# Recursive Dependency

  ## **Avoid recursive relationships:**   
  It's common for data to have recursive relationships. Data may be organized in a
  treelike or hierarchical way. However, creating a foreign key constraint to enforce
  the relationship between two columns in the same table lends to awkward querying.
  Each level of the tree corresponds to another join. You will need to issue recursive
  queries to get all descendants or all ancestors of a node.
  A solution is to construct an additional closure table. It involves storing all paths
  through the tree, not just those with a direct parent-child relationship.
  You might want to compare different hierarchical data designs -- closure table,
  path enumeration, nested sets -- and pick one based on your application's needs.