/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.grape.Grape;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.springframework.boot.cli.compiler.AnnotatedNodeASTTransformation;
import org.springframework.boot.cli.compiler.DependencyManagementBomTransformation;
import org.springframework.boot.cli.compiler.dependencies.DependencyManagement;
import org.springframework.boot.cli.compiler.dependencies.MavenModelDependencyManagement;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionContext;
import org.springframework.boot.groovy.DependencyManagementBom;
import org.springframework.core.annotation.Order;

@Order(value=-2147483548)
public class DependencyManagementBomTransformation
extends AnnotatedNodeASTTransformation {
    public static final int ORDER = -2147483548;
    private static final Set<String> DEPENDENCY_MANAGEMENT_BOM_ANNOTATION_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(DependencyManagementBom.class.getName(), DependencyManagementBom.class.getSimpleName())));
    private final DependencyResolutionContext resolutionContext;

    public DependencyManagementBomTransformation(DependencyResolutionContext resolutionContext) {
        super(DEPENDENCY_MANAGEMENT_BOM_ANNOTATION_NAMES, true);
        this.resolutionContext = resolutionContext;
    }

    protected void processAnnotationNodes(List<AnnotationNode> annotationNodes) {
        if (!annotationNodes.isEmpty()) {
            if (annotationNodes.size() > 1) {
                for (AnnotationNode annotationNode : annotationNodes) {
                    this.handleDuplicateDependencyManagementBomAnnotation(annotationNode);
                }
            } else {
                this.processDependencyManagementBomAnnotation(annotationNodes.get(0));
            }
        }
    }

    private void processDependencyManagementBomAnnotation(AnnotationNode annotationNode) {
        Expression valueExpression = annotationNode.getMember("value");
        List bomDependencies = this.createDependencyMaps(valueExpression);
        this.updateDependencyResolutionContext(bomDependencies);
    }

    private List<Map<String, String>> createDependencyMaps(Expression valueExpression) {
        HashMap<String, String> dependency = null;
        List constantExpressions = this.getConstantExpressions(valueExpression);
        ArrayList<Map<String, String>> dependencies = new ArrayList<Map<String, String>>(constantExpressions.size());
        for (ConstantExpression expression : constantExpressions) {
            Object value = expression.getValue();
            if (!(value instanceof String)) continue;
            String[] components = ((String)expression.getValue()).split(":");
            if (components.length == 3) {
                dependency = new HashMap<String, String>();
                dependency.put("group", components[0]);
                dependency.put("module", components[1]);
                dependency.put("version", components[2]);
                dependency.put("type", "pom");
                dependencies.add(dependency);
                continue;
            }
            this.handleMalformedDependency((Expression)expression);
        }
        return dependencies;
    }

    private List<ConstantExpression> getConstantExpressions(Expression valueExpression) {
        if (valueExpression instanceof ListExpression) {
            return this.getConstantExpressions((ListExpression)valueExpression);
        }
        if (valueExpression instanceof ConstantExpression && ((ConstantExpression)valueExpression).getValue() instanceof String) {
            return Arrays.asList((ConstantExpression)valueExpression);
        }
        this.reportError("@DependencyManagementBom requires an inline constant that is a string or a string array", (ASTNode)valueExpression);
        return Collections.emptyList();
    }

    private List<ConstantExpression> getConstantExpressions(ListExpression valueExpression) {
        ArrayList<ConstantExpression> expressions = new ArrayList<ConstantExpression>();
        for (Expression expression : valueExpression.getExpressions()) {
            if (expression instanceof ConstantExpression && ((ConstantExpression)expression).getValue() instanceof String) {
                expressions.add((ConstantExpression)expression);
                continue;
            }
            this.reportError("Each entry in the array must be an inline string constant", (ASTNode)expression);
        }
        return expressions;
    }

    private void handleMalformedDependency(Expression expression) {
        Message message = this.createSyntaxErrorMessage(String.format("The string must be of the form \"group:module:version\"%n", new Object[0]), (ASTNode)expression);
        this.getSourceUnit().getErrorCollector().addErrorAndContinue(message);
    }

    private void updateDependencyResolutionContext(List<Map<String, String>> bomDependencies) {
        URI[] uris = Grape.getInstance().resolve(null, bomDependencies.toArray(new Map[0]));
        DefaultModelBuilder modelBuilder = new DefaultModelBuilderFactory().newInstance();
        for (URI uri : uris) {
            try {
                DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
                request.setModelResolver((ModelResolver)new GrapeModelResolver(null));
                request.setModelSource((ModelSource)new UrlModelSource(uri.toURL()));
                request.setSystemProperties(System.getProperties());
                Model model = modelBuilder.build((ModelBuildingRequest)request).getEffectiveModel();
                this.resolutionContext.addDependencyManagement((DependencyManagement)new MavenModelDependencyManagement(model));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to build model for '" + uri + "'. Is it a valid Maven bom?", ex);
            }
        }
    }

    private void handleDuplicateDependencyManagementBomAnnotation(AnnotationNode annotationNode) {
        Message message = this.createSyntaxErrorMessage("Duplicate @DependencyManagementBom annotation. It must be declared at most once.", (ASTNode)annotationNode);
        this.getSourceUnit().getErrorCollector().addErrorAndContinue(message);
    }

    private void reportError(String message, ASTNode node) {
        this.getSourceUnit().getErrorCollector().addErrorAndContinue(this.createSyntaxErrorMessage(message, node));
    }

    private Message createSyntaxErrorMessage(String message, ASTNode node) {
        return new SyntaxErrorMessage(new SyntaxException(message, node.getLineNumber(), node.getColumnNumber(), node.getLastLineNumber(), node.getLastColumnNumber()), this.getSourceUnit());
    }
}

