/*
* Copyright 1999-2002 Carnegie Mellon University.
* Portions Copyright 2002 Sun Microsystems, Inc.
* Portions Copyright 2002 Mitsubishi Electric Research Laboratories.
* All Rights Reserved.  Use is subject to license terms.
*
* See the file "license.terms" for information on usage and
* redistribution of this file, and for a DISCLAIMER OF ALL
* WARRANTIES.
*
*/

package edu.cmu.sphinx.research.parallel;

import edu.cmu.sphinx.linguist.flat.SentenceHMMState;


/** Represents a state where states from different feature streams merge. */
public class CombineState extends SentenceHMMState {

    /** Creates a CombineState */
    public CombineState(SentenceHMMState parent, int which) {
        super("C", parent, which);
    }


    /**
     * Retrieves a short label describing the type of this state. Typically, subclasses of SentenceHMMState will
     * implement this method and return a short (5 chars or less) label
     *
     * @return the short label.
     */
    public String getTypeLabel() {
        return "Combine";
    }


    /**
     * Returns the state order for this state type
     *
     * @return the state order
     */
    public int getOrder() {
        return 0;
    }
}


