/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */
namespace Glk {
namespace JACL {

/* THIS FILE CONTAINS ALL THE TEXT OUTPUT INTERNALLY BY THE INTERPRETER.
   THE STRINGS FOR ANY GIVEN LANGUAGE ARE DIVIDED INTO TWO SECTIONS, ONE
   THAT CONTAINS THE TEXT OUTPUT DURING REGULAR PLAY AND ONE THAT CONTAINS
   THE TEXT OUTPUT DURING ERROR CONDITIONS (POSSIBLY BEFORE ANY GIVEN GAME
   HAS FINISHED LOADING.

   TO TRANSLATE A GAME TO LANGUAGE THAT IS NOT CURRENTLY SUPPORTED YOU
   NEED TO TRANSLATE english.library AND verbs.library INTO YOUR CHOSEN
   LANGUAGE.

   THE NATIVE_LANGUAGE CONSTANT BELOW INDICATES WHAT SHOULD BE THE DEFAULT
   LANGUAGE OF THE INTERPRETER WHEN IT IS COMPILED. THE 'GAME MESSAGES'
   BLOCK CONTAINS THE SAME STRINGS AS THE FILE english.library (AND OTHER
   LANGUAGES) AND THESE ARE THE VALUES USED BY THE INTERPRETER IF THOSE
   CONSTANTS ARE NO DEFINED BY ANY GIVEN GAME.

   THE 'SYSTEM MESSAGES' BLOCK CONTAINS ERROR MESSAGES AND OTHER SYSTEM-
   LEVEL MESSAGES THAT ARE MOST COMMONLY SEEN DURING THE DEVELOPMENT OF A
   GAME. THESE MESSAGES CANNOT BE OVERRIDDEN BY ANY SPECIFIC GAME. */


#define ENGLISH     1
#define GERMAN      2
#define FRENCH      3

#define NATIVE_LANGUAGE ENGLISH

#if NATIVE_LANGUAGE==ENGLISH
/* GAME MESSAGES */
#define COMMENT_IGNORED "No transcript running, comment ignored.^"
#define COMMENT_RECORDED "Comment recorded.^"
#define YES_WORD "yes"
#define NO_WORD "no"
#define YES_OR_NO "^Please enter ~yes~ or ~no~: "
#define INVALID_SELECTION "Invalid selection.^"
#define RESTARTING "^Restarting...^"
#define RETURN_GAME "^Returning to game.^"
#define SCRIPTING_ON "Scripting on.^"
#define SCRIPTING_OFF "Scripting off.^"
#define SCRIPTING_ALREADY_OFF "Scripting already off.^"
#define SCRIPTING_ALREADY_ON "Scripting already off.^"
#define CANT_WRITE_SCRIPT "Unable to write to script file.^"
#define ERROR_READING_WALKTHRU "Error reading walkthru file.^"
#define BAD_OOPS "You must follow the ~oops~ command with the word you wish to use instead.^"
#define CANT_CORRECT "I can't correct the last command using ~oops~, sorry.^"
#define SURE_QUIT "Are you sure you want to quit?^"
#define SURE_RESTART "Are you sure you want to restart?^"
#define NOT_CLEVER "It wasn't so clever as to be worth repeating.^"
#define NO_MOVES "But you haven't done anything yet!^"
#define TYPE_NUMBER "^Type a number between %d and %d: "
#define BY "By ~"
#define REFERRING_TO "~, are you referring to:^"
#define WALKTHRU_WORD "walkthru"
#define INFO_WORD "info"
#define RESTART_WORD "restart"
#define AGAIN_WORD "again"
#define SCRIPT_WORD "script"
#define UNSCRIPT_WORD "unscript"
#define QUIT_WORD "quit"
#define UNDO_WORD "undo"
#define OOPS_WORD "oops"
#define FROM_WORD "from"
#define EXCEPT_WORD "except"
#define FOR_WORD "for"
#define BUT_WORD "but"
#define AND_WORD "and"
#define THEN_WORD "then"
#define OF_WORD "of"
#define SHE_WORD "she"
#define HE_WORD "he"
#define THAT_WORD "that"
#define THEM_WORD "them"
#define THOSE_WORD "those"
#define THEY_WORD "they"
#define IT_WORD "it"
#define ITSELF_WORD "itself"
#define HIM_WORD "him"
#define HIMSELF_WORD "himself"
#define HER_WORD "her"
#define HERSELF_WORD "herself"
#define THEMSELVES_WORD "themselves"
#define YOU_WORD "you"
#define YOURSELF_WORD "yourself"
#define ONES_WORD "ones"
#define NO_MULTI_VERB "You can't refer to multiple objects directly after the word ~%s~.^"
#define NO_MULTI_START "You can't refer to multiple objects at the start of a command.^"
#define PERSON_CONCEALING "%s doesn't seem to be carrying any such thing.^"
#define PERSON_POSSESSIVE "%s isn't about to let you take anything of theirs.^"
#define CONTAINER_CLOSED "%s is closed.^"
#define CONTAINER_CLOSED_FEM "%s is closed.^"
#define FROM_NON_CONTAINER "The word ~%s~ must be followed by a container.^"
#define DOUBLE_EXCEPT "You can only use the word ~%s~ once per object reference.^"
#define NONE_HELD "You are not holding anything like that.^"
#define NO_OBJECTS "I don't see what you are referring to.^"
#define NO_FILENAME "Save and restore commands must be followed by a filename.^"
#define MOVE_UNDONE "Previous move undone.^^"
#define NO_UNDO "Nothing to undo.^"
#define CANT_SAVE "Unable to save game state to file.^"
#define CANT_RESTORE "Unable to restore game state from file.^"
#define GAME_SAVED "Game saved.^"
#define INCOMPLETE_SENTENCE "The sentence you typed was incomplete.^"
#define UNKNOWN_OBJECT "You can't see any such thing as ~"
#define UNKNOWN_OBJECT_END "~.^"
#define CANT_USE_WORD "You can't use the word ~"
#define IN_CONTEXT "~ in that context.^"
#define DONT_SEE "You don't see "
#define HERE_WORD " here.^"
#define BAD_SAVED_GAME "Attempt to restore incompatible saved-game file."
#define ARENT "aren't"
#define ISNT "isn't"
#define ARE "are"
#define IS "is"
#define DONT "don't"
#define DOESNT "doesn't"
#define DO "do"
#define DOES "does"
#define SCORE_UP "^[YOUR SCORE JUST WENT UP BY "
#define POINT " POINT]^"
#define POINTS " POINTS]^"
#define STARTING "Starting."
#define NO_IT "You must have referred to an appropriate noun previously to use the word ~"
#define NO_IT_END "~.^"
#define BACK_REFERENCE "You must have referred to a noun previously in the same sentence to use the word ~"
#define BACK_REFERENCE_END "~.^"
#define WHEN_YOU_SAY "When you say ~"
#define MUST_SPECIFY "~, you must specify whether you mean "
#define OR_WORD " or "

/* SYSTEM MESSAGES */
#define READ_ERROR "Error reading game file."
#define OLD_INTERPRETER "Interpreter version is older than game file (v%d), can't continue."
#define BAD_CURSOR "You can only use the ~cursor~ command in the status window.^"
#define INCOMPLETE_GRAMMAR "Incomplete grammar statement."
#define GAME_MODIFIED "Game file modified, reloading.\n"
#define NOT_INTEGER "In function \"%s\", \"%s\" command requires integer parameter."
#define NO_NAME_FUNCTION "In line %d, a function must have at least one name."
#define MAXIMUM_ATTRIBUTES_ERR "In line %d, unable to create attribute \"%s\", maximum number of attributes already defined."
#define BAD_PLAYER "In function \"%s\", attempt to use object pointer \"player\" while it does not point to an object (%d)."
#define BAD_PARENT "In function \"%s\", attempt to use the variable 'here' while the variable 'player' does not have a legal parent."
#define BAD_POINTER "In function \"%s\", attempt to use object pointer \"%s\" that does not point to an object (%d)."
#define ILLEGAL_LABEL "In line %d, reserved word \"%s\" used as label."
#define USED_LABEL_INT "In line %d, \"%s\" is already used as a variable label."
#define USED_LABEL_CINT "In line %d, \"%s\" is already used as an integer constant label."
#define USED_LABEL_STR "In line %d, \"%s\" is already used as a string label."
#define USED_LABEL_CSTR "In line %d, \"%s\" is already used as a string constant label."
#define USED_LABEL_ATT "In line %d, \"%s\" is already used as an attribute label."
#define USED_LABEL_OBJ "In line %d, \"%s\" is already used as an object or location label."
#define NO_OBJECT_ERR "In line %d, property \"%s\" defined before first object or location."
#define BAD_INCLUDE "'#include' directive must be followed by file name enclosed in double quotes."
#define BAD_PARAMETER "Unknown or inappropriate type of container '%s' associated with parameter '%s'."
#define BAD_VALUE "Value '%s' cannot be stored in container '%s'."
#define NO_MEDIA "WebJACL: Media file \"%s\" not found, external media support disabled.\n"
#define MEDIA_REGISTERED "WebJACL: Registered %d media.\n"
#define CLEANING_UP "WebJACL: Cleaning up...\n"
#define NO_GAME "No game file specified, can't continue."
#define NO_PORT "WebJACL: No port number specified (-p <number>), using default port %d.\n"
#define WEBJACL_CONFIGURED "WebJACL server configured on %s:%d\n"
#define NOT_FOUND "Unable to open game file, can't continue."
#define CANT_OPEN "Unable to open processed file \"%s\", can't continue."
#define CANT_RUN "A JACL game must contain at least one object (to represent the player), and at least one location (for the player to start in).^"
#define NO_PLAYER "The object pointer 'player' does not point to an object.^"
#define SELF_REFERENCE "In function \"%s\", reference to object \"%s\" whose parent is itself."
#define EXECUTING "Executing function \"%s\".\n"
#define NO_WHILE "In function \"%s\", 'endwhile' command without matching 'while' command."
#define NO_ITERATE "In function \"%s\", 'enditerate' command without matching 'iterate' command."
#define NO_UPDATE "In function \"%s\", 'endupdate' command without matching 'update' command."
#define NO_REPEAT "In function \"%s\", 'until' command without matching 'repeat' command."
#define NO_LOOP "In function \"%s\", 'endloop' command without matching 'loop' command."
#define UNDEFINED_FUNCTION "In function \"%s\", attempt to execute undefined function \"%s\"."
#define DIVIDE_BY_ZERO "In function \"%s\", division by zero error."
#define ILLEGAL_OPERATOR "In function \"%s\", illegal operator \"%s\"."
#define UNKNOWN_COMMAND "In function \"%s\", unknown command \"%s\"."
#define STACK_OVERFLOW "Stack overflow."
#define ILLEGAL_OPERATOR "In function \"%s\", illegal operator \"%s\"."
#define OUT_OF_RANGE "In function \"%s\", element \"%s\" out of range (%d)."
#define GLOBAL_SELF "Reference to 'self' from global function \"%s\"."
#define NON_GLOBAL_FIRST "In line %d, non-global function before object or location."
#define MAXIMUM_EXCEEDED "Maximum number of objects exceeded, can't continue."
#define ERROR_DETECTED "1 error detected."
#define ERRORS_DETECTED "%d errors detected."
#define UNKOWN_OBJECT_RUN "In function \"%s\",  reference to unknown object \"%s\"."
#define UNKNOWN_FUNCTION_RUN "Attempt to execute unknown function \"%s\"."
#define UNKNOWN_KEYWORD_ERR "In line %d, unknown keyword \"%s\"."
#define UNKNOWN_ATTRIBUTE_ERR "In line %d, unknown attribute \"%s\"."
#define UNKNOWN_VALUE_ERR "In line %d, unable to resolve value \"%s\"."
#define UNKNOWN_ATTRIBUTE_RUN "In function \"%s\",  reference to unknown attribute \"%s\"."
#define INSUFFICIENT_PARAMETERS_RUN "In function \"%s\", \"%s\" command with insufficient parameters."
#define INSUFFICIENT_PARAMETERS_ERR "In line %d, \"%s\" keyword with insufficient parameters."
#define UNDEFINED_ITEM_ERR "In line %d, reference to undefined item \"%s\"."
#define UNDEFINED_ITEM_RUN "In function \"%s\", reference to undefined object \"%s\"."
#define UNDEFINED_DIRECTION_RUN "In function \"%s\", reference to undefined direction \"%s\"."
#define UNKNOWN_SCOPE_RUN "In function \"%s\", reference to unknown scope \"%s\"."
#define UNDEFINED_STRING_RUN "In function \"%s\", reference to undefined string \"%s\"."
#define UNDEFINED_CONTAINER_RUN "In function \"%s\", reference to undefined container \"%s\"."
#define OUT_OF_MEMORY "Out of memory, can't continue."
#define CANT_OPEN_PROCESSED "Unable to open output file \"%s\" for writing, can't continue."
#define CANT_OPEN_OR "Unable to open source file \"%s\" or \"%s\", can't continue."
#define CANT_OPEN_SOURCE "Unable to open source file \"%s\", can't continue."
#endif

#if NATIVE_LANGUAGE==FRENCH
/* GAME MESSAGES */
#define COMMENT_IGNORED "Pas de transcription en cours, commentaire ignor.^"
#define COMMENT_RECORDED "Commentaire enregistr.^"
#define YES_WORD "oui"
#define NO_WORD "no"
#define YES_OR_NO "^Merci d'entrer ~oui~ ou ~non~: "
#define INVALID_SELECTION "Slection invalide.^"
#define RESTARTING "^En train de recommencer...^"
#define RETURN_GAME "^Retour au jeu.^"
#define SCRIPTING_ON "Dbut de transcription.^"
#define SCRIPTING_OFF "Fin de transcription.^"
#define SCRIPTING_ALREADY_OFF "Transcription dj termine.^"
#define SCRIPTING_ALREADY_ON "Transcription dj en cours.^"
#define CANT_WRITE_SCRIPT "Impossible d'crire le fichier de transcription.^"
#define ERROR_READING_WALKTHRU "Erreur lors de la lecture du fichier de solution.^"
#define BAD_OOPS "Vous devez faire suivre la commande ~oops~ par le mot que vous souhaitez remplacer.^"
#define CANT_CORRECT "Dsol, je ne peux corriger la dernire commande en utilisant ~oops~.^"
#define SURE_QUIT "tes-vous certain de vouloir quitter ?^"
#define SURE_RESTART "tes-vous certain de vouloir recommencer ?^"
#define NOT_CLEVER "Ce n'tait pas si intelligent au point de vouloir rpter cela.^"
#define NO_MOVES "Mais vous n'avez rien fait pour le moment !^"
#define TYPE_NUMBER "^Entrez un nombre entre %d et %d: "
#define BY "By ~"
#define REFERRING_TO "Faites-vous rfrence  :^"
#define WALKTHRU_WORD "solution"
#define INFO_WORD "info"
#define RESTART_WORD "recommencer"
#define AGAIN_WORD "encore"
#define SCRIPT_WORD "script"
#define UNSCRIPT_WORD "unscript"
#define QUIT_WORD "quitter"
#define UNDO_WORD "annuler"
#define OOPS_WORD "oops"
#define FROM_WORD "depuis"
#define EXCEPT_WORD "except"
#define FOR_WORD "pour"
#define BUT_WORD "mais"
#define AND_WORD "et"
#define THEN_WORD "puis"
#define OF_WORD "de"
#define SHE_WORD "elle"
#define HE_WORD "il"
#define THAT_WORD "ce"
#define THEM_WORD "ces"
#define THOSE_WORD "ceux"
#define THEY_WORD "ils"
#define IT_WORD "il"
#define ITSELF_WORD "lui-mme"
#define HIM_WORD "him"
#define HIMSELF_WORD "lui-mme"
#define HER_WORD "her"
#define HERSELF_WORD "elle-mme"
#define THEMSELVES_WORD "eux-mme"
#define YOU_WORD "you"
#define YOURSELF_WORD "yourself"
#define ONES_WORD "ceux"
#define NO_MULTI_VERB "Vous ne pouvez vous rfrer  de multiples objets aprs le mot  \"%s\".^"
#define NO_MULTI_START "Vous ne pouvez vous rfrer  de multiples objets au dbut d'une commande.^"
#define PERSON_CONCEALING "%s ne semble par porter cela.^"
#define PERSON_POSSESSIVE "%s ne vous laissera pas lui prendre ses affaires.^"
#define CONTAINER_CLOSED "%s est ferm.^"
#define CONTAINER_CLOSED_FEM "%s est ferm.^"
#define FROM_NON_CONTAINER "Le mot \"%s\" doit tre suivi par un contenant.^"
#define DOUBLE_EXCEPT "Vous ne pouvez utiliser le mot \"%s\" qu'une fois par rfrence d'objet.^"
#define NONE_HELD "Vous ne portez rien de cela.^"
#define NO_OBJECTS "Je ne comprends pas ce  quoi vous vous rferez.^"
#define NO_FILENAME "Les commandes de sauvegarde et lecture doivent tre suivies par un nom de fichier.^"
#define MOVE_UNDONE "Le tour prcdent a t annul.^^"
#define NO_UNDO "Il n'y a rien  annuler.^"
#define CANT_SAVE "Impossible de sauvegarder l'tat du jeu sur fichier.^"
#define CANT_RESTORE "Impossible de rcuprer l'tat du jeu depuis le fichier.^"
#define GAME_SAVED "Jeu sauvegard.^"
#define INCOMPLETE_SENTENCE "La phrase que vous avez tape n'est pas complte.^"
#define UNKNOWN_OBJECT "Vous ne pouvez voir ~"
#define UNKNOWN_OBJECT_END "~.^"
#define CANT_USE_WORD "Vous ne pouvez utiliser le mot ~"
#define IN_CONTEXT "~ dans ce contexte.^"
#define DONT_SEE "Vous ne voyez pas "
#define HERE_WORD " ici.^"
#define BAD_SAVED_GAME "Ficher de sauvegarde incompatible."
#define ARENT "ne sont pas"
#define ISNT "n'est pas"
#define ARE "sont"
#define IS "est"
#define DONT "ne font pas"
#define DOESNT "ne fait pas"
#define DO "font"
#define DOES "fait"
#define SCORE_UP "^[VOTRE SCORE VIENT D'AUGMENTER DE "
#define POINT " POINT]^"
#define POINTS " POINTS]^"
#define STARTING "Dmarrage."
#define NO_IT "Vous devez pralablement avoir fait rfrence  un nom reconnu pour pouvoir utiliser le mot ~"
#define NO_IT_END "~.^"
#define BACK_REFERENCE "Vous devez pralablement avoir fait rfrence  un nom reconnu dans la mme phrase pour pouvoir utiliser le mot ~"
#define BACK_REFERENCE_END "~.^"
#define WHEN_YOU_SAY "When you say ~"
#define MUST_SPECIFY "~, vous devez spcifier si vous voulez dire "
#define OR_WORD " ou "

/* SYSTEM MESSAGES */
#define READ_ERROR "Erreur de lecture du fichier de jeu."
#define OLD_INTERPRETER "La version de l'interprteur est plus ancienne que le fichier de jeu (v%d), impossible de continuer."
#define BAD_CURSOR "You can only use the ~cursor~ command in the status window.^"
#define INCOMPLETE_GRAMMAR "Incomplete grammar statement."
#define GAME_MODIFIED "Game file modified, reloading.\n"
#define NOT_INTEGER "In function \"%s\", \"%s\" command requires integer parameter."
#define NO_NAME_FUNCTION "In line %d, a function must have at least one name."
#define MAXIMUM_ATTRIBUTES_ERR "In line %d, unable to create attribute \"%s\", maximum number of attributes already defined."
#define BAD_PLAYER "In function \"%s\", attempt to use object pointer \"player\" while it does not point to an object (%d)."
#define BAD_PARENT "In function \"%s\", attempt to use the variable 'here' while the variable 'player' does not have a legal parent."
#define BAD_POINTER "In function \"%s\", attempt to use object pointer \"%s\" that does not point to an object (%d)."
#define ILLEGAL_LABEL "In line %d, reserved word \"%s\" used as label."
#define USED_LABEL_INT "In line %d, \"%s\" is already used as a variable label."
#define USED_LABEL_CINT "In line %d, \"%s\" is already used as an integer constant label."
#define USED_LABEL_STR "In line %d, \"%s\" is already used as a string label."
#define USED_LABEL_CSTR "In line %d, \"%s\" is already used as a string constant label."
#define USED_LABEL_ATT "In line %d, \"%s\" is already used as an attribute label."
#define USED_LABEL_OBJ "In line %d, \"%s\" is already used as an object or location label."
#define NO_OBJECT_ERR "In line %d, property \"%s\" defined before first object or location."
#define BAD_INCLUDE "'#include' directive must be followed by file name enclosed in double quotes."
#define BAD_PARAMETER "Unknown or inappropriate type of container '%s' associated with parameter '%s'."
#define BAD_VALUE "Value '%s' cannot be stored in container '%s'."
#define NO_MEDIA "WebJACL: Media file \"%s\" not found, external media support disabled.\n"
#define MEDIA_REGISTERED "WebJACL: Registered %d media.\n"
#define CLEANING_UP "WebJACL: Cleaning up...\n"
#define NO_GAME "No game file specified, can't continue."
#define NO_PORT "WebJACL: No port number specified (-p <number>), using default port %d.\n"
#define WEBJACL_CONFIGURED "WebJACL server configured on %s:%d\n"
#define NOT_FOUND "Unable to open game file, can't continue."
#define CANT_OPEN "Unable to open processed file \"%s\", can't continue."
#define CANT_RUN "A JACL game must contain at least one object (to represent the player), and at least one location (for the player to start in).^"
#define NO_PLAYER "The object pointer 'player' does not point to an object.^"
#define SELF_REFERENCE "In function \"%s\", reference to object \"%s\" whose parent is itself."
#define EXECUTING "Executing function \"%s\".\n"
#define NO_WHILE "In function \"%s\", 'endwhile' command without matching 'while' command."
#define NO_ITERATE "In function \"%s\", 'enditerate' command without matching 'iterate' command."
#define NO_UPDATE "In function \"%s\", 'endupdate' command without matching 'update' command."
#define NO_REPEAT "In function \"%s\", 'until' command without matching 'repeat' command."
#define NO_LOOP "In function \"%s\", 'endloop' command without matching 'loop' command."
#define UNDEFINED_FUNCTION "In function \"%s\", attempt to execute undefined function \"%s\"."
#define DIVIDE_BY_ZERO "In function \"%s\", division by zero error."
#define ILLEGAL_OPERATOR "In function \"%s\", illegal operator \"%s\"."
#define UNKNOWN_COMMAND "In function \"%s\", unknown command \"%s\"."
#define STACK_OVERFLOW "Stack overflow."
#define ILLEGAL_OPERATOR "In function \"%s\", illegal operator \"%s\"."
#define OUT_OF_RANGE "In function \"%s\", element \"%s\" out of range (%d)."
#define GLOBAL_SELF "Reference to 'self' from global function \"%s\"."
#define NON_GLOBAL_FIRST "In line %d, non-global function before object or location."
#define MAXIMUM_EXCEEDED "Maximum number of objects exceeded, can't continue."
#define ERROR_DETECTED "1 error detected."
#define ERRORS_DETECTED "%d errors detected."
#define UNKOWN_OBJECT_RUN "In function \"%s\",  reference to unknown object \"%s\"."
#define UNKNOWN_FUNCTION_RUN "Attempt to execute unknown function \"%s\"."
#define UNKNOWN_KEYWORD_ERR "In line %d, unknown keyword \"%s\"."
#define UNKNOWN_ATTRIBUTE_ERR "In line %d, unknown attribute \"%s\"."
#define UNKNOWN_VALUE_ERR "In line %d, unable to resolve value \"%s\"."
#define UNKNOWN_ATTRIBUTE_RUN "In function \"%s\",  reference to unknown attribute \"%s\"."
#define INSUFFICIENT_PARAMETERS_RUN "In function \"%s\", \"%s\" command with insufficient parameters."
#define INSUFFICIENT_PARAMETERS_ERR "In line %d, \"%s\" keyword with insufficient parameters."
#define UNDEFINED_ITEM_ERR "In line %d, reference to undefined item \"%s\"."
#define UNDEFINED_ITEM_RUN "In function \"%s\", reference to undefined object \"%s\"."
#define UNDEFINED_DIRECTION_RUN "In function \"%s\", reference to undefined direction \"%s\"."
#define UNKNOWN_SCOPE_RUN "In function \"%s\", reference to unknown scope \"%s\"."
#define UNDEFINED_STRING_RUN "In function \"%s\", reference to undefined string \"%s\"."
#define UNDEFINED_CONTAINER_RUN "In function \"%s\", reference to undefined container \"%s\"."
#define OUT_OF_MEMORY "Out of memory, can't continue."
#define CANT_OPEN_PROCESSED "Unable to open output file \"%s\" for writing, can't continue."
#define CANT_OPEN_OR "Unable to open source file \"%s\" or \"%s\", can't continue."
#define CANT_OPEN_SOURCE "Unable to open source file \"%s\", can't continue."
#endif

#if NATIVE_LANGUAGE==GERMAN
/* GAME MESSAGES */
#define COMMENT_IGNORED "No transcript running, comment ignored.^"
#define COMMENT_RECORDED "Comment recorded.^"
#define YES_WORD "yes"
#define NO_WORD "no"
#define YES_OR_NO "^Please enter ~yes~ or ~no~: "
#define YES_WORD "yes"
#define NO_WORD "no"
#define INVALID_SELECTION "Invalid selection.^"
#define RESTARTING "^Restarting...^"
#define RETURN_GAME "^Returning to game.^"
#define SCRIPTING_ON "Scripting on.^"
#define SCRIPTING_OFF "Scripting off.^"
#define SCRIPTING_ALREADY_OFF "Scripting already off.^"
#define SCRIPTING_ALREADY_ON "Scripting already off.^"
#define CANT_WRITE_SCRIPT "Unable to write to script file.^"
#define ERROR_READING_WALKTHRU "Error reading walkthru file.^"
#define BAD_OOPS "You must follow the ~oops~ command with the word you wish to use instead.^"
#define CANT_CORRECT "I can't correct the last command using ~oops~, sorry.^"
#define SURE_QUIT "Are you sure you want to quit?^"
#define SURE_RESTART "Are you sure you want to restart?^"
#define NOT_CLEVER "It wasn't so clever as to be worth repeating.^"
#define NO_MOVES "But you haven't done anything yet!^"
#define TYPE_NUMBER "^Type a number between %d and %d: "
#define BY "By ~"
#define REFERRING_TO "~, are you referring to:^"
#define WALKTHRU_WORD "walkthru"
#define INFO_WORD "info"
#define RESTART_WORD "restart"
#define AGAIN_WORD "again"
#define SCRIPT_WORD "script"
#define UNSCRIPT_WORD "unscript"
#define QUIT_WORD "quit"
#define UNDO_WORD "undo"
#define OOPS_WORD "oops"
#define FROM_WORD "from"
#define EXCEPT_WORD "except"
#define FOR_WORD "for"
#define BUT_WORD "but"
#define AND_WORD "and"
#define THEN_WORD "then"
#define OF_WORD "of"
#define SHE_WORD "she"
#define HE_WORD "he"
#define THAT_WORD "that"
#define THEM_WORD "them"
#define THOSE_WORD "those"
#define THEY_WORD "they"
#define IT_WORD "it"
#define ITSELF_WORD "itself"
#define HIM_WORD "him"
#define HIMSELF_WORD "himself"
#define HER_WORD "her"
#define HERSELF_WORD "herself"
#define THEMSELVES_WORD "themselves"
#define YOU_WORD "you"
#define YOURSELF_WORD "yourself"
#define ONES_WORD "ones"
#define NO_MULTI_VERB "You can't refer to multiple objects directly after the word ~%s~.^"
#define NO_MULTI_START "You can't refer to multiple objects at the start of a command.^"
#define PERSON_CONCEALING "%s doesn't seem to be carrying any such thing.^"
#define PERSON_POSSESSIVE "%s isn't about to let you take anything of theirs.^"
#define CONTAINER_CLOSED "%s is closed.^"
#define CONTAINER_CLOSED_FEM "%s is closed.^"
#define FROM_NON_CONTAINER "The word ~%s~ must be followed by a container.^"
#define DOUBLE_EXCEPT "You can only use the word ~%s~ once per object reference.^"
#define NONE_HELD "You are not holding anything like that.^"
#define NO_OBJECTS "I don't see what you are referring to.^"
#define NO_FILENAME "Save and restore commands must be followed by a filename.^"
#define MOVE_UNDONE "Previous move undone.^^"
#define NO_UNDO "Nothing to undo.^"
#define CANT_SAVE "Unable to save game state to file.^"
#define CANT_RESTORE "Unable to restore game state from file.^"
#define GAME_SAVED "Game saved.^"
#define INCOMPLETE_SENTENCE "The sentence you typed was incomplete.^"
#define UNKNOWN_OBJECT "You can't see any such thing as ~"
#define UNKNOWN_OBJECT_END "~.^"
#define CANT_USE_WORD "You can't use the word ~"
#define IN_CONTEXT "~ in that context.^"
#define DONT_SEE "You don't see "
#define HERE_WORD " here.^"
#define BAD_SAVED_GAME "Attempt to restore incompatible saved-game file."
#define ARENT "aren't"
#define ISNT "isn't"
#define ARE "are"
#define IS "is"
#define DONT "don't"
#define DOESNT "doesn't"
#define DO "do"
#define DOES "does"
#define SCORE_UP "^[YOUR SCORE JUST WENT UP BY "
#define POINT " POINT]^"
#define POINTS " POINTS]^"
#define STARTING "Starting."
#define NO_IT "You must have referred to an appropriate noun previously to use the word ~"
#define NO_IT_END "~.^"
#define BACK_REFERENCE "You must have referred to a noun previously in the same sentence to use the word ~"
#define BACK_REFERENCE_END "~.^"
#define WHEN_YOU_SAY "When you say ~"
#define MUST_SPECIFY "~, you must specify whether you mean "
#define OR_WORD " or "

/* SYSTEM MESSAGES */
#define READ_ERROR "Error reading game file."
#define OLD_INTERPRETER "Interpreter version is older than game file (v%d), can't continue."
#define BAD_CURSOR "You can only use the ~cursor~ command in the status window.^"
#define INCOMPLETE_GRAMMAR "Incomplete grammar statement."
#define GAME_MODIFIED "Game file modified, reloading.\n"
#define NOT_INTEGER "In function \"%s\", \"%s\" command requires integer parameter."
#define NO_NAME_FUNCTION "In line %d, a function must have at least one name."
#define MAXIMUM_ATTRIBUTES_ERR "In line %d, unable to create attribute \"%s\", maximum number of attributes already defined."
#define BAD_PLAYER "In function \"%s\", attempt to use object pointer \"player\" while it does not point to an object (%d)."
#define BAD_PARENT "In function \"%s\", attempt to use the variable 'here' while the variable 'player' does not have a legal parent."
#define BAD_POINTER "In function \"%s\", attempt to use object pointer \"%s\" that does not point to an object (%d)."
#define ILLEGAL_LABEL "In line %d, reserved word \"%s\" used as label."
#define USED_LABEL_INT "In line %d, \"%s\" is already used as a variable label."
#define USED_LABEL_CINT "In line %d, \"%s\" is already used as an integer constant label."
#define USED_LABEL_STR "In line %d, \"%s\" is already used as a string label."
#define USED_LABEL_CSTR "In line %d, \"%s\" is already used as a string constant label."
#define USED_LABEL_ATT "In line %d, \"%s\" is already used as an attribute label."
#define USED_LABEL_OBJ "In line %d, \"%s\" is already used as an object or location label."
#define NO_OBJECT_ERR "In line %d, property \"%s\" defined before first object or location."
#define BAD_INCLUDE "'#include' directive must be followed by file name enclosed in double quotes."
#define BAD_PARAMETER "Unknown or inappropriate type of container '%s' associated with parameter '%s'."
#define BAD_VALUE "Value '%s' cannot be stored in container '%s'."
#define NO_MEDIA "WebJACL: Media file \"%s\" not found, external media support disabled.\n"
#define MEDIA_REGISTERED "WebJACL: Registered %d media.\n"
#define CLEANING_UP "WebJACL: Cleaning up...\n"
#define NO_GAME "No game file specified, can't continue."
#define NO_PORT "WebJACL: No port number specified (-p <number>), using default port %d.\n"
#define WEBJACL_CONFIGURED "WebJACL server configured on %s:%d\n"
#define NOT_FOUND "Unable to open game file, can't continue."
#define CANT_OPEN "Unable to open processed file \"%s\", can't continue."
#define CANT_RUN "A JACL game must contain at least one object (to represent the player), and at least one location (for the player to start in).^"
#define NO_PLAYER "The object pointer 'player' does not point to an object.^"
#define SELF_REFERENCE "In function \"%s\", reference to object \"%s\" whose parent is itself."
#define EXECUTING "Executing function \"%s\".\n"
#define NO_WHILE "In function \"%s\", 'endwhile' command without matching 'while' command."
#define NO_ITERATE "In function \"%s\", 'enditerate' command without matching 'iterate' command."
#define NO_UPDATE "In function \"%s\", 'endupdate' command without matching 'update' command."
#define NO_REPEAT "In function \"%s\", 'until' command without matching 'repeat' command."
#define NO_LOOP "In function \"%s\", 'endloop' command without matching 'loop' command."
#define UNDEFINED_FUNCTION "In function \"%s\", attempt to execute undefined function \"%s\"."
#define DIVIDE_BY_ZERO "In function \"%s\", division by zero error."
#define ILLEGAL_OPERATOR "In function \"%s\", illegal operator \"%s\"."
#define UNKNOWN_COMMAND "In function \"%s\", unknown command \"%s\"."
#define STACK_OVERFLOW "Stack overflow."
#define ILLEGAL_OPERATOR "In function \"%s\", illegal operator \"%s\"."
#define OUT_OF_RANGE "In function \"%s\", element \"%s\" out of range (%d)."
#define GLOBAL_SELF "Reference to 'self' from global function \"%s\"."
#define NON_GLOBAL_FIRST "In line %d, non-global function before object or location."
#define MAXIMUM_EXCEEDED "Maximum number of objects exceeded, can't continue."
#define ERROR_DETECTED "1 error detected."
#define ERRORS_DETECTED "%d errors detected."
#define UNKOWN_OBJECT_RUN "In function \"%s\",  reference to unknown object \"%s\"."
#define UNKNOWN_FUNCTION_RUN "Attempt to execute unknown function \"%s\"."
#define UNKNOWN_KEYWORD_ERR "In line %d, unknown keyword \"%s\"."
#define UNKNOWN_ATTRIBUTE_ERR "In line %d, unknown attribute \"%s\"."
#define UNKNOWN_VALUE_ERR "In line %d, unable to resolve value \"%s\"."
#define UNKNOWN_ATTRIBUTE_RUN "In function \"%s\",  reference to unknown attribute \"%s\"."
#define INSUFFICIENT_PARAMETERS_RUN "In function \"%s\", \"%s\" command with insufficient parameters."
#define INSUFFICIENT_PARAMETERS_ERR "In line %d, \"%s\" keyword with insufficient parameters."
#define UNDEFINED_ITEM_ERR "In line %d, reference to undefined item \"%s\"."
#define UNDEFINED_ITEM_RUN "In function \"%s\", reference to undefined object \"%s\"."
#define UNDEFINED_DIRECTION_RUN "In function \"%s\", reference to undefined direction \"%s\"."
#define UNKNOWN_SCOPE_RUN "In function \"%s\", reference to unknown scope \"%s\"."
#define UNDEFINED_STRING_RUN "In function \"%s\", reference to undefined string \"%s\"."
#define UNDEFINED_CONTAINER_RUN "In function \"%s\", reference to undefined container \"%s\"."
#define OUT_OF_MEMORY "Out of memory, can't continue."
#define CANT_OPEN_PROCESSED "Unable to open output file \"%s\" for writing, can't continue."
#define CANT_OPEN_OR "Unable to open source file \"%s\" or \"%s\", can't continue."
#define CANT_OPEN_SOURCE "Unable to open source file \"%s\", can't continue."
#endif

} // End of namespace JACL
} // End of namespace Glk
