/*
 * Decompiled with CFR 0.152.
 */
package akka.io;

import akka.io.BufferPool;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A3Q!\u0001\u0002\u0001\t\u0019\u0011A\u0003R5sK\u000e$()\u001f;f\u0005V4g-\u001a:Q_>d'BA\u0002\u0005\u0003\tIwNC\u0001\u0006\u0003\u0011\t7n[1\u0014\u0007\u00019Q\u0002\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u0011!BQ;gM\u0016\u0014\bk\\8m\u0011!\u0011\u0002A!A!\u0002\u0013!\u0012!\u00053fM\u0006,H\u000e\u001e\"vM\u001a,'oU5{K\u000e\u0001\u0001C\u0001\u0005\u0016\u0013\t1\u0012BA\u0002J]RD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u000f[\u0006D\bk\\8m\u000b:$(/[3t\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0019A$\b\u0010\u0011\u00059\u0001\u0001\"\u0002\n\u001a\u0001\u0004!\u0002\"\u0002\r\u001a\u0001\u0004!\u0002B\u0002\u0011\u0001A\u0003%\u0011%\u0001\u0003m_\u000e\\\u0007C\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0015awnY6t\u0015\t1s%\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001K\u0015\u0002\tU$\u0018\u000e\u001c\u0006\u0002U\u0005!!.\u0019<b\u0013\ta3EA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\u0007]\u0001\u0001\u000b\u0011B\u0018\u0002\tA|w\u000e\u001c\t\u0004\u0011A\u0012\u0014BA\u0019\n\u0005\u0015\t%O]1z!\t\u0019d'D\u00015\u0015\t)\u0014&A\u0002oS>L!a\u000e\u001b\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000f\u0003\u0004:\u0001\u0001\u0006K\u0001F\u0001\u000eEV4g-\u001a:t\u0013:\u0004vn\u001c7\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u000f\u0005\u001c\u0017/^5sKR\t!\u0007C\u0003?\u0001\u0011\u0005q(A\u0004sK2,\u0017m]3\u0015\u0005\u0001\u001b\u0005C\u0001\u0005B\u0013\t\u0011\u0015B\u0001\u0003V]&$\b\"\u0002#>\u0001\u0004\u0011\u0014a\u00012vM\")a\t\u0001C\u0005\u000f\u0006A\u0011\r\u001c7pG\u0006$X\r\u0006\u00023\u0011\")\u0011*\u0012a\u0001)\u0005!1/\u001b>f\u0011\u0015Y\u0005\u0001\"\u0004=\u0003I!\u0018m[3Ck\u001a4WM\u001d$s_6\u0004vn\u001c7\t\u000b5\u0003AQ\u0002(\u0002#=4g-\u001a:Ck\u001a4WM\u001d+p!>|G\u000e\u0006\u0002A\u001f\")A\t\u0014a\u0001e\u0001")
public class DirectByteBufferPool
implements BufferPool {
    private final int defaultBufferSize;
    private final int maxPoolEntries;
    private final ReentrantLock lock;
    private final ByteBuffer[] pool;
    private int buffersInPool;

    @Override
    public ByteBuffer acquire() {
        return this.takeBufferFromPool();
    }

    @Override
    public void release(ByteBuffer buf) {
        this.offerBufferToPool(buf);
    }

    private ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    private final ByteBuffer takeBufferFromPool() {
        ByteBuffer byteBuffer;
        ByteBuffer buffer;
        block6: {
            buffer = null;
            if (this.lock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                if (this.buffersInPool <= 0) break block6;
                --this.buffersInPool;
                buffer = this.pool[this.buffersInPool];
            }
        }
        if (buffer == null) {
            byteBuffer = this.allocate(this.defaultBufferSize);
        } else {
            buffer.clear();
            byteBuffer = buffer;
        }
        return byteBuffer;
        finally {
            this.lock.unlock();
        }
    }

    private final void offerBufferToPool(ByteBuffer buf) {
        block4: {
            if (this.lock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                if (this.buffersInPool >= this.maxPoolEntries) break block4;
                this.pool[this.buffersInPool] = buf;
                ++this.buffersInPool;
            }
        }
        return;
        finally {
            this.lock.unlock();
        }
    }

    public DirectByteBufferPool(int defaultBufferSize, int maxPoolEntries) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxPoolEntries = maxPoolEntries;
        this.lock = new ReentrantLock();
        this.pool = new ByteBuffer[maxPoolEntries];
        this.buffersInPool = 0;
    }
}

