/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.renderers;

import dotty.tools.scaladoc.DRI;
import dotty.tools.scaladoc.DocContext;
import dotty.tools.scaladoc.DocContext$package$;
import dotty.tools.scaladoc.Link$;
import dotty.tools.scaladoc.PageContent;
import dotty.tools.scaladoc.PageContent$;
import dotty.tools.scaladoc.TocEntry;
import dotty.tools.scaladoc.TocEntry$;
import dotty.tools.scaladoc.renderers.Locations;
import dotty.tools.scaladoc.renderers.Page;
import dotty.tools.scaladoc.renderers.Page$;
import dotty.tools.scaladoc.renderers.ResolvedTemplate;
import dotty.tools.scaladoc.renderers.ResolvedTemplate$;
import dotty.tools.scaladoc.site.LoadedTemplate;
import dotty.tools.scaladoc.site.StaticSiteContext;
import dotty.tools.scaladoc.util.HTML$;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.matching.Regex;

public interface SiteRenderer
extends Locations {
    public static void $init$(SiteRenderer $this) {
        $this.dotty$tools$scaladoc$renderers$SiteRenderer$_setter_$dotty$tools$scaladoc$renderers$SiteRenderer$$HashRegex_$eq(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("([^#]+)(#.+)")));
    }

    public DocContext dotty$tools$scaladoc$renderers$SiteRenderer$$x$1();

    public static Page templateToPage$(SiteRenderer $this, LoadedTemplate t, StaticSiteContext staticSiteCtx) {
        return $this.templateToPage(t, staticSiteCtx);
    }

    default public Page templateToPage(LoadedTemplate t, StaticSiteContext staticSiteCtx) {
        DRI dri = staticSiteCtx.driFor(t.file().toPath());
        ResolvedTemplate content = ResolvedTemplate$.MODULE$.apply(t, staticSiteCtx);
        return Page$.MODULE$.apply(Link$.MODULE$.apply(t.templateFile().title().name(), dri), content, (Seq<Page>)t.children().map((Function1 & Serializable)_$1 -> this.templateToPage((LoadedTemplate)_$1, staticSiteCtx)), t.hidden());
    }

    public Regex dotty$tools$scaladoc$renderers$SiteRenderer$$HashRegex();

    public void dotty$tools$scaladoc$renderers$SiteRenderer$_setter_$dotty$tools$scaladoc$renderers$SiteRenderer$$HashRegex_$eq(Regex var1);

    public static PageContent siteContent$(SiteRenderer $this, DRI pageDri, ResolvedTemplate content) {
        return $this.siteContent(pageDri, content);
    }

    default public PageContent siteContent(DRI pageDri, ResolvedTemplate content) {
        Document document = Jsoup.parse((String)content.resolved().code());
        Seq toc = (Seq)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)document.select("section[id]")).asScala().toSeq().flatMap((Function1 & Serializable)elem -> {
            Element header = elem.selectFirst("h1, h2, h3, h4, h5, h6");
            return Option$.MODULE$.apply((Object)header).map((Function1 & Serializable)h -> TocEntry$.MODULE$.apply(h.tag().getName(), h.text(), new StringBuilder(1).append("#").append(elem.id()).toString()));
        });
        document.select("header + p").forEach(firstParagraph -> {
            firstParagraph.addClass("body-large");
            firstParagraph.addClass("first-p");
        });
        document.select("a").forEach(element -> element.attr("href", this.processLocalLinkWithGuard$1(content, pageDri, element.attr("href"))));
        document.select("img").forEach(element -> element.attr("src", this.processLocalLink$1(content, pageDri, element.attr("src"))));
        return PageContent$.MODULE$.apply(HTML$.MODULE$.div().apply((Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{HTML$.MODULE$.raw(document.outerHtml())})), (Seq<TocEntry>)toc);
    }

    private Option tryAsDriPlain$1(ResolvedTemplate content$1, DRI pageDri$1, String str) {
        Tuple2 tuple2;
        List list;
        Option option;
        String string = str;
        if (string != null && !(option = this.dotty$tools$scaladoc$renderers$SiteRenderer$$HashRegex().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String path = string2;
            String prefix = string3;
            tuple2 = Tuple2$.MODULE$.apply((Object)path, (Object)prefix);
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)str, (Object)"");
        }
        Tuple2 tuple22 = tuple2;
        String path = (String)tuple22._1();
        String prefix = (String)tuple22._2();
        Seq res = (Seq)content$1.ctx().driForLink(content$1.template().file(), path).filter((Function1 & Serializable)dri -> this.driExists((DRI)dri));
        return res.headOption().map((Function1 & Serializable)_$2 -> new StringBuilder(0).append(this.pathToPage(pageDri$1, (DRI)_$2)).append(prefix).toString());
    }

    private static /* synthetic */ boolean $anonfun$2(char c) {
        return c == '.' || c == '/';
    }

    private Option tryAsDri$1(ResolvedTemplate content$2, DRI pageDri$3, String str) {
        Tuple2 tuple2;
        List list;
        Option option;
        String str2;
        String string = StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)c -> SiteRenderer.$anonfun$2(BoxesRunTime.unboxToChar((Object)c))).replaceAll("/", ".");
        String str3 = string;
        String newStr = str3.endsWith("$.html") ? StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(str3), "$.html") : ((str2 = string).endsWith(".html") ? StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(str2), ".html") : str);
        String string2 = newStr;
        if (string2 != null && !(option = this.dotty$tools$scaladoc$renderers$SiteRenderer$$HashRegex().unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
            String string3 = (String)list.apply(0);
            String string4 = (String)list.apply(1);
            String path = string3;
            String prefix = string4;
            tuple2 = Tuple2$.MODULE$.apply((Object)path, (Object)prefix);
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)newStr, (Object)"");
        }
        Tuple2 tuple22 = tuple2;
        String path = (String)tuple22._1();
        String prefix = (String)tuple22._2();
        Seq res = (Seq)content$2.ctx().driForLink(content$2.template().file(), path).filter((Function1 & Serializable)dri -> this.driExists((DRI)dri));
        return res.headOption().map((Function1 & Serializable)_$3 -> new StringBuilder(0).append(this.pathToPage(pageDri$3, (DRI)_$3)).append(prefix).toString());
    }

    private static URL asValidURL$1$$anonfun$1(String str$2) {
        return new URI(str$2).toURL();
    }

    private static Option asValidURL$1(String str$1) {
        return Try$.MODULE$.apply(() -> SiteRenderer.asValidURL$1$$anonfun$1(str$1)).toOption().map((Function1 & Serializable)_$4 -> str$1);
    }

    private String asAsset$1$$anonfun$1(DRI pageDri$7, String str$5) {
        return this.resolveLink(pageDri$7, StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(str$5), "/"));
    }

    private Option asAsset$1(Path staticSiteRootPath$1, String str$4, DRI pageDri$6) {
        return Option$.MODULE$.when(Files.exists(staticSiteRootPath$1.resolve("_assets").resolve(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(str$4), "/")), new LinkOption[0]), () -> this.asAsset$1$$anonfun$1(pageDri$6, str$4));
    }

    private Option asStaticSite$1$$anonfun$1(String str$7, ResolvedTemplate content$5, DRI pageDri$9) {
        return this.tryAsDri$1(content$5, pageDri$9, str$7);
    }

    private Option asStaticSite$1(String str$6, ResolvedTemplate content$4, DRI pageDri$8) {
        return this.tryAsDriPlain$1(content$4, pageDri$8, str$6).orElse(() -> this.asStaticSite$1$$anonfun$1(str$6, content$4, pageDri$8));
    }

    private Option processLocalLink$1$$anonfun$1(String str$9, ResolvedTemplate content$7, DRI pageDri$10) {
        return this.asStaticSite$1(str$9, content$7, pageDri$10);
    }

    private Option processLocalLink$1$$anonfun$2(Path staticSiteRootPath$2, String str$10, DRI pageDri$11) {
        return this.asAsset$1(staticSiteRootPath$2, str$10, pageDri$11);
    }

    private String processLocalLink$1$$anonfun$3(String str$8, ResolvedTemplate content$6) {
        if (!this.dotty$tools$scaladoc$renderers$SiteRenderer$$x$1().args().noLinkAssetWarnings()) {
            String msg = new StringBuilder(25).append("Unable to resolve link '").append(str$8).append("'").toString();
            DocContext$package$.MODULE$.warn(DocContext$package$.MODULE$.report(), msg, content$6.template().templateFile().file(), DocContext$package$.MODULE$.compilerContext(this.dotty$tools$scaladoc$renderers$SiteRenderer$$x$1()));
        }
        return str$8;
    }

    private String processLocalLink$1(ResolvedTemplate content$3, DRI pageDri$5, String str) {
        Path staticSiteRootPath = content$3.ctx().root().toPath().toAbsolutePath();
        return (String)SiteRenderer.asValidURL$1(str).orElse(() -> this.processLocalLink$1$$anonfun$1(str, content$3, pageDri$5)).orElse(() -> this.processLocalLink$1$$anonfun$2(staticSiteRootPath, str, pageDri$5)).getOrElse(() -> this.processLocalLink$1$$anonfun$3(str, content$3));
    }

    private String processLocalLinkWithGuard$1(ResolvedTemplate content$8, DRI pageDri$12, String str) {
        if (str.startsWith("#") || str.isEmpty()) {
            return str;
        }
        return this.processLocalLink$1(content$8, pageDri$12, str);
    }
}

