
# sort - asc, desc, ci_asc, ci_desc
class TestSortOrdering < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context

		@orders = []

		entity = 'cd'
		@object1 = @ec.create entity
		@object2 = @ec.create entity
		@object3 = @ec.create entity
		@object4 = @ec.create entity
		@object5 = @ec.create entity

		@object1['title'] = 'C'
		@object2['title'] = 'b'
		@object3['title'] = 'E'
		@object4['title'] = 'a'
		@object5['title'] = 'd'
		@objects = [@object1, @object2, @object3, @object4, @object5]
	end

	def create_order( key, symbol )
		@orders << SortOrdering.new(key, symbol)
	end

	def sorted
		SortOrdering.sort(@objects, @orders)
	end

	def test_sort_into_ascending_order
		create_order('title', SortOrdering::ASC)
		expected = [@object1, @object3, @object4, @object2, @object5]

		assert_equal(expected, sorted)
	end

	def test_sort_into_case_insensitive_ascending_order
		create_order('title', SortOrdering::CI_ASC)
		expected = [@object4, @object2, @object1, @object5, @object3]

		assert_equal(expected, sorted)
	end

	def test_sort_into_descending_order
		create_order('title', SortOrdering::DESC)
		expected = [@object5, @object2, @object4, @object3, @object1]

		assert_equal(expected, sorted)
	end

	def test_sort_into_case_insensitive_descending_order
		create_order('title', SortOrdering::CI_DESC)
		expected = [@object3, @object5, @object1, @object2, @object4]

		assert_equal(expected, sorted)
	end

	def test_sort_with_multiple_orders
		create_order('title', SortOrdering::ASC)
		create_order('release', SortOrdering::ASC)

		object1 = @ec.create 'cd'
		object2 = @ec.create 'cd'
		object3 = @ec.create 'cd'
		object1['title']   = 'b'
		object2['title']   = 'a'
		object3['title']   = 'a'
		object1['release'] = 2000
		object2['release'] = 2001
		object3['release'] = 2002
		objects  = [object1, object2, object3]
		expected = [object2, object3, object1]

		assert_equal(expected, SortOrdering.sort(objects, @orders))
	end
end


class TestSortOrderingComparisonSupport < Test::Unit::TestCase
	include TapKit

	def test_compare
		tests = [ \
		{:symbol=>SortOrdering::ASC, :left=>'bcd', :right=>'abc', :expected=>1},
		{:symbol=>SortOrdering::ASC, :left=>'abc', :right=>'bcd', :expected=>-1},
		{:symbol=>SortOrdering::ASC, :left=>'abc', :right=>'abc', :expected=>0},
		{:symbol=>SortOrdering::ASC, :left=>'abc', :right=>'ABC', :expected=>1},
		{:symbol=>SortOrdering::CI_ASC, :left=>'bcd', :right=>'abc', :expected=>1},
		{:symbol=>SortOrdering::CI_ASC, :left=>'abc', :right=>'bcd', :expected=>-1},
		{:symbol=>SortOrdering::CI_ASC, :left=>'abc', :right=>'abc', :expected=>0},
		{:symbol=>SortOrdering::CI_ASC, :left=>'abc', :right=>'ABC', :expected=>0},
		{:symbol=>SortOrdering::DESC, :left=>'bcd', :right=>'abc', :expected=>-1},
		{:symbol=>SortOrdering::DESC, :left=>'abc', :right=>'bcd', :expected=>1},
		{:symbol=>SortOrdering::DESC, :left=>'abc', :right=>'abc', :expected=>0},
		{:symbol=>SortOrdering::DESC, :left=>'abc', :right=>'ABC', :expected=>-1},
		{:symbol=>SortOrdering::CI_DESC, :left=>'bcd', :right=>'abc', :expected=>-1},
		{:symbol=>SortOrdering::CI_DESC, :left=>'abc', :right=>'bcd', :expected=>1},
		{:symbol=>SortOrdering::CI_DESC, :left=>'abc', :right=>'abc', :expected=>0},
		{:symbol=>SortOrdering::CI_DESC, :left=>'abc', :right=>'ABC', :expected=>0},
		]

		tests.each do |test|
			assert_equal(test[:expected], \
				SortOrdering.compare(test[:left], test[:right], test[:symbol]))
		end
	end
end
