class TestJoin < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context

		@source      = @app.entity('Book').attribute('publisher_id')
		@destination = @app.entity('Publisher').attribute('publisher_id')
	end

	def test_join
		join = Join.new(@source, @destination)

		assert_equal(@source, join.source)
		assert_equal(@destination, join.destination)
	end

	def test_equal
		join1 = Join.new(@source, @destination)
		join2 = Join.new(@source, @destination)

		assert_equal(join1, join2)
	end

	def test_to_h
		join = Join.new(@source, @destination)
		expected = {'source'=>'publisher_id', 'destination'=>'publisher_id'}

		assert_equal(expected, join.to_h)
	end
end
