
# check list
# * primary key after saving
# * foreign key after saving
# * setted destination object after saving

class TestEditingContextInsertion < Test::Unit::TestCase
	include TapKit

	def setup
		@app = Application.new MODELS
		@ec  = @app.create_editing_context

		test = "test_insertion<#{Time.now}>"
		@data_cd = {'title' => test, 'artist' => 'testartist', 'release' => 2000}
		@data_book      = {'title' => test}
		@data_publisher = {'name' => test}
		@data_author    = {'name' => test}

		@entities = {'cd' => 'title', 'Book' => 'title', 
			'Publisher' => 'name', 'Author' => 'name'}
	end

	def fetchspec( entity )
		qualifier = Qualifier.new_with_format("#{@entities[entity]} like 'test*'")
		spec = FetchSpec.new(entity, qualifier)
		spec.limit = 10
		spec
	end

	def test_01_insert_new_record_without_relationships
		object = @ec.create 'cd'
		object.take_values @data_cd
		@ec.save

		# check inserted object
		title = object['title'].dup
		q = Qualifier.format("title == %@", [title])
		fs = FetchSpec.new('cd', q)
		objects = @ec.fetch fs
		inserted = objects.first
		assert_equal(@data_cd['title'], inserted['title'])
		assert_equal(@data_cd['artist'], inserted['artist'])
		assert_equal(@data_cd['release'], inserted['release'])
	end

	def test_02_insert_new_record_with_new_relationship
		object = @ec.create 'Book'
		dest   = @ec.create 'Publisher'
		object.take_values @data_book
		dest.take_values @data_publisher
		object['publisher'] = dest
		@ec.save

		assert_equal(object['publisher'], dest)
	end

	def test_03_insert_new_record_with_new_to_many_relationship
		object = @ec.create 'Publisher'
		dest1  = @ec.create 'Book'
		dest2  = @ec.create 'Book'
		dest3  = @ec.create 'Book'
		object.take_values @data_publisher
		dest1.take_values @data_book
		dest2.take_values @data_book
		dest3.take_values @data_book
		object['books'] << dest1
		object['books'] << dest2
		object['books'] << dest3
		dest1['publisher'] = object
		dest2['publisher'] = object
		dest3['publisher'] = object
		@ec.save

		assert_equal(3, object['books'].size)
		assert object['books'].include?(dest1)
		assert object['books'].include?(dest2)
		assert object['books'].include?(dest3)
	end


	def test_04_insert_new_record_with_existed_relationship
		object = @ec.create 'Book'
		object['title'] = "test_04_insert<#{Time.now}>"

		# insert
		fs = FetchSpec.new('Publisher')
		fs.limit = 1
		dests = @ec.fetch fs
		dest  = dests.first
		object['publisher'] = dest
		@ec.save

		# check
		title = object['title'].dup
		name = dest['name'].dup
		qualifier = Qualifier.format("(title == %@) and (publisher.name == %@)",
			[title, name])
		fs = FetchSpec.new('Book', qualifier)
		fs.limit = 1
		fs.refresh = true
		objects = @ec.fetch fs
		object  = objects.first
		assert_equal(title, object['title'])
		assert_equal(name, object['publisher']['name'])
	end

	def test_05_insert_new_relationship_to_existed_record
		object = @ec.create 'Publisher'
		object['name'] = "test_05_insert<#{Time.now}>"

		# insert
		qualifier = Qualifier.format("title like 'test_04_insert*'")
		fs = FetchSpec.new('Book', qualifier)
		fs.limit = 1
		dests = @ec.fetch fs
		dest  = dests.first
		dest['publisher'] = object
		object['books'] << dest
		@ec.save

		# check
		name = object['name'].dup
		title = dest['title'].dup
		qualifier = Qualifier.format("(name == %@) and (books.title == %@)",
			[name, title])
		fs = FetchSpec.new('Publisher', qualifier)
		fs.limit = 1
		fs.refresh = true
		objects = @ec.fetch fs
		object = objects.first
		assert_equal(name, object['name'])
		assert_equal(title, object['books'][0]['title'])
	end
end


