module TapKit

	class SortOrdering

		module ComparisonSupport
			def compare( left, right, symbol )
				__send__(symbol, left, right)
			end

			def compare_ascending( left, right )
				if left > right then
					1
				elsif left < right then
					-1
				else
					0
				end
			end

			# Case Insesitive
			def compare_ci_ascending( left, right )
				left  = left.upcase
				right = right.upcase

				if left > right then
					1
				elsif left < right then
					-1
				else
					0
				end
			end

			def compare_descending( left, right )
				if left > right then
					-1
				elsif left < right then
					1
				else
					0
				end
			end

			def compare_ci_descending( left, right )
				left  = left.upcase
				right = right.upcase

				if left > right then
					-1
				elsif left < right then
					1
				else
					0
				end
			end
		end


		extend ComparisonSupport

		attr_reader :key, :symbol

		ASC     = :compare_ascending
		DESC    = :compare_descending
		CI_ASC  = :compare_ci_ascending
		CI_DESC = :compare_ci_descending

		class << self
			def sort( objects, sort_orderings )
				sorted = objects.sort do |a, b|
					result = nil
					sort_orderings.each do |ordering|
						key_a  = a[ordering.key]
						key_b  = b[ordering.key]
						result = compare(key_a, key_b, ordering.symbol)

						unless result == 0 then
							break
						end
					end
					result
				end
				sorted
			end
		end

		def initialize( key, symbol = nil )
			@key = key
			@symbol = symbol || SortOrdering::ASC
		end
	end

end
