module TapKit

	class Database
		attr_reader :adapter, :registerd_contexts, :models
		attr_reader :adapter_name, :application

		def initialize( application, model )
			@application = application
			@adapter_name = model.adapter_name
			@models = [model]

			@adapter = Adapter.new_with_name(@adapter_name, model, application)

			@snapshot_store = SnapshotStore.new
			@registerd_contexts = []
			@result_cache = {}
			@timestamp = nil
		end

		def add_model( model )
			@models << model
		end

		def remove_model( model )
			@models.delete model
		end

		def entity( object )
			@models.each do |model|
				if e = model.entity(object) then
					return e
				end
			end
			nil
		end

		def register_context( context )
			@registerd_contexts << context
		end

		def unregister_context( context )
			@registerd_contexts.delete context
		end

		def result_cache( name )
			@result_cache[name]
		end

		def set_result_cache( name, cache )
			@result_cache[name] = cache
		end

		def snapshot( gid, time = nil )
			@snapshot_store.snapshot(gid, time)
		end

		def snapshot_for_source( gid, name, time = nil )
			@snapshot_store.snapshot_for_source(gid, name, time)
		end

		def snapshots
			@snapshot_store.snapshots
		end

		def record_snapshot( gid, snapshot )
			@snapshot_store.record_snapshot(gid, snapshot)
		end

		def record_snapshot_for_source( gids, gid, name )
			@snapshot_store.record_snapshot_for_source(gids, gid, name)
		end

		def record_snapshots( snapshots )
			@snapshot_store.record_snapshots snapshots
		end

		def record_to_many_snapshots( snapshots )
			@snapshot_store.record_to_many_snapshots snapshots
		end

		def forget_all_snapshots
			@snapshot_store.forget_all_snapshots
		end

		def forget_snapshots( gids )
			@snapshot_store.forget_snapshots gids
		end

		def forget_snapshot( gid )
			@snapshot_store.forget_snapshot gid
		end

		def set_timestamp_to_now
			@snapshot_store.set_timestamp_to_now
		end
	end

end
