require 'dbi'
require 'tapkit/access/adapters/dbi'

module TapKit

	class MySQLAdapter < DBIAdapter
		class << self
			def expression_class
				MySQLExpression
			end

			# Internal types for MySQL.
			# List data types (ENUM and SET) is not supported.
			def internal_types
				types = super
				types['tinyint']            = Integer
				types['tinyint unsigned']   = Integer
				types['smallint unsigned']  = Integer
				types['mediumint']          = Integer
				types['mediumint unsigned'] = Integer
				types['int unsigned']       = Integer
				types['bigint']             = Integer
				types['bigint unsigned']    = Integer
				types['double']             = Float
				types['decimal']            = String
				types['datetime']           = Timestamp
				types['year']               = Date
				types['tinyblob']           = String
				types['tinytext']           = String
				types['blob']               = String
				types['text']               = String
				types['mediumblob']         = String
				types['mediumtext']         = String
				types['longblob']           = String
				types['longtext']           = String
				types
			end
		end

		def expression_factory
			MySQLExpressionFactory.new self
		end
	end

	class MySQLChannel < DBIChannel
		def evaluate_for_aggregate_spec( agg_spec, expression )
			state = self.evaluate expression
			rows = []
			state.fetch_all.each do |row|
				new_row = {}
				row.each_with_index do |value, index|
					key = state.column_names[index]
					new_row[key] = value
				end
				rows << new_row
			end
			rows
		end
	end

	class MySQLContext < DBIContext
		def create_channel
			channel = MySQLChannel.new self
			@channels << channel
			channel
		end
	end

	class MySQLExpression < DBIExpression
		class << self
			def adapter_class
				MySQLAdapter
			end
		end
	end

	class MySQLExpressionFactory < DBIExpressionFactory
		def expression_class
			MySQLExpression
		end
	end

end
