#!/usr/local/bin/ruby

#
# Examples for AggregateSpec
#

$LOAD_PATH.unshift '../lib'

require 'tapkit'
include TapKit


app = Application.new ['model/single_entity.yaml', 'model/employee1.yaml']
ec = app.ec

# aggregating
qualifier = Qualifier.format("name like 'A*'")
spec = AggregateSpec.new("Employee", qualifier)
spec.add("total", "name", AggregateSpec::COUNT)
objects = ec.fetch(spec)

objects.each do |obj|
	puts "Employee('name' like 'A*'): total = #{obj['total']}"
end


# grouping
spec = AggregateSpec.new('cd')
spec.add('albums', 'title', AggregateSpec::COUNT)
spec.group('artist')
objects = ec.fetch(spec)

objects.each do |obj|
	puts "CD: artist = #{obj['artist']}, albums = #{obj['albums']}"
end

