require 'preferences'

module MyAppPrefs
  case RUBY_PLATFORM
  when /win32/
    APP_DIR = "MyApp"
  else
    APP_DIR = ".MyApp"
  end
  
  $real_world = false
  
  if $real_world
    prefs_dir = Preferences.dir
  else
    prefs_dir = "tmp"
  end
  
  prefs_filename = File.join(prefs_dir, APP_DIR, "preferences.yml")
  PREFS = Preferences.new(prefs_filename)

  def register_pref_key(key)
    PREFS.register_pref_key(self, key)
  end

  def register_pref_var(*args)
    PREFS.register_pref_var(self, *args)
  end
end

class MyApp
  include MyAppPrefs
    # include this in all base classes you want to save settings for
  
  attr_accessor :x, :y, :z
  
  def initialize
    register_pref_key "my/app"
    register_pref_var :x => 4, :y => "seven"
    register_pref_var :z => proc {
      puts "calculating default for z" # should appear on first run only
      "default value for z"
    }
    self.x = 5
  end
end

app = MyApp.new

p app.x, app.y

prefs = MyApp::PREFS
prefs.save
p prefs.preferences
p prefs.filename
