require 'preferences'

PREFS = Preferences.new("/tmp/life-cycle-prefs")

$user_input = 7

class Window
  attr_accessor :x, :y
  def initialize
    PREFS.register_pref_key self, "my app/window"
    PREFS.register_pref_var self, :x, :y => "default_y"
  end
  
  # Intercept the closing of the window, so that last good values can be saved
  def close
    PREFS.dump_prefs_for(self)
    PREFS.disconnect(self)
      # don't use this object anymore--it's being destroyed
    
    # unmap the window or whatever
    
    @x = @y = "garbage" # coords are now bogus or maybe will even cause crash
  end

  def run
    @x = $user_input # emulate user's interaction
  end
end

def main
  @window = Window.new
  @window.run
  @window.close
end

main

# even though the window is closed, its prefs value are stored in memory and
# await the save command
PREFS.save 

raise unless PREFS.preferences["my app"]["window"][:x] = $user_input
