#!/usr/bin/env ruby

# Adapted from the "foursplit.rb" example that comes with FXRuby.
# Uses Preferences to remember state of the splitters (split proportions
# as well as expanded state) and the position and size of the main window..
# You can find the additions by grepping for /pref/i .

require 'fox14'
require 'preferences'

include Fox

class FX4Splitter
  # The following methods seem to be missing in some old versions of FXRuby:
  unless instance_methods.include?("expanded")
    def expanded; getExpanded; end
    def expanded=(e); setExpanded(e); end
    def vSplit; getVSplit; end
    def vSplit=(v); setVSplit(v); end
    def hSplit; getHSplit; end
    def hSplit=(h); setHSplit(h); end
  end
end

PREFS = Preferences.new("tmp/foursplit-prefs.yml")

class FourSplitWindow < FXMainWindow
  def initialize(app)
    # Call the base class initialize() first
    super(app, "4-Way Splitter Test", nil, nil, DECOR_ALL, 0, 0, 800, 600, 0, 0)

    PREFS.register "main window" do |entry|
      # These vars are already provided by the window class. We just register
      # them for persistence, and provide some defaults.
      entry.var "width", "height", "x" => 200, "y" => 100
    end
    
    # Menu bar, along the top
    menubar = FXMenuBar.new(self, LAYOUT_SIDE_TOP|LAYOUT_FILL_X)
  
    # Status bar, along the bottom
    FXStatusBar.new(self,
      LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER)
    
    # The top-level splitter takes up the rest of the space
    splitter = FX4Splitter.new(self,
      LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|FOURSPLITTER_TRACKING)
    
    PREFS.register "main window/splitter", splitter do |entry|
      entry.var "expanded", "hSplit", "vSplit"
    end
    
    # File menu
    filemenu = FXMenuPane.new(self)
    FXMenuCommand.new(filemenu, "&Quit\tCtl-Q\tQuit the application.", nil,
      getApp(), FXApp::ID_QUIT)
    FXMenuTitle.new(menubar, "&File", nil, filemenu)
    
    # Expand menu
    expandmenu = FXMenuPane.new(self)
    FXMenuCommand.new(expandmenu, "All four", nil,
      splitter, FX4Splitter::ID_EXPAND_ALL)
    FXMenuCommand.new(expandmenu, "Top/left", nil,
      splitter, FX4Splitter::ID_EXPAND_TOPLEFT)
    FXMenuCommand.new(expandmenu, "Top/right", nil,
      splitter, FX4Splitter::ID_EXPAND_TOPRIGHT)
    FXMenuCommand.new(expandmenu, "Bottom/left", nil,
      splitter, FX4Splitter::ID_EXPAND_BOTTOMLEFT)
    FXMenuCommand.new(expandmenu, "Bottom/right", nil,
      splitter, FX4Splitter::ID_EXPAND_BOTTOMRIGHT)
    FXMenuTitle.new(menubar, "&Expand", nil, expandmenu)
    
    # The 4-splitter accepts exactly four child widgets, and the
    # order in which they are added matters (top left, top right,
    # bottom left and bottom right, in that order). For our case,
    # the first three child widgets are just regular pushbuttons,
    # but the fourth is itself another 4-splitter. There is no
    # restriction on nesting these kinds of widgets.

    FXButton.new(splitter, "Top &Left\tThis splitter tracks", nil,
      nil, 0, FRAME_RAISED|FRAME_THICK)

    FXButton.new(splitter, "Top &Right\tThis splitter tracks", nil,
      nil, 0, FRAME_RAISED|FRAME_THICK)

    FXButton.new(splitter, "&Bottom Left\tThis splitter tracks", nil,
      nil, 0, FRAME_SUNKEN|FRAME_THICK)

    subsplitter = FX4Splitter.new(splitter, LAYOUT_FILL_X|LAYOUT_FILL_Y)
    
    PREFS.register "main window/splitter/subsplitter", subsplitter do |entry|
      entry.var "expanded", "hSplit", "vSplit"
    end

    # Create the four children of the sub-splitter...
    FXButton.new(subsplitter, "&Of course\tThis splitter does NOT track") do |theButton|
      theButton.frameStyle = FRAME_SUNKEN|FRAME_THICK
      theButton.backColor = FXRGB(0, 128, 0)
      theButton.textColor = FXRGB(255, 255, 255)
    end

    button = FXButton.new(subsplitter,
      "the&y CAN\tThis splitter does NOT track", nil,
      nil, 0, FRAME_SUNKEN|FRAME_THICK)
    button.backColor = FXRGB(128, 0, 0)
    button.textColor = FXRGB(255, 255, 255)

    button = FXButton.new(subsplitter,
      "be &NESTED\tThis splitter does NOT track", nil,
      nil, 0, FRAME_SUNKEN|FRAME_THICK)
    button.backColor = FXRGB(0, 0, 200)
    button.textColor = FXRGB(255, 255, 255)

    button = FXButton.new(subsplitter,
      "&arbitrarily!\tThis splitter does NOT track", nil,
      nil, 0, FRAME_SUNKEN|FRAME_THICK)
    button.backColor = FXRGB(128, 128, 0)
    button.textColor = FXRGB(255, 255, 255)
    
    # Finally, create the tool tip object
    FXToolTip.new(getApp())

    # We need to do this to prevent a segfault with fxruby 1.4
    getAccelTable().addAccel(MKUINT(KEY_F4,ALTMASK),
      self, FXSEL(SEL_COMMAND,ID_CLOSE))
    
    connect(SEL_CLOSE) do
      PREFS.save
      $already_saved_prefs = true
      close
    end
  end

  def create
    super
    show #(PLACEMENT_SCREEN) <-- let PREFS handle this!
  end
end

def runme
  application = FXApp.new("FourSplit", "FoxTest")
  FourSplitWindow.new(application)
  application.create
  application.run
  PREFS.save unless $already_saved_prefs # avoids the segfault
end

runme
