//! Qore namespace
namespace Qore {
//! Xml namespace
namespace Xml {
//! The FileSaxIterator class provides a SAX iterator for file-based XML data based on <a href="http://xmlsoft.org">libxml2</a>
/***/
class FileSaxIterator : public SaxIterator {

public:
//! creates a new FileSaxIterator object from the file name and the element name passed
/** @par Restrictions:
    @ref Qore::PO_NO_FILESYSTEM

    @param path the path to a file containing the XML data to iterate
    @param element_name the name of the element to iterate through
    @param encoding an optional encoding for the file; if not given, then any encoding given in the file's XML preamble is used

    @par Example:
    @code
FileSaxIterator i(path, "DetailRecord");
map printf("record %d: %y\n", $#, $1), i;
    @endcode

    @throw XMLDOC-CONSTRUCTOR-ERROR error parsing XML string
 */
 constructor(string path, string element_name, __7_ string encoding);

public:
//! creates a new FileSaxIterator object from the file name and the element name passed
/** @par Restrictions:
    @ref Qore::PO_NO_FILESYSTEM

    @param path the path to a file containing the XML data to iterate
    @param element_name the name of the element to iterate through
    @param opts the following options are accepted:
    - \c encoding: (string) the file's character encoding
    - \c xml_input_io: (AbstractXmlIoInputCallback) an AbstractXmlIoInputCallback object to resolve external XSD schema references
    - \c xml_parse_options: (int bitfield) XML parsing flags; see @ref xml_parsing_constants for more information
    - \c xsd: (string) an XSD string for schema validation while parsing

    @par Example:
    @code
FileSaxIterator i(path, "DetailRecord");
map printf("record %d: %y\n", $#, $1), i;
    @endcode

    @throw XML-READER-ERROR error opening file
    @throw FILESAXITERATOR-OPTION-ERROR error in option hash

    @since xml 1.4
*/
 constructor(string path, string element_name, hash opts);

public:
//! Returns a copy of the current object (the copy will be reset to the beginning of the XML string)
/** @return a copy of the current object (the copy will be reset to the beginning of the XML string)

    @par Example:
    @code FileSaxIterator copy = i.copy(); @endcode
*/
 copy();
};
}
}
