// -*- mode: c++; indent-tabs-mode: nil -*-
//! @file SaxDataProvider.qm Qore user module for working with CSV files

/*  SaxDataProvider.qm Copyright 2012 - 2022 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

// minimum required Qore version



// assume local var scope, do not use "$" for vars, members, and method calls


/** @mainpage SaxDataProvider Module

    @tableofcontents

    @section saxdataproviderintro Introduction to the SaxDataProvider Module

    The %SaxDataProvider module provides functionality for processing XML data efficiently.

    To use this module, use \c "%requires SaxDataProvider" in your code.

    All the public symbols in the module are defined in the SaxDataProvider namespace

    Currently the module provides the following classes:
    - @ref SaxDataProvider::SaxDataProvider "SaxDataProvider": a data provider for reading and searching CSV files
    - @ref SaxDataProvider::SaxDataProviderFactory "SaxDataProviderFactory": a data provider factory for reading and searching CSV files

    @section saxdataprovider_relnotes Release Notes

    @subsection saxdataprovider_v1_0 Version 1.0
    - initial version of module
*/

//! The main namespace for the SaxDataProvider module
namespace SaxDataProvider {
};
