# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     ./generate_unicodedb.py --unidata_version=5.2.0 --output=unicodedb_5_2_0

from rpython.rlib.rarithmetic import r_longlong


base_mod = None
version = '5.2.0'


def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright, parentstr, codepoint = _charnodes[charnode:charnode+3]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)
        
        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError, name

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright, parentstr, codepoint = _charnodes[charnode:charnode+3]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.insert(0, substring)

        prevnode = charnode // 3
        charnode = parent

    return ''.join(res)
    

_stringtable = (
'\x01 '
'\x02 A'
'\x06 ABOVE'
'\x14 ABOVE LEFT TRIANGLE'
'\x14 ABOVE SLANTED EQUAL'
'\x05 ADEG'
'\x06 AGUNG'
'\x04 ALL'
'\x05 ALLO'
'\x0f ALTERNATE FORM'
'\x11 ALTERNATION MARK'
'\x05 AMPS'
'\x03 AN'
'\x05 AND '
'\n AND ACUTE'
'\n AND BREVE'
'\x14 AND DIAGONAL STROKE'
'\x0e AND DOT ABOVE'
'\x13 AND DOT ABOVE AND '
'\n AND GRAVE'
'\x10 AND HEAVY RIGHT'
'\t AND HOOK'
'\x10 AND LIGHT RIGHT'
'\x0f AND LOWER LEFT'
'\x10 AND LOWER RIGHT'
'\x0b AND MACRON'
'\x11 AND MIDDLE TILDE'
'\x13 AND PROSGEGRAMMENI'
'\x06 AND S'
'\x15 AND SLANTED PARALLEL'
'\x0e AND SMALL TAH'
'\x12 AND SMASH PRODUCT'
'\t AND TAIL'
'\x15 AND THREE DOTS ABOVE'
'\x13 AND TWO DOTS ABOVE'
'\x12 AND YPOGEGRAMMENI'
'\x07 APLOUN'
'\t APODEXIA'
'\t ARCHAION'
'\x06 ARROW'
'\r B BAR SYMBOL'
'\x05 BACK'
'\n BACKSLASH'
'\x04 BAR'
'\r BEHIND CLOUD'
'\x06 BELOW'
'\x1c BETWEEN TWO HORIZONTAL BARS'
'\r BLACK SQUARE'
'\x06 BLOCK'
'\r BZHI MIG CAN'
'\x04 C D'
'\x05 CAPO'
'\x06 CARET'
'\x08 CEDILLA'
'\x07 CER-WA'
'\x07 CHIKI '
'\x07 CIRCLE'
'\x05 CLEF'
'\x0f CLOUD AND RAIN'
'\x0f CORNER BRACKET'
'\x1f CROSSING ASH OVER ASH OVER ASH'
'\x0e CROSSING GABA'
'\x0c CROSSING GU'
'\r CROSSING KA2'
'\x08 CURRENT'
'\x05 DEKA'
'\x0f DEYTEROU ICHOU'
'\r DIFFERENTIAL'
'\x0c DIMINUTION-'
'\r DIMINUTION-1'
'\x06 DIPLI'
'\x1b DIVIDED BY HORIZONTAL RULE'
'\x05 DOTS'
'\t DRACHMAS'
'\n ENCLOSURE'
'\x06 ENTRY'
'\t EQUAL TO'
'\x07 EQUALS'
'\x06 EQUID'
'\x03 FA'
'\x05 FACE'
'\x07 FLEXUS'
'\t FORM TWO'
'\t FROM BAR'
'\n FROM WALL'
'\x1a GAD OVER GAD GAR OVER GAR'
'\r GAR OVER GAR'
'\t GARSHUNI'
'\x05 GORA'
'\x07 GROUND'
'\x05 GUNU'
'\x05 HAA '
'\x08 HANDLES'
'\x06 HANDS'
'\x0e HASER FOR VAV'
'\x03 HE'
'\r HEADED ARROW'
'\x03 HU'
'\x08 HUNDRED'
'\x17 HUNDRED TWENTY-EIGHTH '
'\x07 HYPHEN'
'\x05 ILUT'
'\x03 IN'
'\x13 IN A RECTANGLE BOX'
'\x0c IN TRIANGLE'
'\x10 INSERTION POINT'
'\x0e ISOLATED FORM'
'\x05 JERA'
'\x02 K'
'\n KABA TENU'
'\x06 KAPAL'
'\x13 KASKAL U GUNU DISH'
'\x05 KAWI'
'\x07 KEFULA'
'\x08 KEMBANG'
'\x0e KISIM5 TIMES '
'\x02 L'
'\x05 LACA'
'\x11 LAGAB TIMES ASH2'
'\x11 LAGAR OVER LAGAR'
'\x04 LAI'
'\n LATE FORM'
'\x05 LEFT'
'\x06 LELET'
'\x06 LENGA'
'\x1a LESS THAN THE DENOMINATOR'
'\x05 LINE'
'\x0c LINE SYMBOL'
'\x06 LONGA'
'\x07 LONSUM'
'\x02 M'
'\n MAHAPRANA'
'\x05 MARK'
'\x05 MEGA'
'\x06 MELIK'
'\x07 MENDUT'
'\x07 MUQDAM'
'\x06 MURDA'
'\x1a NEGATED WITH VERTICAL BAR'
'\x04 NEO'
'\x04 NOT'
'\n NOTATION '
'\n NOTEHEAD '
'\x08 NUTILLU'
'\x03 OF'
'\x04 OF '
'\n OF DHARMA'
'\x04 OHM'
'\x10 ON BLACK SQUARE'
'\x0c ON PEDESTAL'
'\t OPENING '
'\t OPERATOR'
'\x0f OPERATOR WITH '
'\r OPPOSING KUR'
'\x04 OR '
'\x1a OR APPROXIMATELY EQUAL TO'
'\t OR EQUAL'
'\x0c OR EQUAL TO'
'\x10 OR THE IMAGE OF'
'\x08 OTTAVA '
'\t OVER BAL'
'\x0b OVER BULUG'
'\x16 OVER GAD GAR OVER GAR'
') OVER HI TIMES ASH2 KU OVER HI TIMES ASH2'
'\x0b OVER IDIM '
'\x12 OVER INVERTED SHU'
'\n OVER KAD5'
'\x08 OVER KG'
'\x0c OVER KISIM5'
'\x14 OVER LAGAR GUNU SHE'
'\t OVER LUM'
'\x07 OVER M'
'\x08 OVER MU'
'\t OVER NUN'
'\x19 OVER NUN LAGAR TIMES SAL'
'\x1d OVER RIGHTWARDS ARROW TO BAR'
'\x07 OVER S'
'\x0f OVER SIG4 SHU2'
'\x08 OVER SU'
'\x18 OVER TOP SQUARE BRACKET'
'\x14 OVER TUR ZA OVER ZA'
'\x0c OVER TWO PI'
'\x08 OVER ZI'
'\x02 P'
'\x0f PARESTIGMENON '
'\x07 PLOPHU'
'\x06 PLUS '
'\x07 PLUS A'
'\t PLUS ASH'
'\x08 PLUS DI'
'\x08 PLUS DU'
'\x08 PLUS EN'
'\t PLUS GUD'
'\x0f PLUS HI PLUS A'
'\t PLUS KU3'
'\x08 PLUS LA'
'\t PLUS LAL'
'\x08 PLUS LU'
'\x12 PLUS LU PLUS ESH2'
'\n PLUS MASH'
'\x0b PLUS MASH2'
'\x0b PLUS NUNUZ'
'\x08 PLUS RA'
'\x08 PLUS RU'
'\x11 PLUS SHA3 PLUS A'
'\n PLUS SHU2'
'\t PLUS SUM'
'\t PLUS TUR'
'\x0f POINTING INDEX'
'\x0b PROPORTION'
'\x11 PUNCTUATION MARK'
'\x06 QATAN'
'\x0f QUOTATION MARK'
'\x07 RAMBAT'
'\x08 RASWADI'
'\x05 REPA'
'\x05 REST'
'\n RESUPINUS'
'\n RGYA GRAM'
'\x04 RHO'
'\x06 RIGHT'
'\x08 ROTUNDA'
'\x03 SA'
'\x05 SARI'
'\n SCHROEDER'
'\n SEPARATOR'
'\x05 SHAD'
'\x0b SHOE STILE'
'\x05 SIGN'
'\x06 SIGN '
'\x0c SKEWED LEFT'
'\r SKEWED RIGHT'
'\x08 SLIDING'
'\x07 SLOWLY'
'\x06 SMALL'
'\x10 SOLIDUS OVERLAY'
'\x08 SQUARED'
'\x08 STATERS'
'\x07 STRIDE'
'\x03 SU'
'\x07 SYMBOL'
'\x05 TACK'
'\x0b TACK BELOW'
'\x05 TAIL'
'\x08 TALENTS'
'\x07 TEDUNG'
'\x05 TELU'
'\x05 TENU'
'\t THOUSAND'
'\x0f THROUGH CIRCLE'
'\x12 THROUGH DESCENDER'
'\x07 TIMES '
'\x08 TIMES A'
'\x10 TIMES A PLUS NA'
'\n TIMES BAD'
'\x08 TIMES E'
'\x0b TIMES ESH2'
'\t TIMES GA'
'\x10 TIMES GAN2 TENU'
'\x0f TIMES IGI GUNU'
'\r TIMES KASKAL'
'\n TIMES KUR'
'\n TIMES LAL'
'\n TIMES SHE'
'\x08 TIMES U'
'\x11 TO BLACK DIAMOND'
'\x06 TONE-'
'\t TROMIKON'
'\x08 TTUDDAG'
'" TWO DOTS OVER ONE DOT PUNCTUATION'
'\x02 U'
'\t UNDERBAR'
'\x03 UP'
'\x0b UPPER HALF'
'\r VARIANT FORM'
'\x05 WITH'
'\x06 WITH '
'\n WITH BASE'
'\x0b WITH CARON'
'\x0c WITH CIRCLE'
'\x12 WITH CIRCLE ABOVE'
'\x12 WITH CIRCLE BELOW'
'\x17 WITH CIRCUMFLEX ACCENT'
'\x0b WITH COMMA'
'\x12 WITH CROSSED-TAIL'
'\n WITH CURL'
'\x07 WITH D'
'\x0c WITH DAGESH'
'\x0b WITH DASIA'
'\x0f WITH DESCENDER'
'\x0f WITH DIAERESIS'
'\t WITH DOT'
'\n WITH DOT '
'\x0f WITH DOT ABOVE'
'\x10 WITH DOT INSIDE'
'\n WITH DOTS'
'\x19 WITH DOUBLE GRAVE ACCENT'
'\x14 WITH FATHATAN ABOVE'
'\x0e WITH FISHHOOK'
'\n WITH HOOK'
'\x14 WITH HORIZONTAL BAR'
'$ WITH HORIZONTAL MIDDLE BLACK STRIPE'
'\r WITH JEGOGAN'
'\x0e WITH LONG LEG'
'\x0b WITH MAPIQ'
'\r WITH OVERBAR'
'\x12 WITH PALATAL HOOK'
'\n WITH PLUS'
'\x14 WITH RETROFLEX HOOK'
'\x1d WITH REVERSED NEGATION SLASH'
'\x07 WITH S'
'\x13 WITH STRIKETHROUGH'
'\x0c WITH STROKE'
'\n WITH TAIL'
'\r WITH TEE TOP'
'\n WITH TICK'
'\x11 WITH TILDE ABOVE'
'\x0b WITH TITLO'
'\x0e WITH UNDERBAR'
'\r WITHOUT SNOW'
'\x07 WOLOSO'
'\x01-'
'\x02-0'
'\x02-2'
'\x11-9 QUOTATION MARK'
'\x02-A'
'\x05-ALAF'
'\x05-ARY '
'\x05-BEAM'
'\x0c-BREAK SPACE'
'\x10-BREAKING HYPHEN'
'\x06-BRJGU'
'\x0f-CARRIER LETTER'
'\x06-CREE '
'\x07-CREE R'
'\x08-CREE TH'
'\x0e-CURRENCY SIGN'
'\x0c-DZUD RTAGS '
'\r-ESASA DOTTED'
'\x0b-FEATHERED '
'\x1b-FEATHERED RIGHTWARDS ARROW'
'\x11-GAAHLAA TTUDDAAG'
'\x08-HEADED '
'\x1f-HEADED ARROW FROM SMALL CIRCLE'
'\x18-HEADED RIGHTWARDS ARROW'
'\x06-HIDET'
'\x06-HIEUH'
'\n-HIRAGANA '
'\x1e-HIRAGANA PROLONGED SOUND MARK'
'\x02-I'
'\x06-IEUNG'
'\x07-INDIC '
'\x08-KHIEUKH'
'\t-KHYUD PA'
'\x07-KIYEOK'
'\x0b-LINE STAFF'
'\n-LUE KARAN'
'\x07-MACRON'
'\x06-MINUS'
'\x0b-MINUS SIGN'
'\x02-O'
'\x04-ONE'
'\r-OR-PLUS SIGN'
'\r-PER-EM SPACE'
'\x08-PHIEUPH'
'\x06-PIEUP'
'\n-POINTING '
'\x10-POINTING ANGLE '
' -POINTING ANGLE BRACKET ORNAMENT'
'\x18-POINTING TRIANGLE WITH '
'\x15-ROUND NOTEHEAD DOWN '
'\x15-SHAPED BAG DELIMITER'
'\n-SHAPED HA'
'\x0c-SIMPLIFIED '
'\x05-SIOS'
'\t-STACCATO'
'\x0e-STEM TONE BAR'
'\x05-TAIL'
'\x03-TE'
'\x07-TIKEUT'
'\x02-U'
'\x04-UM '
'\x02-W'
'\x010'
'\x080 BRONZE'
'\x050 DWO'
'\x0b0 FOOTSTOOL'
'\x040 KO'
'\x040 MA'
'\x050 MAN'
'\x040 NI'
'\x050 OIL'
'\x040 PU'
'\x040 RA'
'\x070 SPEAR'
'\x030 U'
'\x070 WHEAT'
'\x110 WHEELED CHARIOT'
'\x040 WI'
'\x040 ZO'
'\x030-0'
'\x0207'
'\x0209'
'\x030B9'
'\x011'
'\x071 ARROW'
'\x081 BARLEY'
'\t1 CHARIOT'
'\x041 DA'
'\x041 DU'
'\x051 DWE'
'\x061 GOLD'
'\x081 HELMET'
'\x061 HORN'
'\x041 KU'
'\x031 O'
'\n1 PLASTICS'
'\x041 PO'
'\x041 QI'
'\x041 SA'
'\x041 SI'
'\x051 TWO'
'\x061 WINE'
'\x031-0'
'\x0211'
'\x03121'
'\x03155'
'\x0216'
'\x0218'
'\x0318D'
'\x021A'
'\x021D'
'\x012'
'\x0f2 CHARIOT FRAME'
'\t2 GARMENT'
'\x042 NO'
'\x072 OLIVE'
'\x042 PE'
'\n2 PLASTICS'
'\n2 PLUS ASH'
'\n2 PLUS GAL'
'\x0b2 PLUS GIR2'
'\x052 PTE'
'\x042 QO'
'\x042 RO'
'\x042 SO'
'\x042 WO'
'\x072 WOMAN'
'\x032-0'
'\x0220'
'\x0221'
'\x0222'
'\t247 DIPTE'
'\x03253'
'\x0229'
'\x022D'
'\x032DD'
'\x022F'
'\x013'
'\x043 A3'
'\x073 AREPA'
'\x083 ARMOUR'
'\x043 ME'
'\x043 MI'
'\x073 MONTH'
'\x043 MU'
'\x043 PA'
'\n3 PLASTICS'
'\x053 RA3'
'\x043 RI'
'\x073 SPICE'
'\x073 SWORD'
'\x073 WHEEL'
'\x033-0'
'\x03305'
'\x0234'
'\x0239'
'\x014'
'\x064 DART'
'\x064 DEER'
'\x044 DO'
'\x044 KE'
'\x044 NE'
'\n4 PLASTICS'
'\x044 TE'
'\x044 WA'
'\x044 ZE'
'\x034-0'
'\x0240'
'\x03439'
'\x024B'
'\x024D'
'\x024E'
'\x015'
'\x045 A2'
'\x045 AU'
'\t5 BATHTUB'
'\t5 CYPERUS'
'\x045 DE'
'\x045 JU'
'\x065 MERI'
'\x045 MO'
'\x045 NU'
'\n5 PLASTICS'
'\x045 TO'
'\x045 WE'
'\x065 WOOL'
'\x035-0'
'\x0250'
'\x0351F'
'\x0253'
'\x0255'
'\x03557'
'\x0256'
'\x0856 TURO2'
'\x016'
'\x046 JE'
'\x046 JO'
'\x046 NA'
'\n6 PLASTICS'
'\x046 QA'
'\x056 RA2'
'\x046 RU'
'\x056 TA2'
'\x066 TREE'
'\x036-0'
'\x03620'
'\x036D7'
'\x017'
'\x047 DI'
'\x047 JA'
'\x047 KA'
'\x067 KAPO'
'\x047 KI'
'\n7 PLASTICS'
'\x047 RE'
'\x047 TI'
'\x057 TWE'
'\x047 ZA'
'\x0270'
'\x0372C'
'\x0279'
'\x018'
'\x038 A'
'\x038 E'
'\x038 I'
'\x088 KANAKO'
'\x058 NWA'
'\x048 QE'
'\x058 RO2'
'\x048 SU'
'\x028C'
'\x038F0'
'\x019'
'\x079 CLOTH'
'\x049 PI'
'\x059 PU2'
'\x049 SE'
'\x049 TA'
'\x049 TU'
'\x04904A'
'\x0295'
'\x0299'
'\x039E3'
'\x01A'
'\x02A '
'\x07A -PHRU'
'\x06A HAAM'
'\x04A IE'
'\x07A NAME '
'\x11A PLUS HA PLUS DA'
'\nA PLUS IGI'
'\nA PLUS KUR'
'\nA TANG LAI'
'\x05A UNA'
'\x14A- SHOG GI MGO RGYAN'
'\x04A-HA'
'\x05A-ROL'
'\x02A0'
'\x02A2'
'\x02A4'
'\x02AA'
'\x05AADHU'
'\x03AAF'
'\x04AAFU'
'\x05AAMAE'
'\x04AAMU'
'\x03AAN'
'\x02AB'
'\nAB2 TIMES '
'\x08ABAAFILI'
'\x11ABBREVIATION MARK'
'\x11ABBREVIATION SIGN'
'\x04ABIC'
'\x04ABLE'
'\tABLED CAR'
'\x08ABOAFILI'
'\x04ABOR'
'\x05ABOVE'
'\x06ABOVE '
'\nABOVE AND '
'\x11ABOVE EQUALS SIGN'
'\x12ABOVE GREATER-THAN'
'&ABOVE LEFTWARDS HARPOON WITH BARB DOWN'
'\x0fABOVE LESS-THAN'
"'ABOVE RIGHTWARDS HARPOON WITH BARB DOWN"
'\x15ABOVE SHORT DOWN TACK'
'\tABOVE TO '
'\x02AC'
'\x05ACCAT'
'\x06ACCENT'
'\x07ACCENT '
'\x03ACE'
'\tACE NOTE '
'\nACE SYMBOL'
'\x03ACH'
'\x0fACHES THE LIMIT'
'\x03ACK'
'\nACK CIRCLE'
'\x0bACKNOWLEDGE'
'\x08ACKSPACE'
'\x05ACRON'
'\x03ACT'
'\x07ACTION '
'\x05ACUTE'
'\x0cACUTE ACCENT'
'\x15ACUTE AND HOOK SYMBOL'
'\x0bACUTE-GRAVE'
'\x02AD'
'\x03AD3'
'\x03ADA'
'\nADAK BINDI'
'\x04ADDA'
'\nADDA WITH '
'\x05ADDAK'
'\x03ADE'
'\tADEG ADEG'
'\x04ADHE'
'\x04ADHU'
'\x10ADIAN SYLLABICS '
'\tADMA GDAN'
'\x03ADU'
'\x02AE'
'\nAEDA-PILLA'
'\x03AEF'
'\nAELA-PILLA'
'\x07AELAENG'
'\x03AEM'
'\x0bAESCULAPIUS'
'\x06AESURA'
'\x11AEUM ONE PLETHRON'
'\x02AF'
'\x08AF WITH '
'\x02AG'
'\x03AG-'
'\x04AGAB'
'\x0bAGAZ DAEG D'
'\x06AGE OF'
'\x05AGGER'
'\x1eAGGRAVATED INDEPENDENT SVARITA'
'\x03AGL'
'\x05AGMA '
'\tAGOLITIC '
'\x04AGON'
'\x06AGRANT'
'\x02AH'
'\x03AH '
'\x04AH I'
'\x08AH WITH '
'\x04AHAD'
'\x07AHAPAKH'
'\x08AHAPRANA'
'\x02AI'
'\x0eAI LENGTH MARK'
'\tAIGHTNESS'
'\x03AIL'
'\nAILED BIRD'
'\x0eAILLE PATTERN '
'\x0bAILLESS PHI'
'\x04AILM'
'\x06AILURE'
'\x03AIN'
'\x05AINS '
'\x06AISED '
'\tAISED DOT'
'\x16AISED OMISSION BRACKET'
'\x06AITING'
'\x08AIYANNOI'
'\tAJANYALAN'
'\x02AK'
'\x06AKABAT'
'\x03AKE'
'\x15AKIA TELOUS ICHIMATOS'
'\nAKKHANGYAO'
'\x04AKRA'
'\x02AL'
'\nAL BARLINE'
'\x0fAL INTERSECTION'
'\x07AL SIGN'
'\nAL SYMBOL '
'\x05AL TO'
'&AL WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x03AL2'
'\x03ALA'
'\x04ALAF'
'\x04ALAG'
'\x04ALAI'
'\x05ALAPH'
'\x15ALATALIZED HOOK BELOW'
'\x05ALATH'
'\x0fALAYHE ASSALLAM'
'\x03ALC'
'\x04ALDA'
'\x03ALE'
'\x08ALE SIGN'
'\x04ALEF'
'\x05ALEF '
'\nALEF LAMED'
'\rALEF MAKSURA '
'\x17ALEF MAKSURA FINAL FORM'
'\x1aALEF MAKSURA ISOLATED FORM'
'\x16ALEF WITH LAM WITH YEH'
'\nALENT SIGN'
'\x06ALENTS'
'\x05ALEPH'
'\x04ALES'
'\x07ALESMA '
'\x05ALETH'
'\x03ALF'
'\x05ALF H'
'\x0eALF TREE TRUNK'
'\x14ALF TRIANGULAR COLON'
'\x17ALGAMATION OR COPRODUCT'
'\tALI GALI '
'\x05ALING'
'\x03ALK'
'\x03ALL'
'\x04ALL '
'\x06ALL AA'
'!ALL BUT UPPER LEFT QUADRANT BLACK'
'\x0eALLAJALALOUHOU'
'\x05ALLEY'
'\x05ALLI '
'\x08ALLIANCE'
'\x15ALLING DIAGONAL SLASH'
'\x07ALLOT X'
'\x08ALLY EQU'
'\x0fALMOST EQUAL TO'
'\x07ALOCHKA'
'\x05ALOG '
'\tALPAPRANA'
'\x05ALPHA'
'\x03ALT'
'\x04ALTA'
'\x07ALTILLO'
'\x06ALTIRE'
'\x02AM'
'\x07AM ALEF'
'\x10AM ISOLATED FORM'
'\x07AMAKKAN'
'\x0fAMARITAN SOURCE'
'\x05AMATS'
'\x04AMBA'
'\x11AMBDA WITH STROKE'
'\x05AMBOO'
'\x04AMDA'
'\x03AME'
'\x04AME '
'\x07AME DOT'
'\x05AMED '
'\x05AMEKH'
'\x04AMIL'
'\x04AMLA'
'\x04AMMA'
'\x0eAMNUC PII KUUH'
'\x05AMOND'
'\x0fAMOUNT OF CHECK'
'\tAMPERSAND'
'\x11AMPHYLIAN DIGAMMA'
'\x04AMPI'
'\x08AMS HORN'
'\x02AN'
'\x07AN MARK'
'\x03AN2'
'\x03ANA'
'\x04ANA '
'\x04ANAP'
'\x04ANCH'
'\x06ANCHOR'
'\x03AND'
'\x04AND '
'\tAND ACUTE'
'\x0cAND CRESCENT'
'\x0fAND FEMALE SIGN'
'\x1eAND JOINED BY DASH WITH SUBSET'
'\x18AND MALE AND FEMALE SIGN'
'\x14AND NORTH EAST ARROW'
'\x14AND NORTH WEST ARROW'
'\x0cAND OPERATOR'
'\x0fAND PARALLEL TO'
'\x14AND SOUTH EAST ARROW'
'\x14AND SOUTH WEST ARROW'
'\x04ANDA'
'\x07ANDERER'
'\x08ANE TREE'
'\tANEROSIS '
'\x03ANG'
'\x04ANG '
'\x17ANG DEPARTING TONE MARK'
'\x0cANG KHANG GY'
'\x14ANGE ANTIRESTRICTION'
'\x06ANGKAT'
'\nANGKHANKHU'
'\x05ANGLE'
'\rANGLE BRACKET'
'\x06ANGUL '
'\x07ANGULAR'
'\nANGULAR TO'
'\rANNED LEATHER'
'\x0bANNOTATION '
'\x03ANO'
'\x08ANS SIGN'
'\nANS-SERIF '
'\x12ANS-SERIF CAPITAL '
'\x13ANS-SERIF CAPITAL L'
'\x06ANSIOS'
'\x13ANSPOSITION BRACKET'
'\x04ANT '
'\x0cANTARGOMUKHA'
'\tANTHAKHAT'
'\x13ANTICLOCKWISE ARROW'
'\x06ANUARY'
'\x08ANUDATTA'
'\x08ANUSVARA'
'\tAOS ICHOS'
'\x02AP'
'\tAP FILLER'
'\x03APA'
'\x07APEZIUM'
'\x03APH'
'\x06APISMA'
'\x06APITAL'
'\x07APITAL '
'\x08APITAL L'
'\x0eAPITAL LETTER '
'\x11APLI DYO DODEKATA'
'\x06APLI M'
'\x06APLOUN'
'\x04APON'
'\nAPOSTROPHE'
'\x04APPA'
'\x0bAPPROXIMATE'
'\tAPUN IYEK'
'\x07APYEOUN'
'\x0cAPYEOUNPIEUP'
'\x06APYRUS'
'\x02AR'
'\x04AR A'
'\x05AR AE'
'\x05AR B '
'\x0cAR DIAERESIS'
'\x08AR TSHES'
'\rAR WITH QUILL'
'\x04ARA '
'\x13ARABIC FORM SHAPING'
'\x1eARABIC LETTER TAH AND TWO DOTS'
'\x06ARADDO'
'\x12ARAGRAPH SEPARATOR'
'\nARAKALESMA'
'\x07ARALLEL'
'\x0cARALLELOGRAM'
'\nARANI SIGN'
'\x04ARB '
'\x06ARBUTA'
'\x03ARC'
'\x04ARC '
'\x17ARC ANTICLOCKWISE ARROW'
'\rARCHAIC KOPPA'
'\tARCHAIC M'
'\x08ARCHAION'
'\x07ARDNESS'
'\x07ARDROP-'
'\x13ARENTHESIS NOTEHEAD'
'\x05ARERU'
'\x05ARET '
'\x03ARG'
'\x04ARGA'
'\x05ARGE '
'\x0bARGE CIRCLE'
'\x0bARGE SQUARE'
'\x04ARGI'
'\rARGOSYNTHETON'
'\x04ARIA'
'\x08ARISTERA'
'\tARISTERA '
'\x04ARK '
'\x08ARKENING'
'\x15ARKENING OF THE LIGHT'
'\x08ARKLEAN '
'\rARLAUG SYMBOL'
'\x04ARON'
'\tAROSHTHI '
'\x0eAROUND-PROFILE'
'\x04ARP '
'\x0bARPEGGIATO '
'\x07ARRED B'
'\x07ARRED O'
'\x06ARRIER'
'\x05ARROW'
'\x06ARROW '
'\x0bARROW ABOVE'
'\rARROW OVERLAY'
'\x18ARROW POINTING DIRECTLY '
'\tARROWHEAD'
'\x06ARSEOS'
'\x08ARSI YEH'
'\x08ART SUIT'
'\x06ARTER '
'\x04ARTH'
'\x13ARTIAL DIFFERENTIAL'
'\x08ARTYRIA '
'\x03ARU'
'\x14ARXIS KAI FTHORA VOU'
'\x15ARYSTIAN FIVE HUNDRED'
'\x02AS'
'\x03AS '
'\tAS MEMBER'
'\x07AS SIGN'
'\x03ASE'
'\x0bASE TO THE '
'\x05ASEIA'
'\x07ASES AS'
'\x03ASH'
"'ASH FROM LEFT MEMBER OF DOUBLE VERTICAL"
'\x04ASH2'
'\x0bASHED ARROW'
'&ASHED TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x06ASHGAB'
'\x04ASIA'
'\x05ASKAL'
'\x04ASLA'
'\x13ASOUL ISOLATED FORM'
'\x05ASPER'
'\x06ASSING'
'\x08AST WIND'
'\nASTERISCUS'
'\x08ASTERISK'
'\x1cASTERISKS ALIGNED VERTICALLY'
'\x11ASTERN PWO KAREN '
'\x08ASTERN W'
'\x12ASTROLOGICAL SIGN '
'\x03ASU'
'\x07ASURED '
'\x07ASUTORU'
'\x02AT'
'\x03AT '
'\x0fATA LINK ESCAPE'
'\x05ATAF '
'\x08ATAKANA '
'\nATAKANA DE'
'\x03ATE'
'\x08ATE MARK'
'\x04ATER'
'\nATER-THAN '
'\x03ATH'
'\x08ATH MARK'
'\x04ATHA'
'\tATHAMASAT'
' ATHARVAVEDIC INDEPENDENT SVARITA'
'\x08ATHERING'
'\x11ATHERING TOGETHER'
'\x03ATI'
'\x04ATIM'
'\x05ATIN '
'\x12ATIN SMALL LETTER '
'\x0fATINATE MYSLITE'
'\x0bATION POINT'
'\x05ATIYA'
'\x0cATNAH HAFUKH'
'\nATRICHISMA'
'\x06ATTIC '
'\x04ATTO'
'\x0cATTOOED HEAD'
'\x07ATURAL '
'\x02AU'
'\x0eAU LENGTH MARK'
'\x11AUKAZ LAGU LOGR L'
'\x04AULA'
'\x07AULDRON'
'\x07AUNTLET'
'\x05AUTHS'
'\x06AUTUMN'
'\x02AV'
'\x03AVA'
'\x08AVAGRAHA'
'\x03AVE'
'\nAVE ACCENT'
'\tAVE ARROW'
'\x07AVIYANI'
'\x05AVROS'
'\x08AVY BAND'
'\x02AW'
'\x03AW '
'\rAWELLEMET YAZ'
'\x05AXIMA'
'\x07AXIMATA'
'\x02AY'
'\x03AY '
'\x07AY SIGN'
'\x07AYALAM '
'\x06AYANNA'
'\x03AYB'
'\x12AYHE ISOLATED FORM'
'\x04AYIN'
'\x03AZU'
'\x01B'
'\tB DIGRAPH'
'\x02B0'
'\x03B00'
'\x02B2'
'\x10B2 TENU PLUS TAB'
'\x03B57'
'\x02B6'
'\x03B89'
'\x02BA'
'\x03BAA'
'\x05BAARU'
'\x08BACK YER'
'\tBACKSLASH'
'\rBACKSLASH BAR'
'\x03BAD'
'\x06BAFILI'
'\x0eBAG MEMBERSHIP'
'\x0cBAHIRGOMUKHA'
'\x07BAIRKAN'
'\x05BALAG'
'\x17BALLOON-SPOKED ASTERISK'
'\x06BALUDA'
'\x07BAMBOOS'
'\x03BAN'
'\x04BANG'
'\x0bBANK SYMBOL'
'\x06BANWA '
'\x03BAR'
'\x04BAR '
'\tBAR ABOVE'
'\x16BAR ABOVE INTERSECTION'
'\x0fBAR ABOVE UNION'
'\x05BARB '
'\x17BARBED RIGHTWARDS ARROW'
'\x07BARLINE'
'\x06BARREE'
'\x07BARREKH'
'\x04BASA'
'\x05BASA '
'\tBASE UNIT'
'\x04BASH'
'\x05BASSA'
'\x08BATBEIT '
'\x03BAU'
'\x07BAYANNA'
'\x02BB'
'\x10BBREVIATION MARK'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x07BE ROOT'
'\x04BEAM'
'\x03BEE'
'\x06BEFILI'
'\x06BEGIN '
'\x03BEH'
'\x05BEITH'
'\x0fBELGTHOR SYMBOL'
'\x05BELOW'
'\x06BELOW '
'\x0fBELOW LONG DASH'
'\x03BEN'
'\x04BEND'
'\x05BENDE'
'\x04BER '
'\x11BERBER ACADEMY YA'
'\x04BERD'
'\x18BERKANAN BEORC BJARKAN B'
'\x07BESIDE '
'#BESIDE AND JOINED WITH INTERSECTION'
'\x1cBESIDE AND JOINED WITH UNION'
'\x15BESIDE RIGHT TRIANGLE'
'\x03BET'
'\x04BETA'
'\x0bBETA SYMBOL'
'\x06BETAN '
'\x04BETH'
'\x08BEVERAGE'
'\x03BHA'
'\x05BHADH'
'\x05BHETH'
'\x02BI'
'\x03BIB'
'\x03BIE'
'\x07BIG YUS'
'\x03BIN'
'\x0fBINARY RELATION'
'\x05BINDI'
'\x0fBINDING BRACKET'
'\x07BINING '
'\x16BINING GEMINATION MARK'
'\x0cBINING MARK '
'\x04BIRD'
'\x05BIRGA'
'\x05BISAH'
'\x06BISHOP'
'\tBJARKAN B'
'\x0fBJOINED LETTER '
'\tBKHASIAN '
'\x03BLA'
'\x05BLACK'
'\x06BLACK '
'\x0bBLACK ARROW'
'\x0cBLACK CIRCLE'
'\x18BLACK LENTICULAR BRACKET'
'\x11BLACK SHOGI PIECE'
'\x0cBLACK SQUARE'
'\nBLACK STAR'
'\x0eBLACK TRIANGLE'
'\x0eBLADE SCISSORS'
'\x05BLANK'
'\x03BLE'
'\x08BLINEAR '
'\x05BLOCK'
'\x02BO'
'\tBO BAIMAI'
'\tBO GYFU G'
'\x06BOFILI'
'\x08BOL FOR '
'\x08BOL SIGN'
'\x05BOLD '
'\x04BORE'
'\x06BOTTOM'
'\x07BOTTOM '
'\rBOTTOM CORNER'
'\x11BOTTOM HALF BLACK'
'\x10BOTTOM HALF RING'
'\x0bBOTTOM MARK'
'#BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD'
'\x07BOURING'
'\x04BOVE'
'\x05BOVE '
'\x06BOWTIE'
'\x03BOX'
'\x02BR'
'\x03BRA'
'\x07BRACKET'
'\x11BRACKET EXTENSION'
'\x10BRACKET ORNAMENT'
'\x1bBRDA RNYING YIG MGO MDUN MA'
'\x1bBRDA RNYING YIG MGO SGAB MA'
'\x05BREVE'
'\x0bBREVE BELOW'
'\x07BREVIS '
'\x05BREW '
'\nBROKEN BAR'
'\tBRUL SHAD'
'\x02BS'
'\x0cBSCRIPT ALEF'
'\x04BSET'
'\x07BSET OF'
'\x14BSET OF NOR EQUAL TO'
'\nBSTRUCTION'
'\x03BU '
'\x06BULLET'
'\x0bBUMPY ABOVE'
'\x08BUNDANCE'
'\x03BUR'
'\x03BUT'
'\x19BUT NOT ACTUALLY EQUAL TO'
'\x0bBUT NOT EQU'
'\x15BUT NOT EQUIVALENT TO'
'\x03BWA'
'\x03BXG'
'\x02BY'
'\rBY DEFINITION'
'\x0cBYSMAL WATER'
'\x0bBZHI -KHYIL'
'\x0cBZHI MIG CAN'
'\x01C'
'\x03C A'
'\x06C CLEF'
'\x13C DIGRAPH WITH CURL'
'\x16C GREATER-THAN BRACKET'
'\x13C LESS-THAN BRACKET'
'\nC WITH DOT'
'\x02C-'
'\x02C0'
'\x02CA'
'\x03CA9'
'\x05CAANG'
'\x05CAKRA'
'\x03CAL'
'\x11CAL SYMBOL BOTTOM'
'\x06CALATE'
'\x05CALYA'
'\x0bCAN RGYINGS'
'\x11CANCELLATION MARK'
'\x08CANDICUS'
'\x06CANDRA'
'\x07CANDRA '
'\x0cCANDRA BELOW'
'\x0bCANDRABINDU'
'\tCANG TE-U'
'\x12CANTILLATION SIGN '
'\x08CAPITAL '
'\tCAPITAL D'
'\tCAPITAL F'
'\tCAPITAL L'
'\x0fCAPITAL LETTER '
'\tCAPITAL Q'
'\x05CARET'
'\x0bCARET TILDE'
'\x06CARIK '
'\x05CARON'
'\x04CART'
'\x06CATAWA'
'\x05CAUDA'
'\x05CAUSE'
'\x07CAYANNA'
'\x04CAYN'
'\x02CC'
'\x06CCEEDS'
'\x05CCENT'
'\tCCER BALL'
'\x0bCCUMULATION'
'\x02CE'
'\x13CE OF INTEREST SIGN'
'\x08CE SKATE'
'\x05CECAK'
'\x05CECEK'
'\x05CEDES'
'\x0bCELANDIC-YR'
'\x07CELSIUS'
'\x0cCENDING NODE'
'\tCENT SIGN'
'\x07CENTRE '
'\x14CENTRE VERTICAL LINE'
'\x0eCENTURIAL SIGN'
'\x06CER-WA'
'\x05CEREK'
'\x03CES'
'\x02CH'
'\x03CH '
'\x03CHA'
'\nCHAD RTAGS'
'\x05CHADA'
'\x06CHADIN'
'\x0cCHAIR SYMBOL'
'\x06CHAMKO'
'\x08CHATTAWA'
'\tCHAVIYANI'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\x05CHED '
'\x04CHEE'
'\x04CHEH'
'\x08CHEIKHEI'
'\x07CHEINAP'
'\x06CHEMA '
'\x03CHI'
'\x07CHIEUCH'
'\x04CHIL'
'\x06CHIRET'
'\tCHMA SIGN'
'\x06CHO CH'
'\x05CHOOL'
'\x04CHOR'
'\tCHOSEONG '
'\x06CHRIVI'
'\x07CHROMA '
'\rCHRYSANTHEMUM'
'\x07CHU CAN'
'\x05CHULA'
'\x06CHURCH'
'\x04CHWA'
'\x0cCIAN LETTER '
'\x05CIEUC'
'\x03CIG'
'\x06CIMAL '
'\x06CIRCLE'
'\x07CIRCLE '
'\rCIRCLE INSIDE'
'\x1bCIRCLE WITH NORTHWEST ARROW'
'\x08CIRCLED '
'\x0cCIRCLED PLUS'
'\x13CIRCLED SANS-SERIF '
'\x0fCIRCUIT-OUTPUT '
'\nCIRCUMFLEX'
'\x10CIRCUMFLEX ABOVE'
'\x11CIRCUMFLEX ACCENT'
'\x17CIRCUMFLEX ACCENT ABOVE'
'\nCISIVENESS'
'\x07CISSORS'
'\x16CJK UNIFIED IDEOGRAPH-'
'\x02CK'
'\x07CK MARK'
')CK-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x04CKET'
'\x05CKING'
'\x06CKNESS'
'\x07CKWISE '
'\x05CLICK'
'\x05CLIFF'
'\x1aCLOCKWISE ARROW WITH MINUS'
'\x0fCLOSED BY CURVE'
'\x11CLOSED LITTLE YUS'
'\tCLOSED PL'
'\x08CLOSED T'
'\x07CLOSURE'
'\x14CLUB-SPOKED ASTERISK'
'\x02CO'
'\x08COENG QA'
'\x05COLON'
'\x0eCOLON OPERATOR'
'\x03COM'
'\nCOMBINING '
'\x05COMMA'
'\x0bCOMMA ABOVE'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\x18COMPATIBILITY IDEOGRAPH-'
'\tCOMPLETED'
'\x0bCOMPOSITION'
'\x04COND'
'\x05COND '
'\x18CONSECUTIVE EQUALS SIGNS'
'\x0fCONSONANT SIGN '
'\x14CONSONANT SIGN HAARU'
'\x11CONSONANT SIGN PA'
'\x0bCONTAIN AS '
'\x1eCONTAINING BLACK SMALL DIAMOND'
'\x1dCONTAINING BLACK SMALL SQUARE'
'\x1bCONTINUOUS UNDERLINE SYMBOL'
'\x11CONTOURED OUTLINE'
'\x03COO'
'\x07COPTIC '
'\x06CORNER'
'\x0eCORNER BRACKET'
'\x10CORNER DOWNWARDS'
'\x10CORNER LEFTWARDS'
'\x0fCORNER WITH DOT'
'\x08COUNCIL '
'\x08COUNT OF'
'\x08COUNTERS'
'\x02CR'
'\x03CR '
'\x06CREASE'
'\x05CREEN'
'\tCRESCENDO'
'\x04CRET'
'\x0eCRIFICIAL WINE'
'\x06CRIPT '
'\rCRIPTION TAKE'
'\rCRIPTIONAL PA'
'\x08CRO SIGN'
'\x04CRON'
'\nCROPHONIC '
'\x05CROSS'
'\x11CROSS PUNCTUATION'
'\tCROSSING '
'\x0bCROSSING BU'
'\x0bCROSSING EN'
'\rCROSSING GAN2'
'\x0bCROSSING GI'
'\x0cCROSSING GI4'
'\rCROSSING GISH'
'\x0bCROSSING IM'
'\x0cCROSSING KAL'
'\x0cCROSSING LU2'
'\rCROSSING MUSH'
'\x19CROSSING NORTH EAST ARROW'
'\x0cCROSSING NUN'
'\x0bCROSSING PI'
'\x0bCROSSING UR'
'\x0cCSIMILE SIGN'
'\x02CT'
'\x11CTION APPLICATION'
'\nCTION MARK'
'\x15CTOR OR CROSS PRODUCT'
'\nCTORY HAND'
'\x05CTRIC'
'\tCUBE ROOT'
'\x05CUBED'
'\x07CULAR O'
'\x18CULINE ORDINAL INDICATOR'
'\x04CURL'
'\rCURLY BRACKET'
'\x16CURLY BRACKET ORNAMENT'
'\tCURRENCY '
'\x07CURVED '
'\x14CURVED ANGLE BRACKET'
'\x04CUTE'
'\x0bCUTE ACCENT'
'\x02CW'
'\x03CWA'
'\x04CWAA'
'\x03CWI'
'\x03CYA'
'\x04CYCL'
'\x01D'
'\x02D '
'\rD COMMA ABOVE'
'\x04D HA'
'\x07D MOUTH'
'\x05D OF '
'\nD OF PROOF'
'\x08D RIGHT '
'\tD SALTIRE'
'\x08D SYMBOL'
'\x07D WITH '
'\nD WITH DOT'
'\x02D0'
'\x03D42'
'\x03D70'
'\x02DA'
'\x03DA '
'\nDA PLUS HA'
'\x03DAA'
'\tDAD WITH '
'\x06DAGESH'
'\x0fDAGESH OR MAPIQ'
'\x04DAGS'
'\x04DAIR'
'\x04DAL '
'\x05DALAT'
'\x05DALET'
'\x06DALETH'
'\x05DAMMA'
'\x05DANDA'
'\x07DANESE '
'\x08DANTAJA '
'\x03DAP'
'\x03DAR'
'\x04DASH'
'\nDASH ARROW'
'\x05DASIA'
'\x0eDASIA PNEUMATA'
'\x05DATUS'
'\x07DAYANNA'
'\x02DD'
'\nDDAH ABOVE'
'\x02DE'
'\x0cDE MARK SIGN'
'\x03DE6'
'\x04DEAD'
'\x07DEAVOUR'
'\x03DEE'
'\x03DEG'
'\x03DEK'
'\x04DEL '
'\tDELIMITER'
'\x15DELIMITER TSHEG BSTAR'
'\x11DELPHIC FIVE MNAS'
'\x04DELT'
'\x05DELTA'
'\x05DENCE'
'\x13DENOMINATOR SIXTEEN'
'\x0cDENTAL CLICK'
'\x11DENTAL PERCUSSIVE'
'\tDEOGRAPH '
'\x06DERBAR'
'\x06DERMA '
'\x03DES'
'\tDESCENDER'
'\x0fDESCENDING TONE'
'\x05DESTY'
'\x10DEWAYS U BRACKET'
'\x05DEXIA'
'\x0eDEYTEROS ICHOS'
'\x1bDGE-TAILED RIGHTWARDS ARROW'
'\x04DGER'
'\x03DHA'
'\x05DHADH'
'\x07DHALATH'
'\x03DHE'
'\x02DI'
'\x0fDI ALLAHOU ANHU'
'\tDIAERESIS'
'\x19DIAERESIS AND HOOK SYMBOL'
'\rDIAERESIZED U'
'\tDIAGONAL '
'\x18DIAGONAL CROSSHATCH FILL'
'\x13DIAGONAL HALF BLACK'
'\x0fDIAGONAL STROKE'
'\x05DIAL '
'\x0fDIALYTIKA TONOS'
'\x07DIAMOND'
'\x05DIAN '
'\x07DIARGON'
'\nDIATONIKI '
'\x0bDIATONON DI'
'\x03DIB'
'\x04DIC '
'\x06DICINE'
'\x06DIESIS'
'\x08DIFONIAS'
'\x05DIGA '
'\x0fDIGA AELA-PILLA'
'\x07DIGAMMA'
'\x06DIGIT '
'\nDIGIT ZERO'
'\x15DIGRAMMOS EX DODEKATA'
'\x07DIGRAPH'
'\x0cDIGRAPH KOTO'
'\x0cDIGRAPH YORI'
'\x03DIM'
'\x04DIM2'
'\x03DIN'
'\x05DIPLI'
'\x07DIPLOUN'
'!DIRECT PRODUCT WITH BOTTOM CLOSED'
'\x14DIRECT QUESTION MARK'
'\nDIRGA MURE'
'\x04DISH'
'\x07DISIMOU'
'\x10DITORIAL CORONIS'
'\x05DIUM '
'\x06DIVIDE'
'>DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR'
'\x03DJA'
'\x05DKAR '
'\x04DLE '
'\x07DLE DOT'
'\x03DMA'
'\x02DO'
'\x03DO '
'\x0bDOACHASHMEE'
'\x0eDOES NOT EXIST'
'\x07DOFONON'
'\x06DOKMAI'
'\x0bDOLLAR SIGN'
'\x16DOMAIN ANTIRESTRICTION'
'\x03DON'
'\x0bDONG TSHUGS'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x13DOT ABOVE AND TILDE'
'\tDOT BELOW'
'\x17DOT BELOW AND DOT ABOVE'
'\x1eDOT BELOW AND THREE DOTS ABOVE'
'\x0cDOT OPERATOR'
'\x1dDOT OVER TWO DOTS PUNCTUATION'
'\x14DOTLESS HEAD OF KHAH'
'\x1dDOTS OVER ONE DOT PUNCTUATION'
'\x05DOTS-'
'\x06DOTTED'
'\x07DOTTED '
'\x1bDOTTED INTERPOLATION MARKER'
'\x1aDOTTED LUNATE SIGMA SYMBOL'
'\x1aDOTTED SUBSTITUTION MARKER'
'\rDOTTED ZLAMA '
'\x07DOUBLE '
'\x0bDOUBLE AND '
'\x14DOUBLE ANGLE BRACKET'
'\x1bDOUBLE ANGLE QUOTATION MARK'
'\x11DOUBLE ARCH BELOW'
'\x0cDOUBLE ARROW'
'\x19DOUBLE CANDRABINDU VIRAMA'
'\rDOUBLE CIRCLE'
'\x10DOUBLE DOT ABOVE'
'\x14DOUBLE DOT TONE MARK'
'\x10DOUBLE HEAD MARK'
'\rDOUBLE HYPHEN'
'\x15DOUBLE LEFT TURNSTILE'
'\rDOUBLE MUCAAD'
'\x1bDOUBLE PRIME QUOTATION MARK'
'\x12DOUBLE PUNCTUATION'
'\x0bDOUBLE SHAD'
'\x16DOUBLE SOLIDUS OVERLAY'
'\rDOUBLE STROKE'
'\x10DOUBLE TURNSTILE'
'\x16DOUBLE VERTICAL STROKE'
'$DOUBLE-LINE EQUAL ABOVE GREATER-THAN'
'!DOUBLE-LINE EQUAL ABOVE LESS-THAN'
'\x0eDOUBLE-STRUCK '
'\x0cDOWED WHITE '
'\x04DOWN'
'\x05DOWN '
'\tDOWN AND '
'\x13DOWN AND HORIZONTAL'
'\nDOWN ARROW'
'\x14DOWN ARROWHEAD BELOW'
'\x0cDOWN HARPOON'
'\nDOWN HEAVY'
'\x1cDOWN HEAVY AND LEFT UP LIGHT'
'\x1dDOWN HEAVY AND RIGHT UP LIGHT'
'\x15DOWN HORIZONTAL HEAVY'
'\x15DOWN HORIZONTAL LIGHT'
'\nDOWN LIGHT'
'\x10DOWN RIGHT BARB '
'\tDOWN TACK'
'\x12DOWN-OUTPUT SYMBOL'
'\tDOWNWARDS'
'\x1eDOWNWARDS AND RIGHTWARDS ARROW'
'\x0fDOWNWARDS ARROW'
'!DOWNWARDS HARPOON WITH BARB RIGHT'
'\x17DOWNWARDS THEN CURVING '
'\x16DOWNWARDS ZIGZAG ARROW'
'\x02DR'
'\x07DRACHMA'
'\x06DRAGON'
'\x16DRESSED TO THE SUBJECT'
'\x07DRIL BU'
'\x1aDROP-SHADOWED WHITE SQUARE'
'\x19DRY MEASURE FIRST SUBUNIT'
'\x08DS-CREE '
'\x17DSTONE GRAVEYARD SYMBOL'
'\x02DU'
'\x03DUG'
'\x03DUN'
'\tDUN3 GUNU'
'\x03DUR'
'\tDUS RTAGS'
'\x06DVANCE'
'\x08DVISVARA'
'\x02DY'
'\x0bDYO CHRONON'
'\x03DZE'
'\x01E'
'\x02E '
'\x07E FACE-'
'\x05E GEE'
'\x1aE ONE-WAY LEFT WAY TRAFFIC'
'\x0fE OVER INFINITY'
'\x18E PLUS A PLUS SU PLUS NA'
'\tE PLUS EN'
'\nE PLUS SUM'
'\tE TSA CAN'
'\x06E WAVE'
'\x02E0'
'\x02E2'
'\x02EA'
'\x04EACE'
'\x03EAF'
'\x05EAGLE'
'\x0cEAGULL BELOW'
'\x06EAHMUK'
'\x03EAN'
'\x11EAR SCREEN SYMBOL'
'\x08EAR SIGN'
'\tEARDROP-S'
'\nEARLY FORM'
'\x05EARTH'
'\nEARTH MARK'
'\x05EAST '
'\x06EASURE'
'\x03EAT'
'\x04EAT '
'\x0fEATER-THAN SIGN'
'\x04EATH'
'\x0cEATH PRODUCT'
'\x06EATHER'
'\x05EAVEN'
'\rEAVENLY EARTH'
'\x0bEAVER DENE '
'\tEAVY DOWN'
'\x1bEAVY WHITE RIGHTWARDS ARROW'
'\x07EAVY YA'
'\x08EBEEFILI'
'\nEBENSTIMME'
'\tEBIT SIGN'
'\x05ECEDE'
'\x06ECEDES'
'\x07ECEMBER'
'\x03ECH'
'\x08ECH YIWN'
'\x10ECIMAL SEPARATOR'
'\x08ECTANGLE'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x03ED '
'-ED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE'
'\x0bED EQUAL TO'
'\nED FIGURE-'
'\x0fED PAPER SYMBOL'
'\x0eED PARAGRAPHOS'
'\tEDESTRIAN'
'\x1cEDGE-TAILED RIGHTWARDS ARROW'
'\x06EDIAL '
'\nEDIAL FORM'
'\x06EDILLA'
'\x06EDIUM '
'\x05EDUNG'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x04EEK '
'\x03EEL'
'\x05EEM I'
'\tEEM WITH '
'\x03EEN'
'\tEEN WITH '
'\x04EENG'
'\x06EENTH '
'\x04EENU'
'\x0cEEPING SMALL'
'\x04EESU'
'\x04EETA'
'\x02EF'
'\x03EF '
'\x10EFORE COMPLETION'
'\x03EFT'
'\x04EFT '
'\x1cEFT ARC GREATER-THAN BRACKET'
'\x0eEFT HALF BLACK'
'\x08EFT HOOK'
'\x15EFT OPEN BOX OPERATOR'
'\x0fEFT PARENTHESIS'
'\x0fEFT REPEAT SIGN'
'\x13EFT-POINTING ANGLE '
'!EFT-POINTING ANGLE QUOTATION MARK'
'\x0fEFTWARDS ARROWS'
'\x1fEFTWARDS HARPOON WITH BARB DOWN'
'\x1dEFTWARDS HARPOON WITH BARB UP'
'\rEFTWARDS TICK'
'\x03EGA'
'\x05EGALI'
'\x06EGEAN '
'\x05EGIN '
'\x05EGION'
'\x05EGL H'
'\x04EGOL'
'\x08EGORIAN '
'\x02EH'
'\x03EH '
'\x0fEH INITIAL FORM'
'\x08EH WITH '
'&EH WITH SUPERSCRIPT ALEF ISOLATED FORM'
'\x04EHEH'
'\x03EHI'
'\x02EI'
'\x03EI '
'\nEICH STARK'
'\x03EIE'
'\x05EIGHT'
'\x06EIGHT '
'\x06EIGHTH'
'\x0cEIGHTH BLOCK'
'\x0cEIGHTH NOTES'
'\x07EIGHTHS'
'\rEIGHTHS BLOCK'
'\x06EIGHTY'
'\x06EILING'
'\x04EIRT'
'\x03EIS'
'\x05EISMA'
'\x04EIWS'
'\x02EK'
'\x03EK '
'\x08EK ONKAR'
'\x04EKAA'
'\x0bEKFONITIKON'
'\x02EL'
'\x07EL PUMP'
'\x15ELATIONAL COMPOSITION'
'\x03ELD'
'\x08ELEPHONE'
'\x03ELF'
'\x03ELL'
'\x07ELLIPSE'
'\x08ELLIPSIS'
'\tELLOWSHIP'
'\x05ELMET'
'\x03ELS'
'\x03ELT'
'\nELT BUCKLE'
'\x04ELTA'
'\x04ELVE'
'\x17ELVE POINTED BLACK STAR'
'\x02EM'
'\x05EMALE'
'\x06EMASTI'
'\tEMBEDDING'
'\x1bEMICIRCULAR CLOCKWISE ARROW'
'\x08EMICOLON'
'\x11EMICOLON UNDERBAR'
'\x11EMIDIRECT PRODUCT'
'\x0cEMISOFT SIGN'
'\x03EMK'
'\x06EMKATH'
'\x05EMLJA'
'\x06EMOLO-'
'\rEMPHATIC TONE'
'\tEMPTY SET'
'\x06EMPUS '
'\x02EN'
'\x06EN BOX'
'\x0cEN FULL STOP'
'\x06EN GHE'
'\x10EN MILLIONS SIGN'
'\x07EN SIGN'
'\x05ENANO'
'\x0cENARIUS SIGN'
'\x14ENARMONIOS ANTIFONIA'
'\x04ENAT'
'\x0fENCH FRANC SIGN'
'\x03END'
'\x0eEND OF SECTION'
'\x0eENDED MULTIMAP'
'\x05ENDEP'
'\x05ENENG'
'\nENETRATION'
'\x03ENG'
'\x0bENG DIGRAPH'
'\x06ENIKI '
'\x0cENOS CHRONOU'
'\x03ENT'
'\x08ENT SIGN'
'\x07ENTAGON'
'\x1bENTATION FORM FOR VERTICAL '
'\x12ENTERING TONE MARK'
'\x04ENTH'
'\x0bENTHESIZED '
'\nENTHUSIASM'
'\x06ENTIMA'
'\x06ENTION'
'\x05ENTRE'
'\x10ENTRE WHITE STAR'
'\x07ENTRED '
'\x04ENTY'
'\x03ENU'
'\x10ENUMERATION SIGN'
'\x05ENUTO'
'\x02EO'
'\x05EO-EU'
'\nEONGCHIEUM'
'\x0bEORGIAN NAR'
'\x03EOW'
'\x02EP'
'\x05EPEAT'
'\x0eEPENTHETIC YUT'
'\x03EPH'
'\x07EPHONE '
'\x0bEPIDAUREAN '
'\x12EPIGRAPHIC LETTER '
'\x0eEPSILON SYMBOL'
'\x10EPSILON UNDERBAR'
'\x03EQU'
'\x05EQUAL'
'\x06EQUAL '
'\x08EQUAL TO'
'\x0cEQUAL TO OR '
'\x18EQUAL TO OR GREATER-THAN'
'\x15EQUAL TO OR LESS-THAN'
'\x06EQUALS'
'\x0bEQUALS SIGN'
'\x02ER'
'\x03ER '
'\x15ER RIGHT CORNER ANGLE'
'\x07ER THAN'
'\x08ER TRUTH'
'\x08ERAL URN'
'\x0cERATION MARK'
'\x0bERCENT SIGN'
'\x07ERCIAL '
'\tERCIAL AT'
'\x06ERESIS'
'\x04ERET'
'\x05ERET '
'\x0eERIC INDICATOR'
'\x05ERIN2'
'\nERISPOMENI'
'\x05ERKHA'
'\x06ERMATA'
'\x05ERN W'
'\x08ERO SIGN'
'\nERO WIDTH '
'\x0cERPENDICULAR'
'\x05ERSON'
'\x0cERTICAL LINE'
'\x05ERTIE'
'\rERTION SYMBOL'
'\tERTY LINE'
'\x03ERU'
'\x07ES NOT '
'\tESAME DOT'
'\x03ESC'
'\x08ESCENDER'
'\x07ESCENDO'
'\x03ESH'
'\x0bESH DIGRAPH'
'\x08ESH LOOP'
'\x04ESH2'
'\x05ESHE3'
'\x06ESHTIN'
'\x03ESI'
'\x0fESIDE LESS-THAN'
'\x05ESIS '
'\x0bESMILO SIGN'
'\x05ESO E'
'\x03ESS'
'\x17ESS OUTLINED WHITE STAR'
'\x08ESS-THAN'
'\x0fESSARON CHRONON'
'\x04EST '
'\x08EST WIND'
'\x11ESTERN PWO KAREN '
'\x06ESTION'
'\x0bESTION MARK'
'\x07ESTIVAL'
'\x02ET'
'\x03ET '
'\x13ET WITH WHITE CROSS'
'\x03ETA'
'\x08ETA SIGN'
'\nETA SYMBOL'
'\x04ETAL'
' ETALLED BLACK AND WHITE FLORETTE'
'\x1fETALLED OUTLINED BLACK FLORETTE'
'\x0cETARTIMORION'
'\x08ETARTOS '
'\x0bETEI MAYEK '
'\tETER SIGN'
'\x03ETH'
'\x05ETION'
'\x07ETNAHTA'
'\x05ETORU'
'\x08ETRASEME'
'\tETRASIMOU'
'\x0cETRETES SIGN'
'\rETROFLEX HOOK'
'\nETTA-PILLA'
'\x06ETTER '
'\x05ETTI '
'\x02EU'
'\x04EUCH'
'\x07EULEUNG'
'\x04EUNG'
'\nEUR-DE-LIS'
'\nEUTRAL YER'
'\x03EUX'
'\x03EVA'
'\nEVANAGARI '
'\x03EVE'
'\x04EVEN'
'\x05EVEN '
'\x08EVEN OF '
'\x13EVEN POWERS OF FOUR'
'\x05EVENT'
'\x08EVENTEEN'
'\x12EVENTEEN FULL STOP'
'\x06EVENTH'
'\x06EVENTY'
'\x08EVERANCE'
'\x0eEVERSE SOLIDUS'
'\x08EVERSED '
'\rEVERSED DAMMA'
'\x1dEVERSED LUNATE EPSILON SYMBOL'
'\nEVERSED PE'
'\x14EVERSED ROTATED RANA'
'\x10EVERSED VISARGA '
'\x04EVMA'
'\x02EW'
'\rEWDATA SQUARE'
'\x0bEXCLAMATION'
'\x10EXCLAMATION MARK'
'\x06EXISTS'
'\x0fEXPONENT SYMBOL'
'\x03EXT'
'\x1cEXTENDED ARABIC-INDIC DIGIT '
'&EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE'
'&EXTENDED ARABIC-INDIC DIGIT FOUR BELOW'
'\x1dEXTENDED ARABIC-INDIC DIGIT T'
'\tEXTENSION'
'\x1aEXTRA-LOW CONTOUR TONE BAR'
'\x02EY'
'\x06EYANNA'
'\x05EYYAL'
'\x03EZH'
'\x03EZI'
'\x04EZZO'
'\x01F'
'\x06F CLEF'
'\x05F COW'
'\x07F DAVID'
'\x05F EWE'
'\x06F MARE'
'\x07F SASAK'
'\nF SHE-GOAT'
'\x05F SOW'
'\x08F SYMBOL'
'\x0cF TREE TRUNK'
'\x07F WITH '
'\x02F0'
'\x03F14'
'\x02F3'
'\x03F8C'
'\x02FA'
'\x05FAAFU'
'\x12FACING SVASTI SIGN'
'\nFAHRENHEIT'
'\x05FAIHU'
'\x10FALLING DIAGONAL'
'\x0cFALLING DOTS'
'\x06FAMILY'
'\x05FATHA'
'\x06FATHA '
'\x07FAYANNA'
'\x02FE'
'\x05FEARN'
'\x0cFEATHER MARK'
'\nFEATHERED '
'\x08FEBRUARY'
'\x19FECTIVENESS OR DISTORTION'
'\x03FEE'
'\x03FEH'
'\tFEH WITH '
'\x0eFEHU FEOH FE F'
'\x0bFEMALE SIGN'
'\x0cFEMININE DOT'
'\x05FENCE'
'\x0cFERENCE MARK'
'\x06FF OF '
'\x10FFERENCE BETWEEN'
'\nFFICULTIES'
'\x19FFICULTY AT THE BEGINNING'
'\x04FFIN'
'\x0bFGHANI SIGN'
'\x03FHA'
'\x02FI'
'\x05FIFTH'
'\x06FIFTHS'
'\x05FIFTY'
'\x06FILLER'
'\x03FIN'
'\x07FINAGH '
'\x06FINAL '
'\nFINAL FORM'
'\rFINAL LETTER '
'\tFINAL MEM'
'\tFINAL NGA'
'\rFINAL SEMKATH'
'\x0bFINAL SIGMA'
'\x08FINAL TH'
'\x07FINAL Y'
'\x04FIRE'
'\tFISH TAIL'
'\x08FISHHOOK'
'\x05FISTO'
'\x04FITA'
'\x04FIVE'
'\x12FIVE EIGHTHS BLOCK'
'\x0cFIVE HUNDRED'
'\x0bFIXED-FORM '
'\rFIXED-FORM RA'
'\x02FL'
'\x05FLAKE'
'\x04FLAT'
'\tFLAT SIGN'
'\nFLATTENED '
'\x16FLATTENED OPEN A ABOVE'
'\x15FLATTENED PARENTHESIS'
'\x05FLICT'
'\x13FLORAL HEART BULLET'
'\x08FLOURISH'
'\x07FLUENCE'
'\x05FLUTE'
'\x02FO'
'\x03FO '
'\x06FONIAS'
'\x05FORCE'
'\x04FORE'
'\rFOREMENTIONED'
'\x04FORK'
'\x12FORKED PARAGRAPHOS'
'\x07FORKING'
'\x14FORMS LIGHT VERTICAL'
'\x04FOUR'
'\x1cFOUR BALLOON-SPOKED ASTERISK'
'\nFOUR BELOW'
'\tFOUR DOTS'
'\x0fFOUR DOTS ABOVE'
'\x0bFOURTH ROOT'
'\tFRACTION '
'\x0fFRACTION DIGIT '
'\x08FRAKTUR '
'\x08FRICAN D'
'\x08FROM BAR'
'\x05FSAAQ'
'\x02FT'
'\x03FT '
'\x0cFT RERENGGAN'
'\x05FTEEN'
'\x0fFTER COMPLETION'
'\x1cFTING POINT RIGHTWARDS ARROW'
'\nFTOGGOS OU'
'\rFTWARDS ARROW'
'\x03FTY'
'\tFULL STOP'
'\rFULL SURROUND'
'\x03FWA'
'\x04FWAA'
'\x01G'
'\x02G '
'\tG IN HOLE'
'\x12G WITH TILDE ABOVE'
'\x05G YUS'
'\x02G0'
'\x02G2'
'\x02G3'
'\x02G9'
'\x02GA'
'\x10GAAHLAA TTUDDAAG'
'\x03GAB'
'\x03GAD'
'\x19GAD OVER GAD GAR OVER GAR'
'\x05GADOL'
'\x03GAG'
'\x04GAIN'
'\x03GAL'
'\x05GALGA'
'\x05GALI '
'\x05GAMAL'
'\x05GAMAN'
'\x04GAML'
'\x05GAMMA'
'\x04GAN2'
'\tGAN2 TENU'
'\nGANDA MARK'
'\x06GANGIA'
'\x13GAPPED CIRCLE ARROW'
'\x03GAR'
'\x08GARITIC '
'\nGAS BZUNG '
'\x03GAT'
'\x12GATIVE ACKNOWLEDGE'
'\x0cGAW KAREN EU'
'\rGAW KAREN SHA'
'\x03GAY'
'\x07GAYANNA'
'\x0bGAYANUKITTA'
'\x02GB'
'\x03GBA'
'\nGBAKURUNEN'
'\x08GBASINNA'
'\x02GE'
'\x07GE SIGN'
'\x06GEADAL'
'\x0cGEBA KAREN I'
'\x03GED'
'\x04GEDE'
'\x06GEDOLA'
'\x11GENERIC MATERIALS'
'\x08GENITIVE'
'\x0bGENTLE WIND'
'\x03GER'
'\x0eGERED TREMOLO-'
'\x04GESH'
'\x05GESH2'
'\x02GG'
'\x04GGER'
'\nGGRAVATION'
'\x04GGWS'
'\x0fGH VOLTAGE SIGN'
'\x03GHA'
'\x0bGHAIN WITH '
'\x06GHAMAL'
'\x03GHE'
'\x04GHOM'
'\x03GHT'
'\rGHT ARROWHEAD'
'\rGHT HALF RING'
'\x0cGHT OPEN BOX'
'\x15GHT OPEN BOX OPERATOR'
'\x0fGHT REPEAT SIGN'
'\x18GHT TRIFOLIATE SNOWFLAKE'
'\x14GHTWARDS ARROW BELOW'
'\x05GHULU'
'\x06GHUNNA'
'\x04GHWA'
'\x02GI'
'\x07GI GUNU'
'\x0cGI MGO RGYAN'
'\x04GIBA'
'\x06GICAL '
'\x04GIDA'
'\x05GIMEL'
'\x08GINAL OF'
'\x07GINESE '
'\x03GIR'
'\x04GISH'
'\rGISTERED SIGN'
'\x04GIT '
'\tGITTARIUS'
'\x07GLAGOLI'
'\x06GLAZ H'
'\x04GLE '
'\x0bGLE BRACKET'
'\x0cGLOTTAL STOP'
'\x18GLOTTAL STOP WITH STROKE'
'\x05GMENT'
'\x02GN'
'\x03GNO'
'\x02GO'
'\x06GO NGU'
'\x04GOAL'
'\x05GOGI '
'\x07GOLIAN '
'\x0cGONAL STROKE'
'\x05GONEK'
'\x04GONG'
'\x04GORG'
'\x05GORGI'
'\x06GORGON'
'\x04GORT'
'\x03GOU'
'\x02GR'
'\x14GRA GCAN -CHAR RTAGS'
'\x04GRAL'
'\tGRAM FOR '
'\x0bGRAMMA SIGN'
'\x15GRAMMOS OKTO DODEKATA'
'\x05GRAPH'
'\x08GRAPH UK'
'\x05GRAVE'
'\x0cGRAVE ACCENT'
'\x0bGRAVE-ACUTE'
'\x08GREAT SA'
'\tGREATER Y'
'\x0cGREATER-THAN'
'$GREATER-THAN ABOVE DOUBLE-LINE EQUAL'
'\x1eGREATER-THAN ABOVE EQUALS SIGN'
'\x16GREATER-THAN DIAERESIS'
'\x11GREATER-THAN NOR '
'\x18GREATER-THAN OR EQUAL TO'
'\x11GREATER-THAN SIGN'
'\x05GREE '
'\nGREE SLASH'
'\x0bGREEK CROSS'
'\x17GREEK SMALL LETTER IOTA'
'\x0cGREEN DRAGON'
'\tGRIK SIGN'
'\x0fGROUP SEPARATOR'
'\x04GRU '
'\x15GRUENT WITH DOT ABOVE'
'\x02GS'
'\x06GS-PA '
'\x0bGSUM -KHYIL'
'\rGTER TSHEG MA'
'\x03GUD'
'\x04GUNU'
'\x06GURAMU'
'\x05GURE '
'\x0cGXI RADICAL '
'\rGYA GRAM SHAD'
'\x13GYPTIAN HIEROGLYPH '
'\x0eGYPTOLOGICAL A'
'\x01H'
'\x02H '
'\x06H NOTE'
'\rH-TYPE SYMBOL'
'\x03H00'
'\x02HA'
'\x03HAA'
'\x05HAALU'
'\nHAAPRAANA '
'\x07HAARKAA'
'\x03HAD'
'\x05HADDA'
'\x04HADE'
'\x1cHADED WHITE RIGHTWARDS ARROW'
'\x14HADOWED WHITE SQUARE'
'\x08HAGALL H'
'\x0bHAGGAR YAZH'
'\x03HAH'
'\x04HAH '
'\x05HAH I'
'\x10HAH INITIAL FORM'
'\x11HAH ISOLATED FORM'
'\tHAH WITH '
'\x04HAIN'
'\x05HAINU'
'\x04HAIR'
'\rHAKASSIAN CHE'
'\x03HAL'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x07HALF BL'
'\nHALF BLACK'
'\x0cHALF BRACKET'
'\x0fHALF FILL SPACE'
'\rHALF INTEGRAL'
'\tHALF RING'
'\tHALSHELET'
'\x03HAM'
'\x04HAM '
'\x06HAM AI'
'\rHAM DIGIT ONE'
'\x06HAMZA '
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAN '
'\nHAN DIGIT '
'\x08HAN-AKAT'
'\x15HAND INTERIOR PRODUCT'
'\x05HANGE'
'\x07HANGUL '
'\x17HANKED RIGHTWARDS ARROW'
'\x05HANNA'
'\x03HAR'
'\x04HAR2'
'\x14HAR2 TIMES GAL PLUS '
'\tHARACTER '
'\tHARACTERS'
'\x08HARMONIC'
'\x06HARP S'
'\x08HARPOON '
'\x12HARPOON WITH BARB '
'\x1bHARPOON WITH BARB DOWNWARDS'
'\x07HASANTA'
'\x0cHASIS SYMBOL'
'\x05HATHI'
'\x04HAVE'
'\x08HAVIYANI'
'\x07HAYANNA'
'\x04HAYN'
'\x02HE'
'\x03HE '
'\x06HE MGO'
'\x04HEAD'
'\x05HEAD '
'\x07HEADING'
'\nHEADSTROKE'
'\x05HEART'
'\x1fHEART EXCLAMATION MARK ORNAMENT'
'\x04HEAT'
'\x06HEAVEN'
'\x0bHEAVEN MARK'
'\x05HEAVY'
'\x06HEAVY '
'\nHEAVY AND '
'\x0fHEAVY AND LEFT '
'\x10HEAVY AND RIGHT '
'\nHEAVY BEAT'
'\x18HEAVY BLACK HEART BULLET'
'\x03HEE'
'\x04HEEN'
'\x04HEEP'
'\x08HEG SHAD'
'\x03HEH'
'\x0fHEH MEDIAL FORM'
'\x06HEISEI'
'\x04HELL'
'\x03HEN'
'\x03HER'
'\rHERICAL ANGLE'
'\x06HERMES'
'\x04HERU'
'\x06HESHIG'
'\x08HESPIAN '
'\x05HESS '
'\x04HETA'
'\x04HETH'
'\x05HETHE'
'\x16HEXIFORM LONG ANUSVARA'
'\x03HHA'
'\x02HI'
'\x05HI RO'
'\x07HI SIGN'
'\tHI SYMBOL'
'\x0cHI TIMES BAD'
'\x06HIBIT '
'\x03HID'
'\x04HID '
'\x05HIDET'
'\x06HIEUCH'
'\x05HIEUH'
'\x06HIEUKH'
'\x06HIEUPH'
'\x06HIEUTH'
'\x05HIFT '
'\x05HIGH '
'\x14HIGH RATHA OR LOW PA'
'\x10HIGH SPACING DOT'
'\tHIGH STOP'
'\x0bHIGH STROKE'
'\tHIGH TONE'
'\x14HIGH TONE APOSTROPHE'
'\x1eHIGH-REVERSED-9 QUOTATION MARK'
'\x04HIIN'
'\x04HILD'
'\tHIMA SIMA'
'\x03HIN'
'\x07HIN DOT'
'\rHINESE TONE Y'
'\x03HIP'
'\x04HIRD'
'\x05HIRIQ'
'\x04HIRT'
'\x07HIRTEEN'
'\x11HIRTEEN FULL STOP'
'\x05HIRTY'
'\x05HISTI'
'\x03HIT'
'\x05HITE '
'\nHITE ARROW'
'\x1bHITE DOWN-POINTING TRIANGLE'
'\x0bHITE DRAGON'
'\x05HIUTH'
'\x04HIVE'
'\x06HIVETE'
'\tHIYYAALAA'
'\x0bHJONG TILE '
'\x06HLAVI '
'\x02HM'
'\x07HM SIGN'
'\x10HMATULLAH ALAYHE'
'\x02HO'
'\x03HO '
'\x06HO HOI'
'\nHOGI PIECE'
'\x04HOKE'
'\x05HOLAM'
'\x05HOLAR'
'\x10HOLDING TOGETHER'
'\x05HOLE '
'\x04HOOK'
'\nHOOK ABOVE'
'\x0bHOOK SYMBOL'
'\x0bHORA DIGIT '
'\x04HORI'
'\nHORIZONTAL'
'\x0eHORIZONTAL BAR'
'\x14HORIZONTAL BAR WITH '
'\x0fHORIZONTAL DASH'
'\x11HORIZONTAL DOUBLE'
'\x13HORIZONTAL ELLIPSIS'
'\x0fHORIZONTAL FILL'
'\x10HORIZONTAL HEAVY'
'\x10HORIZONTAL LIGHT'
'\x11HORIZONTAL SINGLE'
'\x11HORIZONTAL STROKE'
'\x15HORIZONTAL TABULATION'
'\x12HORIZONTALLY BELOW'
'\x04HORN'
'\x05HORSE'
'\x05HORT '
'\x06HORT A'
'\x16HORT HORIZONTAL STROKE'
'\nHORT-TWIG-'
'\x04HOST'
'\tHOT SASAK'
'\nHOTIC HOOK'
'\x03HOU'
'\x05HOUR '
'\x07HOUSAND'
'\x15HOUSAND MILLIONS SIGN'
'\x0fHOUSAND STATERS'
'\x12HOUSANDS SEPARATOR'
'\x05HREAD'
'\x04HREE'
'\x05HREE '
'\nHREE ABOVE'
'\x0bHREE BALUDA'
'\tHREE DOTS'
'\nHREE DOTS '
'\x0fHREE DOTS ABOVE'
'\x19HREE DOTS ABOVE DOWNWARDS'
'\x0fHREE DOTS BELOW'
'\tHREE FOR '
'\x08HREE OF '
'\x07HROUGH '
'\x03HSA'
'\x04HSDA'
'\x04HSHU'
'\x1aHTORA SKLIRON CHROMA VASIS'
'\x02HU'
'\x04HUEN'
'\x03HUK'
'\x07HUNDRED'
'\x08HUNDRED '
'\x03HUR'
'\x06HUR PA'
'\x13HURISAZ THURS THORN'
'\x02HV'
'\x02HW'
'\x03HWA'
'\x04HWAA'
'\tHWAZ EH E'
'\x07HYAAUSH'
'\x06HYPHEN'
'\x0cHYPHEN-MINUS'
'\x02HZ'
'\x01I'
'\x02I '
'\nI ARCHAION'
'\x05I KOI'
'\rI LENGTH MARK'
'\x06I MAIM'
'\tI PLUS LI'
'\x07I RTAGS'
'\x08I SHAKTI'
'\x08I SYMBOL'
'\x0bI TIMES NUN'
'\rI WITH STROKE'
'\x16I YFESIS TETARTIMORION'
'\x03I-I'
'\x02I0'
'\x02IA'
'\x08IAERESIS'
'\x08IAGONAL '
'\x0eIAGONAL STROKE'
'\x03IAL'
'\tIALECT-P '
'\x08IALYTIKA'
'\tIALYTIKA '
'\x06IAMOND'
'\x0fIAMOND UNDERBAR'
'\x0bIAN LETTER '
'\x05IANCE'
'\x06IANGLE'
'\x1aIANGLE BESIDE VERTICAL BAR'
'&IANGLE CONTAINING SMALL WHITE TRIANGLE'
'\x04IANO'
'\x04IARA'
'\x06IASMA '
'\x05IAUDA'
'\x04IBE '
'\x07IBIFILI'
'\x0bIBLE-CREE Y'
'\x02IC'
'\nICAL TAPER'
'\x03ICE'
'\x05ICHON'
'\x05ICHOS'
'\x05ICRON'
'\x13ICTLY EQUIVALENT TO'
'\x02ID'
'\nIDDLE MARK'
'\x0bIDDLE TILDE'
'\x0cIDDLE-WELSH '
'\x03IDE'
'\x1bIDE ARC ANTICLOCKWISE ARROW'
'\x17IDE ARC CLOCKWISE ARROW'
'\x1bIDE-HEADED RIGHTWARDS ARROW'
'\x0cIDENTICAL TO'
'\tIDEOGRAM '
'\nIDEOGRAPH '
'\x0cIDEOGRAPHIC '
'\x11IDEOGRAPHIC COMMA'
'\x1aIDEOGRAPHIC ITERATION MARK'
'\x08IDEWAYS '
'\tIDEWAYS U'
'\x05IDGE '
'\nIDGE BELOW'
'\x0fIDING ENCLOSURE'
'\x02IE'
'\x03IER'
'\x03IES'
'\x04IEUC'
'\x05IEUNG'
'\x04IEUP'
'\x04IFAT'
'\x03IFF'
'\x06IFIED '
'\rIFIER LETTER '
'\x03IFT'
'\x06IFTEEN'
'\x10IFTEEN FULL STOP'
'\x04IFTY'
'\x02IG'
'\x06IG YUS'
'\x03IG4'
'\x06IGAMMA'
'\x08IGATURE '
'\x16IGEL LONG-BRANCH-SOL S'
'\x04IGER'
'\x0bIGGLY FENCE'
'\x03IGH'
'\x04IGH '
'\tIGH HAMZA'
'\x04IGHT'
'\x05IGHT '
'\tIGHT DOWN'
'\x08IGHT OF '
'\x07IGHTEEN'
'\x11IGHTEEN FULL STOP'
'\x06IGHTH '
'\tIGHTH ASH'
'\x0eIGHTWARDS TICK'
'\x0eIGHTWARDS VANE'
'"IGHUR KAZAKH KIRGHIZ ALEF MAKSURA '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x04IGMA'
'\x03IGN'
'\x04IGN '
'\x02IH'
'\x03IHI'
'\x05IHVUS'
'\x02II'
'\x03II '
'\x04IITO'
'\x02IJ'
'\x04IK H'
'\x05IKARA'
'\x05IKEUT'
'\x07IKHAHIT'
'\x04IKRI'
'\nIKRON ISON'
'\x03IKU'
'\x05IKURU'
'\x02IL'
'\x0bIL FRAGMENT'
'\x06ILBOAT'
'\x0bILCROW SIGN'
'\x04ILDE'
'\x03ILE'
'\rILE SEPARATOR'
'\tILE TILDE'
'\nILING FACE'
'\tILIPPINE '
'\x0bILIQUA SIGN'
'\x03ILK'
'\x06ILLAGE'
'\x07ILLEANN'
'\x05ILLU '
'\x04ILUY'
'\x02IM'
'\x03IM5'
'\x03IMA'
'\rIMAGE BRACKET'
'\x14IMAGE OF OR EQUAL TO'
'\x08IMANSIS '
'\x03IME'
'\x04IMEL'
'\x0bIMEL SYMBOL'
'\x10IMENSIONAL ANGLE'
'\x04IMES'
'\x05IMES '
'\x13IMIDIA SEXTULA SIGN'
'\x07IMILAR '
'\x0fIMISEOS CHRONOU'
'\x05IMMA '
'\nIMPERFECTA'
'\x0fIMPERFECTA REST'
'\x1bIMPERFECTUM CUM PROLATIONE '
'\x02IN'
'\x03IN '
'\x13IN CHEN SPUNGS SHAD'
'\x16IN DEPARTING TONE MARK'
'\x06IN DOT'
'\x0bIN EQUAL TO'
'\x08IN SPACE'
'\tIN SQUARE'
'\x0bIN TRIANGLE'
'\x1fIN WHITE CIRCLE IN BLACK SQUARE'
'\x08IN WITH '
'\x03IN2'
'\x06INAGMA'
'\nINAL SIGMA'
'\x04INAP'
'\x06INCUNX'
'\x03IND'
'\x13INDEPENDENT SVARITA'
'\x12INDEPENDENT VOWEL '
'\x0bINDERGARTEN'
'\x06INDHI '
'\x06INDIC '
'\x0bINDICESIMA '
'\x16INDIRECT QUESTION MARK'
'\x1aINDUSTRIAL STANDARD SYMBOL'
'\x03INE'
'\tINE BELOW'
'\x07INE OF '
'\x11INEAR ANNOTATION '
'\x04INES'
'\x10INES CONVERGING '
'\x06INESE '
'\x03ING'
'\tING ABOVE'
'\tING LANES'
'\nING LARGE '
'\x0cING OPERATOR'
'\x08ING ROD '
'\x0fING SYMBOL FOR '
'\x06INGAAT'
'\x06INGLE '
'\x0fINGLE HEAD MARK'
'\x05INGSA'
'\x04INGU'
'\nINHERENT A'
'\x03INI'
'\x05INIMA'
'\x17ININE ORDINAL INDICATOR'
'\x14INING OBLIQUE STROKE'
'\tINISHMENT'
'\x0cINITIAL FORM'
'\x05INITY'
'\x06INKING'
'\x04INOR'
'\x03INS'
'\x06INSHIP'
'\x06INSIDE'
'\x1dINSTRUMENTAL NOTATION SYMBOL-'
'\tINSULAR G'
'\x04INTE'
'\x08INTEGRAL'
'\x11INTEGRAL OPERATOR'
'\x0bINTEGRATION'
'\x0cINTEGRATION '
'\x05INTER'
'\x14INTERPOLATION MARKER'
'\x0bINTERROBANG'
'\x15INTERSECTING LOGICAL '
'\x0cINTERSECTION'
'\x15INTERSECTION OPERATOR'
'\x18INTERSECTION WITH SERIFS'
'\x05INTHU'
'\x04INTO'
'\x0bINTO SHRINE'
'\x03INU'
'\x05INU P'
'\x17INUOUS UNDERLINE SYMBOL'
'\x04INUS'
'\x0fINUS SIGN BELOW'
'\x14INVERSE WHITE CIRCLE'
'\x08INVERTED'
'\tINVERTED '
'\x0eINVERTED BREVE'
'\x14INVERTED CANDRABINDU'
'\x0eINVERTED DAMMA'
'\x19INVERTED EXCLAMATION MARK'
'\rINVERTED FORK'
'\x15INVERTED GLOTTAL STOP'
'\x16INVERTED SMALL V ABOVE'
'\x16INVERTED SMALL V BELOW'
'\rINVERTED TURN'
'\nINVERTED V'
'\x03ION'
'\x08ION SIGN'
'\x0bIOR PRODUCT'
'\x03IOS'
'\x04IOTA'
'\x02IP'
'\x03IP '
'\x07IP SIGN'
'\x05IPEHA'
'\x05IPING'
'\x0bIPLE TONGUE'
'\x04IPOD'
'\x04IPT '
'\x04IQAA'
'\x02IR'
'\x08IR SPACE'
'\x08IRA SIGN'
'\x0cIRAGANA HOKA'
'\x05IRAMA'
'\x03IRC'
'\x05IRCLE'
'\x06IRCLE '
'\x10IRCLE X NOTEHEAD'
'\x07IRCLED '
'\x06IRCLES'
'\tIRCUMFLEX'
'\x10IRCUMFLEX ACCENT'
'\x0fIRCUMFLEX BELOW'
'\x08IRD MARK'
'\x03IRE'
'\x04IRED'
'\x04IRGA'
'\x07IRGHIZ '
'\x03IRI'
'\x06IRINGU'
'\x04IRIQ'
'\x04IRIT'
'\x03IRO'
'\x07IRPLANE'
'\tIRST MARK'
'\x0cIRST SUBUNIT'
'\x03IRT'
'\x06IRTEEN'
'\x04IRTY'
'\x0cIRTY-SECOND '
'\x03IRU'
'\x02IS'
'\x08IS-PILLA'
'\x06ISELEH'
'\tISEN-ISEN'
'\x03ISH'
'\x08ISH TAIL'
'\x04ISI '
'\x07ISIBLE '
'\x0bISIGOTHIC Z'
'\x1cISMILLAH AR-RAHMAN AR-RAHEEM'
'\rISOLATED FORM'
'\x06ISSHAR'
'\x06ISSIMO'
'\x05ISTLE'
'\x10ISTOS DISC SIGN '
'\x02IT'
'\x03IT '
'\x03ITA'
'\x0eITA PLUS GISH '
'\x06ITABLE'
'\x07ITALIC '
'\x03ITE'
'\x13ITED LIABILITY SIGN'
'\x04ITEM'
'\x0eITERATION MARK'
'\x04ITH '
'\x0fITH FINGERNAILS'
'\x06ITHER '
'\x05ITHI '
'\x06ITIAL '
'\x05ITING'
'\nITING HAND'
'\rITING THROUGH'
'\x0fITION INDICATOR'
'\x04ITLO'
'\x05ITON '
'\x07ITON RA'
'\tITRA SIGN'
'\x04ITSA'
'\tITTLE YUS'
'\x03ITU'
'\x05ITUAL'
'\x03ITY'
'\nIVALENT TO'
'\x05IVATE'
'\x03IVE'
'\x04IVE '
'\x0eIVE KEY SYMBOL'
'\x0eIVE OBOLS SIGN'
'\x07IVE OF '
'\x10IVE POINTED STAR'
'\rIVE SLOW SIGN'
'\tIVINATION'
'\x07IVISION'
'\x0eIWAZ TIR TYR T'
'\x03IWN'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x06IX OF '
'\x03IXT'
'\x06IXTEEN'
'\x04IXTH'
'\nIXTHS DISH'
'\x04IXTY'
'\x06IYANNA'
'\x05IYEOK'
'\x01J'
'\x02JA'
'\x05JANG '
'\x07JARATI '
'\x08JAVIYANI'
'\x07JAYANNA'
'\x02JE'
'\x1aJECT REPLACEMENT CHARACTER'
'\x0bJECT SYMBOL'
'\x07JECTIVE'
'\x03JEE'
'\x04JEEM'
'\x05JEEM '
'\x06JEEM I'
'\x11JEEM INITIAL FORM'
'\x12JEEM ISOLATED FORM'
'\x07JEGOGAN'
'\x04JEON'
'\x03JER'
'\x07JERAN J'
'\tJERUSALEM'
'\x04JERV'
'\x05JERVI'
'\rJES SU NGA RO'
'\x03JEU'
'\x03JHA'
'\x07JIBWAY '
'\x0bJIHVAMULIYA'
'\x03JK '
'\x06JOINED'
'\x0eJOINED SQUARES'
'\x06JOINER'
'\x05JOKER'
'\x04JONG'
'\x03JOT'
'\x04JOT '
'\x03JOY'
'\x0bJOYOUS LAKE'
'\x14JUDEO-SPANISH VARIKA'
'\x05JUDGE'
'\x06JUDIJE'
'\x05JUEUI'
'\x08JUNCTION'
'\x01K'
'\x03K00'
'\x02K2'
'\nK2 PLUS BU'
'\x02K4'
'\x02KA'
'\tKA- SHOG '
'\x04KAAF'
'\x03KAB'
'\tKABA TENU'
'\x04KAD3'
'\x03KAF'
'\nKAI SYMBOL'
'\x03KAK'
'\x04KAKO'
'\x03KAL'
'\x0cKANA REPEAT '
'\x04KANG'
'\x12KANTAJA NAASIKYAYA'
'\x04KAPA'
'\x04KAPH'
'\x05KAPPA'
'\x0cKAPPA SYMBOL'
'\rKAPYEOUNPIEUP'
'\x04KARA'
'\x06KASKAL'
'\x05KASRA'
'\x08KATAKANA'
'\x12KATAKANA-HIRAGANA '
'\x1bKATHAKA INDEPENDENT SVARITA'
'\x04KATO'
'\x04KAUN'
'\x06KAVYKA'
'\x03KAY'
'\x06KAYAH '
'\x07KAYANNA'
'\x12KBAR ISOLATED FORM'
'\x04KCET'
'\x02KE'
'\x06KE PHO'
'\x16KEEPING STILL MOUNTAIN'
'\x04KEMP'
'\tKEMPHRENG'
'\x05KERET'
'\x03KET'
'\x06KEYCAP'
'\nKFONITIKON'
'\x02KH'
'\x05KHAH '
'\x06KHAH I'
'\x11KHAH INITIAL FORM'
'\x0cKHAMTI TONE-'
'\x05KHAPH'
'\x07KHIEUKH'
'\x0cKHMIMIC KHEI'
'\x02KI'
'\x04KICK'
'\x03KIN'
'\x04KING'
'\x0fKISIM5 TIMES BI'
'\x06KIYEOK'
'\x06KLITON'
'\x05KNIFE'
'\x06KNIFE '
'\x02KO'
'\x03KO '
'\x05KO LA'
'\x04KOET'
'\x07KOMBUVA'
'\x03KON'
'\x03KOO'
'\x05KOPPA'
'\x07KOQNDON'
'\x12KOREAN CHARACTER O'
'\x07KORONIS'
'\x03KOT'
'\x08KOUFISMA'
'\x06KRISIS'
'\x02KS'
'\tKSTREPTON'
'\x0bKTIESELSKAB'
'\x06KTIKO '
'\x02KU'
'\tKU RU KHA'
'\x03KUN'
'\x03KUR'
'\x04KURO'
'\x05KURON'
'\x06KUSHU2'
'\x05KUSMA'
'\x07KUTAARU'
'\x03KUU'
'\x02KW'
'\x04KWAA'
'\x05KWAEN'
'\x07KYLISMA'
'\x01L'
'\x02L '
'\x14L FUNCTIONAL SYMBOL '
'\x07L SEGNO'
'\x05L TAG'
'\x0bL TIMES LAL'
'\x08L-LAKUNA'
'\rL-TYPE SYMBOL'
'\x02L0'
'\x03L00'
'\x02L2'
'\x02LA'
'\x08LA LENGA'
'*LA USED AS KORANIC STOP SIGN ISOLATED FORM'
'\x03LA3'
'\x04LAAN'
'\x05LABAT'
'\x07LABIAL '
'\x05LABOR'
'\x0eLACE OF SAJDAH'
'\x04LACK'
'\x05LACK '
'\x0cLACK DIAMOND'
'\x0cLACK HEXAGON'
'\tLACKFOOT '
'\x06LAFRON'
'\x03LAG'
'\x05LAGAB'
' LAGAB TIMES U OVER LAGAB TIMES U'
'\nLAGAR GUNU'
'\x0cLAGAR TIMES '
'\x07LAGIOS '
'\x05LAGUS'
'\x11LAH ISOLATED FORM'
'\x03LAI'
'\x04LAKE'
'\x03LAL'
'\x03LAM'
'\x04LAM '
'\tLAM WITH '
'\x06LAMADH'
'\tLAMATION '
'\x04LAMD'
'\x05LAMDA'
'\x05LAMED'
'\x06LAMEDH'
'\nLANE MERGE'
'3LANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL'
'0LANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL'
'\x11LAPPING LESS-THAN'
'\tLARGEMENT'
'\x03LAS'
'\x04LASH'
'\x08LASH BAR'
'\x05LASMA'
'\x06LASTON'
'\x04LAT '
'\x0cLATALIZATION'
'\rLATERAL CLICK'
'\x05LATIK'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x16LATIN CAPITAL LETTER S'
'\x0bLATIN CROSS'
'\x0fLATION FUNCTION'
'\x07LAYANNA'
'\x05LAYAR'
'\x06LAZY S'
'\x02LC'
'\nLCROW SIGN'
'\x02LD'
'\x03LD '
'\x10LD ASSYRIAN ONE '
'\x03LDE'
'\x02LE'
'\x03LE '
'\nLE LETTER '
'\nLE-DELAYED'
'\x06LEADER'
'\x05LEASE'
'\x03LEF'
'\x04LEF '
'\x04LEFT'
'\x05LEFT '
'\tLEFT AND '
'\x14LEFT AND LOWER RIGHT'
'\x10LEFT ARROW ABOVE'
'\x18LEFT DIAGONAL HALF BLACK'
'\x0bLEFT DOUBLE'
'\x0fLEFT DOWN BARB '
'\tLEFT HALF'
'\x0fLEFT HALF BLACK'
'\x10LEFT HALF CIRCLE'
'\x0eLEFT HALF RING'
'\x0cLEFT HARPOON'
'\nLEFT HEAVY'
'\tLEFT HOOK'
'\nLEFT LIGHT'
'\x10LEFT PARENTHESIS'
'\x19LEFT PARENTHESIS ORNAMENT'
'\rLEFT QUADRANT'
'\x0bLEFT SINGLE'
'\tLEFT TACK'
'\x08LEFT TO '
'\x13LEFT TO LOWER RIGHT'
'$LEFT TORTOISE SHELL BRACKET ORNAMENT'
'\rLEFT TRIANGLE'
'\x16LEFT TRIANGLE OPERATOR'
'\x0eLEFT TURNSTILE'
'\nLEFT-HAND '
'\x12LEFT-STEM TONE BAR'
'\tLEFTWARDS'
'\x0fLEFTWARDS ARROW'
'\x19LEFTWARDS ARROW WITH HOOK'
'\x1cLEFTWARDS OF DOWNWARDS ARROW'
'\x1aLEFTWARDS OF UPWARDS ARROW'
'\x0eLEFTWARDS TICK'
'\rLEGETOS ICHOS'
'\x04LEIA'
'\nLEK ATTAK '
'\x07LEK TOO'
'\x06LEMENT'
'\tLEMENT OF'
'\nLENDED YUS'
'\x0bLENGTH MARK'
'\x05LENIS'
'\x0eLENTICULAR BRA'
'\x12LENTICULAR BRACKET'
'\x04LEPH'
'\x0cLER CONSTANT'
'\x08LESS SHA'
'\tLESS-THAN'
'!LESS-THAN ABOVE DOUBLE-LINE EQUAL'
'\x1bLESS-THAN ABOVE EQUALS SIGN'
'\x0eLESS-THAN NOR '
'\x15LESS-THAN OR EQUAL TO'
'\x08LESSER Y'
'\nLET SYMBOL'
'\x04LETE'
'\x04LETH'
'\x07LETTER '
'\x0fLETTER CAPITAL '
'\x15LETTER SMALL CAPITAL '
'\x07LEUT KA'
'\x0fLEVEL TONE MARK'
'\x05LEVEN'
'\x0fLEVEN FULL STOP'
'\x02LF'
'\x03LF '
'\x08LF RING '
'\x03LFA'
'\x08LFWIDTH '
'\nLGIZ EOLHX'
'\x02LH'
'\x03LHA'
'\nLHAG RTAGS'
'\x02LI'
'\x08LI GALI '
'\x05LIDUS'
'\x04LIFI'
'\x04LIFU'
'\x05LIGHT'
'\nLIGHT AND '
'\x0fLIGHT AND LEFT '
'\x10LIGHT AND RIGHT '
'\nLIGHT BEAT'
'\x06LIGION'
'\x06LIGON '
'\nLIMITATION'
'\nLINDRICITY'
'\x04LINE'
'\x05LINE '
'\nLINE BELOW'
'\x0eLINE EXTENSION'
'\tLINE FEED'
'\x1aLINE FEED SEPARATOR SYMBOL'
'\x18LINE HORIZONTAL ELLIPSIS'
'\nLINE STAFF'
'\x04LING'
'\x0cLINGING FIRE'
'\x0cLINKING MARK'
'\x14LIQUE ANGLE OPENING '
'\x1cLIQUID MEASURE FIRST SUBUNIT'
'\x04LISH'
'\x06LISHA '
'\tLISSANDO '
'\x06LITIKI'
'\x0eLITTLE SECTION'
'\nLITTLE YUS'
'\x04LIUM'
'\tLIVERANCE'
'\x04LIWN'
'\x03LJE'
'\x02LK'
'\x03LK '
'\x02LL'
'\x07LL SIGN'
'\tLL SYMBOL'
'\x03LLA'
'\x07LLABLE '
'\tLLABLE B0'
'\tLLABLE OM'
'\x16LLAHOU ALAYHE WASALLAM'
'\x1aLLALLAHOU ALAYHE WASSALLAM'
'\tLLAR SIGN'
'\x05LLEL '
'\x04LLET'
'\x07LLIANCE'
'\x0fLLING DIAGONAL '
'\x03LLO'
'\x07LLOWING'
'\x02LM'
'\x0eLMOST EQUAL TO'
'\x0fLMOST EQUAL TO '
'\x02LO'
'\rLOCATION SIGN'
'\x08LOCATIVE'
'\tLOCKWISE '
'\x08LOGICAL '
'\x0bLOGICAL AND'
'\nLOGICAL OR'
'\x04LOLL'
'\x03LON'
'\x0bLON SKEWED '
'\x05LONG '
'\rLONG ANUSVARA'
'\x08LONG BAR'
'\x06LONG E'
'\x16LONG HORIZONTAL STROKE'
'\x08LONG LEG'
'\nLONG OVER '
'\x08LONG S T'
'\x0fLONG VOWEL SIGN'
'\x03LOO'
'\x04LOOP'
'\x04LOOR'
'\x03LOR'
'\x08LORRAINE'
'\x03LOS'
'\x06LOSED '
'\x12LOSED CIRCLE ARROW'
'\x0bLOSED ENTRY'
'\x10LOSED LITTLE YUS'
'\x07LOSING '
'\x0bLOSING MARK'
'\x0bLOTI NAGRI '
'\x07LOTTAL '
'\x0bLOTTAL STOP'
'\x05LOURE'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'\x08LOW LINE'
'\x16LOW PARAPHRASE BRACKET'
'\x08LOW STOP'
'\x08LOW TONE'
'\x06LOWER '
'\x0cLOWER CORNER'
'\x0eLOWER DIAGONAL'
'\tLOWER DOT'
'\nLOWER HALF'
'\nLOWER HOOK'
'+LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x07LOZENGE'
'\x03LPA'
'\nLPAPRAANA '
'\x04LPHA'
'\x02LT'
'\x0bLT OF CLOTH'
'\x03LTA'
'\x0cLTA EQUAL TO'
'\x0bLTERNATE YA'
'\x03LTI'
'\x05LTIRE'
'\x02LU'
'\x0bLU PLUS IGI'
'\x03LUB'
'\x08LUB SUIT'
'\x03LUE'
'\x03LUG'
'\x04LUIS'
'\x03LUL'
'\x03LUM'
'\x04LUMN'
'\x13LUNATE SIGMA SYMBOL'
'\x03LUS'
'\x0cLUS NOTEHEAD'
'\x08LUS SIGN'
'\x0eLUS SIGN BELOW'
'\x03LVE'
'\rLVE FULL STOP'
'\rLVEOLAR CLICK'
'\tLVIN SIGN'
'\x02LY'
'\x03LY '
'\x04LY H'
'\x18LY-RECYCLED PAPER SYMBOL'
'\x07LYGISMA'
'\x01M'
'\x02M '
'\x06M BOAR'
'\x08M BRANCH'
'\x06M BULL'
'\x06M DASH'
'\tM HE-GOAT'
'\x05M RAM'
'\nM STALLION'
'\x0bM TIMES SHE'
'\x02M0'
'\x02MA'
'\x05MAAEH'
'\x06MACRON'
'\x05MACUS'
'\x0bMADDA ABOVE'
'\x0cMADDA ABOVE '
'\x06MADR M'
'\x05MADYA'
'\x07MAGE OF'
'\tMAHAPRANA'
'\x04MAI '
'\x05MAI K'
'\x07MAI SAT'
'\x07MAKSURA'
'\x08MAKSURA '
'\x15MAKSURA ISOLATED FORM'
'\x1eMAKSURA WITH SUPERSCRIPT ALEF '
'\x0fMAL SUBGROUP OF'
'\x0fMALAKON CHROMA '
'\tMALE SIGN'
'\x15MALE WITH STROKE SIGN'
'\x04MALL'
'\x05MALL '
'\x06MALL A'
'\x08MALL AXE'
'\rMALL CAPITAL '
'\x0bMALL CIRCLE'
'\x11MALL CIRCLE ABOVE'
'\x18MALL CIRCLE TO THE RIGHT'
'\x06MALL F'
'\x0cMALL LETTER '
'\rMALL LETTER J'
'\rMALL LETTER Z'
'\x15MALL Q WITH HOOK TAIL'
'\tMALL RING'
'\x0bMALL SQUARE'
'\x11MALL WHITE CIRCLE'
'\x08MALL YUS'
'\x05MALON'
'\x03MAN'
'\x04MAN '
'\x07MANCHU '
'\x11MANENT PAPER SIGN'
'\x08MANGALAM'
'\x05MANNA'
'\x0cMANNAZ MAN M'
'\x03MAP'
'\x05MAPIQ'
'\x05MAQAF'
'\x03MAR'
'\x07MARCATO'
'\x08MARITAN '
'\x04MARK'
'\x05MARK '
'\x1aMARRIED PARTNERSHIP SYMBOL'
'\x0fMARRYING MAIDEN'
'\x04MARU'
'\x04MASH'
'\rMASORA CIRCLE'
'\x12MATHEMATICAL SPACE'
'\x02MB'
'\x0bMBA BAYANNA'
'\x0cMBELLISHMENT'
'\x04MBIC'
'\x19MBINING CRYPTOGRAMMIC DOT'
'\x05MBOL '
'\x07MBOL B0'
'\x04MBOO'
'\x07MBRELLA'
'\tMBROIDERY'
'\x02ME'
'\x0bME LONG CAN'
'\nME PLUS DA'
'\nME PLUS EN'
'\x11ME PLUS GAN2 TENU'
'\x04MEAR'
'\x08MEASURE '
'\x0bMED RGYINGS'
'\x0bMEDIAL FORM'
'\x06MEDIUM'
'\x07MEDIUM '
'\x04MEEM'
'\x05MEEM '
'\x0fMEEM FINAL FORM'
'\x06MEEM I'
'\x11MEEM INITIAL FORM'
'\x05MEEMU'
'\x07MEETORU'
'\x04MEGA'
'\x05MEIZI'
'\x04MEKH'
'\rMELODIC QITSA'
'\x03MEM'
'\x08MEM-QOPH'
'\x06MEMBER'
'\x03MEN'
'\x04MEN '
'\x07MENIAN '
'\x0eMENSION ORIGIN'
'\x04MENT'
'\x07MENT OF'
'\x05MEPET'
'\x04MER '
'\tMES WITH '
'\x04MESO'
'\rMESSENIAN TEN'
'\x0cMETA STAVROU'
'\x05METEG'
'\tMETOBELUS'
'\x06METRIC'
'\x05METRY'
'\x0cMFLEX ACCENT'
'\tMHANCHOLL'
'\x02MI'
'\x03MI '
'\x05MI RO'
'\x07MICOLON'
'\x07MIDDLE '
'\x10MIDDLE AND BELOW'
'\x10MIDDLE AND RIGHT'
'\x0fMIDDLE DIAGONAL'
'\nMIDDLE DOT'
'\x0bMIDDLE HOOK'
'\x0cMIDDLE PIECE'
'\x0bMIDDLE STEM'
'\x0cMIDDLE TILDE'
'\x10MIDIRECT PRODUCT'
'\x05MIEUM'
'\x04MIIN'
'\x04MIL '
'\x06MILAR '
'\nMILLE SIGN'
'\rMILLIONS SIGN'
'\x03MIM'
'\x03MIN'
'\x12MINAL DIGIT SHAPES'
'\x04MING'
'\x0cMING TO MEET'
'\x07MINGKAL'
'\x04MINI'
'\x07MINIMA '
'\nMINO TILE '
'\x05MINUS'
'\nMINUS SIGN'
'\rMINUS SIMILAR'
'\rMINUS WHITE X'
'\x08MIONIAN '
'\x05MISRA'
'\x03MIT'
'\x03MKA'
'\x04MLYA'
'\x02MM'
'\x03MMA'
'\x04MMA '
'\x08MMATION '
'\tMMER AND '
'\x04MMU2'
'\x04MNAS'
'\x16MNYAM YIG GI MGO RGYAN'
'\x02MO'
'$MODIFIER LETTER KHAMTI REDUPLICATION'
'"MODIFIER LETTER LABIALIZATION MARK'
'\x1eMODIFIER LETTER LEFT HALF RING'
'\tMODYNAMIC'
'\x03MOI'
'\x04MON '
'\x08MON TIME'
'\x04MONO'
'\nMONOFONIAS'
'\nMONOGRAM B'
'\x1cMONOGRAMMOS TESSERA DODEKATA'
'\x0cMONOGRAPH UK'
'\nMONOSPACE '
'\nMONTH SIGN'
'\x03MOO'
'\x15MORPHOLOGICAL DIVIDER'
'\x0bMOST EQUAL '
'\x08MOTHETIC'
'\x0eMOTHETIC ABOVE'
'\x08MOUNTAIN'
'\x0bMOVED BELOW'
'\x02MP'
'\x05MPARE'
'\x08MPERSAND'
'\x0cMPHASIS MARK'
'\x03MPI'
'\x03MPL'
'\tMPLIFIED '
'\x0cMPTY CENTRE '
'\x05MROCK'
'\x04MTI '
'\x02MU'
'\x06MUCAAD'
'\x03MUG'
'\x04MUIN'
'\tMUKPHRENG'
'\x08MULTIMAP'
'\rMULTIOCULAR O'
'\x14MULTIPLE PUNCTUATION'
'\x0eMULTIPLICATION'
'\x19MULTIPLICATION SIGN BELOW'
'\x10MULTIPLICATION X'
'\x04MUM '
'\x0cMUM TIMES PA'
'\x0bMUNCIA SIGN'
'\x07MUNGKAH'
'\x04MUOY'
'\x05MUOY '
'\x05MURDA'
'\x0fMURDA MAHAPRANA'
'\x04MUSH'
'\x05MUSIC'
'\x08MUSICAL '
'\x0fMUSICAL SYMBOL '
'\x03MUT'
'\x0bMUUSIKATOAN'
'\x03MWA'
'\x04MWAA'
'\x02MX'
'\x02MY'
'\x04MYA '
'\x07MYSLITE'
'\x03MZA'
'\x0fMZA ABOVE WITH '
'\x01N'
'\x02N '
'\x06N DASH'
'\x0cN ELEMENT OF'
'\x06N SIGN'
'\x0bN THE VERGE'
'\x07N WITH '
'\x06N YANG'
'\x0fN-ARY SUMMATION'
'\x08N-JOINER'
'\x07N2 TENU'
'\x02NA'
'\x05NA PO'
'\nNAASIKYAYA'
'\x04NAAU'
'\x05NABLA'
'\x06NACLES'
'\x05NADA '
'\x04NAG '
'\x03NAH'
'\nNAKE BELOW'
'\x04NAL '
'\x08NAM BCAD'
'\x04NANA'
'\x07NANCIAL'
'\nNANGMONTHO'
'\rNAP PIZZICATO'
'\x03NAR'
'\x11NASALIZATION MARK'
'\x05NASHI'
'\nNASPIRATED'
'\x05NATE '
'\x0cNATURAL SIGN'
'\x06NAUD N'
'\x11NAUDIZ NYD NAUD N'
'\x08NAVIYANI'
'\x13NAXIAN FIVE HUNDRED'
'\x07NAYANNA'
'\x08NCE SIGN'
'\x04NCEL'
'\x05NCHU '
'\x04NCIL'
'\x0cNCK CONSTANT'
'\tNCLOSING '
'\x05NCORA'
'\x02ND'
'\x03ND '
'\nND OF AYAH'
'\x0fND OF PARAGRAPH'
'\x16ND RECORDING COPYRIGHT'
'\x13ND SLANTED PARALLEL'
'\x13ND SOUTH EAST ARROW'
'\x13ND SOUTH WEST ARROW'
'\x0bND TWO DOTS'
'\x06NDA TA'
'\x04NDA2'
'\x04NDAP'
'\x03NDO'
'\x05NDRA '
'\tNDRABINDU'
'\x02NE'
'\x03NE '
'\x07NE DOT '
'\x0fNE EIGHTH BLOCK'
'\x0cNE HALF SIGN'
'\x06NE OF '
'\x11NEGATIVE CIRCLED '
"'NEGATIVE SQUARED LATIN CAPITAL LETTER P"
'\x08NEIFORM '
'\x03NEO'
'\x04NEO '
'\x07NEQUDAA'
'\x03NER'
'\x0cNERSHIP SIGN'
'\x04NESS'
'\x07NESTED '
'\x04NET '
'\tNFORZANDO'
'\x02NG'
'\x03NG '
'\x08NG BELOW'
'\x08NG RTAGS'
'\x07NG SIGN'
'\x11NG STROKE OVERLAY'
'\x03NGA'
'\x04NGA2'
'\x06NGBAT '
'\x04NGIA'
'\x04NGLE'
'\x05NGLE '
'\x0cNGLE BARLINE'
'\x0cNGLE BRACKET'
'\x13NGLE QUOTATION MARK'
'\x05NGMAN'
'\x0cNGRATULATION'
'\x04NGSI'
'\tNGTH MARK'
'\x08NGTHENER'
'\nNGUAGE TAG'
'\x04NGUE'
'\x02NI'
'\x08NI ABOVE'
'\x03NIA'
'\x03NIB'
'\x04NIC '
'\x05NIEUN'
'\x03NIG'
'\tNIGGAHITA'
'\x05NIGHT'
'\tNIHSHVASA'
'\x03NII'
'\x07NIKAHIT'
'\x04NINE'
'\x08NINETEEN'
'\x12NINETEEN FULL STOP'
'\x06NINETY'
'\x04NING'
'\x05NINTH'
'\x04NION'
'\x06NIRUGU'
'\x06NISTER'
'\x12NITE PART INTEGRAL'
'\x0bNITIAL FORM'
'\x0bNITIAL IZHE'
'\x08NITIAL Z'
'\x19NIVERSAL RECYCLING SYMBOL'
'\x07NJAEMLI'
'\x03NJE'
'\x0fNJOINING MACRON'
'\tNK SYMBOL'
'\x03NMA'
'\x02NN'
'\x03NNA'
'\x0cNNED LEATHER'
'\x02NO'
'\x08NO SLASH'
'\tNO TELEIA'
'\tNOCULAR O'
'\x06NOKHUK'
'\x03NOO'
'\x04NOON'
'\x0fNOON FINAL FORM'
'\nNOON WITH '
'\x06NOR BU'
' NORMAL FACTOR SEMIDIRECT PRODUCT'
'\x0fNORMAL SUBGROUP'
'\x12NORMAL SUBGROUP OF'
'\x10NORTH EAST ARROW'
'\x10NORTH WEST ARROW'
'\x04NOT '
'\x0fNOT APPROXIMATE'
'\tNOT EQUAL'
'\x0cNOT EQUAL TO'
'\x16NOT INCLUDING THE POLE'
'\x08NOT SIGN'
'\x0fNOT TILDE ABOVE'
'\x05NOTCH'
'\x04NOTE'
'\tNOTEHEAD '
'\x04NOUT'
'\x08NOVEMBER'
'\x03NOW'
'\x06NOWMAN'
'\x04NPEA'
'\rNSONANT SIGN '
'\x03NSU'
'\x04NSUB'
'\x07NSULAR '
'\x08NSULAR D'
'\x08NSULAR G'
'\x06NSUZ A'
'\x15NSVERSAL INTERSECTION'
'\x05NSYON'
'\x02NT'
'\x10NT SCREEN SYMBOL'
')NT-TILTED SHADOWED WHITE RIGHTWARDS ARROW'
'\x05NTAIN'
'\x07NTAINS '
'\x11NTED EQUAL TO OR '
'\tNTERPRISE'
'\x06NTEVMA'
'\x03NTI'
'\x07NTICAL '
'"NTICLOCKWISE-ROTATED DIVISION SIGN'
'\x06NTIIMU'
'\x15NTISTRY SYMBOL LIGHT '
'\nNTITY MARK'
'\x04NTOC'
'\x06NTOGEN'
'\tNTRACTION'
'\x03NTY'
'\rNTY FULL STOP'
'\x02NU'
'\x07NUBIAN '
'\x05NUENG'
'\x0cNUITY SYMBOL'
'\x05NUKTA'
'\x03NUM'
'\x07NUMBER '
'\x0bNUMBER SIGN'
'\nNUMBER TEN'
'\x0bNUMBER ZERO'
'\x08NUMERAL '
'\x0cNUMERAL SIGN'
'\nNUMERATOR '
'\rNUMERATOR ONE'
'\rNUMERIC SIGN '
'\x03NUN'
'\x0bNUN HAFUKHA'
'\x04NUNG'
'\x08NUS SIGN'
'\x07NUSVARA'
'\x08NUSVARA '
'\x0bNUSVARA ONE'
'\tNUSVARAYA'
'\x07NUTILLU'
'\x04NUUN'
'\x08NVERTED '
'\tNVERTED M'
'\tNVERTED R'
'\x0fNVERTED UBADAMA'
'\x02NW'
'\x04NWAA'
'\x0bNWHEEL STAR'
'\x02NY'
'\x12NYET THYOOM TA-ROL'
'\x07NYI ZLA'
'\x0eNYI ZLA NAA DA'
'\x04NYIS'
'\x0bNYIS -KHYIL'
'\x03NYO'
'\x12NYOOGA NAAKSIKYAYA'
'\x01O'
'\x02O '
'\x05O ANG'
'\x03O B'
'\tO HUNDRED'
'\x05O KAI'
'\x04O MA'
'\x03O N'
'\x05O PLA'
'\x05O RUA'
'\x06O SIGN'
'\x08O SYMBOL'
'\x03O Y'
'\x02O0'
'\x0cOACTIVE SIGN'
'\nOANDAKHIAT'
'\x03OAY'
'\x04OBAT'
'\x06OBELOS'
'\x06OBELUS'
'\x0eOBLIQUE HYPHEN'
'\rOBLIQUE LINE '
'\nOBOLS SIGN'
'\x08OBOOFILI'
'\x04OBRO'
'\x15OCAL NOTATION SYMBOL-'
'\x07OCALIC '
'\tOCCLUSION'
'\x06OCENCE'
'\x06OCIETY'
'\x03OCK'
'\x1aOCKED FEMALE AND MALE SIGN'
'\x07OCTOBER'
'\x12ODD POWERS OF FOUR'
'\x06ODHADH'
'\tODIASTOLE'
'\x0fODIFIER LETTER '
'\x04ODO '
'\x02OE'
'\x03OE '
'\x03OEH'
'\x04OENG'
'\tOENICIAN '
'\x10OETIC VERSE SIGN'
'\x02OF'
'\x0bOF MASHFAAT'
'\tOF STIMME'
'\x06OFOUND'
'\x04OFT '
'\x02OG'
'\x07OGDIAN '
'\x03OGH'
'\x0fOGOGRAM KHAMTI '
'\x06OGONEK'
'\rOGOTYPE SIGN '
'\tOGRAPHIC '
'\x02OH'
'\x15OHAMMAD ISOLATED FORM'
'\x0cOHAZARD SIGN'
'\x08OHM SIGN'
'\x06OICING'
'\x0cOID NOTEHEAD'
'\x03OIN'
'\x0cOING TO MEET'
'\x05OINT '
'\x07OINTED '
'\x11OINTED BLACK STAR'
'\x06OINTER'
'\x03OIX'
'\x02OK'
'\x08OK ABOVE'
'\x05OKARA'
'\x05OKEN '
'\x05OKOJI'
'\tOKOUFISMA'
'\x07OKRYTIE'
'\x02OL'
'\x04OLAM'
'\x03OLD'
'\x19OLD ASSYRIAN WORD DIVIDER'
'\x0bOLD NUBIAN '
'\x0eOLD RESOLUTION'
'\x0bOLDING BACK'
'\x03OLE'
'\x06OLIDUS'
'\x0fOLIDUS OPERATOR'
'\x0eOLIDUS OVERLAY'
'\x03OLL'
'\nOLLAR SIGN'
'\x08OLLOWING'
'\x04OLON'
'\nOLON EQUAL'
'\x05OLONG'
'\x0eOLUME INTEGRAL'
'\x02OM'
'\x04OMAN'
'\rOMAN NUMERAL '
'\tOMBINING '
'\x04OMBU'
'\x05OMEGA'
'\x07OMERANG'
'\x05OMIKO'
'\x04OMMA'
'\x08OMMA BAR'
'\nOMMA BELOW'
'\x10OMPLETE INFINITY'
'\x03OMU'
'\x02ON'
'\x03ON '
'\tON GROUND'
'\nON MEDIAL '
'\x0bON PEDESTAL'
'\x0cON WITH BALL'
'\x12ON-SPOKED ASTERISK'
'\x04ONA '
'\x04ONAP'
'%ONCAVE-POINTED BLACK RIGHTWARDS ARROW'
'\x14ONCAVE-SIDED DIAMOND'
'\x04OND '
'\x03ONE'
'\x04ONE '
'\x07ONE BAR'
'\x10ONE EIGHTH BLOCK'
'\x08ONE FOR '
'\x0bONE HUNDRED'
'\x08ONE MARK'
'\tONE MARK-'
'\x04ONE-'
'\x04ONEK'
'\x03ONG'
'\x04ONG '
'\x08ONG DASH'
'\x07ONG LEG'
'\rONG RIGHT LEG'
'\x05ONG S'
'\x0bONG-BRANCH-'
'\x04ONGA'
'\rONGRATULATION'
'\tONGSEONG '
'\x04ONON'
'\x04ONOS'
'\tONSONANT '
'\x14ONSONANT SIGN COENG '
'\x0fONTOUR INTEGRAL'
'\x02OO'
'\tOO DENNEN'
'\x08OO TYPE '
'\x03OOD'
'\x03OOF'
'\x06OOMUUT'
'\x03OON'
'\nOON LILITH'
'\rOON NOTEHEAD '
'\x04OONE'
'\x04OONU'
'\x03OOT'
'\x04OOTH'
'\x0eOOTNOTE MARKER'
'\x03OOU'
'\x02OP'
'\tOP HALF O'
'\x07OP MARK'
'\x05OPBAR'
'\x1eOPEN CENTRE EIGHT POINTED STAR'
'\x11OPEN CIRCLE ARROW'
'\x06OPEN D'
'\x06OPEN E'
'\x06OPEN P'
'\nOPEN SHELF'
'\x11OPEN-HEADED ARROW'
'\x08OPENING '
'\x0cOPENING LEFT'
'\x08OPERATOR'
'\x03OPO'
'\x04OPPA'
'\x15OPPOSING AN PLUS NAGA'
'\x0bOPPOSING EN'
'\x0bOPPOSING IM'
'\x0cOPPOSING LU2'
'\rOPPOSING NAGA'
'\x0eOPPOSING PIRIG'
'\x08OPRODUCT'
'\x02OQ'
'\x02OR'
'\x03OR '
'\x06OR EQU'
'\x08OR EQUAL'
'\x0bOR EQUAL TO'
'#OR LOWER LEFT CURLY BRACKET SECTION'
'$OR LOWER RIGHT CURLY BRACKET SECTION'
'\x0bOR OPERATOR'
'\x0bORCE SYMBOL'
'\x07ORCULUS'
'\x0eORD SEPARATOR '
'\x10OREAN CHARACTER '
'\x15OREAN STANDARD SYMBOL'
'\x06ORETTE'
'\x07OREVMA '
'\x05ORGON'
'\x03ORI'
'\x17ORIGINAL OF OR EQUAL TO'
'\x04ORII'
'\tORINHIEUH'
'\tORIZONTAL'
'\x18ORIZONTAL BAR WITH NOTCH'
'\x0fORIZONTAL COLON'
'\x12ORK ON THE DECAYED'
'\x07ORKHON '
'\x08ORM FEED'
'\x0fORMATION SOURCE'
'\x03ORN'
'\x08ORNAMENT'
'\x05ORNER'
'\rORNER BRACKET'
'\x06ORONIS'
'\x06ORPIUS'
'\x04ORT '
'\x0bORT BARLINE'
'\x0fORT EQUALS SIGN'
'\tORTH WIND'
'\x1aORTHOGONAL CROSSHATCH FILL'
'\x06ORTION'
'\x15ORTOISE SHELL BRACKET'
'\x04ORTY'
'\x03ORU'
'\x05ORUTO'
'\x02OS'
'\x06OSETTE'
'\x07OSITION'
'\x0eOSITION SYMBOL'
'\x03OSS'
'\x05OSS O'
'\nOSSED SHEI'
'\nOSTAL MARK'
'\x08OSTROPHE'
'\x02OT'
'\x03OT '
'\x08OT ABOVE'
'\x08OT BELOW'
'\x0bOT OPERATOR'
'\x0eOT PUNCTUATION'
'\x07OT SIGN'
'\x03OTA'
'\x07OTATED '
'\x0cOTATION MARK'
'\x04OTE '
'\rOTEHEAD BLACK'
'\x05OTERI'
'\x03OTH'
'\x05OTHAL'
'\x05OTHES'
'\rOTHIC LETTER '
'\x08OTIFIED '
'\x07OTLESS '
'\x12OTLESS DALATH RISH'
'\x14OTLESS J WITH STROKE'
'\x03OTO'
'\x06OTTED-'
'\x04OTTO'
'\x0cOTTOM HALF O'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE ACUTE'
'\x0bOUBLE ARROW'
'\x0fOUBLE BACKSLASH'
'\x0bOUBLE DANDA'
'\x11OUBLE MONOCULAR O'
'\x04OUBT'
'\x04OUND'
'\nOUND OMEGA'
'\tOUND SIGN'
'\x1cOUND-TIPPED RIGHTWARDS ARROW'
'\x0eOUNDED CORNERS'
'#OUNDED HIGH STOP WITH FILLED CENTRE'
'\x03OUR'
'\x04OUR '
'\x13OUR DOT PUNCTUATION'
'\x08OUR DOTS'
'\x0eOUR DOTS ABOVE'
'\nOUR FIFTHS'
'\x0cOUR INTEGRAL'
'\x0eOUR OBOLS SIGN'
'\x07OUR OF '
'\x10OUR POINTED STAR'
'\tOURA SIGN'
'\x05OURCE'
'\x07OURTEEN'
'\x11OURTEEN FULL STOP'
'\rOURTH SUBUNIT'
'\x0eOUSING THUNDER'
'\x03OUT'
'\x04OUT '
'\x07OUT HUB'
'\nOUTER JOIN'
'\x0fOUTH EAST ARROW'
'\tOUTH WIND'
'\x19OUTLINED RIGHTWARDS ARROW'
'\x03OVE'
'\x07OVER AN'
'\x08OVER ASH'
'\tOVER ASH '
'\x08OVER BU '
'\x07OVER DU'
'\x13OVER E NUN OVER NUN'
'\x08OVER GA2'
'\tOVER GAN2'
'\x08OVER GI4'
'\x0eOVER GUD LUGAL'
'"OVER IGI SHIR OVER SHIR UD OVER UD'
',OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U'
'\x14OVER LEFTWARDS ARROW'
'\x16OVER LEFTWARDS HARPOON'
'\tOVER LONG'
'\tOVER MUSH'
'\x08OVER NUN'
'\x15OVER RIGHTWARDS ARROW'
'\x17OVER RIGHTWARDS HARPOON'
'\x08OVER SAG'
'\tOVER SHE '
'\x16OVER SHIR BUR OVER BUR'
'"OVER TAB NI OVER NI DISH OVER DISH'
'\x08OVER TIR'
'\x19OVER TWO DOTS PUNCTUATION'
'\x07OVER U '
'\x07OVERBAR'
'\x08OVERLAID'
'\x17OVERLAPPING LOGICAL AND'
'\x07OVERLAY'
'\x08OVERLINE'
'\x08OVERRIDE'
'\x02OW'
'\x03OW '
'\x07OW LINE'
'\x05OW PA'
'\x06OW TIE'
'\x12OW TONE APOSTROPHE'
'\x13OW-9 QUOTATION MARK'
'\x05OWEL '
'\nOWEL SIGN '
'\x04OWER'
'\x05OWER '
'\x0fOWER HALF BLACK'
'\tOWER LEFT'
'\x11OWER NUMERAL SIGN'
'*OWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x07OWILO S'
'\x03OWN'
'\x08OWN TACK'
'\rOWN-POINTING '
'\x07OX BACK'
'\x07OX LINE'
'\x04OXIA'
'\x02OY'
'\x06OYANNA'
'\x03OZE'
'\x01P'
'\x02P '
'\tP DIGRAPH'
'\x18P DIRECTIONAL FORMATTING'
'\x08P HALF O'
'\x11P ON BLACK SQUARE'
'\x17P SYMBOL FOR LIGHTHOUSE'
'\x06P TACK'
'\x02P0'
'\x02PA'
'\x17PA OVER PA GAR OVER GAR'
'\tPAA-PILLA'
'\x05PAATO'
'\x04PACE'
'\tPADE SUIT'
'\rPAIRED ARROWS'
'\x08PAIRTHRA'
'\x0cPALATAL HOOK'
'\x07PALLAWA'
'\x08PALOCHKA'
'\x06PALUTA'
'\x07PANESE '
'\x07PANSIOS'
'\tPANYANGGA'
'\x0ePAO KAREN TONE'
'\x0cPAP PLUS PAP'
'\x13PARAGRAPH SEPARATOR'
'\x0bPARAKALESMA'
'\x0bPARALLEL TO'
'\x0bPARENTHESIS'
'\x14PARENTHESIS ORNAMENT'
'\x0ePARESTIGMENON '
'\x06PARKLE'
'\x11PARTING TONE MARK'
'\x07PARTURE'
'\x05PASEQ'
'\x05PATAH'
'\x05PATAK'
'\x08PAVIYANI'
'\x04PAWN'
'\x07PAYANNA'
'\x07PAYEROK'
'\x05PCHA '
'\x02PE'
'\x08PE DRIVE'
'\x04PEAT'
'\x06PECIAL'
'\x07PECTIVE'
'\nPEDAL MARK'
'\x03PEE'
'\x08PEE SIGN'
'\x05PEECH'
'\x04PEEP'
'\x07PEGERMA'
'\x03PEH'
'\x05PEITH'
'\x04PEN '
'\x10PEN CENTRE CROSS'
'\x05PEN E'
'\x05PEN O'
'\x05PEN-P'
'\x06PENCIL'
'\nPENDICULAR'
'\x07PENGKAL'
'\tPENTASEME'
'\x05PEPET'
'\x04PER '
'\x0cPER-EM SPACE'
'\x07PERATOR'
'\nPERCUSSIVE'
'\x08PERFECTA'
'\rPERFECTA REST'
'\x19PERFECTUM CUM PROLATIONE '
'\x12PERFIXED LETTER RA'
'\x0fPERIAL ARAMAIC '
'\x0bPERISPOMENI'
'\x04PERS'
'\x07PERSAND'
'\x06PERSET'
'\tPERSET OF'
'\x16PERSET OF NOR EQUAL TO'
'\x08PERSIAN '
'\x0fPERTHO PEORTH P'
'\x07PERVISE'
'\x02PH'
'\x03PHA'
'\x1bPHARYNGEAL VOICED FRICATIVE'
'\x0cPHEME JOINER'
'\x03PHI'
'\x07PHIEUPH'
'\x0bPHNAEK MUAN'
'\x06PHRASE'
'\x07PHUTHAO'
'\x02PI'
'\x05PI RO'
'\x03PIC'
'\x04PICK'
'\tPIDERY HA'
'\x05PIEUP'
'\x03PII'
'\x04PII '
'\x03PIN'
'\x04PING'
'\x11PINWHEEL ASTERISK'
'\rPINWHEEL STAR'
'\x06PIRIT '
'\x05PITER'
'\x10PLACEHOLDER MARK'
'\x13PLACEMENT CHARACTER'
'\x04PLE '
'\x10PLE MEASURE REST'
'\x03PLI'
'\nPLICATION '
'\x0ePLITTING APART'
'\x06PLOPHU'
'\x04PLUM'
'\x04PLUS'
'\nPLUS BELOW'
'\nPLUS ERIN2'
'\nPLUS NAGA '
'\rPLUS OPERATOR'
'\x08PLUS SAR'
'\tPLUS SIGN'
'\x0fPLUS SIGN BELOW'
'\x02PM'
'\x0cPOETRY MARK-'
'\x0cPOGEGRAMMENI'
'\x05POINT'
'\x1ePOINTED RECTILINEAR BLACK STAR'
'\x07POINTER'
'\tPOINTING '
'\x18POINTING DOWNWARDS ABOVE'
'\x0ePOINTING INDEX'
'\x16POINTING UPWARDS BELOW'
'\x06POKED '
'\x05POLI '
'\x07POMOFO '
'\x05PONSE'
'\x04POSE'
'\x08POSITION'
'\x10POSTPOSITION MEN'
'\tPOSTROPHE'
'\x03POT'
'\x02PP'
'\x03PPA'
'\nPPA SYMBOL'
'\x05PPAGE'
'\x04PPER'
'\rPPOSING LUGAL'
'\tPPOSITION'
'\x07PPROACH'
'"PPROXIMATELY NOR ACTUALLY EQUAL TO'
'\x02PR'
'\nPRALINEAR '
'\x16PRECEDED BY APOSTROPHE'
'\x08PRECEDES'
'\x11PRECEDING SOLIDUS'
'\x10PRECEDING SUBSET'
'\x10PRECHGESANG STEM'
'\x07PRENKHA'
'\rPREPONDERANCE'
'\x07PRESENT'
'\x07PRICORN'
'\x04PRIL'
'\x05PRIME'
'\x05PRING'
'\x05PRINT'
'\x0fPRIOT SYLLABLE '
'\x0fPRISHTHAMATRA E'
'\x03PRO'
'\x07PRODUCT'
'\x14PROLONGED SOUND MARK'
'\x0cPROTOS ICHOS'
'\x05PSILI'
'\x06PSILON'
'\x07PTHAHA '
'\x05PTIVE'
'\x05PTUNE'
'\x02PU'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x16PUNCTUATION KUNDDALIYA'
'\x11PUNCTUATION SIGN '
'\x08PUSHPIKA'
'\x02PV'
'\x03PWA'
'\x02PY'
'\x01Q'
'\x03Q00'
'\x02QA'
'\x04QAAF'
'\x05QAAFU'
'\x03QAF'
'\x1eQAF WITH LAM WITH ALEF MAKSURA'
'\x08QAIRTHRA'
'\x06QAMATS'
'\x04QAPH'
'\x03QAR'
'\x05QATAN'
'\x04QEF '
'\x06QETANA'
'\x05QITSA'
'\x02QN'
'\x03QOF'
'\x04QOPA'
'\x04QOPH'
'\x03QOT'
'\x02QU'
'\x03QUA'
'\x04QUAD'
'\x15QUADRANT CIRCULAR ARC'
'\x0fQUADRUPLE ARROW'
'\x0fQUADRUPLE DASH '
'\nQUALS SIGN'
'\x10QUALS SIGN BELOW'
'\x05QUARE'
'\x06QUARE '
'\x0bQUARE BELOW'
'\rQUARE BRACKET'
'\x06QUARED'
'\x07QUARIUS'
'\x07QUARTER'
'\x0bQUARTER ASH'
'\rQUARTER BLOCK'
'\x08QUARTERS'
'\x0eQUARTERS BLOCK'
'\rQUARTERS SIGN'
'\x11QUAT REVERSED ESH'
'\x05QUEEN'
'\x08QUESTION'
'\rQUESTION MARK'
'\x13QUESTION MARK ABOVE'
'\x03QUF'
'\x05QUILL'
'\x0eQUINARIUS SIGN'
'\x0bQUIQUADRATE'
'\x0cQUIRREL TAIL'
'\x05QUIRY'
'\nQUISH QUAD'
'\x0eQUOTATION MARK'
'\x17QUOTATION MARK ORNAMENT'
'\tQUSHSHAYA'
'\x01R'
'\x02R '
'\x07R ABOVE'
'\x10R PLUS GAN2 TENU'
'\tR PLUS RA'
'\x06R THAN'
'\x07R TSHES'
'\x0fR WITH FISHHOOK'
'\x02R0'
'\x02R2'
'\nR2 PLUS SU'
'\x02R7'
'\x02RA'
'\x07RA REPA'
'\x07RA SIGN'
'\x03RAA'
'\x0bRACHMA SIGN'
'\x05RACHY'
'\nRACTER TIE'
'\x10RACTION ONE HALF'
'\x08RADICAL '
'\x03RAE'
'\x04RAEA'
'\x04RAFE'
'\x07RAGANA '
'\nRAGGISMATA'
'\x0cRAH BEN YOMO'
'\x03RAI'
'\x05RAIDA'
'\x10RAIDO RAD REID R'
'\nRAINIAN IE'
'\x17RAISED OMISSION BRACKET'
'\x07RAKHANG'
'\tRAL HEART'
'\x03RAM'
'\x04RAM '
'\x08RAM FOR '
'\x04RAMA'
'\x08RAMMA GG'
'\x03RAN'
'\x19RANCH BANK IDENTIFICATION'
'\x0cRANCHING OUT'
'\x07RANGKEP'
'\x0bRANSMISSION'
'\x05RANUS'
'\x07RARIETY'
'\x05RASHA'
'\x05RASS '
'\x05RATER'
'\x05RATHA'
'\x08RAUGHTS '
'\x0bRAVE ACCENT'
'\x03RAY'
'\x07RAYANNA'
'\x03RCH'
'\x07RCHAIC '
'\x0cRCHAIC SAMPI'
'\x07RCHAION'
'\x05RCHID'
'\x05RCURY'
'\x02RD'
'\x03RD '
'\x07RD SIGN'
'\tRDEL DKAR'
'\x08RDEL NAG'
'\x0bRDHAVISARGA'
'\x07RDO RJE'
'\x02RE'
'\x07READING'
'\x0bREAKTHROUGH'
'\x04REAT'
'\x07REAT SA'
'\x0eREATIVE HEAVEN'
'\x08REATNESS'
'\x0fRECEPTIVE EARTH'
'\x10RECORD SEPARATOR'
'\x08RECORDER'
'\x1cRECT CURRENT SYMBOL FORM TWO'
'\tRECTANGLE'
'\x1cRECTANGULAR PATH AROUND POLE'
'\x16RECTILINEAR BLACK STAR'
'\nRED DRAGON'
'\nREDIT SIGN'
'\x03REE'
'\x04REE '
'\x0bREE HUNDRED'
'\x08REE MARK'
'\x17REE VARIATION SELECTOR '
'\x0eREE-LINE STAFF'
'\x05REEK '
'\x0cREFACE COLON'
'\x03REH'
'\x04REH '
'\x0eREH FINAL FORM'
'\x04REIA'
'\x05RELAA'
'\nRENCY SIGN'
'\x06RENGTH'
'\x04REPA'
'\x0cREPONDERANCE'
'\x07REREKAN'
'\x05REREN'
'\x03RES'
'\x0bRESCENT BAR'
'\x04RESH'
'\x07RESILLO'
'\x07RESSION'
'\x04REST'
'\x0eRETROFLEX HOOK'
'\x08REVERSE '
'\x0cREVERSE MARK'
'\x0fREVERSE SOLIDUS'
'\x08REVERSED'
'\tREVERSED '
'\x15REVERSED FEATHER MARK'
'\nREVERSED I'
'\x14REVERSED ONE HUNDRED'
'\x0fREVERSED OPEN E'
'\x05REVIA'
'\x0eRFACE INTEGRAL'
'\x03RGE'
'\x06RGIAN '
'\x06RGLASS'
'\x03RGO'
'\x04RGON'
'\x04RGU2'
'\x03RHO'
'\nRHO SYMBOL'
'\x02RI'
'\x05RIAC '
'\x0cRIANGLE DOWN'
'\x1fRIANGLE-HEADED RIGHTWARDS ARROW'
'\x0fRIANGULAR COLON'
'\x11RIATION SELECTOR-'
'\x05RICEM'
'\x05RIEUL'
'\x03RIG'
'\x05RIGHT'
'\x06RIGHT '
'\nRIGHT AND '
'\x14RIGHT ANGLE WITH DOT'
'\x1bRIGHT ARC LESS-THAN BRACKET'
'\x0cRIGHT ARROW '
'\x11RIGHT ARROW ABOVE'
'\x17RIGHT DIAGONAL ELLIPSIS'
'\x19RIGHT DIAGONAL HALF BLACK'
'\x0cRIGHT DOUBLE'
'\x10RIGHT DOWN BARB '
'\nRIGHT HALF'
'\x10RIGHT HALF BLACK'
'\x11RIGHT HALF CIRCLE'
'\x0fRIGHT HALF RING'
'\rRIGHT HARPOON'
'\x0bRIGHT HEAVY'
'\nRIGHT HOOK'
'\x0bRIGHT LIGHT'
'\x11RIGHT PARENTHESIS'
'\x1aRIGHT PARENTHESIS ORNAMENT'
'\x0eRIGHT QUADRANT'
'\x14RIGHT QUADRANT BLACK'
'\x0fRIGHT RERENGGAN'
'\x0cRIGHT SINGLE'
'\x13RIGHT TO LOWER LEFT'
'%RIGHT TORTOISE SHELL BRACKET ORNAMENT'
'\x0eRIGHT TRIANGLE'
'\x0fRIGHT TURNSTILE'
'\x0bRIGHT-HAND '
'\x14RIGHT-POINTING ANGLE'
'#RIGHT-POINTING ANGLE QUOTATION MARK'
'\nRIGHTWARDS'
'\x10RIGHTWARDS ARROW'
'&RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW'
'\x11RIGHTWARDS ARROWS'
'!RIGHTWARDS HARPOON WITH BARB DOWN'
'\x1fRIGHTWARDS HARPOON WITH BARB UP'
'\x18RIGHTWARDS THEN CURVING '
'\x0fRIGHTWARDS TICK'
'\nRIGINAL OF'
'%RIGVEDIC KASHMIRI INDEPENDENT SVARITA'
'\x03RII'
'\x06RIISAP'
'\x06RIKRIK'
'\x07RILLIC '
'\x04RIME'
'\x04RIN2'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\x1fRING OVER TWO RINGS PUNCTUATION'
'\x0cRING OVERLAY'
'\x1fRINGS OVER ONE RING PUNCTUATION'
'\x08RINHIEUH'
'\x0cRION CHRONON'
'\x03RIP'
'\x06RIPLE '
'\x0bRIPLE ARROW'
'\x1aRIPLE DOT PUNCTUATION MARK'
'\x0bRIPLE PRIME'
'\rRIPLE SVARITA'
'\x0eRIPLE UNDERDOT'
'\x1bRIPLE VERTICAL BAR OPERATOR'
'\x04RIPT'
'\x06RIPT G'
'\x06RISEME'
'\x04RISH'
'\x07RISIMOU'
'\x0fRISING DIAGONAL'
'\x15RISING DIAGONAL SLASH'
'\x0bRISING DOTS'
'\x0bRISING TONE'
'\x10RISING TONE MARK'
'\tRISPOMENI'
'\x05RITSI'
'\x04RITU'
'\x08RIYOOSAN'
'\tRIZONTAL '
'\x10RIZONTAL ELLIPSE'
'\x02RK'
'\x0eRK NOON GHUNNA'
'\x08RK SHADE'
'\x06RKAANU'
'\x04RKLE'
'\x03RMA'
'\x0fRMAN PENNY SIGN'
'\x18RMITIAN CONJUGATE MATRIX'
'\x07RMUKHI '
'\x02RN'
'\x0cRNAM BCAD MA'
'\x0fRNAMENT STROKE-'
'\x05RNED '
'\tRNEY PARA'
'\nRNING SIGN'
'\x02RO'
'\x04ROA '
'\nROAD OMEGA'
'\x04ROAR'
'\x06ROBANG'
'\x03ROC'
'\nROEZENIAN '
'\x03ROG'
'\x07ROGRESS'
'\tROJECTION'
'\rROKEE LETTER '
'\x07ROKEN L'
'\x0bROKUTASTI A'
'\x03RON'
'\x0eRONIAN SIGN ET'
'\x05RONIS'
'\x0bRONTHISMATA'
'\x04ROOK'
'\x03ROP'
'\x0bROR-BARRED '
'\rROSGEGRAMMENI'
'\x04ROSH'
'\x04ROSS'
'\x0bROSS ACCENT'
'\x0eROSS ON SHIELD'
'\x0bROSSED-TAIL'
'\rROSSING LANES'
'\x1bROTATED FLORAL HEART BULLET'
'\x04ROTO'
'\x07ROTUNDA'
'\x16ROUND A POINT OPERATOR'
'\x0cROUNDED ZERO'
'\x04ROUT'
'\rROW POINTING '
'\tROW WITH '
'\x0cROWNING FACE'
'\rRPENTRY PLANE'
'\x0bRPOON ABOVE'
'\tRPORATION'
'\x04RPSE'
'\x03RQA'
'\x02RR'
'\x05RRECT'
'\x07RRECTUS'
'\x06RRED O'
'\x0cRRESPONDS TO'
'\rRRIAGE RETURN'
'\rRRIAGE SYMBOL'
'\x06RRIER '
'\x04RROI'
'\x04RROW'
'\x13RROW NO-BREAK SPACE'
'\x16RROW WITH ROUNDED HEAD'
'\x03RRY'
'\x08RSECTION'
'\x06RSHANA'
'\nRSI SYMBOL'
'\x06RSIAN '
'\x10RST QUARTER MOON'
'\x02RT'
'\x03RT '
'\x04RT T'
'\x04RTAR'
'\x03RTE'
'\tRTER MARK'
'\tRTER NOTE'
'\x03RTH'
'\x07RTHIAN '
'\x17RTOISE SHELL BRACKETED '
'\x03RTY'
'\x02RU'
'\x04RUCK'
'\x04RUDA'
'\x05RUDAA'
'\x03RUE'
'\x05RUHUA'
'\x04RUIS'
'\x04RUKU'
'\tRUM CLEF-'
'\x14RUMAI PALAUNG TONE-5'
'\x04RUNA'
'\x04RUNG'
'\x06RUPEE '
'\nRUPEE MARK'
'\nRUPEE SIGN'
'\x05RUSH '
'\x04RUSI'
'\x04RUTU'
'\x02RV'
'\nRVICE MARK'
'\x02RY'
'\x11RYBLION BASE SIGN'
'\x08RYNGEAL '
'\x0bRYVNIA SIGN'
'\x01S'
'\x02S '
'\x07S ABOVE'
'\x0cS ABOVE SIGN'
'\x07S BELOW'
'\tS DIGRAPH'
'\x07S ICHOS'
'\x08S INSIDE'
'\rS KAI APOTHES'
'\x03S O'
'\x1aS OVER ONE DOT PUNCTUATION'
'\x0cS SUBPUNCTIS'
'\x02S0'
'\x02SA'
'\x04SA-I'
'\x06SAADIY'
'\x1eSAD WITH LAM WITH ALEF MAKSURA'
'\x04SADI'
'\x03SAG'
'\x03SAL'
'\rSAL PLUS TUG2'
'\x03SAM'
'\x07SAMPHAO'
'\x05SAMPI'
'\rSAMYOK SANNYA'
'\x04SANG'
'\x08SANGSIOS'
'\x0bSANS-SERIF '
'\x08SANYAKA '
'\x05SARGA'
'\x05SASA '
'\x05SASAK'
'\x03SAT'
'\x05SAUIL'
'\x07SAYANNA'
'\x0cSAZ IS ISS I'
'\nSBUB -CHAL'
'\nSCAN LINE-'
'\x05SCAPE'
'\x05SCENT'
'\x04SCES'
'\x05SCHWA'
'\x14SCRIPTION CHARACTER '
'\x02SE'
'\x03SE '
'\nSE-CREE SK'
'\x06SEBALL'
'\x0bSECOND MARK'
'\x0eSECOND SUBUNIT'
'\x04SECT'
'\x07SECTION'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEN'
'\x05SEGOL'
'\x04SELF'
'\x16SEMI-VOICED SOUND MARK'
' SEMICIRCULAR ANTICLOCKWISE ARROW'
'\x1dSEMICIRCULAR PATH AROUND POLE'
'\tSEMICOLON'
'\x0fSEMIVOWEL SIGN '
'\x05SENTO'
'\tSEPARATOR'
'\x14SEPARATOR KEY SYMBOL'
'\x14SEPARATOR MIDDLE DOT'
'\tSEPTEMBER'
'\x10SERIFS AT BOTTOM'
'\x07SERTION'
'\x03SET'
'\rSEVEN EIGHTHS'
'\x13SEVEN EIGHTHS BLOCK'
'\x07SEXTILE'
'\x04SEYE'
'\nSGOR RTAGS'
'\x02SH'
'\x03SH '
'\x13SH PLUS HU PLUS ASH'
'\nSH PRODUCT'
'\x07SH TAIL'
'\x0cSH ZIDA TENU'
'\x03SH2'
'\x03SHA'
'\x04SHA3'
'\x0bSHAAYATHIYA'
'\x04SHAD'
'\x05SHADE'
'\x15SHADOWED WHITE SQUARE'
'\x04SHAN'
'\x05SHAN '
'\x0eSHAN MEDIAL WA'
'\x05SHANG'
'\x04SHAR'
'\x05SHAR2'
'\x05SHARA'
'\x05SHARP'
'\nSHARP SIGN'
'\x05SHARU'
'\x06SHAYIM'
'\x03SHE'
'\x04SHE3'
'\x05SHED '
'\x0cSHED BARLINE'
'\x04SHEI'
'\x0bSHEQEL SIGN'
'\x05SHESH'
'\x07SHESHIG'
'\x05SHEYE'
'\x05SHGAB'
'\x05SHIMA'
'\x0fSHITA PLUS GISH'
'\x08SHKIR KA'
'\x08SHOE JOT'
'\nSHOE STILE'
'\x05SHOOK'
'\x05SHORT'
'\x06SHORT '
'\x07SHORT A'
'\x15SHORT LEFTWARDS ARROW'
'\x0fSHORT OVER LONG'
'\x16SHORT RIGHTWARDS ARROW'
'\x0cSHORT RIKRIK'
'\x16SHORT VERTICAL STROKES'
'\x04SHTA'
'\x04SHU2'
'\x04SHYA'
'\x02SI'
'\x1dSIBE SYLLABLE BOUNDARY MARKER'
'\x03SIC'
'\x06SICKLE'
'\x05SICLE'
'\x06SIEUNG'
'\x08SIFISTON'
'\x0cSIGMA SYMBOL'
'\x04SIGN'
'\x05SIGN '
'\rSIGN AVAGRAHA'
'\x0bSIGN COENG '
'\x08SIGN LAE'
'\x07SIGN PA'
'\rSIGN PAMUDPOD'
'\x0bSIGN VIRAMA'
'\x04SIKI'
'\x05SILA3'
'\x04SILI'
'\rSILI PNEUMATA'
'\x17SING DIAGONAL CROSSING '
'\x0bSINGLE AND '
'\x14SINGLE DOT TONE MARK'
'\x12SINGLE PUNCTUATION'
'\x0cSINGLE-LINE '
'\x18SINGLE-LINE NOT EQUAL TO'
'\x04SINK'
'\x05SION '
'\x04SIOS'
'\x04SIS '
'\x03SIX'
'\tSIXTEENTH'
'\x0fSIXTEENTH NOTES'
'\nSIXTEENTHS'
'\x05SIXTH'
'\x06SIXTHS'
'\x03SJE'
'\x04SKAL'
'\x06SKAPI '
'\x08SKLIRON '
'\x08SLANTED '
'\x10SLANTED EQUAL TO'
'\x05SLASH'
'\x04SLUR'
'\x03SMA'
'\x06SMALL '
'\x18SMALL ARABIC LETTER TAH '
'$SMALL ARABIC LETTER TAH AND TWO DOTS'
'\x10SMALL CAPITAL EL'
'\x0cSMALL CIRCLE'
'\x12SMALL CIRCLE ABOVE'
'\x07SMALL L'
'\rSMALL LETTER '
'\x0eSMALL LETTER J'
'\x0eSMALL TRIANGLE'
'\x07SMALL V'
'\rSMALL V ABOVE'
'\rSMALL V BELOW'
'\tSMALL YUS'
'\x07SMANYA '
'\x08SNA LDAN'
'\x02SO'
'\x03SO '
'\tSOF PASUQ'
'\x05SOL S'
'\x0cSOLATED FORM'
'\x07SOLIDUS'
'\x17SOLIDUS BINARY RELATION'
'\x03SON'
'\x04SONG'
'\x03SOO'
'\x06SOUNAP'
'\x0eSOUTH ARABIAN '
'\x10SOUTH EAST ARROW'
'\x05SPACE'
'\nSPACE MARK'
'\x13SPACING CANDRABINDU'
'\x06SPATHI'
'\x08SPERSION'
'\x06SPIRAL'
'\x0bSPIRATED FA'
'\tSPIRITUS '
'\x0fSPOKED ASTERISK'
'\x07SPRINGS'
'\x06SQUARE'
'\x0eSQUARE BRACKET'
'\x07SQUARED'
'\x08SQUARED '
'\x11SQUARED TIMES KUR'
'\x0eSQUIGGLE ARROW'
'\x02SS'
'\x07SS-THAN'
'\x08SS-THAN '
'\x0cSS-THAN SIGN'
'\x03SSA'
'\nSSANGARAEA'
'\x0bSSANGKIYEOK'
'\nSSANGPIEUP'
'\tSSANGSIOS'
'\x05SSERA'
'\x08SSESSION'
'\x0bSSIVE-PULL-'
'\x02ST'
'\x0fST QUARTER MOON'
'\x0fST SYRIAC CROSS'
'\x03STA'
'\rSTABLE SYMBOL'
'\x06STANCE'
'\x06STANCY'
'\x04STAR'
'\x07STATERS'
'\x0fSTERESIS SYMBOL'
'\x07STERING'
'\x07STERISK'
'\x08STERISK '
'\x10STERISK OPERATOR'
'\rSTERTIUS SIGN'
'\x05STILE'
'\x07STIMATE'
'\x04STLE'
'\x06STOLI '
'\x04STOP'
'\x0bSTORIC SITE'
'\x05STORM'
'\x13STRATIAN FIFTY MNAS'
'\x10STRING FRETBOARD'
'\x06STROFO'
'\x06STROKE'
'\x07STROKE '
'\x19STROKE AND TWO DOTS ABOVE'
'\x0fSTROKE NOT SIGN'
'\x0eSTROKE OVERLAY'
'\x18STROKE THROUGH DESCENDER'
'\nSTROM SIGN'
'\x07STRUCK '
'\x03STU'
'\x02SU'
'\x03SU '
'\x06SUBSET'
'\x13SUBSTITUTION MARKER'
'\x07SUCCEED'
'\x08SUCCEEDS'
'\x04SUIT'
'\x04SUKU'
'\x05SUKUN'
'\x07SUKUUDO'
'\x03SUM'
'\x04SUNG'
'\x1dSUPERSCRIPT ALEF INITIAL FORM'
'\x1eSUPERSCRIPT ALEF ISOLATED FORM'
'\x08SUPERSET'
'\x0cSUR OVER SUR'
'\x06SURANG'
'\x0eSURROUND FROM '
'\x07SVARITA'
'\nSWASH TAIL'
'\x06SWORDS'
'\x02SY'
'\tSYLLABLE '
'\x06SYMBOL'
'\x07SYMBOL '
'\x0bSYMBOL FOR '
'\x12SYMMETRIC SWAPPING'
'\x16SYMPTOTICALLY EQUAL TO'
'\x06SYNAFI'
'\x07SYNAGMA'
'\rSYNDESMOS NEO'
'\tSYNTHETON'
'\x06SYOUWA'
'\x0bSYURA SASAK'
'\x01T'
'\x02T '
'\x07T ABOVE'
'\x07T BELOW'
'\x18T BLACK RIGHTWARDS ARROW'
'\x07T MINUS'
'\x07T RIGHT'
'\x02T0'
'\x02TA'
'\x03TA '
'\x07TA MARK'
'\x03TAA'
'\x08TAALUJA '
'\x03TAB'
'\x19TAB OVER TAB GAR OVER GAR'
'\tTABE SIGN'
'\x04TACK'
'\x05TACK '
'\nTACK BELOW'
'\x03TAH'
'\x08TAI LUE '
'\x06TAIKHU'
'\x04TAIL'
'\x04TAIN'
'\x07TAISYOU'
'\x04TAK4'
'\x06TAKANA'
'\tTAKHALLUS'
'\x03TAL'
'\x08TAL MARK'
'\nTAL RUNOUT'
'\x05TAL S'
'\x07TALENTS'
'\x1bTALIC LATIN CAPITAL LETTER '
'\x07TALL AA'
'\x03TAM'
'\x06TAMING'
'\x03TAN'
'\x11TAN ISOLATED FORM'
'\tTANDSTILL'
'\x03TAO'
'\x03TAR'
'\x08TART OF '
'\x13TART OF RUB EL HIZB'
'\x03TAS'
'\x06TATED '
'\x06TAU RO'
'\x06TAUROS'
'\x03TAV'
'\x04TAWA'
'\x07TAYANNA'
'\x03TCH'
'\x07TCHFORK'
'\x02TE'
'\x0cTE SEPARATOR'
'\x06TE TSE'
'\x18TEARDROP-SPOKED ASTERISK'
'"TEARDROP-SPOKED PROPELLER ASTERISK'
'\x04TED '
'\x06TEDUNG'
'\x04TEEN'
'\x15TEEN POINTED ASTERISK'
'\x05TEGEH'
'\x03TEH'
'\nTELEGRAPH '
'\x10TELOUS ICHIMATOS'
'\nTEMPLATION'
'\x03TEN'
'\x04TEN '
'\x11TEN THOUSAND SIGN'
'\x1aTENDED ARABIC-INDIC DIGIT '
'\x0bTENS DIGIT '
'\x04TENT'
'\x04TENU'
'\x03TER'
'\x04TER '
'\nTER SYMBOL'
'\x05TERIS'
'\nTERMINATOR'
'\x06TERNAT'
'\nTERNATIVE '
'\x19TERNION INTEGRAL OPERATOR'
'\x07TERNITY'
'\x06TERON '
'\x11TERSYLLABIC TSHEG'
'\nTESE CROSS'
'\x0eTETARTOS ICHOS'
'\x0bTETRAFONIAS'
'\x04TEXT'
'\x02TH'
'\x03TH '
'\x07TH MARK'
'\x07TH ROOT'
'\x03THA'
'\x0eTHAKA ANUDATTA'
'\x0eTHALAN ETHEL O'
'\x05THAM '
'\x0bTHAM DIGIT '
'\x08THAMASAT'
'\x13THANG LONG ANUSVARA'
'\nTHAPASCAN '
'\x05THEMA'
'\x0bTHEMATICAL '
'\x04THER'
'\x07THESEOS'
'\x0cTHETA SYMBOL'
'\x07THIEUTH'
'\x08THIOPIC '
'\x05THIRD'
'\x06THIRD '
'\rTHIRD SUBUNIT'
'\x06THIRDS'
'\x07THIRDS '
'\x0bTHIRDS SIGN'
'\nTHMIKON N '
'\x03THO'
'\x0cTHODOX CROSS'
'\x04THOR'
'\x06THORA '
'\x08THOUSAND'
'\tTHOUSAND '
'\x0eTHOUSANDS SIGN'
'\x06THREE '
'\x0bTHREE DOTS '
'\x10THREE DOTS ABOVE'
'\x1aTHREE DOTS ABOVE DOWNWARDS'
'\x0eTHREE QUARTERS'
'\x0bTHREE TIMES'
'\x14THROUGH SMALL CIRCLE'
'\x07THUNDER'
'\x03THY'
'\x02TI'
'\x04TIC '
'\x06TICAL '
'\x08TICK IN '
'\x0cTICLOCKWISE '
'\x03TIE'
'\x05TIGMA'
'\x06TIKENO'
'\x06TIKEUT'
'\x04TIKI'
'\x05TILDE'
'\x06TILDE '
'\x0fTILDE DIAERESIS'
'\x0eTILDE OPERATOR'
'\x15TILDE OPERATOR ABOVE '
'\x05TIMES'
'\x06TIMES '
'\tTIMES BAD'
'\x0eTIMES OPERATOR'
'\tTIMES PAP'
'\tTIMES SHE'
'\x0eTIMES SHU TENU'
'\nTIMES SIGN'
'\nTIMES TAK4'
'\x08TIMORION'
'\x04TIN '
'\x08TINGUISH'
'\x05TINNE'
'\x03TIO'
'\x08TION KEY'
'\x13TIONAL DIGIT SHAPES'
'\x04TIP '
'\x05TIPPI'
'\rTIRTA TUMETES'
'\x06TIRYAK'
'\x08TISMOS E'
'\x03TIV'
'\x07TIVATE '
'\x03TJE'
'\x05TKAAN'
'\x03TLE'
'\x07TLINED '
'\x05TMAAU'
'\x05TNESS'
'\x02TO'
'\x03TO '
'\x06TO BAR'
'\tTO CORNER'
'\x12TO LOWER LEFT FILL'
'\x13TO LOWER RIGHT FILL'
'\x08TO-LEFT '
'\tTO-RIGHT '
'\x10TODO SOFT HYPHEN'
'\nTOM SYMBOL'
'\x03TON'
'\x05TON A'
'\x0bTONAL MARK '
'\x05TONE '
'\x08TONE BAR'
'\tTONE MAI '
'\tTONE MARK'
'\x15TONE MARK SGAW KAREN '
'\x05TONE-'
'\x05TONOS'
'\x03TOO'
'\x03TOP'
'\x04TOP '
'\nTOP CORNER'
'\x0eTOP HALF BLACK'
'\rTOP HALF RING'
'\x14TOP SEMICIRCLE ARROW'
' TOP-LIGHTED RIGHTWARDS ARROWHEAD'
'\x06TOPBAR'
'\x16TORTOISE SHELL BRACKET'
'\tTOS ICHOS'
'\x0cTRAGRAM FOR '
'\x05TRAIF'
'\tTRAIGHT U'
'\x07TRAINER'
'\x14TRANSPOSITION MARKER'
'\x06TRAPLI'
'\nTRESS AND '
'\x0bTRESS SIGN '
'\nTRETCHED C'
'\x03TRI'
'\x04TRIA'
'\x08TRIANGLE'
' TRIANGLE-HEADED RIGHTWARDS ARROW'
'\x0fTRIANGULAR MARK'
'\x07TRICAL '
'\x08TRICOLON'
'\x13TRICTED LEFT ENTRY-'
'\x0cTRIPLE DANDA'
'\x0cTRIPLE DASH '
'\x11TRIPLE DASH ARROW'
'\x16TRIPLE RIGHT TURNSTILE'
'\x16TRIPLE VERTICAL STROKE'
'\rTROFLEX CLICK'
'\x12TROFLEX HOOK BELOW'
'\x05TROKE'
'\x0eTROKE NOT SIGN'
'\rTROKE OVERLAY'
'\x0bTRUNCATED A'
'\x02TS'
'\x05TSADI'
'\x05TSERE'
'\x05TSHEG'
'\x02TT'
'\x06TTAVA '
'\x05TTED '
'\tTTED STEM'
'\x19TTED SUBSTITUTION BRACKET'
'\x08TTENTION'
'\x04TTER'
'\x05TTER '
'\x05TTERN'
'\x07TTHACAN'
'\x08TTO MARK'
'\x05TTOCK'
'\x05TTOM '
'\x05TTORU'
'\x02TU'
'\x05TUEUM'
'\x04TUG2'
'!TUG2 OVER TUG2 TUG2 OVER TUG2 PAP'
'\x04TUKI'
'\tTUKWENTIS'
'\x03TUR'
'\x0eTURKIC LETTER '
'\x04TURN'
'\x0bTURN SYMBOL'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x08TURNED M'
'\x13TURNED PADA PISELEH'
'\x04TURU'
'\tTUTEYASAT'
'\x05TUUMU'
'\x0fTVIMADUR SYMBOL'
'\x03TWA'
'\x04TWAA'
'\x05TWEEL'
'\x03TWO'
'\x0eTWO DOT LEADER'
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO DOTS ABOVE'
'!TWO DOTS ABOVE AND TWO DOTS BELOW'
'\x16TWO HORIZONTAL STROKES'
'#TWO HORIZONTAL STROKES TO THE RIGHT'
'\nTWO SHORTS'
'\nTWO THIRDS'
'\x0eTWO WHITE DOTS'
'\x0fTWO WITH STROKE'
'\x02TY'
'\x06TY SET'
'\nTYPE COLON'
'\x05TYPE-'
'\x05TYR T'
'\x01U'
'\x02U '
'\rU LENGTH MARK'
'\x06U MARK'
'\x08U PLUS U'
'\x0fU PLUS U PLUS U'
'\x1aU REVERSED OVER U REVERSED'
'\x03U U'
'\rU WITH STROKE'
'\x02U0'
'\x02U2'
'\x02U3'
'\nU3 PLUS AN'
'\x02UA'
'\x03UAE'
'\x03UAN'
'\nUARDEDNESS'
'\x08UAREG YA'
'\x03UAT'
'\x08UATRILLO'
'\x02UB'
'\x03UB2'
'\x07UBADAMA'
'\x04UBED'
'\x0eUBHAYATO MUKHA'
'\x05UBITO'
'\x10UBJOINED LETTER '
'\x04UBLE'
'\x05UBLE '
'\x08UBLE BAR'
'\nUBLE DANDA'
'\nUBLE DASH '
'\nUBLE GRAVE'
'\x0fUBLE RING BELOW'
'\x0cUBLE SVARITA'
'\x0bUBLE TONGUE'
'\x14UBLE VERTICAL STROKE'
'\x06UBLE X'
'\x16UBSCRIPT SMALL LETTER '
'\x0cUBSCRIPT TWO'
'\tUBSTITUTE'
'\x13UBSTITUTION BRACKET'
'\x07UBUFILI'
'\x05UBURU'
'\x05UBUTS'
'\x05UCEUS'
'\x02UD'
'\x05UDAAT'
'\x06UDATTA'
'\x03UDY'
'\x02UE'
'\x03UEH'
'\rUFFLE PRODUCT'
'\x06UFISMA'
'\x02UG'
'\x0bUG RTAGS GY'
'\x0fUGMENTATION DOT'
'\x04UGU '
'\x05UGUST'
'\x04UHUR'
'6UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA '
'\x03UJA'
'\x02UK'
'\x05UKARA'
'\x07UKKAKHA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x03UL '
'\x08ULA SIGN'
'\x0bULAR BULLET'
'\x10ULDERED OPEN BOX'
'\x06ULDRON'
'\x0fULGAR FRACTION '
'\x03ULL'
'\x12ULL AND CROSSBONES'
'\x0cULL NOTEHEAD'
'\x08ULL STOP'
'\x08ULLS LEG'
'\x0bULO TWO SUM'
'\x04ULTI'
')ULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT'
'\x03ULU'
'\x04ULU '
'\x04ULUG'
'\x02UM'
'\x07UM IYEK'
'\nUM ROTUNDA'
'\x0fUMAI PALAUNG FA'
'\x04UMAN'
'\nUMAN EARTH'
'\nUMBER SIGN'
'\tUMED HEAD'
'\x08UMMATION'
'\x05UMMER'
'\x03UMX'
'\x02UN'
'\x0cUN WITH RAYS'
'\x04UNAH'
'\x04UNAP'
'\x06UNATE '
'\x12UNATE SIGMA SYMBOL'
'\x04UNAV'
'\nUNCIA SIGN'
'\x0bUNCTUATION '
'\x10UNCTUATION SPACE'
'\x04UND '
'\x08UND SIGN'
'\x05UNDER'
'\x0eUNDER RELATION'
'\x08UNDERBAR'
'\x08UNDERTIE'
'\x07UNDRED '
'\x03UNG'
'\tUNGSEONG '
'\x05UNION'
'\x0eUNION OPERATOR'
'\x11UNION WITH SERIFS'
'\x0bUNIT DIGIT '
'\x0eUNIT SEPARATOR'
'\x05UNITY'
'\x0bUNJO WYNN W'
'\nUNKIA SIGN'
'\x04UNNY'
'\x05UNOO '
'\x03UNT'
'\x06UNTAIN'
'\x02UO'
'\x03UON'
'\x04UON '
'\x03UOP'
'\x02UP'
'\x03UP '
'\x07UP AND '
'\x11UP AND HORIZONTAL'
'\x08UP ARROW'
'\x0cUP ARROWHEAD'
'\x12UP ARROWHEAD BELOW'
'\x06UP BOW'
'\nUP HARPOON'
'\x08UP HEAVY'
'\x1cUP HEAVY AND LEFT DOWN LIGHT'
'\x1dUP HEAVY AND RIGHT DOWN LIGHT'
'\x13UP HORIZONTAL HEAVY'
'\x13UP HORIZONTAL LIGHT'
'\x08UP LIGHT'
'\x07UP MARK'
'\x0eUP RIGHT BARB '
'\x07UP TACK'
'\x10UP-OUTPUT SYMBOL'
'\x0bUPADHMANIYA'
'\rUPERIMPOSED X'
'\x10UPERSCRIPT ALAPH'
'\x0fUPERSCRIPT ALEF'
'\x04UPLE'
'\x05UPLE '
'\rUPONDIUS SIGN'
'\x06UPPER '
'\x0cUPPER CORNER'
'\tUPPER DOT'
'\nUPPER HALF'
'\nUPPER HOOK'
'\x16UPPER RIGHT AND LOWER '
'+UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW'
'\x18UPRIGHT RECTANGULAR ZERO'
'\x07UPSILON'
'\rUPSILON WITH '
'\tUPTSTIMME'
'\x06UPTURN'
'\x18UPWARD POINTING TRIANGLE'
'\x07UPWARDS'
'\x1cUPWARDS AND RIGHTWARDS ARROW'
'\rUPWARDS ARROW'
'\x1fUPWARDS HARPOON WITH BARB RIGHT'
'\x02UQ'
'\x02UR'
'\nUR CORNERS'
'\nUR HUNDRED'
'\nUR YIG MGO'
'\x03UR-'
'\x03URA'
'\tURAMAZDAA'
'\x05URAMU'
'\tURASHTRA '
'\x07URATION'
'\x04URCH'
'\x04URDA'
'\x05URDA '
'\x03URE'
'\x07URGLASS'
'\x05URITY'
'\x03URL'
'\x0cURLY BRACKET'
'\x03URN'
'\x06URNED '
'\x0bURNED COMMA'
'\x11URNED COMMA ABOVE'
'\tURNED GAN'
'\x13URRENCY SYMBOL BAHT'
'\x13URRENCY SYMBOL RIEL'
'\x03URT'
'\x06URTEEN'
'\x05URTLE'
'\x03URU'
'\x04URUS'
'\tURUZ UR U'
'\x02US'
'\x04USA '
'\x03USE'
"'USED AS KORANIC STOP SIGN ISOLATED FORM"
'\x03USH'
'\rUSHING UPWARD'
'\rUSICAL LEIMMA'
'\x0eUSPENSION MARK'
'\x07USSYERU'
'\x0fUSTER NOTEHEAD '
'\x16USTOMER ACCOUNT NUMBER'
'\x0bUSTRAL SIGN'
'\x02UT'
'\x04UT H'
'\nUT NOT EQU'
'\x07UT TIME'
'\x03UTE'
'\x05UTE A'
'\x04UTER'
'\tUTER JOIN'
'\x0bUTH CORNERS'
'\x0cUTH-SLAVEY K'
'\x05UTIES'
'\nUTION SIGN'
'\x12UTLINED BLACK STAR'
'\x02UU'
'\x06UUMISH'
'\tUURDHAJA '
'\x02UX'
'\x06UYANNA'
'\x02UZ'
'\x06UZEIRO'
'\x0bUZEIRO SIGN'
'\x01V'
'\x08V OVER M'
'\x02V0'
'\x02VA'
'\x05VAAVU'
'\x07VAGRAHA'
'\x0cVAKRAHASANYA'
'\x14VAL WITH OVAL INSIDE'
'\x07VALENT '
'\x0bVAMAGOMUKHA'
'\tVANAGARI '
'\x07VANESE '
'\x05VARIA'
'\x0eVARIANT FORM A'
'\x11VARIANT FORM ASH9'
'\x10VARIANT FORM ESH'
'\x13VARIANT FORM ILIMMU'
'\x11VARIANT FORM IMIN'
'\x12VARIANT FORM LIMMU'
'\x11VARIANT FORM USSU'
'\x13VARIANT WITH SQUARE'
'\x13VARIATION INDICATOR'
'\x0bVARYS ICHOS'
'\x05VASIS'
'\x13VASTNESS OR WASTING'
'\x03VAV'
'\x07VAV YOD'
'\x07VAYANNA'
'\x02VE'
'\x03VE '
'\x07VE DOT '
'\x10VE EIGHTHS BLOCK'
'\nVE HUNDRED'
'\x08VE SASAK'
'\rVE-LINE STAFF'
' VED STEM PARAGRAPH SIGN ORNAMENT'
'\x04VEDE'
'\x03VEE'
'\x11VEE WITH UNDERBAR'
'\x06VELOPE'
'\tVELOPMENT'
'\x03VEN'
'\x11VEN EIGHTHS BLOCK'
'\x03VER'
'\x0cVER EQUAL TO'
'\tVER LUGAL'
'\x05VER S'
'\x11VERAGE WITH SLASH'
'\x08VERGENCE'
'\x07VERLINE'
'\tVERLONG A'
'\x17VERSAL RECYCLING SYMBOL'
'\x05VERSE'
'\rVERSE DIVIDER'
'\x13VERSE FINAL BARLINE'
'\x07VERSED '
'\x08VERTICAL'
'\tVERTICAL '
'\x0eVERTICAL ABOVE'
'\nVERTICAL B'
'\x0cVERTICAL BAR'
'\rVERTICAL BAR '
'(VERTICAL BAR AT END OF HORIZONTAL STROKE'
'\x17VERTICAL BISECTING LINE'
'\x0eVERTICAL COLON'
'\rVERTICAL FILL'
'\x0eVERTICAL HEAVY'
'\x0eVERTICAL LIGHT'
'\rVERTICAL LINE'
'\x13VERTICAL LINE BELOW'
'\x15VERTICAL LINE OVERLAY'
'\x0fVERTICAL STROKE'
'\x13VERTICAL TABULATION'
'\x10VERTICALLY ABOVE'
'\x08VESSEL B'
'\x07VESTAN '
'\x07VEW NOW'
'\x02VI'
'\x0cVIAN LETTER '
'\rVICE CONTROL '
'\x04VIDA'
'\x04VIDE'
'\x05VIET '
'\x06VILIAN'
'\x07VILIK B'
'\x03VIN'
'\x08VINATION'
'\x04VINE'
'\nVIOUS PAGE'
'\x03VIR'
'\x06VIRAMA'
'\x06VIRIAM'
'\x03VIS'
'\x07VISARGA'
'\x08VISARGA '
'\x0bVISARGA ONE'
'\tVISARGAYA'
'\x08VISION S'
'\x06VIYANI'
'\x02VO'
'\x08VOCALIC '
'\tVOCALIC R'
'\x05VOICE'
'\x15VOICED ITERATION MARK'
'\x18VOICED LARYNGEAL SPIRANT'
'\x11VOICED SOUND MARK'
'\x08VOLUTION'
'\x0eVONIC ASTERISK'
'\x03VOU'
'\x03VOW'
'\x05VOWEL'
'\x06VOWEL '
'\x0fVOWEL SEPARATOR'
'\x0fVOWEL SHORTENER'
'\x0bVOWEL SIGN '
'\rVOWEL SIGN PA'
'\x11VRE TOURNOIS SIGN'
'\x05VRIDO'
'\x0eVRON SNOWFLAKE'
'\x02VU'
'\x03VUU'
'\x03VY '
'\x05VZMET'
'\x01W'
'\x02W '
'\x06W LINE'
'\nW OR MODEL'
'\rW RING INSIDE'
'\x02W0'
'\x02WA'
'\x03WAA'
'\x04WAAK'
'\x05WAAVU'
'\x04WAHA'
'\x03WAI'
'\x04WAIR'
'\x03WAN'
'\x05WARDS'
'\x06WARDS '
'\x0bWARDS ARROW'
'\x11WARDS ARROW BELOW'
'\x0cWARDS BULLET'
'!WARDS HARPOON WITH BARB DOWNWARDS'
'\nWARDS VANE'
'\x14WARE-FUNCTION SYMBOL'
'\x16WASALLAM ISOLATED FORM'
'\x08WASH KAF'
'\tWASH TAIL'
'\x05WATTO'
'\x03WAU'
'\x04WAVE'
'\x0bWAVY HAMZA '
'\rWAVY LOW LINE'
'\rWAVY OVERLINE'
'\x03WAW'
'\x04WAW '
'\rWAW-AYIN-RESH'
'\x03WAZ'
'\x07WAZ EOH'
'\x02WE'
'\x04WEEN'
'\x04WEET'
'\x05WENTY'
'\x06WEORTH'
'\x03WER'
'\x04WER '
'\x05WEST '
'\x12WESTERN PWO KAREN '
'\x17WESTERN PWO KAREN TONE-'
'\x02WG'
'\x05WHITE'
'\x06WHITE '
'\x0bWHITE ARROW'
'\x0cWHITE CIRCLE'
'\x0fWHITE DOT RIGHT'
'\x11WHITE PARENTHESIS'
'\x11WHITE SHOGI PIECE'
'\nWHITE STAR'
'\x12WHITE VERTICAL BAR'
'\x05WIANG'
'\x05WIDE '
'\x11WIDE BRIDGE ABOVE'
'\x06WIDTH '
'\x0cWIGGLY FENCE'
'\x07WIGNYAN'
'\x04WIND'
'\x05WINDU'
'\x05WINJA'
'\x05WISAD'
'\x05WITH '
'\rWITH ASTERISK'
'\nWITH BARB '
'\nWITH CARON'
'\x10WITH CENTRED DOT'
'\x0eWITH DIAERESIS'
'\tWITH DOT '
'\x0eWITH DOT ABOVE'
'\x0eWITH DOT BELOW'
'\x0fWITH DOWN ARROW'
'\x0eWITH FATHATAN '
'\x14WITH FOUR DOTS ABOVE'
'\x10WITH HAMZA ABOVE'
'\tWITH HOOK'
'\x16WITH HORIZONTAL STROKE'
'\rWITH INTEGRAL'
'\x16WITH JEEM INITIAL FORM'
'\nWITH MEEM '
'\x11WITH NOT EQUAL TO'
"'WITH OPEN ARM ENDING IN ARROW POINTING "
'\x0fWITH RAIN DROPS'
'\x0cWITH STROKE '
'\x12WITH STROKE SYMBOL'
'\x06WITH T'
'\x15WITH THREE DOTS ABOVE'
'\rWITH TWO DOTS'
'\rWITH UNDERBAR'
'\x16WITH VOICED SOUND MARK'
'\x13WITH YEH FINAL FORM'
'\x05WLINE'
'\x02WN'
'\x03WN '
'\x08WN ARROW'
'\x0cWN ARROWHEAD'
'\x06WN BOW'
'\x06WN BOX'
'\x07WN TACK'
'\rWN TACK BELOW'
'\x02WO'
'\x03WO '
'\x08WO ABOVE'
'\x08WO DOTS '
'\rWO DOTS ABOVE'
'\rWO DOTS BELOW'
'\x1bWO DOTS BELOW AND DOT ABOVE'
' WO DOTS OVER ONE DOT PUNCTUATION'
'\x18WO DOTS VERTICALLY ABOVE'
'&WO DOTS VERTICALLY BELOW AND SMALL TAH'
'\x07WO FOR '
'\x0fWO HEADED ARROW'
'\x07WO MARK'
'\x06WO OF '
'\nWO SHORTS '
'\x11WO VERTICAL DOTS '
'\x07WO WAEN'
'\rWO-LINE STAFF'
'\x17WO-WAY LEFT WAY TRAFFIC'
'\x08WON SIGN'
'\x0cWORD DIVIDER'
'\x0eWORD SEPARATOR'
'\tWORDSPACE'
'\x04WTIE'
'\x02WU'
'\x05WU318'
'\x04WULU'
'\tWUNG DASH'
'\x04WYNN'
'\x01X'
'\x02X '
'\x0bX DRAWINGS '
'\nX NOTEHEAD'
'\x03X00'
'\x02XA'
'\x05XAGON'
'\x0bXAGRAM FOR '
'\x03XAN'
'\x08XCELLENT'
'\x0fXCLAMATION MARK'
'\x10XCLAMATION MARK '
'\x02XE'
'\x03XEH'
'\x04XEIA'
'\x0bXESTES SIGN'
'\x02XG'
'\tXHAUSTION'
'\x02XI'
'\x03XIA'
'\tXIMATELY '
'\x0cXIRON KLASMA'
'\x02XO'
'\x0eXO EKFONITIKON'
'\x06XO NEO'
'\x02XT'
'\x07XT PAGE'
'\x0fXTEEN FULL STOP'
'\x05XTILE'
'\x05XTRA-'
'\x03XWG'
'\x01Y'
'\x02Y '
'\x07Y MUCH '
'\x11Y ON BLACK SQUARE'
'\x0eY SMALL SQUARE'
'\tY-FOURTH '
'\x03Y00'
'\x02YA'
'\x03YA '
'\x03YAA'
'\x07YAH LI '
'\x0bYAJURVEDIC '
'\x1aYAJURVEDIC MIDLINE SVARITA'
'\x06YAKASH'
'\x05YAMOK'
'\x04YANG'
'\x07YANMAR '
'\x05YANNA'
'\tYANUKITTA'
'\x03YAT'
'\x10YATHOS BASE SIGN'
'\x07YAYANNA'
'\x08YBEYFILI'
'\x06YBOARD'
'\x02YE'
'\tYEAR SIGN'
'\x05YECEK'
'\x03YEE'
'\x03YEH'
'\x04YEH '
'\tYEH ABOVE'
'\x0eYEH FINAL FORM'
'\x11YEH ISOLATED FORM'
'\tYEH WITH '
'\x06YELLOW'
'\x17YELORUSSIAN-UKRAINIAN I'
'\x08YEN SIGN'
'\x05YENAP'
'\x08YENISEI '
'\x0bYEORINHIEUH'
'\x08YER YAGH'
'\x05YEROK'
'\x06YFESIS'
'\x06YGISMA'
'\x02YI'
'\x08YIDDISH '
'\x07YIG MGO'
'\x08YIG MGO '
'\x0fYIG MGO MDUN MA'
'\x14YIG MGO PHUR SHAD MA'
'\x0fYIG MGO SGAB MA'
'\x15YIG MGO TSHEG SHAD MA'
'\x03YIN'
'\x06YIN-DO'
'\x04YIS '
'\x05YIZET'
'\x06YLISMA'
'\x08YLLABLE '
'\x06YMBOL '
'\x15YMPTOTICALLY EQUAL TO'
'\x02YN'
'\x0fYNCHRONOUS IDLE'
'\x03YNN'
'\x02YO'
'\x03YOD'
'\rYOD YOD PATAH'
'\x04YODH'
'\x03YOO'
'\x03YOT'
'\x0eYOUTHFUL FOLLY'
'\x0cYOUTHFULNESS'
'\x05YPHEN'
'\rYPOGEGRAMMENI'
'\x08YPORROON'
'\x0cYPTOGRAMMIC '
'\x02YR'
'\tYRANISMA '
'\x14YRENAIC TWO DRACHMAS'
'\x0bYRIGHT SIGN'
'\x08YRILLIC '
'\nYRILLIC EN'
'\x02YT'
'\x02YU'
'\x04YUDH'
'\x04YUKU'
'\x05YURII'
'\x03YUT'
'\rYUUKALEAPINTU'
'\x03YWA'
'\x04YWAA'
'\x18YZANTINE MUSICAL SYMBOL '
'\x01Z'
'\tZ DIGRAPH'
'\x02Z0'
'\x02Z2'
'\x02ZA'
'\x0eZAH WITH MEEM '
'\x03ZAI'
'\x04ZAIN'
'\x0fZAIN FINAL FORM'
'\tZAL SASAK'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x02ZE'
'\x04ZELO'
'\x03ZEN'
'\tZENE RING'
'\x05ZENGE'
'\x03ZER'
'\x04ZERO'
'\x1bZERO FOR ODD POWERS OF FOUR'
'\tZERO SIGN'
'\x0bZERO THIRDS'
'\x04ZETA'
'\x02ZH'
'\nZH DIGRAPH'
'\x03ZHA'
'\x05ZHAIN'
'\x06ZHITSA'
'\rZHOU NUMERAL '
'\x02ZI'
'\tZIDA TENU'
'\x04ZIET'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\x0bZIGZAG LINE'
'\x05ZILDE'
'\tZIR SASAK'
'\x03ZJE'
'\x02ZO'
'\x03ZOO'
'\x07ZQAPHA '
'\x03ZUP'
'\x08ZWARAKAY'
'\x05ZYGOS'
)
_charnodes =[70758,
 -54013,
 -1,
 132371,
 28800,
 -1,
 197694,
 78444,
 -1,
 262727,
 136035,
 -1,
 327957,
 202075,
 -1,
 393238,
 282270,
 -1,
 -65529,
 347806,
 195071,
 -65528,
 409767,
 195070,
 -65527,
 472620,
 195069,
 -65526,
 535811,
 195068,
 -65525,
 599707,
 195067,
 -65524,
 660878,
 195066,
 -65523,
 726363,
 195065,
 -65522,
 791847,
 195064,
 -65521,
 857312,
 195063,
 -65520,
 922779,
 195062,
 -65519,
 988195,
 195061,
 -65518,
 1053654,
 195060,
 -65517,
 1119078,
 195059,
 -65516,
 1184449,
 195058,
 -65515,
 1249833,
 195057,
 -1,
 1315241,
 195056,
 1507367,
 344231,
 -1,
 -65512,
 1461918,
 195055,
 -65511,
 1523879,
 195054,
 -65510,
 1586732,
 195053,
 -65509,
 1649923,
 195052,
 -65508,
 1713819,
 195051,
 -65507,
 1774990,
 195050,
 -65506,
 1840475,
 195049,
 -65505,
 1905959,
 195048,
 -65504,
 1971424,
 195047,
 -65503,
 2036891,
 195046,
 -65502,
 2102307,
 195045,
 -65501,
 2167766,
 195044,
 -65500,
 2233190,
 195043,
 -65499,
 2298561,
 195042,
 -65498,
 2363945,
 195041,
 -1,
 2429353,
 195040,
 2621496,
 1455660,
 -1,
 -65495,
 2576030,
 195039,
 -65494,
 2637991,
 195038,
 -65493,
 2700844,
 195037,
 -65492,
 2764035,
 195036,
 -65491,
 2827931,
 195035,
 -65490,
 2889102,
 195034,
 -65489,
 2954587,
 195033,
 -65488,
 3020071,
 195032,
 -65487,
 3085536,
 195031,
 -65486,
 3151003,
 195030,
 -65485,
 3216419,
 195029,
 -65484,
 3281878,
 195028,
 -65483,
 3347302,
 195027,
 -65482,
 3412673,
 195026,
 -65481,
 3478057,
 195025,
 -1,
 3543465,
 195024,
 3735625,
 2567427,
 -1,
 -65478,
 3690142,
 195023,
 -65477,
 3752103,
 195022,
 -65476,
 3814956,
 195021,
 -65475,
 3878147,
 195020,
 -65474,
 3942043,
 195019,
 -65473,
 4003214,
 195018,
 -65472,
 4068699,
 195017,
 -65471,
 4134183,
 195016,
 -65470,
 4199648,
 195015,
 -65469,
 4265115,
 195014,
 -65468,
 4330531,
 195013,
 -65467,
 4395990,
 195012,
 -65466,
 4461414,
 195011,
 -65465,
 4526785,
 195010,
 -65464,
 4592169,
 195009,
 -1,
 4657577,
 195008,
 4849754,
 3679899,
 -1,
 -65461,
 4804254,
 195007,
 -65460,
 4866215,
 195006,
 -65459,
 4929068,
 195005,
 -65458,
 4992259,
 195004,
 -65457,
 5056155,
 195003,
 -65456,
 5117326,
 195002,
 -65455,
 5182811,
 195001,
 -65454,
 5248295,
 195000,
 -65453,
 5313760,
 194999,
 -65452,
 5379227,
 194998,
 -65451,
 5444643,
 194997,
 -65450,
 5510102,
 194996,
 -65449,
 5575526,
 194995,
 -65448,
 5640897,
 194994,
 -65447,
 5706281,
 194993,
 -1,
 5771689,
 194992,
 5963883,
 4789646,
 -1,
 -65444,
 5918366,
 194991,
 -65443,
 5980327,
 194990,
 -65442,
 6043180,
 194989,
 -65441,
 6106371,
 194988,
 -65440,
 6170267,
 194987,
 -65439,
 6231438,
 194986,
 -65438,
 6296923,
 194985,
 -65437,
 6362407,
 194984,
 -65436,
 6427872,
 194983,
 -65435,
 6493339,
 194982,
 -65434,
 6558755,
 194981,
 -65433,
 6624214,
 194980,
 -65432,
 6689638,
 194979,
 -65431,
 6755009,
 194978,
 -65430,
 6820393,
 194977,
 -1,
 6885801,
 194976,
 7078012,
 5903707,
 -1,
 -65427,
 7032478,
 194975,
 -65426,
 7094439,
 194974,
 -65425,
 7157292,
 194973,
 -65424,
 7220483,
 194972,
 -65423,
 7284379,
 194971,
 -65422,
 7345550,
 194970,
 -65421,
 7411035,
 194969,
 -65420,
 7476519,
 194968,
 -65419,
 7541984,
 194967,
 -65418,
 7607451,
 194966,
 -65417,
 7672867,
 194965,
 -65416,
 7738326,
 194964,
 -65415,
 7803750,
 194963,
 -65414,
 7869121,
 194962,
 -65413,
 7934505,
 194961,
 -1,
 7999913,
 194960,
 8192141,
 7017767,
 -1,
 -65410,
 8146590,
 194959,
 -65409,
 8208551,
 194958,
 -65408,
 8271404,
 194957,
 -65407,
 8334595,
 194956,
 -65406,
 8398491,
 194955,
 -65405,
 8459662,
 194954,
 -65404,
 8525147,
 194953,
 -65403,
 8590631,
 194952,
 -65402,
 8656096,
 194951,
 -65401,
 8721563,
 194950,
 -65400,
 8786979,
 194949,
 -65399,
 8852438,
 194948,
 -65398,
 8917862,
 194947,
 -65397,
 8983233,
 194946,
 -65396,
 9048617,
 194945,
 -1,
 9114025,
 194944,
 9306270,
 8131808,
 -1,
 -65393,
 9260702,
 194943,
 -65392,
 9322663,
 194942,
 -65391,
 9385516,
 194941,
 -65390,
 9448707,
 194940,
 -65389,
 9512603,
 194939,
 -65388,
 9573774,
 194938,
 -65387,
 9639259,
 194937,
 -65386,
 9704743,
 194936,
 -65385,
 9770208,
 194935,
 -65384,
 9835675,
 194934,
 -65383,
 9901091,
 194933,
 -65382,
 9966550,
 194932,
 -65381,
 10031974,
 194931,
 -65380,
 10097345,
 194930,
 -65379,
 10162729,
 194929,
 -1,
 10228137,
 194928,
 10420399,
 9245851,
 -1,
 -65376,
 10374814,
 194927,
 -65375,
 10436775,
 194926,
 -65374,
 10499628,
 194925,
 -65373,
 10562819,
 194924,
 -65372,
 10626715,
 194923,
 -65371,
 10687886,
 194922,
 -65370,
 10753371,
 194921,
 -65369,
 10818855,
 194920,
 -65368,
 10884320,
 194919,
 -65367,
 10949787,
 194918,
 -65366,
 11015203,
 194917,
 -65365,
 11080662,
 194916,
 -65364,
 11146086,
 194915,
 -65363,
 11211457,
 194914,
 -65362,
 11276841,
 194913,
 -1,
 11342249,
 194912,
 11534528,
 10359843,
 -1,
 -65359,
 11488926,
 194911,
 -65358,
 11550887,
 194910,
 -65357,
 11613740,
 194909,
 -65356,
 11676931,
 194908,
 -65355,
 11740827,
 194907,
 -65354,
 11801998,
 194906,
 -65353,
 11867483,
 194905,
 -65352,
 11932967,
 194904,
 -65351,
 11998432,
 194903,
 -65350,
 12063899,
 194902,
 -65349,
 12129315,
 194901,
 -65348,
 12194774,
 194900,
 -65347,
 12260198,
 194899,
 -65346,
 12325569,
 194898,
 -65345,
 12390953,
 194897,
 -1,
 12456361,
 194896,
 12648657,
 11473878,
 -1,
 -65342,
 12603038,
 194895,
 -65341,
 12664999,
 194894,
 -65340,
 12727852,
 194893,
 -65339,
 12791043,
 194892,
 -65338,
 12854939,
 194891,
 -65337,
 12916110,
 194890,
 -65336,
 12981595,
 194889,
 -65335,
 13047079,
 194888,
 -65334,
 13112544,
 194887,
 -65333,
 13178011,
 194886,
 -65332,
 13243427,
 194885,
 -65331,
 13308886,
 194884,
 -65330,
 13374310,
 194883,
 -65329,
 13439681,
 194882,
 -65328,
 13505065,
 194881,
 -1,
 13570473,
 194880,
 13762786,
 12587878,
 -1,
 -65325,
 13717150,
 194879,
 -65324,
 13779111,
 194878,
 -65323,
 13841964,
 194877,
 -65322,
 13905155,
 194876,
 -65321,
 13969051,
 194875,
 -65320,
 14030222,
 194874,
 -65319,
 14095707,
 194873,
 -65318,
 14161191,
 194872,
 -65317,
 14226656,
 194871,
 -65316,
 14292123,
 194870,
 -65315,
 14357539,
 194869,
 -65314,
 14422998,
 194868,
 -65313,
 14488422,
 194867,
 -65312,
 14553793,
 194866,
 -65311,
 14619177,
 194865,
 -1,
 14684585,
 194864,
 14876915,
 13701825,
 -1,
 -65308,
 14831262,
 194863,
 -65307,
 14893223,
 194862,
 -65306,
 14956076,
 194861,
 -65305,
 15019267,
 194860,
 -65304,
 15083163,
 194859,
 -65303,
 15144334,
 194858,
 -65302,
 15209819,
 194857,
 -65301,
 15275303,
 194856,
 -65300,
 15340768,
 194855,
 -65299,
 15406235,
 194854,
 -65298,
 15471651,
 194853,
 -65297,
 15537110,
 194852,
 -65296,
 15602534,
 194851,
 -65295,
 15667905,
 194850,
 -65294,
 15733289,
 194849,
 -1,
 15798697,
 194848,
 15991044,
 14815785,
 -1,
 -65291,
 15945374,
 194847,
 -65290,
 16007335,
 194846,
 -65289,
 16070188,
 194845,
 -65288,
 16133379,
 194844,
 -65287,
 16197275,
 194843,
 -65286,
 16258446,
 194842,
 -65285,
 16323931,
 194841,
 -65284,
 16389415,
 194840,
 -65283,
 16454880,
 194839,
 -65282,
 16520347,
 194838,
 -65281,
 16585763,
 194837,
 -65280,
 16651222,
 194836,
 -65279,
 16716646,
 194835,
 -65278,
 16782017,
 194834,
 -65277,
 16847401,
 194833,
 -1,
 16912809,
 194832,
 17170431,
 15929769,
 -1,
 -65274,
 17059486,
 194831,
 -65273,
 17121447,
 194830,
 -65272,
 17184300,
 194829,
 -65271,
 17247491,
 194828,
 -65270,
 17311387,
 194827,
 -65269,
 17372558,
 194826,
 -65268,
 17438043,
 194825,
 -65267,
 17503527,
 194824,
 -65266,
 17568992,
 194823,
 -65265,
 17634459,
 194822,
 -65264,
 17699875,
 194821,
 -65263,
 17765334,
 194820,
 -65262,
 17830758,
 194819,
 -65261,
 17896129,
 194818,
 -65260,
 17961513,
 194817,
 -1,
 18026921,
 194816,
 18219558,
 267559,
 -1,
 18284839,
 18173598,
 -1,
 -65256,
 18239134,
 194815,
 -65255,
 18301095,
 194814,
 -65254,
 18363948,
 194813,
 -65253,
 18427139,
 194812,
 -65252,
 18491035,
 194811,
 -65251,
 18552206,
 194810,
 -65250,
 18617691,
 194809,
 -65249,
 18683175,
 194808,
 -65248,
 18748640,
 194807,
 -65247,
 18814107,
 194806,
 -65246,
 18879523,
 194805,
 -65245,
 18944982,
 194804,
 -65244,
 19010406,
 194803,
 -65243,
 19075777,
 194802,
 -65242,
 19141161,
 194801,
 -1,
 19206569,
 194800,
 19398968,
 18235559,
 -1,
 -65239,
 19353246,
 194799,
 -65238,
 19415207,
 194798,
 -65237,
 19478060,
 194797,
 -65236,
 19541251,
 194796,
 -65235,
 19605147,
 194795,
 -65234,
 19666318,
 194794,
 -65233,
 19731803,
 194793,
 -65232,
 19797287,
 194792,
 -65231,
 19862752,
 194791,
 -65230,
 19928219,
 194790,
 -65229,
 19993635,
 194789,
 -65228,
 20059094,
 194788,
 -65227,
 20124518,
 194787,
 -65226,
 20189889,
 194786,
 -65225,
 20255273,
 194785,
 -1,
 20320681,
 194784,
 20513097,
 19346988,
 -1,
 -65222,
 20467358,
 194783,
 -65221,
 20529319,
 194782,
 -65220,
 20592172,
 194781,
 -65219,
 20655363,
 194780,
 -65218,
 20719259,
 194779,
 -65217,
 20780430,
 194778,
 -65216,
 20845915,
 194777,
 -65215,
 20911399,
 194776,
 -65214,
 20976864,
 194775,
 -65213,
 21042331,
 194774,
 -65212,
 21107747,
 194773,
 -65211,
 21173206,
 194772,
 -65210,
 21238630,
 194771,
 -65209,
 21304001,
 194770,
 -65208,
 21369385,
 194769,
 -1,
 21434793,
 194768,
 21627226,
 20458755,
 -1,
 -65205,
 21581470,
 194767,
 -65204,
 21643431,
 194766,
 -65203,
 21706284,
 194765,
 -65202,
 21769475,
 194764,
 -65201,
 21833371,
 194763,
 -65200,
 21894542,
 194762,
 -65199,
 21960027,
 194761,
 -65198,
 22025511,
 194760,
 -65197,
 22090976,
 194759,
 -65196,
 22156443,
 194758,
 -65195,
 22221859,
 194757,
 -65194,
 22287318,
 194756,
 -65193,
 22352742,
 194755,
 -65192,
 22418113,
 194754,
 -65191,
 22483497,
 194753,
 -1,
 22548905,
 194752,
 22741355,
 21571227,
 -1,
 -65188,
 22695582,
 194751,
 -65187,
 22757543,
 194750,
 -65186,
 22820396,
 194749,
 -65185,
 22883587,
 194748,
 -65184,
 22947483,
 194747,
 -65183,
 23008654,
 194746,
 -65182,
 23074139,
 194745,
 -65181,
 23139623,
 194744,
 -65180,
 23205088,
 194743,
 -65179,
 23270555,
 194742,
 -65178,
 23335971,
 194741,
 -65177,
 23401430,
 194740,
 -65176,
 23466854,
 194739,
 -65175,
 23532225,
 194738,
 -65174,
 23597609,
 194737,
 -1,
 23663017,
 194736,
 23855484,
 22680974,
 -1,
 -65171,
 23809694,
 194735,
 -65170,
 23871655,
 194734,
 -65169,
 23934508,
 194733,
 -65168,
 23997699,
 194732,
 -65167,
 24061595,
 194731,
 -65166,
 24122766,
 194730,
 -65165,
 24188251,
 194729,
 -65164,
 24253735,
 194728,
 -65163,
 24319200,
 194727,
 -65162,
 24384667,
 194726,
 -65161,
 24450083,
 194725,
 -65160,
 24515542,
 194724,
 -65159,
 24580966,
 194723,
 -65158,
 24646337,
 194722,
 -65157,
 24711721,
 194721,
 -1,
 24777129,
 194720,
 24969613,
 23795035,
 -1,
 -65154,
 24923806,
 194719,
 -65153,
 24985767,
 194718,
 -65152,
 25048620,
 194717,
 -65151,
 25111811,
 194716,
 -65150,
 25175707,
 194715,
 -65149,
 25236878,
 194714,
 -65148,
 25302363,
 194713,
 -65147,
 25367847,
 194712,
 -65146,
 25433312,
 194711,
 -65145,
 25498779,
 194710,
 -65144,
 25564195,
 194709,
 -65143,
 25629654,
 194708,
 -65142,
 25695078,
 194707,
 -65141,
 25760449,
 194706,
 -65140,
 25825833,
 194705,
 -1,
 25891241,
 194704,
 26083742,
 24909095,
 -1,
 -65137,
 26037918,
 194703,
 -65136,
 26099879,
 194702,
 -65135,
 26162732,
 194701,
 -65134,
 26225923,
 194700,
 -65133,
 26289819,
 194699,
 -65132,
 26350990,
 194698,
 -65131,
 26416475,
 194697,
 -65130,
 26481959,
 194696,
 -65129,
 26547424,
 194695,
 -65128,
 26612891,
 194694,
 -65127,
 26678307,
 194693,
 -65126,
 26743766,
 194692,
 -65125,
 26809190,
 194691,
 -65124,
 26874561,
 194690,
 -65123,
 26939945,
 194689,
 -1,
 27005353,
 194688,
 27197871,
 26023136,
 -1,
 -65120,
 27152030,
 194687,
 -65119,
 27213991,
 194686,
 -65118,
 27276844,
 194685,
 -65117,
 27340035,
 194684,
 -65116,
 27403931,
 194683,
 -65115,
 27465102,
 194682,
 -65114,
 27530587,
 194681,
 -65113,
 27596071,
 194680,
 -65112,
 27661536,
 194679,
 -65111,
 27727003,
 194678,
 -65110,
 27792419,
 194677,
 -65109,
 27857878,
 194676,
 -65108,
 27923302,
 194675,
 -65107,
 27988673,
 194674,
 -65106,
 28054057,
 194673,
 -1,
 28119465,
 194672,
 28312000,
 27137179,
 -1,
 -65103,
 28266142,
 194671,
 -65102,
 28328103,
 194670,
 -65101,
 28390956,
 194669,
 -65100,
 28454147,
 194668,
 -65099,
 28518043,
 194667,
 -65098,
 28579214,
 194666,
 -65097,
 28644699,
 194665,
 -65096,
 28710183,
 194664,
 -65095,
 28775648,
 194663,
 -65094,
 28841115,
 194662,
 -65093,
 28906531,
 194661,
 -65092,
 28971990,
 194660,
 -65091,
 29037414,
 194659,
 -65090,
 29102785,
 194658,
 -65089,
 29168169,
 194657,
 -1,
 29233577,
 194656,
 29426129,
 28251171,
 -1,
 -65086,
 29380254,
 194655,
 -65085,
 29442215,
 194654,
 -65084,
 29505068,
 194653,
 -65083,
 29568259,
 194652,
 -65082,
 29632155,
 194651,
 -65081,
 29693326,
 194650,
 -65080,
 29758811,
 194649,
 -65079,
 29824295,
 194648,
 -65078,
 29889760,
 194647,
 -65077,
 29955227,
 194646,
 -65076,
 30020643,
 194645,
 -65075,
 30086102,
 194644,
 -65074,
 30151526,
 194643,
 -65073,
 30216897,
 194642,
 -65072,
 30282281,
 194641,
 -1,
 30347689,
 194640,
 30540258,
 29365206,
 -1,
 -65069,
 30494366,
 194639,
 -65068,
 30556327,
 194638,
 -65067,
 30619180,
 194637,
 -65066,
 30682371,
 194636,
 -65065,
 30746267,
 194635,
 -65064,
 30807438,
 194634,
 -65063,
 30872923,
 194633,
 -65062,
 30938407,
 194632,
 -65061,
 31003872,
 194631,
 -65060,
 31069339,
 194630,
 -65059,
 31134755,
 194629,
 -65058,
 31200214,
 194628,
 -65057,
 31265638,
 194627,
 -65056,
 31331009,
 194626,
 -65055,
 31396393,
 194625,
 -1,
 31461801,
 194624,
 31654387,
 30479206,
 -1,
 -65052,
 31608478,
 194623,
 -65051,
 31670439,
 194622,
 -65050,
 31733292,
 194621,
 -65049,
 31796483,
 194620,
 -65048,
 31860379,
 194619,
 -65047,
 31921550,
 194618,
 -65046,
 31987035,
 194617,
 -65045,
 32052519,
 194616,
 -65044,
 32117984,
 194615,
 -65043,
 32183451,
 194614,
 -65042,
 32248867,
 194613,
 -65041,
 32314326,
 194612,
 -65040,
 32379750,
 194611,
 -65039,
 32445121,
 194610,
 -65038,
 32510505,
 194609,
 -1,
 32575913,
 194608,
 32768516,
 31593153,
 -1,
 -65035,
 32722590,
 194607,
 -65034,
 32784551,
 194606,
 -65033,
 32847404,
 194605,
 -65032,
 32910595,
 194604,
 -65031,
 32974491,
 194603,
 -65030,
 33035662,
 194602,
 -65029,
 33101147,
 194601,
 -65028,
 33166631,
 194600,
 -65027,
 33232096,
 194599,
 -65026,
 33297563,
 194598,
 -65025,
 33362979,
 194597,
 -65024,
 33428438,
 194596,
 -65023,
 33493862,
 194595,
 -65022,
 33559233,
 194594,
 -65021,
 33624617,
 194593,
 -1,
 33690025,
 194592,
 33882645,
 32707113,
 -1,
 -65018,
 33836702,
 194591,
 -65017,
 33898663,
 194590,
 -65016,
 33961516,
 194589,
 -65015,
 34024707,
 194588,
 -65014,
 34088603,
 194587,
 -65013,
 34149774,
 194586,
 -65012,
 34215259,
 194585,
 -65011,
 34280743,
 194584,
 -65010,
 34346208,
 194583,
 -65009,
 34411675,
 194582,
 -65008,
 34477091,
 194581,
 -65007,
 34542550,
 194580,
 -65006,
 34607974,
 194579,
 -65005,
 34673345,
 194578,
 -65004,
 34738729,
 194577,
 -1,
 34804137,
 194576,
 35061759,
 33821097,
 -1,
 -65001,
 34950814,
 194575,
 -65000,
 35012775,
 194574,
 -64999,
 35075628,
 194573,
 -64998,
 35138819,
 194572,
 -64997,
 35202715,
 194571,
 -64996,
 35263886,
 194570,
 -64995,
 35329371,
 194569,
 -64994,
 35394855,
 194568,
 -64993,
 35460320,
 194567,
 -64992,
 35525787,
 194566,
 -64991,
 35591203,
 194565,
 -64990,
 35656662,
 194564,
 -64989,
 35722086,
 194563,
 -64988,
 35787457,
 194562,
 -64987,
 35852841,
 194561,
 -1,
 35918249,
 194560,
 36175871,
 18158990,
 -1,
 36176440,
 36049321,
 -1,
 -64983,
 36130462,
 195087,
 -64982,
 36192423,
 195086,
 -64981,
 36255276,
 195085,
 -64980,
 36318467,
 195084,
 -64979,
 36382363,
 195083,
 -64978,
 36443534,
 195082,
 -64977,
 36509019,
 195081,
 -64976,
 36574503,
 195080,
 -64975,
 36639968,
 195079,
 -64974,
 36705435,
 195078,
 -64973,
 36770851,
 195077,
 -64972,
 36836310,
 195076,
 -64971,
 36901734,
 195075,
 -64970,
 36967105,
 195074,
 -64969,
 37032489,
 195073,
 -1,
 37097897,
 195072,
 37355519,
 36114985,
 -1,
 -64966,
 37238316,
 195101,
 -64965,
 37301507,
 195100,
 -64964,
 37365403,
 195099,
 -64963,
 37426574,
 195098,
 -64962,
 37492059,
 195097,
 -64961,
 37557543,
 195096,
 -64960,
 37623008,
 195095,
 -64959,
 37688475,
 195094,
 -64958,
 37753891,
 195093,
 -64957,
 37819350,
 195092,
 -64956,
 37884774,
 195091,
 -64955,
 37950145,
 195090,
 -64954,
 38015529,
 195089,
 -1,
 38080937,
 195088,
 38338559,
 216734,
 -1,
 38339417,
 38212955,
 -1,
 38404698,
 38293150,
 -1,
 -64949,
 38358686,
 63999,
 -64948,
 38420647,
 63998,
 -64947,
 38483500,
 63997,
 -64946,
 38546691,
 63996,
 -64945,
 38610587,
 63995,
 -64944,
 38671758,
 63994,
 -64943,
 38737243,
 63993,
 -64942,
 38802727,
 63992,
 -64941,
 38868192,
 63991,
 -64940,
 38933659,
 63990,
 -64939,
 38999075,
 63989,
 -64938,
 39064534,
 63988,
 -64937,
 39129958,
 63987,
 -64936,
 39195329,
 63986,
 -64935,
 39260713,
 63985,
 -1,
 39326121,
 63984,
 39518827,
 38355111,
 -1,
 -64932,
 39472798,
 63983,
 -64931,
 39534759,
 63982,
 -64930,
 39597612,
 63981,
 -64929,
 39660803,
 63980,
 -64928,
 39724699,
 63979,
 -64927,
 39785870,
 63978,
 -64926,
 39851355,
 63977,
 -64925,
 39916839,
 63976,
 -64924,
 39982304,
 63975,
 -64923,
 40047771,
 63974,
 -64922,
 40113187,
 63973,
 -64921,
 40178646,
 63972,
 -64920,
 40244070,
 63971,
 -64919,
 40309441,
 63970,
 -64918,
 40374825,
 63969,
 -1,
 40440233,
 63968,
 40632956,
 39466540,
 -1,
 -64915,
 40586910,
 63967,
 -64914,
 40648871,
 63966,
 -64913,
 40711724,
 63965,
 -64912,
 40774915,
 63964,
 -64911,
 40838811,
 63963,
 -64910,
 40899982,
 63962,
 -64909,
 40965467,
 63961,
 -64908,
 41030951,
 63960,
 -64907,
 41096416,
 63959,
 -64906,
 41161883,
 63958,
 -64905,
 41227299,
 63957,
 -64904,
 41292758,
 63956,
 -64903,
 41358182,
 63955,
 -64902,
 41423553,
 63954,
 -64901,
 41488937,
 63953,
 -1,
 41554345,
 63952,
 41747085,
 40578307,
 -1,
 -64898,
 41701022,
 63951,
 -64897,
 41762983,
 63950,
 -64896,
 41825836,
 63949,
 -64895,
 41889027,
 63948,
 -64894,
 41952923,
 63947,
 -64893,
 42014094,
 63946,
 -64892,
 42079579,
 63945,
 -64891,
 42145063,
 63944,
 -64890,
 42210528,
 63943,
 -64889,
 42275995,
 63942,
 -64888,
 42341411,
 63941,
 -64887,
 42406870,
 63940,
 -64886,
 42472294,
 63939,
 -64885,
 42537665,
 63938,
 -64884,
 42603049,
 63937,
 -1,
 42668457,
 63936,
 42861214,
 41690779,
 -1,
 -64881,
 42815134,
 63935,
 -64880,
 42877095,
 63934,
 -64879,
 42939948,
 63933,
 -64878,
 43003139,
 63932,
 -64877,
 43067035,
 63931,
 -64876,
 43128206,
 63930,
 -64875,
 43193691,
 63929,
 -64874,
 43259175,
 63928,
 -64873,
 43324640,
 63927,
 -64872,
 43390107,
 63926,
 -64871,
 43455523,
 63925,
 -64870,
 43520982,
 63924,
 -64869,
 43586406,
 63923,
 -64868,
 43651777,
 63922,
 -64867,
 43717161,
 63921,
 -1,
 43782569,
 63920,
 43975343,
 42800526,
 -1,
 -64864,
 43929246,
 63919,
 -64863,
 43991207,
 63918,
 -64862,
 44054060,
 63917,
 -64861,
 44117251,
 63916,
 -64860,
 44181147,
 63915,
 -64859,
 44242318,
 63914,
 -64858,
 44307803,
 63913,
 -64857,
 44373287,
 63912,
 -64856,
 44438752,
 63911,
 -64855,
 44504219,
 63910,
 -64854,
 44569635,
 63909,
 -64853,
 44635094,
 63908,
 -64852,
 44700518,
 63907,
 -64851,
 44765889,
 63906,
 -64850,
 44831273,
 63905,
 -1,
 44896681,
 63904,
 45089472,
 43914587,
 -1,
 -64847,
 45043358,
 63903,
 -64846,
 45105319,
 63902,
 -64845,
 45168172,
 63901,
 -64844,
 45231363,
 63900,
 -64843,
 45295259,
 63899,
 -64842,
 45356430,
 63898,
 -64841,
 45421915,
 63897,
 -64840,
 45487399,
 63896,
 -64839,
 45552864,
 63895,
 -64838,
 45618331,
 63894,
 -64837,
 45683747,
 63893,
 -64836,
 45749206,
 63892,
 -64835,
 45814630,
 63891,
 -64834,
 45880001,
 63890,
 -64833,
 45945385,
 63889,
 -1,
 46010793,
 63888,
 46203601,
 45028647,
 -1,
 -64830,
 46157470,
 63887,
 -64829,
 46219431,
 63886,
 -64828,
 46282284,
 63885,
 -64827,
 46345475,
 63884,
 -64826,
 46409371,
 63883,
 -64825,
 46470542,
 63882,
 -64824,
 46536027,
 63881,
 -64823,
 46601511,
 63880,
 -64822,
 46666976,
 63879,
 -64821,
 46732443,
 63878,
 -64820,
 46797859,
 63877,
 -64819,
 46863318,
 63876,
 -64818,
 46928742,
 63875,
 -64817,
 46994113,
 63874,
 -64816,
 47059497,
 63873,
 -1,
 47124905,
 63872,
 47317730,
 46142688,
 -1,
 -64813,
 47271582,
 63871,
 -64812,
 47333543,
 63870,
 -64811,
 47396396,
 63869,
 -64810,
 47459587,
 63868,
 -64809,
 47523483,
 63867,
 -64808,
 47584654,
 63866,
 -64807,
 47650139,
 63865,
 -64806,
 47715623,
 63864,
 -64805,
 47781088,
 63863,
 -64804,
 47846555,
 63862,
 -64803,
 47911971,
 63861,
 -64802,
 47977430,
 63860,
 -64801,
 48042854,
 63859,
 -64800,
 48108225,
 63858,
 -64799,
 48173609,
 63857,
 -1,
 48239017,
 63856,
 48431859,
 47256731,
 -1,
 -64796,
 48385694,
 63855,
 -64795,
 48447655,
 63854,
 -64794,
 48510508,
 63853,
 -64793,
 48573699,
 63852,
 -64792,
 48637595,
 63851,
 -64791,
 48698766,
 63850,
 -64790,
 48764251,
 63849,
 -64789,
 48829735,
 63848,
 -64788,
 48895200,
 63847,
 -64787,
 48960667,
 63846,
 -64786,
 49026083,
 63845,
 -64785,
 49091542,
 63844,
 -64784,
 49156966,
 63843,
 -64783,
 49222337,
 63842,
 -64782,
 49287721,
 63841,
 -1,
 49353129,
 63840,
 49545988,
 48370723,
 -1,
 -64779,
 49499806,
 63839,
 -64778,
 49561767,
 63838,
 -64777,
 49624620,
 63837,
 -64776,
 49687811,
 63836,
 -64775,
 49751707,
 63835,
 -64774,
 49812878,
 63834,
 -64773,
 49878363,
 63833,
 -64772,
 49943847,
 63832,
 -64771,
 50009312,
 63831,
 -64770,
 50074779,
 63830,
 -64769,
 50140195,
 63829,
 -64768,
 50205654,
 63828,
 -64767,
 50271078,
 63827,
 -64766,
 50336449,
 63826,
 -64765,
 50401833,
 63825,
 -1,
 50467241,
 63824,
 50660117,
 49484758,
 -1,
 -64762,
 50613918,
 63823,
 -64761,
 50675879,
 63822,
 -64760,
 50738732,
 63821,
 -64759,
 50801923,
 63820,
 -64758,
 50865819,
 63819,
 -64757,
 50926990,
 63818,
 -64756,
 50992475,
 63817,
 -64755,
 51057959,
 63816,
 -64754,
 51123424,
 63815,
 -64753,
 51188891,
 63814,
 -64752,
 51254307,
 63813,
 -64751,
 51319766,
 63812,
 -64750,
 51385190,
 63811,
 -64749,
 51450561,
 63810,
 -64748,
 51515945,
 63809,
 -1,
 51581353,
 63808,
 51774246,
 50598758,
 -1,
 -64745,
 51728030,
 63807,
 -64744,
 51789991,
 63806,
 -64743,
 51852844,
 63805,
 -64742,
 51916035,
 63804,
 -64741,
 51979931,
 63803,
 -64740,
 52041102,
 63802,
 -64739,
 52106587,
 63801,
 -64738,
 52172071,
 63800,
 -64737,
 52237536,
 63799,
 -64736,
 52303003,
 63798,
 -64735,
 52368419,
 63797,
 -64734,
 52433878,
 63796,
 -64733,
 52499302,
 63795,
 -64732,
 52564673,
 63794,
 -64731,
 52630057,
 63793,
 -1,
 52695465,
 63792,
 52888375,
 51712705,
 -1,
 -64728,
 52842142,
 63791,
 -64727,
 52904103,
 63790,
 -64726,
 52966956,
 63789,
 -64725,
 53030147,
 63788,
 -64724,
 53094043,
 63787,
 -64723,
 53155214,
 63786,
 -64722,
 53220699,
 63785,
 -64721,
 53286183,
 63784,
 -64720,
 53351648,
 63783,
 -64719,
 53417115,
 63782,
 -64718,
 53482531,
 63781,
 -64717,
 53547990,
 63780,
 -64716,
 53613414,
 63779,
 -64715,
 53678785,
 63778,
 -64714,
 53744169,
 63777,
 -1,
 53809577,
 63776,
 54002504,
 52826665,
 -1,
 -64711,
 53956254,
 63775,
 -64710,
 54018215,
 63774,
 -64709,
 54081068,
 63773,
 -64708,
 54144259,
 63772,
 -64707,
 54208155,
 63771,
 -64706,
 54269326,
 63770,
 -64705,
 54334811,
 63769,
 -64704,
 54400295,
 63768,
 -64703,
 54465760,
 63767,
 -64702,
 54531227,
 63766,
 -64701,
 54596643,
 63765,
 -64700,
 54662102,
 63764,
 -64699,
 54727526,
 63763,
 -64698,
 54792897,
 63762,
 -64697,
 54858281,
 63761,
 -1,
 54923689,
 63760,
 55181311,
 53940649,
 -1,
 -64694,
 55070366,
 63759,
 -64693,
 55132327,
 63758,
 -64692,
 55195180,
 63757,
 -64691,
 55258371,
 63756,
 -64690,
 55322267,
 63755,
 -64689,
 55383438,
 63754,
 -64688,
 55448923,
 63753,
 -64687,
 55514407,
 63752,
 -64686,
 55579872,
 63751,
 -64685,
 55645339,
 63750,
 -64684,
 55710755,
 63749,
 -64683,
 55776214,
 63748,
 -64682,
 55841638,
 63747,
 -64681,
 55907009,
 63746,
 -64680,
 55972393,
 63745,
 -1,
 56037801,
 63744,
 56295423,
 38278542,
 -1,
 56296299,
 56175875,
 -1,
 -64676,
 56250014,
 64207,
 -64675,
 56311975,
 64206,
 -64674,
 56374828,
 64205,
 -64673,
 56438019,
 64204,
 -64672,
 56501915,
 64203,
 -64671,
 56563086,
 64202,
 -64670,
 56628571,
 64201,
 -64669,
 56694055,
 64200,
 -64668,
 56759520,
 64199,
 -64667,
 56824987,
 64198,
 -64666,
 56890403,
 64197,
 -64665,
 56955862,
 64196,
 -64664,
 57021286,
 64195,
 -64663,
 57086657,
 64194,
 -64662,
 57152041,
 64193,
 -1,
 57217449,
 64192,
 57410428,
 56239771,
 -1,
 -64659,
 57364126,
 64191,
 -64658,
 57426087,
 64190,
 -64657,
 57488940,
 64189,
 -64656,
 57552131,
 64188,
 -64655,
 57616027,
 64187,
 -64654,
 57677198,
 64186,
 -64653,
 57742683,
 64185,
 -64652,
 57808167,
 64184,
 -64651,
 57873632,
 64183,
 -64650,
 57939099,
 64182,
 -64649,
 58004515,
 64181,
 -64648,
 58069974,
 64180,
 -64647,
 58135398,
 64179,
 -64646,
 58200769,
 64178,
 -64645,
 58266153,
 64177,
 -1,
 58331561,
 64176,
 58524557,
 57349518,
 -1,
 -64642,
 58478238,
 64175,
 -64641,
 58540199,
 64174,
 -64640,
 58603052,
 64173,
 -64639,
 58666243,
 64172,
 -64638,
 58730139,
 64171,
 -64637,
 58791310,
 64170,
 -64636,
 58856795,
 64169,
 -64635,
 58922279,
 64168,
 -64634,
 58987744,
 64167,
 -64633,
 59053211,
 64166,
 -64632,
 59118627,
 64165,
 -64631,
 59184086,
 64164,
 -64630,
 59249510,
 64163,
 -64629,
 59314881,
 64162,
 -64628,
 59380265,
 64161,
 -1,
 59445673,
 64160,
 59638686,
 58463579,
 -1,
 -64625,
 59592350,
 64159,
 -64624,
 59654311,
 64158,
 -64623,
 59717164,
 64157,
 -64622,
 59780355,
 64156,
 -64621,
 59844251,
 64155,
 -64620,
 59905422,
 64154,
 -64619,
 59970907,
 64153,
 -64618,
 60036391,
 64152,
 -64617,
 60101856,
 64151,
 -64616,
 60167323,
 64150,
 -64615,
 60232739,
 64149,
 -64614,
 60298198,
 64148,
 -64613,
 60363622,
 64147,
 -64612,
 60428993,
 64146,
 -64611,
 60494377,
 64145,
 -1,
 60559785,
 64144,
 60752815,
 59577639,
 -1,
 -64608,
 60706462,
 64143,
 -64607,
 60768423,
 64142,
 -64606,
 60831276,
 64141,
 -64605,
 60894467,
 64140,
 -64604,
 60958363,
 64139,
 -64603,
 61019534,
 64138,
 -64602,
 61085019,
 64137,
 -64601,
 61150503,
 64136,
 -64600,
 61215968,
 64135,
 -64599,
 61281435,
 64134,
 -64598,
 61346851,
 64133,
 -64597,
 61412310,
 64132,
 -64596,
 61477734,
 64131,
 -64595,
 61543105,
 64130,
 -64594,
 61608489,
 64129,
 -1,
 61673897,
 64128,
 61866944,
 60691680,
 -1,
 -64591,
 61820574,
 64127,
 -64590,
 61882535,
 64126,
 -64589,
 61945388,
 64125,
 -64588,
 62008579,
 64124,
 -64587,
 62072475,
 64123,
 -64586,
 62133646,
 64122,
 -64585,
 62199131,
 64121,
 -64584,
 62264615,
 64120,
 -64583,
 62330080,
 64119,
 -64582,
 62395547,
 64118,
 -64581,
 62460963,
 64117,
 -64580,
 62526422,
 64116,
 -64579,
 62591846,
 64115,
 -64578,
 62657217,
 64114,
 -64577,
 62722601,
 64113,
 -1,
 62788009,
 64112,
 62981073,
 61805603,
 -1,
 -64574,
 62934686,
 64095,
 -64573,
 62996647,
 64094,
 -64572,
 63059500,
 64093,
 -64571,
 63122691,
 64092,
 -64570,
 63186587,
 64091,
 -64569,
 63247758,
 64090,
 -64568,
 63313243,
 64089,
 -64567,
 63378727,
 64088,
 -64566,
 63444192,
 64087,
 -64565,
 63509659,
 64086,
 -64564,
 63575075,
 64085,
 -64563,
 63640534,
 64084,
 -64562,
 63705958,
 64083,
 -64561,
 63771329,
 64082,
 -64560,
 63836713,
 64081,
 -1,
 63902121,
 64080,
 64095202,
 62919638,
 -1,
 -64557,
 64048798,
 64079,
 -64556,
 64110759,
 64078,
 -64555,
 64173612,
 64077,
 -64554,
 64236803,
 64076,
 -64553,
 64300699,
 64075,
 -64552,
 64361870,
 64074,
 -64551,
 64427355,
 64073,
 -64550,
 64492839,
 64072,
 -64549,
 64558304,
 64071,
 -64548,
 64623771,
 64070,
 -64547,
 64689187,
 64069,
 -64546,
 64754646,
 64068,
 -64545,
 64820070,
 64067,
 -64544,
 64885441,
 64066,
 -64543,
 64950825,
 64065,
 -1,
 65016233,
 64064,
 65209331,
 64033638,
 -1,
 -64540,
 65162910,
 64063,
 -64539,
 65224871,
 64062,
 -64538,
 65287724,
 64061,
 -64537,
 65350915,
 64060,
 -64536,
 65414811,
 64059,
 -64535,
 65475982,
 64058,
 -64534,
 65541467,
 64057,
 -64533,
 65606951,
 64056,
 -64532,
 65672416,
 64055,
 -64531,
 65737883,
 64054,
 -64530,
 65803299,
 64053,
 -64529,
 65868758,
 64052,
 -64528,
 65934182,
 64051,
 -64527,
 65999553,
 64050,
 -64526,
 66064937,
 64049,
 -1,
 66130345,
 64048,
 66323460,
 65147433,
 -1,
 -64523,
 66277022,
 64031,
 -64522,
 66338983,
 64030,
 -64521,
 66401836,
 64029,
 -64520,
 66465027,
 64028,
 -64519,
 66528923,
 64027,
 -64518,
 66590094,
 64026,
 -64517,
 66655579,
 64025,
 -64516,
 66721063,
 64024,
 -64515,
 66786528,
 64023,
 -64514,
 66851995,
 64022,
 -64513,
 66917411,
 64021,
 -64512,
 66982870,
 64020,
 -64511,
 67048294,
 64019,
 -64510,
 67113665,
 64018,
 -64509,
 67179049,
 64017,
 -1,
 67244457,
 64016,
 67437589,
 66261417,
 -1,
 -64506,
 67391134,
 64015,
 -64505,
 67453095,
 64014,
 -64504,
 67515948,
 64013,
 -64503,
 67579139,
 64012,
 -64502,
 67643035,
 64011,
 -64501,
 67704206,
 64010,
 -64500,
 67769691,
 64009,
 -64499,
 67835175,
 64008,
 -64498,
 67900640,
 64007,
 -64497,
 67966107,
 64006,
 -64496,
 68031523,
 64005,
 -64495,
 68096982,
 64004,
 -64494,
 68162406,
 64003,
 -64493,
 68227777,
 64002,
 -64492,
 68293161,
 64001,
 -1,
 68358569,
 64000,
 68551716,
 67376283,
 -1,
 -64489,
 68498988,
 64109,
 -64488,
 68562179,
 64108,
 -64487,
 68626075,
 64107,
 -64486,
 68687246,
 64106,
 -64485,
 68752731,
 64105,
 -64484,
 68818215,
 64104,
 -64483,
 68883680,
 64103,
 -64482,
 68949147,
 64102,
 -64481,
 69014563,
 64101,
 -64480,
 69080022,
 64100,
 -64479,
 69145446,
 64099,
 -64478,
 69210817,
 64098,
 -64477,
 69276201,
 64097,
 -1,
 69341609,
 64096,
 69534771,
 68489921,
 -1,
 -64474,
 69482028,
 64045,
 -64473,
 69545219,
 64044,
 -64472,
 69609115,
 64043,
 -64471,
 69670286,
 64042,
 -64470,
 69735771,
 64041,
 -64469,
 69801255,
 64040,
 -64468,
 69866720,
 64039,
 -64467,
 69932187,
 64038,
 -64466,
 69997603,
 64037,
 -64465,
 70063062,
 64036,
 -64464,
 70128486,
 64035,
 -64463,
 70193857,
 64034,
 -64462,
 70259241,
 64033,
 -1,
 70324649,
 64032,
 70582271,
 69482028,
 -1,
 -64459,
 70456667,
 64217,
 -64458,
 70522151,
 64216,
 -64457,
 70587616,
 64215,
 -64456,
 70653083,
 64214,
 -64455,
 70718499,
 64213,
 -64454,
 70783958,
 64212,
 -64453,
 70849382,
 64211,
 -64452,
 70914753,
 64210,
 -64451,
 70980137,
 64209,
 -1,
 71045545,
 64208,
 71238894,
 174710,
 -1,
 71304293,
 71183619,
 -1,
 71369821,
 71242080,
 -1,
 71435335,
 71350192,
 -1,
 -64445,
 71410279,
 11976,
 -64444,
 71460521,
 11952,
 -64443,
 71523465,
 11977,
 -64442,
 71582535,
 11973,
 -1,
 71638132,
 12007,
 71828555,
 71418744,
 -1,
 -64439,
 71816970,
 12019,
 -64438,
 71866198,
 12014,
 -1,
 71900936,
 11993,
 72090703,
 71782046,
 -1,
 -64435,
 72070291,
 12010,
 -64434,
 72122395,
 11996,
 -1,
 72183159,
 12005,
 72352850,
 72053700,
 -1,
 -64431,
 72324726,
 11987,
 -1,
 72368434,
 11994,
 72549461,
 72307499,
 -1,
 -64428,
 72520829,
 11984,
 -1,
 72557762,
 11988,
 72746072,
 72499367,
 -1,
 -64425,
 72735297,
 12012,
 -1,
 72754321,
 12000,
 -64423,
 72736813,
 11995,
 -64422,
 72900638,
 12002,
 -64421,
 72957925,
 12016,
 -64420,
 73018978,
 11979,
 -1,
 73083355,
 12006,
 73270368,
 71332804,
 -1,
 -64417,
 73243460,
 11970,
 -1,
 73295032,
 11905,
 73466979,
 73228775,
 -1,
 -64414,
 73456741,
 11936,
 -1,
 73518797,
 11983,
 -64412,
 73441135,
 11943,
 -1,
 73621216,
 11931,
 73794692,
 71284656,
 -1,
 73860208,
 73753063,
 -1,
 73925743,
 73828338,
 -1,
 73991275,
 73915866,
 -1,
 -64406,
 73948130,
 12008,
 -1,
 73997253,
 11980,
 74187886,
 73947379,
 -1,
 -64403,
 74160609,
 11974,
 -1,
 74193785,
 11942,
 -1,
 74180066,
 12009,
 -1,
 73890915,
 11951,
 74515575,
 73810087,
 -1,
 74581110,
 74461856,
 -1,
 74646645,
 74564472,
 -1,
 -64396,
 74637921,
 11907,
 -1,
 74670270,
 11908,
 -1,
 74618402,
 11906,
 -1,
 74521113,
 11915,
 74974332,
 74484034,
 -1,
 75039867,
 74947890,
 -1,
 -64390,
 75025926,
 11925,
 -1,
 75077154,
 11924,
 -1,
 74979823,
 11922,
 75302015,
 74949724,
 -1,
 -64386,
 75288070,
 11949,
 -1,
 75339298,
 11948,
 75498626,
 75268481,
 -1,
 -64383,
 75484678,
 11917,
 -1,
 75535906,
 11916,
 -64381,
 75485815,
 11932,
 -1,
 75652192,
 11958,
 75826319,
 73760840,
 -1,
 75891852,
 75796978,
 -1,
 75957385,
 75879128,
 -1,
 -64376,
 75943430,
 11990,
 -1,
 75994658,
 11989,
 -64374,
 75941688,
 11935,
 -64373,
 76134070,
 11965,
 -1,
 76191120,
 11933,
 76414975,
 75841703,
 -1,
 -64370,
 76331684,
 11957,
 -1,
 76358801,
 11964,
 76547225,
 75769499,
 -1,
 76612756,
 76517874,
 -1,
 -64366,
 76604374,
 11910,
 -64365,
 76647270,
 12003,
 -1,
 76709707,
 11946,
 76874903,
 76593000,
 -1,
 -64362,
 76860934,
 11963,
 -1,
 76912162,
 11962,
 -64360,
 76840858,
 11992,
 -1,
 77012189,
 11950,
 77202596,
 76537306,
 -1,
 77268129,
 77141390,
 -1,
 77333662,
 77252122,
 -1,
 -64355,
 77319686,
 11938,
 -1,
 77370914,
 11937,
 77594623,
 77298790,
 -1,
 -64352,
 77516294,
 11982,
 -1,
 77567522,
 11981,
 77791231,
 77220655,
 -1,
 -64349,
 77712902,
 11972,
 -1,
 77764130,
 11971,
 77923502,
 77165508,
 -1,
 77989035,
 77864172,
 -1,
 78054569,
 77972344,
 -1,
 -64344,
 78045793,
 11919,
 -1,
 78078142,
 11920,
 -64342,
 78026274,
 11918,
 -1,
 78205464,
 11921,
 78446591,
 77960826,
 -1,
 -64339,
 78368262,
 11986,
 -1,
 78419490,
 11985,
 78578870,
 77885335,
 -1,
 78644405,
 78516576,
 -1,
 78709939,
 78627704,
 -1,
 -64334,
 78698250,
 12018,
 -1,
 78747478,
 12013,
 -64332,
 78662831,
 12011,
 -1,
 78856165,
 12015,
 -1,
 78583847,
 11945,
 79103166,
 78534899,
 -1,
 79168700,
 79053098,
 -1,
 79234235,
 79148717,
 -1,
 -64326,
 79220230,
 11927,
 -1,
 79271458,
 11926,
 -1,
 79181356,
 12001,
 -64323,
 79141345,
 11975,
 -1,
 79437196,
 11928,
 79627462,
 79052967,
 -1,
 79692996,
 79570068,
 -1,
 79758531,
 79676280,
 -1,
 -64318,
 79749729,
 11998,
 -1,
 79782078,
 11999,
 -1,
 79730210,
 11997,
 -64315,
 79685005,
 11947,
 -1,
 80011044,
 11960,
 80151755,
 79610744,
 -1,
 -64312,
 80140042,
 12017,
 -64311,
 80176423,
 11969,
 -64310,
 80240824,
 11923,
 -1,
 80287346,
 11911,
 80479441,
 80128470,
 -1,
 80544976,
 80418190,
 -1,
 -64306,
 80519275,
 11929,
 -64305,
 80576584,
 11959,
 -1,
 80635800,
 11991,
 -1,
 80496822,
 11904,
 80872663,
 80448523,
 -1,
 80938197,
 80855928,
 -1,
 -64300,
 80929377,
 11954,
 -1,
 80961726,
 11955,
 -64298,
 80909858,
 11953,
 -1,
 81089048,
 11956,
 81265886,
 80827179,
 -1,
 81331421,
 81242992,
 -1,
 81396956,
 81314680,
 -1,
 -64293,
 81388129,
 11967,
 -1,
 81420478,
 11968,
 -1,
 81368610,
 11966,
 -1,
 81289299,
 12004,
 81724643,
 81240171,
 -1,
 81790178,
 81667645,
 -1,
 -64287,
 81776134,
 11941,
 -1,
 81827362,
 11940,
 -1,
 81742407,
 11909,
 82052327,
 81671724,
 -1,
 -64283,
 82023304,
 11944,
 -64282,
 82079539,
 11914,
 -1,
 82133435,
 11934,
 82314474,
 82014959,
 -1,
 -64279,
 82300422,
 11913,
 -1,
 82351650,
 11912,
 82511085,
 82267806,
 -1,
 -64276,
 82483026,
 11978,
 -1,
 82537707,
 11939,
 -1,
 82482301,
 11961,
 82837503,
 71221668,
 -1,
 82838781,
 82729203,
 12752,
 82904313,
 82831352,
 12757,
 82969845,
 82896888,
 12741,
 83035380,
 82962424,
 12750,
 -1,
 82989867,
 12769,
 -1,
 83009643,
 12747,
 83231991,
 82959834,
 12749,
 -1,
 83186475,
 12744,
 -64264,
 83215224,
 12746,
 -1,
 83317547,
 12742,
 83494139,
 82878571,
 12743,
 -1,
 83484536,
 12748,
 -64260,
 83485884,
 12768,
 -1,
 83579691,
 12758,
 83756295,
 82818992,
 12753,
 83821825,
 83748856,
 12759,
 -64256,
 83814392,
 12766,
 -1,
 83877752,
 12745,
 84018436,
 83811802,
 12740,
 -64253,
 84011000,
 12760,
 -1,
 84038443,
 12767,
 -64251,
 84001656,
 12761,
 -64250,
 84189291,
 12755,
 -1,
 84235051,
 12762,
 84411659,
 83730539,
 12754,
 -64247,
 84404216,
 12764,
 -64246,
 84431659,
 12770,
 -1,
 84489772,
 12763,
 84673805,
 84394872,
 12736,
 -1,
 84642114,
 12765,
 -64242,
 84665425,
 12738,
 -64241,
 84795256,
 12737,
 -64240,
 84846534,
 12771,
 -64239,
 84904258,
 12751,
 -64238,
 84948524,
 12756,
 -1,
 85011656,
 12739,
 85199338,
 118510,
 -1,
 85264864,
 85167059,
 -1,
 85330255,
 85245121,
 -1,
 85394861,
 85283627,
 -1,
 85460340,
 85333390,
 73909,
 85525858,
 85398209,
 73911,
 85655551,
 85458944,
 -1,
 85656929,
 85575912,
 -1,
 85722404,
 85595534,
 -1,
 85787936,
 85657740,
 -1,
 -64226,
 85747157,
 73914,
 -64225,
 85809425,
 73913,
 -1,
 85866142,
 73912,
 86050082,
 85768868,
 73917,
 -1,
 85988101,
 73918,
 -64221,
 86018370,
 73916,
 -1,
 86124209,
 73915,
 86312237,
 85702576,
 -1,
 86377769,
 86268147,
 -1,
 86443304,
 86327463,
 73957,
 -1,
 86378863,
 73958,
 -1,
 86401933,
 73959,
 86639916,
 86316430,
 -1,
 -64213,
 86616534,
 73956,
 -1,
 86668228,
 73955,
 -1,
 86626841,
 73960,
 86902069,
 86266667,
 -1,
 86967602,
 86860263,
 73933,
 87033137,
 86905814,
 73934,
 -1,
 86968467,
 73935,
 -1,
 87009827,
 73936,
 87293951,
 86906254,
 -1,
 -64204,
 87206358,
 73932,
 -1,
 87263638,
 73931,
 87426364,
 86864118,
 -1,
 87491896,
 87384973,
 73946,
 -1,
 87427309,
 73947,
 87622971,
 87430542,
 -1,
 -64198,
 87604715,
 73945,
 -1,
 87650550,
 73944,
 -1,
 87609175,
 73948,
 87885123,
 87382259,
 -1,
 87950657,
 87823758,
 -1,
 88016192,
 87913412,
 73938,
 -1,
 87951588,
 73939,
 -1,
 87951616,
 73937,
 -64190,
 87936913,
 73941,
 -1,
 88171026,
 73940,
 88343880,
 87834791,
 -1,
 88409414,
 88312130,
 73929,
 -1,
 88345437,
 73930,
 88604671,
 88372164,
 73927,
 -1,
 88475876,
 73928,
 88671565,
 88290860,
 -1,
 88737099,
 88629735,
 73924,
 -1,
 88703110,
 73925,
 -64180,
 88723342,
 73926,
 -1,
 88806798,
 73923,
 88999251,
 88614555,
 -1,
 89064784,
 88987171,
 73921,
 -1,
 89000246,
 73922,
 89260031,
 89003406,
 -1,
 -64174,
 89172468,
 73920,
 -1,
 89208364,
 73919,
 89392470,
 88985326,
 73962,
 89522175,
 89339436,
 73963,
 -1,
 89393326,
 73964,
 89589080,
 89362698,
 73952,
 -1,
 89524170,
 73953,
 89720155,
 89555016,
 -1,
 -64166,
 89678311,
 73951,
 -1,
 89735422,
 73950,
 89916766,
 89678311,
 -1,
 -64163,
 89897643,
 73943,
 -1,
 89937359,
 73942,
 -64161,
 89900089,
 73961,
 -64160,
 90087632,
 73954,
 -1,
 90141721,
 73949,
 -1,
 85630402,
 73965,
 90375528,
 85494082,
 73974,
 90505215,
 90313409,
 73975,
 90570751,
 90374144,
 -1,
 -64154,
 90490385,
 73976,
 -64153,
 90545611,
 73977,
 -1,
 90584196,
 73978,
 90768747,
 90338244,
 73970,
 -64150,
 90709132,
 73972,
 -1,
 90768372,
 73971,
 90965357,
 90745302,
 73979,
 -1,
 90903398,
 73980,
 91096431,
 90912300,
 73968,
 -1,
 91031321,
 73969,
 91227505,
 91039437,
 73966,
 -1,
 91161331,
 73967,
 -64142,
 91208473,
 73981,
 -64141,
 91324488,
 73973,
 -1,
 91358261,
 73910,
 91555219,
 85418471,
 73984,
 91620735,
 91531734,
 -1,
 91686269,
 91558758,
 73994,
 91815935,
 91622161,
 -1,
 -64135,
 91726032,
 73999,
 -64134,
 91783041,
 73998,
 -64133,
 91842005,
 73997,
 -64132,
 91902928,
 73996,
 -1,
 91952577,
 73995,
 92209151,
 91624129,
 73992,
 -1,
 92079157,
 73993,
 92276105,
 91600816,
 -1,
 92341640,
 92231923,
 74001,
 92471295,
 92274688,
 -1,
 92472711,
 92390264,
 -1,
 92538246,
 92432169,
 -1,
 -64123,
 92521529,
 74004,
 -1,
 92546811,
 74003,
 -1,
 92489844,
 74005,
 -1,
 92419243,
 74002,
 -1,
 92281369,
 74000,
 92931469,
 92214230,
 73988,
 93061119,
 92864512,
 -1,
 -64116,
 92970453,
 73989,
 -1,
 93009054,
 73990,
 93193618,
 92864512,
 -1,
 93259153,
 93178088,
 -1,
 -64112,
 93245166,
 73986,
 -1,
 93274279,
 73985,
 -1,
 93205650,
 73987,
 -1,
 93141486,
 73991,
 93586859,
 91541230,
 74006,
 93652380,
 93524673,
 74008,
 93782015,
 93585408,
 -1,
 93783451,
 93702376,
 -1,
 93848985,
 93745473,
 74009,
 -1,
 93784942,
 74010,
 -64102,
 93829221,
 74012,
 -1,
 93950218,
 74011,
 -1,
 93739171,
 74013,
 94176673,
 93628886,
 74021,
 94242208,
 94162670,
 -1,
 -64097,
 94223012,
 74024,
 -1,
 94275906,
 74023,
 -1,
 94180576,
 74022,
 94504359,
 94123564,
 74014,
 94633983,
 94437376,
 -1,
 94635430,
 94554344,
 -1,
 -64091,
 94598022,
 74016,
 -1,
 94639564,
 74015,
 -1,
 94608862,
 74017,
 94897577,
 94470216,
 74019,
 -1,
 94833570,
 74020,
 -64086,
 94860228,
 74018,
 -1,
 94962434,
 74007,
 95223807,
 93539015,
 73982,
 -1,
 95095692,
 73983,
 95290934,
 85357508,
 -1,
 95356418,
 95229326,
 74167,
 95421948,
 95310687,
 -1,
 95487478,
 95364763,
 74168,
 95617023,
 95420416,
 -1,
 95618549,
 95537384,
 -1,
 95684027,
 95557006,
 74169,
 95749560,
 95619212,
 -1,
 -64074,
 95712542,
 74172,
 -64073,
 95769600,
 74171,
 -1,
 95827614,
 74170,
 -64071,
 95730386,
 74175,
 -64070,
 95979842,
 74174,
 -1,
 96039876,
 74173,
 96208322,
 95669998,
 74213,
 96273855,
 96143500,
 -1,
 -64066,
 96259848,
 74215,
 -1,
 96277902,
 74214,
 -64064,
 96254628,
 74218,
 -64063,
 96417324,
 74217,
 -1,
 96473850,
 74216,
 96667083,
 96188336,
 -1,
 96732618,
 96622835,
 -1,
 96798150,
 96718673,
 74207,
 -1,
 96733530,
 74208,
 96929225,
 96759288,
 -1,
 -64056,
 96912913,
 74206,
 -1,
 96969950,
 74205,
 -1,
 96878856,
 74204,
 -1,
 96719385,
 74209,
 97256914,
 96628982,
 -1,
 97322448,
 97242862,
 -1,
 97387983,
 97285060,
 74194,
 -1,
 97323210,
 74195,
 -1,
 97325926,
 74193,
 97648639,
 97280487,
 74191,
 -1,
 97552706,
 74192,
 97715671,
 97219524,
 -1,
 97781205,
 97701614,
 74198,
 -1,
 97743812,
 74199,
 -64042,
 97742199,
 74197,
 -1,
 97851583,
 74196,
 98043357,
 97673703,
 -1,
 98108892,
 98009160,
 74188,
 98238463,
 98044044,
 -1,
 -64037,
 98140030,
 74190,
 -1,
 98195729,
 74189,
 -1,
 98063823,
 74187,
 98436578,
 97997611,
 -1,
 98502112,
 98422942,
 74182,
 -1,
 98437312,
 74183,
 98697215,
 98440590,
 74180,
 -1,
 98609622,
 74181,
 98764263,
 98419576,
 -1,
 98829798,
 98702734,
 -1,
 -64027,
 98791690,
 74211,
 -1,
 98849579,
 74210,
 -1,
 98779365,
 74212,
 99091947,
 98730056,
 -1,
 99157482,
 99041447,
 74200,
 -1,
 99092663,
 74201,
 -1,
 99145559,
 74202,
 99354095,
 99047667,
 -1,
 99419630,
 99292558,
 74184,
 -1,
 99382212,
 74185,
 -1,
 99377718,
 74186,
 99616242,
 99296923,
 -1,
 -64015,
 99574247,
 74177,
 -1,
 99620859,
 74176,
 -64013,
 99584870,
 74203,
 -64012,
 99763985,
 74179,
 -1,
 99825425,
 74178,
 -1,
 95600650,
 74219,
 100139007,
 95463894,
 74220,
 100204543,
 100007936,
 -1,
 100206074,
 100124946,
 74221,
 -1,
 100141413,
 74222,
 100401151,
 100161699,
 74223,
 -1,
 100272026,
 74224,
 100468223,
 95387720,
 74228,
 100597759,
 100404108,
 74229,
 -1,
 100469055,
 74230,
 100664833,
 100430788,
 74226,
 -1,
 100600727,
 74227,
 -1,
 100622675,
 74225,
 100861490,
 95342318,
 74235,
 100927013,
 100799169,
 74237,
 101056511,
 100859904,
 -1,
 101058080,
 100975480,
 -1,
 101123615,
 101017385,
 -1,
 101189133,
 101085430,
 -1,
 101254668,
 101128187,
 -1,
 101320203,
 101192550,
 74246,
 -1,
 101255323,
 74247,
 -1,
 101257921,
 74245,
 -1,
 101212647,
 74248,
 101582352,
 101170285,
 -1,
 -63985,
 101544191,
 74255,
 -1,
 101583003,
 74254,
 101778963,
 101550402,
 -1,
 -63982,
 101764846,
 74253,
 -1,
 101793959,
 74252,
 101975574,
 101741593,
 -1,
 -63979,
 101929843,
 74250,
 -1,
 101976219,
 74249,
 102172184,
 101927612,
 74240,
 -1,
 102107870,
 74241,
 -63975,
 102157622,
 74256,
 -63974,
 102269848,
 74251,
 -63973,
 102328007,
 74244,
 -63972,
 102391052,
 74243,
 -63971,
 102454224,
 74242,
 -63970,
 102508283,
 74239,
 -1,
 102570521,
 74238,
 -1,
 101075060,
 74257,
 102827555,
 101038000,
 -1,
 -63966,
 102803656,
 74260,
 -1,
 102849712,
 74261,
 -63964,
 102799426,
 74259,
 -1,
 102970578,
 74258,
 103155243,
 100881316,
 74263,
 103284735,
 103088128,
 -1,
 103286314,
 103191026,
 -1,
 -63959,
 103275112,
 74264,
 -1,
 103327261,
 74265,
 -1,
 103267227,
 74266,
 103548462,
 103120968,
 74269,
 103677951,
 103483311,
 74270,
 -1,
 103547919,
 74271,
 -63953,
 103510980,
 74268,
 -63952,
 103700723,
 74267,
 -63951,
 103748454,
 74262,
 -1,
 103811891,
 74236,
 104071167,
 100819431,
 74231,
 -63948,
 103987876,
 74234,
 -63947,
 104040054,
 74233,
 -1,
 104100804,
 74232,
 104269483,
 95252726,
 -1,
 104334993,
 104207758,
 74071,
 104400507,
 104270609,
 -1,
 104465990,
 104354603,
 -1,
 104531519,
 104404366,
 74082,
 104597053,
 104507862,
 74085,
 -1,
 104532296,
 74086,
 -63938,
 104565142,
 74084,
 -1,
 104690628,
 74083,
 104859204,
 104489447,
 74087,
 104924739,
 104839847,
 -1,
 -63934,
 104899842,
 74089,
 -1,
 104936619,
 74090,
 -1,
 104901152,
 74088,
 105250815,
 104845038,
 74091,
 -1,
 105163310,
 74092,
 105317968,
 104445872,
 -1,
 105383500,
 105273587,
 -1,
 -63927,
 105369326,
 74115,
 -63926,
 105407373,
 74114,
 -63925,
 105463975,
 74113,
 -1,
 105518478,
 74112,
 105711182,
 105321870,
 74110,
 -1,
 105687510,
 74111,
 -63921,
 105697528,
 74117,
 -1,
 105800946,
 74116,
 105973336,
 105283656,
 -1,
 106038870,
 105922727,
 74100,
 106168319,
 105973900,
 -1,
 -63916,
 106087711,
 74103,
 -63915,
 106124748,
 74102,
 -1,
 106184801,
 74101,
 106430463,
 105996775,
 74104,
 -1,
 106301738,
 74105,
 106497629,
 105959150,
 74119,
 -63910,
 106478244,
 74123,
 -63909,
 106530972,
 74122,
 -63908,
 106575404,
 74121,
 -1,
 106631873,
 74120,
 106825315,
 106440347,
 -1,
 106890850,
 106763662,
 -1,
 -63904,
 106867158,
 74078,
 -63903,
 106919090,
 74077,
 -1,
 106968620,
 74076,
 -1,
 106848743,
 74079,
 107218535,
 106763662,
 74072,
 107284070,
 107165228,
 74073,
 -1,
 107219162,
 74074,
 -1,
 107264735,
 74075,
 107480683,
 107180278,
 -1,
 107546218,
 107438567,
 74096,
 -1,
 107492908,
 74097,
 -1,
 107485669,
 74095,
 107742830,
 107448642,
 -1,
 -63891,
 107729527,
 74107,
 -1,
 107757735,
 74106,
 107939441,
 107705284,
 -1,
 -63888,
 107925230,
 74099,
 -1,
 107962855,
 74098,
 108136052,
 107897319,
 -1,
 -63885,
 108101704,
 74094,
 -1,
 108156364,
 74093,
 108332663,
 108085415,
 -1,
 -63882,
 108313311,
 74081,
 -1,
 108376625,
 74080,
 -63880,
 108325080,
 74124,
 -63879,
 108512456,
 74118,
 -63878,
 108574459,
 74109,
 -1,
 108635144,
 74108,
 108791425,
 104347180,
 -1,
 108856958,
 108729379,
 74131,
 -1,
 108791673,
 74132,
 -63873,
 108794838,
 74130,
 -63872,
 108925798,
 74129,
 -1,
 108991169,
 74128,
 109184645,
 108772843,
 74140,
 109314047,
 109117440,
 -1,
 -63868,
 109223440,
 74142,
 -1,
 109278396,
 74141,
 109446793,
 109147076,
 74135,
 109576191,
 109379584,
 -1,
 -63864,
 109496559,
 74136,
 -1,
 109524165,
 74137,
 109708940,
 109412424,
 -1,
 -63861,
 109646806,
 74139,
 -1,
 109712065,
 74138,
 109905550,
 109670646,
 74133,
 -1,
 109841262,
 74134,
 110036624,
 109843137,
 74125,
 -1,
 109970191,
 74126,
 -1,
 109979291,
 74127,
 110233245,
 104320750,
 74154,
 110298772,
 110209494,
 74163,
 -1,
 110233252,
 74164,
 110429846,
 110261188,
 74160,
 -1,
 110363701,
 74161,
 110560920,
 110367702,
 74157,
 -1,
 110496802,
 74158,
 -63847,
 110541923,
 74165,
 -63846,
 110659906,
 74162,
 -63845,
 110695648,
 74159,
 -63844,
 110760806,
 74156,
 -1,
 110823216,
 74155,
 111019689,
 110191079,
 74144,
 111085219,
 110999472,
 -1,
 111150753,
 111044298,
 74152,
 -1,
 111085453,
 74153,
 -63838,
 111106291,
 74151,
 -1,
 111221273,
 74150,
 111412903,
 111020817,
 -1,
 111478438,
 111398638,
 74146,
 -1,
 111425068,
 74147,
 -1,
 111421179,
 74145,
 -63832,
 111380802,
 74149,
 -1,
 111621676,
 74148,
 -63830,
 111010748,
 74166,
 -1,
 111758012,
 74143,
 111937298,
 104249264,
 -1,
 112002787,
 111892723,
 -1,
 112068294,
 111960551,
 -1,
 112133820,
 112033864,
 74438,
 112263167,
 112069393,
 -1,
 112264882,
 112158165,
 74444,
 -1,
 112198709,
 74445,
 112395957,
 112207515,
 -1,
 -63820,
 112382484,
 74441,
 -1,
 112400921,
 74440,
 -63818,
 112375905,
 74449,
 -63817,
 112560158,
 74448,
 -63816,
 112623527,
 74447,
 -63815,
 112685973,
 74446,
 -63814,
 112743424,
 74443,
 -63813,
 112802295,
 74442,
 -1,
 112858510,
 74439,
 113051328,
 112110038,
 74451,
 113180671,
 112984064,
 -1,
 -63809,
 113100305,
 74452,
 -1,
 113155783,
 74453,
 113313476,
 112997932,
 74435,
 113442815,
 113249041,
 -1,
 -63805,
 113338055,
 74437,
 -1,
 113382798,
 74436,
 -63803,
 113296313,
 74454,
 -1,
 113544437,
 74450,
 113706708,
 112006542,
 74413,
 113772241,
 113644390,
 74414,
 113901567,
 113707793,
 -1,
 113903307,
 113823470,
 74421,
 -1,
 113838227,
 74422,
 -63796,
 113888620,
 74420,
 -63795,
 114015331,
 74419,
 -63794,
 114068326,
 74418,
 -63793,
 114120208,
 74417,
 -63792,
 114173691,
 74416,
 -1,
 114234766,
 74415,
 -63790,
 113748512,
 74425,
 -63789,
 114370246,
 74424,
 -1,
 114431131,
 74423,
 114624223,
 113655975,
 74426,
 114689752,
 114604708,
 74432,
 -63785,
 114652450,
 74434,
 -1,
 114692801,
 74433,
 114886365,
 114622464,
 -1,
 114951900,
 114859709,
 -1,
 -63781,
 114934745,
 74429,
 -1,
 114971515,
 74428,
 -1,
 114909555,
 74427,
 -63778,
 114854210,
 74431,
 -1,
 115168092,
 74430,
 115408895,
 114609902,
 74455,
 -63775,
 115289216,
 74458,
 -63774,
 115348161,
 74457,
 -1,
 115410790,
 74456,
 115607298,
 111941006,
 74387,
 115672830,
 115561259,
 74389,
 115802111,
 115605504,
 -1,
 115803899,
 115722472,
 -1,
 115869421,
 115789550,
 -1,
 -63767,
 115849892,
 74406,
 -63766,
 115911126,
 74405,
 -63765,
 115966024,
 74404,
 -63764,
 116008603,
 74403,
 -1,
 116069057,
 74402,
 116262640,
 115849136,
 -1,
 -63761,
 116219168,
 74400,
 -1,
 116267545,
 74399,
 116459251,
 116224246,
 -1,
 -63758,
 116446755,
 74395,
 -1,
 116464101,
 74394,
 116655861,
 116408417,
 74391,
 -1,
 116598427,
 74392,
 -63754,
 116638677,
 74401,
 -63753,
 116756746,
 74398,
 -63752,
 116819188,
 74397,
 -63751,
 116883371,
 74396,
 -63750,
 116939025,
 74393,
 -1,
 116987278,
 74390,
 -63748,
 115777204,
 74407,
 -63747,
 117150031,
 74388,
 -1,
 117201059,
 74408,
 117376768,
 115635140,
 74409,
 -1,
 117310792,
 74410,
 -63743,
 117352918,
 74412,
 -1,
 117476433,
 74411,
 117638923,
 115592942,
 74466,
 117704453,
 117615062,
 74473,
 -1,
 117642587,
 74474,
 117835527,
 117669960,
 74471,
 -1,
 117777273,
 74472,
 117966601,
 117782060,
 74468,
 -1,
 117904065,
 74469,
 -63734,
 117924240,
 74470,
 -1,
 118032420,
 74467,
 118292479,
 117596647,
 74459,
 118294287,
 118182699,
 74461,
 118423551,
 118232022,
 74462,
 -1,
 118294548,
 74463,
 -63728,
 118256720,
 74465,
 -63727,
 118452476,
 74464,
 -1,
 118490165,
 74460,
 118687606,
 111922926,
 74507,
 118753094,
 118663638,
 74536,
 118818611,
 118738670,
 74551,
 118884145,
 118754065,
 -1,
 118949660,
 118838059,
 -1,
 119015195,
 118887822,
 74556,
 -63719,
 118991318,
 74559,
 -63718,
 119048598,
 74558,
 -1,
 119108548,
 74557,
 -1,
 119000814,
 74560,
 119342880,
 118935278,
 -1,
 -63714,
 119322371,
 74574,
 -63713,
 119354924,
 74573,
 -1,
 119408832,
 74572,
 119605028,
 119300583,
 -1,
 -63710,
 119585444,
 74564,
 -63709,
 119636040,
 74563,
 -1,
 119690700,
 74562,
 119867175,
 119584688,
 -1,
 -63706,
 119825660,
 74570,
 -1,
 119888784,
 74569,
 120063785,
 119805326,
 74552,
 -1,
 120044457,
 74553,
 -63702,
 120048941,
 74571,
 -63701,
 120168656,
 74568,
 -63700,
 120227269,
 74567,
 -63699,
 120291243,
 74566,
 -63698,
 120353466,
 74565,
 -63697,
 120412433,
 74561,
 -63696,
 120471656,
 74555,
 -1,
 120530803,
 74554,
 120782847,
 118830743,
 74575,
 -1,
 120654765,
 74576,
 120850240,
 118756033,
 74539,
 120979455,
 120785681,
 -1,
 120981305,
 120901457,
 74545,
 121110527,
 120916108,
 -1,
 -63688,
 120990066,
 74547,
 -1,
 121054073,
 74546,
 121243454,
 120919438,
 -1,
 121308989,
 121178252,
 -1,
 -63684,
 121276830,
 74541,
 -1,
 121329937,
 74540,
 -1,
 121271236,
 74542,
 -63681,
 121213194,
 74544,
 -1,
 121526545,
 74543,
 121702210,
 120807911,
 74549,
 -1,
 121639782,
 74550,
 121833285,
 121634816,
 -1,
 -63676,
 121813915,
 74538,
 -1,
 121845024,
 74537,
 -1,
 121770966,
 74548,
 122095442,
 118699564,
 74515,
 122160977,
 122028032,
 -1,
 122226509,
 122145000,
 -1,
 122292043,
 122212113,
 74519,
 -1,
 122225717,
 74520,
 -63668,
 122258676,
 74518,
 -1,
 122365691,
 74517,
 122554191,
 122207131,
 74522,
 -1,
 122489651,
 74523,
 -63664,
 122516373,
 74516,
 -1,
 122640547,
 74521,
 -1,
 122147022,
 74524,
 122881885,
 122060872,
 74525,
 122947416,
 122817297,
 -1,
 -63659,
 122932974,
 74529,
 -63658,
 122993383,
 74528,
 -63657,
 123044749,
 74527,
 -1,
 123106486,
 74526,
 123275100,
 122933785,
 74531,
 123404287,
 123210513,
 -1,
 -63653,
 123314384,
 74533,
 -1,
 123367843,
 74532,
 -1,
 123218309,
 74530,
 123602790,
 122862244,
 74577,
 123668323,
 123538193,
 -1,
 123733857,
 123630453,
 74579,
 -1,
 123709910,
 74580,
 -63646,
 123716665,
 74581,
 -1,
 123803022,
 74578,
 -63644,
 123659222,
 74582,
 -63643,
 123982451,
 74584,
 -1,
 123998913,
 74583,
 124192621,
 123535360,
 -1,
 124258155,
 124165924,
 -1,
 -63639,
 124243745,
 74512,
 -63638,
 124306095,
 74511,
 -1,
 124362963,
 74510,
 -63636,
 124243772,
 74509,
 -1,
 124475551,
 74508,
 124651377,
 124184568,
 -1,
 124716912,
 124588902,
 74586,
 -1,
 124652414,
 74587,
 -1,
 124702446,
 74588,
 124913523,
 124619074,
 74534,
 -1,
 124847157,
 74535,
 -63628,
 124898653,
 74585,
 -63627,
 124987035,
 74514,
 -1,
 125047489,
 74513,
 125241285,
 118625678,
 73728,
 125306766,
 125183643,
 73738,
 125372295,
 125239296,
 -1,
 125437830,
 125356264,
 -1,
 125503357,
 125395431,
 -1,
 -63620,
 125470149,
 73745,
 -1,
 125523407,
 73744,
 125699968,
 125457247,
 -1,
 -63617,
 125667734,
 73742,
 -1,
 125727684,
 73741,
 -63615,
 125685521,
 73748,
 -63614,
 125877141,
 73747,
 -63613,
 125924534,
 73746,
 -63612,
 125982993,
 73743,
 -63611,
 126042220,
 73740,
 -1,
 126100389,
 73739,
 -1,
 125393059,
 73749,
 126418943,
 125309633,
 73750,
 126484479,
 126290705,
 -1,
 -63606,
 126403641,
 73755,
 -63605,
 126466791,
 73754,
 -63604,
 126518168,
 73753,
 -63603,
 126571472,
 73752,
 -1,
 126625578,
 73751,
 126814107,
 125268932,
 73760,
 126879641,
 126749457,
 -1,
 126945171,
 126841078,
 -1,
 -63598,
 126902759,
 73766,
 -1,
 126949374,
 73765,
 -63596,
 126932823,
 73768,
 -63595,
 127122280,
 73767,
 -63594,
 127162641,
 73764,
 -63593,
 127227408,
 73763,
 -63592,
 127285746,
 73762,
 -1,
 127343129,
 73761,
 -63590,
 126830795,
 73770,
 -1,
 127475043,
 73769,
 127666087,
 126793648,
 -1,
 127731622,
 127621363,
 73784,
 127797156,
 127664128,
 -1,
 127862690,
 127770003,
 -1,
 127928225,
 127835530,
 73788,
 -1,
 127861459,
 73789,
 -1,
 127913275,
 73787,
 -63581,
 127854811,
 73785,
 -1,
 128086307,
 73786,
 -63579,
 127751027,
 73791,
 -1,
 128193217,
 73790,
 -1,
 127670903,
 73783,
 128452528,
 127601425,
 -1,
 -63575,
 128432221,
 73736,
 -63574,
 128485598,
 73735,
 -63573,
 128546013,
 73734,
 -63572,
 128607701,
 73733,
 -63571,
 128669969,
 73732,
 -63570,
 128734160,
 73731,
 -63569,
 128788219,
 73730,
 -1,
 128849294,
 73729,
 129042360,
 128420162,
 73773,
 129107895,
 128974848,
 -1,
 129173429,
 129082601,
 -1,
 -63564,
 129155082,
 73777,
 -1,
 129210388,
 73776,
 -63562,
 129157169,
 73775,
 -1,
 129342850,
 73774,
 -1,
 129088360,
 73778,
 129566652,
 129018326,
 -1,
 129632187,
 129505275,
 73780,
 -1,
 129567628,
 73781,
 -1,
 129593631,
 73782,
 129828800,
 129528054,
 73757,
 129957887,
 129764113,
 -1,
 -63553,
 129874869,
 73759,
 -1,
 129911298,
 73758,
 130090946,
 129794728,
 73771,
 -1,
 130026402,
 73772,
 -63549,
 130065459,
 73779,
 -63548,
 130168364,
 73756,
 -1,
 130224833,
 73737,
 130418703,
 125208898,
 -1,
 130484195,
 130404078,
 74337,
 130549730,
 130451778,
 74339,
 130615255,
 130537552,
 74349,
 130744319,
 130547712,
 -1,
 130746325,
 130618933,
 -1,
 -63540,
 130731857,
 74359,
 -63539,
 130792721,
 74358,
 -63538,
 130845542,
 74357,
 -63537,
 130905113,
 74356,
 -63536,
 130969901,
 74355,
 -63535,
 131032537,
 74354,
 -63534,
 131094687,
 74353,
 -63533,
 131154020,
 74352,
 -63532,
 131213682,
 74351,
 -1,
 131277789,
 74350,
 131530751,
 130708171,
 74360,
 -1,
 131402757,
 74361,
 131661823,
 130547712,
 -1,
 131663838,
 131560680,
 -1,
 131729371,
 131643489,
 74342,
 -1,
 131663828,
 74343,
 -63524,
 131716951,
 74344,
 -63523,
 131826424,
 74341,
 -1,
 131879936,
 74340,
 132057056,
 131609863,
 74347,
 -1,
 131990874,
 74348,
 -63519,
 132040209,
 74345,
 -1,
 132161149,
 74346,
 -1,
 130486950,
 74338,
 132384766,
 130441703,
 74316,
 132450295,
 132352840,
 74322,
 132579327,
 132385553,
 -1,
 132581355,
 132496232,
 74330,
 132710399,
 132515987,
 -1,
 132712426,
 132627108,
 74332,
 -1,
 132647067,
 74333,
 -1,
 132644982,
 74331,
 132909039,
 132519310,
 -1,
 132974574,
 132889252,
 74324,
 -1,
 132909211,
 74325,
 -1,
 132942146,
 74323,
 133171186,
 132894446,
 -1,
 -63503,
 133151396,
 74335,
 -1,
 133174010,
 74334,
 133367797,
 133138754,
 -1,
 -63500,
 133354103,
 74329,
 -1,
 133382311,
 74328,
 -63498,
 133333923,
 74327,
 -1,
 133519519,
 74326,
 133695483,
 132415560,
 74319,
 133824511,
 133630803,
 -1,
 -63494,
 133736931,
 74321,
 -1,
 133794198,
 74320,
 -63492,
 133675101,
 74336,
 -63491,
 133894849,
 74318,
 -1,
 133958462,
 74317,
 134154249,
 132322702,
 74302,
 134219781,
 134107999,
 74304,
 134285316,
 134152192,
 -1,
 -63486,
 134269212,
 74306,
 -63485,
 134322255,
 74307,
 -1,
 134376251,
 74305,
 -1,
 134261206,
 74308,
 134613000,
 134185032,
 74310,
 -63481,
 134550209,
 74311,
 -1,
 134612544,
 74309,
 -1,
 134550209,
 74303,
 134938623,
 134103207,
 74312,
 135004159,
 134807552,
 -1,
 135006222,
 134924520,
 -1,
 -63475,
 134992030,
 74314,
 -1,
 135009678,
 74313,
 -1,
 134986651,
 74315,
 135268429,
 130364972,
 -1,
 135333940,
 135206286,
 73813,
 135399471,
 135287595,
 73814,
 135528447,
 135333168,
 -1,
 135530521,
 135418667,
 -1,
 135596054,
 135487975,
 73821,
 -1,
 135572000,
 73822,
 135727128,
 135533966,
 73819,
 -1,
 135661843,
 73820,
 -1,
 135712926,
 73823,
 135923742,
 135492548,
 -1,
 135989277,
 135909102,
 73829,
 -63460,
 135954504,
 73831,
 -1,
 135989534,
 73830,
 -1,
 135927182,
 73828,
 136251425,
 135909102,
 -1,
 -63456,
 136231588,
 73837,
 -1,
 136254224,
 73836,
 136448035,
 136211550,
 73825,
 -1,
 136382711,
 73826,
 136579110,
 136390299,
 -1,
 -63451,
 136536551,
 73818,
 -1,
 136583812,
 73817,
 136775721,
 136517006,
 -1,
 -63448,
 136741544,
 73816,
 -1,
 136775955,
 73815,
 -63446,
 136758329,
 73835,
 -63445,
 136952941,
 73834,
 -63444,
 137011567,
 73833,
 -63443,
 137071462,
 73832,
 -63442,
 137130305,
 73827,
 -1,
 137189649,
 73824,
 137365555,
 135375318,
 73839,
 137494527,
 137303438,
 -1,
 -63438,
 137368534,
 73841,
 -1,
 137433958,
 73840,
 -1,
 137330760,
 73838,
 137693253,
 135319278,
 73850,
 137758778,
 137660738,
 73860,
 137824313,
 137696102,
 73861,
 137953279,
 137757749,
 73862,
 -1,
 137823285,
 73863,
 -1,
 137761750,
 73864,
 138086461,
 137701019,
 73854,
 -63428,
 138023617,
 73856,
 -1,
 138087239,
 73855,
 138283073,
 138018816,
 -1,
 -63425,
 138263451,
 73853,
 -63424,
 138321318,
 73851,
 -1,
 138369187,
 73852,
 138545219,
 138236715,
 73857,
 -1,
 138530974,
 73858,
 -63420,
 138521120,
 73865,
 -1,
 138631411,
 73859,
 138870783,
 137650663,
 73842,
 138872905,
 138772552,
 73844,
 -63416,
 138810049,
 73846,
 -1,
 138873762,
 73845,
 139069515,
 138840386,
 73847,
 -1,
 139003141,
 73848,
 -63412,
 139049636,
 73849,
 -1,
 139142811,
 73843,
 139331714,
 135217319,
 73866,
 139397222,
 139323479,
 73889,
 139526143,
 139332369,
 -1,
 139528277,
 139424708,
 -1,
 139593811,
 139466126,
 73903,
 -1,
 139555820,
 73904,
 -63404,
 139579118,
 73906,
 -1,
 139682279,
 73905,
 139855961,
 139466126,
 73890,
 139921496,
 139790573,
 73891,
 -1,
 139856791,
 73892,
 -1,
 139888962,
 73893,
 140118109,
 139817206,
 -1,
 140183644,
 140059625,
 73900,
 -1,
 140118665,
 73901,
 -1,
 140169044,
 73902,
 140380256,
 140103406,
 -1,
 -63393,
 140326444,
 73908,
 -1,
 140382913,
 73907,
 140576866,
 140335377,
 73897,
 -1,
 140510261,
 73898,
 140707940,
 140525676,
 73895,
 -1,
 140641333,
 73896,
 -63387,
 140666329,
 73899,
 -1,
 140781307,
 73894,
 140970095,
 139364674,
 73879,
 141099007,
 140902400,
 -1,
 141101164,
 141019368,
 -1,
 141166699,
 141054923,
 73880,
 -1,
 141101790,
 73881,
 -1,
 141132670,
 73882,
 -63379,
 141082634,
 73885,
 -63378,
 141334570,
 73884,
 -1,
 141374584,
 73883,
 141559928,
 140907201,
 73869,
 141688831,
 141495057,
 -1,
 141690996,
 141604784,
 -1,
 -63373,
 141646736,
 73874,
 -1,
 141695513,
 73873,
 -63371,
 141676270,
 73875,
 -63370,
 141853940,
 73872,
 -63369,
 141906944,
 73871,
 -1,
 141956527,
 73870,
 142149755,
 141535702,
 -1,
 -63366,
 142108709,
 73887,
 -1,
 142165777,
 73886,
 142346366,
 142082048,
 -1,
 -63363,
 142330120,
 73867,
 -1,
 142384558,
 73868,
 -63361,
 142326495,
 73888,
 -63360,
 142504900,
 73878,
 -63359,
 142562828,
 73877,
 -1,
 142621175,
 73876,
 142805161,
 139314040,
 -1,
 142870681,
 142742926,
 74475,
 142936205,
 142824235,
 74483,
 143065087,
 142871313,
 -1,
 143067273,
 142981796,
 -1,
 -63352,
 143052526,
 74487,
 -1,
 143081639,
 74486,
 -63350,
 143052958,
 74489,
 -63349,
 143248694,
 74488,
 -63348,
 143284383,
 74485,
 -1,
 143337842,
 74484,
 143526035,
 142868480,
 -1,
 143591569,
 143509736,
 -1,
 -63344,
 143557876,
 74478,
 -1,
 143613169,
 74477,
 -63342,
 143546531,
 74479,
 -1,
 143729705,
 74476,
 143919255,
 143468187,
 74480,
 144048127,
 143851520,
 -1,
 -63338,
 143966218,
 74482,
 -1,
 144023262,
 74481,
 -63336,
 143894998,
 74491,
 -1,
 144142602,
 74490,
 144312481,
 142828007,
 74494,
 144378015,
 144288214,
 74497,
 144506879,
 144310272,
 -1,
 144509086,
 144416513,
 74499,
 -1,
 144442356,
 74500,
 -1,
 144492854,
 74498,
 -63328,
 144339908,
 74496,
 -1,
 144640734,
 74495,
 144836775,
 144297710,
 74501,
 144902308,
 144812502,
 74505,
 -1,
 144836678,
 74506,
 -63323,
 144867400,
 74504,
 -63322,
 144994550,
 74503,
 -1,
 145052502,
 74502,
 145293311,
 144785575,
 74492,
 -1,
 145163317,
 74493,
 145361101,
 142770248,
 -1,
 145426624,
 145346286,
 74284,
 145492155,
 145406628,
 74290,
 145557684,
 145424384,
 -1,
 145623217,
 145541352,
 -1,
 -63313,
 145614858,
 74293,
 -63312,
 145650566,
 74292,
 -1,
 145692046,
 74291,
 145885363,
 145596019,
 74294,
 -1,
 145820450,
 74295,
 -1,
 145831135,
 74296,
 146145279,
 145494886,
 74297,
 146210815,
 146014208,
 -1,
 146213050,
 146131176,
 -1,
 146278585,
 146150798,
 74298,
 -1,
 146213029,
 74299,
 -1,
 146225303,
 74300,
 -1,
 146167971,
 74301,
 146540733,
 145445675,
 74286,
 -1,
 146474037,
 74287,
 -63298,
 146517618,
 74289,
 -63297,
 146640714,
 74288,
 -1,
 146671553,
 74285,
 146868425,
 145364366,
 74272,
 146933955,
 146848420,
 74278,
 -1,
 146870977,
 74279,
 147065030,
 146866176,
 -1,
 -63291,
 147048758,
 74273,
 -1,
 147085475,
 74274,
 -63289,
 147040726,
 74277,
 -63288,
 147216627,
 74276,
 -1,
 147264193,
 74275,
 147458251,
 146825703,
 74282,
 -1,
 147425602,
 74283,
 147652607,
 147407015,
 74280,
 -1,
 147568560,
 74281,
 147720424,
 145318375,
 74047,
 147785941,
 147685448,
 74062,
 147851476,
 147718144,
 -1,
 -63279,
 147835190,
 74063,
 -63278,
 147898378,
 74066,
 -63277,
 147953718,
 74065,
 -1,
 147993785,
 74064,
 -1,
 147810200,
 74067,
 148244700,
 147739435,
 74053,
 148373503,
 148201959,
 74054,
 148439039,
 148242432,
 -1,
 -63271,
 148352646,
 74056,
 -63270,
 148413933,
 74057,
 -63269,
 148461731,
 74058,
 -1,
 148519270,
 74055,
 148703455,
 148206532,
 74059,
 -63266,
 148640449,
 74061,
 -1,
 148704093,
 74060,
 148900067,
 148650478,
 74050,
 149028863,
 148834138,
 -1,
 -63262,
 148946954,
 74052,
 -1,
 148974720,
 74051,
 -63260,
 148880036,
 74070,
 -63259,
 149137878,
 74069,
 -63258,
 149195074,
 74068,
 -63257,
 149235355,
 74049,
 -1,
 149291010,
 74048,
 149489922,
 147675379,
 -1,
 149555444,
 149447143,
 74029,
 149684223,
 149490449,
 -1,
 149686509,
 149562233,
 74030,
 -1,
 149623489,
 74031,
 -63250,
 149671662,
 74038,
 -63249,
 149797736,
 74037,
 -63248,
 149852426,
 74036,
 -63247,
 149910210,
 74035,
 -63246,
 149967735,
 74034,
 -63245,
 150026827,
 74033,
 -1,
 150087419,
 74032,
 150276349,
 149540590,
 74039,
 150341884,
 150218414,
 74040,
 150470655,
 150276881,
 -1,
 -63240,
 150392990,
 74045,
 -63239,
 150436884,
 74044,
 -63238,
 150499747,
 74043,
 -63237,
 150559201,
 74042,
 -1,
 150609251,
 74041,
 -1,
 150303766,
 74046,
 150929407,
 150214030,
 74025,
 150931713,
 150798336,
 -1,
 -63232,
 150914577,
 74026,
 -1,
 150952099,
 74027,
 -1,
 150893508,
 74028,
 151193885,
 149463147,
 -1,
 151259416,
 151151079,
 74367,
 151324945,
 151191552,
 -1,
 151390480,
 151308520,
 -1,
 151456008,
 151375598,
 74375,
 -1,
 151392961,
 74376,
 151587082,
 151413223,
 74373,
 -1,
 151529115,
 74374,
 151718157,
 151529115,
 -1,
 -63220,
 151703278,
 74371,
 -1,
 151740903,
 74370,
 151914767,
 151655822,
 74368,
 -1,
 151856795,
 74369,
 -1,
 151863463,
 74372,
 -1,
 151336212,
 74377,
 152240127,
 151301866,
 74378,
 152305663,
 152109056,
 -1,
 152307991,
 152226024,
 -1,
 -63211,
 152299530,
 74381,
 -63210,
 152359070,
 74380,
 -1,
 152400202,
 74379,
 -1,
 152279133,
 74382,
 152635676,
 151197070,
 74362,
 -63206,
 152608875,
 74365,
 -63205,
 152668482,
 74364,
 -1,
 152712748,
 74363,
 -1,
 152586940,
 74366,
 152963382,
 151135899,
 -1,
 153028903,
 152901006,
 73792,
 153094434,
 152990660,
 73796,
 -63199,
 153032888,
 73798,
 -1,
 153093891,
 73797,
 153291044,
 153070038,
 73799,
 -1,
 153228811,
 73800,
 -63195,
 153246436,
 73795,
 -63194,
 153375577,
 73794,
 -1,
 153433644,
 73793,
 153618737,
 153013998,
 73805,
 153684269,
 153550848,
 -1,
 153749804,
 153656733,
 -1,
 -63189,
 153735799,
 73807,
 -1,
 153753138,
 73806,
 -1,
 153695340,
 73808,
 154011951,
 153659862,
 73811,
 -1,
 153948865,
 73812,
 154206207,
 153976734,
 73809,
 -1,
 154076941,
 73810,
 154337279,
 153575911,
 73801,
 154402815,
 154209041,
 -1,
 -63180,
 154297817,
 73804,
 -63179,
 154358784,
 73803,
 -1,
 154408334,
 73802,
 154601802,
 152954872,
 -1,
 154667326,
 154558951,
 74595,
 154732858,
 154609307,
 74598,
 -1,
 154666227,
 74599,
 -63173,
 154724359,
 74601,
 -63172,
 154817323,
 74600,
 -63171,
 154866534,
 74597,
 -1,
 154929256,
 74596,
 155126083,
 154652398,
 74602,
 155191617,
 155063331,
 74603,
 -1,
 155126553,
 74604,
 -63166,
 155156552,
 74606,
 -1,
 155266176,
 74605,
 155453769,
 155063694,
 74589,
 155519303,
 155385856,
 -1,
 -63162,
 155502097,
 74590,
 -1,
 155566107,
 74591,
 -63160,
 155486491,
 74593,
 -1,
 155669291,
 74592,
 -1,
 155402535,
 74594,
 155975679,
 154577366,
 -1,
 155978061,
 155850126,
 74383,
 -1,
 155920027,
 74384,
 -63154,
 155963118,
 74386,
 -1,
 156066279,
 74385,
 156240346,
 85299452,
 -1,
 156305782,
 156192414,
 -1,
 156371301,
 156277878,
 -1,
 156436823,
 156358955,
 74812,
 156502358,
 156368896,
 -1,
 -63147,
 156444315,
 74815,
 -1,
 156505486,
 74814,
 -1,
 156439510,
 74813,
 156764507,
 156378779,
 -1,
 156830042,
 156704110,
 74834,
 -1,
 156765218,
 74835,
 -1,
 156817168,
 74808,
 157026654,
 156744505,
 -1,
 -63139,
 157011694,
 74800,
 -1,
 157029057,
 74790,
 157223265,
 156980454,
 -1,
 -63136,
 157208302,
 74785,
 -1,
 157225665,
 74776,
 157419875,
 157164409,
 74754,
 -1,
 157354718,
 74828,
 -63132,
 157404910,
 74767,
 -1,
 157497931,
 74761,
 157745151,
 156331753,
 -1,
 157747563,
 157661104,
 -1,
 157813098,
 157702880,
 -1,
 -63127,
 157798126,
 74801,
 -1,
 157815489,
 74791,
 -1,
 157773690,
 74844,
 158075247,
 157689499,
 -1,
 158140782,
 158014830,
 74836,
 -1,
 158075938,
 74837,
 -1,
 158127888,
 74809,
 158337394,
 158029030,
 -1,
 -63119,
 158322414,
 74786,
 -1,
 158339777,
 74777,
 158534004,
 158278521,
 74755,
 -1,
 158468830,
 74829,
 -63115,
 158519022,
 74768,
 -1,
 158612043,
 74762,
 158796186,
 156287864,
 -1,
 158861706,
 158752963,
 -1,
 158927229,
 158841657,
 -1,
 158992763,
 158912238,
 74798,
 -1,
 158927906,
 74799,
 159186943,
 158929601,
 74788,
 -1,
 159058978,
 74789,
 159254913,
 158869147,
 -1,
 159320448,
 159242000,
 74806,
 -1,
 159255586,
 74807,
 -1,
 159260014,
 74833,
 159517060,
 159242484,
 -1,
 -63101,
 159454021,
 74811,
 -1,
 159519409,
 74810,
 159713671,
 159470822,
 -1,
 -63098,
 159698670,
 74784,
 -1,
 159716033,
 74775,
 159910281,
 159654777,
 74753,
 -1,
 159845086,
 74827,
 -1,
 159857227,
 74760,
 160169983,
 158851684,
 -1,
 160172430,
 160089989,
 -1,
 -63091,
 160159955,
 74846,
 -1,
 160184907,
 74843,
 160369041,
 160152377,
 -1,
 -63088,
 160354030,
 74797,
 -1,
 160371393,
 74787,
 160565652,
 160322790,
 -1,
 -63085,
 160550638,
 74783,
 -1,
 160568001,
 74774,
 160762263,
 160507547,
 -1,
 -63082,
 160749328,
 74805,
 -1,
 160767342,
 74832,
 160958873,
 160703353,
 74752,
 -1,
 160893662,
 74826,
 -1,
 160910017,
 74841,
 161155505,
 158775216,
 -1,
 161221030,
 161107124,
 -1,
 161286561,
 161208601,
 -1,
 161352096,
 161218560,
 -1,
 -63073,
 161293979,
 74819,
 -1,
 161355150,
 74818,
 -1,
 161289062,
 74817,
 -63070,
 161271534,
 74770,
 -63069,
 161594174,
 74793,
 -63068,
 161633515,
 74779,
 -63067,
 161692235,
 74764,
 -1,
 161751929,
 74757,
 161941934,
 161181535,
 -1,
 162007465,
 161883001,
 74756,
 -1,
 161942238,
 74830,
 -63062,
 161994978,
 74816,
 -63061,
 162123502,
 74769,
 -63060,
 162183998,
 74792,
 -63059,
 162223339,
 74778,
 -1,
 162282059,
 74763,
 162529279,
 161897193,
 -1,
 -63056,
 162432453,
 74803,
 -1,
 162478667,
 74802,
 162662852,
 161124850,
 -1,
 162728385,
 162630505,
 -1,
 162793910,
 162711401,
 -1,
 -63051,
 162781395,
 74845,
 -1,
 162806347,
 74842,
 162990521,
 162747622,
 -1,
 -63048,
 162975470,
 74782,
 -1,
 162992833,
 74773,
 163187132,
 162939047,
 -1,
 -63045,
 163167084,
 74840,
 -1,
 163210634,
 74847,
 163383743,
 163128987,
 -1,
 -63042,
 163370768,
 74804,
 -1,
 163388782,
 74831,
 -63040,
 163363675,
 74796,
 -1,
 163555551,
 74848,
 163774463,
 162690729,
 -1,
 -63037,
 163691994,
 74849,
 -1,
 163752151,
 74850,
 163908050,
 162630870,
 -1,
 163973583,
 163875689,
 -1,
 164039114,
 163961093,
 74822,
 -63032,
 163976150,
 74824,
 -63031,
 164041574,
 74823,
 -1,
 164102146,
 74825,
 -63029,
 164024046,
 74772,
 -63028,
 164281150,
 74795,
 -63027,
 164320491,
 74781,
 -63026,
 164379211,
 74766,
 -1,
 164438905,
 74759,
 164691967,
 163927536,
 -1,
 -63023,
 164595141,
 74838,
 -1,
 164645539,
 74839,
 164888575,
 163857757,
 -1,
 164891093,
 164813118,
 74820,
 -1,
 164828006,
 74821,
 -63018,
 164876014,
 74771,
 -63017,
 165002046,
 74794,
 -63016,
 165041387,
 74780,
 -63015,
 165100107,
 74765,
 -1,
 165159801,
 74758,
 165412863,
 156215201,
 -1,
 165415390,
 165296348,
 -1,
 -63011,
 165399520,
 74867,
 -1,
 165425688,
 74866,
 -63009,
 165403510,
 74865,
 -1,
 165581953,
 74864,
 165743080,
 85240278,
 -1,
 165808614,
 165707806,
 -1,
 165874149,
 165772624,
 -1,
 -63004,
 165845112,
 8910,
 -1,
 165879180,
 8911,
 -1,
 165817235,
 9130,
 -63001,
 165796340,
 10081,
 -1,
 166112600,
 164,
 -62999,
 165716124,
 9982,
 -1,
 166209599,
 8731,
 166399312,
 85136782,
 -1,
 166464784,
 166365506,
 -1,
 166530317,
 166402111,
 -1,
 166595282,
 166472963,
 5281,
 166660804,
 166532494,
 5264,
 166726338,
 166639159,
 -1,
 166791707,
 166708088,
 -1,
 166857215,
 166773624,
 -1,
 166922745,
 166836144,
 -1,
 166988277,
 166871207,
 5737,
 -1,
 166936743,
 5738,
 -62986,
 166973166,
 5735,
 -62985,
 167088626,
 5736,
 -62984,
 167141863,
 5739,
 -1,
 167187854,
 5740,
 167381499,
 166871207,
 5604,
 -1,
 167329959,
 5605,
 -62980,
 167366382,
 5602,
 -62979,
 167481842,
 5603,
 -62978,
 167535079,
 5606,
 -1,
 167581070,
 5607,
 167774733,
 166818756,
 -1,
 167840263,
 167729395,
 -1,
 167905795,
 167788711,
 5686,
 -1,
 167854247,
 5687,
 -62972,
 167890670,
 5684,
 -62971,
 168006130,
 5685,
 -62970,
 168059367,
 5688,
 -1,
 168105358,
 5689,
 168299017,
 167788711,
 5692,
 -1,
 168247463,
 5693,
 -62966,
 168283886,
 5690,
 -62965,
 168399346,
 5691,
 -62964,
 168452583,
 5694,
 -1,
 168498574,
 5695,
 168692244,
 167753648,
 -1,
 168757776,
 168640679,
 5725,
 -1,
 168706215,
 5726,
 -62959,
 168742638,
 5723,
 -62958,
 168858098,
 5724,
 -62957,
 168911335,
 5727,
 -1,
 168957326,
 5728,
 169213951,
 168646899,
 -1,
 169216535,
 169099431,
 5598,
 -1,
 169164967,
 5599,
 -62952,
 169201390,
 5596,
 -62951,
 169316850,
 5597,
 -62950,
 169370087,
 5600,
 -1,
 169416078,
 5601,
 169609776,
 166737452,
 -1,
 169675299,
 169601016,
 -1,
 169740831,
 169623719,
 5706,
 -1,
 169689255,
 5707,
 -62944,
 169725678,
 5704,
 -62943,
 169841138,
 5705,
 -62942,
 169894375,
 5708,
 -1,
 169940366,
 5709,
 170134058,
 169636804,
 -1,
 170199590,
 170082471,
 5674,
 -1,
 170148007,
 5675,
 -62937,
 170184430,
 5672,
 -62936,
 170299890,
 5673,
 -62935,
 170353127,
 5676,
 -1,
 170399118,
 5677,
 170592815,
 170082471,
 -1,
 170658350,
 170559810,
 -1,
 -62931,
 170640487,
 6389,
 -1,
 170672308,
 6382,
 -1,
 170606759,
 5203,
 -1,
 170549735,
 5204,
 170986050,
 169562923,
 -1,
 171051576,
 170940659,
 -1,
 171117108,
 170999975,
 5574,
 -1,
 171065511,
 5575,
 -62923,
 171101934,
 5572,
 -62922,
 171217394,
 5573,
 -62921,
 171270631,
 5576,
 -1,
 171316622,
 5577,
 171510331,
 171040218,
 -1,
 -62918,
 171495150,
 6381,
 -1,
 171513230,
 6384,
 171706941,
 171458727,
 5617,
 -1,
 171655335,
 5618,
 171838015,
 171644302,
 5620,
 -1,
 171775374,
 6383,
 -62912,
 171822830,
 5615,
 -62911,
 171938290,
 5616,
 -1,
 171991527,
 5619,
 172165712,
 170964912,
 -1,
 172231242,
 172120307,
 5722,
 172296774,
 172179623,
 5718,
 -1,
 172245159,
 5719,
 -62905,
 172281582,
 5716,
 -62904,
 172397042,
 5717,
 -62903,
 172450279,
 5720,
 -1,
 172496270,
 5721,
 172689996,
 172179623,
 5712,
 -1,
 172638375,
 5713,
 -62899,
 172674798,
 5710,
 -62898,
 172790258,
 5711,
 -62897,
 172843495,
 5714,
 -1,
 172889486,
 5715,
 173083231,
 172126454,
 -1,
 173148760,
 173043958,
 5633,
 173214292,
 173097127,
 5629,
 -1,
 173162663,
 5630,
 -62891,
 173199086,
 5627,
 -62890,
 173314546,
 5628,
 -62889,
 173367783,
 5631,
 -1,
 173413774,
 5632,
 173670399,
 173103347,
 -1,
 173673051,
 173555879,
 5623,
 -1,
 173621415,
 5624,
 -62884,
 173657838,
 5621,
 -62883,
 173773298,
 5622,
 -62882,
 173826535,
 5625,
 -1,
 173872526,
 5626,
 174066286,
 173043607,
 -1,
 174131815,
 174026647,
 -1,
 174197347,
 174080167,
 5662,
 -1,
 174145703,
 5663,
 -62876,
 174182126,
 5660,
 -62875,
 174297586,
 5661,
 -62874,
 174350823,
 5664,
 -1,
 174396814,
 5665,
 174590569,
 174080167,
 5655,
 -1,
 174538919,
 5656,
 -62870,
 174579202,
 6386,
 -62869,
 174706414,
 5652,
 -62868,
 174756338,
 5654,
 -62867,
 174809575,
 5657,
 -1,
 174855566,
 5659,
 175049340,
 174027716,
 -1,
 175114870,
 175003891,
 -1,
 175180402,
 175063207,
 5680,
 -1,
 175128743,
 5681,
 -62861,
 175165166,
 5678,
 -62860,
 175280626,
 5679,
 -62859,
 175333863,
 5682,
 -1,
 175379854,
 5683,
 175573624,
 175063207,
 5668,
 -1,
 175521959,
 5669,
 -62855,
 175558382,
 5666,
 -62854,
 175673842,
 5667,
 -62853,
 175727079,
 5670,
 -1,
 175773070,
 5671,
 175966854,
 175003891,
 5195,
 176032388,
 175955418,
 -1,
 176097920,
 175980711,
 5592,
 -1,
 176046247,
 5593,
 -62847,
 176082670,
 5590,
 -62846,
 176198130,
 5591,
 -62845,
 176251367,
 5594,
 -1,
 176297358,
 5595,
 -62843,
 175989223,
 5175,
 -1,
 176440135,
 5174,
 176622221,
 175958008,
 5702,
 176687753,
 176570535,
 5698,
 -1,
 176636071,
 5699,
 -62838,
 176672494,
 5696,
 -62837,
 176787954,
 5697,
 -62836,
 176841191,
 5700,
 -1,
 176887182,
 5701,
 177080980,
 176595051,
 5614,
 177146512,
 177029287,
 5610,
 -1,
 177094823,
 5611,
 -62831,
 177131246,
 5608,
 -62830,
 177246706,
 5609,
 -62829,
 177299943,
 5612,
 -1,
 177345934,
 5613,
 177539740,
 177047874,
 -1,
 177605271,
 177488039,
 5636,
 -1,
 177553575,
 5637,
 -62824,
 177589998,
 5634,
 -62823,
 177705458,
 5635,
 -62822,
 177758695,
 5638,
 -62821,
 177820459,
 5329,
 -1,
 177870222,
 5639,
 178064035,
 177530048,
 -1,
 178129567,
 178012327,
 5648,
 -1,
 178077863,
 5649,
 -62816,
 178114286,
 5646,
 -62815,
 178229746,
 5647,
 -62814,
 178282983,
 5650,
 -1,
 178328974,
 5651,
 178522794,
 178052570,
 -1,
 178588326,
 178471079,
 5586,
 -1,
 178536615,
 5587,
 -62809,
 178573038,
 5584,
 -62808,
 178688498,
 5585,
 -62807,
 178741735,
 5588,
 -1,
 178787726,
 5589,
 178981553,
 178498006,
 -1,
 179047085,
 178929831,
 5580,
 -1,
 178995367,
 5581,
 -62802,
 179031790,
 5578,
 -62801,
 179147250,
 5579,
 -62800,
 179200487,
 5582,
 -1,
 179246478,
 5583,
 179440312,
 178946120,
 -1,
 179505844,
 179388583,
 5642,
 -1,
 179454119,
 5643,
 -62795,
 179490542,
 5640,
 -62794,
 179606002,
 5641,
 -62793,
 179659239,
 5644,
 -1,
 179705230,
 5645,
 179899071,
 179384135,
 -1,
 179964603,
 179847335,
 5731,
 -1,
 179912871,
 5732,
 -62788,
 179949294,
 5729,
 -62787,
 180064754,
 5730,
 -62786,
 180117991,
 5733,
 -1,
 180163982,
 5734,
 180357825,
 179855847,
 5129,
 -1,
 180325776,
 5703,
 -1,
 180306759,
 5128,
 180617215,
 166663566,
 5265,
 -1,
 180511207,
 5258,
 180685516,
 166649306,
 -1,
 180751047,
 180654578,
 5272,
 -1,
 180720114,
 5274,
 180882121,
 180707815,
 5268,
 -1,
 180838887,
 5270,
 181013195,
 180819342,
 5276,
 -1,
 180950414,
 5278,
 -1,
 180961447,
 5266,
 181209806,
 180654578,
 5261,
 -1,
 181178866,
 5262,
 181340880,
 181166567,
 5259,
 -1,
 181297639,
 5260,
 -62767,
 181296378,
 5741,
 -1,
 181420199,
 5257,
 181603156,
 166583770,
 -1,
 181668670,
 181551271,
 5132,
 181796863,
 181649576,
 -1,
 181799741,
 181669706,
 -1,
 181865191,
 181778352,
 -1,
 181930719,
 181853658,
 -1,
 181996250,
 181899762,
 5373,
 -1,
 181965298,
 5375,
 182127324,
 181952999,
 5369,
 -1,
 182084071,
 5371,
 182258398,
 182064526,
 5377,
 -1,
 182195598,
 5379,
 -1,
 182206631,
 5367,
 182517759,
 181887410,
 -1,
 182520546,
 182424050,
 5406,
 -1,
 182489586,
 5408,
 182651620,
 182477287,
 5402,
 -1,
 182608359,
 5404,
 182782694,
 182588814,
 5410,
 -1,
 182719886,
 5412,
 -1,
 182730919,
 5400,
 182979317,
 181826500,
 5355,
 183044848,
 182967770,
 -1,
 183110379,
 183013874,
 5347,
 -1,
 183079410,
 5349,
 183241453,
 183067111,
 5343,
 -1,
 183198183,
 5345,
 183372527,
 183178638,
 5351,
 -1,
 183309710,
 5353,
 -1,
 183320743,
 5341,
 183569138,
 183013874,
 5450,
 -1,
 183538162,
 6369,
 183700212,
 183506318,
 5453,
 -1,
 183637390,
 6370,
 -1,
 183648423,
 5444,
 183896830,
 182969536,
 5440,
 184025087,
 183885274,
 -1,
 184027897,
 183931378,
 5430,
 -1,
 183996914,
 5432,
 184158971,
 183984615,
 5426,
 -1,
 184115687,
 5428,
 184290045,
 184096142,
 5434,
 -1,
 184227214,
 5436,
 -1,
 184238247,
 5424,
 184486664,
 183878520,
 -1,
 184552199,
 184475098,
 -1,
 184617730,
 184521202,
 5214,
 -1,
 184586738,
 5216,
 184748804,
 184574439,
 5210,
 -1,
 184705511,
 5212,
 184879878,
 184685966,
 5218,
 -1,
 184817038,
 5220,
 -1,
 184828071,
 5208,
 -1,
 184508857,
 5481,
 185142033,
 184459371,
 5194,
 185270271,
 185130458,
 -1,
 185273100,
 185176562,
 5185,
 -1,
 185242098,
 5187,
 185404174,
 185229799,
 5181,
 -1,
 185360871,
 5183,
 185535248,
 185341326,
 5189,
 -1,
 185472398,
 5191,
 -1,
 185483431,
 5179,
 185731866,
 185106504,
 5308,
 185860095,
 185720282,
 -1,
 185862933,
 185766386,
 5299,
 -1,
 185831922,
 5301,
 185994007,
 185819623,
 5295,
 -1,
 185950695,
 5297,
 186125081,
 185931150,
 5303,
 -1,
 186062222,
 5305,
 -1,
 186073255,
 5293,
 186321698,
 185720282,
 -1,
 186387229,
 186290674,
 5139,
 -1,
 186356210,
 5141,
 186518303,
 186343911,
 5135,
 -1,
 186474983,
 5137,
 186649377,
 186455438,
 5144,
 -1,
 186586510,
 5146,
 -1,
 186597543,
 5133,
 186845994,
 186282926,
 -1,
 186911525,
 186814962,
 5243,
 -1,
 186880498,
 5245,
 187042599,
 186868199,
 5239,
 -1,
 186999271,
 5241,
 187173673,
 186979726,
 5247,
 -1,
 187110798,
 5249,
 -1,
 187121831,
 5237,
 187370290,
 186791443,
 -1,
 187435821,
 187339250,
 5273,
 -1,
 187404786,
 5275,
 187566895,
 187392487,
 5269,
 -1,
 187523559,
 5271,
 187697969,
 187504014,
 5277,
 -1,
 187635086,
 5279,
 -1,
 187646119,
 5267,
 187894584,
 187345366,
 5457,
 -62668,
 187883013,
 5455,
 -62667,
 187929074,
 5516,
 -62666,
 187982311,
 5515,
 -62665,
 188039335,
 5514,
 -1,
 188093838,
 5517,
 188287804,
 187863433,
 -1,
 188353339,
 188224910,
 5324,
 -1,
 188290446,
 5326,
 -1,
 188301479,
 5322,
 -1,
 188240678,
 5468,
 -1,
 181750304,
 6365,
 188681039,
 181637618,
 5138,
 188809215,
 188649970,
 5140,
 188874751,
 188694592,
 -1,
 188877646,
 188794547,
 5535,
 188943178,
 188866010,
 -1,
 189008709,
 188912114,
 5754,
 -1,
 188977650,
 5755,
 189139783,
 188965351,
 5752,
 -1,
 189096423,
 5753,
 189270857,
 189076878,
 5756,
 -1,
 189207950,
 5757,
 -1,
 189219655,
 5751,
 -62645,
 188912114,
 5533,
 -62644,
 189424103,
 5532,
 -62643,
 189481127,
 5531,
 -1,
 189535630,
 5534,
 -1,
 188829896,
 5758,
 189795154,
 188618126,
 5143,
 -62639,
 189785280,
 6323,
 -1,
 189797774,
 5145,
 190054399,
 189751783,
 5134,
 -1,
 189948391,
 5136,
 190122904,
 181569858,
 5328,
 190188395,
 190059918,
 5319,
 190253928,
 190168560,
 -1,
 190319455,
 190232496,
 -1,
 190384986,
 190280622,
 5386,
 -1,
 190322062,
 5390,
 -62629,
 190373381,
 5380,
 -62628,
 190500343,
 5389,
 -62627,
 190556095,
 5388,
 -62626,
 190592534,
 5391,
 -1,
 190648742,
 5387,
 190843746,
 190307802,
 -1,
 -62623,
 190813958,
 5142,
 -1,
 190846481,
 5147,
 -62621,
 190834650,
 5437,
 -62620,
 191024635,
 5221,
 -62619,
 191074700,
 5327,
 -62618,
 191138070,
 5306,
 -62617,
 191198129,
 5250,
 -1,
 191247898,
 5280,
 191433578,
 190190990,
 5320,
 -1,
 191390183,
 5313,
 -1,
 191423680,
 6332,
 191630197,
 190173867,
 -1,
 191695732,
 191587858,
 5499,
 191761263,
 191664626,
 5495,
 -1,
 191730162,
 5496,
 191892337,
 191717863,
 5493,
 -1,
 191848935,
 5494,
 192023411,
 191829390,
 5497,
 -1,
 191960462,
 5498,
 -1,
 191971495,
 5492,
 -1,
 191682500,
 5500,
 192285566,
 191583019,
 5525,
 192351098,
 192222606,
 5523,
 192416633,
 192288142,
 5524,
 -1,
 192373223,
 5518,
 -1,
 192373223,
 5744,
 192613244,
 192319986,
 5521,
 -1,
 192582130,
 5522,
 192806911,
 192569831,
 5519,
 -1,
 192700903,
 5520,
 192875398,
 192273882,
 -1,
 192940929,
 192844274,
 6346,
 -1,
 192909810,
 6348,
 193072003,
 192897511,
 6342,
 -1,
 193028583,
 6344,
 193203077,
 193009038,
 5323,
 -1,
 193140110,
 5325,
 -1,
 193151143,
 5321,
 193399693,
 192842778,
 5526,
 193465225,
 193368562,
 5747,
 -1,
 193434098,
 5748,
 193596299,
 193421799,
 5745,
 -1,
 193552871,
 5746,
 193789951,
 193533326,
 5749,
 -1,
 193664398,
 5750,
 193858448,
 193368562,
 5316,
 -62577,
 193848512,
 6331,
 -1,
 193892850,
 5317,
 194055060,
 193793881,
 -1,
 194120595,
 194011623,
 5473,
 -1,
 194077159,
 5475,
 -1,
 194068647,
 5471,
 194317206,
 194011623,
 5314,
 -1,
 194273767,
 5315,
 -62569,
 194271475,
 5330,
 -1,
 194396327,
 5312,
 194579415,
 190104440,
 5222,
 194644909,
 194533619,
 5482,
 194710434,
 194580313,
 5550,
 194775965,
 194679282,
 5546,
 -1,
 194744818,
 5547,
 194907039,
 194732519,
 5544,
 -1,
 194863591,
 5545,
 195038113,
 194844046,
 5548,
 -1,
 194975118,
 5549,
 -1,
 194986151,
 5543,
 195234726,
 194698714,
 -1,
 195300261,
 195171726,
 6372,
 -1,
 195237262,
 5480,
 -1,
 195248295,
 6371,
 195496872,
 195203570,
 5476,
 -1,
 195465714,
 5477,
 195627946,
 195453415,
 5472,
 -1,
 195584487,
 5474,
 195759020,
 195564942,
 5478,
 -1,
 195696014,
 5479,
 -1,
 195707047,
 5470,
 195955642,
 194626424,
 -1,
 196021174,
 195909875,
 5487,
 196086705,
 195990002,
 5485,
 -1,
 196055538,
 6374,
 196217779,
 196023694,
 5486,
 -1,
 196154766,
 6375,
 -62540,
 196206372,
 6373,
 -62539,
 196305383,
 5484,
 -1,
 196362407,
 5483,
 -62537,
 195990002,
 5225,
 -62536,
 196501991,
 5224,
 -62535,
 196559015,
 5223,
 -1,
 196613518,
 5226,
 196807618,
 195943898,
 -1,
 196873149,
 196776434,
 5213,
 -1,
 196841970,
 5215,
 197004223,
 196829671,
 5209,
 -1,
 196960743,
 5211,
 197135297,
 196941198,
 5217,
 -1,
 197072270,
 5219,
 -1,
 197083303,
 5207,
 197331913,
 196770502,
 -1,
 197397445,
 197300722,
 5512,
 -1,
 197366258,
 6377,
 -62522,
 197386020,
 6376,
 -62521,
 197485031,
 5511,
 -62520,
 197542055,
 5510,
 -1,
 197596558,
 5513,
 197790670,
 197321920,
 -1,
 -62517,
 197759474,
 5490,
 -62516,
 197812711,
 5489,
 -62515,
 197869735,
 5488,
 -1,
 197924238,
 5491,
 198118354,
 197727630,
 5205,
 198183889,
 198055310,
 5206,
 -1,
 198140391,
 5197,
 -1,
 198173888,
 6327,
 198380500,
 198087154,
 5200,
 -1,
 198349298,
 5201,
 198511574,
 198336999,
 5198,
 -1,
 198468071,
 5199,
 -1,
 198459559,
 5196,
 198708247,
 194557872,
 5381,
 198773745,
 198645134,
 5364,
 198839279,
 198763712,
 6335,
 198967295,
 198798724,
 -1,
 198970338,
 198884004,
 -1,
 199035870,
 198939122,
 5529,
 -1,
 199004658,
 6379,
 -62497,
 199024420,
 6378,
 -62496,
 199123431,
 5528,
 -62495,
 199180455,
 5527,
 -1,
 199234958,
 5530,
 199429096,
 198924531,
 -1,
 199494629,
 199397874,
 5570,
 -1,
 199463410,
 6380,
 -62490,
 199451111,
 5569,
 -62489,
 199573671,
 5568,
 -1,
 199628174,
 5571,
 199822316,
 199389079,
 -1,
 199887851,
 199806702,
 5653,
 -1,
 199872238,
 6385,
 -1,
 199844327,
 5658,
 -62483,
 199812674,
 5441,
 -62482,
 200066739,
 5282,
 -1,
 200114248,
 5311,
 200343551,
 198776206,
 5365,
 -1,
 200237543,
 5358,
 200412164,
 198727923,
 5413,
 200477691,
 200400346,
 -1,
 200543222,
 200446450,
 5405,
 -62475,
 200533184,
 6338,
 -1,
 200577522,
 5407,
 200739832,
 200499687,
 5401,
 -1,
 200696295,
 5403,
 200870906,
 200676750,
 5409,
 -1,
 200807822,
 5411,
 -1,
 200818855,
 5399,
 201067518,
 200446450,
 5395,
 -62467,
 201057472,
 6336,
 -1,
 201101810,
 5396,
 201264129,
 201004430,
 5397,
 -62464,
 201254080,
 6337,
 -1,
 201266574,
 5398,
 201460739,
 201220583,
 5393,
 -1,
 201417191,
 5394,
 -1,
 201408679,
 5392,
 201657356,
 200400346,
 5383,
 201722887,
 201626098,
 5372,
 -1,
 201691634,
 5374,
 201853961,
 201679335,
 5368,
 -1,
 201810407,
 5370,
 201985035,
 201790862,
 5376,
 -1,
 201921934,
 5378,
 -1,
 201932967,
 5366,
 202181652,
 201626098,
 5361,
 202247186,
 202168321,
 -1,
 -62449,
 202216390,
 5255,
 -62448,
 202270198,
 5254,
 -62447,
 202327281,
 5253,
 -1,
 202381596,
 5256,
 -62445,
 202237120,
 6334,
 -1,
 202543602,
 5362,
 202705942,
 202138087,
 5359,
 -1,
 202662375,
 5360,
 -1,
 202653863,
 5357,
 202902584,
 198698176,
 5438,
 202968102,
 202837834,
 -1,
 203033628,
 202940523,
 -1,
 -62437,
 203021829,
 5192,
 -1,
 203069190,
 5173,
 -62435,
 203024158,
 5420,
 -62434,
 203218394,
 5149,
 -62433,
 203279007,
 5202,
 -62432,
 203341663,
 5363,
 -62431,
 203396870,
 5127,
 -62430,
 203460120,
 5318,
 -62429,
 203523960,
 5289,
 -62428,
 203587053,
 5337,
 -62427,
 203649812,
 5233,
 -1,
 203699053,
 5263,
 203885614,
 202956250,
 -1,
 203951145,
 203854322,
 5429,
 -1,
 203919858,
 5431,
 204082219,
 203907559,
 5425,
 -1,
 204038631,
 5427,
 204213293,
 204019086,
 5433,
 -1,
 204150158,
 5435,
 -1,
 204161191,
 5423,
 204409906,
 203822478,
 5421,
 204475441,
 204346766,
 5422,
 -1,
 204431847,
 5415,
 -1,
 204465344,
 6340,
 204672053,
 204378610,
 5418,
 -62412,
 204661952,
 6339,
 -1,
 204706290,
 5419,
 204868663,
 204628455,
 5416,
 -1,
 204825063,
 5417,
 -1,
 204816551,
 5414,
 205065303,
 202854046,
 5469,
 205130831,
 205021671,
 5461,
 205196366,
 205097438,
 -1,
 205261888,
 205171158,
 -1,
 205327423,
 205218279,
 -1,
 -62402,
 205294618,
 5156,
 -1,
 205346123,
 5155,
 -1,
 205265322,
 6367,
 205589573,
 205208272,
 -1,
 205655108,
 205574093,
 -1,
 -62397,
 205634631,
 5158,
 -1,
 205658054,
 5157,
 -1,
 205644363,
 5162,
 205917256,
 205567920,
 -1,
 -62393,
 205881890,
 6366,
 -1,
 205938737,
 5160,
 -62391,
 205900486,
 5154,
 -62390,
 206087374,
 5161,
 -62389,
 206144835,
 5159,
 -62388,
 206198573,
 5152,
 -62387,
 206252837,
 5153,
 -1,
 206313414,
 5151,
 -1,
 205152743,
 5462,
 206572626,
 205067662,
 5465,
 206700543,
 206509454,
 5466,
 -1,
 206594535,
 5460,
 206769236,
 206541298,
 5463,
 -1,
 206737906,
 5464,
 -62379,
 206757381,
 5467,
 -62378,
 206885310,
 5742,
 -1,
 206913703,
 5459,
 207096944,
 205026244,
 5354,
 207162464,
 207085018,
 -1,
 207227995,
 207131122,
 5346,
 -1,
 207196658,
 5348,
 207359069,
 207184359,
 5342,
 -1,
 207315431,
 5344,
 207490143,
 207295886,
 5350,
 -1,
 207426958,
 5352,
 -1,
 207437991,
 5340,
 207686759,
 207116531,
 5542,
 207752291,
 207655410,
 5538,
 -1,
 207720946,
 5539,
 207883365,
 207708647,
 5536,
 -1,
 207839719,
 5537,
 208076799,
 207820174,
 5540,
 -1,
 207951246,
 5541,
 208145515,
 207623566,
 5338,
 208211050,
 208082318,
 5339,
 -1,
 208167399,
 5332,
 -1,
 208200896,
 6333,
 208407661,
 208114162,
 5335,
 -1,
 208376306,
 5336,
 208538735,
 208364007,
 5333,
 -1,
 208495079,
 5334,
 -1,
 208486567,
 5331,
 208735367,
 207061064,
 5307,
 208800889,
 208723418,
 -1,
 208866420,
 208769522,
 5298,
 -1,
 208835058,
 5300,
 208997494,
 208822759,
 5294,
 -1,
 208953831,
 5296,
 209128568,
 208934286,
 5302,
 -1,
 209065358,
 5304,
 -1,
 209076391,
 5292,
 209325181,
 208737678,
 5290,
 209390716,
 209261966,
 5291,
 -1,
 209347047,
 5284,
 -1,
 209380544,
 6330,
 209587328,
 209293810,
 5287,
 209715199,
 209555954,
 5288,
 -1,
 209631536,
 5385,
 209783940,
 209535143,
 5283,
 209911807,
 209729827,
 -1,
 -62333,
 209824214,
 5458,
 -1,
 209875908,
 5356,
 210046086,
 209740263,
 5285,
 -1,
 210002407,
 5286,
 -1,
 210000115,
 5309,
 210242721,
 208676507,
 -1,
 210308253,
 210203809,
 -1,
 210373774,
 210296282,
 5759,
 -62325,
 210342386,
 5558,
 -62324,
 210395623,
 5557,
 -62323,
 210452647,
 5556,
 -1,
 210507150,
 5559,
 210701459,
 210340162,
 -1,
 -62320,
 210670066,
 5562,
 -62319,
 210723303,
 5561,
 -62318,
 210780327,
 5560,
 -1,
 210834830,
 5563,
 211029144,
 210661622,
 -1,
 -62315,
 210997746,
 5566,
 -62314,
 211050983,
 5565,
 -62313,
 211108007,
 5564,
 -1,
 211162510,
 5567,
 -62311,
 211007408,
 5384,
 -62310,
 211325426,
 5554,
 -62309,
 211378663,
 5553,
 -62308,
 211435687,
 5552,
 -1,
 211490190,
 5555,
 211684512,
 210256360,
 -1,
 -62305,
 211659222,
 6388,
 -1,
 211710916,
 6387,
 -1,
 211641161,
 5439,
 211946678,
 210217430,
 5456,
 212012202,
 211934682,
 -1,
 212077733,
 211980786,
 6353,
 -1,
 212046322,
 6354,
 212208807,
 212034023,
 6351,
 -1,
 212165095,
 6352,
 212339881,
 212145550,
 6355,
 -1,
 212276622,
 5454,
 -1,
 212288327,
 6350,
 212536494,
 211948942,
 5451,
 212602029,
 212473230,
 5452,
 -1,
 212558311,
 5445,
 -1,
 212591808,
 6341,
 212798640,
 212505074,
 5448,
 -1,
 212767218,
 5449,
 212929714,
 212754919,
 5446,
 -1,
 212885991,
 5447,
 213060789,
 212864849,
 -1,
 -62284,
 213049124,
 6368,
 -1,
 213074087,
 5443,
 -1,
 213008551,
 5442,
 213322954,
 211918955,
 5193,
 213388480,
 213310938,
 -1,
 213454011,
 213357042,
 5184,
 -62278,
 213443776,
 6326,
 -1,
 213488114,
 5186,
 213650621,
 213410279,
 5180,
 -1,
 213606887,
 5182,
 213781695,
 213587342,
 5188,
 -1,
 213718414,
 5190,
 -1,
 213729447,
 5178,
 213978308,
 213325198,
 5176,
 214043843,
 213915022,
 5177,
 -1,
 214000103,
 5168,
 -1,
 214033600,
 6325,
 214240455,
 213946866,
 5171,
 -62266,
 214230208,
 6324,
 -1,
 214274546,
 5172,
 214437065,
 214196711,
 5169,
 -1,
 214393319,
 5170,
 -1,
 214384807,
 5167,
 214633693,
 213283062,
 5251,
 214699220,
 214621658,
 5252,
 214764751,
 214635918,
 5246,
 -62258,
 214754496,
 6329,
 -1,
 214766990,
 5248,
 214961361,
 214733298,
 5242,
 -1,
 214929906,
 5244,
 215092435,
 214917607,
 5238,
 -1,
 215048679,
 5240,
 -1,
 215040167,
 5236,
 215289048,
 214635918,
 5234,
 215354583,
 215225742,
 5235,
 -1,
 215310823,
 5228,
 -1,
 215344320,
 6328,
 215551194,
 215257586,
 5231,
 -1,
 215519730,
 5232,
 215682268,
 215507431,
 5229,
 -1,
 215638503,
 5230,
 -1,
 215629991,
 5227,
 215878895,
 214602226,
 5125,
 215944428,
 215838828,
 -1,
 216009957,
 215910722,
 6361,
 216137727,
 215997914,
 -1,
 216141027,
 216044018,
 6347,
 -1,
 216109554,
 6349,
 216334335,
 216097255,
 6343,
 -1,
 216228327,
 6345,
 216403175,
 215988144,
 6362,
 -1,
 216357107,
 6363,
 -62232,
 216384376,
 6357,
 -62231,
 216506475,
 6356,
 -62230,
 216563784,
 6360,
 -62229,
 216625398,
 6358,
 -1,
 216673539,
 6359,
 -62227,
 215934144,
 6320,
 -62226,
 216830450,
 5126,
 -1,
 216893762,
 5165,
 217058554,
 215815566,
 5130,
 217124083,
 216995214,
 5131,
 -62222,
 217113792,
 6322,
 -1,
 217145831,
 5122,
 217320694,
 217106203,
 -1,
 -62219,
 217298864,
 5382,
 -1,
 217350216,
 5310,
 217517304,
 217276903,
 5148,
 -1,
 217504876,
 5551,
 -62215,
 217507008,
 6321,
 -1,
 217614658,
 5166,
 217779459,
 217032646,
 5509,
 217844991,
 217716110,
 5507,
 217910526,
 217781646,
 5508,
 -1,
 217866727,
 5502,
 -1,
 217866727,
 5743,
 218107137,
 217813490,
 5505,
 -1,
 218075634,
 5506,
 218300415,
 218063335,
 5503,
 -1,
 218194407,
 5504,
 218369286,
 217735655,
 5123,
 -62203,
 218335554,
 5164,
 -1,
 218391015,
 5124,
 218565897,
 218316967,
 5121,
 -62200,
 218532162,
 5163,
 -1,
 218571873,
 6364,
 218762508,
 218519795,
 -1,
 -62197,
 218752834,
 5120,
 -1,
 218788086,
 5501,
 -1,
 218715730,
 5150,
 219086847,
 166473389,
 -1,
 -62193,
 218999254,
 9803,
 -1,
 219050982,
 917631,
 219221322,
 166439382,
 -1,
 219286852,
 219177674,
 -1,
 219352344,
 219270894,
 66226,
 219480063,
 219336430,
 66239,
 219545599,
 219401966,
 66212,
 -62186,
 219467502,
 66235,
 -62185,
 219485030,
 66256,
 -1,
 219550401,
 66248,
 219745566,
 219330480,
 66224,
 219811099,
 219726712,
 66242,
 -1,
 219747009,
 66243,
 219942173,
 219764979,
 66222,
 -1,
 219878081,
 66223,
 -1,
 219920304,
 66232,
 220138787,
 219709512,
 66218,
 220266495,
 220079771,
 66250,
 -62175,
 220140502,
 66253,
 -62174,
 220205926,
 66252,
 -1,
 220271297,
 66251,
 220466471,
 220105026,
 66229,
 -62171,
 220432706,
 66227,
 -62170,
 220484395,
 66244,
 -1,
 220542508,
 66238,
 220728618,
 220447608,
 66221,
 220856319,
 220709752,
 66247,
 -1,
 220730049,
 66230,
 220925229,
 220689348,
 66211,
 221052927,
 220870188,
 66214,
 -1,
 220926657,
 66254,
 221121839,
 220899798,
 66213,
 -1,
 221096406,
 66249,
 221252913,
 221093995,
 66231,
 -1,
 221188801,
 66209,
 221383987,
 221212918,
 66236,
 -1,
 221319873,
 66237,
 221515061,
 221340135,
 66233,
 -1,
 221471207,
 66245,
 221646135,
 221467435,
 66240,
 -1,
 221582017,
 66241,
 221777209,
 221593767,
 66234,
 -1,
 221713089,
 66255,
 221908283,
 221722156,
 66210,
 -1,
 221844161,
 66220,
 222039358,
 221850970,
 -1,
 -62147,
 221975507,
 66246,
 -1,
 222040756,
 66225,
 222235968,
 221975950,
 66208,
 -1,
 222171841,
 66215,
 -62143,
 222225366,
 66228,
 -62142,
 222341062,
 66216,
 -62141,
 222401010,
 66219,
 -1,
 222439067,
 66217,
 222629192,
 219234471,
 -1,
 222694727,
 222610296,
 8248,
 -1,
 222627018,
 8257,
 -1,
 222627401,
 8453,
 -62135,
 222598544,
 711,
 -1,
 222825056,
 9936,
 223022413,
 219166252,
 -1,
 -62132,
 223006872,
 9764,
 -1,
 223024610,
 8454,
 -62130,
 223008788,
 9761,
 -62129,
 223199566,
 9963,
 -1,
 223258336,
 9809,
 223416263,
 166367730,
 -1,
 223481555,
 223379528,
 -1,
 223547082,
 223422895,
 -1,
 223612320,
 223489283,
 -1,
 223677840,
 223602586,
 -1,
 223743359,
 223640130,
 -1,
 223808861,
 223690919,
 -1,
 223874393,
 223786928,
 11757,
 -1,
 223809938,
 11765,
 -62118,
 223848918,
 11756,
 -62117,
 223971650,
 11753,
 -62116,
 224034888,
 11752,
 -1,
 224097220,
 11751,
 224267618,
 223764967,
 -1,
 224333153,
 224238424,
 -1,
 -62112,
 224274813,
 11775,
 -1,
 224335246,
 11772,
 -1,
 224280743,
 11767,
 224595301,
 224258040,
 -1,
 -62108,
 224549776,
 11748,
 -1,
 224608423,
 11749,
 224791912,
 224584896,
 -1,
 -62105,
 224775918,
 11771,
 -1,
 224797841,
 11770,
 224988523,
 224772984,
 -1,
 -62102,
 224966953,
 11760,
 -1,
 225001639,
 11758,
 225185134,
 224967332,
 -1,
 -62099,
 225128270,
 11763,
 -1,
 225187214,
 11762,
 225381745,
 225130028,
 -1,
 -62096,
 225341515,
 11768,
 -1,
 225394855,
 11747,
 225578356,
 225322651,
 -1,
 -62093,
 225535221,
 11774,
 -1,
 225591463,
 11744,
 -62091,
 225565106,
 11745,
 -62090,
 225747503,
 11755,
 -62089,
 225808882,
 11754,
 -62088,
 225871701,
 11769,
 -62087,
 225934400,
 11773,
 -62086,
 225997069,
 11750,
 -62085,
 226056465,
 11759,
 -62084,
 226121008,
 11746,
 -62083,
 226185463,
 11764,
 -62082,
 226242449,
 11761,
 -1,
 226301326,
 11766,
 226495877,
 223715435,
 -1,
 226561411,
 226432398,
 -1,
 -62078,
 226551342,
 42621,
 -1,
 226588174,
 1156,
 -62076,
 226540828,
 1158,
 -1,
 226727021,
 1159,
 226889097,
 226476920,
 -1,
 -62073,
 226848410,
 1155,
 -62072,
 226910335,
 42610,
 -1,
 226969391,
 42608,
 227151244,
 226845063,
 -1,
 -62069,
 227133396,
 1160,
 -1,
 227182003,
 42609,
 -62067,
 227139028,
 42607,
 -62066,
 227313075,
 1161,
 -62065,
 227373554,
 42620,
 -1,
 227424043,
 1157,
 227610006,
 223646194,
 -1,
 227675541,
 227575390,
 -1,
 227741076,
 227612303,
 787,
 -1,
 227674614,
 789,
 -1,
 227682424,
 806,
 -1,
 227642815,
 65062,
 228003226,
 227546510,
 -1,
 228068761,
 227980491,
 780,
 -1,
 228000307,
 812,
 -1,
 228035420,
 784,
 228265373,
 227966278,
 -1,
 -62052,
 228242028,
 8409,
 -1,
 228270740,
 8405,
 228461983,
 228224193,
 770,
 -1,
 228393523,
 813,
 -1,
 228410163,
 807,
 228658667,
 223572932,
 -1,
 228724167,
 228599104,
 -1,
 228789697,
 228703911,
 -1,
 228855207,
 228726158,
 867,
 -62043,
 228841574,
 7638,
 -62042,
 228889074,
 7637,
 -1,
 228933799,
 7636,
 229117355,
 228829654,
 876,
 229244927,
 229048320,
 -1,
 -62038,
 229160307,
 7651,
 -1,
 229189752,
 7626,
 229379501,
 229077956,
 7645,
 -1,
 229349022,
 7653,
 229510575,
 229335527,
 869,
 -1,
 229478231,
 7640,
 229641649,
 229458087,
 868,
 -1,
 229623475,
 7641,
 229772723,
 229584131,
 872,
 -1,
 229704332,
 7639,
 -62028,
 229763064,
 7654,
 -62027,
 229893078,
 879,
 -62026,
 229955686,
 878,
 -62025,
 230018798,
 871,
 -62024,
 230081400,
 877,
 -62023,
 230143920,
 7652,
 -62022,
 230199794,
 870,
 -62021,
 230263106,
 7648,
 -62020,
 230326344,
 875,
 -62019,
 230387958,
 7644,
 -62018,
 230447347,
 874,
 -62017,
 230511403,
 7642,
 -62016,
 230576478,
 7635,
 -1,
 230635052,
 873,
 230883327,
 228751962,
 -1,
 -62013,
 230795734,
 7650,
 -62012,
 230852930,
 7649,
 -62011,
 230916168,
 7647,
 -62010,
 230978500,
 7646,
 -1,
 231035691,
 7643,
 231214560,
 228672442,
 -1,
 231280093,
 231145472,
 -1,
 231345620,
 231216526,
 -1,
 231411153,
 231323203,
 -1,
 231476686,
 231365539,
 -1,
 -62003,
 231417976,
 852,
 -1,
 231478927,
 7678,
 231735295,
 231407616,
 -1,
 -62000,
 231614584,
 8430,
 -1,
 231675535,
 8406,
 231931903,
 231378023,
 -1,
 -61997,
 231811192,
 841,
 -1,
 231872143,
 794,
 232066521,
 231299345,
 -1,
 232132056,
 232028837,
 -1,
 -61993,
 232073336,
 796,
 -1,
 232134287,
 849,
 -1,
 232109527,
 8400,
 232394204,
 232042295,
 -1,
 -61989,
 232335480,
 845,
 -1,
 232396431,
 8417,
 -1,
 232375304,
 792,
 232718335,
 231267884,
 -1,
 -61985,
 232610622,
 8429,
 -1,
 232661664,
 8426,
 232852968,
 231182834,
 -1,
 232918503,
 232819741,
 -1,
 232984037,
 232896432,
 -1,
 -61980,
 232967309,
 822,
 -1,
 233018589,
 824,
 -61978,
 232971219,
 8402,
 -1,
 233127327,
 8427,
 -1,
 232906207,
 818,
 233439231,
 232809735,
 -1,
 -61974,
 233353126,
 65057,
 -1,
 233404257,
 65056,
 233573927,
 228603436,
 -1,
 233639437,
 233542130,
 -1,
 233704964,
 233623501,
 -1,
 233770483,
 233691894,
 -1,
 233836018,
 233732954,
 -1,
 -61967,
 233777272,
 840,
 -1,
 233838223,
 782,
 -1,
 233816534,
 8422,
 234098167,
 233752736,
 864,
 234225663,
 234029056,
 -1,
 -61962,
 234139558,
 65059,
 -1,
 234190689,
 65058,
 234360314,
 234073734,
 -1,
 -61959,
 234327073,
 858,
 -1,
 234378661,
 866,
 234556924,
 234324126,
 862,
 -1,
 234488371,
 863,
 234687998,
 234499054,
 861,
 -1,
 234619443,
 860,
 -61953,
 234659677,
 831,
 -61952,
 234782347,
 819,
 -61951,
 234842958,
 865,
 -61950,
 234903347,
 783,
 -61949,
 234959071,
 7629,
 -1,
 235018188,
 779,
 235212300,
 233685880,
 -1,
 235277833,
 235143168,
 -1,
 235343368,
 235214479,
 775,
 -1,
 235276790,
 856,
 -1,
 235284600,
 803,
 235601919,
 235259250,
 -1,
 -61941,
 235493171,
 7616,
 -1,
 235542476,
 7617,
 -1,
 235201107,
 798,
 235802149,
 233589920,
 -1,
 235867676,
 235747748,
 -1,
 235933202,
 235848568,
 -1,
 -61935,
 235922017,
 43234,
 -1,
 235954366,
 43235,
 236129813,
 235911088,
 -1,
 -61932,
 236089180,
 43238,
 -1,
 236145839,
 43239,
 236326424,
 236080798,
 -1,
 -61929,
 236297330,
 43236,
 -1,
 236351205,
 43237,
 -61927,
 236316783,
 43232,
 -61926,
 236492322,
 43233,
 -61925,
 236555551,
 43241,
 -1,
 236602711,
 43240,
 236785188,
 235829826,
 -1,
 -61922,
 236772407,
 43248,
 -61921,
 236834542,
 43243,
 -61920,
 236890673,
 43247,
 -61919,
 236953808,
 43246,
 -61918,
 237013406,
 43245,
 -61917,
 237072653,
 43244,
 -1,
 237114766,
 43242,
 -1,
 236764359,
 43249,
 237436927,
 235758193,
 776,
 -1,
 237306419,
 804,
 237506118,
 233548246,
 -1,
 237571649,
 237461991,
 -1,
 237637181,
 237524281,
 -1,
 237702716,
 237568000,
 -1,
 237768246,
 237642375,
 -1,
 237833779,
 237722531,
 -1,
 237899314,
 237770126,
 -1,
 237964849,
 237865667,
 -1,
 -61904,
 237949919,
 854,
 -1,
 237977219,
 7679,
 -1,
 237906798,
 848,
 -1,
 237840504,
 853,
 238354431,
 237764608,
 -1,
 -61899,
 238233720,
 8431,
 -1,
 238294671,
 8407,
 238489147,
 237721873,
 -1,
 238554682,
 238451365,
 -1,
 -61895,
 238495864,
 825,
 -1,
 238556815,
 855,
 -1,
 238532055,
 8401,
 -1,
 238470152,
 793,
 -1,
 237690462,
 8428,
 239009791,
 237603869,
 -1,
 -61889,
 238919509,
 8408,
 -61888,
 238954616,
 805,
 -1,
 239015567,
 778,
 239271935,
 237519015,
 -1,
 239275589,
 239196861,
 -1,
 -61884,
 239220273,
 788,
 -1,
 239274616,
 8421,
 -1,
 239258725,
 802,
 239537755,
 237459157,
 -1,
 239603281,
 239485779,
 -1,
 239668813,
 239569129,
 -1,
 239734348,
 239649656,
 -1,
 -61877,
 239711026,
 119362,
 -1,
 239750183,
 119363,
 -1,
 239706822,
 119364,
 -61874,
 239658824,
 837,
 -61873,
 239969103,
 834,
 -61872,
 240022329,
 835,
 -1,
 240073001,
 836,
 240320511,
 239539598,
 -1,
 240324186,
 240245170,
 -1,
 240389719,
 240254976,
 -1,
 240455254,
 240326484,
 768,
 -1,
 240386611,
 790,
 -1,
 240437875,
 832,
 240713727,
 240324326,
 -1,
 -61863,
 240615582,
 7621,
 -1,
 240654319,
 7624,
 -1,
 240296916,
 847,
 240914031,
 239474062,
 -1,
 240979556,
 240858626,
 -1,
 241045089,
 240910336,
 -1,
 241110624,
 240981844,
 769,
 -1,
 241041971,
 791,
 -1,
 241093235,
 833,
 241369087,
 240979686,
 -1,
 -61853,
 241270942,
 7623,
 -1,
 241325888,
 7625,
 241503849,
 240945474,
 -1,
 241569384,
 241485942,
 -1,
 -61849,
 241545836,
 8410,
 -1,
 241574548,
 8404,
 -1,
 241537163,
 8423,
 241831532,
 241484056,
 -1,
 -61845,
 241772664,
 857,
 -1,
 241833615,
 8432,
 242089983,
 241794332,
 -1,
 -61842,
 241969272,
 7677,
 -1,
 242030223,
 844,
 242224762,
 240877640,
 -1,
 242290297,
 242161588,
 772,
 242355829,
 242224870,
 -1,
 -61837,
 242308909,
 7622,
 -61836,
 242363374,
 7628,
 -1,
 242423750,
 7620,
 242679807,
 242286592,
 -1,
 -61833,
 242593702,
 65061,
 -61832,
 242644833,
 65060,
 -1,
 242690168,
 817,
 -1,
 242248470,
 800,
 242945669,
 242172071,
 -1,
 243011204,
 242911920,
 -1,
 243076735,
 242988976,
 -1,
 -61826,
 243050657,
 8414,
 -1,
 243086314,
 8418,
 243273345,
 243019873,
 8413,
 -1,
 243204629,
 8416,
 -61822,
 243258804,
 8420,
 -61821,
 243364446,
 8419,
 -1,
 243415353,
 8415,
 -1,
 242985104,
 839,
 243666575,
 242923440,
 -1,
 243732107,
 243621924,
 -1,
 243797642,
 243709872,
 -1,
 -61815,
 243780749,
 821,
 -1,
 243832029,
 823,
 -1,
 243784659,
 8403,
 -61812,
 243718007,
 7619,
 -61811,
 244033710,
 827,
 -61810,
 244091347,
 7618,
 -1,
 244138300,
 828,
 244321943,
 243647352,
 -1,
 244387476,
 244278887,
 771,
 244514815,
 244318208,
 -1,
 -61805,
 244424533,
 820,
 -1,
 244459640,
 816,
 -61803,
 244373179,
 786,
 -61802,
 244626171,
 8424,
 -1,
 244670709,
 8411,
 244846239,
 244277735,
 -1,
 244911774,
 244814172,
 -1,
 244977309,
 244853636,
 -1,
 245042844,
 244927659,
 785,
 -1,
 244974131,
 815,
 -1,
 244999293,
 826,
 -1,
 244923572,
 811,
 -1,
 244889546,
 7632,
 245370534,
 244788100,
 -1,
 245436067,
 245320875,
 774,
 -61790,
 245371012,
 7627,
 -1,
 245432883,
 814,
 245694463,
 245392503,
 -1,
 -61787,
 245573752,
 810,
 -1,
 245634703,
 838,
 245829292,
 245354222,
 -1,
 245894826,
 245801067,
 -1,
 -61783,
 245882431,
 846,
 -1,
 245893813,
 797,
 -61781,
 245872565,
 7634,
 -1,
 246065627,
 7633,
 246222513,
 245816054,
 -1,
 246288048,
 246184794,
 -1,
 -61777,
 246229112,
 809,
 -1,
 246290063,
 781,
 -1,
 246270112,
 830,
 246550197,
 246190578,
 -1,
 246615732,
 246503087,
 808,
 -1,
 246546437,
 7630,
 -1,
 246602387,
 773,
 246812345,
 246505159,
 -1,
 -61769,
 246789162,
 795,
 -61768,
 246846536,
 777,
 -1,
 246908839,
 843,
 247074492,
 246802666,
 -1,
 -61765,
 247015544,
 7631,
 -1,
 247076495,
 859,
 247271103,
 247063512,
 -1,
 -61762,
 247212152,
 851,
 -1,
 247273103,
 829,
 247467714,
 247242859,
 -1,
 -61759,
 247431138,
 799,
 -1,
 247470740,
 801,
 247664325,
 247427513,
 -1,
 -61756,
 247651625,
 12441,
 -1,
 247708057,
 12442,
 247860936,
 247615134,
 -1,
 -61753,
 247831704,
 8412,
 -1,
 247876121,
 850,
 -61751,
 247848959,
 8425,
 -1,
 248024821,
 842,
 248188623,
 223510600,
 -1,
 248254158,
 248138191,
 -1,
 -61747,
 248219156,
 8274,
 -1,
 248259729,
 64,
 -1,
 248190350,
 44,
 248516306,
 248160363,
 -1,
 -61743,
 248486548,
 9092,
 -1,
 248543564,
 8705,
 -1,
 248466282,
 9732,
 248778642,
 223453291,
 -1,
 248844177,
 248760417,
 -1,
 248909617,
 248821680,
 -1,
 248975143,
 248873443,
 -1,
 249040622,
 248943090,
 11423,
 249106157,
 249001637,
 -1,
 249171687,
 249049969,
 -1,
 249237215,
 249125107,
 -1,
 249302749,
 249173390,
 11471,
 -1,
 249283448,
 11477,
 -61730,
 249272655,
 11469,
 -1,
 249382209,
 11475,
 249564898,
 249215652,
 -1,
 -61727,
 249521870,
 11483,
 -1,
 249578817,
 11461,
 -61725,
 249534314,
 11455,
 -61724,
 249713637,
 11479,
 -61723,
 249776803,
 11463,
 -61722,
 249838261,
 11481,
 -1,
 249895321,
 11445,
 250150911,
 249139325,
 -1,
 250154731,
 250054978,
 -1,
 -61718,
 250144322,
 11489,
 -1,
 250172876,
 11487,
 -61716,
 250142416,
 11491,
 -1,
 250330031,
 11485,
 -1,
 249076659,
 11441,
 250547958,
 248985132,
 -1,
 250613492,
 250503830,
 -1,
 -61711,
 250580182,
 11451,
 -61710,
 250638707,
 11449,
 -61709,
 250699568,
 11467,
 -1,
 250747606,
 11443,
 -61707,
 250561857,
 1007,
 -1,
 250878660,
 11399,
 251072253,
 250525616,
 -1,
 251137786,
 251025651,
 -1,
 -61703,
 251094734,
 1005,
 -1,
 251151681,
 995,
 -61701,
 251108275,
 11403,
 -61700,
 251291342,
 11429,
 -1,
 251338069,
 11457,
 251531012,
 251016156,
 -1,
 251596547,
 251520863,
 -1,
 -61696,
 251575172,
 11500,
 -61695,
 251628758,
 11453,
 -61694,
 251679717,
 11502,
 -1,
 251741523,
 11447,
 -1,
 251566765,
 11459,
 251989770,
 251490550,
 -1,
 252055304,
 251943155,
 -1,
 -61689,
 252010983,
 11437,
 -1,
 252069185,
 999,
 -61687,
 252034157,
 11421,
 -1,
 252190684,
 11413,
 252382989,
 251970424,
 -1,
 -61684,
 252337360,
 11409,
 -1,
 252388788,
 11431,
 252579600,
 252354667,
 -1,
 -61681,
 252558445,
 11439,
 -1,
 252600807,
 11425,
 252776211,
 252539844,
 -1,
 -61678,
 252716504,
 11415,
 -1,
 252776789,
 11473,
 252972822,
 252729587,
 -1,
 -61675,
 252942671,
 1001,
 -1,
 252978370,
 11407,
 253169433,
 252924767,
 -1,
 -61672,
 253135965,
 1003,
 -1,
 253199962,
 11397,
 253366044,
 253120158,
 -1,
 -61669,
 253321703,
 11435,
 -1,
 253379905,
 997,
 253562655,
 253302158,
 -1,
 -61666,
 253524654,
 11393,
 -1,
 253588141,
 11465,
 -61664,
 253552703,
 11405,
 -61663,
 253746261,
 11395,
 -61662,
 253808482,
 11433,
 -61661,
 253867109,
 11427,
 -61660,
 253922518,
 11419,
 -61659,
 253986036,
 11417,
 -61658,
 254042934,
 11411,
 -1,
 254100819,
 11401,
 254345215,
 248964816,
 -1,
 254349099,
 254261168,
 -1,
 -61654,
 254330107,
 11495,
 -1,
 254369249,
 11498,
 254545710,
 254308598,
 -1,
 -61651,
 254500084,
 11497,
 -1,
 254548295,
 11492,
 -61649,
 254526708,
 11496,
 -61648,
 254714891,
 11494,
 -1,
 254772475,
 11493,
 254939016,
 248851715,
 -1,
 255004547,
 254877707,
 -1,
 255070026,
 254972402,
 11422,
 255135561,
 255030949,
 -1,
 255201091,
 255079281,
 -1,
 255266619,
 255154419,
 -1,
 255332153,
 255202702,
 11470,
 -1,
 255312760,
 11476,
 -61638,
 255301967,
 11468,
 -1,
 255411521,
 11474,
 255594302,
 255244964,
 -1,
 -61635,
 255551182,
 11482,
 -1,
 255608129,
 11460,
 -61633,
 255563626,
 11454,
 -61632,
 255742949,
 11478,
 -61631,
 255806115,
 11462,
 -61630,
 255867573,
 11480,
 -1,
 255924633,
 11444,
 256180223,
 255168637,
 -1,
 256184135,
 256084290,
 -1,
 -61626,
 256173634,
 11488,
 -1,
 256202188,
 11486,
 -61624,
 256171728,
 11490,
 -1,
 256359343,
 11484,
 -1,
 255105971,
 11440,
 256577362,
 255014444,
 -1,
 256642896,
 256533142,
 -1,
 -61619,
 256609494,
 11450,
 -61618,
 256668019,
 11448,
 -61617,
 256728880,
 11466,
 -1,
 256776918,
 11442,
 -61615,
 256591169,
 1006,
 -1,
 256907972,
 11398,
 257101657,
 256554928,
 -1,
 257167190,
 257054963,
 -1,
 -61611,
 257124046,
 1004,
 -1,
 257180993,
 994,
 -61609,
 257137587,
 11402,
 -61608,
 257320654,
 11428,
 -1,
 257367381,
 11456,
 257560416,
 257045468,
 -1,
 257625951,
 257550175,
 -1,
 -61604,
 257604484,
 11499,
 -61603,
 257658070,
 11452,
 -61602,
 257709029,
 11501,
 -1,
 257770835,
 11446,
 -1,
 257596077,
 11458,
 258019174,
 257519862,
 -1,
 258084708,
 257972467,
 -1,
 -61597,
 258040295,
 11436,
 -1,
 258098497,
 998,
 -61595,
 258063469,
 11420,
 -1,
 258219996,
 11412,
 258412393,
 257999736,
 -1,
 -61592,
 258366672,
 11408,
 -1,
 258418100,
 11430,
 258609004,
 258383979,
 -1,
 -61589,
 258587757,
 11438,
 -1,
 258630119,
 11424,
 258805615,
 258569156,
 -1,
 -61586,
 258745816,
 11414,
 -1,
 258806101,
 11472,
 259002226,
 258758899,
 -1,
 -61583,
 258971983,
 1000,
 -1,
 259007682,
 11406,
 259198837,
 258954079,
 -1,
 -61580,
 259165277,
 1002,
 -1,
 259229274,
 11396,
 259395448,
 259149470,
 -1,
 -61577,
 259351015,
 11434,
 -1,
 259409217,
 996,
 259592059,
 259331470,
 -1,
 -61574,
 259553966,
 11392,
 -1,
 259617453,
 11464,
 -61572,
 259582015,
 11404,
 -61571,
 259775573,
 11394,
 -61570,
 259837794,
 11432,
 -61569,
 259896421,
 11426,
 -61568,
 259951830,
 11418,
 -61567,
 260015348,
 11416,
 -61566,
 260072246,
 11410,
 -1,
 260130131,
 11400,
 260374527,
 254973247,
 -1,
 260378503,
 260292562,
 -1,
 -61562,
 260340084,
 11505,
 -1,
 260383752,
 11504,
 -1,
 260345049,
 11503,
 260640653,
 254907547,
 -1,
 -61558,
 260627139,
 11516,
 -61557,
 260663448,
 11515,
 -61556,
 260723466,
 11513,
 -1,
 260782635,
 11514,
 260968336,
 260591262,
 -1,
 -61553,
 260952510,
 11518,
 -1,
 261007973,
 11517,
 -1,
 260933500,
 11519,
 -1,
 248833934,
 169,
 261296049,
 248763277,
 -1,
 261361582,
 261253439,
 -1,
 261427105,
 261346122,
 -1,
 261492632,
 261407608,
 -1,
 -61545,
 261481057,
 119649,
 -1,
 261513406,
 119650,
 261689243,
 261470128,
 -1,
 -61542,
 261648220,
 119653,
 -1,
 261704879,
 119654,
 261885854,
 261639838,
 -1,
 -61539,
 261856370,
 119651,
 -1,
 261910245,
 119652,
 -61537,
 261854754,
 119648,
 -61536,
 262049055,
 119656,
 -1,
 262096215,
 119655,
 262340607,
 261408256,
 -1,
 262344613,
 262259576,
 -1,
 -61532,
 262333025,
 119658,
 -1,
 262365374,
 119659,
 262541224,
 262322096,
 -1,
 -61529,
 262500188,
 119662,
 -1,
 262556847,
 119663,
 262737835,
 262491806,
 -1,
 -61526,
 262708338,
 119660,
 -1,
 262762213,
 119661,
 -61524,
 262706722,
 119657,
 -61523,
 262901023,
 119665,
 -1,
 262948183,
 119664,
 263192575,
 261310847,
 -1,
 -61520,
 263110044,
 9013,
 -1,
 263138033,
 9012,
 263327681,
 261261634,
 -1,
 263393214,
 263308152,
 -1,
 263458748,
 263330205,
 -1,
 263524280,
 263446596,
 -1,
 -61514,
 263510837,
 8955,
 -61513,
 263561004,
 8957,
 -1,
 263617961,
 8954,
 263847935,
 263463749,
 -1,
 263851963,
 263753316,
 8883,
 -1,
 263784156,
 8885,
 -1,
 263816279,
 8715,
 -61507,
 263429298,
 8750,
 -1,
 264006393,
 9089,
 -61505,
 263352557,
 9740,
 -61504,
 264135512,
 9010,
 -1,
 264198245,
 10861,
 264376261,
 263290229,
 58,
 264503295,
 264306688,
 -1,
 -61500,
 264420540,
 8353,
 -1,
 264456556,
 8788,
 -61498,
 264353294,
 8792,
 -1,
 264589372,
 9904,
 264770014,
 223405248,
 -1,
 264835481,
 264745508,
 -1,
 264900782,
 264814239,
 -1,
 264966314,
 264850528,
 -1,
 265031647,
 264913063,
 1101,
 265097170,
 264997186,
 1085,
 265224191,
 265030710,
 -1,
 -61489,
 265143335,
 1226,
 -61488,
 265192782,
 1315,
 -61487,
 265248520,
 1224,
 -1,
 265304090,
 1187,
 265490391,
 265057220,
 1083,
 265617407,
 265423926,
 -1,
 -61483,
 265536551,
 1222,
 -61482,
 265585998,
 1313,
 -1,
 265641736,
 1299,
 265818073,
 265467824,
 1089,
 -1,
 265751786,
 1195,
 265949147,
 265791958,
 1088,
 -1,
 265883288,
 1167,
 266080221,
 265912392,
 1084,
 -1,
 266014335,
 1230,
 -61474,
 266030750,
 1092,
 -1,
 266145018,
 1261,
 266342389,
 264990966,
 -1,
 266407916,
 266310130,
 -1,
 266473451,
 266372343,
 -1,
 266538982,
 266417708,
 -1,
 -61468,
 266529051,
 1287,
 -61467,
 266563515,
 1283,
 -1,
 266616999,
 1281,
 -61465,
 266529051,
 1285,
 -61464,
 266783156,
 1295,
 -61463,
 266845671,
 1293,
 -61462,
 266898875,
 1291,
 -1,
 266959967,
 1289,
 -1,
 266446339,
 1153,
 267194354,
 266343822,
 1082,
 267321343,
 267127862,
 -1,
 -61457,
 267246569,
 1181,
 -61456,
 267305373,
 1183,
 -61455,
 267345672,
 1220,
 -1,
 267401242,
 1179,
 -61453,
 267172973,
 1135,
 -61452,
 267546555,
 1116,
 -1,
 267606483,
 1228,
 267784202,
 266297831,
 1080,
 267849728,
 267751922,
 1105,
 267976703,
 267830136,
 -1,
 267980799,
 267871420,
 -1,
 -61446,
 267969888,
 42579,
 -61445,
 268008512,
 1129,
 -61444,
 268058791,
 1125,
 -61443,
 268120522,
 42589,
 -61442,
 268183933,
 1133,
 -1,
 268244366,
 42583,
 -1,
 267916686,
 42567,
 268505092,
 267796647,
 1077,
 268632063,
 268438582,
 -1,
 -61437,
 268523309,
 1104,
 -1,
 268577774,
 1239,
 268767240,
 268438582,
 -1,
 -61434,
 268730526,
 1251,
 -61433,
 268785453,
 1117,
 -1,
 268843178,
 1253,
 269090815,
 268757187,
 1141,
 -1,
 268963147,
 1143,
 269160479,
 267761584,
 -1,
 269226004,
 269113587,
 -1,
 269291536,
 269195792,
 -1,
 269357071,
 269246951,
 1081,
 -1,
 269291135,
 1163,
 -1,
 269340398,
 1118,
 -61423,
 269279012,
 42647,
 -61422,
 269506833,
 1211,
 -61421,
 269561678,
 1097,
 -1,
 269620622,
 1096,
 269815834,
 269194115,
 -1,
 269881368,
 269762727,
 -1,
 -61417,
 269844552,
 42599,
 -1,
 269906884,
 42597,
 -61415,
 269860028,
 1100,
 -1,
 270022486,
 42595,
 270209052,
 269798213,
 1199,
 -1,
 270143090,
 1201,
 270340126,
 270151742,
 1241,
 -1,
 270273786,
 1243,
 -1,
 270288589,
 1165,
 270536747,
 269104684,
 -1,
 270602278,
 270526456,
 -1,
 270667811,
 270549159,
 1109,
 -1,
 270630188,
 42563,
 -61404,
 270657615,
 42633,
 -61403,
 270786340,
 42627,
 -1,
 270818192,
 1119,
 270995496,
 270561211,
 1106,
 -1,
 270972792,
 42569,
 -61399,
 270982948,
 42625,
 -61398,
 271096817,
 42605,
 -1,
 271138983,
 1076,
 271323193,
 270526456,
 -1,
 271388724,
 271276275,
 -1,
 271454259,
 271335591,
 1078,
 271581183,
 271387702,
 -1,
 271585330,
 271463980,
 -1,
 -61391,
 271540849,
 1245,
 -1,
 271600274,
 1175,
 -1,
 271526894,
 1218,
 -1,
 271441700,
 42629,
 271974399,
 271335591,
 1079,
 271978552,
 271846601,
 -1,
 -61385,
 271934065,
 1247,
 -1,
 271993490,
 1177,
 -1,
 271943250,
 42561,
 272240708,
 271312064,
 -1,
 272306238,
 272190072,
 1099,
 272433151,
 272239670,
 -1,
 -61379,
 272316586,
 1273,
 -1,
 272377562,
 42577,
 272568385,
 272242062,
 1103,
 -61376,
 272548728,
 1123,
 -1,
 272580775,
 1305,
 -61374,
 272551662,
 1102,
 -61373,
 272730434,
 42591,
 -1,
 272785895,
 1111,
 272961616,
 272221048,
 -1,
 273027146,
 272938928,
 -1,
 -61369,
 273014564,
 42639,
 -61368,
 273070377,
 42641,
 -61367,
 273111952,
 1115,
 -1,
 273170599,
 1094,
 273354830,
 272973991,
 1090,
 273481727,
 273288246,
 -1,
 -61363,
 273384782,
 42635,
 -1,
 273430554,
 1197,
 -61361,
 273342244,
 42637,
 -1,
 273559441,
 42643,
 273748060,
 272901787,
 -1,
 273813589,
 273683854,
 -1,
 273879124,
 273790471,
 1257,
 -1,
 273812730,
 1259,
 -1,
 273857477,
 1185,
 274075736,
 273768935,
 -1,
 -61353,
 274042375,
 42603,
 -1,
 274092877,
 1131,
 -61351,
 274064873,
 1110,
 -61350,
 274248813,
 42573,
 -61349,
 274299229,
 42587,
 -1,
 274350247,
 1073,
 274534502,
 273683854,
 1072,
 274600034,
 274475533,
 -1,
 274665568,
 274542481,
 1213,
 -1,
 274599146,
 1215,
 -61343,
 274618641,
 1193,
 -1,
 274743459,
 1249,
 274927717,
 274533430,
 -1,
 -61340,
 274872490,
 1235,
 -1,
 274934766,
 1233,
 -1,
 274889328,
 1311,
 275189871,
 274486059,
 -1,
 275255406,
 275143568,
 1075,
 275382271,
 275188790,
 -1,
 275386475,
 275300765,
 1171,
 -1,
 275316970,
 1275,
 -61332,
 275371437,
 1169,
 -61331,
 275481934,
 1173,
 -1,
 275527706,
 1271,
 -1,
 275214267,
 1107,
 275779703,
 275173102,
 1091,
 275845237,
 275713078,
 -1,
 275910772,
 275789356,
 -1,
 -61325,
 275880893,
 1267,
 -1,
 275931761,
 1265,
 -1,
 275873950,
 1263,
 276234239,
 275804406,
 1145,
 -1,
 276146888,
 1108,
 276303999,
 275732723,
 -1,
 276369534,
 276239758,
 1093,
 276435069,
 276302902,
 -1,
 -61317,
 276414877,
 1279,
 -61316,
 276455176,
 1277,
 -1,
 276510746,
 1203,
 -1,
 276409303,
 1098,
 -1,
 276356900,
 42645,
 276828296,
 276245763,
 -1,
 276893830,
 276781968,
 1095,
 277020671,
 276827190,
 -1,
 277024901,
 276903468,
 -1,
 -61308,
 276980337,
 1269,
 -1,
 277039762,
 1207,
 -1,
 277011433,
 1209,
 -61305,
 276856370,
 42585,
 -1,
 277229457,
 42631,
 277418127,
 276802006,
 -1,
 277483661,
 277368095,
 -1,
 -61301,
 277473359,
 1297,
 -61300,
 277538737,
 42581,
 -1,
 277561507,
 42565,
 -61298,
 277453837,
 1147,
 -1,
 277698833,
 1303,
 277876886,
 277389419,
 -1,
 277942420,
 277823655,
 1087,
 278069247,
 277875766,
 -1,
 -61293,
 277972302,
 1191,
 -1,
 278018074,
 1317,
 -61291,
 277920877,
 1137,
 -1,
 278142038,
 1231,
 278335643,
 277844466,
 1086,
 278401177,
 278299692,
 1121,
 -1,
 278335157,
 1149,
 -61286,
 278381432,
 1151,
 -1,
 278465786,
 1255,
 278663327,
 278295492,
 -1,
 -61283,
 278622139,
 1113,
 -61282,
 278687420,
 1127,
 -1,
 278747409,
 1301,
 278925474,
 278628674,
 -1,
 -61279,
 278884283,
 1114,
 -1,
 278940813,
 42575,
 279122085,
 278890269,
 -1,
 -61276,
 279074596,
 42571,
 -1,
 279131536,
 42601,
 -61274,
 279109412,
 1309,
 -61273,
 279304626,
 1074,
 -61272,
 279357388,
 1307,
 -61271,
 279408571,
 1112,
 -1,
 279466231,
 1139,
 279707647,
 264922375,
 -1,
 -61268,
 279627055,
 1205,
 -61267,
 279660328,
 1189,
 -1,
 279713186,
 1237,
 279908754,
 264842783,
 -1,
 279974286,
 279858272,
 -1,
 280039620,
 279920807,
 1069,
 280105143,
 280004930,
 1053,
 280231935,
 280038454,
 -1,
 -61260,
 280151079,
 1225,
 -61259,
 280200526,
 1314,
 -61258,
 280256264,
 1223,
 -1,
 280311834,
 1186,
 280498364,
 280064964,
 1051,
 280625151,
 280431670,
 -1,
 -61254,
 280544295,
 1221,
 -61253,
 280593742,
 1312,
 -1,
 280649480,
 1298,
 280826046,
 280475568,
 1057,
 -1,
 280759530,
 1194,
 280957120,
 280799702,
 1056,
 -1,
 280891032,
 1166,
 281088194,
 280920136,
 1052,
 -1,
 281022079,
 1229,
 -61245,
 281038494,
 1060,
 -1,
 281152762,
 1260,
 281350362,
 279998710,
 -1,
 281415889,
 281317874,
 -1,
 281481424,
 281380087,
 -1,
 281546955,
 281425452,
 -1,
 -61239,
 281536795,
 1286,
 -61238,
 281571259,
 1282,
 -1,
 281624743,
 1280,
 -61236,
 281536795,
 1284,
 -61235,
 281790900,
 1294,
 -61234,
 281853415,
 1292,
 -61233,
 281906619,
 1290,
 -1,
 281967711,
 1288,
 -1,
 281454083,
 1152,
 282202327,
 281351566,
 1050,
 282329087,
 282135606,
 -1,
 -61228,
 282254313,
 1180,
 -61227,
 282313117,
 1182,
 -61226,
 282353416,
 1219,
 -1,
 282408986,
 1178,
 -61224,
 282180717,
 1134,
 -61223,
 282554299,
 1036,
 -1,
 282614227,
 1227,
 282792175,
 281305575,
 1048,
 282857701,
 282759666,
 1025,
 282984447,
 282837880,
 -1,
 282988772,
 282879164,
 -1,
 -61217,
 282977632,
 42578,
 -61216,
 283016256,
 1128,
 -61215,
 283066535,
 1124,
 -61214,
 283128266,
 42588,
 -61213,
 283191677,
 1132,
 -1,
 283252110,
 42582,
 -1,
 282924430,
 42566,
 283513065,
 282804391,
 1045,
 283639807,
 283446326,
 -1,
 -61208,
 283531053,
 1024,
 -1,
 283585518,
 1238,
 283775213,
 283446326,
 -1,
 -61205,
 283738270,
 1250,
 -61204,
 283793197,
 1037,
 -1,
 283850922,
 1252,
 284098559,
 283764931,
 1140,
 -1,
 283970891,
 1142,
 284168452,
 282769328,
 -1,
 284233977,
 284121331,
 -1,
 284299509,
 284203536,
 -1,
 284365044,
 284254695,
 1049,
 -1,
 284298879,
 1162,
 -1,
 284348142,
 1038,
 -61194,
 284286756,
 42646,
 -61193,
 284514577,
 1210,
 -61192,
 284569422,
 1065,
 -1,
 284628366,
 1064,
 284823807,
 284201859,
 -1,
 284889341,
 284770471,
 -1,
 -61188,
 284852296,
 42598,
 -1,
 284914628,
 42596,
 -61186,
 284867772,
 1068,
 -1,
 285030230,
 42594,
 285217025,
 284805957,
 1198,
 -1,
 285150834,
 1200,
 285348099,
 285159486,
 1240,
 -1,
 285281530,
 1242,
 -1,
 285296333,
 1164,
 285544720,
 284112428,
 -1,
 285610251,
 285534200,
 -1,
 285675784,
 285556903,
 1029,
 -1,
 285637932,
 42562,
 -61175,
 285665359,
 42632,
 -61174,
 285794084,
 42626,
 -1,
 285825936,
 1039,
 286003469,
 285568955,
 1026,
 -1,
 285980536,
 42568,
 -61170,
 285990692,
 42624,
 -61169,
 286104561,
 42604,
 -1,
 286146727,
 1044,
 286331166,
 285534200,
 -1,
 286396697,
 286284019,
 -1,
 286462232,
 286343335,
 1046,
 286588927,
 286395446,
 -1,
 286593303,
 286471724,
 -1,
 -61162,
 286548593,
 1244,
 -1,
 286608018,
 1174,
 -1,
 286534638,
 1217,
 -1,
 286449444,
 42628,
 286982143,
 286343335,
 1047,
 286986525,
 286854345,
 -1,
 -61156,
 286941809,
 1246,
 -1,
 287001234,
 1176,
 -1,
 286950994,
 42560,
 287248681,
 286319808,
 -1,
 287314211,
 287197816,
 1067,
 287440895,
 287247414,
 -1,
 -61150,
 287324330,
 1272,
 -1,
 287385306,
 42576,
 287576358,
 287249806,
 1071,
 -61147,
 287556472,
 1122,
 -1,
 287588519,
 1304,
 -61145,
 287559406,
 1070,
 -61144,
 287738178,
 42590,
 -1,
 287793639,
 1031,
 287969589,
 287228792,
 -1,
 288035119,
 287946672,
 -1,
 -61140,
 288022308,
 42638,
 -61139,
 288078121,
 42640,
 -61138,
 288119696,
 1035,
 -1,
 288178343,
 1062,
 288362803,
 287981735,
 1058,
 288489471,
 288295990,
 -1,
 -61134,
 288392526,
 42634,
 -1,
 288438298,
 1196,
 -61132,
 288349988,
 42636,
 -1,
 288567185,
 42642,
 288756033,
 287909531,
 -1,
 288821562,
 288691598,
 -1,
 288887097,
 288798215,
 1256,
 -1,
 288820474,
 1258,
 -1,
 288865221,
 1184,
 289083709,
 288776679,
 -1,
 -61124,
 289050119,
 42602,
 -1,
 289100621,
 1130,
 -61122,
 289072617,
 1030,
 -61121,
 289256557,
 42572,
 -61120,
 289306973,
 42586,
 -1,
 289357991,
 1041,
 289542475,
 288691598,
 1040,
 289608007,
 289483277,
 -1,
 289673541,
 289550225,
 1212,
 -1,
 289606890,
 1214,
 -61114,
 289626385,
 1192,
 -1,
 289751203,
 1248,
 289935690,
 289541174,
 -1,
 -61111,
 289880234,
 1234,
 -1,
 289942510,
 1232,
 -1,
 289897072,
 1310,
 290197844,
 289493803,
 -1,
 290263379,
 290151312,
 1043,
 290390015,
 290196534,
 -1,
 290394448,
 290308509,
 1170,
 -1,
 290324714,
 1274,
 -61103,
 290379181,
 1168,
 -61102,
 290489678,
 1172,
 -1,
 290535450,
 1270,
 -1,
 290222011,
 1027,
 290787676,
 290180846,
 1059,
 290853210,
 290720822,
 -1,
 290918745,
 290797100,
 -1,
 -61096,
 290888637,
 1266,
 -1,
 290939505,
 1264,
 -1,
 290881694,
 1262,
 291241983,
 290812150,
 1144,
 -1,
 291154632,
 1028,
 291311972,
 290740467,
 -1,
 291377507,
 291247502,
 1061,
 291443042,
 291310646,
 -1,
 -61088,
 291422621,
 1278,
 -61087,
 291462920,
 1276,
 -1,
 291518490,
 1202,
 -1,
 291417047,
 1066,
 -1,
 291364644,
 42644,
 291836269,
 291253507,
 -1,
 291901803,
 291789712,
 1063,
 292028415,
 291834934,
 -1,
 292032874,
 291911212,
 -1,
 -61079,
 291988081,
 1268,
 -1,
 292047506,
 1206,
 -1,
 292019177,
 1208,
 -61076,
 291864114,
 42584,
 -1,
 292237201,
 42630,
 292426100,
 291809750,
 -1,
 292491634,
 292375839,
 -1,
 -61072,
 292481103,
 1296,
 -61071,
 292546481,
 42580,
 -1,
 292569251,
 42564,
 -61069,
 292461581,
 1146,
 -1,
 292706577,
 1302,
 292884857,
 292393458,
 1054,
 292950391,
 292848684,
 1120,
 -1,
 292884149,
 1148,
 -61064,
 292930424,
 1150,
 -1,
 293014778,
 1254,
 293212543,
 292855915,
 -1,
 293278078,
 293159079,
 1055,
 293404671,
 293211190,
 -1,
 -61059,
 293307726,
 1190,
 -1,
 293353498,
 1316,
 -1,
 293256301,
 1136,
 293605763,
 293172164,
 -1,
 -61055,
 293564347,
 1033,
 -61054,
 293629628,
 1126,
 -1,
 293689617,
 1300,
 293867910,
 293570882,
 -1,
 -61051,
 293826491,
 1034,
 -1,
 293883021,
 42574,
 294064521,
 293832477,
 -1,
 -61048,
 294016804,
 42570,
 -1,
 294073744,
 42600,
 -61046,
 294051620,
 1308,
 -61045,
 294246834,
 1042,
 -61044,
 294299596,
 1306,
 -61043,
 294350779,
 1032,
 -1,
 294408439,
 1138,
 294649855,
 279930119,
 -1,
 -61040,
 294569263,
 1204,
 -61039,
 294602536,
 1188,
 -1,
 294655394,
 1236,
 294850966,
 279870018,
 -1,
 -61036,
 294829678,
 7467,
 -61035,
 294887734,
 1216,
 -1,
 294946874,
 42606,
 -61033,
 294832084,
 1154,
 -61032,
 295084577,
 42623,
 -1,
 295137778,
 42622,
 295309789,
 264808191,
 -1,
 295375264,
 295289720,
 -1,
 -61028,
 295358190,
 67633,
 -61027,
 295408114,
 67632,
 -61026,
 295461351,
 67631,
 -61025,
 295518375,
 67630,
 -1,
 295572878,
 67629,
 295768486,
 295352240,
 -1,
 -61022,
 295751406,
 67628,
 -61021,
 295801330,
 67627,
 -61020,
 295854567,
 67626,
 -61019,
 295911591,
 67625,
 -1,
 295966094,
 67624,
 296161708,
 295741910,
 -1,
 -61016,
 296144622,
 67623,
 -61015,
 296194546,
 67622,
 -61014,
 296247783,
 67621,
 -61013,
 296304807,
 67620,
 -1,
 296359310,
 67619,
 296554930,
 296132715,
 -1,
 -61010,
 296537838,
 67618,
 -61009,
 296587762,
 67617,
 -61008,
 296640999,
 67616,
 -61007,
 296698023,
 67615,
 -1,
 296752526,
 67614,
 296948152,
 296520002,
 -1,
 -61004,
 296931054,
 67613,
 -61003,
 296980978,
 67612,
 -61002,
 297034215,
 67611,
 -61001,
 297091239,
 67610,
 -1,
 297145742,
 67609,
 297341374,
 296910920,
 -1,
 -60998,
 297324270,
 67608,
 -60997,
 297374194,
 67607,
 -60996,
 297427431,
 67606,
 -60995,
 297484455,
 67605,
 -1,
 297538958,
 67604,
 297734596,
 297300932,
 -1,
 -60992,
 297717486,
 67603,
 -60991,
 297767410,
 67602,
 -60990,
 297820647,
 67601,
 -60989,
 297877671,
 67600,
 -1,
 297932174,
 67599,
 298127818,
 297693430,
 -1,
 -60986,
 298110702,
 67598,
 -60985,
 298160626,
 67597,
 -60984,
 298213863,
 67596,
 -60983,
 298270887,
 67595,
 -1,
 298325390,
 67594,
 298521039,
 298114522,
 -1,
 -60980,
 298488306,
 67637,
 -60979,
 298541543,
 67636,
 -60978,
 298598567,
 67635,
 -1,
 298653070,
 67634,
 298848722,
 298510328,
 -1,
 -60975,
 298815986,
 67647,
 -1,
 298849678,
 67644,
 299045333,
 298836950,
 -1,
 -60972,
 298991783,
 67640,
 -1,
 299046286,
 67639,
 299241944,
 299003799,
 -1,
 -60969,
 299209202,
 67592,
 -1,
 299242894,
 67589,
 -60967,
 299224814,
 67588,
 -60966,
 299405810,
 67587,
 -60965,
 299459047,
 67586,
 -60964,
 299516071,
 67585,
 -1,
 299570574,
 67584,
 -1,
 295271242,
 9005,
 299832160,
 264727686,
 -1,
 299897693,
 299792062,
 -1,
 299963212,
 299841070,
 -1,
 300028465,
 299917799,
 -1,
 300093998,
 299972606,
 -1,
 300159474,
 300070832,
 -1,
 300225000,
 300142318,
 -1,
 -60954,
 300196777,
 12972,
 -60953,
 300255554,
 12944,
 -1,
 300314119,
 12956,
 300487147,
 300204920,
 -1,
 -60950,
 300470446,
 12971,
 -1,
 300520152,
 12945,
 300683758,
 300433575,
 -1,
 -60947,
 300669505,
 12934,
 -1,
 300692474,
 12953,
 -60945,
 300655168,
 12949,
 -60944,
 300847825,
 12947,
 -60943,
 300904284,
 12933,
 -1,
 300953591,
 12870,
 301142521,
 300109470,
 -1,
 301208055,
 301097447,
 -1,
 -60939,
 301193650,
 12932,
 -60938,
 301247494,
 12939,
 -1,
 301304305,
 12950,
 -60936,
 301177970,
 12931,
 -1,
 301418093,
 12955,
 301601280,
 301115862,
 -1,
 301666815,
 301547687,
 -1,
 301732350,
 301643696,
 -1,
 -60931,
 301712248,
 12961,
 -1,
 301767921,
 12974,
 -1,
 301693745,
 12970,
 -1,
 301622603,
 12968,
 302060038,
 301563976,
 -1,
 302125572,
 302006439,
 -1,
 -60925,
 302105679,
 12942,
 -1,
 302135663,
 12969,
 -60923,
 302094123,
 12938,
 -1,
 302258889,
 12954,
 302453259,
 302006439,
 -1,
 -60920,
 302441487,
 12957,
 -60919,
 302485482,
 12973,
 -60918,
 302540107,
 12935,
 -1,
 302588657,
 12943,
 302780945,
 302394627,
 -1,
 302846480,
 302748146,
 -1,
 -60914,
 302822905,
 12963,
 -60913,
 302884803,
 12962,
 -1,
 302943393,
 12951,
 -1,
 302794832,
 12965,
 303174165,
 302760824,
 -1,
 -60909,
 303161953,
 12929,
 -60908,
 303194302,
 12930,
 -1,
 303253265,
 12937,
 303436314,
 303139138,
 -1,
 303501849,
 303391207,
 -1,
 -60904,
 303467366,
 12936,
 -1,
 303519033,
 12976,
 -1,
 303439080,
 12948,
 303763998,
 303395780,
 -1,
 -60900,
 303734639,
 12966,
 -60899,
 303776698,
 12967,
 -1,
 303830666,
 12952,
 304026145,
 303750618,
 -1,
 -60896,
 303994652,
 12941,
 -1,
 304030927,
 12940,
 304222756,
 303984886,
 -1,
 -60893,
 304192401,
 12871,
 -1,
 304244850,
 12869,
 304419367,
 304175347,
 -1,
 -60890,
 304375096,
 12964,
 -1,
 304424458,
 12946,
 304615978,
 304354702,
 -1,
 -60887,
 304598256,
 12959,
 -1,
 304643302,
 12975,
 -60885,
 304589111,
 12868,
 -60884,
 304785145,
 12958,
 -60883,
 304846370,
 12928,
 -1,
 304901678,
 12960,
 305135615,
 300074101,
 -1,
 -60880,
 305048022,
 127276,
 -1,
 305081603,
 127275,
 305271402,
 299987908,
 -1,
 305336937,
 305210688,
 -1,
 305402446,
 305315495,
 -1,
 -60875,
 305391608,
 9449,
 -60874,
 305456320,
 9448,
 -60873,
 305521622,
 9447,
 -60872,
 305585626,
 9446,
 -60871,
 305649766,
 9445,
 -60870,
 305712878,
 9444,
 -60869,
 305775480,
 9443,
 -60868,
 305838000,
 9442,
 -60867,
 305899990,
 9441,
 -60866,
 305964998,
 9440,
 -60865,
 306028651,
 9439,
 -60864,
 306090482,
 9438,
 -60863,
 306153794,
 9437,
 -60862,
 306217032,
 9436,
 -60861,
 306279364,
 9435,
 -60860,
 306344182,
 9434,
 -60859,
 306409367,
 9433,
 -60858,
 306471399,
 9432,
 -60857,
 306534643,
 9431,
 -60856,
 306598699,
 9430,
 -60855,
 306663070,
 9429,
 -60854,
 306725031,
 9428,
 -60853,
 306787884,
 9427,
 -60852,
 306851075,
 9426,
 -60851,
 306914971,
 9425,
 -1,
 306976142,
 9424,
 307232767,
 305344041,
 -1,
 -60848,
 307161080,
 9423,
 -60847,
 307225792,
 9422,
 -60846,
 307291094,
 9421,
 -60845,
 307355098,
 9420,
 -60844,
 307419238,
 9419,
 -60843,
 307482350,
 9418,
 -60842,
 307544952,
 9417,
 -60841,
 307607472,
 9416,
 -60840,
 307669462,
 9415,
 -60839,
 307734470,
 9414,
 -60838,
 307798123,
 9413,
 -60837,
 307859954,
 9412,
 -60836,
 307923266,
 9411,
 -60835,
 307986504,
 9410,
 -60834,
 308048836,
 9409,
 -60833,
 308113654,
 9408,
 -60832,
 308178839,
 9407,
 -60831,
 308240871,
 9406,
 -60830,
 308304115,
 9405,
 -60829,
 308368171,
 9404,
 -60828,
 308432542,
 9403,
 -60827,
 308494503,
 9402,
 -60826,
 308557356,
 9401,
 -60825,
 308620547,
 9400,
 -60824,
 308684443,
 9399,
 -1,
 308745614,
 9398,
 -1,
 305285910,
 10688,
 309007030,
 305238178,
 -1,
 309072530,
 308986744,
 -1,
 309138046,
 309059364,
 -1,
 309203581,
 309104744,
 9331,
 309329919,
 309133312,
 -1,
 309334642,
 309248888,
 -1,
 -60815,
 309322337,
 12882,
 -1,
 309354686,
 12883,
 309531253,
 309311408,
 -1,
 -60812,
 309489500,
 12886,
 -1,
 309546159,
 12887,
 309727864,
 309499280,
 -1,
 -60809,
 309674151,
 12881,
 -1,
 309723735,
 12873,
 309924475,
 309677726,
 -1,
 -60806,
 309894258,
 12884,
 -1,
 309948133,
 12885,
 -60804,
 309890335,
 12889,
 -1,
 310068567,
 12888,
 -1,
 309166065,
 9323,
 310317712,
 309091860,
 -1,
 310383247,
 310305984,
 12890,
 310509567,
 310312960,
 -1,
 310514308,
 310428536,
 -1,
 -60797,
 310501985,
 12892,
 -1,
 310534334,
 12893,
 310710919,
 310491056,
 -1,
 -60794,
 310669148,
 12977,
 -1,
 310725807,
 12978,
 310907530,
 310678928,
 -1,
 -60791,
 310853799,
 12891,
 -1,
 310903383,
 12874,
 311104141,
 310857374,
 -1,
 -60788,
 311073906,
 12894,
 -1,
 311127781,
 12895,
 -60786,
 311069983,
 12980,
 -1,
 311248215,
 12979,
 -1,
 310330220,
 9324,
 311558143,
 310265617,
 9321,
 -1,
 311428706,
 12872,
 311628457,
 309022366,
 -1,
 311693989,
 311595506,
 -1,
 311759524,
 311670519,
 12981,
 311885823,
 311689216,
 -1,
 311890585,
 311804792,
 -1,
 -60776,
 311878241,
 12983,
 -1,
 311910590,
 12984,
 312087196,
 311867312,
 -1,
 -60773,
 312045404,
 12987,
 -1,
 312102063,
 12988,
 312283807,
 312055184,
 -1,
 -60770,
 312230055,
 12982,
 -1,
 312279639,
 12875,
 312480418,
 312233630,
 -1,
 -60767,
 312450162,
 12985,
 -1,
 312504037,
 12986,
 -60765,
 312446239,
 12990,
 -1,
 312624471,
 12989,
 -1,
 311744259,
 9325,
 312934399,
 311649489,
 -1,
 312939176,
 312861888,
 12991,
 -1,
 312870498,
 12876,
 -1,
 312886124,
 9326,
 313135792,
 311605168,
 -1,
 313201325,
 313093994,
 -1,
 -60756,
 313189581,
 12877,
 -1,
 313213804,
 9327,
 313458687,
 313150679,
 -1,
 -60753,
 313386189,
 12878,
 -1,
 313410412,
 9328,
 313594549,
 313082023,
 -1,
 313660084,
 313550155,
 -1,
 -60749,
 313648333,
 12879,
 -1,
 313672556,
 9329,
 -1,
 313621128,
 9322,
 -1,
 313560356,
 9330,
 313987827,
 308965622,
 -1,
 314053360,
 313926830,
 -1,
 314118846,
 314033016,
 -1,
 -60742,
 314101486,
 13025,
 -60741,
 314151410,
 13027,
 -60740,
 314204647,
 13024,
 -60739,
 314261671,
 13026,
 -1,
 314316174,
 13023,
 314512068,
 314095536,
 -1,
 -60736,
 314494702,
 13020,
 -60735,
 314544626,
 13022,
 -60734,
 314597863,
 13019,
 -60733,
 314654887,
 13021,
 -1,
 314709390,
 13018,
 314905290,
 314485206,
 -1,
 -60730,
 314887918,
 13048,
 -60729,
 314937842,
 13050,
 -60728,
 314991079,
 13047,
 -60727,
 315048103,
 13049,
 -1,
 315102606,
 13046,
 315298512,
 314870082,
 -1,
 -60724,
 315281134,
 13030,
 -60723,
 315331058,
 13032,
 -60722,
 315384295,
 13029,
 -60721,
 315441319,
 13031,
 -1,
 315495822,
 13028,
 315691734,
 315261000,
 -1,
 -60718,
 315674350,
 13040,
 -60717,
 315724274,
 13042,
 -60716,
 315777511,
 13039,
 -60715,
 315834535,
 13041,
 -1,
 315889038,
 13038,
 316084956,
 315650294,
 -1,
 -60712,
 316067566,
 13015,
 -60711,
 316117490,
 13017,
 -60710,
 316170727,
 13014,
 -60709,
 316227751,
 13016,
 -1,
 316282254,
 13013,
 316478178,
 316037363,
 -1,
 -60706,
 316460782,
 13035,
 -60705,
 316510706,
 13037,
 -60704,
 316563943,
 13034,
 -60703,
 316620967,
 13036,
 -1,
 316675470,
 13033,
 316871399,
 316464602,
 -1,
 -60700,
 316838386,
 13054,
 -60699,
 316891623,
 13052,
 -60698,
 316948647,
 13053,
 -1,
 317003150,
 13051,
 317199083,
 316859584,
 -1,
 -60695,
 317181678,
 13044,
 -60694,
 317231602,
 13045,
 -1,
 317265294,
 13043,
 -60692,
 317181678,
 13010,
 -60691,
 317428210,
 13012,
 -60690,
 317481447,
 13009,
 -60689,
 317538471,
 13011,
 -1,
 317592974,
 13008,
 317849599,
 314022163,
 -1,
 -60686,
 317747431,
 12925,
 -1,
 317796215,
 12924,
 317985561,
 313940211,
 -1,
 318051095,
 317923054,
 -1,
 318116602,
 318030712,
 -1,
 318182136,
 318072349,
 12898,
 -1,
 318111746,
 12912,
 318373887,
 318135626,
 12907,
 -1,
 318242818,
 12921,
 318444287,
 318087275,
 -1,
 318509821,
 318399662,
 12901,
 -1,
 318439426,
 12915,
 318701567,
 318463299,
 12908,
 -1,
 318570498,
 12922,
 318771972,
 318402806,
 -1,
 318837506,
 318730129,
 12896,
 -1,
 318767106,
 12910,
 319029247,
 318790972,
 12906,
 -1,
 318898178,
 12920,
 319099657,
 318713091,
 -1,
 319165191,
 319055011,
 12904,
 -1,
 319094786,
 12918,
 319356927,
 319118639,
 12905,
 -1,
 319225858,
 12919,
 319427341,
 319055016,
 12903,
 319553535,
 319356928,
 -1,
 -60660,
 319475438,
 12926,
 -1,
 319493518,
 12917,
 319689487,
 319405479,
 12902,
 -1,
 319619074,
 12916,
 319820561,
 319663844,
 12899,
 -1,
 319750146,
 12913,
 319951635,
 319786223,
 12897,
 -1,
 319881218,
 12911,
 320082709,
 319915409,
 12900,
 -1,
 320012290,
 12914,
 320274431,
 320036150,
 12909,
 -1,
 320143362,
 12923,
 -60648,
 318019972,
 9097,
 -1,
 320291326,
 10162,
 320475950,
 317929004,
 -1,
 320541484,
 320430567,
 -1,
 320607017,
 320493091,
 -1,
 320672543,
 320586616,
 -1,
 -60642,
 320660065,
 9313,
 -1,
 320692414,
 9314,
 320869154,
 320649136,
 -1,
 -60639,
 320827228,
 9317,
 -1,
 320883887,
 9318,
 321065765,
 320818846,
 -1,
 -60636,
 321035378,
 9315,
 -1,
 321089253,
 9316,
 -60634,
 321054831,
 9450,
 -60633,
 321230370,
 9312,
 -60632,
 321293599,
 9320,
 -1,
 321340759,
 9319,
 321585151,
 320593102,
 -1,
 -60629,
 321484270,
 8856,
 -1,
 321545709,
 10808,
 -60627,
 320510693,
 8857,
 -1,
 321659769,
 8861,
 321852211,
 320446571,
 -1,
 -60624,
 321821368,
 12342,
 -60623,
 321880008,
 8853,
 -60622,
 321931834,
 10681,
 -1,
 321986838,
 10679,
 322179896,
 321838554,
 -1,
 322245431,
 322133571,
 -1,
 -60618,
 322224363,
 10026,
 -1,
 322251876,
 10686,
 -1,
 322234360,
 127278,
 322507579,
 322159480,
 -1,
 -60614,
 322481807,
 9098,
 -1,
 322529060,
 8855,
 322704190,
 322480598,
 -1,
 -60611,
 322660658,
 8858,
 -1,
 322718992,
 10680,
 322900801,
 322666568,
 -1,
 -60608,
 322884065,
 10806,
 -1,
 322923281,
 8854,
 323097412,
 322841859,
 -1,
 -60605,
 323073348,
 9938,
 -1,
 323106348,
 127277,
 323294023,
 323032462,
 -1,
 -60602,
 323272993,
 8859,
 -1,
 323325959,
 10684,
 -60600,
 323279642,
 10678,
 -60599,
 323458953,
 10050,
 -60598,
 323508063,
 10689,
 -60597,
 323570028,
 8860,
 -1,
 323628132,
 10687,
 323878911,
 299892736,
 -1,
 323883868,
 323805252,
 -1,
 323949393,
 323867901,
 -1,
 -60592,
 323924049,
 9684,
 -1,
 323967494,
 9683,
 324146004,
 323925936,
 -1,
 -60589,
 324129973,
 10683,
 -1,
 324174275,
 10690,
 324342615,
 324105156,
 -1,
 -60586,
 324313038,
 9682,
 -1,
 324355040,
 9680,
 -60584,
 324328325,
 9677,
 -60583,
 324521588,
 10691,
 -60582,
 324579249,
 9681,
 -60581,
 324624192,
 10677,
 -1,
 324672473,
 9685,
 -1,
 323828342,
 10682,
 324993023,
 299880174,
 -1,
 -60577,
 324895965,
 94,
 -1,
 324957807,
 10768,
 325129273,
 299784435,
 -1,
 325194693,
 325075111,
 -1,
 325260228,
 325170345,
 -1,
 325325685,
 325239672,
 -1,
 325391211,
 325302192,
 -1,
 -60570,
 325376102,
 5096,
 -60569,
 325439214,
 5095,
 -60568,
 325489138,
 5094,
 -60567,
 325542375,
 5093,
 -60566,
 325599399,
 5092,
 -1,
 325653902,
 5091,
 325849970,
 325350340,
 -1,
 -60563,
 325834854,
 5090,
 -60562,
 325897966,
 5089,
 -60561,
 325947890,
 5088,
 -60560,
 326001127,
 5087,
 -60559,
 326058151,
 5086,
 -1,
 326112654,
 5085,
 -60557,
 325804519,
 5080,
 -60556,
 326254759,
 5078,
 -1,
 326309262,
 5076,
 326505340,
 325302192,
 5069,
 -60553,
 326490214,
 5074,
 -60552,
 326553326,
 5073,
 -60551,
 326603250,
 5072,
 -60550,
 326656487,
 5071,
 -60549,
 326713511,
 5070,
 -1,
 326768014,
 5068,
 326964100,
 326469954,
 -1,
 327029631,
 326899086,
 5054,
 -1,
 326981875,
 5056,
 -60544,
 327014502,
 5061,
 -60543,
 327143150,
 5060,
 -60542,
 327193074,
 5059,
 -60541,
 327246311,
 5058,
 -1,
 327303335,
 5057,
 327488396,
 326916339,
 -1,
 -60538,
 327473254,
 5042,
 -60537,
 327536366,
 5041,
 -60536,
 327586290,
 5040,
 -60535,
 327649694,
 5055,
 -60534,
 327705063,
 5039,
 -60533,
 327762087,
 5038,
 -1,
 327816590,
 5037,
 328012692,
 327431724,
 -1,
 -60530,
 327997542,
 5083,
 -60529,
 328060654,
 5082,
 -60528,
 328110578,
 5081,
 -60527,
 328168473,
 5084,
 -60526,
 328229351,
 5079,
 -60525,
 328286375,
 5077,
 -1,
 328340878,
 5075,
 328536987,
 328000704,
 -1,
 -60522,
 328521830,
 5108,
 -60521,
 328584942,
 5107,
 -60520,
 328634866,
 5106,
 -60519,
 328688103,
 5105,
 -60518,
 328745127,
 5104,
 -1,
 328799630,
 5103,
 328995746,
 328523226,
 -1,
 -60515,
 328980582,
 5102,
 -60514,
 329043694,
 5101,
 -60513,
 329093618,
 5100,
 -60512,
 329146855,
 5099,
 -60511,
 329203879,
 5098,
 -1,
 329258382,
 5097,
 329454505,
 328968259,
 -1,
 -60508,
 329439334,
 5067,
 -60507,
 329502446,
 5066,
 -60506,
 329552370,
 5065,
 -60505,
 329605607,
 5064,
 -60504,
 329662631,
 5063,
 -1,
 329717134,
 5062,
 329913264,
 329413572,
 -1,
 -60501,
 329898086,
 5048,
 -60500,
 329961198,
 5047,
 -60499,
 330011122,
 5046,
 -60498,
 330064359,
 5045,
 -60497,
 330121383,
 5044,
 -1,
 330175886,
 5043,
 330372023,
 329863979,
 -1,
 -60494,
 330356838,
 5036,
 -60493,
 330419950,
 5035,
 -60492,
 330469874,
 5034,
 -60491,
 330523111,
 5033,
 -60490,
 330580135,
 5032,
 -1,
 330634638,
 5030,
 330830781,
 330334280,
 -1,
 -60487,
 330813166,
 5053,
 -60486,
 330863090,
 5052,
 -60485,
 330916327,
 5051,
 -60484,
 330973351,
 5050,
 -1,
 331027854,
 5049,
 -60482,
 330815590,
 5029,
 -60481,
 331206382,
 5028,
 -60480,
 331256306,
 5027,
 -60479,
 331313421,
 5031,
 -60478,
 331375079,
 5026,
 -60477,
 331432103,
 5025,
 -1,
 331486606,
 5024,
 -1,
 325202247,
 10003,
 331748405,
 325129614,
 -1,
 331813939,
 331710538,
 -1,
 331879434,
 331774530,
 -1,
 331944916,
 331829370,
 -1,
 332010443,
 331909442,
 43590,
 -1,
 331961131,
 43586,
 -60468,
 331998400,
 43592,
 -60467,
 332120952,
 43589,
 -60466,
 332185660,
 43595,
 -60465,
 332245462,
 43593,
 -60464,
 332308587,
 43591,
 -60463,
 332362692,
 43594,
 -60462,
 332427510,
 43584,
 -60461,
 332485419,
 43585,
 -1,
 332541767,
 43588,
 332731358,
 331909442,
 -1,
 332796889,
 332683507,
 -1,
 -60457,
 332779698,
 43536,
 -60456,
 332820377,
 43538,
 -1,
 332862862,
 43537,
 333059036,
 332747563,
 -1,
 -60453,
 333041842,
 43530,
 -1,
 333059470,
 43531,
 -60451,
 333041842,
 43543,
 -1,
 333190542,
 43544,
 333386722,
 332701803,
 -1,
 -60448,
 333357264,
 43547,
 -60447,
 333404433,
 43548,
 -1,
 333452686,
 43546,
 333648870,
 333329964,
 -1,
 -60444,
 333601041,
 43542,
 -60443,
 333657751,
 43545,
 -1,
 333714830,
 43541,
 333911018,
 333588123,
 -1,
 -60440,
 333863185,
 43550,
 -60439,
 333915853,
 43553,
 -1,
 333976974,
 43549,
 334173165,
 333890424,
 -1,
 -60436,
 334125329,
 43540,
 -1,
 334173582,
 43539,
 334369776,
 334149552,
 -1,
 -60433,
 334346282,
 43558,
 -1,
 334370190,
 43559,
 334566387,
 334331976,
 -1,
 -60430,
 334549170,
 43551,
 -1,
 334566798,
 43552,
 334762998,
 334524662,
 -1,
 -60427,
 334715153,
 43527,
 -1,
 334763406,
 43526,
 334959609,
 334720919,
 -1,
 -60424,
 334911761,
 43535,
 -1,
 334960014,
 43534,
 335156220,
 334910251,
 -1,
 -60421,
 335108369,
 43529,
 -1,
 335156622,
 43528,
 335352831,
 335097671,
 -1,
 -60418,
 335304977,
 43533,
 -1,
 335353230,
 43532,
 335549441,
 335287694,
 43520,
 -1,
 335503847,
 43524,
 -60414,
 335537404,
 43554,
 -60413,
 335665268,
 43557,
 -60412,
 335728366,
 43522,
 -60411,
 335784497,
 43555,
 -60410,
 335843826,
 43525,
 -60409,
 335901721,
 43556,
 -60408,
 335962599,
 43521,
 -60407,
 336025873,
 43560,
 -1,
 336085159,
 43523,
 336270358,
 331865480,
 -1,
 336335887,
 336205198,
 -1,
 -60403,
 336318190,
 43569,
 -60402,
 336355815,
 43568,
 -1,
 336401806,
 43561,
 336598033,
 336318190,
 43565,
 -1,
 336543911,
 43570,
 336729107,
 336564722,
 43567,
 -1,
 336674983,
 43566,
 336860181,
 336683495,
 43562,
 -1,
 336814567,
 43563,
 -1,
 336807233,
 43564,
 337056804,
 336214436,
 -1,
 337122330,
 337036152,
 -1,
 -60391,
 337109601,
 43602,
 -1,
 337141950,
 43603,
 337318941,
 337098672,
 -1,
 -60388,
 337276764,
 43606,
 -1,
 337333423,
 43607,
 337515552,
 337268382,
 -1,
 -60385,
 337484914,
 43604,
 -1,
 337538789,
 43605,
 -60383,
 337504367,
 43600,
 -60382,
 337679906,
 43601,
 -60381,
 337743135,
 43609,
 -1,
 337790295,
 43608,
 337974317,
 336999103,
 -1,
 338039849,
 337924218,
 -1,
 -60377,
 338005018,
 43587,
 -60376,
 338067528,
 43596,
 -1,
 338122995,
 43597,
 -60374,
 338027772,
 43571,
 -60373,
 338288130,
 43574,
 -60372,
 338340401,
 43572,
 -1,
 338392089,
 43573,
 338624511,
 337946493,
 -1,
 338629681,
 338507308,
 -1,
 -60368,
 338598885,
 43614,
 -1,
 338632293,
 43613,
 -60366,
 338611197,
 43615,
 -1,
 338804671,
 43612,
 -60364,
 331786842,
 8256,
 -1,
 338913772,
 9939,
 339088440,
 331702759,
 -1,
 -60361,
 339064011,
 9911,
 -1,
 339085809,
 9767,
 -1,
 339072625,
 9962,
 339350608,
 325088196,
 -1,
 339416143,
 339317234,
 -1,
 339481670,
 339392809,
 -1,
 339547205,
 339424814,
 -1,
 339612738,
 339526165,
 -1,
 339678272,
 339583848,
 10960,
 -1,
 339609308,
 10962,
 339869695,
 339618867,
 10959,
 -1,
 339740380,
 10961,
 339940420,
 339596088,
 10828,
 -1,
 339870084,
 10832,
 -1,
 339897023,
 10829,
 -1,
 339479570,
 8272,
 340202574,
 339423627,
 -1,
 340268106,
 340143363,
 -1,
 -60343,
 340236022,
 8754,
 -1,
 340295187,
 10561,
 -60341,
 340249300,
 8631,
 -60340,
 340432808,
 8635,
 -60339,
 340486699,
 8753,
 -1,
 340546540,
 10227,
 -1,
 340185246,
 9729,
 -1,
 339362132,
 9114,
 340857948,
 339296423,
 -1,
 340923480,
 340823948,
 -1,
 340989015,
 340896774,
 -1,
 341054550,
 340949850,
 -1,
 -60331,
 341024605,
 65098,
 -1,
 341081739,
 65102,
 -1,
 340985265,
 8452,
 -1,
 340920888,
 162,
 341382235,
 340867223,
 -1,
 -60326,
 341343359,
 184,
 -1,
 341379640,
 8373,
 -1,
 341355914,
 9907,
 341704703,
 340830678,
 -1,
 341709925,
 341613219,
 -1,
 341775457,
 341656210,
 -1,
 -60320,
 341754597,
 9876,
 -1,
 341805995,
 127370,
 341972068,
 341706317,
 -1,
 -60317,
 341933567,
 9768,
 -1,
 341995585,
 9769,
 -1,
 341928221,
 9932,
 -1,
 341694554,
 8354,
 342302302,
 32840,
 -1,
 342366592,
 342234510,
 -1,
 342431912,
 342345516,
 -1,
 342496776,
 342407088,
 -1,
 342562268,
 342433583,
 -1,
 342627681,
 342502123,
 -1,
 342693088,
 342584846,
 -1,
 342758562,
 342670889,
 -1,
 342824050,
 342728811,
 120421,
 -60304,
 342801517,
 120769,
 -60303,
 342843879,
 120761,
 -1,
 342908145,
 120767,
 343086197,
 342803320,
 120425,
 -60300,
 343039174,
 120753,
 -1,
 343090612,
 120765,
 343282809,
 343052786,
 120420,
 343408639,
 343244872,
 -1,
 -60296,
 343303027,
 120760,
 -1,
 343360704,
 120770,
 343544956,
 343228583,
 120410,
 -60293,
 343524281,
 120752,
 -1,
 343582547,
 120750,
 343741566,
 343533560,
 120431,
 -1,
 343690117,
 120751,
 343872640,
 343729110,
 120429,
 -1,
 343826919,
 120759,
 344003714,
 343854830,
 120426,
 -1,
 343975763,
 120766,
 344134788,
 343979952,
 120424,
 -1,
 344090088,
 120764,
 344265862,
 344107478,
 120423,
 -1,
 344219335,
 120762,
 344396936,
 344230210,
 120419,
 -1,
 344379118,
 120758,
 344528010,
 344358984,
 120418,
 -1,
 344510190,
 120757,
 344659084,
 344486852,
 120417,
 -1,
 344595683,
 120756,
 344790158,
 344617206,
 120416,
 -1,
 344727626,
 120755,
 344921232,
 344744423,
 120414,
 -1,
 344890120,
 120754,
 345052306,
 344871723,
 120412,
 -1,
 344988943,
 120748,
 345183380,
 345001630,
 120411,
 -1,
 345139248,
 120763,
 345314454,
 345126444,
 120409,
 -1,
 345261640,
 120749,
 345445528,
 345255171,
 120408,
 -1,
 345398513,
 120768,
 345576602,
 345384603,
 120407,
 -1,
 345525125,
 120747,
 345707676,
 345511310,
 120406,
 -1,
 345669443,
 120746,
 -60259,
 345695424,
 120430,
 -60258,
 345824730,
 120428,
 -60257,
 345888870,
 120427,
 -60256,
 345941958,
 120422,
 -60255,
 345993111,
 120415,
 -1,
 346052851,
 120413,
 346232023,
 342699522,
 -1,
 346297511,
 346211192,
 120399,
 346363046,
 346250438,
 120727,
 -1,
 346294951,
 120737,
 -1,
 346301876,
 120739,
 346559659,
 346267755,
 120395,
 -60247,
 346537069,
 120743,
 -60246,
 346579431,
 120735,
 -1,
 346643697,
 120741,
 346821807,
 346526194,
 120394,
 346947583,
 346783816,
 -1,
 -60242,
 346841971,
 120734,
 -1,
 346899648,
 120744,
 347083954,
 346767527,
 120384,
 -60239,
 347063225,
 120726,
 -1,
 347121491,
 120724,
 347280564,
 347072504,
 120405,
 -1,
 347229061,
 120725,
 347411638,
 347268054,
 120403,
 -1,
 347365863,
 120733,
 347542712,
 347393774,
 120400,
 -1,
 347514707,
 120740,
 347673786,
 347518896,
 120398,
 -1,
 347629032,
 120738,
 347804860,
 347646422,
 120397,
 -1,
 347758279,
 120736,
 347935934,
 347769154,
 120393,
 -1,
 347918062,
 120732,
 348067008,
 347897928,
 120392,
 -1,
 348049134,
 120731,
 348198082,
 348025796,
 120391,
 -1,
 348134627,
 120730,
 348329156,
 348156150,
 120390,
 -1,
 348266570,
 120729,
 348460230,
 348283367,
 120388,
 -1,
 348429064,
 120728,
 348591304,
 348410667,
 120386,
 -1,
 348527887,
 120722,
 348722378,
 348534316,
 120383,
 -1,
 348669512,
 120723,
 348853452,
 348663043,
 120382,
 -1,
 348806385,
 120742,
 348984526,
 348792475,
 120381,
 -1,
 348932997,
 120721,
 349115600,
 348919182,
 120380,
 -1,
 349077315,
 120720,
 -60207,
 349103296,
 120404,
 -60206,
 349232602,
 120402,
 -60205,
 349296742,
 120401,
 -60204,
 349349830,
 120396,
 -60203,
 349400983,
 120389,
 -60202,
 349460723,
 120387,
 -1,
 349523614,
 120385,
 349705435,
 346202219,
 -1,
 -60199,
 349659693,
 120777,
 -60198,
 349723906,
 120775,
 -1,
 349774582,
 120771,
 -60196,
 349685573,
 120773,
 -60195,
 349941371,
 120776,
 -60194,
 349997495,
 120745,
 -60193,
 350056835,
 120774,
 -1,
 350111990,
 120772,
 350295317,
 342670889,
 -1,
 350360805,
 350265451,
 120317,
 -60189,
 350338157,
 120711,
 -60188,
 350380519,
 120703,
 -1,
 350444785,
 120709,
 350622952,
 350339960,
 120321,
 -60185,
 350575814,
 120695,
 -1,
 350627252,
 120707,
 350819564,
 350589426,
 120316,
 350945279,
 350781512,
 -1,
 -60181,
 350839667,
 120702,
 -1,
 350897344,
 120712,
 351081711,
 350765223,
 120306,
 -60178,
 351060921,
 120694,
 -1,
 351119187,
 120692,
 351278321,
 351070200,
 120327,
 -1,
 351226757,
 120693,
 351409395,
 351265750,
 120325,
 -1,
 351363559,
 120701,
 351540469,
 351391470,
 120322,
 -1,
 351512403,
 120708,
 351671543,
 351516592,
 120320,
 -1,
 351626728,
 120706,
 351802617,
 351644118,
 120319,
 -1,
 351755975,
 120704,
 351933691,
 351766850,
 120315,
 -1,
 351915758,
 120700,
 352064765,
 351895624,
 120314,
 -1,
 352046830,
 120699,
 352195839,
 352023492,
 120313,
 -1,
 352132323,
 120698,
 352326913,
 352153846,
 120312,
 -1,
 352264266,
 120697,
 352457987,
 352281063,
 120310,
 -1,
 352426760,
 120696,
 352589061,
 352408363,
 120308,
 -1,
 352525583,
 120690,
 352720135,
 352538270,
 120307,
 -1,
 352675888,
 120705,
 352851209,
 352663084,
 120305,
 -1,
 352798280,
 120691,
 352982283,
 352791811,
 120304,
 -1,
 352935153,
 120710,
 353113357,
 352921243,
 120303,
 -1,
 353061765,
 120689,
 353244431,
 353047950,
 120302,
 -1,
 353206083,
 120688,
 -60144,
 353232064,
 120326,
 -60143,
 353361370,
 120324,
 -60142,
 353425510,
 120323,
 -60141,
 353478598,
 120318,
 -60140,
 353529751,
 120311,
 -1,
 353589491,
 120309,
 353768778,
 350236162,
 -1,
 353834266,
 353747832,
 120295,
 353899801,
 353787078,
 120669,
 -1,
 353831591,
 120679,
 -1,
 353838516,
 120681,
 354096414,
 353804395,
 120291,
 -60132,
 354073709,
 120685,
 -60131,
 354116071,
 120677,
 -1,
 354180337,
 120683,
 354358562,
 354062834,
 120290,
 354484223,
 354320456,
 -1,
 -60127,
 354378611,
 120676,
 -1,
 354436288,
 120686,
 354620709,
 354304167,
 120280,
 -60124,
 354599865,
 120668,
 -1,
 354658131,
 120666,
 354817319,
 354609144,
 120301,
 -1,
 354765701,
 120667,
 354948393,
 354804694,
 120299,
 -1,
 354902503,
 120675,
 355079467,
 354930414,
 120296,
 -1,
 355051347,
 120682,
 355210541,
 355055536,
 120294,
 -1,
 355165672,
 120680,
 355341615,
 355183062,
 120293,
 -1,
 355294919,
 120678,
 355472689,
 355305794,
 120289,
 -1,
 355454702,
 120674,
 355603763,
 355434568,
 120288,
 -1,
 355585774,
 120673,
 355734837,
 355562436,
 120287,
 -1,
 355671267,
 120672,
 355865911,
 355692790,
 120286,
 -1,
 355803210,
 120671,
 355996985,
 355820007,
 120284,
 -1,
 355965704,
 120670,
 356128059,
 355947307,
 120282,
 -1,
 356064527,
 120664,
 356259133,
 356070956,
 120279,
 -1,
 356206152,
 120665,
 356390207,
 356199683,
 120278,
 -1,
 356343025,
 120684,
 356521281,
 356329115,
 120277,
 -1,
 356469637,
 120663,
 356652355,
 356455822,
 120276,
 -1,
 356613955,
 120662,
 -60092,
 356639936,
 120300,
 -60091,
 356769242,
 120298,
 -60090,
 356833382,
 120297,
 -60089,
 356886470,
 120292,
 -60088,
 356937623,
 120285,
 -60087,
 356997363,
 120283,
 -1,
 357060254,
 120281,
 357242200,
 353712548,
 -1,
 357307726,
 357221240,
 -1,
 -60083,
 357294689,
 120814,
 -1,
 357327038,
 120815,
 357504337,
 357283760,
 -1,
 -60080,
 357461852,
 120818,
 -1,
 357518511,
 120819,
 357700948,
 357453470,
 -1,
 -60077,
 357670002,
 120816,
 -1,
 357723877,
 120817,
 -60075,
 357689455,
 120812,
 -60074,
 357864994,
 120813,
 -60073,
 357928223,
 120821,
 -1,
 357975383,
 120820,
 358159708,
 357212267,
 -1,
 -60070,
 358113837,
 120719,
 -60069,
 358178050,
 120717,
 -1,
 358228726,
 120713,
 -60067,
 358139717,
 120715,
 -60066,
 358395515,
 120718,
 -60065,
 358451639,
 120687,
 -60064,
 358510979,
 120716,
 -1,
 358566134,
 120714,
 358749592,
 342584846,
 -1,
 358815101,
 358727209,
 -1,
 -60060,
 358803448,
 120379,
 -60059,
 358868160,
 120378,
 -60058,
 358933462,
 120377,
 -60057,
 358997466,
 120376,
 -60056,
 359061606,
 120375,
 -60055,
 359124718,
 120374,
 -60054,
 359187320,
 120373,
 -60053,
 359249840,
 120372,
 -60052,
 359311830,
 120371,
 -60051,
 359376838,
 120370,
 -60050,
 359440491,
 120369,
 -60049,
 359502322,
 120368,
 -60048,
 359565634,
 120367,
 -60047,
 359628872,
 120366,
 -60046,
 359691204,
 120365,
 -60045,
 359756022,
 120364,
 -60044,
 359821207,
 120363,
 -60043,
 359883239,
 120362,
 -60042,
 359946483,
 120361,
 -60041,
 360010539,
 120360,
 -60040,
 360074910,
 120359,
 -60039,
 360136871,
 120358,
 -60038,
 360199724,
 120357,
 -60037,
 360262915,
 120356,
 -60036,
 360326811,
 120355,
 -1,
 360387982,
 120354,
 360644607,
 358755842,
 -1,
 -60033,
 360572920,
 120353,
 -60032,
 360637632,
 120352,
 -60031,
 360702934,
 120351,
 -60030,
 360766938,
 120350,
 -60029,
 360831078,
 120349,
 -60028,
 360894190,
 120348,
 -60027,
 360956792,
 120347,
 -60026,
 361019312,
 120346,
 -60025,
 361081302,
 120345,
 -60024,
 361146310,
 120344,
 -60023,
 361209963,
 120343,
 -60022,
 361271794,
 120342,
 -60021,
 361335106,
 120341,
 -60020,
 361398344,
 120340,
 -60019,
 361460676,
 120339,
 -60018,
 361525494,
 120338,
 -60017,
 361590679,
 120337,
 -60016,
 361652711,
 120336,
 -60015,
 361715955,
 120335,
 -60014,
 361780011,
 120334,
 -60013,
 361844382,
 120333,
 -60012,
 361906343,
 120332,
 -60011,
 361969196,
 120331,
 -60010,
 362032387,
 120330,
 -60009,
 362096283,
 120329,
 -1,
 362157454,
 120328,
 362354099,
 358727209,
 -1,
 -60006,
 362342392,
 120275,
 -60005,
 362407104,
 120274,
 -60004,
 362472406,
 120273,
 -60003,
 362536410,
 120272,
 -60002,
 362600550,
 120271,
 -60001,
 362663662,
 120270,
 -60000,
 362726264,
 120269,
 -59999,
 362788784,
 120268,
 -59998,
 362850774,
 120267,
 -59997,
 362915782,
 120266,
 -59996,
 362979435,
 120265,
 -59995,
 363041266,
 120264,
 -59994,
 363104578,
 120263,
 -59993,
 363167816,
 120262,
 -59992,
 363230148,
 120261,
 -59991,
 363294966,
 120260,
 -59990,
 363360151,
 120259,
 -59989,
 363422183,
 120258,
 -59988,
 363485427,
 120257,
 -59987,
 363549483,
 120256,
 -59986,
 363613854,
 120255,
 -59985,
 363675815,
 120254,
 -59984,
 363738668,
 120253,
 -59983,
 363801859,
 120252,
 -59982,
 363865755,
 120251,
 -1,
 363926926,
 120250,
 364123598,
 362294786,
 -1,
 -59979,
 364111864,
 120249,
 -59978,
 364176576,
 120248,
 -59977,
 364241878,
 120247,
 -59976,
 364305882,
 120246,
 -59975,
 364370022,
 120245,
 -59974,
 364433134,
 120244,
 -59973,
 364495736,
 120243,
 -59972,
 364558256,
 120242,
 -59971,
 364620246,
 120241,
 -59970,
 364685254,
 120240,
 -59969,
 364748907,
 120239,
 -59968,
 364810738,
 120238,
 -59967,
 364874050,
 120237,
 -59966,
 364937288,
 120236,
 -59965,
 364999620,
 120235,
 -59964,
 365064438,
 120234,
 -59963,
 365129623,
 120233,
 -59962,
 365191655,
 120232,
 -59961,
 365254899,
 120231,
 -59960,
 365318955,
 120230,
 -59959,
 365383326,
 120229,
 -59958,
 365445287,
 120228,
 -59957,
 365508140,
 120227,
 -59956,
 365571331,
 120226,
 -59955,
 365635227,
 120225,
 -1,
 365696398,
 120224,
 365953023,
 364067236,
 -1,
 365958610,
 365871992,
 -1,
 -59951,
 365945441,
 120804,
 -1,
 365977790,
 120805,
 366155221,
 365934512,
 -1,
 -59948,
 366112604,
 120808,
 -1,
 366169263,
 120809,
 366351832,
 366104222,
 -1,
 -59945,
 366320754,
 120806,
 -1,
 366374629,
 120807,
 -59943,
 366340207,
 120802,
 -59942,
 366515746,
 120803,
 -59941,
 366578975,
 120811,
 -1,
 366626135,
 120810,
 366870527,
 342504462,
 -1,
 366876149,
 366788137,
 -1,
 -59937,
 366864376,
 120015,
 -59936,
 366929088,
 120014,
 -59935,
 366994390,
 120013,
 -59934,
 367058394,
 120012,
 -59933,
 367122534,
 120011,
 -59932,
 367185646,
 120010,
 -59931,
 367248248,
 120009,
 -59930,
 367310768,
 120008,
 -59929,
 367372758,
 120007,
 -59928,
 367437766,
 120006,
 -59927,
 367501419,
 120005,
 -59926,
 367561026,
 120003,
 -59925,
 367624264,
 120002,
 -59924,
 367686596,
 120001,
 -59923,
 367751414,
 120000,
 -59922,
 367816599,
 119999,
 -59921,
 367878631,
 119998,
 -59920,
 367941875,
 119997,
 -59919,
 368004766,
 119995,
 -59918,
 368064044,
 119993,
 -59917,
 368127235,
 119992,
 -59916,
 368191131,
 119991,
 -1,
 368252302,
 119990,
 368508927,
 366816770,
 -1,
 -59913,
 368437240,
 119989,
 -59912,
 368501952,
 119988,
 -59911,
 368567254,
 119987,
 -59910,
 368631258,
 119986,
 -59909,
 368695398,
 119985,
 -59908,
 368758510,
 119984,
 -59907,
 368821112,
 119983,
 -59906,
 368883632,
 119982,
 -59905,
 368945094,
 119980,
 -59904,
 369008747,
 119979,
 -59903,
 369070578,
 119978,
 -59902,
 369133890,
 119977,
 -59901,
 369193206,
 119974,
 -59900,
 369258391,
 119973,
 -59899,
 369316651,
 119970,
 -59898,
 369374764,
 119967,
 -59897,
 369437955,
 119966,
 -1,
 369497486,
 119964,
 369694575,
 342436587,
 -1,
 369759869,
 369651214,
 -1,
 369825343,
 369737257,
 -1,
 369890831,
 369795179,
 119953,
 -59891,
 369867885,
 120653,
 -59890,
 369910247,
 120645,
 -1,
 369974513,
 120651,
 370152978,
 369869688,
 119957,
 -59887,
 370105542,
 120637,
 -1,
 370156980,
 120649,
 370349590,
 370119154,
 119952,
 370475007,
 370311240,
 -1,
 -59883,
 370369395,
 120644,
 -1,
 370427072,
 120654,
 370611737,
 370294951,
 119942,
 -59880,
 370590649,
 120636,
 -1,
 370648915,
 120634,
 370808347,
 370599928,
 119963,
 -1,
 370756485,
 120635,
 370939421,
 370795478,
 119961,
 -1,
 370893287,
 120643,
 371070495,
 370921198,
 119958,
 -1,
 371042131,
 120650,
 371201569,
 371046320,
 119956,
 -1,
 371156456,
 120648,
 371332643,
 371173846,
 119955,
 -1,
 371285703,
 120646,
 371463717,
 371296578,
 119951,
 -1,
 371445486,
 120642,
 371594791,
 371425352,
 119950,
 -1,
 371576558,
 120641,
 371725865,
 371553220,
 119949,
 -1,
 371662051,
 120640,
 371856939,
 371683574,
 119948,
 -1,
 371793994,
 120639,
 371988013,
 371810791,
 119946,
 -1,
 371956488,
 120638,
 372119087,
 371938091,
 119944,
 -1,
 372055311,
 120632,
 372250161,
 372067998,
 119943,
 -1,
 372205616,
 120647,
 372381235,
 372192812,
 119941,
 -1,
 372328008,
 120633,
 372512309,
 372321539,
 119940,
 -1,
 372464881,
 120652,
 372643383,
 372450971,
 119939,
 -1,
 372591493,
 120631,
 372774457,
 372577678,
 119938,
 -1,
 372735811,
 120630,
 -59846,
 372761792,
 119962,
 -59845,
 372891098,
 119960,
 -59844,
 372955238,
 119959,
 -59843,
 373008326,
 119954,
 -59842,
 373059479,
 119947,
 -1,
 373119219,
 119945,
 373298804,
 369765890,
 -1,
 373364292,
 373277560,
 119931,
 373429827,
 373316806,
 120611,
 -1,
 373361319,
 120621,
 -1,
 373368244,
 120623,
 373626440,
 373334123,
 119927,
 -59834,
 373603437,
 120627,
 -59833,
 373645799,
 120619,
 -1,
 373710065,
 120625,
 373888588,
 373592562,
 119926,
 374013951,
 373850184,
 -1,
 -59829,
 373908339,
 120618,
 -1,
 373966016,
 120628,
 374150735,
 373833895,
 119916,
 -59826,
 374129593,
 120610,
 -1,
 374187859,
 120608,
 374347345,
 374138872,
 119937,
 -1,
 374295429,
 120609,
 374478419,
 374334422,
 119935,
 -1,
 374432231,
 120617,
 374609493,
 374460142,
 119932,
 -1,
 374581075,
 120624,
 374740567,
 374585264,
 119930,
 -1,
 374695400,
 120622,
 374871641,
 374712790,
 119929,
 -1,
 374824647,
 120620,
 375002715,
 374835522,
 119925,
 -1,
 374984430,
 120616,
 375133789,
 374964296,
 119924,
 -1,
 375115502,
 120615,
 375264863,
 375092164,
 119923,
 -1,
 375200995,
 120614,
 375395937,
 375222518,
 119922,
 -1,
 375332938,
 120613,
 375527011,
 375349735,
 119920,
 -1,
 375495432,
 120612,
 375658085,
 375477035,
 119918,
 -1,
 375594255,
 120606,
 375789159,
 375600684,
 119915,
 -1,
 375735880,
 120607,
 375920233,
 375729411,
 119914,
 -1,
 375872753,
 120626,
 376051307,
 375858843,
 119913,
 -1,
 375999365,
 120605,
 376182381,
 375985550,
 119912,
 -1,
 376143683,
 120604,
 -59794,
 376169664,
 119936,
 -59793,
 376298970,
 119934,
 -59792,
 376363110,
 119933,
 -59791,
 376416198,
 119928,
 -59790,
 376467351,
 119921,
 -59789,
 376527091,
 119919,
 -1,
 376589982,
 119917,
 376772216,
 373268587,
 -1,
 -59786,
 376726061,
 120661,
 -59785,
 376790274,
 120659,
 -1,
 376840950,
 120655,
 -59783,
 376751941,
 120657,
 -59782,
 377007739,
 120660,
 -59781,
 377063863,
 120629,
 -59780,
 377123203,
 120658,
 -1,
 377178358,
 120656,
 377362155,
 369735600,
 -1,
 377427636,
 377323905,
 -1,
 377493123,
 377397355,
 119849,
 -59775,
 377470061,
 120537,
 -59774,
 377512423,
 120529,
 -1,
 377576689,
 120535,
 377755270,
 377471864,
 119853,
 -59771,
 377707718,
 120521,
 -1,
 377759156,
 120533,
 377951882,
 377721330,
 119848,
 378077183,
 377913416,
 -1,
 -59767,
 377971571,
 120528,
 -1,
 378029248,
 120538,
 378214029,
 377897127,
 119838,
 -59764,
 378192825,
 120520,
 -1,
 378251091,
 120518,
 378410640,
 378156588,
 119837,
 -59761,
 378365184,
 120779,
 -1,
 378422856,
 120517,
 378607250,
 378398712,
 119859,
 -1,
 378555269,
 120519,
 378738324,
 378594262,
 119857,
 -1,
 378692071,
 120527,
 378869398,
 378719982,
 119854,
 -1,
 378840915,
 120534,
 379000472,
 378845104,
 119852,
 -1,
 378955240,
 120532,
 379131546,
 378972630,
 119851,
 -1,
 379084487,
 120530,
 379262620,
 379095362,
 119847,
 -1,
 379244270,
 120526,
 379393694,
 379224136,
 119846,
 -1,
 379375342,
 120525,
 379524768,
 379352004,
 119845,
 -1,
 379460835,
 120524,
 379655842,
 379482358,
 119844,
 -1,
 379592778,
 120523,
 379786916,
 379609575,
 119842,
 -1,
 379755272,
 120522,
 379917990,
 379736875,
 119840,
 -1,
 379854095,
 120516,
 380049064,
 379866782,
 119839,
 -1,
 380004400,
 120531,
 380180138,
 379989251,
 119836,
 -1,
 380132593,
 120536,
 380311212,
 380118683,
 119835,
 -1,
 380259205,
 120515,
 380442286,
 380245390,
 119834,
 -1,
 380403523,
 120514,
 -59729,
 380429504,
 119858,
 -59728,
 380558810,
 119856,
 -59727,
 380622950,
 119855,
 -59726,
 380676038,
 119850,
 -59725,
 380727191,
 119843,
 -1,
 380786931,
 119841,
 381026303,
 377369614,
 -1,
 381032144,
 380943913,
 -1,
 -59721,
 381020152,
 120067,
 -59720,
 381084864,
 120066,
 -59719,
 381150166,
 120065,
 -59718,
 381214170,
 120064,
 -59717,
 381278310,
 120063,
 -59716,
 381341422,
 120062,
 -59715,
 381404024,
 120061,
 -59714,
 381466544,
 120060,
 -59713,
 381528534,
 120059,
 -59712,
 381593542,
 120058,
 -59711,
 381657195,
 120057,
 -59710,
 381719026,
 120056,
 -59709,
 381782338,
 120055,
 -59708,
 381845576,
 120054,
 -59707,
 381907908,
 120053,
 -59706,
 381972726,
 120052,
 -59705,
 382037911,
 120051,
 -59704,
 382099943,
 120050,
 -59703,
 382163187,
 120049,
 -59702,
 382227243,
 120048,
 -59701,
 382291614,
 120047,
 -59700,
 382353575,
 120046,
 -59699,
 382416428,
 120045,
 -59698,
 382479619,
 120044,
 -59697,
 382543515,
 120043,
 -1,
 382604686,
 120042,
 382861311,
 380972546,
 -1,
 -59694,
 382789624,
 120041,
 -59693,
 382854336,
 120040,
 -59692,
 382919638,
 120039,
 -59691,
 382983642,
 120038,
 -59690,
 383047782,
 120037,
 -59689,
 383110894,
 120036,
 -59688,
 383173496,
 120035,
 -59687,
 383236016,
 120034,
 -59686,
 383298006,
 120033,
 -59685,
 383363014,
 120032,
 -59684,
 383426667,
 120031,
 -59683,
 383488498,
 120030,
 -59682,
 383551810,
 120029,
 -59681,
 383615048,
 120028,
 -59680,
 383677380,
 120027,
 -59679,
 383742198,
 120026,
 -59678,
 383807383,
 120025,
 -59677,
 383869415,
 120024,
 -59676,
 383932659,
 120023,
 -59675,
 383996715,
 120022,
 -59674,
 384061086,
 120021,
 -59673,
 384123047,
 120020,
 -59672,
 384185900,
 120019,
 -59671,
 384249091,
 120018,
 -59670,
 384312987,
 120017,
 -1,
 384374158,
 120016,
 384571170,
 377311877,
 -1,
 384636679,
 384548393,
 -1,
 -59666,
 384624632,
 120223,
 -59665,
 384689344,
 120222,
 -59664,
 384754646,
 120221,
 -59663,
 384818650,
 120220,
 -59662,
 384882790,
 120219,
 -59661,
 384945902,
 120218,
 -59660,
 385008504,
 120217,
 -59659,
 385071024,
 120216,
 -59658,
 385133014,
 120215,
 -59657,
 385198022,
 120214,
 -59656,
 385261675,
 120213,
 -59655,
 385323506,
 120212,
 -59654,
 385386818,
 120211,
 -59653,
 385450056,
 120210,
 -59652,
 385512388,
 120209,
 -59651,
 385577206,
 120208,
 -59650,
 385642391,
 120207,
 -59649,
 385704423,
 120206,
 -59648,
 385767667,
 120205,
 -59647,
 385831723,
 120204,
 -59646,
 385896094,
 120203,
 -59645,
 385958055,
 120202,
 -59644,
 386020908,
 120201,
 -59643,
 386084099,
 120200,
 -59642,
 386147995,
 120199,
 -1,
 386209166,
 120198,
 386465791,
 384577026,
 -1,
 -59639,
 386394104,
 120197,
 -59638,
 386458816,
 120196,
 -59637,
 386524118,
 120195,
 -59636,
 386588122,
 120194,
 -59635,
 386652262,
 120193,
 -59634,
 386715374,
 120192,
 -59633,
 386777976,
 120191,
 -59632,
 386840496,
 120190,
 -59631,
 386902486,
 120189,
 -59630,
 386967494,
 120188,
 -59629,
 387031147,
 120187,
 -59628,
 387092978,
 120186,
 -59627,
 387156290,
 120185,
 -59626,
 387219528,
 120184,
 -59625,
 387281860,
 120183,
 -59624,
 387346678,
 120182,
 -59623,
 387411863,
 120181,
 -59622,
 387473895,
 120180,
 -59621,
 387537139,
 120179,
 -59620,
 387601195,
 120178,
 -59619,
 387665566,
 120177,
 -59618,
 387727527,
 120176,
 -59617,
 387790380,
 120175,
 -59616,
 387853571,
 120174,
 -59615,
 387917467,
 120173,
 -1,
 387978638,
 120172,
 388175704,
 384511490,
 -1,
 388241191,
 388154232,
 119827,
 388306726,
 388193478,
 120495,
 -1,
 388237991,
 120505,
 -1,
 388244916,
 120507,
 388503339,
 388210795,
 119823,
 -59607,
 388480109,
 120511,
 -59606,
 388522471,
 120503,
 -1,
 388586737,
 120509,
 388765487,
 388469234,
 119822,
 388890623,
 388726856,
 -1,
 -59602,
 388785011,
 120502,
 -1,
 388842688,
 120512,
 389027634,
 388710567,
 119812,
 -59599,
 389006265,
 120494,
 -1,
 389064531,
 120492,
 389224245,
 388970028,
 119811,
 -59596,
 389178624,
 120778,
 -1,
 389236296,
 120491,
 389420855,
 389212152,
 119833,
 -1,
 389368709,
 120493,
 389551929,
 389407702,
 119831,
 -1,
 389505511,
 120501,
 389683003,
 389533422,
 119828,
 -1,
 389654355,
 120508,
 389814077,
 389658544,
 119826,
 -1,
 389768680,
 120506,
 389945151,
 389786070,
 119825,
 -1,
 389897927,
 120504,
 390076225,
 389908802,
 119821,
 -1,
 390057710,
 120500,
 390207299,
 390037576,
 119820,
 -1,
 390188782,
 120499,
 390338373,
 390165444,
 119819,
 -1,
 390274275,
 120498,
 390469447,
 390295798,
 119818,
 -1,
 390406218,
 120497,
 390600521,
 390423015,
 119816,
 -1,
 390568712,
 120496,
 390731595,
 390550315,
 119814,
 -1,
 390667535,
 120490,
 390862669,
 390671619,
 119810,
 -1,
 390814961,
 120510,
 390993743,
 390801051,
 119809,
 -1,
 390941573,
 120489,
 391124817,
 390927758,
 119808,
 -1,
 391085891,
 120488,
 -59566,
 391111872,
 119832,
 -59565,
 391241178,
 119830,
 -59564,
 391305318,
 119829,
 -59563,
 391358406,
 119824,
 -59562,
 391409559,
 119817,
 -59561,
 391469299,
 119815,
 -1,
 391532190,
 119813,
 391714662,
 388118948,
 -1,
 391780188,
 391693176,
 -1,
 -59557,
 391766625,
 120784,
 -1,
 391798974,
 120785,
 391976799,
 391755696,
 -1,
 -59554,
 391933788,
 120788,
 -1,
 391990447,
 120789,
 392173410,
 391925406,
 -1,
 -59551,
 392141938,
 120786,
 -1,
 392195813,
 120787,
 -59549,
 392161391,
 120782,
 -59548,
 392336930,
 120783,
 -59547,
 392400159,
 120791,
 -1,
 392447319,
 120790,
 392632170,
 391684203,
 -1,
 -59544,
 392585773,
 120545,
 -59543,
 392649986,
 120543,
 -1,
 392700662,
 120539,
 -59541,
 392611653,
 120541,
 -59540,
 392867451,
 120544,
 -59539,
 392923575,
 120513,
 -59538,
 392982915,
 120542,
 -1,
 393038070,
 120540,
 393222117,
 369651214,
 -1,
 393287591,
 393199145,
 -1,
 393353077,
 393257067,
 119901,
 -59533,
 393329773,
 120595,
 -59532,
 393372135,
 120587,
 -1,
 393436401,
 120593,
 393615226,
 393295404,
 119889,
 393680761,
 393583457,
 -1,
 -59528,
 393637783,
 120485,
 -1,
 393699815,
 120484,
 -1,
 393627208,
 120575,
 393942909,
 393593720,
 119905,
 -59524,
 393895110,
 120579,
 -1,
 393946548,
 120591,
 394139521,
 393908722,
 119900,
 394264575,
 394100808,
 -1,
 -59520,
 394158963,
 120586,
 -1,
 394216640,
 120596,
 394401668,
 394084519,
 119890,
 -59517,
 394380217,
 120578,
 -1,
 394438483,
 120576,
 394598278,
 394389496,
 119911,
 -1,
 394546053,
 120577,
 394729352,
 394585046,
 119909,
 -1,
 394682855,
 120585,
 394860426,
 394710766,
 119906,
 -1,
 394831699,
 120592,
 394991500,
 394835888,
 119904,
 -1,
 394946024,
 120590,
 395122574,
 394963414,
 119903,
 -1,
 395075271,
 120588,
 395253648,
 395086146,
 119899,
 -1,
 395235054,
 120584,
 395384722,
 395214920,
 119898,
 -1,
 395366126,
 120583,
 395515796,
 395342788,
 119897,
 -1,
 395451619,
 120582,
 395646870,
 395473142,
 119896,
 -1,
 395583562,
 120581,
 395777944,
 395600359,
 119894,
 -1,
 395746056,
 120580,
 395909018,
 395727659,
 119892,
 -1,
 395844879,
 120574,
 396040092,
 395857566,
 119891,
 -1,
 395995184,
 120589,
 396171166,
 395980035,
 119888,
 -1,
 396123377,
 120594,
 396302240,
 396109467,
 119887,
 -1,
 396249989,
 120573,
 396433314,
 396236174,
 119886,
 -1,
 396394307,
 120572,
 -59485,
 396420288,
 119910,
 -59484,
 396549594,
 119908,
 -59483,
 396613734,
 119907,
 -59482,
 396666822,
 119902,
 -1,
 396717975,
 119895,
 396892124,
 393227778,
 -1,
 396957612,
 396870520,
 119879,
 397023147,
 396909766,
 120553,
 -1,
 396954279,
 120563,
 -1,
 396961204,
 120565,
 397219760,
 396927083,
 119875,
 -59474,
 397196397,
 120569,
 -59473,
 397238759,
 120561,
 -1,
 397303025,
 120567,
 397481908,
 397185522,
 119874,
 397606911,
 397443144,
 -1,
 -59469,
 397501299,
 120560,
 -1,
 397558976,
 120570,
 397744055,
 397426855,
 119864,
 -59466,
 397722553,
 120552,
 -1,
 397780819,
 120550,
 397940665,
 397731832,
 119885,
 -1,
 397888389,
 120551,
 398071739,
 397927382,
 119883,
 -1,
 398025191,
 120559,
 398202813,
 398053102,
 119880,
 -1,
 398174035,
 120566,
 398333887,
 398178224,
 119878,
 -1,
 398288360,
 120564,
 398464961,
 398305750,
 119877,
 -1,
 398417607,
 120562,
 398596035,
 398428482,
 119873,
 -1,
 398577390,
 120558,
 398727109,
 398557256,
 119872,
 -1,
 398708462,
 120557,
 398858183,
 398685124,
 119871,
 -1,
 398793955,
 120556,
 398989257,
 398815478,
 119870,
 -1,
 398925898,
 120555,
 399120331,
 398942695,
 119868,
 -1,
 399088392,
 120554,
 399251405,
 399069995,
 119866,
 -1,
 399187215,
 120548,
 399382479,
 399193644,
 119863,
 -1,
 399328840,
 120549,
 399513553,
 399322371,
 119862,
 -1,
 399465713,
 120568,
 399644627,
 399451803,
 119861,
 -1,
 399592325,
 120547,
 399775701,
 399578510,
 119860,
 -1,
 399736643,
 120546,
 -59434,
 399762624,
 119884,
 -59433,
 399891930,
 119882,
 -59432,
 399956070,
 119881,
 -59431,
 400009158,
 119876,
 -59430,
 400060311,
 119869,
 -59429,
 400120051,
 119867,
 -1,
 400182942,
 119865,
 400365536,
 396861547,
 -1,
 -59426,
 400319021,
 120603,
 -59425,
 400383234,
 120601,
 -1,
 400433910,
 120597,
 -59423,
 400344901,
 120599,
 -59422,
 400600699,
 120602,
 -59421,
 400656823,
 120571,
 -59420,
 400716163,
 120600,
 -1,
 400771318,
 120598,
 400955434,
 393185122,
 -1,
 401020929,
 400932393,
 -1,
 -59416,
 401008632,
 120483,
 -59415,
 401073344,
 120482,
 -59414,
 401138646,
 120481,
 -59413,
 401202650,
 120480,
 -59412,
 401266790,
 120479,
 -59411,
 401329902,
 120478,
 -59410,
 401392504,
 120477,
 -59409,
 401455024,
 120476,
 -59408,
 401517014,
 120475,
 -59407,
 401582022,
 120474,
 -59406,
 401645675,
 120473,
 -59405,
 401707506,
 120472,
 -59404,
 401770818,
 120471,
 -59403,
 401834056,
 120470,
 -59402,
 401896388,
 120469,
 -59401,
 401961206,
 120468,
 -59400,
 402026391,
 120467,
 -59399,
 402088423,
 120466,
 -59398,
 402151667,
 120465,
 -59397,
 402215723,
 120464,
 -59396,
 402280094,
 120463,
 -59395,
 402342055,
 120462,
 -59394,
 402404908,
 120461,
 -59393,
 402468099,
 120460,
 -59392,
 402531995,
 120459,
 -1,
 402593166,
 120458,
 402790428,
 400961026,
 -1,
 -59389,
 402778104,
 120457,
 -59388,
 402842816,
 120456,
 -59387,
 402908118,
 120455,
 -59386,
 402972122,
 120454,
 -59385,
 403036262,
 120453,
 -59384,
 403099374,
 120452,
 -59383,
 403161976,
 120451,
 -59382,
 403224496,
 120450,
 -59381,
 403286486,
 120449,
 -59380,
 403351494,
 120448,
 -59379,
 403415147,
 120447,
 -59378,
 403476978,
 120446,
 -59377,
 403540290,
 120445,
 -59376,
 403603528,
 120444,
 -59375,
 403665860,
 120443,
 -59374,
 403730678,
 120442,
 -59373,
 403795863,
 120441,
 -59372,
 403857895,
 120440,
 -59371,
 403921139,
 120439,
 -59370,
 403985195,
 120438,
 -59369,
 404049566,
 120437,
 -59368,
 404111527,
 120436,
 -59367,
 404174380,
 120435,
 -59366,
 404237571,
 120434,
 -59365,
 404301467,
 120433,
 -1,
 404362638,
 120432,
 404619263,
 402733476,
 -1,
 404625440,
 404538232,
 -1,
 -59361,
 404611681,
 120824,
 -1,
 404644030,
 120825,
 404822051,
 404600752,
 -1,
 -59358,
 404778844,
 120828,
 -1,
 404835503,
 120829,
 405018662,
 404770462,
 -1,
 -59355,
 404986994,
 120826,
 -1,
 405040869,
 120827,
 -59353,
 405006447,
 120822,
 -59352,
 405181986,
 120823,
 -59351,
 405245215,
 120831,
 -1,
 405292375,
 120830,
 405477480,
 400899635,
 -1,
 405542982,
 405454377,
 -1,
 -59347,
 405530616,
 120171,
 -59346,
 405595328,
 120170,
 -59345,
 405660630,
 120169,
 -59344,
 405724634,
 120168,
 -59343,
 405788774,
 120167,
 -59342,
 405851886,
 120166,
 -59341,
 405914488,
 120165,
 -59340,
 405977008,
 120164,
 -59339,
 406038998,
 120163,
 -59338,
 406104006,
 120162,
 -59337,
 406167659,
 120161,
 -59336,
 406229490,
 120160,
 -59335,
 406292802,
 120159,
 -59334,
 406356040,
 120158,
 -59333,
 406418372,
 120157,
 -59332,
 406483190,
 120156,
 -59331,
 406548375,
 120155,
 -59330,
 406610407,
 120154,
 -59329,
 406673651,
 120153,
 -59328,
 406737707,
 120152,
 -59327,
 406802078,
 120151,
 -59326,
 406864039,
 120150,
 -59325,
 406926892,
 120149,
 -59324,
 406990083,
 120148,
 -59323,
 407053979,
 120147,
 -1,
 407115150,
 120146,
 407312474,
 405483010,
 -1,
 -59320,
 407299264,
 120144,
 -59319,
 407364566,
 120143,
 -59318,
 407428570,
 120142,
 -59317,
 407492710,
 120141,
 -59316,
 407555822,
 120140,
 -59315,
 407618424,
 120139,
 -59314,
 407680944,
 120138,
 -59313,
 407736818,
 120134,
 -59312,
 407797832,
 120132,
 -59311,
 407860164,
 120131,
 -59310,
 407924982,
 120130,
 -59309,
 407990167,
 120129,
 -59308,
 408052199,
 120128,
 -59307,
 408113963,
 120126,
 -59306,
 408178334,
 120125,
 -59305,
 408240295,
 120124,
 -59304,
 408303148,
 120123,
 -59303,
 408364699,
 120121,
 -1,
 408425870,
 120120,
 408682495,
 407255460,
 -1,
 408688734,
 408601464,
 -1,
 -59299,
 408674913,
 120794,
 -1,
 408707262,
 120795,
 408885345,
 408663984,
 -1,
 -59296,
 408842076,
 120798,
 -1,
 408898735,
 120799,
 409081956,
 408833694,
 -1,
 -59293,
 409050226,
 120796,
 -1,
 409104101,
 120797,
 -59291,
 409069679,
 120792,
 -59290,
 409245218,
 120793,
 -59289,
 409308447,
 120801,
 -1,
 409355607,
 120800,
 409540762,
 405426821,
 -1,
 409606276,
 409517609,
 -1,
 -59285,
 409593848,
 120119,
 -59284,
 409658560,
 120118,
 -59283,
 409723862,
 120117,
 -59282,
 409787866,
 120116,
 -59281,
 409852006,
 120115,
 -59280,
 409915118,
 120114,
 -59279,
 409977720,
 120113,
 -59278,
 410040240,
 120112,
 -59277,
 410102230,
 120111,
 -59276,
 410167238,
 120110,
 -59275,
 410230891,
 120109,
 -59274,
 410292722,
 120108,
 -59273,
 410356034,
 120107,
 -59272,
 410419272,
 120106,
 -59271,
 410481604,
 120105,
 -59270,
 410546422,
 120104,
 -59269,
 410611607,
 120103,
 -59268,
 410673639,
 120102,
 -59267,
 410736883,
 120101,
 -59266,
 410800939,
 120100,
 -59265,
 410865310,
 120099,
 -59264,
 410927271,
 120098,
 -59263,
 410990124,
 120097,
 -59262,
 411053315,
 120096,
 -59261,
 411117211,
 120095,
 -1,
 411178382,
 120094,
 411435007,
 409546242,
 -1,
 -59258,
 411362496,
 120092,
 -59257,
 411427798,
 120091,
 -59256,
 411491802,
 120090,
 -59255,
 411555942,
 120089,
 -59254,
 411619054,
 120088,
 -59253,
 411681656,
 120087,
 -59252,
 411744176,
 120086,
 -59251,
 411805638,
 120084,
 -59250,
 411869291,
 120083,
 -59249,
 411931122,
 120082,
 -59248,
 411994434,
 120081,
 -59247,
 412057672,
 120080,
 -59246,
 412120004,
 120079,
 -59245,
 412184822,
 120078,
 -59244,
 412250007,
 120077,
 -59243,
 412308267,
 120074,
 -59242,
 412372638,
 120073,
 -59241,
 412434599,
 120072,
 -59240,
 412497452,
 120071,
 -59239,
 412559003,
 120069,
 -1,
 412620174,
 120068,
 412817569,
 409513716,
 -1,
 412883102,
 412802945,
 -1,
 -59235,
 412863249,
 10221,
 -1,
 412925947,
 10215,
 -59233,
 412832117,
 10223,
 -59232,
 413023363,
 10219,
 -1,
 413081312,
 10217,
 413335551,
 412776182,
 -1,
 413341861,
 413261697,
 -1,
 -59228,
 413322001,
 10220,
 -1,
 413384699,
 10214,
 -59226,
 413290869,
 10222,
 -59225,
 413482115,
 10218,
 -1,
 413540064,
 10216,
 413735219,
 342389700,
 -1,
 413800748,
 413673068,
 -1,
 413866232,
 413760066,
 -1,
 413931702,
 413805827,
 -1,
 413997237,
 413882611,
 -1,
 414062772,
 413951676,
 -1,
 414128304,
 414026050,
 3451,
 -1,
 414091586,
 3450,
 414259378,
 414086084,
 3453,
 -1,
 414217156,
 3454,
 -59213,
 414234102,
 3452,
 -1,
 414347510,
 3455,
 -1,
 413996430,
 3355,
 -1,
 413930894,
 3354,
 414652605,
 413915238,
 -1,
 414718140,
 414618296,
 -1,
 414783674,
 414689750,
 3339,
 -1,
 414755286,
 3424,
 414973951,
 414741444,
 3340,
 -1,
 414872516,
 3425,
 -1,
 414651790,
 3381,
 415111363,
 414630776,
 -1,
 415176897,
 415089528,
 -1,
 -59200,
 415127825,
 3360,
 -1,
 415176078,
 3359,
 -59198,
 415127825,
 3365,
 -1,
 415307150,
 3364,
 415504584,
 415074626,
 -1,
 -59195,
 415491324,
 3358,
 -59194,
 415533470,
 3363,
 -59193,
 415585119,
 3353,
 -1,
 415634830,
 3368,
 415832270,
 415446572,
 -1,
 415897804,
 415774252,
 -1,
 -59189,
 415848721,
 3362,
 -1,
 415896974,
 3361,
 -59187,
 415848721,
 3367,
 -1,
 416028046,
 3366,
 416225490,
 415765902,
 3333,
 -59184,
 416206574,
 3348,
 -59183,
 416244199,
 3344,
 -1,
 416290190,
 3334,
 416487638,
 416200624,
 -1,
 -59180,
 416462890,
 3383,
 -59179,
 416504081,
 3382,
 -1,
 416552334,
 3384,
 416749787,
 416445380,
 -1,
 416815322,
 416707524,
 -1,
 -59175,
 416773145,
 3380,
 -1,
 416814478,
 3379,
 -1,
 416748942,
 3378,
 417077469,
 416730862,
 3337,
 -1,
 417058542,
 3338,
 417208544,
 417049046,
 -1,
 -59169,
 417180209,
 3377,
 -1,
 417207694,
 3376,
 417405155,
 417177707,
 -1,
 -59166,
 417356049,
 3371,
 -1,
 417404302,
 3370,
 417601765,
 417370610,
 3346,
 -1,
 417567218,
 3347,
 417732840,
 417558774,
 -1,
 -59161,
 417683729,
 3350,
 -1,
 417731982,
 3349,
 417929451,
 417689495,
 -1,
 -59158,
 417880337,
 3357,
 -1,
 417928590,
 3356,
 418126061,
 417882599,
 3335,
 -1,
 418079207,
 3336,
 418257136,
 418075435,
 -1,
 -59153,
 418208017,
 3352,
 -1,
 418256270,
 3351,
 418453746,
 418201767,
 3342,
 -1,
 418398375,
 3343,
 418584821,
 418391707,
 -1,
 -59148,
 418535697,
 3373,
 -1,
 418583950,
 3372,
 -59146,
 418571516,
 3375,
 -59145,
 418742421,
 3374,
 -1,
 418797841,
 3385,
 418978058,
 413851016,
 -1,
 419043582,
 418962657,
 -1,
 419109116,
 419015126,
 3395,
 -1,
 419080662,
 3396,
 419299327,
 419066820,
 3426,
 -1,
 419197892,
 3427,
 419371266,
 418977166,
 -1,
 -59136,
 419352302,
 3404,
 -59135,
 419389927,
 3400,
 -1,
 419435918,
 3390,
 419633412,
 419352302,
 3393,
 -1,
 419614446,
 3394,
 419764486,
 419598834,
 3402,
 -1,
 419729906,
 3403,
 419895560,
 419717607,
 3391,
 -1,
 419848679,
 3392,
 420085759,
 419840167,
 3398,
 -1,
 419971239,
 3399,
 420157722,
 418919980,
 -1,
 420223257,
 420111842,
 -1,
 420288783,
 420201336,
 -1,
 -59122,
 420274785,
 3432,
 -1,
 420307134,
 3433,
 420485394,
 420263856,
 -1,
 -59119,
 420441948,
 3436,
 -1,
 420498607,
 3437,
 420682005,
 420433566,
 -1,
 -59116,
 420650098,
 3434,
 -1,
 420703973,
 3435,
 -59114,
 420669551,
 3430,
 -59113,
 420845090,
 3431,
 -59112,
 420908319,
 3439,
 -1,
 420955479,
 3438,
 -1,
 420160710,
 3449,
 421206305,
 420134081,
 -1,
 421271838,
 421190711,
 -1,
 -59107,
 421247158,
 3331,
 -1,
 421309199,
 3405,
 421527551,
 421205390,
 -1,
 -59104,
 421451901,
 3389,
 -1,
 421499176,
 3330,
 421665062,
 421171362,
 -1,
 421730597,
 421631526,
 -1,
 -59100,
 421709761,
 3442,
 -1,
 421749119,
 3441,
 -1,
 421709258,
 3440,
 421992747,
 421614187,
 -1,
 422058282,
 421959206,
 -1,
 -59095,
 422029527,
 3443,
 -1,
 422074867,
 3444,
 -1,
 422037538,
 3445,
 -1,
 421930423,
 3415,
 422385970,
 413745321,
 -1,
 422451504,
 422371734,
 -1,
 -59089,
 422427836,
 9894,
 -1,
 422452699,
 9895,
 -59087,
 422427836,
 9794,
 -1,
 422583724,
 9893,
 -1,
 422364808,
 10016,
 422844794,
 413687448,
 -1,
 422910274,
 422819760,
 -1,
 422975802,
 422866787,
 -1,
 423041337,
 422915331,
 -1,
 -59080,
 422997168,
 127006,
 -1,
 423058184,
 126988,
 -1,
 422979407,
 126997,
 423303487,
 422923450,
 -1,
 423369022,
 423243011,
 -1,
 -59075,
 423324848,
 127007,
 -1,
 423385864,
 126989,
 -1,
 423307087,
 126998,
 -59072,
 423285357,
 127015,
 -59071,
 423601907,
 127014,
 -1,
 423664986,
 126977,
 423827789,
 422888312,
 -1,
 423893320,
 423813939,
 -1,
 423958855,
 423832835,
 -1,
 -59066,
 423914672,
 127002,
 -1,
 423975688,
 126984,
 -1,
 423896911,
 126993,
 424280063,
 423846201,
 -1,
 424286540,
 424160515,
 -1,
 -59061,
 424242352,
 127003,
 -1,
 424303368,
 126985,
 -1,
 424224591,
 126994,
 424548696,
 423775902,
 -1,
 424614227,
 424516814,
 -1,
 424679762,
 424553731,
 -1,
 -59055,
 424635568,
 127004,
 -1,
 424696584,
 126986,
 -1,
 424617807,
 126995,
 425000959,
 424570636,
 -1,
 425007447,
 424881411,
 -1,
 -59050,
 424963248,
 127005,
 -1,
 425024264,
 126987,
 -1,
 424945487,
 126996,
 425269599,
 424514034,
 -1,
 425335134,
 425233298,
 -1,
 425400669,
 425274627,
 -1,
 -59044,
 425356464,
 127001,
 -1,
 425417480,
 126983,
 -1,
 425338703,
 126992,
 -1,
 425307076,
 127011,
 425728358,
 425232706,
 -1,
 425793893,
 425683160,
 -1,
 425859428,
 425733379,
 -1,
 -59037,
 425815216,
 127009,
 -1,
 425876232,
 126991,
 -1,
 425797455,
 127000,
 -1,
 425761329,
 126979,
 426187117,
 425672871,
 -1,
 426252652,
 426141024,
 -1,
 426318187,
 426192131,
 -1,
 -59030,
 426273968,
 127008,
 -1,
 426334984,
 126990,
 -1,
 426256207,
 126999,
 -1,
 426189845,
 126976,
 426645873,
 426171866,
 -1,
 -59025,
 426601055,
 127017,
 -59024,
 426663536,
 126982,
 -1,
 426724148,
 126978,
 426908020,
 426583757,
 -1,
 -59021,
 426869607,
 127012,
 -1,
 426914116,
 127019,
 -59019,
 426880199,
 126980,
 -59018,
 427074761,
 127010,
 -59017,
 427126945,
 127018,
 -59016,
 427186233,
 126981,
 -59015,
 427241499,
 127013,
 -1,
 427304435,
 127016,
 427497853,
 422819760,
 -1,
 -59012,
 427478785,
 12348,
 -1,
 427505048,
 186,
 -59010,
 427472425,
 9901,
 -59009,
 427663534,
 9967,
 -1,
 427701306,
 175,
 427891552,
 342331890,
 -1,
 427956883,
 427832876,
 -1,
 428022417,
 427910339,
 -1,
 428087783,
 427997104,
 -1,
 428153313,
 428048769,
 -1,
 428218773,
 428131192,
 7511,
 428284306,
 428201640,
 -1,
 428349834,
 428217742,
 7492,
 -58999,
 428310339,
 7579,
 -1,
 428359847,
 7494,
 428546444,
 428321238,
 692,
 -1,
 428477833,
 693,
 428677518,
 428507208,
 7514,
 -1,
 428608988,
 7597,
 -58993,
 428660838,
 7610,
 -58992,
 428775361,
 7500,
 -58991,
 428827111,
 7502,
 -1,
 428890355,
 7587,
 -58989,
 428250993,
 7508,
 -58988,
 429022406,
 7615,
 -1,
 429067781,
 7605,
 429267359,
 428158211,
 7580,
 429332893,
 429203450,
 -1,
 429398426,
 429285863,
 7590,
 -58983,
 429363567,
 694,
 -1,
 429395570,
 7591,
 -58981,
 429379310,
 7608,
 -58980,
 429558082,
 7600,
 -1,
 429618116,
 7595,
 -58978,
 429284593,
 7521,
 -1,
 429722814,
 7581,
 429922725,
 429242288,
 738,
 429988259,
 429862147,
 -1,
 -58974,
 429962027,
 7586,
 -1,
 430006709,
 7498,
 -58972,
 429941869,
 7513,
 -1,
 430116233,
 7603,
 430315946,
 429867175,
 7497,
 -58969,
 430303403,
 7614,
 -58968,
 430360243,
 7582,
 -58967,
 430422692,
 7604,
 -1,
 430476314,
 7505,
 430643631,
 430265131,
 7501,
 430709166,
 430615842,
 -1,
 -58963,
 430679009,
 7520,
 -1,
 430724037,
 7518,
 -1,
 430644495,
 736,
 430971315,
 430581403,
 7495,
 -58959,
 430939041,
 7509,
 -58958,
 430984069,
 7517,
 -1,
 431039096,
 7601,
 431233463,
 430958584,
 7611,
 431357951,
 431164470,
 -1,
 -58954,
 431271348,
 7612,
 -1,
 431306161,
 7613,
 431495610,
 431214318,
 7512,
 -58951,
 431466323,
 7607,
 -1,
 431489568,
 7606,
 431692222,
 431466966,
 691,
 431816703,
 431639839,
 -1,
 -58947,
 431724481,
 7583,
 -1,
 431773266,
 740,
 431954370,
 431657458,
 7506,
 432078847,
 431923844,
 -1,
 -58943,
 431985138,
 7507,
 -1,
 432029863,
 7499,
 432216518,
 431911876,
 737,
 432340991,
 432147510,
 -1,
 -58939,
 432254388,
 7593,
 -1,
 432316705,
 7594,
 432478665,
 432158252,
 7496,
 -58936,
 432446332,
 7585,
 -1,
 432490056,
 7519,
 432675276,
 432412046,
 7491,
 -58933,
 432635715,
 7493,
 -1,
 432695192,
 7516,
 432871886,
 432658534,
 7515,
 -1,
 432803209,
 7609,
 433002960,
 432840811,
 7510,
 -1,
 432954609,
 7602,
 433134035,
 432965998,
 -1,
 -58926,
 433106356,
 7599,
 -1,
 433158067,
 7598,
 433330645,
 433094728,
 7504,
 -1,
 433261961,
 7596,
 433461719,
 433287063,
 690,
 -1,
 433392811,
 7592,
 433592794,
 433414631,
 -1,
 -58919,
 433560328,
 7589,
 -1,
 433589874,
 7588,
 433789404,
 433543411,
 688,
 -1,
 433720713,
 689,
 -58915,
 433775808,
 696,
 -58914,
 433906646,
 739,
 -58913,
 433970650,
 695,
 -58912,
 434008310,
 7503,
 -1,
 434065054,
 7584,
 434248164,
 428133235,
 -1,
 -58909,
 434208436,
 42785,
 -1,
 434265497,
 42784,
 434503679,
 434198771,
 -1,
 -58906,
 434412065,
 42890,
 -1,
 434456076,
 765,
 434641428,
 428027139,
 -1,
 434706946,
 434577402,
 -1,
 434772461,
 434678230,
 7487,
 434896895,
 434720031,
 -1,
 -58900,
 434800962,
 7483,
 -1,
 434847911,
 7474,
 435034607,
 434737650,
 7484,
 -1,
 435015406,
 7485,
 435165681,
 434972315,
 7470,
 -1,
 435102320,
 7471,
 435296755,
 435099022,
 7468,
 -1,
 435241127,
 7469,
 -58892,
 435281370,
 7490,
 -58891,
 435411046,
 11389,
 -58890,
 435474158,
 7489,
 -58889,
 435536760,
 7488,
 -58888,
 435593323,
 7486,
 -58887,
 435652930,
 7482,
 -58886,
 435716168,
 7481,
 -58885,
 435778500,
 7480,
 -58884,
 435843318,
 7479,
 -58883,
 435908503,
 7478,
 -58882,
 435970535,
 7477,
 -58881,
 436033779,
 7476,
 -58880,
 436097835,
 7475,
 -58879,
 436158631,
 7473,
 -1,
 436221484,
 7472,
 436410893,
 434658807,
 -1,
 436476424,
 436365211,
 -1,
 -58875,
 436452147,
 42754,
 -58874,
 436516603,
 42758,
 -58873,
 436578371,
 42756,
 -1,
 436642871,
 42752,
 436862975,
 436412041,
 -1,
 -58870,
 436779827,
 42755,
 -58869,
 436844283,
 42759,
 -58868,
 436906051,
 42757,
 -1,
 436970551,
 42753,
 437131792,
 436357223,
 -1,
 -58865,
 437104596,
 722,
 -1,
 437155724,
 723,
 -58863,
 437118883,
 7544,
 -58862,
 437302557,
 735,
 -58861,
 437359876,
 42889,
 -1,
 437415105,
 710,
 437590577,
 434598852,
 -1,
 437656110,
 437559151,
 -1,
 437721645,
 437583872,
 -1,
 437787163,
 437679857,
 -1,
 437852698,
 437715450,
 767,
 -1,
 437803934,
 753,
 -1,
 437784957,
 42773,
 438049312,
 437730000,
 -1,
 438114847,
 438029510,
 -1,
 -58850,
 438094432,
 42763,
 -1,
 438139032,
 42768,
 -1,
 438100528,
 751,
 438376995,
 438027128,
 -1,
 -58846,
 438343211,
 744,
 -1,
 438396519,
 759,
 438573606,
 438349446,
 -1,
 -58843,
 438537242,
 755,
 -1,
 438588733,
 754,
 -58841,
 438557617,
 716,
 -58840,
 438752210,
 752,
 -58839,
 438796446,
 717,
 -58838,
 438856577,
 42783,
 -58837,
 438916915,
 718,
 -58836,
 438972656,
 42888,
 -1,
 439031756,
 719,
 -1,
 437668230,
 42778,
 439353343,
 437601214,
 -1,
 -58832,
 439245372,
 703,
 -1,
 439296711,
 706,
 439491139,
 437534887,
 -1,
 439556672,
 439477430,
 -1,
 439622202,
 439508311,
 -1,
 439687735,
 439565319,
 -1,
 -58826,
 439667296,
 42760,
 -1,
 439711896,
 42765,
 -58824,
 439667296,
 741,
 -58823,
 439842968,
 42770,
 -1,
 439897702,
 983945,
 440139775,
 439582342,
 -1,
 440146494,
 440024071,
 -1,
 -58819,
 440126048,
 42764,
 -1,
 440170648,
 42769,
 -58817,
 440126048,
 745,
 -1,
 440301720,
 42774,
 440532991,
 439519939,
 -1,
 -58814,
 440434356,
 764,
 -1,
 440491417,
 762,
 440670801,
 439462358,
 -1,
 440736330,
 440605091,
 -1,
 -58810,
 440718281,
 42779,
 -58809,
 440757121,
 42782,
 -58808,
 440815015,
 42781,
 -58807,
 440876664,
 42780,
 -1,
 440939032,
 760,
 441129549,
 440690000,
 -1,
 -58804,
 441080380,
 702,
 -1,
 441131719,
 707,
 441326160,
 441077023,
 -1,
 -58801,
 441275986,
 705,
 -1,
 441332284,
 701,
 -1,
 441278562,
 734,
 441588321,
 440631368,
 -1,
 441653856,
 441541095,
 -1,
 441719391,
 441595436,
 -1,
 441784922,
 441647104,
 -1,
 441850456,
 441728007,
 -1,
 -58793,
 441829984,
 42762,
 -1,
 441874584,
 42767,
 -58791,
 441829984,
 743,
 -1,
 442005656,
 42772,
 442236927,
 441727679,
 -1,
 442243678,
 442121327,
 -1,
 -58787,
 442193715,
 757,
 -1,
 442243020,
 758,
 -1,
 442193715,
 756,
 -1,
 441684255,
 727,
 -1,
 441587636,
 713,
 442636908,
 441531088,
 -1,
 442702438,
 442614650,
 -1,
 -58780,
 442686234,
 42775,
 -58779,
 442744346,
 42776,
 -1,
 442785600,
 42777,
 442964585,
 442688035,
 -1,
 -58776,
 442942461,
 725,
 -1,
 442966727,
 709,
 443219967,
 442945485,
 -1,
 -58773,
 443131629,
 698,
 -1,
 443162687,
 750,
 443357812,
 442587379,
 -1,
 443423347,
 443311420,
 -1,
 443488881,
 443366407,
 -1,
 -58768,
 443468384,
 42761,
 -1,
 443512984,
 42766,
 -58766,
 443468384,
 742,
 -1,
 443644056,
 42771,
 -1,
 443358088,
 721,
 443882106,
 443338478,
 -1,
 443947640,
 443850861,
 -1,
 -58761,
 443925501,
 724,
 -1,
 443949767,
 708,
 -58759,
 443922352,
 42864,
 -1,
 444107310,
 749,
 444275326,
 443831083,
 -1,
 -58756,
 444246923,
 715,
 -58755,
 444300907,
 704,
 -1,
 444352675,
 4348,
 444537473,
 444261568,
 -1,
 -58752,
 444491699,
 746,
 -1,
 444538510,
 747,
 444734084,
 444520550,
 -1,
 -58749,
 444699637,
 748,
 -1,
 444746317,
 712,
 444930695,
 444711800,
 -1,
 -58746,
 444913327,
 699,
 -1,
 444968636,
 720,
 445127306,
 444899435,
 -1,
 -58743,
 445100588,
 697,
 -1,
 445153241,
 726,
 445323917,
 445065303,
 -1,
 -58740,
 445284020,
 763,
 -1,
 445341081,
 761,
 445520528,
 445257102,
 -1,
 -58737,
 445490674,
 700,
 -1,
 445527559,
 714,
 -1,
 445487055,
 766,
 -58734,
 428003792,
 10762,
 -1,
 445728309,
 8871,
 445913951,
 427919682,
 -1,
 445979480,
 445863578,
 -1,
 446044982,
 445938242,
 -1,
 446110395,
 446022520,
 -1,
 446175929,
 446075699,
 -1,
 446241437,
 446109070,
 -1,
 446306972,
 446200539,
 -1,
 -58725,
 446294201,
 6297,
 -1,
 446350265,
 6296,
 -1,
 446270490,
 6218,
 446569119,
 446222062,
 6215,
 -1,
 446513319,
 6217,
 446700194,
 446546808,
 -1,
 -58719,
 446674986,
 6228,
 -1,
 446698894,
 6224,
 446896804,
 446665202,
 6214,
 -1,
 446840999,
 6216,
 447027879,
 446853015,
 -1,
 -58714,
 446980718,
 6234,
 -1,
 447026574,
 6227,
 447224489,
 446976863,
 6222,
 -1,
 447157646,
 6232,
 447355564,
 447165996,
 -1,
 -58709,
 447342602,
 6236,
 -1,
 447354254,
 6225,
 -58707,
 447341820,
 6229,
 -58706,
 447536642,
 6230,
 -58705,
 447588300,
 6221,
 -58704,
 447652048,
 6220,
 -58703,
 447712482,
 6235,
 -58702,
 447774869,
 6223,
 -58701,
 447839709,
 6211,
 -58700,
 447901965,
 6231,
 -58699,
 447963623,
 6213,
 -58698,
 448026900,
 6233,
 -58697,
 448086183,
 6212,
 -58696,
 448147278,
 6226,
 -1,
 448210637,
 6219,
 -58694,
 446150698,
 6204,
 -1,
 448337294,
 6194,
 448535264,
 446043534,
 6176,
 448600799,
 448494299,
 -1,
 448666307,
 448578424,
 -1,
 448731841,
 448643960,
 -1,
 -58688,
 448682257,
 6285,
 -1,
 448730510,
 6284,
 -58686,
 448684244,
 6278,
 -1,
 448861582,
 6288,
 449059528,
 448607788,
 -1,
 449125063,
 448992654,
 6289,
 -58682,
 449086195,
 6274,
 -1,
 449139624,
 6313,
 -1,
 449066647,
 6286,
 449387211,
 448992654,
 6279,
 -58678,
 449351993,
 6272,
 -1,
 449403123,
 6295,
 449583822,
 449374200,
 -1,
 -58675,
 449534225,
 6293,
 -1,
 449582478,
 6294,
 449780433,
 449552491,
 -1,
 -58672,
 449730833,
 6291,
 -1,
 449779086,
 6290,
 449977044,
 449743170,
 -1,
 -58669,
 449939870,
 6287,
 -1,
 449991519,
 6282,
 450173654,
 449929703,
 6280,
 -1,
 450138489,
 6276,
 450304729,
 450124280,
 -1,
 -58664,
 450290940,
 6311,
 -1,
 450350830,
 6310,
 -58662,
 450288824,
 6273,
 -58661,
 450482069,
 6275,
 -58660,
 450543709,
 6292,
 -58659,
 450588941,
 6281,
 -58658,
 450637152,
 6283,
 -1,
 450701128,
 6277,
 -1,
 448564250,
 6185,
 450960124,
 448509872,
 -1,
 451025658,
 450913084,
 -1,
 451091173,
 451012600,
 -1,
 -58652,
 451041553,
 6258,
 -1,
 451089806,
 6255,
 451287783,
 451071726,
 6241,
 -1,
 451231911,
 6240,
 451418858,
 451265400,
 -1,
 -58647,
 451393578,
 6254,
 -1,
 451417486,
 6248,
 451615468,
 451371495,
 6238,
 -1,
 451601600,
 6239,
 451746542,
 451565841,
 6245,
 -1,
 451679630,
 6253,
 451877616,
 451695455,
 6244,
 -1,
 451810702,
 6252,
 -58639,
 451853027,
 6247,
 -58638,
 451979844,
 6256,
 -58637,
 452042960,
 6246,
 -58636,
 452096269,
 6243,
 -58635,
 452161433,
 6250,
 -58634,
 452218631,
 6251,
 -58633,
 452280487,
 6237,
 -58632,
 452343447,
 6249,
 -58631,
 452407118,
 6257,
 -1,
 452468357,
 6242,
 -58629,
 450976017,
 6193,
 -1,
 452597134,
 6192,
 452795158,
 450920597,
 6190,
 452919295,
 452758168,
 -1,
 452926225,
 452795317,
 -1,
 452991746,
 452913144,
 -1,
 -58623,
 452942097,
 6308,
 -1,
 452990350,
 6309,
 453188357,
 452969336,
 -1,
 -58620,
 453166009,
 6302,
 -1,
 453186958,
 6304,
 453384968,
 453129772,
 -1,
 -58617,
 453335313,
 6305,
 -1,
 453392513,
 6303,
 453581579,
 453324035,
 -1,
 -58614,
 453567740,
 6307,
 -1,
 453580174,
 6300,
 -58612,
 453558365,
 6306,
 -58611,
 453741645,
 6299,
 -58610,
 453802697,
 6314,
 -58609,
 453865576,
 6301,
 -58608,
 453924121,
 6298,
 -1,
 453978466,
 6312,
 -58606,
 452913337,
 6263,
 -58605,
 454142513,
 6261,
 -58604,
 454193421,
 6260,
 -58603,
 454255079,
 6259,
 -1,
 454315783,
 6262,
 454499098,
 452782072,
 -1,
 -58600,
 454470193,
 6207,
 -58599,
 454515953,
 6209,
 -1,
 454563214,
 6205,
 454761244,
 454479598,
 6180,
 -1,
 454705319,
 6182,
 454892318,
 454726130,
 6179,
 -1,
 454836391,
 6181,
 455023393,
 454849476,
 -1,
 -58592,
 454973713,
 6208,
 -1,
 455021966,
 6191,
 455220004,
 454979830,
 -1,
 -58589,
 455170321,
 6203,
 -1,
 455218574,
 6202,
 455416614,
 455164071,
 6177,
 -1,
 455360679,
 6183,
 455547689,
 455356231,
 -1,
 -58584,
 455500263,
 6210,
 -1,
 455546254,
 6196,
 -58582,
 455533820,
 6198,
 -58581,
 455728642,
 6200,
 -58580,
 455780913,
 6199,
 -58579,
 455845836,
 6188,
 -58578,
 455909584,
 6187,
 -58577,
 455969182,
 6184,
 -58576,
 456028057,
 6197,
 -58575,
 456090087,
 6178,
 -58574,
 456153364,
 6206,
 -58573,
 456217439,
 6189,
 -58572,
 456281863,
 6201,
 -58571,
 456341143,
 6195,
 -1,
 456402637,
 6186,
 456596292,
 445987236,
 -1,
 456661818,
 456573816,
 -1,
 -58567,
 456647265,
 6162,
 -1,
 456679614,
 6163,
 456858429,
 456636336,
 -1,
 -58564,
 456814428,
 6166,
 -1,
 456871087,
 6167,
 457055040,
 456806046,
 -1,
 -58561,
 457022578,
 6164,
 -1,
 457076453,
 6165,
 -58559,
 457042031,
 6160,
 -58558,
 457217570,
 6161,
 -58557,
 457280799,
 6169,
 -1,
 457327959,
 6168,
 457513804,
 456543902,
 -1,
 457579338,
 457485563,
 -1,
 457644873,
 457556856,
 -1,
 -58552,
 457630305,
 6156,
 -1,
 457662654,
 6157,
 -1,
 457610786,
 6155,
 -58549,
 457560510,
 6147,
 -1,
 457874575,
 6149,
 458038095,
 457474658,
 -1,
 -58546,
 457986826,
 6153,
 -1,
 458043964,
 6152,
 458234706,
 457978380,
 -1,
 -58543,
 458196570,
 6146,
 -1,
 458259829,
 6148,
 -58541,
 458218856,
 6158,
 -58540,
 458410536,
 6150,
 -58539,
 458472560,
 6151,
 -58538,
 458526039,
 6154,
 -58537,
 458573340,
 6145,
 -1,
 458631648,
 6144,
 458883071,
 445944306,
 -1,
 458890078,
 458774258,
 -1,
 458955613,
 458876096,
 -1,
 -58532,
 458909592,
 9867,
 -1,
 458956421,
 9866,
 -1,
 458899844,
 119552,
 -1,
 458866895,
 9101,
 -1,
 445895569,
 9968,
 459349190,
 427871982,
 -1,
 459414705,
 459324558,
 -1,
 459480237,
 459348543,
 -1,
 459545503,
 459418883,
 -1,
 459611025,
 459510258,
 -1,
 459676560,
 459571272,
 -1,
 459742095,
 459614639,
 -1,
 459807600,
 459716528,
 -1,
 459873133,
 459785080,
 -1,
 459938668,
 459806542,
 -1,
 -58517,
 459903474,
 119164,
 -1,
 459959759,
 119166,
 -1,
 459884138,
 119141,
 -58514,
 459843249,
 119142,
 -58513,
 460163588,
 119213,
 -1,
 460227509,
 119176,
 460397432,
 459755835,
 -1,
 460462967,
 460331195,
 -1,
 -58509,
 460395555,
 119154,
 -58508,
 460461014,
 119153,
 -58507,
 460526438,
 119152,
 -58506,
 460591809,
 119151,
 -1,
 460657193,
 119150,
 -1,
 460418088,
 119175,
 460921728,
 460374904,
 -1,
 460987263,
 460892630,
 -1,
 461052798,
 460932843,
 -1,
 -58500,
 460985190,
 119145,
 -58499,
 461050561,
 119144,
 -1,
 461115945,
 119143,
 -1,
 461007939,
 119179,
 -1,
 460933257,
 119165,
 461446020,
 460864208,
 -1,
 -58494,
 461431357,
 119210,
 -58493,
 461492250,
 119178,
 -1,
 461532653,
 119173,
 461708168,
 461378958,
 -1,
 461773703,
 461647505,
 119163,
 -1,
 461705587,
 119169,
 -1,
 461754589,
 119149,
 461970314,
 461669036,
 119167,
 -1,
 461902195,
 119168,
 -58485,
 461951986,
 119211,
 -58484,
 462074543,
 119174,
 -58483,
 462126711,
 119170,
 -58482,
 462183186,
 119212,
 -1,
 462235801,
 119177,
 -1,
 459704084,
 119092,
 -1,
 459617943,
 119052,
 462560152,
 459568068,
 -1,
 462625685,
 462542734,
 -1,
 -58476,
 462610299,
 119130,
 -1,
 462629403,
 119131,
 462880767,
 462578151,
 -1,
 -58473,
 462806179,
 119253,
 -1,
 462848165,
 119255,
 463018907,
 462531030,
 -1,
 -58470,
 462984257,
 119247,
 -1,
 463030939,
 119186,
 -58468,
 463001556,
 119093,
 -58467,
 463170711,
 119109,
 -58466,
 463214739,
 119059,
 -1,
 463274669,
 119073,
 463477709,
 459522936,
 -1,
 463543221,
 463448534,
 119190,
 463667199,
 463495900,
 -1,
 463674290,
 463537717,
 -1,
 463739817,
 463655851,
 -1,
 463805351,
 463711988,
 -1,
 -58458,
 463789947,
 119120,
 -1,
 463809051,
 119121,
 -58456,
 463789947,
 119112,
 -1,
 463940123,
 119113,
 464133036,
 463711988,
 -1,
 -58453,
 464117627,
 119116,
 -1,
 464136731,
 119117,
 464329647,
 464090870,
 -1,
 -58450,
 464314235,
 119114,
 -1,
 464333339,
 119115,
 464584703,
 464272980,
 -1,
 -58447,
 464510843,
 119118,
 -1,
 464529947,
 119119,
 464781311,
 463606057,
 -1,
 -58444,
 464707451,
 119124,
 -1,
 464726555,
 119125,
 464919489,
 463488778,
 -1,
 464985021,
 464873340,
 -1,
 465050556,
 464938849,
 119243,
 465174527,
 464978762,
 -1,
 -58438,
 465048422,
 119246,
 -58437,
 465113793,
 119245,
 -1,
 465179177,
 119244,
 -1,
 465019643,
 119242,
 465502207,
 464954130,
 -1,
 465509312,
 465412859,
 119239,
 -1,
 465437527,
 119241,
 -1,
 465463137,
 119240,
 465705925,
 464901796,
 119191,
 465829887,
 465633280,
 -1,
 -58428,
 465753000,
 119194,
 -1,
 465813018,
 119193,
 465968074,
 465656051,
 -1,
 466033609,
 465923401,
 -1,
 -58424,
 466005423,
 119104,
 -1,
 466063115,
 119138,
 -1,
 466005267,
 119064,
 466295756,
 465934588,
 119256,
 -1,
 466225627,
 119260,
 -1,
 466281311,
 119063,
 466492403,
 463452080,
 -1,
 466557915,
 466444775,
 -1,
 466623450,
 466543574,
 -1,
 466688983,
 466600824,
 -1,
 466754516,
 466674926,
 -1,
 -58413,
 466726319,
 119105,
 -1,
 466784011,
 119139,
 467009535,
 466699135,
 -1,
 -58410,
 466922927,
 119103,
 -1,
 466980619,
 119137,
 467206143,
 466620134,
 -1,
 -58407,
 467124613,
 119068,
 -1,
 467172280,
 119067,
 -1,
 466586733,
 119040,
 467409894,
 466501799,
 -1,
 467475429,
 467371252,
 -1,
 467540961,
 467437051,
 -1,
 -58401,
 467525499,
 119229,
 -58400,
 467578287,
 119238,
 -1,
 467610139,
 119230,
 467861503,
 467479552,
 -1,
 -58397,
 467787643,
 119225,
 -58396,
 467840431,
 119236,
 -1,
 467872283,
 119226,
 -1,
 467424897,
 119051,
 468130795,
 467380391,
 -1,
 468196330,
 468094736,
 -1,
 -58391,
 468180859,
 119110,
 -1,
 468199963,
 119111,
 -1,
 468133531,
 119250,
 468458480,
 468080883,
 -1,
 468524015,
 468394591,
 -1,
 -58386,
 468505512,
 119088,
 -1,
 468532815,
 119089,
 -1,
 468490773,
 119045,
 468786162,
 468397492,
 119254,
 -1,
 468714445,
 119259,
 -1,
 468766641,
 119181,
 468982797,
 466439838,
 -1,
 469048316,
 468935143,
 -1,
 469113851,
 469010754,
 -1,
 469179386,
 469062871,
 -1,
 -58376,
 469111654,
 119148,
 -58375,
 469177025,
 119147,
 -1,
 469242409,
 119146,
 -1,
 469113372,
 119042,
 -1,
 469096934,
 119066,
 469572609,
 469012978,
 -1,
 469638144,
 469554759,
 -1,
 -58369,
 469614981,
 119069,
 -1,
 469662648,
 119065,
 -1,
 469612219,
 119185,
 469900293,
 469500589,
 119074,
 470024191,
 469829370,
 -1,
 -58364,
 469903356,
 119076,
 -1,
 469965944,
 119075,
 470162440,
 469882662,
 -1,
 -58361,
 470146939,
 119231,
 -1,
 470166043,
 119232,
 470359051,
 470119945,
 -1,
 -58358,
 470340520,
 119084,
 -1,
 470367823,
 119085,
 470614015,
 470305305,
 119056,
 -1,
 470483507,
 119057,
 470686754,
 468947442,
 -1,
 470752282,
 470660154,
 -1,
 470817810,
 470684201,
 119195,
 -58351,
 470749737,
 119205,
 -1,
 470815145,
 119204,
 -58349,
 470750555,
 119203,
 -58348,
 470947111,
 119202,
 -58347,
 471012576,
 119201,
 -58346,
 471078043,
 119200,
 -58345,
 471143459,
 119199,
 -58344,
 471208918,
 119198,
 -58343,
 471274342,
 119197,
 -1,
 471339713,
 119196,
 471538719,
 470715238,
 -1,
 471604254,
 471467135,
 -1,
 -58339,
 471575983,
 119106,
 -1,
 471633675,
 119140,
 -1,
 471535725,
 119062,
 471924735,
 471518399,
 -1,
 -58335,
 471803900,
 119095,
 -1,
 471866488,
 119094,
 472063027,
 470627884,
 -1,
 472128553,
 471995790,
 -1,
 472194086,
 472090571,
 119220,
 -1,
 472121411,
 119221,
 -58329,
 472169335,
 119044,
 -58328,
 472282078,
 119049,
 -1,
 472318591,
 119050,
 472521773,
 472095670,
 -1,
 -58325,
 472496970,
 119082,
 -58324,
 472535364,
 119083,
 -1,
 472590283,
 119041,
 472783920,
 472495906,
 -1,
 -58321,
 472715969,
 119078,
 -1,
 472781353,
 119077,
 473038847,
 472727719,
 -1,
 -58318,
 472930314,
 119209,
 -1,
 472986608,
 119187,
 473177155,
 472000155,
 -1,
 473242686,
 473147862,
 -1,
 473308219,
 473186471,
 -1,
 473373754,
 473290854,
 -1,
 473439289,
 473328986,
 119224,
 -1,
 473369045,
 119235,
 -1,
 473383079,
 119132,
 -1,
 473310435,
 119058,
 473759743,
 473241419,
 -1,
 -58307,
 473657946,
 119061,
 -1,
 473710759,
 119060,
 473956351,
 473187537,
 -1,
 -58304,
 473876611,
 119157,
 -58303,
 473939488,
 119159,
 -58302,
 473998329,
 119161,
 -1,
 474032199,
 119155,
 474225744,
 473145451,
 -1,
 474291272,
 474190322,
 -1,
 474356807,
 474265087,
 119257,
 -1,
 474285005,
 119258,
 -1,
 474298170,
 119252,
 474553421,
 474235047,
 -1,
 474618956,
 474494680,
 -1,
 -58293,
 474600569,
 119215,
 -1,
 474645181,
 119214,
 -1,
 474593306,
 119261,
 -58290,
 474513356,
 119108,
 -58289,
 474833701,
 119183,
 -1,
 474882452,
 119126,
 475077725,
 474185800,
 -1,
 475143253,
 475031952,
 119227,
 475267071,
 475070464,
 -1,
 -58284,
 475180463,
 119237,
 -1,
 475212315,
 119228,
 475405400,
 475124188,
 -1,
 -58281,
 475374739,
 119081,
 -1,
 475400661,
 119098,
 475602011,
 475371322,
 -1,
 -58278,
 475586427,
 119122,
 -1,
 475605531,
 119123,
 -58276,
 475549337,
 119184,
 -1,
 475735631,
 119222,
 475929708,
 475026219,
 -1,
 475995237,
 475900374,
 -1,
 476060770,
 475940072,
 -1,
 -58271,
 476008096,
 119249,
 -1,
 476065033,
 119248,
 476315647,
 475993959,
 -1,
 -58268,
 476233242,
 119188,
 -1,
 476286452,
 119189,
 476453993,
 475923117,
 119070,
 476577791,
 476382970,
 -1,
 -58264,
 476456956,
 119072,
 -1,
 476519544,
 119071,
 476774399,
 476412960,
 -1,
 -58261,
 476697512,
 119217,
 -1,
 476724815,
 119218,
 476912760,
 475900374,
 -1,
 476978293,
 476856487,
 -1,
 477043828,
 476947003,
 -1,
 477109363,
 476988112,
 -1,
 -58255,
 477041510,
 119055,
 -58254,
 477106881,
 119054,
 -1,
 477172265,
 119053,
 -1,
 477037448,
 119048,
 -1,
 477027025,
 119043,
 477560831,
 476930535,
 -1,
 -58249,
 477465616,
 119180,
 -1,
 477517180,
 119047,
 477699202,
 476856487,
 -1,
 477764735,
 477661891,
 -1,
 -58245,
 477743235,
 119158,
 -58244,
 477806112,
 119160,
 -58243,
 477864953,
 119162,
 -58242,
 477926258,
 119208,
 -1,
 477964359,
 119156,
 478216191,
 477717891,
 -1,
 -58239,
 478129583,
 119102,
 -1,
 478187275,
 119136,
 478354572,
 477669443,
 -1,
 478420105,
 478290666,
 -1,
 478485639,
 478399066,
 -1,
 -58234,
 478460746,
 119090,
 -1,
 478499140,
 119091,
 -58232,
 478457263,
 119101,
 -1,
 478646027,
 119135,
 478871551,
 478374028,
 -1,
 -58229,
 478750716,
 119097,
 -1,
 478813304,
 119096,
 479009939,
 478316866,
 -1,
 479075472,
 478946732,
 -1,
 -58225,
 479056808,
 119086,
 -1,
 479084111,
 119087,
 -58223,
 479056305,
 119129,
 -58222,
 479238950,
 119128,
 -1,
 479281707,
 119207,
 479468697,
 478966724,
 -1,
 479534232,
 479434416,
 119223,
 479657983,
 479461376,
 -1,
 -58217,
 479568644,
 119233,
 -1,
 479618924,
 119234,
 -1,
 479478814,
 119046,
 479861919,
 479418641,
 -1,
 479927454,
 479820449,
 -1,
 -58212,
 479899055,
 119100,
 -58211,
 479961679,
 119216,
 -1,
 480022283,
 119134,
 -1,
 479909283,
 119206,
 480255140,
 479845850,
 -1,
 480320675,
 480206594,
 -1,
 -58206,
 480292271,
 119099,
 -1,
 480349963,
 119133,
 -1,
 480276039,
 119219,
 480582823,
 480237670,
 -1,
 -58202,
 480547836,
 119127,
 -1,
 480603380,
 119251,
 480779434,
 480518756,
 -1,
 -58199,
 480760744,
 119171,
 -1,
 480788047,
 119172,
 -58197,
 480765944,
 119182,
 -58196,
 480961511,
 119107,
 -1,
 480996333,
 119192,
 481230847,
 459407360,
 -1,
 -58193,
 481147728,
 9839,
 -58192,
 481200703,
 9838,
 -1,
 481251657,
 9837,
 481434819,
 459374452,
 -1,
 481500350,
 481404072,
 -1,
 481565885,
 481475772,
 215,
 481689599,
 481492992,
 -1,
 481696954,
 481585051,
 -1,
 -58185,
 481676190,
 10811,
 -58184,
 481734594,
 10805,
 -58183,
 481785723,
 10804,
 -1,
 481836269,
 10807,
 482082815,
 481681476,
 -1,
 -58180,
 482005755,
 10801,
 -1,
 482032445,
 10800,
 -1,
 481551318,
 10005,
 482286786,
 481475174,
 8844,
 482410495,
 482213888,
 -1,
 -58175,
 482333475,
 8846,
 -1,
 482379869,
 8845,
 -1,
 482247320,
 8888,
 482672639,
 481374026,
 -1,
 -58171,
 482572727,
 8810,
 -1,
 482629471,
 8811,
 482811339,
 459334984,
 -1,
 482876748,
 482767812,
 -1,
 482942280,
 482823264,
 -1,
 483007719,
 482898166,
 -1,
 483073254,
 482957585,
 4097,
 483196927,
 483035151,
 -1,
 483204305,
 483079724,
 -1,
 483269840,
 483145260,
 -1,
 -58161,
 483219729,
 43625,
 -1,
 483267982,
 43624,
 -1,
 483219729,
 43626,
 483531988,
 483183804,
 -1,
 -58157,
 483481873,
 43623,
 -1,
 483530126,
 43622,
 483728599,
 483494210,
 -1,
 -58154,
 483714300,
 43621,
 -1,
 483726734,
 43627,
 483925210,
 483684247,
 -1,
 -58151,
 483875089,
 43620,
 -1,
 483923342,
 43619,
 484121821,
 483875059,
 -1,
 -58148,
 484071697,
 43630,
 -1,
 484119950,
 43629,
 484318432,
 484060419,
 -1,
 -58145,
 484268305,
 43618,
 -1,
 484316558,
 43617,
 -58143,
 484304906,
 43634,
 -58142,
 484500470,
 43633,
 -58141,
 484554794,
 43628,
 -58140,
 484616753,
 43635,
 -58139,
 484660063,
 43616,
 -1,
 484724487,
 43631,
 -1,
 483005838,
 4096,
 484973821,
 482981808,
 -1,
 485039354,
 484923665,
 4176,
 485163007,
 485001540,
 -1,
 485170413,
 485067074,
 -1,
 -58132,
 485156092,
 4218,
 -1,
 485168526,
 4220,
 485367024,
 485126390,
 -1,
 -58129,
 485316881,
 4214,
 -1,
 485365134,
 4213,
 -58127,
 485353482,
 4217,
 -58126,
 485541578,
 4224,
 -58125,
 485598132,
 4221,
 -58124,
 485644561,
 4225,
 -58123,
 485708639,
 4215,
 -58122,
 485773063,
 4222,
 -58121,
 485832343,
 4219,
 -58120,
 485895520,
 4216,
 -58119,
 485959373,
 4223,
 -1,
 486020494,
 4130,
 -58117,
 485013546,
 4177,
 -58116,
 486167612,
 4193,
 -1,
 486217102,
 4126,
 486415622,
 484933704,
 -1,
 486481157,
 486380947,
 -1,
 486546690,
 486418455,
 -1,
 -58111,
 486490279,
 4189,
 -1,
 486544782,
 4188,
 -58109,
 486509645,
 4186,
 -58108,
 486699112,
 4187,
 -1,
 486752423,
 4136,
 -1,
 486413710,
 4121,
 487005453,
 486377794,
 -1,
 487070986,
 486967618,
 -1,
 -58103,
 487056636,
 4106,
 -1,
 487069070,
 4111,
 -58101,
 487056636,
 4105,
 -58100,
 487215967,
 4100,
 -1,
 487265678,
 4116,
 487464210,
 486989025,
 -1,
 487529744,
 487434710,
 4178,
 -1,
 487500246,
 4179,
 487718911,
 487486404,
 4180,
 -1,
 487617476,
 4181,
 487791896,
 487441272,
 -1,
 487857430,
 487768952,
 -1,
 -58091,
 487807249,
 4108,
 -1,
 487855502,
 4107,
 -58089,
 487807249,
 4113,
 -1,
 487986574,
 4112,
 488185117,
 487735463,
 4135,
 488308735,
 488121423,
 -1,
 -58085,
 488237014,
 4207,
 -58084,
 488279520,
 4206,
 -1,
 488330695,
 4208,
 488512803,
 488125996,
 -1,
 488578337,
 488453676,
 -1,
 -58080,
 488528145,
 4110,
 -1,
 488576398,
 4109,
 -58078,
 488528145,
 4115,
 -1,
 488707470,
 4114,
 488906024,
 488496602,
 -1,
 488971559,
 488852285,
 -1,
 -58074,
 488949450,
 4197,
 -1,
 489007039,
 4198,
 -1,
 488904078,
 4125,
 489233708,
 488854315,
 -1,
 -58070,
 489204770,
 4159,
 -58069,
 489249041,
 4099,
 -1,
 489297294,
 4098,
 489495855,
 489166222,
 4129,
 -58066,
 489475822,
 4138,
 -1,
 489516709,
 43642,
 489692465,
 489475822,
 4133,
 -1,
 489672430,
 4134,
 489823540,
 489662934,
 -1,
 -58061,
 489804335,
 4238,
 -1,
 489821582,
 4123,
 490020151,
 489791595,
 -1,
 -58058,
 489969937,
 4118,
 -1,
 490018190,
 4117,
 490216762,
 489976772,
 -1,
 -58055,
 490173465,
 4128,
 -1,
 490214798,
 4124,
 490413373,
 490172311,
 -1,
 -58052,
 490363153,
 4104,
 -1,
 490411406,
 4103,
 490609983,
 490365415,
 4131,
 -1,
 490562023,
 4132,
 490741058,
 490548483,
 -1,
 -58047,
 490690833,
 4102,
 -1,
 490739086,
 4101,
 490937669,
 490677915,
 -1,
 -58044,
 490887441,
 4120,
 -1,
 490935694,
 4119,
 -58042,
 490923260,
 4122,
 -58041,
 491098610,
 4137,
 -1,
 491149585,
 4127,
 491388927,
 482907031,
 -1,
 -58038,
 491300910,
 43637,
 -58037,
 491360853,
 43636,
 -1,
 491413163,
 43638,
 491593097,
 482850736,
 -1,
 491658606,
 491546097,
 -1,
 491724123,
 491632560,
 -1,
 491789658,
 491674245,
 -1,
 491855189,
 491768467,
 -1,
 -58030,
 491787419,
 4234,
 -58029,
 491852835,
 4233,
 -58028,
 491918182,
 4232,
 -1,
 491983553,
 4231,
 492240895,
 491795393,
 -1,
 492248409,
 492161683,
 -1,
 -58024,
 492180326,
 4236,
 -1,
 492245697,
 4235,
 -1,
 492193522,
 4237,
 -1,
 491733628,
 4171,
 492576097,
 491708256,
 -1,
 -58019,
 492508195,
 4205,
 -58018,
 492573654,
 4204,
 -58017,
 492639078,
 4203,
 -58016,
 492704449,
 4202,
 -1,
 492769833,
 4201,
 492969316,
 492559415,
 -1,
 -58013,
 492943542,
 4152,
 -1,
 493005583,
 4153,
 493165927,
 492925586,
 -1,
 -58010,
 493097830,
 4251,
 -1,
 493163049,
 4250,
 493362538,
 493098382,
 -1,
 -58007,
 493336776,
 4154,
 -1,
 493392168,
 4150,
 -58005,
 493336364,
 4239,
 -58004,
 493527392,
 43643,
 -58003,
 493583409,
 4170,
 -1,
 493632347,
 4151,
 493821308,
 491608714,
 -1,
 493886834,
 493798264,
 -1,
 -57999,
 493871713,
 4242,
 -1,
 493904062,
 4243,
 494083445,
 493860784,
 -1,
 -57996,
 494038876,
 4246,
 -1,
 494095535,
 4247,
 494280056,
 494030494,
 -1,
 -57993,
 494247026,
 4244,
 -1,
 494300901,
 4245,
 -57991,
 494266479,
 4240,
 -57990,
 494442018,
 4241,
 -57989,
 494505247,
 4249,
 -1,
 494552407,
 4248,
 494796799,
 493807312,
 -1,
 494804355,
 494671246,
 -1,
 494869890,
 494759583,
 -1,
 -57984,
 494849542,
 43641,
 -57983,
 494900770,
 43640,
 -1,
 494947739,
 43639,
 -1,
 494817749,
 4174,
 495197574,
 494779166,
 -1,
 -57979,
 495162914,
 4254,
 -1,
 495209883,
 4255,
 -57977,
 495156541,
 4172,
 -57976,
 495342782,
 4175,
 -1,
 495399557,
 4173,
 495590829,
 491576712,
 -1,
 495656337,
 495564720,
 -1,
 495721872,
 495606405,
 -1,
 495787406,
 495665319,
 4228,
 -1,
 495714309,
 4229,
 -57969,
 495734993,
 4230,
 -1,
 495851025,
 4227,
 -1,
 495670319,
 4194,
 496115094,
 495639777,
 -1,
 496180628,
 496085462,
 4182,
 -1,
 496150998,
 4183,
 496369663,
 496137156,
 4184,
 -1,
 496268228,
 4185,
 496442779,
 496047502,
 -1,
 496508314,
 496394727,
 4146,
 496631807,
 496486984,
 4252,
 -1,
 496525799,
 4253,
 -1,
 496440718,
 4140,
 496770463,
 496398845,
 -1,
 -57955,
 496750318,
 4211,
 -57954,
 496800568,
 4210,
 -1,
 496845639,
 4212,
 497032610,
 496754509,
 -1,
 -57951,
 497012914,
 4200,
 -1,
 497044589,
 4199,
 497229220,
 497012462,
 4143,
 -1,
 497209070,
 4144,
 497360295,
 497190671,
 -1,
 -57946,
 497324530,
 4148,
 -1,
 497378819,
 4147,
 497556905,
 497312231,
 4141,
 -1,
 497508839,
 4142,
 497687979,
 497500327,
 4145,
 -1,
 497614853,
 4149,
 -57940,
 497665169,
 4139,
 -1,
 497767567,
 4209,
 497950139,
 495532452,
 -1,
 498015665,
 497927032,
 -1,
 -57936,
 498000481,
 4162,
 -1,
 498032830,
 4163,
 498212276,
 497989552,
 -1,
 -57933,
 498167644,
 4166,
 -1,
 498224303,
 4167,
 498408887,
 498159262,
 -1,
 -57930,
 498375794,
 4164,
 -1,
 498429669,
 4165,
 -57928,
 498395247,
 4160,
 -57927,
 498570786,
 4161,
 -57926,
 498634015,
 4169,
 -1,
 498681175,
 4168,
 498867655,
 497889983,
 -1,
 498933190,
 498827336,
 -1,
 498998722,
 498877217,
 -1,
 -57921,
 498984188,
 4155,
 -57920,
 499047938,
 4157,
 -57919,
 499100209,
 4156,
 -1,
 499144977,
 4158,
 499384319,
 498963873,
 -1,
 -57916,
 499288478,
 4190,
 -57915,
 499351701,
 4191,
 -1,
 499414041,
 4192,
 -1,
 498907940,
 4226,
 499654090,
 498846333,
 -1,
 -57911,
 499610151,
 4196,
 -1,
 499669871,
 4195,
 -1,
 499615386,
 43632,
 499916362,
 482754727,
 -1,
 499981844,
 499862521,
 -1,
 500047355,
 499938244,
 -1,
 500112890,
 499993696,
 -1,
 500178388,
 500074818,
 -1,
 500243922,
 500127441,
 43977,
 -1,
 500172229,
 44001,
 500432895,
 500176270,
 43973,
 -1,
 500303301,
 43999,
 500506072,
 500155256,
 -1,
 500571607,
 500459077,
 43975,
 -1,
 500499909,
 44000,
 -1,
 500523117,
 43978,
 500768220,
 500473963,
 -1,
 500833755,
 500700558,
 43972,
 -1,
 500762053,
 43998,
 -1,
 500783696,
 43984,
 501030368,
 500723958,
 -1,
 501095903,
 500995141,
 43968,
 -1,
 501024197,
 43995,
 -1,
 501047405,
 43976,
 501292514,
 500991562,
 43971,
 -1,
 501220805,
 43997,
 501423588,
 501249301,
 43970,
 -1,
 501351877,
 43996,
 501554663,
 501378967,
 -1,
 -57882,
 501507653,
 43990,
 -1,
 501570128,
 43987,
 501751273,
 501506535,
 43983,
 -1,
 501679557,
 44002,
 501882348,
 501699371,
 -1,
 -57877,
 501847109,
 43986,
 -1,
 501899373,
 43992,
 502078959,
 501823020,
 -1,
 -57874,
 502031941,
 43991,
 -1,
 502095981,
 43993,
 502275570,
 502015643,
 -1,
 -57871,
 502225488,
 43994,
 -1,
 502273422,
 43989,
 -57869,
 502261059,
 43980,
 -57868,
 502455833,
 43979,
 -57867,
 502518391,
 43982,
 -57866,
 502577267,
 43969,
 -57865,
 502639277,
 43988,
 -57864,
 502686075,
 43981,
 -57863,
 502738906,
 43974,
 -1,
 502801781,
 43985,
 -1,
 500093468,
 44012,
 503062025,
 499988900,
 -1,
 503127551,
 503038840,
 -1,
 -57858,
 503112289,
 44018,
 -1,
 503144638,
 44019,
 503324162,
 503101360,
 -1,
 -57855,
 503279452,
 44022,
 -1,
 503336111,
 44023,
 503520773,
 503271070,
 -1,
 -57852,
 503487602,
 44020,
 -1,
 503541477,
 44021,
 -57850,
 503507055,
 44016,
 -57849,
 503682594,
 44017,
 -57848,
 503745823,
 44025,
 -1,
 503792983,
 44024,
 503979538,
 503045512,
 -1,
 -57845,
 503965194,
 44006,
 -57844,
 504025740,
 44008,
 -57843,
 504086371,
 44007,
 -57842,
 504141277,
 44003,
 -57841,
 504205594,
 44010,
 -57840,
 504260667,
 44004,
 -57839,
 504311743,
 44009,
 -1,
 504372603,
 44005,
 -57837,
 503918518,
 44011,
 -1,
 504504411,
 44013,
 504700457,
 499923561,
 -1,
 504765978,
 504671982,
 -1,
 504831513,
 504692736,
 -1,
 -57832,
 504799668,
 10089,
 -1,
 504837572,
 10101,
 -1,
 504762607,
 10093,
 505093663,
 504723185,
 -1,
 505159198,
 505020416,
 -1,
 -57827,
 505127348,
 10088,
 -1,
 505165252,
 10100,
 -1,
 505090287,
 10092,
 505421346,
 505067440,
 -1,
 -57823,
 505381432,
 9900,
 -1,
 505436475,
 9618,
 505617957,
 505368915,
 -1,
 -57820,
 505589799,
 10091,
 -1,
 505640921,
 10090,
 -57818,
 505601940,
 9898,
 -57817,
 505797402,
 10073,
 -57816,
 505840395,
 8287,
 -1,
 505883188,
 9899,
 506076732,
 504636545,
 -1,
 506142266,
 506011354,
 8737,
 506265599,
 506068992,
 -1,
 506273337,
 506192222,
 -1,
 506338864,
 506254255,
 -1,
 -57809,
 506310382,
 10664,
 -1,
 506361585,
 10665,
 506535475,
 506310395,
 -1,
 -57806,
 506516392,
 10668,
 -1,
 506543695,
 10670,
 506732086,
 506492668,
 -1,
 -57803,
 506713000,
 10669,
 -1,
 506740303,
 10671,
 506986495,
 506674778,
 -1,
 -57800,
 506900206,
 10666,
 -1,
 506951409,
 10667,
 -1,
 506238965,
 10651,
 -57797,
 506113798,
 10653,
 -1,
 507129036,
 8798,
 507321929,
 506055640,
 -1,
 507387459,
 507298680,
 -1,
 507452993,
 507372346,
 -1,
 -57792,
 507420265,
 9173,
 -1,
 507474052,
 9174,
 -57790,
 507425586,
 9175,
 -1,
 507595815,
 9176,
 507780678,
 507346377,
 -1,
 -57787,
 507760280,
 9172,
 -1,
 507821032,
 9170,
 -57785,
 507755539,
 9171,
 -57784,
 507945670,
 9177,
 -1,
 507980782,
 9169,
 -1,
 507292618,
 9791,
 508297215,
 499868135,
 -1,
 508304985,
 508201282,
 -1,
 508370520,
 508286755,
 -1,
 508436055,
 508297216,
 -1,
 508501590,
 508411068,
 8722,
 508624895,
 508428288,
 -1,
 508632661,
 508551236,
 -1,
 -57774,
 508605292,
 10796,
 -57773,
 508645189,
 10795,
 -57772,
 508705627,
 10794,
 -1,
 508768834,
 10793,
 -1,
 508585968,
 10810,
 -1,
 508479648,
 8770,
 -1,
 508367015,
 8723,
 -1,
 508355776,
 10751,
 509222492,
 508245548,
 -1,
 -57765,
 509180831,
 8943,
 -1,
 509229764,
 183,
 -57763,
 509181037,
 8357,
 -1,
 509359153,
 181,
 509552640,
 342258628,
 -1,
 509617226,
 509482382,
 -1,
 509682651,
 509593930,
 -1,
 509747543,
 509654960,
 -1,
 509813068,
 509706625,
 -1,
 509878601,
 509768644,
 -1,
 509944126,
 509824096,
 -1,
 510009001,
 509920120,
 116,
 510074500,
 509988590,
 -1,
 510140035,
 510047306,
 -1,
 510205549,
 510110166,
 633,
 510328831,
 510135350,
 -1,
 -57749,
 510247975,
 11385,
 -57748,
 510295488,
 634,
 -1,
 510353160,
 635,
 510533232,
 510154995,
 613,
 510656511,
 510463354,
 686,
 -1,
 510525847,
 687,
 510729843,
 510465422,
 592,
 -57742,
 510689091,
 594,
 -1,
 510738599,
 7426,
 510926454,
 510693874,
 -1,
 -57739,
 510894746,
 7432,
 -1,
 510935207,
 7444,
 511123064,
 510885960,
 623,
 -1,
 511053276,
 624,
 511254138,
 511074791,
 7433,
 -1,
 511217504,
 42879,
 -57733,
 511239360,
 654,
 -57732,
 511368666,
 653,
 -57731,
 511432806,
 652,
 -57730,
 511492984,
 647,
 -57729,
 511538116,
 42881,
 -57728,
 511602934,
 670,
 -57727,
 511660843,
 7543,
 -57726,
 511721639,
 477,
 -1,
 511784895,
 397,
 -1,
 510099528,
 42871,
 512040600,
 510004278,
 -1,
 512106123,
 511978755,
 -1,
 -57721,
 512087699,
 566,
 -57720,
 512136560,
 539,
 -57719,
 512191698,
 7793,
 -57718,
 512246579,
 355,
 -1,
 512303681,
 357,
 512499346,
 512046636,
 -1,
 512564879,
 512465615,
 -1,
 -57714,
 512501880,
 7789,
 -1,
 512562831,
 7787,
 512819199,
 512516718,
 -1,
 -57711,
 512710306,
 11366,
 -1,
 512772577,
 7831,
 -57709,
 512475549,
 359,
 -57708,
 512929204,
 648,
 -57707,
 512991521,
 427,
 -57706,
 513049971,
 7541,
 -57705,
 513112928,
 7791,
 -1,
 513171208,
 429,
 513351326,
 512004594,
 -1,
 513416861,
 513313641,
 -1,
 -57701,
 513396230,
 424,
 -57700,
 513457585,
 389,
 -1,
 513495292,
 445,
 -1,
 513384595,
 7446,
 513744547,
 513300723,
 -1,
 513810082,
 513710561,
 254,
 513933311,
 513740402,
 42853,
 -1,
 513805054,
 42855,
 -1,
 513740382,
 7546,
 -57692,
 513730552,
 42793,
 -57691,
 514045906,
 678,
 -57690,
 514108831,
 42795,
 -57689,
 514149031,
 679,
 -57688,
 514206992,
 680,
 -1,
 514267521,
 11383,
 514465518,
 509952167,
 101,
 514531034,
 514395190,
 -1,
 514596538,
 514469123,
 -1,
 514662071,
 514550967,
 234,
 514785279,
 514588672,
 -1,
 514793142,
 514661776,
 -1,
 -57680,
 514771104,
 7877,
 -57679,
 514818206,
 983561,
 -57678,
 514875149,
 7875,
 -57677,
 514938669,
 7873,
 -57676,
 514997083,
 7879,
 -57675,
 515059292,
 983563,
 -1,
 515119046,
 7871,
 -1,
 514730104,
 7705,
 515382969,
 514605875,
 553,
 -1,
 515309707,
 7709,
 -1,
 515318337,
 283,
 515579588,
 514537004,
 -1,
 515645123,
 515543538,
 -1,
 515710658,
 515621754,
 -1,
 515776193,
 515643023,
 279,
 515899391,
 515702906,
 -1,
 -57664,
 515819680,
 983589,
 -1,
 515839942,
 983587,
 -1,
 515713144,
 7865,
 -1,
 515690482,
 517,
 -1,
 515596913,
 235,
 516234952,
 515562431,
 983555,
 516358143,
 516161658,
 -1,
 -57657,
 516249389,
 983557,
 -1,
 516298694,
 983559,
 516497100,
 516199335,
 281,
 516620287,
 516423802,
 -1,
 -57653,
 516540576,
 983585,
 -1,
 516560838,
 983583,
 516759248,
 516456606,
 275,
 516882431,
 516685946,
 -1,
 -57649,
 516773677,
 7701,
 -1,
 516822982,
 7703,
 517021394,
 516737184,
 7869,
 -1,
 516948531,
 7707,
 -57645,
 516997533,
 583,
 -57644,
 517123508,
 7570,
 -57643,
 517181189,
 11384,
 -57642,
 517237582,
 519,
 -57641,
 517299981,
 7867,
 -57640,
 517363501,
 232,
 -57639,
 517417966,
 277,
 -1,
 517478342,
 233,
 517676771,
 514517163,
 658,
 517799935,
 517603328,
 -1,
 517807842,
 517726276,
 -1,
 517873376,
 517745923,
 -1,
 -57633,
 517854867,
 659,
 -1,
 517874241,
 495,
 -57631,
 517850151,
 442,
 -1,
 518041012,
 7578,
 -1,
 517778921,
 441,
 518266600,
 517651108,
 643,
 518389759,
 518196278,
 -1,
 -57626,
 518303156,
 7576,
 -57625,
 518365473,
 7563,
 -1,
 518403505,
 646,
 518594282,
 518243192,
 42859,
 -1,
 518543603,
 240,
 518725357,
 518543588,
 -1,
 -57620,
 518682344,
 42787,
 -1,
 518743960,
 42789,
 -1,
 518687770,
 331,
 518987566,
 514429426,
 111,
 519053094,
 518917174,
 -1,
 519118585,
 519003847,
 -1,
 519184120,
 519091242,
 417,
 519307263,
 519110778,
 -1,
 -57612,
 519227552,
 7905,
 -57611,
 519266061,
 7903,
 -57610,
 519329581,
 7901,
 -57609,
 519387995,
 7907,
 -1,
 519444422,
 7899,
 -1,
 519148616,
 7887,
 519708420,
 519058988,
 -1,
 519773954,
 519672306,
 -1,
 519839487,
 519750522,
 -1,
 519905022,
 519771791,
 559,
 -1,
 519831846,
 561,
 -1,
 519841912,
 7885,
 520159231,
 519819213,
 -1,
 -57599,
 520050477,
 525,
 -1,
 520099782,
 337,
 520355839,
 519725681,
 246,
 -1,
 520225062,
 555,
 520429325,
 519646467,
 -1,
 520494860,
 520383671,
 244,
 520617983,
 520421498,
 -1,
 -57592,
 520538272,
 7895,
 -57591,
 520576781,
 7893,
 -57590,
 520640301,
 7891,
 -57589,
 520698715,
 7897,
 -1,
 520755142,
 7889,
 -1,
 520430145,
 466,
 521019154,
 520407200,
 245,
 521142271,
 520945786,
 -1,
 -57584,
 521044126,
 557,
 -57583,
 521091242,
 7759,
 -1,
 521148358,
 7757,
 521346838,
 521001919,
 983569,
 521469951,
 521273466,
 -1,
 -57579,
 521361197,
 983571,
 -1,
 521410502,
 983573,
 521608986,
 521306270,
 333,
 521732095,
 521535610,
 -1,
 -57575,
 521623341,
 7761,
 -1,
 521672646,
 7763,
 521871134,
 521567532,
 -1,
 -57572,
 521854449,
 11386,
 -57571,
 521901934,
 42829,
 -1,
 521964603,
 42827,
 522133280,
 521847197,
 248,
 -1,
 522059904,
 511,
 522264354,
 522097575,
 491,
 -1,
 522191142,
 493,
 -57565,
 522218318,
 527,
 -57564,
 522344237,
 242,
 -57563,
 522398702,
 335,
 -1,
 522459078,
 243,
 522657579,
 519021188,
 -1,
 522723113,
 522621426,
 596,
 -1,
 522653219,
 7575,
 522911743,
 522666151,
 603,
 -1,
 522784291,
 7571,
 -57556,
 522637038,
 547,
 -57555,
 522949106,
 42831,
 -1,
 523002343,
 419,
 523181929,
 518919566,
 97,
 523247453,
 523111478,
 -1,
 523312953,
 523185411,
 -1,
 523378488,
 523267255,
 226,
 523501567,
 523305082,
 -1,
 -57548,
 523421856,
 7851,
 -57547,
 523460365,
 7849,
 -57546,
 523523885,
 7847,
 -57545,
 523582299,
 7853,
 -1,
 523638726,
 7845,
 -1,
 523313729,
 462,
 523902786,
 523253292,
 -1,
 523968320,
 523866610,
 -1,
 524033855,
 523944826,
 -1,
 524099390,
 523966095,
 551,
 -1,
 524026150,
 481,
 -1,
 524036216,
 7841,
 -1,
 524013554,
 513,
 524419071,
 523919985,
 228,
 -1,
 524288294,
 479,
 524492617,
 523840494,
 259,
 524615679,
 524419194,
 -1,
 -57531,
 524535968,
 7861,
 -57530,
 524574477,
 7859,
 -57529,
 524637997,
 7857,
 -57528,
 524696411,
 7863,
 -1,
 524752838,
 7855,
 524951377,
 524462550,
 -1,
 525016912,
 524902887,
 -1,
 525082447,
 524979229,
 -1,
 525147982,
 525014671,
 229,
 -1,
 525074560,
 507,
 -1,
 525084792,
 7681,
 -1,
 525030731,
 7834,
 -1,
 524962887,
 7567,
 525475669,
 524915623,
 261,
 525598719,
 525402234,
 -1,
 -57516,
 525519008,
 983581,
 -1,
 525539270,
 983579,
 525737815,
 525435038,
 257,
 -1,
 525664462,
 983553,
 -57512,
 525715616,
 227,
 -57511,
 525844893,
 11365,
 -57510,
 525888334,
 515,
 -57509,
 525950733,
 7843,
 -57508,
 526014253,
 224,
 -1,
 526063558,
 225,
 526262113,
 523190439,
 230,
 526385151,
 526191670,
 -1,
 -57504,
 526287006,
 483,
 -1,
 526325702,
 509,
 526524259,
 526243942,
 42809,
 -1,
 526454164,
 42811,
 526655333,
 526483267,
 593,
 -1,
 526585379,
 7568,
 -57498,
 526640320,
 42813,
 -57497,
 526765806,
 42807,
 -57496,
 526815730,
 42805,
 -1,
 526849422,
 42803,
 527048609,
 523161326,
 117,
 527114141,
 526974976,
 -1,
 527179676,
 527097924,
 -1,
 527245178,
 527119916,
 -1,
 527310709,
 527196785,
 252,
 527433727,
 527237120,
 -1,
 527441780,
 527310224,
 -1,
 -57487,
 527401118,
 470,
 -57486,
 527456045,
 476,
 -57485,
 527511132,
 474,
 -1,
 527570886,
 472,
 -1,
 527378552,
 7795,
 527892479,
 527274482,
 -1,
 527900537,
 527814605,
 -1,
 -57480,
 527849261,
 533,
 -1,
 527898566,
 369,
 -1,
 527876997,
 7909,
 528162691,
 527195847,
 -1,
 528228226,
 528135210,
 432,
 528351231,
 528154746,
 -1,
 -57474,
 528271520,
 7919,
 -57473,
 528310029,
 7917,
 -57472,
 528373549,
 7915,
 -57471,
 528431963,
 7921,
 -1,
 528488390,
 7913,
 -1,
 528192584,
 7911,
 528752521,
 528122014,
 363,
 528875519,
 528679034,
 -1,
 -57466,
 528795808,
 983611,
 -57465,
 528832301,
 983577,
 -57464,
 528890026,
 7803,
 -1,
 528947142,
 983609,
 529145741,
 528730272,
 361,
 529268735,
 529072128,
 -1,
 -57460,
 529148024,
 7797,
 -1,
 529210773,
 7801,
 529407889,
 529109927,
 371,
 529530879,
 529334394,
 -1,
 -57456,
 529451168,
 983607,
 -1,
 529471430,
 983605,
 529670037,
 529345795,
 -1,
 529735572,
 529624247,
 251,
 -1,
 529662515,
 7799,
 -1,
 529670721,
 468,
 529932184,
 529639894,
 -1,
 -57449,
 529885459,
 367,
 -1,
 529943623,
 7577,
 -57447,
 529886030,
 535,
 -57446,
 530077485,
 249,
 -57445,
 530131950,
 365,
 -1,
 530192326,
 250,
 -1,
 527116147,
 649,
 530456479,
 527083347,
 650,
 -1,
 530386546,
 7551,
 -57440,
 530415688,
 42872,
 -1,
 530530471,
 7531,
 530718666,
 527000039,
 105,
 530784192,
 530648118,
 -1,
 530849710,
 530724396,
 -1,
 530915244,
 530813426,
 -1,
 530980779,
 530891642,
 -1,
 531046314,
 530912924,
 -1,
 -57432,
 531024032,
 983591,
 -57431,
 531060525,
 983590,
 -1,
 531109830,
 983566,
 -1,
 530983032,
 7883,
 -1,
 530960370,
 521,
 531496959,
 530866801,
 239,
 -1,
 531366016,
 7727,
 531570610,
 530813863,
 303,
 531693567,
 531497146,
 -1,
 -57423,
 531613856,
 983595,
 -1,
 531634118,
 983593,
 531832756,
 531548320,
 297,
 -1,
 531759667,
 7725,
 531963830,
 531792030,
 299,
 -1,
 531890382,
 983565,
 532094905,
 531901699,
 -1,
 -57416,
 532049079,
 238,
 -1,
 532095553,
 464,
 -57414,
 532070813,
 616,
 -57413,
 532262324,
 7574,
 -57412,
 532310862,
 523,
 -57411,
 532373261,
 7881,
 -57410,
 532436781,
 236,
 -57409,
 532491246,
 301,
 -1,
 532551622,
 237,
 532750279,
 530747215,
 -1,
 -57406,
 532726648,
 42887,
 -57405,
 532789168,
 42885,
 -57404,
 532851158,
 42883,
 -57403,
 532894507,
 7545,
 -57402,
 532958878,
 42876,
 -1,
 533018156,
 42874,
 533209033,
 532716296,
 617,
 -1,
 533139058,
 7548,
 -1,
 533182384,
 42861,
 533405677,
 530692016,
 115,
 533471197,
 533335094,
 -1,
 533536722,
 533409027,
 -1,
 533602255,
 533471809,
 353,
 -1,
 533528747,
 7783,
 -57392,
 533566832,
 537,
 -57391,
 533687479,
 349,
 -1,
 533742387,
 351,
 533929942,
 533478200,
 -1,
 533995477,
 533866616,
 7779,
 -1,
 533921963,
 7785,
 -1,
 533927567,
 7777,
 534192088,
 533862342,
 347,
 -1,
 534118571,
 7781,
 -57383,
 534174655,
 983575,
 -57382,
 534299354,
 575,
 -57381,
 534356257,
 7562,
 -57380,
 534414707,
 7540,
 -1,
 534470408,
 642,
 534650852,
 533423204,
 -1,
 534716385,
 534614514,
 7441,
 -57376,
 534684320,
 7442,
 -1,
 534711922,
 7443,
 -57374,
 534695662,
 7453,
 -57373,
 534891957,
 7455,
 -1,
 534919374,
 7454,
 535109610,
 534588675,
 -1,
 535175145,
 535060917,
 601,
 535298047,
 535104566,
 -1,
 -57368,
 535211444,
 7573,
 -1,
 535256840,
 602,
 -1,
 535147307,
 609,
 -57365,
 535079199,
 645,
 -57364,
 535452443,
 223,
 -1,
 535501949,
 42892,
 535699475,
 533375446,
 114,
 535764999,
 535625728,
 -1,
 535830534,
 535748676,
 -1,
 535896054,
 535771856,
 -1,
 535961589,
 535872378,
 -1,
 536027124,
 535898232,
 7771,
 -1,
 535953702,
 7773,
 -1,
 535959183,
 7769,
 -1,
 535941106,
 529,
 536289273,
 535872376,
 -1,
 -57352,
 536241767,
 983603,
 -1,
 536287587,
 637,
 536485884,
 536245188,
 -1,
 -57349,
 536450696,
 636,
 -1,
 536504526,
 7775,
 536682494,
 536432872,
 638,
 -1,
 536609074,
 7539,
 536813569,
 536620291,
 -1,
 -57344,
 536757043,
 343,
 -1,
 536814145,
 345,
 -57342,
 536789405,
 589,
 -57341,
 536977697,
 7561,
 -57340,
 537036147,
 7538,
 -57339,
 537094990,
 531,
 -1,
 537139142,
 341,
 -1,
 535803251,
 42843,
 537403408,
 535711007,
 -1,
 537468940,
 537368513,
 604,
 537591807,
 537398326,
 -1,
 -57333,
 537505204,
 7572,
 -1,
 537550600,
 605,
 537731086,
 537406723,
 8580,
 -1,
 537660682,
 42815,
 -57329,
 537700877,
 639,
 -1,
 537804967,
 600,
 537993234,
 537383449,
 42869,
 -1,
 537922045,
 42845,
 -1,
 537927002,
 612,
 538189879,
 535655364,
 108,
 538255403,
 538119222,
 -1,
 538320922,
 538193155,
 -1,
 -57321,
 538302099,
 564,
 -57320,
 538340562,
 7741,
 -57319,
 538395443,
 316,
 -1,
 538452545,
 318,
 538648606,
 538262224,
 -1,
 538714141,
 538624901,
 7735,
 -1,
 538640678,
 7737,
 -1,
 538693587,
 11361,
 538910753,
 538608905,
 -1,
 -57312,
 538888352,
 619,
 -1,
 538917684,
 320,
 539107364,
 538846875,
 -1,
 -57309,
 539051577,
 620,
 -1,
 539107457,
 410,
 -57307,
 539084960,
 983599,
 -57306,
 539279773,
 322,
 -57305,
 539340212,
 621,
 -57304,
 539402529,
 7557,
 -57303,
 539458400,
 7739,
 -57302,
 539516301,
 42825,
 -1,
 539563974,
 314,
 539762737,
 538220190,
 383,
 539885567,
 539692086,
 -1,
 539893808,
 539768364,
 -1,
 -57297,
 539859667,
 7835,
 -1,
 539910787,
 7836,
 -1,
 539843981,
 7837,
 -57294,
 539748346,
 683,
 -57293,
 540135961,
 42866,
 -57292,
 540194770,
 682,
 -57291,
 540241815,
 457,
 -57290,
 540298897,
 622,
 -1,
 540351691,
 411,
 540549209,
 538129964,
 100,
 540614730,
 540478518,
 -1,
 540680254,
 540552451,
 -1,
 -57285,
 540661395,
 545,
 -57284,
 540699858,
 7699,
 -57283,
 540754739,
 7697,
 -1,
 540811841,
 271,
 541007937,
 540656504,
 -1,
 -57280,
 540972931,
 396,
 -1,
 541006179,
 598,
 541204547,
 540958472,
 599,
 -1,
 541131159,
 7569,
 541335622,
 541145912,
 -1,
 -57275,
 541272184,
 7693,
 -1,
 541333135,
 7691,
 -57273,
 541311389,
 273,
 -57272,
 541499681,
 7553,
 -57271,
 541558131,
 7533,
 -1,
 541621088,
 7695,
 541794383,
 540600312,
 499,
 541917183,
 541720576,
 -1,
 541925454,
 541800908,
 675,
 -1,
 541854910,
 677,
 -1,
 541909091,
 454,
 542122068,
 541760353,
 -1,
 542187603,
 542076823,
 567,
 542310399,
 542117490,
 607,
 -1,
 542179562,
 644,
 -1,
 542138855,
 305,
 542449751,
 542064807,
 -1,
 -57258,
 542435502,
 676,
 -1,
 542474071,
 7839,
 -57256,
 542429721,
 42865,
 -1,
 542582429,
 568,
 542777458,
 540510530,
 110,
 542842991,
 542703616,
 -1,
 542908526,
 542826564,
 -1,
 542974049,
 542846211,
 -1,
 -57250,
 542955155,
 565,
 -57249,
 542993618,
 7755,
 -57248,
 543048499,
 326,
 -1,
 543105601,
 328,
 543301733,
 542929860,
 -1,
 -57245,
 543266448,
 414,
 -57244,
 543320270,
 7753,
 -1,
 543376367,
 626,
 543563880,
 543243064,
 -1,
 -57241,
 543500408,
 7751,
 -1,
 543561359,
 7749,
 -57239,
 543541408,
 241,
 -57238,
 543731124,
 627,
 -57237,
 543793441,
 7559,
 -57236,
 543851891,
 7536,
 -57235,
 543905581,
 505,
 -1,
 543954886,
 324,
 -1,
 542877294,
 329,
 -57232,
 542822937,
 42868,
 -57231,
 544173975,
 460,
 -1,
 544232250,
 983567,
 544415878,
 542726387,
 104,
 544481410,
 544345142,
 -1,
 544546938,
 544421420,
 -1,
 544612472,
 544512719,
 -1,
 -57225,
 544548984,
 7717,
 -1,
 544609935,
 7715,
 -57223,
 544563825,
 7719,
 -1,
 544754322,
 11368,
 544940158,
 544484611,
 -1,
 -57220,
 544894135,
 293,
 -57219,
 544949043,
 7721,
 -1,
 545006145,
 543,
 -57217,
 544915869,
 295,
 -57216,
 545160032,
 7830,
 -57215,
 545218312,
 614,
 -1,
 545270772,
 7723,
 545464452,
 544425918,
 42791,
 -1,
 545394057,
 615,
 -57211,
 545445990,
 405,
 -1,
 545528691,
 11382,
 545726618,
 544353539,
 99,
 545792146,
 545655862,
 -1,
 545857678,
 545729795,
 -1,
 545923211,
 545801011,
 231,
 -1,
 545849472,
 7689,
 -57204,
 545904275,
 597,
 -57203,
 546008247,
 265,
 -1,
 546054721,
 269,
 -57201,
 545833373,
 572,
 -57200,
 546201352,
 392,
 -57199,
 546257725,
 267,
 -1,
 546314182,
 263,
 546513047,
 545750540,
 -1,
 546578582,
 546476530,
 -1,
 -57195,
 546546330,
 666,
 -1,
 546604076,
 631,
 -1,
 546549298,
 606,
 546840729,
 546492293,
 42797,
 -1,
 546770079,
 42799,
 -1,
 546805136,
 42863,
 547037358,
 545712120,
 122,
 547160063,
 546966582,
 -1,
 547168417,
 547042860,
 -1,
 547233952,
 547134159,
 -1,
 -57185,
 547170424,
 7827,
 -1,
 547231375,
 380,
 -1,
 547179154,
 11372,
 547496101,
 547106051,
 -1,
 -57181,
 547477139,
 657,
 -57180,
 547515575,
 7825,
 -1,
 547562049,
 382,
 547758248,
 547469232,
 -1,
 -57177,
 547741376,
 576,
 -1,
 547802232,
 438,
 -57175,
 547728820,
 656,
 -57174,
 547922209,
 7566,
 -57173,
 547980659,
 7542,
 -57172,
 548043616,
 7829,
 -57171,
 548101896,
 549,
 -1,
 548149190,
 378,
 548348096,
 547022016,
 121,
 548413631,
 548277302,
 -1,
 548479157,
 548353580,
 -1,
 548544692,
 548444879,
 -1,
 -57165,
 548481144,
 7925,
 -1,
 548542095,
 7823,
 -1,
 548495985,
 255,
 548806839,
 548429576,
 436,
 -1,
 548732933,
 7927,
 -57160,
 548784288,
 7929,
 -57159,
 548913565,
 591,
 -57158,
 548975169,
 7833,
 -57157,
 549027998,
 563,
 -57156,
 549092849,
 7935,
 -57155,
 549148461,
 7923,
 -57154,
 549204180,
 375,
 -1,
 549263302,
 253,
 -1,
 548377491,
 541,
 549527760,
 548295467,
 103,
 549593293,
 549456950,
 -1,
 549658822,
 549530883,
 -1,
 -57148,
 549612727,
 285,
 -57147,
 549667635,
 291,
 -1,
 549724737,
 487,
 -57145,
 549634461,
 485,
 -57144,
 549888289,
 7555,
 -57143,
 549945502,
 7713,
 -57142,
 550002440,
 608,
 -57141,
 550058813,
 289,
 -57140,
 550120430,
 287,
 -1,
 550180806,
 501,
 -57138,
 549551723,
 578,
 -57137,
 550328593,
 983041,
 -1,
 550378767,
 611,
 550576352,
 549482742,
 107,
 550641887,
 550505526,
 -1,
 550707414,
 550581804,
 -1,
 -57132,
 550673116,
 7731,
 -57131,
 550724227,
 42819,
 -1,
 550783634,
 11370,
 550969560,
 550683037,
 42817,
 -1,
 550895766,
 42821,
 551100635,
 550907139,
 -1,
 -57126,
 551043891,
 311,
 -1,
 551100993,
 489,
 -57124,
 551067937,
 7556,
 -57123,
 551254880,
 7733,
 -57122,
 551313160,
 409,
 -1,
 551360454,
 7729,
 -1,
 550611505,
 312,
 551624942,
 550512283,
 98,
 551690475,
 551554102,
 -1,
 551756005,
 551631672,
 -1,
 -57116,
 551692408,
 7685,
 -1,
 551753359,
 7683,
 -57114,
 551734026,
 387,
 -57113,
 551928221,
 384,
 -57112,
 551985441,
 7552,
 -57111,
 552043891,
 7532,
 -57110,
 552106848,
 7687,
 -1,
 552165128,
 595,
 -57108,
 551662775,
 42823,
 -57107,
 552311713,
 7447,
 -1,
 552346232,
 629,
 552542459,
 551606374,
 118,
 552607992,
 552471606,
 -1,
 552673523,
 552547884,
 -1,
 -57102,
 552639196,
 7807,
 -1,
 552690307,
 42847,
 -57100,
 552650912,
 7805,
 -57099,
 552841214,
 11377,
 -57098,
 552902945,
 7564,
 -57097,
 552951560,
 651,
 -1,
 553006513,
 11380,
 -57095,
 552592576,
 42849,
 -57094,
 553151889,
 42851,
 -1,
 553207685,
 42857,
 553394440,
 552509547,
 112,
 553459975,
 553323574,
 -1,
 553525505,
 553433008,
 -1,
 553591040,
 553503864,
 7549,
 -1,
 553519870,
 42833,
 -1,
 553560455,
 42837,
 -57086,
 553492769,
 7560,
 -57085,
 553747827,
 7537,
 -57084,
 553803528,
 421,
 -57083,
 553865637,
 42835,
 -57082,
 553925437,
 7767,
 -1,
 553981894,
 7765,
 -1,
 553409777,
 632,
 554246422,
 553353288,
 109,
 554311954,
 554175542,
 -1,
 554377485,
 554253112,
 -1,
 -57076,
 554313848,
 7747,
 -1,
 554374799,
 7745,
 -57074,
 554354848,
 983601,
 -57073,
 554541345,
 7558,
 -57072,
 554599795,
 7535,
 -57071,
 554655496,
 625,
 -1,
 554702790,
 7743,
 554901781,
 554263463,
 -1,
 -57068,
 554883174,
 7933,
 -1,
 554925162,
 7931,
 -1,
 554881561,
 42867,
 555163938,
 554229210,
 119,
 555286527,
 555093046,
 -1,
 555295005,
 555169324,
 -1,
 555360540,
 555260623,
 -1,
 -57061,
 555296888,
 7817,
 -1,
 555357839,
 7815,
 -1,
 555311729,
 7813,
 -57058,
 555266625,
 7832,
 -57057,
 555573000,
 11379,
 -57056,
 555636525,
 7809,
 -57055,
 555692244,
 373,
 -1,
 555751366,
 7811,
 555950377,
 555132870,
 113,
 556015912,
 555879478,
 -1,
 556081446,
 555966216,
 672,
 -1,
 556010177,
 587,
 -57049,
 556057061,
 42839,
 -1,
 556153107,
 42841,
 -1,
 555982960,
 569,
 556409137,
 555904919,
 106,
 556531711,
 556338230,
 -1,
 556540207,
 556412163,
 -1,
 -57043,
 556512568,
 669,
 -57042,
 556559543,
 309,
 -1,
 556606017,
 496,
 -57040,
 556515741,
 585,
 -1,
 556743495,
 983597,
 556933432,
 556355230,
 102,
 556998967,
 556862518,
 -1,
 -57036,
 556966177,
 7554,
 -57035,
 557024627,
 7534,
 -57034,
 557080328,
 402,
 -1,
 557136701,
 7711,
 -1,
 556943298,
 681,
 557449215,
 556917718,
 120,
 557514751,
 557321270,
 -1,
 557523261,
 557397548,
 -1,
 -57028,
 557488851,
 7819,
 -1,
 557539953,
 7821,
 -1,
 557490465,
 7565,
 557842431,
 509895943,
 -1,
 557850949,
 557731486,
 -1,
 557916483,
 557797022,
 64256,
 -57022,
 557872068,
 64260,
 -1,
 557933031,
 64259,
 -57020,
 557872068,
 64258,
 -1,
 558064103,
 64257,
 -57018,
 557826216,
 64262,
 -57017,
 558207800,
 339,
 -57016,
 558267860,
 64261,
 -1,
 558327311,
 307,
 558563327,
 509816361,
 -1,
 -57013,
 558485312,
 7550,
 -1,
 558522946,
 7547,
 558759935,
 509792322,
 -1,
 -57010,
 558687190,
 8339,
 -57009,
 558749798,
 7525,
 -57008,
 558812910,
 7524,
 -57007,
 558872846,
 8340,
 -57006,
 558934486,
 7523,
 -57005,
 558993906,
 8338,
 -57004,
 559050647,
 11388,
 -57003,
 559112679,
 7522,
 -57002,
 559169703,
 8337,
 -1,
 559224206,
 8336,
 559424398,
 509684995,
 -1,
 559489933,
 559357954,
 -1,
 559555466,
 559434848,
 -1,
 559620505,
 559518194,
 79,
 559686035,
 559549494,
 -1,
 559751525,
 559636167,
 -1,
 559817060,
 559723562,
 416,
 559939583,
 559743098,
 -1,
 -56992,
 559859872,
 7904,
 -56991,
 559898381,
 7902,
 -56990,
 559961901,
 7900,
 -56989,
 560020315,
 7906,
 -1,
 560076742,
 7898,
 -1,
 559780936,
 7886,
 560341360,
 559691308,
 -1,
 560406894,
 560304626,
 -1,
 560472427,
 560382842,
 -1,
 560537962,
 560404111,
 558,
 -1,
 560464166,
 560,
 -1,
 560474232,
 7884,
 560791551,
 560451533,
 -1,
 -56979,
 560682797,
 524,
 -1,
 560732102,
 336,
 560988159,
 560358001,
 214,
 -1,
 560857382,
 554,
 561062265,
 560278787,
 -1,
 561127800,
 561015991,
 212,
 561250303,
 561053818,
 -1,
 -56972,
 561170592,
 7894,
 -56971,
 561209101,
 7892,
 -56970,
 561272621,
 7890,
 -56969,
 561331035,
 7896,
 -1,
 561387462,
 7888,
 -1,
 561062465,
 465,
 561652094,
 561039520,
 213,
 561774591,
 561578106,
 -1,
 -56964,
 561676446,
 556,
 -56963,
 561723562,
 7758,
 -1,
 561780678,
 7756,
 561979780,
 561610824,
 -1,
 562045315,
 561911732,
 332,
 562167807,
 561971322,
 -1,
 -56958,
 562059053,
 7760,
 -1,
 562108358,
 7762,
 -1,
 561996699,
 415,
 562373000,
 561961919,
 983568,
 562495487,
 562299002,
 -1,
 -56953,
 562386733,
 983570,
 -1,
 562436038,
 983572,
 562635146,
 562348445,
 216,
 -1,
 562561152,
 510,
 562766220,
 562598823,
 490,
 -1,
 562692390,
 492,
 562897295,
 562724140,
 -1,
 -56946,
 562861934,
 42828,
 -1,
 562924603,
 42826,
 -56944,
 562850638,
 526,
 -56943,
 563042093,
 210,
 -56942,
 563096558,
 334,
 -1,
 563156934,
 211,
 563356054,
 559653508,
 -1,
 -56939,
 563319282,
 390,
 -1,
 563364007,
 400,
 -56937,
 563334894,
 546,
 -56936,
 563515890,
 42830,
 -1,
 563569127,
 418,
 563749331,
 559562919,
 69,
 563814856,
 563678262,
 -1,
 563880362,
 563752195,
 -1,
 563945895,
 563834039,
 202,
 564068351,
 563871744,
 -1,
 564076966,
 563944848,
 -1,
 -56928,
 564054176,
 7876,
 -56927,
 564101278,
 983560,
 -56926,
 564158221,
 7874,
 -56925,
 564221741,
 7872,
 -56924,
 564280155,
 7878,
 -56923,
 564342364,
 983562,
 -1,
 564402118,
 7870,
 -1,
 564013176,
 7704,
 564666793,
 563888947,
 552,
 -1,
 564592779,
 7708,
 -1,
 564601409,
 282,
 564863412,
 563820076,
 -1,
 564928947,
 564826610,
 -1,
 564994482,
 564904826,
 -1,
 565060017,
 564926095,
 278,
 565182463,
 564985978,
 -1,
 -56912,
 565102752,
 983588,
 -1,
 565123014,
 983586,
 -1,
 564996216,
 7864,
 -1,
 564973554,
 516,
 -1,
 564879985,
 203,
 565518776,
 564845503,
 983554,
 565641215,
 565444730,
 -1,
 -56905,
 565532461,
 983556,
 -1,
 565581766,
 983558,
 565780924,
 565482407,
 280,
 565903359,
 565706874,
 -1,
 -56901,
 565823648,
 983584,
 -1,
 565843910,
 983582,
 566043072,
 565739678,
 274,
 566165503,
 565969018,
 -1,
 -56897,
 566056749,
 7700,
 -1,
 566106054,
 7702,
 566305218,
 566020256,
 7868,
 -1,
 566231603,
 7706,
 -56893,
 566280605,
 582,
 -56892,
 566389582,
 518,
 -56891,
 566451981,
 7866,
 -56890,
 566515501,
 200,
 -56889,
 566569966,
 276,
 -1,
 566630342,
 201,
 566829516,
 563800235,
 439,
 566951935,
 566755328,
 -1,
 -56885,
 566878307,
 494,
 -1,
 566930921,
 440,
 567091662,
 566805368,
 42858,
 -1,
 567040243,
 208,
 567222737,
 567040228,
 -1,
 -56880,
 567178984,
 42786,
 -1,
 567240600,
 42788,
 -56878,
 567196324,
 425,
 -1,
 567381018,
 330,
 567550474,
 563680654,
 65,
 567615998,
 567479350,
 -1,
 567681502,
 567553283,
 -1,
 567747037,
 567635127,
 194,
 567869439,
 567672954,
 -1,
 -56871,
 567789728,
 7850,
 -56870,
 567828237,
 7848,
 -56869,
 567891757,
 7846,
 -56868,
 567950171,
 7852,
 -1,
 568006598,
 7844,
 -1,
 567681601,
 461,
 568271335,
 567621164,
 -1,
 568336869,
 568234482,
 -1,
 568402404,
 568312698,
 -1,
 568467939,
 568333967,
 550,
 -1,
 568394022,
 480,
 -1,
 568404088,
 7840,
 -1,
 568381426,
 512,
 568786943,
 568287857,
 196,
 -1,
 568656166,
 478,
 568861166,
 568208366,
 258,
 568983551,
 568787066,
 -1,
 -56854,
 568903840,
 7860,
 -56853,
 568942349,
 7858,
 -56852,
 569005869,
 7856,
 -56851,
 569064283,
 7862,
 -1,
 569120710,
 7854,
 569319922,
 568832571,
 -1,
 569385457,
 569251471,
 197,
 -1,
 569311360,
 506,
 -1,
 569321592,
 7680,
 569582070,
 569283495,
 260,
 569704447,
 569507962,
 -1,
 -56843,
 569624736,
 983580,
 -1,
 569644998,
 983578,
 569844216,
 569540766,
 256,
 -1,
 569770190,
 983552,
 -56839,
 569821344,
 195,
 -56838,
 569950621,
 570,
 -56837,
 569994062,
 514,
 -56836,
 570056461,
 7842,
 -56835,
 570119981,
 192,
 -1,
 570169286,
 193,
 570368514,
 567558311,
 198,
 570490879,
 570297398,
 -1,
 -56831,
 570392734,
 482,
 -1,
 570431430,
 508,
 570630660,
 570349670,
 42808,
 -1,
 570559892,
 42810,
 -56827,
 570614976,
 42812,
 -56826,
 570740462,
 42806,
 -56825,
 570790386,
 42804,
 -56824,
 570851139,
 11373,
 -56823,
 570905230,
 393,
 -1,
 570955150,
 42802,
 571155005,
 567529198,
 85,
 571220540,
 571080704,
 -1,
 571286075,
 571203652,
 -1,
 571351579,
 571225644,
 -1,
 571417110,
 571302513,
 220,
 571539455,
 571342848,
 -1,
 571548181,
 571415952,
 -1,
 -56814,
 571506846,
 469,
 -56813,
 571561773,
 475,
 -56812,
 571616860,
 473,
 -1,
 571676614,
 471,
 -1,
 571484280,
 7794,
 571998207,
 571380210,
 -1,
 572006938,
 571920333,
 -1,
 -56807,
 571954989,
 532,
 -1,
 572004294,
 368,
 -1,
 571982725,
 7908,
 572269092,
 571301575,
 -1,
 572334627,
 572240938,
 431,
 572456959,
 572260474,
 -1,
 -56801,
 572377248,
 7918,
 -56800,
 572415757,
 7916,
 -56799,
 572479277,
 7914,
 -56798,
 572537691,
 7920,
 -1,
 572594118,
 7912,
 -1,
 572298312,
 7910,
 572858922,
 572227742,
 362,
 572981247,
 572784762,
 -1,
 -56793,
 572901536,
 983610,
 -56792,
 572938029,
 983576,
 -56791,
 572995754,
 7802,
 -1,
 573052870,
 983608,
 573252142,
 572836000,
 360,
 573374463,
 573177856,
 -1,
 -56787,
 573253752,
 7796,
 -1,
 573316501,
 7800,
 573514290,
 573215655,
 370,
 573636607,
 573440122,
 -1,
 -56783,
 573556896,
 983606,
 -1,
 573577158,
 983604,
 573776438,
 573451523,
 -1,
 573841973,
 573729975,
 219,
 -1,
 573768243,
 7798,
 -1,
 573776449,
 467,
 -56777,
 573747777,
 366,
 -56776,
 573991758,
 534,
 -56775,
 574052141,
 217,
 -56774,
 574106606,
 364,
 -1,
 574166982,
 218,
 -1,
 571221875,
 580,
 -1,
 571189075,
 433,
 574497377,
 571105767,
 73,
 574562904,
 574426166,
 -1,
 574628423,
 574502444,
 -1,
 574693957,
 574591474,
 -1,
 574759492,
 574669690,
 -1,
 -56765,
 574695544,
 7882,
 -1,
 574756495,
 304,
 -1,
 574738418,
 520,
 575078399,
 574644849,
 207,
 -1,
 574947456,
 7726,
 575152715,
 574591911,
 302,
 575275007,
 575078522,
 -1,
 -56758,
 575195296,
 983594,
 -1,
 575215558,
 983592,
 575414861,
 575129760,
 296,
 -1,
 575341107,
 7724,
 575545935,
 575373470,
 298,
 -1,
 575471822,
 983564,
 575677010,
 575483139,
 -1,
 -56751,
 575630519,
 206,
 -1,
 575676993,
 463,
 -56749,
 575652253,
 407,
 -56748,
 575826766,
 522,
 -56747,
 575889165,
 7880,
 -56746,
 575952685,
 204,
 -56745,
 576007150,
 300,
 -1,
 576067526,
 205,
 576266847,
 574525263,
 -1,
 -56742,
 576242552,
 42886,
 -56741,
 576305072,
 42884,
 -56740,
 576367062,
 42882,
 -56739,
 576410411,
 42877,
 -56738,
 576474782,
 42875,
 -1,
 576534060,
 42873,
 -56736,
 576239536,
 42860,
 -1,
 576690952,
 406,
 576856705,
 574473080,
 84,
 576922225,
 576785462,
 -1,
 576987752,
 576859395,
 -1,
 -56731,
 576951664,
 538,
 -56730,
 577006802,
 7792,
 -56729,
 577061683,
 354,
 -1,
 577118785,
 356,
 577315437,
 576927276,
 -1,
 577380972,
 577280719,
 -1,
 -56725,
 577316984,
 7788,
 -1,
 577377935,
 7786,
 -1,
 577331843,
 574,
 -56722,
 577290653,
 358,
 -56721,
 577613236,
 430,
 -56720,
 577665888,
 7790,
 -1,
 577724168,
 428,
 577905272,
 576902824,
 -1,
 577970804,
 577836430,
 11375,
 -1,
 577929027,
 11376,
 -56715,
 577951846,
 581,
 -56714,
 578060360,
 412,
 -56713,
 578122692,
 42880,
 -1,
 578185756,
 42878,
 578364028,
 577869350,
 -1,
 -56710,
 578342406,
 423,
 -56709,
 578403761,
 388,
 -1,
 578441468,
 444,
 578626175,
 578314265,
 222,
 578748415,
 578555506,
 42852,
 -1,
 578620158,
 42854,
 -56704,
 578611192,
 42792,
 -1,
 578792863,
 42794,
 578953877,
 576829360,
 83,
 579019409,
 578882614,
 -1,
 579084937,
 578956547,
 -1,
 579150470,
 579019329,
 352,
 -1,
 579076267,
 7782,
 -56697,
 579114352,
 536,
 -56696,
 579234999,
 348,
 -1,
 579289907,
 350,
 579478157,
 579025720,
 -1,
 579543692,
 579414136,
 7778,
 -1,
 579469483,
 7784,
 -1,
 579475087,
 7776,
 579740303,
 579409862,
 346,
 -1,
 579666091,
 7780,
 -56688,
 579722175,
 983574,
 -1,
 579846874,
 11390,
 -56686,
 578978316,
 586,
 -56685,
 579951387,
 7838,
 -56684,
 580005950,
 399,
 -1,
 580066429,
 42891,
 580264621,
 578922966,
 82,
 580330153,
 580190208,
 -1,
 580395688,
 580313156,
 -1,
 580461214,
 580336336,
 -1,
 580526749,
 580436858,
 -1,
 580592284,
 580462712,
 7770,
 -1,
 580518182,
 7772,
 -1,
 580523663,
 7768,
 -1,
 580505586,
 528,
 580854433,
 580436856,
 -1,
 -56672,
 580806247,
 983602,
 -1,
 580852067,
 11364,
 581051044,
 580791555,
 -1,
 -56669,
 580993843,
 342,
 -1,
 581050945,
 344,
 -56667,
 581026205,
 588,
 -56666,
 581204832,
 7774,
 -56665,
 581266254,
 530,
 -1,
 581310406,
 340,
 -1,
 580367731,
 42842,
 581575340,
 580275487,
 -1,
 -56661,
 581517479,
 398,
 -1,
 581578063,
 42814,
 -1,
 581554724,
 42844,
 581837507,
 580219844,
 76,
 581903042,
 581766198,
 -1,
 581968563,
 581843664,
 -1,
 582034098,
 581944197,
 7734,
 -1,
 581959974,
 7736,
 -1,
 582012883,
 11360,
 582230711,
 581905667,
 -1,
 -56651,
 582184146,
 7740,
 -56650,
 582239027,
 315,
 -1,
 582296129,
 317,
 582492858,
 582203312,
 -1,
 -56647,
 582470776,
 321,
 -1,
 582517232,
 456,
 582689469,
 582452489,
 -1,
 -56644,
 582666400,
 11362,
 -1,
 582695732,
 319,
 -56642,
 582666400,
 983598,
 -56641,
 582843232,
 7738,
 -56640,
 582901133,
 42824,
 -56639,
 582952819,
 573,
 -1,
 583014342,
 313,
 -1,
 581857175,
 455,
 583279316,
 581821632,
 89,
 583344851,
 583207990,
 -1,
 583410378,
 583284268,
 -1,
 583475913,
 583375567,
 -1,
 -56632,
 583411832,
 7924,
 -1,
 583472783,
 7822,
 -1,
 583426673,
 376,
 583738060,
 583360264,
 435,
 -1,
 583663621,
 7926,
 -56627,
 583714976,
 7928,
 -56626,
 583844253,
 590,
 -56625,
 583893150,
 562,
 -56624,
 583958001,
 7934,
 -56623,
 584013613,
 7922,
 -56622,
 584069332,
 374,
 -1,
 584128454,
 221,
 -1,
 583308179,
 540,
 584393446,
 583240002,
 78,
 584458981,
 584322102,
 -1,
 584524506,
 584414148,
 -1,
 -56616,
 584488592,
 544,
 -56615,
 584542414,
 7752,
 -1,
 584598511,
 413,
 584786654,
 584461571,
 -1,
 -56612,
 584740050,
 7754,
 -56611,
 584794931,
 325,
 -1,
 584852033,
 327,
 585048801,
 584727352,
 -1,
 -56608,
 584984696,
 7750,
 -1,
 585045647,
 7748,
 -56606,
 585025696,
 209,
 -56605,
 585219765,
 459,
 -56604,
 585258797,
 504,
 -1,
 585308102,
 323,
 -1,
 584413079,
 458,
 585573112,
 584332844,
 68,
 585638646,
 585501750,
 -1,
 585704172,
 585611184,
 -1,
 585769707,
 585662974,
 498,
 -1,
 585698376,
 453,
 -1,
 585747576,
 272,
 585966320,
 585641219,
 -1,
 -56594,
 585919698,
 7698,
 -56593,
 585974579,
 7696,
 -1,
 586031681,
 270,
 586228467,
 585907000,
 -1,
 -56590,
 586164344,
 7692,
 -1,
 586225295,
 7690,
 -56588,
 586205962,
 395,
 -56587,
 586382176,
 7694,
 -1,
 586440456,
 394,
 586678271,
 585623544,
 497,
 -1,
 586550344,
 452,
 586752777,
 585521395,
 72,
 586818310,
 586681398,
 -1,
 586883840,
 586757676,
 -1,
 586949374,
 586848975,
 -1,
 -56579,
 586885240,
 7716,
 -1,
 586946191,
 7714,
 -56577,
 586900081,
 7718,
 -1,
 587090578,
 11367,
 587277060,
 586820867,
 -1,
 -56574,
 587230391,
 292,
 -56573,
 587285299,
 7720,
 -1,
 587342401,
 542,
 -56571,
 587252125,
 294,
 -1,
 587475956,
 7722,
 -56569,
 586800669,
 502,
 -56568,
 587614142,
 42790,
 -1,
 587668339,
 11381,
 587866904,
 586699563,
 71,
 587932437,
 587795510,
 -1,
 587997967,
 587869443,
 -1,
 -56563,
 587951287,
 284,
 -56562,
 588006195,
 290,
 -1,
 588063297,
 486,
 -56560,
 587973021,
 484,
 -56559,
 588218526,
 7712,
 -56558,
 588275464,
 403,
 -56557,
 588331837,
 288,
 -56556,
 588393454,
 286,
 -1,
 588453830,
 500,
 -56554,
 587890283,
 577,
 -56553,
 588601617,
 983040,
 -1,
 588651791,
 404,
 588849958,
 587803907,
 67,
 588915491,
 588778550,
 -1,
 588981023,
 588852483,
 -1,
 589046557,
 588923699,
 199,
 -1,
 588972160,
 7688,
 -56546,
 588999863,
 264,
 -1,
 589111873,
 268,
 -56544,
 588956061,
 571,
 -56543,
 589258504,
 391,
 -56542,
 589314877,
 266,
 -1,
 589371334,
 262,
 589570853,
 588894085,
 42796,
 -1,
 589499551,
 42798,
 -1,
 589534608,
 42862,
 589767478,
 588834808,
 90,
 589889535,
 589696054,
 -1,
 589898541,
 589772332,
 -1,
 589964076,
 589863631,
 -1,
 -56533,
 589899896,
 7826,
 -1,
 589960847,
 379,
 -1,
 589908626,
 11371,
 590226224,
 589871024,
 -1,
 -56529,
 590208704,
 11391,
 -1,
 590269560,
 437,
 590422835,
 590163203,
 -1,
 -56526,
 590376119,
 7824,
 -1,
 590422593,
 381,
 -56524,
 590379872,
 7828,
 -56523,
 590569224,
 548,
 -1,
 590616518,
 377,
 590816068,
 589721846,
 75,
 590938111,
 590744630,
 -1,
 590947132,
 590820908,
 -1,
 -56518,
 590912220,
 7730,
 -56517,
 590963331,
 42818,
 -1,
 591022738,
 11369,
 591209278,
 590922141,
 42816,
 -1,
 591134870,
 42820,
 591340353,
 591146243,
 -1,
 -56512,
 591282995,
 310,
 -1,
 591340097,
 488,
 -56510,
 591297376,
 7732,
 -56509,
 591486728,
 408,
 -1,
 591534022,
 7728,
 591733584,
 590798298,
 87,
 591799119,
 591662134,
 -1,
 591864651,
 591738412,
 -1,
 591930186,
 591829711,
 -1,
 -56503,
 591865976,
 7816,
 -1,
 591926927,
 7814,
 -1,
 591880817,
 7812,
 -56500,
 591814408,
 11378,
 -56499,
 592140077,
 7808,
 -56498,
 592195796,
 372,
 -1,
 592254918,
 7810,
 -1,
 591783680,
 503,
 592520026,
 591714406,
 86,
 592585559,
 592448566,
 -1,
 592651093,
 592524844,
 -1,
 -56492,
 592616156,
 7806,
 -1,
 592667267,
 42846,
 -56490,
 592627872,
 7804,
 -1,
 592797448,
 434,
 -56488,
 592569536,
 42848,
 -56487,
 592932241,
 42850,
 -1,
 592988037,
 42856,
 593175396,
 592486507,
 80,
 593297407,
 593103926,
 -1,
 593306464,
 593213360,
 -1,
 593371999,
 593284216,
 11363,
 -1,
 593300222,
 42832,
 -1,
 593340807,
 42836,
 -56479,
 593256200,
 420,
 -56478,
 593514917,
 42834,
 -56477,
 593574717,
 7766,
 -1,
 593631174,
 7764,
 593830767,
 593133640,
 77,
 593896300,
 593759286,
 -1,
 593961833,
 593836856,
 -1,
 -56472,
 593897592,
 7746,
 -1,
 593958543,
 7744,
 -56470,
 593938592,
 983600,
 -56469,
 594108168,
 11374,
 -1,
 594155462,
 7742,
 594411519,
 593847207,
 -1,
 -56466,
 594335846,
 7932,
 -1,
 594377834,
 7930,
 594551673,
 593766043,
 66,
 594617208,
 594480182,
 -1,
 594682740,
 594557752,
 -1,
 -56461,
 594618488,
 7684,
 -1,
 594679439,
 7682,
 -56459,
 594660106,
 386,
 -56458,
 594854301,
 579,
 -56457,
 594901856,
 7686,
 -1,
 594960136,
 385,
 -1,
 594588855,
 42822,
 595207038,
 594505623,
 74,
 595329023,
 595135542,
 -1,
 -56452,
 595249312,
 983596,
 -56451,
 595313053,
 584,
 -1,
 595341524,
 308,
 595534722,
 595190742,
 88,
 595656703,
 595463369,
 -1,
 -56447,
 595565267,
 7818,
 -1,
 595616369,
 7820,
 595796870,
 595503046,
 81,
 595918847,
 595725366,
 -1,
 -56443,
 595837413,
 42838,
 -1,
 595867923,
 42840,
 596115455,
 595742366,
 70,
 596180991,
 595987510,
 -1,
 -56439,
 596074248,
 401,
 -1,
 596130621,
 7710,
 596377599,
 559506695,
 -1,
 -56436,
 596284216,
 338,
 -1,
 596338191,
 306,
 -1,
 559461656,
 10013,
 596583379,
 559381058,
 -1,
 596648891,
 596555696,
 -1,
 596714426,
 596607383,
 -1,
 596779926,
 596683222,
 640,
 596845461,
 596725023,
 -1,
 -56428,
 596814294,
 7449,
 -1,
 596871490,
 7438,
 -1,
 596824601,
 42870,
 597107610,
 596742642,
 7439,
 -56424,
 597085934,
 7445,
 -56423,
 597140128,
 7440,
 -1,
 597180583,
 630,
 597369758,
 597083000,
 7451,
 597491711,
 597350056,
 -1,
 -56419,
 597404118,
 7450,
 -1,
 597442727,
 11387,
 597631905,
 597311655,
 7431,
 -56416,
 597616811,
 7459,
 -1,
 597673651,
 7430,
 597828515,
 597586884,
 671,
 -1,
 597757554,
 7436,
 597959589,
 597778919,
 618,
 -1,
 597922159,
 641,
 598090663,
 597906219,
 610,
 -1,
 598019465,
 667,
 598221737,
 598025883,
 665,
 -1,
 598155888,
 7427,
 598352811,
 598152590,
 7424,
 -1,
 598294695,
 7425,
 -56404,
 598337528,
 7458,
 -56403,
 598467776,
 655,
 -56402,
 598531546,
 7457,
 -56401,
 598595686,
 7456,
 -56400,
 598658798,
 7452,
 -56399,
 598718384,
 42801,
 -56398,
 598777963,
 7448,
 -56397,
 598837570,
 628,
 -56396,
 598900808,
 7437,
 -56395,
 598962422,
 7435,
 -56394,
 599027607,
 7434,
 -56393,
 599087347,
 668,
 -56392,
 599150238,
 42800,
 -56391,
 599209516,
 7429,
 -1,
 599272707,
 7428,
 -1,
 596691850,
 663,
 599532480,
 596618246,
 -1,
 599598015,
 599513829,
 -1,
 -56386,
 599545439,
 674,
 -1,
 599607987,
 426,
 -1,
 599575639,
 451,
 599860165,
 599468402,
 -1,
 599925700,
 599815263,
 -1,
 -56381,
 599892720,
 684,
 -1,
 599929235,
 664,
 -1,
 599865324,
 685,
 600187847,
 599813033,
 662,
 -1,
 600116850,
 446,
 600318921,
 600135250,
 660,
 -1,
 600247922,
 673,
 600449996,
 600249742,
 -1,
 -56373,
 600408067,
 450,
 -1,
 600467352,
 7461,
 -56371,
 600434540,
 422,
 -56370,
 600630225,
 447,
 -56369,
 600694032,
 7460,
 -56368,
 600755901,
 443,
 -56367,
 600810424,
 661,
 -56366,
 600864283,
 449,
 -1,
 600913887,
 448,
 601161727,
 596527331,
 -1,
 601170903,
 601075186,
 -1,
 -56362,
 601137259,
 43004,
 -1,
 601181854,
 43003,
 601367514,
 601121255,
 -1,
 -56359,
 601330021,
 43005,
 -1,
 601359806,
 43006,
 -1,
 601301361,
 43007,
 601629752,
 509645300,
 -1,
 601695240,
 601586242,
 -1,
 601760739,
 601641407,
 -1,
 601826273,
 601706142,
 -1,
 -56352,
 601789840,
 983043,
 -1,
 601826909,
 983044,
 -56350,
 601801881,
 3741,
 -1,
 601997924,
 3743,
 602153960,
 601736056,
 -1,
 602219495,
 602103498,
 -1,
 -56346,
 602195097,
 3735,
 -1,
 602260068,
 3734,
 -1,
 602182130,
 3733,
 602481645,
 602120299,
 -1,
 602547180,
 602431178,
 -1,
 -56341,
 602522777,
 3742,
 -1,
 602587748,
 3740,
 -1,
 602509810,
 3739,
 602809329,
 602442050,
 -1,
 -56337,
 602793732,
 3725,
 -56336,
 602837490,
 3737,
 -1,
 602887813,
 3719,
 603071477,
 602766636,
 983046,
 603193343,
 602998079,
 -1,
 -56332,
 603101010,
 3749,
 -1,
 603154703,
 3747,
 603333626,
 603025654,
 -1,
 603399161,
 603283146,
 -1,
 -56328,
 603374745,
 3716,
 -1,
 603439716,
 3714,
 -1,
 603361778,
 3713,
 603661309,
 603307797,
 -1,
 -56324,
 603636889,
 3722,
 -1,
 603701860,
 3754,
 603857920,
 603610826,
 -1,
 -56321,
 603833497,
 3758,
 -1,
 603898468,
 3755,
 -56319,
 603842308,
 3746,
 -56318,
 604037729,
 3751,
 -56317,
 604091493,
 983045,
 -56316,
 604148210,
 3757,
 -56315,
 604210839,
 3745,
 -56314,
 604256976,
 3732,
 -56313,
 604320268,
 3720,
 -1,
 604383931,
 3738,
 604578842,
 601677192,
 -1,
 604644366,
 604509582,
 3760,
 -56309,
 604628160,
 3779,
 -56308,
 604667976,
 3763,
 -56307,
 604725735,
 3780,
 -1,
 604771726,
 3762,
 604972048,
 604628160,
 3766,
 -1,
 604955840,
 3767,
 605103122,
 604950254,
 3768,
 -1,
 605081326,
 3769,
 605234197,
 605061352,
 -1,
 -56300,
 605197712,
 3771,
 -1,
 605232483,
 3761,
 605430807,
 605184487,
 3764,
 -1,
 605381095,
 3765,
 605561881,
 605372583,
 3776,
 -1,
 605512167,
 3777,
 -1,
 605524466,
 3778,
 605758504,
 604518820,
 -1,
 605824030,
 605733752,
 -1,
 -56291,
 605807201,
 3794,
 -1,
 605839550,
 3795,
 606020641,
 605796272,
 -1,
 -56288,
 605974364,
 3798,
 -1,
 606031023,
 3799,
 606217252,
 605965982,
 -1,
 -56285,
 606182514,
 3796,
 -1,
 606236389,
 3797,
 -56283,
 606201967,
 3792,
 -56282,
 606377506,
 3793,
 -56281,
 606440735,
 3801,
 -1,
 606487895,
 3800,
 606676014,
 605735529,
 -1,
 606741548,
 606651256,
 -1,
 -56277,
 606691815,
 3786,
 -1,
 606756551,
 3785,
 -56275,
 606684605,
 3784,
 -1,
 606875239,
 3787,
 607069233,
 606648825,
 -1,
 -56272,
 607031771,
 3773,
 -1,
 607092012,
 3772,
 607265844,
 607018698,
 -1,
 -56269,
 607227377,
 3804,
 -1,
 607291031,
 3805,
 -56267,
 607227129,
 3789,
 -56266,
 607417085,
 3782,
 -56265,
 607471132,
 3759,
 -1,
 607530402,
 3788,
 607724616,
 601599575,
 -1,
 607790150,
 607649792,
 -1,
 607855679,
 607765368,
 -1,
 607921214,
 607838820,
 -1,
 -56259,
 607892089,
 68414,
 -1,
 607927260,
 68412,
 -1,
 607892234,
 11004,
 608183362,
 607819302,
 -1,
 -56255,
 608154188,
 68415,
 -1,
 608189353,
 68413,
 -56253,
 608162960,
 10200,
 -56252,
 608335975,
 10782,
 -56251,
 608386867,
 10201,
 -1,
 608448609,
 9711,
 608698367,
 607758846,
 10923,
 -1,
 608569052,
 10925,
 -56247,
 607699115,
 9790,
 -1,
 608734406,
 917505,
 608904700,
 509567463,
 -1,
 608970071,
 608865126,
 -1,
 609035600,
 608903311,
 -1,
 609101021,
 608986133,
 -1,
 609166523,
 609035931,
 -1,
 609232029,
 609096233,
 -1,
 609297508,
 609161641,
 -1,
 609363029,
 609227811,
 -1,
 -56237,
 609321083,
 65669,
 -56236,
 609373883,
 65668,
 -1,
 609420220,
 65667,
 609625176,
 609293659,
 -1,
 -56233,
 609583197,
 65677,
 -1,
 609636007,
 65676,
 609821787,
 609555751,
 -1,
 -56230,
 609779789,
 65675,
 -1,
 609832661,
 65674,
 610018398,
 609752288,
 -1,
 -56227,
 609976427,
 65673,
 -1,
 610029258,
 65672,
 610215009,
 609948827,
 -1,
 -56224,
 610173045,
 65671,
 -1,
 610225845,
 65670,
 -56222,
 610145247,
 65666,
 -56221,
 610341686,
 65665,
 -1,
 610406864,
 65664,
 610608239,
 609227931,
 -1,
 -56218,
 610538843,
 65713,
 -56217,
 610604327,
 65712,
 -56216,
 610669792,
 65711,
 -56215,
 610735259,
 65710,
 -56214,
 610800675,
 65709,
 -56213,
 610866134,
 65708,
 -56212,
 610931573,
 65707,
 -56211,
 610996947,
 65706,
 -56210,
 611062313,
 65705,
 -1,
 611127721,
 65704,
 611329145,
 610538720,
 -1,
 -56207,
 611259739,
 65722,
 -56206,
 611325223,
 65721,
 -56205,
 611390688,
 65720,
 -56204,
 611456205,
 65719,
 -56203,
 611521494,
 65718,
 -56202,
 611586952,
 65717,
 -56201,
 611652289,
 65716,
 -56200,
 611717673,
 65715,
 -1,
 611783081,
 65714,
 611984514,
 611259427,
 -1,
 -56197,
 611915101,
 65703,
 -56196,
 611980583,
 65702,
 -56195,
 612046048,
 65701,
 -56194,
 612111318,
 65699,
 -56193,
 612176742,
 65698,
 -56192,
 612242113,
 65697,
 -56191,
 612307558,
 65696,
 -1,
 612372905,
 65695,
 612574346,
 611915047,
 -1,
 -56188,
 612504923,
 65729,
 -56187,
 612570147,
 65728,
 -56186,
 612635606,
 65727,
 -56185,
 612701030,
 65726,
 -56184,
 612766401,
 65725,
 -56183,
 612831785,
 65724,
 -1,
 612897193,
 65723,
 613098640,
 612504534,
 -1,
 -56180,
 613029019,
 65694,
 -56179,
 613094515,
 65693,
 -56178,
 613159617,
 65692,
 -56177,
 613225046,
 65691,
 -1,
 613290411,
 65690,
 613491862,
 613028545,
 -1,
 -56174,
 613422137,
 65682,
 -56173,
 613487536,
 65681,
 -56172,
 613552866,
 65680,
 -56171,
 613618227,
 65679,
 -1,
 613683703,
 65678,
 613885082,
 613421926,
 -1,
 -56168,
 613814977,
 65687,
 -56167,
 613880475,
 65686,
 -1,
 613945819,
 65685,
 614203391,
 613815643,
 -1,
 -56164,
 614077021,
 65731,
 -1,
 614142377,
 65730,
 614399999,
 609161921,
 -1,
 614409384,
 614274083,
 -1,
 -56160,
 614339931,
 65757,
 -56159,
 614405415,
 65756,
 -56158,
 614470880,
 65755,
 -56157,
 614536347,
 65754,
 -56156,
 614601763,
 65753,
 -56155,
 614667224,
 65752,
 -56154,
 614732646,
 65751,
 -56153,
 614798017,
 65750,
 -1,
 614863401,
 65749,
 615064753,
 614339542,
 -1,
 -56150,
 614995291,
 65748,
 -56149,
 615060775,
 65747,
 -56148,
 615126171,
 65745,
 -56147,
 615191587,
 65744,
 -56146,
 615257024,
 65743,
 -56145,
 615322307,
 65742,
 -56144,
 615387708,
 65741,
 -1,
 615453183,
 65740,
 615654584,
 614994790,
 -1,
 -56141,
 615584923,
 65739,
 -56140,
 615650262,
 65738,
 -56139,
 615715768,
 65737,
 -56138,
 615781057,
 65736,
 -56137,
 615846443,
 65735,
 -1,
 615911915,
 65734,
 616169471,
 615584449,
 -1,
 -56134,
 616043567,
 65733,
 -1,
 616108474,
 65732,
 616366079,
 609147934,
 -1,
 616375515,
 616239809,
 -1,
 616441032,
 616305193,
 -1,
 -56129,
 616371547,
 65778,
 -56128,
 616437031,
 65777,
 -56127,
 616502496,
 65776,
 -56126,
 616567963,
 65775,
 -56125,
 616633379,
 65774,
 -56124,
 616698838,
 65773,
 -56123,
 616764262,
 65772,
 -56122,
 616829633,
 65771,
 -56121,
 616895017,
 65770,
 -1,
 616960425,
 65769,
 617161939,
 616370601,
 -1,
 -56118,
 617092443,
 65768,
 -56117,
 617157927,
 65767,
 -56116,
 617223392,
 65766,
 -56115,
 617288859,
 65765,
 -56114,
 617354275,
 65764,
 -56113,
 617419734,
 65763,
 -56112,
 617485158,
 65762,
 -56111,
 617550529,
 65761,
 -56110,
 617615913,
 65760,
 -1,
 617681321,
 65759,
 617882842,
 617091777,
 -1,
 -56107,
 617813339,
 65784,
 -56106,
 617878823,
 65783,
 -56105,
 617944288,
 65782,
 -56104,
 618009755,
 65781,
 -56103,
 618074817,
 65780,
 -1,
 618140201,
 65779,
 -1,
 617813118,
 65785,
 -56100,
 616305612,
 65786,
 -1,
 618336941,
 65758,
 618538310,
 609075948,
 -1,
 618603827,
 618495115,
 -1,
 618669289,
 618534112,
 -1,
 -56095,
 618599748,
 65572,
 -56094,
 618665196,
 65551,
 -56093,
 618730684,
 65608,
 -56092,
 618796142,
 65592,
 -56091,
 618861578,
 65597,
 -56090,
 618926979,
 65558,
 -56089,
 618992362,
 65567,
 -56088,
 619057744,
 65603,
 -1,
 619123142,
 65554,
 619324659,
 618599459,
 -1,
 -56085,
 619255157,
 65586,
 -56084,
 619320655,
 65585,
 -56083,
 619386087,
 65546,
 -56082,
 619451481,
 65565,
 -56081,
 619516933,
 65591,
 -56080,
 619582379,
 65578,
 -56079,
 619647709,
 65564,
 -56078,
 619713099,
 65545,
 -1,
 619778529,
 65570,
 619980029,
 619254465,
 -1,
 -56075,
 619910506,
 65606,
 -56074,
 619975985,
 65538,
 -56073,
 620041480,
 65577,
 -56072,
 620106946,
 65580,
 -56071,
 620172325,
 65600,
 -56070,
 620237808,
 65562,
 -56069,
 620303248,
 65560,
 -56068,
 620368518,
 65573,
 -1,
 620433942,
 65599,
 620635399,
 619909545,
 -1,
 -56065,
 620565872,
 65582,
 -56064,
 620631337,
 65536,
 -56063,
 620696802,
 65543,
 -56062,
 620762279,
 65561,
 -56061,
 620827753,
 65589,
 -56060,
 620893184,
 65587,
 -56059,
 620958613,
 65566,
 -56058,
 621024039,
 65579,
 -1,
 621089350,
 65541,
 621290768,
 620565659,
 -1,
 -56055,
 621221242,
 65590,
 -56054,
 621286729,
 65610,
 -56053,
 621352184,
 65553,
 -56052,
 621417671,
 65611,
 -56051,
 621483080,
 65550,
 -56050,
 621548316,
 65607,
 -56049,
 621613682,
 65539,
 -1,
 621679078,
 65576,
 621880601,
 621220822,
 -1,
 -56046,
 621811006,
 65605,
 -56045,
 621876381,
 65547,
 -56044,
 621941827,
 65542,
 -56043,
 622007275,
 65552,
 -56042,
 622072680,
 65601,
 -56041,
 622138161,
 65594,
 -56040,
 622203536,
 65583,
 -1,
 622268945,
 65593,
 622470434,
 621810534,
 -1,
 -56037,
 622400869,
 65568,
 -56036,
 622466349,
 65537,
 -56035,
 622531853,
 65588,
 -56034,
 622597282,
 65549,
 -56033,
 622662565,
 65609,
 -56032,
 622727970,
 65574,
 -56031,
 622793355,
 65581,
 -1,
 622858710,
 65563,
 623060267,
 622400041,
 -1,
 -56028,
 622990616,
 65596,
 -56027,
 623056055,
 65571,
 -56026,
 623121492,
 65559,
 -56025,
 623186918,
 65544,
 -56024,
 623252350,
 65557,
 -56023,
 623317804,
 65584,
 -56022,
 623383169,
 65569,
 -1,
 623448563,
 65540,
 623650096,
 622990631,
 -1,
 -56019,
 623580434,
 65612,
 -56018,
 623645738,
 65602,
 -56017,
 623710829,
 65555,
 -1,
 623776203,
 65556,
 624033791,
 623580507,
 -1,
 -56014,
 623907477,
 65613,
 -1,
 623972788,
 65604,
 624230399,
 618562399,
 -1,
 624239929,
 624104743,
 -1,
 -56010,
 624170331,
 65629,
 -56009,
 624235675,
 65628,
 -56008,
 624300902,
 65627,
 -1,
 624366273,
 65626,
 624567612,
 624170139,
 -1,
 -56005,
 624497622,
 65624,
 -1,
 624563046,
 65623,
 624764223,
 624497622,
 -1,
 -56002,
 624694619,
 65621,
 -1,
 624760032,
 65620,
 624960834,
 624693801,
 -1,
 -55999,
 624891227,
 65617,
 -1,
 624956711,
 65616,
 -55997,
 624891172,
 65625,
 -55996,
 625087631,
 65622,
 -55995,
 625152976,
 65619,
 -1,
 625218376,
 65618,
 625475583,
 618497837,
 -1,
 625485135,
 625349161,
 -1,
 625550667,
 625415014,
 -1,
 -55990,
 625480781,
 65689,
 -1,
 625546093,
 65688,
 625747278,
 625480385,
 -1,
 -55987,
 625677621,
 65684,
 -1,
 625743089,
 65683,
 -1,
 625677458,
 65700,
 -1,
 625414987,
 65746,
 626130943,
 608960512,
 -1,
 626140502,
 626027090,
 -1,
 626206037,
 626122820,
 -1,
 -55980,
 626178513,
 10771,
 -1,
 626240659,
 10770,
 -1,
 626167509,
 10772,
 -1,
 626113039,
 8232,
 626533810,
 608927816,
 -1,
 626599345,
 626469984,
 -1,
 626664832,
 626555458,
 -1,
 626730334,
 626636720,
 -1,
 -55972,
 626702378,
 6426,
 -55971,
 626743569,
 6425,
 -1,
 626791822,
 6427,
 626992480,
 626713852,
 6421,
 -1,
 626952514,
 6410,
 627123555,
 626967416,
 -1,
 -55966,
 627071249,
 6412,
 -1,
 627119502,
 6411,
 627320166,
 627089515,
 -1,
 -55963,
 627267857,
 6417,
 -1,
 627316110,
 6416,
 627516777,
 627280194,
 -1,
 -55960,
 627463007,
 6405,
 -1,
 627512718,
 6415,
 627713388,
 627470582,
 -1,
 -55957,
 627661073,
 6402,
 -1,
 627709326,
 6401,
 627909999,
 627666839,
 -1,
 -55954,
 627857681,
 6409,
 -1,
 627905934,
 6408,
 628106610,
 627856171,
 -1,
 -55951,
 628054289,
 6404,
 -1,
 628102542,
 6403,
 628303221,
 628045356,
 -1,
 -55948,
 628250897,
 6414,
 -1,
 628299150,
 6413,
 628499832,
 628239619,
 -1,
 -55945,
 628447505,
 6407,
 -1,
 628495758,
 6406,
 628696443,
 628434587,
 -1,
 -55942,
 628644113,
 6419,
 -1,
 628692366,
 6418,
 -55940,
 628678146,
 6424,
 -55939,
 628861489,
 6422,
 -55938,
 628916373,
 6420,
 -55937,
 628978713,
 6423,
 -1,
 629037329,
 6428,
 629220757,
 626636720,
 -1,
 629286284,
 629178851,
 -1,
 629351813,
 629246274,
 -1,
 -55932,
 629298015,
 6449,
 -1,
 629347726,
 6452,
 -55930,
 629326777,
 6451,
 -55929,
 629516849,
 6455,
 -55928,
 629579984,
 6453,
 -55927,
 629637269,
 6454,
 -55926,
 629699609,
 6456,
 -55925,
 629764365,
 6448,
 -1,
 629809084,
 6450,
 630007185,
 629237233,
 -1,
 -55922,
 629979181,
 6459,
 -55921,
 630032423,
 6457,
 -55920,
 630095341,
 6464,
 -1,
 630157898,
 6458,
 630390783,
 629985207,
 -1,
 -55917,
 630318332,
 6441,
 -55916,
 630382082,
 6443,
 -1,
 630434353,
 6442,
 630597025,
 629202267,
 -1,
 630662560,
 630524478,
 -1,
 630728090,
 630592910,
 6432,
 -55911,
 630705902,
 6438,
 -1,
 630743527,
 6436,
 630924700,
 630690290,
 6440,
 -1,
 630886898,
 6437,
 631055774,
 630866087,
 6439,
 -1,
 630997159,
 6435,
 -55905,
 631033582,
 6434,
 -1,
 631136743,
 6433,
 -1,
 630591290,
 6400,
 631383471,
 630536612,
 -1,
 631448997,
 631358328,
 -1,
 -55900,
 631431777,
 6472,
 -1,
 631464126,
 6473,
 631645608,
 631420848,
 -1,
 -55897,
 631598940,
 6476,
 -1,
 631655599,
 6477,
 631842219,
 631590558,
 -1,
 -55894,
 631807090,
 6474,
 -1,
 631860965,
 6475,
 -55892,
 631826543,
 6470,
 -55891,
 632002082,
 6471,
 -55890,
 632065311,
 6479,
 -1,
 632112471,
 6478,
 -55888,
 631351616,
 6469,
 -1,
 632245671,
 6468,
 -1,
 626552346,
 13007,
 632497650,
 626508312,
 -1,
 632563183,
 632453698,
 -1,
 632628674,
 632537976,
 -1,
 632694205,
 632591910,
 -1,
 632759740,
 632654113,
 -1,
 -55880,
 632735838,
 42232,
 -55879,
 632785310,
 42236,
 -55878,
 632844388,
 42237,
 -55877,
 632895011,
 42234,
 -1,
 632957627,
 42235,
 -1,
 632719777,
 42233,
 633218496,
 632666032,
 -1,
 -55873,
 633166097,
 42206,
 -1,
 633214350,
 42205,
 -55871,
 633166097,
 42197,
 -1,
 633345422,
 42196,
 633546181,
 632606446,
 42228,
 -55868,
 633493747,
 42230,
 -1,
 633553063,
 42229,
 633742792,
 633530360,
 -1,
 -55865,
 633690385,
 42211,
 -1,
 633738638,
 42212,
 633939403,
 633714608,
 -1,
 -55862,
 633886993,
 42219,
 -1,
 633935246,
 42210,
 634136014,
 633905259,
 -1,
 -55859,
 634083601,
 42194,
 -1,
 634131854,
 42193,
 634332624,
 634098162,
 42227,
 -1,
 634273959,
 42231,
 634463699,
 634292546,
 -1,
 -55854,
 634409823,
 42213,
 -1,
 634459534,
 42208,
 634660310,
 634417398,
 -1,
 -55851,
 634607889,
 42200,
 -1,
 634656142,
 42199,
 634856921,
 634607859,
 -1,
 -55848,
 634804497,
 42216,
 -1,
 634852750,
 42214,
 635053532,
 634802987,
 -1,
 -55845,
 635001105,
 42221,
 -1,
 635049358,
 42198,
 635250142,
 634994855,
 42224,
 -1,
 635227886,
 42225,
 635381217,
 635188780,
 -1,
 -55840,
 635365386,
 42204,
 -1,
 635377038,
 42195,
 635577828,
 635317507,
 -1,
 -55837,
 635525393,
 42203,
 -1,
 635573646,
 42202,
 635774438,
 635508110,
 42222,
 -1,
 635715751,
 42223,
 -55833,
 635757820,
 42220,
 -55832,
 635888630,
 42215,
 -55831,
 635952642,
 42218,
 -55830,
 635994261,
 42207,
 -55829,
 636056601,
 42209,
 -55828,
 636120985,
 42201,
 -55827,
 636183015,
 42226,
 -55826,
 636243719,
 42217,
 -1,
 636298957,
 42192,
 636551167,
 632530813,
 -1,
 -55823,
 636441354,
 42239,
 -1,
 636498492,
 42238,
 636691961,
 632444217,
 -1,
 636757496,
 636616704,
 -1,
 -55819,
 636738330,
 10072,
 -55818,
 636795645,
 9617,
 -55817,
 636858519,
 10099,
 -1,
 636909620,
 10098,
 -1,
 636718407,
 9735,
 -55814,
 636673442,
 8374,
 -55813,
 637119036,
 8356,
 -1,
 637152135,
 9806,
 637347698,
 608845991,
 -1,
 637413094,
 637293222,
 -1,
 637478520,
 637337600,
 -1,
 637543955,
 637450160,
 -1,
 637609483,
 637511866,
 91,
 637730815,
 637534208,
 -1,
 637740552,
 637657156,
 -1,
 637806086,
 637716589,
 -1,
 -55803,
 637782700,
 10637,
 -1,
 637807365,
 10639,
 -55801,
 637784827,
 10635,
 -1,
 637970790,
 8261,
 -55799,
 637719812,
 9121,
 -55798,
 638090948,
 9123,
 -1,
 638144092,
 9122,
 638330382,
 637559271,
 -1,
 -55795,
 638291079,
 8216,
 -1,
 638335034,
 11814,
 638526993,
 638271655,
 -1,
 -55792,
 638507589,
 9609,
 -1,
 638551424,
 8907,
 -55790,
 638505072,
 11778,
 -1,
 638652735,
 10181,
 638854694,
 637512150,
 -1,
 638920229,
 638805328,
 -1,
 638985756,
 638853767,
 8596,
 639107071,
 638910464,
 -1,
 639116827,
 639033412,
 -1,
 -55783,
 639097833,
 8697,
 -55782,
 639156637,
 8622,
 -1,
 639188437,
 8700,
 -1,
 639092797,
 10568,
 639444512,
 638926022,
 8660,
 639565823,
 639372342,
 -1,
 -55777,
 639491049,
 10500,
 -1,
 639549853,
 8654,
 639706659,
 639426010,
 -1,
 -55774,
 639655497,
 11012,
 -1,
 639706649,
 8621,
 -55772,
 639670234,
 8703,
 -1,
 639838760,
 11020,
 -1,
 638851508,
 11788,
 640099888,
 638836186,
 -1,
 640165423,
 640048707,
 -1,
 640230955,
 640101635,
 -1,
 -55766,
 640210583,
 10627,
 -1,
 640260596,
 12302,
 -55764,
 640207633,
 12312,
 -55763,
 640401403,
 12314,
 -55762,
 640459176,
 10629,
 -1,
 640514441,
 12310,
 -1,
 640116012,
 10712,
 640755257,
 640036099,
 -1,
 640820790,
 640734871,
 123,
 640942079,
 640745472,
 -1,
 -55756,
 640865574,
 9127,
 -55755,
 640910682,
 9128,
 -1,
 640974581,
 9129,
 -55753,
 640784884,
 12300,
 -55752,
 641105446,
 9948,
 -1,
 641156514,
 8968,
 641345093,
 640685454,
 -1,
 641410624,
 641304898,
 -1,
 641476157,
 641357382,
 12296,
 -1,
 641404170,
 10641,
 641662975,
 641414749,
 -1,
 -55745,
 641582077,
 10203,
 -1,
 641613252,
 10202,
 641859583,
 641378774,
 -1,
 641869380,
 641775026,
 -1,
 -55741,
 641842815,
 11056,
 -1,
 641872035,
 11058,
 -1,
 641805627,
 10643,
 642131534,
 641319800,
 -1,
 642197065,
 642099670,
 -1,
 -55736,
 642147043,
 10703,
 -1,
 642195304,
 11785,
 642393676,
 642146499,
 -1,
 -55733,
 642361602,
 9610,
 -1,
 642401677,
 9613,
 -55731,
 642357853,
 12308,
 -1,
 642520976,
 8867,
 642721369,
 642066075,
 -1,
 642786902,
 642654518,
 -1,
 642852435,
 642765953,
 -1,
 -55726,
 642831353,
 10574,
 -1,
 642858648,
 10570,
 643104767,
 642793250,
 -1,
 -55723,
 643027961,
 10571,
 -1,
 643055256,
 10576,
 643301375,
 642741377,
 -1,
 -55720,
 643222289,
 10647,
 -1,
 643266953,
 12304,
 643442272,
 642661072,
 -1,
 643507807,
 643420109,
 -1,
 -55716,
 643489816,
 10714,
 -55715,
 643541413,
 8220,
 -55714,
 643604904,
 11816,
 -1,
 643636960,
 12298,
 -1,
 643484886,
 11780,
 643901029,
 643408296,
 40,
 644022271,
 643825664,
 -1,
 -55709,
 643945766,
 9115,
 -55708,
 643989237,
 9117,
 -1,
 644042332,
 9116,
 644228714,
 643863026,
 -1,
 644294249,
 644189033,
 -1,
 -55704,
 644262123,
 9614,
 -1,
 644302187,
 9615,
 -1,
 644274155,
 10197,
 644556399,
 644173470,
 -1,
 644621934,
 644506087,
 -1,
 -55699,
 644602305,
 9611,
 -1,
 644659914,
 10620,
 -1,
 644578806,
 8970,
 644884082,
 644537103,
 -1,
 -55695,
 644849744,
 9144,
 -1,
 644882603,
 11808,
 645080693,
 644831742,
 -1,
 -55692,
 645042904,
 9612,
 -1,
 645076884,
 9686,
 -55690,
 645041731,
 8905,
 -55689,
 645236785,
 10204,
 -1,
 645299860,
 11804,
 645474008,
 637460012,
 -1,
 645539488,
 645407367,
 8592,
 645605023,
 645464064,
 -1,
 645670540,
 645587012,
 -1,
 645736068,
 645645176,
 -1,
 645801601,
 645667171,
 8610,
 645922815,
 645729334,
 -1,
 -55680,
 645848041,
 11065,
 -1,
 645873109,
 11066,
 646119423,
 645753899,
 -1,
 -55677,
 646043085,
 11025,
 -1,
 646070096,
 11024,
 646260359,
 645675728,
 -1,
 -55674,
 646238246,
 8698,
 -1,
 646302924,
 11064,
 -55672,
 646241257,
 8695,
 -55671,
 646431133,
 8602,
 -55670,
 646489299,
 10566,
 -55669,
 646544881,
 8619,
 -1,
 646602504,
 8617,
 646784661,
 645645176,
 -1,
 646850193,
 646746621,
 -1,
 646915728,
 646783105,
 8676,
 -1,
 646842350,
 8633,
 -1,
 646870151,
 10525,
 647167999,
 646799682,
 -1,
 -55661,
 647095254,
 11070,
 -55660,
 647152156,
 10618,
 -1,
 647199159,
 10615,
 647374492,
 646715029,
 -1,
 647440025,
 647343555,
 -1,
 -55656,
 647415997,
 11083,
 -1,
 647437382,
 11074,
 -55654,
 647415997,
 10611,
 -55653,
 647609379,
 10563,
 -1,
 647633990,
 11082,
 647833246,
 647320215,
 8612,
 -1,
 647760822,
 10527,
 -1,
 647798406,
 8646,
 -1,
 645534092,
 10521,
 648095412,
 645487394,
 -1,
 648160947,
 648077400,
 -1,
 648226476,
 648139688,
 -1,
 648292011,
 648151040,
 -1,
 648357545,
 648222357,
 -1,
 648423080,
 648311748,
 -1,
 -55641,
 648386175,
 10602,
 -1,
 648430708,
 10594,
 -1,
 648393112,
 10598,
 -55638,
 648333789,
 10578,
 -1,
 648630935,
 10586,
 -1,
 648273446,
 8636,
 648937471,
 648166991,
 -1,
 648947378,
 648806400,
 -1,
 -55633,
 648923613,
 10582,
 -55632,
 648958615,
 10590,
 -55631,
 649013381,
 10603,
 -1,
 649074435,
 10599,
 -1,
 648928806,
 8637,
 -1,
 648126108,
 8651,
 649406149,
 648070008,
 -1,
 649471682,
 649388641,
 -1,
 649537217,
 649400262,
 -1,
 649602752,
 649470605,
 -1,
 649668287,
 649584708,
 -1,
 649733821,
 649643047,
 11067,
 649854975,
 649661494,
 -1,
 -55620,
 649780201,
 11068,
 -1,
 649805269,
 11069,
 -55618,
 649714665,
 11060,
 -1,
 649936341,
 11061,
 -1,
 649613975,
 11062,
 -1,
 649579543,
 11063,
 -1,
 649462884,
 8606,
 650379263,
 649441971,
 -1,
 -55612,
 650262298,
 10510,
 -1,
 650322567,
 8666,
 650520272,
 649344556,
 -1,
 650585807,
 650484662,
 -1,
 650651342,
 650519175,
 8656,
 650716877,
 650575872,
 -1,
 650782412,
 650698820,
 -1,
 -55605,
 650763241,
 10498,
 -1,
 650822045,
 8653,
 -1,
 650728087,
 10502,
 -1,
 650645900,
 10523,
 -1,
 650589978,
 10508,
 -1,
 650519466,
 8672,
 651241171,
 650501594,
 -1,
 -55598,
 651189833,
 8678,
 -1,
 651240985,
 8604,
 -55596,
 651214893,
 8668,
 -55595,
 651405413,
 11077,
 -55594,
 651469066,
 8647,
 -55593,
 651532250,
 8701,
 -1,
 651569704,
 11013,
 651821055,
 645402342,
 -1,
 651831005,
 651741726,
 -1,
 -55589,
 651796326,
 8237,
 -55588,
 651854525,
 8206,
 -1,
 651904634,
 8234,
 652093153,
 651797871,
 -1,
 -55585,
 652033176,
 171,
 -55584,
 652097005,
 10748,
 -1,
 652156640,
 9001,
 652355300,
 652064688,
 -1,
 -55581,
 652305336,
 10553,
 -1,
 652368192,
 10154,
 652607487,
 652300048,
 4054,
 -1,
 652479808,
 4056,
 652683083,
 637379113,
 -1,
 652748573,
 652638786,
 -1,
 652814065,
 652723064,
 -1,
 652879596,
 652788600,
 -1,
 -55573,
 652826897,
 7246,
 -1,
 652875150,
 7245,
 653076207,
 652851120,
 -1,
 -55570,
 653023505,
 7192,
 -1,
 653071758,
 7191,
 -55568,
 653023505,
 7179,
 -1,
 653202830,
 7178,
 653403893,
 652779627,
 -1,
 -55565,
 653358105,
 7183,
 -55564,
 653416721,
 7184,
 -1,
 653464974,
 7182,
 653666041,
 653363522,
 -1,
 -55561,
 653649148,
 7177,
 -55560,
 653677407,
 7173,
 -1,
 653727118,
 7181,
 653928189,
 653619446,
 -1,
 -55557,
 653882393,
 7169,
 -55556,
 653941009,
 7170,
 -1,
 653989262,
 7168,
 654190337,
 653866540,
 -1,
 -55553,
 654174218,
 7193,
 -55552,
 654194327,
 7247,
 -1,
 654251406,
 7180,
 654452484,
 654161840,
 -1,
 -55549,
 654399761,
 7201,
 -1,
 654448014,
 7200,
 654649095,
 654409800,
 -1,
 -55546,
 654603289,
 7190,
 -1,
 654644622,
 7189,
 654845706,
 654596339,
 -1,
 -55543,
 654799897,
 7198,
 -1,
 654841230,
 7197,
 655042317,
 654791467,
 -1,
 -55540,
 654996505,
 7172,
 -1,
 655037838,
 7171,
 655238928,
 654986910,
 -1,
 -55537,
 655193113,
 7186,
 -1,
 655234446,
 7185,
 655435539,
 655174915,
 -1,
 -55534,
 655382801,
 7175,
 -1,
 655431054,
 7174,
 655632150,
 655369883,
 -1,
 -55531,
 655586329,
 7188,
 -1,
 655627662,
 7187,
 -55529,
 655615228,
 7194,
 -55528,
 655810050,
 7202,
 -55527,
 655874164,
 7199,
 -55526,
 655927857,
 7195,
 -55525,
 655979545,
 7196,
 -55524,
 656043929,
 7176,
 -1,
 656086414,
 7203,
 656287531,
 652687780,
 -1,
 656353057,
 656262008,
 -1,
 -55520,
 656335457,
 7234,
 -1,
 656367806,
 7235,
 656549668,
 656324528,
 -1,
 -55517,
 656502620,
 7238,
 -1,
 656559279,
 7239,
 656746279,
 656494238,
 -1,
 -55514,
 656710770,
 7236,
 -1,
 656764645,
 7237,
 -55512,
 656730223,
 7232,
 -55511,
 656905762,
 7233,
 -55510,
 656968991,
 7241,
 -1,
 657016151,
 7240,
 657205045,
 656224959,
 -1,
 657270574,
 657164610,
 7216,
 -1,
 657254062,
 7220,
 657401648,
 657223926,
 7213,
 -1,
 657333893,
 7221,
 -55503,
 657376120,
 7219,
 -55502,
 657500630,
 7218,
 -55501,
 657563755,
 7217,
 -55500,
 657621064,
 7214,
 -1,
 657683396,
 7215,
 657860413,
 657186184,
 -1,
 657925944,
 657837806,
 7210,
 -1,
 657903342,
 7211,
 658057018,
 657887730,
 7208,
 -1,
 658018802,
 7209,
 -55493,
 658006503,
 7207,
 -55492,
 658129063,
 7212,
 -1,
 658183697,
 7206,
 658384708,
 657827709,
 -1,
 658450242,
 658359160,
 -1,
 658515777,
 658422754,
 7231,
 -1,
 658440853,
 7230,
 -1,
 658445826,
 7227,
 -55485,
 658411936,
 7228,
 -1,
 658648886,
 7229,
 658898943,
 658356144,
 -1,
 658909000,
 658821047,
 -1,
 -55481,
 658892028,
 7204,
 -1,
 658942513,
 7205,
 659161087,
 658859505,
 -1,
 -55478,
 659073821,
 7222,
 -1,
 659132568,
 7223,
 659302257,
 652656711,
 -1,
 659367769,
 659263986,
 -1,
 659433304,
 659335640,
 -1,
 659498835,
 659406345,
 10877,
 659619839,
 659426580,
 -1,
 659629906,
 659494543,
 10881,
 -1,
 659556854,
 10883,
 -1,
 659581431,
 10879,
 659826518,
 659441942,
 -1,
 -55467,
 659779284,
 8818,
 -1,
 659823178,
 8804,
 -55465,
 659773279,
 8822,
 -1,
 659955791,
 10885,
 -1,
 659413595,
 8806,
 660219750,
 659297678,
 -1,
 660285283,
 660155251,
 -1,
 660350816,
 660256688,
 -1,
 660416351,
 660301635,
 -1,
 -55458,
 660379782,
 10893,
 -1,
 660412089,
 10895,
 -1,
 660370793,
 10899,
 -55455,
 660306101,
 10614,
 -55454,
 660625260,
 10897,
 -1,
 660684268,
 10891,
 660930559,
 660245187,
 -1,
 -55451,
 660848003,
 10887,
 -1,
 660901550,
 10889,
 661071722,
 660201540,
 -1,
 -55448,
 661039438,
 10875,
 -55447,
 661076788,
 8918,
 -1,
 661139568,
 10873,
 661333868,
 661008826,
 10918,
 -1,
 661258273,
 10920,
 661464943,
 661269666,
 -1,
 -55442,
 661417684,
 8934,
 -1,
 661461578,
 8808,
 -55440,
 661437628,
 60,
 -1,
 661604669,
 8922,
 -1,
 659263986,
 9804,
 661858222,
 637330624,
 -1,
 661923729,
 661794883,
 -1,
 661989239,
 661898104,
 66199,
 -55434,
 661963640,
 66200,
 -1,
 662001907,
 66185,
 662185849,
 661948738,
 66191,
 -1,
 662145346,
 66193,
 662316923,
 662143048,
 66190,
 -1,
 662274120,
 66192,
 662447997,
 662270198,
 66187,
 -1,
 662401270,
 66196,
 662579071,
 662388903,
 66177,
 -1,
 662538562,
 66202,
 662710145,
 662513307,
 66178,
 -1,
 662657267,
 66179,
 662841219,
 662640014,
 66176,
 -1,
 662800706,
 66201,
 -55420,
 662824952,
 66184,
 -55419,
 662954966,
 66204,
 -55418,
 663018970,
 66183,
 -55417,
 663080686,
 66194,
 -55416,
 663140272,
 66198,
 -55415,
 663202262,
 66197,
 -55414,
 663267270,
 66188,
 -55413,
 663330923,
 66195,
 -55412,
 663385028,
 66189,
 -55411,
 663449495,
 66186,
 -55410,
 663511527,
 66182,
 -55409,
 663574771,
 66203,
 -55408,
 663638827,
 66180,
 -1,
 663696940,
 66181,
 663945215,
 661862721,
 -1,
 663955373,
 663845442,
 -1,
 664020885,
 663929720,
 67887,
 -1,
 663995256,
 67892,
 664151959,
 663992240,
 67891,
 -1,
 664123312,
 67886,
 664283033,
 664111426,
 67883,
 -1,
 664242498,
 67896,
 664414107,
 664236996,
 67881,
 -1,
 664396992,
 67895,
 664545181,
 664354983,
 67876,
 -1,
 664504642,
 67894,
 664676255,
 664475022,
 67872,
 -1,
 664635714,
 67893,
 -55392,
 664659136,
 67879,
 -55391,
 664787046,
 67877,
 -55390,
 664850158,
 67888,
 -55389,
 664906198,
 67885,
 -55388,
 664971206,
 67890,
 -55387,
 665031154,
 67884,
 -55386,
 665092168,
 67882,
 -55385,
 665153782,
 67880,
 -55384,
 665215463,
 67878,
 -55383,
 665277227,
 67874,
 -55382,
 665341598,
 67889,
 -55381,
 665400876,
 67875,
 -55380,
 665464067,
 67897,
 -1,
 665527963,
 67873,
 -1,
 663931848,
 67903,
 665790463,
 661819890,
 -1,
 665855951,
 665771482,
 -1,
 665921483,
 665799042,
 -1,
 665987002,
 665890548,
 -1,
 666052533,
 665958320,
 -1,
 -55372,
 665999709,
 10065,
 -1,
 666060420,
 10558,
 -55370,
 666028958,
 9727,
 -55369,
 666216527,
 9694,
 -55368,
 666280620,
 9998,
 -55367,
 666320907,
 10063,
 -1,
 666383281,
 10195,
 666576830,
 665941750,
 -1,
 -55364,
 666553246,
 9722,
 -55363,
 666614192,
 10559,
 -1,
 666675279,
 9695,
 666838978,
 666524152,
 -1,
 -55360,
 666790694,
 9691,
 -55359,
 666841185,
 9697,
 -1,
 666905269,
 9604,
 667101125,
 666814435,
 -1,
 -55356,
 667068674,
 9606,
 -1,
 667108749,
 9603,
 667297736,
 667063846,
 -1,
 -55353,
 667265259,
 9602,
 -1,
 667305323,
 9601,
 -55351,
 667269752,
 9607,
 -55350,
 667439361,
 9605,
 -1,
 667495059,
 9987,
 667746303,
 665845760,
 -1,
 -55347,
 667646805,
 95,
 -55346,
 667696484,
 12319,
 -1,
 667755561,
 8270,
 667953127,
 665816093,
 -1,
 668018652,
 667907825,
 -1,
 668084183,
 667999788,
 -1,
 668149716,
 668024006,
 10232,
 -1,
 668074975,
 10237,
 668280790,
 668082823,
 10229,
 -1,
 668206047,
 10235,
 -1,
 668254253,
 11059,
 668532735,
 668008448,
 -1,
 668542939,
 668446452,
 -1,
 -55334,
 668482758,
 10234,
 -1,
 668541575,
 10231,
 -1,
 668517373,
 10206,
 668805092,
 667987694,
 -1,
 668870627,
 668786220,
 -1,
 668936160,
 668810438,
 10233,
 -1,
 668861407,
 10238,
 669067234,
 668869255,
 10230,
 -1,
 668992479,
 10236,
 -1,
 669040685,
 10239,
 -1,
 668797615,
 10205,
 669384703,
 668743212,
 -1,
 -55322,
 669282109,
 10188,
 -1,
 669328253,
 10982,
 669526013,
 667899369,
 -1,
 669591539,
 669489272,
 8744,
 669712383,
 669515776,
 -1,
 669722610,
 669638724,
 -1,
 669788144,
 669661904,
 -1,
 669853679,
 669765581,
 -1,
 -55314,
 669831931,
 10851,
 -1,
 669884204,
 10850,
 -1,
 669827965,
 10834,
 -55311,
 669746535,
 10843,
 -1,
 670064484,
 10845,
 -1,
 669687613,
 10841,
 670367743,
 669523340,
 8743,
 670433279,
 670239798,
 -1,
 670443514,
 670317264,
 -1,
 670509049,
 670420941,
 -1,
 -55304,
 670487291,
 10848,
 -1,
 670539564,
 10846,
 -1,
 670483325,
 10833,
 -55301,
 670421755,
 10847,
 -55300,
 670729575,
 10842,
 -1,
 670785380,
 10844,
 671023103,
 669509733,
 9674,
 -1,
 670892908,
 10208,
 -1,
 665715201,
 8468,
 671166271,
 509493415,
 -1,
 671231143,
 671111376,
 -1,
 671295618,
 671159694,
 -1,
 671361115,
 671224233,
 -1,
 671426579,
 671290326,
 -1,
 671492103,
 671355939,
 77877,
 -1,
 671421838,
 77878,
 671623177,
 671421286,
 77874,
 -1,
 671552910,
 77875,
 671754251,
 671552193,
 77872,
 -1,
 671683982,
 77873,
 671885325,
 671682985,
 77869,
 -1,
 671815054,
 77870,
 -55282,
 671815003,
 77882,
 -55281,
 671946023,
 77881,
 -55280,
 672011488,
 77880,
 -55279,
 672076955,
 77879,
 -55278,
 672142294,
 77876,
 -1,
 672207401,
 77871,
 672409632,
 671355433,
 -1,
 672475158,
 672339168,
 77844,
 -1,
 672404878,
 77845,
 672606232,
 672404438,
 77840,
 -1,
 672535950,
 77841,
 -55271,
 672535899,
 77847,
 -55270,
 672666919,
 77846,
 -55269,
 672732315,
 77843,
 -55268,
 672797731,
 77842,
 -55267,
 672863078,
 77839,
 -55266,
 672928449,
 77838,
 -55265,
 672993833,
 77837,
 -1,
 673059241,
 77836,
 673261613,
 672338345,
 -1,
 673327140,
 673191067,
 77830,
 -55261,
 673261211,
 77832,
 -1,
 673322382,
 77831,
 673523750,
 673256483,
 77828,
 -1,
 673453454,
 77829,
 -55257,
 673453403,
 77835,
 -55256,
 673584423,
 77834,
 -55255,
 673649888,
 77833,
 -55254,
 673715158,
 77827,
 -55253,
 673780582,
 77826,
 -55252,
 673845953,
 77825,
 -1,
 673911337,
 77824,
 674113593,
 673190758,
 -1,
 674179120,
 674042561,
 77860,
 -1,
 674108814,
 77861,
 -55247,
 674108763,
 77868,
 -55246,
 674239783,
 77867,
 -55245,
 674305248,
 77866,
 -55244,
 674370715,
 77865,
 -55243,
 674436131,
 77864,
 -55242,
 674501590,
 77863,
 -55241,
 674567014,
 77862,
 -55240,
 674632233,
 77859,
 -1,
 674697641,
 77858,
 674900036,
 674043035,
 -1,
 -55237,
 674829659,
 77902,
 -55236,
 674895143,
 77901,
 -55235,
 674960608,
 77900,
 -55234,
 675026075,
 77899,
 -55233,
 675091491,
 77898,
 -55232,
 675156950,
 77897,
 -55231,
 675222374,
 77896,
 -55230,
 675287745,
 77895,
 -55229,
 675353129,
 77894,
 -1,
 675418537,
 77893,
 675620943,
 674829347,
 -1,
 -55226,
 675550555,
 77892,
 -55225,
 675616039,
 77891,
 -55224,
 675681504,
 77890,
 -55223,
 675746971,
 77889,
 -55222,
 675812387,
 77888,
 -55221,
 675877846,
 77887,
 -55220,
 675943270,
 77886,
 -55219,
 676008641,
 77885,
 -55218,
 676074025,
 77884,
 -1,
 676139433,
 77883,
 676341850,
 675549889,
 -1,
 -55215,
 676271451,
 77857,
 -55214,
 676336935,
 77856,
 -55213,
 676402400,
 77855,
 -55212,
 676467867,
 77854,
 -55211,
 676533283,
 77853,
 -55210,
 676598742,
 77852,
 -55209,
 676664166,
 77851,
 -55208,
 676729537,
 77850,
 -55207,
 676794921,
 77849,
 -1,
 676860329,
 77848,
 -1,
 676271389,
 77903,
 677183487,
 671290888,
 -1,
 677193832,
 677056937,
 -1,
 677259360,
 677123296,
 78867,
 -55201,
 677193371,
 78869,
 -1,
 677254542,
 78868,
 -55199,
 677188955,
 78871,
 -55198,
 677385511,
 78870,
 -55197,
 677450907,
 78866,
 -55196,
 677516323,
 78865,
 -55195,
 677581782,
 78864,
 -55194,
 677647206,
 78863,
 -55193,
 677712577,
 78862,
 -1,
 677777961,
 78861,
 677980275,
 677122753,
 -1,
 -55190,
 677909851,
 78891,
 -55189,
 677975335,
 78890,
 -55188,
 678040800,
 78889,
 -55187,
 678106267,
 78888,
 -55186,
 678171683,
 78887,
 -55185,
 678237142,
 78886,
 -55184,
 678302566,
 78885,
 -55183,
 678367937,
 78884,
 -55182,
 678433321,
 78883,
 -1,
 678498729,
 78882,
 678701182,
 677909033,
 -1,
 -55179,
 678630747,
 78881,
 -55178,
 678696231,
 78880,
 -55177,
 678761696,
 78879,
 -55176,
 678827163,
 78878,
 -55175,
 678892579,
 78877,
 -55174,
 678958038,
 78876,
 -55173,
 679023462,
 78875,
 -55172,
 679088833,
 78874,
 -55171,
 679154217,
 78873,
 -1,
 679219625,
 78872,
 679477247,
 678630246,
 -1,
 -55168,
 679350977,
 78894,
 -55167,
 679416361,
 78893,
 -1,
 679481769,
 78892,
 679684337,
 671254850,
 -1,
 679749818,
 679612841,
 -1,
 679815315,
 679678822,
 -1,
 679880839,
 679744736,
 78361,
 -1,
 679810446,
 78362,
 680011913,
 679810083,
 78358,
 -1,
 679941518,
 78359,
 680142987,
 679941078,
 78356,
 -1,
 680072590,
 78357,
 680274061,
 680072038,
 78354,
 -1,
 680203662,
 78355,
 -55154,
 680203611,
 78364,
 -55153,
 680334631,
 78363,
 -55152,
 680400027,
 78360,
 -55151,
 680465089,
 78353,
 -55150,
 680530473,
 78352,
 -1,
 680595881,
 78351,
 680798368,
 679744041,
 -1,
 680863895,
 680727847,
 78336,
 -55146,
 680797851,
 78338,
 -1,
 680859022,
 78337,
 -55144,
 680793435,
 78339,
 -55143,
 680989920,
 78335,
 -55142,
 681055387,
 78334,
 -55141,
 681120803,
 78333,
 -55140,
 681186262,
 78332,
 -55139,
 681251686,
 78331,
 -55138,
 681317057,
 78330,
 -55137,
 681382441,
 78329,
 -1,
 681447849,
 78328,
 681650348,
 680727233,
 -1,
 681715875,
 681579555,
 78345,
 -1,
 681645454,
 78346,
 -55132,
 681645403,
 78350,
 -55131,
 681776423,
 78349,
 -55130,
 681841888,
 78348,
 -55129,
 681907355,
 78347,
 -55128,
 681972694,
 78344,
 -55127,
 682038118,
 78343,
 -55126,
 682103489,
 78342,
 -55125,
 682168873,
 78341,
 -1,
 682234281,
 78340,
 682436790,
 681578921,
 -1,
 -55122,
 682366299,
 78327,
 -55121,
 682431783,
 78326,
 -55120,
 682497248,
 78325,
 -55119,
 682562715,
 78324,
 -55118,
 682628131,
 78323,
 -55117,
 682693590,
 78322,
 -55116,
 682759014,
 78321,
 -55115,
 682824385,
 78320,
 -1,
 682889769,
 78319,
 683147263,
 682365910,
 -1,
 -55112,
 683020993,
 78367,
 -55111,
 683086377,
 78366,
 -1,
 683151785,
 78365,
 683354328,
 679726926,
 -1,
 683419849,
 683282985,
 -1,
 683485374,
 683349287,
 78409,
 -1,
 683414926,
 78410,
 683616448,
 683414057,
 78401,
 -1,
 683545998,
 78402,
 683747522,
 683545001,
 78399,
 -1,
 683677070,
 78400,
 -55101,
 683677019,
 78411,
 -55100,
 683807968,
 78408,
 -55099,
 683873435,
 78407,
 -55098,
 683938851,
 78406,
 -55097,
 684004310,
 78405,
 -55096,
 684069734,
 78404,
 -1,
 684135105,
 78403,
 684337363,
 683348393,
 -1,
 -55093,
 684266843,
 78398,
 -55092,
 684332327,
 78397,
 -55091,
 684397792,
 78396,
 -55090,
 684463259,
 78395,
 -55089,
 684528675,
 78394,
 -55088,
 684594134,
 78393,
 -55087,
 684659558,
 78392,
 -55086,
 684724929,
 78391,
 -1,
 684790313,
 78390,
 685047807,
 684266177,
 -1,
 685058262,
 684921537,
 78414,
 -1,
 684987790,
 78415,
 -55081,
 684986921,
 78413,
 -1,
 685117865,
 78412,
 685375487,
 683308047,
 -1,
 685385957,
 685249065,
 -1,
 685451484,
 685315296,
 78385,
 -1,
 685381006,
 78386,
 -55075,
 685380955,
 78388,
 -55074,
 685511975,
 78387,
 -55073,
 685577371,
 78384,
 -55072,
 685642787,
 78383,
 -55071,
 685708246,
 78382,
 -55070,
 685773670,
 78381,
 -55069,
 685839041,
 78380,
 -55068,
 685904425,
 78379,
 -1,
 685969833,
 78378,
 686172400,
 685314473,
 -1,
 686237928,
 686101539,
 78372,
 -1,
 686167438,
 78373,
 -55063,
 686167387,
 78377,
 -55062,
 686298407,
 78376,
 -55061,
 686363872,
 78375,
 -55060,
 686429339,
 78374,
 -55059,
 686494678,
 78371,
 -55058,
 686560102,
 78370,
 -55057,
 686625473,
 78369,
 -1,
 686690857,
 78368,
 -1,
 686101314,
 78389,
 686958933,
 679622284,
 -1,
 687024392,
 686887971,
 -1,
 687089917,
 686952873,
 77997,
 -55051,
 687038951,
 78006,
 -55050,
 687102195,
 78005,
 -55049,
 687166251,
 78004,
 -55048,
 687230622,
 78003,
 -55047,
 687292583,
 78002,
 -55046,
 687355436,
 78001,
 -55045,
 687418627,
 78000,
 -55044,
 687482523,
 77999,
 -1,
 687543694,
 77998,
 687745279,
 687018966,
 78011,
 -1,
 687674766,
 78012,
 687876353,
 687674049,
 78008,
 -1,
 687805838,
 78009,
 -55038,
 687805787,
 78017,
 -55037,
 687936807,
 78016,
 -55036,
 688002272,
 78015,
 -55035,
 688067739,
 78014,
 -55034,
 688133155,
 78013,
 -55033,
 688198502,
 78010,
 -1,
 688263721,
 78007,
 688466201,
 686953627,
 -1,
 688531730,
 688395488,
 78025,
 -55029,
 688478451,
 78033,
 -55028,
 688542507,
 78032,
 -55027,
 688606878,
 78031,
 -55026,
 688668839,
 78030,
 -55025,
 688731692,
 78029,
 -55024,
 688794883,
 78028,
 -55023,
 688858779,
 78027,
 -1,
 688919950,
 78026,
 -55021,
 688460955,
 78024,
 -55020,
 689050659,
 78023,
 -55019,
 689116118,
 78022,
 -55018,
 689181542,
 78021,
 -55017,
 689246913,
 78020,
 -55016,
 689312297,
 78019,
 -1,
 689377705,
 78018,
 689580326,
 688395222,
 -1,
 689645852,
 689509671,
 77994,
 -1,
 689575310,
 77995,
 689776926,
 689575067,
 77991,
 -1,
 689706382,
 77992,
 -55009,
 689706331,
 77996,
 -55008,
 689837280,
 77993,
 -55007,
 689902627,
 77990,
 -55006,
 689968086,
 77989,
 -55005,
 690033510,
 77988,
 -55004,
 690098881,
 77987,
 -55003,
 690164265,
 77986,
 -1,
 690229673,
 77985,
 690432307,
 689509222,
 -1,
 690497833,
 690361302,
 77978,
 -1,
 690427278,
 77979,
 690628907,
 690426409,
 77974,
 -1,
 690558350,
 77975,
 -54996,
 690558299,
 77984,
 -54995,
 690689319,
 77983,
 -54994,
 690754784,
 77982,
 -54993,
 690820251,
 77981,
 -54992,
 690885667,
 77980,
 -54991,
 690951014,
 77977,
 -54990,
 691016385,
 77976,
 -1,
 691081641,
 77973,
 691284287,
 690361025,
 -1,
 691349814,
 691213536,
 77969,
 -1,
 691279246,
 77970,
 -54985,
 691279195,
 77972,
 -54984,
 691410215,
 77971,
 -54983,
 691475611,
 77968,
 -54982,
 691541027,
 77967,
 -54981,
 691606486,
 77966,
 -54980,
 691671910,
 77965,
 -54979,
 691737281,
 77964,
 -54978,
 691802665,
 77963,
 -1,
 691868073,
 77962,
 692070730,
 691212841,
 -1,
 -54975,
 692000091,
 77961,
 -54974,
 692065575,
 77960,
 -54973,
 692131040,
 77959,
 -54972,
 692196507,
 77958,
 -54971,
 692261923,
 77957,
 -54970,
 692327382,
 77956,
 -54969,
 692392806,
 77955,
 -54968,
 692458177,
 77954,
 -54967,
 692523561,
 77953,
 -1,
 692588969,
 77952,
 692846591,
 691999145,
 -1,
 692857165,
 692720935,
 77949,
 -1,
 692786574,
 77950,
 -54962,
 692786523,
 77951,
 -54961,
 692917472,
 77948,
 -54960,
 692982939,
 77947,
 -54959,
 693048355,
 77946,
 -54958,
 693113814,
 77945,
 -54957,
 693179238,
 77944,
 -54956,
 693244609,
 77943,
 -1,
 693309993,
 77942,
 693512615,
 686938225,
 -1,
 693578096,
 693441217,
 -1,
 693643620,
 693506473,
 78726,
 -54951,
 693597124,
 78738,
 -54950,
 693661942,
 78737,
 -54949,
 693727127,
 78736,
 -54948,
 693789159,
 78735,
 -54947,
 693852403,
 78734,
 -54946,
 693916459,
 78733,
 -54945,
 693980830,
 78732,
 -54944,
 694042791,
 78731,
 -54943,
 694105644,
 78730,
 -54942,
 694168835,
 78729,
 -54941,
 694232731,
 78728,
 -1,
 694293902,
 78727,
 694495590,
 693572955,
 78749,
 -1,
 694424974,
 78750,
 694626664,
 694424871,
 78747,
 -1,
 694556046,
 78748,
 694757738,
 694555494,
 78741,
 -1,
 694687118,
 78742,
 -54933,
 694686944,
 78746,
 -54932,
 694817947,
 78745,
 -54931,
 694883363,
 78744,
 -54930,
 694948822,
 78743,
 -54929,
 695014081,
 78740,
 -1,
 695079465,
 78739,
 695282054,
 693506473,
 -1,
 695347579,
 695210537,
 78690,
 -54925,
 695296487,
 78699,
 -54924,
 695359731,
 78698,
 -54923,
 695423787,
 78697,
 -54922,
 695488158,
 78696,
 -54921,
 695550119,
 78695,
 -54920,
 695612972,
 78694,
 -54919,
 695676163,
 78693,
 -54918,
 695740059,
 78692,
 -1,
 695801230,
 78691,
 696002942,
 695276768,
 78706,
 -54915,
 695936667,
 78708,
 -1,
 695997838,
 78707,
 696199552,
 695931585,
 78700,
 -1,
 696128910,
 78701,
 -54911,
 696128859,
 78710,
 -54910,
 696259879,
 78709,
 -54909,
 696325275,
 78705,
 -54908,
 696390691,
 78704,
 -54907,
 696456150,
 78703,
 -1,
 696521574,
 78702,
 696723862,
 695210537,
 -1,
 696789387,
 696652329,
 78712,
 -54903,
 696724739,
 78715,
 -54902,
 696788635,
 78714,
 -1,
 696849806,
 78713,
 697051534,
 696718017,
 78716,
 -54899,
 696985243,
 78718,
 -1,
 697046414,
 78717,
 -54897,
 696980827,
 78725,
 -54896,
 697177383,
 78724,
 -54895,
 697242848,
 78723,
 -54894,
 697308315,
 78722,
 -54893,
 697373731,
 78721,
 -54892,
 697439190,
 78720,
 -54891,
 697504614,
 78719,
 -1,
 697569705,
 78711,
 697772453,
 696652646,
 -1,
 697837977,
 697701600,
 78761,
 -1,
 697767310,
 78762,
 697969051,
 697766758,
 78756,
 -1,
 697898382,
 78757,
 698100125,
 697897513,
 78753,
 -1,
 698029454,
 78754,
 698231199,
 698028457,
 78751,
 -1,
 698160526,
 78752,
 -54880,
 698160475,
 78764,
 -54879,
 698291495,
 78763,
 -54878,
 698356891,
 78760,
 -54877,
 698422307,
 78759,
 -54876,
 698487766,
 78758,
 -1,
 698553025,
 78755,
 698810367,
 697701395,
 78765,
 -1,
 698684814,
 78766,
 698886649,
 693473850,
 -1,
 698952122,
 698814889,
 -1,
 699017648,
 698881179,
 78423,
 -54869,
 698961566,
 78429,
 -54868,
 699023527,
 78428,
 -54867,
 699086380,
 78427,
 -54866,
 699149571,
 78426,
 -54865,
 699213467,
 78425,
 -1,
 699274638,
 78424,
 699476402,
 698946595,
 78421,
 -1,
 699405710,
 78422,
 699607476,
 699404841,
 78416,
 -1,
 699536782,
 78417,
 -54859,
 699536731,
 78432,
 -54858,
 699667751,
 78431,
 -54857,
 699733216,
 78430,
 -54856,
 699798486,
 78420,
 -54855,
 699863910,
 78419,
 -1,
 699929281,
 78418,
 700131787,
 698880870,
 -1,
 700197312,
 700060827,
 78469,
 -54851,
 700134956,
 78473,
 -54850,
 700198147,
 78472,
 -54849,
 700262043,
 78471,
 -1,
 700323214,
 78470,
 700524994,
 700126054,
 78465,
 -1,
 700454286,
 78466,
 700656068,
 700453289,
 78461,
 -1,
 700585358,
 78462,
 -54843,
 700585307,
 78476,
 -54842,
 700716327,
 78475,
 -54841,
 700781792,
 78474,
 -54840,
 700847139,
 78468,
 -54839,
 700912598,
 78467,
 -54838,
 700977857,
 78464,
 -1,
 701043241,
 78463,
 701245914,
 700060353,
 -1,
 701311438,
 701175131,
 78459,
 -1,
 701240718,
 78460,
 701442512,
 701240355,
 78454,
 -1,
 701371790,
 78455,
 701573586,
 701371350,
 78452,
 -1,
 701502862,
 78453,
 701704660,
 701501865,
 78447,
 -1,
 701633934,
 78448,
 -54827,
 701633831,
 78458,
 -54826,
 701764832,
 78457,
 -54825,
 701830299,
 78456,
 -54824,
 701895526,
 78451,
 -54823,
 701960897,
 78450,
 -1,
 702026281,
 78449,
 702228969,
 701174313,
 -1,
 702294495,
 702157225,
 78433,
 -54819,
 702229763,
 78436,
 -54818,
 702293659,
 78435,
 -1,
 702354830,
 78434,
 702556641,
 702223707,
 78445,
 -1,
 702485902,
 78446,
 -54814,
 702485799,
 78444,
 -54813,
 702616800,
 78443,
 -54812,
 702682267,
 78442,
 -54811,
 702747683,
 78441,
 -54810,
 702813142,
 78440,
 -54809,
 702878566,
 78439,
 -54808,
 702943937,
 78438,
 -1,
 703009321,
 78437,
 703212020,
 702157782,
 -1,
 -54805,
 703141211,
 78486,
 -54804,
 703206695,
 78485,
 -54803,
 703272160,
 78484,
 -54802,
 703337627,
 78483,
 -54801,
 703403043,
 78482,
 -54800,
 703468502,
 78481,
 -54799,
 703533926,
 78480,
 -54798,
 703599297,
 78479,
 -54797,
 703664681,
 78478,
 -1,
 703730089,
 78477,
 703987711,
 703140899,
 -1,
 703998456,
 703861161,
 78487,
 -54793,
 703932059,
 78489,
 -1,
 703993230,
 78488,
 -1,
 703926825,
 78490,
 704260673,
 698843282,
 -1,
 704326161,
 704188969,
 -1,
 704391684,
 704254657,
 78268,
 -54787,
 704338163,
 78276,
 -54786,
 704402219,
 78275,
 -54785,
 704466590,
 78274,
 -54784,
 704528551,
 78273,
 -54783,
 704591404,
 78272,
 -54782,
 704654595,
 78271,
 -54781,
 704718491,
 78270,
 -1,
 704779662,
 78269,
 704981510,
 704320736,
 78283,
 -1,
 704910734,
 78284,
 705112584,
 704910491,
 78281,
 -1,
 705041806,
 78282,
 705243658,
 705041443,
 78279,
 -1,
 705172878,
 78280,
 705374732,
 705171881,
 78265,
 -1,
 705303950,
 78266,
 -54771,
 705303899,
 78286,
 -54770,
 705434919,
 78285,
 -54769,
 705500118,
 78278,
 -54768,
 705565542,
 78277,
 -1,
 705630761,
 78267,
 705833503,
 704254822,
 -1,
 705899029,
 705762150,
 78304,
 -54764,
 705832603,
 78306,
 -1,
 705893774,
 78305,
 706095639,
 705827369,
 78301,
 -1,
 706024846,
 78302,
 -54760,
 706024795,
 78312,
 -54759,
 706155815,
 78311,
 -54758,
 706221280,
 78310,
 -54757,
 706286747,
 78309,
 -54756,
 706352163,
 78308,
 -54755,
 706417622,
 78307,
 -54754,
 706482881,
 78303,
 -1,
 706548137,
 78300,
 706751021,
 705761985,
 -1,
 706816546,
 706680103,
 78297,
 -1,
 706745742,
 78298,
 706947620,
 706745302,
 78292,
 -1,
 706876814,
 78293,
 707078694,
 706876097,
 78289,
 -1,
 707007886,
 78290,
 -54745,
 707007835,
 78299,
 -54744,
 707138784,
 78296,
 -54743,
 707204251,
 78295,
 -54742,
 707269667,
 78294,
 -54741,
 707335014,
 78291,
 -54740,
 707400233,
 78288,
 -1,
 707465641,
 78287,
 707668538,
 706679209,
 -1,
 707734065,
 707596841,
 78253,
 -54736,
 707667611,
 78255,
 -1,
 707728782,
 78254,
 707930675,
 707662694,
 78257,
 -1,
 707859854,
 78258,
 -54732,
 707859803,
 78264,
 -54731,
 707990823,
 78263,
 -54730,
 708056288,
 78262,
 -54729,
 708121755,
 78261,
 -54728,
 708187171,
 78260,
 -54727,
 708252630,
 78259,
 -1,
 708317889,
 78256,
 708575231,
 707597270,
 -1,
 708586045,
 708448681,
 78313,
 -1,
 708515214,
 78314,
 -54722,
 708514774,
 78318,
 -54721,
 708645734,
 78317,
 -54720,
 708711105,
 78316,
 -1,
 708776489,
 78315,
 708979337,
 704204537,
 -1,
 709044816,
 708907990,
 -1,
 709110341,
 708973792,
 78132,
 -1,
 709039502,
 78133,
 709241415,
 709039259,
 78130,
 -1,
 709170574,
 78131,
 709372489,
 709170211,
 78128,
 -1,
 709301646,
 78129,
 -54710,
 709301595,
 78135,
 -54709,
 709432615,
 78134,
 -54708,
 709497814,
 78127,
 -54707,
 709563238,
 78126,
 -54706,
 709628609,
 78125,
 -54705,
 709693993,
 78124,
 -1,
 709759401,
 78123,
 709962334,
 708973414,
 -1,
 710027859,
 709891367,
 78120,
 -1,
 709957006,
 78121,
 710158933,
 709956832,
 78118,
 -1,
 710088078,
 78119,
 710290007,
 710087209,
 78111,
 -1,
 710219150,
 78112,
 -54696,
 710219099,
 78122,
 -54695,
 710349979,
 78117,
 -54694,
 710415395,
 78116,
 -54693,
 710480854,
 78115,
 -54692,
 710546278,
 78114,
 -54691,
 710611649,
 78113,
 -1,
 710676905,
 78110,
 710879850,
 709890753,
 -1,
 710945377,
 710808105,
 78100,
 -1,
 710874510,
 78101,
 -54686,
 710874459,
 78109,
 -54685,
 711005479,
 78108,
 -54684,
 711070944,
 78107,
 -54683,
 711136411,
 78106,
 -54682,
 711201827,
 78105,
 -54681,
 711267286,
 78104,
 -54680,
 711332710,
 78103,
 -54679,
 711398081,
 78102,
 -1,
 711463337,
 78099,
 711666294,
 710808105,
 -1,
 711731821,
 711594854,
 78091,
 -1,
 711660942,
 78092,
 -54674,
 711660891,
 78098,
 -54673,
 711791911,
 78097,
 -54672,
 711857376,
 78096,
 -54671,
 711922843,
 78095,
 -54670,
 711988259,
 78094,
 -54669,
 712053718,
 78093,
 -54668,
 712118977,
 78090,
 -54667,
 712184361,
 78089,
 -1,
 712249769,
 78088,
 712452737,
 711594409,
 -1,
 712518265,
 712380969,
 78078,
 -1,
 712447374,
 78079,
 -54662,
 712447323,
 78087,
 -54661,
 712578343,
 78086,
 -54660,
 712643808,
 78085,
 -54659,
 712709275,
 78084,
 -54658,
 712774691,
 78083,
 -54657,
 712840150,
 78082,
 -54656,
 712905574,
 78081,
 -1,
 712970945,
 78080,
 713228287,
 712381475,
 -1,
 713239174,
 713101865,
 78137,
 -54652,
 713174275,
 78140,
 -54651,
 713238171,
 78139,
 -1,
 713299342,
 78138,
 -54649,
 713167718,
 78142,
 -54648,
 713429697,
 78141,
 -1,
 713494953,
 78136,
 713698000,
 708924243,
 -1,
 713763479,
 713626582,
 -1,
 713829005,
 713692195,
 78196,
 -1,
 713758094,
 78197,
 713960079,
 713757542,
 78193,
 -1,
 713889166,
 78194,
 -54640,
 713889115,
 78201,
 -54639,
 714020135,
 78200,
 -54638,
 714085600,
 78199,
 -54637,
 714151067,
 78198,
 -54636,
 714216406,
 78195,
 -54635,
 714281665,
 78192,
 -54634,
 714347049,
 78191,
 -1,
 714412457,
 78190,
 714615460,
 713692006,
 -1,
 714680986,
 714544352,
 78186,
 -1,
 714610062,
 78187,
 714812060,
 714609819,
 78184,
 -1,
 714741134,
 78185,
 -54627,
 714741083,
 78189,
 -54626,
 714872103,
 78188,
 -54625,
 714937379,
 78183,
 -54624,
 715002838,
 78182,
 -54623,
 715068262,
 78181,
 -54622,
 715133633,
 78180,
 -54621,
 715199017,
 78179,
 -1,
 715264425,
 78178,
 715467441,
 714543809,
 -1,
 715532967,
 715396251,
 78173,
 -1,
 715462030,
 78174,
 715664041,
 715461033,
 78166,
 -1,
 715593102,
 78167,
 -54614,
 715593051,
 78177,
 -54613,
 715724071,
 78176,
 -54612,
 715789536,
 78175,
 -54611,
 715854883,
 78172,
 -54610,
 715920342,
 78171,
 -54609,
 715985766,
 78170,
 -54608,
 716051137,
 78169,
 -1,
 716116521,
 78168,
 716319422,
 715395497,
 -1,
 716384949,
 716248288,
 78150,
 -54604,
 716318363,
 78152,
 -1,
 716379534,
 78151,
 716581559,
 716313755,
 78148,
 -1,
 716510606,
 78149,
 -54600,
 716510555,
 78154,
 -54599,
 716641575,
 78153,
 -54598,
 716706851,
 78147,
 -54597,
 716772310,
 78146,
 -54596,
 716837734,
 78145,
 -54595,
 716903105,
 78144,
 -1,
 716968489,
 78143,
 717171402,
 716247593,
 -1,
 717236929,
 717099561,
 78156,
 -1,
 717165966,
 78157,
 -54590,
 717165915,
 78165,
 -54589,
 717296935,
 78164,
 -54588,
 717362400,
 78163,
 -54587,
 717427867,
 78162,
 -54586,
 717493283,
 78161,
 -54585,
 717558742,
 78160,
 -54584,
 717624166,
 78159,
 -54583,
 717689537,
 78158,
 -1,
 717754793,
 78155,
 718012415,
 717100067,
 -1,
 -54580,
 717886422,
 78206,
 -54579,
 717951846,
 78205,
 -54578,
 718017217,
 78204,
 -54577,
 718082601,
 78203,
 -1,
 718148009,
 78202,
 718351116,
 713668647,
 -1,
 718416607,
 718279209,
 -1,
 718482133,
 718345174,
 78560,
 -54572,
 718415515,
 78562,
 -1,
 718476686,
 78561,
 718678743,
 718410976,
 78565,
 -1,
 718607758,
 78566,
 -54568,
 718607707,
 78568,
 -54567,
 718738727,
 78567,
 -54566,
 718804123,
 78564,
 -54565,
 718869539,
 78563,
 -54564,
 718934886,
 78559,
 -54563,
 719000257,
 78558,
 -54562,
 719065641,
 78557,
 -1,
 719131049,
 78556,
 719334124,
 718344897,
 -1,
 719399651,
 719262875,
 78575,
 -54558,
 719333019,
 78577,
 -1,
 719394190,
 78576,
 -54556,
 719328603,
 78580,
 -54555,
 719525159,
 78579,
 -54554,
 719590624,
 78578,
 -54553,
 719655971,
 78574,
 -54552,
 719721430,
 78573,
 -54551,
 719786854,
 78572,
 -54550,
 719852225,
 78571,
 -54549,
 719917609,
 78570,
 -1,
 719983017,
 78569,
 720186104,
 719262566,
 -1,
 720251631,
 720114723,
 78586,
 -1,
 720180622,
 78587,
 -54544,
 720180571,
 78591,
 -54543,
 720311591,
 78590,
 -54542,
 720377056,
 78589,
 -54541,
 720442523,
 78588,
 -54540,
 720507862,
 78585,
 -54539,
 720573286,
 78584,
 -54538,
 720638657,
 78583,
 -54537,
 720704041,
 78582,
 -1,
 720769449,
 78581,
 720972548,
 720114089,
 -1,
 721038075,
 720901275,
 78551,
 -1,
 720967054,
 78552,
 721169149,
 720966337,
 78546,
 -1,
 721098126,
 78547,
 -54530,
 721098075,
 78555,
 -54529,
 721229095,
 78554,
 -54528,
 721294560,
 78553,
 -54527,
 721359907,
 78550,
 -54526,
 721425366,
 78549,
 -54525,
 721490790,
 78548,
 -1,
 721556009,
 78545,
 721813503,
 720901078,
 -1,
 -54522,
 721687707,
 78598,
 -54521,
 721753123,
 78597,
 -54520,
 721818582,
 78596,
 -54519,
 721884006,
 78595,
 -54518,
 721949377,
 78594,
 -54517,
 722014761,
 78593,
 -1,
 722080169,
 78592,
 722283329,
 718327630,
 -1,
 722348826,
 722211521,
 -1,
 722414352,
 722277723,
 78674,
 -1,
 722343310,
 78675,
 722545426,
 722342758,
 78667,
 -1,
 722474382,
 78668,
 -54509,
 722474279,
 78673,
 -54508,
 722605280,
 78672,
 -54507,
 722670747,
 78671,
 -54506,
 722736163,
 78670,
 -54505,
 722801622,
 78669,
 -54504,
 722866881,
 78666,
 -54503,
 722932265,
 78665,
 -1,
 722997673,
 78664,
 723200806,
 722277222,
 -1,
 723266333,
 723129025,
 78678,
 -1,
 723195278,
 78679,
 -54498,
 723195227,
 78686,
 -54497,
 723326247,
 78685,
 -54496,
 723391712,
 78684,
 -54495,
 723457179,
 78683,
 -54494,
 723522595,
 78682,
 -54493,
 723588054,
 78681,
 -54492,
 723653478,
 78680,
 -54491,
 723718697,
 78677,
 -1,
 723784105,
 78676,
 723987250,
 723128745,
 -1,
 724052778,
 723915931,
 78648,
 -54487,
 723986075,
 78650,
 -1,
 724047246,
 78649,
 -54485,
 723981659,
 78653,
 -54484,
 724178215,
 78652,
 -54483,
 724243680,
 78651,
 -54482,
 724309027,
 78647,
 -54481,
 724374486,
 78646,
 -54480,
 724439910,
 78645,
 -54479,
 724505281,
 78644,
 -1,
 724570665,
 78643,
 724773693,
 723915305,
 -1,
 -54476,
 724702555,
 78663,
 -54475,
 724768039,
 78662,
 -54474,
 724833504,
 78661,
 -54473,
 724898971,
 78660,
 -54472,
 724964387,
 78659,
 -54471,
 725029846,
 78658,
 -54470,
 725095270,
 78657,
 -54469,
 725160641,
 78656,
 -54468,
 725226025,
 78655,
 -1,
 725291433,
 78654,
 725549055,
 724702166,
 -1,
 -54465,
 725422785,
 78689,
 -54464,
 725488169,
 78688,
 -1,
 725553577,
 78687,
 725756786,
 722256822,
 -1,
 725822288,
 725684649,
 -1,
 725887813,
 725751131,
 78610,
 -1,
 725816718,
 78611,
 726018887,
 725816615,
 78608,
 -1,
 725947790,
 78609,
 726149961,
 725947616,
 78606,
 -1,
 726078862,
 78607,
 726281035,
 726078310,
 78601,
 -1,
 726209934,
 78602,
 -54452,
 726209691,
 78605,
 -54451,
 726340643,
 78604,
 -54450,
 726406102,
 78603,
 -54449,
 726471361,
 78600,
 -1,
 726536745,
 78599,
 726739805,
 725750313,
 -1,
 726805331,
 726668443,
 78619,
 -1,
 726734222,
 78620,
 726936405,
 726733353,
 78613,
 -1,
 726865294,
 78614,
 -54442,
 726865243,
 78623,
 -54441,
 726996263,
 78622,
 -54440,
 727061728,
 78621,
 -54439,
 727127075,
 78618,
 -54438,
 727192534,
 78617,
 -54437,
 727257958,
 78616,
 -54436,
 727323329,
 78615,
 -1,
 727388585,
 78612,
 727591784,
 726667969,
 -1,
 -54433,
 727520603,
 78633,
 -54432,
 727586087,
 78632,
 -54431,
 727651552,
 78631,
 -54430,
 727717019,
 78630,
 -54429,
 727782435,
 78629,
 -54428,
 727847894,
 78628,
 -54427,
 727913318,
 78627,
 -54426,
 727978689,
 78626,
 -54425,
 728044073,
 78625,
 -1,
 728109481,
 78624,
 728367103,
 727520102,
 -1,
 728378219,
 728240998,
 78638,
 -1,
 728307086,
 78639,
 728509293,
 728306369,
 78636,
 -1,
 728438158,
 78637,
 -54418,
 728437915,
 78642,
 -54417,
 728568867,
 78641,
 -54416,
 728634326,
 78640,
 -54415,
 728699433,
 78635,
 -1,
 728764841,
 78634,
 728968099,
 725696804,
 -1,
 729033600,
 728896193,
 -1,
 729099126,
 728962343,
 78066,
 -1,
 729027982,
 78067,
 729230200,
 729026985,
 78057,
 -1,
 729159054,
 78058,
 -54407,
 729159003,
 78068,
 -54406,
 729289952,
 78065,
 -54405,
 729355419,
 78064,
 -54404,
 729420835,
 78063,
 -54403,
 729486294,
 78062,
 -54402,
 729551718,
 78061,
 -54401,
 729617089,
 78060,
 -1,
 729682473,
 78059,
 729885581,
 728961577,
 -1,
 729951107,
 729814240,
 78053,
 -1,
 729879950,
 78054,
 730082181,
 729879707,
 78051,
 -1,
 730011022,
 78052,
 -54394,
 730010971,
 78056,
 -54393,
 730141991,
 78055,
 -54392,
 730207267,
 78050,
 -54391,
 730272726,
 78049,
 -54390,
 730338150,
 78048,
 -54389,
 730403521,
 78047,
 -54388,
 730468905,
 78046,
 -1,
 730534313,
 78045,
 730737561,
 729813417,
 -1,
 730803088,
 730666331,
 78043,
 -1,
 730731918,
 78044,
 730934162,
 730731815,
 78041,
 -1,
 730862990,
 78042,
 -54381,
 730862816,
 78040,
 -54380,
 730993819,
 78039,
 -54379,
 731059235,
 78038,
 -54378,
 731124694,
 78037,
 -54377,
 731190118,
 78036,
 -54376,
 731255489,
 78035,
 -1,
 731320873,
 78034,
 731578367,
 730665830,
 -1,
 731589532,
 731452374,
 78073,
 -1,
 731518350,
 78074,
 -54371,
 731518247,
 78077,
 -54370,
 731649248,
 78076,
 -54369,
 731714715,
 78075,
 -54368,
 731779942,
 78072,
 -54367,
 731845313,
 78071,
 -54366,
 731910697,
 78070,
 -1,
 731976105,
 78069,
 732179407,
 728950788,
 -1,
 732244925,
 732107305,
 -1,
 732310447,
 732173347,
 78842,
 -54361,
 732258791,
 78851,
 -54360,
 732322035,
 78850,
 -54359,
 732386091,
 78849,
 -54358,
 732450462,
 78848,
 -54357,
 732512423,
 78847,
 -54356,
 732575276,
 78846,
 -54355,
 732638467,
 78845,
 -54354,
 732702363,
 78844,
 -1,
 732763534,
 78843,
 732965816,
 732239003,
 78852,
 -54351,
 732911859,
 78860,
 -54350,
 732975915,
 78859,
 -54349,
 733040286,
 78858,
 -54348,
 733102247,
 78857,
 -54347,
 733165100,
 78856,
 -54346,
 733228291,
 78855,
 -54345,
 733292187,
 78854,
 -1,
 733353358,
 78853,
 -54343,
 732894166,
 78841,
 -54342,
 733483878,
 78840,
 -54341,
 733549249,
 78839,
 -54340,
 733614633,
 78838,
 -1,
 733680041,
 78837,
 733937663,
 732172713,
 -1,
 733948867,
 733811393,
 78821,
 -54336,
 733885996,
 78825,
 -54335,
 733949187,
 78824,
 -54334,
 734013083,
 78823,
 -1,
 734074254,
 78822,
 734276550,
 733877094,
 78826,
 -54331,
 734209691,
 78828,
 -1,
 734270862,
 78827,
 734473160,
 734204963,
 78831,
 -1,
 734401934,
 78832,
 734604234,
 734401494,
 78829,
 -1,
 734533006,
 78830,
 -54325,
 734532955,
 78836,
 -54324,
 734663975,
 78835,
 -54323,
 734729440,
 78834,
 -54322,
 734794907,
 78833,
 -1,
 734859817,
 78820,
 735063029,
 732146205,
 -1,
 735128541,
 734990889,
 -1,
 735194067,
 735057051,
 78530,
 -1,
 735122830,
 78531,
 735325141,
 735121833,
 78523,
 -1,
 735253902,
 78524,
 -54314,
 735253851,
 78534,
 -54313,
 735384871,
 78533,
 -54312,
 735450336,
 78532,
 -54311,
 735515683,
 78529,
 -54310,
 735581142,
 78528,
 -54309,
 735646566,
 78527,
 -54308,
 735711937,
 78526,
 -1,
 735777321,
 78525,
 735980522,
 735056297,
 -1,
 736046049,
 735908710,
 78514,
 -54304,
 735979163,
 78516,
 -1,
 736040334,
 78515,
 736242659,
 735974081,
 78512,
 -1,
 736171406,
 78513,
 -54300,
 736171355,
 78522,
 -54299,
 736302375,
 78521,
 -54298,
 736367840,
 78520,
 -54297,
 736433307,
 78519,
 -54296,
 736498723,
 78518,
 -54295,
 736564182,
 78517,
 -1,
 736629289,
 78511,
 736886783,
 735908545,
 -1,
 -54292,
 736761179,
 78544,
 -54291,
 736826663,
 78543,
 -54290,
 736892128,
 78542,
 -54289,
 736957595,
 78541,
 -54288,
 737023011,
 78540,
 -54287,
 737088470,
 78539,
 -54286,
 737153894,
 78538,
 -54285,
 737219265,
 78537,
 -54284,
 737284649,
 78536,
 -1,
 737350057,
 78535,
 737553433,
 735043071,
 -1,
 737618949,
 737481257,
 -1,
 737684473,
 737547559,
 78789,
 -1,
 737613198,
 78790,
 737815547,
 737613024,
 78787,
 -1,
 737744270,
 78788,
 737946621,
 737743830,
 78783,
 -1,
 737875342,
 78784,
 738077695,
 737874345,
 78778,
 -1,
 738006414,
 78779,
 -54272,
 738006363,
 78791,
 -54271,
 738137243,
 78786,
 -54270,
 738202659,
 78785,
 -54269,
 738268006,
 78782,
 -54268,
 738333377,
 78781,
 -1,
 738398761,
 78780,
 738602001,
 737546665,
 -1,
 738667528,
 738530651,
 78776,
 -1,
 738596238,
 78777,
 738798602,
 738595686,
 78769,
 -1,
 738727310,
 78770,
 -54261,
 738727207,
 78775,
 -54260,
 738858208,
 78774,
 -54259,
 738923675,
 78773,
 -54258,
 738989091,
 78772,
 -54257,
 739054550,
 78771,
 -54256,
 739119809,
 78768,
 -1,
 739185193,
 78767,
 739442687,
 738529985,
 -1,
 739453972,
 739316694,
 78796,
 -1,
 739382670,
 78797,
 -54251,
 739382307,
 78798,
 -54250,
 739513190,
 78795,
 -54249,
 739578561,
 78794,
 -54248,
 739643945,
 78793,
 -1,
 739709353,
 78792,
 739912761,
 737488221,
 -1,
 739978279,
 739840425,
 -1,
 740043807,
 739906241,
 77915,
 -54243,
 739978499,
 77918,
 -54242,
 740042395,
 77917,
 -1,
 740103566,
 77916,
 -54240,
 739972443,
 77925,
 -54239,
 740234535,
 77924,
 -54238,
 740300000,
 77923,
 -54237,
 740365467,
 77922,
 -54236,
 740430883,
 77921,
 -54235,
 740496342,
 77920,
 -54234,
 740561766,
 77919,
 -1,
 740626985,
 77914,
 740830259,
 739906089,
 -1,
 740895786,
 740757929,
 77926,
 -1,
 740824462,
 77927,
 -54229,
 740824411,
 77936,
 -54228,
 740955431,
 77935,
 -54227,
 741020896,
 77934,
 -54226,
 741086363,
 77933,
 -54225,
 741151779,
 77932,
 -54224,
 741217238,
 77931,
 -54223,
 741282662,
 77930,
 -54222,
 741348033,
 77929,
 -1,
 741413417,
 77928,
 741670911,
 740758209,
 -1,
 -54219,
 741544918,
 77941,
 -54218,
 741610342,
 77940,
 -54217,
 741675713,
 77939,
 -54216,
 741741097,
 77938,
 -1,
 741806505,
 77937,
 742009935,
 739861099,
 -1,
 742075462,
 741937577,
 -1,
 742140989,
 742004059,
 78225,
 -1,
 742069646,
 78226,
 742272063,
 742069283,
 78220,
 -1,
 742200718,
 78221,
 -54208,
 742200615,
 78224,
 -54207,
 742331616,
 78223,
 -54206,
 742397083,
 78222,
 -54205,
 742462422,
 78219,
 -54204,
 742527846,
 78218,
 -54203,
 742593217,
 78217,
 -1,
 742658601,
 78216,
 742916095,
 742003241,
 -1,
 742927433,
 742789673,
 78229,
 -1,
 742856078,
 78230,
 743058507,
 742855081,
 78227,
 -1,
 742987150,
 78228,
 -54196,
 742986787,
 78234,
 -54195,
 743117782,
 78233,
 -54194,
 743183206,
 78232,
 -1,
 743248577,
 78231,
 743451743,
 741974221,
 -1,
 743517276,
 743379369,
 -1,
 743582803,
 743445350,
 78494,
 -1,
 743511438,
 78495,
 743713877,
 743510569,
 78491,
 -1,
 743642510,
 78492,
 -54186,
 743642459,
 78501,
 -54185,
 743773479,
 78500,
 -54184,
 743838944,
 78499,
 -54183,
 743904411,
 78498,
 -54182,
 743969827,
 78497,
 -54181,
 744035286,
 78496,
 -1,
 744100545,
 78493,
 744357887,
 743445033,
 -1,
 -54178,
 744231465,
 78503,
 -1,
 744296873,
 78502,
 744500332,
 743433202,
 -1,
 744565859,
 744428502,
 78802,
 -54174,
 744498843,
 78804,
 -1,
 744560014,
 78803,
 744762469,
 744494375,
 78809,
 -1,
 744691086,
 78810,
 744893543,
 744690843,
 78806,
 -1,
 744822158,
 78807,
 -54168,
 744821984,
 78808,
 -54167,
 744952867,
 78805,
 -54166,
 745018214,
 78801,
 -54165,
 745083585,
 78800,
 -1,
 745148969,
 78799,
 745352311,
 744453138,
 -1,
 745417839,
 745280667,
 78249,
 -1,
 745346446,
 78250,
 745548913,
 745345729,
 78244,
 -1,
 745477518,
 78245,
 -54158,
 745477415,
 78252,
 -54157,
 745608416,
 78251,
 -54156,
 745673763,
 78248,
 -54155,
 745739222,
 78247,
 -54154,
 745804646,
 78246,
 -1,
 745869865,
 78243,
 746073218,
 745285290,
 -1,
 746138746,
 746001443,
 77908,
 -1,
 746067342,
 77909,
 -54149,
 746067291,
 77913,
 -54148,
 746198311,
 77912,
 -54147,
 746263776,
 77911,
 -54146,
 746329243,
 77910,
 -54145,
 746394582,
 77907,
 -54144,
 746460006,
 77906,
 -54143,
 746525377,
 77905,
 -1,
 746590761,
 77904,
 746794124,
 746054904,
 -1,
 746859653,
 746721833,
 78811,
 -1,
 746788238,
 78812,
 -54138,
 746788135,
 78819,
 -54137,
 746919136,
 78818,
 -54136,
 746984603,
 78817,
 -54135,
 747050019,
 78816,
 -54134,
 747115478,
 78815,
 -54133,
 747180902,
 78814,
 -1,
 747246273,
 78813,
 747449494,
 746739981,
 -1,
 747515023,
 747377819,
 78212,
 -1,
 747443598,
 78213,
 -54128,
 747443495,
 78215,
 -54127,
 747574496,
 78214,
 -54126,
 747639843,
 78211,
 -54125,
 747705302,
 78210,
 -54124,
 747770726,
 78209,
 -54123,
 747836097,
 78208,
 -1,
 747901481,
 78207,
 748104863,
 747401464,
 -1,
 -54120,
 748033319,
 78242,
 -54119,
 748098784,
 78241,
 -54118,
 748164251,
 78240,
 -54117,
 748229667,
 78239,
 -54116,
 748295126,
 78238,
 -54115,
 748360550,
 78237,
 -54114,
 748425921,
 78236,
 -1,
 748491305,
 78235,
 748748799,
 748070856,
 -1,
 -54111,
 748623072,
 78510,
 -54110,
 748688539,
 78509,
 -54109,
 748753955,
 78508,
 -54108,
 748819414,
 78507,
 -54107,
 748884838,
 78506,
 -54106,
 748950209,
 78505,
 -1,
 749015593,
 78504,
 749219519,
 671205210,
 -1,
 749285003,
 749189040,
 -1,
 749350536,
 749266631,
 -1,
 749415641,
 749294379,
 -1,
 749481145,
 749359915,
 -1,
 749546674,
 749460954,
 -1,
 749612207,
 749486247,
 11670,
 -1,
 749551783,
 11669,
 749743281,
 749540750,
 11667,
 -1,
 749671822,
 4895,
 -1,
 749691367,
 11668,
 749939892,
 749486247,
 4893,
 -1,
 749879463,
 4892,
 750070966,
 749868430,
 4888,
 -1,
 749999502,
 4891,
 -54089,
 750046958,
 4889,
 -54088,
 750162418,
 4894,
 -1,
 750215655,
 4890,
 750398659,
 749436515,
 -1,
 750464188,
 750359026,
 4774,
 -1,
 750392718,
 11658,
 750595262,
 750403751,
 4773,
 -1,
 750534823,
 4772,
 750726336,
 750523790,
 4768,
 -1,
 750654862,
 4771,
 -54079,
 750706178,
 4775,
 -54078,
 750833390,
 4769,
 -1,
 750871015,
 4770,
 751054027,
 750380224,
 -1,
 751119558,
 750993575,
 11741,
 -1,
 751059111,
 11740,
 751250632,
 751048078,
 11736,
 -1,
 751179150,
 11739,
 -54071,
 751226606,
 11737,
 -54070,
 751342066,
 11742,
 -1,
 751395303,
 11738,
 751578321,
 751033818,
 -1,
 751643854,
 751517863,
 4885,
 -1,
 751583399,
 4884,
 751774928,
 751572366,
 4880,
 -1,
 751703438,
 4883,
 -1,
 751722983,
 4882,
 751971539,
 751538674,
 4878,
 -1,
 751900046,
 4879,
 752102613,
 751911079,
 4877,
 -1,
 752042151,
 4876,
 752233687,
 752031118,
 4872,
 -1,
 752162190,
 4875,
 -54056,
 752209646,
 4873,
 -1,
 752312807,
 4874,
 752495875,
 749385648,
 -1,
 752561380,
 752441587,
 -1,
 752626909,
 752521714,
 4670,
 -1,
 752555406,
 11652,
 752757983,
 752566439,
 4669,
 -1,
 752697511,
 4668,
 752889057,
 752686478,
 4664,
 -1,
 752817550,
 4667,
 -54046,
 752868866,
 4671,
 -54045,
 752996078,
 4665,
 -1,
 753033703,
 4666,
 753216749,
 752543736,
 -1,
 753282279,
 753156263,
 4645,
 -1,
 753221799,
 4644,
 753413353,
 753210766,
 4640,
 -1,
 753341838,
 4643,
 -54038,
 753393154,
 4647,
 -54037,
 753520366,
 4641,
 -54036,
 753570290,
 4646,
 -1,
 753623527,
 4642,
 753806581,
 753186736,
 -1,
 753872112,
 753746087,
 11685,
 -1,
 753811623,
 11684,
 754003186,
 753800590,
 11680,
 -1,
 753931662,
 11683,
 -54029,
 753979118,
 11681,
 -54028,
 754094578,
 11686,
 -1,
 754147815,
 11682,
 754330876,
 753746087,
 4661,
 754396411,
 754264066,
 -1,
 -54024,
 754362303,
 5004,
 -54023,
 754419986,
 4992,
 -54022,
 754471714,
 5000,
 -1,
 754527428,
 4996,
 -1,
 754335911,
 4660,
 754789630,
 754291186,
 4662,
 -1,
 754718094,
 11651,
 754920704,
 754718094,
 4656,
 -1,
 754849166,
 4659,
 -54015,
 754900482,
 4663,
 -54014,
 755027694,
 4657,
 -1,
 755065319,
 4658,
 755248425,
 752468856,
 -1,
 755313934,
 755194099,
 -1,
 755379463,
 755274226,
 4902,
 -1,
 755307918,
 11663,
 755510537,
 755318951,
 4901,
 -1,
 755450023,
 4900,
 755641611,
 755438990,
 4896,
 -1,
 755570062,
 4899,
 -54004,
 755621378,
 4903,
 -54003,
 755748590,
 4897,
 -1,
 755786215,
 4898,
 755969303,
 755296248,
 -1,
 756034833,
 755929586,
 4934,
 -1,
 755963278,
 4935,
 756165907,
 755974311,
 4933,
 -1,
 756105383,
 4932,
 756296981,
 756094350,
 4928,
 -1,
 756225422,
 4931,
 -53994,
 756272878,
 4929,
 -1,
 756376039,
 4930,
 756559136,
 755939248,
 -1,
 756624666,
 756498599,
 4925,
 -1,
 756564135,
 4924,
 756755740,
 756553102,
 4920,
 -1,
 756684174,
 4923,
 -53987,
 756735490,
 4927,
 -53986,
 756862702,
 4921,
 -53985,
 756912626,
 4926,
 -1,
 756965863,
 4922,
 757148962,
 756519410,
 4726,
 -1,
 757077390,
 11654,
 757280036,
 757088423,
 4725,
 -1,
 757219495,
 4724,
 757411110,
 757208462,
 4720,
 -1,
 757339534,
 4723,
 -53977,
 757390850,
 4727,
 -53976,
 757518062,
 4721,
 -1,
 757555687,
 4722,
 757738830,
 755214278,
 -1,
 757804344,
 757684467,
 -1,
 757869873,
 757784026,
 -1,
 757935406,
 757809319,
 4701,
 -1,
 757874855,
 4700,
 758066480,
 757863822,
 4696,
 -1,
 757994894,
 4699,
 -1,
 758014439,
 4698,
 758263091,
 757809319,
 4693,
 -1,
 758202535,
 4692,
 758394165,
 758191502,
 4688,
 -1,
 758322574,
 4691,
 -53962,
 758370030,
 4689,
 -53961,
 758485490,
 4694,
 -1,
 758538727,
 4690,
 758721856,
 757785792,
 -1,
 758787387,
 758661287,
 11717,
 -1,
 758726823,
 11716,
 758918461,
 758715790,
 11712,
 -1,
 758846862,
 11715,
 -53954,
 758894318,
 11713,
 -53953,
 759009778,
 11718,
 -1,
 759063015,
 11714,
 759246150,
 758701530,
 -1,
 759311683,
 759185575,
 4685,
 -1,
 759251111,
 4684,
 759442757,
 759240078,
 4680,
 -1,
 759371150,
 4683,
 -1,
 759390695,
 4682,
 759639368,
 759206386,
 4678,
 -1,
 759567758,
 4679,
 759770442,
 759578791,
 4677,
 -1,
 759709863,
 4676,
 759901516,
 759698830,
 4672,
 -1,
 759829902,
 4675,
 -53939,
 759877358,
 4673,
 -1,
 759980519,
 4674,
 760163699,
 757690614,
 -1,
 760229213,
 760144854,
 -1,
 760294742,
 760208858,
 -1,
 760360275,
 760234151,
 4805,
 -1,
 760299687,
 4804,
 760491349,
 760288654,
 4800,
 -1,
 760419726,
 4803,
 -1,
 760439271,
 4802,
 760687960,
 760234151,
 4797,
 -1,
 760627367,
 4796,
 760819034,
 760616334,
 4792,
 -1,
 760747406,
 4795,
 -53925,
 760794862,
 4793,
 -53924,
 760910322,
 4798,
 -1,
 760963559,
 4794,
 761146725,
 760210624,
 -1,
 761212256,
 761086119,
 11725,
 -1,
 761151655,
 11724,
 761343330,
 761140622,
 11720,
 -1,
 761271694,
 11723,
 -53917,
 761319150,
 11721,
 -53916,
 761434610,
 11726,
 -1,
 761487847,
 11722,
 761671019,
 761126362,
 -1,
 761736552,
 761610407,
 4789,
 -1,
 761675943,
 4788,
 761867626,
 761664910,
 4784,
 -1,
 761795982,
 4787,
 -1,
 761815527,
 4786,
 762064237,
 761631218,
 4782,
 -1,
 761992590,
 4783,
 762195311,
 762003623,
 4781,
 -1,
 762134695,
 4780,
 762326385,
 762123662,
 4776,
 -1,
 762254734,
 4779,
 -53902,
 762302190,
 4777,
 -1,
 762405351,
 4778,
 762588567,
 760098051,
 -1,
 762654084,
 762522883,
 -1,
 762719613,
 762599667,
 -1,
 762785144,
 762658983,
 11709,
 -1,
 762724519,
 11708,
 762916218,
 762713486,
 11704,
 -1,
 762844558,
 11707,
 -53893,
 762892014,
 11705,
 -53892,
 763007474,
 11710,
 -1,
 763060711,
 11706,
 763243903,
 762658983,
 11693,
 -1,
 763183271,
 11692,
 763374977,
 763172238,
 11688,
 -1,
 763303310,
 11691,
 -53886,
 763350766,
 11689,
 -53885,
 763466226,
 11694,
 -1,
 763519463,
 11690,
 763702670,
 762599667,
 -1,
 763768199,
 763662834,
 4910,
 -1,
 763696526,
 11664,
 763899273,
 763707559,
 4909,
 -1,
 763838631,
 4908,
 764030347,
 763827598,
 4904,
 -1,
 763958670,
 4907,
 -53876,
 764009986,
 4911,
 -53875,
 764137198,
 4905,
 -1,
 764174823,
 4906,
 764358032,
 763662834,
 4734,
 -1,
 764286350,
 11655,
 764489106,
 764297383,
 4733,
 -1,
 764428455,
 4732,
 764620180,
 764417422,
 4728,
 -1,
 764548494,
 4731,
 -53867,
 764599810,
 4735,
 -53866,
 764727022,
 4729,
 -1,
 764764647,
 4730,
 764947895,
 762552427,
 -1,
 765013418,
 764893427,
 -1,
 765078947,
 764941710,
 4912,
 765144482,
 765048731,
 -1,
 765210013,
 765083815,
 4821,
 -1,
 765149351,
 4820,
 765341087,
 765138318,
 4816,
 -1,
 765269390,
 4819,
 -53856,
 765316846,
 4817,
 -53855,
 765432306,
 4822,
 -1,
 765485543,
 4818,
 -1,
 765072782,
 4915,
 765734309,
 765039090,
 4918,
 -1,
 765662606,
 11665,
 765865383,
 765673639,
 4917,
 -1,
 765804711,
 4916,
 -53848,
 765844994,
 4919,
 -53847,
 765972206,
 4913,
 -1,
 766009831,
 4914,
 766193071,
 764992986,
 -1,
 766258605,
 766132391,
 5007,
 -1,
 766197927,
 5006,
 -53842,
 766206439,
 5005,
 -1,
 766317966,
 4951,
 766520753,
 766153202,
 4950,
 -1,
 766449038,
 11666,
 766651827,
 766460071,
 4949,
 -1,
 766591143,
 4948,
 766782901,
 766580110,
 4944,
 -1,
 766711182,
 4947,
 -53834,
 766758638,
 4945,
 -1,
 766861799,
 4946,
 767045074,
 764930040,
 -1,
 767110593,
 766990579,
 -1,
 767176123,
 767049895,
 4837,
 -1,
 767115431,
 4836,
 767307197,
 767104398,
 4832,
 -1,
 767235470,
 4835,
 -53826,
 767286786,
 4839,
 -53825,
 767413998,
 4833,
 -53824,
 767463922,
 4838,
 -1,
 767517159,
 4834,
 767700425,
 767092728,
 -1,
 767765956,
 767639719,
 11701,
 -1,
 767705255,
 11700,
 767897030,
 767694222,
 11696,
 -1,
 767825294,
 11699,
 -53817,
 767872750,
 11697,
 -53816,
 767988210,
 11702,
 -1,
 768041447,
 11698,
 768224715,
 767660530,
 4830,
 -1,
 768152974,
 11659,
 768355789,
 768164007,
 4829,
 -1,
 768295079,
 4828,
 768486863,
 768284046,
 4824,
 -1,
 768415118,
 4827,
 -53808,
 768466434,
 4831,
 -53807,
 768593646,
 4825,
 -1,
 768631271,
 4826,
 768814569,
 767026134,
 -1,
 768880091,
 768795840,
 -1,
 768945622,
 768819367,
 11733,
 -1,
 768884903,
 11732,
 769076696,
 768873870,
 11728,
 -1,
 769004942,
 11731,
 -53799,
 769052398,
 11729,
 -53798,
 769167858,
 11734,
 -1,
 769221095,
 11730,
 769404385,
 768859610,
 -1,
 769469918,
 769343655,
 4749,
 -1,
 769409191,
 4748,
 769600992,
 769398158,
 4744,
 -1,
 769529230,
 4747,
 -1,
 769548775,
 4746,
 769797603,
 769364466,
 4742,
 -1,
 769725838,
 4743,
 769928677,
 769736871,
 4741,
 -1,
 769867943,
 4740,
 770059751,
 769856910,
 4736,
 -1,
 769987982,
 4739,
 -53784,
 770035438,
 4737,
 -1,
 770138599,
 4738,
 770321917,
 768772418,
 -1,
 770387444,
 770303168,
 -1,
 770452973,
 770347506,
 4766,
 -1,
 770381198,
 11657,
 770584047,
 770392231,
 4765,
 -1,
 770523303,
 4764,
 770715121,
 770512270,
 4760,
 -1,
 770643342,
 4763,
 -53774,
 770694658,
 4767,
 -53773,
 770821870,
 4761,
 -1,
 770859495,
 4762,
 771042806,
 770347506,
 4758,
 -1,
 770971022,
 11656,
 771173880,
 770982055,
 4757,
 -1,
 771113127,
 4756,
 771304954,
 771102094,
 4752,
 -1,
 771233166,
 4755,
 -53765,
 771284482,
 4759,
 -53764,
 771411694,
 4753,
 -1,
 771449319,
 4754,
 771632657,
 770258476,
 -1,
 771698184,
 771569196,
 -1,
 771763713,
 771658226,
 4862,
 -1,
 771691918,
 11661,
 771894787,
 771702951,
 4861,
 -1,
 771834023,
 4860,
 772025861,
 771822990,
 4856,
 -1,
 771954062,
 4859,
 -53754,
 772005378,
 4863,
 -53753,
 772132590,
 4857,
 -1,
 772170215,
 4858,
 772353546,
 771658226,
 4854,
 -1,
 772281742,
 11660,
 772484620,
 772292775,
 4853,
 -1,
 772423847,
 4852,
 772615694,
 772412814,
 4848,
 -1,
 772543886,
 4851,
 -53745,
 772595202,
 4855,
 -53744,
 772722414,
 4849,
 -1,
 772760039,
 4850,
 772943395,
 771578099,
 -1,
 773008923,
 772888819,
 -1,
 773074453,
 772948135,
 4629,
 -1,
 773013671,
 4628,
 773205527,
 773002638,
 4624,
 -1,
 773133710,
 4627,
 -53736,
 773185026,
 4631,
 -53735,
 773312238,
 4625,
 -53734,
 773362162,
 4630,
 -1,
 773415399,
 4626,
 773598749,
 772968946,
 4614,
 -1,
 773526926,
 4615,
 773729823,
 773537959,
 4613,
 -1,
 773669031,
 4612,
 773860897,
 773657998,
 4608,
 -1,
 773789070,
 4611,
 -53726,
 773836526,
 4609,
 -1,
 773939687,
 4610,
 774123058,
 772898888,
 -1,
 774188585,
 774102490,
 -1,
 774254119,
 774127783,
 4995,
 -1,
 774193319,
 4994,
 -53720,
 774201831,
 4993,
 -1,
 774313358,
 4639,
 774516267,
 774148594,
 4638,
 -1,
 774444430,
 11649,
 774647341,
 774455463,
 4637,
 -1,
 774586535,
 4636,
 774778415,
 774575502,
 4632,
 -1,
 774706574,
 4635,
 -53712,
 774759676,
 4953,
 -53711,
 774885102,
 4633,
 -1,
 774922727,
 4634,
 775106112,
 774065822,
 -1,
 775171640,
 775085530,
 -1,
 775237174,
 775110823,
 5003,
 -1,
 775176359,
 5002,
 -53705,
 775184871,
 5001,
 -1,
 775296398,
 4943,
 775499322,
 775110823,
 4941,
 -1,
 775438503,
 4940,
 775630396,
 775427470,
 4936,
 -1,
 775558542,
 4939,
 -53699,
 775611644,
 4954,
 -53698,
 775737070,
 4937,
 -53697,
 775786994,
 4942,
 -1,
 775840231,
 4938,
 776023630,
 775038619,
 -1,
 776089158,
 776003034,
 -1,
 776154692,
 776028327,
 4999,
 -1,
 776093863,
 4998,
 -53691,
 776102375,
 4997,
 -1,
 776213902,
 4711,
 776416840,
 776049138,
 4710,
 -1,
 776344974,
 11653,
 776547914,
 776356007,
 4709,
 -1,
 776487079,
 4708,
 776678988,
 776476046,
 4704,
 -1,
 776607118,
 4707,
 -53683,
 776654574,
 4705,
 -1,
 776757735,
 4706,
 776941145,
 775989718,
 -1,
 777006673,
 776901106,
 4654,
 -1,
 776934798,
 11650,
 777137747,
 776945831,
 4653,
 -1,
 777076903,
 4652,
 777268821,
 777065870,
 4648,
 -1,
 777196942,
 4651,
 -53674,
 777250044,
 4952,
 -53673,
 777379330,
 4655,
 -53672,
 777441006,
 4649,
 -1,
 777478631,
 4650,
 777662051,
 776893380,
 -1,
 777727580,
 777622002,
 4622,
 -1,
 777655694,
 11648,
 777858654,
 777666727,
 4621,
 -1,
 777797799,
 4620,
 777989728,
 777786766,
 4616,
 -1,
 777917838,
 4619,
 -53663,
 777969154,
 4623,
 -53662,
 778096366,
 4617,
 -1,
 778133991,
 4618,
 778317421,
 777613207,
 -1,
 778382950,
 778277362,
 4870,
 -1,
 778311054,
 11662,
 778514024,
 778322087,
 4869,
 -1,
 778453159,
 4868,
 778645098,
 778442126,
 4864,
 -1,
 778573198,
 4867,
 -53653,
 778624514,
 4871,
 -53652,
 778751726,
 4865,
 -1,
 778789351,
 4866,
 778972790,
 778298560,
 -1,
 779038320,
 778932722,
 4846,
 -1,
 778966414,
 4847,
 779169394,
 778977447,
 4845,
 -1,
 779108519,
 4844,
 779300468,
 779097486,
 4840,
 -1,
 779228558,
 4843,
 -53643,
 779276014,
 4841,
 -1,
 779379175,
 4842,
 779562623,
 778952154,
 -1,
 779628153,
 779522546,
 4814,
 -1,
 779556238,
 4815,
 779759227,
 779567271,
 4813,
 -1,
 779698343,
 4812,
 779890301,
 779687310,
 4808,
 -1,
 779818382,
 4811,
 -53634,
 779865838,
 4809,
 -1,
 779968999,
 4810,
 780206079,
 779540582,
 -1,
 780217986,
 780091559,
 4717,
 -1,
 780157095,
 4716,
 780349060,
 780146062,
 4712,
 -1,
 780277134,
 4715,
 -53627,
 780328450,
 4719,
 -53626,
 780455662,
 4713,
 -53625,
 780505586,
 4718,
 -1,
 780558823,
 4714,
 780795903,
 749289639,
 -1,
 -53622,
 780698881,
 4964,
 -1,
 780744014,
 4960,
 780938906,
 749244578,
 -1,
 781004433,
 780911480,
 -1,
 781069967,
 780945169,
 4978,
 -1,
 780995300,
 4988,
 -53616,
 781049649,
 4979,
 -1,
 781147699,
 4980,
 781332116,
 780974000,
 -1,
 -53613,
 781283205,
 4983,
 -1,
 781339904,
 4984,
 781528727,
 781274782,
 -1,
 -53610,
 781490803,
 4981,
 -1,
 781542637,
 4982,
 -53608,
 781487424,
 4986,
 -53607,
 781672831,
 4987,
 -1,
 781731227,
 4985,
 781921959,
 780913230,
 -1,
 781987487,
 781858348,
 -1,
 782053022,
 781928936,
 5009,
 -1,
 781979656,
 5016,
 -1,
 782001331,
 5012,
 782249634,
 781938934,
 -1,
 -53599,
 782227199,
 5017,
 -1,
 782255984,
 5013,
 -53597,
 782231226,
 5008,
 -53596,
 782416954,
 5011,
 -53595,
 782479901,
 5010,
 -53594,
 782523689,
 5015,
 -1,
 782577631,
 5014,
 782773940,
 781859236,
 -1,
 782839467,
 782746488,
 -1,
 -53590,
 782819937,
 4970,
 -1,
 782852286,
 4971,
 783036078,
 782809008,
 -1,
 -53587,
 782987100,
 4974,
 -1,
 783043759,
 4975,
 783232689,
 782978718,
 -1,
 -53584,
 783195250,
 4972,
 -1,
 783249125,
 4973,
 -53582,
 783193634,
 4969,
 -53581,
 783387935,
 4977,
 -1,
 783435095,
 4976,
 783625913,
 782709260,
 -1,
 783691448,
 783581256,
 -1,
 -53577,
 783646869,
 4963,
 -1,
 783690167,
 4959,
 -1,
 783646069,
 4965,
 783953596,
 783589483,
 -1,
 -53573,
 783920424,
 4966,
 -1,
 783950072,
 4968,
 -53571,
 783934378,
 4961,
 -53570,
 784116032,
 4967,
 -1,
 784159498,
 4962,
 784346848,
 749185091,
 -1,
 784412379,
 784275993,
 -1,
 784477906,
 784381874,
 -1,
 784543440,
 784448700,
 61,
 784662527,
 784465920,
 -1,
 784674508,
 784536974,
 -1,
 784740042,
 784608115,
 -1,
 -53561,
 784713917,
 10867,
 -53560,
 784773420,
 10609,
 -53559,
 784835851,
 10865,
 -1,
 784890037,
 11072,
 785121279,
 784698105,
 10723,
 -1,
 784993955,
 10724,
 785252351,
 784654404,
 -1,
 -53554,
 785174075,
 10871,
 -53553,
 785202011,
 10854,
 -1,
 785263723,
 10926,
 -53551,
 784523338,
 10862,
 -1,
 785396248,
 8789,
 785645567,
 784400384,
 -1,
 785657562,
 785566169,
 -1,
 785723097,
 785619067,
 -1,
 -53546,
 785695295,
 8927,
 -53545,
 785753733,
 8926,
 -53544,
 785807799,
 8924,
 -1,
 785864543,
 8925,
 -1,
 785657039,
 8797,
 -1,
 785587755,
 8917,
 786235391,
 784359911,
 -1,
 786247391,
 786159783,
 -1,
 -53538,
 786227413,
 10872,
 -1,
 786287062,
 8781,
 -1,
 786177789,
 8794,
 786509556,
 784327638,
 -1,
 786575087,
 786482661,
 -1,
 786640613,
 786547576,
 -1,
 -53532,
 786621025,
 1778,
 -1,
 786653374,
 1779,
 786837224,
 786610096,
 -1,
 -53529,
 786788188,
 1782,
 -1,
 786844847,
 1783,
 787033835,
 786779806,
 -1,
 -53526,
 786996338,
 1780,
 -1,
 787050213,
 1781,
 -53524,
 787015791,
 1776,
 -53523,
 787191330,
 1777,
 -53522,
 787254559,
 1785,
 -1,
 787301719,
 1784,
 787546111,
 786509059,
 -1,
 787558131,
 787445052,
 -1,
 -53518,
 787523904,
 8265,
 -1,
 787579581,
 33,
 -1,
 787499770,
 8761,
 787820292,
 786462398,
 -1,
 787885825,
 787776643,
 8712,
 788004863,
 787808256,
 -1,
 788016894,
 787931204,
 -1,
 -53511,
 787995445,
 8947,
 -53510,
 788058875,
 8952,
 -53509,
 788123229,
 8953,
 -53508,
 788176684,
 8950,
 -53507,
 788233641,
 8946,
 -1,
 788282173,
 8949,
 788529151,
 787978220,
 -1,
 -53504,
 788452813,
 10194,
 -1,
 788479824,
 10969,
 788725759,
 787821946,
 -1,
 -53501,
 788601383,
 9191,
 -1,
 788660730,
 8961,
 788868881,
 787775560,
 -1,
 788934413,
 788832363,
 -1,
 788999948,
 788909776,
 8709,
 789118975,
 788925494,
 -1,
 -53495,
 789036684,
 10674,
 -53494,
 789098308,
 10675,
 -53493,
 789159724,
 10673,
 -1,
 789215003,
 10676,
 -1,
 788945762,
 9091,
 789512191,
 788856832,
 -1,
 -53489,
 789430154,
 8195,
 -53488,
 789489738,
 8193,
 -1,
 789526293,
 8212,
 789720862,
 788834774,
 -1,
 789786395,
 789689593,
 -1,
 789851927,
 789766017,
 -1,
 -53483,
 789823476,
 10734,
 -53482,
 789854521,
 10736,
 -1,
 789917793,
 10738,
 790167551,
 789785121,
 -1,
 -53479,
 790085620,
 10735,
 -53478,
 790116665,
 10737,
 -1,
 790179937,
 10739,
 790429695,
 789717855,
 -1,
 -53475,
 790343406,
 8998,
 -1,
 790394609,
 9003,
 790572841,
 789669195,
 -1,
 790638376,
 790495232,
 -1,
 790703910,
 790601835,
 -1,
 790769445,
 790664224,
 -1,
 -53469,
 790736048,
 10039,
 -53468,
 790799438,
 10037,
 -1,
 790833785,
 10036,
 -1,
 790711235,
 10049,
 -53465,
 790676815,
 10058,
 -1,
 791068636,
 10035,
 -1,
 790583544,
 9834,
 791293745,
 790530370,
 -1,
 791359278,
 791216128,
 -1,
 -53460,
 791330698,
 8194,
 -53459,
 791390282,
 8192,
 -1,
 791426837,
 8211,
 -53457,
 791337520,
 9993,
 -53456,
 791594527,
 9094,
 -1,
 791623250,
 8718,
 791818038,
 791269102,
 -1,
 791883573,
 791786597,
 -1,
 -53452,
 791809890,
 8352,
 -1,
 791874104,
 8364,
 -1,
 791837089,
 8455,
 792145722,
 791745934,
 -1,
 792211257,
 792114899,
 9793,
 -1,
 792134701,
 9178,
 -1,
 792182971,
 9841,
 792407869,
 792117574,
 -1,
 -53444,
 792377264,
 8793,
 -1,
 792409712,
 8494,
 -53442,
 792358873,
 9167,
 -1,
 792541784,
 11790,
 792737434,
 671138680,
 -1,
 792801995,
 792663438,
 -1,
 792867059,
 792757660,
 -1,
 792932482,
 792836016,
 -1,
 792998013,
 792913607,
 -1,
 793063301,
 792955202,
 -1,
 793128799,
 793020738,
 -1,
 793194323,
 793086274,
 -1,
 793259851,
 793122190,
 -1,
 -53431,
 793235182,
 983833,
 -53430,
 793272807,
 983830,
 -1,
 793318798,
 983823,
 793521997,
 793235182,
 983826,
 -1,
 793497326,
 983827,
 793653071,
 793481714,
 983831,
 -1,
 793612786,
 983832,
 793784145,
 793600487,
 983824,
 -1,
 793731559,
 983825,
 793968639,
 793723047,
 983828,
 -1,
 793854119,
 983829,
 794046295,
 793122190,
 -1,
 -53419,
 794021614,
 983701,
 -53418,
 794059239,
 983698,
 -1,
 794105230,
 983691,
 794308441,
 794021614,
 983694,
 -1,
 794283758,
 983695,
 794439515,
 794268146,
 983699,
 -1,
 794399218,
 983700,
 794570589,
 794386919,
 983692,
 -1,
 794517991,
 983693,
 794755071,
 794509479,
 983696,
 -1,
 794640551,
 983697,
 794832748,
 793109696,
 -1,
 794898276,
 794760590,
 -1,
 -53406,
 794873582,
 983679,
 -53405,
 794911207,
 983676,
 -1,
 794957198,
 983669,
 795160422,
 794873582,
 983672,
 -1,
 795135726,
 983673,
 795291496,
 795120114,
 983677,
 -1,
 795251186,
 983678,
 795422570,
 795238887,
 983670,
 -1,
 795369959,
 983671,
 795607039,
 795361447,
 983674,
 -1,
 795492519,
 983675,
 795684729,
 794776363,
 -1,
 795750257,
 795612558,
 -1,
 -53393,
 795725550,
 983657,
 -53392,
 795763175,
 983654,
 -1,
 795809166,
 983647,
 796012403,
 795725550,
 983650,
 -1,
 795987694,
 983651,
 796143477,
 795972082,
 983655,
 -1,
 796103154,
 983656,
 796274551,
 796090855,
 983648,
 -1,
 796221927,
 983649,
 796459007,
 796213415,
 983652,
 -1,
 796344487,
 983653,
 796536701,
 795612558,
 -1,
 -53381,
 796511982,
 983723,
 -53380,
 796549607,
 983720,
 -1,
 796595598,
 983713,
 796798847,
 796511982,
 983716,
 -1,
 796774126,
 983717,
 796929921,
 796758514,
 983721,
 -1,
 796889586,
 983722,
 797060995,
 796877287,
 983714,
 -1,
 797008359,
 983715,
 797245439,
 796999847,
 983718,
 -1,
 797130919,
 983719,
 797323181,
 793032624,
 -1,
 797388692,
 797268211,
 -1,
 797454219,
 797316494,
 -1,
 -53367,
 797429486,
 983855,
 -53366,
 797467111,
 983852,
 -1,
 797513102,
 983845,
 797716365,
 797429486,
 983848,
 -1,
 797691630,
 983849,
 797847439,
 797676018,
 983853,
 -1,
 797807090,
 983854,
 797978513,
 797794791,
 983846,
 -1,
 797925863,
 983847,
 798109587,
 797917351,
 983850,
 -1,
 798048423,
 983851,
 -1,
 798077458,
 983901,
 798306209,
 797358000,
 -1,
 798371737,
 798233998,
 -1,
 -53353,
 798346990,
 983866,
 -53352,
 798384615,
 983863,
 -1,
 798430606,
 983856,
 798633883,
 798346990,
 983859,
 -1,
 798609134,
 983860,
 798764957,
 798593522,
 983864,
 -1,
 798724594,
 983865,
 798896031,
 798712295,
 983857,
 -1,
 798843367,
 983858,
 799080447,
 798834855,
 983861,
 -1,
 798965927,
 983862,
 799158181,
 798233998,
 -1,
 -53341,
 799133422,
 983877,
 -53340,
 799171047,
 983874,
 -1,
 799217038,
 983867,
 799420327,
 799133422,
 983870,
 -1,
 799395566,
 983871,
 799551401,
 799379954,
 983875,
 -1,
 799511026,
 983876,
 799682475,
 799498727,
 983868,
 -1,
 799629799,
 983869,
 799866879,
 799621287,
 983872,
 -1,
 799752359,
 983873,
 799944660,
 797275076,
 -1,
 800010184,
 799896516,
 -1,
 800075708,
 799962052,
 -1,
 800141236,
 800003470,
 -1,
 -53326,
 800116462,
 983800,
 -53325,
 800154087,
 983797,
 -1,
 800200078,
 983790,
 800403382,
 800116462,
 983793,
 -1,
 800378606,
 983794,
 800534456,
 800362994,
 983798,
 -1,
 800494066,
 983799,
 800665530,
 800481767,
 983791,
 -1,
 800612839,
 983792,
 800849919,
 800604327,
 983795,
 -1,
 800735399,
 983796,
 800927680,
 800003470,
 -1,
 -53314,
 800902894,
 983811,
 -53313,
 800940519,
 983808,
 -1,
 800986510,
 983801,
 801189826,
 800902894,
 983804,
 -1,
 801165038,
 983805,
 801320900,
 801149426,
 983809,
 -1,
 801280498,
 983810,
 801451974,
 801268199,
 983802,
 -1,
 801399271,
 983803,
 801636351,
 801390759,
 983806,
 -1,
 801521831,
 983807,
 801714124,
 799937934,
 -1,
 -53302,
 801689326,
 983778,
 -53301,
 801726951,
 983775,
 -1,
 801772942,
 983768,
 801976270,
 801689326,
 983771,
 -1,
 801951470,
 983772,
 802107344,
 801935858,
 983776,
 -1,
 802066930,
 983777,
 802238418,
 802054631,
 983769,
 -1,
 802185703,
 983770,
 802422783,
 802177191,
 983773,
 -1,
 802308263,
 983774,
 802500590,
 799895798,
 -1,
 802566114,
 802471996,
 -1,
 802631642,
 802493838,
 983889,
 -53288,
 802606830,
 983900,
 -53287,
 802644455,
 983897,
 -1,
 802690446,
 983890,
 802893788,
 802606830,
 983893,
 -1,
 802868974,
 983894,
 803024862,
 802853362,
 983898,
 -1,
 802984434,
 983899,
 803155936,
 802972135,
 983891,
 -1,
 803103207,
 983892,
 803340287,
 803094695,
 983895,
 -1,
 803225767,
 983896,
 803418086,
 802493838,
 -1,
 -53276,
 803393262,
 983646,
 -53275,
 803430887,
 983643,
 -1,
 803476878,
 983636,
 803680232,
 803393262,
 983639,
 -1,
 803655406,
 983640,
 803811306,
 803639794,
 983644,
 -1,
 803770866,
 983645,
 803942380,
 803758567,
 983637,
 -1,
 803889639,
 983638,
 804126719,
 803881127,
 983641,
 -1,
 804012199,
 983642,
 804204552,
 802472824,
 -1,
 804270076,
 804176760,
 -1,
 804335604,
 804197774,
 -1,
 -53262,
 804310766,
 983690,
 -53261,
 804348391,
 983687,
 -1,
 804394382,
 983680,
 804597750,
 804310766,
 983683,
 -1,
 804572910,
 983684,
 804728824,
 804557298,
 983688,
 -1,
 804688370,
 983689,
 804859898,
 804676071,
 983681,
 -1,
 804807143,
 983682,
 805044223,
 804798631,
 983685,
 -1,
 804929703,
 983686,
 805122048,
 804197774,
 -1,
 -53250,
 805097198,
 983712,
 -53249,
 805134823,
 983709,
 -1,
 805180814,
 983702,
 805384194,
 805097198,
 983705,
 -1,
 805359342,
 983706,
 805515268,
 805343730,
 983710,
 -1,
 805474802,
 983711,
 805646342,
 805462503,
 983703,
 -1,
 805593575,
 983704,
 805830655,
 805585063,
 983707,
 -1,
 805716135,
 983708,
 805908514,
 804170198,
 -1,
 805974038,
 805874134,
 -1,
 806039566,
 805901710,
 -1,
 -53236,
 806014702,
 983822,
 -53235,
 806052327,
 983819,
 -1,
 806098318,
 983812,
 806301712,
 806014702,
 983815,
 -1,
 806276846,
 983816,
 806432786,
 806261234,
 983820,
 -1,
 806392306,
 983821,
 806563860,
 806380007,
 983813,
 -1,
 806511079,
 983814,
 806748159,
 806502567,
 983817,
 -1,
 806633639,
 983818,
 806826010,
 805901710,
 -1,
 -53224,
 806801134,
 983767,
 -53223,
 806838759,
 983764,
 -1,
 806884750,
 983757,
 807088156,
 806801134,
 983760,
 -1,
 807063278,
 983761,
 807219230,
 807047666,
 983765,
 -1,
 807178738,
 983766,
 807350304,
 807166439,
 983758,
 -1,
 807297511,
 983759,
 807534591,
 807288999,
 983762,
 -1,
 807420071,
 983763,
 807612463,
 805889216,
 -1,
 807677991,
 807540110,
 -1,
 -53211,
 807653102,
 983756,
 -53210,
 807690727,
 983753,
 -1,
 807736718,
 983746,
 807940137,
 807653102,
 983749,
 -1,
 807915246,
 983750,
 808071211,
 807899634,
 983754,
 -1,
 808030706,
 983755,
 808202285,
 808018407,
 983747,
 -1,
 808149479,
 983748,
 808386559,
 808140967,
 983751,
 -1,
 808272039,
 983752,
 808464444,
 807589990,
 -1,
 808529972,
 808392078,
 -1,
 -53198,
 808505070,
 983789,
 -53197,
 808542695,
 983786,
 -1,
 808588686,
 983779,
 808792118,
 808505070,
 983782,
 -1,
 808767214,
 983783,
 808923192,
 808751602,
 983787,
 -1,
 808882674,
 983788,
 809054266,
 808870375,
 983780,
 -1,
 809001447,
 983781,
 809238527,
 808992935,
 983784,
 -1,
 809124007,
 983785,
 809316425,
 808427627,
 -1,
 809381953,
 809244046,
 -1,
 -53185,
 809357038,
 983734,
 -53184,
 809394663,
 983731,
 -1,
 809440654,
 983724,
 809644099,
 809357038,
 983727,
 -1,
 809619182,
 983728,
 809775173,
 809603570,
 983732,
 -1,
 809734642,
 983733,
 809906247,
 809722343,
 983725,
 -1,
 809853415,
 983726,
 810090495,
 809844903,
 983729,
 -1,
 809975975,
 983730,
 810168406,
 809271368,
 -1,
 810233934,
 810096014,
 -1,
 -53172,
 810209006,
 983745,
 -53171,
 810246631,
 983742,
 -1,
 810292622,
 983735,
 810496080,
 810209006,
 983738,
 -1,
 810471150,
 983739,
 810627154,
 810455538,
 983743,
 -1,
 810586610,
 983744,
 810758228,
 810574311,
 983736,
 -1,
 810705383,
 983737,
 810942463,
 810696871,
 983740,
 -1,
 810827943,
 983741,
 811020387,
 810119063,
 -1,
 811085915,
 810947982,
 -1,
 -53159,
 811060974,
 983844,
 -53158,
 811098599,
 983841,
 -1,
 811144590,
 983834,
 811348061,
 811060974,
 983837,
 -1,
 811323118,
 983838,
 811479135,
 811307506,
 983842,
 -1,
 811438578,
 983843,
 811610209,
 811426279,
 983835,
 -1,
 811557351,
 983836,
 811794431,
 811548839,
 983839,
 -1,
 811679911,
 983840,
 811872368,
 810965235,
 -1,
 811937896,
 811799950,
 -1,
 -53146,
 811912942,
 983888,
 -53145,
 811950567,
 983885,
 -1,
 811996558,
 983878,
 812200042,
 811912942,
 983881,
 -1,
 812175086,
 983882,
 812331116,
 812159474,
 983886,
 -1,
 812290546,
 983887,
 812462190,
 812278247,
 983879,
 -1,
 812409319,
 983880,
 812646399,
 812400807,
 983883,
 -1,
 812531879,
 983884,
 812777471,
 811805955,
 -1,
 812789877,
 812651918,
 -1,
 -53133,
 812764910,
 983668,
 -53132,
 812802535,
 983665,
 -1,
 812848526,
 983658,
 813052023,
 812764910,
 983661,
 -1,
 813027054,
 983662,
 813183097,
 813011442,
 983666,
 -1,
 813142514,
 983667,
 813314171,
 813130215,
 983659,
 -1,
 813261287,
 983660,
 813498367,
 813252775,
 983663,
 -1,
 813383847,
 983664,
 813629439,
 792946161,
 -1,
 813641857,
 813554743,
 -1,
 -53120,
 813611190,
 2947,
 -1,
 813673231,
 3021,
 -1,
 813572028,
 2946,
 813904045,
 792885826,
 -1,
 813969546,
 813861186,
 -1,
 814035079,
 813926722,
 -1,
 -53114,
 813992350,
 2985,
 -1,
 814028174,
 2979,
 -53112,
 814015740,
 2974,
 -53111,
 814175071,
 2969,
 -1,
 814224782,
 2984,
 814428302,
 813897102,
 2949,
 -53108,
 814403310,
 2964,
 -53107,
 814440935,
 2960,
 -1,
 814486926,
 2950,
 814690450,
 814397360,
 -1,
 -53104,
 814659626,
 2999,
 -53103,
 814700817,
 2998,
 -1,
 814749070,
 3000,
 814952599,
 814642116,
 -1,
 815018134,
 814904260,
 -1,
 -53099,
 814969881,
 2996,
 -1,
 815011214,
 2995,
 -1,
 814945678,
 2994,
 815280281,
 814927598,
 2953,
 -1,
 815255278,
 2954,
 815411356,
 815252344,
 -1,
 -53093,
 815383481,
 2975,
 -1,
 815404430,
 2980,
 815607967,
 815376854,
 -1,
 -53090,
 815573553,
 2993,
 -1,
 815601038,
 2992,
 815804577,
 815567346,
 2962,
 -1,
 815763954,
 2963,
 815935651,
 815751655,
 2951,
 -1,
 815882727,
 2952,
 816066725,
 815874215,
 2958,
 -1,
 816005287,
 2959,
 -53082,
 816047356,
 2991,
 -53081,
 816175220,
 2997,
 -53080,
 816226512,
 2986,
 -53079,
 816283797,
 2990,
 -53078,
 816345357,
 2965,
 -53077,
 816410521,
 2972,
 -53076,
 816470289,
 3001,
 -1,
 816524640,
 2970,
 816722120,
 813837571,
 -1,
 816787655,
 816682711,
 -1,
 816853172,
 816744770,
 983619,
 816918706,
 816810306,
 983617,
 -1,
 816875842,
 983629,
 -53069,
 816899264,
 983615,
 -1,
 816993067,
 983613,
 817180855,
 816822192,
 983633,
 -53066,
 817149872,
 983632,
 -1,
 817191155,
 983631,
 817377466,
 817132484,
 983624,
 817496063,
 817329092,
 983627,
 -1,
 817394628,
 983626,
 817574076,
 817349496,
 983618,
 -1,
 817546104,
 983616,
 817705150,
 817539542,
 983623,
 -1,
 817670614,
 983628,
 817836224,
 817656054,
 983612,
 -1,
 817807420,
 983635,
 -53055,
 817816768,
 983622,
 -53054,
 817944678,
 983625,
 -53053,
 817995883,
 983620,
 -53052,
 818053192,
 983621,
 -53051,
 818114455,
 983630,
 -53050,
 818174195,
 983634,
 -1,
 818228483,
 983614,
 -1,
 816753874,
 3063,
 818491609,
 816657964,
 -1,
 818557143,
 818439650,
 -1,
 818622669,
 818529144,
 -1,
 -53044,
 818602593,
 3048,
 -1,
 818634942,
 3049,
 818819280,
 818591664,
 -1,
 -53041,
 818769756,
 3052,
 -1,
 818826415,
 3053,
 819015891,
 818761374,
 -1,
 -53038,
 818977906,
 3050,
 -1,
 819031781,
 3051,
 -53036,
 818997359,
 3046,
 -53035,
 819172898,
 3047,
 -53034,
 819236127,
 3055,
 -1,
 819283287,
 3054,
 -53032,
 818496054,
 3062,
 -1,
 819406436,
 3059,
 819605734,
 818470280,
 -1,
 819671262,
 819533198,
 -1,
 -53028,
 819646190,
 3020,
 -53027,
 819683815,
 3016,
 -1,
 819729806,
 3006,
 819933408,
 819646190,
 3009,
 -1,
 819908334,
 3010,
 820064482,
 819892722,
 3018,
 -1,
 820023794,
 3019,
 820195556,
 820011495,
 3007,
 -1,
 820142567,
 3008,
 820379647,
 820134055,
 3014,
 -1,
 820265127,
 3015,
 820457708,
 819564706,
 -1,
 820523242,
 820418086,
 -1,
 -53015,
 820496321,
 3058,
 -1,
 820535679,
 3057,
 -53013,
 820495818,
 3056,
 -1,
 820690108,
 3066,
 820850927,
 820385166,
 -1,
 -53010,
 820825843,
 3031,
 -1,
 820885437,
 3064,
 -53008,
 820831632,
 3061,
 -53007,
 821016413,
 3065,
 -53006,
 821073193,
 3024,
 -1,
 821135213,
 3060,
 821309988,
 792814057,
 -1,
 821375388,
 821282540,
 -1,
 821440825,
 821328450,
 -1,
 821506318,
 821392324,
 -1,
 821571850,
 821469042,
 -1,
 821637372,
 821522678,
 -1,
 -52998,
 821617654,
 6692,
 -52997,
 821647633,
 6693,
 -1,
 821695886,
 6691,
 821899519,
 821609336,
 -1,
 -52994,
 821844241,
 6709,
 -1,
 821892494,
 6708,
 822096130,
 821862507,
 -1,
 -52991,
 822040849,
 6717,
 -1,
 822089102,
 6715,
 822292741,
 822029571,
 -1,
 -52988,
 822237457,
 6699,
 -1,
 822285710,
 6697,
 -52986,
 822273276,
 6719,
 -52985,
 822458410,
 6698,
 -52984,
 822520700,
 6704,
 -52983,
 822565137,
 6732,
 -1,
 822628103,
 6716,
 822817036,
 821499278,
 6723,
 -1,
 822755495,
 6739,
 -52979,
 822792370,
 6724,
 -1,
 822899737,
 6730,
 823079204,
 821452119,
 -1,
 823144723,
 823048112,
 -1,
 -52975,
 823113770,
 6727,
 -52974,
 823154961,
 6726,
 -1,
 823203214,
 6728,
 823406871,
 823095542,
 -1,
 -52971,
 823387126,
 6690,
 -52970,
 823417105,
 6689,
 -1,
 823465358,
 6688,
 823669018,
 823378808,
 -1,
 -52967,
 823613713,
 6707,
 -1,
 823661966,
 6706,
 823865629,
 823631979,
 -1,
 -52964,
 823810321,
 6713,
 -1,
 823858574,
 6712,
 824062240,
 823799043,
 -1,
 -52961,
 824006929,
 6696,
 -1,
 824055182,
 6695,
 -52959,
 824042748,
 6720,
 -52958,
 824224636,
 6702,
 -52957,
 824269073,
 6729,
 -1,
 824332039,
 6714,
 824521001,
 823044566,
 -1,
 824586536,
 824448398,
 6721,
 -52953,
 824558521,
 6701,
 -1,
 824609182,
 6705,
 -1,
 824561842,
 6722,
 824848685,
 824478018,
 -1,
 -52949,
 824829180,
 6700,
 -52948,
 824857439,
 6694,
 -1,
 824907150,
 6710,
 825110831,
 824823534,
 6735,
 -1,
 825085678,
 6736,
 825241905,
 825057767,
 6733,
 -1,
 825188839,
 6734,
 -52942,
 825220610,
 6725,
 -52941,
 825333510,
 6738,
 -52940,
 825393301,
 6718,
 -52939,
 825448268,
 6740,
 -52938,
 825508679,
 6737,
 -52937,
 825570967,
 6703,
 -52936,
 825632461,
 6711,
 -1,
 825693582,
 6731,
 825897307,
 821411009,
 -1,
 825962820,
 825848054,
 -1,
 826028353,
 825909622,
 -1,
 826093888,
 825953224,
 -1,
 -52930,
 826020899,
 6777,
 -52929,
 826086358,
 6776,
 -1,
 826151782,
 6775,
 -1,
 826019961,
 6780,
 826421571,
 825955886,
 6824,
 -1,
 826373034,
 6825,
 -1,
 826362031,
 6819,
 826618185,
 825931818,
 -1,
 826683719,
 826591672,
 6826,
 -1,
 826635178,
 6827,
 -52920,
 826662434,
 6818,
 -1,
 826766145,
 6752,
 826945870,
 826573027,
 -1,
 827011404,
 826896731,
 6772,
 -1,
 826934636,
 6744,
 -52915,
 826991933,
 6823,
 -1,
 827111539,
 6779,
 827273552,
 826925043,
 6816,
 -1,
 827252233,
 6817,
 827404627,
 827247251,
 -1,
 -52910,
 827331265,
 6774,
 -1,
 827396649,
 6773,
 827601238,
 827369942,
 -1,
 -52907,
 827542879,
 6822,
 -1,
 827594139,
 6778,
 827797849,
 827545843,
 -1,
 -52904,
 827760733,
 6820,
 -1,
 827793029,
 6828,
 -52902,
 827734778,
 6821,
 -1,
 827927911,
 6829,
 828125553,
 825875848,
 -1,
 828191074,
 828084722,
 6763,
 828256608,
 828118416,
 -1,
 -52897,
 828188792,
 6764,
 -1,
 828249743,
 6771,
 -52895,
 828236992,
 6765,
 -1,
 828412402,
 6768,
 828584294,
 828165870,
 6761,
 828649829,
 828559086,
 6762,
 -1,
 828588199,
 6760,
 -1,
 828588199,
 6759,
 828846442,
 828511630,
 6753,
 -52888,
 828793319,
 6769,
 -52887,
 828850343,
 6767,
 -1,
 828904846,
 6755,
 829108589,
 828818296,
 -1,
 -52884,
 829053529,
 6770,
 -1,
 829103058,
 6756,
 829305199,
 829055463,
 6757,
 -1,
 829252071,
 6758,
 -52880,
 829260014,
 6754,
 -1,
 829374631,
 6766,
 829567359,
 828098290,
 -1,
 829632885,
 829539192,
 -1,
 -52876,
 829612641,
 6802,
 -1,
 829644990,
 6803,
 829829496,
 829601712,
 -1,
 -52873,
 829779804,
 6806,
 -1,
 829836463,
 6807,
 830026107,
 829771422,
 -1,
 -52870,
 829987954,
 6804,
 -1,
 830041829,
 6805,
 -52868,
 830007407,
 6800,
 -52867,
 830182946,
 6801,
 -52866,
 830246175,
 6809,
 -1,
 830293335,
 6808,
 830484877,
 829513508,
 -1,
 830550403,
 830456696,
 -1,
 -52862,
 830530145,
 6786,
 -1,
 830562494,
 6787,
 830747014,
 830519216,
 -1,
 -52859,
 830697308,
 6790,
 -1,
 830753967,
 6791,
 830943625,
 830688926,
 -1,
 -52856,
 830905458,
 6788,
 -1,
 830959333,
 6789,
 -52854,
 830924911,
 6784,
 -52853,
 831100450,
 6785,
 -52852,
 831163679,
 6793,
 -1,
 831210839,
 6792,
 831455231,
 830419468,
 -1,
 831467931,
 831360824,
 -1,
 831533460,
 831422536,
 -1,
 831598995,
 831472417,
 -1,
 -52846,
 831564337,
 6741,
 -1,
 831616025,
 6742,
 -1,
 831526286,
 6748,
 831861143,
 831484868,
 -1,
 -52842,
 831823742,
 6746,
 -1,
 831854039,
 6743,
 -52840,
 831830058,
 6750,
 -52839,
 832003421,
 6747,
 -52838,
 832065700,
 6745,
 -1,
 832120525,
 6749,
 -1,
 831423295,
 6783,
 832385530,
 821353567,
 -1,
 832451036,
 832338498,
 -1,
 832516541,
 832405126,
 -1,
 832582051,
 832473410,
 -1,
 -52831,
 832562948,
 43664,
 -52830,
 832606706,
 43672,
 -1,
 832657029,
 43656,
 832844200,
 832532726,
 -1,
 832909735,
 832788723,
 -1,
 -52826,
 832868850,
 43650,
 -1,
 832921287,
 43652,
 -1,
 832868850,
 43648,
 833171883,
 832815992,
 -1,
 -52822,
 833130994,
 43668,
 -1,
 833183431,
 43670,
 833368494,
 833134699,
 -1,
 -52819,
 833327602,
 43676,
 -1,
 833380039,
 43678,
 833565105,
 833301763,
 -1,
 -52816,
 833524210,
 43658,
 -1,
 833576647,
 43660,
 -52814,
 833545988,
 43684,
 -52813,
 833739998,
 43690,
 -52812,
 833797906,
 43662,
 -52811,
 833860709,
 43686,
 -52810,
 833917426,
 43694,
 -52809,
 833980055,
 43682,
 -52808,
 834043180,
 43688,
 -52807,
 834100935,
 43692,
 -52806,
 834164357,
 43654,
 -52805,
 834228668,
 43680,
 -52804,
 834288336,
 43666,
 -1,
 834349755,
 43674,
 834600959,
 832462167,
 -1,
 834613698,
 834505026,
 -1,
 -52800,
 834594564,
 43665,
 -52799,
 834638322,
 43673,
 -1,
 834688645,
 43657,
 834875847,
 834564342,
 -1,
 834941382,
 834820339,
 -1,
 -52795,
 834900466,
 43651,
 -1,
 834952903,
 43653,
 -1,
 834900466,
 43649,
 835203530,
 834847608,
 -1,
 -52791,
 835162610,
 43669,
 -1,
 835215047,
 43671,
 835400141,
 835166315,
 -1,
 -52788,
 835359218,
 43677,
 -1,
 835411655,
 43679,
 835596752,
 835333379,
 -1,
 -52785,
 835555826,
 43659,
 -1,
 835608263,
 43661,
 -52783,
 835577604,
 43685,
 -52782,
 835771614,
 43691,
 -52781,
 835829522,
 43663,
 -52780,
 835892325,
 43687,
 -52779,
 835949042,
 43695,
 -52778,
 836011671,
 43683,
 -52777,
 836074796,
 43689,
 -52776,
 836132551,
 43693,
 -52775,
 836195973,
 43655,
 -52774,
 836260284,
 43681,
 -52773,
 836319952,
 43667,
 -1,
 836381371,
 43675,
 836579819,
 832429409,
 -1,
 836645347,
 836507022,
 -1,
 -52769,
 836625600,
 43708,
 -52768,
 836686002,
 43707,
 -52767,
 836733250,
 43709,
 -52766,
 836796488,
 43710,
 -1,
 836834702,
 43697,
 837038567,
 836620014,
 43700,
 837104102,
 836976807,
 43699,
 -1,
 837031310,
 43705,
 -1,
 837031310,
 43706,
 837300713,
 836985319,
 43698,
 -1,
 837227918,
 43704,
 -52758,
 837259762,
 43702,
 -1,
 837370023,
 43701,
 837562866,
 836551424,
 -1,
 837628399,
 837513974,
 -1,
 -52754,
 837585218,
 43739,
 -1,
 837640695,
 43743,
 -52752,
 837597299,
 43741,
 -52751,
 837783685,
 43740,
 -1,
 837836494,
 43742,
 838021623,
 837536361,
 -1,
 -52748,
 837994404,
 43713,
 -52747,
 838057818,
 43714,
 -52746,
 838111365,
 43712,
 -1,
 838157757,
 43711,
 838402047,
 837976296,
 -1,
 -52743,
 838295103,
 43703,
 -1,
 838344325,
 43696,
 838598655,
 832337605,
 -1,
 838611463,
 838517624,
 -1,
 838676994,
 838571628,
 -1,
 -52738,
 838603931,
 6516,
 -52737,
 838669347,
 6515,
 -52736,
 838734806,
 6514,
 -52735,
 838800230,
 6513,
 -1,
 838865601,
 6512,
 839070213,
 838645680,
 -1,
 -52732,
 839014673,
 6497,
 -1,
 839062926,
 6483,
 -52730,
 839014673,
 6487,
 -1,
 839193998,
 6486,
 839397898,
 838549671,
 6507,
 -52727,
 839342323,
 6502,
 -1,
 839401639,
 6501,
 839594509,
 839325070,
 6499,
 -52724,
 839569586,
 6508,
 -1,
 839606759,
 6509,
 839791119,
 839569134,
 6503,
 -1,
 839729319,
 6506,
 839922194,
 839753835,
 -1,
 -52719,
 839866641,
 6490,
 -1,
 839914894,
 6489,
 840118804,
 839881202,
 6505,
 -1,
 840077810,
 6504,
 840249879,
 840075586,
 -1,
 -52714,
 840192863,
 6482,
 -1,
 840242574,
 6498,
 840446490,
 840200438,
 -1,
 -52711,
 840390929,
 6496,
 -1,
 840439182,
 6480,
 -52709,
 840426748,
 6485,
 -52708,
 840623094,
 6481,
 -52707,
 840685684,
 6493,
 -52706,
 840742954,
 6484,
 -52705,
 840804300,
 6495,
 -52704,
 840859797,
 6491,
 -52703,
 840922137,
 6488,
 -52702,
 840983015,
 6500,
 -52701,
 841046289,
 6494,
 -1,
 841109255,
 6492,
 841298633,
 821252907,
 -1,
 841364123,
 841220096,
 -1,
 841429605,
 841315268,
 -1,
 841495134,
 841360704,
 -1,
 841560643,
 841465511,
 -1,
 -52694,
 841541624,
 917626,
 -52693,
 841606336,
 917625,
 -52692,
 841671638,
 917624,
 -52691,
 841735642,
 917623,
 -52690,
 841799782,
 917622,
 -52689,
 841862894,
 917621,
 -52688,
 841925496,
 917620,
 -52687,
 841988016,
 917619,
 -52686,
 842050006,
 917618,
 -52685,
 842115014,
 917617,
 -52684,
 842178667,
 917616,
 -52683,
 842240498,
 917615,
 -52682,
 842303810,
 917614,
 -52681,
 842367048,
 917613,
 -52680,
 842429380,
 917612,
 -52679,
 842494198,
 917611,
 -52678,
 842559383,
 917610,
 -52677,
 842621415,
 917609,
 -52676,
 842684659,
 917608,
 -52675,
 842748715,
 917607,
 -52674,
 842813086,
 917606,
 -52673,
 842875047,
 917605,
 -52672,
 842937900,
 917604,
 -52671,
 843001091,
 917603,
 -52670,
 843064987,
 917602,
 -1,
 843126158,
 917601,
 843382783,
 841494057,
 -1,
 -52667,
 843311096,
 917594,
 -52666,
 843375808,
 917593,
 -52665,
 843441110,
 917592,
 -52664,
 843505114,
 917591,
 -52663,
 843569254,
 917590,
 -52662,
 843632366,
 917589,
 -52661,
 843694968,
 917588,
 -52660,
 843757488,
 917587,
 -52659,
 843819478,
 917586,
 -52658,
 843884486,
 917585,
 -52657,
 843948139,
 917584,
 -52656,
 844009970,
 917583,
 -52655,
 844073282,
 917582,
 -52654,
 844136520,
 917581,
 -52653,
 844198852,
 917580,
 -52652,
 844263670,
 917579,
 -52651,
 844328855,
 917578,
 -52650,
 844390887,
 917577,
 -52649,
 844454131,
 917576,
 -52648,
 844518187,
 917575,
 -52647,
 844582558,
 917574,
 -52646,
 844644519,
 917573,
 -52645,
 844707372,
 917572,
 -52644,
 844770563,
 917571,
 -52643,
 844834459,
 917570,
 -1,
 844895630,
 917569,
 845099620,
 841433255,
 -1,
 845165155,
 845042345,
 -1,
 -52639,
 845135867,
 917595,
 -52638,
 845193640,
 917544,
 -1,
 845231542,
 917627,
 -1,
 845135952,
 917564,
 -1,
 845062006,
 917599,
 845558389,
 841365036,
 -1,
 845623924,
 845506018,
 -1,
 845689450,
 845595512,
 -1,
 -52631,
 845668961,
 917554,
 -1,
 845701310,
 917555,
 845886061,
 845658032,
 -1,
 -52628,
 845836124,
 917558,
 -1,
 845892783,
 917559,
 846082672,
 845827742,
 -1,
 -52625,
 846044274,
 917556,
 -1,
 846098149,
 917557,
 -52623,
 846063727,
 917552,
 -52622,
 846239266,
 917553,
 -52621,
 846302495,
 917561,
 -1,
 846349655,
 917560,
 -1,
 845583600,
 917540,
 846606971,
 845523414,
 -1,
 846672506,
 846554448,
 -1,
 -52616,
 846643195,
 917597,
 -52615,
 846700968,
 917545,
 -1,
 846738870,
 917629,
 -1,
 846613776,
 917596,
 847000194,
 846540035,
 -1,
 847065729,
 846959090,
 -1,
 847131264,
 847021655,
 -1,
 -52609,
 847071703,
 917568,
 -1,
 847123854,
 917548,
 -1,
 847084917,
 917562,
 -1,
 847015105,
 917598,
 847458950,
 846968752,
 -1,
 -52604,
 847421691,
 917536,
 -52603,
 847484102,
 917551,
 -1,
 847529632,
 917563,
 847721098,
 847385998,
 -1,
 -52600,
 847692048,
 917546,
 -52599,
 847750642,
 917543,
 -1,
 847808468,
 917542,
 847983245,
 847685699,
 -1,
 -52596,
 847944468,
 917538,
 -1,
 847989590,
 917567,
 848179856,
 847945835,
 -1,
 -52593,
 848134105,
 917547,
 -1,
 848185795,
 917541,
 848376467,
 848123605,
 -1,
 -52590,
 848314795,
 917566,
 -1,
 848373262,
 917600,
 848573078,
 848314535,
 -1,
 -52587,
 848552984,
 917537,
 -1,
 848603269,
 917565,
 -52585,
 848550833,
 917628,
 -52584,
 848742560,
 917630,
 -52583,
 848793770,
 917539,
 -52582,
 848847319,
 917549,
 -1,
 848909066,
 917550,
 849097395,
 841292894,
 -1,
 849162927,
 849050178,
 -1,
 849228448,
 849119554,
 -1,
 -52577,
 849171295,
 5893,
 -1,
 849221006,
 5896,
 -52575,
 849208572,
 5900,
 -52574,
 849403394,
 5903,
 -52573,
 849465070,
 5890,
 -52572,
 849527737,
 5894,
 -52571,
 849590314,
 5904,
 -52570,
 849649872,
 5897,
 -52569,
 849707157,
 5899,
 -52568,
 849769497,
 5902,
 -52567,
 849834253,
 5891,
 -52566,
 849895911,
 5889,
 -52565,
 849959185,
 5905,
 -52564,
 850023263,
 5892,
 -52563,
 850081431,
 5895,
 -52562,
 850142925,
 5898,
 -1,
 850204046,
 5888,
 850408114,
 849141128,
 -1,
 -52559,
 850382574,
 5907,
 -1,
 850420199,
 5906,
 -1,
 850377984,
 5908,
 850722815,
 849028972,
 -1,
 850735814,
 850623042,
 -1,
 850801336,
 850692418,
 -1,
 -52553,
 850744159,
 5989,
 -1,
 850793870,
 5992,
 -52551,
 850781436,
 5996,
 -52550,
 850976258,
 5999,
 -52549,
 851037934,
 5986,
 -52548,
 851100601,
 5990,
 -52547,
 851163178,
 6000,
 -52546,
 851222736,
 5993,
 -52545,
 851280021,
 5995,
 -52544,
 851342361,
 5998,
 -52543,
 851407117,
 5987,
 -52542,
 851468775,
 5985,
 -52541,
 851530591,
 5988,
 -52540,
 851588759,
 5991,
 -52539,
 851650253,
 5994,
 -1,
 851711374,
 5984,
 851967999,
 850713992,
 -1,
 -52536,
 851889902,
 6003,
 -1,
 851927527,
 6002,
 -52534,
 841275156,
 9801,
 -1,
 852075058,
 9991,
 852243523,
 792748519,
 -1,
 852308973,
 852175181,
 -1,
 852374327,
 852277168,
 -1,
 852439818,
 852348855,
 -1,
 852505304,
 852411256,
 -1,
 852570835,
 852476792,
 -1,
 -52526,
 852515089,
 3995,
 -1,
 852563342,
 3994,
 852767446,
 852539312,
 -1,
 -52523,
 852711697,
 4010,
 -1,
 852759950,
 4009,
 -52521,
 852711697,
 4000,
 -1,
 852891022,
 3999,
 853095137,
 852440620,
 -1,
 853160668,
 853075960,
 -1,
 -52517,
 853104913,
 4012,
 -1,
 853153166,
 4011,
 853357279,
 853095980,
 -1,
 -52514,
 853301521,
 3997,
 -1,
 853349774,
 3996,
 -52512,
 853301521,
 4002,
 -1,
 853480846,
 4001,
 853684966,
 853051714,
 -1,
 -52509,
 853665020,
 3993,
 -52508,
 853707166,
 3998,
 -52507,
 853758815,
 3988,
 -1,
 853808526,
 4003,
 854012650,
 853653424,
 -1,
 -52504,
 853981226,
 4021,
 -52503,
 854022417,
 4020,
 -1,
 854070670,
 4022,
 854274798,
 853962998,
 -1,
 -52500,
 854245469,
 4025,
 -52499,
 854284561,
 3985,
 -1,
 854332814,
 3984,
 854536946,
 854216993,
 -1,
 -52496,
 854516988,
 4027,
 -52495,
 854580738,
 4026,
 -1,
 854633009,
 4028,
 854799093,
 854517752,
 -1,
 -52492,
 854743313,
 4014,
 -1,
 854791566,
 4015,
 854995704,
 854761579,
 -1,
 -52489,
 854939921,
 4005,
 -1,
 854988174,
 4004,
 855192315,
 854938411,
 -1,
 -52486,
 855136529,
 3987,
 -1,
 855184782,
 3986,
 855388926,
 855125251,
 -1,
 -52483,
 855333137,
 3990,
 -1,
 855381390,
 3989,
 855585537,
 855320219,
 -1,
 -52480,
 855529745,
 4007,
 -1,
 855577998,
 4006,
 -52478,
 855565564,
 4017,
 -52477,
 855760386,
 4013,
 -52476,
 855812657,
 4018,
 -52475,
 855867541,
 4008,
 -52474,
 855929881,
 4019,
 -52473,
 855994265,
 3991,
 -52472,
 856054033,
 4023,
 -52471,
 856102286,
 4024,
 -1,
 856166144,
 4016,
 856372009,
 852387313,
 -1,
 856437531,
 856336854,
 -1,
 856503065,
 856373123,
 -1,
 856568595,
 856459722,
 -1,
 856634130,
 856511275,
 -1,
 -52464,
 856605280,
 4047,
 -52463,
 856658378,
 3870,
 -1,
 856698966,
 3869,
 -1,
 856599519,
 4046,
 857014271,
 856505017,
 -1,
 857027352,
 856904491,
 -1,
 -52458,
 856998496,
 3868,
 -52457,
 857051594,
 3867,
 -1,
 857092182,
 3866,
 -1,
 856992745,
 3871,
 -52454,
 856459747,
 3967,
 -1,
 857305174,
 3966,
 857486110,
 856417532,
 -1,
 -52451,
 857451013,
 3902,
 -1,
 857508906,
 3975,
 857682721,
 857440328,
 -1,
 -52448,
 857616425,
 3977,
 -1,
 857677986,
 3903,
 857879332,
 857634452,
 -1,
 -52445,
 857825820,
 3974,
 -1,
 857882899,
 3976,
 858075943,
 857823328,
 -1,
 -52442,
 858031043,
 3979,
 -1,
 858074518,
 3978,
 -52440,
 858046217,
 3971,
 -1,
 858231227,
 3970,
 858456063,
 856351936,
 -1,
 858469174,
 858358617,
 -1,
 858534704,
 858426940,
 4041,
 858652671,
 858456064,
 -1,
 -52434,
 858558927,
 4042,
 -52433,
 858609797,
 4043,
 -1,
 858664170,
 4044,
 858862386,
 858500094,
 4037,
 -1,
 858786278,
 4039,
 858993461,
 858824811,
 -1,
 -52428,
 858939796,
 4040,
 -1,
 858986576,
 4038,
 -1,
 858931203,
 4036,
 -1,
 858422421,
 3840,
 859321207,
 852325316,
 -1,
 859386740,
 859262048,
 -1,
 859452226,
 859358072,
 -1,
 859517757,
 859423608,
 -1,
 -52420,
 859461905,
 3915,
 -1,
 859510158,
 3914,
 859714368,
 859486128,
 -1,
 -52417,
 859658513,
 3930,
 -1,
 859706766,
 3929,
 -52415,
 859658513,
 3920,
 -1,
 859837838,
 3919,
 860042059,
 859387436,
 -1,
 860107590,
 860022776,
 -1,
 -52411,
 860051729,
 3932,
 -1,
 860099982,
 3931,
 860304201,
 860042796,
 -1,
 -52408,
 860248337,
 3917,
 -1,
 860296590,
 3916,
 -52406,
 860248337,
 3922,
 -1,
 860427662,
 3921,
 860631888,
 859998530,
 -1,
 -52403,
 860611836,
 3913,
 -52402,
 860653982,
 3918,
 -52401,
 860705631,
 3908,
 -1,
 860755342,
 3923,
 860959573,
 860582134,
 -1,
 -52398,
 860930141,
 3945,
 -52397,
 860975373,
 3947,
 -52396,
 861034769,
 3905,
 -1,
 861083022,
 3904,
 861287257,
 860927920,
 -1,
 -52393,
 861255722,
 3941,
 -52392,
 861296913,
 3940,
 -1,
 861345166,
 3942,
 861549404,
 861267960,
 -1,
 -52389,
 861493521,
 3934,
 -1,
 861541774,
 3935,
 861746015,
 861514198,
 -1,
 -52386,
 861710897,
 3948,
 -1,
 861738382,
 3938,
 861942626,
 861708395,
 -1,
 -52383,
 861886737,
 3925,
 -1,
 861934990,
 3924,
 862139237,
 861885227,
 -1,
 -52380,
 862083345,
 3907,
 -1,
 862131598,
 3906,
 862335848,
 862072067,
 -1,
 -52377,
 862279953,
 3910,
 -1,
 862328206,
 3909,
 862532459,
 862267035,
 -1,
 -52374,
 862476561,
 3927,
 -1,
 862524814,
 3926,
 -52372,
 862512380,
 3937,
 -52371,
 862707202,
 3933,
 -52370,
 862748821,
 3928,
 -52369,
 862811161,
 3939,
 -52368,
 862875545,
 3911,
 -52367,
 862935313,
 3943,
 -52366,
 862998829,
 3946,
 -52365,
 863049102,
 3944,
 -1,
 863112960,
 3936,
 863371263,
 859345838,
 -1,
 -52362,
 863271629,
 3862,
 -1,
 863317842,
 3861,
 863515572,
 859275970,
 -1,
 863581059,
 863458091,
 -1,
 863646592,
 863553050,
 -1,
 863712127,
 863626838,
 -1,
 863777662,
 863637921,
 -1,
 -52355,
 863745069,
 3842,
 -1,
 863787153,
 3843,
 -1,
 863751323,
 3841,
 -1,
 863685814,
 3860,
 864157695,
 863621329,
 -1,
 -52350,
 864064912,
 3898,
 -1,
 864101186,
 3899,
 864301965,
 863513859,
 -1,
 864367497,
 864231854,
 -1,
 864433032,
 864292721,
 -1,
 -52345,
 864387969,
 3859,
 -1,
 864431350,
 3894,
 -1,
 864413295,
 3846,
 864695180,
 864321091,
 -1,
 -52341,
 864675460,
 3845,
 -1,
 864693202,
 4052,
 -1,
 864639895,
 3896,
 864957333,
 864258370,
 -1,
 865022866,
 864937653,
 -1,
 865088401,
 864996534,
 4050,
 -1,
 865012262,
 3856,
 -1,
 865057528,
 3854,
 865337343,
 864965645,
 -1,
 -52332,
 865254041,
 3895,
 -1,
 865309107,
 3893,
 865481630,
 864888475,
 -1,
 865547163,
 865449904,
 -1,
 865612698,
 865497334,
 -1,
 -52327,
 865588796,
 3849,
 -1,
 865605096,
 4048,
 -1,
 865550458,
 3892,
 865927167,
 865497360,
 -1,
 -52323,
 865855054,
 3850,
 -1,
 865883607,
 983047,
 866071459,
 865429400,
 -1,
 866136994,
 866020964,
 -1,
 -52319,
 866117215,
 3844,
 -1,
 866134966,
 4051,
 -1,
 866109046,
 3851,
 866399142,
 866045095,
 -1,
 -52315,
 866344037,
 3855,
 -1,
 866391443,
 3897,
 866595753,
 866367408,
 -1,
 -52312,
 866539825,
 3853,
 -1,
 866593817,
 3848,
 866792364,
 866560470,
 -1,
 -52309,
 866740127,
 3857,
 -1,
 866801858,
 3858,
 866988975,
 866721446,
 -1,
 -52306,
 866948496,
 3900,
 -1,
 866984770,
 3901,
 -52304,
 866969236,
 3847,
 -52303,
 867148095,
 3973,
 -52302,
 867206784,
 4049,
 -52301,
 867260907,
 3972,
 -1,
 867317650,
 3852,
 867513296,
 863451556,
 -1,
 867578819,
 867457528,
 -1,
 867644345,
 867550072,
 -1,
 -52296,
 867623521,
 3883,
 -1,
 867655870,
 3884,
 867840956,
 867612592,
 -1,
 -52293,
 867790684,
 3887,
 -1,
 867847343,
 3888,
 868037567,
 867782302,
 -1,
 -52290,
 867998834,
 3885,
 -1,
 868052709,
 3886,
 -52288,
 868018287,
 3891,
 -52287,
 868193826,
 3882,
 -52286,
 868257055,
 3890,
 -1,
 868304215,
 3889,
 868496326,
 867550072,
 -1,
 -52283,
 868475489,
 3874,
 -1,
 868507838,
 3875,
 868692937,
 868464560,
 -1,
 -52280,
 868642652,
 3878,
 -1,
 868699311,
 3879,
 868889548,
 868634270,
 -1,
 -52277,
 868850802,
 3876,
 -1,
 868904677,
 3877,
 -52275,
 868870255,
 3872,
 -52274,
 869045794,
 3873,
 -52273,
 869109023,
 3881,
 -1,
 869156183,
 3880,
 869348321,
 867491208,
 -1,
 869413846,
 869326049,
 -1,
 869479380,
 869378518,
 3958,
 -1,
 869444054,
 3959,
 869662719,
 869430212,
 3960,
 -1,
 869561284,
 3961,
 869741528,
 869388014,
 3956,
 -1,
 869715694,
 3957,
 869872602,
 869707282,
 3968,
 -1,
 869818855,
 3969,
 870003676,
 869831154,
 3964,
 -1,
 869962226,
 3965,
 870134750,
 869949927,
 3954,
 -1,
 870080999,
 3955,
 870265824,
 870072487,
 3962,
 -1,
 870203559,
 3963,
 -1,
 870192657,
 3953,
 870462438,
 869281263,
 -1,
 -52253,
 870430951,
 4035,
 -52252,
 870480678,
 4033,
 -52251,
 870538291,
 4032,
 -1,
 870591973,
 4034,
 870790123,
 870392938,
 -1,
 870855658,
 870758320,
 -1,
 -52247,
 870799064,
 3863,
 -1,
 870857512,
 3865,
 -1,
 870781019,
 3864,
 871170047,
 870740856,
 4030,
 -1,
 871039596,
 4031,
 871248940,
 852250738,
 -1,
 871314475,
 871201346,
 -1,
 871379993,
 871294144,
 -1,
 871445526,
 871306638,
 11568,
 871511029,
 871380524,
 11575,
 871576564,
 871446060,
 11577,
 -1,
 871520499,
 11578,
 -1,
 871520499,
 11576,
 871773176,
 871491576,
 11619,
 -52233,
 871753720,
 11621,
 -1,
 871782643,
 11594,
 871969787,
 871744376,
 11612,
 -52230,
 871940984,
 11615,
 -1,
 871979251,
 11613,
 872166398,
 871937968,
 11609,
 -52227,
 872134576,
 11610,
 -1,
 872175859,
 11611,
 872363009,
 872116470,
 11581,
 872480767,
 872306931,
 11589,
 -1,
 872372467,
 11583,
 872559620,
 872305451,
 11571,
 872677375,
 872503539,
 11606,
 -1,
 872569075,
 11572,
 872756230,
 872524246,
 11604,
 -1,
 872720854,
 11605,
 872887304,
 872700147,
 11584,
 -1,
 872831219,
 11587,
 873018378,
 872818331,
 11569,
 -1,
 872962291,
 11570,
 -52213,
 872998080,
 11618,
 -52212,
 873127386,
 11617,
 -52211,
 873191526,
 11616,
 -52210,
 873244614,
 11591,
 -52209,
 873308267,
 11602,
 -52208,
 873367874,
 11599,
 -52207,
 873431112,
 11598,
 -52206,
 873493444,
 11597,
 -52205,
 873557911,
 11574,
 -52204,
 873615006,
 11580,
 -52203,
 873672519,
 11614,
 -1,
 873731470,
 11588,
 -52201,
 871419630,
 11603,
 -52200,
 873882087,
 11593,
 -1,
 873942657,
 11579,
 874132517,
 871351160,
 -1,
 874198052,
 874106744,
 -1,
 874263581,
 874148086,
 11582,
 -1,
 874207475,
 11590,
 874394656,
 874205995,
 -1,
 -52193,
 874350914,
 11600,
 -1,
 874404083,
 11607,
 -52191,
 874375339,
 11596,
 -52190,
 874555334,
 11592,
 -52189,
 874613786,
 11601,
 -1,
 874666227,
 11586,
 -1,
 874128961,
 11620,
 874918952,
 874064041,
 -1,
 -52185,
 874868631,
 11573,
 -1,
 874928371,
 11585,
 875167743,
 874845582,
 -1,
 -52182,
 875095589,
 11608,
 -1,
 875125115,
 11595,
 -1,
 871270079,
 11631,
 875377723,
 871200442,
 126,
 875495423,
 875298816,
 -1,
 875508790,
 875403266,
 8764,
 875626495,
 875429888,
 -1,
 875639859,
 875552836,
 -1,
 -52174,
 875606892,
 10859,
 -1,
 875641661,
 10858,
 875888639,
 875566741,
 -1,
 -52171,
 875802924,
 10610,
 -1,
 875854005,
 11081,
 876085247,
 875487300,
 -1,
 876098618,
 875969336,
 -1,
 -52167,
 876030072,
 11807,
 -1,
 876091023,
 11806,
 -1,
 876065345,
 11803,
 876360765,
 875336093,
 10750,
 -1,
 876284898,
 68410,
 876491840,
 876315798,
 -1,
 -52161,
 876457905,
 10709,
 -1,
 876509035,
 10708,
 -52159,
 876459215,
 8266,
 -52158,
 876631436,
 10053,
 -1,
 876691669,
 10717,
 876885316,
 852181159,
 -1,
 876950728,
 876835780,
 -1,
 877016260,
 876925165,
 -1,
 877081742,
 876967614,
 -1,
 877147277,
 877055230,
 -1,
 877212751,
 877123686,
 -1,
 877278286,
 877171384,
 -1,
 877343820,
 877242838,
 3083,
 -1,
 877308374,
 3168,
 877527039,
 877294532,
 3084,
 -1,
 877425604,
 3169,
 -1,
 877204878,
 3125,
 877671510,
 877183864,
 -1,
 877737043,
 877642616,
 -1,
 -52142,
 877680913,
 3104,
 -1,
 877729166,
 3103,
 -52140,
 877705258,
 3160,
 -52139,
 877877521,
 3109,
 -1,
 877925774,
 3108,
 878130269,
 877606444,
 -1,
 878195802,
 878065196,
 -1,
 -52135,
 878139665,
 3106,
 -1,
 878187918,
 3105,
 -52133,
 878176266,
 3161,
 -52132,
 878336273,
 3111,
 -1,
 878384526,
 3110,
 878589026,
 878086466,
 -1,
 -52129,
 878568700,
 3102,
 -52128,
 878610846,
 3107,
 -52127,
 878662495,
 3097,
 -1,
 878712206,
 3112,
 878916710,
 878515598,
 3077,
 -52124,
 878890734,
 3092,
 -52123,
 878928359,
 3088,
 -1,
 878974350,
 3078,
 879178858,
 878884784,
 -1,
 -52120,
 879147050,
 3127,
 -52119,
 879188241,
 3126,
 -1,
 879236494,
 3128,
 879441004,
 879152878,
 3081,
 -1,
 879415022,
 3082,
 879572079,
 879405526,
 -1,
 -52114,
 879536689,
 3121,
 -1,
 879564174,
 3120,
 879768690,
 879534187,
 -1,
 -52111,
 879712529,
 3115,
 -1,
 879760782,
 3114,
 879965300,
 879727090,
 3090,
 -1,
 879923698,
 3091,
 880096375,
 879915972,
 -1,
 -52106,
 880047129,
 3123,
 -1,
 880088462,
 3122,
 880292986,
 880046326,
 -1,
 -52103,
 880236817,
 3094,
 -1,
 880285070,
 3093,
 880489597,
 880242583,
 -1,
 -52100,
 880433425,
 3101,
 -1,
 880481678,
 3100,
 880686207,
 880435687,
 3079,
 -1,
 880632295,
 3080,
 880817282,
 880628523,
 -1,
 -52095,
 880761105,
 3096,
 -1,
 880809358,
 3095,
 881013892,
 880754855,
 3086,
 -1,
 880951463,
 3087,
 881144967,
 880946435,
 -1,
 -52090,
 881088785,
 3099,
 -1,
 881137038,
 3098,
 881341578,
 881075867,
 -1,
 -52087,
 881285393,
 3117,
 -1,
 881333646,
 3116,
 -52085,
 881321212,
 3119,
 -52084,
 881492117,
 3118,
 -1,
 881547537,
 3129,
 -1,
 877104307,
 3157,
 881800352,
 877059464,
 -1,
 881865876,
 881777889,
 -1,
 881931410,
 881830358,
 3139,
 -1,
 881895894,
 3140,
 882114559,
 881882052,
 3170,
 -1,
 882013124,
 3171,
 882193560,
 881792398,
 -1,
 -52074,
 882167534,
 3148,
 -52073,
 882205159,
 3144,
 -1,
 882251150,
 3134,
 882455706,
 882167534,
 3137,
 -1,
 882429678,
 3138,
 882586780,
 882414066,
 3146,
 -1,
 882545138,
 3147,
 882717854,
 882532839,
 3135,
 -1,
 882663911,
 3136,
 882900991,
 882655399,
 3142,
 -1,
 882786471,
 3143,
 882980014,
 881736100,
 -1,
 883045540,
 882951032,
 -1,
 -52061,
 883024481,
 3176,
 -1,
 883056830,
 3177,
 883242151,
 883013552,
 -1,
 -52058,
 883191644,
 3180,
 -1,
 883248303,
 3181,
 883438762,
 883183262,
 -1,
 -52055,
 883399794,
 3178,
 -1,
 883453669,
 3179,
 -52053,
 883419247,
 3174,
 -52052,
 883594786,
 3175,
 -52051,
 883658015,
 3183,
 -1,
 883705175,
 3182,
 883897530,
 882922101,
 -1,
 883963062,
 883868536,
 -1,
 884028595,
 883942163,
 -1,
 -52046,
 883987199,
 3194,
 -1,
 884034755,
 3197,
 884277247,
 883974447,
 -1,
 -52043,
 884183807,
 3195,
 -1,
 884231363,
 3198,
 884421817,
 883922500,
 -1,
 -52040,
 884380415,
 3193,
 -1,
 884427971,
 3196,
 -1,
 884402292,
 3192,
 884683971,
 883866817,
 -1,
 884749502,
 884661303,
 -1,
 -52035,
 884717750,
 3075,
 -1,
 884779791,
 3149,
 884946113,
 884675982,
 -1,
 -52032,
 884922493,
 3133,
 -1,
 884969768,
 3074,
 -52030,
 884919777,
 3199,
 -1,
 885075417,
 3073,
 -1,
 884611402,
 3158,
 885391359,
 876955855,
 -1,
 -52026,
 885308604,
 8481,
 -52025,
 885369955,
 8981,
 -1,
 885423407,
 9990,
 885601598,
 876923698,
 -1,
 885667035,
 885533955,
 -1,
 885732564,
 885625330,
 -1,
 885798097,
 885688642,
 -1,
 885863632,
 885769080,
 -1,
 -52018,
 885828450,
 119563,
 -52017,
 885868617,
 119582,
 -1,
 885921722,
 119573,
 -1,
 885833956,
 119608,
 886243327,
 885753838,
 -1,
 -52013,
 886137558,
 119634,
 -1,
 886197267,
 119630,
 886387929,
 885685768,
 -1,
 886453464,
 886325415,
 -1,
 -52009,
 886410238,
 119590,
 -1,
 886453828,
 119613,
 -1,
 886429313,
 119631,
 -52006,
 886332084,
 119585,
 -1,
 886655056,
 119558,
 886846697,
 885601836,
 -1,
 886912226,
 886792679,
 -1,
 886977760,
 886865992,
 -1,
 -52001,
 886932956,
 119625,
 -1,
 886991299,
 119612,
 -51999,
 886954634,
 119568,
 -1,
 887115799,
 119636,
 887305446,
 886849703,
 -1,
 -51996,
 887267825,
 119623,
 -51995,
 887312280,
 119567,
 -1,
 887370010,
 119586,
 -51993,
 887281678,
 119584,
 -51992,
 887528451,
 119619,
 -1,
 887562763,
 119624,
 887764210,
 886784167,
 -1,
 887829742,
 887720258,
 -1,
 -51988,
 887780832,
 119603,
 -51987,
 887830383,
 119583,
 -1,
 887894995,
 119600,
 -51985,
 887809108,
 119626,
 -51984,
 888063591,
 119610,
 -51983,
 888111917,
 119618,
 -1,
 888152923,
 119580,
 888354044,
 887728598,
 -1,
 888419579,
 888291495,
 -1,
 888485113,
 888387504,
 -1,
 888550648,
 888431079,
 -1,
 -51977,
 888520925,
 119579,
 -1,
 888551365,
 119596,
 -1,
 888513997,
 119598,
 -51974,
 888436450,
 119578,
 -1,
 888739708,
 119572,
 -1,
 888368842,
 119605,
 889009413,
 888295070,
 -1,
 889074944,
 888983962,
 -1,
 -51969,
 889031678,
 119595,
 -1,
 889062053,
 119559,
 889271555,
 889033202,
 -1,
 -51966,
 889241864,
 119638,
 -1,
 889289986,
 119576,
 -51964,
 889223924,
 119606,
 -1,
 889395602,
 119632,
 889599245,
 888977328,
 -1,
 889664779,
 889570168,
 -1,
 889730314,
 889623026,
 -1,
 -51959,
 889706930,
 119601,
 -1,
 889759250,
 119628,
 -1,
 889695587,
 119593,
 -51956,
 889612768,
 119621,
 -1,
 889933063,
 119627,
 890123539,
 889541419,
 -1,
 890189072,
 890053916,
 119592,
 -1,
 890111141,
 119615,
 -51951,
 890163053,
 119614,
 -51950,
 890285113,
 119602,
 -1,
 890344461,
 119599,
 890516761,
 890085483,
 -1,
 890582295,
 890443150,
 -1,
 -51946,
 890555652,
 119604,
 -1,
 890581374,
 119588,
 -51944,
 890558093,
 119594,
 -1,
 890718131,
 119571,
 890909982,
 890443150,
 -1,
 -51941,
 890878211,
 119564,
 -51940,
 890918137,
 119633,
 -51939,
 890978436,
 119577,
 -1,
 891039393,
 119617,
 891237666,
 890863688,
 -1,
 -51936,
 891186415,
 119560,
 -51935,
 891240859,
 119609,
 -1,
 891298830,
 119616,
 891499815,
 891188164,
 -1,
 891565350,
 891426190,
 -1,
 -51931,
 891543014,
 119597,
 -1,
 891562854,
 119637,
 -1,
 891503831,
 119589,
 891827499,
 891430555,
 -1,
 -51927,
 891792187,
 119566,
 -51926,
 891851943,
 119587,
 -1,
 891888256,
 119561,
 892089646,
 891805186,
 -1,
 -51923,
 892060947,
 119620,
 -1,
 892104299,
 119575,
 892286257,
 892047858,
 -1,
 -51920,
 892249643,
 119565,
 -1,
 892307810,
 119635,
 892482868,
 892236022,
 -1,
 -51917,
 892430832,
 119591,
 -1,
 892486539,
 119562,
 892679479,
 892430232,
 -1,
 -51914,
 892636141,
 119622,
 -1,
 892679139,
 119570,
 892876090,
 892623091,
 -1,
 -51911,
 892834998,
 119574,
 -1,
 892871044,
 119629,
 -51909,
 892856117,
 119569,
 -51908,
 893049226,
 119607,
 -51907,
 893113189,
 119611,
 -1,
 893153461,
 119581,
 893334849,
 885557570,
 -1,
 -51904,
 893305720,
 9978,
 -1,
 893342848,
 8376,
 893583359,
 893264268,
 -1,
 -51901,
 893501404,
 10043,
 -1,
 893527987,
 10170,
 893728294,
 876828915,
 -1,
 893793802,
 893654414,
 -1,
 893859270,
 893739497,
 -1,
 893924792,
 893791491,
 -1,
 893990327,
 893868798,
 -1,
 894055776,
 893958064,
 -1,
 894121306,
 893984953,
 -1,
 894186834,
 894047630,
 3632,
 894252367,
 894132747,
 -1,
 -51890,
 894226281,
 3651,
 -1,
 894245513,
 3652,
 -51888,
 894206024,
 3635,
 -51887,
 894386343,
 3649,
 -1,
 894440846,
 3634,
 894645590,
 894160622,
 3640,
 894711125,
 894582951,
 3638,
 -1,
 894648487,
 3639,
 -1,
 894684910,
 3641,
 894907736,
 894591463,
 3636,
 -1,
 894853607,
 3637,
 -51879,
 894865906,
 3650,
 -1,
 894976167,
 3648,
 895221759,
 894079476,
 -1,
 895235423,
 895137712,
 -1,
 -51875,
 895209314,
 3626,
 -51874,
 895259122,
 3595,
 -1,
 895294075,
 3624,
 -1,
 895203182,
 3625,
 895563119,
 894026616,
 -1,
 895628652,
 895506675,
 -1,
 895694187,
 895586804,
 -1,
 895759721,
 895665843,
 -1,
 895825255,
 895686030,
 -1,
 -51866,
 895781186,
 3600,
 -1,
 895834753,
 3607,
 -51864,
 895800085,
 3606,
 -1,
 895981174,
 3608,
 -51862,
 895722496,
 3602,
 -1,
 896109049,
 3601,
 -1,
 895623054,
 3660,
 896401407,
 895586804,
 -1,
 -51858,
 896320708,
 3605,
 -1,
 896377349,
 3599,
 896546171,
 895516744,
 -1,
 896611706,
 896473415,
 -1,
 896677240,
 896532480,
 -1,
 896742773,
 896648056,
 -1,
 -51852,
 896708230,
 3658,
 -1,
 896753351,
 3657,
 -51850,
 896686741,
 3633,
 -51849,
 896878013,
 3656,
 -1,
 896937854,
 3659,
 -51847,
 896656701,
 3654,
 -1,
 897106976,
 3655,
 -1,
 896569873,
 3617,
 897332614,
 896495862,
 -1,
 897398149,
 897277639,
 -1,
 897463684,
 897318912,
 -1,
 897529219,
 897413744,
 -1,
 -51840,
 897506841,
 3588,
 -51839,
 897568641,
 3587,
 -51838,
 897619344,
 3589,
 -1,
 897653063,
 3586,
 -1,
 897493739,
 3590,
 -1,
 897419522,
 3675,
 -1,
 897356299,
 3585,
 898053520,
 897294443,
 -1,
 898119054,
 897997043,
 -1,
 898184589,
 898077172,
 -1,
 898250124,
 898147249,
 -1,
 -51829,
 898224917,
 3612,
 -1,
 898243939,
 3614,
 -1,
 898218103,
 3616,
 -1,
 898132696,
 3642,
 -51825,
 898077210,
 3611,
 -1,
 898505170,
 3631,
 898708886,
 898009410,
 -1,
 898774420,
 898667030,
 -1,
 -51821,
 898748142,
 3609,
 -1,
 898778897,
 3603,
 -51819,
 898721315,
 3661,
 -1,
 898913928,
 3591,
 899102108,
 898659268,
 -1,
 899167642,
 899060212,
 -1,
 -51815,
 899120067,
 3621,
 -1,
 899166257,
 3628,
 -51813,
 899141358,
 3622,
 -1,
 899291657,
 3653,
 899495329,
 899035120,
 -1,
 899560863,
 899423587,
 3592,
 -1,
 899502891,
 3594,
 -51808,
 899519288,
 3596,
 -1,
 899639567,
 3593,
 899823014,
 899474624,
 -1,
 899888549,
 899781174,
 -1,
 -51804,
 899836175,
 3597,
 -1,
 899881445,
 3618,
 -1,
 899816616,
 3662,
 900150698,
 899764668,
 -1,
 900216233,
 900072387,
 3613,
 -1,
 900172098,
 3615,
 -1,
 900172955,
 3663,
 900412845,
 900114902,
 -1,
 -51796,
 900386542,
 3620,
 -1,
 900436512,
 3619,
 900609456,
 900357834,
 -1,
 -51793,
 900566545,
 3630,
 -1,
 900619781,
 3627,
 900806067,
 900545235,
 -1,
 -51790,
 900740991,
 3604,
 -1,
 900804445,
 3598,
 -51788,
 900784983,
 3623,
 -51787,
 900960759,
 3629,
 -51786,
 900999870,
 3610,
 -1,
 901062351,
 3674,
 -1,
 893966039,
 3647,
 901382143,
 893860260,
 -1,
 901395900,
 901301112,
 -1,
 -51781,
 901374561,
 3666,
 -1,
 901406910,
 3667,
 901592511,
 901363632,
 -1,
 -51778,
 901541724,
 3670,
 -1,
 901598383,
 3671,
 901789122,
 901533342,
 -1,
 -51775,
 901749874,
 3668,
 -1,
 901803749,
 3669,
 -51773,
 901769327,
 3664,
 -51772,
 901944866,
 3665,
 -51771,
 902008095,
 3673,
 -1,
 902055255,
 3672,
 902299647,
 893787510,
 -1,
 902313468,
 902199874,
 -1,
 902378958,
 902284152,
 -1,
 902444491,
 902322452,
 1932,
 -1,
 902397822,
 1947,
 -51764,
 902415304,
 1944,
 -51763,
 902533618,
 1952,
 -1,
 902571555,
 1939,
 902772180,
 902346672,
 -1,
 902837714,
 902715635,
 -1,
 -51759,
 902775686,
 1949,
 -1,
 902833699,
 1921,
 -51757,
 902775686,
 1936,
 -1,
 902960660,
 1950,
 903165401,
 902752248,
 -1,
 903230936,
 903091598,
 -1,
 -51753,
 903208151,
 1938,
 -1,
 903222670,
 1948,
 -1,
 903188978,
 1953,
 903493085,
 903107371,
 -1,
 -51749,
 903449189,
 1935,
 -51748,
 903502280,
 1955,
 -1,
 903550494,
 1934,
 903755234,
 903427628,
 -1,
 903820769,
 903681422,
 -1,
 -51744,
 903797975,
 1937,
 -1,
 903813178,
 1951,
 -1,
 903764248,
 1931,
 904082917,
 903711042,
 -1,
 -51740,
 904042317,
 1922,
 -1,
 904074769,
 1969,
 904279528,
 904033220,
 -1,
 -51737,
 904223610,
 1925,
 -1,
 904271401,
 1933,
 904476139,
 904229110,
 -1,
 -51734,
 904419604,
 1946,
 -1,
 904467998,
 1926,
 904672750,
 904419571,
 -1,
 -51731,
 904616212,
 1945,
 -1,
 904664593,
 1920,
 904869361,
 904598926,
 -1,
 -51728,
 904821487,
 1927,
 -1,
 904882927,
 1954,
 -51726,
 904848643,
 1940,
 -51725,
 905043470,
 1957,
 -51724,
 905107575,
 1928,
 -51723,
 905161284,
 1923,
 -51722,
 905226196,
 1956,
 -51721,
 905290251,
 1941,
 -51720,
 905348126,
 1929,
 -51719,
 905408426,
 1942,
 -51718,
 905465610,
 1930,
 -51717,
 905523079,
 1943,
 -1,
 905586384,
 1924,
 905786880,
 902271474,
 -1,
 -51714,
 905745044,
 1963,
 -51713,
 905784018,
 1966,
 -1,
 905844353,
 1967,
 906049028,
 905724071,
 -1,
 -51710,
 906028413,
 1965,
 -51709,
 906052130,
 1961,
 -1,
 906111056,
 1964,
 906311175,
 905975182,
 -1,
 -51706,
 906241791,
 1958,
 -1,
 906303040,
 1959,
 -51704,
 906285188,
 1962,
 -51703,
 906478162,
 1968,
 -1,
 906519361,
 1960,
 906704411,
 893758685,
 -1,
 906769942,
 906625024,
 -1,
 906835473,
 906720196,
 -1,
 906901008,
 906782967,
 -1,
 -51697,
 906866414,
 9886,
 -1,
 906917617,
 9887,
 -1,
 906839140,
 11057,
 907163156,
 906769964,
 -1,
 -51693,
 907123441,
 8278,
 -1,
 907175699,
 10176,
 -51691,
 907129188,
 8694,
 -1,
 907293350,
 10870,
 907542527,
 906694374,
 -1,
 907556378,
 907425326,
 -1,
 -51687,
 907528937,
 10146,
 -1,
 907553602,
 10147,
 -1,
 907518683,
 8196,
 907818530,
 906643839,
 -1,
 907884065,
 907755687,
 -1,
 907949600,
 907804672,
 -1,
 -51681,
 907890104,
 8707,
 -1,
 907950819,
 8708,
 -1,
 907891152,
 8756,
 -1,
 907839233,
 10727,
 908277285,
 907793126,
 -1,
 -51676,
 908247403,
 9736,
 -1,
 908264115,
 9928,
 -1,
 908224477,
 8201,
 908539474,
 893692374,
 -1,
 908605006,
 908485095,
 -1,
 908670523,
 908567694,
 -1,
 908736046,
 908647207,
 -1,
 -51669,
 908714245,
 10997,
 -51668,
 908767436,
 8874,
 -51667,
 908801928,
 10624,
 -1,
 908863881,
 10996,
 909063729,
 908697707,
 -1,
 -51664,
 909029932,
 8244,
 -1,
 909082568,
 10747,
 909260340,
 909020163,
 -1,
 -51661,
 909212087,
 10999,
 -1,
 909268831,
 11000,
 909456951,
 909205327,
 -1,
 -51658,
 909429824,
 10857,
 -1,
 909458901,
 10856,
 -51656,
 909428896,
 8779,
 -51655,
 909623102,
 11003,
 -51654,
 909666859,
 8749,
 -1,
 909718046,
 10998,
 909915717,
 908613362,
 -1,
 909981247,
 909893082,
 -1,
 -51650,
 909928519,
 9780,
 -1,
 909976783,
 9781,
 -51648,
 909953106,
 9779,
 -51647,
 910133174,
 9782,
 -51646,
 910193945,
 9777,
 -51645,
 910253031,
 9776,
 -51644,
 910315737,
 9778,
 -1,
 910377348,
 9783,
 910571085,
 909844101,
 -1,
 910636620,
 910522046,
 -1,
 910702155,
 910560310,
 -1,
 -51639,
 910676731,
 10699,
 -51638,
 910735949,
 10701,
 -1,
 910768957,
 10698,
 -1,
 910626799,
 10141,
 -1,
 910610790,
 8227,
 -1,
 910504472,
 8285,
 911160913,
 908531086,
 -1,
 -51632,
 911118192,
 10971,
 -1,
 911161177,
 8482,
 -1,
 911134898,
 8872,
 911423096,
 908497394,
 -1,
 911488615,
 911384685,
 -1,
 911554137,
 911453940,
 -1,
 911619672,
 911486211,
 -1,
 -51625,
 911586549,
 8974,
 -1,
 911645166,
 8989,
 -1,
 911563281,
 11811,
 911881822,
 911505142,
 -1,
 911947357,
 911813891,
 -1,
 -51620,
 911914229,
 8975,
 -1,
 911972846,
 8988,
 -1,
 911890961,
 11810,
 912209506,
 911810886,
 -1,
 912275041,
 912138136,
 10554,
 -1,
 912199192,
 10557,
 -1,
 912208287,
 10556,
 -51613,
 912182033,
 9184,
 -51612,
 912441339,
 9140,
 -51611,
 912499112,
 9180,
 -51610,
 912546350,
 8992,
 -1,
 912602550,
 9182,
 912799351,
 911455967,
 -1,
 912864886,
 912732461,
 -1,
 912930413,
 912790683,
 -1,
 -51605,
 912856352,
 127552,
 -51604,
 912921739,
 127560,
 -1,
 912986965,
 127557,
 913192560,
 912856288,
 -1,
 -51601,
 913118428,
 127558,
 -1,
 913183269,
 127556,
 913389171,
 913118243,
 -1,
 -51598,
 913319625,
 127555,
 -1,
 913380191,
 127559,
 913637375,
 913314848,
 -1,
 -51595,
 913511764,
 127554,
 -1,
 913576482,
 127553,
 -1,
 912815692,
 127274,
 -1,
 912770140,
 9008,
 913913481,
 911396590,
 -1,
 913979016,
 913880138,
 -1,
 914044544,
 913946544,
 -1,
 914110079,
 913973050,
 -1,
 -51587,
 914089152,
 8516,
 -51586,
 914125764,
 8514,
 -1,
 914182955,
 8513,
 -1,
 914063836,
 8526,
 914437763,
 913970574,
 -1,
 -51582,
 914394210,
 10658,
 -1,
 914458580,
 8523,
 -51580,
 914415555,
 9929,
 -51579,
 914591468,
 8985,
 -51578,
 914642977,
 8489,
 -51577,
 914697749,
 8498,
 -1,
 914762330,
 9930,
 -1,
 913922118,
 8366,
 915079167,
 913890778,
 -1,
 915093145,
 914985460,
 -1,
 915158672,
 915028788,
 -1,
 915224207,
 915079168,
 -1,
 -51570,
 915187569,
 8282,
 -1,
 915240667,
 8229,
 -1,
 915191807,
 11818,
 915486355,
 915111248,
 -1,
 -51566,
 915445988,
 10760,
 -1,
 915480094,
 10759,
 915682966,
 915434118,
 -1,
 -51563,
 915642488,
 10838,
 -1,
 915676556,
 10837,
 -51561,
 915632267,
 10697,
 -51560,
 915813030,
 10869,
 -1,
 915874866,
 8273,
 -1,
 915031634,
 10041,
 916143737,
 792663438,
 -1,
 916208954,
 916105686,
 -1,
 916274357,
 916133485,
 -1,
 916339873,
 916193280,
 -1,
 916405287,
 916288452,
 -1,
 916470183,
 916350215,
 -1,
 916535096,
 916436912,
 -1,
 916600548,
 916478195,
 -1,
 916666069,
 916538224,
 -1,
 916731570,
 916609267,
 -1,
 916797103,
 916658463,
 -1,
 916862634,
 916774980,
 -1,
 916928169,
 916816879,
 -1,
 -51544,
 916875725,
 64872,
 -1,
 916934785,
 64871,
 -1,
 916907447,
 64938,
 917190317,
 916808167,
 -1,
 -51540,
 917159721,
 64778,
 -1,
 917212536,
 64814,
 -51538,
 917144527,
 64824,
 -1,
 917328001,
 64806,
 917569535,
 916735220,
 -1,
 -51535,
 917472207,
 64746,
 -1,
 917531085,
 64818,
 917714623,
 916685807,
 -1,
 917780154,
 917692484,
 -1,
 917845687,
 917734383,
 -1,
 -51530,
 917793229,
 64877,
 -1,
 917852289,
 64876,
 918093823,
 917795443,
 -1,
 -51527,
 917989837,
 64875,
 -1,
 918048897,
 64874,
 918238909,
 917725671,
 -1,
 -51524,
 918208297,
 64780,
 -1,
 918261112,
 64816,
 -51522,
 918193103,
 64745,
 -1,
 918376577,
 64808,
 918566598,
 917663734,
 -1,
 918632131,
 918512103,
 -1,
 -51518,
 918601513,
 64777,
 -1,
 918654328,
 64813,
 -51516,
 918610438,
 64873,
 -51515,
 918782927,
 64823,
 -1,
 918835329,
 64805,
 919025356,
 918516339,
 -1,
 919090890,
 918970855,
 -1,
 -51511,
 919060265,
 64779,
 -1,
 919113080,
 64815,
 -51509,
 919045071,
 64825,
 -1,
 919228545,
 64807,
 919418575,
 919004584,
 -1,
 -51506,
 919367098,
 64766,
 -1,
 919425153,
 64794,
 919615186,
 919383353,
 -1,
 -51503,
 919563706,
 64781,
 -1,
 919621761,
 64809,
 919863295,
 919542508,
 -1,
 -51500,
 919760314,
 64765,
 -1,
 919818369,
 64793,
 920059903,
 916592662,
 -1,
 920073947,
 919957930,
 -1,
 920139482,
 919994368,
 -1,
 -51495,
 920093647,
 64756,
 -1,
 920153530,
 64610,
 -1,
 920110248,
 64607,
 920401632,
 920008432,
 -1,
 920467167,
 920322048,
 -1,
 -51490,
 920421327,
 64755,
 -1,
 920481210,
 64609,
 -1,
 920437928,
 64606,
 920729315,
 920342367,
 -1,
 -51486,
 920683471,
 64754,
 -1,
 920743354,
 64608,
 -1,
 920699527,
 64611,
 920991509,
 916538224,
 -1,
 921057010,
 920945647,
 -1,
 921122542,
 921034820,
 -1,
 921188074,
 921076719,
 -1,
 -51479,
 921135565,
 64867,
 -1,
 921194625,
 64866,
 921384685,
 921131403,
 -1,
 -51476,
 921332173,
 64864,
 -1,
 921391233,
 64863,
 -1,
 921333763,
 64865,
 921646833,
 921068007,
 -1,
 -51472,
 921616169,
 64543,
 -1,
 921668984,
 64688,
 -1,
 921600975,
 64743,
 921908988,
 921000179,
 -1,
 921974521,
 921835807,
 -1,
 922040055,
 921919975,
 -1,
 -51466,
 922009385,
 64541,
 -1,
 922062200,
 64686,
 -51464,
 922018090,
 64860,
 -1,
 922190799,
 64821,
 922419199,
 921912564,
 -1,
 -51461,
 922321871,
 64744,
 -1,
 922380749,
 64817,
 922564356,
 921858675,
 -1,
 922629888,
 922542148,
 -1,
 -51457,
 922609079,
 64966,
 -1,
 922622714,
 64936,
 922826499,
 922575335,
 -1,
 -51454,
 922795817,
 64542,
 -1,
 922848632,
 64687,
 -1,
 922780623,
 64822,
 923088652,
 922513398,
 -1,
 923154184,
 923066436,
 -1,
 -51449,
 923097494,
 64861,
 -1,
 923147002,
 64862,
 923350795,
 923099623,
 -1,
 -51446,
 923320105,
 64540,
 -1,
 923372920,
 64685,
 -1,
 923304911,
 64820,
 923612943,
 923067816,
 -1,
 -51442,
 923561402,
 64764,
 -1,
 923619457,
 64792,
 923809554,
 923577657,
 -1,
 -51439,
 923758010,
 64782,
 -1,
 923816065,
 64810,
 924057599,
 923736812,
 -1,
 -51436,
 923954618,
 64763,
 -1,
 924012673,
 64791,
 924254207,
 920917390,
 -1,
 924268337,
 924137081,
 -1,
 924333856,
 924211595,
 -1,
 924399389,
 924311620,
 -1,
 924464924,
 924342667,
 -1,
 -51429,
 924412365,
 64869,
 -1,
 924471425,
 64868,
 -1,
 924444087,
 64937,
 924778495,
 924344807,
 -1,
 -51425,
 924696361,
 64544,
 -1,
 924749176,
 64689,
 924923687,
 924287983,
 -1,
 924989220,
 924901697,
 -1,
 -51421,
 924936653,
 64965,
 -1,
 924995713,
 64870,
 925237247,
 924934631,
 -1,
 -51418,
 925155113,
 64545,
 -1,
 925207928,
 64691,
 925382442,
 924902824,
 -1,
 -51415,
 925330874,
 64774,
 -1,
 925388929,
 64802,
 925579053,
 925347129,
 -1,
 -51412,
 925527482,
 64783,
 -1,
 925585537,
 64811,
 925775664,
 925506284,
 -1,
 -51409,
 925724090,
 64773,
 -1,
 925782145,
 64801,
 -1,
 925725312,
 64690,
 926089215,
 924218308,
 -1,
 926103351,
 925987865,
 -1,
 926168886,
 926023680,
 -1,
 -51403,
 926144303,
 65008,
 -1,
 926182842,
 65017,
 -1,
 926121119,
 65018,
 -1,
 926030999,
 65013,
 926496661,
 916505464,
 -1,
 926562156,
 926434568,
 -1,
 926627654,
 926516207,
 -1,
 926693185,
 926605380,
 -1,
 -51395,
 926672311,
 64931,
 -51394,
 926708352,
 64855,
 -51393,
 926773251,
 64853,
 -51392,
 926833046,
 64854,
 -1,
 926882554,
 64932,
 927086404,
 926638567,
 -1,
 -51389,
 927055657,
 64526,
 -1,
 927108472,
 64676,
 -51387,
 927040463,
 64739,
 -1,
 927223937,
 64626,
 927414099,
 926570739,
 -1,
 927479632,
 927340831,
 -1,
 927545165,
 927457348,
 -1,
 927610700,
 927494134,
 -1,
 -51381,
 927558093,
 64850,
 -1,
 927617153,
 64849,
 -1,
 927564812,
 64851,
 927924223,
 927490535,
 -1,
 -51377,
 927842089,
 64524,
 -1,
 927894904,
 64674,
 928120831,
 927417588,
 -1,
 -51374,
 928023503,
 64740,
 -1,
 928082381,
 64677,
 928266075,
 927363699,
 -1,
 928331608,
 928243780,
 -1,
 -51370,
 928310711,
 64929,
 -51369,
 928351244,
 64852,
 -1,
 928389882,
 64930,
 928645119,
 928276967,
 -1,
 -51366,
 928562985,
 64525,
 -1,
 928615800,
 64675,
 928790371,
 928215030,
 -1,
 928855904,
 928768068,
 -1,
 -51362,
 928834999,
 64927,
 -51361,
 928875532,
 64848,
 -1,
 928914170,
 64928,
 929169407,
 928801255,
 -1,
 -51358,
 929087273,
 64523,
 -1,
 929140088,
 64673,
 929314662,
 928769448,
 -1,
 -51355,
 929263034,
 64528,
 -1,
 929321089,
 64629,
 929511273,
 929241836,
 -1,
 -51352,
 929459642,
 64527,
 -1,
 929517697,
 64628,
 -51350,
 929490981,
 64625,
 -51349,
 929672510,
 64624,
 -1,
 929730081,
 64627,
 929904512,
 926505203,
 -1,
 929970047,
 929842440,
 -1,
 930035572,
 929924079,
 -1,
 930101106,
 929980903,
 -1,
 -51343,
 930070313,
 64530,
 -1,
 930123128,
 64678,
 -51341,
 930055119,
 64741,
 -1,
 930238593,
 64632,
 930428791,
 930014632,
 -1,
 -51338,
 930377146,
 64532,
 -1,
 930435201,
 64635,
 930625402,
 930355948,
 -1,
 -51335,
 930573754,
 64531,
 -1,
 930631809,
 64634,
 -51333,
 930605093,
 64631,
 -51332,
 930786622,
 64630,
 -51331,
 930844193,
 64633,
 -51330,
 930902037,
 64529,
 -1,
 930962546,
 64742,
 -1,
 929897040,
 64603,
 931266559,
 929831208,
 -1,
 931280780,
 931169263,
 -1,
 931346312,
 931258436,
 -1,
 931411846,
 931289483,
 -1,
 -51323,
 931359181,
 64882,
 -1,
 931418241,
 64881,
 -51321,
 931390903,
 64884,
 -1,
 931562508,
 64883,
 931739531,
 931291623,
 -1,
 -51318,
 931708713,
 64551,
 -1,
 931761528,
 64819,
 -1,
 931693519,
 64826,
 932001679,
 931259816,
 -1,
 -51314,
 931950010,
 64758,
 -1,
 932008065,
 64786,
 932198290,
 931944848,
 -1,
 -51311,
 932167465,
 64550,
 -1,
 932220280,
 64696,
 932446207,
 932125420,
 -1,
 -51308,
 932343226,
 64757,
 -1,
 932401281,
 64785,
 932591600,
 926475736,
 -1,
 932657108,
 932534515,
 -1,
 932722641,
 932582798,
 -1,
 932788172,
 932677938,
 -1,
 932853667,
 932713870,
 -1,
 932919200,
 932804332,
 -1,
 932984734,
 932872446,
 -1,
 -51299,
 932933050,
 64515,
 -1,
 932991105,
 64616,
 -51297,
 932933050,
 64490,
 -1,
 933122177,
 64491,
 933363711,
 932855977,
 -1,
 -51294,
 933260730,
 64492,
 -1,
 933318785,
 64493,
 933509034,
 932832448,
 -1,
 933574567,
 933482224,
 -1,
 -51290,
 933522874,
 64500,
 -1,
 933580929,
 64501,
 933822463,
 933512436,
 -1,
 -51287,
 933719482,
 64516,
 -1,
 933777537,
 64617,
 933967792,
 933463023,
 -1,
 934033326,
 933913063,
 -1,
 -51283,
 934002473,
 64514,
 -1,
 934055288,
 64666,
 -51281,
 933987279,
 64735,
 -1,
 934170753,
 64614,
 934361015,
 933910771,
 -1,
 934426548,
 934298868,
 -1,
 -51277,
 934380495,
 64736,
 -1,
 934439373,
 64667,
 934674431,
 934353187,
 -1,
 -51274,
 934592297,
 64513,
 -1,
 934645112,
 64664,
 934819772,
 934297769,
 -1,
 934885307,
 934765031,
 -1,
 -51270,
 934854441,
 64502,
 -1,
 934907256,
 64504,
 -1,
 934826113,
 64503,
 935147455,
 934797061,
 -1,
 -51266,
 935095738,
 64494,
 -1,
 935153793,
 64495,
 935344066,
 935120624,
 -1,
 -51263,
 935292346,
 64496,
 -1,
 935350401,
 64497,
 935540677,
 935301947,
 -1,
 -51260,
 935488954,
 64498,
 -1,
 935547009,
 64499,
 935737288,
 935489532,
 -1,
 -51257,
 935706409,
 64512,
 -1,
 935759224,
 64663,
 -51255,
 935716901,
 64613,
 -51254,
 935898430,
 64612,
 -51253,
 935956001,
 64615,
 -1,
 936014464,
 64665,
 936247295,
 932731125,
 -1,
 936261584,
 936141287,
 -1,
 -51249,
 936230697,
 64598,
 -1,
 936283512,
 64731,
 -1,
 936239622,
 64942,
 936574975,
 932660468,
 -1,
 -51245,
 936477647,
 64753,
 -1,
 936536525,
 64734,
 936720351,
 932611055,
 -1,
 936785882,
 936697924,
 -1,
 936851417,
 936739823,
 -1,
 -51240,
 936798669,
 64925,
 -1,
 936857729,
 64924,
 -1,
 936830391,
 64944,
 937113565,
 936731111,
 -1,
 -51236,
 937082665,
 64600,
 -1,
 937135480,
 64733,
 -51234,
 937067471,
 64752,
 -1,
 937250945,
 64659,
 937441252,
 936669174,
 -1,
 937506787,
 937386471,
 -1,
 -51230,
 937475881,
 64597,
 -1,
 937528696,
 64730,
 -1,
 937484806,
 64943,
 937768935,
 937420200,
 -1,
 -51226,
 937717178,
 64602,
 -1,
 937775233,
 64662,
 937965546,
 937718393,
 -1,
 -51223,
 937934633,
 64599,
 -1,
 937987448,
 64732,
 938162157,
 937892588,
 -1,
 -51220,
 938110394,
 64601,
 -1,
 938168449,
 64661,
 -51218,
 938141733,
 64658,
 -51217,
 938323262,
 64657,
 -1,
 938380833,
 64660,
 938555439,
 932541739,
 -1,
 938620930,
 938482395,
 -1,
 938686461,
 938598468,
 -1,
 938751994,
 938629742,
 -1,
 938817527,
 938682494,
 -1,
 -51210,
 938765754,
 65273,
 -1,
 938823809,
 65274,
 939065343,
 938743445,
 -1,
 -51207,
 938962362,
 65271,
 -1,
 939020417,
 65272,
 939261951,
 938705079,
 -1,
 -51204,
 939158970,
 65269,
 -1,
 939217025,
 65270,
 939407360,
 938639614,
 -1,
 -51201,
 939355578,
 64579,
 -1,
 939413633,
 64646,
 -51199,
 939355578,
 65275,
 -1,
 939544705,
 65276,
 939735053,
 938574831,
 -1,
 939800584,
 939712580,
 -1,
 939866119,
 939743627,
 -1,
 -51194,
 939813325,
 64904,
 -1,
 939872385,
 64903,
 -1,
 939845047,
 64941,
 940128267,
 939745767,
 -1,
 -51190,
 940097321,
 64578,
 -1,
 940150136,
 64716,
 -51188,
 940082127,
 64749,
 -1,
 940265601,
 64645,
 940455961,
 939683830,
 -1,
 940521494,
 940433476,
 -1,
 940587026,
 940475375,
 -1,
 -51183,
 940534221,
 64954,
 -1,
 940593281,
 64956,
 940783637,
 940535798,
 -1,
 -51180,
 940730829,
 64899,
 -1,
 940789889,
 64900,
 -1,
 940762551,
 64940,
 941096959,
 940466663,
 -1,
 -51176,
 941014825,
 64575,
 -1,
 941067640,
 64713,
 941242405,
 940398835,
 -1,
 941307940,
 941168927,
 -1,
 941373473,
 941285444,
 -1,
 941439007,
 941327343,
 -1,
 -51170,
 941386189,
 64949,
 -1,
 941445249,
 64896,
 -51168,
 941417911,
 64897,
 -1,
 941562618,
 64898,
 941817855,
 941318631,
 -1,
 -51165,
 941735721,
 64576,
 -1,
 941788536,
 64714,
 -1,
 941245688,
 64717,
 942028844,
 941191795,
 -1,
 942094377,
 942006593,
 -1,
 -51160,
 942041549,
 64902,
 -1,
 942100609,
 64901,
 942342143,
 942039527,
 -1,
 -51157,
 942260009,
 64577,
 -1,
 942312824,
 64715,
 942538751,
 942007720,
 -1,
 -51154,
 942435770,
 64580,
 -1,
 942493825,
 64647,
 942684258,
 938504438,
 -1,
 942749780,
 942610607,
 -1,
 942815292,
 942703599,
 -1,
 942880823,
 942792772,
 -1,
 942946358,
 942834671,
 -1,
 -51147,
 942893517,
 64963,
 -1,
 942952577,
 64955,
 -1,
 942925239,
 64951,
 943208506,
 942825959,
 -1,
 -51143,
 943177513,
 64572,
 -1,
 943230328,
 64712,
 -51141,
 943162319,
 64748,
 -1,
 943345793,
 64642,
 943536194,
 942765350,
 -1,
 943601728,
 943481319,
 -1,
 -51137,
 943570729,
 64571,
 -1,
 943623544,
 64711,
 -51135,
 943555535,
 64747,
 -1,
 943739009,
 64641,
 943929416,
 943463131,
 -1,
 943994950,
 943882494,
 -1,
 -51131,
 943943098,
 64573,
 -1,
 944001153,
 64643,
 -51129,
 943943098,
 64567,
 -1,
 944132225,
 64640,
 944322635,
 943908264,
 -1,
 -51126,
 944270778,
 64574,
 -1,
 944328833,
 64644,
 944519246,
 944271993,
 -1,
 -51123,
 944488233,
 64570,
 -1,
 944541048,
 64710,
 944715857,
 944467964,
 -1,
 -51120,
 944684841,
 64568,
 -1,
 944737656,
 64708,
 944963583,
 944658832,
 -1,
 -51117,
 944881449,
 64569,
 -1,
 944934264,
 64709,
 945160191,
 942692793,
 -1,
 945174616,
 945087912,
 -1,
 -51113,
 945122746,
 64772,
 -1,
 945180801,
 64800,
 945371227,
 945128453,
 -1,
 -51110,
 945340201,
 64539,
 -1,
 945393016,
 64684,
 945567838,
 945319932,
 -1,
 -51107,
 945536809,
 64537,
 -1,
 945589624,
 64683,
 945764449,
 945494764,
 -1,
 -51104,
 945712570,
 64771,
 -1,
 945770625,
 64799,
 -1,
 945707431,
 64538,
 946026641,
 942640689,
 -1,
 946092144,
 945975286,
 -1,
 946157677,
 946069572,
 -1,
 946223208,
 946111471,
 -1,
 -51097,
 946170317,
 64920,
 -1,
 946229377,
 64919,
 946419819,
 946166155,
 -1,
 -51094,
 946366925,
 64952,
 -1,
 946425985,
 64957,
 -51092,
 946398647,
 64967,
 -1,
 946543354,
 64921,
 946798591,
 946102759,
 -1,
 -51089,
 946716457,
 64587,
 -1,
 946769272,
 64722,
 946944124,
 946034931,
 -1,
 947009657,
 946870559,
 -1,
 947075190,
 946987076,
 -1,
 -51084,
 947054007,
 64947,
 -51083,
 947094540,
 64917,
 -1,
 947133178,
 64918,
 947388415,
 947020263,
 -1,
 -51080,
 947306281,
 64588,
 -1,
 947359096,
 64723,
 947585023,
 946947316,
 -1,
 -51077,
 947487695,
 64751,
 -1,
 947546573,
 64726,
 947730565,
 946897903,
 -1,
 947796096,
 947707972,
 -1,
 -51073,
 947774903,
 64922,
 -1,
 947788538,
 64923,
 947992707,
 947741159,
 -1,
 -51070,
 947961641,
 64590,
 -1,
 948014456,
 64725,
 -51068,
 947946447,
 64750,
 -1,
 948129921,
 64652,
 948320392,
 947709352,
 -1,
 -51065,
 948268474,
 64592,
 -1,
 948326529,
 64655,
 948517003,
 948269689,
 -1,
 -51062,
 948485929,
 64589,
 -1,
 948538744,
 64724,
 948713614,
 948443884,
 -1,
 -51059,
 948661690,
 64591,
 -1,
 948719745,
 64654,
 -51057,
 948693029,
 64651,
 -51056,
 948874558,
 64650,
 -1,
 948932129,
 64653,
 949106871,
 945979464,
 -1,
 949172406,
 949044066,
 -1,
 949237916,
 949121014,
 -1,
 949303449,
 949215300,
 -1,
 -51050,
 949282231,
 64960,
 -51049,
 949322764,
 64909,
 -51048,
 949383808,
 64914,
 -1,
 949442966,
 64908,
 949682175,
 949248487,
 -1,
 -51045,
 949600041,
 64581,
 -1,
 949652856,
 64718,
 949827748,
 949187187,
 -1,
 949893281,
 949805124,
 -1,
 -51041,
 949872055,
 64953,
 -51040,
 949912588,
 64911,
 -1,
 949972995,
 64910,
 950206463,
 949838311,
 -1,
 -51037,
 950124329,
 64583,
 -1,
 950177144,
 64720,
 950352044,
 949770635,
 -1,
 950417577,
 950329412,
 -1,
 -51033,
 950396343,
 64907,
 -51032,
 950436876,
 64906,
 -1,
 950497283,
 64905,
 950730751,
 950362599,
 -1,
 -51029,
 950648617,
 64582,
 -1,
 950701432,
 64719,
 950876338,
 950305775,
 -1,
 950941872,
 950821351,
 -1,
 -51025,
 950910761,
 64584,
 -1,
 950963576,
 64721,
 -51023,
 950919686,
 64945,
 -1,
 951079041,
 64649,
 951269557,
 950803163,
 -1,
 -51020,
 951222535,
 64585,
 -1,
 951275649,
 64648,
 -1,
 951248326,
 64586,
 -1,
 949130185,
 65012,
 951597274,
 949036699,
 -1,
 951662809,
 951534856,
 -1,
 951728322,
 951605491,
 -1,
 951793855,
 951654687,
 -1,
 951859390,
 951738855,
 -1,
 -51011,
 951828265,
 64518,
 -1,
 951881080,
 64669,
 -1,
 951837190,
 64962,
 952172543,
 951731444,
 -1,
 -51007,
 952075215,
 64738,
 -1,
 952134093,
 64672,
 952318152,
 951682031,
 -1,
 952383686,
 952263143,
 -1,
 -51003,
 952352553,
 64520,
 -1,
 952405368,
 64671,
 -51001,
 952337359,
 64737,
 -1,
 952520833,
 64620,
 952711373,
 952267379,
 -1,
 952776908,
 952656359,
 -1,
 -50997,
 952745769,
 64519,
 -1,
 952798584,
 64670,
 -1,
 952754694,
 64926,
 953039056,
 952690088,
 -1,
 -50993,
 952987066,
 64522,
 -1,
 953045121,
 64623,
 953235667,
 952987644,
 -1,
 -50990,
 953204521,
 64517,
 -1,
 953257336,
 64668,
 953432278,
 953162476,
 -1,
 -50987,
 953380282,
 64521,
 -1,
 953438337,
 64622,
 -50985,
 953411621,
 64619,
 -50984,
 953593150,
 64618,
 -1,
 953650721,
 64621,
 -1,
 951610781,
 65021,
 953891070,
 951522702,
 -1,
 953956595,
 953837596,
 -1,
 954022118,
 953910255,
 -1,
 954087651,
 953999428,
 -1,
 954153185,
 954041327,
 -1,
 -50976,
 954100173,
 64887,
 -1,
 954159233,
 64886,
 -50974,
 954131895,
 64950,
 -1,
 954276602,
 64888,
 954531839,
 954032615,
 -1,
 -50971,
 954449705,
 64554,
 -1,
 954502520,
 64699,
 954677485,
 953970678,
 -1,
 954743018,
 954655041,
 -1,
 -50967,
 954689997,
 64964,
 -1,
 954749057,
 64885,
 954990591,
 954687975,
 -1,
 -50964,
 954908457,
 64553,
 -1,
 954961272,
 64698,
 955136240,
 954656168,
 -1,
 -50961,
 955084218,
 64760,
 -1,
 955142273,
 64788,
 955383807,
 955063020,
 -1,
 -50958,
 955280826,
 64759,
 -1,
 955338881,
 64787,
 955529469,
 953906116,
 -1,
 955595003,
 955466661,
 -1,
 955660536,
 955572422,
 -1,
 -50953,
 955608506,
 64829,
 -1,
 955666561,
 64828,
 955908095,
 955613469,
 -1,
 -50950,
 955805114,
 64605,
 -1,
 955863169,
 64656,
 -50948,
 955544835,
 65010,
 -1,
 955983487,
 65015,
 -1,
 955478540,
 65011,
 956250400,
 953833715,
 -1,
 956315922,
 956176680,
 -1,
 956381447,
 956269551,
 -1,
 956446980,
 956358724,
 -1,
 -50941,
 956425655,
 64858,
 -1,
 956439290,
 64859,
 956694527,
 956391911,
 -1,
 -50938,
 956612393,
 64536,
 -1,
 956665208,
 64682,
 956840204,
 956329974,
 -1,
 956905739,
 956785127,
 -1,
 -50934,
 956874537,
 64535,
 -1,
 956927352,
 64681,
 -1,
 956883462,
 64959,
 957167887,
 956818856,
 -1,
 -50930,
 957115834,
 64768,
 -1,
 957173889,
 64796,
 957415423,
 957094636,
 -1,
 -50927,
 957312442,
 64767,
 -1,
 957370497,
 64795,
 957612031,
 956253448,
 -1,
 957626650,
 957514735,
 -1,
 957692183,
 957603908,
 -1,
 -50922,
 957645836,
 64916,
 -1,
 957706243,
 64915,
 957939711,
 957637095,
 -1,
 -50919,
 957857577,
 64594,
 -1,
 957910392,
 64728,
 958085405,
 957575164,
 -1,
 -50916,
 958054185,
 64593,
 -1,
 958107000,
 64727,
 -50914,
 958064070,
 64596,
 -50913,
 958251625,
 64729,
 -1,
 958274322,
 64595,
 958478654,
 956184237,
 -1,
 958544168,
 958427763,
 -1,
 958609701,
 958521665,
 -1,
 -50908,
 958556621,
 64880,
 -1,
 958615681,
 64879,
 958857215,
 958554599,
 -1,
 -50905,
 958775081,
 64548,
 -1,
 958827896,
 64694,
 959002927,
 958486923,
 -1,
 959068460,
 958980164,
 -1,
 -50901,
 959047095,
 64939,
 -1,
 959060730,
 64878,
 959315967,
 959013351,
 -1,
 -50898,
 959233833,
 64547,
 -1,
 959286648,
 64693,
 959461682,
 958981544,
 -1,
 -50895,
 959409594,
 64776,
 -1,
 959467649,
 64804,
 959658293,
 959425849,
 -1,
 -50892,
 959606202,
 64784,
 -1,
 959664257,
 64812,
 959854904,
 959611909,
 -1,
 -50889,
 959823657,
 64549,
 -1,
 959876472,
 64695,
 960051515,
 959803388,
 -1,
 -50886,
 960020265,
 64546,
 -1,
 960073080,
 64692,
 960299007,
 959978220,
 -1,
 -50883,
 960196026,
 64775,
 -1,
 960254081,
 64803,
 960444760,
 958427031,
 -1,
 960510295,
 960381794,
 -1,
 960575818,
 960463855,
 -1,
 960641351,
 960553028,
 -1,
 960706885,
 960584075,
 -1,
 -50876,
 960653773,
 64857,
 -1,
 960712833,
 64856,
 -50874,
 960685495,
 64933,
 -1,
 960830202,
 64935,
 961085439,
 960586215,
 -1,
 -50871,
 961003305,
 64534,
 -1,
 961056120,
 64680,
 961231185,
 960518539,
 -1,
 961296718,
 961208388,
 -1,
 -50867,
 961275319,
 64958,
 -1,
 961288954,
 64934,
 961544191,
 961241575,
 -1,
 -50864,
 961462057,
 64533,
 -1,
 961514872,
 64679,
 961689940,
 961209768,
 -1,
 -50861,
 961637818,
 64770,
 -1,
 961695873,
 64798,
 961937407,
 961616620,
 -1,
 -50858,
 961834426,
 64769,
 -1,
 961892481,
 64797,
 -1,
 960437243,
 65019,
 962148721,
 960384954,
 -1,
 962214240,
 962097779,
 -1,
 962279773,
 962191681,
 -1,
 -50852,
 962226637,
 64893,
 -1,
 962285697,
 64892,
 962527231,
 962224615,
 -1,
 -50849,
 962445097,
 64559,
 -1,
 962497912,
 64704,
 962672997,
 962167791,
 -1,
 962738532,
 962617831,
 -1,
 -50845,
 962707241,
 64560,
 -1,
 962760056,
 64705,
 -1,
 962716166,
 64961,
 963000680,
 962651560,
 -1,
 -50841,
 962948538,
 64562,
 -1,
 963006593,
 64637,
 963197291,
 962949116,
 -1,
 -50838,
 963165993,
 64557,
 -1,
 963218808,
 64702,
 963393902,
 963139984,
 -1,
 -50835,
 963362601,
 64558,
 -1,
 963415416,
 64703,
 963641343,
 963320556,
 -1,
 -50832,
 963538362,
 64561,
 -1,
 963596417,
 64636,
 963787143,
 962111436,
 -1,
 963852678,
 963727089,
 -1,
 963918205,
 963806191,
 -1,
 963983738,
 963895364,
 -1,
 964049272,
 963926411,
 -1,
 -50825,
 963996109,
 64948,
 -1,
 964055169,
 64894,
 -50823,
 964027831,
 64946,
 -1,
 964199413,
 64895,
 964427775,
 963928551,
 -1,
 -50820,
 964345641,
 64564,
 -1,
 964398456,
 64707,
 964573568,
 963896744,
 -1,
 -50817,
 964521402,
 64566,
 -1,
 964579457,
 64639,
 964770179,
 964516240,
 -1,
 -50814,
 964738857,
 64563,
 -1,
 964791672,
 64706,
 965017599,
 964696812,
 -1,
 -50811,
 964914618,
 64565,
 -1,
 964972673,
 64638,
 -1,
 963802149,
 65009,
 965228953,
 963728669,
 -1,
 965294480,
 965182447,
 -1,
 965360013,
 965271620,
 -1,
 -50805,
 965338551,
 64890,
 -50804,
 965379061,
 64889,
 -1,
 965417722,
 64891,
 965672959,
 965304807,
 -1,
 -50801,
 965590825,
 64556,
 -1,
 965643640,
 64701,
 965818771,
 965273000,
 -1,
 -50798,
 965766586,
 64762,
 -1,
 965824641,
 64790,
 966015382,
 965767164,
 -1,
 -50795,
 965984041,
 64555,
 -1,
 966036856,
 64700,
 966262783,
 965941996,
 -1,
 -50792,
 966159802,
 64761,
 -1,
 966217857,
 64789,
 966408606,
 965208077,
 -1,
 966474141,
 966353383,
 -1,
 -50788,
 966442793,
 64552,
 -1,
 966495608,
 64697,
 -1,
 966427599,
 64827,
 966736291,
 966381821,
 -1,
 966801826,
 966681063,
 -1,
 -50783,
 966770473,
 64505,
 -1,
 966823288,
 64507,
 -1,
 966742145,
 64506,
 967063974,
 966699478,
 -1,
 -50779,
 967001361,
 64604,
 -1,
 967058420,
 65014,
 -1,
 967040672,
 65016,
 967376895,
 916409440,
 -1,
 967391729,
 967295864,
 -1,
 967457216,
 967329009,
 1578,
 967522745,
 967376896,
 -1,
 967588274,
 967475272,
 -1,
 967653809,
 967516475,
 1577,
 967770111,
 967573504,
 -1,
 -50769,
 967667130,
 65171,
 -50768,
 967726735,
 1731,
 -1,
 967790721,
 65172,
 -1,
 967590696,
 65176,
 968047029,
 967565380,
 -1,
 -50764,
 968017927,
 1661,
 -1,
 968077878,
 1660,
 968243640,
 967991783,
 -1,
 -50761,
 968212265,
 65173,
 -1,
 968265080,
 65175,
 -1,
 968183937,
 65174,
 968556543,
 967460081,
 1663,
 968622079,
 968425472,
 -1,
 968636862,
 968516071,
 -1,
 -50755,
 968605481,
 64354,
 -1,
 968658296,
 64356,
 -50753,
 968590287,
 64357,
 -1,
 968773761,
 64355,
 968964559,
 967389105,
 1670,
 969030088,
 968901873,
 1671,
 969146367,
 968949760,
 -1,
 969161158,
 969040359,
 -1,
 -50747,
 969129769,
 64382,
 -1,
 969182584,
 64384,
 -50745,
 969114575,
 64385,
 -1,
 969298049,
 64383,
 969539583,
 968949760,
 -1,
 969554380,
 969433575,
 -1,
 -50741,
 969522985,
 64378,
 -1,
 969575800,
 64380,
 -50739,
 969531544,
 1727,
 -50738,
 969704399,
 64381,
 -1,
 969756801,
 64379,
 969947613,
 968934815,
 1657,
 970013143,
 969884913,
 1658,
 970129407,
 969932800,
 -1,
 970144213,
 970023399,
 -1,
 -50732,
 970112809,
 64350,
 -1,
 970165624,
 64352,
 -50730,
 970097615,
 64353,
 -1,
 970281089,
 64351,
 970522623,
 969932800,
 -1,
 970537435,
 970416615,
 -1,
 -50726,
 970506025,
 64358,
 -1,
 970558840,
 64360,
 -50724,
 970490831,
 64361,
 -1,
 970674305,
 64359,
 970865129,
 969890035,
 -1,
 970930661,
 970802417,
 1579,
 971046911,
 970850304,
 -1,
 971061731,
 970940903,
 -1,
 -50718,
 971030313,
 65177,
 -1,
 971083128,
 65179,
 -50716,
 971015119,
 65180,
 -1,
 971198593,
 65178,
 971440127,
 970856985,
 1584,
 971505663,
 971309056,
 -1,
 -50712,
 971402682,
 65195,
 -1,
 971460737,
 65196,
 971702271,
 970791196,
 1591,
 971767807,
 971571200,
 -1,
 971782638,
 971661799,
 -1,
 -50707,
 971751209,
 65217,
 -1,
 971804024,
 65219,
 -50705,
 971760061,
 1695,
 -50704,
 971932623,
 65220,
 -1,
 971985025,
 65218,
 972175916,
 967334131,
 -1,
 972241422,
 972113137,
 1607,
 972357631,
 972161024,
 -1,
 972372476,
 972248719,
 1729,
 972488703,
 972292096,
 -1,
 972503545,
 972382695,
 -1,
 -50696,
 972472105,
 64422,
 -1,
 972524920,
 64424,
 -50694,
 972480746,
 1730,
 -50693,
 972653519,
 64425,
 -1,
 972705921,
 64423,
 972896771,
 972307159,
 1726,
 973012991,
 972816384,
 -1,
 973027841,
 972906983,
 -1,
 -50688,
 972996393,
 64426,
 -1,
 973049208,
 64428,
 -50686,
 972981199,
 64429,
 -1,
 973164673,
 64427,
 973355529,
 972873796,
 -1,
 973421064,
 973333933,
 1728,
 973537279,
 973340672,
 -1,
 -50681,
 973434298,
 64420,
 -1,
 973492353,
 64421,
 -1,
 973368315,
 1791,
 973748748,
 973300199,
 -1,
 -50677,
 973717289,
 65257,
 -1,
 973770104,
 65259,
 -50675,
 973702095,
 65260,
 -1,
 973885569,
 65258,
 974076455,
 972166542,
 -1,
 974141989,
 974018803,
 1581,
 974258175,
 974061568,
 -1,
 974273056,
 974184516,
 -1,
 974338585,
 974242680,
 -1,
 974404118,
 974316145,
 -1,
 -50667,
 974379776,
 1666,
 -1,
 974395023,
 1879,
 974651391,
 974348522,
 -1,
 -50664,
 974562721,
 1880,
 -1,
 974591631,
 1669,
 974797342,
 974306864,
 -1,
 974862877,
 974722446,
 -1,
 -50660,
 974818101,
 1903,
 -1,
 974859118,
 1906,
 -1,
 974792824,
 1902,
 -50657,
 974740085,
 1665,
 -1,
 975064599,
 1916,
 975256099,
 974217703,
 -1,
 -50654,
 975224617,
 65185,
 -1,
 975277432,
 65187,
 -50652,
 975209423,
 65188,
 -1,
 975392897,
 65186,
 975634431,
 974096686,
 1569,
 -1,
 975504603,
 65152,
 975765503,
 974021953,
 1652,
 975831039,
 975634432,
 -1,
 -50646,
 975758756,
 1656,
 -50645,
 975822593,
 1654,
 -1,
 975837910,
 1653,
 976042593,
 972109356,
 -1,
 976108105,
 975967630,
 -1,
 976173629,
 976057284,
 1583,
 976289791,
 976093184,
 -1,
 976304699,
 976216132,
 -1,
 976370228,
 976274296,
 -1,
 -50637,
 976347884,
 1881,
 -1,
 976380165,
 1679,
 976566839,
 976317252,
 -1,
 -50634,
 976541798,
 1774,
 -1,
 976600809,
 1882,
 976763449,
 976501595,
 1674,
 -1,
 976683381,
 1675,
 -50630,
 976728630,
 1673,
 -1,
 976835151,
 1680,
 -50628,
 976252346,
 65193,
 -1,
 976965761,
 65194,
 977156677,
 976107052,
 1590,
 977272831,
 977076224,
 -1,
 977287746,
 977166823,
 -1,
 -50623,
 977256233,
 65213,
 -1,
 977309048,
 65215,
 -50621,
 977264807,
 1787,
 -50620,
 977437647,
 65216,
 -1,
 977490049,
 65214,
 977731583,
 977099233,
 1676,
 977797119,
 977600512,
 -1,
 -50616,
 977694138,
 64388,
 -1,
 977752193,
 64389,
 977943122,
 976041623,
 -1,
 978008654,
 977892292,
 1672,
 978124799,
 977928192,
 -1,
 -50611,
 978021818,
 64392,
 -1,
 978079873,
 64393,
 978321407,
 977951201,
 1677,
 978386943,
 978190336,
 -1,
 -50607,
 978283962,
 64386,
 -1,
 978342017,
 64387,
 978532953,
 977921444,
 1668,
 978649087,
 978452480,
 -1,
 978664023,
 978543079,
 -1,
 -50602,
 978632489,
 64370,
 -1,
 978685304,
 64372,
 -50600,
 978617295,
 64373,
 -1,
 978800769,
 64371,
 978991709,
 978506070,
 1678,
 979107839,
 978911232,
 -1,
 -50596,
 979004858,
 64390,
 -1,
 979062913,
 64391,
 979304447,
 978951009,
 -1,
 -50593,
 979216346,
 1647,
 -50592,
 979259318,
 1697,
 -1,
 979314782,
 1646,
 979516050,
 975967630,
 -1,
 979581571,
 979465960,
 1575,
 979697663,
 979501056,
 -1,
 979712637,
 979623386,
 -1,
 979778169,
 979660354,
 -1,
 979843695,
 979720814,
 -1,
 979909227,
 979773560,
 1573,
 980025343,
 979828736,
 -1,
 -50582,
 979922362,
 65159,
 -1,
 979980417,
 65160,
 980221951,
 979834511,
 1571,
 980287487,
 980090880,
 -1,
 -50578,
 980184506,
 65155,
 -1,
 980242561,
 65156,
 980433523,
 979796139,
 1570,
 980549631,
 980353024,
 -1,
 -50574,
 980446650,
 65153,
 -1,
 980504705,
 65154,
 980695670,
 980410073,
 -1,
 -50571,
 980625528,
 1651,
 -1,
 980686479,
 1650,
 980942847,
 980635198,
 -1,
 -50568,
 980869736,
 1907,
 -1,
 980902089,
 1908,
 981139455,
 979706863,
 1649,
 981204991,
 981008384,
 -1,
 -50564,
 981102010,
 64336,
 -1,
 981160065,
 64337,
 981351041,
 979665142,
 1609,
 981467135,
 981270528,
 -1,
 -50560,
 981364154,
 65263,
 -1,
 981422209,
 65264,
 -50558,
 981298618,
 65165,
 -1,
 981553281,
 65166,
 981744273,
 979527576,
 1593,
 981860351,
 981663744,
 -1,
 981875340,
 981787062,
 -1,
 981940873,
 981852785,
 -1,
 -50552,
 981916685,
 1887,
 -1,
 981931663,
 1885,
 982188031,
 981885162,
 -1,
 -50549,
 982099321,
 1886,
 -1,
 982128271,
 1696,
 982334095,
 981819879,
 -1,
 -50546,
 982302505,
 65225,
 -1,
 982355320,
 65227,
 -50544,
 982287311,
 65228,
 -1,
 982470785,
 65226,
 -1,
 981680295,
 1749,
 982727359,
 979464438,
 -1,
 982792866,
 982664504,
 1705,
 982908927,
 982712320,
 -1,
 982923933,
 982835268,
 -1,
 982989468,
 982893432,
 -1,
 983055003,
 982933738,
 -1,
 -50535,
 983016865,
 1892,
 -50534,
 983050360,
 1596,
 -1,
 983111311,
 1891,
 -1,
 983032442,
 1595,
 -1,
 982924093,
 1890,
 983448224,
 982868455,
 -1,
 -50529,
 983416617,
 64398,
 -1,
 983469432,
 64400,
 -50527,
 983401423,
 64401,
 -1,
 983584897,
 64399,
 983775919,
 982718636,
 1603,
 983891967,
 983695360,
 -1,
 983906986,
 983818308,
 -1,
 983972520,
 983876472,
 -1,
 -50521,
 983949946,
 1919,
 -1,
 983982367,
 1710,
 -50519,
 983937590,
 1707,
 -1,
 984103741,
 1708,
 984300205,
 983851495,
 -1,
 -50516,
 984268585,
 65241,
 -1,
 984321400,
 65243,
 -50514,
 984253391,
 65244,
 -1,
 984436865,
 65242,
 984627896,
 983723257,
 -1,
 984693428,
 984606641,
 1737,
 984809471,
 984612864,
 -1,
 -50509,
 984706490,
 64482,
 -1,
 984764545,
 64483,
 985006079,
 984650552,
 1733,
 985071615,
 984875008,
 -1,
 -50505,
 984968634,
 64480,
 -1,
 985026689,
 64481,
 985268223,
 984570247,
 1582,
 985333759,
 985137152,
 -1,
 985348797,
 985227751,
 -1,
 -50500,
 985317161,
 65189,
 -1,
 985369976,
 65191,
 -50498,
 985301967,
 65192,
 -1,
 985485441,
 65190,
 985676521,
 982681922,
 -1,
 985742036,
 985634603,
 1606,
 985858047,
 985661440,
 -1,
 985873099,
 985784388,
 -1,
 985938630,
 985842552,
 -1,
 -50491,
 985916040,
 1895,
 -1,
 985948405,
 1725,
 986135241,
 985906729,
 -1,
 -50488,
 986110054,
 1897,
 -1,
 986170387,
 1896,
 -50486,
 986100278,
 1724,
 -1,
 986266459,
 1721,
 986462927,
 985814464,
 1722,
 986578943,
 986382336,
 -1,
 -50482,
 986475962,
 64414,
 -1,
 986534017,
 64415,
 986725074,
 986407399,
 -1,
 -50479,
 986693417,
 65253,
 -1,
 986746232,
 65255,
 -50477,
 986678223,
 65256,
 -1,
 986861697,
 65254,
 987052770,
 985682731,
 1709,
 987118300,
 987009855,
 1713,
 987234303,
 987037696,
 -1,
 987249370,
 987128295,
 -1,
 -50471,
 987217705,
 64410,
 -1,
 987270520,
 64412,
 -50469,
 987202511,
 64413,
 -1,
 987385985,
 64411,
 987627519,
 987037696,
 -1,
 987642592,
 987521511,
 -1,
 -50465,
 987610921,
 64467,
 -1,
 987663736,
 64469,
 -50463,
 987595727,
 64470,
 -1,
 987779201,
 64468,
 988020735,
 987030948,
 1667,
 988086271,
 987889664,
 -1,
 988101351,
 987980263,
 -1,
 -50458,
 988069673,
 64374,
 -1,
 988122488,
 64376,
 -50456,
 988054479,
 64377,
 -1,
 988237953,
 64375,
 988429071,
 985642928,
 -1,
 988494587,
 988365676,
 1587,
 988610559,
 988413952,
 -1,
 988625654,
 988536900,
 -1,
 988691185,
 988595064,
 -1,
 988756720,
 988635423,
 1691,
 -1,
 988676513,
 1692,
 -1,
 988734163,
 1901,
 -50446,
 988659273,
 1904,
 -50445,
 988900347,
 1918,
 -50444,
 988959311,
 1884,
 -50443,
 989023728,
 1917,
 -1,
 989084517,
 1690,
 989281017,
 988570087,
 -1,
 -50440,
 989249321,
 65201,
 -1,
 989302136,
 65203,
 -50438,
 989234127,
 65204,
 -1,
 989417601,
 65202,
 989608709,
 988420091,
 1589,
 989724671,
 989528064,
 -1,
 989739776,
 989651382,
 -1,
 -50433,
 989717128,
 1693,
 -1,
 989749493,
 1694,
 989936387,
 989684199,
 -1,
 -50430,
 989904681,
 65209,
 -1,
 989957496,
 65211,
 -50428,
 989889487,
 65212,
 -1,
 990072961,
 65210,
 990264077,
 989551707,
 1588,
 990380031,
 990183424,
 -1,
 990395146,
 990274023,
 -1,
 -50423,
 990363433,
 65205,
 -1,
 990416248,
 65207,
 -50421,
 990372007,
 1786,
 -50420,
 990544847,
 65208,
 -1,
 990597249,
 65206,
 -50418,
 990240439,
 1706,
 -1,
 990762196,
 1648,
 990919475,
 988406976,
 -1,
 990985007,
 990856433,
 1610,
 991100927,
 990904320,
 -1,
 991116062,
 991027268,
 -1,
 991181594,
 991058549,
 1574,
 991297535,
 991100928,
 -1,
 991312664,
 991191527,
 -1,
 -50409,
 991280937,
 65161,
 -1,
 991333752,
 65163,
 -50407,
 991265743,
 65164,
 -1,
 991449217,
 65162,
 991640349,
 991150968,
 -1,
 -50404,
 991584543,
 1745,
 -1,
 991631715,
 1741,
 -1,
 991608531,
 1742,
 991902506,
 991045587,
 1746,
 992018431,
 991821824,
 -1,
 992033576,
 991944772,
 -1,
 992099109,
 991976053,
 1747,
 992215039,
 992018432,
 -1,
 -50396,
 992112058,
 64432,
 -1,
 992170113,
 64433,
 992411647,
 992038462,
 -1,
 -50393,
 992338536,
 1914,
 -1,
 992370889,
 1915,
 -50391,
 991980986,
 64430,
 -1,
 992497793,
 64431,
 992688941,
 991846887,
 -1,
 -50388,
 992657193,
 65265,
 -1,
 992710008,
 65267,
 -50386,
 992641999,
 65268,
 -1,
 992825473,
 65266,
 993067007,
 990957294,
 1736,
 993132543,
 992935936,
 -1,
 -50382,
 993029562,
 64475,
 -1,
 993087617,
 64476,
 993278803,
 990882262,
 -1,
 993344328,
 993215729,
 1585,
 993460223,
 993263616,
 -1,
 993475398,
 993386564,
 -1,
 993540925,
 993441712,
 -1,
 993606460,
 993493377,
 -1,
 993671995,
 993581158,
 1682,
 -1,
 993591859,
 1685,
 -1,
 993599698,
 1905,
 -1,
 993578104,
 1883,
 993934144,
 993512994,
 -1,
 -50369,
 993909773,
 1899,
 -1,
 993924751,
 1687,
 994130754,
 993868635,
 1684,
 -1,
 994050219,
 1686,
 -50365,
 994095670,
 1683,
 -50364,
 994208763,
 1775,
 -50363,
 994269813,
 1900,
 -1,
 994333263,
 1689,
 -50361,
 993422778,
 65197,
 -1,
 994463873,
 65198,
 994655055,
 993299996,
 1723,
 994770943,
 994574336,
 -1,
 994786125,
 994664935,
 -1,
 -50356,
 994754345,
 64416,
 -1,
 994807160,
 64418,
 -50354,
 994739151,
 64419,
 -1,
 994922625,
 64417,
 995164159,
 994618677,
 1681,
 995229695,
 995033088,
 -1,
 -50350,
 995126714,
 64396,
 -1,
 995184769,
 64397,
 995375987,
 993208380,
 -1,
 995441516,
 995318003,
 1576,
 995507045,
 995360768,
 -1,
 995572576,
 995483716,
 -1,
 995638109,
 995541880,
 -1,
 995703644,
 995582186,
 -1,
 995769179,
 995665313,
 1874,
 -1,
 995688887,
 1875,
 -1,
 995713030,
 1872,
 -1,
 995680918,
 1876,
 -50338,
 995606227,
 1878,
 -50337,
 995978198,
 1877,
 -1,
 996031357,
 1873,
 996227939,
 995516903,
 -1,
 -50334,
 996196137,
 65167,
 -1,
 996248952,
 65169,
 -50332,
 996180943,
 65170,
 -1,
 996364417,
 65168,
 996605951,
 995443953,
 1664,
 996671487,
 996474880,
 -1,
 996686698,
 996565479,
 -1,
 -50327,
 996654889,
 64346,
 -1,
 996707704,
 64348,
 -50325,
 996639695,
 64349,
 -1,
 996823169,
 64347,
 997064703,
 995378417,
 1659,
 997130239,
 996933632,
 -1,
 997145457,
 997024231,
 -1,
 -50320,
 997113641,
 64338,
 -1,
 997166456,
 64340,
 -50318,
 997098447,
 64341,
 -1,
 997281921,
 64339,
 997473173,
 995315358,
 -1,
 997538693,
 997401304,
 1740,
 997654527,
 997457920,
 -1,
 997669760,
 997580868,
 -1,
 997735292,
 997608915,
 -1,
 997800827,
 997704568,
 -1,
 -50310,
 997778024,
 1909,
 -1,
 997810377,
 1910,
 -1,
 997741114,
 1911,
 998062975,
 997704568,
 -1,
 -50306,
 998040186,
 1598,
 -1,
 998072565,
 1599,
 -1,
 998009851,
 1597,
 998325123,
 997614055,
 -1,
 -50302,
 998293289,
 64508,
 -1,
 998346104,
 64510,
 -50300,
 998278095,
 64511,
 -1,
 998461569,
 64509,
 998703103,
 997475569,
 1601,
 998768639,
 998572032,
 -1,
 998783888,
 998694980,
 -1,
 998849421,
 998753144,
 -1,
 998914956,
 998793450,
 -1,
 -50293,
 998876577,
 1889,
 -1,
 998910072,
 1701,
 -1,
 998892168,
 1888,
 999227391,
 998783800,
 -1,
 -50289,
 999131071,
 1698,
 -1,
 999172216,
 1699,
 999373715,
 998728167,
 -1,
 -50286,
 999341865,
 65233,
 -1,
 999394680,
 65235,
 -50284,
 999326671,
 65236,
 -1,
 999510145,
 65234,
 999701425,
 997413675,
 -1,
 999766946,
 999626924,
 1711,
 999882751,
 999686144,
 -1,
 999898013,
 999809092,
 -1,
 999963548,
 999867256,
 -1,
 -50277,
 999940744,
 1714,
 -1,
 999973109,
 1716,
 -1,
 999928374,
 1712,
 1000225696,
 999842279,
 -1,
 -50273,
 1000193833,
 64402,
 -1,
 1000246648,
 64404,
 -50271,
 1000178639,
 64405,
 -1,
 1000362113,
 64403,
 1000553386,
 999709123,
 1594,
 1000669183,
 1000472576,
 -1,
 1000684455,
 1000563175,
 -1,
 -50266,
 1000652585,
 65229,
 -1,
 1000705400,
 65231,
 -50264,
 1000661159,
 1788,
 -50263,
 1000833999,
 65232,
 -1,
 1000886401,
 65230,
 1001127935,
 1000526005,
 1715,
 1001193471,
 1000996864,
 -1,
 1001208751,
 1001087463,
 -1,
 -50258,
 1001176873,
 64406,
 -1,
 1001229688,
 64408,
 -50256,
 1001161679,
 64409,
 -1,
 1001345153,
 64407,
 1001536448,
 999677697,
 1608,
 1001652223,
 1001455616,
 -1,
 1001667518,
 1001578564,
 -1,
 1001733048,
 1001609845,
 1572,
 1001848831,
 1001652224,
 -1,
 -50249,
 1001745850,
 65157,
 -1,
 1001803905,
 65158,
 1001995195,
 1001672254,
 -1,
 -50246,
 1001972328,
 1912,
 -1,
 1002004681,
 1913,
 -50244,
 1001967148,
 1738,
 -50243,
 1002156598,
 1732,
 -1,
 1002191677,
 1743,
 -50241,
 1001614778,
 65261,
 -1,
 1002328193,
 65262,
 1002519502,
 1001497210,
 1662,
 1002585032,
 1002456305,
 1702,
 1002700799,
 1002504192,
 -1,
 1002716102,
 1002594791,
 -1,
 -50235,
 1002684201,
 64366,
 -1,
 1002737016,
 64368,
 -50233,
 1002669007,
 64369,
 -1,
 1002852481,
 64367,
 1003094015,
 1002504192,
 -1,
 1003109324,
 1002988007,
 -1,
 -50229,
 1003077417,
 64342,
 -1,
 1003130232,
 64344,
 -50227,
 1003062223,
 64345,
 -1,
 1003245697,
 64343,
 1003437020,
 1002468642,
 1604,
 1003552767,
 1003356160,
 -1,
 1003568087,
 1003479108,
 -1,
 1003633620,
 1003538410,
 -1,
 -50221,
 1003563128,
 1720,
 -1,
 1003624079,
 1719,
 -50219,
 1003601619,
 1717,
 -50218,
 1003764541,
 1718,
 -1,
 1003825011,
 1898,
 1004026842,
 1003512295,
 -1,
 -50215,
 1003994921,
 65245,
 -1,
 1004047736,
 65247,
 -50213,
 1003979727,
 65248,
 -1,
 1004163201,
 65246,
 1004354536,
 1003415562,
 -1,
 1004420068,
 1004296435,
 1592,
 1004535807,
 1004339200,
 -1,
 1004551138,
 1004429799,
 -1,
 -50207,
 1004519209,
 65221,
 -1,
 1004572024,
 65223,
 -50205,
 1004504015,
 65224,
 -1,
 1004687489,
 65222,
 1004929023,
 1004365720,
 1586,
 1004994559,
 1004797952,
 -1,
 -50201,
 1004891578,
 65199,
 -1,
 1004949633,
 65200,
 1005140979,
 1004329394,
 1739,
 1005206512,
 1005082867,
 1700,
 1005322239,
 1005125632,
 -1,
 1005337582,
 1005216231,
 -1,
 -50195,
 1005305641,
 64362,
 -1,
 1005358456,
 64364,
 -50193,
 1005290447,
 64365,
 -1,
 1005473921,
 64363,
 1005715455,
 1005125632,
 -1,
 -50190,
 1005612474,
 64478,
 -1,
 1005670529,
 64479,
 1005861887,
 1005088699,
 -1,
 1005927419,
 1005799018,
 1580,
 1006043135,
 1005846528,
 -1,
 1006058489,
 1005937127,
 -1,
 -50184,
 1006026537,
 65181,
 -1,
 1006079352,
 65183,
 -50182,
 1006011343,
 65184,
 -1,
 1006194817,
 65182,
 1006436351,
 1005869299,
 1688,
 1006501887,
 1006305280,
 -1,
 -50178,
 1006398906,
 64394,
 -1,
 1006456961,
 64395,
 1006648328,
 1005833966,
 1735,
 1006713861,
 1006567424,
 -1,
 1006779395,
 1006690538,
 1655,
 -1,
 1006699739,
 64477,
 -50172,
 1006726586,
 64471,
 -1,
 1006850177,
 64472,
 1007091711,
 1006658994,
 -1,
 -50169,
 1006994383,
 64489,
 -1,
 1007053261,
 64488,
 1007238162,
 1006610394,
 1602,
 1007353855,
 1007157248,
 -1,
 1007369229,
 1007280196,
 -1,
 -50164,
 1007339510,
 1704,
 -1,
 1007369021,
 1703,
 1007565840,
 1007313383,
 -1,
 -50161,
 1007533865,
 65237,
 -1,
 1007586680,
 65239,
 -50159,
 1007518671,
 65240,
 -1,
 1007702145,
 65238,
 1007893532,
 1007191018,
 1605,
 1008009215,
 1007812608,
 -1,
 1008024599,
 1007935630,
 -1,
 -50154,
 1007954040,
 1894,
 -1,
 1008014991,
 1893,
 1008221210,
 1007968743,
 -1,
 -50151,
 1008189225,
 65249,
 -1,
 1008242040,
 65251,
 -50149,
 1008174031,
 65252,
 -1,
 1008357505,
 65250,
 1008548899,
 1007829159,
 1744,
 1008664575,
 1008467968,
 -1,
 1008679969,
 1008558567,
 -1,
 -50144,
 1008647977,
 64484,
 -1,
 1008700792,
 64486,
 -50142,
 1008632783,
 64487,
 -1,
 1008816257,
 64485,
 1009057791,
 1008505656,
 1734,
 1009123327,
 1008926720,
 -1,
 -50138,
 1009020346,
 64473,
 -1,
 1009078401,
 64474,
 1009269859,
 916371376,
 -1,
 1009335368,
 1009222017,
 -1,
 1009400896,
 1009278295,
 -1,
 1009466416,
 1009349572,
 -1,
 1009531951,
 1009411335,
 -1,
 -50131,
 1009498169,
 1750,
 -50130,
 1009559518,
 1751,
 -1,
 1009589037,
 1558,
 -1,
 1009458319,
 1753,
 1009859637,
 1009418312,
 -1,
 1009925172,
 1009795932,
 -1,
 -50125,
 1009893161,
 1762,
 -1,
 1009945976,
 1752,
 -1,
 1009850385,
 1764,
 1010187320,
 1009828728,
 -1,
 -50121,
 1010131168,
 1755,
 -1,
 1010178332,
 1557,
 -50119,
 1010165792,
 1559,
 -50118,
 1010361764,
 1767,
 -50117,
 1010423156,
 1760,
 -50116,
 1010481545,
 1756,
 -50115,
 1010546066,
 1759,
 -50114,
 1010601500,
 1768,
 -50113,
 1010659313,
 1754,
 -1,
 1010711495,
 1761,
 1010908227,
 1009352326,
 -1,
 -50110,
 1010874761,
 1763,
 -1,
 1010926570,
 1773,
 -50108,
 1010886052,
 1766,
 -50107,
 1011080961,
 1765,
 -50106,
 1011118506,
 1562,
 -50105,
 1011175257,
 1560,
 -1,
 1011234544,
 1561,
 1011432535,
 1009280497,
 -1,
 1011498065,
 1011398576,
 -1,
 1011563598,
 1011422606,
 -1,
 -50100,
 1011517903,
 1537,
 -50099,
 1011580086,
 1552,
 -1,
 1011634253,
 1539,
 1011875839,
 1011509374,
 -1,
 -50096,
 1011787233,
 1790,
 -1,
 1011817785,
 1789,
 1012022356,
 1011460657,
 -1,
 -50093,
 1011965622,
 1554,
 -1,
 1012021402,
 1555,
 -50091,
 1011991621,
 1556,
 -50090,
 1012172356,
 1551,
 -1,
 1012210352,
 1553,
 1012415581,
 1011404526,
 -1,
 1012481116,
 1012364162,
 1618,
 1012596735,
 1012400128,
 -1,
 -50085,
 1012499407,
 65151,
 -1,
 1012559290,
 65150,
 -1,
 1012411430,
 1622,
 1012808801,
 1012357429,
 1617,
 1012924415,
 1012727808,
 -1,
 -50080,
 1012827087,
 65149,
 -1,
 1012886970,
 65148,
 -50078,
 1012778197,
 1758,
 -1,
 1013008032,
 1563,
 1013202030,
 1009208990,
 -1,
 1013267563,
 1013130476,
 1614,
 1013333097,
 1013186560,
 -1,
 -50073,
 1013309907,
 1630,
 -50072,
 1013351375,
 65143,
 -1,
 1013411258,
 65142,
 1013645311,
 1013302436,
 1611,
 -1,
 1013515483,
 65136,
 -50068,
 1013240254,
 1748,
 -50067,
 1013684059,
 1538,
 -1,
 1013739284,
 1645,
 1013922936,
 1013134892,
 -1,
 1013988471,
 1013847438,
 -1,
 1014054006,
 1013941850,
 1615,
 1014119539,
 1014023332,
 1612,
 -1,
 1014039771,
 65138,
 1014300671,
 1014038528,
 -1,
 -50059,
 1014203343,
 65145,
 -1,
 1014263226,
 65144,
 -1,
 1014023458,
 1549,
 -1,
 1013924450,
 1643,
 1014578303,
 1013891960,
 -1,
 1014643837,
 1014502798,
 -1,
 1014709372,
 1014615552,
 1600,
 -1,
 1014631781,
 65137,
 -1,
 1014654536,
 65139,
 -50050,
 1014608582,
 1566,
 -1,
 1014849701,
 1644,
 1015037061,
 1014526378,
 1616,
 1015102594,
 1015006372,
 1613,
 -1,
 1015022811,
 65140,
 1015283711,
 1015021568,
 -1,
 -50044,
 1015186383,
 65147,
 -1,
 1015246266,
 65146,
 1015430281,
 1015012744,
 -1,
 -50041,
 1015398107,
 1626,
 -50040,
 1015442367,
 1627,
 -1,
 1015495515,
 1628,
 1015692429,
 1015392726,
 -1,
 -50037,
 1015651406,
 1772,
 -50036,
 1015696680,
 1629,
 -1,
 1015752285,
 1544,
 1015954577,
 1015652459,
 -1,
 -50033,
 1015911250,
 1550,
 -50032,
 1015968877,
 1769,
 -1,
 1016023491,
 1642,
 1016216726,
 1015890087,
 -1,
 1016282261,
 1016170492,
 -1,
 -50028,
 1016233643,
 1770,
 -1,
 1016290691,
 1771,
 -1,
 1016236743,
 1757,
 1016544409,
 1016168597,
 -1,
 -50024,
 1016509393,
 1624,
 -1,
 1016543051,
 1619,
 1016741020,
 1016486510,
 -1,
 -50021,
 1016670328,
 1621,
 -1,
 1016731279,
 1620,
 -50019,
 1016719666,
 1625,
 -50018,
 1016899904,
 1567,
 -50017,
 1016959146,
 1536,
 -50016,
 1017015154,
 1623,
 -1,
 1017066044,
 1548,
 1017315327,
 916262986,
 -1,
 1017330864,
 1017199012,
 -1,
 1017396390,
 1017299832,
 -1,
 -50011,
 1017373281,
 1634,
 -1,
 1017405630,
 1635,
 1017593001,
 1017362352,
 -1,
 -50008,
 1017540444,
 1638,
 -1,
 1017597103,
 1639,
 1017789612,
 1017532062,
 -1,
 -50005,
 1017748594,
 1636,
 -1,
 1017802469,
 1637,
 -50003,
 1017768047,
 1632,
 -50002,
 1017943586,
 1633,
 -50001,
 1018006815,
 1641,
 -1,
 1018053975,
 1640,
 1018248371,
 1017291478,
 -1,
 -49998,
 1018217939,
 1546,
 -1,
 1018267048,
 1545,
 -49996,
 1018188383,
 1543,
 -1,
 1018377600,
 1542,
 1018576177,
 916227175,
 -1,
 1018641650,
 1018543775,
 -1,
 1018707178,
 1018580064,
 -1,
 1018772670,
 1018637571,
 -1,
 1018838204,
 1018714355,
 -1,
 -49989,
 1018774769,
 1395,
 -1,
 1018828174,
 1401,
 -49987,
 1018794482,
 1409,
 -1,
 1018959246,
 1390,
 1019165890,
 1018708135,
 -1,
 -49984,
 1019134840,
 1384,
 -49983,
 1019173107,
 1383,
 -1,
 1019227975,
 1381,
 1019428037,
 1019144184,
 -1,
 -49980,
 1019370384,
 1386,
 -1,
 1019417998,
 1382,
 1019624647,
 1019405890,
 1397,
 -1,
 1019601440,
 1410,
 1019755722,
 1019598950,
 -1,
 -49975,
 1019711986,
 1400,
 -1,
 1019760010,
 1406,
 1019952333,
 1019724664,
 -1,
 -49972,
 1019908594,
 1385,
 -1,
 1019965268,
 1407,
 1020148944,
 1019918256,
 -1,
 -49969,
 1020090641,
 1399,
 -1,
 1020151025,
 1405,
 1020345555,
 1020111318,
 -1,
 -49966,
 1020282097,
 1408,
 -1,
 1020335502,
 1404,
 1020542166,
 1020305515,
 -1,
 -49963,
 1020489560,
 1411,
 -1,
 1020544241,
 1402,
 1020738777,
 1020490276,
 -1,
 -49960,
 1020692802,
 1391,
 -1,
 1020745971,
 1412,
 1020935388,
 1020686231,
 -1,
 -49957,
 1020877934,
 1403,
 -1,
 1020925326,
 1393,
 1021131999,
 1020875563,
 -1,
 -49954,
 1021077191,
 1379,
 -1,
 1021139249,
 1394,
 -49952,
 1021109308,
 1389,
 -49951,
 1021285318,
 1413,
 -49950,
 1021349672,
 1398,
 -49949,
 1021412446,
 1396,
 -49948,
 1021475930,
 1388,
 -49947,
 1021536652,
 1387,
 -49946,
 1021599431,
 1392,
 -49945,
 1021661110,
 1414,
 -49944,
 1021720215,
 1380,
 -49943,
 1021782165,
 1378,
 -1,
 1021847163,
 1377,
 1022099455,
 1018651911,
 -1,
 1022115056,
 1022002274,
 -1,
 -49939,
 1022092348,
 64279,
 -49938,
 1022136104,
 64275,
 -49937,
 1022192012,
 64277,
 -1,
 1022247509,
 64276,
 -49935,
 1022090287,
 64278,
 -1,
 1022378585,
 1415,
 1022573863,
 1018572035,
 -1,
 1022639398,
 1022500875,
 -1,
 1022704890,
 1022569731,
 -1,
 1022770424,
 1022646515,
 -1,
 -49929,
 1022706929,
 1347,
 -1,
 1022760334,
 1353,
 -49927,
 1022726642,
 1361,
 -1,
 1022891406,
 1342,
 1023098110,
 1022640295,
 -1,
 -49924,
 1023067000,
 1336,
 -49923,
 1023105267,
 1335,
 -1,
 1023160135,
 1333,
 1023360257,
 1023076344,
 -1,
 -49920,
 1023302544,
 1338,
 -1,
 1023350158,
 1334,
 1023556867,
 1023338050,
 1349,
 -1,
 1023533600,
 1362,
 1023687942,
 1023531110,
 -1,
 -49915,
 1023644146,
 1352,
 -1,
 1023692170,
 1358,
 1023884553,
 1023656824,
 -1,
 -49912,
 1023840754,
 1337,
 -1,
 1023897428,
 1359,
 1024081164,
 1023850416,
 -1,
 -49909,
 1024022801,
 1351,
 -1,
 1024083185,
 1357,
 1024277775,
 1024043478,
 -1,
 -49906,
 1024214257,
 1360,
 -1,
 1024267662,
 1356,
 1024474386,
 1024237675,
 -1,
 -49903,
 1024421720,
 1363,
 -1,
 1024476401,
 1354,
 1024670997,
 1024422436,
 -1,
 -49900,
 1024624962,
 1343,
 -1,
 1024678131,
 1364,
 1024867608,
 1024618391,
 -1,
 -49897,
 1024810094,
 1355,
 -1,
 1024857486,
 1345,
 1025064219,
 1024807723,
 -1,
 -49894,
 1025009351,
 1331,
 -1,
 1025071409,
 1346,
 -49892,
 1025041468,
 1341,
 -49891,
 1025217478,
 1365,
 -49890,
 1025281832,
 1350,
 -49889,
 1025344606,
 1348,
 -49888,
 1025408090,
 1340,
 -49887,
 1025468812,
 1339,
 -49886,
 1025531591,
 1344,
 -49885,
 1025593270,
 1366,
 -49884,
 1025652375,
 1332,
 -49883,
 1025714325,
 1330,
 -1,
 1025779323,
 1329,
 -1,
 1022596450,
 1373,
 1026047274,
 1022509223,
 -1,
 -49879,
 1026024472,
 1372,
 -1,
 1026066397,
 1371,
 1026243885,
 1025971598,
 -1,
 -49876,
 1026205170,
 1370,
 -1,
 1026238490,
 1375,
 -49874,
 1026206016,
 1374,
 -49873,
 1026393826,
 1369,
 -49872,
 1026449872,
 1418,
 -1,
 1026511626,
 1417,
 1026702648,
 1018541476,
 -1,
 1026768181,
 1026666936,
 -1,
 -49868,
 1026741709,
 10548,
 -1,
 1026768720,
 10549,
 1027014655,
 1026703275,
 -1,
 -49865,
 1026928929,
 10551,
 -1,
 1026980011,
 10550,
 -49863,
 1026647199,
 9800,
 -1,
 1027091715,
 8978,
 1027292583,
 916168811,
 -1,
 1027358110,
 1027240905,
 -1,
 1027423580,
 1027319875,
 -1,
 1027489113,
 1027348475,
 9109,
 1027604479,
 1027407872,
 -1,
 1027620168,
 1027487276,
 -1,
 1027685699,
 1027579949,
 -1,
 -49854,
 1027661363,
 9047,
 -1,
 1027670661,
 9036,
 1027882310,
 1027629543,
 -1,
 -49851,
 1027857498,
 9017,
 -1,
 1027874083,
 9018,
 1028128767,
 1027818974,
 9044,
 -1,
 1028047801,
 9037,
 1028209995,
 1027593128,
 -1,
 -49846,
 1028185651,
 9040,
 -1,
 1028194949,
 9043,
 1028406606,
 1028159166,
 -1,
 -49843,
 1028374591,
 9027,
 -1,
 1028412152,
 9031,
 1028603217,
 1028336899,
 -1,
 -49840,
 1028560132,
 9056,
 -1,
 1028615306,
 9020,
 -49838,
 1028570650,
 9025,
 -49837,
 1028763948,
 9032,
 -49836,
 1028827447,
 9072,
 -49835,
 1028886206,
 9071,
 -49834,
 1028944044,
 9019,
 -49833,
 1029003103,
 9028,
 -49832,
 1029064986,
 9016,
 -1,
 1029121763,
 9026,
 1029373951,
 1027447585,
 -1,
 -49829,
 1029296891,
 9048,
 -1,
 1029351498,
 9054,
 1029520750,
 1027356204,
 -1,
 1029586277,
 1029480493,
 -1,
 1029651812,
 1029505024,
 -1,
 1029717346,
 1029620738,
 -1,
 -49823,
 1029690107,
 9034,
 -1,
 1029730476,
 9038,
 -49821,
 1029684183,
 9062,
 -1,
 1029844553,
 9073,
 -1,
 1029627520,
 9046,
 1030110573,
 1029522910,
 -1,
 1030176106,
 1030029312,
 -1,
 -49816,
 1030146208,
 9067,
 -49815,
 1030209856,
 9042,
 -1,
 1030240426,
 9058,
 1030488063,
 1030144956,
 -1,
 -49812,
 1030411003,
 9049,
 -1,
 1030472000,
 9035,
 -1,
 1030054586,
 9050,
 1030700408,
 1029451011,
 -1,
 1030765943,
 1030646928,
 -1,
 1030831475,
 1030733992,
 -1,
 -49806,
 1030776428,
 9021,
 -1,
 1030824065,
 9055,
 -49804,
 1030804219,
 9052,
 -49803,
 1030975660,
 9022,
 -49802,
 1031026858,
 9061,
 -1,
 1031087843,
 9033,
 -1,
 1030722919,
 9066,
 1031355777,
 1030673320,
 -1,
 1031421312,
 1031274496,
 -1,
 1031486846,
 1031390210,
 -1,
 -49796,
 1031446316,
 9041,
 -49795,
 1031499948,
 9045,
 -1,
 1031551146,
 9057,
 -49793,
 1031453646,
 9053,
 -1,
 1031679561,
 9074,
 -1,
 1031396992,
 9039,
 1031945608,
 1031321520,
 -1,
 1032011141,
 1031914360,
 -1,
 -49788,
 1031956094,
 9069,
 -1,
 1032003733,
 9059,
 -49786,
 1031973274,
 9015,
 -49785,
 1032156659,
 9023,
 -1,
 1032210089,
 9070,
 1032404364,
 1031889383,
 -1,
 1032469899,
 1032362760,
 9075,
 -1,
 1032391688,
 9080,
 -1,
 1032392463,
 9014,
 1032666511,
 1032366550,
 -1,
 -49778,
 1032611235,
 9030,
 -1,
 1032675015,
 9076,
 1032863121,
 1032623438,
 9077,
 -1,
 1032784904,
 9081,
 1032994196,
 1032812273,
 -1,
 -49773,
 1032969856,
 9029,
 -1,
 1032981036,
 9063,
 1033190807,
 1032941744,
 -1,
 -49770,
 1033163515,
 9051,
 -1,
 1033189546,
 9060,
 1033387417,
 1033116782,
 9082,
 -1,
 1033309192,
 9078,
 -49766,
 1033365771,
 9068,
 -49765,
 1033488557,
 9064,
 -49764,
 1033525168,
 9065,
 -49763,
 1033586949,
 9079,
 -1,
 1033643757,
 9024,
 1033846182,
 1027319583,
 -1,
 1033911717,
 1033823333,
 -1,
 1033977252,
 1033849120,
 -1,
 1034042787,
 1033947606,
 8773,
 -1,
 1033963241,
 8786,
 -1,
 1034000527,
 10864,
 -1,
 1033907336,
 8774,
 -1,
 1033836416,
 8784,
 -1,
 1033804483,
 39,
 1034436087,
 1027228874,
 -1,
 1034501606,
 1034391714,
 -1,
 1034567098,
 1034470264,
 -1,
 1034632625,
 1034542554,
 -1,
 1034698159,
 1034588658,
 65800,
 1034813439,
 1034616832,
 -1,
 -49746,
 1034733505,
 65827,
 -1,
 1034772863,
 65818,
 1035010047,
 1034635375,
 65809,
 -1,
 1034881764,
 65836,
 1035091384,
 1034574067,
 -1,
 1035156918,
 1035054301,
 65801,
 1035272191,
 1035075584,
 -1,
 -49739,
 1035192257,
 65828,
 -1,
 1035231615,
 65819,
 1035468799,
 1035103556,
 65810,
 -1,
 1035340516,
 65837,
 1035599871,
 1035028241,
 65808,
 -1,
 1035471588,
 65835,
 1035681223,
 1034532784,
 -1,
 1035746753,
 1035628380,
 65804,
 1035812286,
 1035718349,
 65813,
 -1,
 1035733732,
 65840,
 1035993087,
 1035730944,
 -1,
 -49728,
 1035913153,
 65831,
 -1,
 1035952511,
 65822,
 1036189695,
 1035685039,
 65805,
 1036205508,
 1036111565,
 65814,
 -1,
 1036126948,
 65841,
 1036386303,
 1036124160,
 -1,
 -49722,
 1036306369,
 65832,
 -1,
 1036345727,
 65823,
 1036533206,
 1035619998,
 -1,
 1036598735,
 1036489202,
 -1,
 1036664269,
 1036572195,
 65802,
 1036779519,
 1036582912,
 -1,
 -49716,
 1036699585,
 65829,
 -1,
 1036738943,
 65820,
 1036976127,
 1036629751,
 65811,
 -1,
 1036847844,
 65838,
 1037107199,
 1036542439,
 -1,
 1037123028,
 1037031858,
 65803,
 1037238271,
 1037041664,
 -1,
 -49709,
 1037158337,
 65830,
 -1,
 1037197695,
 65821,
 1037434879,
 1037062918,
 65812,
 -1,
 1037306596,
 65839,
 1037516252,
 1036487967,
 65807,
 1037581785,
 1037487821,
 65816,
 -1,
 1037503204,
 65843,
 1037762559,
 1037500416,
 -1,
 -49701,
 1037682625,
 65834,
 -1,
 1037721983,
 65825,
 1037909474,
 1037452631,
 65806,
 1037975007,
 1037886656,
 65815,
 -1,
 1037896420,
 65842,
 1038155775,
 1037893632,
 -1,
 -49695,
 1038075841,
 65833,
 -1,
 1038115199,
 65824,
 1038352383,
 1037866530,
 65799,
 1038417919,
 1038221312,
 -1,
 -49691,
 1038337985,
 65826,
 -1,
 1038377343,
 65817,
 1038564849,
 1034477018,
 -1,
 1038630382,
 1038501213,
 -1,
 1038695915,
 1038569118,
 -1,
 -49686,
 1038654737,
 65851,
 -1,
 1038708012,
 65848,
 -49684,
 1038665584,
 65850,
 -49683,
 1038858574,
 65849,
 -1,
 1038886893,
 65847,
 1039138815,
 1038588164,
 -1,
 -49680,
 1039039317,
 65792,
 -1,
 1039088436,
 65793,
 1039285748,
 1038517178,
 -1,
 -49677,
 1039255408,
 65855,
 -1,
 1039317326,
 65854,
 -49675,
 1039236087,
 65853,
 -49674,
 1039417382,
 65852,
 -1,
 1039478683,
 65794,
 1039679036,
 1034411047,
 -1,
 1039744571,
 1039628866,
 -1,
 1039810049,
 1039668622,
 68352,
 1039875581,
 1039734158,
 68353,
 -49668,
 1039831538,
 68355,
 -1,
 1039894850,
 68357,
 1040072191,
 1039810727,
 68358,
 -1,
 1040007335,
 68359,
 -49664,
 1040028146,
 68354,
 -1,
 1040156994,
 68356,
 1040334345,
 1039763778,
 -1,
 1040399878,
 1040274219,
 -1,
 -49660,
 1040377229,
 68387,
 -49659,
 1040439730,
 68388,
 -1,
 1040466087,
 68386,
 -49657,
 1040377229,
 68390,
 -49656,
 1040616294,
 68391,
 -1,
 1040662695,
 68389,
 1040858639,
 1040299952,
 -1,
 1040924173,
 1040799987,
 -1,
 -49652,
 1040901517,
 68403,
 -1,
 1040924839,
 68401,
 -49650,
 1040890728,
 68404,
 -1,
 1041055911,
 68399,
 1041251859,
 1040835542,
 -1,
 -49647,
 1041229197,
 68370,
 -49646,
 1041291698,
 68371,
 -1,
 1041318055,
 68369,
 1041514007,
 1041220472,
 -1,
 -49643,
 1041483039,
 68381,
 -49642,
 1041521552,
 68378,
 -1,
 1041580199,
 68377,
 1041776155,
 1041453867,
 -1,
 -49639,
 1041718160,
 68374,
 -49638,
 1041781885,
 68373,
 -1,
 1041842343,
 68372,
 1042038302,
 1041754104,
 -1,
 -49635,
 1041980304,
 68402,
 -1,
 1042038951,
 68400,
 1042234913,
 1042015424,
 -1,
 -49632,
 1042212237,
 68394,
 -1,
 1042235559,
 68395,
 1042431523,
 1042206446,
 68366,
 -1,
 1042403054,
 68367,
 1042562597,
 1042387442,
 68362,
 -1,
 1042518514,
 68363,
 1042693671,
 1042506215,
 68364,
 -1,
 1042637287,
 68365,
 1042824746,
 1042634995,
 -1,
 -49623,
 1042776958,
 68393,
 -1,
 1042825383,
 68405,
 1043021356,
 1042759847,
 68360,
 -1,
 1042956455,
 68361,
 1043152431,
 1042953772,
 -1,
 -49618,
 1043094416,
 68380,
 -1,
 1043153063,
 68379,
 1043349042,
 1043080859,
 -1,
 -49615,
 1043291024,
 68385,
 -1,
 1043349671,
 68384,
 -49613,
 1043323314,
 68396,
 -49612,
 1043508230,
 68397,
 -49611,
 1043571247,
 68382,
 -49610,
 1043628926,
 68392,
 -49609,
 1043691198,
 68398,
 -49608,
 1043755556,
 68368,
 -49607,
 1043820475,
 68376,
 -49606,
 1043877742,
 68383,
 -1,
 1043934893,
 68375,
 -1,
 1039668809,
 68409,
 1044201038,
 1039632706,
 -1,
 1044266565,
 1044170870,
 -1,
 1044332097,
 1044196611,
 -1,
 -49600,
 1044289270,
 8755,
 -1,
 1044348435,
 10560,
 -49598,
 1044302548,
 8630,
 -49597,
 1044486056,
 8634,
 -49596,
 1044539974,
 10769,
 -1,
 1044599788,
 10226,
 1044790859,
 1044206379,
 -1,
 1044856394,
 1044739774,
 8736,
 1044971519,
 1044778038,
 -1,
 -49591,
 1044894459,
 10660,
 -1,
 1044953060,
 10654,
 -1,
 1044824574,
 8491,
 -49588,
 1044738672,
 9765,
 -49587,
 1045116545,
 10193,
 -1,
 1045180413,
 9875,
 1045380700,
 1044149188,
 -1,
 1045446227,
 1045333906,
 -1,
 1045511762,
 1045416406,
 8776,
 -1,
 1045433479,
 10863,
 -1,
 1045469327,
 8778,
 1045708374,
 1045415483,
 -1,
 -49579,
 1045655278,
 9095,
 -1,
 1045708986,
 9941,
 1045904985,
 1045656518,
 -1,
 -49576,
 1045842215,
 8780,
 -1,
 1045897808,
 9006,
 1046151167,
 1045840039,
 -1,
 -49573,
 1046053690,
 9879,
 -1,
 1046105819,
 8501,
 1046298212,
 1045346224,
 -1,
 1046363745,
 1046267434,
 -1,
 1046429280,
 1046311158,
 42,
 -1,
 1046349450,
 8727,
 -1,
 1046380616,
 8258,
 -49566,
 1046341335,
 8771,
 -49565,
 1046592094,
 8870,
 -1,
 1046621939,
 9738,
 1046822509,
 1046228227,
 -1,
 1046888040,
 1046796256,
 -1,
 -49561,
 1046842466,
 10655,
 -1,
 1046883985,
 180,
 1047084651,
 1046858156,
 -1,
 -49558,
 1047053076,
 8299,
 -1,
 1047077054,
 8301,
 -49556,
 1047016394,
 8448,
 -1,
 1047200541,
 9190,
 1047412336,
 1046773832,
 -1,
 -49553,
 1047372640,
 38,
 -1,
 1047403421,
 10815,
 1047608947,
 1047344684,
 -1,
 -49550,
 1047552548,
 9772,
 -1,
 1047609324,
 8449,
 -49548,
 1047582645,
 8371,
 -49547,
 1047775801,
 9883,
 -49546,
 1047832783,
 9810,
 -49545,
 1047884642,
 8525,
 -49544,
 1047948570,
 9992,
 -1,
 1048006721,
 1547,
 1048200075,
 916120768,
 -1,
 1048265610,
 1048142311,
 -1,
 1048331145,
 1048182784,
 -1,
 1048396603,
 1048298223,
 -1,
 1048461122,
 1048348994,
 -1,
 1048526492,
 1048438776,
 -1,
 1048592006,
 1048497902,
 41727,
 1048657538,
 1048553942,
 41730,
 -1,
 1048634326,
 41729,
 1048788612,
 1048613362,
 41721,
 -1,
 1048765398,
 41720,
 -49531,
 1048765398,
 41726,
 -1,
 1048879211,
 41728,
 1049050765,
 1048535527,
 41711,
 1049116298,
 1048985767,
 41714,
 -49527,
 1049093078,
 41713,
 -1,
 1049141355,
 41715,
 -49525,
 1049093078,
 41710,
 -49524,
 1049281400,
 41709,
 -1,
 1049337963,
 41712,
 1049509523,
 1049027776,
 41733,
 1049575056,
 1049471446,
 41736,
 -1,
 1049551830,
 41735,
 -49519,
 1049551830,
 41732,
 -49518,
 1049674616,
 41731,
 -1,
 1049731179,
 41734,
 1049902743,
 1049433486,
 41718,
 -49515,
 1049879510,
 41717,
 -49514,
 1049936760,
 41716,
 -1,
 1049993323,
 41719,
 1050164890,
 1049858546,
 -1,
 -49511,
 1050141654,
 41722,
 -1,
 1050189931,
 41723,
 1050411007,
 1050099879,
 41725,
 -1,
 1050338262,
 41724,
 1050492600,
 1048454811,
 -1,
 1050558116,
 1050436071,
 41080,
 1050623649,
 1050493095,
 41083,
 -49504,
 1050600406,
 41082,
 -1,
 1050648683,
 41084,
 -49502,
 1050600406,
 41079,
 -49501,
 1050788728,
 41078,
 -1,
 1050845291,
 41081,
 1051016874,
 1050535104,
 41101,
 1051082407,
 1050978774,
 41104,
 -1,
 1051059158,
 41103,
 -49496,
 1051059158,
 41100,
 -49495,
 1051181944,
 41099,
 -1,
 1051238507,
 41102,
 1051410096,
 1050988270,
 41095,
 1051475629,
 1051371990,
 41098,
 -1,
 1051452374,
 41097,
 -49490,
 1051452374,
 41094,
 -49489,
 1051575160,
 41093,
 -1,
 1051631723,
 41096,
 1051803316,
 1051365874,
 41091,
 -49486,
 1051780054,
 41090,
 -49485,
 1051837304,
 41089,
 -1,
 1051893867,
 41092,
 1052114943,
 1051727246,
 41087,
 -49482,
 1052042198,
 41086,
 -49481,
 1052099448,
 41085,
 -1,
 1052156011,
 41088,
 1052327634,
 1050439575,
 -1,
 1052393153,
 1052271079,
 42035,
 1052458686,
 1052328103,
 42039,
 -49476,
 1052435414,
 42038,
 -49475,
 1052492664,
 42037,
 -1,
 1052549227,
 42040,
 -49473,
 1052435414,
 42034,
 -49472,
 1052689272,
 42033,
 -1,
 1052745835,
 42036,
 1052917448,
 1052364526,
 42048,
 1052982980,
 1052879318,
 42051,
 -1,
 1052959702,
 42050,
 1053114054,
 1052938738,
 42042,
 -1,
 1053090774,
 42041,
 -49465,
 1053090774,
 42047,
 -1,
 1053204587,
 42049,
 1053376206,
 1052894400,
 42054,
 1053441739,
 1053338070,
 42057,
 -1,
 1053418454,
 42056,
 -49460,
 1053418454,
 42053,
 -49459,
 1053541240,
 42052,
 -1,
 1053597803,
 42055,
 1053818879,
 1053331954,
 42045,
 -49456,
 1053746134,
 42044,
 -49455,
 1053803384,
 42043,
 -1,
 1053859947,
 42046,
 1054031594,
 1052289494,
 -1,
 1054097113,
 1054008512,
 41895,
 1054162646,
 1054058966,
 41898,
 -1,
 1054139350,
 41897,
 -49449,
 1054139350,
 41894,
 -49448,
 1054262136,
 41893,
 -1,
 1054318699,
 41896,
 1054490335,
 1054068462,
 41889,
 1054555868,
 1054452182,
 41892,
 -1,
 1054532566,
 41891,
 -49443,
 1054532566,
 41888,
 -49442,
 1054655352,
 41887,
 -1,
 1054711915,
 41890,
 1054883555,
 1054425255,
 41885,
 -49439,
 1054860246,
 41884,
 -49438,
 1054917496,
 41883,
 -1,
 1054974059,
 41886,
 1055145703,
 1054807438,
 41878,
 -49435,
 1055122390,
 41877,
 -49434,
 1055179640,
 41876,
 -1,
 1055236203,
 41879,
 1055457279,
 1055101426,
 41881,
 -49431,
 1055384534,
 41880,
 -1,
 1055432811,
 41882,
 1055604482,
 1053963820,
 -1,
 1055670001,
 1055575790,
 41316,
 1055735534,
 1055631830,
 41319,
 -1,
 1055712214,
 41318,
 -49425,
 1055712214,
 41315,
 -49424,
 1055835000,
 41314,
 -1,
 1055891563,
 41317,
 1056063223,
 1055613415,
 41299,
 1056128756,
 1055998119,
 41302,
 -1,
 1056105430,
 41301,
 -49419,
 1056105430,
 41298,
 -49418,
 1056228216,
 41297,
 -1,
 1056284779,
 41300,
 1056456443,
 1056018930,
 41309,
 -49415,
 1056433110,
 41308,
 -49414,
 1056490360,
 41307,
 -1,
 1056546923,
 41310,
 1056718591,
 1056380302,
 41305,
 -49411,
 1056695254,
 41304,
 -49410,
 1056752504,
 41303,
 -1,
 1056809067,
 41306,
 1057030143,
 1056653479,
 41312,
 -49407,
 1056957398,
 41311,
 -1,
 1057005675,
 41313,
 1057177366,
 1055581376,
 -1,
 1057242891,
 1057120743,
 42060,
 1057308424,
 1057177767,
 42064,
 -49402,
 1057285078,
 42063,
 -49401,
 1057342328,
 42062,
 -1,
 1057398891,
 42065,
 -49399,
 1057285078,
 42059,
 -49398,
 1057538936,
 42058,
 -1,
 1057595499,
 42061,
 1057767186,
 1057214190,
 42075,
 1057832719,
 1057722866,
 42067,
 -49394,
 1057809366,
 42066,
 -1,
 1057857643,
 42068,
 -49392,
 1057809366,
 42074,
 -49391,
 1057997688,
 42073,
 -1,
 1058054251,
 42076,
 1058275327,
 1057722866,
 42071,
 -49388,
 1058202582,
 42070,
 -49387,
 1058259832,
 42069,
 -1,
 1058316395,
 42072,
 1058488104,
 1057116971,
 -1,
 1058553627,
 1058443762,
 41577,
 -49383,
 1058530262,
 41576,
 -49382,
 1058587512,
 41575,
 -1,
 1058644075,
 41578,
 1058815775,
 1058477454,
 41570,
 -49379,
 1058792406,
 41569,
 -49378,
 1058849656,
 41568,
 -1,
 1058906219,
 41571,
 1059077922,
 1058788248,
 41574,
 -49375,
 1059054550,
 41573,
 -1,
 1059111800,
 41572,
 1059274533,
 1059021976,
 41566,
 -49372,
 1059251158,
 41565,
 -1,
 1059299435,
 41567,
 1059520511,
 1059209383,
 41580,
 -49369,
 1059447766,
 41579,
 -1,
 1059496043,
 41581,
 1059667761,
 1058459374,
 41363,
 1059733292,
 1059623410,
 41352,
 -49365,
 1059709910,
 41351,
 -1,
 1059758187,
 41353,
 1059929902,
 1059695062,
 41366,
 -1,
 1059906518,
 41365,
 -49361,
 1059906518,
 41362,
 -49360,
 1060029304,
 41361,
 -1,
 1060085867,
 41364,
 1060257592,
 1059611111,
 41343,
 1060323125,
 1060192423,
 41346,
 -49356,
 1060299734,
 41345,
 -1,
 1060348011,
 41347,
 -49354,
 1060299734,
 41342,
 -49353,
 1060488056,
 41341,
 -1,
 1060544619,
 41344,
 1060716348,
 1060213234,
 41356,
 -49350,
 1060692950,
 41355,
 -49349,
 1060750200,
 41354,
 -1,
 1060806763,
 41357,
 1060978495,
 1060651175,
 41359,
 -49346,
 1060955094,
 41358,
 -1,
 1061003371,
 41360,
 1061224447,
 1060902286,
 41349,
 -49343,
 1061151702,
 41348,
 -1,
 1061199979,
 41350,
 1061371845,
 1048402163,
 -1,
 1061437284,
 1061319620,
 -1,
 1061502797,
 1061408494,
 41389,
 1061568328,
 1061458418,
 41379,
 -49337,
 1061544918,
 41378,
 -1,
 1061593195,
 41380,
 1061764938,
 1061530070,
 41392,
 -1,
 1061741526,
 41391,
 -49333,
 1061741526,
 41388,
 -49332,
 1061864312,
 41387,
 -1,
 1061920875,
 41390,
 1062092628,
 1061446119,
 41369,
 1062158161,
 1062027431,
 41372,
 -49328,
 1062134742,
 41371,
 -1,
 1062183019,
 41373,
 -49326,
 1062134742,
 41368,
 -49325,
 1062323064,
 41367,
 -1,
 1062379627,
 41370,
 1062551386,
 1062069440,
 41395,
 1062616919,
 1062513110,
 41398,
 -1,
 1062593494,
 41397,
 -49320,
 1062593494,
 41394,
 -49319,
 1062716280,
 41393,
 -1,
 1062772843,
 41396,
 1062944606,
 1062475150,
 41376,
 -49316,
 1062921174,
 41375,
 -49315,
 1062978424,
 41374,
 -1,
 1063034987,
 41377,
 1063206753,
 1062900210,
 41382,
 -49312,
 1063183318,
 41381,
 -1,
 1063231595,
 41383,
 1063452671,
 1063141543,
 41385,
 -49309,
 1063379926,
 41384,
 -1,
 1063428203,
 41386,
 1063600002,
 1061388360,
 -1,
 1063665518,
 1063571182,
 41125,
 1063731049,
 1063621106,
 41117,
 -49304,
 1063707606,
 41116,
 -1,
 1063755883,
 41118,
 1063927659,
 1063692758,
 41128,
 -1,
 1063904214,
 41127,
 -49300,
 1063904214,
 41124,
 -49299,
 1064027000,
 41123,
 -1,
 1064083563,
 41126,
 1064255349,
 1063608807,
 41107,
 1064320882,
 1064190119,
 41110,
 -49295,
 1064297430,
 41109,
 -1,
 1064345707,
 41111,
 -49293,
 1064297430,
 41106,
 -49292,
 1064485752,
 41105,
 -1,
 1064542315,
 41108,
 1064714106,
 1064232128,
 41130,
 1064779640,
 1064675798,
 41133,
 -1,
 1064756182,
 41132,
 -49287,
 1064756182,
 41129,
 -1,
 1064869995,
 41131,
 1065041790,
 1064669682,
 41121,
 -49284,
 1065018326,
 41120,
 -49283,
 1065075576,
 41119,
 -1,
 1065132139,
 41122,
 1065353215,
 1064965518,
 41114,
 -49280,
 1065280470,
 41113,
 -49279,
 1065337720,
 41112,
 -1,
 1065394283,
 41115,
 1065566106,
 1063576534,
 -1,
 1065631627,
 1065509351,
 41544,
 1065697160,
 1065566375,
 41548,
 -49274,
 1065673686,
 41547,
 -49273,
 1065730936,
 41546,
 -1,
 1065787499,
 41549,
 -49271,
 1065673686,
 41543,
 -49270,
 1065927544,
 41542,
 -1,
 1065984107,
 41545,
 1066155919,
 1065603992,
 41556,
 -49267,
 1066132438,
 41555,
 -49266,
 1066189688,
 41554,
 -1,
 1066246251,
 41557,
 1066418067,
 1066111474,
 41560,
 -49263,
 1066394582,
 41559,
 -49262,
 1066451832,
 41558,
 -1,
 1066508395,
 41561,
 1066680215,
 1066341774,
 41552,
 -49259,
 1066656726,
 41551,
 -49258,
 1066713976,
 41550,
 -1,
 1066770539,
 41553,
 1066991615,
 1066614951,
 41563,
 -49255,
 1066918870,
 41562,
 -1,
 1066967147,
 41564,
 1067138994,
 1065519426,
 -1,
 1067204515,
 1067082215,
 41322,
 1067270048,
 1067139239,
 41326,
 -49250,
 1067246550,
 41325,
 -49249,
 1067303800,
 41324,
 -1,
 1067360363,
 41327,
 -49247,
 1067246550,
 41321,
 -49246,
 1067500408,
 41320,
 -1,
 1067556971,
 41323,
 1067728807,
 1067128206,
 41330,
 -49243,
 1067705302,
 41329,
 -49242,
 1067762552,
 41328,
 -1,
 1067819115,
 41331,
 1067990955,
 1067699950,
 -1,
 1068056490,
 1067946482,
 41333,
 -1,
 1068032982,
 41332,
 -1,
 1068024696,
 41340,
 1068253103,
 1067946482,
 -1,
 -49235,
 1068229590,
 41335,
 -49234,
 1068286840,
 41334,
 -1,
 1068343403,
 41336,
 1068564479,
 1068187815,
 41338,
 -49231,
 1068491734,
 41337,
 -1,
 1068540011,
 41339,
 1068711862,
 1067111320,
 41591,
 -49228,
 1068688342,
 41590,
 -49227,
 1068745592,
 41589,
 -1,
 1068802155,
 41592,
 1068974010,
 1068667378,
 41595,
 -49224,
 1068950486,
 41594,
 -49223,
 1069007736,
 41593,
 -1,
 1069064299,
 41596,
 1069236158,
 1068897678,
 41587,
 -49220,
 1069212630,
 41586,
 -49219,
 1069269880,
 41585,
 -1,
 1069326443,
 41588,
 1069498306,
 1069179367,
 -1,
 1069563841,
 1069432999,
 41584,
 -1,
 1069540310,
 41583,
 -1,
 1069532024,
 41582,
 1069809663,
 1069432999,
 41598,
 -49212,
 1069736918,
 41597,
 -1,
 1069785195,
 41599,
 1069957153,
 1061349368,
 -1,
 1070022628,
 1069934584,
 -1,
 1070088143,
 1069965799,
 41682,
 1070153676,
 1070022823,
 41686,
 -49206,
 1070130134,
 41685,
 -49205,
 1070187384,
 41684,
 -1,
 1070243947,
 41687,
 -49203,
 1070130134,
 41681,
 -49202,
 1070383992,
 41680,
 -1,
 1070440555,
 41683,
 1070612437,
 1070064832,
 41705,
 1070677970,
 1070574038,
 41708,
 -1,
 1070654422,
 41707,
 -49197,
 1070654422,
 41704,
 -49196,
 1070777208,
 41703,
 -1,
 1070833771,
 41706,
 1071005658,
 1070583534,
 41699,
 1071071192,
 1070967254,
 41702,
 -1,
 1071047638,
 41701,
 -49191,
 1071047638,
 41698,
 -1,
 1071161451,
 41700,
 1071333342,
 1070929294,
 41690,
 -49188,
 1071309782,
 41689,
 -49187,
 1071367032,
 41688,
 -1,
 1071423595,
 41691,
 1071595489,
 1071288818,
 41693,
 -49184,
 1071571926,
 41692,
 -1,
 1071620203,
 41694,
 1071841279,
 1071530151,
 41696,
 -49181,
 1071768534,
 41695,
 -1,
 1071816811,
 41697,
 1071988736,
 1069963507,
 -1,
 1072054254,
 1071959790,
 41815,
 1072119785,
 1072009714,
 41803,
 -49176,
 1072096214,
 41802,
 -1,
 1072144491,
 41804,
 1072316395,
 1072081366,
 41818,
 -1,
 1072292822,
 41817,
 -49172,
 1072292822,
 41814,
 -49171,
 1072415608,
 41813,
 -1,
 1072472171,
 41816,
 1072644084,
 1072030912,
 41821,
 1072709617,
 1072605654,
 41824,
 -1,
 1072686038,
 41823,
 -49166,
 1072686038,
 41820,
 -49165,
 1072808824,
 41819,
 -1,
 1072865387,
 41822,
 1073037304,
 1072599538,
 41807,
 -49162,
 1073013718,
 41806,
 -49161,
 1073070968,
 41805,
 -1,
 1073127531,
 41808,
 1073299452,
 1072971943,
 41811,
 -49158,
 1073275862,
 41810,
 -49157,
 1073333112,
 41809,
 -1,
 1073389675,
 41812,
 1073610751,
 1073223054,
 41800,
 -49154,
 1073538006,
 41799,
 -49153,
 1073595256,
 41798,
 -1,
 1073651819,
 41801,
 1073823753,
 1071959790,
 41636,
 1073889284,
 1073779186,
 41625,
 -49149,
 1073865686,
 41624,
 -1,
 1073913963,
 41626,
 1074085894,
 1073850838,
 41639,
 -1,
 1074062294,
 41638,
 -49145,
 1074062294,
 41635,
 -49144,
 1074185080,
 41634,
 -1,
 1074241643,
 41637,
 1074413584,
 1073766887,
 41615,
 1074479117,
 1074348199,
 41618,
 -49140,
 1074455510,
 41617,
 -1,
 1074503787,
 41619,
 -49138,
 1074455510,
 41614,
 -49137,
 1074643832,
 41613,
 -1,
 1074700395,
 41616,
 1074872342,
 1074390208,
 41642,
 1074937875,
 1074833878,
 41645,
 -1,
 1074914262,
 41644,
 -49132,
 1074914262,
 41641,
 -49131,
 1075037048,
 41640,
 -1,
 1075093611,
 41643,
 1075265562,
 1074827762,
 41629,
 -49128,
 1075241942,
 41628,
 -49127,
 1075299192,
 41627,
 -1,
 1075355755,
 41630,
 1075527710,
 1075189134,
 41622,
 -49124,
 1075504086,
 41621,
 -49123,
 1075561336,
 41620,
 -1,
 1075617899,
 41623,
 1075838975,
 1075462311,
 41632,
 -49120,
 1075766230,
 41631,
 -1,
 1075814507,
 41633,
 1075986556,
 1069922224,
 -1,
 1076052031,
 1075951536,
 -1,
 1076117546,
 1075995111,
 41772,
 1076183079,
 1076052135,
 41775,
 -49114,
 1076159446,
 41774,
 -1,
 1076207723,
 41776,
 -49112,
 1076159446,
 41771,
 -49111,
 1076347768,
 41770,
 -1,
 1076404331,
 41773,
 1076576304,
 1076094144,
 41794,
 1076641837,
 1076537814,
 41797,
 -1,
 1076618198,
 41796,
 -49106,
 1076618198,
 41793,
 -49105,
 1076740984,
 41792,
 -1,
 1076797547,
 41795,
 1076969524,
 1076547310,
 41790,
 -49102,
 1076945878,
 41789,
 -49101,
 1077003128,
 41788,
 -1,
 1077059691,
 41791,
 1077231672,
 1076924914,
 41783,
 -49098,
 1077208022,
 41782,
 -49097,
 1077265272,
 41781,
 -1,
 1077321835,
 41784,
 1077493820,
 1077155214,
 41779,
 -49094,
 1077470166,
 41778,
 -49093,
 1077527416,
 41777,
 -1,
 1077583979,
 41780,
 1077805055,
 1077428391,
 41786,
 -49090,
 1077732310,
 41785,
 -1,
 1077780587,
 41787,
 1077952603,
 1075992819,
 -1,
 1078018121,
 1077923566,
 41916,
 1078083652,
 1077973490,
 41904,
 -49085,
 1078059990,
 41903,
 -1,
 1078108267,
 41905,
 1078280262,
 1078045142,
 41919,
 -1,
 1078256598,
 41918,
 -49081,
 1078256598,
 41915,
 -49080,
 1078379384,
 41914,
 -1,
 1078435947,
 41917,
 1078607951,
 1077994688,
 41922,
 1078673484,
 1078569430,
 41925,
 -1,
 1078649814,
 41924,
 -49075,
 1078649814,
 41921,
 -49074,
 1078772600,
 41920,
 -1,
 1078829163,
 41923,
 1079001171,
 1078563314,
 41908,
 -49071,
 1078977494,
 41907,
 -49070,
 1079034744,
 41906,
 -1,
 1079091307,
 41909,
 1079263319,
 1078935719,
 41912,
 -49067,
 1079239638,
 41911,
 -49066,
 1079296888,
 41910,
 -1,
 1079353451,
 41913,
 1079574527,
 1079186830,
 41901,
 -49063,
 1079501782,
 41900,
 -49062,
 1079559032,
 41899,
 -1,
 1079615595,
 41902,
 1079787620,
 1077923566,
 41760,
 1079853151,
 1079742962,
 41749,
 -49058,
 1079829462,
 41748,
 -1,
 1079877739,
 41750,
 1080049761,
 1079814614,
 41763,
 -1,
 1080026070,
 41762,
 -49054,
 1080026070,
 41759,
 -49053,
 1080148856,
 41758,
 -1,
 1080205419,
 41761,
 1080377451,
 1079730663,
 41739,
 1080442984,
 1080311975,
 41742,
 -49049,
 1080419286,
 41741,
 -1,
 1080467563,
 41743,
 -49047,
 1080419286,
 41738,
 -49046,
 1080607608,
 41737,
 -1,
 1080664171,
 41740,
 1080836209,
 1080353984,
 41766,
 1080901742,
 1080797654,
 41769,
 -1,
 1080878038,
 41768,
 -49041,
 1080878038,
 41765,
 -49040,
 1081000824,
 41764,
 -1,
 1081057387,
 41767,
 1081229429,
 1080791538,
 41753,
 -49037,
 1081205718,
 41752,
 -49036,
 1081262968,
 41751,
 -1,
 1081319531,
 41754,
 1081491577,
 1081152910,
 41746,
 -49033,
 1081467862,
 41745,
 -49032,
 1081525112,
 41744,
 -1,
 1081581675,
 41747,
 1081802751,
 1081426087,
 41756,
 -49029,
 1081730006,
 41755,
 -1,
 1081778283,
 41757,
 1081950400,
 1075914395,
 -1,
 1082015902,
 1081878171,
 -1,
 1082081415,
 1081986798,
 41070,
 1082146946,
 1082036722,
 41059,
 -49023,
 1082123222,
 41058,
 -1,
 1082171499,
 41060,
 1082343556,
 1082108374,
 41073,
 -1,
 1082319830,
 41072,
 -49019,
 1082319830,
 41069,
 -49018,
 1082442616,
 41068,
 -1,
 1082499179,
 41071,
 1082671247,
 1082024423,
 41048,
 1082736780,
 1082605735,
 41052,
 -49014,
 1082713046,
 41051,
 -49013,
 1082770296,
 41050,
 -1,
 1082826859,
 41053,
 -49011,
 1082713046,
 41047,
 -49010,
 1082966904,
 41046,
 -1,
 1083023467,
 41049,
 1083195539,
 1082647744,
 41076,
 -49007,
 1083171798,
 41075,
 -49006,
 1083229048,
 41074,
 -1,
 1083285611,
 41077,
 1083457687,
 1083150834,
 41063,
 -49003,
 1083433942,
 41062,
 -49002,
 1083491192,
 41061,
 -1,
 1083547755,
 41064,
 1083719835,
 1083381134,
 41056,
 -48999,
 1083696086,
 41055,
 -48998,
 1083753336,
 41054,
 -1,
 1083809899,
 41057,
 1084030975,
 1083654311,
 41066,
 -48995,
 1083958230,
 41065,
 -1,
 1084006507,
 41067,
 1084178599,
 1081986798,
 41006,
 1084244130,
 1084133874,
 40995,
 -48991,
 1084220374,
 40994,
 -1,
 1084268651,
 40996,
 1084440740,
 1084205526,
 41009,
 -1,
 1084416982,
 41008,
 -48987,
 1084416982,
 41005,
 -48986,
 1084539768,
 41004,
 -1,
 1084596331,
 41007,
 1084768431,
 1084121575,
 40984,
 1084833964,
 1084702887,
 40988,
 -48982,
 1084810198,
 40987,
 -48981,
 1084867448,
 40986,
 -1,
 1084924011,
 40989,
 -48979,
 1084810198,
 40983,
 -48978,
 1085064056,
 40982,
 -1,
 1085120619,
 40985,
 1085292725,
 1084744896,
 41012,
 1085358258,
 1085254102,
 41015,
 -1,
 1085334486,
 41014,
 -48973,
 1085334486,
 41011,
 -48972,
 1085457272,
 41010,
 -1,
 1085513835,
 41013,
 1085685945,
 1085247986,
 40999,
 -48969,
 1085662166,
 40998,
 -48968,
 1085719416,
 40997,
 -1,
 1085775979,
 41000,
 1085948093,
 1085609358,
 40992,
 -48965,
 1085924310,
 40991,
 -48964,
 1085981560,
 40990,
 -1,
 1086038123,
 40993,
 1086259199,
 1085882535,
 41002,
 -48961,
 1086186454,
 41001,
 -1,
 1086234731,
 41003,
 1086406911,
 1081879811,
 -1,
 1086472413,
 1086347507,
 -1,
 1086537931,
 1086443246,
 41842,
 1086603463,
 1086493170,
 41831,
 -48955,
 1086579670,
 41830,
 -48954,
 1086636920,
 41829,
 -1,
 1086693483,
 41832,
 1086865609,
 1086564822,
 41845,
 -1,
 1086841814,
 41844,
 -48950,
 1086841814,
 41841,
 -1,
 1086955627,
 41843,
 1087127761,
 1086514368,
 41848,
 1087193294,
 1087089110,
 41851,
 -1,
 1087169494,
 41850,
 -48945,
 1087169494,
 41847,
 -48944,
 1087292280,
 41846,
 -1,
 1087348843,
 41849,
 1087520981,
 1087082994,
 41835,
 -48941,
 1087497174,
 41834,
 -48940,
 1087554424,
 41833,
 -1,
 1087610987,
 41836,
 1087783129,
 1087455399,
 41839,
 -48937,
 1087759318,
 41838,
 -48936,
 1087816568,
 41837,
 -1,
 1087873131,
 41840,
 1088094207,
 1087706510,
 41827,
 -48933,
 1088021462,
 41826,
 -48932,
 1088078712,
 41825,
 -1,
 1088135275,
 41828,
 1088307430,
 1086443246,
 41670,
 1088372961,
 1088262642,
 41659,
 -48928,
 1088349142,
 41658,
 -1,
 1088397419,
 41660,
 1088569571,
 1088334294,
 41673,
 -1,
 1088545750,
 41672,
 -48924,
 1088545750,
 41669,
 -48923,
 1088668536,
 41668,
 -1,
 1088725099,
 41671,
 1088897262,
 1088250343,
 41648,
 1088962795,
 1088831655,
 41652,
 -48919,
 1088938966,
 41651,
 -48918,
 1088996216,
 41650,
 -1,
 1089052779,
 41653,
 -48916,
 1088938966,
 41647,
 -48915,
 1089192824,
 41646,
 -1,
 1089249387,
 41649,
 1089421556,
 1088873664,
 41676,
 1089487089,
 1089382870,
 41679,
 -1,
 1089463254,
 41678,
 -48910,
 1089463254,
 41675,
 -48909,
 1089586040,
 41674,
 -1,
 1089642603,
 41677,
 1089814776,
 1089376754,
 41663,
 -48906,
 1089790934,
 41662,
 -48905,
 1089848184,
 41661,
 -1,
 1089904747,
 41664,
 1090076924,
 1089738126,
 41656,
 -48902,
 1090053078,
 41655,
 -48901,
 1090110328,
 41654,
 -1,
 1090166891,
 41657,
 1090387967,
 1090011303,
 41666,
 -48898,
 1090315222,
 41665,
 -1,
 1090363499,
 41667,
 1090535739,
 1086346027,
 -1,
 1090601245,
 1090474795,
 -1,
 1090666763,
 1090572014,
 41516,
 1090732294,
 1090621938,
 41504,
 -48892,
 1090708438,
 41503,
 -48891,
 1090765688,
 41502,
 -1,
 1090822251,
 41505,
 1090994440,
 1090693590,
 41519,
 -1,
 1090970582,
 41518,
 -48887,
 1090970582,
 41515,
 -48886,
 1091093368,
 41514,
 -1,
 1091149931,
 41517,
 1091322129,
 1090609639,
 41494,
 1091387663,
 1091256487,
 41496,
 -48882,
 1091363798,
 41495,
 -1,
 1091412075,
 41497,
 -48880,
 1091363798,
 41493,
 -1,
 1091552120,
 41492,
 1091715349,
 1091277298,
 41508,
 -48877,
 1091691478,
 41507,
 -48876,
 1091748728,
 41506,
 -1,
 1091805291,
 41509,
 1091977497,
 1091649703,
 41512,
 -48873,
 1091953622,
 41511,
 -48872,
 1092010872,
 41510,
 -1,
 1092067435,
 41513,
 1092288511,
 1091900814,
 41500,
 -48869,
 1092215766,
 41499,
 -48868,
 1092273016,
 41498,
 -1,
 1092329579,
 41501,
 1092501799,
 1090572014,
 41460,
 1092567330,
 1092456946,
 41448,
 -48864,
 1092543446,
 41447,
 -48863,
 1092600696,
 41446,
 -1,
 1092657259,
 41449,
 1092829476,
 1092528598,
 41463,
 -1,
 1092805590,
 41462,
 -48859,
 1092805590,
 41459,
 -48858,
 1092928376,
 41458,
 -1,
 1092984939,
 41461,
 1093157167,
 1092444647,
 41436,
 1093222700,
 1093091495,
 41440,
 -48854,
 1093198806,
 41439,
 -48853,
 1093256056,
 41438,
 -1,
 1093312619,
 41441,
 -48851,
 1093198806,
 41435,
 -48850,
 1093452664,
 41434,
 -1,
 1093509227,
 41437,
 1093681459,
 1093112306,
 41452,
 -48847,
 1093657558,
 41451,
 -48846,
 1093714808,
 41450,
 -1,
 1093771371,
 41453,
 1093943607,
 1093615783,
 41456,
 -48843,
 1093919702,
 41455,
 -48842,
 1093976952,
 41454,
 -1,
 1094033515,
 41457,
 1094254591,
 1093866894,
 41444,
 -48839,
 1094181846,
 41443,
 -48838,
 1094239096,
 41442,
 -1,
 1094295659,
 41445,
 1094467954,
 1090486344,
 -1,
 1094533459,
 1094406955,
 -1,
 1094598982,
 1094504174,
 41538,
 1094664513,
 1094554098,
 41527,
 -48832,
 1094640598,
 41526,
 -1,
 1094688875,
 41528,
 1094861123,
 1094625750,
 41541,
 -1,
 1094837206,
 41540,
 -48828,
 1094837206,
 41537,
 -48827,
 1094959992,
 41536,
 -1,
 1095016555,
 41539,
 1095188810,
 1094554098,
 41531,
 -48824,
 1095164886,
 41530,
 -48823,
 1095222136,
 41529,
 -1,
 1095278699,
 41532,
 1095450958,
 1095112078,
 41524,
 -48820,
 1095427030,
 41523,
 -48819,
 1095484280,
 41522,
 -1,
 1095540843,
 41525,
 1095713105,
 1095385255,
 41534,
 -48816,
 1095689174,
 41533,
 -1,
 1095737451,
 41535,
 1095958527,
 1095656600,
 41521,
 -1,
 1095885782,
 41520,
 1096040797,
 1094504174,
 41157,
 1096106328,
 1095995890,
 41147,
 -48810,
 1096082390,
 41146,
 -48809,
 1096139640,
 41145,
 -1,
 1096196203,
 41148,
 1096368474,
 1096067542,
 41160,
 -1,
 1096344534,
 41159,
 -48805,
 1096344534,
 41156,
 -48804,
 1096467320,
 41155,
 -1,
 1096523883,
 41158,
 1096696164,
 1095983591,
 41136,
 1096761697,
 1096630439,
 41139,
 -48800,
 1096737750,
 41138,
 -1,
 1096786027,
 41140,
 -48798,
 1096737750,
 41135,
 -48797,
 1096926072,
 41134,
 -1,
 1096982635,
 41137,
 1097154920,
 1096672448,
 41163,
 -48794,
 1097130966,
 41162,
 -48793,
 1097188216,
 41161,
 -1,
 1097244779,
 41164,
 1097417068,
 1097110002,
 41151,
 -48790,
 1097393110,
 41150,
 -48789,
 1097450360,
 41149,
 -1,
 1097506923,
 41152,
 1097679216,
 1097340302,
 41143,
 -48786,
 1097655254,
 41142,
 -48785,
 1097712504,
 41141,
 -1,
 1097769067,
 41144,
 1097990143,
 1097613479,
 41154,
 -1,
 1097917398,
 41153,
 1098072489,
 1094414231,
 -1,
 1098137997,
 1098018711,
 -1,
 1098203517,
 1098108654,
 42025,
 1098269048,
 1098158578,
 42017,
 -48777,
 1098245078,
 42016,
 -1,
 1098293355,
 42018,
 1098465658,
 1098230230,
 42028,
 -1,
 1098441686,
 42027,
 -48773,
 1098441686,
 42024,
 -48772,
 1098564472,
 42023,
 -1,
 1098621035,
 42026,
 1098793349,
 1098146279,
 42010,
 1098858882,
 1098727591,
 42014,
 -48768,
 1098834902,
 42013,
 -48767,
 1098892152,
 42012,
 -1,
 1098948715,
 42015,
 -48765,
 1098834902,
 42009,
 -48764,
 1099088760,
 42008,
 -1,
 1099145323,
 42011,
 1099317641,
 1098769600,
 42031,
 -48761,
 1099293654,
 42030,
 -48760,
 1099350904,
 42029,
 -1,
 1099407467,
 42032,
 1099628543,
 1099272690,
 42021,
 -48757,
 1099555798,
 42020,
 -48756,
 1099613048,
 42019,
 -1,
 1099669611,
 42022,
 1099841943,
 1098108654,
 41970,
 1099907474,
 1099796978,
 41962,
 -48752,
 1099883478,
 41961,
 -48751,
 1099940728,
 41960,
 -1,
 1099997291,
 41963,
 1100169620,
 1099868630,
 41973,
 -1,
 1100145622,
 41972,
 -48747,
 1100145622,
 41969,
 -48746,
 1100268408,
 41968,
 -1,
 1100324971,
 41971,
 1100497311,
 1099784679,
 41954,
 1100562844,
 1100431527,
 41958,
 -48742,
 1100538838,
 41957,
 -48741,
 1100596088,
 41956,
 -1,
 1100652651,
 41959,
 -48739,
 1100538838,
 41953,
 -48738,
 1100792696,
 41952,
 -1,
 1100849259,
 41955,
 1101021605,
 1100473536,
 41976,
 1101087138,
 1100982742,
 41979,
 -1,
 1101063126,
 41978,
 -48733,
 1101063126,
 41975,
 -48732,
 1101185912,
 41974,
 -1,
 1101242475,
 41977,
 1101463551,
 1100976626,
 41966,
 -48729,
 1101390806,
 41965,
 -48728,
 1101448056,
 41964,
 -1,
 1101504619,
 41967,
 1101677024,
 1098004012,
 -1,
 1101742534,
 1101608492,
 -1,
 1101808052,
 1101713134,
 41293,
 1101873583,
 1101763058,
 41282,
 -48722,
 1101849558,
 41281,
 -1,
 1101897835,
 41283,
 1102070193,
 1101834710,
 41296,
 -1,
 1102046166,
 41295,
 -48718,
 1102046166,
 41292,
 -48717,
 1102168952,
 41291,
 -1,
 1102225515,
 41294,
 1102397883,
 1101750759,
 41272,
 1102463416,
 1102332071,
 41275,
 -48713,
 1102439382,
 41274,
 -1,
 1102487659,
 41276,
 -48711,
 1102439382,
 41271,
 -48710,
 1102627704,
 41270,
 -1,
 1102684267,
 41273,
 1102856639,
 1102352882,
 41286,
 -48707,
 1102832598,
 41285,
 -48706,
 1102889848,
 41284,
 -1,
 1102946411,
 41287,
 1103118787,
 1102779790,
 41279,
 -48703,
 1103094742,
 41278,
 -48702,
 1103151992,
 41277,
 -1,
 1103208555,
 41280,
 1103429631,
 1103052967,
 41289,
 -48699,
 1103356886,
 41288,
 -1,
 1103405163,
 41290,
 1103577550,
 1101713134,
 41238,
 1103643081,
 1103538646,
 41241,
 -1,
 1103619030,
 41240,
 1103774155,
 1103598066,
 41228,
 -1,
 1103750102,
 41227,
 -48692,
 1103750102,
 41237,
 -48691,
 1103872888,
 41236,
 -1,
 1103929451,
 41239,
 1104101845,
 1103520231,
 41218,
 1104167378,
 1104036007,
 41221,
 -48687,
 1104143318,
 41220,
 -1,
 1104191595,
 41222,
 -48685,
 1104143318,
 41217,
 -48684,
 1104331640,
 41216,
 -1,
 1104388203,
 41219,
 1104560601,
 1104056818,
 41231,
 -48681,
 1104536534,
 41230,
 -48680,
 1104593784,
 41229,
 -1,
 1104650347,
 41232,
 1104822749,
 1104483726,
 41225,
 -48677,
 1104798678,
 41224,
 -48676,
 1104855928,
 41223,
 -1,
 1104912491,
 41226,
 1105133567,
 1104756903,
 41234,
 -48673,
 1105060822,
 41233,
 -1,
 1105109099,
 41235,
 1105281556,
 1101638102,
 -1,
 1105347066,
 1105242582,
 -1,
 1105412586,
 1105317614,
 41866,
 1105478117,
 1105373654,
 41869,
 -1,
 1105454038,
 41868,
 1105609191,
 1105433074,
 41855,
 -1,
 1105585110,
 41854,
 -48664,
 1105585110,
 41865,
 -48663,
 1105707896,
 41864,
 -1,
 1105764459,
 41867,
 1105936880,
 1105388736,
 41872,
 1106002413,
 1105897942,
 41875,
 -1,
 1105978326,
 41874,
 -48658,
 1105978326,
 41871,
 -48657,
 1106101112,
 41870,
 -1,
 1106157675,
 41873,
 1106330100,
 1105891826,
 41858,
 -48654,
 1106306006,
 41857,
 -48653,
 1106363256,
 41856,
 -1,
 1106419819,
 41859,
 1106592248,
 1106264231,
 41862,
 -48650,
 1106568150,
 41861,
 -48649,
 1106625400,
 41860,
 -1,
 1106681963,
 41863,
 1106903039,
 1106515342,
 41853,
 -1,
 1106830294,
 41852,
 1106985475,
 1105317614,
 41942,
 1107051006,
 1106940402,
 41931,
 -48643,
 1107026902,
 41930,
 -1,
 1107075179,
 41932,
 1107247616,
 1107012054,
 41945,
 -1,
 1107223510,
 41944,
 -48639,
 1107223510,
 41941,
 -48638,
 1107346296,
 41940,
 -1,
 1107402859,
 41943,
 1107575305,
 1106961600,
 41948,
 1107640838,
 1107536342,
 41951,
 -1,
 1107616726,
 41950,
 -48633,
 1107616726,
 41947,
 -48632,
 1107739512,
 41946,
 -1,
 1107796075,
 41949,
 1107968525,
 1107530226,
 41935,
 -48629,
 1107944406,
 41934,
 -48628,
 1108001656,
 41933,
 -1,
 1108058219,
 41936,
 1108230673,
 1107891598,
 41928,
 -48625,
 1108206550,
 41927,
 -48624,
 1108263800,
 41926,
 -1,
 1108320363,
 41929,
 1108541439,
 1108164775,
 41938,
 -48621,
 1108468694,
 41937,
 -1,
 1108516971,
 41939,
 1108689464,
 1105228740,
 -1,
 1108754975,
 1108659950,
 41424,
 1108820506,
 1108709874,
 41413,
 -48616,
 1108796374,
 41412,
 -48615,
 1108853624,
 41411,
 -1,
 1108910187,
 41414,
 1109082652,
 1108781526,
 41427,
 -1,
 1109058518,
 41426,
 -48611,
 1109058518,
 41423,
 -48610,
 1109181304,
 41422,
 -1,
 1109237867,
 41425,
 1109410343,
 1108697575,
 41401,
 1109475876,
 1109344423,
 41405,
 -48606,
 1109451734,
 41404,
 -48605,
 1109508984,
 41403,
 -1,
 1109565547,
 41406,
 -48603,
 1109451734,
 41400,
 -48602,
 1109705592,
 41399,
 -1,
 1109762155,
 41402,
 1109934637,
 1109386432,
 41430,
 1110000170,
 1109895638,
 41433,
 -1,
 1109976022,
 41432,
 -48597,
 1109976022,
 41429,
 -48596,
 1110098808,
 41428,
 -1,
 1110155371,
 41431,
 1110327857,
 1109889522,
 41417,
 -48593,
 1110303702,
 41416,
 -48592,
 1110360952,
 41415,
 -1,
 1110417515,
 41418,
 1110590005,
 1110250894,
 41409,
 -48589,
 1110565846,
 41408,
 -48588,
 1110623096,
 41407,
 -1,
 1110679659,
 41410,
 1110900735,
 1110524071,
 41420,
 -48585,
 1110827990,
 41419,
 -1,
 1110876267,
 41421,
 1111048792,
 1108662374,
 -1,
 1111114305,
 1110991335,
 41188,
 1111179838,
 1111048359,
 41192,
 -48580,
 1111155670,
 41191,
 -48579,
 1111212920,
 41190,
 -1,
 1111269483,
 41193,
 -48577,
 1111155670,
 41187,
 -48576,
 1111409528,
 41186,
 -1,
 1111466091,
 41189,
 1111638599,
 1111090368,
 41212,
 1111704132,
 1111599574,
 41215,
 -1,
 1111679958,
 41214,
 -48571,
 1111679958,
 41211,
 -48570,
 1111802744,
 41210,
 -1,
 1111859307,
 41213,
 1112031821,
 1111609070,
 41206,
 1112097354,
 1111992790,
 41209,
 -1,
 1112073174,
 41208,
 -48565,
 1112073174,
 41205,
 -48564,
 1112195960,
 41204,
 -1,
 1112252523,
 41207,
 1112425041,
 1111986674,
 41200,
 -48561,
 1112400854,
 41199,
 -48560,
 1112458104,
 41198,
 -1,
 1112514667,
 41201,
 1112687189,
 1112348046,
 41196,
 -48557,
 1112662998,
 41195,
 -48556,
 1112720248,
 41194,
 -1,
 1112776811,
 41197,
 1112997887,
 1112621223,
 -1,
 -48553,
 1112925142,
 41202,
 -1,
 1112973419,
 41203,
 1113145975,
 1111007339,
 -1,
 1113211490,
 1113116398,
 41036,
 1113277021,
 1113166322,
 41028,
 -48548,
 1113252822,
 41027,
 -1,
 1113301099,
 41029,
 1113473631,
 1113237974,
 41039,
 -1,
 1113449430,
 41038,
 -48544,
 1113449430,
 41035,
 -48543,
 1113572216,
 41034,
 -1,
 1113628779,
 41037,
 1113801321,
 1113154023,
 41018,
 1113866854,
 1113735335,
 41021,
 -48539,
 1113842646,
 41020,
 -1,
 1113890923,
 41022,
 -48537,
 1113842646,
 41017,
 -48536,
 1114030968,
 41016,
 -1,
 1114087531,
 41019,
 1114260079,
 1113777344,
 41042,
 1114325612,
 1114221014,
 41045,
 -1,
 1114301398,
 41044,
 -48531,
 1114301398,
 41041,
 -48530,
 1114424184,
 41040,
 -1,
 1114480747,
 41043,
 1114653299,
 1114214898,
 41032,
 -48527,
 1114629078,
 41031,
 -48526,
 1114686328,
 41030,
 -1,
 1114742891,
 41033,
 1114963967,
 1114576270,
 41025,
 -48523,
 1114891222,
 41024,
 -48522,
 1114948472,
 41023,
 -1,
 1115005035,
 41026,
 1115177620,
 1113121984,
 -1,
 1115243138,
 1115148014,
 42115,
 1115308669,
 1115197938,
 42107,
 -48517,
 1115284438,
 42106,
 -48516,
 1115341688,
 42105,
 -1,
 1115398251,
 42108,
 1115570815,
 1115269590,
 42118,
 -1,
 1115546582,
 42117,
 -48512,
 1115546582,
 42114,
 -48511,
 1115669368,
 42113,
 -1,
 1115725931,
 42116,
 1115898506,
 1115185639,
 42099,
 1115964039,
 1115832487,
 42103,
 -48507,
 1115939798,
 42102,
 -48506,
 1115997048,
 42101,
 -1,
 1116053611,
 42104,
 -48504,
 1115939798,
 42098,
 -48503,
 1116193656,
 42097,
 -1,
 1116250219,
 42100,
 1116422800,
 1115874496,
 42121,
 1116488333,
 1116383702,
 42124,
 -1,
 1116464086,
 42123,
 -48498,
 1116464086,
 42120,
 -48497,
 1116586872,
 42119,
 -1,
 1116643435,
 42122,
 1116864511,
 1116377586,
 42111,
 -48494,
 1116791766,
 42110,
 -48493,
 1116849016,
 42109,
 -1,
 1116905579,
 42112,
 1117078193,
 1115145080,
 -1,
 1117143711,
 1117048558,
 41266,
 1117209242,
 1117098482,
 41255,
 -48488,
 1117184982,
 41254,
 -48487,
 1117242232,
 41253,
 -1,
 1117298795,
 41256,
 1117471388,
 1117170134,
 41269,
 -1,
 1117447126,
 41268,
 -48483,
 1117447126,
 41265,
 -48482,
 1117569912,
 41264,
 -1,
 1117626475,
 41267,
 1117799078,
 1117086183,
 41244,
 1117864611,
 1117733031,
 41247,
 -48478,
 1117840342,
 41246,
 -1,
 1117888619,
 41248,
 -48476,
 1117840342,
 41243,
 -48475,
 1118028664,
 41242,
 -1,
 1118085227,
 41245,
 1118257834,
 1117753842,
 41259,
 -48472,
 1118233558,
 41258,
 -48471,
 1118290808,
 41257,
 -1,
 1118347371,
 41260,
 1118519982,
 1118180750,
 41251,
 -48468,
 1118495702,
 41250,
 -48467,
 1118552952,
 41249,
 -1,
 1118609515,
 41252,
 1118830591,
 1118453927,
 41262,
 -48464,
 1118757846,
 41261,
 -1,
 1118806123,
 41263,
 1118978766,
 1117038534,
 -1,
 1119044284,
 1118949102,
 41998,
 1119109815,
 1118999026,
 41990,
 -48459,
 1119085526,
 41989,
 -48458,
 1119142776,
 41988,
 -1,
 1119199339,
 41991,
 1119371961,
 1119070678,
 42001,
 -1,
 1119347670,
 42000,
 -48454,
 1119347670,
 41997,
 -48453,
 1119470456,
 41996,
 -1,
 1119527019,
 41999,
 1119699652,
 1118986727,
 41982,
 1119765185,
 1119633575,
 41986,
 -48449,
 1119740886,
 41985,
 -48448,
 1119798136,
 41984,
 -1,
 1119854699,
 41987,
 -48446,
 1119740886,
 41981,
 -48445,
 1119994744,
 41980,
 -1,
 1120051307,
 41983,
 1120223946,
 1119675584,
 42004,
 1120289479,
 1120184790,
 42007,
 -1,
 1120265174,
 42006,
 -48440,
 1120265174,
 42003,
 -48439,
 1120387960,
 42002,
 -1,
 1120444523,
 42005,
 1120665599,
 1120178674,
 41994,
 -48436,
 1120592854,
 41993,
 -48435,
 1120650104,
 41992,
 -1,
 1120706667,
 41995,
 1120879339,
 1118925046,
 -1,
 1120944856,
 1120849646,
 41488,
 1121010387,
 1120899570,
 41476,
 -48430,
 1120986070,
 41475,
 -1,
 1121034347,
 41477,
 1121206997,
 1120971222,
 41491,
 -1,
 1121182678,
 41490,
 -48426,
 1121182678,
 41487,
 -48425,
 1121305464,
 41486,
 -1,
 1121362027,
 41489,
 1121534687,
 1120887271,
 41466,
 1121600220,
 1121468583,
 41469,
 -48421,
 1121575894,
 41468,
 -1,
 1121624171,
 41470,
 -48419,
 1121575894,
 41465,
 -48418,
 1121764216,
 41464,
 -1,
 1121820779,
 41467,
 1121993443,
 1121489394,
 41480,
 -48415,
 1121969110,
 41479,
 -48414,
 1122026360,
 41478,
 -1,
 1122082923,
 41481,
 1122255591,
 1121927335,
 41484,
 -48411,
 1122231254,
 41483,
 -48410,
 1122288504,
 41482,
 -1,
 1122345067,
 41485,
 1122566143,
 1122178446,
 41473,
 -48407,
 1122493398,
 41472,
 -48406,
 1122550648,
 41471,
 -1,
 1122607211,
 41474,
 1122779905,
 1120816798,
 -1,
 1122845426,
 1122750190,
 41178,
 1122910959,
 1122806230,
 41181,
 -1,
 1122886614,
 41180,
 -48400,
 1122886614,
 41177,
 -48399,
 1123009400,
 41176,
 -1,
 1123065963,
 41179,
 1123238646,
 1122821312,
 41184,
 -48396,
 1123214294,
 41183,
 -48395,
 1123271544,
 41182,
 -1,
 1123328107,
 41185,
 1123500794,
 1123181031,
 41167,
 -48392,
 1123476438,
 41166,
 -48391,
 1123533688,
 41165,
 -1,
 1123590251,
 41168,
 1123762942,
 1123423630,
 41171,
 -48388,
 1123738582,
 41170,
 -48387,
 1123795832,
 41169,
 -1,
 1123852395,
 41172,
 1124073471,
 1123717618,
 41174,
 -48384,
 1124000726,
 41173,
 -1,
 1124049003,
 41175,
 1124221718,
 1122755542,
 -1,
 1124287242,
 1124164071,
 42079,
 1124352775,
 1124221095,
 42083,
 -48379,
 1124328406,
 42082,
 -48378,
 1124385656,
 42081,
 -1,
 1124442219,
 42084,
 -48376,
 1124328406,
 42078,
 -48375,
 1124582264,
 42077,
 -1,
 1124638827,
 42080,
 1124811536,
 1124263104,
 42093,
 1124877069,
 1124772310,
 42096,
 -1,
 1124852694,
 42095,
 -48370,
 1124852694,
 42092,
 -48369,
 1124975480,
 42091,
 -1,
 1125032043,
 42094,
 1125204756,
 1124766194,
 42089,
 -48366,
 1125180374,
 42088,
 -48365,
 1125237624,
 42087,
 -1,
 1125294187,
 42090,
 1125515263,
 1125176216,
 42086,
 -1,
 1125442518,
 42085,
 1125597989,
 1124195802,
 -1,
 1125663515,
 1125568238,
 40981,
 1125777407,
 1125618162,
 41605,
 -48358,
 1125704662,
 41604,
 -1,
 1125752939,
 41606,
 1125925663,
 1125586318,
 41602,
 -48355,
 1125901270,
 41601,
 -48354,
 1125958520,
 41600,
 -1,
 1126015083,
 41603,
 1126187810,
 1125880306,
 41608,
 -48351,
 1126163414,
 41607,
 -1,
 1126211691,
 41609,
 1126432767,
 1126121639,
 41611,
 -48348,
 1126360022,
 41610,
 -1,
 1126408299,
 41612,
 1126581038,
 1125540327,
 40962,
 1126646570,
 1126514855,
 40966,
 -48344,
 1126622166,
 40965,
 -48343,
 1126679416,
 40964,
 -1,
 1126735979,
 40967,
 1126908716,
 1126613880,
 40960,
 -1,
 1126844854,
 983048,
 -48339,
 1126884310,
 40961,
 -1,
 1126998123,
 40963,
 1127170866,
 1126535666,
 40977,
 -48336,
 1127146454,
 40976,
 -48335,
 1127203704,
 40975,
 -1,
 1127260267,
 40978,
 1127433014,
 1127093646,
 40970,
 -48332,
 1127408598,
 40969,
 -48331,
 1127465848,
 40968,
 -1,
 1127522411,
 40971,
 1127695161,
 1127404440,
 40973,
 -48328,
 1127670742,
 40972,
 -1,
 1127719019,
 40974,
 1127940095,
 1127628967,
 40980,
 -1,
 1127867350,
 40979,
 1128071167,
 1048357494,
 -1,
 1128088387,
 1127951619,
 -1,
 1128153920,
 1128064192,
 42172,
 -48321,
 1128121208,
 42147,
 -1,
 1128177771,
 42132,
 -48319,
 1128125348,
 42173,
 -48318,
 1128295464,
 42174,
 -1,
 1128356752,
 42179,
 1128547146,
 1128065016,
 -1,
 1128612679,
 1128517358,
 -1,
 -48314,
 1128573398,
 42177,
 -1,
 1128636523,
 42146,
 -48312,
 1128589541,
 42180,
 -48311,
 1128766156,
 42155,
 -1,
 1128797582,
 42162,
 1129005905,
 1128511408,
 -1,
 1129071440,
 1128945907,
 -1,
 -48307,
 1129047232,
 42160,
 -48306,
 1129109027,
 42170,
 -48305,
 1129158510,
 42178,
 -1,
 1129194641,
 42176,
 -1,
 1129036909,
 42133,
 1129464664,
 1128944427,
 -1,
 1129530197,
 1129403179,
 -1,
 -48300,
 1129501592,
 42150,
 -1,
 1129551726,
 42134,
 -48298,
 1129487052,
 42166,
 -48297,
 1129662643,
 42135,
 -1,
 1129715086,
 42145,
 1129923422,
 1129417026,
 -1,
 1129988956,
 1129899200,
 -1,
 -48293,
 1129944942,
 42151,
 -1,
 1129999400,
 42131,
 -48291,
 1129965870,
 42164,
 -1,
 1130113401,
 42181,
 1130316644,
 1129869207,
 -1,
 1130382179,
 1130262423,
 -1,
 -48287,
 1130357952,
 42165,
 -48286,
 1130420161,
 42154,
 -1,
 1130456216,
 42167,
 -1,
 1130336754,
 42163,
 1130709866,
 1130256627,
 -1,
 1130775401,
 1130685398,
 -1,
 -48281,
 1130746776,
 42143,
 -48280,
 1130796910,
 42175,
 -1,
 1130851821,
 42137,
 -1,
 1130727063,
 42157,
 1131103086,
 1130656708,
 -1,
 1131168621,
 1131045351,
 42129,
 -1,
 1131102375,
 42171,
 -1,
 1131145068,
 42138,
 1131365233,
 1131078848,
 -1,
 -48272,
 1131319794,
 42141,
 -1,
 1131376109,
 42158,
 1131561844,
 1131337830,
 -1,
 -48269,
 1131533859,
 42159,
 -1,
 1131563187,
 42161,
 1131758455,
 1131529080,
 -1,
 -48266,
 1131728622,
 42152,
 -1,
 1131750545,
 42144,
 1131955066,
 1131716715,
 -1,
 -48263,
 1131931566,
 42156,
 -1,
 1131993025,
 42142,
 1132151677,
 1131905096,
 -1,
 -48260,
 1132107630,
 42140,
 -1,
 1132159463,
 42136,
 1132348288,
 1132097782,
 -1,
 -48257,
 1132293613,
 42130,
 -1,
 1132347559,
 42182,
 1132544899,
 1132279340,
 -1,
 -48254,
 1132515054,
 42169,
 -1,
 1132544118,
 42148,
 1132741510,
 1132471963,
 -1,
 -48251,
 1132713507,
 42149,
 -1,
 1132735620,
 42139,
 -48249,
 1132716641,
 42168,
 -48248,
 1132898367,
 42128,
 -1,
 1132959598,
 42153,
 -1,
 1048283510,
 9775,
 -1,
 1048201024,
 165,
 1133267361,
 1048127131,
 -1,
 1133331603,
 1133226454,
 -1,
 1133397135,
 1133255026,
 -1,
 1133462670,
 1133329402,
 -1,
 1133528079,
 1133384233,
 10241,
 1133593552,
 1133449921,
 10243,
 1133659057,
 1133515622,
 10247,
 1133724578,
 1133581270,
 10255,
 1133790107,
 1133646883,
 10271,
 1133855640,
 1133712539,
 10303,
 1133921175,
 1133778144,
 10367,
 -1,
 1133843751,
 10495,
 -1,
 1133843751,
 10431,
 1134117786,
 1133778144,
 10335,
 -1,
 1134040359,
 10463,
 -1,
 1134040359,
 10399,
 1134314399,
 1133712539,
 10287,
 1134379934,
 1134236896,
 10351,
 -1,
 1134302503,
 10479,
 -1,
 1134302503,
 10415,
 1134576545,
 1134236896,
 10319,
 -1,
 1134499111,
 10447,
 -1,
 1134499111,
 10383,
 1134773162,
 1133646883,
 10263,
 1134838695,
 1134695579,
 10295,
 1134904230,
 1134761184,
 10359,
 -1,
 1134826791,
 10487,
 -1,
 1134826791,
 10423,
 1135100841,
 1134761184,
 10327,
 -1,
 1135023399,
 10455,
 -1,
 1135023399,
 10391,
 1135297454,
 1134695579,
 10279,
 1135362989,
 1135219936,
 10343,
 -1,
 1135285543,
 10471,
 -1,
 1135285543,
 10407,
 1135559600,
 1135219936,
 10311,
 -1,
 1135482151,
 10439,
 -1,
 1135482151,
 10375,
 1135756225,
 1133581270,
 10251,
 1135821754,
 1135678499,
 10267,
 1135887287,
 1135744155,
 10299,
 1135952822,
 1135809760,
 10363,
 -1,
 1135875367,
 10491,
 -1,
 1135875367,
 10427,
 1136149433,
 1135809760,
 10331,
 -1,
 1136071975,
 10459,
 -1,
 1136071975,
 10395,
 1136346046,
 1135744155,
 10283,
 1136411581,
 1136268512,
 10347,
 -1,
 1136334119,
 10475,
 -1,
 1136334119,
 10411,
 1136608192,
 1136268512,
 10315,
 -1,
 1136530727,
 10443,
 -1,
 1136530727,
 10379,
 1136804809,
 1135678499,
 10259,
 1136870342,
 1136727195,
 10291,
 1136935877,
 1136792800,
 10355,
 -1,
 1136858407,
 10483,
 -1,
 1136858407,
 10419,
 1137132488,
 1136792800,
 10323,
 -1,
 1137055015,
 10451,
 -1,
 1137055015,
 10387,
 1137329101,
 1136727195,
 10275,
 1137394636,
 1137251552,
 10339,
 -1,
 1137317159,
 10467,
 -1,
 1137317159,
 10403,
 1137591247,
 1137251552,
 10307,
 -1,
 1137513767,
 10435,
 -1,
 1137513767,
 10371,
 1137787888,
 1133515622,
 10245,
 1137853409,
 1137710038,
 10253,
 1137918938,
 1137775651,
 10269,
 1137984471,
 1137841307,
 10301,
 1138050006,
 1137906912,
 10365,
 -1,
 1137972519,
 10493,
 -1,
 1137972519,
 10429,
 1138246617,
 1137906912,
 10333,
 -1,
 1138169127,
 10461,
 -1,
 1138169127,
 10397,
 1138443230,
 1137841307,
 10285,
 1138508765,
 1138365664,
 10349,
 -1,
 1138431271,
 10477,
 -1,
 1138431271,
 10413,
 1138705376,
 1138365664,
 10317,
 -1,
 1138627879,
 10445,
 -1,
 1138627879,
 10381,
 1138901993,
 1137775651,
 10261,
 1138967526,
 1138824347,
 10293,
 1139033061,
 1138889952,
 10357,
 -1,
 1138955559,
 10485,
 -1,
 1138955559,
 10421,
 1139229672,
 1138889952,
 10325,
 -1,
 1139152167,
 10453,
 -1,
 1139152167,
 10389,
 1139426285,
 1138824347,
 10277,
 1139491820,
 1139348704,
 10341,
 -1,
 1139414311,
 10469,
 -1,
 1139414311,
 10405,
 1139688431,
 1139348704,
 10309,
 -1,
 1139610919,
 10437,
 -1,
 1139610919,
 10373,
 1139885056,
 1137710038,
 10249,
 1139950585,
 1139807267,
 10265,
 1140016118,
 1139872923,
 10297,
 1140081653,
 1139938528,
 10361,
 -1,
 1140004135,
 10489,
 -1,
 1140004135,
 10425,
 1140278264,
 1139938528,
 10329,
 -1,
 1140200743,
 10457,
 -1,
 1140200743,
 10393,
 1140474877,
 1139872923,
 10281,
 1140540412,
 1140397280,
 10345,
 -1,
 1140462887,
 10473,
 -1,
 1140462887,
 10409,
 1140737023,
 1140397280,
 10313,
 -1,
 1140659495,
 10441,
 -1,
 1140659495,
 10377,
 1140933640,
 1139807267,
 10257,
 1140999173,
 1140855963,
 10289,
 1141064708,
 1140921568,
 10353,
 -1,
 1140987175,
 10481,
 -1,
 1140987175,
 10417,
 1141261319,
 1140921568,
 10321,
 -1,
 1141183783,
 10449,
 -1,
 1141183783,
 10385,
 1141457932,
 1140855963,
 10273,
 1141523467,
 1141380320,
 10337,
 -1,
 1141445927,
 10465,
 -1,
 1141445927,
 10401,
 1141720078,
 1141380320,
 10305,
 -1,
 1141642535,
 10433,
 -1,
 1141642535,
 10369,
 1141916751,
 1133449921,
 10242,
 1141982256,
 1141838694,
 10246,
 1142047777,
 1141904342,
 10254,
 1142113306,
 1141969955,
 10270,
 1142178839,
 1142035611,
 10302,
 1142244374,
 1142101216,
 10366,
 -1,
 1142166823,
 10494,
 -1,
 1142166823,
 10430,
 1142440985,
 1142101216,
 10334,
 -1,
 1142363431,
 10462,
 -1,
 1142363431,
 10398,
 1142637598,
 1142035611,
 10286,
 1142703133,
 1142559968,
 10350,
 -1,
 1142625575,
 10478,
 -1,
 1142625575,
 10414,
 1142899744,
 1142559968,
 10318,
 -1,
 1142822183,
 10446,
 -1,
 1142822183,
 10382,
 1143096361,
 1141969955,
 10262,
 1143161894,
 1143018651,
 10294,
 1143227429,
 1143084256,
 10358,
 -1,
 1143149863,
 10486,
 -1,
 1143149863,
 10422,
 1143424040,
 1143084256,
 10326,
 -1,
 1143346471,
 10454,
 -1,
 1143346471,
 10390,
 1143620653,
 1143018651,
 10278,
 1143686188,
 1143543008,
 10342,
 -1,
 1143608615,
 10470,
 -1,
 1143608615,
 10406,
 1143882799,
 1143543008,
 10310,
 -1,
 1143805223,
 10438,
 -1,
 1143805223,
 10374,
 1144079424,
 1141904342,
 10250,
 1144144953,
 1144001571,
 10266,
 1144210486,
 1144067227,
 10298,
 1144276021,
 1144132832,
 10362,
 -1,
 1144198439,
 10490,
 -1,
 1144198439,
 10426,
 1144472632,
 1144132832,
 10330,
 -1,
 1144395047,
 10458,
 -1,
 1144395047,
 10394,
 1144669245,
 1144067227,
 10282,
 1144734780,
 1144591584,
 10346,
 -1,
 1144657191,
 10474,
 -1,
 1144657191,
 10410,
 1144931391,
 1144591584,
 10314,
 -1,
 1144853799,
 10442,
 -1,
 1144853799,
 10378,
 1145128008,
 1144001571,
 10258,
 1145193541,
 1145050267,
 10290,
 1145259076,
 1145115872,
 10354,
 -1,
 1145181479,
 10482,
 -1,
 1145181479,
 10418,
 1145455687,
 1145115872,
 10322,
 -1,
 1145378087,
 10450,
 -1,
 1145378087,
 10386,
 1145652300,
 1145050267,
 10274,
 1145717835,
 1145574624,
 10338,
 -1,
 1145640231,
 10466,
 -1,
 1145640231,
 10402,
 1145914446,
 1145574624,
 10306,
 -1,
 1145836839,
 10434,
 -1,
 1145836839,
 10370,
 1146111087,
 1141838694,
 10244,
 1146176608,
 1146033110,
 10252,
 1146242137,
 1146098723,
 10268,
 1146307670,
 1146164379,
 10300,
 1146373205,
 1146229984,
 10364,
 -1,
 1146295591,
 10492,
 -1,
 1146295591,
 10428,
 1146569816,
 1146229984,
 10332,
 -1,
 1146492199,
 10460,
 -1,
 1146492199,
 10396,
 1146766429,
 1146164379,
 10284,
 1146831964,
 1146688736,
 10348,
 -1,
 1146754343,
 10476,
 -1,
 1146754343,
 10412,
 1147028575,
 1146688736,
 10316,
 -1,
 1146950951,
 10444,
 -1,
 1146950951,
 10380,
 1147225192,
 1146098723,
 10260,
 1147290725,
 1147147419,
 10292,
 1147356260,
 1147213024,
 10356,
 -1,
 1147278631,
 10484,
 -1,
 1147278631,
 10420,
 1147552871,
 1147213024,
 10324,
 -1,
 1147475239,
 10452,
 -1,
 1147475239,
 10388,
 1147749484,
 1147147419,
 10276,
 1147815019,
 1147671776,
 10340,
 -1,
 1147737383,
 10468,
 -1,
 1147737383,
 10404,
 1148011630,
 1147671776,
 10308,
 -1,
 1147933991,
 10436,
 -1,
 1147933991,
 10372,
 1148208255,
 1146033110,
 10248,
 1148273784,
 1148130339,
 10264,
 1148339317,
 1148195995,
 10296,
 1148404852,
 1148261600,
 10360,
 -1,
 1148327207,
 10488,
 -1,
 1148327207,
 10424,
 1148601463,
 1148261600,
 10328,
 -1,
 1148523815,
 10456,
 -1,
 1148523815,
 10392,
 1148798076,
 1148195995,
 10280,
 1148863611,
 1148720352,
 10344,
 -1,
 1148785959,
 10472,
 -1,
 1148785959,
 10408,
 1149060222,
 1148720352,
 10312,
 -1,
 1148982567,
 10440,
 -1,
 1148982567,
 10376,
 1149256839,
 1148130339,
 10256,
 1149322372,
 1149179035,
 10288,
 1149387907,
 1149244640,
 10352,
 -1,
 1149310247,
 10480,
 -1,
 1149310247,
 10416,
 1149584518,
 1149244640,
 10320,
 -1,
 1149506855,
 10448,
 -1,
 1149506855,
 10384,
 1149781131,
 1149179035,
 10272,
 1149846666,
 1149703392,
 10336,
 -1,
 1149768999,
 10464,
 -1,
 1149768999,
 10400,
 1150043277,
 1149703392,
 10304,
 -1,
 1149965607,
 10432,
 -1,
 1149965607,
 10368,
 -1,
 1133390498,
 10240,
 1150305426,
 1133352023,
 -1,
 -47983,
 1150234750,
 9099,
 -1,
 1150297971,
 166,
 -1,
 1150241963,
 728,
 1150567957,
 1133307871,
 -1,
 1150633157,
 1150489998,
 -1,
 1150698663,
 1150591083,
 -1,
 1150764195,
 1150652914,
 -1,
 1150829727,
 1150730646,
 -1,
 1150895260,
 1150793648,
 118801,
 1151008767,
 1150812160,
 -1,
 -47973,
 1150913500,
 118865,
 -1,
 1150958075,
 118802,
 1151205375,
 1150837225,
 -1,
 -47970,
 1151124910,
 118957,
 -1,
 1151189837,
 118866,
 1151354018,
 1150760975,
 -1,
 -47967,
 1151306716,
 118916,
 -1,
 1151345019,
 118818,
 -1,
 1151321894,
 118819,
 1151616166,
 1150700276,
 -1,
 -47963,
 1151591566,
 118835,
 -1,
 1151627877,
 118797,
 -1,
 1151564504,
 118917,
 1151878323,
 1150659030,
 -1,
 1151943856,
 1151824750,
 -1,
 -47958,
 1151920415,
 119022,
 -47957,
 1151982931,
 119018,
 -47956,
 1152032976,
 119017,
 -47955,
 1152093398,
 119023,
 -47954,
 1152152100,
 119021,
 -47953,
 1152209759,
 119019,
 -1,
 1152268439,
 119020,
 1152516095,
 1151882885,
 -1,
 -47950,
 1152435035,
 118899,
 -1,
 1152485698,
 118935,
 1152664768,
 1151817364,
 -1,
 1152730295,
 1152624063,
 -1,
 -47946,
 1152669375,
 118945,
 -1,
 1152721371,
 118938,
 1152926906,
 1152680830,
 -1,
 -47943,
 1152895897,
 118941,
 -1,
 1152957549,
 118942,
 1153123517,
 1152865978,
 -1,
 -47940,
 1153080116,
 118944,
 -1,
 1153130983,
 118943,
 1153368063,
 1153049012,
 -1,
 -47937,
 1153276724,
 118939,
 -1,
 1153327591,
 118940,
 1153564671,
 1152616770,
 -1,
 1153582276,
 1153484941,
 -1,
 -47933,
 1153532053,
 118876,
 -1,
 1153594300,
 118882,
 -1,
 1153508744,
 118824,
 1153844464,
 1150578934,
 -1,
 1153909972,
 1153779778,
 -1,
 1153975502,
 1153876921,
 118800,
 1154088959,
 1153892352,
 -1,
 1154106573,
 1153993696,
 -1,
 -47925,
 1154057376,
 119024,
 -47924,
 1154118120,
 119026,
 -1,
 1154162466,
 118862,
 -1,
 1154031995,
 118812,
 1154482175,
 1153892352,
 -1,
 1154499795,
 1154386912,
 -1,
 -47919,
 1154450592,
 119025,
 -47918,
 1154511336,
 119027,
 -1,
 1154555682,
 118863,
 -1,
 1154425211,
 118811,
 1154827489,
 1153870294,
 -1,
 1154893024,
 1154753851,
 -1,
 1154958557,
 1154815374,
 -1,
 1155024092,
 1154875392,
 -1,
 1155089627,
 1154946446,
 -1,
 -47910,
 1155050428,
 118913,
 -1,
 1155103998,
 118914,
 -1,
 1155042268,
 118915,
 -1,
 1154991033,
 118834,
 1155465215,
 1154912754,
 -1,
 -47905,
 1155393366,
 118868,
 -1,
 1155429189,
 118860,
 -1,
 1154827891,
 118796,
 1155679462,
 1154781682,
 -1,
 1155744996,
 1155633140,
 118842,
 -1,
 1155661896,
 118850,
 -47899,
 1155715271,
 118858,
 -1,
 1155839198,
 118921,
 1156007146,
 1155626492,
 118820,
 1156120575,
 1155923968,
 -1,
 -47895,
 1156018664,
 119028,
 -1,
 1156063010,
 118911,
 1156269295,
 1155933329,
 -1,
 1156334830,
 1156195837,
 -1,
 -47891,
 1156300325,
 118906,
 -1,
 1156320207,
 118839,
 -1,
 1156275769,
 118791,
 -1,
 1156245184,
 118881,
 1156662544,
 1153781406,
 -1,
 1156728075,
 1156630458,
 -1,
 1156793596,
 1156659535,
 -1,
 1156859128,
 1156745538,
 -1,
 1156924663,
 1156801001,
 -1,
 -47882,
 1156870632,
 118977,
 -1,
 1156914978,
 118978,
 -1,
 1156849010,
 118971,
 -47879,
 1156835615,
 118976,
 -47878,
 1157144784,
 118970,
 -47877,
 1157198372,
 118975,
 -1,
 1157249175,
 118973,
 1157448961,
 1156759031,
 -1,
 1157514496,
 1157378067,
 -1,
 -47873,
 1157486980,
 983050,
 -1,
 1157546814,
 118982,
 -1,
 1157445978,
 118974,
 1157776644,
 1157400898,
 -1,
 -47869,
 1157711688,
 118983,
 -1,
 1157767109,
 118972,
 1157973255,
 1157726540,
 -1,
 -47866,
 1157924642,
 118980,
 -1,
 1157970301,
 118979,
 1158169865,
 1157898619,
 118836,
 -1,
 1158087468,
 118969,
 -47862,
 1158111824,
 118987,
 -1,
 1158235995,
 118988,
 1158432015,
 1156652667,
 -1,
 -47859,
 1158399650,
 118958,
 -47858,
 1158448930,
 118959,
 -1,
 1158494589,
 118960,
 -1,
 1158373720,
 118981,
 1158759727,
 1156626352,
 -1,
 1158825246,
 1158702837,
 -1,
 1158890776,
 1158793021,
 119006,
 1159004159,
 1158807552,
 -1,
 1159021847,
 1158923128,
 -1,
 -47850,
 1158984510,
 119008,
 -1,
 1159023664,
 119009,
 -1,
 1158953552,
 119007,
 1159331839,
 1158816465,
 119010,
 1159397375,
 1159200768,
 -1,
 1159415069,
 1159316344,
 -1,
 -47844,
 1159377726,
 119012,
 -1,
 1159416880,
 119013,
 -1,
 1159346768,
 119011,
 1159677223,
 1158800576,
 -1,
 1159742757,
 1159629122,
 -1,
 1159808292,
 1159665920,
 -1,
 -47838,
 1159760860,
 118885,
 -47837,
 1159824563,
 118827,
 -1,
 1159864699,
 118826,
 -1,
 1159744901,
 118803,
 1160183807,
 1159705589,
 118886,
 -1,
 1160104091,
 118792,
 1160267052,
 1159644024,
 -1,
 1160332586,
 1160193579,
 118910,
 -1,
 1160249830,
 118815,
 -47829,
 1160293013,
 118852,
 -1,
 1160406504,
 119016,
 1160594734,
 1160201650,
 118825,
 -1,
 1160513056,
 118889,
 -1,
 1160521301,
 118813,
 1160791376,
 1158717547,
 -1,
 1160856890,
 1160756333,
 -1,
 1160922423,
 1160794353,
 -1,
 1160987956,
 1160874306,
 118841,
 -1,
 1160906272,
 118874,
 -47819,
 1160954693,
 118897,
 -47818,
 1161077136,
 118895,
 -1,
 1161134144,
 118892,
 1161363455,
 1160868804,
 -1,
 -47815,
 1161270672,
 118807,
 -1,
 1161322983,
 118784,
 1161512259,
 1160790183,
 -1,
 1161577792,
 1161479401,
 -1,
 1161643327,
 1161544568,
 -1,
 -47810,
 1161598051,
 118859,
 -1,
 1161650663,
 118857,
 -1,
 1161592981,
 118849,
 1161905474,
 1161524738,
 118840,
 -1,
 1161823776,
 118861,
 -1,
 1161868181,
 118786,
 1162102093,
 1161437313,
 -1,
 1162167628,
 1162025445,
 -1,
 1162233161,
 1162116138,
 118793,
 1162346495,
 1162149888,
 -1,
 -47800,
 1162251228,
 118878,
 -1,
 1162289531,
 118846,
 1162543103,
 1162156897,
 -1,
 -47797,
 1162447836,
 118879,
 -1,
 1162486139,
 118845,
 -1,
 1162109799,
 118814,
 1162805247,
 1162044207,
 -1,
 -47793,
 1162709980,
 118873,
 -1,
 1162748283,
 118822,
 1162954096,
 1160721964,
 -1,
 1163019630,
 1162895847,
 -1,
 1163085147,
 1162955490,
 -1,
 1163150680,
 1163051896,
 -1,
 1163216215,
 1163112070,
 -1,
 -47786,
 1163184449,
 118990,
 -1,
 1163220744,
 118995,
 -1,
 1163152355,
 118991,
 -47783,
 1163102008,
 118993,
 -47782,
 1163409846,
 118994,
 -1,
 1163468826,
 118992,
 1163674979,
 1163023147,
 -1,
 1163740514,
 1163630921,
 118930,
 1163853823,
 1163659380,
 -1,
 1163871585,
 1163731452,
 -1,
 -47776,
 1163817448,
 118931,
 -1,
 1163861794,
 118932,
 -1,
 1163802699,
 118933,
 -1,
 1163701012,
 119014,
 1164199275,
 1163597198,
 -1,
 1164264810,
 1164165459,
 -1,
 1164330344,
 1164189740,
 -1,
 -47769,
 1164273195,
 119002,
 -1,
 1164330180,
 119003,
 -47767,
 1164298045,
 119005,
 -1,
 1164458491,
 119004,
 -1,
 1164226157,
 118937,
 1164723565,
 1164158116,
 118918,
 -1,
 1164640752,
 118912,
 -1,
 1164661485,
 119015,
 -47761,
 1162995460,
 118831,
 -1,
 1164845931,
 118785,
 1165051279,
 1162920824,
 -1,
 1165116801,
 1165011414,
 -1,
 1165182333,
 1165071708,
 -1,
 1165247864,
 1165134148,
 -1,
 1165313399,
 1165170062,
 -1,
 -47754,
 1165274044,
 118838,
 -1,
 1165327614,
 118851,
 -1,
 1165265884,
 118883,
 1165575547,
 1165205611,
 -1,
 -47750,
 1165540518,
 118891,
 -1,
 1165566219,
 118894,
 -47748,
 1165542213,
 118896,
 -1,
 1165721664,
 118893,
 1165950975,
 1165124071,
 -1,
 -47745,
 1165862052,
 118919,
 -47744,
 1165907653,
 118934,
 -1,
 1165956494,
 118832,
 1166165386,
 1165056243,
 -1,
 1166230921,
 1166098599,
 -1,
 1166296456,
 1166180501,
 118829,
 1166361991,
 1166264735,
 -1,
 -47738,
 1166337148,
 118903,
 -1,
 1166393106,
 118902,
 -1,
 1166279134,
 118904,
 -1,
 1166260205,
 118905,
 -1,
 1166175732,
 118804,
 1166755214,
 1166098599,
 -1,
 -47732,
 1166723948,
 118920,
 -47731,
 1166786701,
 118833,
 -1,
 1166833972,
 118799,
 -1,
 1166698537,
 118823,
 1167082918,
 1165000776,
 -1,
 1167148453,
 1167008522,
 -1,
 1167213976,
 1167115128,
 -1,
 1167279509,
 1167175302,
 -1,
 -47724,
 1167248168,
 118950,
 -1,
 1167282627,
 118951,
 1167523839,
 1167215600,
 -1,
 -47721,
 1167423782,
 118953,
 -1,
 1167483757,
 118952,
 1167672735,
 1167171691,
 -1,
 1167738268,
 1167635822,
 -1,
 -47717,
 1167710584,
 118962,
 -1,
 1167767516,
 118946,
 1167982591,
 1167684853,
 -1,
 -47714,
 1167902355,
 118963,
 -1,
 1167942509,
 118955,
 1168131490,
 1167596560,
 -1,
 -47711,
 1168090944,
 118947,
 -1,
 1168128081,
 118949,
 -47709,
 1168103800,
 118961,
 -47708,
 1168275750,
 118954,
 -1,
 1168324689,
 118948,
 -1,
 1167091248,
 118871,
 1168590264,
 1167058112,
 -1,
 1168655794,
 1168527214,
 -1,
 1168721327,
 1168620972,
 -1,
 1168786860,
 1168690069,
 -1,
 -47701,
 1168755009,
 118989,
 -1,
 1168791304,
 118999,
 -47699,
 1168738104,
 118997,
 -47698,
 1168914870,
 118998,
 -1,
 1168973850,
 118996,
 1169227775,
 1168673092,
 -1,
 -47695,
 1169125864,
 118908,
 -1,
 1169170210,
 118909,
 1169424383,
 1168613483,
 -1,
 1169442231,
 1169330674,
 -1,
 1169507766,
 1169388366,
 118794,
 -1,
 1169425253,
 118795,
 -1,
 1169471038,
 118867,
 -1,
 1169407255,
 118864,
 1169769931,
 1168528171,
 -1,
 1169835463,
 1169725560,
 -1,
 1169900996,
 1169774213,
 -1,
 1169966531,
 1169852740,
 -1,
 1170032063,
 1169924553,
 -1,
 -47682,
 1169963083,
 118929,
 -1,
 1170022899,
 118928,
 1170228674,
 1169984480,
 -1,
 -47679,
 1170174440,
 119029,
 -1,
 1170218786,
 118927,
 -1,
 1170153851,
 118806,
 -1,
 1169933147,
 118898,
 1170604031,
 1169868697,
 -1,
 -47674,
 1170487809,
 118965,
 -1,
 1170546739,
 118964,
 1170752970,
 1169770446,
 -1,
 -47671,
 1170728500,
 119001,
 -1,
 1170749814,
 119000,
 -1,
 1170715876,
 118853,
 1171015129,
 1169723890,
 -1,
 1171080658,
 1170990144,
 -1,
 1171146193,
 1170997248,
 -1,
 -47665,
 1171098588,
 118856,
 -47664,
 1171146194,
 118787,
 -1,
 1171208699,
 118788,
 -1,
 1171087852,
 118816,
 1171473877,
 1171056495,
 -1,
 -47660,
 1171426268,
 118901,
 -1,
 1171464571,
 118828,
 1171670488,
 1171422008,
 -1,
 -47657,
 1171622876,
 118855,
 -1,
 1171661179,
 118805,
 -1,
 1171620435,
 118875,
 1171932647,
 1170956775,
 -1,
 1171998177,
 1171883252,
 -1,
 1172063712,
 1171934878,
 -1,
 1172129247,
 1172031413,
 -1,
 -47650,
 1172084112,
 118968,
 -1,
 1172116878,
 118837,
 -1,
 1172084429,
 118967,
 -1,
 1171994951,
 118936,
 1172456934,
 1171961776,
 -1,
 1172522469,
 1172411795,
 -1,
 -47644,
 1172474844,
 118854,
 -1,
 1172513147,
 118810,
 -1,
 1172445683,
 118956,
 -1,
 1172385635,
 118847,
 1172850162,
 1171865767,
 -1,
 1172915691,
 1172817519,
 -1,
 -47638,
 1172873616,
 118880,
 -1,
 1172906464,
 118900,
 1173112302,
 1172867394,
 -1,
 -47635,
 1173043954,
 118907,
 -1,
 1173103383,
 118966,
 -47633,
 1173087359,
 118798,
 -47632,
 1173267058,
 118888,
 -47631,
 1173320875,
 118869,
 -1,
 1173386072,
 118884,
 1173571069,
 1172796356,
 -1,
 1173636604,
 1173504167,
 -1,
 1173702139,
 1173579611,
 -1,
 1173767672,
 1173668728,
 -1,
 -47625,
 1173729954,
 118924,
 -1,
 1173768991,
 118925,
 -47623,
 1173710667,
 118926,
 -47622,
 1173899221,
 118922,
 -1,
 1173962903,
 118923,
 -1,
 1173653259,
 118830,
 -1,
 1173612091,
 118877,
 1174291976,
 1173499719,
 -1,
 1174357506,
 1174254696,
 -1,
 -47616,
 1174333755,
 118984,
 -47615,
 1174388655,
 118986,
 -1,
 1174434530,
 118985,
 1174619653,
 1174313281,
 -1,
 -47612,
 1174571996,
 118887,
 -1,
 1174610299,
 118843,
 1174863871,
 1174543621,
 -1,
 -47609,
 1174771088,
 118808,
 -1,
 1174823399,
 118870,
 1175012880,
 1174263924,
 -1,
 1175078415,
 1174973773,
 -1,
 1175143950,
 1174994944,
 -1,
 -47604,
 1175096284,
 118872,
 -47603,
 1175143890,
 118789,
 -1,
 1175206395,
 118790,
 -1,
 1175085548,
 118817,
 -1,
 1175046234,
 118809,
 1175537171,
 1174972886,
 -1,
 -47598,
 1175473541,
 118821,
 -1,
 1175527404,
 118844,
 -47596,
 1175512175,
 118890,
 -1,
 1175685612,
 118848,
 1175865139,
 1150489998,
 -1,
 1175930557,
 1175811012,
 -1,
 1175996085,
 1175873800,
 -1,
 1176061528,
 1175943746,
 -1,
 1176127008,
 1176028024,
 -1,
 1176192543,
 1176049038,
 6946,
 1176305663,
 1176109056,
 -1,
 -47587,
 1176225030,
 6947,
 -47586,
 1176275150,
 6942,
 -1,
 1176335913,
 6941,
 -1,
 1176168721,
 6983,
 1176585765,
 1176078658,
 -1,
 1176651299,
 1176507790,
 6950,
 -1,
 1176570302,
 6945,
 -47580,
 1176626428,
 6940,
 -1,
 1176720223,
 6935,
 1176913450,
 1176531190,
 -1,
 1176978985,
 1176835470,
 6931,
 -47576,
 1176915650,
 6981,
 -1,
 1176962512,
 6932,
 -1,
 1176920152,
 6982,
 1177241136,
 1176843927,
 6948,
 1177354239,
 1177159117,
 -1,
 1177372207,
 1177278075,
 -1,
 -47570,
 1177321689,
 6944,
 -1,
 1177361508,
 6943,
 -1,
 1177294938,
 6949,
 1177634357,
 1177163150,
 -1,
 1177699891,
 1177579934,
 6917,
 -1,
 1177619152,
 6918,
 -47564,
 1177666412,
 6987,
 -1,
 1177773591,
 6928,
 1177962041,
 1177597994,
 6962,
 1178075135,
 1177881094,
 -1,
 -47560,
 1177985232,
 6961,
 -1,
 1178030943,
 6960,
 1178224188,
 1177922097,
 6957,
 1178337279,
 1178143183,
 6923,
 -1,
 1178208976,
 6924,
 1178420799,
 1178170393,
 6958,
 1178533887,
 1178338697,
 6925,
 -1,
 1178405584,
 6926,
 1178617409,
 1178390843,
 6921,
 -1,
 1178536656,
 6922,
 1178748483,
 1178575056,
 6951,
 -1,
 1178666238,
 6952,
 1178879557,
 1178702929,
 6929,
 -1,
 1178798800,
 6930,
 1179010631,
 1178824601,
 6938,
 -1,
 1178928362,
 6939,
 1179141705,
 1178953239,
 6919,
 -1,
 1179060944,
 6920,
 1179272779,
 1179079519,
 6933,
 -1,
 1179190311,
 6934,
 1179403854,
 1179205799,
 -1,
 -47539,
 1179349406,
 6927,
 -1,
 1179406018,
 6984,
 1179600464,
 1179331936,
 6936,
 -1,
 1179518274,
 6937,
 1179731538,
 1179526861,
 6953,
 -1,
 1179649319,
 6954,
 -47533,
 1179707445,
 6986,
 -47532,
 1179837692,
 6956,
 -47531,
 1179901442,
 6959,
 -47530,
 1179965917,
 6985,
 -47529,
 1180008597,
 6955,
 -1,
 1180064017,
 6963,
 1180255873,
 1176013042,
 -1,
 1180321383,
 1180186156,
 -1,
 1180386913,
 1180243342,
 -1,
 1180452447,
 1180339226,
 7012,
 1180565503,
 1180368896,
 -1,
 -47522,
 1180484284,
 7013,
 -1,
 1180521632,
 7018,
 -47520,
 1180395791,
 7017,
 -1,
 1180649406,
 7015,
 1180845668,
 1180319911,
 -1,
 -47517,
 1180816149,
 7016,
 -1,
 1180863514,
 7010,
 -47515,
 1180816149,
 7011,
 -47514,
 1180997238,
 7009,
 -1,
 1181051151,
 7014,
 1181238898,
 1180250673,
 -1,
 1181304429,
 1181184581,
 -1,
 1181369963,
 1181274454,
 7021,
 -1,
 1181289934,
 7024,
 1181548543,
 1181317848,
 7022,
 -1,
 1181421006,
 7025,
 -47506,
 1181271449,
 7019,
 -47505,
 1181577256,
 7023,
 -47504,
 1181636277,
 7027,
 -47503,
 1181697959,
 7020,
 -1,
 1181755550,
 7026,
 1181959802,
 1181186189,
 -1,
 1182025335,
 1181915080,
 -1,
 -47499,
 1181995797,
 7033,
 -47498,
 1182034191,
 7036,
 -1,
 1182080645,
 7032,
 1182334975,
 1181954524,
 -1,
 -47495,
 1182257464,
 7035,
 -1,
 1182276069,
 7034,
 1182531583,
 1181921500,
 -1,
 1182549630,
 1182439354,
 -1,
 -47491,
 1182519502,
 7028,
 -1,
 1182537912,
 7029,
 1182793727,
 1182478822,
 -1,
 -47488,
 1182716216,
 7030,
 -1,
 1182734821,
 7031,
 1182942867,
 1180229000,
 -1,
 1183008393,
 1182909304,
 -1,
 1183073928,
 1182931903,
 6974,
 1183186943,
 1182990336,
 -1,
 1183204999,
 1183100266,
 6975,
 -1,
 1183124176,
 6977,
 -1,
 1183171959,
 6976,
 -1,
 1183007553,
 6965,
 1183467147,
 1182978571,
 6966,
 -1,
 1183386122,
 6967,
 1183598221,
 1183433293,
 6968,
 -1,
 1183515807,
 6969,
 1183729295,
 1183558196,
 6970,
 -1,
 1183648464,
 6971,
 1183860369,
 1183687376,
 6978,
 -1,
 1183779536,
 6979,
 1184038911,
 1183806492,
 6972,
 -1,
 1183910608,
 6973,
 1184122529,
 1182874020,
 -1,
 1184188055,
 1184088952,
 -1,
 -47466,
 1184162401,
 6994,
 -1,
 1184194750,
 6995,
 1184384666,
 1184151472,
 -1,
 -47463,
 1184329564,
 6998,
 -1,
 1184386223,
 6999,
 1184581277,
 1184321182,
 -1,
 -47460,
 1184537714,
 6996,
 -1,
 1184591589,
 6997,
 -47458,
 1184557167,
 6992,
 -47457,
 1184732706,
 6993,
 -47456,
 1184795935,
 7001,
 -1,
 1184843095,
 7000,
 1185040041,
 1184087233,
 -1,
 1185105573,
 1185010191,
 -1,
 -47452,
 1185066718,
 6912,
 -1,
 1185099197,
 6913,
 -47450,
 1185071804,
 6915,
 -47449,
 1185262972,
 6964,
 -47448,
 1185296083,
 6914,
 -1,
 1185360358,
 6916,
 1185564334,
 1184997584,
 -1,
 1185629869,
 1185513544,
 -1,
 -47444,
 1185564589,
 7008,
 -1,
 1185617922,
 7003,
 -1,
 1185583099,
 7002,
 1185892019,
 1185492565,
 -1,
 1185957554,
 1185849552,
 -1,
 -47439,
 1185918340,
 7007,
 -1,
 1185974453,
 7005,
 -1,
 1185922316,
 7006,
 -47436,
 1185865778,
 7004,
 -1,
 1186142251,
 6980,
 1186398207,
 1175944492,
 -1,
 1186416316,
 1186317178,
 -1,
 1186481851,
 1186343808,
 9744,
 1186594815,
 1186401334,
 -1,
 -47430,
 1186522070,
 9746,
 -1,
 1186541461,
 9745,
 -1,
 1186456534,
 10007,
 -1,
 1186371013,
 10057,
 1186875185,
 1175881879,
 -1,
 1186940710,
 1186822722,
 -1,
 1187006162,
 1186892098,
 -1,
 1187071684,
 1186951063,
 -1,
 -47422,
 1187041125,
 42686,
 -47421,
 1187070791,
 42694,
 -1,
 1187125379,
 42674,
 1187333832,
 1187009323,
 -1,
 -47418,
 1187279798,
 42707,
 -47417,
 1187337055,
 42708,
 -1,
 1187386766,
 42709,
 1187595978,
 1187303150,
 42685,
 -1,
 1187518558,
 42684,
 1187727053,
 1187562360,
 -1,
 -47412,
 1187698738,
 42731,
 -1,
 1187726151,
 42695,
 -47410,
 1187702338,
 42664,
 -47409,
 1187887843,
 42691,
 -47408,
 1187930599,
 42703,
 -47407,
 1187985065,
 42673,
 -1,
 1188042126,
 42715,
 1188251359,
 1186951414,
 -1,
 1188316886,
 1188205042,
 42719,
 -47403,
 1188289996,
 42734,
 -1,
 1188320564,
 42735,
 1188513498,
 1188249767,
 -1,
 -47400,
 1188485190,
 42692,
 -47399,
 1188545400,
 42683,
 -1,
 1188596034,
 42706,
 -47397,
 1188488608,
 42682,
 -47396,
 1188744942,
 42659,
 -47395,
 1188798672,
 42729,
 -47394,
 1188848103,
 42725,
 -1,
 1188894094,
 42657,
 1189103338,
 1188200520,
 42675,
 1189168867,
 1189036199,
 -1,
 -47390,
 1189120322,
 42722,
 -1,
 1189167946,
 42671,
 1189365478,
 1189095067,
 -1,
 -47387,
 1189299985,
 42720,
 -1,
 1189352977,
 42727,
 -47385,
 1189334766,
 42677,
 -47384,
 1189515762,
 42726,
 -47383,
 1189568999,
 42702,
 -1,
 1189614990,
 42723,
 1189824244,
 1189066672,
 -1,
 1189889776,
 1189763315,
 -1,
 -47379,
 1189859054,
 42688,
 -47378,
 1189908978,
 42710,
 -47377,
 1189963267,
 42678,
 -1,
 1190022296,
 42680,
 -47375,
 1189861426,
 42676,
 -47374,
 1190158823,
 42679,
 -47373,
 1190218904,
 42681,
 -1,
 1190272198,
 42732,
 1190479614,
 1189784022,
 -1,
 1190545145,
 1190412455,
 -1,
 -47369,
 1190516806,
 42704,
 -47368,
 1190562114,
 42721,
 -1,
 1190609063,
 42661,
 1190807292,
 1190486503,
 -1,
 -47365,
 1190748647,
 42668,
 -1,
 1190806343,
 42669,
 -47363,
 1190776558,
 42700,
 -1,
 1190926430,
 42705,
 1191134983,
 1190436971,
 -1,
 1191200514,
 1191104238,
 -1,
 -47359,
 1191133351,
 42696,
 -1,
 1191188574,
 42711,
 1191397125,
 1191133351,
 -1,
 -47356,
 1191368774,
 42693,
 -1,
 1191395495,
 42698,
 -47354,
 1191338471,
 42717,
 -1,
 1191515534,
 42667,
 1191724815,
 1191101304,
 -1,
 1191790347,
 1191657639,
 -1,
 -47350,
 1191756664,
 42728,
 -1,
 1191807298,
 42730,
 1191986958,
 1191712142,
 -1,
 -47347,
 1191919783,
 42662,
 -1,
 1191974286,
 42672,
 -1,
 1191928295,
 42724,
 1192249109,
 1191670724,
 -1,
 -47343,
 1192218350,
 42701,
 -47342,
 1192269941,
 42718,
 -47341,
 1192321511,
 42716,
 -47340,
 1192379214,
 42670,
 -1,
 1192433038,
 42666,
 1192642330,
 1192185502,
 -1,
 -47337,
 1192611566,
 42712,
 -47336,
 1192662313,
 42713,
 -47335,
 1192706887,
 42699,
 -1,
 1192760867,
 42733,
 1192970014,
 1192617152,
 -1,
 -47332,
 1192941088,
 42689,
 -47331,
 1192990837,
 42687,
 -1,
 1193022862,
 42690,
 1193232161,
 1192943066,
 -1,
 -47328,
 1193201842,
 42697,
 -1,
 1193219470,
 42714,
 -47326,
 1193201390,
 42658,
 -47325,
 1193382386,
 42663,
 -47324,
 1193435623,
 42665,
 -47323,
 1193493319,
 42660,
 -1,
 1193547150,
 42656,
 1193756461,
 1186869772,
 -1,
 1193821996,
 1193705544,
 -1,
 1193887531,
 1193748942,
 -1,
 -47318,
 1193856354,
 42737,
 -1,
 1193898782,
 42736,
 -1,
 1193836693,
 42741,
 -1,
 1193770357,
 42740,
 -47314,
 1193720303,
 42742,
 -47313,
 1194174784,
 42743,
 -47312,
 1194233267,
 42738,
 -1,
 1194283786,
 42739,
 -47310,
 1186838843,
 9918,
 -1,
 1194406223,
 10155,
 1194608715,
 1175818738,
 -1,
 1194674160,
 1194583003,
 -1,
 1194739566,
 1194619844,
 -1,
 1194805091,
 1194681680,
 -1,
 1194870598,
 1194735148,
 -1,
 1194936129,
 1194824178,
 -1,
 1195001662,
 1194910240,
 9591,
 1195114495,
 1194918010,
 -1,
 -47300,
 1195028206,
 9484,
 -47299,
 1195079409,
 9488,
 -1,
 1195138869,
 9516,
 1195376639,
 1194971111,
 -1,
 -47296,
 1195301613,
 9550,
 -1,
 1195335477,
 9548,
 1195573247,
 1194877562,
 -1,
 1195591493,
 1195496701,
 -1,
 -47292,
 1195552899,
 9585,
 -1,
 1195604000,
 9586,
 -1,
 1195521098,
 9587,
 1195853645,
 1194841000,
 9589,
 1195966463,
 1195769978,
 -1,
 1195984715,
 1195858163,
 -1,
 -47286,
 1195940218,
 9524,
 -1,
 1195983348,
 9597,
 -47284,
 1195945710,
 9492,
 -1,
 1196127985,
 9496,
 1196312402,
 1195825901,
 9474,
 1196425215,
 1196228730,
 -1,
 -47280,
 1196338926,
 9500,
 -47279,
 1196390129,
 9508,
 -1,
 1196449589,
 9532,
 1196640089,
 1196237126,
 -1,
 1196705622,
 1196610479,
 -1,
 -47275,
 1196666606,
 9584,
 -1,
 1196717809,
 9583,
 1196949503,
 1196637786,
 -1,
 -47272,
 1196863214,
 9581,
 -1,
 1196914417,
 9582,
 1197098844,
 1196608522,
 -1,
 -47269,
 1197071085,
 9478,
 -1,
 1197104949,
 9476,
 1197295455,
 1197058165,
 -1,
 -47266,
 1197267693,
 9482,
 -1,
 1197301557,
 9480,
 1197492065,
 1197242097,
 9588,
 -1,
 1197408473,
 9596,
 -47262,
 1197453038,
 9590,
 -1,
 1197563701,
 9472,
 1197801471,
 1194738622,
 -1,
 1197819752,
 1197701909,
 -1,
 -47258,
 1197792147,
 9546,
 -47257,
 1197855748,
 9530,
 -1,
 1197883045,
 9522,
 1198081900,
 1197759522,
 -1,
 -47254,
 1198054306,
 9533,
 -47253,
 1198118000,
 9525,
 -1,
 1198145303,
 9517,
 -47251,
 1198052394,
 9539,
 -1,
 1198276301,
 9541,
 1198475161,
 1194670800,
 -1,
 1198540682,
 1198449187,
 -1,
 1198606201,
 1198488314,
 -1,
 1198671732,
 1198567156,
 -1,
 -47245,
 1198642180,
 9505,
 -1,
 1198676986,
 9485,
 1198868343,
 1198618358,
 -1,
 -47242,
 1198838788,
 9513,
 -1,
 1198873594,
 9489,
 -47240,
 1198838856,
 9543,
 -1,
 1199005610,
 9519,
 1199196034,
 1198545927,
 -1,
 1199261565,
 1199156980,
 -1,
 -47236,
 1199232112,
 9503,
 -1,
 1199274740,
 9486,
 1199458176,
 1199208182,
 -1,
 -47233,
 1199428720,
 9511,
 -1,
 1199471348,
 9490,
 -47231,
 1199428700,
 9537,
 -1,
 1199595451,
 9520,
 1199785862,
 1199160642,
 -1,
 -47228,
 1199746952,
 9554,
 -47227,
 1199798085,
 9557,
 -1,
 1199857524,
 9572,
 1200095231,
 1199717495,
 -1,
 -47224,
 1200009334,
 9555,
 -47223,
 1200060417,
 9558,
 -1,
 1200119756,
 9573,
 1200357375,
 1198510029,
 -1,
 1200375696,
 1200282349,
 9553,
 1200488447,
 1200291962,
 -1,
 -47218,
 1200402158,
 9568,
 -47217,
 1200453361,
 9571,
 -1,
 1200512821,
 9580,
 1200703380,
 1200346031,
 -1,
 -47214,
 1200664302,
 9562,
 -47213,
 1200715505,
 9565,
 -1,
 1200774965,
 9577,
 1200965528,
 1200635482,
 -1,
 -47210,
 1200926446,
 9556,
 -47209,
 1200977649,
 9559,
 -1,
 1201037109,
 9574,
 -1,
 1200906037,
 9552,
 1201293241,
 1198414848,
 -1,
 1201358755,
 1201224400,
 -1,
 1201424288,
 1201332768,
 9595,
 1201537023,
 1201340538,
 -1,
 -47202,
 1201450734,
 9487,
 -47201,
 1201501937,
 9491,
 -1,
 1201561397,
 9523,
 1201799167,
 1201393639,
 -1,
 -47198,
 1201724141,
 9551,
 -1,
 1201758005,
 9549,
 1201948586,
 1201329064,
 9593,
 1202061311,
 1201864826,
 -1,
 1202079656,
 1201959876,
 -1,
 -47193,
 1202021718,
 9599,
 -1,
 1202078650,
 9499,
 -47191,
 1202040558,
 9495,
 -1,
 1202216757,
 9531,
 1202407343,
 1201920749,
 9475,
 1202520063,
 1202323578,
 -1,
 -47187,
 1202433774,
 9507,
 -47186,
 1202484977,
 9515,
 -1,
 1202544437,
 9547,
 1202735026,
 1202375690,
 -1,
 -47183,
 1202707181,
 9479,
 -1,
 1202741045,
 9477,
 1202931637,
 1202694261,
 -1,
 -47180,
 1202903789,
 9483,
 -1,
 1202937653,
 9481,
 1203128247,
 1202878193,
 9592,
 -1,
 1203044596,
 9598,
 -47176,
 1203089134,
 9594,
 -1,
 1203199797,
 9473,
 1203390420,
 1201263531,
 -1,
 1203455939,
 1203337978,
 -1,
 1203521470,
 1203416820,
 -1,
 -47171,
 1203461114,
 9493,
 -1,
 1203519141,
 9506,
 1203718081,
 1203468022,
 -1,
 -47168,
 1203657722,
 9497,
 -1,
 1203715749,
 9514,
 -47166,
 1203658666,
 9527,
 -1,
 1203846891,
 9544,
 1204045772,
 1203395591,
 -1,
 1204111303,
 1204006644,
 -1,
 -47162,
 1204058868,
 9494,
 -1,
 1204109079,
 9502,
 1204307914,
 1204057846,
 -1,
 -47159,
 1204255476,
 9498,
 -1,
 1204305687,
 9510,
 -47157,
 1204248507,
 9528,
 -1,
 1204436737,
 9536,
 1204635600,
 1204010306,
 -1,
 -47154,
 1204596616,
 9560,
 -47153,
 1204647749,
 9563,
 -1,
 1204707188,
 9575,
 1204944895,
 1204567159,
 -1,
 -47150,
 1204858998,
 9561,
 -47149,
 1204910081,
 9564,
 -1,
 1204969420,
 9576,
 1205159909,
 1203362550,
 -1,
 1205225433,
 1205124418,
 -1,
 -47145,
 1205186440,
 9566,
 -47144,
 1205237573,
 9569,
 -1,
 1205297012,
 9578,
 1205487581,
 1205172986,
 -1,
 -47141,
 1205448690,
 9501,
 -47140,
 1205499816,
 9509,
 -1,
 1205559210,
 9535,
 1205749729,
 1205427207,
 -1,
 -47137,
 1205710857,
 9504,
 -47136,
 1205761981,
 9512,
 -1,
 1205821371,
 9538,
 1206059007,
 1205681271,
 -1,
 -47133,
 1205973110,
 9567,
 -47132,
 1206024193,
 9570,
 -1,
 1206083532,
 9579,
 1206321151,
 1205120756,
 -1,
 1206339562,
 1206221573,
 -1,
 -47128,
 1206311827,
 9545,
 -47127,
 1206375428,
 9529,
 -1,
 1206402725,
 9521,
 1206601710,
 1206279186,
 -1,
 -47124,
 1206573986,
 9534,
 -47123,
 1206637680,
 9526,
 -1,
 1206664983,
 9518,
 -47121,
 1206572045,
 9540,
 -1,
 1206795952,
 9542,
 1206994997,
 1194632645,
 -1,
 1207060528,
 1206942274,
 -1,
 1207126011,
 1206982030,
 12570,
 1207191542,
 1207077186,
 12578,
 -47115,
 1207142722,
 12713,
 -1,
 1207194411,
 12580,
 1207388152,
 1207160558,
 12576,
 -1,
 1207340509,
 12719,
 1207519226,
 1207329255,
 12574,
 -1,
 1207471581,
 12718,
 -1,
 1207468104,
 12720,
 1207715843,
 1207058599,
 12572,
 1207781375,
 1207667010,
 12579,
 -47106,
 1207732546,
 12709,
 -1,
 1207784235,
 12581,
 -47104,
 1207740886,
 12582,
 -47103,
 1207919079,
 12575,
 -47102,
 1207982323,
 12573,
 -1,
 1208041639,
 12708,
 1208240138,
 1207656935,
 12583,
 1208305670,
 1208192477,
 12714,
 -1,
 1208256834,
 12723,
 -47097,
 1208274670,
 12585,
 -47096,
 1208396246,
 12712,
 -47095,
 1208451144,
 12716,
 -1,
 1208506611,
 12589,
 1208698897,
 1208193522,
 12571,
 1208764430,
 1208650050,
 -1,
 -47091,
 1208715586,
 12711,
 -1,
 1208767275,
 12722,
 -47089,
 1208733422,
 12577,
 -47088,
 1208914418,
 12710,
 -1,
 1208975432,
 12721,
 1209157652,
 1208674296,
 12567,
 -47085,
 1209098727,
 12705,
 -1,
 1209161971,
 12563,
 1209354263,
 1209108802,
 12555,
 1209466879,
 1209291563,
 12587,
 -1,
 1209357099,
 12717,
 1209550874,
 1209291563,
 12557,
 -47079,
 1209519854,
 12707,
 -1,
 1209567554,
 12588,
 1209747484,
 1209519854,
 12584,
 -1,
 1209699805,
 12715,
 1209878558,
 1209710512,
 12569,
 -1,
 1209817331,
 12565,
 1210009632,
 1209823127,
 12560,
 -1,
 1209950695,
 12706,
 1210140706,
 1209937155,
 12568,
 -1,
 1210079475,
 12564,
 1210271780,
 1210066587,
 12549,
 -1,
 1210240750,
 12704,
 -47067,
 1210246102,
 12562,
 -47066,
 1210374246,
 12586,
 -47065,
 1210434424,
 12554,
 -47064,
 1210493398,
 12566,
 -47063,
 1210558406,
 12561,
 -47062,
 1210622059,
 12550,
 -47061,
 1210679368,
 12551,
 -47060,
 1210741700,
 12556,
 -47059,
 1210806518,
 12558,
 -47058,
 1210865907,
 12559,
 -47057,
 1210928798,
 12552,
 -1,
 1210988076,
 12553,
 1211236351,
 1206997132,
 -1,
 -47054,
 1211155320,
 12725,
 -47053,
 1211211883,
 12724,
 -47052,
 1211265270,
 12726,
 -1,
 1211324659,
 12727,
 1211516999,
 1206963489,
 -1,
 1211582523,
 1211477748,
 -1,
 1211648058,
 1211510019,
 -1,
 -47047,
 1211610357,
 8972,
 -1,
 1211668974,
 8991,
 -1,
 1211587089,
 11813,
 1211910208,
 1211528950,
 -1,
 1211975743,
 1211837699,
 -1,
 -47042,
 1211938037,
 8973,
 -1,
 1211996654,
 8990,
 -1,
 1211914769,
 11812,
 1212237890,
 1211875323,
 9141,
 -1,
 1212155949,
 9142,
 -47037,
 1212205841,
 9185,
 -47036,
 1212326312,
 9181,
 -47035,
 1212373550,
 8993,
 -47034,
 1212429750,
 9183,
 -1,
 1212490059,
 10555,
 1212743679,
 1211491252,
 8904,
 1212809215,
 1212615734,
 -1,
 -47030,
 1212723121,
 10706,
 -1,
 1212774251,
 10705,
 1212958931,
 1194541223,
 -1,
 1213024459,
 1212909890,
 -1,
 1213089993,
 1212961710,
 -1,
 1213155475,
 1213037122,
 -1,
 1213220950,
 1213114838,
 -1,
 1213286484,
 1213142414,
 2480,
 1213399039,
 1213205558,
 -1,
 -47021,
 1213302067,
 2544,
 -1,
 1213365969,
 2545,
 -47019,
 1213246001,
 2524,
 -1,
 1213487377,
 2525,
 1213679707,
 1213193441,
 -1,
 1213745241,
 1213639126,
 2443,
 -1,
 1213704662,
 2528,
 1213923327,
 1213690820,
 2444,
 -1,
 1213821892,
 2529,
 1214007393,
 1213645688,
 -1,
 1214072927,
 1213973368,
 -1,
 -47010,
 1214011665,
 2464,
 -1,
 1214059918,
 2463,
 -47008,
 1214011665,
 2469,
 -1,
 1214190990,
 2468,
 1214400614,
 1213958466,
 -1,
 -47005,
 1214375164,
 2462,
 -47004,
 1214417310,
 2467,
 -47003,
 1214468959,
 2457,
 -1,
 1214518670,
 2472,
 1214728300,
 1214330412,
 -1,
 1214793834,
 1214658092,
 -1,
 -46999,
 1214732561,
 2466,
 -1,
 1214780814,
 2465,
 -46997,
 1214732561,
 2471,
 -1,
 1214911886,
 2470,
 1215121520,
 1214649742,
 2437,
 -46994,
 1215090414,
 2452,
 -46993,
 1215128039,
 2448,
 -1,
 1215174030,
 2438,
 1215383668,
 1215084464,
 -1,
 -46990,
 1215346730,
 2487,
 -46989,
 1215387921,
 2486,
 -1,
 1215436174,
 2488,
 1215645816,
 1215328502,
 -1,
 1215711351,
 1215584529,
 2454,
 -1,
 1215662913,
 2510,
 -1,
 1215632782,
 2453,
 1215907963,
 1215620288,
 -1,
 -46982,
 1215882492,
 2527,
 -1,
 1215894926,
 2479,
 1216104573,
 1215876846,
 2441,
 -1,
 1216073454,
 2442,
 1216235648,
 1216061547,
 -1,
 -46977,
 1216174353,
 2475,
 -1,
 1216222606,
 2474,
 1216432259,
 1216180119,
 -1,
 -46974,
 1216370961,
 2461,
 -1,
 1216419214,
 2460,
 1216628869,
 1216373223,
 2439,
 -1,
 1216569831,
 2440,
 1216759944,
 1216566059,
 -1,
 -46969,
 1216698641,
 2456,
 -1,
 1216746894,
 2455,
 1216956555,
 1216687363,
 -1,
 -46966,
 1216895249,
 2459,
 -1,
 1216943502,
 2458,
 1217153166,
 1216882331,
 -1,
 -46963,
 1217091857,
 2477,
 -1,
 1217140110,
 2476,
 -46961,
 1217106418,
 2451,
 -46960,
 1217298581,
 2478,
 -46959,
 1217360921,
 2482,
 -46958,
 1217419537,
 2489,
 -1,
 1217478823,
 2447,
 1217677475,
 1213128072,
 -1,
 1217743001,
 1217649889,
 -1,
 1217808535,
 1217702358,
 2499,
 -1,
 1217767894,
 2500,
 1217986559,
 1217754052,
 2530,
 -1,
 1217885124,
 2531,
 1218070685,
 1217664398,
 -1,
 -46949,
 1218039534,
 2508,
 -46948,
 1218077159,
 2504,
 -1,
 1218123150,
 2494,
 1218332831,
 1218039534,
 2497,
 -1,
 1218301678,
 2498,
 1218463905,
 1218273767,
 2495,
 -1,
 1218404839,
 2496,
 -46942,
 1218417138,
 2507,
 -1,
 1218527399,
 2503,
 1218726065,
 1217608100,
 -1,
 1218791591,
 1218691960,
 -1,
 -46938,
 1218765409,
 2536,
 -1,
 1218797758,
 2537,
 1218988202,
 1218754480,
 -1,
 -46935,
 1218932572,
 2540,
 -1,
 1218989231,
 2541,
 1219184813,
 1218924190,
 -1,
 -46932,
 1219140722,
 2538,
 -1,
 1219194597,
 2539,
 -46930,
 1219160175,
 2534,
 -46929,
 1219335714,
 2535,
 -46928,
 1219398943,
 2543,
 -1,
 1219446103,
 2542,
 1219643578,
 1218690241,
 -1,
 1219709109,
 1219615799,
 -1,
 -46924,
 1219672246,
 2435,
 -1,
 1219734287,
 2509,
 1219905720,
 1219630478,
 -1,
 -46921,
 1219876989,
 2493,
 -1,
 1219924264,
 2434,
 -46919,
 1219858584,
 2492,
 -1,
 1220029913,
 2433,
 1220233411,
 1219573211,
 -1,
 1220298946,
 1220186339,
 -1,
 1220364479,
 1220264824,
 -1,
 -46914,
 1220338273,
 2549,
 -1,
 1220370622,
 2550,
 1220561089,
 1220318754,
 2548,
 -1,
 1220478352,
 2552,
 -1,
 1220497944,
 2551,
 -1,
 1220229067,
 2553,
 1220823238,
 1220196171,
 -1,
 -46907,
 1220787388,
 2547,
 -1,
 1220838077,
 2546,
 -46905,
 1220767176,
 2554,
 -46904,
 1220957146,
 2555,
 -1,
 1221010871,
 2519,
 1221263359,
 1213065307,
 9004,
 -1,
 1221135444,
 9187,
 1221347534,
 1212990328,
 -1,
 -46899,
 1221320487,
 8812,
 -1,
 1221331623,
 8502,
 1221544145,
 1221270777,
 -1,
 -46896,
 1221508543,
 9836,
 -1,
 1221543288,
 9835,
 -46894,
 1221491829,
 9086,
 -1,
 1221668468,
 8757,
 1221871962,
 1212904473,
 -1,
 1221937497,
 1221800260,
 -1,
 1222003022,
 1221853184,
 -1,
 1222068455,
 1221930243,
 -1,
 1222133983,
 1222008000,
 -1,
 1222199515,
 1222078710,
 -1,
 -46886,
 1222151427,
 9822,
 -1,
 1222207759,
 9818,
 -46884,
 1222161648,
 9820,
 -46883,
 1222355249,
 9819,
 -46882,
 1222418964,
 9823,
 -1,
 1222453740,
 9821,
 1222658276,
 1222077578,
 9679,
 1222770687,
 1222577206,
 -1,
 -46878,
 1222696865,
 9864,
 -46877,
 1222758062,
 9865,
 -1,
 1222786680,
 10733,
 -46875,
 1222620457,
 9960,
 -46874,
 1222934417,
 9827,
 -1,
 1222985814,
 10028,
 1223182583,
 1222031280,
 -1,
 1223248112,
 1223131208,
 -1,
 1223313647,
 1223171021,
 -1,
 1223379181,
 1223276464,
 -1,
 -46868,
 1223345352,
 11089,
 -1,
 1223403681,
 9642,
 -46866,
 1223327532,
 11050,
 -1,
 1223506233,
 11049,
 -1,
 1223255688,
 9787,
 -46863,
 1223217786,
 9728,
 -46862,
 1223738568,
 9733,
 -46861,
 1223796897,
 9632,
 -46860,
 1223860480,
 9824,
 -46859,
 1223921452,
 9927,
 -46858,
 1223974613,
 9751,
 -1,
 1224028453,
 9986,
 1224231177,
 1223128004,
 -1,
 1224296705,
 1224164282,
 -1,
 1224362237,
 1224216787,
 -1,
 -46853,
 1224330142,
 9664,
 -46852,
 1224392388,
 9666,
 -1,
 1224451431,
 9668,
 1224624384,
 1224278016,
 -1,
 -46849,
 1224582546,
 9754,
 -1,
 1224635742,
 9944,
 -1,
 1224597073,
 8268,
 1224886534,
 1224249842,
 -1,
 1224952069,
 1224859458,
 -1,
 -46844,
 1224913085,
 9698,
 -1,
 1224964185,
 9699,
 -1,
 1224927333,
 10731,
 1225261055,
 1224810941,
 -1,
 -46840,
 1225179124,
 11035,
 -1,
 1225207905,
 11044,
 1225410839,
 1224190422,
 -1,
 1225476374,
 1225352523,
 -1,
 1225541905,
 1225396435,
 -1,
 1225607439,
 1225498731,
 -1,
 -46834,
 1225561146,
 9658,
 -1,
 1225607151,
 11091,
 -46832,
 1225575326,
 9654,
 -1,
 1225768644,
 9656,
 1225935125,
 1225514540,
 -1,
 1226000660,
 1225859719,
 10145,
 -1,
 1225939870,
 10148,
 -1,
 1225927780,
 8269,
 -1,
 1225853305,
 9755,
 -1,
 1225409139,
 9644,
 1226328355,
 1225340460,
 -1,
 1226393885,
 1226269363,
 9670,
 1226506239,
 1226309632,
 -1,
 -46821,
 1226432694,
 10730,
 -46820,
 1226490440,
 9830,
 -1,
 1226540589,
 10070,
 1226721568,
 1226353538,
 -1,
 -46817,
 1226670681,
 9922,
 -1,
 1226732230,
 9923,
 1226964991,
 1226678330,
 -1,
 -46814,
 1226886046,
 9660,
 -1,
 1226948292,
 9662,
 1227114796,
 1226297070,
 -1,
 1227180331,
 1227071595,
 -1,
 1227245864,
 1227137750,
 -1,
 -46809,
 1227206845,
 9701,
 -1,
 1227257945,
 9700,
 1227489279,
 1227165907,
 -1,
 -46806,
 1227410334,
 9650,
 -1,
 1227472580,
 9652,
 -1,
 1227132313,
 9851,
 1227704628,
 1227063368,
 -1,
 1227770163,
 1227637562,
 -1,
 1227835697,
 1227732912,
 -1,
 -46800,
 1227794593,
 9724,
 -1,
 1227850284,
 9726,
 -46798,
 1227783980,
 11047,
 -1,
 1227962681,
 11045,
 -1,
 1227724591,
 9912,
 1228228923,
 1227643123,
 -1,
 1228294456,
 1228182002,
 -1,
 -46793,
 1228265093,
 10711,
 -1,
 1228321725,
 11052,
 1228537855,
 1228226727,
 -1,
 -46790,
 1228465145,
 11042,
 -1,
 1228481249,
 9829,
 1228687680,
 1228200535,
 -1,
 1228753215,
 1228654694,
 -1,
 -46786,
 1228713097,
 9646,
 -1,
 1228752404,
 11054,
 -1,
 1228727519,
 11037,
 1229015364,
 1228653432,
 -1,
 -46782,
 1228989293,
 9942,
 -46781,
 1229043454,
 9951,
 -1,
 1229080067,
 9742,
 1229277513,
 1228951198,
 -1,
 1229343048,
 1229222852,
 -1,
 -46777,
 1229297978,
 10047,
 -1,
 1229330616,
 9873,
 -1,
 1229298902,
 10022,
 1229605196,
 1229234283,
 -1,
 -46773,
 1229539311,
 11039,
 -1,
 1229594910,
 9648,
 -46771,
 1229556966,
 10002,
 -1,
 1229728633,
 10707,
 1229979647,
 1221922534,
 -1,
 1229998421,
 1229879882,
 -1,
 -46767,
 1229973496,
 8488,
 -46766,
 1230023126,
 8476,
 -46765,
 1230070247,
 8465,
 -46764,
 1230133491,
 8460,
 -1,
 1230187779,
 8493,
 1230438399,
 1229934468,
 -1,
 -46761,
 1230356345,
 10164,
 -46760,
 1230418220,
 10165,
 -1,
 1230474887,
 10166,
 -1,
 1221889487,
 9250,
 1230719388,
 1221840622,
 -1,
 1230784896,
 1230657028,
 -1,
 1230850424,
 1230731842,
 -1,
 1230915942,
 1230801218,
 -1,
 1230981473,
 1230890176,
 -1,
 -46752,
 1230908768,
 6671,
 -1,
 1230968206,
 6670,
 1231178084,
 1230918443,
 -1,
 -46749,
 1231122701,
 6659,
 -1,
 1231164814,
 6658,
 -46747,
 1231137329,
 6667,
 -1,
 1231295886,
 6666,
 1231505769,
 1230864456,
 -1,
 -46744,
 1231462608,
 6663,
 -1,
 1231492494,
 6662,
 -46742,
 1231480060,
 6672,
 -46741,
 1231673460,
 6675,
 -46740,
 1231733689,
 6664,
 -46739,
 1231796266,
 6676,
 -46738,
 1231858225,
 6673,
 -46737,
 1231921360,
 6660,
 -46736,
 1231975449,
 6674,
 -46735,
 1232040205,
 6656,
 -46734,
 1232105369,
 6669,
 -46733,
 1232165137,
 6678,
 -46732,
 1232229215,
 6657,
 -46731,
 1232287383,
 6665,
 -46730,
 1232350560,
 6668,
 -46729,
 1232414413,
 6661,
 -1,
 1232475534,
 6677,
 1232685438,
 1230822792,
 -1,
 -46726,
 1232654062,
 6680,
 -46725,
 1232703986,
 6682,
 -46724,
 1232757223,
 6679,
 -46723,
 1232814247,
 6681,
 -1,
 1232869470,
 6683,
 -46721,
 1232642350,
 6686,
 -1,
 1233012617,
 6687,
 1233209752,
 1230724388,
 -1,
 1233275285,
 1233156674,
 -1,
 1233340805,
 1233226050,
 -1,
 -46716,
 1233277791,
 5957,
 -1,
 1233327502,
 5960,
 -46714,
 1233315068,
 5964,
 -46713,
 1233509890,
 5967,
 -46712,
 1233571566,
 5954,
 -46711,
 1233634233,
 5958,
 -46710,
 1233696810,
 5968,
 -46709,
 1233758769,
 5965,
 -46708,
 1233821904,
 5961,
 -46707,
 1233879189,
 5963,
 -46706,
 1233941529,
 5966,
 -46705,
 1234006285,
 5955,
 -46704,
 1234067943,
 5953,
 -46703,
 1234131217,
 5969,
 -46702,
 1234195295,
 5956,
 -46701,
 1234253463,
 5959,
 -46700,
 1234314957,
 5962,
 -1,
 1234376078,
 5952,
 1234632703,
 1233247624,
 -1,
 -46697,
 1234554606,
 5971,
 -1,
 1234592231,
 5970,
 1234829311,
 1233157226,
 -1,
 1234848155,
 1234717546,
 8226,
 -1,
 1234765450,
 8729,
 -1,
 1234811540,
 9678,
 1235091455,
 1230660071,
 -1,
 1235110304,
 1234981677,
 -1,
 -46689,
 1235074870,
 10744,
 -1,
 1235135961,
 10745,
 -1,
 1235063775,
 9763,
 1235373838,
 1133230000,
 -1,
 1235438366,
 1235331142,
 -1,
 1235503901,
 1235397638,
 -1,
 1235569361,
 1235419136,
 -1,
 1235634646,
 1235517512,
 -1,
 1235700143,
 1235603184,
 -1,
 -46680,
 1235672538,
 13244,
 -46679,
 1235736678,
 13238,
 -46678,
 1235793840,
 13234,
 -46677,
 1235845192,
 13211,
 -46676,
 1235907524,
 13205,
 -46675,
 1235964715,
 13197,
 -46674,
 1236029086,
 13196,
 -1,
 1236080014,
 13186,
 1236289974,
 1235621262,
 13187,
 1236355507,
 1236230631,
 -1,
 -46670,
 1236317947,
 13124,
 -1,
 1236366218,
 13123,
 -46668,
 1236317981,
 13126,
 -46667,
 1236504454,
 13127,
 -1,
 1236557037,
 13125,
 1236748733,
 1236205568,
 -1,
 1236814267,
 1236701682,
 -1,
 1236879802,
 1236785778,
 13223,
 -1,
 1236798089,
 13224,
 -1,
 1236819627,
 13249,
 -46660,
 1236779018,
 13217,
 -1,
 1237005706,
 13221,
 1237207490,
 1236689383,
 -1,
 1237273024,
 1237167750,
 13129,
 -1,
 1237198548,
 13130,
 -46655,
 1237218244,
 13269,
 -1,
 1237349263,
 13128,
 1237535174,
 1237155912,
 13212,
 1237647359,
 1237450752,
 -1,
 -46651,
 1237565450,
 13215,
 -1,
 1237595530,
 13219,
 1237797322,
 1237467303,
 -1,
 1237862857,
 1237734239,
 13131,
 -1,
 1237830212,
 13132,
 -1,
 1237797921,
 13133,
 1238059468,
 1237769690,
 13245,
 -1,
 1237976545,
 13247,
 1238190542,
 1238030438,
 13239,
 -1,
 1238107617,
 13241,
 1238321616,
 1238115995,
 13190,
 -1,
 1238239857,
 13268,
 -46639,
 1238284208,
 13235,
 -46638,
 1238409424,
 13227,
 -46637,
 1238471797,
 13270,
 -46636,
 1238528964,
 13206,
 -46635,
 1238589924,
 13202,
 -1,
 1238651691,
 13198,
 1238845945,
 1235579126,
 -1,
 1238911453,
 1238794312,
 13214,
 1239023615,
 1238827008,
 -1,
 1239042524,
 1238904067,
 -1,
 -46629,
 1239011229,
 13222,
 -1,
 1239031795,
 13262,
 -1,
 1239007242,
 13218,
 1239304673,
 1238854934,
 13076,
 -46625,
 1239277258,
 13079,
 -46624,
 1239319588,
 13078,
 -1,
 1239373992,
 13077,
 1239566822,
 1239225742,
 13188,
 1239632357,
 1239525846,
 -1,
 -46620,
 1239587179,
 13069,
 -1,
 1239623066,
 13068,
 -1,
 1239575809,
 13067,
 1239894505,
 1239537187,
 -1,
 -46616,
 1239865427,
 13082,
 -1,
 1239914312,
 13083,
 1240091116,
 1239847410,
 -1,
 -46613,
 1240053569,
 13085,
 -1,
 1240111115,
 13086,
 -46611,
 1240065982,
 13074,
 -46610,
 1240260058,
 13246,
 -46609,
 1240324198,
 13240,
 -46608,
 1240384376,
 13263,
 -46607,
 1240441040,
 13226,
 -46606,
 1240495044,
 13208,
 -46605,
 1240559862,
 13261,
 -46604,
 1240621540,
 13201,
 -46603,
 1240683307,
 13199,
 -46602,
 1240744856,
 13084,
 -46601,
 1240804723,
 13193,
 -46600,
 1240868507,
 13189,
 -1,
 1240925789,
 13248,
 1241139734,
 1238802539,
 -1,
 1241205248,
 1241071783,
 -1,
 1241270782,
 1241155906,
 -1,
 -46595,
 1241235989,
 13114,
 -1,
 1241277945,
 13112,
 -46593,
 1241235218,
 13111,
 -1,
 1241403029,
 13115,
 1241598469,
 1241126286,
 13225,
 1241664004,
 1241519502,
 -1,
 -46589,
 1241632045,
 13100,
 -1,
 1241692681,
 13099,
 -1,
 1241579632,
 13184,
 1241926154,
 1241539047,
 -1,
 1241991689,
 1241870582,
 -1,
 -46584,
 1241962256,
 13103,
 -1,
 1242010098,
 13104,
 -1,
 1241916553,
 13102,
 1242253837,
 1241879026,
 -1,
 -46580,
 1242205010,
 13120,
 -1,
 1242262238,
 13117,
 -46578,
 1242226138,
 13242,
 -46577,
 1242421350,
 13236,
 -46576,
 1242478512,
 13232,
 -46575,
 1242540502,
 13274,
 -46574,
 1242604837,
 13273,
 -46573,
 1242660936,
 13272,
 -46572,
 1242716403,
 13271,
 -46571,
 1242779294,
 13194,
 -1,
 1242836227,
 13174,
 1243040302,
 1241112026,
 -1,
 1243105836,
 1242984002,
 -1,
 1243171359,
 1243075837,
 -1,
 1243236892,
 1243131636,
 -1,
 -46565,
 1243204078,
 9640,
 -1,
 1243232511,
 11028,
 1243480063,
 1243182838,
 -1,
 -46562,
 1243400705,
 9639,
 -1,
 1243429119,
 9705,
 1243630116,
 1243116484,
 -1,
 1243695651,
 1243586504,
 -1,
 -46558,
 1243656046,
 9706,
 -1,
 1243707180,
 11029,
 -1,
 1243628512,
 9703,
 -46555,
 1243601797,
 9637,
 -46554,
 1243925175,
 11026,
 -46553,
 1243983793,
 9704,
 -46552,
 1244043835,
 9638,
 -46551,
 1244094362,
 9636,
 -46550,
 1244149990,
 9641,
 -46549,
 1244214107,
 10720,
 -1,
 1244277523,
 11027,
 -46547,
 1243031195,
 13277,
 -1,
 1244407194,
 13143,
 1244613186,
 1242978547,
 -1,
 1244678707,
 1244581614,
 -1,
 -46543,
 1244637981,
 13109,
 -46542,
 1244685834,
 13107,
 -1,
 1244733681,
 13106,
 1244940856,
 1244631538,
 -1,
 1245006391,
 1244893682,
 -1,
 -46538,
 1244968699,
 13121,
 -1,
 1245022530,
 13122,
 -1,
 1244956994,
 13119,
 1245268538,
 1244897387,
 13259,
 -1,
 1245189518,
 13169,
 1245399613,
 1245200551,
 -1,
 -46532,
 1245362035,
 13113,
 -1,
 1245410210,
 13110,
 1245596223,
 1245320590,
 13258,
 -1,
 1245540038,
 13098,
 -46528,
 1245571064,
 13200,
 -46527,
 1245670515,
 127488,
 -1,
 1245729579,
 13004,
 1245923921,
 1244549931,
 -1,
 1245989447,
 1245864423,
 -1,
 -46523,
 1245951752,
 13075,
 -46522,
 1246006547,
 13073,
 -1,
 1246057311,
 13072,
 1246251595,
 1245910414,
 -1,
 -46519,
 1246213323,
 13070,
 -46518,
 1246268889,
 13071,
 -1,
 1246327748,
 13311,
 1246513741,
 1246221913,
 13080,
 -1,
 1246480964,
 13081,
 -46514,
 1246487744,
 13257,
 -46513,
 1246601424,
 13228,
 -46512,
 1246650852,
 13203,
 -1,
 1246701211,
 13191,
 1246906976,
 1245882838,
 -1,
 1246972502,
 1246847463,
 -1,
 -46508,
 1246940455,
 13137,
 -46507,
 1246997041,
 13138,
 -1,
 1247040870,
 10958,
 1247234649,
 1246894075,
 13229,
 1247346687,
 1247152140,
 13230,
 -1,
 1247218313,
 13231,
 1247431260,
 1247203054,
 -1,
 -46501,
 1247400076,
 13140,
 -1,
 1247454250,
 13139,
 1247627871,
 1247363239,
 -1,
 -46498,
 1247580247,
 13142,
 -1,
 1247643668,
 13141,
 -1,
 1247582034,
 8730,
 1247890030,
 1246833923,
 -1,
 1247955557,
 1247838280,
 13213,
 1248067583,
 1247870976,
 -1,
 -46492,
 1247985674,
 13216,
 -1,
 1248015754,
 13220,
 1248217703,
 1247908338,
 13255,
 -1,
 1248179683,
 13183,
 1248348778,
 1248138638,
 -1,
 -46487,
 1248305259,
 8851,
 -1,
 1248359364,
 13192,
 -46485,
 1248318376,
 8852,
 -46484,
 1248474668,
 13253,
 -46483,
 1248537859,
 13252,
 -1,
 1248593796,
 13254,
 1248807546,
 1247819308,
 -1,
 1248873075,
 1248755784,
 13175,
 1248985087,
 1248788480,
 -1,
 -46478,
 1248903178,
 13176,
 -1,
 1248933258,
 13177,
 1249135221,
 1248793998,
 13170,
 -1,
 1249059965,
 13092,
 -46474,
 1249090168,
 13094,
 -46473,
 1249211332,
 13207,
 -46472,
 1249275799,
 127376,
 -46471,
 1249331918,
 13093,
 -1,
 1249388187,
 13256,
 1249593987,
 1248758082,
 -1,
 1249659517,
 1249514894,
 13185,
 -1,
 1249611249,
 13096,
 -46466,
 1249631706,
 13243,
 -46465,
 1249761382,
 13237,
 -46464,
 1249818544,
 13233,
 -46463,
 1249876892,
 13097,
 -46462,
 1249935432,
 13210,
 -1,
 1249988254,
 13195,
 1250183822,
 1249525927,
 -1,
 1250249355,
 1250142678,
 -1,
 1250314890,
 1250170279,
 -1,
 -46457,
 1250280497,
 13181,
 -46456,
 1250345829,
 13180,
 -46455,
 1250395185,
 13182,
 -1,
 1250450562,
 13179,
 -1,
 1250251563,
 13005,
 -46452,
 1250220134,
 13006,
 -46451,
 1250673240,
 13063,
 -1,
 1250706893,
 13064,
 1250904728,
 1250146224,
 -1,
 1250970258,
 1250838498,
 -1,
 -46447,
 1250922994,
 13091,
 -1,
 1250976231,
 13090,
 1251166869,
 1250891150,
 -1,
 -46444,
 1251119146,
 13088,
 -1,
 1251173951,
 13087,
 -46442,
 1251137638,
 13276,
 -46441,
 1251322326,
 13275,
 -1,
 1251372293,
 13089,
 1251560097,
 1250845159,
 -1,
 1251625628,
 1251510594,
 13260,
 -46437,
 1251592286,
 13061,
 -1,
 1251633532,
 13060,
 1251822240,
 1251573969,
 8847,
 1251934207,
 1251739314,
 -1,
 -46433,
 1251839688,
 8932,
 -1,
 1251887399,
 8849,
 -1,
 1251790574,
 13178,
 1252149930,
 1251485339,
 -1,
 1252215461,
 1252070798,
 -1,
 -46428,
 1252174294,
 13172,
 -1,
 1252204968,
 13101,
 -46426,
 1252185990,
 13108,
 -46425,
 1252370374,
 13251,
 -46424,
 1252432508,
 13118,
 -46423,
 1252486486,
 13105,
 -1,
 1252541341,
 13116,
 1252739762,
 1252070798,
 -1,
 -46420,
 1252708078,
 13171,
 -46419,
 1252767506,
 13057,
 -46418,
 1252827381,
 13056,
 -46417,
 1252888371,
 13058,
 -46416,
 1252950088,
 13250,
 -46415,
 1252991763,
 13059,
 -1,
 1253050297,
 13279,
 1253264058,
 1252692466,
 -1,
 1253329591,
 1253224929,
 8848,
 1253441535,
 1253246642,
 -1,
 -46410,
 1253347016,
 8933,
 -1,
 1253394727,
 8850,
 -46408,
 1253300326,
 13173,
 -46407,
 1253545356,
 13066,
 -1,
 1253609286,
 13065,
 1253788354,
 1253209028,
 -1,
 1253853886,
 1253741042,
 -1,
 -46403,
 1253828709,
 8977,
 -1,
 1253856043,
 13266,
 -46401,
 1253827542,
 13267,
 -46400,
 1254000962,
 13265,
 -46399,
 1254064200,
 13264,
 -1,
 1254114296,
 10957,
 1254312647,
 1253762240,
 -1,
 1254378182,
 1254233617,
 -1,
 -46395,
 1254340347,
 13135,
 -1,
 1254374096,
 13134,
 -1,
 1254346601,
 13136,
 1254640332,
 1254248094,
 -1,
 1254705867,
 1254593010,
 -1,
 -46390,
 1254676006,
 9974,
 -1,
 1254726348,
 9165,
 -1,
 1254654024,
 13209,
 1254968015,
 1254605688,
 -1,
 -46386,
 1254921616,
 13095,
 -1,
 1254973924,
 13204,
 -46384,
 1254938728,
 13278,
 -1,
 1255134107,
 13062,
 1255342079,
 1235498542,
 -1,
 1255361280,
 1255223597,
 -1,
 1255426787,
 1255281699,
 -1,
 1255492311,
 1255347547,
 -1,
 -46378,
 1255412569,
 127511,
 -1,
 1255477947,
 127509,
 1255688922,
 1255412582,
 -1,
 -46375,
 1255624448,
 127534,
 -1,
 1255681671,
 127506,
 1255885533,
 1255609025,
 -1,
 -46372,
 1255805981,
 127516,
 -1,
 1255871166,
 127520,
 -46370,
 1255821059,
 127517,
 -46369,
 1256011622,
 127532,
 -46368,
 1256072898,
 127505,
 -46367,
 1256133975,
 127524,
 -46366,
 1256199190,
 127525,
 -1,
 1256264375,
 127518,
 1256475376,
 1255347355,
 -1,
 1256540904,
 1256395457,
 -1,
 -46362,
 1256461700,
 127527,
 -46361,
 1256526981,
 127537,
 -1,
 1256592410,
 127504,
 1256803051,
 1256461347,
 -1,
 -46358,
 1256728231,
 127519,
 -1,
 1256789383,
 127515,
 1256999662,
 1256723302,
 -1,
 -46355,
 1256920200,
 127528,
 -1,
 1256985119,
 127535,
 -46353,
 1256935164,
 127526,
 -1,
 1257116888,
 127513,
 1257327351,
 1256395808,
 -1,
 1257392884,
 1257247145,
 -1,
 -46349,
 1257313627,
 127530,
 -1,
 1257378217,
 127529,
 -46347,
 1257313806,
 127512,
 -46346,
 1257510228,
 127508,
 -1,
 1257575260,
 127533,
 1257786107,
 1257248039,
 -1,
 -46343,
 1257715347,
 127536,
 -46342,
 1257778531,
 127523,
 -1,
 1257837962,
 127510,
 1258048255,
 1257706720,
 -1,
 -46339,
 1257977487,
 127521,
 -46338,
 1258034305,
 127522,
 -1,
 1258099369,
 127514,
 -1,
 1257969023,
 127531,
 1258375942,
 1255323568,
 -1,
 -46334,
 1258338224,
 127309,
 -46333,
 1258399905,
 10696,
 -46332,
 1258455461,
 10695,
 -46331,
 1258501676,
 127308,
 -1,
 1258560645,
 9949,
 1258769164,
 1258321462,
 -1,
 -46328,
 1258741210,
 127302,
 -46327,
 1258796976,
 127298,
 -46326,
 1258856555,
 127295,
 -46325,
 1258916162,
 127293,
 -1,
 1258956443,
 127281,
 1259162383,
 1258725483,
 -1,
 -46322,
 1259120572,
 127310,
 -1,
 1259175880,
 8862,
 1259358994,
 1259110472,
 -1,
 -46319,
 1259329638,
 127307,
 -1,
 1259367185,
 8863,
 1259555605,
 1259303158,
 -1,
 -46316,
 1259490945,
 9919,
 -1,
 1259545783,
 127507,
 1259752216,
 1259490974,
 -1,
 -46313,
 1259707515,
 11820,
 -1,
 1259740191,
 10693,
 -46311,
 1259718882,
 8864,
 -46310,
 1259909974,
 10692,
 -46309,
 1259954607,
 127306,
 -46308,
 1260010396,
 8865,
 -1,
 1260069929,
 10694,
 -1,
 1235469197,
 10151,
 1260342269,
 1235412160,
 -1,
 1260407688,
 1260301961,
 -1,
 1260473162,
 1260354114,
 -1,
 1260538666,
 1260435376,
 -1,
 1260604198,
 1260491659,
 -1,
 -46300,
 1260579005,
 1869,
 -46299,
 1260614303,
 1870,
 -1,
 1260670830,
 1871,
 -46297,
 1260573891,
 1809,
 -46296,
 1260805611,
 1835,
 -46295,
 1260865246,
 1827,
 -1,
 1260918837,
 1832,
 1261128495,
 1260495407,
 1830,
 1261240319,
 1261090450,
 -1,
 -46291,
 1261131049,
 1838,
 -46290,
 1261189259,
 1839,
 -1,
 1261250924,
 1837,
 1261456179,
 1261093752,
 -1,
 1261521714,
 1261390863,
 1819,
 -1,
 1261437981,
 1820,
 -1,
 1261446714,
 1836,
 1261718325,
 1261430708,
 1821,
 -1,
 1261634656,
 1822,
 1261849400,
 1261677014,
 -1,
 -46281,
 1261792631,
 1834,
 -1,
 1261849940,
 1831,
 1262046010,
 1261788048,
 1815,
 -1,
 1262012083,
 1818,
 1262177084,
 1261982644,
 1811,
 -1,
 1262093341,
 1812,
 1262308159,
 1262106156,
 -1,
 -46274,
 1262263145,
 1814,
 -1,
 1262295722,
 1813,
 -46272,
 1262282784,
 1817,
 -46271,
 1262477057,
 1816,
 -46270,
 1262528525,
 1833,
 -46269,
 1262588170,
 1826,
 -46268,
 1262650817,
 1825,
 -46267,
 1262712117,
 1824,
 -46266,
 1262776696,
 1823,
 -46265,
 1262833838,
 1828,
 -46264,
 1262895271,
 1829,
 -46263,
 1262954836,
 1810,
 -1,
 1263016590,
 1808,
 1263225685,
 1260411123,
 -1,
 1263291216,
 1263151074,
 -1,
 1263356751,
 1263206400,
 -1,
 -46258,
 1263282296,
 1851,
 -1,
 1263343247,
 1850,
 -1,
 1263275902,
 1852,
 1263618900,
 1263215146,
 -1,
 -46254,
 1263571557,
 1803,
 -46253,
 1263633606,
 1804,
 -1,
 1263674398,
 1805,
 -1,
 1263573405,
 1797,
 1263946590,
 1263190549,
 -1,
 1264012122,
 1263904355,
 -1,
 1264077657,
 1263940120,
 1795,
 -1,
 1263995461,
 1800,
 -1,
 1264014090,
 1793,
 1264320511,
 1263938220,
 -1,
 1264339805,
 1264202264,
 1796,
 -1,
 1264257618,
 1801,
 -1,
 1264276234,
 1794,
 1264536421,
 1263911800,
 -1,
 1264601954,
 1264509765,
 -1,
 -46239,
 1264527480,
 1860,
 -1,
 1264588431,
 1859,
 1264844799,
 1264541930,
 -1,
 -46236,
 1264724088,
 1862,
 -1,
 1264785039,
 1861,
 1264995179,
 1264495062,
 -1,
 1265060713,
 1264920551,
 -1,
 -46232,
 1264986232,
 1847,
 -1,
 1265047183,
 1846,
 -46230,
 1265032724,
 1855,
 -1,
 1265226049,
 1858,
 1265388399,
 1264970022,
 -1,
 -46227,
 1265318912,
 1845,
 -46226,
 1265379448,
 1844,
 -1,
 1265440399,
 1843,
 1265650547,
 1265346394,
 -1,
 -46223,
 1265581056,
 1842,
 -46222,
 1265641592,
 1841,
 -1,
 1265702543,
 1840,
 1265912696,
 1265582247,
 -1,
 1265978231,
 1265875132,
 -1,
 -46218,
 1265903736,
 1854,
 -1,
 1265964687,
 1853,
 -1,
 1265928914,
 1792,
 1266240381,
 1265840652,
 -1,
 1266305916,
 1266187641,
 -1,
 -46213,
 1266265838,
 1799,
 -1,
 1266317041,
 1798,
 -1,
 1266258014,
 1802,
 1266568064,
 1266193019,
 -1,
 -46209,
 1266493560,
 1864,
 -1,
 1266554511,
 1863,
 1266764675,
 1266498657,
 -1,
 -46206,
 1266704181,
 1848,
 -1,
 1266753269,
 1849,
 -46204,
 1266723276,
 1857,
 -46203,
 1266911459,
 1865,
 -46202,
 1266962399,
 1856,
 -46201,
 1267017690,
 1866,
 -1,
 1267078729,
 1807,
 1267289028,
 1260355159,
 -1,
 1267354549,
 1267235394,
 -1,
 1267420048,
 1267319672,
 -1,
 1267485582,
 1267385208,
 -1,
 -46195,
 1267438066,
 43024,
 -1,
 1267490503,
 43025,
 -46193,
 1267438066,
 43028,
 -1,
 1267621575,
 43029,
 1267813270,
 1267349036,
 -1,
 1267878804,
 1267742252,
 -1,
 -46189,
 1267831282,
 43026,
 -1,
 1267883719,
 43027,
 -46187,
 1267831282,
 43030,
 -1,
 1268014791,
 43031,
 1268206489,
 1267771862,
 -1,
 -46184,
 1268167781,
 43040,
 -1,
 1268224498,
 43038,
 1268403100,
 1268162667,
 -1,
 -46181,
 1268355570,
 43033,
 -1,
 1268408007,
 43034,
 1268599711,
 1268347126,
 -1,
 -46178,
 1268552178,
 43015,
 -1,
 1268604615,
 43016,
 1268796322,
 1268543383,
 -1,
 -46175,
 1268748786,
 43022,
 -1,
 1268801223,
 43023,
 1268992933,
 1268732715,
 -1,
 -46172,
 1268945394,
 43017,
 -1,
 1268997831,
 43018,
 1269189544,
 1268919555,
 -1,
 -46169,
 1269142002,
 43020,
 -1,
 1269194439,
 43021,
 1269386155,
 1269114523,
 -1,
 -46166,
 1269338610,
 43035,
 -1,
 1269391047,
 43036,
 -46164,
 1269354222,
 43011,
 -46163,
 1269546770,
 43041,
 -46162,
 1269600754,
 43013,
 -46161,
 1269665265,
 43032,
 -46160,
 1269728919,
 43037,
 -46159,
 1269792044,
 43039,
 -46158,
 1269850599,
 43009,
 -46157,
 1269915335,
 43042,
 -46156,
 1269973159,
 43012,
 -1,
 1270027662,
 43008,
 1270238139,
 1267326344,
 -1,
 -46153,
 1270206190,
 43045,
 -46152,
 1270257414,
 43047,
 -46151,
 1270309351,
 43044,
 -46150,
 1270366375,
 43046,
 -1,
 1270420878,
 43043,
 1270631360,
 1270195496,
 -1,
 -46147,
 1270551510,
 43051,
 -46146,
 1270616934,
 43050,
 -46145,
 1270682305,
 43049,
 -1,
 1270747689,
 43048,
 1271005183,
 1270594753,
 -1,
 -46142,
 1270897498,
 43014,
 -46141,
 1270956171,
 43010,
 -1,
 1271013308,
 43019,
 1271267327,
 1267236936,
 -1,
 1271286780,
 1271147225,
 -1,
 1271352274,
 1271248816,
 -1,
 1271417801,
 1271320678,
 9242,
 -1,
 1271333845,
 9254,
 1271548876,
 1271383244,
 -1,
 -46133,
 1271514798,
 9218,
 -1,
 1271552937,
 9217,
 1271745487,
 1271487825,
 -1,
 -46130,
 1271700782,
 9230,
 -1,
 1271752600,
 9231,
 -46128,
 1271719664,
 9238,
 -46127,
 1271898363,
 9248,
 -1,
 1271930032,
 8527,
 1272138717,
 1271281196,
 -1,
 1272204252,
 1272070311,
 -1,
 1272269786,
 1272175687,
 -1,
 1272335320,
 1272234872,
 -1,
 -46121,
 1272308321,
 9234,
 -1,
 1272340670,
 9235,
 -46119,
 1272288802,
 9233,
 -1,
 1272467992,
 9236,
 1272709119,
 1272216120,
 9249,
 -1,
 1272579029,
 9253,
 -1,
 1272128664,
 9232,
 1272859623,
 1272070311,
 -1,
 1272925158,
 1272809794,
 -1,
 1272990693,
 1272854092,
 -1,
 1273056228,
 1272955768,
 -1,
 1273121763,
 1273015120,
 9220,
 -1,
 1273037413,
 9239,
 -1,
 1273056719,
 9219,
 -1,
 1273005019,
 9241,
 -1,
 1272949140,
 9221,
 -1,
 1272887549,
 9243,
 1273514988,
 1272809794,
 -1,
 1273580523,
 1273446567,
 -1,
 -46102,
 1273553434,
 9252,
 -1,
 1273582620,
 9237,
 -1,
 1273549210,
 9216,
 1273842671,
 1273450142,
 -1,
 -46098,
 1273797064,
 9228,
 -1,
 1273849456,
 9244,
 1274039282,
 1273769312,
 -1,
 -46095,
 1274000923,
 9229,
 -1,
 1274055315,
 9240,
 1274235893,
 1273964187,
 -1,
 -46092,
 1274168848,
 9223,
 -1,
 1274222507,
 9224,
 -46090,
 1274207225,
 9227,
 -46089,
 1274401622,
 9247,
 -46088,
 1274457170,
 9246,
 -46087,
 1274510202,
 9226,
 -46086,
 1274568688,
 9225,
 -46085,
 1274632272,
 9245,
 -1,
 1274681247,
 9222,
 -1,
 1271235799,
 9007,
 1274956988,
 1260262798,
 -1,
 1275022442,
 1274926687,
 -1,
 1275087937,
 1274968642,
 -1,
 1275153415,
 1275058278,
 -1,
 1275218950,
 1275105976,
 -1,
 1275284484,
 1275177430,
 43144,
 -1,
 1275242966,
 43145,
 1275461631,
 1275229124,
 43146,
 -1,
 1275360196,
 43147,
 -1,
 1275139470,
 43182,
 1275612173,
 1275118456,
 -1,
 1275677707,
 1275577208,
 -1,
 -46070,
 1275615505,
 43165,
 -1,
 1275663758,
 43164,
 -46068,
 1275615505,
 43170,
 -1,
 1275794830,
 43169,
 1276005394,
 1275562306,
 -1,
 -46065,
 1275979004,
 43163,
 -46064,
 1276021150,
 43168,
 -46063,
 1276072799,
 43158,
 -1,
 1276122510,
 43173,
 1276333080,
 1275934252,
 -1,
 1276398614,
 1276261932,
 -1,
 -46059,
 1276336401,
 43167,
 -1,
 1276384654,
 43166,
 -46057,
 1276336401,
 43172,
 -1,
 1276515726,
 43171,
 1276726300,
 1276253582,
 43138,
 -46054,
 1276694254,
 43153,
 -46053,
 1276731879,
 43150,
 -1,
 1276777870,
 43139,
 1276988448,
 1276688304,
 -1,
 -46050,
 1276950570,
 43184,
 -46049,
 1276991761,
 43183,
 -1,
 1277040014,
 43185,
 1277250594,
 1276956398,
 43142,
 -1,
 1277218542,
 43143,
 1277381669,
 1277206635,
 -1,
 -46044,
 1277319441,
 43175,
 -1,
 1277367694,
 43174,
 1277578279,
 1277334002,
 43151,
 -1,
 1277530610,
 43152,
 1277709354,
 1277522884,
 -1,
 -46039,
 1277654041,
 43187,
 -1,
 1277695374,
 43181,
 1277905965,
 1277653238,
 -1,
 -46036,
 1277843729,
 43155,
 -1,
 1277891982,
 43154,
 1278102576,
 1277849495,
 -1,
 -46033,
 1278040337,
 43162,
 -1,
 1278088590,
 43161,
 1278299186,
 1278042599,
 43140,
 -1,
 1278239207,
 43141,
 1278430261,
 1278235435,
 -1,
 -46028,
 1278368017,
 43157,
 -1,
 1278416270,
 43156,
 1278626871,
 1278361767,
 43148,
 -1,
 1278558375,
 43149,
 1278757946,
 1278553347,
 -1,
 -46023,
 1278695697,
 43160,
 -1,
 1278743950,
 43159,
 1278954557,
 1278682779,
 -1,
 -46020,
 1278892305,
 43177,
 -1,
 1278940558,
 43176,
 -46018,
 1278928124,
 43179,
 -46017,
 1279109681,
 43180,
 -46016,
 1279164565,
 43178,
 -1,
 1279219985,
 43186,
 1279413331,
 1275059592,
 -1,
 1279478855,
 1279384801,
 -1,
 1279544389,
 1279437270,
 43194,
 -1,
 1279502806,
 43195,
 1279721471,
 1279488964,
 43196,
 -1,
 1279620036,
 43197,
 1279806539,
 1279399310,
 -1,
 -46007,
 1279774446,
 43203,
 -46006,
 1279812071,
 43200,
 -1,
 1279858062,
 43189,
 1280068685,
 1279774446,
 43192,
 -1,
 1280036590,
 43193,
 1280199759,
 1280020978,
 43201,
 -1,
 1280152050,
 43202,
 1280330833,
 1280139751,
 43190,
 -1,
 1280270823,
 43191,
 1280507903,
 1280262311,
 43198,
 -1,
 1280393383,
 43199,
 1280592996,
 1279342124,
 -1,
 1280658530,
 1280533986,
 -1,
 1280724056,
 1280623480,
 -1,
 -45993,
 1280696929,
 43218,
 -1,
 1280729278,
 43219,
 1280920667,
 1280686000,
 -1,
 -45990,
 1280864092,
 43222,
 -1,
 1280920751,
 43223,
 1281117278,
 1280855710,
 -1,
 -45987,
 1281072242,
 43220,
 -1,
 1281126117,
 43221,
 -45985,
 1281091695,
 43216,
 -45984,
 1281267234,
 43217,
 -45983,
 1281330463,
 43225,
 -1,
 1281377623,
 43224,
 -45981,
 1280613349,
 43215,
 -1,
 1281498725,
 43214,
 1281707113,
 1280556225,
 -1,
 1281772648,
 1281678391,
 -1,
 -45977,
 1281734838,
 43137,
 -1,
 1281796879,
 43204,
 -1,
 1281695676,
 43136,
 -1,
 1281635023,
 43188,
 1282100408,
 1274970804,
 -1,
 1282165894,
 1282046530,
 -1,
 1282231408,
 1282130808,
 -1,
 -45970,
 1282193458,
 2065,
 -45969,
 1282239981,
 2056,
 -1,
 1282283034,
 2069,
 1282493556,
 1282171367,
 -1,
 -45966,
 1282467008,
 2052,
 -45965,
 1282524024,
 2055,
 -1,
 1282574658,
 2063,
 1282755703,
 1282455472,
 -1,
 -45962,
 1282697560,
 2062,
 -1,
 1282759297,
 2068,
 1282952314,
 1282680475,
 -1,
 -45959,
 1282895341,
 2049,
 -1,
 1282938385,
 2053,
 -45957,
 1282926679,
 2054,
 -45956,
 1283123140,
 2057,
 -45955,
 1283175225,
 2067,
 -45954,
 1283238242,
 2066,
 -45953,
 1283297546,
 2061,
 -45952,
 1283360193,
 2060,
 -45951,
 1283421273,
 2059,
 -45950,
 1283485978,
 2058,
 -45949,
 1283543994,
 2050,
 -45948,
 1283608657,
 2064,
 -45947,
 1283667677,
 2051,
 -1,
 1283725951,
 2048,
 1283935384,
 1282137480,
 -1,
 1284000909,
 1283882373,
 -1,
 1284066442,
 1283921294,
 2082,
 -1,
 1283986830,
 2079,
 -45941,
 1284034286,
 2086,
 -45940,
 1284137447,
 2089,
 -1,
 1284194471,
 2076,
 1284394128,
 1283953138,
 2091,
 1284505599,
 1284364955,
 2081,
 -1,
 1284380046,
 2078,
 1284590739,
 1284356016,
 -1,
 -45934,
 1284559181,
 2092,
 -1,
 1284595754,
 2085,
 1284787349,
 1284511118,
 2083,
 -1,
 1284707726,
 2080,
 -45930,
 1284755182,
 2087,
 -45929,
 1284858343,
 2090,
 -1,
 1284915367,
 2077,
 1285115051,
 1283893117,
 -1,
 1285180576,
 1285035406,
 -1,
 1285246109,
 1285130562,
 -1,
 -45924,
 1285196210,
 2110,
 -1,
 1285248156,
 2098,
 -45922,
 1285212618,
 2100,
 -45921,
 1285403625,
 2108,
 -1,
 1285444256,
 2097,
 1285639331,
 1285154808,
 -1,
 -45918,
 1285581913,
 2104,
 -1,
 1285625964,
 2106,
 1285835942,
 1285601200,
 -1,
 -45915,
 1285788518,
 2109,
 -1,
 1285840526,
 2101,
 -45913,
 1285803474,
 2107,
 -45912,
 1285990440,
 2105,
 -45911,
 1286048741,
 2096,
 -45910,
 1286112316,
 2103,
 -1,
 1286154251,
 2099,
 1286360247,
 1285062728,
 -1,
 1286425779,
 1286283782,
 -1,
 1286491311,
 1286367128,
 2070,
 -1,
 1286409987,
 2071,
 -45904,
 1286443712,
 2072,
 -45903,
 1286573029,
 2093,
 -45902,
 1286621372,
 2075,
 -1,
 1286682295,
 2073,
 1286930431,
 1286378275,
 -1,
 -45899,
 1286847477,
 2084,
 -45898,
 1286889959,
 2088,
 -1,
 1286949052,
 2074,
 -1,
 1286280777,
 2102,
 -45895,
 1282067839,
 9796,
 -45894,
 1287159672,
 9747,
 -45893,
 1287218772,
 9973,
 -1,
 1287280168,
 9808,
 1287474549,
 1274924782,
 -1,
 1287539974,
 1287424322,
 9737,
 1287605509,
 1287468796,
 -1,
 1287671011,
 1287551554,
 -1,
 1287736516,
 1287620930,
 -1,
 -45886,
 1287709948,
 7057,
 -45885,
 1287738207,
 7053,
 -1,
 1287787918,
 7060,
 1287998663,
 1287698352,
 -1,
 -45882,
 1287972092,
 7087,
 -1,
 1287984526,
 7070,
 1288195274,
 1287942390,
 -1,
 -45879,
 1288132881,
 7086,
 -1,
 1288181134,
 7050,
 1288391884,
 1288126631,
 7048,
 -1,
 1288359662,
 7049,
 1288522958,
 1288312206,
 7043,
 -1,
 1288454311,
 7046,
 -45873,
 1288497162,
 7056,
 -45872,
 1288627452,
 7066,
 -45871,
 1288692726,
 7071,
 -45870,
 1288756738,
 7069,
 -45869,
 1288820852,
 7063,
 -45868,
 1288883950,
 7045,
 -45867,
 1288946617,
 7058,
 -45866,
 1289005617,
 7067,
 -45865,
 1289070540,
 7051,
 -45864,
 1289134288,
 7061,
 -45863,
 1289196018,
 7047,
 -45862,
 1289257109,
 7065,
 -45861,
 1289319449,
 7068,
 -45860,
 1289383833,
 7055,
 -45859,
 1289445863,
 7044,
 -45858,
 1289509137,
 7072,
 -45857,
 1289573215,
 7052,
 -45856,
 1289637639,
 7062,
 -45855,
 1289696919,
 7059,
 -45854,
 1289760096,
 7054,
 -1,
 1289823949,
 7064,
 1290030321,
 1287600548,
 -1,
 1290095847,
 1289995128,
 -1,
 -45850,
 1290068577,
 7090,
 -1,
 1290100926,
 7091,
 1290292458,
 1290057648,
 -1,
 -45847,
 1290235740,
 7094,
 -1,
 1290292399,
 7095,
 1290489069,
 1290227358,
 -1,
 -45844,
 1290443890,
 7092,
 -1,
 1290497765,
 7093,
 -45842,
 1290463343,
 7088,
 -45841,
 1290638882,
 7089,
 -45840,
 1290702111,
 7097,
 -1,
 1290749271,
 7096,
 1290947833,
 1290001812,
 -1,
 1291013368,
 1290897730,
 -1,
 -45836,
 1290987449,
 7077,
 -45835,
 1291031828,
 7079,
 -45834,
 1291081146,
 7076,
 -45833,
 1291144309,
 7081,
 -1,
 1291196539,
 7078,
 -1,
 1290962059,
 7080,
 1291472128,
 1290910954,
 -1,
 1291537663,
 1291422018,
 -1,
 1291603198,
 1291473707,
 -1,
 -45827,
 1291575358,
 7042,
 -1,
 1291613831,
 7041,
 -1,
 1291576730,
 7040,
 -1,
 1291485336,
 7082,
 1291976703,
 1291399908,
 -1,
 1291996420,
 1291882909,
 -1,
 -45821,
 1291937339,
 7075,
 -1,
 1291983380,
 7074,
 -1,
 1291945454,
 7073,
 -1,
 1287520805,
 9925,
 1292324151,
 1287496539,
 -1,
 1292389663,
 1292258157,
 -1,
 1292455186,
 1292342115,
 8835,
 1292566527,
 1292369920,
 -1,
 1292586255,
 1292441237,
 -1,
 -45812,
 1292552381,
 10952,
 -45811,
 1292603080,
 10956,
 -45810,
 1292650867,
 10950,
 -1,
 1292704838,
 10954,
 1292913937,
 1292540047,
 8839,
 -1,
 1292832031,
 10948,
 -1,
 1292886348,
 8843,
 1293110550,
 1292427332,
 -1,
 -45804,
 1293067541,
 10944,
 -45803,
 1293125740,
 10946,
 -1,
 1293171508,
 10942,
 1293372699,
 1293031061,
 -1,
 1293438234,
 1293337109,
 -1,
 -45799,
 1293394792,
 10966,
 -1,
 1293429811,
 10964,
 -1,
 1293383861,
 10619,
 1293700382,
 1293297881,
 -1,
 -45795,
 1293664796,
 10967,
 -1,
 1293688252,
 10968,
 -1,
 1293657742,
 10185,
 1294008319,
 1292317710,
 -1,
 1294028069,
 1293906884,
 -1,
 1294093604,
 1293952326,
 -1,
 -45789,
 1294043458,
 8319,
 -1,
 1294098919,
 8305,
 -1,
 1294025742,
 8317,
 1294355752,
 1293992824,
 -1,
 -45785,
 1294328417,
 178,
 -1,
 1294360766,
 179,
 1294552363,
 1294317488,
 -1,
 -45782,
 1294495580,
 8310,
 -1,
 1294552239,
 8311,
 1294748974,
 1294487198,
 -1,
 -45779,
 1294703730,
 8308,
 -1,
 1294757605,
 8309,
 1294945585,
 1294680231,
 -1,
 -45776,
 1294903429,
 8316,
 -1,
 1294951755,
 8312,
 -45774,
 1294919791,
 8304,
 -45773,
 1295101973,
 8318,
 -45772,
 1295164683,
 8314,
 -45771,
 1295226402,
 185,
 -45770,
 1295289631,
 8313,
 -1,
 1295353358,
 8315,
 1295535456,
 1292250147,
 -1,
 1295600972,
 1295463438,
 -1,
 1295666492,
 1295565688,
 -1,
 -45765,
 1295639137,
 8322,
 -1,
 1295671486,
 8323,
 1295863103,
 1295628208,
 -1,
 -45762,
 1295806300,
 8326,
 -1,
 1295862959,
 8327,
 1296059714,
 1295797918,
 -1,
 -45759,
 1296014450,
 8324,
 -1,
 1296068325,
 8325,
 1296256325,
 1295990951,
 -1,
 -45756,
 1296214149,
 8332,
 -1,
 1296262475,
 8328,
 -45754,
 1296230511,
 8320,
 -45753,
 1296412693,
 8334,
 -45752,
 1296475403,
 8330,
 -45751,
 1296537122,
 8321,
 -45750,
 1296600351,
 8329,
 -45749,
 1296664078,
 8331,
 -1,
 1296725960,
 8333,
 1296957439,
 1295534957,
 -1,
 1296977239,
 1296864099,
 8834,
 1297088511,
 1296891904,
 -1,
 1297108308,
 1296963221,
 -1,
 -45743,
 1297074365,
 10951,
 -45742,
 1297125064,
 10955,
 -45741,
 1297172851,
 10949,
 -1,
 1297226822,
 10953,
 1297435990,
 1297062031,
 8838,
 -1,
 1297354015,
 10947,
 -1,
 1297408332,
 8842,
 1297632603,
 1296949316,
 -1,
 -45735,
 1297589525,
 10943,
 -45734,
 1297647724,
 10945,
 -1,
 1297693492,
 10941,
 1297940479,
 1297553045,
 -1,
 1297960287,
 1297859093,
 -1,
 -45730,
 1297916776,
 10963,
 -1,
 1297951795,
 10965,
 -1,
 1297920300,
 10617,
 1298222448,
 1295462026,
 8827,
 1298333695,
 1298137088,
 -1,
 1298353515,
 1298208405,
 -1,
 1298419046,
 1298316662,
 -1,
 -45723,
 1298370248,
 10930,
 -1,
 1298418035,
 10928,
 1298615657,
 1298370217,
 -1,
 -45720,
 1298549031,
 10934,
 -1,
 1298603078,
 10938,
 -45718,
 1298549107,
 10932,
 -1,
 1298734150,
 10936,
 1298943342,
 1298307199,
 -1,
 -45715,
 1298886356,
 8831,
 -1,
 1298930250,
 8829,
 -45713,
 1298911980,
 8881,
 -1,
 1299066030,
 8937,
 1299271028,
 1298171491,
 -1,
 -45710,
 1299243292,
 10763,
 -45709,
 1299303075,
 9138,
 -1,
 1299327734,
 9139,
 -1,
 1299230280,
 8751,
 1299598846,
 1287414247,
 -1,
 1299664368,
 1299548482,
 -1,
 1299729897,
 1299601893,
 -1,
 1299795402,
 1299675714,
 -1,
 1299860879,
 1299715470,
 -1,
 1299926407,
 1299808056,
 -1,
 1299991934,
 1299891064,
 -1,
 -45699,
 1299957003,
 3495,
 -1,
 1299981940,
 3501,
 1300188545,
 1299920428,
 -1,
 -45696,
 1300117312,
 3497,
 -1,
 1300178548,
 3503,
 -45694,
 1300144665,
 3508,
 -45693,
 1300328964,
 3482,
 -45692,
 1300393907,
 3490,
 -45691,
 1300452430,
 3484,
 -45690,
 1300508282,
 3488,
 -1,
 1300572175,
 3510,
 1300778378,
 1299857575,
 -1,
 -45687,
 1300751696,
 3463,
 -1,
 1300778628,
 3464,
 -45685,
 1300751696,
 3461,
 -45684,
 1300944969,
 3478,
 -45683,
 1300988705,
 3513,
 -45682,
 1301049226,
 3475,
 -1,
 1301096052,
 3462,
 1301302691,
 1299808328,
 -1,
 1301368223,
 1301222798,
 -1,
 1301433758,
 1301305630,
 -1,
 1301499285,
 1301398392,
 -1,
 -45676,
 1301464331,
 3496,
 -1,
 1301489268,
 3502,
 1301695896,
 1301427756,
 -1,
 -45673,
 1301624640,
 3498,
 -1,
 1301685876,
 3504,
 -45671,
 1301651993,
 3509,
 -45670,
 1301836292,
 3483,
 -45669,
 1301901235,
 3491,
 -45668,
 1301959758,
 3485,
 -45667,
 1302015610,
 3489,
 -1,
 1302079503,
 3511,
 -1,
 1301407056,
 3512,
 1302396927,
 1301338172,
 -1,
 -45663,
 1302313170,
 3522,
 -45662,
 1302366850,
 3499,
 -1,
 1302427263,
 3525,
 1302613420,
 1301242343,
 -1,
 1302678951,
 1302574843,
 -1,
 -45658,
 1302652240,
 3469,
 -1,
 1302714441,
 3470,
 1302875562,
 1302626174,
 -1,
 -45655,
 1302848848,
 3471,
 -1,
 1302911049,
 3472,
 -45653,
 1302848848,
 3465,
 -1,
 1303015306,
 3466,
 1303203250,
 1302575277,
 -1,
 1303268784,
 1303131692,
 -1,
 -45649,
 1303197504,
 3500,
 -1,
 1303258740,
 3507,
 -45647,
 1303211955,
 3494,
 -1,
 1303401550,
 3487,
 1303596471,
 1303167948,
 -1,
 1303662006,
 1303558186,
 -1,
 -45643,
 1303635280,
 3521,
 -1,
 1303679455,
 3493,
 -1,
 1303611815,
 3492,
 1303924155,
 1303525124,
 -1,
 -45639,
 1303886034,
 3523,
 -45638,
 1303939714,
 3505,
 -1,
 1304000127,
 3517,
 1304186302,
 1303891694,
 -1,
 -45635,
 1304159568,
 3467,
 -1,
 1304221769,
 3468,
 1304382913,
 1304138226,
 -1,
 -45632,
 1304356176,
 3476,
 -1,
 1304404064,
 3477,
 1304579524,
 1304314023,
 -1,
 -45629,
 1304552784,
 3473,
 -1,
 1304579716,
 3474,
 -45627,
 1304552821,
 3514,
 -45626,
 1304746410,
 3520,
 -45625,
 1304800155,
 3515,
 -45624,
 1304850784,
 3486,
 -45623,
 1304910723,
 3524,
 -1,
 1304973158,
 3526,
 1305169379,
 1299766664,
 -1,
 1305234903,
 1305112822,
 -1,
 1305300435,
 1305187657,
 -1,
 1305365970,
 1305270388,
 3545,
 1305477119,
 1305281595,
 -1,
 -45616,
 1305367638,
 3550,
 -45615,
 1305426316,
 3549,
 -1,
 1305483376,
 3548,
 -1,
 1305281318,
 3547,
 1305804799,
 1305234535,
 -1,
 -45611,
 1305714923,
 3540,
 -45610,
 1305767261,
 3538,
 -1,
 1305811041,
 3536,
 1306021343,
 1305164166,
 -1,
 1306086875,
 1305957215,
 -1,
 -45606,
 1306060118,
 3571,
 -1,
 1306086485,
 3570,
 -45604,
 1306042603,
 3542,
 -45603,
 1306227464,
 3546,
 -45602,
 1306291549,
 3539,
 -1,
 1306335329,
 3537,
 1306545634,
 1305957215,
 -1,
 -45599,
 1306518870,
 3551,
 -1,
 1306545237,
 3544,
 -1,
 1306466416,
 3535,
 1306807784,
 1305132225,
 -1,
 1306873319,
 1306727822,
 -1,
 -45594,
 1306825029,
 3458,
 -1,
 1306883064,
 3530,
 -1,
 1306844356,
 3459,
 -1,
 1306765194,
 3572,
 1307201007,
 1299666497,
 -1,
 1307266541,
 1307145156,
 -1,
 -45588,
 1307221918,
 8218,
 -1,
 1307264066,
 8249,
 -45586,
 1307226365,
 8250,
 -1,
 1307401656,
 8219,
 -1,
 1307132189,
 8767,
 1307659768,
 1299613089,
 -1,
 1307725300,
 1307613307,
 -1,
 -45581,
 1307670967,
 10909,
 -1,
 1307727711,
 10910,
 1307921911,
 1307645589,
 -1,
 -45578,
 1307867619,
 10911,
 -1,
 1307924369,
 10912,
 -1,
 1307870751,
 10860,
 1308229631,
 1307632598,
 -1,
 1308249596,
 1308100721,
 -1,
 -45573,
 1308202024,
 10038,
 -1,
 1308248994,
 10046,
 -45571,
 1308214659,
 10042,
 -1,
 1308364981,
 8198,
 1308577360,
 1299536115,
 -1,
 1308642883,
 1308497294,
 -1,
 1308708414,
 1308613690,
 -1,
 1308773899,
 1308628366,
 -1,
 1308839429,
 1308731862,
 -1,
 -45564,
 1308797847,
 66684,
 -1,
 1308836007,
 66680,
 -45562,
 1308811044,
 66679,
 -45561,
 1308998308,
 66664,
 -45560,
 1309043806,
 66682,
 -45559,
 1309104371,
 66669,
 -45558,
 1309168765,
 66673,
 -1,
 1309227728,
 66665,
 1309429266,
 1308725746,
 -1,
 -45555,
 1309398977,
 66668,
 -45554,
 1309452758,
 66681,
 -45553,
 1309515879,
 66677,
 -45552,
 1309575490,
 66666,
 -45551,
 1309632069,
 66678,
 -1,
 1309678053,
 66676,
 1309888024,
 1309360295,
 -1,
 1309953558,
 1309808014,
 -1,
 -45547,
 1309918072,
 66672,
 -1,
 1309977046,
 66685,
 -45545,
 1309914614,
 66683,
 -1,
 1310086385,
 66663,
 1310281245,
 1309852536,
 -1,
 1310346780,
 1310218483,
 -1,
 -45541,
 1310287160,
 66644,
 -1,
 1310346881,
 66654,
 -1,
 1310300876,
 66641,
 1310608929,
 1310220775,
 -1,
 -45537,
 1310543518,
 66662,
 -45536,
 1310600877,
 66674,
 -1,
 1310661987,
 66686,
 1310871076,
 1310582157,
 -1,
 -45533,
 1310842330,
 66687,
 -1,
 1310856590,
 66648,
 1311067687,
 1310843489,
 -1,
 -45530,
 1311020149,
 66667,
 -1,
 1311064231,
 66658,
 1311264298,
 1311029168,
 -1,
 -45527,
 1311233665,
 66646,
 -1,
 1311281650,
 66645,
 1311460909,
 1311211592,
 -1,
 -45524,
 1311401726,
 66661,
 -1,
 1311457691,
 66656,
 1311657520,
 1311398131,
 -1,
 -45521,
 1311626005,
 66649,
 -1,
 1311643133,
 66659,
 -45519,
 1311631650,
 66655,
 -45518,
 1311825239,
 66653,
 -45517,
 1311888296,
 66675,
 -45516,
 1311945848,
 66670,
 -45515,
 1312006765,
 66640,
 -45514,
 1312067850,
 66671,
 -45513,
 1312128368,
 66660,
 -45512,
 1312191165,
 66642,
 -45511,
 1312256218,
 66657,
 -45510,
 1312314267,
 66652,
 -45509,
 1312378802,
 66643,
 -45508,
 1312438122,
 66651,
 -45507,
 1312501815,
 66647,
 -1,
 1312565621,
 66650,
 1312771650,
 1308638786,
 -1,
 -45504,
 1312735467,
 10032,
 -45503,
 1312781923,
 10014,
 -1,
 1312829537,
 10061,
 -1,
 1312720905,
 9752,
 1313099342,
 1308594674,
 -1,
 1313164877,
 1313060525,
 -1,
 1313230409,
 1313133712,
 10976,
 1313341439,
 1313144832,
 -1,
 -45496,
 1313268193,
 10984,
 -1,
 1313281835,
 10985,
 1313492555,
 1313161011,
 10975,
 -1,
 1313410551,
 10983,
 -45492,
 1313452349,
 10564,
 -1,
 1313568781,
 10974,
 -1,
 1313132914,
 9085,
 -45489,
 1313067193,
 10722,
 -1,
 1313762019,
 9961,
 1313951392,
 1308524616,
 -1,
 1314016927,
 1313871246,
 -1,
 1314082462,
 1313963114,
 -1,
 1314147996,
 1313996800,
 -1,
 1314213490,
 1314105814,
 -1,
 1314279021,
 1314166065,
 -1,
 1314344540,
 1314243448,
 -1,
 1314410074,
 1314315738,
 -1,
 -45479,
 1314361842,
 8561,
 -1,
 1314408013,
 8571,
 -45477,
 1314349246,
 8562,
 -1,
 1314539281,
 8569,
 1314737762,
 1314279070,
 -1,
 1314803297,
 1314677223,
 -1,
 1314868832,
 1314773426,
 8564,
 -1,
 1314784374,
 8574,
 -1,
 1314804486,
 8572,
 -1,
 1314757746,
 8563,
 1315130982,
 1314690594,
 8560,
 1315241983,
 1315045376,
 -1,
 -45467,
 1315162049,
 8575,
 -1,
 1315201407,
 8573,
 1315393129,
 1315092400,
 -1,
 -45464,
 1315336028,
 8565,
 -1,
 1315392687,
 8566,
 1315589740,
 1315324071,
 -1,
 -45461,
 1315535496,
 8570,
 -1,
 1315595595,
 8567,
 -1,
 1315540255,
 8568,
 1315851889,
 1314219344,
 -1,
 -45457,
 1315818257,
 65118,
 -45456,
 1315873192,
 65114,
 -1,
 1315911094,
 65116,
 -1,
 1315786000,
 65128,
 1316179578,
 1314144423,
 -1,
 1316245111,
 1316125011,
 8714,
 1316356095,
 1316162614,
 -1,
 -45450,
 1316281141,
 8948,
 -1,
 1316331308,
 8951,
 -45448,
 1316217880,
 65111,
 -45447,
 1316464773,
 65126,
 -1,
 1316520036,
 65112,
 1316703876,
 1316106764,
 -1,
 1316769408,
 1316655056,
 -1,
 1316834943,
 1316741188,
 -1,
 -45442,
 1316805429,
 8956,
 -1,
 1316855596,
 8958,
 -1,
 1316758345,
 8717,
 1317097091,
 1316718167,
 -1,
 -45438,
 1317030359,
 65131,
 -1,
 1317082510,
 65104,
 -1,
 1317043573,
 65109,
 1317359242,
 1316648638,
 -1,
 1317424777,
 1317294761,
 -1,
 -45433,
 1317391121,
 65117,
 -45432,
 1317446056,
 65113,
 -1,
 1317483958,
 65115,
 -1,
 1317388368,
 65124,
 1317752461,
 1317323640,
 -1,
 -45428,
 1317724850,
 68411,
 -1,
 1317758567,
 732,
 1317949072,
 1317707883,
 -1,
 -45425,
 1317896153,
 65122,
 -1,
 1317947843,
 65130,
 1318145683,
 1317868942,
 -1,
 -45422,
 1318109456,
 65121,
 -1,
 1318160340,
 65120,
 -45420,
 1318115870,
 10849,
 -45419,
 1318304239,
 65108,
 -45418,
 1318365504,
 65110,
 -45417,
 1318424746,
 65119,
 -45416,
 1318478903,
 65105,
 -45415,
 1318543831,
 65123,
 -45414,
 1318606834,
 65125,
 -45413,
 1318671114,
 65106,
 -1,
 1318730497,
 65129,
 1318977535,
 1314081180,
 10922,
 -1,
 1318848220,
 10924,
 -1,
 1314044607,
 10803,
 -1,
 1313957484,
 8995,
 1319194300,
 1313903090,
 -1,
 1319259830,
 1319161582,
 -1,
 1319325365,
 1319225014,
 -1,
 1319390893,
 1319256469,
 -1,
 1319456426,
 1319314055,
 8600,
 1319567359,
 1319370752,
 -1,
 -45401,
 1319493883,
 10533,
 -45400,
 1319553508,
 8690,
 -45399,
 1319580909,
 10541,
 -1,
 1319640656,
 10537,
 -45397,
 1319427976,
 11010,
 -45396,
 1319779526,
 8664,
 -1,
 1319840296,
 11018,
 1320091647,
 1319362375,
 -1,
 1320111794,
 1319969415,
 8601,
 1320222719,
 1320026112,
 -1,
 -45391,
 1320149243,
 10534,
 -1,
 1320164873,
 10538,
 -45389,
 1320083336,
 11011,
 -45388,
 1320303814,
 8665,
 -1,
 1320364584,
 11019,
 -1,
 1319275234,
 8471,
 1320636088,
 1319205604,
 47,
 -1,
 1320553975,
 10742,
 1320767163,
 1320571558,
 -1,
 -45382,
 1320738443,
 9108,
 -1,
 1320748183,
 173,
 -1,
 1320693399,
 9917,
 1321029329,
 1319120131,
 -1,
 1321094863,
 1320987094,
 -1,
 1321160398,
 1321036884,
 -1,
 1321225929,
 1321086466,
 -1,
 -45375,
 1321183702,
 8475,
 -45374,
 1321246827,
 8472,
 -45373,
 1321304136,
 8499,
 -45372,
 1321366468,
 8466,
 -45371,
 1321427431,
 8464,
 -45370,
 1321490675,
 8459,
 -45369,
 1321553566,
 8497,
 -45368,
 1321615527,
 8496,
 -1,
 1321674395,
 8492,
 1321926655,
 1321188905,
 -1,
 -45365,
 1321832946,
 8500,
 -45364,
 1321890756,
 8467,
 -45363,
 1321947947,
 8458,
 -1,
 1322008743,
 8495,
 -1,
 1321129188,
 8456,
 -45360,
 1321048585,
 9807,
 -1,
 1322195804,
 9878,
 1322405600,
 1320960167,
 -1,
 1322471126,
 1322353908,
 -1,
 -45356,
 1322433164,
 9914,
 -45355,
 1322465801,
 10802,
 -1,
 1322529304,
 59,
 1322733273,
 1322432432,
 -1,
 -45352,
 1322690939,
 9916,
 -1,
 1322720497,
 65093,
 1322929884,
 1322661177,
 -1,
 -45349,
 1322883192,
 8980,
 -1,
 1322937354,
 167,
 -45347,
 1322902704,
 9913,
 -45346,
 1323090854,
 8726,
 -45345,
 1323153275,
 8480,
 -1,
 1323193976,
 8979,
 1323388655,
 1322369912,
 -1,
 1323454187,
 1323308430,
 -1,
 1323519720,
 1323411928,
 -1,
 1323585254,
 1323471346,
 -1,
 -45339,
 1323541224,
 8902,
 -1,
 1323585197,
 10017,
 -45337,
 1323518316,
 8795,
 -1,
 1323703711,
 9770,
 1323958271,
 1323454463,
 -1,
 -45334,
 1323850916,
 9882,
 -1,
 1323899015,
 9877,
 1324154879,
 1323411926,
 -1,
 -45331,
 1324049273,
 8803,
 -45330,
 1324108542,
 10025,
 -1,
 1324161369,
 9188,
 1324371708,
 1323332548,
 -1,
 1324437239,
 1324291470,
 -1,
 1324502774,
 1324388312,
 -1,
 1324568308,
 1324448183,
 10901,
 -1,
 1324485935,
 10903,
 1324744703,
 1324504927,
 10902,
 -1,
 1324617007,
 10904,
 -1,
 1324473668,
 42611,
 1324941311,
 1324390254,
 -1,
 1324961531,
 1324837159,
 -1,
 -45318,
 1324914808,
 10839,
 -1,
 1324948876,
 10840,
 -1,
 1324892327,
 9011,
 1325223685,
 1324327019,
 -1,
 1325289217,
 1325161622,
 8738,
 1325400063,
 1325205120,
 -1,
 -45312,
 1325323176,
 10657,
 -1,
 1325364977,
 10656,
 1325551364,
 1325208974,
 -1,
 -45309,
 1325511664,
 10055,
 -1,
 1325543085,
 32,
 -1,
 1325484776,
 8375,
 1325813513,
 1325174568,
 -1,
 1325879048,
 1325761113,
 9731,
 -1,
 1325797072,
 9924,
 -1,
 1325814078,
 10052,
 1326075660,
 1325756662,
 -1,
 -45301,
 1326043550,
 9760,
 -1,
 1326081179,
 9975,
 -45299,
 1326048199,
 8275,
 -1,
 1326187709,
 10700,
 1326404631,
 1235310835,
 -1,
 1326469668,
 1326323086,
 -1,
 1326535048,
 1326418242,
 -1,
 1326600559,
 1326469931,
 -1,
 1326666077,
 1326567769,
 -1,
 1326731323,
 1326608279,
 -1,
 1326796747,
 1326683843,
 -1,
 1326862139,
 1326755556,
 4527,
 1326972927,
 1326780134,
 -1,
 1326993184,
 1326882923,
 -1,
 1327058718,
 1326933166,
 4530,
 1327169535,
 1326976742,
 -1,
 -45285,
 1327089812,
 55257,
 -45284,
 1327152551,
 4563,
 -45283,
 1327211493,
 55258,
 -1,
 1327258934,
 4564,
 -45281,
 1326996803,
 4533,
 -1,
 1327374177,
 4567,
 1327583015,
 1326936310,
 -1,
 1327648549,
 1327525777,
 4528,
 1327759359,
 1327566566,
 -1,
 -45276,
 1327676839,
 4556,
 -1,
 1327717686,
 55254,
 -45274,
 1327586620,
 4568,
 -1,
 1327833197,
 4565,
 1328041772,
 1327531409,
 4529,
 1328152575,
 1327959782,
 -1,
 -45270,
 1328070055,
 4562,
 -45269,
 1328116443,
 4561,
 -1,
 1328176438,
 55256,
 1328369456,
 1328014733,
 -1,
 1328434991,
 1328322928,
 4569,
 -1,
 1328353295,
 55260,
 -1,
 1328397471,
 55259,
 1328631604,
 1328333688,
 -1,
 1328697139,
 1328571933,
 4558,
 -1,
 1328615439,
 4559,
 -1,
 1328635210,
 4532,
 1328893753,
 1328592816,
 -1,
 1328959288,
 1328855187,
 -1,
 -45257,
 1328922023,
 4566,
 -1,
 1328968411,
 55253,
 -1,
 1328901151,
 4531,
 -45254,
 1328844015,
 4557,
 -1,
 1329159478,
 4534,
 1329352540,
 1326823344,
 -1,
 1329418059,
 1329313939,
 -1,
 1329483585,
 1329380775,
 4539,
 1329594367,
 1329401574,
 -1,
 -45248,
 1329514644,
 55277,
 -1,
 1329558235,
 55276,
 1329745731,
 1329449108,
 55245,
 -1,
 1329664204,
 55246,
 1329876805,
 1329704676,
 4560,
 -1,
 1329795154,
 55255,
 -45242,
 1329832996,
 55270,
 -45241,
 1329958127,
 4607,
 -45240,
 1330021777,
 55264,
 -45239,
 1330082523,
 4521,
 -45238,
 1330144424,
 4590,
 -1,
 1330196560,
 55289,
 1330446335,
 1329359903,
 4538,
 1330511871,
 1330319078,
 -1,
 1330532176,
 1330430840,
 -1,
 -45233,
 1330472477,
 4584,
 -1,
 1330535754,
 55281,
 1330728787,
 1330487403,
 -1,
 -45230,
 1330668718,
 4586,
 -1,
 1330716513,
 55278,
 1330925398,
 1330671862,
 -1,
 -45227,
 1330868113,
 4583,
 -1,
 1330913389,
 55275,
 1331122009,
 1330851075,
 -1,
 -45224,
 1331061923,
 55279,
 -1,
 1331125551,
 55280,
 -45222,
 1331080932,
 4585,
 -45221,
 1331266961,
 55274,
 -1,
 1331322166,
 55282,
 1331515251,
 1329307755,
 -1,
 1331580778,
 1331455150,
 4536,
 1331691519,
 1331498726,
 -1,
 1331711841,
 1331608999,
 4537,
 -1,
 1331630486,
 55271,
 1331842915,
 1331670756,
 4579,
 -1,
 1331761347,
 55268,
 1331973990,
 1331768579,
 -1,
 -45211,
 1331913891,
 55272,
 -1,
 1331977519,
 55273,
 -45209,
 1331939476,
 55267,
 -45208,
 1332126693,
 4580,
 -45207,
 1332184465,
 55269,
 -1,
 1332239670,
 4581,
 1332432751,
 1331518787,
 4545,
 1332543487,
 1332350694,
 -1,
 -45203,
 1332463442,
 55291,
 -45202,
 1332526503,
 55290,
 -1,
 1332585508,
 4595,
 1332805631,
 1332354913,
 4587,
 1332871167,
 1332678374,
 -1,
 -45198,
 1332782116,
 55283,
 -1,
 1332834704,
 55284,
 1333022597,
 1331458294,
 -1,
 1333088126,
 1332965265,
 4520,
 1333198847,
 1333006054,
 -1,
 1333219192,
 1333116327,
 4522,
 -1,
 1333137509,
 4548,
 -45191,
 1333178084,
 4547,
 -45190,
 1333306404,
 4603,
 -45189,
 1333365999,
 4602,
 -45188,
 1333424805,
 4605,
 -45187,
 1333484854,
 4606,
 -1,
 1333538770,
 4604,
 1333743492,
 1333010533,
 -1,
 1333809026,
 1333698667,
 -1,
 -45183,
 1333748910,
 4582,
 -1,
 1333812547,
 4596,
 -45181,
 1333767908,
 55261,
 -1,
 1333953937,
 4578,
 -1,
 1333681468,
 4543,
 1334202263,
 1332970897,
 4535,
 1334312959,
 1334120166,
 -1,
 1334333324,
 1334228912,
 -1,
 1334398859,
 1334294675,
 -1,
 -45174,
 1334361511,
 4574,
 -1,
 1334414575,
 55263,
 -1,
 1334340639,
 4573,
 1334661008,
 1334288491,
 -1,
 1334726543,
 1334600878,
 4572,
 -1,
 1334645101,
 55265,
 -1,
 1334648673,
 4575,
 1334923155,
 1334586627,
 -1,
 -45166,
 1334863011,
 55266,
 -1,
 1334926639,
 4576,
 -45164,
 1334882020,
 4571,
 -45163,
 1335069935,
 55262,
 -45162,
 1335128795,
 4570,
 -1,
 1335188790,
 4577,
 1335381924,
 1334166392,
 -1,
 1335447459,
 1335322141,
 4526,
 1335558143,
 1335365350,
 -1,
 1335578524,
 1335475623,
 55248,
 -1,
 1335496805,
 55249,
 1335709599,
 1335504131,
 -1,
 -45154,
 1335649443,
 55250,
 -1,
 1335713071,
 55251,
 -45152,
 1335674706,
 55252,
 -45151,
 1335865060,
 4555,
 -45150,
 1335927844,
 55247,
 -1,
 1335980763,
 4554,
 -1,
 1335385418,
 4544,
 1336233905,
 1335332079,
 4523,
 1336344575,
 1336151782,
 -1,
 1336364969,
 1336263544,
 -1,
 -45144,
 1336305181,
 4550,
 -1,
 1336368458,
 4553,
 1336561580,
 1336290563,
 -1,
 -45141,
 1336501411,
 4524,
 -1,
 1336565039,
 55244,
 -45139,
 1336524199,
 4551,
 -45138,
 1336717028,
 55243,
 -45137,
 1336779086,
 4552,
 -45136,
 1336832731,
 4549,
 -1,
 1336892726,
 4525,
 1337085881,
 1336206733,
 -1,
 1337151416,
 1337048223,
 4592,
 1337262079,
 1337069286,
 -1,
 -45131,
 1337179559,
 4593,
 -45130,
 1337237838,
 4594,
 -45129,
 1337296273,
 55285,
 -1,
 1337351478,
 55286,
 -1,
 1337104752,
 4601,
 1337610175,
 1337023798,
 4546,
 1337720831,
 1337528038,
 -1,
 -45124,
 1337634532,
 4598,
 -45123,
 1337697316,
 4600,
 -45122,
 1337756911,
 4597,
 -1,
 1337820561,
 4599,
 1338003397,
 1337549992,
 4540,
 1338114047,
 1337921254,
 -1,
 1338134468,
 1338011894,
 -1,
 -45117,
 1338077073,
 4588,
 -1,
 1338137916,
 4591,
 -1,
 1338097772,
 4589,
 1338441727,
 1337928963,
 -1,
 1338462154,
 1338336419,
 4541,
 1338572799,
 1338380006,
 -1,
 -45111,
 1338491000,
 55288,
 -1,
 1338549284,
 55287,
 -1,
 1338400047,
 4542,
 1338834943,
 1326764825,
 -1,
 1338855409,
 1338762432,
 -1,
 1338920920,
 1338822382,
 4466,
 1339031551,
 1338838758,
 -1,
 1339051985,
 1338959245,
 4498,
 -1,
 1339003378,
 4497,
 1339183059,
 1338982567,
 4496,
 -1,
 1339134450,
 4495,
 1339314133,
 1339102606,
 4494,
 -1,
 1339244711,
 55223,
 -45098,
 1339281134,
 4499,
 -45097,
 1339396594,
 55224,
 -1,
 1339449831,
 4500,
 1339641827,
 1338872306,
 4461,
 1339752447,
 1339559654,
 -1,
 1339772894,
 1339679936,
 -1,
 1339838429,
 1339692430,
 4484,
 -1,
 1339768999,
 4485,
 -1,
 1339771023,
 4486,
 1340035040,
 1339692430,
 55218,
 -1,
 1339965607,
 55219,
 -45087,
 1339986418,
 4487,
 -45086,
 1340105191,
 4488,
 -1,
 1340164239,
 55220,
 1340362729,
 1339572391,
 4456,
 1340473343,
 1340314098,
 4455,
 1340538879,
 1340346086,
 -1,
 -45081,
 1340466428,
 4517,
 -45080,
 1340526318,
 4478,
 -1,
 1340576242,
 4477,
 1340755951,
 1340282254,
 4451,
 1340821486,
 1340673766,
 -1,
 -45076,
 1340794628,
 4473,
 -45075,
 1340853998,
 4516,
 -1,
 1340903922,
 4472,
 -1,
 1340752039,
 4452,
 1341194239,
 1340695015,
 4468,
 -1,
 1341067678,
 4503,
 1341280258,
 1338794471,
 4469,
 1341390847,
 1341198054,
 -1,
 1341411323,
 1341318336,
 -1,
 1341476855,
 1341330830,
 4505,
 -45066,
 1341407399,
 55230,
 -1,
 1341460639,
 55229,
 1341673465,
 1341407399,
 55232,
 -1,
 1341624818,
 55231,
 -45062,
 1341640430,
 55235,
 -1,
 1341755890,
 55234,
 1341935613,
 1341362674,
 4506,
 -1,
 1341853760,
 55233,
 1342066687,
 1341855118,
 4504,
 -1,
 1342024323,
 4509,
 -45056,
 1342033646,
 4507,
 -45055,
 1342136807,
 55236,
 -1,
 1342196845,
 4508,
 1342394384,
 1341210791,
 4454,
 1342459915,
 1342361326,
 4467,
 1342570495,
 1342377702,
 -1,
 1342590984,
 1342455975,
 55227,
 -45049,
 1342557934,
 4502,
 -1,
 1342607858,
 55226,
 -45047,
 1342557934,
 4501,
 -45046,
 1342738930,
 55228,
 -1,
 1342772622,
 55225,
 1343029247,
 1342411250,
 4453,
 1343094783,
 1342901990,
 -1,
 -45042,
 1343016686,
 4475,
 -45041,
 1343066610,
 4474,
 -1,
 1343114349,
 4476,
 1343311901,
 1342345714,
 4457,
 1343377436,
 1343229670,
 -1,
 1343442967,
 1343349952,
 -1,
 1343508501,
 1343373479,
 4481,
 -1,
 1343459826,
 55216,
 1343684607,
 1343427982,
 4518,
 -1,
 1343570087,
 4519,
 1343770649,
 1343394290,
 4482,
 -1,
 1343688768,
 55217,
 1343901723,
 1343701159,
 4480,
 -1,
 1343853042,
 4479,
 -1,
 1343868654,
 4483,
 -1,
 1343307943,
 4460,
 1344163882,
 1343231374,
 4449,
 1344229413,
 1344121475,
 4510,
 1344339967,
 1344147174,
 -1,
 1344360482,
 1344225447,
 55238,
 -1,
 1344311794,
 4511,
 -45021,
 1344327406,
 4512,
 -45020,
 1344430567,
 4513,
 -1,
 1344476558,
 55237,
 1344688169,
 1344147174,
 -1,
 -45017,
 1344655086,
 4471,
 -45016,
 1344705010,
 4470,
 -1,
 1344752749,
 4515,
 -1,
 1344618663,
 4450,
 1345015859,
 1344130798,
 4462,
 1345126399,
 1344933606,
 -1,
 1345146926,
 1345054093,
 4492,
 -1,
 1345098226,
 55221,
 1345278000,
 1345066382,
 4489,
 -1,
 1345208487,
 4490,
 -45007,
 1345244910,
 4493,
 -45006,
 1345348199,
 55222,
 -1,
 1345407122,
 4491,
 1345605689,
 1344986586,
 -1,
 1345671222,
 1345536167,
 4464,
 -1,
 1345622514,
 4463,
 1345802296,
 1345590670,
 4458,
 -1,
 1345732775,
 4459,
 -1,
 1345741287,
 4465,
 -44998,
 1345568865,
 4514,
 -1,
 1345933415,
 4448,
 1346130149,
 1326657538,
 -1,
 1346195553,
 1346090928,
 -1,
 1346261074,
 1346137119,
 4361,
 1346371583,
 1346178790,
 -1,
 1346392131,
 1346281579,
 -1,
 1346457666,
 1346331822,
 4402,
 -1,
 1346375781,
 4403,
 -1,
 1346395459,
 4410,
 1346654278,
 1346356088,
 -1,
 -44987,
 1346594333,
 4399,
 -1,
 1346657610,
 4409,
 1346850889,
 1346597110,
 -1,
 -44984,
 1346793361,
 4397,
 -1,
 1346854204,
 4408,
 1347047500,
 1346776323,
 -1,
 -44981,
 1346987171,
 4406,
 -1,
 1347050799,
 4407,
 -44979,
 1347010691,
 4404,
 -44978,
 1347202788,
 4400,
 -44977,
 1347259631,
 4398,
 -44976,
 1347323281,
 4401,
 -44975,
 1347380392,
 4405,
 -1,
 1347444022,
 4411,
 1347682303,
 1346222227,
 -1,
 1347702870,
 1347601272,
 -1,
 -44971,
 1347642909,
 4356,
 -1,
 1347706186,
 43385,
 1347899480,
 1347665319,
 4362,
 -1,
 1347817676,
 43381,
 1348030554,
 1347825744,
 4365,
 -1,
 1347948559,
 43384,
 -44965,
 1348003353,
 43388,
 -44964,
 1348120292,
 4377,
 -44963,
 1348183076,
 4360,
 -44962,
 1348242671,
 4372,
 -44961,
 1348301531,
 4353,
 -44960,
 1348363432,
 4423,
 -1,
 1348427062,
 4440,
 1348620415,
 1346150507,
 -1,
 1348685946,
 1348560046,
 4359,
 1348796415,
 1348603622,
 -1,
 1348817006,
 1348712368,
 -1,
 1348882541,
 1348758559,
 4385,
 1348993023,
 1348800230,
 -1,
 1349013610,
 1348911992,
 -1,
 -44951,
 1348953629,
 4387,
 -1,
 1349016906,
 43378,
 -44949,
 1348969508,
 4388,
 -44948,
 1349153499,
 4386,
 -1,
 1349202000,
 4390,
 -1,
 1348843672,
 4389,
 1349472369,
 1348780920,
 -1,
 -44944,
 1349412381,
 4384,
 -1,
 1349475658,
 4393,
 1349668980,
 1349415158,
 -1,
 -44941,
 1349611409,
 4382,
 -1,
 1349672252,
 43379,
 1349865591,
 1349594371,
 -1,
 -44938,
 1349805219,
 4391,
 -1,
 1349868847,
 4392,
 -44936,
 1349821413,
 4394,
 -44935,
 1350012143,
 4383,
 -1,
 1350065462,
 43380,
 1350258814,
 1348623683,
 4369,
 1350369279,
 1350176486,
 -1,
 -44931,
 1350280228,
 4438,
 -1,
 1350327606,
 43386,
 -1,
 1350180705,
 4416,
 1350586521,
 1348545795,
 -1,
 1350652046,
 1350524145,
 -1,
 1350717578,
 1350618416,
 -1,
 1350783111,
 1350678448,
 -1,
 1350848646,
 1350744211,
 -1,
 -44923,
 1350811047,
 4413,
 -1,
 1350840400,
 4431,
 -1,
 1350790175,
 4412,
 1351155711,
 1350708483,
 -1,
 -44919,
 1351050403,
 4430,
 -1,
 1351114031,
 4436,
 1351352319,
 1350650992,
 4366,
 1351417855,
 1351225062,
 -1,
 -44915,
 1351316133,
 4434,
 -1,
 1351376182,
 4435,
 1351569559,
 1350584472,
 -1,
 1351635092,
 1351530416,
 -1,
 1351700627,
 1351596179,
 -1,
 -44910,
 1351663015,
 4415,
 -1,
 1351692368,
 4433,
 -1,
 1351642143,
 4414,
 1352007679,
 1351560451,
 -1,
 -44906,
 1351902371,
 4432,
 -1,
 1351965999,
 4437,
 1352204287,
 1351509155,
 4364,
 -1,
 1352077379,
 4429,
 1352290475,
 1350545124,
 4357,
 1352400895,
 1352208102,
 -1,
 1352421537,
 1352316848,
 -1,
 1352487072,
 1352382611,
 -1,
 -44898,
 1352452244,
 43367,
 -44897,
 1352508452,
 43370,
 -1,
 1352561371,
 43365,
 -1,
 1352428575,
 43372,
 1352814757,
 1352364278,
 -1,
 -44893,
 1352757137,
 43364,
 -44892,
 1352817980,
 43374,
 -1,
 1352867949,
 43371,
 -44890,
 1352779924,
 43366,
 -44889,
 1353032740,
 43369,
 -44888,
 1353092335,
 4376,
 -44887,
 1353155985,
 43368,
 -44886,
 1353211190,
 4378,
 -1,
 1353265232,
 43373,
 1353470140,
 1352230056,
 4363,
 1353580543,
 1353387750,
 -1,
 1353601201,
 1353490539,
 -1,
 -44881,
 1353540782,
 4420,
 -44880,
 1353604419,
 4427,
 -1,
 1353654113,
 4422,
 1353863348,
 1353565048,
 -1,
 -44877,
 1353803293,
 4418,
 -1,
 1353866570,
 4426,
 1354059959,
 1353788675,
 -1,
 -44874,
 1353999523,
 4424,
 -1,
 1354063151,
 4425,
 -44872,
 1354022311,
 4421,
 -44871,
 1354215140,
 43382,
 -44870,
 1354270097,
 4419,
 -44869,
 1354330843,
 4417,
 -1,
 1354390838,
 43383,
 1354584262,
 1353433976,
 -1,
 1354649797,
 1354524189,
 4355,
 1354760191,
 1354567398,
 -1,
 -44864,
 1354677671,
 43362,
 -44863,
 1354739428,
 4446,
 -44862,
 1354802212,
 43361,
 -44861,
 1354859921,
 43360,
 -44860,
 1354920667,
 4375,
 -1,
 1354969168,
 43363,
 -1,
 1354587466,
 4368,
 1355239633,
 1354526966,
 -1,
 1355305166,
 1355161701,
 -1,
 1355370699,
 1355260011,
 -1,
 -44854,
 1355310254,
 4395,
 -1,
 1355373891,
 4439,
 -44852,
 1355333752,
 4396,
 -44851,
 1355525860,
 4379,
 -1,
 1355580817,
 4381,
 1355763920,
 1355247505,
 4352,
 -1,
 1355682198,
 4442,
 -1,
 1355701564,
 4367,
 1355960537,
 1355189487,
 4354,
 1356070911,
 1355878118,
 -1,
 -44844,
 1355991188,
 4373,
 -44843,
 1356053927,
 4443,
 -44842,
 1356112932,
 4374,
 -44841,
 1356165851,
 4371,
 -44840,
 1356225846,
 4445,
 -1,
 1356279888,
 4444,
 1356484831,
 1355908497,
 4358,
 1356595199,
 1356402406,
 -1,
 -44836,
 1356515476,
 43376,
 -44835,
 1356578215,
 43377,
 -44834,
 1356637220,
 4380,
 -1,
 1356690139,
 43375,
 1356878050,
 1356457357,
 -1,
 -44831,
 1356840095,
 4428,
 -1,
 1356896624,
 4441,
 1357074660,
 1356815670,
 4370,
 -1,
 1356992877,
 43387,
 -1,
 1357008999,
 4447,
 1357271386,
 1346075202,
 -1,
 1357336827,
 1357243584,
 -1,
 1357402350,
 1357267111,
 12630,
 1357467884,
 1357364383,
 12673,
 1357578239,
 1357385446,
 -1,
 -44821,
 1357495719,
 12674,
 -1,
 1357553998,
 12675,
 1357774847,
 1357418994,
 12629,
 -1,
 1357689497,
 12678,
 1357861107,
 1357369070,
 12640,
 1357971455,
 1357778662,
 -1,
 1357992178,
 1357899149,
 12683,
 -1,
 1357943282,
 12682,
 -1,
 1357930983,
 12684,
 1358188792,
 1357812210,
 12635,
 1358299135,
 1358106342,
 -1,
 1358319863,
 1358226684,
 12679,
 -1,
 1358250151,
 12680,
 -1,
 1358258663,
 12681,
 1358516474,
 1358108046,
 12625,
 -1,
 1358446759,
 12626,
 -1,
 1358455271,
 12642,
 1358713100,
 1357297584,
 -1,
 1358778629,
 1358674067,
 -1,
 -44802,
 1358743700,
 12600,
 -44801,
 1358806439,
 12614,
 -44800,
 1358865444,
 12611,
 -44799,
 1358925039,
 12645,
 -44798,
 1358983899,
 12594,
 -44797,
 1359045800,
 12672,
 -44796,
 1359109430,
 12677,
 -1,
 1359163472,
 12617,
 1359413247,
 1358720031,
 12613,
 1359478783,
 1359285990,
 -1,
 -44792,
 1359399060,
 12668,
 -44791,
 1359455268,
 12669,
 -44790,
 1359514863,
 12667,
 -44789,
 1359573723,
 12666,
 -1,
 1359622224,
 12670,
 1359827228,
 1358671588,
 12601,
 1359937535,
 1359744742,
 -1,
 1359958291,
 1359847531,
 -1,
 1360023825,
 1359897774,
 12604,
 -1,
 1359941997,
 12651,
 -44782,
 1359961411,
 12607,
 -1,
 1360076641,
 12652,
 1360285974,
 1359922040,
 -1,
 -44779,
 1360225821,
 12650,
 -1,
 1360289098,
 12606,
 1360482584,
 1360229083,
 12602,
 -1,
 1360400749,
 12649,
 -44775,
 1360455193,
 12653,
 -44774,
 1360575911,
 12605,
 -44773,
 1360627089,
 12603,
 -1,
 1360682294,
 12608,
 1360875818,
 1359781995,
 -1,
 1360941352,
 1360815278,
 12610,
 1361051647,
 1360858854,
 -1,
 1361072419,
 1360969127,
 12612,
 1361182719,
 1360989926,
 -1,
 -44766,
 1361102996,
 12661,
 -1,
 1361146587,
 12660,
 1361334566,
 1361036152,
 -1,
 -44763,
 1361274397,
 12659,
 -1,
 1361337674,
 12663,
 -44761,
 1361277659,
 12658,
 -1,
 1361457232,
 12662,
 -44759,
 1360878915,
 12621,
 -1,
 1361583969,
 12671,
 1361793332,
 1360818422,
 -1,
 1361858865,
 1361715301,
 -1,
 1361924399,
 1361813611,
 -1,
 -44754,
 1361863854,
 12664,
 -1,
 1361927491,
 12676,
 -44752,
 1361887352,
 12665,
 -1,
 1362068881,
 12657,
 1362252083,
 1361801105,
 12593,
 -1,
 1362170221,
 12595,
 -1,
 1362189628,
 12619,
 1362448699,
 1361743087,
 12596,
 1362558975,
 1362366182,
 -1,
 -44745,
 1362479252,
 12646,
 -44744,
 1362541991,
 12647,
 -44743,
 1362600270,
 12648,
 -44742,
 1362648374,
 12598,
 -1,
 1362702416,
 12597,
 1362907457,
 1362419162,
 -1,
 1362972990,
 1362837671,
 12638,
 -1,
 1362924018,
 12637,
 1363104064,
 1362892174,
 12632,
 -1,
 1363034279,
 12633,
 -1,
 1363042791,
 12639,
 1363300679,
 1362855313,
 12609,
 1363410943,
 1363218150,
 -1,
 1363431750,
 1363320939,
 -1,
 -44731,
 1363371182,
 12654,
 -1,
 1363418977,
 12656,
 -1,
 1363393959,
 12655,
 1363693899,
 1363219854,
 12623,
 1363759434,
 1363651203,
 12685,
 -1,
 1363689639,
 12686,
 -1,
 1363689639,
 12624,
 1363956046,
 1363624103,
 12628,
 -44723,
 1363922670,
 12641,
 -1,
 1363972594,
 12627,
 1364152657,
 1363919736,
 -1,
 -44720,
 1364092445,
 12599,
 -1,
 1364155722,
 12620,
 1364349267,
 1364103666,
 12631,
 -1,
 1364279463,
 12634,
 1364480341,
 1364287975,
 12643,
 -1,
 1364413565,
 12615,
 1364611416,
 1364405507,
 -1,
 -44713,
 1364550819,
 12616,
 -1,
 1364614447,
 12618,
 -44711,
 1364578030,
 12636,
 -1,
 1364745526,
 12622,
 -44709,
 1357233486,
 12334,
 -44708,
 1364873319,
 12644,
 -1,
 1364933900,
 12335,
 1365180415,
 1326639306,
 -1,
 1365201254,
 1365099384,
 -1,
 1365266786,
 1365171674,
 -1,
 -44703,
 1365217778,
 12322,
 -1,
 1365264495,
 12345,
 1365463397,
 1365203187,
 -1,
 -44700,
 1365421277,
 12323,
 -1,
 1365470532,
 12346,
 -1,
 1365395217,
 12344,
 1365725545,
 1365161904,
 -1,
 -44696,
 1365667676,
 12326,
 -1,
 1365724335,
 12327,
 1365922156,
 1365659294,
 -1,
 -44693,
 1365875826,
 12324,
 -1,
 1365929701,
 12325,
 -44691,
 1365874210,
 12321,
 -44690,
 1366068511,
 12329,
 -1,
 1366115671,
 12328,
 1366360063,
 1326568327,
 -1,
 1366380932,
 1366260290,
 -1,
 1366446452,
 1366329666,
 -1,
 -44685,
 1366381407,
 5925,
 -1,
 1366431118,
 5928,
 -44683,
 1366418684,
 5932,
 -44682,
 1366613506,
 5935,
 -44681,
 1366675182,
 5922,
 -44680,
 1366737849,
 5926,
 -44679,
 1366800426,
 5936,
 -44678,
 1366862385,
 5933,
 -44677,
 1366925520,
 5929,
 -44676,
 1366982805,
 5931,
 -44675,
 1367045145,
 5934,
 -44674,
 1367109901,
 5923,
 -44673,
 1367171559,
 5921,
 -44672,
 1367234833,
 5937,
 -44671,
 1367298911,
 5924,
 -44670,
 1367357079,
 5927,
 -44669,
 1367418573,
 5930,
 -1,
 1367479694,
 5920,
 1367691655,
 1366351240,
 -1,
 -44666,
 1367658222,
 5939,
 -1,
 1367695847,
 5938,
 -1,
 1367653618,
 5940,
 1367953952,
 1326480050,
 -1,
 1368019409,
 1367896496,
 -1,
 1368084944,
 1367932928,
 -1,
 1368150477,
 1368029762,
 -1,
 1368215965,
 1368111024,
 -1,
 1368281496,
 1368162689,
 -1,
 1368347026,
 1368253632,
 -1,
 -44656,
 1368313582,
 65389,
 -44655,
 1368363506,
 65390,
 -1,
 1368397198,
 65388,
 -44653,
 1368313582,
 65385,
 -44652,
 1368575277,
 65391,
 -44651,
 1368625650,
 65387,
 -44650,
 1368678887,
 65384,
 -44649,
 1368735911,
 65386,
 -1,
 1368790414,
 65383,
 -44647,
 1368248046,
 65405,
 -44646,
 1368953330,
 65407,
 -44645,
 1369006567,
 65404,
 -44644,
 1369063591,
 65406,
 -1,
 1369118094,
 65403,
 1369330083,
 1368164674,
 65437,
 -44641,
 1369296622,
 65415,
 -44640,
 1369346546,
 65417,
 -44639,
 1369399783,
 65414,
 -44638,
 1369456807,
 65416,
 -1,
 1369511310,
 65413,
 1369723305,
 1369293688,
 -1,
 -44635,
 1369689838,
 65410,
 -44634,
 1369739762,
 65412,
 -44633,
 1369792999,
 65409,
 -44632,
 1369850023,
 65411,
 -1,
 1369904526,
 65408,
 1370116527,
 1369680342,
 -1,
 -44629,
 1370083054,
 65433,
 -44628,
 1370132978,
 65435,
 -44627,
 1370186215,
 65432,
 -44626,
 1370243239,
 65434,
 -1,
 1370297742,
 65431,
 1370509749,
 1370062920,
 -1,
 -44623,
 1370476270,
 65425,
 -44622,
 1370526194,
 65427,
 -44621,
 1370579431,
 65424,
 -44620,
 1370636455,
 65426,
 -1,
 1370690958,
 65423,
 1370902971,
 1370452214,
 -1,
 -44617,
 1370869486,
 65400,
 -44616,
 1370919410,
 65402,
 -44615,
 1370972647,
 65399,
 -44614,
 1371029671,
 65401,
 -1,
 1371084174,
 65398,
 1371296193,
 1370839283,
 -1,
 -44611,
 1371262702,
 65420,
 -44610,
 1371312626,
 65422,
 -44609,
 1371365863,
 65419,
 -44608,
 1371422887,
 65421,
 -1,
 1371477390,
 65418,
 1371689413,
 1371268288,
 -1,
 -44605,
 1371655918,
 65429,
 -44604,
 1371705842,
 65430,
 -1,
 1371739534,
 65428,
 1371951560,
 1371659738,
 -1,
 -44601,
 1371902450,
 65382,
 -1,
 1371936142,
 65436,
 -44599,
 1371918062,
 65395,
 -44598,
 1372099058,
 65397,
 -44597,
 1372152295,
 65394,
 -44596,
 1372209319,
 65396,
 -1,
 1372263822,
 65393,
 -44594,
 1368120617,
 65438,
 -44593,
 1372436889,
 65439,
 -1,
 1372489027,
 65381,
 -1,
 1368002593,
 65392,
 1372738066,
 1367956154,
 -1,
 1372803601,
 1372682818,
 -1,
 1372869085,
 1372761828,
 65449,
 1372979199,
 1372786406,
 -1,
 1373000152,
 1372889195,
 -1,
 -44585,
 1372939438,
 65452,
 -1,
 1373003075,
 65455,
 -44583,
 1372964690,
 65454,
 -44582,
 1373158823,
 65453,
 -44581,
 1373210001,
 65451,
 -44580,
 1373270747,
 65450,
 -1,
 1373330742,
 65456,
 1373524453,
 1372841152,
 -1,
 1373589984,
 1373454503,
 65483,
 -1,
 1373540850,
 65482,
 1373721058,
 1373509006,
 65476,
 -1,
 1373651111,
 65477,
 -44573,
 1373687534,
 65495,
 -44572,
 1373802994,
 65490,
 -1,
 1373856231,
 65499,
 1374048749,
 1373484976,
 -1,
 1374114284,
 1374009491,
 -1,
 -44568,
 1374079124,
 65448,
 -44567,
 1374141863,
 65462,
 -44566,
 1374200868,
 65459,
 -44565,
 1374253787,
 65442,
 -1,
 1374302288,
 65465,
 -1,
 1374055455,
 65461,
 1374573043,
 1374019034,
 -1,
 1374638576,
 1374503079,
 65493,
 -1,
 1374589426,
 65492,
 1374769650,
 1374557582,
 65485,
 -1,
 1374699687,
 65486,
 -1,
 1374708199,
 65494,
 1374966263,
 1374527595,
 -1,
 1375031798,
 1374905518,
 65458,
 -1,
 1374949741,
 65460,
 -1,
 1374969155,
 65469,
 1375228411,
 1374915823,
 65444,
 1375338495,
 1375145702,
 -1,
 -44550,
 1375231286,
 65446,
 -1,
 1375285328,
 65445,
 1375490559,
 1375170806,
 -1,
 1375556094,
 1375432593,
 65441,
 -1,
 1375474029,
 65443,
 -1,
 1375493436,
 65467,
 1375752706,
 1375420583,
 65479,
 -44543,
 1375719150,
 65498,
 -1,
 1375769074,
 65478,
 1375949317,
 1375716216,
 -1,
 -44540,
 1375888925,
 65447,
 -1,
 1375952202,
 65468,
 1376145927,
 1375900146,
 65484,
 -1,
 1376075943,
 65487,
 1376277001,
 1376084455,
 65500,
 -1,
 1376210045,
 65463,
 1376408076,
 1376201987,
 -1,
 -44533,
 1376347299,
 65464,
 -1,
 1376410927,
 65466,
 1376604686,
 1376327054,
 65474,
 -1,
 1376534695,
 65475,
 -44529,
 1376571118,
 65491,
 -44528,
 1376683409,
 65457,
 -1,
 1376738614,
 65470,
 -1,
 1372737639,
 65440,
 1376997909,
 1372696302,
 -1,
 -44524,
 1376968243,
 65515,
 -1,
 1376977603,
 65379,
 1377194520,
 1376941809,
 -1,
 -44521,
 1377164851,
 65513,
 -1,
 1377174211,
 65378,
 1377391131,
 1377133610,
 -1,
 -44518,
 1377325834,
 65377,
 -1,
 1377382972,
 65380,
 -44516,
 1377361812,
 65518,
 -44515,
 1377555954,
 65514,
 -44514,
 1377587715,
 65512,
 -44513,
 1377648505,
 65516,
 -1,
 1377708652,
 65517,
 1377915427,
 1367901804,
 -1,
 -44510,
 1377877138,
 9773,
 -1,
 1377936405,
 9874,
 -1,
 1377856609,
 8202,
 1378177930,
 1326399655,
 -1,
 1378243288,
 1378102280,
 -1,
 1378308742,
 1378186180,
 -1,
 1378374270,
 1378241632,
 -1,
 1378439729,
 1378344953,
 -1,
 -44502,
 1378403586,
 64296,
 -44501,
 1378463130,
 64295,
 -44500,
 1378514257,
 64293,
 -44499,
 1378578738,
 64292,
 -44498,
 1378638736,
 64291,
 -44497,
 1378701466,
 64294,
 -44496,
 1378760419,
 64290,
 -1,
 1378818774,
 64289,
 1379029565,
 1378400176,
 -1,
 1379095099,
 1378967019,
 1513,
 1379205119,
 1379011638,
 -1,
 1379226168,
 1379088055,
 64329,
 1379336191,
 1379139928,
 -1,
 -44489,
 1379231690,
 64301,
 -1,
 1379294703,
 64300,
 1379532799,
 1379186608,
 -1,
 -44486,
 1379428298,
 64299,
 -1,
 1379491311,
 64298,
 1379729407,
 1379015935,
 1505,
 -1,
 1379601617,
 64321,
 1379816005,
 1378963578,
 -1,
 1379881536,
 1379770927,
 1507,
 -1,
 1379798225,
 64323,
 1380012610,
 1379823922,
 1498,
 -1,
 1379929297,
 64314,
 -44477,
 1379978410,
 1509,
 -44476,
 1380094218,
 1503,
 -1,
 1380156490,
 1501,
 1380340304,
 1379734926,
 -1,
 1380405839,
 1380283332,
 -1,
 1380471372,
 1380336546,
 1488,
 1380581375,
 1380387894,
 -1,
 -44470,
 1380493318,
 64303,
 -44469,
 1380557311,
 64302,
 -1,
 1380614812,
 64304,
 1380843519,
 1380435522,
 -1,
 -44466,
 1380754699,
 64297,
 -1,
 1380787858,
 64288,
 -1,
 1380378282,
 1506,
 1381061207,
 1380303736,
 -1,
 1381126739,
 1381021784,
 1510,
 -1,
 1381043409,
 64326,
 1381257813,
 1381059434,
 1496,
 -1,
 1381174481,
 64312,
 1381433343,
 1381180922,
 1514,
 -1,
 1381305553,
 64330,
 1381519963,
 1381033735,
 1497,
 1381629951,
 1381436470,
 -1,
 -44454,
 1381522958,
 64285,
 -1,
 1381578423,
 64313,
 1381782111,
 1381489054,
 1493,
 1381892095,
 1381698614,
 -1,
 -44450,
 1381785317,
 64331,
 -1,
 1381840567,
 64309,
 1382044259,
 1381737007,
 1508,
 1382154239,
 1381960758,
 -1,
 -44446,
 1382066824,
 64334,
 -1,
 1382102711,
 64324,
 1382306407,
 1381986610,
 1499,
 1382416383,
 1382222902,
 -1,
 -44442,
 1382328968,
 64333,
 -1,
 1382364855,
 64315,
 1382568554,
 1382243216,
 1492,
 -44439,
 1382531960,
 1495,
 -1,
 1382551019,
 64308,
 1382765166,
 1382492472,
 1489,
 1382875135,
 1382681654,
 -1,
 -44435,
 1382787720,
 64332,
 -1,
 1382823607,
 64305,
 1383027312,
 1382737988,
 1494,
 -1,
 1382943953,
 64310,
 1383158386,
 1382985114,
 1512,
 -1,
 1383075025,
 64328,
 1383289460,
 1383114801,
 1511,
 -1,
 1383206097,
 64327,
 1383420534,
 1383239946,
 1504,
 -1,
 1383337169,
 64320,
 1383551608,
 1383367754,
 1502,
 -1,
 1383468241,
 64318,
 1383682682,
 1383494993,
 1500,
 -1,
 1383599313,
 64316,
 1383813756,
 1383618037,
 1490,
 -1,
 1383730385,
 64306,
 1383989247,
 1383741155,
 1491,
 -1,
 1383861457,
 64307,
 1384120319,
 1378313479,
 -1,
 1384141445,
 1384048197,
 -1,
 1384206979,
 1384070255,
 -1,
 -44414,
 1384179463,
 1522,
 -1,
 1384241566,
 1520,
 -44412,
 1384179467,
 64287,
 -1,
 1384372642,
 1521,
 -1,
 1384061665,
 64335,
 1384600242,
 1378228059,
 -1,
 1384665742,
 1384572920,
 -1,
 1384731277,
 1384584590,
 -1,
 1384796812,
 1384687644,
 -1,
 -44405,
 1384753174,
 1428,
 -1,
 1384797077,
 1429,
 -1,
 1384756722,
 1432,
 -1,
 1384671719,
 1454,
 1385124501,
 1384629112,
 -1,
 1385190036,
 1385054375,
 -1,
 1385255571,
 1385135129,
 -1,
 -44398,
 1385211937,
 1449,
 -1,
 1385256101,
 1440,
 -1,
 1385225361,
 1435,
 -1,
 1385131063,
 1430,
 1385583258,
 1385070664,
 -1,
 1385648792,
 1385515539,
 1445,
 -1,
 1385563423,
 1446,
 -44391,
 1385616007,
 1443,
 -1,
 1385699638,
 1444,
 1385910942,
 1385518291,
 -1,
 1385976477,
 1385843363,
 1436,
 -1,
 1385891318,
 1437,
 -1,
 1385937761,
 1438,
 1386173089,
 1385883021,
 -1,
 -44384,
 1386138024,
 1434,
 -1,
 1386195616,
 1450,
 1386369700,
 1386133424,
 -1,
 -44381,
 1386306118,
 1427,
 -1,
 1386366179,
 1426,
 1386566311,
 1386325964,
 -1,
 -44378,
 1386525776,
 1439,
 -1,
 1386560204,
 1448,
 1386762922,
 1386520784,
 -1,
 -44375,
 1386735723,
 1441,
 -1,
 1386789982,
 1433,
 1386959533,
 1386690092,
 -1,
 -44372,
 1386890557,
 1453,
 -1,
 1386947000,
 1447,
 -44370,
 1386917442,
 1431,
 -44369,
 1387107522,
 1451,
 -44368,
 1387161282,
 1452,
 -44367,
 1387219993,
 1425,
 -1,
 1387275643,
 1442,
 1387483860,
 1384554603,
 -1,
 1387549388,
 1387435034,
 -1,
 1387614908,
 1387485427,
 -1,
 1387680441,
 1387537576,
 -1,
 -44361,
 1387641230,
 1457,
 -44360,
 1387702278,
 1459,
 -1,
 1387766271,
 1458,
 1387942587,
 1387631736,
 1465,
 -1,
 1387856977,
 1466,
 -1,
 1387883788,
 1460,
 1388139202,
 1387575216,
 -1,
 1388204736,
 1388075251,
 -1,
 -44353,
 1388144586,
 1473,
 -1,
 1388203164,
 1456,
 -44351,
 1388144586,
 1474,
 -1,
 1388332259,
 1462,
 1388532422,
 1388095430,
 -1,
 1388597957,
 1388453056,
 1464,
 -1,
 1388513703,
 1479,
 -1,
 1388564626,
 1467,
 -44345,
 1388498096,
 1461,
 -44344,
 1388751496,
 1471,
 -44343,
 1388814847,
 1463,
 -44342,
 1388872896,
 1469,
 -44341,
 1388933317,
 64286,
 -1,
 1388983998,
 1468,
 1389232127,
 1387516603,
 -1,
 1389253328,
 1389122771,
 -1,
 -44337,
 1389214561,
 1524,
 -1,
 1389251235,
 1523,
 -44335,
 1389215513,
 1475,
 -44334,
 1389404665,
 1472,
 -44333,
 1389465870,
 1478,
 -1,
 1389527714,
 1470,
 1389756415,
 1387430594,
 -1,
 -44330,
 1389679889,
 1476,
 -44329,
 1389724413,
 1455,
 -1,
 1389788896,
 1477,
 1389974327,
 1378214911,
 -1,
 1390039790,
 1389937528,
 -1,
 1390105325,
 1389976467,
 -1,
 1390170847,
 1390030083,
 -1,
 -44323,
 1390128170,
 19904,
 -44322,
 1390181320,
 19933,
 -1,
 1390224861,
 19953,
 1390432996,
 1390089614,
 -1,
 1390498531,
 1390389718,
 -1,
 -44318,
 1390451999,
 19954,
 -1,
 1390512414,
 19910,
 -1,
 1390423261,
 19932,
 1390760679,
 1390403034,
 -1,
 -44314,
 1390691856,
 19951,
 -1,
 1390747242,
 19959,
 -44312,
 1390718018,
 19905,
 -44311,
 1390904035,
 19957,
 -44310,
 1390965294,
 19955,
 -44309,
 1391030457,
 19961,
 -44308,
 1391088839,
 19960,
 -1,
 1391152978,
 19940,
 -1,
 1390062601,
 19913,
 1391416056,
 1389966892,
 -1,
 1391481587,
 1391345831,
 -1,
 -44303,
 1391450679,
 19956,
 -44302,
 1391492176,
 19943,
 -1,
 1391539171,
 19944,
 1391743734,
 1391419879,
 -1,
 -44299,
 1391706038,
 19962,
 -1,
 1391743010,
 19906,
 -44297,
 1391711849,
 19935,
 -1,
 1391862292,
 19939,
 1392071427,
 1391350571,
 -1,
 1392136962,
 1392028118,
 -1,
 1392202497,
 1392066982,
 -1,
 1392268032,
 1392156779,
 -1,
 1392333567,
 1392218610,
 -1,
 -44290,
 1392303934,
 19937,
 -1,
 1392361619,
 19917,
 -1,
 1392291183,
 19931,
 -1,
 1392231581,
 19929,
 -1,
 1392121699,
 19925,
 -1,
 1392059685,
 19948,
 1392792329,
 1392031664,
 -1,
 1392857863,
 1392738689,
 -1,
 -44282,
 1392821405,
 19912,
 -1,
 1392879306,
 19965,
 -44280,
 1392821434,
 19915,
 -1,
 1393009843,
 19926,
 1393185551,
 1392732056,
 -1,
 1393251085,
 1393133890,
 -1,
 -44276,
 1393201866,
 19928,
 -1,
 1393248676,
 19964,
 -44274,
 1393185198,
 19934,
 -1,
 1393374179,
 19945,
 1393578772,
 1393142790,
 -1,
 1393644307,
 1393542008,
 -1,
 -44270,
 1393612452,
 19927,
 -1,
 1393667101,
 19936,
 -1,
 1393614139,
 19952,
 1393906456,
 1393533035,
 -1,
 -44266,
 1393874779,
 19949,
 -44265,
 1393931415,
 19938,
 -1,
 1393967405,
 19914,
 1394168605,
 1393857010,
 -1,
 1394234140,
 1394124288,
 -1,
 -44261,
 1394191783,
 19950,
 -1,
 1394252428,
 19941,
 -1,
 1394158677,
 19942,
 1394496290,
 1394094604,
 -1,
 1394561825,
 1394444610,
 -1,
 -44256,
 1394525631,
 19923,
 -1,
 1394561419,
 19909,
 -1,
 1394509281,
 19947,
 1394823974,
 1394419355,
 -1,
 -44252,
 1394781201,
 19946,
 -44251,
 1394830972,
 19924,
 -1,
 1394885545,
 19967,
 1395086122,
 1394742670,
 -1,
 -44248,
 1395041845,
 19922,
 -44247,
 1395086016,
 19966,
 -1,
 1395141751,
 19958,
 1395348269,
 1395056090,
 -1,
 -44244,
 1395300781,
 19921,
 -1,
 1395333579,
 19908,
 1395544880,
 1395295895,
 -1,
 -44241,
 1395513333,
 19930,
 -1,
 1395537972,
 19918,
 1395741491,
 1395478174,
 -1,
 -44238,
 1395692795,
 19920,
 -1,
 1395738149,
 19916,
 -44236,
 1395713830,
 19907,
 -44235,
 1395882815,
 19963,
 -44234,
 1395941105,
 19911,
 -1,
 1396000823,
 19919,
 1396200326,
 1389893006,
 -1,
 1396265861,
 1396170192,
 -1,
 1396331331,
 1396190467,
 -1,
 1396396863,
 1396272266,
 11096,
 1396462398,
 1396313142,
 -1,
 -44227,
 1396425132,
 9955,
 -1,
 1396453488,
 11095,
 -1,
 1396389478,
 11097,
 1396724546,
 1396333456,
 -1,
 -44223,
 1396694458,
 10054,
 -1,
 1396715847,
 10004,
 -1,
 1396676066,
 10152,
 1396986703,
 1396254363,
 -1,
 1397052238,
 1396929660,
 -1,
 1397117769,
 1396969356,
 -1,
 -44217,
 1397079929,
 10167,
 -44216,
 1397141804,
 10168,
 -1,
 1397198471,
 10169,
 1397424127,
 1397030912,
 -1,
 1397445453,
 1397306853,
 -1,
 -44212,
 1397413333,
 10150,
 -1,
 1397440346,
 10149,
 -1,
 1397382076,
 10084,
 -1,
 1396972597,
 10008,
 1397773142,
 1396949880,
 -1,
 1397838677,
 1397703023,
 -1,
 1397904212,
 1397794232,
 -1,
 -44205,
 1397859388,
 10051,
 -1,
 1397892137,
 10045,
 -1,
 1397840578,
 10171,
 -1,
 1397796508,
 10142,
 1398231900,
 1397733296,
 -1,
 1398297434,
 1398171999,
 -1,
 -44199,
 1398263184,
 10075,
 -1,
 1398288974,
 10076,
 -44197,
 1398251992,
 10056,
 -1,
 1398447434,
 10136,
 1398625123,
 1398188502,
 -1,
 1398690658,
 1398564171,
 -1,
 1398756193,
 1398608094,
 -1,
 -44192,
 1398712756,
 10095,
 -1,
 1398746021,
 10097,
 -1,
 1398726195,
 10137,
 -1,
 1398643746,
 10140,
 1399083881,
 1398567876,
 -1,
 1399149415,
 1399014446,
 -1,
 -44186,
 1399105972,
 10094,
 -1,
 1399139237,
 10096,
 -44184,
 1399103482,
 10157,
 -1,
 1399267779,
 11093,
 1399477104,
 1399013543,
 -1,
 1399542637,
 1399448616,
 -1,
 -44180,
 1399505657,
 10071,
 -1,
 1399560677,
 10082,
 1399783423,
 1399481680,
 -1,
 -44177,
 1399702863,
 10059,
 -1,
 1399760200,
 10040,
 1399935860,
 1399447002,
 -1,
 -44174,
 1399874540,
 10132,
 -44173,
 1399938644,
 9947,
 -1,
 1399997188,
 10173,
 1400198008,
 1399886322,
 -1,
 -44170,
 1400166546,
 11094,
 -44169,
 1400231967,
 10030,
 -1,
 1400283785,
 10012,
 1400460157,
 1400124972,
 -1,
 1400525692,
 1400413110,
 -1,
 -44165,
 1400491408,
 10077,
 -1,
 1400517198,
 10078,
 -1,
 1400447926,
 10144,
 -44162,
 1400429338,
 10074,
 -44161,
 1400755528,
 10158,
 -44160,
 1400802951,
 10138,
 -44159,
 1400866950,
 10006,
 -44158,
 1400921026,
 10083,
 -44157,
 1400985621,
 10010,
 -44156,
 1401049629,
 10020,
 -1,
 1401103401,
 10033,
 -1,
 1396195401,
 9980,
 1401377673,
 1396145418,
 -1,
 -44152,
 1401310065,
 9937,
 -1,
 1401359015,
 9096,
 -1,
 1401336841,
 8889,
 1401639928,
 1378116071,
 -1,
 1401705462,
 1401596557,
 -1,
 1401770995,
 1401649730,
 -1,
 1401836450,
 1401730992,
 -1,
 1401901981,
 1401782657,
 -1,
 1401967507,
 1401873600,
 -1,
 -44143,
 1401933550,
 12421,
 -44142,
 1401983474,
 12423,
 -1,
 1402017166,
 12419,
 1402229654,
 1401909494,
 -1,
 -44139,
 1402159271,
 12438,
 -1,
 1402213774,
 12437,
 -44137,
 1402199554,
 12430,
 -44136,
 1402392302,
 12357,
 -44135,
 1402457389,
 12387,
 -44134,
 1402507762,
 12361,
 -44133,
 1402560999,
 12355,
 -44132,
 1402618023,
 12359,
 -1,
 1402672526,
 12353,
 -44130,
 1401868014,
 12377,
 -44129,
 1402835442,
 12381,
 -44128,
 1402888679,
 12375,
 -44127,
 1402945703,
 12379,
 -1,
 1403000206,
 12373,
 1403212712,
 1401784642,
 12435,
 -44124,
 1403178734,
 12396,
 -44123,
 1403228658,
 12398,
 -44122,
 1403281895,
 12395,
 -44121,
 1403338919,
 12397,
 -1,
 1403393422,
 12394,
 1403605934,
 1403185144,
 -1,
 -44118,
 1403571950,
 12378,
 -44117,
 1403621874,
 12382,
 -44116,
 1403675111,
 12376,
 -44115,
 1403732135,
 12380,
 -1,
 1403786638,
 12374,
 1403999156,
 1403569016,
 -1,
 -44112,
 1403965166,
 12388,
 -44111,
 1404015090,
 12392,
 -44110,
 1404068327,
 12385,
 -44109,
 1404125351,
 12390,
 -1,
 1404179854,
 12383,
 1404392378,
 1403955670,
 -1,
 -44106,
 1404358382,
 12427,
 -44105,
 1404408306,
 12429,
 -44104,
 1404461543,
 12426,
 -44103,
 1404518567,
 12428,
 -1,
 1404573070,
 12425,
 1404785600,
 1404346475,
 -1,
 -44100,
 1404751598,
 12407,
 -44099,
 1404801522,
 12413,
 -44098,
 1404854759,
 12404,
 -44097,
 1404911783,
 12410,
 -1,
 1404966286,
 12401,
 1405178822,
 1404731464,
 -1,
 -44094,
 1405144814,
 12416,
 -44093,
 1405194738,
 12418,
 -44092,
 1405247975,
 12415,
 -44091,
 1405304999,
 12417,
 -1,
 1405359502,
 12414,
 1405572044,
 1405120758,
 -1,
 -44088,
 1405538030,
 12367,
 -44087,
 1405587954,
 12371,
 -44086,
 1405641191,
 12365,
 -44085,
 1405698215,
 12369,
 -1,
 1405752718,
 12363,
 1405965266,
 1405507827,
 -1,
 -44082,
 1405931246,
 12405,
 -44081,
 1405981170,
 12411,
 -44080,
 1406034407,
 12402,
 -44079,
 1406091431,
 12408,
 -1,
 1406145934,
 12399,
 1406358488,
 1405899563,
 -1,
 -44076,
 1406324462,
 12368,
 -44075,
 1406374386,
 12372,
 -44074,
 1406427623,
 12366,
 -44073,
 1406484647,
 12370,
 -1,
 1406539150,
 12364,
 1406751710,
 1406285356,
 -1,
 -44070,
 1406717678,
 12389,
 -44069,
 1406767602,
 12393,
 -44068,
 1406820839,
 12386,
 -44067,
 1406877863,
 12391,
 -1,
 1406932366,
 12384,
 1407144932,
 1406674587,
 -1,
 -44064,
 1407110894,
 12406,
 -44063,
 1407160818,
 12412,
 -44062,
 1407214055,
 12403,
 -44061,
 1407271079,
 12409,
 -1,
 1407325582,
 12400,
 1407538153,
 1407114714,
 -1,
 -44058,
 1407488498,
 12434,
 -44057,
 1407541735,
 12432,
 -44056,
 1407598759,
 12433,
 -1,
 1407653262,
 12431,
 1407865837,
 1407509696,
 -1,
 -44053,
 1407831790,
 12422,
 -44052,
 1407881714,
 12424,
 -1,
 1407915406,
 12420,
 -44050,
 1407835593,
 12436,
 -44049,
 1408093934,
 12358,
 -44048,
 1408143858,
 12362,
 -44047,
 1408197095,
 12356,
 -44046,
 1408254119,
 12360,
 -1,
 1408308622,
 12354,
 -44044,
 1401740538,
 12446,
 -44043,
 1408462387,
 12445,
 -1,
 1408514529,
 12447,
 -44041,
 1401667935,
 9964,
 -1,
 1408652553,
 9889,
 1408848908,
 1401590258,
 -1,
 1408914437,
 1408807859,
 -1,
 1408979967,
 1408874738,
 -1,
 -44036,
 1408898395,
 9149,
 -44035,
 1408963808,
 9148,
 -44034,
 1409028966,
 9147,
 -1,
 1409094185,
 9146,
 1409307650,
 1408902811,
 -1,
 -44031,
 1409250452,
 11043,
 -1,
 1409294465,
 8213,
 -44029,
 1409253734,
 9897,
 -44028,
 1409448811,
 9135,
 -1,
 1409500700,
 8230,
 1409700872,
 1408880366,
 -1,
 -44025,
 1409661225,
 8962,
 -1,
 1409724002,
 8987,
 1409897483,
 1409663866,
 -1,
 -44022,
 1409859564,
 9832,
 -1,
 1409886553,
 9749,
 -1,
 1409845150,
 8763,
 1410159638,
 1408820416,
 -1,
 1410225173,
 1410113643,
 -1,
 1410290708,
 1410161806,
 8208,
 1410356242,
 1410203648,
 -1,
 -44015,
 1410326655,
 11802,
 -1,
 1410346084,
 8259,
 -44013,
 1410278761,
 8231,
 -1,
 1410470028,
 45,
 -1,
 1410241305,
 11794,
 -1,
 1410187512,
 9102,
 -1,
 1410119588,
 8372,
 1410881798,
 1326338859,
 -1,
 1410946774,
 1410836950,
 -1,
 1411012309,
 1410875559,
 -1,
 1411077803,
 1410942400,
 -1,
 1411142907,
 1411037104,
 -1,
 1411208437,
 1411088769,
 -1,
 1411273969,
 1411152450,
 -1,
 1411339337,
 1411224873,
 -1,
 1411404860,
 1411269824,
 969,
 1411514367,
 1411320886,
 -1,
 1411535917,
 1411424363,
 -1,
 1411601451,
 1411497239,
 8032,
 1411710975,
 1411514490,
 -1,
 1411732518,
 1411635405,
 8034,
 -1,
 1411645899,
 8098,
 1411863592,
 1411687247,
 8038,
 -1,
 1411776971,
 8102,
 1411994666,
 1411817560,
 8036,
 -1,
 1411908043,
 8100,
 -1,
 1411966792,
 8096,
 1412235263,
 1411533320,
 8182,
 -1,
 1412104651,
 8183,
 1412322358,
 1411462949,
 8033,
 1412431871,
 1412235386,
 -1,
 1412453425,
 1412356301,
 8035,
 -1,
 1412366795,
 8099,
 1412584499,
 1412408143,
 8039,
 -1,
 1412497867,
 8103,
 1412715573,
 1412538456,
 8037,
 -1,
 1412628939,
 8101,
 -1,
 1412687688,
 8097,
 1412912184,
 1412290765,
 8060,
 -1,
 1412825547,
 8178,
 1413043258,
 1412866136,
 8061,
 -1,
 1412956619,
 8180,
 -43973,
 1413015368,
 8179,
 -1,
 1413139097,
 974,
 1413349375,
 1411343219,
 959,
 1413414911,
 1413221430,
 -1,
 1413436482,
 1413326669,
 8000,
 1413545983,
 1413349498,
 -1,
 -43967,
 1413470413,
 8002,
 -1,
 1413521496,
 8004,
 1413698630,
 1413363493,
 8001,
 1413808127,
 1413611642,
 -1,
 -43963,
 1413732557,
 8003,
 -1,
 1413783640,
 8005,
 -43961,
 1413667021,
 8056,
 -43960,
 1413925529,
 972,
 -1,
 1413980248,
 8057,
 1414157428,
 1411268775,
 -1,
 1414222951,
 1414120377,
 951,
 1414332415,
 1414138934,
 -1,
 1414354008,
 1414242411,
 -1,
 1414419542,
 1414315287,
 7968,
 1414529023,
 1414332538,
 -1,
 1414550609,
 1414453453,
 7970,
 -1,
 1414463947,
 8082,
 1414681683,
 1414505295,
 7974,
 -1,
 1414595019,
 8086,
 1414812757,
 1414635608,
 7972,
 -1,
 1414726091,
 8084,
 -1,
 1414784840,
 8080,
 1415053311,
 1414351368,
 8134,
 -1,
 1414922699,
 8135,
 1415140449,
 1414280997,
 7969,
 1415249919,
 1415053434,
 -1,
 1415271516,
 1415174349,
 7971,
 -1,
 1415184843,
 8083,
 1415402590,
 1415226191,
 7975,
 -1,
 1415315915,
 8087,
 1415533664,
 1415356504,
 7973,
 -1,
 1415446987,
 8085,
 -1,
 1415505736,
 8081,
 1415730275,
 1415108813,
 8052,
 -1,
 1415643595,
 8130,
 1415861349,
 1415684184,
 8053,
 -1,
 1415774667,
 8132,
 -43930,
 1415833416,
 8131,
 -1,
 1415957145,
 942,
 1416167423,
 1414178643,
 949,
 1416232959,
 1416039478,
 -1,
 1416254573,
 1416144717,
 7952,
 1416364031,
 1416167546,
 -1,
 -43924,
 1416288461,
 7954,
 -1,
 1416339544,
 7956,
 1416516721,
 1416181541,
 7953,
 1416626175,
 1416429690,
 -1,
 -43920,
 1416550605,
 7955,
 -1,
 1416601688,
 7957,
 -43918,
 1416485069,
 8050,
 -43917,
 1416743577,
 941,
 -1,
 1416798296,
 8051,
 1416975512,
 1414075790,
 -1,
 1417041045,
 1416920899,
 945,
 1417150463,
 1416956982,
 -1,
 1417172099,
 1417060459,
 -1,
 1417237633,
 1417133335,
 7936,
 1417347071,
 1417150586,
 -1,
 1417368700,
 1417271501,
 7938,
 -1,
 1417281995,
 8066,
 1417499774,
 1417323343,
 7942,
 -1,
 1417413067,
 8070,
 1417630848,
 1417453656,
 7940,
 -1,
 1417544139,
 8068,
 -1,
 1417602888,
 8064,
 1417871359,
 1417169416,
 8118,
 -1,
 1417740747,
 8119,
 1417958540,
 1417099045,
 7937,
 1418067967,
 1417871482,
 -1,
 1418089607,
 1417992397,
 7939,
 -1,
 1418002891,
 8067,
 1418220681,
 1418044239,
 7943,
 -1,
 1418133963,
 8071,
 1418351755,
 1418174552,
 7941,
 -1,
 1418265035,
 8069,
 -1,
 1418323784,
 8065,
 1418548368,
 1417926758,
 -1,
 1418613903,
 1418469870,
 8048,
 -1,
 1418527179,
 8114,
 -1,
 1418570324,
 8112,
 1418810514,
 1418502232,
 8049,
 -1,
 1418723787,
 8116,
 -43885,
 1418782536,
 8115,
 -43884,
 1418906265,
 940,
 -1,
 1418952862,
 8113,
 1419182079,
 1416997799,
 -1,
 -43881,
 1419098239,
 883,
 -1,
 1419146008,
 985,
 1419334835,
 1416942989,
 965,
 1419444223,
 1419250742,
 -1,
 1419465894,
 1419327020,
 -1,
 1419531425,
 1419403936,
 971,
 1419640831,
 1419444346,
 -1,
 -43874,
 1419565261,
 8162,
 -43873,
 1419627161,
 944,
 -43872,
 1419682639,
 8167,
 -1,
 1419747416,
 8163,
 1419968511,
 1419453412,
 8017,
 1420034047,
 1419837562,
 -1,
 -43868,
 1419958477,
 8019,
 -43867,
 1420010319,
 8023,
 -1,
 1420075096,
 8021,
 1420252333,
 1419419755,
 -1,
 1420317868,
 1420213527,
 8016,
 1420427263,
 1420230778,
 -1,
 -43862,
 1420351693,
 8018,
 -43861,
 1420403535,
 8022,
 -1,
 1420468312,
 8020,
 -1,
 1420249608,
 8166,
 1420711088,
 1420220518,
 -1,
 -43857,
 1420667476,
 8160,
 -1,
 1420698094,
 8058,
 -43855,
 1420675737,
 973,
 -43854,
 1420861528,
 8059,
 -1,
 1420918942,
 8161,
 1421104334,
 1419275299,
 953,
 1421213695,
 1421020214,
 -1,
 1421235393,
 1421096492,
 -1,
 1421300924,
 1421173408,
 970,
 1421410303,
 1421213818,
 -1,
 -43847,
 1421334733,
 8146,
 -43846,
 1421396633,
 912,
 -43845,
 1421452111,
 8151,
 -1,
 1421516888,
 8147,
 1421737983,
 1421222884,
 7985,
 1421803519,
 1421607034,
 -1,
 -43841,
 1421727949,
 7987,
 -43840,
 1421779791,
 7991,
 -1,
 1421844568,
 7989,
 1422021832,
 1421189227,
 -1,
 1422087367,
 1421982999,
 7984,
 1422196735,
 1422000250,
 -1,
 -43835,
 1422121165,
 7986,
 -43834,
 1422173007,
 7990,
 -1,
 1422237784,
 7988,
 -1,
 1422019080,
 8150,
 1422480587,
 1421989990,
 -1,
 -43830,
 1422436948,
 8144,
 -1,
 1422467566,
 8054,
 -43828,
 1422445209,
 943,
 -43827,
 1422631000,
 8055,
 -1,
 1422688414,
 8145,
 1422873813,
 1421064112,
 -1,
 1422939346,
 1422792078,
 -1,
 -43823,
 1422887234,
 1019,
 -1,
 1422952426,
 993,
 -43821,
 1422903431,
 987,
 -43820,
 1423074792,
 963,
 -1,
 1423138503,
 1016,
 1423332570,
 1422827627,
 -1,
 -43817,
 1423293549,
 968,
 -43816,
 1423335911,
 960,
 -43815,
 1423400177,
 966,
 -1,
 1423449411,
 887,
 1423660254,
 1423289975,
 961,
 1423769599,
 1423576118,
 -1,
 -43811,
 1423681357,
 8164,
 -1,
 1423718181,
 8165,
 1423922401,
 1423623032,
 -1,
 -43808,
 1423858886,
 952,
 -1,
 1423910324,
 964,
 1424119012,
 1423864054,
 -1,
 -43805,
 1424070671,
 991,
 -1,
 1424105546,
 954,
 1424315623,
 1424045612,
 -1,
 -43802,
 1424254208,
 989,
 -1,
 1424311880,
 948,
 -43800,
 1424287910,
 950,
 -43799,
 1424483422,
 958,
 -43798,
 1424527482,
 957,
 -43797,
 1424590868,
 956,
 -43796,
 1424651595,
 955,
 -43795,
 1424710854,
 881,
 -43794,
 1424774085,
 947,
 -43793,
 1424838844,
 962,
 -43792,
 1424895950,
 967,
 -1,
 1424959804,
 946,
 1425167604,
 1411231218,
 -1,
 -43789,
 1425113012,
 891,
 -1,
 1425161259,
 893,
 -1,
 1425095723,
 892,
 1425473535,
 1411174466,
 -1,
 -43785,
 1425387127,
 7528,
 -43784,
 1425449953,
 7529,
 -43783,
 1425494981,
 7527,
 -43782,
 1425551310,
 7530,
 -1,
 1425615164,
 7526,
 1425823155,
 1411067394,
 -1,
 1425888685,
 1425765316,
 -1,
 1425954220,
 1425820768,
 -1,
 1426019623,
 1425904937,
 -1,
 1426085146,
 1425949888,
 937,
 1426194431,
 1426000950,
 -1,
 1426216205,
 1426104427,
 -1,
 1426281740,
 1426177303,
 8040,
 1426391039,
 1426194554,
 -1,
 1426412808,
 1426301035,
 -1,
 1426478343,
 1426344456,
 8046,
 -1,
 1426391364,
 8110,
 -1,
 1426437381,
 8104,
 1426674954,
 1426381005,
 8042,
 -1,
 1426587972,
 8106,
 1426849791,
 1426628696,
 8044,
 -1,
 1426719044,
 8108,
 -1,
 1426240773,
 8188,
 1427002647,
 1426143013,
 8041,
 1427111935,
 1426915450,
 -1,
 1427133715,
 1427021931,
 -1,
 1427199250,
 1427065352,
 8047,
 -1,
 1427112260,
 8111,
 -1,
 1427158277,
 8105,
 1427395861,
 1427101901,
 8043,
 -1,
 1427308868,
 8107,
 1427570687,
 1427349592,
 8045,
 -1,
 1427439940,
 8109,
 -43752,
 1426970829,
 8186,
 -43751,
 1427622553,
 911,
 -1,
 1427677272,
 8187,
 1427898367,
 1426023283,
 927,
 1427963903,
 1427770422,
 -1,
 1427985696,
 1427875661,
 8008,
 1428094975,
 1427898490,
 -1,
 -43745,
 1428019405,
 8010,
 -1,
 1428070488,
 8012,
 1428247844,
 1427912485,
 8009,
 1428357119,
 1428160634,
 -1,
 -43741,
 1428281549,
 8011,
 -1,
 1428332632,
 8013,
 -43739,
 1428216013,
 8184,
 -43738,
 1428474521,
 908,
 -1,
 1428529240,
 8185,
 1428706640,
 1425948839,
 -1,
 1428772163,
 1428669369,
 919,
 1428881407,
 1428687926,
 -1,
 1428903222,
 1428791403,
 -1,
 1428968757,
 1428864279,
 7976,
 1429078015,
 1428881530,
 -1,
 1429099825,
 1428988011,
 -1,
 1429165360,
 1429031432,
 7982,
 -1,
 1429078340,
 8094,
 -1,
 1429124357,
 8088,
 1429361971,
 1429067981,
 7978,
 -1,
 1429274948,
 8090,
 1429536767,
 1429315672,
 7980,
 -1,
 1429406020,
 8092,
 -1,
 1428927749,
 8140,
 1429689664,
 1428829989,
 7977,
 1429798911,
 1429602426,
 -1,
 1429820732,
 1429708907,
 -1,
 1429886267,
 1429752328,
 7983,
 -1,
 1429799236,
 8095,
 -1,
 1429845253,
 8089,
 1430082878,
 1429788877,
 7979,
 -1,
 1429995844,
 8091,
 1430257663,
 1430036568,
 7981,
 -1,
 1430126916,
 8093,
 -43711,
 1429657805,
 8138,
 -43710,
 1430309529,
 905,
 -1,
 1430364248,
 8139,
 1430585343,
 1428727635,
 917,
 1430650879,
 1430457398,
 -1,
 1430672713,
 1430562637,
 7960,
 1430781951,
 1430585466,
 -1,
 -43704,
 1430706381,
 7962,
 -1,
 1430757464,
 7964,
 1430934861,
 1430599461,
 7961,
 1431044095,
 1430847610,
 -1,
 -43700,
 1430968525,
 7963,
 -1,
 1431019608,
 7965,
 -43698,
 1430902989,
 8136,
 -43697,
 1431161497,
 904,
 -1,
 1431216216,
 8137,
 1431393648,
 1428624782,
 -1,
 1431459183,
 1431338819,
 913,
 1431568383,
 1431374902,
 -1,
 1431590239,
 1431478379,
 -1,
 1431655774,
 1431551255,
 7944,
 1431764991,
 1431568506,
 -1,
 1431786842,
 1431674987,
 -1,
 1431852377,
 1431718408,
 7950,
 -1,
 1431765316,
 8078,
 -1,
 1431811333,
 8072,
 1432048988,
 1431754957,
 7946,
 -1,
 1431961924,
 8074,
 1432223743,
 1432002648,
 7948,
 -1,
 1432092996,
 8076,
 -1,
 1431614725,
 8124,
 1432376681,
 1431516965,
 7945,
 1432485887,
 1432289402,
 -1,
 1432507749,
 1432395883,
 -1,
 1432573284,
 1432439304,
 7951,
 -1,
 1432486212,
 8079,
 -1,
 1432532229,
 8073,
 1432769895,
 1432475853,
 7947,
 -1,
 1432682820,
 8075,
 1432944639,
 1432723544,
 7949,
 -1,
 1432813892,
 8077,
 1433032044,
 1432344678,
 -1,
 -43669,
 1432988244,
 8120,
 -1,
 1433018862,
 8122,
 -43667,
 1432996505,
 902,
 -43666,
 1433182296,
 8123,
 -1,
 1433239710,
 8121,
 -1,
 1431415727,
 882,
 1433490820,
 1431333923,
 921,
 1433599999,
 1433406518,
 -1,
 1433621881,
 1433482796,
 -1,
 1433687416,
 1433543652,
 7993,
 1433796607,
 1433600122,
 -1,
 -43658,
 1433721037,
 7995,
 -43657,
 1433772879,
 7999,
 -1,
 1433837656,
 7997,
 -1,
 1433625248,
 938,
 1434080638,
 1433577293,
 7992,
 1434189823,
 1433993338,
 -1,
 -43652,
 1434114253,
 7994,
 -43651,
 1434166095,
 7998,
 -1,
 1434230872,
 7996,
 1434408321,
 1434048614,
 -1,
 -43648,
 1434364500,
 8152,
 -1,
 1434395118,
 8154,
 -43646,
 1434372761,
 906,
 -43645,
 1434558552,
 8155,
 -1,
 1434615966,
 8153,
 1434801555,
 1433458061,
 933,
 1434910719,
 1434717238,
 -1,
 1434932621,
 1434793516,
 -1,
 1434998156,
 1434854372,
 8025,
 1435107327,
 1434910842,
 -1,
 -43638,
 1435031757,
 8027,
 -43637,
 1435083599,
 8031,
 -1,
 1435148376,
 8029,
 -1,
 1434935968,
 939,
 1435391376,
 1434900582,
 -1,
 -43633,
 1435347540,
 8168,
 -1,
 1435378158,
 8170,
 -43631,
 1435355801,
 910,
 -43630,
 1435541592,
 8171,
 -1,
 1435599006,
 8169,
 1435784600,
 1434755179,
 -1,
 -43627,
 1435745389,
 936,
 -43626,
 1435787751,
 928,
 -43625,
 1435852017,
 934,
 -1,
 1435901251,
 886,
 1436112284,
 1435744176,
 -1,
 -43622,
 1436050920,
 931,
 -43621,
 1436114631,
 1015,
 -1,
 1436163427,
 1018,
 1436374431,
 1436074872,
 -1,
 -43618,
 1436310726,
 920,
 -1,
 1436362164,
 932,
 1436571041,
 1436331639,
 929,
 -1,
 1436486878,
 8172,
 -43614,
 1436543142,
 918,
 -43613,
 1436673118,
 926,
 -43612,
 1436717178,
 925,
 -43611,
 1436780564,
 924,
 -43610,
 1436841291,
 923,
 -43609,
 1436905853,
 922,
 -43608,
 1436966086,
 880,
 -43607,
 1437029317,
 915,
 -43606,
 1437087679,
 916,
 -43605,
 1437151182,
 935,
 -1,
 1437215036,
 914,
 -1,
 1425920664,
 1017,
 1437488560,
 1425845746,
 -1,
 -43601,
 1437433780,
 1021,
 -1,
 1437482027,
 1023,
 -43599,
 1437452101,
 1012,
 -43598,
 1437626678,
 975,
 -1,
 1437678635,
 1022,
 1437881864,
 1425741198,
 -1,
 1437947396,
 1437807679,
 -1,
 1438012890,
 1437869459,
 -1,
 1438078409,
 1437945937,
 -1,
 1438143938,
 1438046642,
 65859,
 1438253055,
 1438056448,
 -1,
 1438275005,
 1438172024,
 -1,
 1438340540,
 1438212215,
 65862,
 -1,
 1438255815,
 65870,
 -1,
 1438260047,
 65864,
 1438537153,
 1438212479,
 65861,
 1438646271,
 1438449664,
 -1,
 -43584,
 1438565485,
 65868,
 -1,
 1438630128,
 65875,
 -1,
 1438499056,
 65871,
 1438908415,
 1438077702,
 65860,
 1438973951,
 1438777344,
 -1,
 1438995912,
 1438892920,
 -1,
 1439061447,
 1438933111,
 65863,
 -1,
 1438976658,
 65878,
 -1,
 1438980943,
 65866,
 -1,
 1438957808,
 65873,
 1439323604,
 1438029350,
 -1,
 1439389135,
 1439258867,
 -1,
 1439454670,
 1439355661,
 -1,
 -43571,
 1439417453,
 65867,
 -1,
 1439482096,
 65874,
 -1,
 1439374191,
 65857,
 1439716818,
 1439352778,
 -1,
 -43567,
 1439679597,
 65869,
 -1,
 1439744240,
 65876,
 -43565,
 1439672535,
 65856,
 -1,
 1439842269,
 65858,
 1440088063,
 1439286734,
 -1,
 1440110040,
 1440007032,
 -1,
 -43561,
 1440047253,
 65877,
 -1,
 1440095055,
 65865,
 -43559,
 1440071920,
 65872,
 -1,
 1440253563,
 65879,
 1440437747,
 1437975416,
 -1,
 1440503275,
 1440373943,
 -1,
 1440568802,
 1440465784,
 -1,
 1440634336,
 1440504051,
 -1,
 -43553,
 1440591078,
 65899,
 -1,
 1440640324,
 65893,
 -43551,
 1440604769,
 65884,
 -1,
 1440761617,
 65892,
 1440962022,
 1440519714,
 65881,
 1441071103,
 1440874496,
 -1,
 -43547,
 1440991169,
 65905,
 -1,
 1441030527,
 65898,
 1441267711,
 1440895057,
 -1,
 1441289706,
 1441192373,
 -1,
 -43543,
 1441253313,
 65906,
 -1,
 1441292671,
 65902,
 -1,
 1441223430,
 65897,
 1441595391,
 1440461960,
 -1,
 1441617393,
 1441484881,
 -1,
 1441682927,
 1441585586,
 65887,
 -1,
 1441596534,
 65901,
 1441857535,
 1441616646,
 65894,
 -1,
 1441726542,
 65895,
 1441988607,
 1441580490,
 65888,
 -1,
 1441857614,
 65889,
 1442076153,
 1440373906,
 -1,
 1442141688,
 1442022971,
 -1,
 -43530,
 1442104778,
 65890,
 -43529,
 1442158114,
 65882,
 -1,
 1442205793,
 65896,
 -1,
 1442060442,
 65880,
 1442469373,
 1442007255,
 -1,
 1442534908,
 1442434566,
 65883,
 -1,
 1442448270,
 65886,
 -1,
 1442468116,
 65900,
 1442731520,
 1442393347,
 -1,
 -43521,
 1442703225,
 65885,
 -1,
 1442718508,
 65903,
 -43519,
 1442693489,
 65908,
 -43518,
 1442876014,
 65904,
 -43517,
 1442940069,
 65891,
 -1,
 1442985896,
 65907,
 1443190279,
 1437903318,
 -1,
 -43514,
 1443152883,
 65926,
 -1,
 1443208423,
 65927,
 -1,
 1443139069,
 903,
 1443452463,
 1437821438,
 -1,
 1443517969,
 1443369942,
 119327,
 -43509,
 1443435867,
 119356,
 -43508,
 1443501351,
 119355,
 -43507,
 1443566816,
 119354,
 -43506,
 1443632163,
 119353,
 -43505,
 1443697510,
 119352,
 -43504,
 1443762881,
 119351,
 -1,
 1443828137,
 119350,
 1444042265,
 1443435049,
 119325,
 -43501,
 1443960155,
 119337,
 -43500,
 1444025639,
 119336,
 -43499,
 1444091104,
 119335,
 -43498,
 1444156374,
 119334,
 -43497,
 1444221798,
 119333,
 -43496,
 1444287169,
 119332,
 -1,
 1444352553,
 119331,
 1444566560,
 1443959489,
 119326,
 -43493,
 1444484443,
 119343,
 -43492,
 1444549856,
 119342,
 -43491,
 1444615323,
 119341,
 -43490,
 1444680739,
 119340,
 -43489,
 1444746198,
 119339,
 -1,
 1444811622,
 119338,
 1445025318,
 1444484131,
 119328,
 -43486,
 1444942806,
 119361,
 -43485,
 1445008230,
 119360,
 -43484,
 1445073601,
 119359,
 -43483,
 1445138985,
 119358,
 -1,
 1445204393,
 119357,
 1445418541,
 1444942694,
 -1,
 -43480,
 1445336411,
 119349,
 -43479,
 1445401895,
 119348,
 -43478,
 1445467360,
 119347,
 -43477,
 1445532827,
 119346,
 -43476,
 1445597889,
 119345,
 -1,
 1445663145,
 119344,
 -43474,
 1445336359,
 119330,
 -1,
 1445795040,
 119329,
 1446008399,
 1443420262,
 -1,
 1446073934,
 1445958306,
 -1,
 1446139452,
 1445990953,
 119296,
 -43469,
 1446057307,
 119314,
 -43468,
 1446122791,
 119313,
 -43467,
 1446188256,
 119312,
 -43466,
 1446253723,
 119311,
 -43465,
 1446319139,
 119310,
 -43464,
 1446384598,
 119309,
 -43463,
 1446450022,
 119308,
 -43462,
 1446515393,
 119307,
 -43461,
 1446580777,
 119306,
 -1,
 1446646185,
 119305,
 1446860354,
 1446056995,
 119300,
 -43458,
 1446777814,
 119324,
 -43457,
 1446843238,
 119323,
 -43456,
 1446908609,
 119322,
 -43455,
 1446973993,
 119321,
 -1,
 1447039401,
 119320,
 1447253576,
 1446777537,
 119297,
 -43452,
 1447171030,
 119319,
 -43451,
 1447236454,
 119318,
 -43450,
 1447301825,
 119317,
 -43449,
 1447367209,
 119316,
 -1,
 1447432617,
 119315,
 -43447,
 1447171419,
 119304,
 -43446,
 1447564583,
 119303,
 -43445,
 1447630048,
 119302,
 -43444,
 1447695515,
 119301,
 -43443,
 1447760854,
 119299,
 -1,
 1447826278,
 119298,
 -1,
 1445994990,
 8175,
 1448105572,
 1445950404,
 -1,
 1448171103,
 1448037472,
 -1,
 1448236635,
 1448130480,
 -1,
 1448302169,
 1448182167,
 -1,
 1448367702,
 1448255595,
 -1,
 -43435,
 1448328301,
 7466,
 -1,
 1448370663,
 7464,
 -43433,
 1448324727,
 7465,
 -43432,
 1448506699,
 7463,
 -1,
 1448563653,
 7462,
 -43430,
 1448265863,
 986,
 -1,
 1448680789,
 992,
 -43428,
 1448208162,
 1011,
 -43427,
 1448833816,
 990,
 -43426,
 1448884636,
 988,
 -1,
 1448943971,
 984,
 1449154146,
 1448137361,
 -1,
 -43423,
 1449114799,
 1010,
 -1,
 1449150710,
 1013,
 -43421,
 1449107432,
 885,
 -1,
 1449291437,
 65923,
 1449481841,
 1448031788,
 -1,
 1449547371,
 1449419433,
 -1,
 1449612906,
 1449467280,
 -1,
 -43416,
 1449580749,
 8173,
 -43415,
 1449632591,
 8129,
 -1,
 1449697368,
 8174,
 -1,
 1449577113,
 901,
 1449940592,
 1449468900,
 8190,
 1450049535,
 1449853050,
 -1,
 -43410,
 1449973965,
 8157,
 -43409,
 1450025807,
 8159,
 -1,
 1450090584,
 8158,
 -1,
 1449896520,
 65915,
 1450333821,
 1449444216,
 -1,
 1450399351,
 1450268915,
 -1,
 1450464886,
 1450355937,
 -1,
 -43403,
 1450420497,
 65912,
 -1,
 1450480265,
 65918,
 -1,
 1450396562,
 977,
 1450727034,
 1450369636,
 -1,
 -43399,
 1450690445,
 65911,
 -1,
 1450742409,
 65917,
 -43397,
 1450686345,
 65929,
 -43396,
 1450874578,
 900,
 -1,
 1450908484,
 65914,
 1451120263,
 1450287211,
 -1,
 1451185795,
 1451080983,
 8127,
 1451294719,
 1451098234,
 -1,
 -43391,
 1451219149,
 8141,
 -43390,
 1451270991,
 8143,
 -1,
 1451335768,
 8142,
 -43388,
 1451144453,
 8126,
 -43387,
 1451450925,
 982,
 -43386,
 1451515138,
 981,
 -1,
 1451575816,
 8128,
 1451775629,
 1451069938,
 -1,
 1451841162,
 1451723653,
 65909,
 -1,
 1451753550,
 65910,
 -43381,
 1451811937,
 8189,
 -43380,
 1451938679,
 65924,
 -1,
 1451961058,
 65916,
 1452168851,
 1451716854,
 -1,
 1452234385,
 1452086670,
 -1,
 -43376,
 1452189191,
 1008,
 -1,
 1452237357,
 983,
 -43374,
 1452205412,
 65922,
 -1,
 1452382722,
 8125,
 1452562071,
 1452135829,
 -1,
 -43371,
 1452498712,
 978,
 -43370,
 1452554420,
 980,
 -1,
 1452611545,
 979,
 1452824220,
 1452517846,
 -1,
 1452889755,
 1452760778,
 -1,
 -43366,
 1452859811,
 1020,
 -1,
 1452917497,
 1009,
 -1,
 1452821814,
 1014,
 1453151903,
 1452795072,
 -1,
 -43362,
 1453106485,
 890,
 -1,
 1453146470,
 65913,
 1453348514,
 1453097032,
 -1,
 -43359,
 1453315945,
 119365,
 -1,
 1453345850,
 65921,
 1453545125,
 1453280926,
 -1,
 -43356,
 1453497535,
 65919,
 -1,
 1453551357,
 65920,
 -43354,
 1453516944,
 65930,
 -43353,
 1453712453,
 65925,
 -43352,
 1453762880,
 894,
 -43351,
 1453822166,
 884,
 -43350,
 1453872892,
 65928,
 -1,
 1453926721,
 976,
 1454178303,
 1410999508,
 -1,
 1454200507,
 1454084594,
 -1,
 1454266040,
 1454156248,
 -1,
 1454331571,
 1454226953,
 10878,
 1454440447,
 1454247188,
 -1,
 1454462642,
 1454315151,
 10882,
 -1,
 1454376316,
 10884,
 -1,
 1454402039,
 10880,
 1454659254,
 1454262550,
 -1,
 -43339,
 1454599892,
 8819,
 -1,
 1454643786,
 8805,
 -43337,
 1454602679,
 8823,
 -1,
 1454776399,
 10886,
 1455030271,
 1454234199,
 -1,
 -43334,
 1454929358,
 10916,
 -1,
 1454965674,
 8807,
 1455183560,
 1454118286,
 -1,
 1455249093,
 1455106931,
 -1,
 1455314626,
 1455208368,
 -1,
 1455380161,
 1455253315,
 -1,
 -43328,
 1455331462,
 10894,
 -1,
 1455363827,
 10896,
 -1,
 1455322525,
 10900,
 -43325,
 1455272236,
 10616,
 -43324,
 1455585729,
 10898,
 -1,
 1455635985,
 10892,
 1455882239,
 1455196867,
 -1,
 -43321,
 1455799683,
 10888,
 -1,
 1455853230,
 10890,
 1456035532,
 1455153220,
 -1,
 -43318,
 1455991118,
 10876,
 -43317,
 1456028468,
 8919,
 -1,
 1456091248,
 10874,
 1456297681,
 1455957659,
 -1,
 1456363216,
 1456265161,
 -1,
 -43313,
 1456303828,
 8935,
 -1,
 1456347722,
 8809,
 -1,
 1456294610,
 10917,
 1456625363,
 1456222650,
 10919,
 -1,
 1456537633,
 10921,
 -43308,
 1456585916,
 62,
 -1,
 1456687446,
 8923,
 -1,
 1410934286,
 96,
 1456953266,
 1410911982,
 -1,
 1457018696,
 1456893858,
 -1,
 1457084184,
 1456962114,
 -1,
 1457149664,
 1457051750,
 -1,
 1457215199,
 1457099448,
 -1,
 1457280733,
 1457170902,
 2699,
 -1,
 1457236438,
 2784,
 1457455103,
 1457222596,
 2700,
 -1,
 1457353668,
 2785,
 -1,
 1457132942,
 2741,
 1457608422,
 1457111928,
 -1,
 1457673956,
 1457570680,
 -1,
 -43293,
 1457608977,
 2720,
 -1,
 1457657230,
 2719,
 -43291,
 1457608977,
 2725,
 -1,
 1457788302,
 2724,
 1458001643,
 1457555778,
 -1,
 -43288,
 1457972476,
 2718,
 -43287,
 1458014622,
 2723,
 -43286,
 1458066271,
 2713,
 -1,
 1458115982,
 2728,
 1458329329,
 1457927724,
 -1,
 1458394863,
 1458255404,
 -1,
 -43282,
 1458329873,
 2722,
 -1,
 1458378126,
 2721,
 -43280,
 1458329873,
 2727,
 -1,
 1458509198,
 2726,
 1458722549,
 1458247054,
 2693,
 -43277,
 1458687726,
 2708,
 -43276,
 1458725351,
 2704,
 -1,
 1458771342,
 2694,
 1458984697,
 1458681776,
 -1,
 -43273,
 1458944042,
 2743,
 -43272,
 1458985233,
 2742,
 -1,
 1459033486,
 2744,
 1459246843,
 1458949870,
 2697,
 -1,
 1459212014,
 2698,
 1459377918,
 1459200107,
 -1,
 -43267,
 1459312913,
 2731,
 -1,
 1459361166,
 2730,
 1459574529,
 1459319748,
 -1,
 -43264,
 1459516441,
 2739,
 -1,
 1459557774,
 2738,
 1459771140,
 1459515638,
 -1,
 -43261,
 1459706129,
 2710,
 -1,
 1459754382,
 2709,
 1459967751,
 1459711895,
 -1,
 -43258,
 1459902737,
 2717,
 -1,
 1459950990,
 2716,
 1460164361,
 1459904999,
 2695,
 -1,
 1460101607,
 2696,
 1460295436,
 1460097835,
 -1,
 -43253,
 1460230417,
 2712,
 -1,
 1460278670,
 2711,
 1460492047,
 1460219139,
 -1,
 -43250,
 1460427025,
 2715,
 -1,
 1460475278,
 2714,
 1460688658,
 1460414107,
 -1,
 -43247,
 1460623633,
 2733,
 -1,
 1460671886,
 2732,
 -43245,
 1460659452,
 2735,
 -43244,
 1460841009,
 2736,
 -43243,
 1460900338,
 2707,
 -43242,
 1460961429,
 2734,
 -43241,
 1461016849,
 2745,
 -1,
 1461076135,
 2703,
 1461278511,
 1457053025,
 -1,
 1461344044,
 1461238977,
 -1,
 1461409567,
 1461312737,
 -1,
 1461475101,
 1461365206,
 2755,
 -1,
 1461430742,
 2756,
 1461649407,
 1461416900,
 2786,
 -1,
 1461547972,
 2787,
 1461737251,
 1461327246,
 -1,
 -43231,
 1461702382,
 2764,
 -43230,
 1461740007,
 2760,
 -1,
 1461785998,
 2750,
 1461999397,
 1461702382,
 2753,
 -1,
 1461964526,
 2754,
 1462130471,
 1461936615,
 2751,
 -1,
 1462067687,
 2752,
 1462261546,
 1462054340,
 -1,
 -43223,
 1462211058,
 2761,
 -1,
 1462255783,
 2757,
 -43221,
 1462211058,
 2763,
 -1,
 1462386855,
 2759,
 1462632447,
 1461267908,
 -1,
 -43218,
 1462538738,
 2705,
 -1,
 1462583463,
 2701,
 1462785853,
 1461205412,
 -1,
 1462851379,
 1462748024,
 -1,
 -43214,
 1462821473,
 2792,
 -1,
 1462853822,
 2793,
 1463047990,
 1462810544,
 -1,
 -43211,
 1462988636,
 2796,
 -1,
 1463045295,
 2797,
 1463244601,
 1462980254,
 -1,
 -43208,
 1463196786,
 2794,
 -1,
 1463250661,
 2795,
 -43206,
 1463216239,
 2790,
 -43205,
 1463391778,
 2791,
 -43204,
 1463455007,
 2799,
 -1,
 1463502167,
 2798,
 1463703366,
 1462746305,
 -1,
 1463768897,
 1463671863,
 -1,
 -43200,
 1463728310,
 2691,
 -1,
 1463790351,
 2765,
 1463965508,
 1463686542,
 -1,
 -43197,
 1463933053,
 2749,
 -1,
 1463980328,
 2690,
 -43195,
 1463914648,
 2748,
 -1,
 1464085977,
 2689,
 -43193,
 1463662429,
 2801,
 -1,
 1464243497,
 2768,
 1464424369,
 1456976930,
 -1,
 1464489866,
 1464367682,
 -1,
 1464555344,
 1464451960,
 -1,
 1464620878,
 1464517496,
 -1,
 -43187,
 1464555793,
 2592,
 -1,
 1464604046,
 2591,
 -43185,
 1464555793,
 2597,
 -1,
 1464735118,
 2596,
 1464948565,
 1464502594,
 -1,
 -43182,
 1464919292,
 2590,
 -43181,
 1464961438,
 2595,
 -43180,
 1465013087,
 2585,
 -1,
 1465062798,
 2600,
 1465276251,
 1464874540,
 -1,
 1465341785,
 1465202220,
 -1,
 -43176,
 1465276689,
 2594,
 -1,
 1465324942,
 2593,
 -43174,
 1465276689,
 2599,
 -1,
 1465456014,
 2598,
 1465669471,
 1465193870,
 2565,
 -43171,
 1465634542,
 2580,
 -43170,
 1465672167,
 2576,
 -1,
 1465718158,
 2566,
 1465931620,
 1465610486,
 -1,
 1465997155,
 1465866483,
 -1,
 -43166,
 1465932049,
 2649,
 -1,
 1465980302,
 2582,
 -1,
 1465914766,
 2581,
 1466259305,
 1465865003,
 -1,
 1466324840,
 1466194163,
 -1,
 -43161,
 1466259729,
 2650,
 -1,
 1466307982,
 2584,
 -1,
 1466242446,
 2583,
 1466586987,
 1466224366,
 2569,
 -1,
 1466552046,
 2570,
 1466718062,
 1466546096,
 -1,
 -43155,
 1466652945,
 2614,
 -1,
 1466701198,
 2616,
 1466914673,
 1466673622,
 -1,
 -43152,
 1466870321,
 2652,
 -1,
 1466897806,
 2608,
 1467111284,
 1466867819,
 -1,
 -43149,
 1467046161,
 2603,
 -1,
 1467094414,
 2602,
 1467307895,
 1467052996,
 -1,
 -43146,
 1467249689,
 2611,
 -1,
 1467291022,
 2610,
 1467504506,
 1467248535,
 -1,
 -43143,
 1467439377,
 2589,
 -1,
 1467487630,
 2588,
 1467701116,
 1467441639,
 2567,
 -1,
 1467638247,
 2568,
 1467832191,
 1467624707,
 -1,
 -43138,
 1467767057,
 2587,
 -1,
 1467815310,
 2586,
 1468028802,
 1467754139,
 -1,
 -43135,
 1467963665,
 2605,
 -1,
 1468011918,
 2604,
 -43133,
 1468000266,
 2651,
 -43132,
 1468196092,
 2607,
 -43131,
 1468258420,
 2613,
 -43130,
 1468307206,
 2579,
 -43129,
 1468366997,
 2606,
 -43128,
 1468422417,
 2617,
 -43127,
 1468485383,
 2654,
 -1,
 1468547911,
 2575,
 1468749720,
 1464416676,
 -1,
 1468815246,
 1468711800,
 -1,
 -43123,
 1468785249,
 2664,
 -1,
 1468817598,
 2665,
 1469011857,
 1468774320,
 -1,
 -43120,
 1468952412,
 2668,
 -1,
 1469009071,
 2669,
 1469208468,
 1468944030,
 -1,
 -43117,
 1469160562,
 2666,
 -1,
 1469214437,
 2667,
 -43115,
 1469180015,
 2662,
 -43114,
 1469355554,
 2663,
 -43113,
 1469418783,
 2671,
 -1,
 1469465943,
 2670,
 1469667235,
 1468718472,
 -1,
 1469732765,
 1469584782,
 -1,
 -43109,
 1469697774,
 2636,
 -43108,
 1469735399,
 2632,
 -1,
 1469781390,
 2622,
 1469994911,
 1469697774,
 2625,
 -1,
 1469959918,
 2626,
 1470125985,
 1469932007,
 2623,
 -1,
 1470063079,
 2624,
 -43102,
 1470076678,
 2635,
 -1,
 1470186311,
 2631,
 1470388140,
 1469627585,
 -1,
 1470453671,
 1470356535,
 -1,
 -43098,
 1470412982,
 2563,
 -1,
 1470475023,
 2637,
 -43096,
 1470424374,
 2677,
 -43095,
 1470615713,
 2641,
 -43094,
 1470664856,
 2620,
 -43093,
 1470704025,
 2562,
 -1,
 1470765062,
 2561,
 -43091,
 1470355019,
 2675,
 -43090,
 1470941572,
 2672,
 -43089,
 1470983425,
 2674,
 -43088,
 1471038916,
 2676,
 -1,
 1471092769,
 2673,
 -1,
 1464344875,
 8370,
 1471371362,
 1456881831,
 -1,
 1471436891,
 1471320562,
 -1,
 1471502422,
 1471393371,
 -1,
 1471567857,
 1471445570,
 -1,
 1471633341,
 1471502579,
 -1,
 1471698874,
 1471550862,
 -1,
 -43079,
 1471654358,
 4340,
 -1,
 1471692967,
 4336,
 -43077,
 1471648568,
 4341,
 -43076,
 1471833240,
 4338,
 -1,
 1471889575,
 4337,
 1472092099,
 1471556867,
 -1,
 1472157633,
 1472026867,
 -1,
 -43072,
 1472096152,
 4329,
 -1,
 1472143489,
 4333,
 -43070,
 1472095813,
 4332,
 -1,
 1472273763,
 4330,
 1472485320,
 1472054136,
 -1,
 1472550855,
 1472402830,
 -1,
 -43066,
 1472506326,
 4322,
 -1,
 1472563522,
 4311,
 -1,
 1472517837,
 4345,
 1472813003,
 1472456696,
 -1,
 -43062,
 1472748256,
 4319,
 -1,
 1472808721,
 4310,
 1473009614,
 1472777966,
 -1,
 -43059,
 1472956738,
 4323,
 -1,
 1472991027,
 983902,
 1473206225,
 1472968624,
 -1,
 -43056,
 1473142251,
 4328,
 -1,
 1473191267,
 4321,
 1473402836,
 1473159275,
 -1,
 -43053,
 1473338080,
 4324,
 -1,
 1473388673,
 4318,
 1473599447,
 1473343734,
 -1,
 -43050,
 1473534688,
 4325,
 -1,
 1473584483,
 4313,
 1473796058,
 1473539991,
 -1,
 -43047,
 1473734213,
 4331,
 -1,
 1473796737,
 4335,
 1473992669,
 1473729323,
 -1,
 -43044,
 1473927809,
 4326,
 -1,
 1473977699,
 4306,
 1474189280,
 1473921191,
 -1,
 -43041,
 1474136386,
 4308,
 -1,
 1474198250,
 4344,
 1474385891,
 1474106766,
 -1,
 -43038,
 1474332994,
 4304,
 -1,
 1474389912,
 4346,
 -43036,
 1474356973,
 4343,
 -43035,
 1474552843,
 4334,
 -43034,
 1474617124,
 4339,
 -43033,
 1474681972,
 4309,
 -43032,
 1474734719,
 4320,
 -43031,
 1474799634,
 4327,
 -43030,
 1474860432,
 4317,
 -43029,
 1474923026,
 4316,
 -43028,
 1474986585,
 4315,
 -43027,
 1475048938,
 4314,
 -43026,
 1475110808,
 4312,
 -43025,
 1475170385,
 4342,
 -43024,
 1475230500,
 4307,
 -1,
 1475290967,
 4305,
 1475500067,
 1471528615,
 -1,
 1475565561,
 1475434739,
 -1,
 1475631094,
 1475483022,
 -1,
 -43019,
 1475586518,
 11556,
 -1,
 1475625127,
 11552,
 -43017,
 1475580728,
 11557,
 -43016,
 1475765400,
 11554,
 -1,
 1475821735,
 11553,
 1476024319,
 1475489027,
 -1,
 1476089853,
 1475959027,
 -1,
 -43012,
 1476028312,
 11545,
 -1,
 1476075649,
 11549,
 -43010,
 1476027973,
 11548,
 -1,
 1476205923,
 11546,
 1476417538,
 1475995640,
 -1,
 -43007,
 1476352736,
 11535,
 -1,
 1476413201,
 11526,
 1476614149,
 1476379577,
 -1,
 -43004,
 1476569558,
 11538,
 -1,
 1476626754,
 11527,
 1476810760,
 1476573104,
 -1,
 -43001,
 1476746731,
 11544,
 -1,
 1476795747,
 11537,
 1477007371,
 1476763755,
 -1,
 -42998,
 1476942560,
 11540,
 -1,
 1476993153,
 11534,
 1477203982,
 1476948214,
 -1,
 -42995,
 1477139168,
 11541,
 -1,
 1477188963,
 11529,
 1477400593,
 1477144471,
 -1,
 -42992,
 1477338693,
 11547,
 -1,
 1477401217,
 11551,
 1477597204,
 1477333803,
 -1,
 -42989,
 1477532289,
 11542,
 -1,
 1477582179,
 11522,
 -42987,
 1477567499,
 11550,
 -42986,
 1477762852,
 11555,
 -42985,
 1477827700,
 11525,
 -42984,
 1477890679,
 11539,
 -42983,
 1477945983,
 11536,
 -42982,
 1478010898,
 11543,
 -42981,
 1478071696,
 11533,
 -42980,
 1478134290,
 11532,
 -42979,
 1478197849,
 11531,
 -42978,
 1478260202,
 11530,
 -42977,
 1478322072,
 11528,
 -42976,
 1478379281,
 11524,
 -42975,
 1478441764,
 11523,
 -42974,
 1478502231,
 11521,
 -1,
 1478565219,
 11520,
 1478776917,
 1475423785,
 -1,
 1478842411,
 1478711539,
 -1,
 1478907944,
 1478759822,
 -1,
 -42969,
 1478863318,
 4292,
 -1,
 1478901927,
 4288,
 -42967,
 1478857528,
 4293,
 -42966,
 1479042200,
 4290,
 -1,
 1479098535,
 4289,
 1479301169,
 1478765827,
 -1,
 1479366703,
 1479235827,
 -1,
 -42962,
 1479305112,
 4281,
 -1,
 1479352449,
 4285,
 -42960,
 1479304773,
 4284,
 -1,
 1479482723,
 4282,
 1479694388,
 1479272440,
 -1,
 -42957,
 1479629536,
 4271,
 -1,
 1479690001,
 4262,
 1479890999,
 1479656377,
 -1,
 -42954,
 1479846358,
 4274,
 -1,
 1479903554,
 4263,
 1480087610,
 1479849904,
 -1,
 -42951,
 1480023531,
 4280,
 -1,
 1480072547,
 4273,
 1480284221,
 1480040555,
 -1,
 -42948,
 1480219360,
 4276,
 -1,
 1480269953,
 4270,
 1480480832,
 1480225014,
 -1,
 -42945,
 1480415968,
 4277,
 -1,
 1480465763,
 4265,
 1480677443,
 1480421271,
 -1,
 -42942,
 1480615493,
 4283,
 -1,
 1480678017,
 4287,
 1480874054,
 1480610603,
 -1,
 -42939,
 1480809089,
 4278,
 -1,
 1480858979,
 4258,
 -42937,
 1480844299,
 4286,
 -42936,
 1481039652,
 4291,
 -42935,
 1481104500,
 4261,
 -42934,
 1481167479,
 4275,
 -42933,
 1481222783,
 4272,
 -42932,
 1481287698,
 4279,
 -42931,
 1481348496,
 4269,
 -42930,
 1481411090,
 4268,
 -42929,
 1481474649,
 4267,
 -42928,
 1481537002,
 4266,
 -42927,
 1481598872,
 4264,
 -42926,
 1481656081,
 4260,
 -42925,
 1481718564,
 4259,
 -42924,
 1481779031,
 4257,
 -1,
 1481842019,
 4256,
 -1,
 1478730108,
 4347,
 1482162175,
 1471448272,
 -1,
 1482184794,
 1482038333,
 -1,
 -42919,
 1482125012,
 8782,
 -1,
 1482168906,
 8785,
 -1,
 1482099081,
 8762,
 1482446943,
 1471357057,
 9881,
 1482555391,
 1482361904,
 -1,
 -42914,
 1482464567,
 9965,
 -1,
 1482490945,
 9966,
 -42912,
 1482408896,
 12307,
 -42911,
 1482667001,
 8368,
 -1,
 1482720758,
 9802,
 1482905827,
 1471312836,
 -1,
 1482971362,
 1482823942,
 -1,
 1483036835,
 1482931879,
 -1,
 1483102318,
 1482995632,
 -1,
 1483167850,
 1483036915,
 -1,
 1483233385,
 1483129785,
 11339,
 -1,
 1483187217,
 11356,
 -1,
 1483150734,
 11342,
 1483429996,
 1483113034,
 11348,
 -1,
 1483345535,
 11349,
 -42899,
 1483383834,
 11346,
 -1,
 1483505277,
 11332,
 1483692151,
 1483072704,
 -1,
 1483757684,
 1483620519,
 -1,
 1483823219,
 1483712982,
 -1,
 -42894,
 1483788014,
 11343,
 -1,
 1483825639,
 11344,
 -1,
 1483784721,
 11317,
 -42891,
 1483722478,
 11347,
 -42890,
 1484034546,
 11350,
 -1,
 1484072247,
 11345,
 1484281983,
 1483629031,
 11323,
 1484347515,
 1484253355,
 -1,
 -42886,
 1484287671,
 11355,
 -1,
 1484341415,
 11321,
 1484544126,
 1484299020,
 -1,
 -42883,
 1484504823,
 11351,
 -1,
 1484532093,
 11353,
 -1,
 1484492164,
 11322,
 1484806275,
 1484243832,
 -1,
 -42879,
 1484774836,
 11333,
 -42878,
 1484831853,
 11340,
 -1,
 1484895423,
 11357,
 1485068423,
 1484731948,
 -1,
 -42875,
 1485039698,
 11319,
 -42874,
 1485083293,
 11316,
 -1,
 1485140048,
 11324,
 1485330570,
 1485039608,
 -1,
 -42871,
 1485266567,
 11318,
 -1,
 1485326053,
 11320,
 1485527181,
 1485283435,
 -1,
 -42868,
 1485476957,
 11330,
 -1,
 1485521063,
 11338,
 1485723792,
 1485476338,
 -1,
 -42865,
 1485688109,
 11337,
 -1,
 1485738106,
 11329,
 1485920403,
 1485665220,
 -1,
 -42862,
 1485861088,
 11326,
 -1,
 1485907289,
 11358,
 1486117014,
 1485852318,
 -1,
 -42859,
 1486074789,
 11335,
 -1,
 1486122484,
 11354,
 1486313625,
 1486038683,
 -1,
 -42856,
 1486278994,
 11313,
 -1,
 1486316789,
 11352,
 -42854,
 1486281237,
 11314,
 -42853,
 1486475593,
 11334,
 -42852,
 1486533535,
 11331,
 -42851,
 1486588456,
 11328,
 -42850,
 1486653734,
 11327,
 -42849,
 1486713157,
 11325,
 -42848,
 1486773419,
 11336,
 -42847,
 1486837298,
 11315,
 -42846,
 1486893068,
 11341,
 -1,
 1486956183,
 11312,
 1487208447,
 1482960425,
 -1,
 1487231149,
 1487124400,
 -1,
 1487296681,
 1487165683,
 -1,
 1487362216,
 1487258553,
 11291,
 -1,
 1487315985,
 11308,
 -1,
 1487279502,
 11294,
 1487558827,
 1487241802,
 11300,
 -1,
 1487474303,
 11301,
 -42836,
 1487512602,
 11298,
 -1,
 1487634045,
 11284,
 1487820982,
 1487201472,
 -1,
 1487886515,
 1487749287,
 -1,
 1487952050,
 1487841750,
 -1,
 -42831,
 1487916782,
 11295,
 -1,
 1487954407,
 11296,
 -1,
 1487913489,
 11269,
 -42828,
 1487851246,
 11299,
 -42827,
 1488163314,
 11302,
 -1,
 1488201015,
 11297,
 1488410814,
 1487757799,
 11275,
 1488476346,
 1488382123,
 -1,
 -42823,
 1488416439,
 11307,
 -1,
 1488470183,
 11273,
 1488672957,
 1488427788,
 -1,
 -42820,
 1488633591,
 11303,
 -1,
 1488660861,
 11305,
 -1,
 1488620932,
 11274,
 1488935106,
 1488372600,
 -1,
 -42816,
 1488903604,
 11285,
 -42815,
 1488960621,
 11292,
 -1,
 1489024191,
 11309,
 1489197254,
 1488860716,
 -1,
 -42812,
 1489168466,
 11271,
 -42811,
 1489212061,
 11268,
 -1,
 1489268816,
 11276,
 1489459401,
 1489168376,
 -1,
 -42808,
 1489395335,
 11270,
 -1,
 1489454821,
 11272,
 1489656012,
 1489412203,
 -1,
 -42805,
 1489605725,
 11282,
 -1,
 1489649831,
 11290,
 1489852623,
 1489605106,
 -1,
 -42802,
 1489816877,
 11289,
 -1,
 1489866874,
 11281,
 1490049234,
 1489793988,
 -1,
 -42799,
 1489989856,
 11278,
 -1,
 1490036057,
 11310,
 1490245845,
 1489981086,
 -1,
 -42796,
 1490203557,
 11287,
 -1,
 1490251252,
 11306,
 1490442456,
 1490167451,
 -1,
 -42793,
 1490407762,
 11265,
 -1,
 1490445557,
 11304,
 -42791,
 1490410005,
 11266,
 -42790,
 1490604361,
 11286,
 -42789,
 1490662303,
 11283,
 -42788,
 1490717224,
 11280,
 -42787,
 1490782502,
 11279,
 -42786,
 1490841925,
 11277,
 -42785,
 1490902187,
 11288,
 -42784,
 1490966066,
 11267,
 -42783,
 1491021836,
 11293,
 -1,
 1491084951,
 11264,
 -1,
 1482900808,
 10726,
 1491360005,
 1482857290,
 -1,
 1491425513,
 1491306818,
 -1,
 1491491048,
 1491364042,
 -1,
 -42777,
 1491455693,
 66369,
 -1,
 1491469430,
 66378,
 -1,
 1491412461,
 66365,
 1491753196,
 1491387256,
 -1,
 -42773,
 1491689084,
 66360,
 -1,
 1491748280,
 66372,
 1491949807,
 1491689959,
 -1,
 -42770,
 1491915060,
 66358,
 -1,
 1491948804,
 66375,
 1492146418,
 1491884275,
 -1,
 -42767,
 1492114973,
 66376,
 -1,
 1492130044,
 66359,
 1492343029,
 1492063630,
 -1,
 -42764,
 1492280829,
 66356,
 -1,
 1492345162,
 66352,
 -42762,
 1492312120,
 66373,
 -42761,
 1492506388,
 66367,
 -42760,
 1492564172,
 66371,
 -42759,
 1492626097,
 66370,
 -42758,
 1492690941,
 66357,
 -42757,
 1492754712,
 66368,
 -42756,
 1492818750,
 66377,
 -42755,
 1492877957,
 66364,
 -42754,
 1492940029,
 66363,
 -42753,
 1493005212,
 66362,
 -42752,
 1493069877,
 66366,
 -42751,
 1493128676,
 66354,
 -42750,
 1493192494,
 66374,
 -42749,
 1493255598,
 66361,
 -42748,
 1493317326,
 66355,
 -1,
 1493378850,
 66353,
 -1,
 1491298055,
 8503,
 1493654854,
 1410822390,
 -1,
 1493720020,
 1493570958,
 -1,
 1493785264,
 1493666114,
 -1,
 1493850683,
 1493719221,
 -1,
 1493915967,
 1493809072,
 -1,
 1493981460,
 1493877624,
 -1,
 1494046992,
 1493930482,
 -1,
 1494112527,
 1493999723,
 12108,
 -1,
 1494066231,
 12169,
 -1,
 1494059878,
 12143,
 1494309139,
 1493975207,
 -1,
 -42734,
 1494261867,
 12091,
 -1,
 1494293644,
 12115,
 -1,
 1494228364,
 12148,
 1494571291,
 1493934187,
 -1,
 1494636824,
 1494499495,
 -1,
 -42729,
 1494565461,
 12180,
 -1,
 1494622337,
 12141,
 -42727,
 1494594975,
 12076,
 -42726,
 1494783787,
 12052,
 -1,
 1494838545,
 12144,
 1495030052,
 1494505715,
 -1,
 1495095585,
 1494979058,
 -1,
 1495161120,
 1495054001,
 -1,
 -42721,
 1495097528,
 12083,
 -1,
 1495144807,
 12203,
 -1,
 1495112396,
 12087,
 1495465983,
 1495023783,
 -1,
 -42717,
 1495366762,
 12185,
 -1,
 1495419059,
 12154,
 1495619881,
 1494958247,
 -1,
 -42714,
 1495562910,
 12163,
 -42713,
 1495613607,
 12178,
 -42712,
 1495675547,
 12036,
 -1,
 1495734809,
 12057,
 1495947566,
 1495561156,
 -1,
 1496013101,
 1495864718,
 -1,
 -42708,
 1495980466,
 12202,
 -1,
 1496038052,
 12035,
 -1,
 1495950179,
 12122,
 1496275250,
 1495864718,
 -1,
 -42704,
 1496245440,
 12104,
 -42703,
 1496285000,
 12228,
 -1,
 1496331263,
 12223,
 1496537397,
 1496211943,
 -1,
 -42700,
 1496480867,
 12151,
 -1,
 1496527236,
 12135,
 1496734008,
 1496460547,
 -1,
 -42697,
 1496691494,
 12098,
 -1,
 1496735467,
 12064,
 -42695,
 1496702764,
 12130,
 -42694,
 1496896119,
 12103,
 -42693,
 1496950945,
 12101,
 -42692,
 1497013256,
 12211,
 -42691,
 1497075482,
 12089,
 -42690,
 1497137532,
 12073,
 -1,
 1497199298,
 12138,
 1497389399,
 1493841452,
 -1,
 1497454922,
 1497338354,
 -1,
 1497520453,
 1497416568,
 12034,
 1497628671,
 1497482610,
 -1,
 -42684,
 1497548300,
 12136,
 -1,
 1497575833,
 12084,
 -42682,
 1497489988,
 12044,
 -42681,
 1497747515,
 12120,
 -42680,
 1497798776,
 12094,
 -42679,
 1497846571,
 12125,
 -1,
 1497892389,
 12111,
 1498110288,
 1497391591,
 -1,
 1498175822,
 1498068912,
 -1,
 -42675,
 1498138959,
 12196,
 -1,
 1498175731,
 12139,
 -42673,
 1498143864,
 12056,
 -1,
 1498326552,
 12099,
 1498503508,
 1498065366,
 -1,
 -42670,
 1498473664,
 12082,
 -42669,
 1498534425,
 12238,
 -1,
 1498552592,
 12243,
 1498808319,
 1498431655,
 -1,
 -42666,
 1498696063,
 12229,
 -1,
 1498752223,
 12109,
 1498962286,
 1497310875,
 -1,
 1499027806,
 1498911218,
 -1,
 -42662,
 1498996186,
 12088,
 -42661,
 1499040614,
 12219,
 -42660,
 1499103051,
 12134,
 -42659,
 1499152532,
 12189,
 -1,
 1499210897,
 12168,
 1499421026,
 1498982870,
 -1,
 -42656,
 1499387735,
 12160,
 -42655,
 1499426262,
 12090,
 -1,
 1499471232,
 12096,
 1499683174,
 1499362244,
 -1,
 -42652,
 1499648178,
 12205,
 -42651,
 1499698972,
 12174,
 -1,
 1499731856,
 12234,
 1499945322,
 1499619815,
 -1,
 -42648,
 1499909369,
 12191,
 -42647,
 1499966416,
 12227,
 -1,
 1500009259,
 12068,
 1500207469,
 1499862414,
 -1,
 -42644,
 1500152679,
 12149,
 -1,
 1500199036,
 12184,
 -1,
 1500135760,
 12182,
 1500469635,
 1498923896,
 -1,
 1500535155,
 1500424662,
 -1,
 -42639,
 1500474447,
 12237,
 -42638,
 1500529479,
 12106,
 -1,
 1500583824,
 12145,
 1500797303,
 1500452238,
 -1,
 -42635,
 1500745188,
 12209,
 -42634,
 1500806250,
 12220,
 -1,
 1500850856,
 12047,
 1501059449,
 1500766817,
 12038,
 -1,
 1500972106,
 12086,
 1501190524,
 1501025827,
 -1,
 -42629,
 1501153726,
 12244,
 -1,
 1501177687,
 12081,
 1501387135,
 1501139442,
 -1,
 -42626,
 1501338426,
 12242,
 -1,
 1501400273,
 12166,
 1501583746,
 1501323751,
 -1,
 -42623,
 1501525694,
 12129,
 -1,
 1501582547,
 12172,
 -1,
 1501513489,
 12055,
 1501845910,
 1500401310,
 -1,
 1501911433,
 1501782503,
 -1,
 -42618,
 1501870756,
 12226,
 -42617,
 1501932550,
 12117,
 -42616,
 1501975865,
 12222,
 -1,
 1502037503,
 12133,
 1502239117,
 1501828494,
 -1,
 -42613,
 1502201656,
 12119,
 -42612,
 1502252058,
 12123,
 -1,
 1502293677,
 12207,
 1502501264,
 1502194134,
 -1,
 -42609,
 1502450568,
 12236,
 -1,
 1502484757,
 12217,
 1502697875,
 1502442436,
 -1,
 -42606,
 1502667968,
 12214,
 -1,
 1502730204,
 12245,
 -42604,
 1502664227,
 12113,
 -42603,
 1502844754,
 12188,
 -1,
 1502888397,
 12155,
 1503091113,
 1501768963,
 -1,
 1503156637,
 1503039986,
 -1,
 -42599,
 1503124954,
 12124,
 -42598,
 1503189591,
 12045,
 -42597,
 1503245805,
 12075,
 -42596,
 1503299534,
 12112,
 -1,
 1503362555,
 12170,
 1503549859,
 1503097796,
 -1,
 1503615393,
 1503466894,
 -1,
 -42592,
 1503583706,
 12118,
 -1,
 1503627586,
 12114,
 -42590,
 1503566660,
 12176,
 -1,
 1503749304,
 12058,
 1503943079,
 1503466894,
 -1,
 -42587,
 1503910322,
 12147,
 -42586,
 1503973763,
 12224,
 -1,
 1504032426,
 12190,
 -42584,
 1503882960,
 12194,
 -1,
 1504140764,
 12070,
 1504336317,
 1503059418,
 -1,
 1504401838,
 1504253326,
 -1,
 1504467373,
 1504345187,
 12193,
 -1,
 1504379800,
 12175,
 -1,
 1504429590,
 12116,
 1504663985,
 1504356822,
 -1,
 -42576,
 1504614006,
 12206,
 -1,
 1504649167,
 12051,
 1504860596,
 1504612850,
 -1,
 -42573,
 1504818126,
 12079,
 -1,
 1504871001,
 12069,
 1505057207,
 1504798616,
 -1,
 -42570,
 1504985255,
 12195,
 -1,
 1505048108,
 12213,
 1505253818,
 1504991475,
 -1,
 -42567,
 1505193494,
 12137,
 -1,
 1505247650,
 12230,
 1505492991,
 1505181863,
 -1,
 -42564,
 1505411240,
 12177,
 -1,
 1505435706,
 12110,
 1505647055,
 1504280648,
 -1,
 1505712584,
 1505595890,
 -1,
 1505778116,
 1505677038,
 -1,
 1505843651,
 1505724738,
 -1,
 -42558,
 1505805356,
 12077,
 -1,
 1505834540,
 12201,
 -1,
 1505806003,
 12061,
 1506105799,
 1505733078,
 -1,
 -42554,
 1506067656,
 12165,
 -1,
 1506118983,
 12192,
 -1,
 1506055568,
 12105,
 1506367947,
 1505649127,
 -1,
 -42550,
 1506315614,
 12162,
 -1,
 1506376929,
 12233,
 1506564558,
 1506295975,
 -1,
 -42547,
 1506508149,
 12128,
 -1,
 1506550929,
 12161,
 -1,
 1506483555,
 12040,
 1506826719,
 1505588164,
 -1,
 1506892246,
 1506754727,
 -1,
 1506957780,
 1506809230,
 -1,
 -42541,
 1506920248,
 12208,
 -1,
 1506954910,
 12212,
 -42539,
 1506891899,
 12041,
 -1,
 1507083709,
 12210,
 1507285466,
 1506828775,
 -1,
 -42536,
 1507232614,
 12033,
 -42535,
 1507282798,
 12131,
 -1,
 1507341868,
 12039,
 1507547612,
 1507235446,
 12199,
 -1,
 1507461787,
 12085,
 1507721215,
 1507464590,
 -1,
 -42530,
 1507623806,
 12074,
 -1,
 1507668292,
 12107,
 1507875313,
 1506760947,
 -1,
 1507940838,
 1507792270,
 -1,
 1508006372,
 1507881924,
 -1,
 -42525,
 1507938020,
 12121,
 -1,
 1507993787,
 12093,
 -42523,
 1507953344,
 12095,
 -1,
 1508142174,
 12221,
 1508334059,
 1507889650,
 -1,
 1508399594,
 1508288982,
 -1,
 -42519,
 1508358441,
 12218,
 -1,
 1508411714,
 12179,
 -1,
 1508348997,
 12037,
 1508661744,
 1508262055,
 -1,
 1508727279,
 1508578702,
 -1,
 -42514,
 1508685482,
 12092,
 -1,
 1508718124,
 12216,
 -1,
 1508673483,
 12231,
 -1,
 1508598920,
 12054,
 1509054974,
 1507803303,
 -1,
 1509120502,
 1508971918,
 -1,
 1509186037,
 1509075414,
 12159,
 -1,
 1509148339,
 12063,
 -1,
 1509147512,
 12215,
 1509382648,
 1509087809,
 12241,
 -1,
 1509320975,
 12067,
 1509513723,
 1509329218,
 -1,
 -42502,
 1509475862,
 12042,
 -1,
 1509503471,
 12062,
 -42500,
 1509483917,
 12140,
 -42499,
 1509655412,
 12235,
 -1,
 1509713227,
 12043,
 1509906954,
 1509009878,
 -1,
 1509972483,
 1509843431,
 -1,
 -42495,
 1509939799,
 12078,
 -42494,
 1509971289,
 12053,
 -1,
 1510026925,
 12150,
 1510234631,
 1509889422,
 -1,
 -42491,
 1510196088,
 12239,
 -42490,
 1510252651,
 12097,
 -1,
 1510303640,
 12204,
 -42488,
 1510199927,
 12187,
 -42487,
 1510446880,
 12071,
 -1,
 1510490767,
 12186,
 1510693395,
 1509839659,
 -1,
 1510758926,
 1510642162,
 12065,
 -42483,
 1510700706,
 12198,
 -1,
 1510738537,
 12066,
 1510955537,
 1510713905,
 -1,
 -42480,
 1510916156,
 12171,
 -1,
 1510959000,
 12146,
 -42478,
 1510891603,
 12225,
 -1,
 1511072962,
 12200,
 1511283226,
 1510645867,
 -1,
 1511348759,
 1511238102,
 -1,
 -42474,
 1511297916,
 12126,
 -1,
 1511354079,
 12059,
 -42472,
 1511301059,
 12050,
 -42471,
 1511489154,
 12158,
 -1,
 1511548146,
 12183,
 1511741985,
 1511231986,
 -1,
 1511807518,
 1511694443,
 -1,
 -42467,
 1511761363,
 12167,
 -1,
 1511802644,
 12048,
 1512004128,
 1511754598,
 12032,
 -1,
 1511963028,
 12080,
 -1,
 1511945890,
 12156,
 1512200744,
 1511658894,
 -1,
 1512266277,
 1512158710,
 -1,
 -42460,
 1512218479,
 12142,
 -1,
 1512271589,
 12164,
 -42458,
 1512236089,
 12100,
 -42457,
 1512409792,
 12157,
 -1,
 1512461215,
 12060,
 1512659501,
 1512147266,
 -1,
 1512725036,
 1512608242,
 -1,
 -42453,
 1512686456,
 12102,
 -1,
 1512749353,
 12240,
 -1,
 1512655722,
 12153,
 1512987186,
 1512595943,
 -1,
 1513052721,
 1512933698,
 -1,
 -42448,
 1513011549,
 12173,
 -1,
 1513041735,
 12072,
 -1,
 1512976045,
 12046,
 1513314869,
 1512953958,
 -1,
 -42444,
 1513252525,
 12197,
 -1,
 1513298954,
 12181,
 1513511480,
 1513254809,
 -1,
 -42441,
 1513466326,
 12152,
 -1,
 1513502550,
 12127,
 -42439,
 1513481698,
 12232,
 -42438,
 1513674539,
 12132,
 -1,
 1513714409,
 12049,
 1513947135,
 1493797316,
 -1,
 1513970309,
 1513846462,
 -1,
 1514035844,
 1513934078,
 -1,
 1514101317,
 1514002534,
 -1,
 1514166852,
 1514050232,
 -1,
 1514232386,
 1514121686,
 3211,
 -1,
 1514187222,
 3296,
 1514405887,
 1514173380,
 3212,
 -1,
 1514304452,
 3297,
 -1,
 1514083726,
 3253,
 1514560075,
 1514062712,
 -1,
 1514625609,
 1514521464,
 -1,
 -42424,
 1514559761,
 3232,
 -1,
 1514608014,
 3231,
 -42422,
 1514559761,
 3237,
 -1,
 1514739086,
 3236,
 1514953296,
 1514506562,
 -1,
 -42419,
 1514923260,
 3230,
 -42418,
 1514965406,
 3235,
 -42417,
 1515017055,
 3225,
 -1,
 1515066766,
 3240,
 1515280982,
 1514878508,
 -1,
 1515346516,
 1515206188,
 -1,
 -42413,
 1515280657,
 3234,
 -1,
 1515328910,
 3233,
 -42411,
 1515280657,
 3239,
 -1,
 1515459982,
 3238,
 1515674202,
 1515197838,
 3205,
 -42408,
 1515638510,
 3220,
 -42407,
 1515676135,
 3216,
 -1,
 1515722126,
 3206,
 1515936350,
 1515632560,
 -1,
 -42404,
 1515894826,
 3255,
 -42403,
 1515936017,
 3254,
 -1,
 1515984270,
 3256,
 1516198499,
 1515877316,
 -1,
 1516264034,
 1516139460,
 -1,
 -42399,
 1516205081,
 983042,
 -1,
 1516246414,
 3251,
 -1,
 1516180878,
 3250,
 1516526181,
 1516162798,
 3209,
 -1,
 1516490478,
 3210,
 1516657256,
 1516480982,
 -1,
 -42393,
 1516612145,
 3249,
 -1,
 1516639630,
 3248,
 1516853867,
 1516609643,
 -1,
 -42390,
 1516787985,
 3243,
 -1,
 1516836238,
 3242,
 1517050477,
 1516802546,
 3218,
 -1,
 1516999154,
 3219,
 1517181552,
 1516990710,
 -1,
 -42385,
 1517115665,
 3222,
 -1,
 1517163918,
 3221,
 1517378163,
 1517121431,
 -1,
 -42382,
 1517312273,
 3229,
 -1,
 1517360526,
 3228,
 1517574773,
 1517314535,
 3207,
 -1,
 1517511143,
 3208,
 1517705848,
 1517507371,
 -1,
 -42377,
 1517639953,
 3224,
 -1,
 1517688206,
 3223,
 1517902458,
 1517633703,
 3214,
 -1,
 1517830311,
 3215,
 1518033533,
 1517825283,
 -1,
 -42372,
 1517967633,
 3227,
 -1,
 1518015886,
 3226,
 1518230144,
 1517954715,
 -1,
 -42369,
 1518164241,
 3245,
 -1,
 1518212494,
 3244,
 -42367,
 1518200060,
 3247,
 -42366,
 1518370965,
 3246,
 -42365,
 1518426385,
 3257,
 -1,
 1518489351,
 3294,
 -1,
 1513983155,
 3285,
 1518754455,
 1513938312,
 -1,
 1518819979,
 1518722273,
 -1,
 1518885513,
 1518774742,
 3267,
 -1,
 1518840278,
 3268,
 1519058943,
 1518826436,
 3298,
 -1,
 1518957508,
 3299,
 1519147663,
 1518736782,
 -1,
 -42355,
 1519111918,
 3276,
 -42354,
 1519149543,
 3272,
 -1,
 1519195534,
 3262,
 1519409809,
 1519111918,
 3265,
 -1,
 1519374062,
 3266,
 1519540883,
 1519358450,
 3274,
 -1,
 1519489522,
 3275,
 1519671957,
 1519477223,
 3263,
 -1,
 1519608295,
 3264,
 1519845375,
 1519599783,
 3270,
 -1,
 1519730855,
 3271,
 1519934117,
 1518680484,
 -1,
 1519999643,
 1519895416,
 -1,
 -42342,
 1519968865,
 3304,
 -1,
 1520001214,
 3305,
 1520196254,
 1519957936,
 -1,
 -42339,
 1520136028,
 3308,
 -1,
 1520192687,
 3309,
 1520392865,
 1520127646,
 -1,
 -42336,
 1520344178,
 3306,
 -1,
 1520398053,
 3307,
 -42334,
 1520363631,
 3302,
 -42333,
 1520539170,
 3303,
 -42332,
 1520602399,
 3311,
 -1,
 1520649559,
 3310,
 1520851631,
 1519893697,
 -1,
 1520917161,
 1520819255,
 -1,
 -42328,
 1520875702,
 3203,
 -1,
 1520937743,
 3277,
 1521113772,
 1520833934,
 -1,
 -42325,
 1521080445,
 3261,
 -1,
 1521127720,
 3202,
 -42323,
 1521079465,
 3314,
 -42322,
 1521258648,
 3260,
 -1,
 1521315956,
 3313,
 -1,
 1520769354,
 3286,
 1521572668,
 1493746750,
 -1,
 1521638199,
 1521483776,
 -1,
 1521703731,
 1521580610,
 -1,
 1521769180,
 1521661872,
 -1,
 1521834711,
 1521713537,
 -1,
 1521900219,
 1521789398,
 -1,
 -42313,
 1521864430,
 12797,
 -42312,
 1521914354,
 12799,
 -42311,
 1521967591,
 12796,
 -42310,
 1522024615,
 12798,
 -1,
 1522079118,
 12795,
 1522293441,
 1521834227,
 -1,
 -42307,
 1522257646,
 12791,
 -42306,
 1522307570,
 12793,
 -42305,
 1522360807,
 12790,
 -42304,
 1522417831,
 12792,
 -1,
 1522472334,
 12789,
 1522686661,
 1522263232,
 -1,
 -42301,
 1522650862,
 12517,
 -42300,
 1522700786,
 12519,
 -1,
 1522734478,
 12515,
 1522948809,
 1522626806,
 -1,
 -42297,
 1522913006,
 12784,
 -42296,
 1522942119,
 12534,
 -1,
 1522996622,
 12533,
 1523210956,
 1522910072,
 -1,
 -42293,
 1523175150,
 12483,
 -1,
 1523225074,
 12787,
 1523407567,
 1523169200,
 -1,
 -42290,
 1523371758,
 12786,
 -1,
 1523409383,
 12785,
 -42288,
 1523375618,
 12526,
 -42287,
 1523568366,
 12453,
 -42286,
 1523618290,
 12457,
 -42285,
 1523683450,
 12788,
 -42284,
 1523746836,
 12794,
 -42283,
 1523802599,
 12451,
 -42282,
 1523859623,
 12455,
 -1,
 1523914126,
 12449,
 -42280,
 1521798894,
 12473,
 -42279,
 1524077042,
 12477,
 -42278,
 1524130279,
 12471,
 -42277,
 1524187303,
 12475,
 -1,
 1524241806,
 12469,
 1524456162,
 1521715522,
 12531,
 -42274,
 1524420334,
 12492,
 -42273,
 1524470258,
 12494,
 -42272,
 1524523495,
 12491,
 -42271,
 1524580519,
 12493,
 -1,
 1524635022,
 12490,
 1524849384,
 1524426744,
 -1,
 -42268,
 1524813550,
 12474,
 -42267,
 1524863474,
 12478,
 -42266,
 1524916711,
 12472,
 -42265,
 1524973735,
 12476,
 -1,
 1525028238,
 12470,
 1525242606,
 1524815974,
 -1,
 -42262,
 1525206766,
 12532,
 -42261,
 1525256690,
 12538,
 -42260,
 1525309927,
 12536,
 -42259,
 1525366951,
 12537,
 -1,
 1525421454,
 12535,
 1525635828,
 1525203832,
 -1,
 -42256,
 1525599982,
 12484,
 -42255,
 1525649906,
 12488,
 -42254,
 1525703143,
 12481,
 -42253,
 1525760167,
 12486,
 -1,
 1525814670,
 12479,
 1526029050,
 1525590486,
 -1,
 -42250,
 1525993198,
 12523,
 -42249,
 1526043122,
 12525,
 -42248,
 1526096359,
 12522,
 -42247,
 1526153383,
 12524,
 -1,
 1526207886,
 12521,
 1526422272,
 1525981291,
 -1,
 -42244,
 1526386414,
 12503,
 -42243,
 1526436338,
 12509,
 -42242,
 1526489575,
 12500,
 -42241,
 1526546599,
 12506,
 -1,
 1526601102,
 12497,
 1526815494,
 1526366280,
 -1,
 -42238,
 1526779630,
 12512,
 -42237,
 1526829554,
 12514,
 -42236,
 1526882791,
 12511,
 -42235,
 1526939815,
 12513,
 -1,
 1526994318,
 12510,
 1527208716,
 1526755574,
 -1,
 -42232,
 1527172846,
 12463,
 -42231,
 1527222770,
 12467,
 -42230,
 1527276007,
 12461,
 -42229,
 1527333031,
 12465,
 -1,
 1527387534,
 12459,
 1527601938,
 1527142643,
 -1,
 -42226,
 1527566062,
 12501,
 -42225,
 1527615986,
 12507,
 -42224,
 1527669223,
 12498,
 -42223,
 1527726247,
 12504,
 -1,
 1527780750,
 12495,
 1527995160,
 1527534379,
 -1,
 -42220,
 1527959278,
 12464,
 -42219,
 1528009202,
 12468,
 -42218,
 1528062439,
 12462,
 -42217,
 1528119463,
 12466,
 -1,
 1528173966,
 12460,
 1528388382,
 1527920172,
 -1,
 -42214,
 1528352494,
 12485,
 -42213,
 1528402418,
 12489,
 -42212,
 1528455655,
 12482,
 -42211,
 1528512679,
 12487,
 -1,
 1528567182,
 12480,
 1528781604,
 1528309403,
 -1,
 -42208,
 1528745710,
 12502,
 -42207,
 1528795634,
 12508,
 -42206,
 1528848871,
 12499,
 -42205,
 1528905895,
 12505,
 -1,
 1528960398,
 12496,
 1529174825,
 1528749530,
 -1,
 -42202,
 1529123314,
 12530,
 -42201,
 1529176551,
 12528,
 -42200,
 1529233575,
 12529,
 -1,
 1529288078,
 12527,
 1529502509,
 1529144512,
 -1,
 -42197,
 1529466606,
 12518,
 -42196,
 1529516530,
 12520,
 -1,
 1529550222,
 12516,
 1529764655,
 1529419150,
 12450,
 -1,
 1529703155,
 983944,
 -42192,
 1529728750,
 12454,
 -42191,
 1529844210,
 12458,
 -42190,
 1529897447,
 12452,
 -1,
 1529954471,
 12456,
 -42188,
 1521671418,
 12542,
 -42187,
 1530103107,
 12539,
 -42186,
 1530162739,
 12541,
 -1,
 1530214868,
 12543,
 1530462207,
 1521553430,
 -1,
 -42183,
 1530387753,
 12443,
 -42182,
 1530444185,
 12444,
 -42181,
 1530505003,
 12540,
 -1,
 1530543410,
 12448,
 1530747796,
 1521512030,
 -1,
 1530813304,
 1530690114,
 -1,
 1530878789,
 1530738220,
 -1,
 1530944323,
 1530803756,
 -1,
 -42175,
 1530878225,
 69787,
 -42174,
 1530935425,
 69786,
 -1,
 1530992014,
 69785,
 -42172,
 1530878225,
 69793,
 -1,
 1531123086,
 69792,
 1531337547,
 1530839928,
 -1,
 1531403081,
 1531298680,
 -1,
 -42168,
 1531336977,
 69784,
 -1,
 1531385230,
 69783,
 -42166,
 1531336977,
 69791,
 -1,
 1531516302,
 69790,
 1531730768,
 1531283778,
 -1,
 -42163,
 1531700476,
 69782,
 -42162,
 1531742622,
 69789,
 -42161,
 1531794271,
 69777,
 -1,
 1531843982,
 69794,
 1532058452,
 1531647374,
 69763,
 -42158,
 1532022510,
 69772,
 -42157,
 1532060135,
 69770,
 -1,
 1532106126,
 69764,
 1532320600,
 1532016560,
 -1,
 -42154,
 1532278826,
 69805,
 -42153,
 1532320017,
 69804,
 -1,
 1532368270,
 69806,
 1532582746,
 1532284654,
 69767,
 -1,
 1532546798,
 69768,
 1532713821,
 1532537302,
 -1,
 -42148,
 1532647697,
 69788,
 -1,
 1532695950,
 69801,
 1532910432,
 1532665963,
 -1,
 -42145,
 1532844305,
 69796,
 -1,
 1532892558,
 69795,
 1533107043,
 1532850422,
 -1,
 -42142,
 1533040913,
 69774,
 -1,
 1533089166,
 69773,
 1533303654,
 1533046679,
 -1,
 -42139,
 1533237521,
 69781,
 -1,
 1533285774,
 69780,
 1533500264,
 1533239783,
 69765,
 -1,
 1533436391,
 69766,
 1533631339,
 1533432619,
 -1,
 -42134,
 1533565201,
 69776,
 -1,
 1533613454,
 69775,
 1533827950,
 1533553923,
 -1,
 -42131,
 1533761809,
 69779,
 -1,
 1533810062,
 69778,
 1534024561,
 1533748891,
 -1,
 -42128,
 1533958417,
 69798,
 -1,
 1534006670,
 69797,
 -42126,
 1533994236,
 69800,
 -42125,
 1534187636,
 69803,
 -42124,
 1534235122,
 69771,
 -42123,
 1534296213,
 69799,
 -42122,
 1534358553,
 69802,
 -42121,
 1534417169,
 69807,
 -1,
 1534476455,
 69769,
 1534679939,
 1530781064,
 -1,
 1534745469,
 1534596494,
 -1,
 -42117,
 1534709486,
 69816,
 -42116,
 1534747111,
 69814,
 -1,
 1534793102,
 69808,
 1535007615,
 1534709486,
 69811,
 -1,
 1534971630,
 69812,
 1535138689,
 1534943719,
 69809,
 -1,
 1535074791,
 69810,
 -42110,
 1535087090,
 69815,
 -1,
 1535197351,
 69813,
 1535400844,
 1534638000,
 -1,
 1535466379,
 1535337969,
 -1,
 1535531912,
 1535433783,
 -1,
 -42105,
 1535490230,
 69762,
 -1,
 1535552271,
 69817,
 -42103,
 1535479960,
 69818,
 -42102,
 1535651289,
 69760,
 -1,
 1535713212,
 69761,
 -1,
 1535394435,
 69822,
 1535990673,
 1535325740,
 -1,
 1536056208,
 1535941558,
 -1,
 -42097,
 1536014698,
 69823,
 -1,
 1536046838,
 69825,
 -1,
 1535975013,
 69824,
 -42094,
 1535938730,
 69821,
 -42093,
 1536247928,
 69820,
 -1,
 1536300635,
 69819,
 1536557055,
 1530717447,
 -1,
 1536580537,
 1536457282,
 -1,
 1536646042,
 1536526658,
 -1,
 -42088,
 1536615676,
 43281,
 -42087,
 1536643935,
 43277,
 -1,
 1536693646,
 43284,
 1536908189,
 1536607096,
 -1,
 -42084,
 1536842001,
 43294,
 -1,
 1536890254,
 43282,
 1537104800,
 1536866224,
 -1,
 -42081,
 1537038609,
 43279,
 -1,
 1537086862,
 43278,
 1537301411,
 1537056875,
 -1,
 -42078,
 1537235217,
 43286,
 -1,
 1537283470,
 43285,
 1537498022,
 1537249778,
 -1,
 -42075,
 1537446386,
 43301,
 -1,
 1537491111,
 43299,
 1537694633,
 1537437942,
 -1,
 -42072,
 1537628433,
 43275,
 -1,
 1537676686,
 43274,
 1537891244,
 1537628403,
 -1,
 -42069,
 1537852345,
 43283,
 -1,
 1537873294,
 43295,
 -42067,
 1537861642,
 43280,
 -42066,
 1538057468,
 43291,
 -42065,
 1538121218,
 43293,
 -42064,
 1538185332,
 43296,
 -42063,
 1538239025,
 43290,
 -42062,
 1538293909,
 43287,
 -42061,
 1538356249,
 43292,
 -42060,
 1538417127,
 43300,
 -42059,
 1538478943,
 43276,
 -42058,
 1538537111,
 43288,
 -42057,
 1538600288,
 43297,
 -42056,
 1538664141,
 43289,
 -1,
 1538725262,
 43298,
 1538939847,
 1536506276,
 -1,
 1539005373,
 1538900856,
 -1,
 -42052,
 1538974305,
 43266,
 -1,
 1539006654,
 43267,
 1539201984,
 1538963376,
 -1,
 -42049,
 1539141468,
 43270,
 -1,
 1539198127,
 43271,
 1539398595,
 1539133086,
 -1,
 -42046,
 1539349618,
 43268,
 -1,
 1539403493,
 43269,
 -42044,
 1539369071,
 43264,
 -42043,
 1539544610,
 43265,
 -42042,
 1539607839,
 43273,
 -1,
 1539654999,
 43272,
 1539857357,
 1538907489,
 -1,
 1539922890,
 1539821294,
 43304,
 -1,
 1539850407,
 43302,
 1540053964,
 1539850407,
 43303,
 -1,
 1539981479,
 43305,
 -1,
 1540002290,
 43306,
 1540250577,
 1539820122,
 -1,
 1540316112,
 1540173200,
 43308,
 -1,
 1540229252,
 43309,
 -1,
 1540269250,
 43307,
 1540554751,
 1540209857,
 -1,
 -42029,
 1540471912,
 43311,
 -1,
 1540503071,
 43310,
 1540709697,
 1493653747,
 -1,
 1540775140,
 1540654225,
 -1,
 1540840510,
 1540732848,
 -1,
 1540906015,
 1540810448,
 -1,
 1540971503,
 1540857963,
 -1,
 1541037035,
 1540926205,
 -1,
 1541102568,
 1540951782,
 -1,
 1541168098,
 1541023387,
 -1,
 1541233631,
 1541133215,
 -1,
 -42018,
 1541190788,
 6649,
 -1,
 1541239555,
 6633,
 1541472255,
 1541162308,
 -1,
 -42015,
 1541387396,
 6648,
 -1,
 1541436163,
 6632,
 1541626853,
 1541121070,
 -1,
 -42012,
 1541584004,
 6647,
 -1,
 1541632771,
 6631,
 1541865471,
 1541572802,
 -1,
 -42009,
 1541780612,
 6646,
 -1,
 1541829379,
 6630,
 1542062079,
 1541013504,
 -1,
 -42006,
 1541977220,
 6645,
 -1,
 1542025987,
 6629,
 1542216686,
 1540974086,
 -1,
 -42003,
 1542173828,
 6642,
 -1,
 1542222595,
 6626,
 -1,
 1542137073,
 6624,
 1542478853,
 1540896525,
 -1,
 1542544386,
 1542393574,
 -1,
 1542609912,
 1542496363,
 -1,
 1542675445,
 1542564609,
 -1,
 -41996,
 1542632580,
 6655,
 -1,
 1542681347,
 6639,
 1542914047,
 1542612486,
 -1,
 -41993,
 1542829188,
 6652,
 -1,
 1542877955,
 6636,
 1543068671,
 1542530715,
 -1,
 1543134204,
 1543033759,
 -1,
 -41989,
 1543091332,
 6654,
 -1,
 1543140099,
 6638,
 1543372799,
 1543062852,
 -1,
 -41986,
 1543287940,
 6653,
 -1,
 1543336707,
 6637,
 1543569407,
 1543014594,
 -1,
 -41983,
 1543484548,
 6651,
 -1,
 1543533315,
 6635,
 1543766015,
 1542455296,
 -1,
 -41980,
 1543681156,
 6650,
 -1,
 1543729923,
 6634,
 1543920660,
 1542420793,
 -1,
 1543986191,
 1543872619,
 -1,
 1544051726,
 1543940861,
 6133,
 1544159231,
 1543966438,
 -1,
 1544182796,
 1544038043,
 -1,
 -41973,
 1544147867,
 6137,
 -1,
 1544176961,
 6136,
 -41971,
 1544135722,
 6135,
 -1,
 1544325309,
 6134,
 -1,
 1543988739,
 6130,
 1544576018,
 1543906971,
 -1,
 -41967,
 1544541083,
 6132,
 -1,
 1544570177,
 6131,
 -41965,
 1544535894,
 6128,
 -1,
 1544718525,
 6129,
 1544903707,
 1543841435,
 -1,
 1544969240,
 1544868767,
 -1,
 -41961,
 1544926340,
 6644,
 -1,
 1544975107,
 6628,
 1545207807,
 1544897860,
 -1,
 -41958,
 1545122948,
 6643,
 -1,
 1545171715,
 6627,
 1545362462,
 1544849602,
 -1,
 -41955,
 1545319556,
 6641,
 -1,
 1545368323,
 6625,
 -1,
 1545326039,
 6640,
 1545666559,
 1540842993,
 -1,
 1545690150,
 1545545371,
 -1,
 1545755685,
 1545606542,
 -1,
 -41949,
 1545717502,
 6099,
 -41948,
 1545778090,
 6101,
 -1,
 1545834578,
 6091,
 -1,
 1545686667,
 6104,
 1546083370,
 1545629942,
 -1,
 -41944,
 1546032932,
 6106,
 -41943,
 1546082945,
 6100,
 -1,
 1546131944,
 6094,
 1546345518,
 1545999758,
 -1,
 -41940,
 1546311813,
 6108,
 -41939,
 1546374410,
 6109,
 -1,
 1546412366,
 6095,
 1546607665,
 1546306424,
 -1,
 -41936,
 1546564118,
 6090,
 -1,
 1546621514,
 6093,
 1546804276,
 1546562006,
 -1,
 -41933,
 1546752601,
 6092,
 -1,
 1546797385,
 6087,
 1547000887,
 1546726659,
 -1,
 -41930,
 1546949443,
 6098,
 -1,
 1546984724,
 6102,
 -41928,
 1546971080,
 6088,
 -41927,
 1547164828,
 6097,
 -41926,
 1547221125,
 6096,
 -41925,
 1547281389,
 6105,
 -41924,
 1547341079,
 6086,
 -41923,
 1547405574,
 6089,
 -1,
 1547467076,
 6103,
 1547656303,
 1540782658,
 -1,
 1547721800,
 1547617144,
 -1,
 1547787331,
 1547683507,
 -1,
 -41918,
 1547735538,
 6029,
 -1,
 1547769230,
 6027,
 1547983942,
 1547720947,
 -1,
 -41915,
 1547932146,
 6034,
 -1,
 1547965838,
 6032,
 -41913,
 1547932146,
 6033,
 -1,
 1548096910,
 6031,
 1548311629,
 1547667778,
 -1,
 -41910,
 1548281604,
 6025,
 -41909,
 1548325362,
 6035,
 -41908,
 1548389873,
 6030,
 -1,
 1548441221,
 6020,
 1548639315,
 1548251382,
 -1,
 1548704849,
 1548572915,
 -1,
 -41904,
 1548653042,
 6019,
 -1,
 1548686734,
 6017,
 -41902,
 1548653042,
 6018,
 -1,
 1548817806,
 6016,
 1549032537,
 1548561667,
 -1,
 1549098071,
 1548966131,
 -1,
 -41898,
 1549046258,
 6024,
 -1,
 1549079950,
 6022,
 -41896,
 1549046258,
 6023,
 -1,
 1549211022,
 6021,
 1549425757,
 1548990384,
 -1,
 -41893,
 1549385490,
 6046,
 -41892,
 1549424913,
 6045,
 -1,
 1549473166,
 6047,
 1549687906,
 1549377643,
 -1,
 1549753441,
 1549621491,
 -1,
 -41888,
 1549701618,
 6039,
 -1,
 1549735310,
 6037,
 -1,
 1549701618,
 6038,
 1550015589,
 1549628356,
 -1,
 -41884,
 1549963762,
 6043,
 -1,
 1549997454,
 6049,
 1550212200,
 1549940268,
 -1,
 -41881,
 1550160370,
 6028,
 -1,
 1550194062,
 6026,
 -41879,
 1550182148,
 6041,
 -41878,
 1550376158,
 6044,
 -41877,
 1550431333,
 6042,
 -41876,
 1550493644,
 6050,
 -41875,
 1550550679,
 6040,
 -41874,
 1550604561,
 6048,
 -1,
 1550657229,
 6036,
 1550867617,
 1547578627,
 -1,
 1550933152,
 1550816993,
 -1,
 1550998650,
 1550893944,
 -1,
 1551064181,
 1550960307,
 -1,
 -41868,
 1551012338,
 983916,
 -1,
 1551046030,
 983914,
 1551260792,
 1550997747,
 -1,
 -41865,
 1551208946,
 983921,
 -1,
 1551242638,
 983919,
 -41863,
 1551208946,
 983920,
 -1,
 1551373710,
 983918,
 1551588479,
 1550944578,
 -1,
 -41860,
 1551558404,
 983912,
 -41859,
 1551602162,
 983922,
 -41858,
 1551652485,
 983907,
 -1,
 1551701390,
 983917,
 1551916165,
 1551528182,
 -1,
 1551981699,
 1551849715,
 -1,
 -41854,
 1551929842,
 983906,
 -1,
 1551963534,
 983904,
 -41852,
 1551929842,
 983905,
 -1,
 1552094606,
 983903,
 1552309387,
 1551838467,
 -1,
 1552374921,
 1552242931,
 -1,
 -41848,
 1552323058,
 983911,
 -1,
 1552356750,
 983909,
 -41846,
 1552323058,
 983910,
 -1,
 1552487822,
 983908,
 1552702607,
 1552267184,
 -1,
 -41843,
 1552660522,
 983933,
 -41842,
 1552701713,
 983932,
 -1,
 1552749966,
 983934,
 1552964756,
 1552654443,
 -1,
 1553030291,
 1552898291,
 -1,
 -41838,
 1552978418,
 983926,
 -1,
 1553012110,
 983924,
 -1,
 1552978418,
 983925,
 1553292439,
 1552905156,
 -1,
 -41834,
 1553240562,
 983930,
 -1,
 1553274254,
 983936,
 1553489050,
 1553217068,
 -1,
 -41831,
 1553437170,
 983915,
 -1,
 1553470862,
 983913,
 -41829,
 1553458948,
 983928,
 -41828,
 1553652958,
 983931,
 -41827,
 1553708133,
 983929,
 -41826,
 1553761943,
 983927,
 -41825,
 1553815825,
 983935,
 -1,
 1553868493,
 983923,
 -1,
 1550898923,
 6107,
 1554144443,
 1550835041,
 -1,
 1554209976,
 1554103489,
 -1,
 1554275497,
 1554126222,
 -1,
 1554341030,
 1554191758,
 6070,
 -1,
 1554284616,
 983943,
 -41817,
 1554304750,
 6085,
 -41816,
 1554407911,
 6083,
 -1,
 1554464935,
 6082,
 1554668716,
 1554244800,
 6073,
 -41813,
 1554638016,
 6074,
 -1,
 1554650510,
 6079,
 1554865327,
 1554632430,
 6075,
 -41810,
 1554829038,
 6076,
 -1,
 1554847118,
 6077,
 1555061939,
 1554813426,
 -1,
 -41807,
 1555010034,
 6084,
 -41806,
 1555071048,
 983942,
 -1,
 1555120295,
 6078,
 1555324086,
 1554997735,
 6071,
 -41803,
 1555259879,
 6072,
 -1,
 1555316903,
 6080,
 -41801,
 1555251367,
 6081,
 -1,
 1555444239,
 983937,
 1555693567,
 1554147713,
 -1,
 -41798,
 1555605446,
 6068,
 -1,
 1555633550,
 6069,
 1555848406,
 1554081887,
 -1,
 1555913932,
 1555802054,
 -1,
 1555979457,
 1555877614,
 6055,
 1556044992,
 1555943150,
 6057,
 -1,
 1556011110,
 6058,
 -1,
 1555984630,
 6056,
 1556241606,
 1555895694,
 -1,
 -41789,
 1556205294,
 6067,
 -41788,
 1556260806,
 6051,
 -41787,
 1556308455,
 6064,
 -1,
 1556354446,
 6052,
 1556569289,
 1556190995,
 -1,
 -41784,
 1556532742,
 6066,
 -1,
 1556583970,
 6065,
 1556765899,
 1556505063,
 6053,
 -1,
 1556701671,
 6054,
 -1,
 1556693159,
 6063,
 1556962514,
 1555872981,
 -1,
 1557028047,
 1556920198,
 983939,
 -1,
 1556997312,
 983940,
 1557200895,
 1556981702,
 -1,
 -41775,
 1557122798,
 983938,
 -1,
 1557151911,
 983941,
 1557355732,
 1556920198,
 6059,
 -1,
 1557324992,
 6060,
 1557528575,
 1557299227,
 6061,
 -1,
 1557456064,
 6062,
 1557659647,
 1555773860,
 -1,
 1557683418,
 1557578616,
 -1,
 -41767,
 1557652065,
 6114,
 -1,
 1557684414,
 6115,
 1557880029,
 1557641136,
 -1,
 -41764,
 1557819228,
 6118,
 -1,
 1557875887,
 6119,
 1558076640,
 1557810846,
 -1,
 -41761,
 1558027378,
 6116,
 -1,
 1558081253,
 6117,
 -41759,
 1558046831,
 6112,
 -41758,
 1558222370,
 6113,
 -41757,
 1558285599,
 6121,
 -1,
 1558332759,
 6120,
 1558577151,
 1540694598,
 -1,
 1558600980,
 1558477378,
 -1,
 1558666477,
 1558561656,
 -1,
 1558732011,
 1558627192,
 -1,
 -41751,
 1558693578,
 68147,
 -41750,
 1558731025,
 68123,
 -1,
 1558779278,
 68122,
 -41748,
 1558665489,
 68128,
 -1,
 1558910350,
 68127,
 1559125235,
 1558591020,
 -1,
 1559190769,
 1559049772,
 -1,
 -41744,
 1559124241,
 68125,
 -1,
 1559172494,
 68124,
 -41742,
 1559124241,
 68130,
 -1,
 1559303566,
 68129,
 1559518455,
 1559082928,
 -1,
 -41739,
 1559476266,
 68142,
 -41738,
 1559517457,
 68141,
 -1,
 1559565710,
 68143,
 1559780603,
 1559464258,
 -1,
 -41735,
 1559749884,
 68121,
 -41734,
 1559792030,
 68126,
 -1,
 1559827854,
 68131,
 1560042751,
 1559720182,
 -1,
 -41731,
 1559982349,
 68146,
 -41730,
 1560041745,
 68113,
 -1,
 1560089998,
 68112,
 1560304898,
 1559994475,
 -1,
 -41727,
 1560238353,
 68133,
 -1,
 1560286606,
 68132,
 1560501509,
 1560236843,
 -1,
 -41724,
 1560434961,
 68115,
 -1,
 1560483214,
 68114,
 1560698120,
 1560423683,
 -1,
 -41721,
 1560631569,
 68118,
 -1,
 1560679822,
 68117,
 1560894731,
 1560618651,
 -1,
 -41718,
 1560828177,
 68135,
 -1,
 1560876430,
 68134,
 -41716,
 1560864778,
 68144,
 -41715,
 1561060604,
 68137,
 -41714,
 1561122932,
 68140,
 -41713,
 1561176625,
 68138,
 -41712,
 1561231509,
 68136,
 -41711,
 1561293849,
 68139,
 -41710,
 1561358233,
 68119,
 -41709,
 1561418001,
 68145,
 -1,
 1561466254,
 68096,
 1561681186,
 1558554493,
 -1,
 1561746714,
 1561605676,
 -1,
 1561812249,
 1561694706,
 -1,
 -41704,
 1561776092,
 68183,
 -1,
 1561838456,
 68176,
 -1,
 1561730661,
 68182,
 1562074397,
 1561686980,
 -1,
 -41700,
 1562024878,
 68181,
 -1,
 1562077426,
 68184,
 1562271008,
 1561996547,
 -1,
 -41697,
 1562226062,
 68179,
 -1,
 1562274954,
 68178,
 -41695,
 1562230399,
 68177,
 -1,
 1562411644,
 68180,
 1562598700,
 1561647206,
 -1,
 1562664235,
 1562550194,
 -1,
 1562729770,
 1562623169,
 -1,
 -41690,
 1562696938,
 68099,
 -41689,
 1562758894,
 68098,
 -41688,
 1562808818,
 68102,
 -41687,
 1562862055,
 68097,
 -1,
 1562919079,
 68101,
 -1,
 1562671464,
 68108,
 -1,
 1562602624,
 68159,
 1563254068,
 1562557633,
 -1,
 1563319600,
 1563179728,
 -1,
 -41681,
 1563283453,
 68109,
 -1,
 1563345797,
 68154,
 -41679,
 1563286695,
 68111,
 -41678,
 1563438702,
 68153,
 -41677,
 1563502460,
 68152,
 -1,
 1563566012,
 68110,
 1563778363,
 1563201698,
 -1,
 1563843896,
 1563739000,
 -1,
 -41673,
 1563811633,
 68165,
 -1,
 1563838225,
 68164,
 1564082175,
 1563792934,
 -1,
 -41670,
 1564002241,
 68167,
 -1,
 1564041599,
 68166,
 1564278783,
 1563703716,
 -1,
 1564302655,
 1564197752,
 -1,
 -41666,
 1564271201,
 68161,
 -1,
 1564303550,
 68162,
 -41664,
 1564251682,
 68160,
 -1,
 1564430872,
 68163,
 1564630340,
 1540636839,
 -1,
 -41661,
 1564599686,
 9000,
 -1,
 1564639249,
 8490,
 -41659,
 1564580132,
 12927,
 -1,
 1564765231,
 8365,
 1564958743,
 1493620838,
 -1,
 1565024164,
 1564874126,
 -1,
 1565089443,
 1564959209,
 -1,
 1565154962,
 1565049580,
 -1,
 1565220479,
 1565097091,
 -1,
 1565285758,
 1565165890,
 -1,
 1565351257,
 1565217579,
 42507,
 1565416790,
 1565283115,
 -1,
 1565482321,
 1565343911,
 42500,
 -41648,
 1565428034,
 42501,
 -1,
 1565474983,
 42271,
 1565678931,
 1565430258,
 42460,
 -1,
 1565626866,
 42384,
 -41644,
 1565642478,
 42421,
 -41643,
 1565745639,
 42308,
 -1,
 1565791630,
 42348,
 -41641,
 1565365648,
 42428,
 -41640,
 1565935377,
 42467,
 -1,
 1565990243,
 42315,
 1566203239,
 1565275692,
 -1,
 1566268770,
 1566151154,
 42450,
 1566334305,
 1566209729,
 -1,
 -41635,
 1566293855,
 42514,
 -41634,
 1566343317,
 42538,
 -41633,
 1566404877,
 42513,
 -41632,
 1566461703,
 42512,
 -1,
 1566522064,
 42539,
 -1,
 1566282226,
 42374,
 1566793060,
 1566195879,
 42490,
 -1,
 1566720167,
 42261,
 -41627,
 1566756590,
 42411,
 -41626,
 1566859751,
 42298,
 -1,
 1566905742,
 42337,
 1567120751,
 1566172352,
 -1,
 1567186282,
 1567068658,
 42464,
 -1,
 1567134194,
 42388,
 1567317356,
 1567113383,
 42506,
 -1,
 1567244455,
 42275,
 -41619,
 1567280878,
 42425,
 -41618,
 1567384039,
 42312,
 -1,
 1567430030,
 42352,
 1567645047,
 1567059863,
 -1,
 1567710578,
 1567592946,
 42457,
 -1,
 1567658482,
 42381,
 1567841652,
 1567637671,
 42497,
 -1,
 1567768743,
 42268,
 -41611,
 1567805166,
 42418,
 -41610,
 1567908327,
 42305,
 -1,
 1567954318,
 42344,
 1568169337,
 1567592946,
 42463,
 -1,
 1568117234,
 42387,
 1568300411,
 1568096423,
 42505,
 -1,
 1568227495,
 42274,
 -41604,
 1568263918,
 42424,
 -41603,
 1568367079,
 42311,
 -1,
 1568413070,
 42351,
 1568628118,
 1565229128,
 -1,
 1568693639,
 1568560226,
 -1,
 1568759170,
 1568641522,
 42438,
 -1,
 1568707058,
 42363,
 1568890244,
 1568686247,
 42478,
 -1,
 1568817319,
 42250,
 -41595,
 1568853742,
 42400,
 -41594,
 1568956903,
 42287,
 -1,
 1569002894,
 42326,
 1569217935,
 1568614043,
 -1,
 1569283466,
 1569165810,
 42436,
 -1,
 1569231346,
 42361,
 1569414540,
 1569210535,
 42475,
 -1,
 1569341607,
 42248,
 -41587,
 1569378030,
 42398,
 -41586,
 1569481191,
 42285,
 -1,
 1569527182,
 42323,
 1569742225,
 1569165810,
 42462,
 -1,
 1569690098,
 42386,
 1569873299,
 1569669287,
 42504,
 -1,
 1569800359,
 42273,
 -41580,
 1569836782,
 42423,
 -41579,
 1569939943,
 42310,
 -1,
 1569985934,
 42350,
 1570201006,
 1568552492,
 -1,
 1570266535,
 1570134259,
 -1,
 1570332064,
 1570199795,
 -1,
 1570397595,
 1570279922,
 42446,
 -1,
 1570345458,
 42370,
 1570528669,
 1570324647,
 42486,
 -1,
 1570455719,
 42257,
 -41570,
 1570492142,
 42407,
 -41569,
 1570595303,
 42294,
 -1,
 1570641294,
 42333,
 1570856354,
 1570279922,
 42445,
 -1,
 1570804210,
 42369,
 1570987428,
 1570783399,
 42485,
 -1,
 1570914471,
 42256,
 -41563,
 1570950894,
 42406,
 -41562,
 1571054055,
 42293,
 -1,
 1571100046,
 42332,
 1571315113,
 1570214386,
 42449,
 -1,
 1571262962,
 42373,
 1571446187,
 1571242151,
 42489,
 -1,
 1571373223,
 42260,
 -41556,
 1571409646,
 42410,
 -41555,
 1571512807,
 42297,
 -1,
 1571558798,
 42336,
 1571773889,
 1570140406,
 -1,
 1571839417,
 1571725419,
 -1,
 1571904947,
 1571766439,
 42476,
 -41550,
 1571850562,
 42477,
 -1,
 1571897511,
 42249,
 1572101557,
 1571852786,
 42437,
 -1,
 1572049394,
 42362,
 1572232631,
 1572017550,
 42324,
 -1,
 1572178242,
 42325,
 -41544,
 1572196078,
 42399,
 -1,
 1572299239,
 42286,
 1572494779,
 1571787250,
 42459,
 -1,
 1572442610,
 42383,
 1572625853,
 1572421799,
 42499,
 -1,
 1572552871,
 42270,
 1572756927,
 1572541838,
 42346,
 -1,
 1572702530,
 42347,
 -41536,
 1572720366,
 42420,
 -1,
 1572823527,
 42307,
 1573019092,
 1571705643,
 -1,
 1573084620,
 1572939419,
 -1,
 1573150150,
 1573032434,
 42439,
 -41531,
 1573097970,
 42364,
 -1,
 1573161282,
 42440,
 1573346761,
 1573077159,
 42479,
 -41528,
 1573292354,
 42480,
 -1,
 1573339303,
 42251,
 -41526,
 1573310190,
 42401,
 -41525,
 1573478887,
 42288,
 -1,
 1573524878,
 42327,
 1573739983,
 1573011623,
 42502,
 -41522,
 1573685570,
 42503,
 -1,
 1573732519,
 42272,
 1573936593,
 1573687794,
 42461,
 -1,
 1573884402,
 42385,
 -41518,
 1573900014,
 42422,
 -41517,
 1574003175,
 42309,
 -1,
 1574049166,
 42349,
 1574264292,
 1572988920,
 -1,
 1574329821,
 1574197491,
 -1,
 1574395352,
 1574277618,
 42454,
 -1,
 1574343154,
 42378,
 1574526426,
 1574322343,
 42494,
 -1,
 1574453415,
 42265,
 -41509,
 1574489838,
 42415,
 -41508,
 1574592999,
 42302,
 -1,
 1574638990,
 42341,
 1574854111,
 1574277618,
 42453,
 -1,
 1574801906,
 42377,
 1574985185,
 1574781095,
 42493,
 -1,
 1574912167,
 42264,
 -41502,
 1574948590,
 42414,
 -41501,
 1575051751,
 42301,
 -1,
 1575097742,
 42340,
 1575312883,
 1574231514,
 -1,
 1575378409,
 1575260658,
 42431,
 1575443944,
 1575326194,
 42356,
 -1,
 1575389506,
 42357,
 -1,
 1575389506,
 42432,
 1575640557,
 1575305383,
 42470,
 1575706092,
 1575567527,
 42243,
 -1,
 1575651650,
 42244,
 -1,
 1575651650,
 42471,
 1575902703,
 1575603950,
 42393,
 -1,
 1575848258,
 42394,
 1576033777,
 1575838183,
 42280,
 -1,
 1575979330,
 42281,
 1576206335,
 1575949710,
 42318,
 -1,
 1576110402,
 42319,
 1576295939,
 1575273336,
 -1,
 1576361468,
 1576229107,
 -1,
 1576426999,
 1576309234,
 42444,
 -1,
 1576374770,
 42368,
 1576558073,
 1576353959,
 42484,
 -1,
 1576485031,
 42255,
 -41478,
 1576521454,
 42405,
 -41477,
 1576624615,
 42292,
 -1,
 1576670606,
 42331,
 1576885758,
 1576309234,
 42443,
 -1,
 1576833522,
 42367,
 1577016832,
 1576812711,
 42483,
 -1,
 1576943783,
 42254,
 -41471,
 1576980206,
 42404,
 -41470,
 1577083367,
 42291,
 -1,
 1577129358,
 42330,
 1577344531,
 1576253360,
 -1,
 1577410060,
 1577277683,
 -1,
 1577475591,
 1577357810,
 42452,
 -1,
 1577423346,
 42376,
 1577606665,
 1577402535,
 42492,
 -1,
 1577533607,
 42263,
 -41462,
 1577570030,
 42413,
 -41461,
 1577673191,
 42300,
 -1,
 1577719182,
 42339,
 1577934350,
 1577357810,
 42451,
 -1,
 1577882098,
 42375,
 1578065424,
 1577861287,
 42491,
 -1,
 1577992359,
 42262,
 -41455,
 1578028782,
 42412,
 -41454,
 1578131943,
 42299,
 -1,
 1578177934,
 42338,
 1578393123,
 1577264795,
 -1,
 1578458652,
 1578326259,
 -1,
 1578524183,
 1578406386,
 42434,
 -1,
 1578471922,
 42359,
 1578655257,
 1578451111,
 42473,
 -1,
 1578582183,
 42246,
 -41446,
 1578618606,
 42396,
 -41445,
 1578721767,
 42283,
 -1,
 1578767758,
 42321,
 1578982942,
 1578406386,
 42435,
 -1,
 1578930674,
 42360,
 1579114016,
 1578909863,
 42474,
 -1,
 1579040935,
 42247,
 -41439,
 1579077358,
 42397,
 -41438,
 1579180519,
 42284,
 -1,
 1579226510,
 42322,
 1579441712,
 1578326259,
 -1,
 1579507239,
 1579389426,
 42429,
 -41434,
 1579454962,
 42355,
 -1,
 1579518274,
 42430,
 1579703850,
 1579434151,
 42468,
 -41431,
 1579649346,
 42469,
 -1,
 1579696295,
 42242,
 1579900460,
 1579667182,
 42391,
 -1,
 1579845954,
 42392,
 1580031534,
 1579835879,
 42278,
 -1,
 1579977026,
 42279,
 1580204031,
 1579947406,
 42316,
 -1,
 1580108098,
 42317,
 1580293689,
 1579381700,
 -1,
 1580359220,
 1580220583,
 42487,
 -41421,
 1580305597,
 42508,
 -1,
 1580351655,
 42258,
 1580555830,
 1580306930,
 42447,
 -1,
 1580503538,
 42371,
 -41417,
 1580519150,
 42408,
 -41416,
 1580622311,
 42295,
 -1,
 1580668302,
 42334,
 1580883521,
 1580262592,
 -1,
 1580949052,
 1580831218,
 42458,
 -1,
 1580896754,
 42382,
 1581080126,
 1580875943,
 42498,
 -1,
 1581007015,
 42269,
 -41409,
 1581043438,
 42419,
 -41408,
 1581146599,
 42306,
 -1,
 1581192590,
 42345,
 1581407817,
 1580849254,
 -1,
 1581473348,
 1581355506,
 42442,
 -1,
 1581421042,
 42366,
 1581604422,
 1581400231,
 42482,
 -1,
 1581531303,
 42253,
 -41401,
 1581567726,
 42403,
 -41400,
 1581670887,
 42290,
 -1,
 1581716878,
 42329,
 1581932113,
 1581361622,
 -1,
 1581997644,
 1581879794,
 42448,
 -1,
 1581945330,
 42372,
 1582128718,
 1581924519,
 42488,
 -1,
 1582055591,
 42259,
 -41393,
 1582092014,
 42409,
 -41392,
 1582195175,
 42296,
 -1,
 1582241166,
 42335,
 1582456409,
 1581883499,
 -1,
 1582521940,
 1582404082,
 42433,
 -1,
 1582469618,
 42358,
 1582653014,
 1582448807,
 42472,
 -1,
 1582579879,
 42245,
 -41385,
 1582616302,
 42395,
 -41384,
 1582719463,
 42282,
 -1,
 1582765454,
 42320,
 1582980705,
 1582395287,
 -1,
 1583046236,
 1582928370,
 42456,
 -1,
 1582993906,
 42380,
 1583177310,
 1582973095,
 42496,
 -1,
 1583104167,
 42267,
 -41377,
 1583140590,
 42417,
 -41376,
 1583243751,
 42304,
 -1,
 1583289742,
 42343,
 1583505001,
 1582911134,
 -1,
 1583570532,
 1583452658,
 42441,
 -1,
 1583518194,
 42365,
 1583701606,
 1583497383,
 42481,
 -1,
 1583628455,
 42252,
 -41369,
 1583664878,
 42402,
 -41368,
 1583768039,
 42289,
 -1,
 1583814030,
 42328,
 1584029297,
 1583426819,
 -1,
 1584094828,
 1583976946,
 42455,
 -1,
 1584042482,
 42379,
 1584225902,
 1584021671,
 42495,
 -1,
 1584152743,
 42266,
 -41361,
 1584189166,
 42416,
 -41360,
 1584292327,
 42303,
 -1,
 1584338318,
 42342,
 1584553589,
 1583976946,
 42426,
 1584619124,
 1584501234,
 42353,
 -1,
 1584564546,
 42354,
 -1,
 1584564546,
 42427,
 1584815737,
 1584480423,
 42465,
 1584881272,
 1584742567,
 42240,
 -1,
 1584826690,
 42241,
 -1,
 1584826690,
 42466,
 1585077883,
 1584778990,
 42389,
 -1,
 1585023298,
 42390,
 1585208957,
 1585013223,
 42276,
 -1,
 1585154370,
 42277,
 1585381375,
 1585124750,
 42313,
 -1,
 1585285442,
 42314,
 1585512447,
 1565164377,
 -1,
 1585536644,
 1585431416,
 -1,
 -41342,
 1585485430,
 42525,
 -41341,
 1585539343,
 42517,
 -1,
 1585583633,
 42521,
 1585798793,
 1585460780,
 -1,
 1585864328,
 1585746418,
 -1,
 -41337,
 1585813110,
 42523,
 -1,
 1585844383,
 42526,
 -1,
 1585782405,
 42522,
 1586126476,
 1585737974,
 -1,
 -41333,
 1586090773,
 42524,
 -1,
 1586119546,
 42516,
 1586323087,
 1586056862,
 -1,
 -41330,
 1586250618,
 42515,
 -1,
 1586304529,
 42520,
 -41328,
 1586269459,
 42518,
 -41327,
 1586458791,
 42527,
 -1,
 1586505563,
 42519,
 1586716320,
 1565079972,
 -1,
 1586781846,
 1586676600,
 -1,
 -41323,
 1586750049,
 42530,
 -1,
 1586782398,
 42531,
 1586978457,
 1586739120,
 -1,
 -41320,
 1586917212,
 42534,
 -1,
 1586973871,
 42535,
 1587175068,
 1586908830,
 -1,
 -41317,
 1587125362,
 42532,
 -1,
 1587179237,
 42533,
 -41315,
 1587144815,
 42528,
 -41314,
 1587320354,
 42529,
 -41313,
 1587383583,
 42537,
 -1,
 1587430743,
 42536,
 -41311,
 1586669888,
 42511,
 -41310,
 1587565322,
 42510,
 -1,
 1587622460,
 42509,
 1587871743,
 1565044428,
 -1,
 1587896083,
 1587745321,
 65024,
 1587961520,
 1587811675,
 917762,
 -41305,
 1587877211,
 917942,
 -41304,
 1587942695,
 917941,
 -41303,
 1588008160,
 917940,
 -41302,
 1588073627,
 917939,
 -41301,
 1588139043,
 917938,
 -41300,
 1588204502,
 917937,
 -41299,
 1588269926,
 917936,
 -41298,
 1588335297,
 917935,
 -41297,
 1588400681,
 917934,
 -1,
 1588466089,
 917933,
 1588682427,
 1587877159,
 917761,
 -41294,
 1588598107,
 917932,
 -41293,
 1588663591,
 917931,
 -41292,
 1588729056,
 917930,
 -41291,
 1588794523,
 917929,
 -41290,
 1588859939,
 917928,
 -41289,
 1588925398,
 917927,
 -41288,
 1588990822,
 917926,
 -41287,
 1589056193,
 917925,
 -41286,
 1589121577,
 917924,
 -1,
 1589186985,
 917923,
 1589403334,
 1588597984,
 917760,
 -41283,
 1589319003,
 917922,
 -41282,
 1589384487,
 917921,
 -41281,
 1589449952,
 917920,
 -41280,
 1589515419,
 917919,
 -41279,
 1589580835,
 917918,
 -41278,
 1589646294,
 917917,
 -41277,
 1589711718,
 917916,
 -41276,
 1589777089,
 917915,
 -41275,
 1589842473,
 917914,
 -1,
 1589907881,
 917913,
 1590124241,
 1589318811,
 65039,
 -41272,
 1590039899,
 917912,
 -41271,
 1590105383,
 917911,
 -41270,
 1590170848,
 917910,
 -41269,
 1590236315,
 917909,
 -41268,
 1590301731,
 917908,
 -41267,
 1590367190,
 917907,
 -41266,
 1590432614,
 917906,
 -41265,
 1590497985,
 917905,
 -41264,
 1590563369,
 917904,
 -1,
 1590628777,
 917903,
 1590845148,
 1590039587,
 65038,
 -41261,
 1590760795,
 917902,
 -41260,
 1590826279,
 917901,
 -41259,
 1590891744,
 917900,
 -41258,
 1590957211,
 917899,
 -41257,
 1591022627,
 917898,
 -41256,
 1591088086,
 917897,
 -41255,
 1591153510,
 917896,
 -41254,
 1591218881,
 917895,
 -41253,
 1591284265,
 917894,
 -1,
 1591349673,
 917893,
 1591566055,
 1590760406,
 65037,
 -41250,
 1591481691,
 917892,
 -41249,
 1591547175,
 917891,
 -41248,
 1591612640,
 917890,
 -41247,
 1591678107,
 917889,
 -41246,
 1591743523,
 917888,
 -41245,
 1591808982,
 917887,
 -41244,
 1591874406,
 917886,
 -41243,
 1591939777,
 917885,
 -41242,
 1592005161,
 917884,
 -1,
 1592070569,
 917883,
 1592286962,
 1591481190,
 65036,
 -41239,
 1592202587,
 917882,
 -41238,
 1592268071,
 917881,
 -41237,
 1592333536,
 917880,
 -41236,
 1592399003,
 917879,
 -41235,
 1592464419,
 917878,
 -41234,
 1592529878,
 917877,
 -41233,
 1592595302,
 917876,
 -41232,
 1592660673,
 917875,
 -41231,
 1592726057,
 917874,
 -1,
 1592791465,
 917873,
 1593007869,
 1592201921,
 65035,
 -41228,
 1592923483,
 917872,
 -41227,
 1592988967,
 917871,
 -41226,
 1593054432,
 917870,
 -41225,
 1593119899,
 917869,
 -41224,
 1593185315,
 917868,
 -41223,
 1593250774,
 917867,
 -41222,
 1593316198,
 917866,
 -41221,
 1593381569,
 917865,
 -41220,
 1593446953,
 917864,
 -1,
 1593512361,
 917863,
 1593728776,
 1592922665,
 65034,
 -41217,
 1593644379,
 917862,
 -41216,
 1593709863,
 917861,
 -41215,
 1593775328,
 917860,
 -41214,
 1593840795,
 917859,
 -41213,
 1593906211,
 917858,
 -41212,
 1593971670,
 917857,
 -41211,
 1594037094,
 917856,
 -41210,
 1594102465,
 917855,
 -41209,
 1594167849,
 917854,
 -1,
 1594233257,
 917853,
 1594490879,
 1593643433,
 65033,
 -41206,
 1594365275,
 917852,
 -41205,
 1594430759,
 917851,
 -41204,
 1594496224,
 917850,
 -41203,
 1594561691,
 917849,
 -41202,
 1594627107,
 917848,
 -41201,
 1594692566,
 917847,
 -41200,
 1594757990,
 917846,
 -41199,
 1594823361,
 917845,
 -41198,
 1594888745,
 917844,
 -1,
 1594954153,
 917843,
 1595170647,
 1587811009,
 65025,
 1595236127,
 1595085782,
 917767,
 -41194,
 1595151707,
 917992,
 -41193,
 1595217191,
 917991,
 -41192,
 1595282656,
 917990,
 -41191,
 1595348123,
 917989,
 -41190,
 1595413539,
 917988,
 -41189,
 1595478998,
 917987,
 -41188,
 1595544422,
 917986,
 -41187,
 1595609793,
 917985,
 -41186,
 1595675177,
 917984,
 -1,
 1595740585,
 917983,
 1595957034,
 1595151206,
 917766,
 -41183,
 1595872603,
 917982,
 -41182,
 1595938087,
 917981,
 -41181,
 1596003552,
 917980,
 -41180,
 1596069019,
 917979,
 -41179,
 1596134435,
 917978,
 -41178,
 1596199894,
 917977,
 -41177,
 1596265318,
 917976,
 -41176,
 1596330689,
 917975,
 -41175,
 1596396073,
 917974,
 -1,
 1596461481,
 917973,
 1596677941,
 1595871937,
 917765,
 -41172,
 1596593499,
 917972,
 -41171,
 1596658983,
 917971,
 -41170,
 1596724448,
 917970,
 -41169,
 1596789915,
 917969,
 -41168,
 1596855331,
 917968,
 -41167,
 1596920790,
 917967,
 -41166,
 1596986214,
 917966,
 -41165,
 1597051585,
 917965,
 -41164,
 1597116969,
 917964,
 -1,
 1597182377,
 917963,
 1597398848,
 1596592681,
 917764,
 -41161,
 1597314395,
 917962,
 -41160,
 1597379879,
 917961,
 -41159,
 1597445344,
 917960,
 -41158,
 1597510811,
 917959,
 -41157,
 1597576227,
 917958,
 -41156,
 1597641686,
 917957,
 -41155,
 1597707110,
 917956,
 -41154,
 1597772481,
 917955,
 -41153,
 1597837865,
 917954,
 -1,
 1597903273,
 917953,
 1598119755,
 1597313449,
 917763,
 -41150,
 1598035291,
 917952,
 -41149,
 1598100775,
 917951,
 -41148,
 1598166240,
 917950,
 -41147,
 1598231707,
 917949,
 -41146,
 1598297123,
 917948,
 -41145,
 1598362582,
 917947,
 -41144,
 1598428006,
 917946,
 -41143,
 1598493377,
 917945,
 -41142,
 1598558761,
 917944,
 -1,
 1598624169,
 917943,
 1598840659,
 1598034979,
 917768,
 -41139,
 1598755995,
 917999,
 -41138,
 1598821411,
 917998,
 -41137,
 1598886870,
 917997,
 -41136,
 1598952294,
 917996,
 -41135,
 1599017665,
 917995,
 -41134,
 1599083049,
 917994,
 -1,
 1599148457,
 917993,
 -41132,
 1598756187,
 917772,
 -41131,
 1599280423,
 917771,
 -41130,
 1599345888,
 917770,
 -1,
 1599411355,
 917769,
 1599627106,
 1595086171,
 65032,
 -41127,
 1599542619,
 917842,
 -41126,
 1599608103,
 917841,
 -41125,
 1599673568,
 917840,
 -41124,
 1599739035,
 917839,
 -41123,
 1599804451,
 917838,
 -41122,
 1599869910,
 917837,
 -41121,
 1599935334,
 917836,
 -41120,
 1600000705,
 917835,
 -41119,
 1600066089,
 917834,
 -1,
 1600131497,
 917833,
 1600348013,
 1599542567,
 65031,
 -41116,
 1600263515,
 917832,
 -41115,
 1600328999,
 917831,
 -41114,
 1600394464,
 917830,
 -41113,
 1600459931,
 917829,
 -41112,
 1600525347,
 917828,
 -41111,
 1600590806,
 917827,
 -41110,
 1600656230,
 917826,
 -41109,
 1600721601,
 917825,
 -41108,
 1600786985,
 917824,
 -1,
 1600852393,
 917823,
 1601068920,
 1600263392,
 65030,
 -41105,
 1600984411,
 917822,
 -41104,
 1601049895,
 917821,
 -41103,
 1601115360,
 917820,
 -41102,
 1601180827,
 917819,
 -41101,
 1601246243,
 917818,
 -41100,
 1601311702,
 917817,
 -41099,
 1601377126,
 917816,
 -41098,
 1601442497,
 917815,
 -41097,
 1601507881,
 917814,
 -1,
 1601573289,
 917813,
 1601789827,
 1600984219,
 65029,
 -41094,
 1601705307,
 917812,
 -41093,
 1601770791,
 917811,
 -41092,
 1601836256,
 917810,
 -41091,
 1601901723,
 917809,
 -41090,
 1601967139,
 917808,
 -41089,
 1602032598,
 917807,
 -41088,
 1602098022,
 917806,
 -41087,
 1602163393,
 917805,
 -41086,
 1602228777,
 917804,
 -1,
 1602294185,
 917803,
 1602510734,
 1601704995,
 65028,
 -41083,
 1602426203,
 917802,
 -41082,
 1602491687,
 917801,
 -41081,
 1602557152,
 917800,
 -41080,
 1602622619,
 917799,
 -41079,
 1602688035,
 917798,
 -41078,
 1602753494,
 917797,
 -41077,
 1602818918,
 917796,
 -41076,
 1602884289,
 917795,
 -41075,
 1602949673,
 917794,
 -1,
 1603015081,
 917793,
 1603231641,
 1602425814,
 65027,
 -41072,
 1603147099,
 917792,
 -41071,
 1603212583,
 917791,
 -41070,
 1603278048,
 917790,
 -41069,
 1603343515,
 917789,
 -41068,
 1603408931,
 917788,
 -41067,
 1603474390,
 917787,
 -41066,
 1603539814,
 917786,
 -41065,
 1603605185,
 917785,
 -41064,
 1603670569,
 917784,
 -1,
 1603735977,
 917783,
 1603993599,
 1603146598,
 65026,
 -41061,
 1603867995,
 917782,
 -41060,
 1603933479,
 917781,
 -41059,
 1603998944,
 917780,
 -41058,
 1604064411,
 917779,
 -41057,
 1604129827,
 917778,
 -41056,
 1604195286,
 917777,
 -41055,
 1604260710,
 917776,
 -41054,
 1604326081,
 917775,
 -41053,
 1604391465,
 917774,
 -1,
 1604456873,
 917773,
 1604673526,
 1564950695,
 -1,
 1604739028,
 1604598122,
 -1,
 1604804543,
 1604697281,
 -1,
 1604870063,
 1604720014,
 -1,
 1604935598,
 1604817200,
 -1,
 1605001131,
 1604901039,
 7403,
 -1,
 1604914815,
 7404,
 -41044,
 1604964258,
 7409,
 -41043,
 1605052181,
 7402,
 -1,
 1605115777,
 7401,
 -1,
 1604889586,
 7410,
 1605394357,
 1604836527,
 -1,
 1605459890,
 1605357735,
 7395,
 -1,
 1605373567,
 7399,
 1605590964,
 1605377971,
 7397,
 -1,
 1605504639,
 7400,
 -1,
 1605550802,
 7394,
 1605787578,
 1605347798,
 -1,
 1605853113,
 1605717364,
 -1,
 -41032,
 1605816487,
 7396,
 -1,
 1605836723,
 7398,
 -1,
 1605814023,
 7408,
 -41029,
 1605756187,
 7380,
 -41028,
 1606076824,
 7405,
 -41027,
 1606126857,
 7379,
 -41026,
 1606188427,
 7407,
 -1,
 1606245590,
 7406,
 1606483967,
 1604766298,
 -1,
 1606508485,
 1606411535,
 -1,
 1606574019,
 1606447564,
 7383,
 -1,
 1606486544,
 7385,
 -41020,
 1606510667,
 7382,
 -1,
 1606621405,
 7381,
 1606836169,
 1606468472,
 -1,
 -41017,
 1606804104,
 7390,
 -41016,
 1606857453,
 7387,
 -1,
 1606902047,
 7391,
 1607098316,
 1606775053,
 -1,
 -41013,
 1607059150,
 7388,
 -1,
 1607120512,
 7376,
 1607294927,
 1607023312,
 -1,
 -41010,
 1607258125,
 7386,
 -1,
 1607320453,
 7389,
 -41008,
 1607252804,
 7377,
 -41007,
 1607447020,
 7392,
 -41006,
 1607509698,
 7378,
 -41005,
 1607544268,
 7384,
 -1,
 1607607547,
 7393,
 1607819252,
 1604692438,
 -1,
 1607884784,
 1607780454,
 -1,
 1607950302,
 1607826261,
 124,
 1608056831,
 1607860224,
 -1,
 1608081373,
 1607983172,
 -1,
 1608146908,
 1608003688,
 -1,
 -40997,
 1608067192,
 10992,
 -1,
 1608128143,
 10991,
 -1,
 1608090947,
 9087,
 -1,
 1608011356,
 9168,
 1608474597,
 1607889230,
 -1,
 1608540131,
 1608417981,
 12337,
 1608646655,
 1608450048,
 -1,
 -40990,
 1608570139,
 12339,
 -1,
 1608613610,
 12341,
 1608843263,
 1608507887,
 12338,
 -1,
 1608715286,
 12340,
 1608933354,
 1608394615,
 -1,
 -40985,
 1608900869,
 10186,
 -40984,
 1608961065,
 10978,
 -40983,
 1608990016,
 10980,
 -1,
 1609050402,
 10704,
 -40981,
 1608902911,
 10650,
 -40980,
 1609222304,
 11823,
 -40979,
 1609269606,
 9896,
 -40978,
 1609327689,
 12347,
 -40977,
 1609388613,
 8286,
 -1,
 1609451036,
 8942,
 1609654259,
 1607853253,
 -1,
 -40974,
 1609595319,
 8920,
 -1,
 1609652063,
 8921,
 -1,
 1609612441,
 8483,
 -40971,
 1607778507,
 9910,
 -1,
 1609839961,
 10799,
 1610047506,
 1604637066,
 -1,
 1610113027,
 1609995814,
 -1,
 1610178555,
 1610072952,
 -1,
 -40966,
 1610112521,
 8531,
 -1,
 1610172454,
 8530,
 1610375166,
 1610135472,
 -1,
 -40963,
 1610313589,
 8537,
 -1,
 1610370297,
 8528,
 -40961,
 1610328279,
 188,
 -40960,
 1610517836,
 8529,
 -40959,
 1610570227,
 189,
 -40958,
 1610633300,
 8533,
 -1,
 1610696036,
 8539,
 1610899467,
 1610072952,
 -1,
 1610965000,
 1610834115,
 -1,
 -40954,
 1610918137,
 190,
 -40953,
 1610960986,
 8535,
 -1,
 1611023749,
 8540,
 1611268095,
 1610932836,
 -1,
 -40950,
 1611188094,
 8532,
 -1,
 1611223130,
 8534,
 1611423760,
 1610829470,
 -1,
 1611489295,
 1611362025,
 -1,
 -40946,
 1611447776,
 8538,
 -1,
 1611482501,
 8541,
 -1,
 1611439271,
 8536,
 -40943,
 1611393178,
 8585,
 -1,
 1611709034,
 8542,
 1611882518,
 1609982439,
 -1,
 -40940,
 1611837033,
 9805,
 -40939,
 1611877773,
 8983,
 -1,
 1611937135,
 9996,
 -1,
 1611830554,
 8752,
 1612210966,
 1564882476,
 -1,
 1612276045,
 1612157426,
 -1,
 1612341392,
 1612219907,
 -1,
 1612406869,
 1612307181,
 -1,
 1612472404,
 1612320488,
 -1,
 1612537892,
 1612387540,
 -1,
 -40930,
 1612453019,
 127123,
 -40929,
 1612518435,
 127122,
 -40928,
 1612583894,
 127121,
 -40927,
 1612649318,
 127120,
 -40926,
 1612714689,
 127119,
 -40925,
 1612780073,
 127118,
 -1,
 1612845481,
 127117,
 1613062188,
 1612452986,
 -1,
 -40922,
 1612977307,
 127116,
 -40921,
 1613042723,
 127115,
 -40920,
 1613108182,
 127114,
 -40919,
 1613173606,
 127113,
 -40918,
 1613238977,
 127112,
 -40917,
 1613304361,
 127111,
 -1,
 1613369769,
 127110,
 1613586484,
 1612977167,
 -1,
 -40914,
 1613501595,
 127109,
 -40913,
 1613567011,
 127108,
 -40912,
 1613632470,
 127107,
 -40911,
 1613697894,
 127106,
 -40910,
 1613763265,
 127105,
 -40909,
 1613828649,
 127104,
 -1,
 1613894057,
 127103,
 1614110780,
 1613501384,
 -1,
 -40906,
 1614025883,
 127102,
 -40905,
 1614091299,
 127101,
 -40904,
 1614156758,
 127100,
 -40903,
 1614222182,
 127099,
 -40902,
 1614287553,
 127098,
 -40901,
 1614352937,
 127097,
 -1,
 1614418345,
 127096,
 1614635076,
 1614025534,
 -1,
 -40898,
 1614550171,
 127095,
 -40897,
 1614615587,
 127094,
 -40896,
 1614681046,
 127093,
 -40895,
 1614746470,
 127092,
 -40894,
 1614811841,
 127091,
 -40893,
 1614877225,
 127090,
 -1,
 1614942633,
 127089,
 1615159372,
 1614549666,
 -1,
 -40890,
 1615074459,
 127088,
 -40889,
 1615139875,
 127087,
 -40888,
 1615205334,
 127086,
 -40887,
 1615270758,
 127085,
 -40886,
 1615336129,
 127084,
 -40885,
 1615401513,
 127083,
 -1,
 1615466921,
 127082,
 1615724543,
 1615073819,
 -1,
 -40882,
 1615598747,
 127081,
 -40881,
 1615664163,
 127080,
 -40880,
 1615729622,
 127079,
 -40879,
 1615795046,
 127078,
 -40878,
 1615860417,
 127077,
 -40877,
 1615925801,
 127076,
 -1,
 1615991209,
 127075,
 -1,
 1612382735,
 127074,
 1616314367,
 1612341045,
 -1,
 1616339087,
 1616187112,
 -1,
 1616404575,
 1616254164,
 -1,
 -40871,
 1616319643,
 127073,
 -40870,
 1616385059,
 127072,
 -40869,
 1616450518,
 127071,
 -40868,
 1616515942,
 127070,
 -40867,
 1616581313,
 127069,
 -40866,
 1616646697,
 127068,
 -1,
 1616712105,
 127067,
 1616928871,
 1616319610,
 -1,
 -40863,
 1616843931,
 127066,
 -40862,
 1616909347,
 127065,
 -40861,
 1616974806,
 127064,
 -40860,
 1617040230,
 127063,
 -40859,
 1617105601,
 127062,
 -40858,
 1617170985,
 127061,
 -1,
 1617236393,
 127060,
 1617453167,
 1616843791,
 -1,
 -40855,
 1617368219,
 127059,
 -40854,
 1617433635,
 127058,
 -40853,
 1617499094,
 127057,
 -40852,
 1617564518,
 127056,
 -40851,
 1617629889,
 127055,
 -40850,
 1617695273,
 127054,
 -1,
 1617760681,
 127053,
 1617977463,
 1617368008,
 -1,
 -40847,
 1617892507,
 127052,
 -40846,
 1617957923,
 127051,
 -40845,
 1618023382,
 127050,
 -40844,
 1618088806,
 127049,
 -40843,
 1618154177,
 127048,
 -40842,
 1618219561,
 127047,
 -1,
 1618284969,
 127046,
 1618501759,
 1617892158,
 -1,
 -40839,
 1618416795,
 127045,
 -40838,
 1618482211,
 127044,
 -40837,
 1618547670,
 127043,
 -40836,
 1618613094,
 127042,
 -40835,
 1618678465,
 127041,
 -40834,
 1618743849,
 127040,
 -1,
 1618809257,
 127039,
 1619026055,
 1618416290,
 -1,
 -40831,
 1618941083,
 127038,
 -40830,
 1619006499,
 127037,
 -40829,
 1619071958,
 127036,
 -40828,
 1619137382,
 127035,
 -40827,
 1619202753,
 127034,
 -40826,
 1619268137,
 127033,
 -1,
 1619333545,
 127032,
 1619591167,
 1618940443,
 -1,
 -40823,
 1619465371,
 127031,
 -40822,
 1619530787,
 127030,
 -40821,
 1619596246,
 127029,
 -40820,
 1619661670,
 127028,
 -40819,
 1619727041,
 127027,
 -40818,
 1619792425,
 127026,
 -1,
 1619857833,
 127025,
 -1,
 1616249359,
 127024,
 1620140284,
 1612304328,
 -1,
 1620205783,
 1620049920,
 -1,
 1620271267,
 1620126979,
 -1,
 1620336802,
 1620208808,
 -1,
 1620402337,
 1620261284,
 -1,
 1620467864,
 1620362104,
 -1,
 -40809,
 1620435553,
 9462,
 -1,
 1620467902,
 9463,
 1620664475,
 1620424624,
 -1,
 -40806,
 1620602716,
 9466,
 -1,
 1620659375,
 9467,
 1620861086,
 1620594334,
 -1,
 -40803,
 1620810866,
 9464,
 -1,
 1620864741,
 9465,
 -40801,
 1620809250,
 9461,
 -40800,
 1621003551,
 9469,
 -1,
 1621050711,
 9468,
 -1,
 1620349110,
 9470,
 -1,
 1620284681,
 10868,
 1621385389,
 1620228016,
 -1,
 1621450920,
 1621348078,
 -1,
 -40794,
 1621402472,
 8913,
 -40793,
 1621438090,
 10940,
 -1,
 1621503027,
 8912,
 1621713067,
 1621403815,
 -1,
 -40790,
 1621676835,
 10831,
 -1,
 1621715612,
 10830,
 -40788,
 1621675134,
 10988,
 -1,
 1621857485,
 11005,
 1622040758,
 1621324740,
 -1,
 1622106293,
 1621987826,
 -1,
 1622171826,
 1622072794,
 -1,
 -40783,
 1622085358,
 8222,
 -1,
 1622148523,
 8215,
 1622409215,
 1622103529,
 -1,
 -40780,
 1622317176,
 10836,
 -1,
 1622351244,
 10835,
 -1,
 1622033347,
 10645,
 1622630589,
 1622006518,
 -1,
 1622696124,
 1622550391,
 -1,
 1622761659,
 1622621295,
 -1,
 -40774,
 1622716620,
 8875,
 -1,
 1622767742,
 10981,
 -1,
 1622702206,
 10979,
 -1,
 1622637397,
 8214,
 1623089347,
 1622581355,
 -1,
 1623154882,
 1623042518,
 -1,
 1623220417,
 1623090942,
 8243,
 -1,
 1623132590,
 12318,
 -1,
 1623147078,
 10939,
 -1,
 1623097288,
 10746,
 1623482567,
 1623034883,
 -1,
 1623548102,
 1623423415,
 10913,
 -1,
 1623461569,
 10915,
 -1,
 1623480159,
 10914,
 1623744714,
 1623445230,
 -1,
 -40759,
 1623695558,
 10987,
 -1,
 1623756114,
 8915,
 1623941325,
 1623681574,
 -1,
 -40756,
 1623897719,
 8914,
 -1,
 1623938797,
 8748,
 1624137936,
 1623864876,
 -1,
 -40753,
 1624088625,
 10986,
 -1,
 1624119511,
 8225,
 -40751,
 1624104691,
 65100,
 -40750,
 1624289051,
 10646,
 -40749,
 1624353088,
 8263,
 -40748,
 1624412780,
 11799,
 -40747,
 1624464824,
 8223,
 -40746,
 1624526247,
 8252,
 -1,
 1624577996,
 733,
 1624793337,
 1620119270,
 -1,
 1624858862,
 1624752649,
 -1,
 1624924387,
 1624780290,
 -1,
 1624989916,
 1624875115,
 8473,
 -1,
 1624924647,
 8511,
 -40739,
 1624958968,
 8484,
 -40738,
 1625074134,
 8477,
 -40737,
 1625139142,
 8474,
 -40736,
 1625196866,
 8469,
 -40735,
 1625250035,
 8461,
 -40734,
 1625314245,
 8510,
 -1,
 1625369859,
 8450,
 1625579754,
 1624862222,
 -1,
 1625645289,
 1625538089,
 -1,
 -40730,
 1625583511,
 8521,
 -40729,
 1625645543,
 8520,
 -40728,
 1625702567,
 8519,
 -1,
 1625765420,
 8518,
 -1,
 1625566731,
 8517,
 1626038509,
 1625538089,
 -1,
 -40724,
 1625990152,
 8508,
 -1,
 1626035141,
 8509,
 -1,
 1625983357,
 8512,
 1626300664,
 1624800090,
 -1,
 1626366197,
 1626258944,
 -1,
 1626431731,
 1626294576,
 -1,
 -40718,
 1626372535,
 10907,
 -1,
 1626429279,
 10908,
 -40716,
 1626372622,
 11001,
 -1,
 1626560473,
 11002,
 1626800127,
 1626294576,
 -1,
 -40713,
 1626700215,
 10905,
 -1,
 1626756959,
 10906,
 -1,
 1626228632,
 10719,
 1627062271,
 1624716846,
 -1,
 -40709,
 1626964316,
 9891,
 -1,
 1627017171,
 9890,
 1627218222,
 1620107808,
 -1,
 1627283749,
 1627184684,
 -1,
 1627349260,
 1627198862,
 -1,
 1627414795,
 1627305539,
 8595,
 1627521023,
 1627324416,
 -1,
 1627545864,
 1627447364,
 -1,
 1627611397,
 1627507071,
 -1,
 -40700,
 1627566369,
 8627,
 -1,
 1627617451,
 8626,
 -40698,
 1627545566,
 10504,
 -40697,
 1627733430,
 8671,
 -1,
 1627796384,
 8629,
 -40695,
 1627507165,
 10515,
 -40694,
 1627945212,
 8693,
 -1,
 1628000919,
 8615,
 -1,
 1627359930,
 11796,
 1628266778,
 1627282219,
 -1,
 1628332309,
 1628206833,
 -1,
 1628397844,
 1628241920,
 -1,
 1628463378,
 1628317913,
 -1,
 -40687,
 1628427776,
 10607,
 -1,
 1628454793,
 10597,
 -40685,
 1628424669,
 10585,
 -1,
 1628590743,
 10593,
 -1,
 1628364326,
 8643,
 1628897279,
 1628286702,
 -1,
 1628922137,
 1628766208,
 -1,
 -40680,
 1628883421,
 10581,
 -1,
 1628918423,
 10589,
 -1,
 1628888614,
 8642,
 1629184285,
 1628226424,
 -1,
 -40676,
 1629152027,
 8609,
 -1,
 1629205178,
 10507,
 1629380896,
 1629107756,
 -1,
 -40673,
 1629330377,
 8659,
 -1,
 1629365162,
 8675,
 -40671,
 1629350130,
 8623,
 -40670,
 1629544328,
 8681,
 -40669,
 1629595749,
 10225,
 -40668,
 1629659402,
 8650,
 -1,
 1629694504,
 11015,
 1629905195,
 1627193344,
 -1,
 1629970728,
 1629864957,
 8868,
 -1,
 1629883508,
 10993,
 -40663,
 1629925206,
 8945,
 -40662,
 1630032094,
 10623,
 -1,
 1630085831,
 8964,
 1630339071,
 1629819152,
 -1,
 -40659,
 1630252977,
 10729,
 -1,
 1630304107,
 10728,
 1630495037,
 1627177848,
 -1,
 1630560568,
 1630455154,
 -1,
 1630626099,
 1630481667,
 -1,
 -40654,
 1630582040,
 8284,
 -1,
 1630629002,
 9676,
 -40652,
 1630587735,
 11784,
 -40651,
 1630781428,
 11034,
 -40650,
 1630843112,
 11798,
 -40649,
 1630900830,
 11795,
 -1,
 1630949356,
 10649,
 1631191039,
 1630470144,
 -1,
 -40646,
 1631102158,
 8724,
 -40645,
 1631164418,
 8901,
 -40644,
 1631225358,
 8760,
 -1,
 1631262351,
 729,
 1631478091,
 1630423676,
 -1,
 1631543618,
 1631430240,
 -1,
 1631609153,
 1631470144,
 8832,
 -1,
 1631520466,
 8928,
 -1,
 1631559038,
 8876,
 1631805766,
 1631466230,
 -1,
 1631871301,
 1631751780,
 8939,
 -1,
 1631782610,
 8941,
 -1,
 1631814743,
 8716,
 1632067912,
 1631765047,
 8833,
 -1,
 1631979218,
 8929,
 1632198986,
 1631992431,
 8740,
 -1,
 1632112184,
 10990,
 -1,
 1632129482,
 8878,
 -40628,
 1631423539,
 8363,
 -1,
 1632337105,
 36,
 1632526973,
 1612202151,
 -1,
 1632592381,
 1632491707,
 -1,
 1632657843,
 1632533058,
 -1,
 1632723289,
 1632614320,
 -1,
 1632788823,
 1632655603,
 -1,
 1632854358,
 1632737808,
 -1,
 -40620,
 1632801266,
 2322,
 -40619,
 1632845991,
 2318,
 -1,
 1632900494,
 2308,
 -1,
 1632769422,
 2358,
 -40616,
 1632745514,
 2359,
 -1,
 1633097102,
 2360,
 1633313122,
 1632646700,
 -1,
 1633378656,
 1633236524,
 -1,
 1633444190,
 1633302060,
 -1,
 -40611,
 1633376529,
 2396,
 -1,
 1633424782,
 2430,
 -40609,
 1633376529,
 2338,
 -1,
 1633555854,
 2337,
 -40607,
 1633310993,
 2343,
 -1,
 1633686926,
 2342,
 1633902953,
 1633278054,
 -1,
 1633968488,
 1633850040,
 -1,
 1634034022,
 1633921494,
 2315,
 -1,
 1633987030,
 2400,
 1634205695,
 1633973188,
 2316,
 -1,
 1634104260,
 2401,
 -1,
 1633883534,
 2357,
 1634361712,
 1633847618,
 -1,
 1634427245,
 1634306370,
 -1,
 -40596,
 1634371998,
 2345,
 -1,
 1634407822,
 2339,
 -40594,
 1634395388,
 2334,
 -40593,
 1634554719,
 2329,
 -1,
 1634604430,
 2344,
 1634820471,
 1634292523,
 -1,
 1634886004,
 1634752755,
 -1,
 -40589,
 1634818321,
 2394,
 -1,
 1634866574,
 2328,
 -40587,
 1634827883,
 2429,
 -40586,
 1635013471,
 2427,
 -1,
 1635063182,
 2327,
 1635279230,
 1634741507,
 -1,
 1635344765,
 1635194254,
 2330,
 1635450879,
 1635289942,
 -1,
 -40581,
 1635357170,
 2321,
 -40580,
 1635401895,
 2317,
 -1,
 1635456398,
 2418,
 -1,
 1635277073,
 2331,
 1635737988,
 1635238776,
 -1,
 1635803522,
 1635697528,
 -1,
 -40575,
 1635735825,
 2336,
 -1,
 1635784078,
 2335,
 -40573,
 1635735825,
 2341,
 -1,
 1635915150,
 2340,
 1636131208,
 1635653006,
 2309,
 -40570,
 1636093678,
 2324,
 -40569,
 1636131303,
 2320,
 -1,
 1636177294,
 2310,
 1636393356,
 1636084182,
 -1,
 -40566,
 1636346417,
 2353,
 -40565,
 1636391185,
 2397,
 -1,
 1636439438,
 2352,
 1636655505,
 1636332484,
 -1,
 1636721040,
 1636594628,
 -1,
 -40561,
 1636660249,
 2356,
 -1,
 1636701582,
 2355,
 -1,
 1636636046,
 2354,
 1636983190,
 1636593910,
 -1,
 1637048725,
 1636915443,
 -1,
 -40556,
 1636981009,
 2393,
 -1,
 1637029262,
 2326,
 -1,
 1636963726,
 2325,
 1637310874,
 1636921239,
 -1,
 -40552,
 1637248921,
 2428,
 -40551,
 1637308689,
 2333,
 -1,
 1637356942,
 2332,
 1637573022,
 1637230235,
 -1,
 -40548,
 1637505297,
 2349,
 -40547,
 1637557965,
 2431,
 -1,
 1637619086,
 2348,
 1637835169,
 1637541880,
 -1,
 -40544,
 1637767441,
 2425,
 -1,
 1637815694,
 2395,
 1638031780,
 1637803200,
 -1,
 -40541,
 1637999868,
 2399,
 -1,
 1638012302,
 2351,
 1638228390,
 1637994222,
 2313,
 -1,
 1638190830,
 2314,
 1638359465,
 1638178923,
 -1,
 -40536,
 1638291729,
 2347,
 -1,
 1638339982,
 2346,
 1638556075,
 1638293991,
 2311,
 -1,
 1638490599,
 2312,
 1638687150,
 1638488307,
 -1,
 -40531,
 1638613530,
 2426,
 -1,
 1638667662,
 2361,
 -40529,
 1638639564,
 2392,
 -40528,
 1638830578,
 2323,
 -40527,
 1638891669,
 2350,
 -40526,
 1638944519,
 2398,
 -1,
 1639006375,
 2319,
 1639211467,
 1632624008,
 -1,
 1639276985,
 1639177441,
 -1,
 1639342519,
 1639229910,
 2371,
 -1,
 1639295446,
 2372,
 1639514111,
 1639281604,
 2402,
 -1,
 1639412676,
 2403,
 1639604669,
 1639198148,
 -1,
 -40517,
 1639551474,
 2377,
 -40516,
 1639611810,
 2389,
 -1,
 1639661735,
 2373,
 1639866817,
 1639519630,
 -1,
 -40513,
 1639829230,
 2380,
 -40512,
 1639866855,
 2376,
 -1,
 1639912846,
 2366,
 1640128963,
 1639829230,
 2369,
 -1,
 1640091374,
 2370,
 1640260038,
 1640086510,
 -1,
 -40507,
 1640206834,
 2378,
 -1,
 1640251559,
 2374,
 1640456648,
 1640194535,
 2367,
 -1,
 1640391143,
 2368,
 -40503,
 1640408847,
 2382,
 -40502,
 1640534514,
 2379,
 -1,
 1640579239,
 2375,
 1640784355,
 1639167920,
 -1,
 1640849888,
 1640719857,
 -1,
 1640915412,
 1640771033,
 2305,
 1641021439,
 1640824832,
 -1,
 1641046482,
 1640940408,
 -1,
 -40495,
 1641013857,
 43253,
 -1,
 1641046206,
 43254,
 -40493,
 1641012373,
 43251,
 -1,
 1641162241,
 43255,
 1641374167,
 1640881207,
 -1,
 -40490,
 1641330870,
 2307,
 -1,
 1641392911,
 2381,
 1641570778,
 1641289102,
 -1,
 -40487,
 1641535613,
 2365,
 -1,
 1641582888,
 2306,
 -40485,
 1641529243,
 43250,
 -40484,
 1641719731,
 43256,
 -40483,
 1641779352,
 2364,
 -40482,
 1641835357,
 2304,
 -40481,
 1641897330,
 2417,
 -1,
 1641954515,
 43252,
 1642201087,
 1640811390,
 -1,
 -40478,
 1642123431,
 2385,
 -1,
 1642143667,
 2386,
 1642357236,
 1640707628,
 -1,
 1642422770,
 1642292706,
 -1,
 1642488296,
 1642382200,
 -1,
 -40473,
 1642455649,
 2408,
 -1,
 1642487998,
 2409,
 1642684907,
 1642444720,
 -1,
 -40470,
 1642622812,
 2412,
 -1,
 1642679471,
 2413,
 1642881518,
 1642614430,
 -1,
 -40467,
 1642830962,
 2410,
 -1,
 1642884837,
 2411,
 -40465,
 1642850415,
 2406,
 -40464,
 1643025954,
 2407,
 -40463,
 1643089183,
 2415,
 -1,
 1643136343,
 2414,
 -40461,
 1642372069,
 2405,
 -1,
 1643257445,
 2404,
 1643471351,
 1642287915,
 -1,
 -40458,
 1643424651,
 2387,
 -1,
 1643454418,
 43257,
 1643667962,
 1643386254,
 -1,
 -40455,
 1643591175,
 2388,
 -1,
 1643653163,
 2416,
 -40453,
 1643615529,
 2384,
 -40452,
 1643797425,
 43259,
 -1,
 1643851331,
 43258,
 1644061278,
 1632548784,
 -1,
 1644126813,
 1643989485,
 -1,
 1644192302,
 1644084903,
 -1,
 1644257803,
 1644118183,
 -1,
 1644323331,
 1644214192,
 66629,
 -1,
 1644255475,
 66631,
 1644454405,
 1644267842,
 66636,
 -1,
 1644385067,
 66637,
 -40442,
 1644420570,
 66639,
 -40441,
 1644545715,
 66627,
 -40440,
 1644603862,
 66633,
 -40439,
 1644658760,
 66635,
 -40438,
 1644721092,
 66634,
 -1,
 1644777118,
 66625,
 1644978706,
 1644215278,
 -1,
 1645044238,
 1644925426,
 66610,
 -1,
 1644990962,
 66611,
 1645175312,
 1644959118,
 66608,
 -1,
 1645107443,
 66609,
 -40431,
 1645109735,
 66606,
 -1,
 1645232295,
 66607,
 1645437465,
 1644920197,
 -1,
 1645502997,
 1645384178,
 66604,
 -1,
 1645449714,
 66605,
 1645634071,
 1645417870,
 66602,
 -1,
 1645566195,
 66603,
 -40424,
 1645568487,
 66600,
 -1,
 1645691047,
 66601,
 1645896220,
 1645406200,
 -1,
 -40421,
 1645829207,
 66632,
 -1,
 1645888327,
 66630,
 1646092831,
 1645855608,
 -1,
 -40418,
 1646025815,
 66628,
 -1,
 1646084935,
 66619,
 1646289442,
 1646039538,
 -1,
 -40415,
 1646255578,
 66613,
 -1,
 1646289383,
 66638,
 -40413,
 1646257568,
 66615,
 -40412,
 1646453689,
 66614,
 -40411,
 1646516762,
 66626,
 -40410,
 1646568026,
 66617,
 -40409,
 1646621177,
 66623,
 -40408,
 1646686189,
 66622,
 -40407,
 1646745843,
 66616,
 -40406,
 1646810186,
 66624,
 -40405,
 1646868343,
 66620,
 -40404,
 1646931884,
 66621,
 -40403,
 1646995532,
 66618,
 -1,
 1647060573,
 66612,
 1647312895,
 1644113449,
 -1,
 1647338042,
 1647198375,
 -1,
 1647403570,
 1647294384,
 66589,
 -1,
 1647335667,
 66591,
 1647534644,
 1647348034,
 66596,
 -1,
 1647465259,
 66597,
 -40395,
 1647500762,
 66599,
 -40394,
 1647625907,
 66587,
 -40393,
 1647684054,
 66593,
 -40392,
 1647738952,
 66595,
 -40391,
 1647801284,
 66594,
 -1,
 1647857310,
 66585,
 1648058945,
 1647295470,
 -1,
 1648124477,
 1648005618,
 66570,
 -1,
 1648071154,
 66571,
 1648255551,
 1648039310,
 66568,
 -1,
 1648187635,
 66569,
 -40384,
 1648189927,
 66566,
 -1,
 1648312487,
 66567,
 1648517704,
 1648000389,
 -1,
 1648583236,
 1648464370,
 66564,
 -1,
 1648529906,
 66565,
 1648714310,
 1648498062,
 66562,
 -1,
 1648646387,
 66563,
 -40377,
 1648648679,
 66560,
 -1,
 1648771239,
 66561,
 1648976459,
 1648486392,
 -1,
 -40374,
 1648909399,
 66592,
 -1,
 1648968519,
 66590,
 1649173070,
 1648935800,
 -1,
 -40371,
 1649106007,
 66588,
 -1,
 1649165127,
 66579,
 1649369681,
 1649119730,
 -1,
 -40368,
 1649335770,
 66573,
 -1,
 1649369575,
 66598,
 -40366,
 1649337760,
 66575,
 -40365,
 1649533881,
 66574,
 -40364,
 1649596954,
 66586,
 -40363,
 1649648218,
 66577,
 -40362,
 1649701369,
 66583,
 -40361,
 1649766381,
 66582,
 -40360,
 1649826035,
 66576,
 -40359,
 1649890378,
 66584,
 -40358,
 1649948535,
 66580,
 -40357,
 1650012076,
 66581,
 -40356,
 1650075724,
 66578,
 -1,
 1650140765,
 66572,
 -1,
 1644048115,
 9739,
 1650418293,
 1644007473,
 -1,
 1650483819,
 1650383606,
 -1,
 1650549352,
 1650400656,
 -1,
 1650614884,
 1650510503,
 -1,
 -40349,
 1650568942,
 9150,
 -1,
 1650620145,
 9163,
 1650811495,
 1650535165,
 -1,
 -40346,
 1650765550,
 9151,
 -1,
 1650816753,
 9164,
 -1,
 1650777812,
 9158,
 1651113983,
 1650516036,
 -1,
 -40342,
 1651035038,
 9155,
 -1,
 1651060833,
 9152,
 1651270256,
 1650447287,
 9162,
 1651376127,
 1651182646,
 -1,
 -40338,
 1651302100,
 9160,
 -40337,
 1651362718,
 9157,
 -1,
 1651388513,
 9154,
 1651638271,
 1651195492,
 9161,
 1651703807,
 1651510326,
 -1,
 -40333,
 1651629780,
 9159,
 -40332,
 1651690398,
 9156,
 -1,
 1651716193,
 9153,
 1651925625,
 1650350084,
 -1,
 -40329,
 1651883196,
 176,
 -40328,
 1651920675,
 8457,
 -1,
 1651977963,
 8451,
 1652187772,
 1651847258,
 -1,
 -40325,
 1652144665,
 9110,
 -1,
 1652182463,
 9192,
 -1,
 1652129627,
 8796,
 1652450057,
 1632461287,
 -1,
 1652515513,
 1652380459,
 -1,
 1652581035,
 1652452848,
 -1,
 1652646537,
 1652540280,
 -1,
 1652712069,
 1652613729,
 50,
 1652817919,
 1652621312,
 -1,
 -40316,
 1652708106,
 9353,
 -1,
 1652765244,
 127235,
 1653014527,
 1652646078,
 51,
 1653080063,
 1652883456,
 -1,
 -40312,
 1652970250,
 9354,
 -1,
 1653027388,
 127236,
 1653236370,
 1652602800,
 -1,
 1653301902,
 1653174108,
 54,
 1653407743,
 1653211136,
 -1,
 -40307,
 1653297930,
 9357,
 -1,
 1653355068,
 127239,
 1653604351,
 1653230767,
 55,
 1653669887,
 1653473280,
 -1,
 -40303,
 1653560074,
 9358,
 -1,
 1653617212,
 127240,
 1653826203,
 1653165726,
 -1,
 1653891735,
 1653775474,
 52,
 1653997567,
 1653800960,
 -1,
 -40298,
 1653887754,
 9355,
 -1,
 1653944892,
 127237,
 1654194175,
 1653829349,
 53,
 1654259711,
 1654063104,
 -1,
 -40294,
 1654149898,
 9356,
 -1,
 1654207036,
 127238,
 1654416031,
 1653794927,
 48,
 1654521855,
 1654325248,
 -1,
 -40290,
 1654412042,
 127232,
 -1,
 1654469180,
 127233,
 1654678179,
 1654363682,
 49,
 1654783999,
 1654587392,
 -1,
 -40286,
 1654674186,
 9352,
 -1,
 1654731324,
 127234,
 1654940327,
 1654623519,
 57,
 1655046143,
 1654849536,
 -1,
 -40282,
 1654936330,
 9360,
 -1,
 1654993468,
 127242,
 1655242751,
 1654867287,
 56,
 1655308287,
 1655111680,
 -1,
 -40278,
 1655198474,
 9359,
 -1,
 1655255612,
 127241,
 1655504895,
 1652534022,
 -1,
 1655530160,
 1655390596,
 119557,
 1655635967,
 1655472162,
 -1,
 -40273,
 1655558719,
 119556,
 -1,
 1655587284,
 119555,
 1655792307,
 1655470628,
 -1,
 -40270,
 1655728024,
 9869,
 -1,
 1655774853,
 9870,
 1655988918,
 1655724275,
 -1,
 -40267,
 1655951940,
 119554,
 -1,
 1655980506,
 119553,
 1656225791,
 1655920469,
 -1,
 -40264,
 1656121240,
 9871,
 -1,
 1656168069,
 9868,
 1656382183,
 1652460630,
 -1,
 1656447704,
 1656327065,
 -1,
 1656513226,
 1656404129,
 -1,
 1656578761,
 1656437156,
 -1,
 1656644288,
 1656537976,
 -1,
 -40257,
 1656611425,
 10123,
 -1,
 1656643774,
 10124,
 1656840899,
 1656600496,
 -1,
 -40254,
 1656778588,
 10127,
 -1,
 1656835247,
 10128,
 1657037510,
 1656770206,
 -1,
 -40251,
 1656986738,
 10125,
 -1,
 1657040613,
 10126,
 -40249,
 1656985122,
 10122,
 -40248,
 1657179423,
 10130,
 -1,
 1657226583,
 10129,
 -1,
 1656524982,
 10131,
 1657496279,
 1656437156,
 -1,
 1657561806,
 1657455480,
 -1,
 -40243,
 1657528929,
 10103,
 -1,
 1657561278,
 10104,
 1657758417,
 1657518000,
 -1,
 -40240,
 1657696092,
 10107,
 -1,
 1657752751,
 10108,
 1657955028,
 1657687710,
 -1,
 -40237,
 1657904242,
 10105,
 -1,
 1657958117,
 10106,
 -40235,
 1657902626,
 10102,
 -40234,
 1658096927,
 10110,
 -1,
 1658144087,
 10109,
 -1,
 1657442486,
 10111,
 1658454015,
 1656369328,
 -1,
 1658479334,
 1658337700,
 -1,
 1658544861,
 1658438520,
 -1,
 -40228,
 1658511969,
 10113,
 -1,
 1658544318,
 10114,
 1658741472,
 1658501040,
 -1,
 -40225,
 1658679132,
 10117,
 -1,
 1658735791,
 10118,
 1658938083,
 1658670750,
 -1,
 -40222,
 1658887282,
 10115,
 -1,
 1658941157,
 10116,
 -40220,
 1658885666,
 10112,
 -40219,
 1659079967,
 10120,
 -1,
 1659127127,
 10119,
 -1,
 1658425526,
 10121,
 1659396850,
 1656296846,
 -1,
 1659462385,
 1659338824,
 -1,
 1659527920,
 1659409949,
 -1,
 1659593455,
 1659494468,
 -1,
 -40212,
 1659554487,
 11032,
 -40211,
 1659613105,
 11031,
 -40210,
 1659664235,
 11030,
 -1,
 1659710227,
 11033,
 -1,
 1659541506,
 8900,
 -1,
 1659456517,
 8960,
 -1,
 1659390433,
 168,
 1660117753,
 1659322540,
 -1,
 -40204,
 1660032155,
 9861,
 -40203,
 1660097571,
 9860,
 -40202,
 1660163030,
 9859,
 -40201,
 1660228454,
 9858,
 -40200,
 1660293825,
 9857,
 -1,
 1660359209,
 9856,
 1660576514,
 1660082278,
 -1,
 1660642049,
 1660510695,
 -1,
 1660707584,
 1660599713,
 -1,
 1660773119,
 1660663728,
 -1,
 -40194,
 1660712430,
 8725,
 -1,
 1660773869,
 247,
 -1,
 1660733666,
 8903,
 -1,
 1660631062,
 8739,
 -1,
 1660590320,
 9902,
 1661166341,
 1660532656,
 -1,
 -40188,
 1661088575,
 9090,
 -1,
 1661146743,
 9933,
 -40186,
 1661127954,
 12291,
 -40185,
 1661316204,
 9107,
 -40184,
 1661371503,
 9009,
 -1,
 1661423622,
 8783,
 1661625105,
 1652364686,
 -1,
 1661690638,
 1661582193,
 -1,
 -40180,
 1661651879,
 10143,
 -40179,
 1661706077,
 65097,
 -1,
 1661763211,
 65101,
 -40177,
 1661645792,
 9619,
 -40176,
 1661893165,
 8504,
 -1,
 1661949172,
 8224,
 1662189567,
 1661577686,
 -1,
 1662214933,
 1662064014,
 -1,
 -40172,
 1662145232,
 10139,
 -1,
 1662201830,
 8367,
 -1,
 1662152485,
 9946,
 1662477642,
 1612157426,
 -1,
 1662542916,
 1662415812,
 -1,
 1662608388,
 1662465582,
 -1,
 1662673770,
 1662569840,
 -1,
 1662739272,
 1662622144,
 -1,
 1662804786,
 1662653838,
 68608,
 1662870311,
 1662730407,
 -1,
 -40162,
 1662837952,
 68632,
 -40161,
 1662894968,
 68677,
 -40160,
 1662957488,
 68670,
 -40159,
 1663019478,
 68668,
 -40158,
 1663076674,
 68644,
 -40157,
 1663136708,
 68640,
 -40156,
 1663201526,
 68634,
 -40155,
 1663259435,
 68623,
 -40154,
 1663317548,
 68627,
 -1,
 1663379099,
 68619,
 1663591209,
 1662826416,
 68669,
 -1,
 1663523059,
 68671,
 -40150,
 1663558848,
 68630,
 -40149,
 1663681400,
 68675,
 -40148,
 1663740374,
 68666,
 -40147,
 1663805382,
 68660,
 -40146,
 1663863106,
 68643,
 -40145,
 1663923140,
 68638,
 -40144,
 1663980331,
 68621,
 -40143,
 1664038444,
 68625,
 -1,
 1664099995,
 68617,
 1664312126,
 1662730407,
 -1,
 1664377656,
 1664256322,
 -1,
 -40139,
 1664345280,
 68650,
 -40138,
 1664402296,
 68646,
 -40137,
 1664439083,
 68653,
 -1,
 1664494851,
 68648,
 -40135,
 1664346104,
 68628,
 -40134,
 1664662180,
 68673,
 -40133,
 1664721003,
 68655,
 -40132,
 1664778312,
 68642,
 -40131,
 1664843592,
 68641,
 -1,
 1664888067,
 68658,
 1665098564,
 1664258546,
 68614,
 1665164097,
 1665024167,
 68615,
 -1,
 1665102070,
 68636,
 -40126,
 1665123192,
 68679,
 -40125,
 1665247174,
 68664,
 -1,
 1665310827,
 68656,
 1665491783,
 1665032679,
 68611,
 -40122,
 1665443782,
 68662,
 -1,
 1665477891,
 68657,
 -1,
 1665411063,
 68680,
 1665794047,
 1662707216,
 -1,
 1665819484,
 1665668494,
 68609,
 1665885010,
 1665745063,
 68610,
 1665950541,
 1665829186,
 68645,
 -1,
 1665880875,
 68654,
 -40114,
 1665918144,
 68633,
 -40113,
 1666040696,
 68678,
 -40112,
 1666085110,
 68635,
 -40111,
 1666143019,
 68624,
 -1,
 1666197147,
 68620,
 -40109,
 1665852608,
 68631,
 -40108,
 1666368376,
 68676,
 -40107,
 1666431652,
 68672,
 -40106,
 1666492886,
 68667,
 -40105,
 1666557894,
 68661,
 -40104,
 1666616346,
 68652,
 -40103,
 1666675652,
 68639,
 -40102,
 1666732843,
 68622,
 -40101,
 1666790956,
 68626,
 -1,
 1666852507,
 68618,
 1667064676,
 1665745063,
 68613,
 1667130209,
 1667008834,
 -1,
 -40097,
 1667097792,
 68651,
 -40096,
 1667154808,
 68647,
 -1,
 1667181827,
 68649,
 -40094,
 1667098616,
 68629,
 -40093,
 1667349156,
 68674,
 -1,
 1667378435,
 68659,
 1667588968,
 1667011058,
 -1,
 1667654503,
 1667514535,
 68616,
 -1,
 1667592438,
 68637,
 -1,
 1667606470,
 68665,
 1667891199,
 1667523047,
 68612,
 -1,
 1667803078,
 68663,
 1667982253,
 1662624656,
 -1,
 1668047780,
 1667939521,
 -1,
 1668113266,
 1667970604,
 -1,
 1668178800,
 1668027790,
 66477,
 1668284415,
 1668112840,
 66508,
 -1,
 1668157163,
 66509,
 -40079,
 1668140782,
 66479,
 -1,
 1668309479,
 66478,
 1668506486,
 1668027790,
 66464,
 1668612095,
 1668470351,
 66504,
 -40075,
 1668503825,
 66506,
 -1,
 1668550379,
 66505,
 1668768634,
 1668465528,
 -1,
 -40072,
 1668730606,
 66476,
 -40071,
 1668765969,
 66480,
 -1,
 1668814222,
 66475,
 1669030782,
 1668724656,
 -1,
 -40068,
 1668986922,
 66498,
 -40067,
 1669028113,
 66497,
 -1,
 1669076366,
 66495,
 1669292930,
 1668972616,
 -1,
 -40064,
 1669254894,
 66488,
 -40063,
 1669292519,
 66487,
 -1,
 1669338510,
 66486,
 1669555078,
 1669211803,
 -1,
 1669620613,
 1669469582,
 66482,
 -1,
 1669550943,
 66510,
 -1,
 1669584949,
 66511,
 1669817225,
 1669522390,
 -1,
 -40056,
 1669774060,
 66507,
 -1,
 1669797262,
 66471,
 1670013836,
 1669781606,
 -1,
 -40053,
 1669947879,
 66491,
 -1,
 1669993870,
 66490,
 1670210447,
 1669966294,
 -1,
 -40050,
 1670172398,
 66493,
 -1,
 1670190478,
 66492,
 1670407058,
 1670154562,
 -1,
 -40047,
 1670369006,
 66485,
 -1,
 1670387086,
 66484,
 1670603669,
 1670344950,
 -1,
 -40044,
 1670565614,
 66468,
 -1,
 1670583694,
 66467,
 1670800280,
 1670541207,
 -1,
 -40041,
 1670734311,
 66474,
 -1,
 1670780302,
 66473,
 1670996891,
 1670730539,
 -1,
 -40038,
 1670958830,
 66470,
 -1,
 1670976910,
 66469,
 -40036,
 1670965258,
 66496,
 -40035,
 1671161084,
 66489,
 -40034,
 1671220974,
 66466,
 -40033,
 1671274704,
 66481,
 -40032,
 1671328793,
 66494,
 -40031,
 1671389671,
 66465,
 -40030,
 1671452945,
 66499,
 -40029,
 1671515911,
 66483,
 -1,
 1671572832,
 66472,
 1671783340,
 1667993762,
 -1,
 1671848874,
 1671742328,
 -1,
 1671914409,
 1671814618,
 -1,
 -40024,
 1671860722,
 66514,
 -1,
 1671907439,
 66516,
 -1,
 1671841553,
 66515,
 -40021,
 1671796258,
 66513,
 -1,
 1672110463,
 66517,
 -1,
 1671750542,
 66512,
 1672373207,
 1667919374,
 -1,
 1672438737,
 1672313410,
 -1,
 1672504249,
 1672364199,
 66308,
 1672569778,
 1672460208,
 66324,
 -1,
 1672501491,
 66318,
 1672700852,
 1672522198,
 66323,
 -1,
 1672656816,
 66331,
 -40011,
 1672644930,
 66317,
 -40010,
 1672773704,
 66316,
 -40009,
 1672836036,
 66315,
 -40008,
 1672901461,
 66327,
 -1,
 1672957598,
 66330,
 1673159614,
 1672442102,
 -1,
 -40005,
 1673121518,
 66322,
 -40004,
 1673157520,
 66329,
 -40003,
 1673216167,
 66306,
 -1,
 1673270670,
 66314,
 1673487296,
 1673121518,
 66326,
 -1,
 1673449198,
 66334,
 1673618371,
 1673446264,
 -1,
 -39998,
 1673550736,
 66312,
 -1,
 1673609383,
 66325,
 1673814982,
 1673568363,
 -1,
 -39995,
 1673747344,
 66328,
 -1,
 1673805991,
 66320,
 1674011592,
 1673748967,
 66313,
 -1,
 1673945575,
 66333,
 -39991,
 1673979983,
 66310,
 -39990,
 1674107314,
 66309,
 -39989,
 1674165096,
 66321,
 -39988,
 1674220018,
 66319,
 -39987,
 1674271632,
 66311,
 -39986,
 1674327894,
 66307,
 -39985,
 1674391441,
 66332,
 -39984,
 1674455100,
 66305,
 -1,
 1674515854,
 66304,
 1674772479,
 1672384717,
 -1,
 1674798037,
 1674661969,
 -1,
 -39980,
 1674762674,
 66337,
 -1,
 1674793734,
 66339,
 -39978,
 1674757578,
 66338,
 -1,
 1674941986,
 66336,
 1675165695,
 1672331114,
 -1,
 1675191295,
 1675065922,
 -1,
 1675256799,
 1675150200,
 -1,
 1675322333,
 1675188467,
 -1,
 -39972,
 1675250703,
 68220,
 -1,
 1675306554,
 68219,
 -39970,
 1675250703,
 68215,
 -1,
 1675437626,
 68201,
 1675650021,
 1675212720,
 -1,
 1675715556,
 1675564430,
 -1,
 -39966,
 1675674488,
 68202,
 -39965,
 1675723831,
 68207,
 -1,
 1675770003,
 68206,
 -1,
 1675648491,
 68198,
 1676043242,
 1675572780,
 -1,
 1676108777,
 1675974929,
 -1,
 -39960,
 1676048957,
 68217,
 -1,
 1676097683,
 68211,
 -1,
 1676024681,
 68213,
 1676370925,
 1675981046,
 -1,
 -39956,
 1676303563,
 68205,
 -1,
 1676353512,
 68203,
 1676567535,
 1676303248,
 68192,
 -1,
 1676527283,
 68194,
 1676698610,
 1676497707,
 -1,
 -39951,
 1676633858,
 68212,
 -1,
 1676696459,
 68214,
 1676895221,
 1676613006,
 -1,
 -39948,
 1676863213,
 68210,
 -1,
 1676900072,
 68209,
 -39946,
 1676863562,
 68216,
 -39945,
 1677059865,
 68218,
 -39944,
 1677123329,
 68197,
 -39943,
 1677176218,
 68199,
 -39942,
 1677240378,
 68196,
 -39941,
 1677299978,
 68204,
 -39940,
 1677362250,
 68195,
 -39939,
 1677423959,
 68193,
 -39938,
 1677479790,
 68208,
 -1,
 1677535572,
 68200,
 1677787135,
 1675137182,
 -1,
 1677812739,
 1677666468,
 -1,
 -39934,
 1677760034,
 68221,
 -1,
 1677807713,
 68222,
 -1,
 1677740531,
 68223,
 1678114815,
 1662517917,
 -1,
 1678140459,
 1678015042,
 -1,
 1678205968,
 1678054798,
 -1,
 1678271500,
 1678120334,
 -1,
 -39927,
 1678237146,
 7267,
 -39926,
 1678278728,
 7266,
 -39925,
 1678340342,
 7264,
 -1,
 1678405527,
 7265,
 -39923,
 1678230392,
 7259,
 -39922,
 1678543898,
 7261,
 -39921,
 1678603204,
 7262,
 -1,
 1678660395,
 7260,
 1678861335,
 1678144452,
 -1,
 1678926867,
 1678775694,
 7258,
 -1,
 1678841230,
 7263,
 -39916,
 1678888686,
 7273,
 -39915,
 1679004146,
 7283,
 -39914,
 1679057383,
 7268,
 -1,
 1679114407,
 7278,
 1679320092,
 1678823150,
 -1,
 -39911,
 1679287488,
 7277,
 -39910,
 1679330781,
 7276,
 -39909,
 1679373868,
 7275,
 -1,
 1679437059,
 7274,
 1679647777,
 1679266290,
 -1,
 -39906,
 1679612006,
 7286,
 -39905,
 1679674556,
 7284,
 -39904,
 1679710451,
 7287,
 -1,
 1679763099,
 7285,
 1679975462,
 1679581671,
 -1,
 -39901,
 1679931312,
 7269,
 -39900,
 1679993302,
 7272,
 -39899,
 1680052637,
 7271,
 -1,
 1680103667,
 7270,
 1680343039,
 1679900839,
 -1,
 -39896,
 1680258550,
 7282,
 -39895,
 1680318571,
 7279,
 -39894,
 1680378178,
 7281,
 -1,
 1680422728,
 7280,
 1680630841,
 1678064036,
 -1,
 1680696367,
 1680589688,
 -1,
 -39890,
 1680663137,
 7250,
 -1,
 1680695486,
 7251,
 1680892978,
 1680652208,
 -1,
 -39887,
 1680830300,
 7254,
 -1,
 1680886959,
 7255,
 1681089589,
 1680821918,
 -1,
 -39884,
 1681038450,
 7252,
 -1,
 1681092325,
 7253,
 -39882,
 1681057903,
 7248,
 -39881,
 1681233442,
 7249,
 -39880,
 1681296671,
 7257,
 -1,
 1681343831,
 7256,
 1681548350,
 1680580715,
 -1,
 1681613885,
 1681511099,
 -1,
 -39876,
 1681557527,
 7294,
 -1,
 1681603926,
 7295,
 -1,
 1681545513,
 7292,
 1681876033,
 1681491988,
 -1,
 -39872,
 1681788852,
 7290,
 -1,
 1681853401,
 7288,
 -39870,
 1681829202,
 7291,
 -39869,
 1682002786,
 7289,
 -1,
 1682053425,
 7293,
 1682269374,
 1662495190,
 -1,
 1682334905,
 1682203111,
 -1,
 1682400440,
 1682302207,
 -1,
 1682465933,
 1682340418,
 -1,
 1682531407,
 1682430054,
 -1,
 1682596942,
 1682477752,
 -1,
 1682662476,
 1682549206,
 2827,
 -1,
 1682614742,
 2912,
 1682833407,
 1682600900,
 2828,
 -1,
 1682731972,
 2913,
 -1,
 1682511246,
 2869,
 1682990165,
 1682490232,
 -1,
 1683055699,
 1682948984,
 -1,
 -39854,
 1682987281,
 2848,
 -1,
 1683035534,
 2847,
 -39852,
 1682987281,
 2853,
 -1,
 1683166606,
 2852,
 1683383386,
 1682934082,
 -1,
 -39849,
 1683350780,
 2846,
 -39848,
 1683392926,
 2851,
 -39847,
 1683444575,
 2841,
 -1,
 1683494286,
 2856,
 1683711072,
 1683306028,
 -1,
 1683776606,
 1683633708,
 -1,
 -39843,
 1683708177,
 2850,
 -1,
 1683756430,
 2849,
 -39841,
 1683708177,
 2855,
 -1,
 1683887502,
 2854,
 1684104292,
 1683625358,
 2821,
 -39838,
 1684066030,
 2836,
 -39837,
 1684103655,
 2832,
 -1,
 1684149646,
 2822,
 1684366440,
 1684060080,
 -1,
 -39834,
 1684322346,
 2871,
 -39833,
 1684363537,
 2870,
 -1,
 1684411790,
 2872,
 1684628588,
 1684318678,
 -1,
 -39830,
 1684580913,
 2908,
 -39829,
 1684625681,
 2909,
 -1,
 1684673934,
 2864,
 1684890735,
 1684595904,
 -1,
 -39826,
 1684858108,
 2911,
 -1,
 1684870542,
 2863,
 1685087345,
 1684852462,
 2825,
 -1,
 1685049070,
 2826,
 1685218420,
 1685037163,
 -1,
 -39821,
 1685149969,
 2859,
 -1,
 1685198222,
 2858,
 1685415031,
 1685156804,
 -1,
 -39818,
 1685353497,
 2867,
 -1,
 1685394830,
 2866,
 1685611642,
 1685352694,
 -1,
 -39815,
 1685543185,
 2838,
 -1,
 1685591438,
 2837,
 1685808253,
 1685548951,
 -1,
 -39812,
 1685739793,
 2845,
 -1,
 1685788046,
 2844,
 1686004863,
 1685742055,
 2823,
 -1,
 1685938663,
 2824,
 1686135938,
 1685934891,
 -1,
 -39807,
 1686067473,
 2840,
 -1,
 1686115726,
 2839,
 1686332549,
 1686056195,
 -1,
 -39804,
 1686264081,
 2843,
 -1,
 1686312334,
 2842,
 1686529160,
 1686251163,
 -1,
 -39801,
 1686460689,
 2861,
 -1,
 1686508942,
 2860,
 -39799,
 1686494722,
 2929,
 -39798,
 1686671858,
 2835,
 -39797,
 1686732949,
 2862,
 -39796,
 1686788369,
 2873,
 -1,
 1686847655,
 2831,
 1687053469,
 1682431368,
 -1,
 1687118995,
 1687018721,
 -1,
 1687184529,
 1687071190,
 2883,
 -1,
 1687136726,
 2884,
 1687355391,
 1687122884,
 2914,
 -1,
 1687253956,
 2915,
 1687446679,
 1687033230,
 -1,
 -39787,
 1687408366,
 2892,
 -39786,
 1687445991,
 2888,
 -1,
 1687491982,
 2878,
 1687708825,
 1687408366,
 2881,
 -1,
 1687670510,
 2882,
 1687839899,
 1687642599,
 2879,
 -1,
 1687773671,
 2880,
 -39780,
 1687785970,
 2891,
 -1,
 1687896231,
 2887,
 1688102059,
 1686976932,
 -1,
 1688167585,
 1688060792,
 -1,
 -39776,
 1688134241,
 2920,
 -1,
 1688166590,
 2921,
 1688364196,
 1688123312,
 -1,
 -39773,
 1688301404,
 2924,
 -1,
 1688358063,
 2925,
 1688560807,
 1688293022,
 -1,
 -39770,
 1688509554,
 2922,
 -1,
 1688563429,
 2923,
 -39768,
 1688529007,
 2918,
 -39767,
 1688704546,
 2919,
 -39766,
 1688767775,
 2927,
 -1,
 1688814935,
 2926,
 1689019572,
 1688059073,
 -1,
 1689085103,
 1688984631,
 -1,
 -39762,
 1689041078,
 2819,
 -1,
 1689103119,
 2893,
 1689281714,
 1688999310,
 -1,
 -39759,
 1689245821,
 2877,
 -1,
 1689293096,
 2818,
 -39757,
 1689227416,
 2876,
 -1,
 1689398745,
 2817,
 1689609399,
 1688933774,
 -1,
 -39754,
 1689571059,
 2903,
 -1,
 1689608701,
 2902,
 -1,
 1689546184,
 2928,
 -1,
 1682331131,
 8886,
 1689937084,
 1682278969,
 -1,
 -39749,
 1689890837,
 64831,
 -1,
 1689941960,
 64830,
 -39747,
 1689896872,
 9766,
 -1,
 1690045743,
 10183,
 1690264815,
 1682226945,
 -1,
 1690330337,
 1690204738,
 -1,
 1690395843,
 1690244494,
 66710,
 -39742,
 1690334952,
 66688,
 -1,
 1690375566,
 66715,
 1690592454,
 1690351536,
 -1,
 -39739,
 1690525143,
 66697,
 -1,
 1690572174,
 66696,
 1690789064,
 1690538482,
 66713,
 -1,
 1690735090,
 66717,
 1690920139,
 1690726646,
 -1,
 -39734,
 1690851601,
 66693,
 -1,
 1690899994,
 66703,
 1691116749,
 1690845351,
 66711,
 -1,
 1691041959,
 66716,
 1691247824,
 1691039276,
 -1,
 -39729,
 1691179281,
 66698,
 -1,
 1691239256,
 66694,
 -39727,
 1691215100,
 66709,
 -39726,
 1691411446,
 66692,
 -39725,
 1691475713,
 66707,
 -39724,
 1691537134,
 66714,
 -39723,
 1691599801,
 66690,
 -39722,
 1691658801,
 66695,
 -39721,
 1691723727,
 66702,
 -39720,
 1691783511,
 66706,
 -39719,
 1691846039,
 66705,
 -39718,
 1691907156,
 66704,
 -39717,
 1691971481,
 66691,
 -39716,
 1692033511,
 66712,
 -39715,
 1692096785,
 66708,
 -39714,
 1692160863,
 66700,
 -39713,
 1692225287,
 66701,
 -39712,
 1692282498,
 66699,
 -1,
 1692346061,
 66689,
 1692598271,
 1690253732,
 -1,
 1692624101,
 1692517240,
 -1,
 -39708,
 1692590689,
 66722,
 -1,
 1692623038,
 66723,
 1692820712,
 1692579760,
 -1,
 -39705,
 1692757852,
 66726,
 -1,
 1692814511,
 66727,
 1693017323,
 1692749470,
 -1,
 -39702,
 1692966002,
 66724,
 -1,
 1693019877,
 66725,
 -39700,
 1692985455,
 66720,
 -39699,
 1693160994,
 66721,
 -39698,
 1693224223,
 66729,
 -1,
 1693271383,
 66728,
 1693476119,
 1690194731,
 -1,
 1693541654,
 1693407828,
 -1,
 1693607187,
 1693481538,
 -1,
 1693672694,
 1693568750,
 -1,
 -39692,
 1693624790,
 5778,
 -39691,
 1693673140,
 5783,
 -1,
 1693721823,
 5766,
 1693934842,
 1693597994,
 -1,
 -39688,
 1693877482,
 5785,
 -39687,
 1693923461,
 5779,
 -1,
 1693985126,
 5781,
 1694196989,
 1693890480,
 -1,
 -39684,
 1694157631,
 5774,
 -1,
 1694177635,
 5764,
 1694393600,
 1694142962,
 -1,
 -39681,
 1694345686,
 5782,
 -1,
 1694404061,
 5777,
 1694590211,
 1694337346,
 -1,
 -39678,
 1694526470,
 5765,
 -1,
 1694585992,
 5773,
 1694786822,
 1694523879,
 -1,
 -39675,
 1694733074,
 5780,
 -1,
 1694781550,
 5784,
 1694983433,
 1694706947,
 -1,
 -39672,
 1694930156,
 5769,
 -1,
 1694975401,
 5770,
 -39670,
 1694943576,
 5768,
 -39669,
 1695135512,
 5775,
 -39668,
 1695195774,
 5786,
 -39667,
 1695254562,
 5771,
 -39666,
 1695317922,
 5762,
 -39665,
 1695373004,
 5772,
 -39664,
 1695436657,
 5763,
 -39663,
 1695495891,
 5767,
 -39662,
 1695557730,
 5761,
 -1,
 1695619469,
 5776,
 -39660,
 1693564816,
 5760,
 -39659,
 1695788540,
 5788,
 -1,
 1695829879,
 5787,
 -1,
 1693488753,
 731,
 1696097578,
 1693425771,
 -1,
 1696163112,
 1696024337,
 -1,
 1696228643,
 1696071680,
 -1,
 1696294175,
 1696149258,
 -1,
 -39652,
 1696253238,
 10044,
 -39651,
 1696281674,
 10011,
 -39650,
 1696344697,
 10027,
 -1,
 1696408617,
 10034,
 1696621858,
 1696252437,
 -1,
 -39647,
 1696572264,
 10180,
 -1,
 1696607283,
 10179,
 -1,
 1696541568,
 9251,
 1696923647,
 1696141030,
 -1,
 1696949543,
 1696805060,
 -1,
 -39642,
 1696887809,
 9104,
 -1,
 1696946431,
 9103,
 -1,
 1696898404,
 10174,
 -39639,
 1696123234,
 8997,
 -1,
 1697162712,
 9741,
 1697342777,
 1696019423,
 -1,
 1697408303,
 1697261211,
 -1,
 -39635,
 1697360673,
 9286,
 -39634,
 1697423236,
 9285,
 -1,
 1697465917,
 9284,
 1697670450,
 1697330732,
 -1,
 -39631,
 1697618901,
 9290,
 -1,
 1697653625,
 9288,
 1697867061,
 1697590531,
 -1,
 -39628,
 1697830814,
 9289,
 -1,
 1697864142,
 9281,
 -39626,
 1697803163,
 9283,
 -39625,
 1697996552,
 9280,
 -39624,
 1698058723,
 9282,
 -1,
 1698110761,
 9287,
 1698325824,
 1697304302,
 -1,
 1698391359,
 1698286018,
 -1,
 -39620,
 1698357205,
 9885,
 -39619,
 1698395747,
 10015,
 -39618,
 1698453525,
 10009,
 -1,
 1698507385,
 10029,
 -1,
 1698335370,
 8485,
 1698784581,
 1698244251,
 -1,
 1698850116,
 1698724834,
 -1,
 -39613,
 1698812840,
 10662,
 -1,
 1698840143,
 10663,
 -1,
 1698787262,
 65532,
 1699112264,
 1698728813,
 -1,
 -39609,
 1699061514,
 11819,
 -1,
 1699116763,
 8228,
 -39607,
 1699076755,
 8254,
 -1,
 1699241646,
 8486,
 1699440478,
 1662429654,
 -1,
 1699505698,
 1699373543,
 -1,
 1699571224,
 1699435833,
 -1,
 1699636649,
 1699479552,
 -1,
 1699702112,
 1699592112,
 -1,
 1699767642,
 1699653818,
 93,
 1699872767,
 1699676160,
 -1,
 1699898711,
 1699799108,
 -1,
 1699964245,
 1699858541,
 -1,
 -39596,
 1699924652,
 10640,
 -1,
 1699949317,
 10638,
 -39594,
 1699926779,
 10636,
 -1,
 1700112742,
 8262,
 -39592,
 1699861764,
 9124,
 -39591,
 1700232900,
 9126,
 -1,
 1700286044,
 9125,
 1700488541,
 1699701223,
 -1,
 -39588,
 1700433031,
 8217,
 -1,
 1700476986,
 11815,
 -39586,
 1700450416,
 11779,
 -39585,
 1700611771,
 8908,
 -1,
 1700663615,
 10182,
 1700881776,
 1699616142,
 -1,
 1700947307,
 1700826210,
 8735,
 1701052415,
 1700855808,
 -1,
 1701078374,
 1700978756,
 -1,
 -39579,
 1701003203,
 9084,
 -1,
 1701060930,
 8894,
 1701274984,
 1700998027,
 12297,
 -1,
 1701186826,
 10642,
 -39575,
 1701239120,
 10652,
 -39574,
 1701364259,
 11776,
 -1,
 1701395526,
 11777,
 1701642239,
 1700899286,
 -1,
 1701668207,
 1701557682,
 -1,
 -39570,
 1701625471,
 8692,
 -1,
 1701654691,
 10228,
 -1,
 1701588260,
 10644,
 1701930362,
 1700847066,
 -1,
 1701995897,
 1701862979,
 -1,
 1702061429,
 1701915907,
 -1,
 -39564,
 1702024855,
 10628,
 -1,
 1702074868,
 12303,
 -39562,
 1702021905,
 12313,
 -39561,
 1702215675,
 12315,
 -39560,
 1702273448,
 10630,
 -1,
 1702328713,
 12311,
 -1,
 1701930284,
 10713,
 1702585731,
 1701853904,
 -1,
 1702651266,
 1702547405,
 -1,
 1702716799,
 1702565262,
 -1,
 -39554,
 1702671964,
 10608,
 -1,
 1702726778,
 12299,
 -39552,
 1702682648,
 10715,
 -39551,
 1702865317,
 8221,
 -1,
 1702928808,
 11817,
 -1,
 1702612182,
 11781,
 1703175563,
 1702505731,
 -1,
 1703241097,
 1703138967,
 125,
 1703346175,
 1703149568,
 -1,
 -39545,
 1703269670,
 9131,
 -39544,
 1703314778,
 9132,
 -1,
 1703378677,
 9133,
 -39542,
 1703188980,
 12301,
 -1,
 1703495074,
 8969,
 1703699858,
 1703134072,
 -1,
 1703765392,
 1703651798,
 -1,
 1703830927,
 1703699164,
 8895,
 -1,
 1703739404,
 10702,
 -1,
 1703747432,
 11786,
 -39535,
 1703713373,
 12309,
 -1,
 1703942032,
 8866,
 1704158615,
 1703649704,
 41,
 1704263679,
 1704067072,
 -1,
 -39531,
 1704187174,
 9118,
 -39530,
 1704230645,
 9120,
 -1,
 1704283740,
 9119,
 1704486298,
 1704123151,
 -1,
 -39527,
 1704435792,
 9145,
 -1,
 1704468651,
 11809,
 1704682909,
 1704432114,
 -1,
 -39524,
 1704646635,
 10198,
 -1,
 1704692597,
 9621,
 1704879520,
 1704614398,
 -1,
 -39521,
 1704825560,
 9616,
 -1,
 1704859540,
 9687,
 1705076131,
 1704808094,
 -1,
 -39518,
 1705016822,
 8971,
 -1,
 1705078139,
 10621,
 1705272742,
 1704995361,
 -1,
 -39515,
 1705233169,
 10648,
 -1,
 1705277833,
 12305,
 -39513,
 1705224915,
 11789,
 -39512,
 1705414211,
 8906,
 -1,
 1705475732,
 11805,
 1705666057,
 1699601964,
 -1,
 1705731537,
 1705583239,
 8594,
 1705797072,
 1705639936,
 -1,
 1705862590,
 1705762884,
 -1,
 1705928117,
 1705821048,
 -1,
 1705993650,
 1705843043,
 8611,
 1706098687,
 1705905206,
 -1,
 -39503,
 1706023913,
 10516,
 -1,
 1706048981,
 10517,
 1706295295,
 1705929771,
 -1,
 -39500,
 1706218957,
 11023,
 -1,
 1706245968,
 11022,
 1706452408,
 1705851600,
 -1,
 -39497,
 1706414118,
 8699,
 -1,
 1706478796,
 10513,
 -39495,
 1706417129,
 8696,
 -39494,
 1706607005,
 8603,
 -39493,
 1706665171,
 10565,
 -39492,
 1706720753,
 8620,
 -39491,
 1706778376,
 8618,
 -1,
 1706832783,
 8628,
 1707042246,
 1705821048,
 -1,
 1707107779,
 1706975554,
 -1,
 -39487,
 1707074518,
 10567,
 -39486,
 1707131558,
 11076,
 -1,
 1707169631,
 11075,
 1707409407,
 1707053565,
 -1,
 -39483,
 1707308167,
 10526,
 -1,
 1707352193,
 8677,
 1707566541,
 1706956437,
 -1,
 1707632074,
 1707519427,
 -1,
 -39479,
 1707591869,
 11084,
 -1,
 1707613254,
 11080,
 -39477,
 1707591869,
 10612,
 -39476,
 1707785213,
 10562,
 -1,
 1707809862,
 10613,
 1708025295,
 1707496087,
 8614,
 -1,
 1707936694,
 10528,
 -1,
 1707974205,
 8644,
 -1,
 1705709964,
 10522,
 1708287461,
 1705663266,
 -1,
 1708352996,
 1708253272,
 -1,
 1708418525,
 1708315560,
 -1,
 1708484060,
 1708326912,
 -1,
 1708549594,
 1708398229,
 -1,
 1708615129,
 1708487620,
 -1,
 -39464,
 1708562047,
 10604,
 -1,
 1708606612,
 10600,
 -1,
 1708568950,
 10596,
 -39461,
 1708509661,
 10579,
 -1,
 1708806807,
 10587,
 -1,
 1708449318,
 8640,
 1709113343,
 1708342863,
 -1,
 1709139427,
 1708982272,
 -1,
 -39456,
 1709099485,
 10583,
 -39455,
 1709134487,
 10591,
 -39454,
 1709189253,
 10605,
 -1,
 1709250252,
 10601,
 -1,
 1709104678,
 8641,
 -1,
 1708301906,
 8652,
 1709598198,
 1708245880,
 -1,
 1709663731,
 1709564513,
 -1,
 1709729266,
 1709576134,
 -1,
 1709794801,
 1709646477,
 -1,
 1709860336,
 1709760580,
 -1,
 1709925870,
 1709818919,
 10518,
 1710030847,
 1709837366,
 -1,
 -39443,
 1709956073,
 10519,
 -1,
 1709981141,
 10520,
 -39441,
 1709890537,
 10496,
 -1,
 1710112213,
 10497,
 -1,
 1709789847,
 10501,
 -1,
 1709755415,
 10512,
 -1,
 1709638756,
 8608,
 1710555135,
 1709617843,
 -1,
 -39435,
 1710438170,
 10511,
 -1,
 1710498439,
 8667,
 1710712321,
 1709520428,
 -1,
 1710777856,
 1710660534,
 -1,
 1710843391,
 1710695047,
 8658,
 1710908926,
 1710751744,
 -1,
 1710974461,
 1710874692,
 -1,
 -39428,
 1710939113,
 10499,
 -1,
 1710997917,
 8655,
 -1,
 1710903959,
 10503,
 -1,
 1710821772,
 10524,
 -1,
 1710765850,
 10509,
 -1,
 1710695338,
 8674,
 1711433221,
 1710677466,
 -1,
 1711498756,
 1711365705,
 8680,
 -1,
 1711408105,
 8688,
 -1,
 1711416857,
 8605,
 -39418,
 1711390765,
 8669,
 -39417,
 1711646821,
 11078,
 -39416,
 1711710474,
 8649,
 -1,
 1711773658,
 8702,
 1711957527,
 1705578214,
 -1,
 1712023054,
 1711917589,
 -1,
 -39412,
 1711972198,
 8238,
 -39411,
 1712030397,
 8207,
 -1,
 1712080506,
 8235,
 1712285202,
 1711973743,
 -1,
 -39408,
 1712209048,
 187,
 -39407,
 1712272877,
 10749,
 -1,
 1712332512,
 9002,
 1712547349,
 1712240560,
 -1,
 -39404,
 1712481236,
 10552,
 -1,
 1712544064,
 10153,
 1712783359,
 1712475920,
 4053,
 -1,
 1712655680,
 4055,
 -1,
 1711889054,
 10813,
 1712940574,
 1699515421,
 -1,
 -39398,
 1712891202,
 11824,
 -39397,
 1712953346,
 8728,
 -39396,
 1713006545,
 8790,
 -39395,
 1713064231,
 8791,
 -1,
 1713116815,
 730,
 1713333793,
 1712897322,
 -1,
 -39392,
 1713291129,
 10544,
 -1,
 1713327924,
 10539,
 -1,
 1713248823,
 65020,
 1713596086,
 1699466990,
 -1,
 1713661570,
 1713540330,
 -1,
 1713727100,
 1713601090,
 -1,
 1713792563,
 1713682352,
 -1,
 1713858096,
 1713725512,
 -1,
 -39384,
 1713825644,
 5863,
 -39383,
 1713884904,
 5840,
 -39382,
 1713946403,
 5836,
 -39381,
 1714002599,
 5805,
 -39380,
 1714063948,
 5823,
 -39379,
 1714127044,
 5849,
 -39378,
 1714182514,
 5821,
 -39377,
 1714235891,
 5843,
 -1,
 1714299012,
 5830,
 -39375,
 1713816740,
 5861,
 -39374,
 1714462757,
 5834,
 -1,
 1714513168,
 5835,
 1714710073,
 1713738226,
 5806,
 -39371,
 1714669277,
 5855,
 -39370,
 1714731003,
 5801,
 -39369,
 1714791078,
 5845,
 -39368,
 1714850114,
 5808,
 -1,
 1714897063,
 5807,
 1715103297,
 1714648004,
 -1,
 1715168832,
 1715050148,
 -1,
 -39364,
 1715136364,
 5862,
 -39363,
 1715182247,
 5804,
 -39362,
 1715241156,
 5848,
 -39361,
 1715296626,
 5820,
 -1,
 1715347593,
 5829,
 -1,
 1715086790,
 5850,
 1715627592,
 1715036647,
 -1,
 1715693124,
 1715571738,
 5853,
 -1,
 1715658520,
 5852,
 -39355,
 1715658524,
 5831,
 -39354,
 1715779802,
 5825,
 -39353,
 1715837048,
 5857,
 -1,
 1715875551,
 5864,
 1716086349,
 1715552423,
 5826,
 -39350,
 1716045491,
 5799,
 -39349,
 1716096026,
 5814,
 -39348,
 1716150718,
 5846,
 -1,
 1716199553,
 5856,
 1716414035,
 1716008492,
 5841,
 1716479570,
 1716362133,
 -1,
 -39344,
 1716428907,
 5844,
 -39343,
 1716488514,
 5824,
 -1,
 1716548548,
 5851,
 -1,
 1716394180,
 5854,
 1716807257,
 1716333827,
 5837,
 1716872791,
 1716732071,
 -1,
 -39338,
 1716816194,
 5811,
 -1,
 1716853440,
 5860,
 -39336,
 1716838199,
 5858,
 -1,
 1716984512,
 5859,
 1717200478,
 1716736811,
 5813,
 1717266013,
 1717125287,
 -1,
 -39332,
 1717217750,
 5828,
 -1,
 1717250760,
 5815,
 -1,
 1717182593,
 5816,
 1717528163,
 1717114254,
 -1,
 -39328,
 1717473129,
 5800,
 -39327,
 1717533371,
 5833,
 -39326,
 1717586574,
 5803,
 -1,
 1717644549,
 5802,
 1717855845,
 1717494976,
 5796,
 -1,
 1717807574,
 5795,
 1717986919,
 1717820890,
 5797,
 -1,
 1717949291,
 5817,
 1718117994,
 1717945208,
 -1,
 -39319,
 1718054725,
 5839,
 -1,
 1718116763,
 5798,
 1718314605,
 1718055405,
 -1,
 -39316,
 1718228366,
 5810,
 -1,
 1718289648,
 5812,
 1718511216,
 1718245649,
 -1,
 -39313,
 1718441530,
 5818,
 -1,
 1718502621,
 5819,
 -39311,
 1718478840,
 5838,
 -39310,
 1718674390,
 5866,
 -39309,
 1718736998,
 5793,
 -39308,
 1718802201,
 5794,
 -39307,
 1718856375,
 5809,
 -39306,
 1718921158,
 5865,
 -39305,
 1718985625,
 5832,
 -39304,
 1719044691,
 5822,
 -39303,
 1719108235,
 5847,
 -39302,
 1719169081,
 5827,
 -39301,
 1719226308,
 5792,
 -1,
 1719281856,
 5842,
 -39299,
 1713688039,
 5871,
 -39298,
 1719450979,
 5867,
 -39297,
 1719502920,
 5868,
 -39296,
 1719546960,
 5869,
 -39295,
 1719609448,
 5872,
 -1,
 1719673395,
 5870,
 1719887540,
 1713603831,
 -1,
 1719953057,
 1719832738,
 -1,
 1720018572,
 1719911288,
 -1,
 1720084104,
 1719983578,
 -1,
 -39289,
 1720029697,
 69235,
 -1,
 1720076399,
 69226,
 1720280715,
 1720015091,
 -1,
 -39286,
 1720233190,
 69236,
 -1,
 1720282436,
 69227,
 -1,
 1720207121,
 69225,
 1720542867,
 1719973808,
 -1,
 1720608400,
 1720479580,
 -1,
 -39281,
 1720569549,
 69230,
 -1,
 1720583286,
 69239,
 1720844287,
 1720536239,
 -1,
 -39278,
 1720766157,
 69231,
 -1,
 1720779894,
 69240,
 1721001626,
 1720471198,
 -1,
 1721067159,
 1720947186,
 -1,
 -39274,
 1721030193,
 69237,
 -1,
 1721087735,
 69228,
 1721303039,
 1721000423,
 -1,
 -39271,
 1721227730,
 69238,
 -1,
 1721258758,
 69229,
 1721460381,
 1720945951,
 -1,
 -39268,
 1721421517,
 69233,
 -1,
 1721435254,
 69242,
 1721656992,
 1721386327,
 -1,
 -39265,
 1721623744,
 69232,
 -1,
 1721631862,
 69241,
 -1,
 1721603661,
 69234,
 1721919150,
 1719876004,
 -1,
 1721984677,
 1721877368,
 -1,
 -39260,
 1721950817,
 69217,
 -1,
 1721983166,
 69218,
 1722181288,
 1721939888,
 -1,
 -39257,
 1722117980,
 69221,
 -1,
 1722174639,
 69222,
 1722377899,
 1722109598,
 -1,
 -39254,
 1722326130,
 69219,
 -1,
 1722380005,
 69220,
 -39252,
 1722324514,
 69216,
 -39251,
 1722518815,
 69224,
 -1,
 1722565975,
 69223,
 1722810367,
 1721848427,
 -1,
 1722836659,
 1722717734,
 -1,
 -39247,
 1722795875,
 69245,
 -39246,
 1722853591,
 69244,
 -1,
 1722898931,
 69243,
 -1,
 1722797731,
 69246,
 -39243,
 1719837278,
 8360,
 -1,
 1723102928,
 10740,
 1723295515,
 1713520807,
 -1,
 1723360998,
 1723232156,
 -1,
 1723426516,
 1723300418,
 -1,
 1723492034,
 1723369794,
 -1,
 1723557565,
 1723458752,
 -1,
 -39236,
 1723494297,
 43333,
 -1,
 1723536782,
 43323,
 1723754176,
 1723487019,
 -1,
 -39233,
 1723683679,
 43331,
 -1,
 1723733390,
 43314,
 -39231,
 1723676311,
 43332,
 -1,
 1723864462,
 43317,
 1724081861,
 1723433032,
 -1,
 -39228,
 1723999949,
 43330,
 -1,
 1724061070,
 43320,
 -39226,
 1724048636,
 43327,
 -39225,
 1724243458,
 43328,
 -39224,
 1724302265,
 43315,
 -39223,
 1724364842,
 43324,
 -39222,
 1724426801,
 43325,
 -39221,
 1724489936,
 43318,
 -39220,
 1724544025,
 43326,
 -39219,
 1724608781,
 43312,
 -39218,
 1724673945,
 43322,
 -39217,
 1724733713,
 43329,
 -39216,
 1724797791,
 43313,
 -39215,
 1724855959,
 43316,
 -39214,
 1724919136,
 43321,
 -39213,
 1724982989,
 43319,
 -1,
 1725044110,
 43334,
 1725261536,
 1723390054,
 -1,
 1725327071,
 1725210552,
 -1,
 1725392601,
 1725251751,
 43337,
 -39208,
 1725353710,
 43341,
 -1,
 1725371790,
 43342,
 1725589212,
 1725306254,
 -1,
 -39205,
 1725550318,
 43340,
 -1,
 1725587943,
 43338,
 -39203,
 1725550318,
 43336,
 -39202,
 1725731314,
 43339,
 -1,
 1725784551,
 43335,
 -1,
 1725262976,
 43347,
 1726047973,
 1725182655,
 -1,
 1726113507,
 1725991234,
 43344,
 -1,
 1726042923,
 43343,
 -39196,
 1726065110,
 43345,
 -1,
 1726175475,
 43346,
 -1,
 1726003562,
 43359,
 1726441222,
 1723325117,
 -1,
 1726506749,
 1726363182,
 -1,
 1726572268,
 1726464888,
 -1,
 1726637803,
 1726506599,
 8765,
 -1,
 1726546868,
 8909,
 -1,
 1726591713,
 8247,
 1726834416,
 1726495855,
 -1,
 1726899951,
 1726785261,
 8246,
 -1,
 1726810542,
 12317,
 -1,
 1726857670,
 10989,
 1727096563,
 1726789552,
 -1,
 -39182,
 1727022752,
 8271,
 -1,
 1727078221,
 8515,
 1727293174,
 1727045739,
 -1,
 -39179,
 1727246892,
 8245,
 -1,
 1727293019,
 8267,
 1727489784,
 1727209178,
 10659,
 -1,
 1727401665,
 10661,
 -39175,
 1727444306,
 9753,
 -39174,
 1727572288,
 11822,
 -39173,
 1727631084,
 8976,
 -39172,
 1727681000,
 11793,
 -1,
 1727743744,
 10672,
 1727987711,
 1726414848,
 -1,
 1728014083,
 1727905590,
 92,
 1728118783,
 1727922176,
 -1,
 -39167,
 1728045317,
 10743,
 -39166,
 1728095904,
 10184,
 -1,
 1728157698,
 10741,
 1728380927,
 1727973580,
 -1,
 -39163,
 1728295212,
 11079,
 -1,
 1728346293,
 11073,
 1728538386,
 1726363175,
 -1,
 1728603921,
 1728473416,
 -1,
 1728669456,
 1728564962,
 -1,
 -39158,
 1728582909,
 9849,
 -39157,
 1728648364,
 9848,
 -39156,
 1728713822,
 9847,
 -39155,
 1728779253,
 9846,
 -39154,
 1728844698,
 9845,
 -39153,
 1728910063,
 9844,
 -1,
 1728975478,
 9843,
 -1,
 1728599212,
 9850,
 -1,
 1728529115,
 9852,
 1729324823,
 1728493488,
 -1,
 1729390358,
 1729285097,
 -1,
 -39147,
 1729303233,
 9953,
 -1,
 1729368617,
 9952,
 -1,
 1729340877,
 8479,
 -39144,
 1729285508,
 9166,
 -39143,
 1729602682,
 65533,
 -39142,
 1729648149,
 174,
 -1,
 1729712114,
 8251,
 1729914707,
 1723240946,
 -1,
 1729980239,
 1729856093,
 -1,
 1730045759,
 1729925325,
 -1,
 1730111273,
 1729973918,
 -1,
 1730176808,
 1730044391,
 -1,
 1730242340,
 1730140594,
 8548,
 1730347007,
 1730150400,
 -1,
 -39133,
 1730267073,
 8577,
 -1,
 1730306431,
 8558,
 1730543615,
 1730171654,
 8556,
 1730609151,
 1730412544,
 -1,
 -39129,
 1730529217,
 8583,
 -1,
 1730560377,
 8582,
 -1,
 1730124914,
 8547,
 1730832176,
 1730069368,
 -1,
 1730897709,
 1730797018,
 -1,
 -39124,
 1730843122,
 8545,
 -1,
 1730889293,
 8555,
 1731094319,
 1730823953,
 8553,
 -1,
 1731005156,
 8578,
 -1,
 1731027134,
 8546,
 1731290934,
 1730778658,
 8544,
 1731395583,
 1731198976,
 -1,
 1731422004,
 1731315649,
 8559,
 -1,
 1731330682,
 8576,
 1731592191,
 1731355007,
 8557,
 -1,
 1731463908,
 8584,
 1731684154,
 1731246000,
 -1,
 1731749689,
 1731620700,
 8549,
 -1,
 1731659121,
 8581,
 -1,
 1731677359,
 8550,
 1731946301,
 1731608743,
 -1,
 -39108,
 1731885704,
 8554,
 -1,
 1731945803,
 8551,
 -39106,
 1731898909,
 8579,
 -1,
 1732087071,
 8552,
 1732273991,
 1730000816,
 -1,
 1732339526,
 1732198567,
 -1,
 1732405060,
 1732306069,
 -1,
 -39101,
 1732366685,
 65939,
 -1,
 1732386598,
 65936,
 -39099,
 1732362546,
 65944,
 -1,
 1732544681,
 65938,
 -1,
 1732273821,
 65941,
 1732798283,
 1732195884,
 -1,
 -39095,
 1732760815,
 65945,
 -39094,
 1732798255,
 65940,
 -1,
 1732855630,
 65942,
 -39092,
 1732760240,
 65937,
 -39091,
 1733011820,
 65943,
 -39090,
 1733046055,
 65947,
 -1,
 1733108563,
 65946,
 1733361663,
 1729938669,
 -1,
 -39087,
 1733254206,
 10085,
 -39086,
 1733317009,
 10087,
 -1,
 1733373497,
 8506,
 1733623807,
 1729828238,
 -1,
 1733650266,
 1733517799,
 -1,
 1733715801,
 1733605764,
 -1,
 -39081,
 1733672948,
 11787,
 -39080,
 1733716581,
 11782,
 -1,
 1733770255,
 11783,
 -1,
 1733658946,
 9926,
 1734043485,
 1733572759,
 -1,
 -39076,
 1733988925,
 9762,
 -1,
 1734028663,
 9143,
 -1,
 1734003038,
 8758,
 1734306144,
 1699389547,
 -1,
 1734371365,
 1734219150,
 -1,
 1734436895,
 1734322646,
 -1,
 1734502416,
 1734363179,
 -1,
 1734567833,
 1734440495,
 -1,
 1734633342,
 1734524583,
 -1,
 -39067,
 1734600696,
 9397,
 -39066,
 1734665408,
 9396,
 -39065,
 1734730710,
 9395,
 -39064,
 1734794714,
 9394,
 -39063,
 1734858854,
 9393,
 -39062,
 1734921966,
 9392,
 -39061,
 1734984568,
 9391,
 -39060,
 1735047088,
 9390,
 -39059,
 1735109078,
 9389,
 -39058,
 1735174086,
 9388,
 -39057,
 1735237739,
 9387,
 -39056,
 1735299570,
 9386,
 -39055,
 1735362882,
 9385,
 -39054,
 1735426120,
 9384,
 -39053,
 1735488452,
 9383,
 -39052,
 1735553270,
 9382,
 -39051,
 1735618455,
 9381,
 -39050,
 1735680487,
 9380,
 -39049,
 1735743731,
 9379,
 -39048,
 1735807787,
 9378,
 -39047,
 1735872158,
 9377,
 -39046,
 1735934119,
 9376,
 -39045,
 1735996972,
 9375,
 -39044,
 1736060163,
 9374,
 -39043,
 1736124059,
 9373,
 -1,
 1736185230,
 9372,
 1736441855,
 1734553129,
 -1,
 -39040,
 1736370168,
 127273,
 -39039,
 1736434880,
 127272,
 -39038,
 1736500182,
 127271,
 -39037,
 1736564186,
 127270,
 -39036,
 1736628326,
 127269,
 -39035,
 1736691438,
 127268,
 -39034,
 1736754040,
 127267,
 -39033,
 1736816560,
 127266,
 -39032,
 1736878550,
 127265,
 -39031,
 1736943558,
 127264,
 -39030,
 1737007211,
 127263,
 -39029,
 1737069042,
 127262,
 -39028,
 1737132354,
 127261,
 -39027,
 1737195592,
 127260,
 -39026,
 1737257924,
 127259,
 -39025,
 1737322742,
 127258,
 -39024,
 1737387927,
 127257,
 -39023,
 1737449959,
 127256,
 -39022,
 1737513203,
 127255,
 -39021,
 1737577259,
 127254,
 -39020,
 1737641630,
 127253,
 -39019,
 1737703591,
 127252,
 -39018,
 1737766444,
 127251,
 -39017,
 1737829635,
 127250,
 -39016,
 1737893531,
 127249,
 -1,
 1737954702,
 127248,
 1738172364,
 1734501407,
 -1,
 1738237863,
 1738127280,
 -1,
 1738303390,
 1738198766,
 -1,
 -39011,
 1738253225,
 12860,
 -1,
 1738312002,
 12848,
 1738500001,
 1738261368,
 -1,
 -39008,
 1738461358,
 12859,
 -1,
 1738511064,
 12849,
 1738696612,
 1738424487,
 -1,
 -39005,
 1738660417,
 12838,
 -1,
 1738701470,
 12866,
 -39003,
 1738646080,
 12853,
 -39002,
 1738838737,
 12851,
 -1,
 1738895196,
 12837,
 1739089838,
 1738165918,
 -1,
 1739155372,
 1739022823,
 -1,
 -38998,
 1739119026,
 12836,
 -38997,
 1739172870,
 12843,
 -1,
 1739229681,
 12854,
 -38995,
 1739103346,
 12835,
 -1,
 1739344738,
 12864,
 1739548596,
 1739041798,
 -1,
 1739614130,
 1739503536,
 -1,
 -38991,
 1739572088,
 12865,
 -1,
 1739627761,
 12862,
 -38989,
 1739564760,
 12857,
 -1,
 1739724668,
 12867,
 1739941816,
 1739506552,
 -1,
 -38986,
 1739907681,
 12833,
 -38985,
 1739940030,
 12834,
 -1,
 1739998993,
 12841,
 1740203964,
 1739866279,
 -1,
 -38982,
 1740148714,
 12861,
 -38981,
 1740203339,
 12839,
 -1,
 1740251889,
 12847,
 1740466111,
 1740168666,
 -1,
 -38978,
 1740412700,
 12845,
 -1,
 1740448975,
 12844,
 1740662722,
 1740409154,
 -1,
 -38975,
 1740597450,
 12840,
 -1,
 1740643560,
 12852,
 1740859333,
 1740603464,
 -1,
 -38972,
 1740805931,
 12842,
 -1,
 1740852125,
 12846,
 1741055944,
 1740778755,
 -1,
 -38969,
 1741002421,
 12855,
 -1,
 1741036489,
 12858,
 -38967,
 1741002274,
 12832,
 -38966,
 1741190247,
 12856,
 -38965,
 1741249397,
 12850,
 -1,
 1741298710,
 12863,
 1741514735,
 1738103482,
 -1,
 1741580244,
 1741434115,
 -1,
 1741645778,
 1741513891,
 12808,
 1741750271,
 1741553664,
 -1,
 -38959,
 1741672174,
 12828,
 -1,
 1741690254,
 12822,
 1741946879,
 1741577519,
 12809,
 -1,
 1741815810,
 12823,
 1742039001,
 1741538168,
 -1,
 1742104535,
 1741973021,
 12802,
 -1,
 1742012418,
 12816,
 1742274559,
 1742036298,
 12811,
 -1,
 1742143490,
 12825,
 1742366686,
 1741987947,
 -1,
 1742432220,
 1742300334,
 12805,
 -1,
 1742340098,
 12819,
 1742602239,
 1742363971,
 12812,
 -1,
 1742471170,
 12826,
 1742694371,
 1742303478,
 -1,
 1742759905,
 1742630801,
 12800,
 -1,
 1742667778,
 12814,
 1742929919,
 1742691644,
 12810,
 -1,
 1742798850,
 12824,
 1743022053,
 1742650791,
 12806,
 -1,
 1742929922,
 12820,
 1743153127,
 1742974692,
 12803,
 -1,
 1743060994,
 12817,
 1743284201,
 1743097071,
 12801,
 -1,
 1743192066,
 12815,
 1743415275,
 1743226257,
 12804,
 -1,
 1743323138,
 12818,
 1743546349,
 1743348904,
 12807,
 -1,
 1743454210,
 12821,
 1743716351,
 1743478070,
 12813,
 -1,
 1743585282,
 12827,
 1743808512,
 1741459618,
 -1,
 1743874038,
 1743766392,
 -1,
 1743939572,
 1743839012,
 -1,
 -38925,
 1743884392,
 9351,
 -1,
 1743945713,
 9343,
 -38923,
 1743871513,
 9344,
 -1,
 1744062225,
 9341,
 1744267257,
 1743828912,
 -1,
 -38920,
 1744203630,
 9347,
 -1,
 1744260317,
 9348,
 1744463868,
 1744195230,
 -1,
 -38917,
 1744411895,
 9345,
 -1,
 1744463061,
 9346,
 1744660479,
 1744388263,
 -1,
 -38914,
 1744599688,
 9342,
 -1,
 1744659817,
 9349,
 -1,
 1744604452,
 9350,
 1744922637,
 1743731108,
 -1,
 1744988164,
 1744880504,
 -1,
 -38909,
 1744953953,
 9333,
 -1,
 1744986302,
 9334,
 1745184775,
 1744943024,
 -1,
 -38906,
 1745121116,
 9337,
 -1,
 1745177775,
 9338,
 1745381386,
 1745112734,
 -1,
 -38903,
 1745329266,
 9335,
 -1,
 1745383141,
 9336,
 -38901,
 1745327650,
 9332,
 -38900,
 1745521951,
 9340,
 -1,
 1745569111,
 9339,
 1745813503,
 1744859942,
 -1,
 -38897,
 1745711152,
 12829,
 -1,
 1745749106,
 12830,
 1745971225,
 1734415758,
 -1,
 1746036758,
 1745911003,
 -1,
 1746102293,
 1746001988,
 -1,
 -38892,
 1746061501,
 10995,
 -1,
 1746100190,
 10994,
 -1,
 1746061782,
 8741,
 1746403327,
 1745966878,
 -1,
 -38888,
 1746311810,
 11791,
 -1,
 1746340379,
 8233,
 1746599935,
 1745929080,
 -1,
 1746626589,
 1746494098,
 -1,
 -38884,
 1746567207,
 9853,
 -1,
 1746600764,
 8706,
 -38882,
 1746570225,
 12880,
 -1,
 1746731102,
 12349,
 1746954274,
 1734394012,
 -1,
 -38879,
 1746916504,
 9106,
 -1,
 1746943805,
 9105,
 1747189759,
 1746891716,
 -1,
 -38876,
 1747091540,
 11801,
 -1,
 1747154410,
 9908,
 1747347673,
 1734301939,
 -1,
 1747413169,
 1747260814,
 -1,
 1747478641,
 1747343486,
 -1,
 1747544165,
 1747417666,
 -1,
 1747609650,
 1747501944,
 -1,
 1747675181,
 1747567480,
 -1,
 -38868,
 1747605777,
 43114,
 -1,
 1747654030,
 43113,
 1747871792,
 1747630000,
 -1,
 -38865,
 1747802385,
 43089,
 -1,
 1747850638,
 43088,
 -38863,
 1747802385,
 43081,
 -1,
 1747981710,
 43080,
 1748199479,
 1747552578,
 -1,
 -38860,
 1748165884,
 43079,
 -38859,
 1748208030,
 43116,
 -38858,
 1748259679,
 43075,
 -1,
 1748309390,
 43083,
 1748527163,
 1748154288,
 -1,
 -38855,
 1748468103,
 43094,
 -38854,
 1748523281,
 43098,
 -1,
 1748571534,
 43099,
 1748789311,
 1748448812,
 -1,
 -38851,
 1748756490,
 43090,
 -38850,
 1748776599,
 43115,
 -1,
 1748833678,
 43082,
 1749051459,
 1748708611,
 -1,
 1749116994,
 1748964750,
 43076,
 -1,
 1749060444,
 43123,
 -1,
 1749047569,
 43077,
 1749313606,
 1748964750,
 43101,
 -38843,
 1749270470,
 43120,
 -1,
 1749319528,
 43117,
 1749510217,
 1749280760,
 -1,
 -38840,
 1749440785,
 43092,
 -1,
 1749489038,
 43093,
 1749706828,
 1749474548,
 -1,
 -38837,
 1749645742,
 43118,
 -1,
 1749694015,
 43119,
 1749903439,
 1749655659,
 -1,
 -38834,
 1749834001,
 43085,
 -1,
 1749882254,
 43084,
 1750100050,
 1749840118,
 -1,
 -38831,
 1750030609,
 43073,
 -1,
 1750078862,
 43072,
 1750296661,
 1750029099,
 -1,
 -38828,
 1750225759,
 43109,
 -1,
 1750275470,
 43074,
 1750493271,
 1750220967,
 43104,
 -1,
 1750417575,
 43110,
 -38824,
 1750459644,
 43095,
 -38823,
 1750590454,
 43107,
 -38822,
 1750654466,
 43091,
 -38821,
 1750716142,
 43103,
 -38820,
 1750772273,
 43096,
 -38819,
 1750837196,
 43106,
 -38818,
 1750897138,
 43105,
 -38817,
 1750958229,
 43087,
 -38816,
 1751020569,
 43097,
 -38815,
 1751084953,
 43078,
 -38814,
 1751146983,
 43102,
 -38813,
 1751210257,
 43100,
 -38812,
 1751273223,
 43108,
 -1,
 1751328461,
 43086,
 1751541869,
 1747498928,
 -1,
 1751607404,
 1751502574,
 -1,
 1751672939,
 1751525885,
 -1,
 -38807,
 1751639292,
 43112,
 -38806,
 1751703042,
 43111,
 -1,
 1751755313,
 43121,
 -1,
 1751622444,
 43122,
 -1,
 1751542118,
 43124,
 1752066160,
 1751483074,
 -1,
 -38801,
 1752021752,
 43126,
 -1,
 1752055187,
 43127,
 -1,
 1751989537,
 43125,
 1752367103,
 1747414492,
 -1,
 1752393853,
 1752247555,
 -1,
 1752459383,
 1752338930,
 -1,
 1752524918,
 1752400670,
 66020,
 -1,
 1752459694,
 66045,
 -1,
 1752465327,
 66022,
 1752721531,
 1752372622,
 -1,
 -38791,
 1752679288,
 66028,
 -38790,
 1752741321,
 66018,
 -1,
 1752803170,
 66003,
 -38788,
 1752661901,
 66012,
 -1,
 1752915420,
 66004,
 1753114757,
 1752348592,
 -1,
 1753180289,
 1753046257,
 -1,
 -38784,
 1753129067,
 66024,
 -1,
 1753171455,
 66011,
 -38782,
 1753140047,
 66042,
 -38781,
 1753317774,
 66043,
 -38780,
 1753381827,
 66021,
 -1,
 1753425466,
 66015,
 1753639052,
 1753032347,
 -1,
 1753704585,
 1753584114,
 -1,
 -38776,
 1753669082,
 66010,
 -1,
 1753716052,
 66017,
 1753901195,
 1753629511,
 66033,
 -1,
 1753833090,
 66023,
 -1,
 1753862599,
 66027,
 1754097810,
 1753587819,
 -1,
 1754163344,
 1754035140,
 -1,
 -38769,
 1754124890,
 66001,
 -1,
 1754144370,
 66034,
 -38767,
 1754088186,
 66000,
 -1,
 1754275962,
 66036,
 1754491030,
 1754055544,
 -1,
 -38764,
 1754452866,
 66032,
 -38763,
 1754489642,
 66008,
 -1,
 1754539423,
 66002,
 1754753178,
 1754421491,
 -1,
 -38760,
 1754700257,
 66025,
 -38759,
 1754751924,
 66026,
 -1,
 1754809903,
 66006,
 1755015325,
 1754717658,
 -1,
 -38756,
 1754961196,
 66005,
 -1,
 1754998321,
 66044,
 1755211936,
 1754966486,
 -1,
 -38753,
 1755159173,
 66037,
 -1,
 1755192460,
 66029,
 1755408547,
 1755152533,
 -1,
 -38750,
 1755368731,
 66014,
 -1,
 1755417021,
 66013,
 1755605158,
 1755347672,
 -1,
 -38747,
 1755545627,
 66038,
 -1,
 1755592236,
 66016,
 1755801769,
 1755534123,
 -1,
 -38744,
 1755753334,
 66041,
 -1,
 1755784677,
 66007,
 1755998380,
 1755724496,
 -1,
 -38741,
 1755961778,
 66031,
 -1,
 1756003403,
 66019,
 -38739,
 1755962497,
 66035,
 -38738,
 1756143688,
 66039,
 -38737,
 1756189110,
 66040,
 -38736,
 1756250422,
 66030,
 -1,
 1756308103,
 66009,
 1756522710,
 1747358536,
 -1,
 1756588236,
 1756461634,
 -1,
 1756653751,
 1756542896,
 -1,
 -38731,
 1756585451,
 67860,
 -38730,
 1756645082,
 67854,
 -1,
 1756698663,
 67857,
 1756915898,
 1756611448,
 -1,
 -38727,
 1756842858,
 67848,
 -1,
 1756898740,
 67861,
 1757112508,
 1756846992,
 67844,
 -1,
 1757070200,
 67847,
 1757243583,
 1757025678,
 -1,
 -38722,
 1757182622,
 67840,
 -1,
 1757243288,
 67855,
 -38720,
 1757210652,
 67846,
 -38719,
 1757406983,
 67849,
 -38718,
 1757470416,
 67845,
 -38717,
 1757525267,
 67859,
 -38716,
 1757587505,
 67858,
 -38715,
 1757651503,
 67856,
 -38714,
 1757712650,
 67853,
 -38713,
 1757774922,
 67852,
 -38712,
 1757836614,
 67851,
 -38711,
 1757901106,
 67850,
 -38710,
 1757959104,
 67842,
 -38709,
 1758017466,
 67843,
 -1,
 1758079288,
 67841,
 1758292181,
 1756532898,
 -1,
 1758357715,
 1758249848,
 -1,
 1758423249,
 1758322138,
 -1,
 -38704,
 1758368242,
 67866,
 -1,
 1758414959,
 67864,
 -38702,
 1758355646,
 67867,
 -1,
 1758545681,
 67863,
 1758789631,
 1758303778,
 67862,
 -1,
 1758659702,
 67865,
 -1,
 1758258075,
 67871,
 1758986239,
 1756456595,
 -1,
 -38696,
 1758903651,
 5941,
 -1,
 1758936448,
 5942,
 1759144229,
 1747298774,
 -1,
 1759209756,
 1759068327,
 -1,
 1759275275,
 1759164336,
 -1,
 1759340810,
 1759201271,
 -1,
 1759406316,
 1759293172,
 -1,
 1759471843,
 1759371137,
 -1,
 1759537378,
 1759410554,
 -1,
 -38687,
 1759474207,
 65048,
 -1,
 1759523193,
 983049,
 -1,
 1759458176,
 65092,
 1759799526,
 1759390979,
 -1,
 -38683,
 1759762071,
 65080,
 -1,
 1759812084,
 65090,
 -38681,
 1759759121,
 65082,
 -38680,
 1759952891,
 65096,
 -38679,
 1760010664,
 65078,
 -38678,
 1760050307,
 65086,
 -38677,
 1760111169,
 65084,
 -1,
 1760173792,
 65088,
 1760389371,
 1759343556,
 -1,
 1760454906,
 1760314302,
 -1,
 1760520433,
 1760419713,
 -1,
 -38672,
 1760459145,
 65047,
 -1,
 1760506752,
 65091,
 1760717044,
 1760439555,
 -1,
 -38669,
 1760679575,
 65079,
 -1,
 1760729588,
 65089,
 -38667,
 1760676625,
 65081,
 -38666,
 1760870395,
 65095,
 -38665,
 1760928168,
 65077,
 -38664,
 1760967811,
 65085,
 -38663,
 1761028673,
 65083,
 -1,
 1761091296,
 65087,
 -1,
 1760403318,
 65075,
 1761372415,
 1760313511,
 -1,
 -38659,
 1761338392,
 65045,
 -38658,
 1761380679,
 65074,
 -1,
 1761443940,
 65073,
 1761634562,
 1761305642,
 -1,
 -38655,
 1761563402,
 65042,
 -1,
 1761620540,
 65041,
 1761831173,
 1761554956,
 -1,
 -38652,
 1761773146,
 65040,
 -1,
 1761836405,
 65043,
 -38650,
 1761795813,
 65076,
 -38649,
 1761988106,
 65072,
 -38648,
 1762048495,
 65044,
 -38647,
 1762109760,
 65046,
 -1,
 1762156422,
 65049,
 -1,
 1759261717,
 8478,
 1762421019,
 1759194841,
 8826,
 1762525183,
 1762328576,
 -1,
 1762552086,
 1762399893,
 -1,
 1762617617,
 1762508150,
 -1,
 -38640,
 1762561736,
 10929,
 -1,
 1762609523,
 10927,
 1762814228,
 1762561705,
 -1,
 -38637,
 1762740519,
 10933,
 -1,
 1762794566,
 10937,
 -38635,
 1762740595,
 10931,
 -1,
 1762925638,
 10935,
 1763141913,
 1762498687,
 -1,
 -38632,
 1763077844,
 8830,
 -1,
 1763121738,
 8828,
 -38630,
 1763103468,
 8880,
 -1,
 1763257518,
 8936,
 -1,
 1762385030,
 9111,
 1763535138,
 1759154674,
 -1,
 1763600673,
 1763483755,
 -1,
 1763666208,
 1763547734,
 8759,
 -1,
 1763580490,
 8733,
 -1,
 1763592814,
 8522,
 -1,
 1763536869,
 8965,
 1763966975,
 1763467751,
 -1,
 -38620,
 1763872655,
 9113,
 -1,
 1763935102,
 8242,
 1764124991,
 1759081412,
 -1,
 1764190523,
 1764085486,
 -1,
 1764256058,
 1764145072,
 -1,
 1764321593,
 1764166200,
 43,
 1764425727,
 1764229120,
 -1,
 1764452660,
 1764352068,
 -1,
 1764518190,
 1764411558,
 -1,
 -38611,
 1764436088,
 10790,
 -1,
 1764497039,
 10788,
 1764714801,
 1764472752,
 -1,
 -38608,
 1764675673,
 10791,
 -1,
 1764721073,
 10786,
 -38606,
 1764637531,
 10789,
 -38605,
 1764831490,
 10787,
 -1,
 1764895364,
 10792,
 1765108024,
 1764386715,
 -1,
 -38602,
 1765067678,
 10809,
 -38601,
 1765126082,
 10798,
 -1,
 1765177211,
 10797,
 -1,
 1765021351,
 10866,
 -1,
 1764233363,
 177,
 -1,
 1764215254,
 9799,
 1765605375,
 1764103566,
 -1,
 1765632318,
 1765509795,
 8462,
 -1,
 1765541979,
 8463,
 -1,
 1765551792,
 8984,
 1765828945,
 1764049063,
 -1,
 1765894476,
 1765779926,
 -1,
 1765960005,
 1765801984,
 -1,
 -38589,
 1765918163,
 8241,
 -38588,
 1765981372,
 8524,
 -1,
 1766032808,
 8240,
 1766222152,
 1765914544,
 -1,
 -38585,
 1766171207,
 8966,
 -1,
 1766233528,
 9977,
 1766418762,
 1766171315,
 10178,
 -1,
 1766329942,
 10977,
 -38581,
 1766359658,
 9854,
 -1,
 1766469376,
 37,
 1766680911,
 1765849008,
 -1,
 -38578,
 1766625830,
 8369,
 -1,
 1766673289,
 8359,
 -38576,
 1766623902,
 9999,
 -1,
 1766791025,
 9774,
 1767008600,
 1765761511,
 -1,
 1767074132,
 1766966551,
 8916,
 -1,
 1766985354,
 10970,
 -38571,
 1767029001,
 9811,
 -38570,
 1767149969,
 10031,
 -38569,
 1767208599,
 182,
 -1,
 1767256388,
 9935,
 1767467359,
 1766953458,
 -1,
 1767532893,
 1767421872,
 -1,
 1767598428,
 1767490643,
 12306,
 -1,
 1767506887,
 12320,
 -1,
 1767534218,
 8982,
 -38562,
 1767494365,
 163,
 -1,
 1767743610,
 8236,
 -1,
 1767428807,
 8200,
 1767992020,
 1734248770,
 -1,
 1768057349,
 1767915687,
 -1,
 1768122833,
 1768021468,
 -1,
 1768188368,
 1768080407,
 -1,
 1768253863,
 1768127042,
 -1,
 1768319362,
 1768193670,
 -1,
 1768384874,
 1768276856,
 -1,
 -38552,
 1768339498,
 6539,
 -38551,
 1768380689,
 6546,
 -1,
 1768428942,
 6545,
 1768647021,
 1768350678,
 -1,
 -38548,
 1768609908,
 6569,
 -1,
 1768625550,
 6534,
 1768843632,
 1768601520,
 -1,
 -38545,
 1768804194,
 6571,
 -1,
 1768822158,
 6540,
 1769040243,
 1768792171,
 -1,
 -38542,
 1768970513,
 6552,
 -1,
 1769018766,
 6551,
 1769236854,
 1768982850,
 -1,
 -38539,
 1769165663,
 6535,
 -1,
 1769215374,
 6547,
 1769433465,
 1769173238,
 -1,
 -38536,
 1769396340,
 6568,
 -1,
 1769411982,
 6533,
 -38534,
 1769399548,
 6541,
 -38533,
 1769592948,
 6558,
 -38532,
 1769646028,
 6529,
 -38531,
 1769701525,
 6553,
 -38530,
 1769763865,
 6559,
 -38529,
 1769822481,
 6563,
 -38528,
 1769885447,
 6557,
 -38527,
 1769944727,
 6564,
 -1,
 1770006221,
 6565,
 1770219935,
 1768250711,
 -1,
 1770285447,
 1770177400,
 -1,
 -38523,
 1770240042,
 6536,
 -38522,
 1770281233,
 6543,
 -1,
 1770329486,
 6542,
 1770547594,
 1770251222,
 -1,
 -38519,
 1770510452,
 6567,
 -1,
 1770526094,
 6531,
 1770744205,
 1770502064,
 -1,
 -38516,
 1770704738,
 6570,
 -1,
 1770722702,
 6537,
 1770940816,
 1770692715,
 -1,
 -38513,
 1770871057,
 6549,
 -1,
 1770919310,
 6548,
 1771137427,
 1770883394,
 -1,
 -38510,
 1771066207,
 6532,
 -1,
 1771115918,
 6544,
 1771334038,
 1771073782,
 -1,
 -38507,
 1771296884,
 6566,
 -1,
 1771312526,
 6530,
 -38505,
 1771300092,
 6538,
 -38504,
 1771493492,
 6555,
 -38503,
 1771546572,
 6528,
 -38502,
 1771602069,
 6550,
 -38501,
 1771664409,
 6556,
 -38500,
 1771723025,
 6560,
 -38499,
 1771785991,
 6554,
 -38498,
 1771845271,
 6561,
 -1,
 1771906765,
 6562,
 1772158975,
 1770147962,
 -1,
 1772186018,
 1772063042,
 6595,
 -1,
 1772114731,
 6594,
 -38493,
 1772148838,
 6593,
 -38492,
 1772257352,
 6596,
 -38491,
 1772318966,
 6597,
 -38490,
 1772369452,
 6598,
 -1,
 1772431003,
 6599,
 1772644795,
 1768217992,
 -1,
 1772710317,
 1772605166,
 6579,
 1772775851,
 1772634279,
 6585,
 -1,
 1772741824,
 6591,
 -38484,
 1772741824,
 6588,
 -1,
 1772867310,
 6580,
 1773038001,
 1772655090,
 6583,
 1773103536,
 1772950926,
 6584,
 -1,
 1773069504,
 6590,
 -1,
 1773069504,
 6589,
 1773300150,
 1772950926,
 -1,
 1773365684,
 1773213070,
 6577,
 -1,
 1773331648,
 6587,
 -38475,
 1773331648,
 6586,
 -1,
 1773420711,
 6582,
 1773627833,
 1773232615,
 -1,
 -38472,
 1773593792,
 6592,
 -1,
 1773625831,
 6578,
 -38470,
 1773591928,
 6576,
 -1,
 1773748391,
 6581,
 1773955529,
 1772566948,
 -1,
 1774021055,
 1773912952,
 -1,
 -38466,
 1773986401,
 6610,
 -1,
 1774018750,
 6611,
 1774217666,
 1773975472,
 -1,
 -38463,
 1774153564,
 6614,
 -1,
 1774210223,
 6615,
 1774414277,
 1774145182,
 -1,
 -38460,
 1774361714,
 6612,
 -1,
 1774415589,
 6613,
 -38458,
 1774381167,
 6608,
 -38457,
 1774556706,
 6609,
 -38456,
 1774619935,
 6617,
 -1,
 1774667095,
 6616,
 1774873038,
 1773912952,
 -1,
 1774938573,
 1774818914,
 -1,
 -38452,
 1774850753,
 6601,
 -1,
 1774916137,
 6600,
 -1,
 1774869088,
 6618,
 1775239167,
 1774828769,
 6622,
 -1,
 1775163494,
 6623,
 -1,
 1768143753,
 8362,
 1775397362,
 1768051736,
 -1,
 1775462897,
 1775333097,
 -1,
 1775528424,
 1775382682,
 -1,
 1775593956,
 1775472802,
 -1,
 1775659482,
 1775551352,
 -1,
 1775725017,
 1775623972,
 -1,
 -38440,
 1775669352,
 9460,
 -1,
 1775730673,
 9452,
 -1,
 1775656473,
 9453,
 1775987165,
 1775613872,
 -1,
 -38436,
 1775923054,
 9456,
 -1,
 1775979741,
 9457,
 1776183776,
 1775914654,
 -1,
 -38433,
 1776131319,
 9454,
 -1,
 1776182485,
 9455,
 1776380387,
 1776107687,
 -1,
 -38430,
 1776319112,
 9451,
 -1,
 1776379241,
 9458,
 -1,
 1776323876,
 9459,
 1776642535,
 1775531574,
 -1,
 -38426,
 1776590955,
 127327,
 -1,
 1776638195,
 127319,
 -1,
 1776564651,
 9471,
 1776943103,
 1775484946,
 -1,
 1776970222,
 1776842294,
 -1,
 -38421,
 1776918635,
 127359,
 -38420,
 1776975944,
 127356,
 -38419,
 1777038276,
 127355,
 -1,
 1777102743,
 127353,
 -38417,
 1776924714,
 127373,
 -38416,
 1777246416,
 127372,
 -1,
 1777296213,
 127371,
 -1,
 1775387286,
 8879,
 1777560066,
 1775332951,
 -1,
 1777625592,
 1777498623,
 -1,
 1777691127,
 1777551638,
 -1,
 -38410,
 1777626836,
 8820,
 -1,
 1777670730,
 8816,
 -1,
 1777620831,
 8824,
 1777953277,
 1777555399,
 -1,
 1778018812,
 1777879318,
 -1,
 -38405,
 1777954516,
 8821,
 -1,
 1777998410,
 8817,
 -1,
 1777957303,
 8825,
 1778319359,
 1777866126,
 -1,
 1778346497,
 1778191011,
 -1,
 -38400,
 1778295673,
 8841,
 -1,
 1778330688,
 8840,
 -1,
 1778296381,
 8775,
 -38397,
 1777525912,
 9112,
 -38396,
 1778571238,
 9906,
 -1,
 1778624360,
 9798,
 1778805327,
 1767994105,
 -1,
 1778870830,
 1778742212,
 -1,
 1778936364,
 1778797664,
 -1,
 1779001869,
 1778878786,
 2002,
 1779067403,
 1778967804,
 2018,
 -1,
 1778978526,
 2023,
 1779236863,
 1778980238,
 2019,
 -1,
 1779109598,
 2016,
 1779329555,
 1778937751,
 -1,
 1779395090,
 1779275224,
 -1,
 -38384,
 1779345969,
 2026,
 -38383,
 1779396505,
 2024,
 -1,
 1779445582,
 2025,
 -1,
 1779307918,
 2006,
 1779722774,
 1779280342,
 -1,
 -38379,
 1779673649,
 2010,
 -1,
 1779701134,
 2009,
 1779919384,
 1779667442,
 2000,
 -1,
 1779864050,
 1999,
 1780050458,
 1779843239,
 1997,
 -1,
 1779974311,
 1995,
 1780181532,
 1779971735,
 2008,
 -1,
 1780110452,
 2001,
 -38371,
 1780147452,
 2022,
 -38370,
 1780276738,
 2021,
 -38369,
 1780338414,
 1998,
 -38368,
 1780401081,
 2005,
 -38367,
 1780463658,
 2011,
 -38366,
 1780523216,
 2004,
 -38365,
 1780580501,
 2017,
 -38364,
 1780642841,
 2015,
 -38363,
 1780707597,
 2014,
 -38362,
 1780769255,
 1996,
 -38361,
 1780832529,
 2020,
 -38360,
 1780896869,
 2012,
 -38359,
 1780961031,
 2013,
 -38358,
 1781018446,
 2007,
 -38357,
 1781081805,
 2003,
 -1,
 1781142926,
 1994,
 -38355,
 1778884491,
 2037,
 -1,
 1781275099,
 2042,
 1781492284,
 1778792868,
 -1,
 1781557810,
 1781449592,
 -1,
 -38351,
 1781523041,
 1986,
 -1,
 1781555390,
 1987,
 1781754421,
 1781512112,
 -1,
 -38348,
 1781690204,
 1990,
 -1,
 1781746863,
 1991,
 1781951032,
 1781681822,
 -1,
 -38345,
 1781898354,
 1988,
 -1,
 1781952229,
 1989,
 -38343,
 1781917807,
 1984,
 -38342,
 1782093346,
 1985,
 -38341,
 1782156575,
 1993,
 -1,
 1782203735,
 1992,
 1782409802,
 1781412397,
 -1,
 1782475337,
 1782327727,
 -1,
 1782540867,
 1782414725,
 -1,
 -38336,
 1782494072,
 2033,
 -38335,
 1782546100,
 2032,
 -38334,
 1782603161,
 2031,
 -1,
 1782659108,
 2030,
 1782868551,
 1782496238,
 -1,
 -38331,
 1782821752,
 2029,
 -38330,
 1782873780,
 2028,
 -1,
 1782930841,
 2027,
 -38328,
 1782811158,
 2034,
 -1,
 1783053563,
 2035,
 -1,
 1782415509,
 2040,
 1783327309,
 1782366976,
 -1,
 -38324,
 1783273225,
 2038,
 -1,
 1783321705,
 2039,
 -38322,
 1783258531,
 2036,
 -1,
 1783451047,
 2041,
 1783655074,
 1778749938,
 -1,
 1783720574,
 1783605718,
 8893,
 1783786108,
 1783678646,
 -1,
 1783851616,
 1783750471,
 -1,
 1783917149,
 1783764366,
 -1,
 1783982684,
 1783871043,
 8598,
 1784086527,
 1783889920,
 -1,
 1784113753,
 1784007129,
 -1,
 -38312,
 1784053145,
 8632,
 -1,
 1784099705,
 8689,
 -38310,
 1784078587,
 10531,
 -38309,
 1784231149,
 10546,
 -1,
 1784290804,
 10535,
 -1,
 1783925517,
 10529,
 -38306,
 1783881608,
 11009,
 -38305,
 1784495302,
 8662,
 -1,
 1784556072,
 11017,
 1784769135,
 1783785605,
 -1,
 1784834666,
 1784697451,
 -1,
 1784900199,
 1784780326,
 -1,
 -38300,
 1784855989,
 43059,
 -38299,
 1784916183,
 43056,
 -38298,
 1784961523,
 43057,
 -1,
 1785021796,
 43060,
 1785266175,
 1784858595,
 -1,
 -38295,
 1785183695,
 43061,
 -1,
 1785243897,
 43058,
 1785424493,
 1784784966,
 -1,
 -38292,
 1785378495,
 43062,
 -1,
 1785434183,
 43065,
 -38290,
 1785378642,
 43064,
 -1,
 1785570409,
 43063,
 1785790463,
 1784693141,
 -1,
 1785817721,
 1785664910,
 -1,
 1785883256,
 1785771587,
 8599,
 1785987071,
 1785790464,
 -1,
 1786014326,
 1785869410,
 -1,
 -38283,
 1785970553,
 10542,
 -1,
 1786023576,
 10545,
 -38281,
 1785979131,
 10532,
 -1,
 1786125883,
 10536,
 -1,
 1785826081,
 10530,
 -38278,
 1785782152,
 11008,
 -38277,
 1786330310,
 8663,
 -1,
 1786391080,
 11016,
 1786642431,
 1783726396,
 8882,
 -1,
 1786513116,
 8884,
 1786735260,
 1783677816,
 -1,
 1786800793,
 1786642432,
 -1,
 1786866311,
 1786713486,
 -1,
 1786931844,
 1786776227,
 -1,
 -38269,
 1786880879,
 8837,
 -1,
 1786915896,
 8836,
 -38267,
 1786888999,
 8772,
 -38266,
 1787070798,
 8713,
 -1,
 1787133197,
 8777,
 1787325068,
 1786820528,
 -1,
 1787390603,
 1787275431,
 -1,
 -38262,
 1787337043,
 8931,
 -1,
 1787389664,
 8930,
 -1,
 1787323885,
 172,
 1787652751,
 1787282296,
 -1,
 -38258,
 1787606798,
 8877,
 -1,
 1787651687,
 8769,
 1787849361,
 1787596404,
 8938,
 -1,
 1787758300,
 8940,
 1787980436,
 1787775254,
 -1,
 -38253,
 1787915988,
 8813,
 -1,
 1787959882,
 8800,
 -38251,
 1787928988,
 8742,
 -38250,
 1788115383,
 8814,
 -38249,
 1788175368,
 8802,
 -38248,
 1788237663,
 8815,
 -1,
 1788293019,
 9083,
 1788542975,
 1786720166,
 -1,
 -38245,
 1788466504,
 10161,
 -1,
 1788509952,
 10159,
 1788701343,
 1786677570,
 -1,
 -38242,
 1788629499,
 10973,
 -1,
 1788677922,
 8209,
 -38240,
 1788642761,
 8303,
 -38239,
 1788808981,
 160,
 -1,
 1788871587,
 9940,
 1789094585,
 1783566089,
 -1,
 1789160105,
 1789013251,
 -1,
 1789225640,
 1789095080,
 -1,
 -38234,
 1789184249,
 10754,
 -38233,
 1789240564,
 10753,
 -1,
 1789279132,
 10752,
 -1,
 1789171820,
 8720,
 1789553325,
 1789121315,
 8899,
 1789657087,
 1789462164,
 -1,
 -38228,
 1789568206,
 10756,
 -1,
 1789606708,
 10755,
 1789815474,
 1789507504,
 -1,
 1789881009,
 1789765799,
 -1,
 -38224,
 1789842217,
 10758,
 -1,
 1789881001,
 10757,
 -1,
 1789842020,
 8721,
 1790143157,
 1789754704,
 -1,
 -38220,
 1790089336,
 8897,
 -1,
 1790123404,
 8896,
 -38218,
 1790107616,
 11007,
 -38217,
 1790298361,
 10761,
 -38216,
 1790355235,
 8719,
 -1,
 1790405276,
 8898,
 1790601934,
 1789055513,
 -1,
 1790667469,
 1790519460,
 -1,
 1790732993,
 1790624632,
 -1,
 1790798527,
 1790697252,
 -1,
 -38210,
 1790742636,
 9371,
 -1,
 1790803957,
 9363,
 -38208,
 1790729761,
 9364,
 -1,
 1790920475,
 9361,
 1791126214,
 1790687152,
 -1,
 1791191749,
 1791058407,
 -1,
 -38204,
 1791157408,
 9367,
 -1,
 1791186558,
 35,
 -1,
 1791118566,
 9368,
 1791453897,
 1791053470,
 -1,
 -38200,
 1791401215,
 9365,
 -1,
 1791452380,
 9366,
 1791650508,
 1791377575,
 -1,
 -38197,
 1791589006,
 9362,
 -1,
 1791649137,
 9369,
 -1,
 1791593773,
 9370,
 -1,
 1790593574,
 8470,
 1792016383,
 1790514574,
 -1,
 -38192,
 1791936875,
 8302,
 -38191,
 1791997512,
 8239,
 -38190,
 1792051904,
 8892,
 -38189,
 1792109674,
 8358,
 -1,
 1792158231,
 8711,
 1792371763,
 1767924199,
 -1,
 1792437110,
 1792292694,
 -1,
 1792502642,
 1792381884,
 -1,
 1792568124,
 1792460195,
 -1,
 1792633659,
 1792525064,
 -1,
 1792699144,
 1792554540,
 -1,
 1792764679,
 1792616032,
 -1,
 1792830197,
 1792721784,
 -1,
 1792895726,
 1792794074,
 -1,
 1792961261,
 1792819367,
 -1,
 1793026796,
 1792905320,
 13299,
 1793130495,
 1792937702,
 -1,
 1793157859,
 1793049464,
 -1,
 -38174,
 1793122913,
 13301,
 -1,
 1793155262,
 13302,
 1793354470,
 1793111984,
 -1,
 -38171,
 1793290076,
 13305,
 -1,
 1793346735,
 13306,
 1793551081,
 1793281694,
 -1,
 -38168,
 1793498226,
 13303,
 -1,
 1793552101,
 13304,
 -38166,
 1793496610,
 13300,
 -38165,
 1793690911,
 13308,
 -1,
 1793738071,
 13307,
 -1,
 1792966641,
 13291,
 -1,
 1792905714,
 13281,
 1794075380,
 1792825587,
 -1,
 1794140915,
 1794010425,
 -1,
 1794206450,
 1794106560,
 13309,
 -1,
 1794117794,
 13310,
 -1,
 1794130796,
 13292,
 -1,
 1794092253,
 13282,
 -1,
 1794000657,
 13289,
 1794534138,
 1792784304,
 -1,
 1794599672,
 1794469724,
 13285,
 -1,
 1794557310,
 13295,
 1794768895,
 1794526383,
 13286,
 -1,
 1794688382,
 13296,
 1794861824,
 1794461342,
 -1,
 1794927357,
 1794808946,
 13283,
 -1,
 1794884990,
 13293,
 1795096575,
 1794859495,
 -1,
 -38145,
 1795021234,
 13284,
 -1,
 1795052218,
 13294,
 1795255044,
 1794785447,
 -1,
 1795320579,
 1795188043,
 13287,
 -1,
 1795244908,
 13297,
 -1,
 1795259016,
 13290,
 1795517190,
 1795198239,
 13288,
 -1,
 1795474814,
 13298,
 -1,
 1795462690,
 13280,
 -1,
 1792688717,
 13003,
 1795779372,
 1792630897,
 -1,
 1795844889,
 1795736440,
 -1,
 1795910421,
 1795808730,
 -1,
 1795975956,
 1795834023,
 -1,
 1796041491,
 1795919976,
 13164,
 1796145151,
 1795952358,
 -1,
 1796172561,
 1796064120,
 -1,
 -38128,
 1796137569,
 13166,
 -1,
 1796169918,
 13167,
 -38126,
 1796118050,
 13165,
 -1,
 1796297240,
 13168,
 -1,
 1795981297,
 13156,
 -1,
 1795920370,
 13146,
 1796631320,
 1795840243,
 -1,
 -38121,
 1796582621,
 13147,
 -1,
 1796631869,
 13157,
 -1,
 1796556561,
 13154,
 1796893470,
 1795798960,
 -1,
 1796959004,
 1796829020,
 13150,
 -1,
 1796916606,
 13160,
 1797128191,
 1796885679,
 13151,
 -1,
 1797047678,
 13161,
 1797221156,
 1796820638,
 -1,
 1797286689,
 1797168242,
 13148,
 -1,
 1797244286,
 13158,
 1797455871,
 1797218791,
 -1,
 -38109,
 1797380530,
 13149,
 -1,
 1797411514,
 13159,
 1797614376,
 1797144743,
 -1,
 1797679911,
 1797547339,
 13152,
 -1,
 1797604204,
 13162,
 -1,
 1797618312,
 13155,
 1797876522,
 1797557535,
 13153,
 -1,
 1797834110,
 13163,
 -38101,
 1797843055,
 13144,
 -1,
 1797953058,
 13145,
 1798138673,
 1795714967,
 -1,
 1798204208,
 1798098670,
 -1,
 -38097,
 1798146918,
 12997,
 -1,
 1798209563,
 12998,
 -1,
 1798119340,
 12992,
 1798466356,
 1798078613,
 -1,
 -38093,
 1798431936,
 12996,
 -1,
 1798482851,
 12994,
 1798662967,
 1798378894,
 -1,
 -38090,
 1798623474,
 12999,
 -1,
 1798678248,
 12995,
 -38088,
 1798617667,
 13000,
 -38087,
 1798804215,
 13001,
 -38086,
 1798868767,
 13002,
 -1,
 1798918031,
 12993,
 -1,
 1792572292,
 12343,
 1799187282,
 1792483094,
 -1,
 1799252803,
 1799144312,
 -1,
 1799318337,
 1799182579,
 -1,
 -38080,
 1799269618,
 12692,
 -1,
 1799318754,
 12699,
 -38078,
 1799283499,
 12691,
 -1,
 1799460731,
 12694,
 1799646024,
 1799179934,
 -1,
 1799711559,
 1799593074,
 -1,
 -38074,
 1799669434,
 12700,
 -1,
 1799685595,
 12693,
 -1,
 1799646498,
 12697,
 1799973707,
 1799585864,
 -1,
 -38070,
 1799906192,
 12695,
 -1,
 1799953766,
 12703,
 -38068,
 1799928130,
 12698,
 -38067,
 1800121804,
 12689,
 -38066,
 1800181337,
 12690,
 -38065,
 1800240085,
 12688,
 -38064,
 1800297454,
 12701,
 -38063,
 1800356234,
 12702,
 -1,
 1800416054,
 12696,
 1800629094,
 1799108438,
 -1,
 1800694629,
 1800583444,
 -1,
 1800760157,
 1800651459,
 -1,
 1800825688,
 1800721661,
 -1,
 -38057,
 1800777454,
 12281,
 -1,
 1800828657,
 12280,
 1801022299,
 1800762308,
 -1,
 -38054,
 1800970206,
 12282,
 -1,
 1801012154,
 12279,
 -38052,
 1800939640,
 12278,
 -1,
 1801131663,
 12277,
 1801349984,
 1800697879,
 -1,
 -38049,
 1801301742,
 12272,
 -1,
 1801356578,
 12274,
 1801546595,
 1801262913,
 -1,
 -38046,
 1801487633,
 12275,
 -1,
 1801529464,
 12273,
 -38044,
 1801494324,
 12283,
 -1,
 1801671444,
 12276,
 -1,
 1800643039,
 12332,
 1801939817,
 1800547587,
 -1,
 -38040,
 1801885026,
 12289,
 -1,
 1801944651,
 12294,
 -38038,
 1801902436,
 12350,
 -38037,
 1802092426,
 12288,
 -38036,
 1802154884,
 12331,
 -38035,
 1802211521,
 12295,
 -38034,
 1802271352,
 12330,
 -38033,
 1802333747,
 12293,
 -38032,
 1802394142,
 12351,
 -38031,
 1802457866,
 12290,
 -1,
 1802520595,
 12333,
 1802764287,
 1792446463,
 -1,
 1802791797,
 1802684886,
 8801,
 -1,
 1802699103,
 10725,
 -1,
 1802756248,
 10855,
 1802988550,
 1792379202,
 -1,
 1803054022,
 1802942384,
 -1,
 1803119557,
 1802974243,
 -1,
 1803185057,
 1803073239,
 -1,
 1803250581,
 1803123266,
 -1,
 1803316096,
 1803204528,
 -1,
 1803381631,
 1803228558,
 -1,
 -38018,
 1803322423,
 68430,
 -1,
 1803368595,
 68433,
 -1,
 1803312619,
 68436,
 1803643779,
 1803273080,
 -1,
 -38014,
 1803570191,
 68424,
 -1,
 1803626042,
 68437,
 1803840389,
 1803574160,
 68420,
 -1,
 1803798195,
 68423,
 1803971464,
 1803752846,
 -1,
 -38009,
 1803937450,
 68431,
 -1,
 1803975068,
 68416,
 -38007,
 1803937860,
 68422,
 -38006,
 1804134169,
 68425,
 -38005,
 1804197633,
 68421,
 -38004,
 1804250522,
 68435,
 -38003,
 1804314682,
 68434,
 -38002,
 1804378671,
 68432,
 -38001,
 1804439818,
 68429,
 -38000,
 1804502090,
 68428,
 -37999,
 1804563799,
 68427,
 -37998,
 1804628344,
 68426,
 -37997,
 1804686837,
 68418,
 -37996,
 1804744425,
 68419,
 -1,
 1804806484,
 68417,
 1805058047,
 1803194530,
 -1,
 1805085596,
 1804977016,
 -1,
 1805151130,
 1805049306,
 -1,
 -37991,
 1805095410,
 68441,
 -1,
 1805142127,
 68445,
 -37989,
 1805082814,
 68442,
 -1,
 1805272849,
 68444,
 1805478816,
 1805030946,
 68440,
 1805582335,
 1805385728,
 -1,
 -37985,
 1805502401,
 68447,
 -1,
 1805541759,
 68446,
 -1,
 1805406744,
 68443,
 1805844479,
 1803116196,
 -1,
 1805872057,
 1805744706,
 -1,
 1805937576,
 1805825968,
 -1,
 1806003111,
 1805849998,
 -1,
 -37978,
 1805943863,
 68462,
 -1,
 1805990035,
 68464,
 -1,
 1805934059,
 68465,
 1806265259,
 1805894520,
 -1,
 -37974,
 1806191631,
 68456,
 -1,
 1806247482,
 68466,
 1806461869,
 1806195600,
 68452,
 -1,
 1806419635,
 68455,
 -37970,
 1806428228,
 68454,
 -37969,
 1806559001,
 68457,
 -37968,
 1806622474,
 68453,
 -37967,
 1806672431,
 68463,
 -37966,
 1806733578,
 68461,
 -37965,
 1806795854,
 68460,
 -37964,
 1806857559,
 68459,
 -37963,
 1806922104,
 68458,
 -37962,
 1806980597,
 68450,
 -37961,
 1807038185,
 68451,
 -37960,
 1807100244,
 68449,
 -1,
 1807162198,
 68448,
 1807417343,
 1805815970,
 -1,
 1807444928,
 1807336312,
 -1,
 1807510462,
 1807408602,
 -1,
 -37955,
 1807454706,
 68473,
 -1,
 1807501423,
 68477,
 -37953,
 1807442110,
 68474,
 -1,
 1807632145,
 68476,
 1807838148,
 1807390242,
 68472,
 1807941631,
 1807745024,
 -1,
 -37949,
 1807861697,
 68479,
 -1,
 1807901055,
 68478,
 -1,
 1807766040,
 68475,
 -1,
 1803045472,
 9088,
 1808231402,
 1803011359,
 -1,
 1808296923,
 1808181718,
 -1,
 1808362450,
 1808251234,
 8745,
 1808465919,
 1808269312,
 -1,
 1808493518,
 1808392260,
 -1,
 -37940,
 1808441132,
 10819,
 -37939,
 1808498009,
 10820,
 -1,
 1808546612,
 10816,
 1808755665,
 1808406165,
 -1,
 -37936,
 1808716579,
 10823,
 -1,
 1808738205,
 10825,
 -1,
 1808672993,
 10827,
 1809017816,
 1808298948,
 -1,
 1809083351,
 1808951520,
 -1,
 -37931,
 1809040944,
 65531,
 -37930,
 1809103375,
 65530,
 -1,
 1809128837,
 65529,
 -1,
 1809027804,
 9892,
 -37927,
 1808970877,
 8253,
 -37926,
 1809345555,
 10812,
 -1,
 1809395081,
 8890,
 1809645567,
 1808226029,
 8747,
 1809711103,
 1809514496,
 -1,
 1809738726,
 1809637444,
 -1,
 1809804257,
 1809699447,
 -1,
 -37920,
 1809738758,
 10778,
 -1,
 1809790984,
 10780,
 -37918,
 1809762603,
 10776,
 -37917,
 1809948460,
 10779,
 -37916,
 1810004165,
 10775,
 -37915,
 1810066076,
 10777,
 -1,
 1810120118,
 10766,
 1810328553,
 1809651086,
 -1,
 -37912,
 1810291320,
 10767,
 -1,
 1810347387,
 10773,
 -1,
 1810255452,
 9134,
 1810590714,
 1808193638,
 -1,
 1810656246,
 1810516351,
 -1,
 1810721779,
 1810613618,
 -1,
 -37906,
 1810682628,
 8276,
 -37905,
 1810737472,
 191,
 -37904,
 1810797548,
 8487,
 -37903,
 1810855565,
 8766,
 -37902,
 1810918010,
 11800,
 -1,
 1810976167,
 161,
 1811218431,
 1810676012,
 -1,
 -37899,
 1811144596,
 9689,
 -1,
 1811164260,
 9688,
 1811415039,
 1810591113,
 -1,
 -37896,
 1811335394,
 8290,
 -37895,
 1811397135,
 8291,
 -1,
 1811457230,
 8292,
 1811639294,
 1810517662,
 -1,
 1811704829,
 1811573210,
 8734,
 -1,
 1811613189,
 10718,
 -1,
 1811651025,
 8505,
 1811901443,
 1811557635,
 -1,
 1811966978,
 1811852294,
 -1,
 -37887,
 1811907710,
 8710,
 -1,
 1811948401,
 10721,
 -1,
 1811912059,
 10716,
 1812267007,
 1811832089,
 -1,
 -37883,
 1812185876,
 8298,
 -1,
 1812209854,
 8300,
 1812425778,
 1802928200,
 -1,
 1812491312,
 1812374335,
 -1,
 1812556835,
 1812429378,
 -1,
 1812622350,
 1812510640,
 -1,
 1812687885,
 1812534670,
 -1,
 -37876,
 1812628535,
 67662,
 -1,
 1812674707,
 67665,
 -1,
 1812618731,
 67668,
 1812950033,
 1812579192,
 -1,
 -37872,
 1812876303,
 67656,
 -1,
 1812932154,
 67669,
 1813146643,
 1812880272,
 67652,
 -1,
 1813104307,
 67655,
 1813277718,
 1813058958,
 -1,
 -37867,
 1813243562,
 67663,
 -1,
 1813281180,
 67648,
 -37865,
 1813243972,
 67654,
 -37864,
 1813440281,
 67657,
 -37863,
 1813503745,
 67653,
 -37862,
 1813556634,
 67667,
 -37861,
 1813620794,
 67666,
 -37860,
 1813684783,
 67664,
 -37859,
 1813745930,
 67661,
 -37858,
 1813808202,
 67660,
 -37857,
 1813869911,
 67659,
 -37856,
 1813934456,
 67658,
 -37855,
 1813992949,
 67650,
 -37854,
 1814050537,
 67651,
 -1,
 1814112596,
 67649,
 1814326319,
 1812500642,
 -1,
 1814391851,
 1814283128,
 -1,
 1814457384,
 1814355418,
 -1,
 -37849,
 1814401522,
 67673,
 -1,
 1814448239,
 67676,
 1814653994,
 1814382353,
 67675,
 -1,
 1814563556,
 67679,
 -1,
 1814585534,
 67674,
 1814888447,
 1814337058,
 67672,
 1814953983,
 1814757376,
 -1,
 -37842,
 1814874049,
 67678,
 -1,
 1814913407,
 67677,
 -1,
 1814280567,
 67671,
 1815216127,
 1812404432,
 8887,
 -1,
 1815086775,
 8787,
 -1,
 1812344516,
 9976,
 1815375097,
 1792298654,
 -1,
 1815440574,
 1815334638,
 -1,
 1815506105,
 1815379050,
 -1,
 1815571637,
 1815470097,
 -1,
 1815637111,
 1815507908,
 -1,
 1815702639,
 1815553344,
 -1,
 1815768148,
 1815658151,
 -1,
 -37829,
 1815734264,
 65370,
 -37828,
 1815798976,
 65369,
 -37827,
 1815864278,
 65368,
 -37826,
 1815928282,
 65367,
 -37825,
 1815992422,
 65366,
 -37824,
 1816055534,
 65365,
 -37823,
 1816118136,
 65364,
 -37822,
 1816180656,
 65363,
 -37821,
 1816242646,
 65362,
 -37820,
 1816307654,
 65361,
 -37819,
 1816371307,
 65360,
 -37818,
 1816433138,
 65359,
 -37817,
 1816496450,
 65358,
 -37816,
 1816559688,
 65357,
 -37815,
 1816622020,
 65356,
 -37814,
 1816686838,
 65355,
 -37813,
 1816752023,
 65354,
 -37812,
 1816814055,
 65353,
 -37811,
 1816877299,
 65352,
 -37810,
 1816941355,
 65351,
 -37809,
 1817005726,
 65350,
 -37808,
 1817067687,
 65349,
 -37807,
 1817130540,
 65348,
 -37806,
 1817193731,
 65347,
 -37805,
 1817257627,
 65346,
 -1,
 1817318798,
 65345,
 1817575423,
 1815686697,
 -1,
 -37802,
 1817503736,
 65338,
 -37801,
 1817568448,
 65337,
 -37800,
 1817633750,
 65336,
 -37799,
 1817697754,
 65335,
 -37798,
 1817761894,
 65334,
 -37797,
 1817825006,
 65333,
 -37796,
 1817887608,
 65332,
 -37795,
 1817950128,
 65331,
 -37794,
 1818012118,
 65330,
 -37793,
 1818077126,
 65329,
 -37792,
 1818140779,
 65328,
 -37791,
 1818202610,
 65327,
 -37790,
 1818265922,
 65326,
 -37789,
 1818329160,
 65325,
 -37788,
 1818391492,
 65324,
 -37787,
 1818456310,
 65323,
 -37786,
 1818521495,
 65322,
 -37785,
 1818583527,
 65321,
 -37784,
 1818646771,
 65320,
 -37783,
 1818710827,
 65319,
 -37782,
 1818775198,
 65318,
 -37781,
 1818837159,
 65317,
 -37780,
 1818900012,
 65316,
 -37779,
 1818963203,
 65315,
 -37778,
 1819027099,
 65314,
 -1,
 1819088270,
 65313,
 1819307126,
 1815625895,
 -1,
 1819372661,
 1819234985,
 -1,
 -37774,
 1819336625,
 65375,
 -37773,
 1819394043,
 65339,
 -37772,
 1819451816,
 65288,
 -1,
 1819489718,
 65371,
 -1,
 1819328592,
 65308,
 -1,
 1819254646,
 65343,
 1819831431,
 1815557676,
 -1,
 1819896966,
 1819764194,
 -1,
 1819962492,
 1819853688,
 -1,
 -37765,
 1819927137,
 65298,
 -1,
 1819959486,
 65299,
 1820159103,
 1819916208,
 -1,
 -37762,
 1820094300,
 65302,
 -1,
 1820150959,
 65303,
 1820355714,
 1820085918,
 -1,
 -37759,
 1820302450,
 65300,
 -1,
 1820356325,
 65301,
 -37757,
 1820321903,
 65296,
 -37756,
 1820497442,
 65297,
 -37755,
 1820560671,
 65305,
 -1,
 1820607831,
 65304,
 -1,
 1819841776,
 65284,
 1820880014,
 1819781590,
 -1,
 1820945549,
 1820812624,
 -1,
 -37750,
 1820909489,
 65376,
 -37749,
 1820966907,
 65341,
 -37748,
 1821024680,
 65289,
 -1,
 1821062582,
 65373,
 -1,
 1820871952,
 65340,
 1821338774,
 1820798211,
 -1,
 1821404308,
 1821282802,
 -1,
 1821469843,
 1821345367,
 -1,
 -37742,
 1821395415,
 65312,
 -1,
 1821447566,
 65292,
 -1,
 1821408629,
 65306,
 -37739,
 1821338817,
 65342,
 -1,
 1821657062,
 65504,
 1821863066,
 1821286507,
 -1,
 -37736,
 1821809688,
 65505,
 -37735,
 1821867993,
 65291,
 -1,
 1821919683,
 65285,
 1822125214,
 1821775246,
 -1,
 -37732,
 1822081296,
 65290,
 -37731,
 1822139890,
 65287,
 -1,
 1822197716,
 65286,
 1822387361,
 1822078896,
 -1,
 -37728,
 1822332102,
 65295,
 -1,
 1822377632,
 65307,
 1822583972,
 1822337091,
 -1,
 -37725,
 1822530324,
 65282,
 -1,
 1822575446,
 65311,
 1822780583,
 1822525762,
 -1,
 -37722,
 1822741071,
 65283,
 -1,
 1822792448,
 65506,
 1822977194,
 1822709461,
 -1,
 -37719,
 1822900651,
 65310,
 -1,
 1822959118,
 65344,
 1823173805,
 1822900391,
 -1,
 -37716,
 1823138840,
 65281,
 -1,
 1823189125,
 65309,
 -37714,
 1823139329,
 65509,
 -37713,
 1823335301,
 65510,
 -37712,
 1823398833,
 65372,
 -37711,
 1823459488,
 65374,
 -37710,
 1823506590,
 65507,
 -37709,
 1823564247,
 65293,
 -37708,
 1823625994,
 65294,
 -1,
 1823681550,
 65508,
 1823932415,
 1815478272,
 -1,
 -37705,
 1823850842,
 46,
 -37704,
 1823907135,
 10199,
 -1,
 1823943349,
 9608,
 1824156860,
 1815447874,
 -1,
 -37701,
 1824082349,
 9905,
 -1,
 1824142652,
 8289,
 -37699,
 1824110889,
 9179,
 -1,
 1824277985,
 9981,
 1824484561,
 1815384562,
 -1,
 1824550091,
 1824444142,
 -1,
 1824615626,
 1824500182,
 -1,
 1824681160,
 1824522240,
 -1,
 1824746693,
 1824602936,
 -1,
 -37692,
 1824696177,
 8280,
 -1,
 1824752317,
 8283,
 -37690,
 1824703798,
 10018,
 -37689,
 1824862711,
 10021,
 -1,
 1824925488,
 10019,
 -37687,
 1824638658,
 8732,
 -1,
 1825050805,
 8197,
 -1,
 1824559050,
 9970,
 1825374207,
 1824500182,
 -1,
 1825402063,
 1825272054,
 -1,
 -37682,
 1825335567,
 10972,
 -1,
 1825391339,
 11792,
 -37680,
 1825320771,
 8873,
 -1,
 1825505347,
 8704,
 1825729755,
 1824416231,
 -1,
 1825795285,
 1825692089,
 -1,
 -37676,
 1825744753,
 8281,
 -1,
 1825800893,
 11821,
 1825991896,
 1825724591,
 -1,
 -37673,
 1825947530,
 8199,
 -1,
 1825978133,
 8210,
 -37671,
 1825946531,
 9673,
 -37670,
 1826141849,
 9789,
 -1,
 1826196837,
 10765,
 1826385124,
 1825665988,
 -1,
 1826450656,
 1826329074,
 -1,
 1826516191,
 1826414398,
 9880,
 -1,
 1826425237,
 8277,
 -1,
 1826466547,
 10086,
 1826712803,
 1826362766,
 -1,
 -37662,
 1826671056,
 9189,
 -1,
 1826706224,
 9971,
 -1,
 1826638978,
 9884,
 1826974956,
 1826335190,
 -1,
 1827040488,
 1826918898,
 -1,
 -37657,
 1827004960,
 8994,
 -1,
 1827049376,
 10156,
 1827237099,
 1826953150,
 -1,
 -37654,
 1827192346,
 8260,
 -1,
 1827246318,
 8543,
 -1,
 1827161973,
 8355,
 1827499252,
 1826887054,
 -1,
 1827564786,
 1827437806,
 -1,
 1827630321,
 1827484770,
 -1,
 -37648,
 1827582790,
 10540,
 -1,
 1827638919,
 10543,
 -1,
 1827563516,
 9950,
 -37645,
 1827518087,
 9771,
 -1,
 1827812652,
 8507,
 1828061183,
 1827422375,
 -1,
 1828089080,
 1827962952,
 -1,
 -37641,
 1828022678,
 170,
 -1,
 1828068045,
 9792,
 -1,
 1828042355,
 9972,
 1828351383,
 1815334638,
 -1,
 1828416856,
 1828298859,
 -1,
 1828482348,
 1828380204,
 -1,
 1828547849,
 1828394382,
 -1,
 1828613384,
 1828501059,
 8593,
 1828716543,
 1828519936,
 -1,
 1828744453,
 1828642884,
 -1,
 1828809987,
 1828702591,
 -1,
 -37630,
 1828761889,
 8625,
 -1,
 1828812971,
 8624,
 -37628,
 1828741086,
 10505,
 -1,
 1828928950,
 8670,
 -37626,
 1828702685,
 10514,
 -37625,
 1829075167,
 8645,
 -1,
 1829130903,
 8613,
 -1,
 1828555450,
 11797,
 1829399831,
 1828477739,
 -1,
 1829465362,
 1829336817,
 -1,
 1829530897,
 1829371904,
 -1,
 1829596431,
 1829447897,
 -1,
 -37618,
 1829557760,
 10595,
 -1,
 1829584777,
 10606,
 -37616,
 1829554653,
 10584,
 -1,
 1829720727,
 10592,
 -1,
 1829494310,
 8639,
 1830027263,
 1829416686,
 -1,
 1830055190,
 1829896192,
 -1,
 -37611,
 1830013405,
 10580,
 -1,
 1830048407,
 10588,
 -1,
 1830018598,
 8638,
 1830317345,
 1829363585,
 -1,
 1830382879,
 1830232711,
 8679,
 1830486015,
 1830289408,
 -1,
 1830513950,
 1830393260,
 8683,
 1830617087,
 1830423606,
 -1,
 -37603,
 1830542106,
 8685,
 -1,
 1830575936,
 8684,
 -1,
 1830441623,
 8682,
 1830879231,
 1830304966,
 8686,
 -1,
 1830749811,
 8687,
 1830972710,
 1830273912,
 -1,
 1831038245,
 1830937185,
 -1,
 -37596,
 1830948815,
 10569,
 -1,
 1831011428,
 8607,
 -1,
 1830990522,
 10506,
 1831300393,
 1830893100,
 -1,
 -37592,
 1831246793,
 8657,
 -1,
 1831281578,
 8673,
 -37590,
 1831250021,
 10224,
 -37589,
 1831444746,
 8648,
 -1,
 1831479848,
 11014,
 1831693634,
 1828388864,
 -1,
 1831759155,
 1831616084,
 -1,
 1831824688,
 1831674503,
 8597,
 -1,
 1831734333,
 8616,
 -37583,
 1831788424,
 8691,
 -37582,
 1831877830,
 8661,
 -1,
 1831938600,
 11021,
 1832152378,
 1831675821,
 -1,
 1832217911,
 1832103829,
 -1,
 -37578,
 1832169444,
 10575,
 -1,
 1832220571,
 10572,
 1832452095,
 1832154961,
 -1,
 -37575,
 1832366052,
 10573,
 -1,
 1832417179,
 10577,
 1832611134,
 1832067719,
 -1,
 1832676669,
 1832541086,
 8963,
 -1,
 1832583738,
 8996,
 -1,
 1832585966,
 10685,
 1832873280,
 1832567805,
 8869,
 -1,
 1832782945,
 10207,
 -37567,
 1832824662,
 8944,
 -1,
 1832931550,
 10622,
 1833135445,
 1831641814,
 -1,
 1833200970,
 1833086708,
 -1,
 -37563,
 1833159582,
 9721,
 -37562,
 1833220867,
 10066,
 -37561,
 1833281615,
 9693,
 -37560,
 1833345708,
 10000,
 -37559,
 1833408667,
 9137,
 -1,
 1833451531,
 10064,
 1833659727,
 1833137910,
 -1,
 -37556,
 1833618334,
 9720,
 -37555,
 1833674831,
 9692,
 -37554,
 1833736383,
 9136,
 -1,
 1833776049,
 10196,
 1833987411,
 1833589240,
 -1,
 -37551,
 1833921318,
 9690,
 -37550,
 1833971809,
 9696,
 -1,
 1834035893,
 9600,
 -37548,
 1833932339,
 9620,
 -1,
 1834166931,
 9985,
 1834418175,
 1833046288,
 -1,
 -37545,
 1834332081,
 9710,
 -1,
 1834383211,
 9709,
 1834577281,
 1828344836,
 -1,
 1834642816,
 1834515010,
 -1,
 1834708320,
 1834596272,
 -1,
 1834773854,
 1834620302,
 -1,
 -37539,
 1834714702,
 66450,
 -1,
 1834760022,
 66453,
 -37537,
 1834730005,
 66461,
 -1,
 1834900971,
 66444,
 1835101540,
 1834664824,
 -1,
 -37534,
 1835045362,
 66458,
 -37533,
 1835096794,
 66456,
 -1,
 1835158378,
 66441,
 1835363687,
 1835067384,
 -1,
 -37530,
 1835323118,
 66449,
 -1,
 1835355013,
 66439,
 1835560298,
 1835299062,
 -1,
 -37527,
 1835489553,
 66435,
 -1,
 1835538604,
 66443,
 1835756908,
 1835491015,
 66437,
 -1,
 1835713465,
 66440,
 1835887983,
 1835684651,
 -1,
 -37522,
 1835817411,
 66457,
 -1,
 1835867402,
 66434,
 1836084594,
 1835808300,
 -1,
 -37519,
 1836014049,
 66447,
 -1,
 1836074568,
 66436,
 1836281205,
 1835996558,
 -1,
 -37516,
 1836220212,
 66432,
 -1,
 1836279704,
 66451,
 -37514,
 1836246791,
 66442,
 -37513,
 1836442209,
 66438,
 -37512,
 1836502766,
 66460,
 -37511,
 1836559210,
 66455,
 -37510,
 1836623925,
 66454,
 -37509,
 1836689262,
 66452,
 -37508,
 1836749066,
 66448,
 -37507,
 1836811338,
 66446,
 -37506,
 1836873035,
 66445,
 -37505,
 1836933607,
 66459,
 -1,
 1836984636,
 66433,
 -1,
 1834607502,
 66463,
 1837264274,
 1834518850,
 -1,
 1837329806,
 1837195751,
 -1,
 1837395341,
 1837274512,
 8746,
 1837498367,
 1837301760,
 -1,
 1837526409,
 1837424708,
 -1,
 -37497,
 1837473580,
 10818,
 -37496,
 1837532692,
 10817,
 -1,
 1837596005,
 10821,
 1837788556,
 1837438613,
 -1,
 -37493,
 1837722268,
 10822,
 -1,
 1837770630,
 10824,
 -1,
 1837705477,
 10826,
 -1,
 1837357733,
 9842,
 1838116241,
 1837250092,
 -1,
 -37488,
 1838060077,
 9100,
 -1,
 1838107226,
 8255,
 -1,
 1838056136,
 9903,
 1838378390,
 1837204332,
 9730,
 1838481407,
 1838284800,
 -1,
 -37483,
 1838408070,
 9748,
 -1,
 1838454167,
 9969,
 -1,
 1838328668,
 9797,
 1838706241,
 1828314586,
 -1,
 1838771751,
 1838635251,
 -1,
 1838837284,
 1838706198,
 -1,
 1838902819,
 1838743552,
 -1,
 1838968250,
 1838856112,
 -1,
 1839033773,
 1838917793,
 9633,
 1839136767,
 1838940160,
 -1,
 1839164844,
 1839063108,
 -1,
 1839230372,
 1839100868,
 -1,
 1839295907,
 1839177672,
 -1,
 -37470,
 1839247426,
 9714,
 -1,
 1839298547,
 9713,
 -1,
 1839219890,
 10212,
 1839558055,
 1839191293,
 -1,
 -37466,
 1839509570,
 9715,
 -1,
 1839560691,
 9712,
 1839754666,
 1839507926,
 -1,
 -37463,
 1839701055,
 9634,
 -1,
 1839752596,
 10213,
 -37461,
 1839717214,
 9707,
 -1,
 1839869714,
 9093,
 -1,
 1839084321,
 9635,
 1840147892,
 1838973000,
 -1,
 1840213427,
 1840061389,
 -1,
 1840278962,
 1840166832,
 -1,
 -37455,
 1840235720,
 11090,
 -1,
 1840294049,
 9643,
 -1,
 1840217900,
 11051,
 -1,
 1840146056,
 9786,
 -37451,
 1840108154,
 9788,
 -37450,
 1840563400,
 9734,
 -37449,
 1840619776,
 9828,
 -37448,
 1840668373,
 9750,
 -37447,
 1840728708,
 65094,
 -1,
 1840787749,
 9988,
 1840999892,
 1838886147,
 -1,
 1841065415,
 1840934026,
 9675,
 1841168383,
 1840974902,
 -1,
 1841196480,
 1841091837,
 -1,
 -37441,
 1841147970,
 9719,
 -1,
 1841199091,
 9716,
 1841393091,
 1841135293,
 -1,
 -37438,
 1841344578,
 9718,
 -1,
 1841395699,
 9717,
 1841589702,
 1841314512,
 -1,
 -37435,
 1841553959,
 10732,
 -1,
 1841611694,
 9862,
 -1,
 1841548825,
 9863,
 1841851855,
 1840995520,
 -1,
 1841917387,
 1841787126,
 -1,
 -37430,
 1841859843,
 9816,
 -1,
 1841916175,
 9812,
 -37428,
 1841870064,
 9814,
 -37427,
 1842063665,
 9813,
 -37426,
 1842127380,
 9817,
 -1,
 1842162156,
 9815,
 1842376147,
 1841796616,
 10209,
 1842479103,
 1842285622,
 -1,
 -37422,
 1842393553,
 10211,
 -1,
 1842444567,
 10210,
 -1,
 1842315153,
 9831,
 1842703843,
 1840920108,
 -1,
 1842769371,
 1842635443,
 9671,
 1842872319,
 1842675712,
 -1,
 -37416,
 1842798702,
 10192,
 -37415,
 1842856520,
 9826,
 -37414,
 1842898918,
 9931,
 -1,
 1842950914,
 9672,
 1843162592,
 1842716717,
 -1,
 1843228127,
 1843073235,
 -1,
 -37410,
 1843186590,
 9661,
 -1,
 1843248836,
 9663,
 -1,
 1843136889,
 9759,
 1843527679,
 1843112834,
 -1,
 -37406,
 1843429977,
 9920,
 -1,
 1843491526,
 9921,
 1843686893,
 1842653654,
 -1,
 1843752428,
 1843619147,
 -1,
 1843817963,
 1843663059,
 -1,
 1843883497,
 1843765355,
 -1,
 -37400,
 1843827770,
 9659,
 -1,
 1843873775,
 11092,
 -37398,
 1843841950,
 9655,
 -1,
 1844035268,
 9657,
 -1,
 1843726713,
 9758,
 -1,
 1843675763,
 9645,
 1844342263,
 1843622852,
 -1,
 1844407798,
 1844265914,
 -1,
 1844473331,
 1844318419,
 -1,
 -37391,
 1844431774,
 9665,
 -37390,
 1844494020,
 9667,
 -1,
 1844553063,
 9669,
 1844772863,
 1844379648,
 -1,
 -37387,
 1844684178,
 9756,
 -1,
 1844737374,
 9945,
 -1,
 1844322767,
 11036,
 1844997630,
 1844282338,
 -1,
 1845063164,
 1844950960,
 -1,
 -37382,
 1845019848,
 11088,
 -37381,
 1845078177,
 9723,
 -1,
 1845133868,
 9725,
 -37379,
 1845002028,
 11048,
 -1,
 1845246265,
 11046,
 1845456389,
 1844924062,
 -1,
 1845521923,
 1845392324,
 -1,
 1845587458,
 1845434552,
 9872,
 -1,
 1845497257,
 9983,
 -1,
 1845532986,
 10048,
 -37372,
 1845474748,
 9785,
 -1,
 1845730518,
 10023,
 1845915147,
 1845418583,
 -1,
 1845980682,
 1845872742,
 -1,
 -37368,
 1845931145,
 9647,
 -37367,
 1845970452,
 11055,
 -1,
 1846028147,
 11006,
 -1,
 1845945567,
 11038,
 1846308369,
 1845875624,
 -1,
 1846373904,
 1846218963,
 -1,
 1846439439,
 1846332318,
 9651,
 -1,
 1846349066,
 9708,
 -1,
 1846394564,
 9653,
 -1,
 1846282617,
 9757,
 1846701591,
 1846264696,
 -1,
 1846767125,
 1846651350,
 -1,
 -37356,
 1846698750,
 10177,
 -1,
 1846747104,
 9186,
 -37354,
 1846731629,
 9943,
 -1,
 1846887939,
 9743,
 1847094814,
 1846630643,
 -1,
 1847160347,
 1847038450,
 -1,
 -37350,
 1847121541,
 10710,
 -1,
 1847178173,
 11053,
 1847394303,
 1847083175,
 -1,
 -37347,
 1847321593,
 11041,
 -1,
 1847337697,
 9825,
 1847553569,
 1847042155,
 -1,
 -37344,
 1847478255,
 11040,
 -1,
 1847533854,
 9649,
 -37342,
 1847495910,
 10001,
 -1,
 1847667812,
 9702,
 -1,
 1838813080,
 10163,
 1847984127,
 1838760792,
 -1,
 -37338,
 1847865194,
 9855,
 -1,
 1847920210,
 9784,
 1848143414,
 1838683534,
 -1,
 1848208948,
 1848105062,
 -1,
 1848274479,
 1848173762,
 -1,
 1848340013,
 1848210372,
 -1,
 -37332,
 1848287094,
 65103,
 -1,
 1848338634,
 8967,
 -37330,
 1848287069,
 65099,
 -1,
 1848456981,
 12336,
 1848705023,
 1848197289,
 -1,
 1848733235,
 1848582830,
 -1,
 -37326,
 1848684270,
 10547,
 -1,
 1848735473,
 11071,
 -1,
 1848653589,
 12316,
 -37323,
 1848165651,
 8986,
 -1,
 1848947802,
 9888,
 1849126459,
 1848087026,
 -1,
 1849191994,
 1849076691,
 -1,
 -37319,
 1849145902,
 11825,
 -1,
 1849192602,
 8288,
 -1,
 1849133403,
 8361,
 1849454142,
 1849076182,
 -1,
 -37315,
 1849388657,
 9997,
 -1,
 1849442752,
 8768,
 1849688063,
 1849376935,
 -1,
 -37312,
 1849606331,
 9840,
 -1,
 1849636960,
 10172,
 1849847486,
 1838641047,
 -1,
 1849913018,
 1849759118,
 -1,
 1849978551,
 1849874629,
 -1,
 1850044028,
 1849915070,
 -1,
 1850109563,
 1850002686,
 -1,
 1850175054,
 1850050882,
 -1,
 1850240586,
 1850102623,
 43412,
 1850343423,
 1850148226,
 43402,
 -1,
 1850214854,
 43403,
 1850437196,
 1850205436,
 43418,
 -1,
 1850344958,
 43416,
 1850605567,
 1850348942,
 43428,
 -1,
 1850476030,
 43423,
 1850699347,
 1850131320,
 -1,
 1850764881,
 1850655673,
 43419,
 -1,
 1850672592,
 43420,
 1850933247,
 1850676622,
 43424,
 -1,
 1850803710,
 43425,
 1851027032,
 1850619436,
 -1,
 1851092566,
 1850947223,
 43421,
 -1,
 1851000272,
 43422,
 1851260927,
 1851004302,
 43426,
 -1,
 1851131344,
 43427,
 1851354716,
 1850980394,
 43441,
 1851457535,
 1851262413,
 -1,
 -37285,
 1851381366,
 43439,
 -1,
 1851398462,
 43440,
 1851616864,
 1851302096,
 43429,
 1851719679,
 1851523072,
 -1,
 -37281,
 1851623624,
 43430,
 -1,
 1851666237,
 43401,
 1851879012,
 1851552013,
 43407,
 1851981823,
 1851785216,
 -1,
 -37277,
 1851898050,
 43408,
 -1,
 1851951304,
 43409,
 1852141159,
 1851810279,
 43398,
 -37274,
 1852072423,
 43399,
 -1,
 1852114201,
 43397,
 1852337769,
 1852090929,
 43435,
 -1,
 1852244028,
 43436,
 1852468843,
 1852272537,
 43415,
 -1,
 1852376528,
 43417,
 1852599917,
 1852396383,
 43410,
 -1,
 1852507646,
 43411,
 1852730991,
 1852517728,
 43413,
 -1,
 1852638718,
 43414,
 1852862065,
 1852647117,
 43431,
 -1,
 1852769790,
 43432,
 1852993139,
 1852773774,
 43396,
 -1,
 1852924391,
 43405,
 -37260,
 1852957948,
 43434,
 -37259,
 1853087234,
 43438,
 -37258,
 1853148910,
 43400,
 -37257,
 1853198834,
 43406,
 -37256,
 1853259925,
 43433,
 -37255,
 1853322265,
 43437,
 -37254,
 1853380881,
 43442,
 -1,
 1853440167,
 43404,
 -1,
 1850036909,
 43457,
 1853714065,
 1849991376,
 -1,
 1853779598,
 1853634202,
 -1,
 1853845123,
 1853715396,
 -1,
 1853910658,
 1853804270,
 -1,
 -37247,
 1853852846,
 43465,
 -1,
 1853907344,
 43461,
 -1,
 1853843830,
 43464,
 1854172807,
 1853756814,
 -1,
 1854238342,
 1854093179,
 43466,
 -1,
 1854144566,
 43467,
 -1,
 1854180173,
 43459,
 1854434954,
 1854120043,
 -1,
 -37239,
 1854369126,
 43468,
 -1,
 1854414536,
 43463,
 -37237,
 1854398514,
 43462,
 -37236,
 1854589322,
 43486,
 -37235,
 1854636235,
 43460,
 -1,
 1854696813,
 43487,
 1854930943,
 1853721626,
 -1,
 -37232,
 1854843720,
 43471,
 -1,
 1854894864,
 43456,
 1855090335,
 1853634980,
 -1,
 1855155861,
 1855046520,
 -1,
 -37228,
 1855119969,
 43474,
 -1,
 1855152318,
 43475,
 1855352472,
 1855109040,
 -1,
 -37225,
 1855287132,
 43478,
 -1,
 1855343791,
 43479,
 1855549083,
 1855278750,
 -1,
 -37222,
 1855495282,
 43476,
 -1,
 1855549157,
 43477,
 -37220,
 1855514735,
 43472,
 -37219,
 1855690274,
 43473,
 -37218,
 1855753503,
 43481,
 -1,
 1855800663,
 43480,
 1856007851,
 1855053192,
 -1,
 1856073381,
 1855964024,
 -1,
 1856138916,
 1855985038,
 -1,
 -37213,
 1856091974,
 43444,
 -1,
 1856142275,
 43450,
 -1,
 1856083220,
 43445,
 1856401063,
 1856037826,
 43446,
 -1,
 1856308711,
 43447,
 1856532137,
 1856356941,
 43448,
 -1,
 1856439790,
 43449,
 -37206,
 1856479952,
 43452,
 -1,
 1856584256,
 43451,
 1856794289,
 1855962305,
 -1,
 1856859822,
 1856712397,
 43393,
 -1,
 1856768728,
 43443,
 -37201,
 1856823333,
 43395,
 -37200,
 1856938326,
 43392,
 -1,
 1856992903,
 43394,
 1857187509,
 1856713407,
 -1,
 -37197,
 1857135294,
 43454,
 -37196,
 1857188436,
 43453,
 -1,
 1857236333,
 43455,
 -37194,
 1857146302,
 43469,
 -1,
 1857400934,
 43458,
 1857617919,
 1849925958,
 -1,
 -37191,
 1857513647,
 12292,
 -1,
 1857562464,
 9979,
 1857777341,
 1849872110,
 -1,
 -37188,
 1857725539,
 9795,
 -1,
 1857785329,
 9909,
 -1,
 1857721353,
 10781,
 1858039517,
 1849796675,
 -1,
 1858105046,
 1857951118,
 -1,
 1858170580,
 1858027482,
 -1,
 1858236113,
 1858084732,
 -1,
 1858301646,
 1858196733,
 -1,
 1858367179,
 1858238193,
 9624,
 1858469887,
 1858273402,
 -1,
 1858498248,
 1858393393,
 -1,
 -37177,
 1858449134,
 9628,
 -1,
 1858500337,
 9627,
 1858732031,
 1858436797,
 -1,
 -37174,
 1858645742,
 9626,
 -1,
 1858696966,
 9625,
 1858928639,
 1858318062,
 9629,
 1858994175,
 1858797829,
 9630,
 -1,
 1858863381,
 9631,
 1859125247,
 1858240189,
 -1,
 -37168,
 1859038958,
 9623,
 -1,
 1859090161,
 9622,
 1859321855,
 1858196713,
 -1,
 -37165,
 1859233517,
 8279,
 -1,
 1859283508,
 10764,
 -37163,
 1858127437,
 10774,
 -1,
 1859434185,
 9833,
 1859612379,
 1858030415,
 -1,
 1859677914,
 1859518464,
 -1,
 -37159,
 1859617469,
 63,
 -1,
 1859669415,
 8264,
 -1,
 1859601092,
 8799,
 -37156,
 1859558164,
 34,
 -1,
 1859872832,
 9915,
 1860071160,
 1858004984,
 -1,
 1860136690,
 1859978794,
 -1,
 1860202214,
 1860089776,
 -1,
 1860267749,
 1860120519,
 -1,
 1860333284,
 1860214891,
 -1,
 -37149,
 1860285599,
 10785,
 -1,
 1860332605,
 10784,
 -1,
 1860252303,
 10783,
 -1,
 1860216316,
 10625,
 1860660972,
 1860151766,
 -1,
 1860726506,
 1860592976,
 -1,
 -37143,
 1860658898,
 10632,
 -1,
 1860708767,
 10634,
 -37141,
 1860650473,
 10814,
 -1,
 1860837043,
 10853,
 1861054191,
 1860597494,
 -1,
 -37138,
 1860986578,
 10631,
 -1,
 1861036447,
 10633,
 -37136,
 1861013207,
 10626,
 -37135,
 1861171981,
 10852,
 -1,
 1861232390,
 8959,
 1861484543,
 1860061743,
 -1,
 1861512950,
 1861389809,
 -1,
 -37131,
 1861454221,
 8204,
 -1,
 1861488405,
 65279,
 -37129,
 1861468042,
 8203,
 -1,
 1861644442,
 8205,
 1861877759,
 1860035542,
 -1,
 -37126,
 1861785720,
 8891,
 -1,
 1861813417,
 8999]
_charnames_32 = [
20227,
12018,
28379,
27332,
24908,
26955,
15982,
15782,
9824,
26002,
15966,
26920,
3790,
21523,
27830,
20150,
25243,
25247,
25217,
25221,
25235,
25239,
25226,
25230,
25255,
25251,
4033,
20181,
10095,
11970,
22227,
28376,
3789,
8659,
9071,
8984,
8934,
8601,
9094,
8969,
8952,
8765,
9081,
9014,
8877,
9060,
8916,
8538,
9050,
9090,
8853,
8833,
8801,
8714,
9040,
9028,
9086,
8899,
8998,
9728,
26366,
25935,
4958,
10188,
22229,
7982,
8416,
8326,
8247,
7849,
8497,
8384,
8306,
8097,
8489,
8400,
8211,
8456,
8281,
7918,
8443,
8482,
8173,
8138,
7781,
8041,
8430,
8470,
8504,
8366,
8346,
9777,
24534,
25988,
13356,
]

_charnames_160 = [
27296,
27634,
5207,
26973,
2535,
17290,
17553,
20187,
25329,
3985,
27894,
9950,
27275,
20154,
26393,
6527,
25206,
26937,
19750,
19751,
15975,
7773,
26966,
7771,
5209,
19764,
6524,
26127,
24574,
24576,
24581,
27630,
8700,
8701,
8662,
8696,
8677,
8687,
8702,
8987,
8645,
8647,
8604,
8627,
8789,
8791,
8784,
8773,
8653,
8929,
8592,
8594,
8561,
8569,
8558,
7347,
8584,
8760,
8762,
8755,
8718,
8914,
8828,
8171,
8027,
8028,
7985,
8023,
8000,
8012,
8029,
8329,
7895,
7897,
7852,
7875,
8125,
8127,
8119,
8108,
7913,
8296,
7971,
7973,
7941,
7949,
7938,
25342,
7966,
8089,
8091,
8082,
8045,
8382,
7839,
8372,
8694,
8021,
8679,
8002,
8690,
8017,
8994,
8337,
8989,
8332,
8993,
8336,
8990,
8333,
8943,
8253,
8939,
8262,
8636,
7884,
8646,
7896,
8621,
7869,
8632,
7880,
8617,
7865,
8972,
8387,
8979,
8395,
8978,
8394,
8973,
8388,
8961,
8315,
8964,
8318,
8779,
8114,
8781,
8116,
8790,
8126,
8775,
8110,
8771,
8275,
9100,
8520,
9085,
8493,
9023,
8409,
8415,
8897,
8234,
8885,
8216,
8886,
8217,
8892,
8224,
8888,
8229,
8932,
8301,
8924,
8287,
8925,
8288,
8302,
8658,
7917,
8575,
7958,
8593,
7972,
8557,
7937,
9099,
8518,
8871,
8197,
8866,
8191,
8867,
8192,
8845,
8150,
8839,
8144,
8840,
8145,
8836,
8141,
8806,
7817,
8807,
7818,
8813,
7826,
8746,
8073,
8740,
8067,
8761,
8090,
8758,
8086,
8729,
8056,
8750,
8077,
9037,
8480,
8913,
8381,
8905,
9013,
8365,
9003,
8351,
9010,
8356,
8235,
8422,
9079,
9076,
8421,
8826,
7835,
8596,
8992,
8335,
8712,
8949,
8947,
8255,
7810,
8874,
8851,
8597,
9096,
8501,
8977,
8983,
8324,
8800,
8786,
9026,
8413,
8227,
8246,
8821,
8921,
8290,
8579,
8541,
7921,
8600,
7981,
9056,
8451,
9164,
8825,
7834,
8657,
9150,
7828,
8816,
7831,
8814,
8732,
8059,
8764,
9046,
8906,
8373,
9007,
8359,
8648,
8651,
7906,
7904,
9167,
8827,
7836,
9158,
9165,
9170,
9169,
9162,
9151,
8951,
8938,
8270,
8898,
8889,
8244,
8933,
8930,
8304,
8669,
7992,
8785,
8120,
8568,
7948,
8757,
8084,
8721,
8048,
8724,
8051,
8723,
8050,
8722,
8049,
7809,
8678,
8001,
8674,
7997,
8704,
8031,
8975,
8390,
8974,
8389,
9024,
8410,
8586,
7968,
8587,
7969,
8650,
7903,
8494,
8950,
8937,
8266,
8980,
8396,
8966,
9039,
8931,
8300,
8688,
8013,
8705,
8032,
8585,
7967,
8676,
7999,
8698,
8025,
8626,
7874,
8643,
7893,
8772,
8107,
8787,
8123,
8556,
7936,
8591,
7970,
8861,
8181,
8870,
8196,
8728,
8055,
8759,
8088,
8838,
8143,
8804,
7815,
8915,
8383,
8963,
8317,
8919,
8250,
8598,
7979,
9012,
8364,
8673,
7996,
8615,
7863,
8559,
7939,
8571,
7951,
8552,
7932,
8553,
7933,
8910,
8378,
8214,
8285,
7814,
8272,
8280,
8488,
8697,
8991,
8334,
8896,
8812,
8153,
8358,
8981,
8397,
9077,
8763,
8820,
8642,
7890,
9084,
8495,
8849,
8485,
8868,
8193,
8909,
8376,
7792,
8035,
7793,
8426,
7975,
8331,
8256,
8257,
8207,
8165,
8168,
7977,
8200,
8203,
8342,
8273,
8393,
8169,
9125,
8399,
8210,
7789,
8320,
8323,
8121,
8135,
9123,
8223,
8226,
8230,
8245,
7798,
7799,
8464,
8292,
8297,
9138,
8429,
9113,
8341,
8455,
7784,
7787,
7788,
8186,
8184,
8188,
8206,
9105,
9124,
8156,
7907,
8274,
8170,
7911,
7805,
7827,
8092,
8093,
8438,
7804,
7803,
7802,
9132,
8360,
8354,
7898,
7902,
9159,
9168,
9157,
9146,
9155,
9127,
8340,
9126,
9142,
8492,
7807,
9121,
8484,
9160,
9149,
8268,
8277,
8269,
7844,
7846,
7847,
8503,
8243,
8241,
9154,
9156,
7790,
7791,
6618,
6619,
6613,
6586,
6538,
6539,
6552,
6622,
6620,
6792,
6762,
6789,
6798,
6735,
6731,
6703,
6780,
6734,
6704,
6732,
6775,
6760,
6675,
3400,
6787,
6752,
6799,
6779,
6694,
6696,
6698,
6700,
6790,
6771,
6670,
6671,
6774,
6759,
6793,
6751,
17554,
24892,
26141,
25878,
20108,
24790,
6736,
6673,
6574,
6594,
6559,
6621,
6589,
6711,
6769,
6744,
6689,
6718,
6783,
6784,
6786,
6777,
6763,
6687,
6695,
6681,
6693,
6692,
6750,
6748,
6749,
6690,
6729,
6796,
6722,
6795,
6721,
6630,
6800,
6680,
3668,
3678,
3485,
3728,
3696,
3764,
3744,
3590,
3621,
3767,
3648,
3587,
3479,
3759,
3569,
3585,
3481,
3738,
3732,
3474,
3651,
3475,
3669,
3679,
3548,
3643,
3539,
3766,
3542,
3753,
3596,
3776,
3705,
3777,
3653,
3592,
3622,
3647,
3476,
3487,
3762,
3758,
3748,
3741,
3480,
3486,
3746,
3739,
3731,
3704,
3559,
3583,
3730,
3720,
3555,
3721,
3556,
3640,
3740,
3724,
3726,
3774,
3760,
3582,
3670,
3680,
3662,
3663,
3664,
3661,
3749,
3716,
3568,
3538,
3785,
3768,
3694,
3546,
3752,
3674,
3633,
3543,
3783,
3773,
3532,
3634,
3631,
3641,
3591,
3690,
3576,
3771,
3581,
3580,
3578,
3579,
3571,
3584,
3577,
3491,
3503,
3501,
3513,
3510,
3505,
3520,
3517,
3515,
3495,
3511,
3509,
3508,
21927,
21740,
21871,
21654,
22184,
22114,
21911,
21721,
-1,
-1,
22173,
21746,
21748,
21747,
22183,
-1,
-1,
-1,
-1,
-1,
22139,
22122,
21868,
22023,
21838,
21825,
21889,
-1,
21797,
-1,
21904,
21784,
21689,
21841,
21931,
21928,
21929,
21827,
21921,
21800,
21917,
21872,
21926,
21925,
21924,
21923,
21922,
21786,
21909,
21919,
-1,
21913,
21918,
21892,
21910,
21930,
21908,
21759,
21880,
21900,
21651,
21618,
21606,
21707,
21662,
21621,
21744,
21741,
21734,
21607,
21735,
21578,
21727,
21683,
21731,
21739,
21738,
21737,
21736,
21564,
21719,
21722,
21742,
21715,
21728,
21656,
21720,
21743,
21718,
21535,
21686,
21659,
21575,
21680,
21563,
21937,
22186,
22134,
22164,
22166,
22165,
22149,
22148,
22160,
22110,
21655,
22105,
21714,
22109,
21733,
22108,
21730,
22106,
21713,
3925,
3833,
3959,
3867,
3939,
3847,
3952,
3860,
3955,
3863,
3924,
3832,
3920,
3828,
22159,
22170,
22112,
22107,
21936,
22113,
22171,
21914,
21716,
21932,
21915,
21712,
22169,
21934,
21938,
21935,
4327,
4315,
4363,
4435,
4443,
4358,
4413,
4392,
4492,
4480,
4484,
4397,
4312,
4331,
4340,
4362,
4417,
4416,
4490,
4428,
4367,
4325,
4370,
4377,
4314,
4338,
4305,
4279,
4288,
4273,
4468,
4474,
4286,
4284,
4399,
4436,
4290,
4445,
4398,
4453,
4344,
4343,
4450,
4383,
4349,
4272,
4390,
4387,
4188,
4187,
4262,
4199,
4138,
4096,
4141,
4148,
4085,
4109,
4076,
4050,
4059,
4044,
4246,
4240,
4057,
4055,
4170,
4207,
4061,
4216,
4169,
4224,
4115,
4114,
4221,
4154,
4120,
4043,
4161,
4158,
4098,
4086,
4134,
4206,
4214,
4129,
4184,
4163,
4264,
4252,
4256,
4168,
4083,
4102,
4111,
4133,
4469,
4247,
4388,
4159,
4320,
4091,
4481,
4253,
4319,
4090,
4412,
4183,
4322,
4093,
4311,
4082,
4478,
4244,
4493,
4265,
4333,
4104,
4334,
4105,
4442,
4213,
4466,
4237,
4470,
4248,
4471,
4249,
4304,
4075,
4502,
3462,
3458,
3471,
3459,
3460,
3466,
3469,
4339,
4110,
4355,
4126,
4287,
4058,
4432,
4203,
4430,
4201,
4433,
4204,
4374,
4145,
4380,
4151,
4310,
4081,
4307,
4078,
4308,
4079,
4409,
4180,
4278,
4049,
4496,
4268,
4476,
4242,
4421,
4192,
4285,
4056,
4402,
4173,
4351,
4122,
4352,
4123,
4449,
4220,
4495,
4267,
4457,
4228,
4458,
4229,
4342,
4113,
4419,
4190,
4420,
4191,
4500,
4375,
4146,
4309,
4080,
4281,
4052,
4277,
4048,
4275,
4046,
4313,
4084,
4289,
4060,
4245,
4425,
4196,
4424,
4195,
4497,
4269,
4328,
4099,
4353,
4124,
4354,
4125,
4373,
4144,
4379,
4150,
4422,
4193,
4330,
4101,
4332,
4103,
4472,
4250,
4407,
4178,
4408,
4179,
4291,
4062,
4441,
4212,
4440,
4211,
4439,
4210,
4456,
4227,
4434,
4205,
4385,
4156,
4431,
4202,
4448,
4219,
4447,
4218,
4298,
4069,
4297,
4068,
4299,
4070,
4296,
4067,
4303,
4074,
4302,
4073,
4301,
4072,
4300,
4071,
4463,
4234,
4283,
4054,
4482,
4254,
4467,
4238,
4389,
4160,
4491,
4263,
4489,
4261,
4426,
4197,
4282,
4053,
4276,
4047,
4477,
4243,
]

_charnames_1329 = [
15653,
15652,
15641,
15651,
15613,
15616,
15612,
15611,
15623,
15615,
15648,
15647,
15643,
15609,
15635,
15649,
15639,
15642,
15606,
15646,
15617,
15645,
15626,
15620,
15607,
15633,
15638,
15630,
15627,
15621,
15624,
15629,
15608,
15618,
15632,
15636,
15644,
15650,
-1,
-1,
15662,
15659,
15657,
15656,
15654,
15661,
15660,
-1,
15593,
15592,
15581,
15591,
15553,
15556,
15552,
15551,
15563,
15555,
15588,
15587,
15583,
15549,
15575,
15589,
15579,
15582,
15546,
15586,
15557,
15585,
15566,
15560,
15547,
15573,
15578,
15570,
15567,
15561,
15564,
15569,
15548,
15558,
15572,
15576,
15584,
15590,
15601,
-1,
15664,
15663,
-1,
-1,
-1,
-1,
-1,
-1,
21168,
21155,
21154,
21130,
21131,
21140,
21165,
21132,
21161,
21151,
21139,
21147,
21148,
21149,
21157,
21138,
21160,
21169,
21144,
21145,
21142,
21143,
21164,
21158,
21137,
21152,
21166,
21167,
21163,
21133,
21206,
21183,
21174,
21176,
21175,
21179,
21190,
21185,
21192,
21187,
21177,
21178,
21189,
21195,
21193,
21203,
21191,
21201,
21182,
21184,
21200,
21205,
21207,
21202,
21188,
]

_charnames_1488 = [
21063,
21098,
21114,
21116,
21095,
21083,
21102,
21096,
21075,
21079,
21056,
21091,
21112,
21060,
21110,
21059,
21108,
21051,
21071,
21054,
21087,
21058,
21073,
21106,
21104,
21042,
21077,
-1,
-1,
-1,
-1,
-1,
21122,
21124,
21121,
21199,
21198,
]

_charnames_1536 = [
15518,
15435,
15468,
15437,
-1,
-1,
15540,
15539,
15500,
15538,
15537,
15992,
15520,
15478,
15502,
15445,
15436,
15446,
15442,
15443,
15444,
15415,
15406,
15416,
15430,
15431,
15429,
15458,
-1,
-1,
15485,
15517,
-1,
14885,
14959,
14955,
15284,
14951,
15123,
14946,
15188,
14764,
14761,
14814,
15348,
14863,
15032,
14894,
14821,
15156,
15332,
15082,
15109,
15099,
14909,
14825,
15325,
14979,
15266,
15003,
15001,
15231,
15229,
15230,
15482,
15237,
15368,
15010,
15310,
15378,
15040,
14834,
15281,
14973,
15120,
15465,
15473,
15488,
15460,
15472,
15487,
15453,
15448,
15512,
15515,
15514,
15452,
15519,
15511,
15516,
15494,
15495,
15496,
15499,
15462,
-1,
15532,
15533,
15524,
15525,
15530,
15531,
15527,
15528,
15535,
15534,
15504,
15479,
15486,
15469,
14944,
14942,
15118,
14969,
14965,
14964,
14887,
14891,
14890,
15361,
14889,
14799,
14800,
15212,
14772,
14771,
15296,
14777,
15205,
14878,
14868,
15074,
14930,
14872,
14784,
14785,
14922,
14905,
14903,
14904,
14917,
14926,
14937,
14899,
14906,
15183,
15161,
15170,
15168,
15162,
15169,
15167,
15355,
15173,
15093,
15086,
15087,
15102,
15103,
14830,
14987,
14943,
15246,
15247,
15337,
15243,
15297,
15372,
15371,
14995,
15117,
15016,
15017,
15060,
15015,
15254,
15260,
15061,
15258,
15274,
15259,
15316,
15317,
15315,
15314,
15050,
15051,
15176,
15049,
15045,
14844,
14796,
14852,
14836,
14841,
14767,
15292,
15028,
15395,
15359,
15151,
15024,
15291,
15336,
15220,
15132,
15133,
15293,
15388,
15131,
15134,
15137,
15467,
14993,
15404,
15405,
15411,
15407,
15422,
15414,
15419,
15509,
15457,
15420,
15418,
15423,
15410,
15425,
15412,
15428,
15427,
15417,
15421,
15503,
15507,
15508,
15498,
15426,
14901,
15171,
12011,
12012,
12003,
12004,
12009,
12010,
12006,
12007,
12014,
12013,
15114,
14914,
15271,
15440,
15439,
14856,
19319,
19289,
19293,
19287,
19291,
19284,
19323,
19322,
19288,
19292,
19324,
19281,
19282,
19283,
-1,
19335,
19273,
19238,
19272,
19258,
19259,
19262,
19261,
19256,
19264,
19263,
19257,
19248,
19249,
19251,
19252,
19269,
19268,
19267,
19266,
19240,
19270,
19271,
19242,
19255,
19241,
19265,
19254,
19239,
19250,
19246,
19244,
19245,
19314,
19313,
19312,
19310,
19309,
19308,
19304,
19303,
19329,
19330,
19278,
19277,
19279,
19318,
19317,
19305,
19333,
19331,
19306,
19297,
19296,
19300,
19299,
19327,
19326,
19332,
19334,
-1,
-1,
19235,
19236,
19237,
15195,
15199,
15193,
15194,
15196,
15198,
15197,
14869,
14871,
14898,
14902,
15164,
15091,
14984,
14986,
14983,
15244,
15242,
15004,
15002,
15000,
15382,
15381,
15044,
15048,
15047,
15318,
15166,
15172,
15088,
14877,
14875,
15089,
15163,
14876,
14967,
14968,
15225,
15226,
15227,
15289,
15290,
15142,
15143,
14879,
15092,
15090,
15014,
13805,
13777,
13795,
13812,
13819,
13798,
13802,
13807,
13811,
13815,
13817,
13793,
13769,
13799,
13788,
13786,
13778,
13791,
13782,
13773,
13809,
13814,
13816,
13818,
13771,
13804,
13801,
13770,
13783,
13776,
13779,
13792,
13772,
13784,
13808,
13787,
13813,
13810,
13829,
13830,
13833,
13826,
13831,
13821,
13827,
13825,
13822,
13823,
13832,
13796,
]

_charnames_1984 = [
27192,
27193,
27184,
27185,
27190,
27191,
27187,
27188,
27195,
27194,
27179,
27161,
27173,
27160,
27166,
27159,
27158,
27163,
27144,
27178,
27169,
27167,
27154,
27177,
27162,
27157,
27156,
27168,
27175,
27176,
27172,
27171,
27148,
27170,
27145,
27147,
27174,
27165,
27164,
27146,
27152,
27153,
27151,
27206,
27205,
27204,
27202,
27201,
27200,
27199,
27207,
27208,
27213,
27180,
27211,
27212,
27209,
27214,
27181,
-1,
-1,
-1,
-1,
-1,
19589,
19576,
19586,
19588,
19569,
19577,
19578,
19570,
19566,
19579,
19585,
19584,
19583,
19582,
19573,
19571,
19587,
19565,
19581,
19580,
19574,
19567,
19629,
19630,
19631,
19634,
19638,
19633,
19596,
19607,
19599,
19593,
19604,
19598,
19592,
19603,
19636,
19602,
19594,
19605,
19637,
19595,
19606,
19597,
19601,
19632,
-1,
-1,
19624,
19615,
19612,
19626,
19613,
19621,
19639,
19625,
19617,
19623,
19618,
19622,
19614,
19620,
19611,
]

_charnames_2304 = [
25053,
25037,
25049,
25045,
24917,
24964,
24967,
25001,
25002,
24996,
24997,
24932,
24934,
24955,
24916,
25010,
24966,
24954,
24915,
25007,
24965,
24981,
24980,
24950,
24947,
24942,
24952,
24957,
24985,
24984,
24941,
24961,
24960,
24927,
24926,
24940,
24963,
24962,
24929,
24928,
24943,
24939,
25000,
24999,
24989,
24987,
25008,
24995,
24971,
24969,
24976,
24975,
24974,
24936,
24918,
24919,
24920,
25005,
-1,
-1,
25052,
25048,
25024,
25030,
25031,
25025,
25026,
25013,
25014,
25020,
25029,
25034,
25023,
25018,
25028,
25033,
25022,
25046,
25032,
-1,
25082,
25057,
25058,
25077,
25080,
25019,
-1,
-1,
25006,
24979,
24946,
24992,
24924,
24970,
25009,
24994,
24933,
24935,
25015,
25016,
25075,
25074,
25070,
25071,
25062,
25063,
25068,
25069,
25065,
25066,
25073,
25072,
25081,
25054,
24956,
-1,
-1,
-1,
-1,
-1,
-1,
24991,
25004,
24949,
24983,
24948,
24925,
24988,
-1,
18617,
18615,
18611,
-1,
18540,
18543,
18563,
18564,
18555,
18556,
18519,
18521,
-1,
-1,
18578,
18542,
-1,
-1,
18574,
18541,
18551,
18549,
18567,
18566,
18532,
18570,
18569,
18562,
18561,
18530,
18526,
18525,
18537,
18536,
18531,
18528,
18527,
18539,
18538,
18533,
-1,
18559,
18558,
18573,
18572,
18575,
18554,
18512,
-1,
18576,
-1,
-1,
-1,
18546,
18545,
18547,
18577,
-1,
-1,
18616,
18614,
18588,
18591,
18592,
18589,
18590,
18581,
18582,
-1,
-1,
18594,
18587,
-1,
-1,
18593,
18586,
18612,
18550,
]

_charnames_2519 = [
18632,
-1,
-1,
-1,
-1,
18516,
18517,
-1,
18553,
18520,
18522,
18583,
18584,
-1,
-1,
18605,
18606,
18597,
18598,
18603,
18604,
18600,
18601,
18608,
18607,
18514,
18515,
18629,
18628,
18623,
18621,
18622,
18625,
18624,
18626,
18630,
18631,
-1,
-1,
-1,
-1,
-1,
22443,
22442,
22437,
-1,
22363,
22366,
22394,
22395,
22377,
22378,
-1,
-1,
-1,
-1,
22409,
22365,
-1,
-1,
22405,
22364,
22371,
22370,
22376,
22375,
22355,
22398,
22397,
22393,
22392,
22353,
22349,
22348,
22360,
22359,
22354,
22351,
22350,
22362,
22361,
22356,
-1,
22387,
22386,
22401,
22400,
22406,
22403,
22384,
-1,
22390,
22389,
-1,
22404,
22380,
-1,
22381,
22407,
-1,
-1,
22441,
-1,
22428,
22431,
22432,
22429,
22430,
-1,
-1,
-1,
-1,
22434,
22427,
-1,
-1,
22433,
22426,
22438,
-1,
-1,
-1,
22440,
]

_charnames_2662 = [
22420,
22421,
22412,
22413,
22418,
22419,
22415,
22416,
22423,
22422,
22445,
22448,
22446,
22444,
22447,
22439,
]

_charnames_2689 = [
22341,
22339,
22335,
-1,
22257,
22260,
22279,
22280,
22265,
22266,
22235,
22237,
22318,
-1,
22295,
22259,
22317,
-1,
22292,
22258,
22275,
22274,
22283,
22282,
22249,
22286,
22285,
22278,
22277,
22247,
22243,
22242,
22254,
22253,
22248,
22245,
22244,
22256,
22255,
22250,
-1,
22269,
22268,
22289,
22288,
22293,
22290,
22291,
-1,
22272,
22271,
-1,
22239,
22263,
22262,
22264,
22294,
-1,
-1,
22340,
22338,
22306,
22309,
22310,
22307,
22308,
22299,
22300,
22313,
-1,
22315,
22305,
22312,
-1,
22314,
22304,
22336,
-1,
-1,
22343,
]

_charnames_2784 = [
22236,
22238,
22301,
22302,
-1,
-1,
22329,
22330,
22321,
22322,
22327,
22328,
22324,
22325,
22332,
22331,
-1,
22342,
]

_charnames_2817 = [
25779,
25777,
25773,
-1,
25696,
25699,
25725,
25726,
25711,
25712,
25674,
25676,
-1,
-1,
25740,
25698,
-1,
-1,
25737,
25697,
25721,
25720,
25729,
25728,
25688,
25732,
25731,
25724,
25723,
25686,
25682,
25681,
25693,
25692,
25687,
25684,
25683,
25695,
25694,
25689,
-1,
25715,
25714,
25735,
25734,
25738,
25710,
25707,
-1,
25718,
25717,
-1,
25678,
25702,
25701,
25703,
25739,
-1,
-1,
25778,
25776,
25750,
25753,
25754,
25751,
25752,
25743,
25744,
-1,
-1,
25756,
25749,
-1,
-1,
25755,
25748,
25774,
]

_charnames_2902 = [
25782,
25781,
-1,
-1,
-1,
-1,
25705,
25706,
-1,
25709,
25675,
25677,
25745,
25746,
-1,
-1,
25767,
25768,
25759,
25760,
25765,
25766,
25762,
25763,
25770,
25769,
25783,
25736,
]

_charnames_2946 = [
12417,
12415,
-1,
12426,
12429,
12449,
12450,
12439,
12440,
-1,
-1,
-1,
12451,
12452,
12428,
-1,
12447,
12448,
12427,
12457,
-1,
-1,
-1,
12424,
12460,
-1,
12458,
-1,
12423,
12442,
-1,
-1,
-1,
12422,
12443,
-1,
-1,
-1,
12425,
12421,
12455,
-1,
-1,
-1,
12456,
12453,
12446,
12445,
12438,
12437,
12436,
12454,
12432,
12431,
12433,
12459,
-1,
-1,
-1,
-1,
12509,
12514,
12515,
12510,
12511,
-1,
-1,
-1,
12516,
12517,
12508,
-1,
12512,
12513,
12507,
12416,
-1,
-1,
12529,
-1,
-1,
-1,
-1,
-1,
-1,
12525,
]

_charnames_3046 = [
12499,
12500,
12491,
12492,
12497,
12498,
12494,
12495,
12502,
12501,
12522,
12521,
12520,
12504,
12530,
12527,
12503,
12487,
12526,
12528,
12523,
-1,
-1,
-1,
-1,
-1,
-1,
13506,
13504,
13500,
-1,
13410,
13413,
13437,
13438,
13418,
13419,
13386,
13388,
-1,
13442,
13443,
13412,
-1,
13426,
13427,
13411,
13433,
13432,
13441,
13440,
13408,
13446,
13445,
13436,
13435,
13406,
13394,
13393,
13401,
13400,
13407,
13397,
13396,
13404,
13403,
13409,
-1,
13425,
13424,
13449,
13448,
13451,
13450,
13422,
13421,
13430,
13429,
-1,
13390,
13416,
13415,
13417,
13452,
-1,
-1,
-1,
13503,
13463,
13468,
13469,
13464,
13465,
13456,
13457,
-1,
13470,
13471,
13462,
-1,
13466,
13467,
13461,
13501,
]

_charnames_3157 = [
13453,
13507,
-1,
13395,
13402,
-1,
-1,
-1,
-1,
-1,
-1,
13387,
13389,
13458,
13459,
-1,
-1,
13482,
13483,
13474,
13475,
13480,
13481,
13477,
13478,
13485,
13484,
]

_charnames_3192 = [
13497,
13495,
13489,
13492,
13496,
13490,
13493,
13505,
-1,
-1,
23211,
23207,
-1,
23126,
23129,
23155,
23156,
23139,
23140,
23104,
23106,
-1,
23160,
23161,
23128,
-1,
23147,
23148,
23127,
23151,
23150,
23159,
23158,
23118,
23164,
23163,
23154,
23153,
23116,
23112,
23111,
23123,
23122,
23117,
23114,
23113,
23125,
23124,
23119,
-1,
23146,
23145,
23167,
23166,
23169,
23168,
23143,
23142,
23138,
23137,
-1,
23108,
23132,
23131,
23133,
23170,
-1,
-1,
23213,
23210,
23182,
23187,
23188,
23183,
23184,
23175,
23176,
-1,
23189,
23190,
23181,
-1,
23185,
23186,
23180,
23208,
]

_charnames_3294 = [
23171,
-1,
23105,
23107,
23177,
23178,
-1,
-1,
23201,
23202,
23193,
23194,
23199,
23200,
23196,
23197,
23204,
23203,
-1,
23214,
23212,
]

_charnames_3330 = [
6432,
6428,
-1,
6350,
6353,
6379,
6380,
6363,
6364,
6328,
6330,
-1,
6384,
6385,
6352,
-1,
6371,
6372,
6351,
6375,
6374,
6383,
6382,
6342,
6325,
6324,
6378,
6377,
6340,
6336,
6335,
6347,
6346,
6341,
6338,
6337,
6349,
6348,
6343,
-1,
6370,
6369,
6388,
6387,
6390,
6389,
6367,
6366,
6362,
6361,
6360,
6332,
6356,
6355,
6357,
6391,
-1,
-1,
-1,
6431,
6401,
6406,
6407,
6402,
6403,
6394,
6395,
-1,
6408,
6409,
6400,
-1,
6404,
6405,
6399,
6429,
]

_charnames_3424 = [
6329,
6331,
6396,
6397,
-1,
-1,
6421,
6422,
6413,
6414,
6419,
6420,
6416,
6417,
6424,
6423,
6437,
6436,
6435,
6440,
6441,
6442,
-1,
-1,
-1,
6425,
6319,
6318,
6322,
6320,
6321,
6323,
-1,
-1,
19941,
19943,
-1,
19850,
19854,
19848,
19849,
19882,
19883,
19900,
19901,
19877,
19878,
19880,
19881,
19906,
19907,
19853,
19903,
19904,
19851,
-1,
-1,
-1,
19842,
19865,
19844,
19867,
19911,
19889,
19845,
19868,
19843,
19866,
19894,
19893,
19888,
19836,
19859,
19839,
19862,
19873,
19886,
19837,
19860,
19840,
19863,
19897,
-1,
19887,
19841,
19864,
19846,
19869,
19870,
19852,
19908,
19910,
-1,
19898,
-1,
-1,
19909,
19892,
19872,
19896,
19912,
19874,
19913,
-1,
-1,
-1,
19942,
-1,
-1,
-1,
-1,
19938,
19926,
19934,
19925,
19933,
19924,
-1,
19931,
-1,
19937,
19917,
19932,
19922,
19921,
19920,
19919,
19936,
]

_charnames_3585 = [
13701,
13698,
13696,
13695,
13697,
13699,
13717,
13725,
13728,
13726,
13661,
13727,
13731,
13746,
13678,
13669,
13674,
13673,
13715,
13745,
13677,
13671,
13670,
13672,
13714,
13749,
13710,
13706,
13735,
13707,
13736,
13708,
13690,
13732,
13740,
13739,
13720,
13722,
13747,
13662,
13663,
13660,
13743,
13721,
13748,
13742,
13711,
13643,
13685,
13649,
13647,
13654,
13655,
13651,
13652,
13650,
13653,
13709,
-1,
-1,
-1,
-1,
13751,
13657,
13648,
13656,
13645,
13646,
13723,
13688,
13689,
13686,
13684,
13683,
13687,
13675,
13716,
13733,
13737,
13762,
13763,
13754,
13755,
13760,
13761,
13757,
13758,
13765,
13764,
13750,
13700,
]

_charnames_3713 = [
9209,
9208,
-1,
9207,
-1,
-1,
9200,
9222,
-1,
9211,
-1,
-1,
9198,
-1,
-1,
-1,
-1,
-1,
-1,
9221,
9191,
9190,
9189,
-1,
9199,
9223,
9196,
9195,
9185,
9194,
9186,
-1,
9220,
9216,
9204,
-1,
9203,
-1,
9217,
-1,
-1,
9212,
9215,
-1,
9219,
9214,
9270,
9225,
9236,
9229,
9227,
9237,
9238,
9230,
9231,
9232,
9233,
-1,
9235,
9264,
9263,
-1,
-1,
9239,
9240,
9241,
9226,
9228,
-1,
9269,
-1,
9260,
9259,
9258,
9261,
9271,
9268,
-1,
-1,
9252,
9253,
9244,
9245,
9250,
9251,
9247,
9248,
9255,
9254,
-1,
-1,
9266,
9267,
]

_charnames_3840 = [
13110,
13182,
13180,
13181,
13216,
13194,
13192,
13231,
13224,
13208,
13212,
13218,
13235,
13223,
13201,
13220,
13200,
13226,
13227,
13190,
13183,
13174,
13173,
13288,
13290,
13289,
13079,
13078,
13077,
13073,
13072,
13080,
13260,
13261,
13252,
13253,
13258,
13259,
13255,
13256,
13263,
13262,
13248,
13239,
13240,
13245,
13246,
13242,
13243,
13250,
13249,
13247,
13210,
13204,
13191,
13203,
13196,
13221,
13185,
13186,
13229,
13230,
13084,
13088,
13140,
13139,
13156,
13155,
13134,
13159,
13158,
13167,
-1,
13132,
13116,
13115,
13128,
13127,
13133,
13121,
13120,
13130,
13129,
13135,
13153,
13152,
13162,
13161,
13165,
13119,
13118,
13125,
13124,
13164,
13146,
13147,
13171,
13163,
13150,
13166,
13143,
13142,
13144,
13168,
13170,
13137,
13169,
13138,
13149,
-1,
-1,
-1,
-1,
13280,
13276,
13277,
13270,
13271,
13266,
13267,
13268,
13269,
13278,
13279,
13274,
13275,
13082,
13081,
13272,
13273,
13096,
13095,
13234,
13232,
13090,
13085,
13091,
13087,
13094,
13093,
-1,
-1,
-1,
-1,
13037,
13036,
13050,
13049,
13028,
13053,
13052,
13062,
-1,
13026,
13010,
13009,
13022,
13021,
13027,
13015,
13014,
13024,
13023,
13029,
13047,
13046,
13056,
13055,
13060,
13013,
13012,
13019,
13018,
13058,
13043,
13044,
13065,
13057,
13059,
13061,
13032,
13031,
13033,
13063,
13064,
13035,
13040,
13039,
13041,
-1,
13291,
13292,
13284,
13283,
13285,
13282,
13109,
13104,
13108,
13105,
13107,
13099,
13101,
13102,
13103,
-1,
13074,
13071,
13209,
13233,
13199,
13217,
13195,
26133,
9956,
26134,
9957,
]

_charnames_4096 = [
7398,
7370,
7467,
7466,
7435,
7489,
7488,
7484,
7483,
7434,
7432,
7445,
7444,
7456,
7455,
7433,
7447,
7446,
7458,
7457,
7436,
7478,
7477,
7492,
7491,
7429,
7493,
7475,
7481,
7463,
7420,
7495,
7480,
7468,
7417,
7485,
7486,
7471,
7472,
7448,
7428,
7494,
7469,
7595,
7578,
7591,
7592,
7586,
7587,
7593,
7575,
7590,
7589,
7594,
7529,
7533,
7522,
7523,
7528,
7614,
7616,
7615,
7617,
7465,
7607,
7608,
7599,
7600,
7605,
7606,
7602,
7603,
7610,
7609,
7532,
7514,
7558,
7560,
7554,
7559,
7400,
7418,
7438,
7439,
7440,
7441,
7570,
7571,
7572,
7573,
7426,
7427,
7425,
7424,
7619,
7620,
7621,
7419,
7568,
7625,
7624,
7461,
7462,
7585,
7584,
7520,
7519,
7518,
7517,
7516,
7451,
7450,
7452,
7596,
7581,
7580,
7582,
7407,
7406,
7412,
7415,
7408,
7403,
7414,
7404,
7410,
7413,
7416,
7409,
7411,
7622,
7567,
7564,
7565,
7566,
7508,
7507,
7506,
7505,
7512,
7511,
7513,
7474,
7530,
7544,
7545,
7536,
7537,
7542,
7543,
7539,
7540,
7547,
7546,
7526,
7525,
7576,
7577,
7556,
7557,
22612,
22611,
22597,
22610,
22609,
22600,
22579,
22582,
22608,
22591,
22607,
22606,
22605,
22604,
22588,
22578,
22602,
22585,
22581,
22601,
22587,
22590,
22596,
22603,
22584,
22573,
22576,
22593,
22575,
22574,
22598,
22594,
22567,
22570,
22569,
22599,
22566,
22568,
]

_charnames_4304 = [
22497,
22512,
22492,
22511,
22494,
22502,
22474,
22470,
22509,
22486,
22508,
22507,
22506,
22505,
22483,
22473,
22503,
22480,
22469,
22476,
22482,
22485,
22491,
22504,
22479,
22463,
22466,
22488,
22465,
22464,
22500,
22489,
22457,
22460,
22459,
22501,
22456,
22458,
22510,
22499,
22495,
22471,
22498,
22613,
6781,
-1,
-1,
-1,
20686,
20574,
20689,
20669,
20564,
20633,
20697,
20578,
20572,
20541,
20566,
20651,
20631,
20568,
20618,
20688,
20677,
20602,
20706,
20694,
20573,
20691,
20693,
20675,
20647,
20571,
20649,
20684,
20701,
20685,
20594,
20600,
20591,
20581,
20587,
20584,
20586,
20589,
20588,
20597,
20598,
20592,
20599,
20681,
20683,
20551,
20558,
20548,
20557,
20559,
20544,
20545,
20556,
20560,
20554,
20555,
20552,
20549,
20546,
20561,
20614,
20612,
20627,
20625,
20606,
20666,
20658,
20665,
20654,
20663,
20656,
20575,
20661,
20662,
20659,
20655,
20704,
20632,
20616,
20613,
20629,
20626,
20620,
20621,
20617,
20630,
20604,
20682,
20576,
20705,
20687,
20692,
20696,
20695,
20672,
20708,
20538,
20509,
20521,
20457,
20462,
20491,
20482,
20452,
20451,
20496,
20534,
20535,
20508,
20440,
20522,
20533,
20532,
20536,
20429,
20483,
20463,
20465,
20519,
20518,
20461,
20459,
20494,
20493,
20495,
20456,
20455,
20506,
20505,
20499,
20503,
20507,
20443,
20444,
20445,
20448,
20449,
20526,
20527,
20530,
20524,
20528,
20435,
20434,
20433,
20432,
20431,
20437,
20439,
20488,
20486,
20464,
20477,
20468,
20475,
20479,
20481,
20478,
20510,
20513,
20514,
20515,
20537,
20520,
20460,
20454,
20501,
20502,
20340,
20296,
20342,
20388,
20394,
20400,
20376,
20245,
20257,
20263,
20248,
20280,
20275,
20254,
20282,
20357,
20317,
20319,
20299,
20285,
20415,
20422,
20426,
20356,
20387,
20330,
20409,
20344,
20343,
20399,
20391,
20396,
20398,
20392,
20386,
20384,
20259,
20281,
20273,
20274,
20291,
20266,
20265,
20251,
20253,
20262,
20278,
20255,
20261,
20269,
20373,
20371,
20365,
20363,
20361,
20367,
20370,
20374,
20355,
20321,
20327,
20329,
20352,
20308,
20302,
20313,
20305,
20335,
20418,
20420,
20297,
20419,
20402,
20404,
20405,
20334,
20353,
20413,
20411,
20414,
20412,
20408,
20346,
20345,
20349,
20347,
20348,
20294,
11807,
11809,
11810,
11808,
11806,
11805,
11803,
11804,
11870,
11873,
11874,
11871,
11869,
11868,
11866,
11872,
11797,
11800,
11802,
11798,
11796,
11795,
11801,
11799,
11821,
11824,
11825,
11822,
11820,
11819,
11817,
11816,
11495,
11498,
11500,
11496,
11494,
11493,
11499,
11497,
11859,
11863,
11864,
11860,
11858,
11857,
11855,
11862,
11518,
11521,
11522,
11519,
11515,
11509,
11516,
11520,
11487,
11490,
11491,
11488,
11486,
11485,
11483,
11489,
11594,
11596,
11597,
11595,
11593,
11592,
11590,
11591,
11587,
-1,
11589,
11588,
11586,
11585,
-1,
-1,
11571,
11573,
11575,
11572,
11570,
11569,
11574,
-1,
11566,
-1,
11568,
11567,
11565,
11564,
-1,
-1,
11850,
11852,
11853,
11851,
11849,
11848,
11846,
11845,
11906,
11909,
11911,
11907,
11905,
11904,
11910,
11908,
11556,
11559,
11560,
11557,
11555,
11554,
11552,
11558,
11666,
11669,
11670,
11667,
11665,
11664,
11662,
11668,
11749,
11751,
11752,
11750,
11748,
11747,
11745,
11746,
11742,
-1,
11744,
11743,
11741,
11740,
-1,
-1,
11768,
11771,
11772,
11769,
11767,
11766,
11764,
11770,
11759,
11762,
11763,
11760,
11758,
11757,
11755,
11761,
11454,
11457,
11458,
11455,
11453,
11452,
11450,
11456,
11631,
11633,
11634,
11632,
11630,
11629,
11627,
11628,
11624,
-1,
11626,
11625,
11623,
11622,
-1,
-1,
11608,
11610,
11612,
11609,
11607,
11606,
11611,
-1,
11603,
-1,
11605,
11604,
11602,
11601,
-1,
-1,
11899,
11901,
11902,
11900,
11898,
11897,
11895,
11896,
11677,
11679,
11681,
11678,
11676,
11675,
11680,
-1,
11725,
11728,
11729,
11726,
11724,
11723,
11721,
11727,
11707,
11710,
11712,
11708,
11706,
11705,
11711,
11709,
11890,
11892,
11893,
11891,
11889,
11888,
11886,
11887,
11788,
11791,
11792,
11789,
11787,
11786,
11784,
11790,
11779,
11782,
11783,
11780,
11778,
11777,
11775,
11781,
11880,
11883,
11884,
11881,
11879,
11878,
11876,
11882,
11477,
11479,
11480,
11478,
11476,
11475,
11473,
11474,
11470,
-1,
11472,
11471,
11469,
11468,
-1,
-1,
11444,
11446,
11448,
11445,
11443,
11442,
11447,
11440,
11529,
11532,
11533,
11530,
11528,
11527,
11525,
11531,
11657,
11660,
11661,
11658,
11656,
11655,
11653,
11659,
11673,
11688,
11689,
11682,
11686,
11685,
11683,
11687,
11546,
11549,
11551,
11547,
11545,
11544,
11550,
11548,
11539,
11541,
11542,
11540,
11538,
11537,
11535,
11536,
11834,
11837,
11839,
11835,
11833,
11832,
11838,
11831,
11699,
11701,
11702,
11700,
11698,
11697,
11695,
11694,
11861,
11823,
11836,
-1,
-1,
-1,
-1,
11959,
11914,
11964,
11966,
11958,
11913,
11960,
11962,
11965,
11963,
11953,
11945,
11946,
11951,
11952,
11948,
11949,
11955,
11954,
11917,
11919,
11920,
11925,
11926,
11922,
11923,
11929,
11927,
11928,
11918,
-1,
-1,
-1,
11512,
11815,
11814,
11813,
11514,
11844,
11843,
11842,
11513,
11830,
11829,
11828,
11511,
11693,
11692,
11691,
11938,
11932,
11940,
11939,
11934,
11937,
11942,
11941,
11933,
11936,
-1,
-1,
-1,
-1,
-1,
-1,
5059,
5058,
5057,
5055,
5054,
5053,
5046,
5056,
5045,
5044,
5043,
5042,
5041,
5003,
5002,
5001,
4999,
4998,
4997,
5039,
5038,
5037,
5036,
5035,
5034,
5052,
5051,
5050,
5049,
5048,
4989,
5000,
4990,
4995,
4994,
4993,
4992,
4991,
5032,
5031,
5030,
5029,
5028,
5027,
4987,
4981,
4986,
4985,
4984,
4983,
4982,
5011,
4980,
5010,
4979,
5009,
4978,
5007,
5006,
5005,
5008,
4977,
4976,
4975,
4974,
4973,
4972,
4970,
4969,
4968,
4967,
4966,
4965,
5025,
5024,
5023,
5022,
5021,
5020,
5018,
5017,
5016,
5015,
5014,
5013,
]

_charnames_5120 = [
3338,
3334,
3314,
3331,
3333,
3293,
3309,
3104,
2753,
2751,
3311,
3312,
2771,
2849,
2898,
2845,
2899,
2846,
2878,
2843,
2879,
2844,
2912,
2895,
2847,
2897,
2848,
2913,
3318,
3101,
3340,
3149,
3147,
3148,
3144,
3134,
3133,
3139,
3138,
3146,
3143,
3145,
3140,
3335,
3332,
3310,
3321,
3273,
3266,
3271,
3272,
3268,
3270,
3099,
2693,
2692,
3264,
3265,
3263,
2832,
3259,
2828,
3260,
2829,
3256,
2826,
3258,
2827,
3261,
2830,
3262,
2831,
3098,
3254,
2824,
2684,
3030,
3024,
3028,
3029,
3026,
3027,
3102,
2606,
2607,
3022,
3023,
3009,
2822,
3005,
2818,
3006,
2819,
3003,
2816,
3004,
2817,
3007,
2820,
3008,
2821,
2915,
2968,
3000,
2999,
2998,
3001,
3292,
3286,
3290,
3291,
3288,
3289,
3108,
3284,
3285,
3283,
2857,
3281,
2853,
3282,
2854,
3279,
2851,
3280,
2852,
3276,
2855,
3278,
2856,
2918,
3274,
3275,
3088,
3087,
3086,
3089,
2769,
2755,
2766,
2767,
2764,
2765,
3109,
2542,
2754,
2763,
2865,
2759,
2861,
2760,
2862,
2757,
2859,
2758,
2860,
2761,
2863,
2762,
2864,
2919,
2541,
3053,
3200,
3195,
3204,
3205,
3197,
3198,
3106,
3193,
3194,
3192,
2841,
3188,
2837,
3189,
2838,
3186,
2835,
3187,
2836,
3190,
2839,
3191,
2840,
2917,
3184,
2833,
3206,
3317,
3054,
2967,
2921,
2964,
2965,
2957,
2959,
3105,
2901,
2920,
2949,
2875,
2947,
2873,
2948,
2874,
2916,
2900,
2714,
2966,
3183,
3177,
3181,
3182,
3179,
3180,
3107,
3175,
3176,
3167,
2799,
3163,
2795,
3164,
2796,
3161,
2793,
3162,
2794,
3165,
2797,
3166,
2798,
3159,
2791,
3203,
3094,
3056,
3092,
3093,
3084,
3091,
3103,
3032,
3055,
3083,
2782,
3079,
2778,
3080,
2779,
3077,
2776,
3078,
2777,
3081,
2780,
3082,
2781,
2906,
3031,
3316,
3076,
3224,
3199,
2904,
2910,
2908,
2907,
2905,
2909,
3075,
3073,
3074,
3067,
3069,
3070,
3072,
3066,
2790,
3062,
2786,
3063,
2787,
3059,
2784,
3061,
2785,
3064,
2788,
3065,
2789,
3057,
3127,
3120,
3125,
3126,
3122,
3124,
3100,
3118,
3119,
3117,
2813,
3113,
2809,
3114,
2810,
3111,
2807,
3112,
2808,
3115,
2811,
3116,
2812,
2914,
3095,
3232,
2805,
3052,
3253,
3252,
2804,
3244,
3248,
3249,
3246,
3247,
2800,
3242,
3243,
2802,
3240,
2867,
3233,
2866,
3202,
3158,
3153,
3129,
3150,
3154,
3155,
3151,
3152,
3156,
2876,
3128,
2988,
2963,
2984,
2961,
2985,
2962,
2982,
2983,
2986,
2987,
2980,
2823,
2969,
2997,
2996,
2991,
2993,
2990,
3020,
3019,
3018,
3021,
2931,
2927,
2928,
2925,
2926,
2929,
2930,
2924,
2932,
3339,
3325,
3329,
3330,
3327,
3328,
3323,
3324,
3322,
3015,
3014,
3011,
3016,
2870,
2869,
2868,
2871,
2936,
2940,
2941,
2938,
2939,
2934,
2935,
2933,
2950,
3040,
3039,
3036,
3041,
2892,
2891,
2890,
2893,
2881,
3171,
3172,
3169,
3170,
3173,
3174,
3168,
2977,
2973,
2974,
2971,
2972,
2975,
2976,
2970,
3319,
3227,
3226,
3225,
3228,
3212,
3211,
3210,
3213,
3217,
3216,
3215,
3218,
3222,
3221,
3220,
3223,
3046,
3045,
3043,
3047,
2612,
2613,
2610,
2611,
2614,
2615,
2733,
2734,
2731,
2732,
2735,
2736,
2726,
2727,
2724,
2725,
2728,
2729,
2688,
2689,
2686,
2687,
2690,
2691,
2583,
2584,
2581,
2582,
2585,
2586,
2555,
2556,
2553,
2554,
2557,
2558,
2704,
2705,
2702,
2703,
2706,
2707,
2701,
2623,
2624,
2619,
2620,
2625,
2621,
2651,
2652,
2649,
2650,
2653,
2654,
2644,
2645,
2642,
2643,
2646,
2647,
2641,
2711,
2712,
2709,
2710,
2713,
2715,
2740,
2741,
2738,
2739,
2742,
2743,
2719,
2720,
2717,
2718,
2721,
2722,
2666,
3049,
2667,
2663,
2664,
2668,
3051,
2669,
2659,
2660,
2657,
2658,
2661,
2662,
2680,
2681,
2678,
2679,
2682,
2683,
2598,
2599,
2596,
2597,
2600,
2601,
2674,
2675,
2672,
2673,
2676,
2677,
2563,
2564,
2561,
2562,
2565,
2566,
2569,
2570,
2567,
2568,
2571,
2572,
2697,
2698,
2695,
2696,
2699,
2700,
2694,
2752,
2591,
2592,
2589,
2590,
2593,
2594,
2636,
2637,
2634,
2635,
2638,
2639,
2630,
2631,
2628,
2629,
2632,
2633,
2627,
2576,
2577,
2574,
2575,
2578,
2579,
2747,
2748,
2745,
2746,
2749,
2750,
2549,
2550,
2547,
2548,
2551,
2552,
2768,
3157,
3326,
2937,
2953,
2954,
2951,
2952,
2955,
2956,
2889,
2885,
2886,
2883,
2884,
2887,
2888,
2894,
3209,
25875,
25873,
25869,
25871,
25852,
25857,
25845,
25872,
25865,
25863,
25864,
25868,
25870,
25858,
25851,
25866,
25874,
25855,
25843,
25848,
25860,
25849,
25854,
25844,
25861,
25847,
25867,
25877,
25876,
-1,
-1,
-1,
26234,
26226,
26227,
26212,
26211,
26213,
26217,
26185,
26207,
26165,
26210,
26209,
26172,
26154,
26163,
26168,
26167,
26228,
26219,
26197,
26220,
26201,
26186,
26204,
26205,
26214,
26222,
26223,
26174,
26157,
26231,
26155,
26192,
26181,
26184,
26233,
26203,
26175,
26159,
26180,
26230,
26208,
26161,
26162,
26153,
26195,
26224,
26216,
26152,
26189,
26235,
26158,
26191,
26166,
26187,
26232,
26173,
26156,
26176,
26193,
26179,
26178,
26194,
26164,
26188,
26182,
26199,
26200,
26198,
26160,
26171,
26151,
26183,
26229,
26225,
26237,
26238,
26239,
26241,
26236,
26240,
]

_charnames_5888 = [
12974,
12969,
12962,
12968,
12971,
12958,
12963,
12972,
12959,
12965,
12973,
12966,
12960,
-1,
12967,
12961,
12964,
12970,
12977,
12976,
12978,
]

_charnames_5920 = [
20867,
20862,
20854,
20861,
20864,
20850,
20855,
20865,
20851,
20858,
20866,
20859,
20852,
20857,
20860,
20853,
20856,
20863,
20870,
20869,
20871,
26839,
26840,
]

_charnames_5952 = [
18836,
18831,
18823,
18830,
18833,
18819,
18824,
18834,
18820,
18827,
18835,
18828,
18821,
18826,
18829,
18822,
18825,
18832,
18839,
18838,
]

_charnames_5984 = [
12997,
12993,
12986,
12992,
12994,
12982,
12987,
12995,
12983,
12989,
12996,
12990,
12984,
-1,
12991,
12985,
12988,
-1,
13000,
12999,
]

_charnames_6016 = [
23634,
23632,
23633,
23631,
23628,
23640,
23638,
23639,
23637,
23625,
23655,
23618,
23654,
23617,
23627,
23623,
23621,
23622,
23620,
23626,
23662,
23648,
23649,
23647,
23660,
23656,
23658,
23651,
23657,
23643,
23642,
23644,
23661,
23652,
23659,
23747,
23749,
23753,
23754,
23741,
23744,
23742,
23743,
23762,
23763,
23764,
23765,
23755,
23748,
23752,
23751,
23746,
23737,
23738,
23716,
23731,
23732,
23721,
23722,
23724,
23725,
23726,
23730,
23723,
23733,
23734,
23720,
23719,
23728,
23718,
23611,
23603,
23607,
23612,
23599,
23588,
23602,
23600,
23593,
23597,
23609,
23608,
23605,
23586,
23592,
23587,
23606,
23613,
23589,
23610,
23591,
23712,
23595,
23596,
-1,
-1,
23776,
23777,
23768,
23769,
23774,
23775,
23771,
23772,
23779,
23778,
-1,
-1,
-1,
-1,
-1,
-1,
23570,
23571,
23566,
23569,
23568,
23559,
23565,
23564,
23563,
23562,
-1,
-1,
-1,
-1,
-1,
-1,
6999,
6998,
6992,
6986,
6993,
6987,
6995,
6996,
6990,
6989,
6997,
6985,
6983,
6984,
6994,
-1,
6976,
6977,
6968,
6969,
6974,
6975,
6971,
6972,
6979,
6978,
-1,
-1,
-1,
-1,
-1,
-1,
6843,
6948,
6960,
6940,
6938,
6941,
6939,
6949,
6958,
6879,
6965,
6957,
6956,
6962,
6908,
6944,
6907,
6906,
6842,
6964,
6952,
6959,
6953,
6955,
6954,
6963,
6947,
6946,
6841,
6937,
6961,
6935,
6943,
6936,
6951,
6834,
6838,
6836,
6818,
6813,
6819,
6814,
6812,
6840,
6831,
6830,
6823,
6833,
6817,
6827,
6839,
6822,
6816,
6828,
6829,
6835,
6824,
6837,
6821,
6832,
6826,
6902,
6890,
6891,
6886,
6885,
6905,
6899,
6894,
6892,
6898,
6896,
6889,
6903,
6900,
6901,
6895,
6893,
6888,
6884,
6897,
6904,
6883,
6932,
6931,
6930,
6933,
6929,
]

_charnames_6272 = [
6857,
6873,
6853,
6874,
6869,
6878,
6849,
6856,
6868,
6876,
6867,
6877,
6848,
6847,
6855,
6866,
6850,
6852,
6864,
6863,
6875,
6860,
6861,
6858,
6811,
6810,
6927,
6924,
6922,
6926,
6915,
6919,
6916,
6918,
6923,
6921,
6912,
6913,
6872,
6871,
6928,
6854,
6925,
-1,
-1,
-1,
-1,
-1,
3308,
3320,
3313,
2896,
3269,
3267,
3257,
3025,
3287,
3277,
3196,
2958,
2922,
3178,
3090,
3033,
3068,
3071,
3060,
3123,
3121,
3245,
2945,
3299,
2946,
3300,
2943,
3297,
2944,
3298,
3241,
3237,
3238,
3235,
3236,
3239,
3304,
3303,
3306,
3307,
3305,
3295,
3301,
3302,
3336,
2877,
3142,
3135,
3251,
2801,
2803,
2981,
2979,
2995,
2992,
2994,
3013,
3012,
3038,
3037,
3044,
2617,
2605,
2622,
2618,
3050,
2665,
3231,
3230,
2604,
]

_charnames_6400 = [
9632,
9579,
9578,
9585,
9584,
9575,
9591,
9590,
9582,
9581,
9567,
9570,
9569,
9588,
9587,
9576,
9573,
9572,
9594,
9593,
9597,
9566,
9596,
9598,
9595,
9564,
9563,
9565,
9599,
-1,
-1,
-1,
9623,
9631,
9630,
9629,
9625,
9627,
9624,
9628,
9626,
9618,
9620,
9619,
-1,
-1,
-1,
-1,
9610,
9603,
9611,
9605,
9604,
9607,
9608,
9606,
9609,
9614,
9616,
9613,
-1,
-1,
-1,
-1,
9615,
-1,
-1,
-1,
9648,
9647,
9643,
9644,
9635,
9636,
9641,
9642,
9638,
9639,
9646,
9645,
12825,
12827,
12821,
12804,
12829,
12826,
12806,
12805,
12832,
12817,
12816,
12831,
12835,
12828,
12834,
12830,
12824,
12803,
12822,
12810,
12833,
12809,
12808,
12813,
12819,
12818,
12814,
12807,
12811,
12812,
-1,
-1,
12801,
12800,
12799,
12798,
12797,
]

_charnames_6528 = [
27032,
27003,
27029,
27017,
27025,
27000,
26988,
26996,
27012,
27020,
27030,
26983,
26991,
27001,
27014,
27013,
27026,
26985,
26984,
26997,
27023,
27022,
27033,
26994,
26993,
27004,
27036,
27031,
27034,
27007,
27002,
27005,
27035,
27037,
27038,
27006,
27008,
27009,
27028,
27016,
26999,
26987,
27019,
26990,
-1,
-1,
-1,
-1,
27065,
27058,
27064,
27048,
27052,
27066,
27061,
27053,
27054,
27049,
27060,
27059,
27051,
27056,
27055,
27050,
27063,
27042,
27041,
27040,
27043,
27044,
27045,
27046,
27084,
27083,
-1,
-1,
-1,
-1,
-1,
-1,
27077,
27078,
27069,
27070,
27075,
27076,
27072,
27073,
27080,
27079,
27085,
-1,
-1,
-1,
27086,
27087,
23534,
23581,
23533,
23578,
23575,
23530,
23527,
23524,
23521,
23518,
23556,
23553,
23543,
23550,
23547,
23540,
23582,
23580,
23532,
23577,
23574,
23529,
23526,
23523,
23520,
23517,
23555,
23552,
23542,
23549,
23546,
23539,
18800,
18803,
18787,
18786,
18798,
18806,
18792,
18791,
18795,
18804,
18789,
18788,
18805,
18801,
18784,
18783,
18793,
18797,
18799,
18794,
18796,
18807,
18802,
18811,
18809,
18812,
18810,
18813,
-1,
-1,
18814,
18815,
12566,
12565,
12564,
12539,
12537,
12538,
12587,
12575,
12574,
12548,
12550,
12547,
12586,
12582,
12577,
12598,
12551,
12583,
12569,
12568,
12542,
12541,
12588,
12599,
12572,
12571,
12579,
12545,
12553,
12544,
12595,
12549,
12576,
12581,
12584,
12554,
12556,
12593,
12561,
12560,
12562,
12578,
12557,
12600,
12552,
12591,
12592,
12589,
12590,
12597,
12594,
12555,
12596,
12689,
12690,
12694,
12619,
12697,
12693,
12696,
12691,
12698,
12695,
-1,
12616,
12646,
12655,
12649,
12652,
12653,
12654,
12645,
12644,
12642,
12643,
12636,
12638,
12640,
12656,
12648,
12641,
12647,
12651,
12639,
12618,
12626,
12625,
12607,
12606,
12605,
12629,
12621,
12608,
-1,
-1,
12699,
12681,
12682,
12673,
12674,
12679,
12680,
12676,
12677,
12684,
12683,
-1,
-1,
-1,
-1,
-1,
-1,
12667,
12668,
12659,
12660,
12665,
12666,
12662,
12663,
12670,
12669,
-1,
-1,
-1,
-1,
-1,
-1,
12622,
12623,
12615,
12611,
12631,
12633,
12628,
12620,
12609,
12610,
12613,
12614,
12632,
12634,
]

_charnames_6912 = [
18083,
18084,
18087,
18085,
18088,
17969,
17970,
17991,
17992,
17983,
17984,
17978,
17979,
17981,
17982,
17996,
17972,
17987,
17988,
17958,
17960,
17993,
17994,
17956,
17998,
17999,
17989,
17990,
17955,
17950,
17949,
17966,
17965,
17954,
17946,
17948,
17962,
17967,
17953,
17985,
17986,
18000,
18001,
18006,
18003,
17977,
17980,
18004,
17976,
17975,
17973,
18007,
18086,
18056,
18057,
18058,
18059,
18060,
18061,
18062,
18065,
18066,
18051,
18053,
18055,
18054,
18063,
18064,
18100,
17959,
17961,
17951,
17997,
18005,
18002,
17971,
-1,
-1,
-1,
-1,
18077,
18078,
18069,
18070,
18075,
18076,
18072,
18073,
18080,
18079,
18093,
18092,
18099,
18097,
18098,
18096,
18091,
18021,
18019,
18020,
18011,
18013,
18022,
18016,
18018,
18015,
18014,
18029,
18032,
18025,
18027,
18030,
18026,
18028,
18033,
18031,
18044,
18045,
18047,
18048,
18038,
18036,
18041,
18040,
18037,
-1,
-1,
-1,
19710,
19709,
19708,
19660,
19676,
19667,
19661,
19672,
19658,
19659,
19657,
19670,
19678,
19650,
19681,
19675,
19662,
19649,
19668,
19680,
19651,
19671,
19679,
19666,
19682,
19673,
19663,
19669,
19674,
19665,
19654,
19664,
19677,
19716,
19715,
19714,
19701,
19699,
19703,
19700,
19704,
19702,
19711,
-1,
-1,
-1,
19656,
19653,
19693,
19694,
19685,
19686,
19691,
19692,
19688,
19689,
19696,
19695,
]

_charnames_7168 = [
9980,
9978,
9979,
9996,
9995,
9975,
10002,
10001,
10011,
9974,
9968,
9967,
9984,
9976,
9972,
9970,
9971,
9999,
9998,
10005,
10004,
9990,
9989,
9966,
9965,
9982,
10006,
10009,
10010,
9993,
9992,
10008,
9987,
9986,
10007,
10012,
10054,
10055,
10044,
10042,
10040,
10041,
10038,
10039,
10043,
10030,
10035,
10036,
10028,
10034,
10033,
10032,
10029,
10031,
10057,
10058,
-1,
-1,
-1,
10049,
10050,
10051,
10048,
10047,
10023,
10024,
10015,
10016,
10021,
10022,
10018,
10019,
10026,
10025,
-1,
-1,
-1,
9963,
9962,
9983,
25653,
25654,
25645,
25646,
25651,
25652,
25648,
25649,
25656,
25655,
25617,
25612,
25615,
25613,
25614,
25618,
25610,
25611,
25609,
25608,
25621,
25634,
25637,
25636,
25635,
25619,
25627,
25626,
25625,
25624,
25622,
25640,
25642,
25641,
25639,
25620,
25630,
25632,
25629,
25631,
25664,
25666,
25663,
25665,
25661,
25667,
25659,
25660,
]

_charnames_7376 = [
24523,
24527,
24529,
24508,
24506,
24516,
24515,
24513,
24530,
24514,
24525,
24519,
24522,
24526,
24518,
24520,
24528,
24531,
24500,
24496,
24503,
24498,
24504,
24497,
24499,
24493,
24492,
24489,
24490,
24507,
24510,
24509,
24505,
24491,
24494,
]

_charnames_7424 = [
9129,
9130,
7794,
9128,
9145,
9144,
9120,
9118,
7796,
7800,
9141,
9140,
9122,
9139,
9108,
9110,
9112,
8158,
8159,
8160,
7797,
9111,
7837,
8428,
9137,
9107,
9116,
9114,
9135,
8161,
8163,
8162,
9134,
9133,
9131,
9119,
9166,
9163,
22104,
22103,
22101,
22102,
22100,
4499,
6641,
6642,
6639,
6640,
6657,
6656,
6636,
6655,
6654,
6653,
6652,
6651,
6650,
6649,
6648,
6635,
6637,
6638,
6647,
6633,
6646,
6645,
6643,
6601,
6535,
6602,
6537,
6575,
6598,
6565,
6562,
6593,
6543,
6570,
6544,
6623,
6611,
6569,
6590,
6592,
6546,
6576,
6606,
6533,
6583,
6563,
6540,
6604,
6603,
6577,
6573,
6600,
6572,
6557,
8532,
8529,
8527,
8526,
21754,
21752,
21750,
21751,
21753,
8096,
8424,
8264,
8500,
8463,
8299,
8450,
8195,
8189,
8155,
7829,
8362,
7808,
6672,
8132,
7842,
8523,
8136,
8446,
8522,
8094,
8423,
8263,
8499,
8391,
8411,
8231,
8462,
8298,
8449,
8194,
8154,
7910,
8437,
8509,
8361,
8016,
8036,
8258,
7891,
7978,
8202,
8167,
8122,
7976,
7909,
8087,
7905,
6536,
6549,
6558,
6567,
6588,
6624,
6599,
6561,
6545,
6617,
6616,
6551,
6553,
6614,
6596,
6597,
6556,
6612,
6541,
6610,
6609,
6555,
6578,
6607,
6564,
6568,
6548,
6585,
6584,
6554,
6605,
6542,
6579,
6581,
6582,
6566,
6547,
3594,
3595,
3725,
3723,
3700,
3672,
3698,
3682,
3673,
3683,
3498,
3745,
3699,
3586,
3763,
3770,
3742,
3755,
3754,
3519,
3494,
3493,
3492,
3506,
3502,
3504,
3518,
3526,
3516,
3499,
3525,
3524,
3514,
3523,
3522,
3497,
3512,
3500,
3507,
]

_charnames_7677 = [
3693,
3533,
3632,
8689,
8014,
9075,
8420,
9074,
8419,
9078,
8425,
8988,
8330,
8946,
8261,
8945,
8260,
8948,
8265,
8942,
8252,
8941,
8251,
8638,
7886,
8639,
7887,
8614,
7862,
8641,
7889,
8616,
7864,
9097,
8502,
8976,
8392,
8957,
8311,
8956,
8310,
8958,
8312,
8962,
8316,
8965,
8321,
8780,
8115,
8774,
8109,
9027,
8414,
9017,
8403,
9025,
8412,
8880,
8219,
8881,
8220,
8894,
8232,
8884,
8215,
9067,
8465,
9064,
8460,
9063,
8459,
8928,
8295,
8927,
8294,
8920,
8291,
8923,
8286,
8573,
7953,
8572,
7952,
8577,
7960,
8578,
7961,
9059,
8454,
9058,
8453,
8860,
8180,
8858,
8178,
8859,
8179,
8869,
8187,
8844,
8149,
8842,
8147,
8846,
8151,
8837,
8142,
8843,
8148,
8811,
7822,
8810,
7821,
8815,
7830,
8805,
7816,
8725,
8052,
8748,
8075,
8756,
8083,
8749,
8076,
8744,
8071,
9045,
8435,
9043,
8433,
9036,
8479,
9038,
8481,
9034,
8476,
9033,
8475,
9032,
8474,
9088,
8507,
9089,
8508,
8904,
8371,
9009,
8355,
9002,
8350,
9011,
8363,
8319,
7825,
8477,
8377,
8015,
8238,
8239,
8240,
8850,
8278,
8675,
7998,
8699,
8026,
8668,
7991,
8666,
7989,
8665,
7988,
8664,
7987,
8667,
7990,
8685,
8008,
8683,
8006,
8682,
8005,
8681,
8004,
8684,
8007,
8625,
7873,
8644,
7894,
8640,
7888,
8613,
7861,
8610,
7858,
8609,
7857,
8607,
7855,
8611,
7859,
8788,
8124,
8770,
8106,
8554,
7934,
8548,
7928,
8567,
7947,
8565,
7945,
8564,
7944,
8563,
7943,
8566,
7946,
8547,
7927,
8545,
7925,
8544,
7924,
8543,
7923,
8546,
7926,
8730,
8057,
8739,
8066,
8738,
8065,
8736,
8063,
8735,
8062,
8734,
8061,
8737,
8064,
8912,
8380,
8903,
8370,
8907,
8374,
8908,
8375,
9070,
8468,
9069,
8467,
8911,
8379,
21624,
21635,
21626,
21637,
21630,
21641,
21628,
21639,
21844,
21855,
21850,
21861,
21852,
21863,
21847,
21858,
21609,
21613,
21611,
21615,
21612,
21616,
-1,
-1,
21829,
21833,
21831,
21835,
21832,
21836,
-1,
-1,
21581,
21592,
21583,
21594,
21587,
21598,
21585,
21596,
21803,
21814,
21809,
21820,
21811,
21822,
21806,
21817,
21698,
21692,
21700,
21694,
21702,
21696,
21701,
21695,
21881,
21875,
21883,
21877,
21885,
21879,
21884,
21878,
21566,
21570,
21568,
21572,
21569,
21573,
-1,
-1,
21788,
21792,
21790,
21794,
21791,
21795,
-1,
-1,
21671,
21665,
21673,
21667,
21675,
21669,
21674,
21668,
-1,
21895,
-1,
21897,
-1,
21899,
-1,
21898,
21538,
21549,
21540,
21551,
21544,
21555,
21542,
21553,
21762,
21773,
21768,
21779,
21770,
21781,
21765,
21776,
21645,
21648,
21617,
21619,
21601,
21603,
21706,
21708,
21574,
21576,
21679,
21681,
21558,
21560,
-1,
-1,
21632,
21643,
21627,
21638,
21631,
21642,
21629,
21640,
21849,
21860,
21851,
21862,
21853,
21864,
21848,
21859,
21589,
21600,
21584,
21595,
21588,
21599,
21586,
21597,
21808,
21819,
21810,
21821,
21812,
21823,
21807,
21818,
21546,
21557,
21541,
21552,
21545,
21556,
21543,
21554,
21767,
21778,
21769,
21780,
21771,
21782,
21766,
21777,
21647,
21652,
21646,
21650,
21649,
-1,
21633,
21634,
21866,
21870,
21867,
21869,
21854,
22162,
22147,
22142,
22150,
22120,
21602,
21605,
21604,
-1,
21590,
21591,
21837,
21839,
21824,
21826,
21813,
22144,
22146,
22145,
21705,
21709,
21688,
21691,
-1,
-1,
21703,
21690,
21887,
21891,
21888,
21890,
-1,
22125,
22127,
22126,
21678,
21682,
21661,
21664,
21724,
21725,
21676,
21663,
21902,
21906,
21903,
21905,
21920,
22119,
22121,
22094,
-1,
-1,
21559,
21562,
21561,
-1,
21547,
21548,
21796,
21798,
21783,
21785,
21772,
22154,
22123,
-1,
12076,
12047,
12075,
12046,
13850,
27849,
19965,
27862,
26975,
13861,
21027,
28406,
28404,
28407,
9947,
26124,
21518,
27294,
27863,
12077,
12048,
21505,
24764,
24753,
9740,
25947,
19947,
19950,
9820,
25984,
24752,
24788,
25360,
24783,
18841,
13900,
25927,
13966,
21508,
21522,
9558,
26648,
9948,
26125,
26974,
9946,
26123,
27344,
26948,
26946,
26916,
24767,
13871,
26356,
26349,
26347,
3397,
19948,
19949,
26394,
24789,
27608,
25928,
28048,
5171,
3398,
15968,
21521,
27881,
9735,
25942,
24786,
28377,
12017,
13376,
26357,
18688,
18708,
10190,
26353,
5189,
13976,
3788,
20236,
27629,
27870,
13842,
28370,
27843,
27859,
13965,
27844,
24881,
13901,
24558,
7719,
28217,
27835,
27639,
27640,
27641,
-1,
-1,
-1,
-1,
-1,
27652,
15977,
27653,
15978,
27343,
27295,
19761,
19747,
-1,
-1,
19756,
19757,
19753,
19754,
19760,
19765,
19763,
19766,
19759,
19748,
19762,
19746,
19781,
19784,
19770,
19771,
19776,
19777,
19773,
19774,
19780,
19785,
19783,
19786,
19779,
19787,
19782,
-1,
8534,
8533,
8530,
8525,
8528,
]

_charnames_8352 = [
12083,
4035,
5221,
27883,
9722,
7772,
27346,
26958,
26292,
28218,
27088,
24907,
12084,
23877,
13960,
25364,
22624,
26957,
22449,
15987,
21526,
5210,
9721,
20228,
13632,
]

_charnames_8400 = [
3544,
3642,
3557,
3722,
3687,
3484,
3536,
3637,
3646,
3483,
3686,
3734,
3782,
3711,
3709,
3715,
3712,
3547,
3710,
3714,
3713,
3652,
3570,
3688,
3733,
3784,
3551,
3558,
3644,
3550,
3535,
3636,
3691,
]

_charnames_8448 = [
15979,
15986,
24802,
25208,
5206,
3399,
3404,
12085,
20174,
25207,
20172,
20165,
18771,
24800,
26940,
26941,
20164,
18770,
20163,
20171,
10239,
24799,
27341,
20149,
20161,
24794,
24798,
20160,
18769,
24797,
26890,
26390,
20190,
13509,
13904,
24563,
24796,
25919,
25929,
27631,
18768,
13957,
23875,
15946,
20168,
18772,
12092,
20173,
20167,
20166,
13958,
20162,
20170,
15963,
18637,
22789,
25359,
27645,
26450,
27891,
24811,
24812,
24801,
24795,
24813,
13950,
13949,
26354,
13948,
24809,
24808,
24807,
24806,
24805,
26912,
13954,
26947,
15990,
13951,
19409,
24573,
24575,
24570,
24569,
24585,
24577,
24586,
24582,
24591,
24572,
24589,
24578,
24583,
24590,
24593,
27882,
26416,
26411,
26415,
26408,
26400,
26423,
26425,
26428,
26430,
26413,
26427,
26412,
26404,
26420,
26403,
26418,
20066,
20056,
20058,
20065,
20062,
20071,
20072,
20075,
20076,
20059,
20074,
20057,
20064,
20069,
20063,
20068,
26419,
26402,
26414,
26429,
8204,
26424,
26407,
26406,
26421,
24592,
-1,
-1,
-1,
-1,
-1,
-1,
9849,
27901,
26026,
24831,
9749,
27950,
27220,
27249,
20132,
20142,
9864,
26041,
9938,
26116,
9921,
27940,
26098,
24859,
9853,
26030,
9884,
27911,
26061,
24842,
27951,
9867,
26044,
9866,
26043,
9762,
9753,
24864,
27906,
27905,
24836,
24835,
26045,
24839,
15937,
5194,
27223,
9871,
15938,
5195,
9899,
9906,
27926,
27921,
26076,
26083,
24857,
24852,
26063,
27910,
9886,
9941,
27946,
26119,
24867,
9907,
26084,
9931,
9759,
26108,
9927,
27943,
26104,
24862,
9756,
27953,
27230,
27258,
20139,
20147,
9924,
26101,
9939,
26117,
27908,
24838,
9935,
27944,
26112,
24863,
9870,
26053,
9937,
27928,
26114,
24865,
27934,
27930,
27933,
27932,
27935,
27936,
26115,
27224,
20135,
27952,
25965,
24841,
13844,
9863,
26040,
9752,
9861,
26038,
9754,
9942,
26120,
9763,
27856,
3793,
26652,
13854,
13855,
12038,
27648,
27347,
12021,
27269,
20083,
4027,
24901,
20095,
12080,
27319,
27304,
27313,
7758,
7767,
24889,
25341,
20189,
15967,
26138,
18842,
19039,
2537,
27848,
26911,
27643,
25953,
15942,
7722,
20221,
25344,
24904,
26645,
27284,
10227,
10216,
27592,
28035,
27611,
24780,
13881,
4028,
19828,
24598,
5196,
5192,
15935,
13856,
18642,
26461,
26910,
24891,
12019,
22618,
21515,
13358,
26345,
27632,
19951,
28221,
27278,
7766,
15969,
27268,
15777,
15780,
27137,
15952,
27270,
15954,
13879,
15959,
11998,
22616,
25352,
15781,
22617,
15778,
27697,
4036,
11985,
26139,
26140,
4037,
12091,
11999,
20198,
25212,
11993,
7739,
28378,
27283,
27507,
27286,
20204,
10069,
22197,
10072,
22202,
10094,
22223,
7364,
7365,
18636,
27282,
27285,
27287,
27126,
27131,
10068,
22196,
27125,
27130,
10070,
22198,
27127,
27132,
26891,
19808,
26904,
19821,
26903,
19820,
24895,
24902,
19789,
19720,
27267,
27266,
19796,
19727,
27136,
27135,
19798,
19729,
7358,
7361,
7360,
19100,
19123,
19103,
19126,
19048,
19050,
4912,
4928,
4922,
4906,
4908,
4924,
4933,
4938,
4909,
19214,
19217,
19224,
19227,
26001,
9805,
24870,
27966,
15970,
6802,
13905,
27855,
13867,
24761,
24897,
27277,
24906,
27121,
26905,
19822,
27260,
4025,
27261,
4026,
25784,
27696,
7362,
21385,
27610,
28409,
27345,
27216,
25957,
25997,
27316,
27315,
27320,
27305,
25327,
24890,
20196,
25343,
18503,
9845,
26023,
9744,
25950,
26346,
2531,
2532,
24743,
24741,
24779,
24777,
26962,
11994,
10088,
22218,
24561,
24562,
10096,
22228,
11991,
11992,
11990,
11989,
24896,
24903,
27274,
27273,
19102,
19125,
10093,
22222,
26906,
19823,
27279,
24899,
27280,
24900,
24559,
7770,
27968,
24872,
12028,
12024,
20085,
12029,
12027,
20086,
12025,
12026,
4023,
4021,
20093,
4022,
20094,
28401,
25328,
12035,
21510,
27963,
24874,
26913,
26950,
28204,
9784,
25994,
9838,
26017,
18488,
18493,
13910,
13915,
26362,
19132,
15673,
20191,
20186,
13510,
26972,
24596,
26942,
13956,
28212,
21511,
13916,
13911,
18494,
18489,
13925,
18500,
27878,
20127,
27964,
25896,
12060,
28410,
23874,
9952,
26129,
12061,
18633,
4573,
15960,
19452,
13943,
25351,
4031,
20219,
4016,
4015,
15755,
15749,
15703,
15684,
15685,
15701,
15696,
15729,
15732,
15750,
15773,
15697,
15704,
15692,
15702,
15762,
15757,
15693,
15698,
15734,
15712,
15724,
15682,
15687,
15713,
15744,
15689,
15739,
15720,
15690,
15686,
15740,
15716,
15681,
15706,
15723,
15725,
15765,
15731,
15742,
15707,
15730,
15695,
15741,
15721,
15748,
15766,
15733,
15714,
15763,
15770,
15771,
15735,
15719,
15769,
15747,
15751,
15700,
15699,
15715,
15743,
15753,
15758,
15759,
15768,
15772,
15754,
15760,
15767,
27288,
25956,
20045,
18641,
24540,
27589,
4029,
25347,
12044,
3792,
28075,
12079,
15956,
21384,
4887,
4921,
17552,
28047,
7006,
21525,
25894,
25893,
26657,
26656,
25350,
20153,
15677,
25210,
26907,
27138,
26915,
5199,
9826,
9828,
9827,
26004,
26006,
26005,
9736,
9738,
9737,
25943,
25945,
25944,
9779,
9780,
9781,
2533,
25990,
25991,
25992,
27625,
21507,
27981,
27976,
19826,
19827,
13923,
18496,
18497,
26460,
9840,
26008,
21502,
21501,
21500,
21499,
25186,
25189,
25194,
25204,
25199,
25193,
25203,
25198,
25191,
25202,
25197,
25200,
25195,
25187,
25190,
19146,
26391,
12093,
24541,
7752,
7749,
7750,
7748,
7743,
7744,
7745,
7746,
7751,
12088,
27836,
13924,
18499,
13926,
18501,
13922,
18498,
28180,
18634,
20206,
27873,
15980,
12034,
25211,
]

_charnames_9216 = [
19435,
19403,
19402,
19427,
19425,
19429,
19451,
19443,
19444,
19449,
19448,
19445,
19437,
19440,
19405,
19406,
19420,
19416,
19414,
19415,
19417,
19434,
19407,
19426,
19441,
19428,
19399,
19430,
19438,
19450,
19447,
19446,
19408,
19418,
18777,
25890,
19433,
19419,
19400,
]

_charnames_9280 = [
25910,
25908,
25911,
25909,
25902,
25901,
25900,
25912,
25905,
25907,
25904,
]

_charnames_9312 = [
4902,
4893,
4894,
4899,
4900,
4896,
4897,
4904,
4903,
4752,
4788,
4733,
4751,
4772,
4776,
4780,
4783,
4787,
4789,
4717,
26634,
26626,
26627,
26632,
26633,
26629,
26630,
26636,
26635,
26613,
26621,
26611,
26612,
26618,
26619,
26615,
26616,
26622,
26623,
26610,
25249,
25219,
25223,
25237,
25241,
25228,
25232,
25257,
25253,
27328,
27338,
27326,
27327,
27335,
27336,
27331,
27333,
27339,
27340,
27325,
26493,
26492,
26491,
26490,
26489,
26488,
26487,
26486,
26485,
26484,
26483,
26482,
26481,
26480,
26479,
26478,
26477,
26476,
26475,
26474,
26473,
26472,
26471,
26470,
26469,
26468,
4712,
4711,
4710,
4709,
4708,
4707,
4706,
4705,
4704,
4703,
4702,
4701,
4700,
4699,
4698,
4697,
4696,
4695,
4694,
4693,
4692,
4691,
4690,
4689,
4688,
4687,
4685,
4684,
4683,
4682,
4681,
4680,
4679,
4678,
4677,
4676,
4675,
4674,
4673,
4672,
4671,
4670,
4669,
4668,
4667,
4666,
4665,
4664,
4663,
4662,
4661,
4660,
4901,
27105,
27096,
27097,
27102,
27103,
27099,
27100,
27106,
27107,
27095,
24734,
24726,
24727,
24732,
24733,
24729,
24730,
24736,
24735,
24737,
27111,
18274,
18360,
18253,
18346,
18267,
18353,
18266,
18352,
18270,
18356,
18269,
18355,
18235,
18291,
18300,
18333,
18236,
18294,
18303,
18334,
18251,
18364,
18373,
18344,
18252,
18367,
18376,
18343,
18255,
18394,
18374,
18299,
18398,
18290,
18365,
18348,
18256,
18395,
18377,
18302,
18399,
18293,
18368,
18349,
18237,
18283,
18413,
18296,
18305,
18409,
18279,
18335,
18249,
18282,
18412,
18369,
18378,
18408,
18278,
18345,
18257,
18281,
18411,
18396,
18379,
18304,
18400,
18284,
18414,
18285,
18415,
18295,
18370,
18407,
18277,
18350,
18240,
18338,
18239,
18337,
18328,
18315,
18307,
18311,
18325,
18308,
18312,
18326,
18381,
18385,
18321,
18382,
18386,
18322,
18390,
18402,
18317,
18391,
18403,
18318,
18309,
18313,
18327,
18383,
18387,
18323,
18392,
18404,
18319,
18263,
18264,
18261,
18260,
18243,
18244,
18245,
18271,
18246,
18273,
18233,
18357,
18339,
18359,
18331,
18272,
18250,
18358,
18342,
27986,
10183,
10182,
10180,
10177,
10185,
10179,
10184,
27832,
9743,
9802,
9836,
9843,
9803,
9831,
9832,
26014,
9717,
7713,
25358,
27987,
26012,
28368,
28367,
28355,
28362,
28361,
28359,
28358,
28363,
28364,
28365,
18674,
28060,
28072,
28076,
18984,
18980,
18983,
18973,
18970,
18985,
18668,
28081,
18710,
28140,
18749,
28167,
18763,
28192,
18729,
28173,
18730,
28175,
18703,
28137,
18704,
28138,
18701,
28135,
18721,
28125,
18722,
28126,
18682,
28144,
18683,
28145,
18684,
28146,
18712,
28117,
28122,
27864,
10237,
28091,
24882,
4951,
18843,
18655,
4950,
4953,
4949,
4944,
4943,
4955,
9844,
26015,
27637,
27636,
27984,
10175,
27980,
27974,
10166,
10173,
27985,
10176,
18691,
18692,
18727,
18726,
28194,
18979,
18982,
18974,
18977,
28074,
28174,
27991,
27990,
9285,
28070,
28066,
28065,
28069,
28095,
28098,
28097,
28094,
27979,
27972,
10171,
28154,
18735,
28155,
18736,
10165,
18672,
5198,
28050,
20230,
3794,
18673,
28085,
9720,
13859,
19645,
15971,
25181,
4030,
25897,
18755,
28182,
18103,
18106,
18105,
19641,
28052,
21514,
28087,
18677,
20034,
26360,
18686,
18709,
28148,
28176,
28139,
28127,
20234,
3405,
26459,
18848,
3403,
15947,
25788,
5175,
5218,
5219,
20199,
27890,
15985,
21025,
26960,
17289,
13890,
13889,
13891,
13887,
13885,
13886,
13888,
13892,
28198,
28163,
28083,
18671,
28084,
27865,
9288,
7753,
27895,
12087,
6448,
28347,
19640,
28054,
27140,
26938,
15672,
13001,
22625,
3342,
10097,
24595,
9723,
20175,
19643,
3407,
15989,
26964,
28106,
28108,
28107,
28110,
28105,
28109,
18650,
18652,
18651,
18654,
18649,
18653,
18675,
28189,
28120,
18661,
28086,
18746,
18715,
28115,
21513,
28373,
12072,
18640,
18639,
7344,
7343,
7342,
28223,
12089,
28045,
26383,
26382,
26381,
26380,
26379,
26378,
26377,
26384,
18731,
26385,
26651,
26954,
28197,
25336,
25335,
25334,
25333,
25332,
25331,
28101,
28102,
18657,
18658,
7004,
7003,
25272,
25265,
25266,
25271,
28160,
18759,
21026,
15949,
5215,
20202,
20176,
15962,
27869,
22619,
20201,
15988,
27875,
25915,
13838,
13839,
28213,
21495,
24827,
24826,
27607,
6449,
6446,
6447,
24556,
21506,
7717,
7720,
7712,
6525,
25345,
28049,
4038,
27834,
27139,
5211,
26660,
28348,
24564,
5174,
18739,
20188,
20179,
28380,
20183,
20155,
18225,
19219,
28129,
28130,
18718,
18719,
20231,
19717,
26457,
18676,
13860,
13955,
13959,
28121,
5220,
25348,
-1,
26967,
3401,
21383,
4930,
5172,
27297,
15957,
18753,
28181,
18687,
28149,
25365,
21362,
9783,
19205,
27889,
18754,
26389,
26388,
-1,
21308,
-1,
-1,
-1,
-1,
18660,
20047,
5176,
3406,
21494,
22621,
22622,
6526,
7007,
28053,
27850,
27874,
27896,
19642,
19145,
20235,
27698,
26951,
13631,
28345,
21381,
27837,
2536,
28161,
-1,
27988,
18678,
10186,
28089,
-1,
13511,
13002,
15991,
12078,
-1,
-1,
24597,
28220,
10167,
26959,
27975,
28193,
18764,
5060,
21313,
7357,
21376,
18107,
21326,
25917,
21378,
25884,
21367,
9101,
20032,
25916,
6450,
20197,
27845,
27847,
21379,
27846,
18760,
28164,
-1,
20205,
4917,
25885,
18662,
25918,
21366,
26965,
20031,
21380,
25886,
12071,
12068,
12067,
19962,
12066,
21359,
13977,
19964,
13634,
25883,
21331,
19963,
18758,
28162,
12069,
4936,
21330,
20232,
13377,
21312,
20226,
21338,
18108,
12070,
21358,
-1,
20033,
-1,
10168,
27977,
10163,
27973,
-1,
-1,
-1,
18716,
21355,
9716,
7718,
21373,
21336,
21337,
21370,
21371,
-1,
-1,
2534,
21356,
21377,
21325,
26448,
27871,
26449,
7708,
7703,
7716,
7715,
7710,
7705,
21349,
21343,
21350,
21344,
9719,
9718,
7709,
7704,
25300,
25292,
25293,
25298,
25299,
25295,
25296,
25302,
25301,
25303,
25315,
25307,
25308,
25313,
25314,
25310,
25311,
25317,
25316,
25318,
25286,
25278,
25279,
25284,
25285,
25281,
25282,
25288,
25287,
25289,
21361,
-1,
-1,
-1,
21339,
21345,
21375,
25363,
21346,
13899,
21333,
25355,
21372,
18706,
13848,
13849,
18707,
21324,
21323,
19229,
21314,
26132,
9955,
18226,
27879,
21351,
21374,
27291,
-1,
27290,
4888,
28195,
18774,
18775,
18776,
21318,
21319,
21320,
13635,
21332,
28224,
21363,
25895,
-1,
13843,
28179,
26952,
25889,
25888,
9746,
25951,
25789,
26369,
19742,
24550,
-1,
10213,
-1,
-1,
-1,
28119,
15948,
12031,
10169,
27982,
9833,
26011,
27831,
9282,
9284,
9791,
9790,
9846,
10211,
10203,
27967,
10238,
28111,
28114,
28113,
28067,
28073,
6308,
6301,
6311,
6304,
6310,
6303,
6307,
6300,
6309,
6302,
27945,
24866,
15940,
5197,
25966,
10196,
10208,
10202,
10194,
10206,
10201,
10197,
10209,
10195,
10207,
10210,
17550,
17295,
17423,
17296,
17487,
17360,
17424,
17297,
17519,
17392,
17456,
17329,
17488,
17361,
17425,
17298,
17535,
17408,
17472,
17345,
17504,
17377,
17441,
17314,
17520,
17393,
17457,
17330,
17489,
17362,
17426,
17299,
17543,
17416,
17480,
17353,
17512,
17385,
17449,
17322,
17528,
17401,
17465,
17338,
17497,
17370,
17434,
17307,
17536,
17409,
17473,
17346,
17505,
17378,
17442,
17315,
17521,
17394,
17458,
17331,
17490,
17363,
17427,
17300,
17547,
17420,
17484,
17357,
17516,
17389,
17453,
17326,
17532,
17405,
17469,
17342,
17501,
17374,
17438,
17311,
17540,
17413,
17477,
17350,
17509,
17382,
17446,
17319,
17525,
17398,
17462,
17335,
17494,
17367,
17431,
17304,
17544,
17417,
17481,
17354,
17513,
17386,
17450,
17323,
17529,
17402,
17466,
17339,
17498,
17371,
17435,
17308,
17537,
17410,
17474,
17347,
17506,
17379,
17443,
17316,
17522,
17395,
17459,
17332,
17491,
17364,
17428,
17301,
17549,
17422,
17486,
17359,
17518,
17391,
17455,
17328,
17534,
17407,
17471,
17344,
17503,
17376,
17440,
17313,
17542,
17415,
17479,
17352,
17511,
17384,
17448,
17321,
17527,
17400,
17464,
17337,
17496,
17369,
17433,
17306,
17546,
17419,
17483,
17356,
17515,
17388,
17452,
17325,
17531,
17404,
17468,
17341,
17500,
17373,
17437,
17310,
17539,
17412,
17476,
17349,
17508,
17381,
17445,
17318,
17524,
17397,
17461,
17334,
17493,
17366,
17430,
17303,
17548,
17421,
17485,
17358,
17517,
17390,
17454,
17327,
17533,
17406,
17470,
17343,
17502,
17375,
17439,
17312,
17541,
17414,
17478,
17351,
17510,
17383,
17447,
17320,
17526,
17399,
17463,
17336,
17495,
17368,
17432,
17305,
17545,
17418,
17482,
17355,
17514,
17387,
17451,
17324,
17530,
17403,
17467,
17340,
17499,
17372,
17436,
17309,
17538,
17411,
17475,
17348,
17507,
17380,
17444,
17317,
17523,
17396,
17460,
17333,
17492,
17365,
17429,
17302,
26094,
26095,
9930,
26107,
9758,
26096,
9932,
26109,
24837,
27907,
27941,
24860,
9934,
26111,
9923,
26100,
26097,
26039,
27909,
24840,
26032,
26033,
26090,
26092,
26093,
9887,
26064,
9933,
26110,
9872,
26052,
9885,
26062,
27228,
27256,
27225,
27254,
20134,
20144,
27227,
27255,
20137,
20145,
26144,
27887,
20136,
27252,
27888,
26143,
27253,
27226,
28209,
15667,
15668,
15671,
15670,
26131,
9954,
13919,
18502,
13921,
13920,
10164,
10172,
15936,
5193,
26059,
9882,
20043,
26042,
9865,
26048,
9755,
27939,
9810,
9812,
27958,
27960,
9809,
27957,
9813,
27961,
9897,
26074,
27924,
24855,
9902,
26079,
27919,
24850,
9898,
26075,
27925,
24856,
9903,
26080,
27920,
24851,
9895,
27917,
26073,
24849,
9896,
9905,
26072,
26082,
9894,
9904,
26071,
26081,
27918,
24848,
25981,
11975,
13364,
9881,
26058,
26060,
10080,
9876,
22210,
19807,
9875,
19738,
9837,
26018,
27969,
24873,
13868,
28389,
28399,
9769,
25971,
9773,
25975,
28397,
28392,
28398,
28393,
9734,
25941,
9732,
25940,
9733,
25939,
9788,
25959,
9796,
25967,
24757,
24785,
9815,
26020,
24887,
24554,
7737,
25960,
7738,
15945,
15974,
20224,
20223,
13953,
26358,
15944,
26359,
25922,
25923,
7726,
7727,
7735,
7736,
7729,
7732,
7730,
7733,
26364,
12042,
12040,
12041,
12043,
4954,
4935,
4914,
4925,
4913,
4956,
4946,
4934,
27965,
4918,
4939,
4713,
4937,
4947,
4952,
19225,
19223,
19228,
19203,
19202,
13974,
13898,
13896,
20237,
13897,
25998,
9799,
24553,
18506,
18505,
18765,
13375,
13374,
28185,
18742,
9775,
25977,
9819,
25983,
27650,
13378,
27644,
24824,
18986,
27649,
20046,
11978,
11979,
27508,
22754,
13857,
24877,
24876,
18714,
18693,
28100,
18659,
12052,
12056,
12053,
12057,
12054,
12058,
26293,
26370,
20151,
26368,
18846,
18847,
24770,
13872,
9951,
26128,
13371,
7768,
27303,
27302,
27301,
27308,
27307,
27312,
27311,
13970,
13969,
27318,
6801,
19825,
28371,
27866,
27621,
27623,
4959,
15939,
9556,
9555,
9557,
27624,
28372,
27619,
27617,
27620,
27615,
27618,
27616,
28349,
9283,
28388,
28387,
28386,
26928,
26930,
26925,
26929,
26924,
26927,
26931,
7764,
7763,
7762,
7761,
26935,
26934,
24565,
7356,
7355,
20180,
20126,
7352,
7351,
4927,
7353,
4907,
26933,
7765,
7350,
27609,
26135,
28394,
15983,
27597,
28039,
28038,
27595,
27596,
28040,
28042,
27599,
28043,
27600,
28044,
27601,
5186,
5188,
24746,
24745,
5187,
10233,
10223,
24756,
24755,
13973,
13972,
20217,
20218,
10226,
10235,
10224,
10236,
10225,
10232,
10234,
10231,
20115,
10222,
10221,
28400,
28395,
11982,
27509,
13878,
13877,
13362,
13361,
19959,
4032,
11984,
15953,
15779,
11976,
26936,
11974,
24738,
13975,
13845,
11981,
11997,
10089,
22219,
10087,
22217,
10062,
22190,
10066,
22194,
10064,
22192,
10065,
22193,
10071,
22199,
10084,
22214,
10085,
22215,
10082,
22212,
10077,
22207,
10078,
22208,
10081,
22211,
10079,
22209,
20210,
20212,
20211,
20213,
24822,
24823,
24817,
24818,
19954,
19955,
19957,
19958,
24772,
24774,
24773,
22201,
22224,
10090,
22225,
10091,
22226,
20124,
9286,
20125,
9287,
11983,
26896,
19813,
26895,
19812,
26900,
19817,
26898,
19815,
26901,
19818,
26899,
19816,
24769,
24742,
19802,
19733,
19800,
19731,
19801,
19732,
19797,
19728,
19794,
19725,
19792,
19723,
19795,
19726,
19793,
19724,
19137,
19029,
5184,
5182,
5185,
5183,
19805,
19737,
19806,
19736,
19740,
19741,
12032,
26963,
13903,
27853,
27293,
20044,
20041,
20037,
26953,
24551,
24763,
24552,
24762,
10214,
20042,
20039,
20040,
24782,
24776,
24747,
26351,
24905,
24539,
24538,
24871,
26644,
26643,
13869,
13866,
13882,
13874,
13875,
24819,
24820,
13880,
9278,
24748,
28169,
27317,
27257,
27229,
20138,
20146,
9761,
9943,
27947,
24868,
27259,
27231,
20140,
20148,
9764,
27954,
26036,
26035,
9859,
9858,
18981,
18987,
18971,
18978,
25325,
25324,
25323,
25326,
24884,
18695,
28150,
18751,
28170,
18762,
28191,
28188,
18745,
21504,
18696,
18738,
28157,
18737,
28156,
18670,
18669,
28082,
18743,
28186,
18750,
28168,
9794,
13840,
9795,
10198,
9917,
9918,
9919,
9920,
9862,
9855,
9856,
9913,
9915,
9916,
9874,
28210,
11977,
26373,
9880,
26050,
26049,
9940,
26118,
26372,
26057,
13365,
9883,
9879,
26056,
-1,
-1,
-1,
28153,
18667,
28080,
18702,
28136,
21352,
21365,
21309,
21306,
21310,
]

_charnames_11264 = [
22753,
22742,
22744,
22751,
22724,
22706,
22727,
22723,
22728,
22713,
22717,
22710,
22725,
22749,
22736,
22748,
22747,
22734,
22730,
22746,
22700,
22719,
22745,
22739,
22750,
22733,
22731,
22694,
22720,
22752,
22696,
22704,
22705,
22709,
22699,
22707,
22697,
22698,
22708,
22715,
22743,
22716,
22740,
22712,
22695,
22721,
22737,
-1,
22690,
22679,
22681,
22688,
22661,
22643,
22664,
22660,
22665,
22650,
22654,
22647,
22662,
22686,
22673,
22685,
22684,
22671,
22667,
22683,
22637,
22656,
22682,
22676,
22687,
22670,
22668,
22631,
22657,
22689,
22633,
22641,
22642,
22646,
22636,
22644,
22634,
22635,
22645,
22652,
22680,
22653,
22677,
22649,
22632,
22658,
22674,
-1,
8882,
8221,
8891,
9053,
8864,
8024,
7824,
8959,
8313,
9019,
8405,
9004,
8352,
8711,
9066,
8818,
8819,
8436,
9035,
8478,
8439,
8968,
8325,
7848,
7892,
7786,
7963,
9117,
8531,
6644,
8848,
9006,
3961,
3869,
3964,
3872,
3956,
3864,
3921,
3829,
3970,
3878,
3926,
3834,
3963,
3871,
3953,
3861,
3943,
3851,
3969,
3877,
3941,
3849,
3949,
3857,
3968,
3876,
3967,
3875,
3940,
3848,
3891,
3799,
3947,
3855,
3966,
3874,
3927,
3835,
3944,
3852,
3965,
3873,
3958,
3866,
3938,
3846,
3946,
3854,
3913,
3821,
3919,
3827,
3906,
3814,
3934,
3842,
3917,
3825,
3916,
3824,
3932,
3840,
3902,
3810,
3928,
3836,
3935,
3843,
3901,
3809,
3904,
3812,
3962,
3870,
3918,
3826,
3897,
3805,
3895,
3803,
3950,
3858,
3898,
3806,
3896,
3804,
3903,
3811,
3905,
3813,
3900,
3808,
3912,
3820,
3910,
3818,
3909,
3817,
3911,
3819,
3885,
3888,
3887,
3881,
3886,
3884,
3882,
3931,
3839,
3933,
3841,
3975,
3974,
3973,
]

_charnames_11513 = [
3979,
3980,
3978,
3977,
3983,
3982,
3984,
22562,
22561,
22547,
22560,
22559,
22550,
22529,
22532,
22558,
22541,
22557,
22556,
22555,
22554,
22538,
22528,
22552,
22535,
22531,
22551,
22537,
22540,
22546,
22553,
22534,
22523,
22526,
22543,
22525,
22524,
22548,
22544,
22517,
22520,
22519,
22549,
22516,
22518,
]

_charnames_11568 = [
13296,
13320,
13321,
13313,
13315,
13350,
13330,
13297,
13300,
13298,
13299,
13336,
13331,
13310,
13339,
13312,
13318,
13351,
13347,
13319,
13333,
13311,
13340,
13325,
13345,
13335,
13303,
13354,
13344,
13329,
13328,
13327,
13342,
13346,
13326,
13334,
13316,
13317,
13314,
13343,
13353,
13307,
13308,
13309,
13304,
13306,
13332,
13305,
13324,
13323,
13322,
13301,
13348,
13302,
]

_charnames_11648 = [
11867,
11818,
11856,
11517,
11484,
11847,
11553,
11663,
11765,
11756,
11451,
11722,
11785,
11776,
11877,
11526,
11654,
11684,
11696,
11439,
11441,
11438,
11437,
]

_charnames_11680 = [
11504,
11506,
11508,
11505,
11503,
11502,
11507,
-1,
11647,
11649,
11651,
11648,
11646,
11645,
11650,
-1,
11716,
11718,
11720,
11717,
11715,
11714,
11719,
-1,
11640,
11642,
11644,
11641,
11639,
11638,
11643,
-1,
11579,
11581,
11583,
11580,
11578,
11577,
11582,
-1,
11616,
11618,
11620,
11617,
11615,
11614,
11619,
-1,
11734,
11736,
11738,
11735,
11733,
11732,
11737,
-1,
11462,
11464,
11466,
11463,
11461,
11460,
11465,
-1,
3443,
3444,
3451,
3440,
3427,
3428,
3449,
3420,
3419,
3418,
3446,
3445,
3417,
3415,
3434,
3450,
3433,
3453,
3437,
3436,
3452,
3416,
3454,
3425,
3439,
3447,
3431,
3430,
3424,
3448,
3442,
3423,
25961,
25962,
9745,
25949,
9823,
25986,
26455,
26456,
24883,
9800,
25999,
26454,
9765,
26022,
12094,
26647,
27854,
26363,
21524,
24886,
24843,
27912,
24885,
24787,
27633,
26659,
21520,
13370,
9847,
26024,
13369,
13368,
9841,
26009,
13917,
13912,
18495,
18490,
9741,
25948,
9821,
25985,
13967,
25926,
19222,
27860,
26361,
24555,
26137,
28216,
]

_charnames_11904 = [
1232,
1119,
1141,
1139,
1140,
1250,
1169,
1226,
1257,
1256,
1253,
1142,
1153,
1152,
1193,
1191,
1192,
1194,
1147,
1225,
1146,
1145,
1210,
1209,
1213,
1229,
-1,
1124,
1154,
1163,
1254,
1161,
1121,
1181,
1180,
1260,
1249,
1248,
1133,
1123,
1252,
1205,
1171,
1220,
1150,
1149,
1176,
1135,
1091,
1237,
1235,
1236,
1238,
1165,
1155,
1230,
1221,
1261,
1174,
1173,
1166,
1162,
1244,
1242,
1243,
1224,
1118,
1187,
1186,
1093,
1132,
1212,
1090,
1092,
1259,
1115,
1130,
1184,
1183,
1122,
1107,
1197,
1196,
1104,
1108,
1160,
1159,
1231,
1175,
1098,
1105,
1112,
1101,
1219,
1217,
1218,
1111,
1211,
1113,
1170,
1245,
1102,
1116,
1094,
1129,
1134,
1100,
1203,
1110,
1202,
1097,
1204,
1114,
1223,
1201,
1096,
]

_charnames_12032 = [
23070,
22999,
22849,
22828,
22823,
23018,
22903,
23001,
22990,
22996,
23033,
23037,
22853,
22937,
23089,
22902,
23069,
23098,
23063,
22960,
22809,
23041,
23024,
22914,
22862,
22824,
22946,
23062,
23079,
22979,
23034,
23028,
22839,
23051,
23053,
23031,
22889,
22963,
22952,
23048,
23088,
22845,
23005,
22938,
22808,
22977,
23040,
22962,
23071,
22907,
22865,
22814,
22852,
23003,
22904,
22816,
22873,
22844,
22880,
22801,
23021,
23011,
22855,
23012,
22881,
23045,
22838,
22863,
23077,
22842,
23082,
22841,
22831,
22983,
22897,
23006,
22797,
22870,
22972,
22857,
22939,
22931,
22944,
22802,
22957,
22918,
22943,
22922,
22854,
23010,
22829,
22923,
22936,
22856,
23061,
23095,
22988,
22912,
22840,
23000,
23097,
22920,
22875,
22836,
22851,
22968,
22846,
22861,
23035,
22807,
23075,
22799,
22810,
22898,
23056,
22948,
22803,
22891,
23042,
22835,
23094,
23084,
22819,
22933,
23072,
23078,
23064,
23027,
22879,
22989,
22985,
22821,
23076,
22981,
22910,
23068,
22877,
22798,
22940,
23055,
22913,
23087,
22884,
22956,
22945,
22971,
22822,
23017,
22806,
23092,
22893,
23065,
22892,
22818,
23049,
23047,
22932,
22876,
22950,
22887,
22982,
22955,
22951,
22965,
22860,
23091,
23052,
23002,
23058,
22978,
22827,
22815,
23046,
22883,
22959,
22924,
22994,
22900,
22997,
22843,
22995,
22966,
22929,
23029,
23022,
22927,
23016,
22874,
22901,
23013,
22919,
22833,
22949,
23057,
22917,
22888,
22832,
22869,
22969,
23023,
23096,
22986,
22885,
23036,
22926,
22896,
22866,
23044,
23083,
23030,
22909,
22867,
22906,
22930,
]

_charnames_12272 = [
27486,
27490,
27487,
27489,
27492,
27484,
27483,
27482,
27479,
27478,
27481,
27491,
-1,
-1,
-1,
-1,
27498,
27495,
27504,
25349,
28344,
27502,
27496,
27500,
9787,
25958,
9822,
25982,
9782,
25993,
9770,
25972,
9816,
26021,
26970,
22623,
9804,
26000,
9774,
25976,
9771,
25973,
9772,
25974,
28211,
26350,
24768,
10189,
26971,
20844,
20832,
20835,
20842,
20843,
20839,
20840,
20846,
20845,
27501,
27499,
27493,
27505,
20826,
20828,
28206,
24543,
24547,
24545,
24548,
24546,
4911,
27451,
20837,
20833,
20836,
24557,
6523,
26654,
27497,
27503,
-1,
21404,
21490,
21402,
21488,
21399,
21486,
21403,
21489,
21401,
21487,
21451,
21463,
21449,
21461,
21447,
21459,
21450,
21462,
21448,
21460,
21409,
21421,
21407,
21419,
21405,
21417,
21408,
21420,
21406,
21418,
21427,
21469,
21425,
21467,
21400,
21423,
21465,
21426,
21468,
21424,
21466,
21415,
21413,
21411,
21414,
21412,
21457,
21475,
21439,
21455,
21473,
21437,
21453,
21471,
21435,
21456,
21474,
21438,
21454,
21472,
21436,
21445,
21443,
21441,
21444,
21442,
21394,
21484,
21392,
21482,
21393,
21483,
21433,
21431,
21429,
21432,
21430,
21398,
21480,
21478,
21479,
21477,
21410,
21485,
21397,
21396,
-1,
-1,
3779,
3780,
23352,
23353,
21492,
21491,
21493,
23355,
23254,
23341,
23252,
23345,
23248,
23343,
23253,
23346,
23249,
23344,
23307,
23319,
23305,
23317,
23303,
23315,
23306,
23318,
23304,
23316,
23259,
23271,
23257,
23269,
23255,
23267,
23258,
23270,
23256,
23268,
23283,
23325,
23281,
23323,
23242,
23279,
23321,
23282,
23324,
23280,
23322,
23265,
23263,
23261,
23264,
23262,
23313,
23331,
23295,
23311,
23329,
23293,
23309,
23327,
23291,
23312,
23330,
23294,
23310,
23328,
23292,
23301,
23299,
23297,
23300,
23298,
23236,
23340,
23234,
23338,
23235,
23339,
23289,
23287,
23285,
23288,
23286,
23247,
23336,
23334,
23335,
23333,
23260,
23273,
23240,
23239,
23277,
23275,
23276,
23274,
23348,
23354,
23349,
23347,
23350,
-1,
-1,
-1,
-1,
-1,
18466,
18473,
18474,
18478,
18479,
18470,
18452,
18475,
18455,
18476,
18477,
18462,
18472,
18468,
18451,
18465,
18461,
18471,
18449,
18464,
18460,
18418,
18442,
18427,
18433,
18424,
18432,
18422,
18446,
18419,
18428,
18421,
18430,
18431,
18435,
18458,
18438,
18469,
18453,
18457,
18441,
-1,
-1,
-1,
20785,
20737,
20786,
20788,
20794,
20793,
20815,
20733,
20748,
20758,
20762,
20751,
20761,
20757,
20753,
20763,
20801,
20765,
20735,
20767,
20741,
20734,
20820,
20822,
20740,
20823,
20787,
20816,
20776,
20825,
20807,
20810,
20728,
20729,
20813,
20811,
20716,
20711,
20817,
20798,
20799,
20818,
20723,
20824,
20797,
20796,
20800,
20718,
20812,
20730,
20819,
20827,
20736,
20790,
20791,
20792,
20759,
20756,
20752,
20754,
20760,
20804,
20806,
20805,
20784,
20774,
20772,
20770,
20769,
20775,
20773,
20781,
20783,
20746,
20745,
20743,
20744,
20747,
20777,
20738,
20712,
20714,
20715,
20782,
20739,
20717,
20725,
20726,
20727,
20721,
20720,
20722,
20808,
20809,
-1,
27470,
27468,
27469,
27457,
27455,
27462,
27458,
27465,
27473,
27463,
27467,
27456,
27461,
27471,
27472,
27466,
18467,
18450,
18463,
18456,
18434,
18429,
18447,
18444,
18439,
18420,
18436,
18459,
18440,
18454,
18425,
18423,
18426,
18448,
18445,
18437,
18482,
18481,
18483,
18484,
]

_charnames_12736 = [
1291,
1294,
1293,
1298,
1281,
1265,
1272,
1273,
1270,
1280,
1271,
1268,
1274,
1269,
1266,
1296,
1263,
1277,
1287,
1285,
1297,
1264,
1276,
1278,
1282,
1284,
1286,
1290,
1288,
1292,
1279,
1283,
1275,
1267,
1289,
1295,
]

_charnames_12784 = [
23238,
23246,
23245,
23243,
23250,
23232,
23230,
23228,
23231,
23229,
23251,
23226,
23224,
23222,
23225,
23223,
26591,
26599,
26581,
26597,
26601,
26586,
26595,
26603,
26574,
26578,
26593,
26583,
26588,
26605,
26592,
26600,
26582,
26598,
26602,
26587,
26596,
26604,
26577,
26579,
26594,
26584,
26589,
26606,
26576,
26638,
26639,
-1,
26568,
26549,
26550,
26540,
26537,
26534,
26530,
26554,
26560,
26551,
26563,
26538,
26558,
26557,
26564,
26555,
26525,
26528,
26570,
26533,
26561,
26532,
26539,
26566,
26569,
26546,
26567,
26527,
26524,
26553,
26545,
26571,
26541,
26544,
26531,
26547,
4650,
4643,
4593,
4642,
4753,
4727,
4745,
4766,
4775,
4779,
4782,
4786,
26653,
4726,
4720,
4721,
4729,
4730,
4723,
4724,
4732,
4731,
4735,
4744,
4738,
4739,
4747,
4748,
4864,
4881,
4854,
4879,
4883,
4859,
4877,
4873,
4869,
4871,
4866,
4856,
4861,
4885,
4865,
4882,
4855,
4880,
4884,
4860,
4878,
4876,
4870,
4872,
4867,
4857,
4862,
4886,
4850,
4849,
4875,
23876,
4652,
4626,
4627,
4599,
4596,
4592,
4588,
4617,
4631,
4628,
4612,
4597,
4640,
4639,
4610,
4618,
4582,
4586,
4646,
4591,
4633,
4590,
4598,
4623,
4637,
4589,
4613,
4600,
4583,
4615,
4651,
4648,
4653,
4604,
4622,
4621,
4645,
4624,
4635,
4636,
4607,
4611,
4606,
4585,
4581,
4616,
4605,
4649,
4632,
4741,
4742,
4750,
4749,
4756,
4765,
4759,
4760,
4768,
4769,
4762,
4763,
4771,
4770,
4774,
27440,
27450,
27443,
27446,
27442,
27438,
27439,
27445,
27447,
27448,
27449,
27399,
19009,
19082,
19083,
9649,
4847,
4845,
4843,
4846,
4844,
4827,
4825,
4823,
4826,
4824,
4803,
4801,
4799,
4802,
4800,
4797,
4795,
4793,
4796,
4794,
4815,
4813,
4811,
4814,
4812,
4833,
4831,
4829,
4832,
4830,
4821,
4819,
4817,
4820,
4818,
4842,
4840,
4841,
4809,
4807,
4805,
4808,
4806,
4838,
4836,
4837,
4835,
-1,
19117,
19116,
19118,
19120,
19099,
19098,
19152,
19084,
19085,
19129,
19128,
18917,
18916,
18915,
19016,
19017,
19014,
19013,
18924,
19012,
18909,
18912,
18911,
18910,
19019,
19020,
18919,
18920,
18933,
18922,
18923,
19092,
19091,
19095,
19089,
19088,
19060,
19064,
19061,
19149,
19068,
19072,
19006,
18947,
18946,
19108,
18953,
18951,
18952,
19112,
18994,
18993,
19109,
18992,
19004,
18942,
18941,
19003,
18940,
18943,
19113,
18956,
19111,
18999,
18955,
18997,
18998,
18866,
18865,
18869,
18867,
18868,
18881,
18878,
18879,
18887,
18888,
18889,
19141,
19140,
19142,
19027,
19028,
19035,
19034,
19038,
19037,
18989,
27434,
27435,
27412,
27414,
27423,
27426,
27418,
27420,
27429,
27432,
27416,
27431,
27411,
27415,
27424,
27427,
27419,
27421,
27430,
27433,
27404,
27409,
27407,
27408,
27410,
19001,
19059,
19115,
19107,
19127,
18965,
19055,
19057,
19058,
19104,
19081,
19079,
19078,
19080,
19046,
18948,
19067,
18862,
18863,
18913,
18935,
18894,
19024,
19049,
18934,
18964,
19074,
18861,
18860,
18901,
18932,
19007,
18931,
18900,
19023,
19150,
18859,
18899,
19062,
18929,
19147,
19073,
18858,
18882,
19041,
18903,
18884,
19043,
18875,
18908,
18885,
19044,
18876,
18906,
18872,
18873,
18944,
18928,
18897,
19022,
19030,
19031,
19032,
18959,
19071,
18857,
18896,
18958,
19070,
18856,
18892,
18926,
18893,
18957,
19069,
18855,
18890,
18925,
18891,
18936,
18874,
19119,
19110,
19052,
19051,
19053,
19045,
19065,
19021,
19005,
19000,
19097,
18930,
18907,
18927,
19136,
19135,
19133,
19134,
18895,
18880,
18898,
18963,
18962,
18961,
18960,
19094,
19093,
18988,
19151,
19121,
27398,
27373,
27379,
27387,
27390,
27382,
27384,
27393,
27396,
27380,
27395,
27372,
27378,
27388,
27391,
27383,
27385,
27394,
27397,
27358,
27369,
27361,
27362,
27367,
27368,
27364,
27365,
27371,
27370,
27376,
27377,
19018,
]

_charnames_19904 = [
21212,
21223,
21237,
21299,
21292,
21280,
21218,
21301,
21253,
21229,
21271,
21255,
21298,
21246,
21295,
21302,
21297,
21291,
21287,
21279,
21284,
21249,
21256,
21265,
21259,
21248,
21294,
21247,
21219,
21213,
21261,
21238,
21266,
21245,
21270,
21239,
21228,
21275,
21276,
21233,
21234,
21262,
21283,
21281,
21250,
21269,
21274,
21221,
21267,
21214,
21217,
21225,
21232,
21224,
21289,
21222,
21227,
21226,
21236,
21300,
21260,
21254,
21288,
21285,
]

_charnames_40960 = [
17194,
17196,
17189,
17197,
17192,
17191,
17190,
17193,
17204,
17203,
17202,
17205,
17207,
17206,
17208,
17200,
17199,
17198,
17201,
17210,
17209,
17175,
16557,
16556,
16551,
16558,
16554,
16553,
16552,
16555,
16571,
16570,
16569,
16572,
16544,
16543,
16545,
16567,
16566,
16565,
16568,
16574,
16573,
16575,
16549,
16548,
16542,
16550,
16547,
16546,
16563,
16562,
16559,
16564,
16561,
16560,
16999,
16998,
16994,
17000,
16996,
16995,
16997,
17013,
17012,
17011,
17014,
16987,
16986,
16988,
17009,
17008,
17007,
17010,
16992,
16991,
16985,
16993,
16990,
16989,
17005,
17004,
17001,
17006,
17003,
17002,
16525,
16524,
16519,
16526,
16522,
16521,
16520,
16523,
16537,
16536,
16535,
16538,
16512,
16511,
16513,
16533,
16532,
16531,
16534,
16540,
16539,
16541,
16517,
16516,
16510,
16518,
16515,
16514,
16529,
16528,
16527,
16530,
16034,
16033,
16029,
16035,
16031,
16030,
16032,
16054,
16053,
16052,
16055,
16050,
16049,
16048,
16051,
16046,
16045,
16042,
16047,
16044,
16043,
16040,
16039,
16036,
16041,
16038,
16037,
16243,
16242,
16238,
16244,
16240,
16239,
16241,
16256,
16255,
16254,
16257,
16231,
16230,
16232,
16252,
16251,
16250,
16253,
16236,
16235,
16229,
16237,
16234,
16233,
16248,
16245,
16249,
16247,
16246,
16738,
16737,
16733,
16739,
16735,
16734,
16736,
16750,
16749,
16748,
16751,
16726,
16725,
16724,
16727,
16746,
16745,
16744,
16747,
16753,
16752,
16731,
16730,
16723,
16732,
16729,
16728,
16742,
16741,
16740,
16743,
17144,
17143,
17142,
17145,
17148,
17147,
17146,
17149,
17151,
17150,
17152,
17136,
17135,
17132,
17137,
17134,
17133,
17140,
17139,
17138,
17141,
16959,
16958,
16953,
16960,
16956,
16955,
16954,
16957,
16979,
16978,
16977,
16980,
16975,
16974,
16973,
16976,
16982,
16983,
16971,
16970,
16967,
16972,
16969,
16968,
16965,
16964,
16961,
16966,
16963,
16962,
16851,
16850,
16846,
16852,
16848,
16847,
16849,
16859,
16858,
16857,
16860,
16842,
16841,
16855,
16854,
16853,
16856,
16862,
16861,
16863,
16844,
16843,
16838,
16845,
16840,
16839,
17060,
17059,
17055,
17061,
17057,
17056,
17058,
17068,
17067,
17066,
17069,
17048,
17047,
17046,
17049,
17064,
17063,
17062,
17065,
17071,
17070,
17072,
17053,
17052,
17045,
17054,
17051,
17050,
16825,
16824,
16820,
16826,
16822,
16821,
16823,
16833,
16832,
16831,
16834,
16813,
16812,
16814,
16829,
16828,
16827,
16830,
16836,
16835,
16837,
16818,
16817,
16811,
16819,
16816,
16815,
16117,
16116,
16113,
16118,
16115,
16114,
16125,
16124,
16123,
16126,
16121,
16120,
16119,
16122,
16128,
16127,
16129,
16111,
16110,
16107,
16112,
16109,
16108,
16289,
16288,
16283,
16290,
16286,
16285,
16284,
16287,
16293,
16292,
16291,
16294,
16297,
16296,
16301,
16300,
16302,
16304,
16303,
16305,
16298,
16182,
16181,
16177,
16183,
16179,
16178,
16180,
16192,
16191,
16193,
16170,
16169,
16171,
16186,
16185,
16184,
16187,
16189,
16188,
16190,
16175,
16174,
16168,
16176,
16173,
16172,
16210,
16209,
16205,
16211,
16207,
16206,
16208,
16220,
16219,
16218,
16221,
16198,
16197,
16199,
16223,
16222,
16224,
16226,
16225,
16227,
16203,
16202,
16196,
16204,
16201,
16200,
16216,
16215,
16212,
16217,
16214,
16213,
16933,
16932,
16927,
16934,
16930,
16929,
16928,
16931,
16947,
16946,
16945,
16948,
16920,
16919,
16918,
16921,
16943,
16942,
16941,
16944,
16950,
16949,
16951,
16925,
16924,
16917,
16926,
16923,
16922,
16939,
16938,
16935,
16940,
16937,
16936,
16685,
16684,
16679,
16686,
16682,
16681,
16680,
16683,
16697,
16696,
16695,
16698,
16672,
16671,
16670,
16673,
16689,
16688,
16687,
16690,
16693,
16692,
16691,
16694,
16677,
16676,
16669,
16678,
16675,
16674,
17117,
17116,
17112,
17118,
17114,
17113,
17115,
17129,
17128,
17127,
17130,
17105,
17104,
17106,
17121,
17120,
17119,
17122,
17125,
17124,
17123,
17126,
17110,
17109,
17103,
17111,
17108,
17107,
16656,
16655,
16651,
16653,
16652,
16654,
16667,
16666,
16665,
16668,
16644,
16643,
16642,
16645,
16659,
16658,
16657,
16660,
16663,
16662,
16661,
16664,
16649,
16648,
16641,
16650,
16647,
16646,
16722,
16721,
16716,
16715,
16714,
16717,
16703,
16702,
16704,
16712,
16711,
16710,
16713,
16719,
16718,
16720,
16708,
16707,
16701,
16709,
16706,
16705,
16265,
16264,
16259,
16266,
16262,
16261,
16260,
16263,
16277,
16276,
16275,
16278,
16269,
16268,
16267,
16270,
16273,
16272,
16271,
16274,
16280,
16279,
16281,
16163,
16162,
16164,
16157,
16156,
16155,
16158,
16161,
16160,
16159,
16153,
16152,
16151,
16154,
16166,
16165,
16167,
16321,
16320,
16319,
16316,
16315,
16314,
16317,
16308,
16307,
16306,
16309,
16312,
16311,
16310,
16313,
16323,
16322,
16324,
17181,
17180,
17179,
17182,
17177,
17176,
17178,
17184,
17183,
17185,
17187,
17186,
17188,
16398,
16397,
16393,
16399,
16395,
16394,
16396,
16412,
16411,
16410,
16413,
16386,
16385,
16387,
16408,
16407,
16406,
16409,
16415,
16414,
16416,
16391,
16390,
16384,
16392,
16389,
16388,
16404,
16403,
16400,
16405,
16402,
16401,
16620,
16619,
16614,
16621,
16617,
16616,
16615,
16618,
16634,
16633,
16632,
16635,
16607,
16606,
16608,
16630,
16629,
16628,
16631,
16637,
16636,
16638,
16612,
16611,
16605,
16613,
16610,
16609,
16626,
16625,
16622,
16627,
16624,
16623,
16333,
16332,
16327,
16334,
16330,
16329,
16328,
16331,
16348,
16347,
16346,
16349,
16351,
16350,
16352,
16354,
16353,
16355,
16344,
16341,
16345,
16343,
16342,
16339,
16338,
16335,
16340,
16337,
16336,
16011,
16010,
16006,
16012,
16008,
16007,
16009,
16021,
16020,
16019,
16022,
16003,
16002,
16024,
16025,
16027,
16026,
16004,
15999,
16005,
16001,
16000,
16017,
16016,
16013,
16018,
16015,
16014,
16489,
16488,
16484,
16490,
16486,
16485,
16487,
16503,
16502,
16501,
16504,
16477,
16476,
16478,
16499,
16498,
16497,
16500,
16506,
16505,
16507,
16482,
16481,
16475,
16483,
16480,
16479,
16495,
16494,
16491,
16496,
16493,
16492,
16424,
16423,
16419,
16425,
16421,
16420,
16422,
16442,
16441,
16440,
16443,
16438,
16437,
16436,
16439,
16445,
16444,
16446,
16434,
16433,
16432,
16435,
16430,
16429,
16426,
16431,
16428,
16427,
16382,
16381,
16380,
16383,
16359,
16358,
16360,
16374,
16373,
16372,
16375,
16378,
16377,
16376,
16379,
16364,
16363,
16357,
16365,
16362,
16361,
16370,
16369,
16366,
16371,
16368,
16367,
16603,
16602,
16601,
16604,
16581,
16580,
16579,
16582,
16595,
16594,
16593,
16596,
16599,
16598,
16597,
16600,
16585,
16578,
16586,
16584,
16583,
16591,
16590,
16587,
16592,
16589,
16588,
16889,
16888,
16870,
16869,
16882,
16881,
16880,
16883,
16886,
16885,
16884,
16887,
16872,
16871,
16866,
16873,
16868,
16867,
16878,
16877,
16874,
16879,
16876,
16875,
16101,
16100,
16099,
16102,
16104,
16103,
16105,
16097,
16096,
16095,
16098,
16093,
16092,
16089,
16094,
16091,
16090,
16087,
16086,
16083,
16088,
16085,
16084,
16473,
16472,
16471,
16474,
16450,
16449,
16451,
16465,
16464,
16463,
16466,
16469,
16468,
16467,
16470,
16455,
16454,
16448,
16456,
16453,
16452,
16461,
16460,
16457,
16462,
16459,
16458,
16911,
16910,
16909,
16912,
16892,
16891,
16893,
16907,
16906,
16905,
16908,
16914,
16913,
16915,
16897,
16896,
16890,
16898,
16895,
16894,
16903,
16902,
16899,
16904,
16901,
16900,
16797,
16796,
16791,
16798,
16794,
16793,
16792,
16795,
16784,
16783,
16782,
16785,
16807,
16806,
16805,
16808,
16789,
16788,
16781,
16790,
16787,
16786,
16803,
16802,
16799,
16804,
16801,
16800,
17090,
17089,
17084,
17091,
17087,
17086,
17085,
17088,
17077,
17076,
17075,
17078,
17100,
17099,
17098,
17101,
17082,
17081,
17074,
17083,
17080,
17079,
17096,
17095,
17092,
17097,
17094,
17093,
16771,
16770,
16765,
16772,
16768,
16767,
16766,
16769,
16758,
16757,
16759,
16779,
16778,
16777,
16780,
16763,
16762,
16756,
16764,
16761,
16760,
16775,
16774,
16773,
16776,
16063,
16062,
16057,
16064,
16060,
16059,
16058,
16061,
16069,
16068,
16080,
16079,
16078,
16081,
16070,
16065,
16071,
16067,
16066,
16076,
16075,
16072,
16077,
16074,
16073,
16137,
16136,
16131,
16138,
16134,
16133,
16132,
16135,
16141,
16140,
16142,
16148,
16147,
16146,
16149,
16144,
16143,
16139,
16145,
17160,
17159,
17154,
17161,
17157,
17156,
17155,
17158,
17173,
17172,
17170,
17169,
17168,
17171,
17166,
17165,
17162,
17167,
17164,
17163,
17032,
17031,
17026,
17033,
17029,
17028,
17027,
17030,
17019,
17018,
17017,
17020,
17042,
17041,
17040,
17043,
17024,
17023,
17016,
17025,
17022,
17021,
17038,
17037,
17034,
17039,
17036,
17035,
-1,
-1,
-1,
17287,
17259,
17278,
17243,
17215,
17232,
17236,
17238,
17276,
17256,
17261,
17285,
17275,
17263,
17273,
17254,
17270,
17239,
17222,
17214,
17282,
17284,
17235,
17242,
17269,
17288,
17249,
17224,
17272,
17257,
17264,
17266,
17228,
17267,
17225,
17251,
17244,
17248,
17237,
17250,
17286,
17281,
17229,
17260,
17213,
17216,
17217,
17255,
17231,
17221,
17230,
17218,
17223,
17245,
17279,
]

_charnames_42192 = [
9710,
9677,
9676,
9696,
9665,
9664,
9691,
9685,
9684,
9707,
9699,
9698,
9695,
9663,
9662,
9705,
9682,
9706,
9674,
9670,
9671,
9681,
9688,
9703,
9687,
9709,
9704,
9673,
9702,
9690,
9700,
9701,
9692,
9693,
9708,
9678,
9666,
9668,
9667,
9679,
9655,
9660,
9658,
9659,
9656,
9657,
9713,
9712,
24182,
24183,
24105,
24042,
24043,
24149,
24088,
24095,
23947,
23986,
23939,
24008,
24165,
24133,
24063,
24056,
23971,
23964,
24115,
24141,
23978,
23907,
24079,
24072,
24032,
24025,
24173,
24157,
23923,
24125,
23996,
23888,
24014,
23954,
23930,
23915,
24187,
24188,
24108,
24109,
24047,
24048,
24151,
24090,
24097,
23949,
23992,
23941,
24010,
24167,
24135,
24065,
24058,
23973,
23966,
24119,
24143,
23980,
23909,
24081,
24074,
24034,
24027,
24175,
24159,
23925,
24127,
24000,
23892,
24018,
23956,
23932,
23917,
24189,
24190,
23896,
24110,
24111,
24049,
24050,
24152,
24091,
24098,
23950,
23989,
23990,
23942,
24011,
24168,
24136,
24066,
24059,
23974,
23967,
24120,
24144,
23981,
23910,
24082,
24075,
24035,
24028,
24176,
24160,
23926,
24128,
23997,
23998,
23893,
24019,
23957,
23933,
23918,
24178,
24179,
24101,
24038,
24039,
24147,
24086,
24093,
23945,
23988,
23937,
24004,
24163,
24131,
24061,
24054,
23969,
23962,
24117,
24139,
23976,
23905,
24077,
24070,
24030,
24023,
24171,
24155,
23921,
24123,
23994,
23890,
24016,
23952,
23928,
23913,
24185,
24186,
24106,
24107,
24045,
24046,
24150,
24089,
24096,
23948,
23991,
23940,
24009,
24166,
24134,
24064,
24057,
23972,
23965,
24118,
24142,
23979,
23908,
24080,
24073,
24033,
24026,
24174,
24158,
23924,
24126,
23999,
23891,
24017,
23955,
23931,
23916,
24177,
24180,
23894,
24100,
24102,
24037,
24040,
24146,
24085,
24092,
23944,
23987,
23936,
24003,
24005,
24162,
24130,
24060,
24053,
23968,
23961,
24116,
24138,
23975,
23898,
24076,
24069,
24029,
24022,
24170,
24154,
23920,
24122,
23993,
23889,
24015,
23951,
23927,
23912,
24181,
24184,
23895,
24103,
24104,
24041,
24044,
24148,
24087,
24094,
23946,
23984,
23985,
23938,
24006,
24007,
24164,
24132,
24062,
24055,
23970,
23963,
24113,
24140,
23977,
23906,
24078,
24071,
24031,
24024,
24172,
24156,
23922,
24124,
23995,
23886,
23887,
24012,
24013,
23953,
23929,
23914,
23884,
24114,
24226,
24225,
24224,
23903,
23902,
23900,
24205,
24203,
24194,
24207,
24209,
24206,
24195,
24200,
24198,
24202,
24193,
24199,
24208,
24220,
24221,
24212,
24213,
24218,
24219,
24215,
24216,
24223,
24222,
23901,
23904,
]

_charnames_42560 = [
4381,
4152,
4359,
4130,
4465,
4236,
4324,
4095,
4364,
4135,
4487,
4259,
4414,
4185,
4485,
4257,
4386,
4157,
4318,
4089,
4464,
4235,
4323,
4094,
4459,
4230,
4415,
4186,
4321,
4092,
4391,
4162,
-1,
-1,
4350,
4121,
4348,
4119,
4347,
4118,
4488,
4260,
4411,
4182,
4366,
4137,
4501,
3468,
3464,
3467,
3463,
20214,
]

_charnames_42620 = [
3470,
3457,
4504,
4503,
4365,
4136,
4361,
4132,
4376,
4147,
4460,
4231,
4360,
4131,
4401,
4172,
4403,
4174,
4395,
4166,
4396,
4167,
4404,
4175,
4451,
4222,
4341,
4112,
]

_charnames_42656 = [
18213,
18142,
18209,
18139,
18212,
18168,
18188,
18210,
18125,
18211,
18196,
18182,
18170,
18171,
18195,
18146,
18189,
18128,
18115,
18143,
18160,
18150,
18158,
18161,
18159,
18162,
18138,
18136,
18121,
18120,
18113,
18204,
18156,
18203,
18205,
18126,
18135,
18179,
18114,
18124,
18176,
18207,
18180,
18200,
18172,
18192,
18152,
18127,
18166,
18173,
18137,
18117,
18118,
18119,
18157,
18177,
18198,
18199,
18208,
18129,
18194,
18181,
18193,
18131,
18148,
18167,
18145,
18153,
18190,
18141,
18151,
18149,
18185,
18140,
18186,
18123,
18163,
18201,
18132,
18133,
18218,
18217,
18223,
18224,
18220,
18219,
18221,
18222,
]

_charnames_42752 = [
6663,
6668,
6660,
6665,
6662,
6667,
6661,
6666,
6709,
6767,
6742,
6685,
6716,
6710,
6768,
6743,
6686,
6717,
6712,
6770,
6745,
6682,
6719,
6755,
6756,
6757,
6701,
6725,
6728,
6727,
6726,
6697,
6627,
6626,
8655,
7915,
8656,
7916,
8967,
8322,
8831,
7843,
8832,
7845,
8995,
8343,
8996,
8344,
9143,
9136,
8713,
8040,
8710,
8039,
8709,
8038,
8706,
8033,
8707,
8034,
8708,
8037,
8875,
8205,
9020,
8406,
9018,
8404,
9021,
8407,
9080,
8427,
8895,
8233,
8590,
7965,
8589,
7964,
8599,
7980,
9054,
8447,
9057,
8452,
9055,
8448,
9092,
8486,
9093,
8487,
8872,
8198,
8876,
8209,
9044,
8434,
9047,
8440,
9048,
8441,
8829,
7840,
8830,
7841,
9049,
8442,
8652,
7912,
8799,
8137,
8997,
8345,
6776,
8279,
8242,
8469,
8303,
8208,
9109,
7811,
8095,
8798,
8134,
8797,
8133,
8796,
8823,
7801,
8822,
7806,
8795,
8131,
8794,
8130,
8793,
8129,
6699,
6674,
6629,
8852,
8172,
]

_charnames_43003 = [
9174,
9173,
9176,
9177,
9178,
19380,
19377,
19394,
19371,
19379,
19373,
19393,
19357,
19358,
19363,
19364,
19395,
19366,
19367,
19360,
19361,
19340,
19341,
19346,
19347,
19342,
19343,
19348,
19349,
19374,
19354,
19355,
19369,
19370,
19375,
19352,
19376,
19351,
19372,
19378,
19386,
19384,
19382,
19385,
19383,
19391,
19390,
19389,
19388,
-1,
-1,
-1,
-1,
27236,
27237,
27241,
27235,
27238,
27240,
27243,
27246,
27245,
27244,
-1,
-1,
-1,
-1,
-1,
-1,
26705,
26704,
26708,
26677,
26688,
26690,
26720,
26675,
26673,
26672,
26686,
26678,
26702,
26701,
26724,
26718,
26671,
26670,
26684,
26713,
26695,
26696,
26680,
26711,
26715,
26719,
26681,
26682,
26722,
26691,
26721,
26714,
26709,
26717,
26716,
26712,
26723,
26707,
26710,
26729,
26728,
26668,
26667,
26685,
26676,
26693,
26698,
26699,
26692,
26730,
26731,
26689,
26732,
26736,
26734,
26735,
]

_charnames_43136 = [
19560,
19558,
19480,
19483,
19504,
19505,
19488,
19489,
19458,
19459,
19460,
19461,
19509,
19510,
19482,
19493,
19494,
19481,
19500,
19499,
19508,
19507,
19472,
19513,
19512,
19503,
19502,
19470,
19466,
19465,
19477,
19476,
19471,
19468,
19467,
19479,
19478,
19473,
19492,
19491,
19516,
19515,
19519,
19517,
19518,
19497,
19462,
19486,
19485,
19487,
19520,
19496,
19561,
19530,
19535,
19536,
19531,
19532,
19523,
19524,
19525,
19526,
19537,
19538,
19529,
19533,
19534,
19528,
19559,
]

_charnames_43214 = [
19555,
19554,
19550,
19551,
19542,
19543,
19548,
19549,
19545,
19546,
19553,
19552,
-1,
-1,
-1,
-1,
-1,
-1,
3608,
3609,
3600,
3601,
3606,
3607,
3603,
3604,
3611,
3610,
3619,
3614,
3618,
3617,
3616,
3615,
3613,
3620,
25050,
25042,
25055,
25040,
25041,
25043,
25051,
25078,
25084,
25083,
-1,
-1,
-1,
-1,
23491,
23492,
23483,
23484,
23489,
23490,
23486,
23487,
23494,
23493,
23464,
23463,
23476,
23448,
23455,
23454,
23468,
23447,
23452,
23466,
23449,
23458,
23457,
23473,
23477,
23479,
23472,
23469,
23474,
23470,
23451,
23467,
23471,
23478,
23480,
23461,
23475,
23460,
23497,
23498,
23496,
23499,
