#!/usr/bin/env python

import os
import sys


class ExampleRemoteLibrary:
    """Example library to be used with Robot Framework's remote server.

    This documentation is visible in docs generated by _libdoc.py_
    starting from Robot Framework 2.6.2.
    """

    def __init__(self):
        """Also this doc should be in shown in library doc."""

    def count_items_in_directory(self, path):
        """Returns the number of items in the directory specified by `path`."""
        return len([i for i in os.listdir(path) if not i.startswith('.')])

    def strings_should_be_equal(self, str1, str2):
        print "Comparing '%s' to '%s'" % (str1, str2)
        if str1 != str2:
            raise AssertionError("Given strings are not equal")


if __name__ == '__main__':
    from robotremoteserver import RobotRemoteServer
    RobotRemoteServer(ExampleRemoteLibrary(), *sys.argv[1:])
