PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE auto_shape_types (
    id         integer,
    prst       text,
    const_name text,
    base_name  text,
    ms_name    text,
    desc       text
);
INSERT INTO "auto_shape_types" VALUES(1,'rect','RECTANGLE','Rectangle','msoShapeRectangle','Rectangle');
INSERT INTO "auto_shape_types" VALUES(2,'parallelogram','PARALLELOGRAM','Parallelogram','msoShapeParallelogram','Parallelogram');
INSERT INTO "auto_shape_types" VALUES(3,'trapezoid','TRAPEZOID','Trapezoid','msoShapeTrapezoid','Trapezoid');
INSERT INTO "auto_shape_types" VALUES(4,'diamond','DIAMOND','Diamond','msoShapeDiamond','Diamond');
INSERT INTO "auto_shape_types" VALUES(5,'roundRect','ROUNDED_RECTANGLE','Rounded Rectangle','msoShapeRoundedRectangle','Rounded rectangle');
INSERT INTO "auto_shape_types" VALUES(6,'octagon','OCTAGON','Octagon','msoShapeOctagon','Octagon');
INSERT INTO "auto_shape_types" VALUES(7,'triangle','ISOSCELES_TRIANGLE','Isosceles Triangle','msoShapeIsoscelesTriangle','Isosceles triangle');
INSERT INTO "auto_shape_types" VALUES(8,'rtTriangle','RIGHT_TRIANGLE','Right Triangle','msoShapeRightTriangle','Right triangle');
INSERT INTO "auto_shape_types" VALUES(9,'ellipse','OVAL','Oval','msoShapeOval','Oval');
INSERT INTO "auto_shape_types" VALUES(10,'hexagon','HEXAGON','Hexagon','msoShapeHexagon','Hexagon');
INSERT INTO "auto_shape_types" VALUES(11,'plus','CROSS','Cross','msoShapeCross','Cross');
INSERT INTO "auto_shape_types" VALUES(12,'pentagon','REGULAR_PENTAGON','Regular Pentagon','msoShapeRegularPentagon','Pentagon');
INSERT INTO "auto_shape_types" VALUES(13,'can','CAN','Can','msoShapeCan','Can');
INSERT INTO "auto_shape_types" VALUES(14,'cube','CUBE','Cube','msoShapeCube','Cube');
INSERT INTO "auto_shape_types" VALUES(15,'bevel','BEVEL','Bevel','msoShapeBevel','Bevel');
INSERT INTO "auto_shape_types" VALUES(16,'folderCorner','FOLDED_CORNER','Folded Corner','msoShapeFoldedCorner','Folded corner');
INSERT INTO "auto_shape_types" VALUES(17,'smileyFace','SMILEY_FACE','Smiley Face','msoShapeSmileyFace','Smiley face');
INSERT INTO "auto_shape_types" VALUES(18,'donut','DONUT','Donut','msoShapeDonut','Donut');
INSERT INTO "auto_shape_types" VALUES(19,'noSmoking','NO_SYMBOL','"No" symbol','msoShapeNoSymbol','"No" symbol');
INSERT INTO "auto_shape_types" VALUES(20,'blockArc','BLOCK_ARC','Block Arc','msoShapeBlockArc','Block arc');
INSERT INTO "auto_shape_types" VALUES(21,'heart','HEART','Heart','msoShapeHeart','Heart');
INSERT INTO "auto_shape_types" VALUES(22,'lightningBolt','LIGHTNING_BOLT','Lightning Bolt','msoShapeLightningBolt','Lightning bolt');
INSERT INTO "auto_shape_types" VALUES(23,'sun','SUN','Sun','msoShapeSun','Sun');
INSERT INTO "auto_shape_types" VALUES(24,'moon','MOON','Moon','msoShapeMoon','Moon');
INSERT INTO "auto_shape_types" VALUES(25,'arc','ARC','Arc','msoShapeArc','Arc');
INSERT INTO "auto_shape_types" VALUES(26,'bracketPair','DOUBLE_BRACKET','Double Bracket','msoShapeDoubleBracket','Double bracket');
INSERT INTO "auto_shape_types" VALUES(27,'bracePair','DOUBLE_BRACE','Double Brace','msoShapeDoubleBrace','Double brace');
INSERT INTO "auto_shape_types" VALUES(28,'plaque','PLAQUE','Plaque','msoShapePlaque','Plaque');
INSERT INTO "auto_shape_types" VALUES(29,'leftBracket','LEFT_BRACKET','Left Bracket','msoShapeLeftBracket','Left bracket');
INSERT INTO "auto_shape_types" VALUES(30,'rightBracket','RIGHT_BRACKET','Right Bracket','msoShapeRightBracket','Right bracket');
INSERT INTO "auto_shape_types" VALUES(31,'leftBrace','LEFT_BRACE','Left Brace','msoShapeLeftBrace','Left brace');
INSERT INTO "auto_shape_types" VALUES(32,'rightBrace','RIGHT_BRACE','Right Brace','msoShapeRightBrace','Right brace');
INSERT INTO "auto_shape_types" VALUES(33,'rightArrow','RIGHT_ARROW','Right Arrow','msoShapeRightArrow','Block arrow that points right');
INSERT INTO "auto_shape_types" VALUES(34,'leftArrow','LEFT_ARROW','Left Arrow','msoShapeLeftArrow','Block arrow that points left');
INSERT INTO "auto_shape_types" VALUES(35,'upArrow','UP_ARROW','Up Arrow','msoShapeUpArrow','Block arrow that points up');
INSERT INTO "auto_shape_types" VALUES(36,'downArrow','DOWN_ARROW','Down Arrow','msoShapeDownArrow','Block arrow that points down');
INSERT INTO "auto_shape_types" VALUES(37,'leftRightArrow','LEFT_RIGHT_ARROW','Left-Right Arrow','msoShapeLeftRightArrow','Block arrow with arrowheads that point both left and right');
INSERT INTO "auto_shape_types" VALUES(38,'upDownArrow','UP_DOWN_ARROW','Up-Down Arrow','msoShapeUpDownArrow','Block arrow that points up and down');
INSERT INTO "auto_shape_types" VALUES(39,'quadArrow','QUAD_ARROW','Quad Arrow','msoShapeQuadArrow','Block arrows that point up, down, left, and right');
INSERT INTO "auto_shape_types" VALUES(40,'leftRightUpArrow','LEFT_RIGHT_UP_ARROW','Left-Right-Up Arrow','msoShapeLeftRightUpArrow','Block arrow with arrowheads that point left, right, and up');
INSERT INTO "auto_shape_types" VALUES(41,'bentArrow','BENT_ARROW','Bent Arrow','msoShapeBentArrow','Block arrow that follows a curved 90-degree angle');
INSERT INTO "auto_shape_types" VALUES(42,'uturnArrow','U_TURN_ARROW','U-Turn Arrow','msoShapeUTurnArrow','Block arrow forming a U shape');
INSERT INTO "auto_shape_types" VALUES(43,'leftUpArrow','LEFT_UP_ARROW','Left-Up Arrow','msoShapeLeftUpArrow','Block arrow with arrowheads that point left and up');
INSERT INTO "auto_shape_types" VALUES(44,'bentUpArrow','BENT_UP_ARROW','Bent-Up Arrow','msoShapeBentUpArrow','Block arrow that follows a sharp 90-degree angle. Points up by default');
INSERT INTO "auto_shape_types" VALUES(45,'curvedRightArrow','CURVED_RIGHT_ARROW','Curved Right Arrow','msoShapeCurvedRightArrow','Block arrow that curves right');
INSERT INTO "auto_shape_types" VALUES(46,'curvedLeftArrow','CURVED_LEFT_ARROW','Curved Left Arrow','msoShapeCurvedLeftArrow','Block arrow that curves left');
INSERT INTO "auto_shape_types" VALUES(47,'curvedUpArrow','CURVED_UP_ARROW','Curved Up Arrow','msoShapeCurvedUpArrow','Block arrow that curves up');
INSERT INTO "auto_shape_types" VALUES(48,'curvedDownArrow','CURVED_DOWN_ARROW','Curved Down Arrow','msoShapeCurvedDownArrow','Block arrow that curves down');
INSERT INTO "auto_shape_types" VALUES(49,'stripedRightArrow','STRIPED_RIGHT_ARROW','Striped Right Arrow','msoShapeStripedRightArrow','Block arrow that points right with stripes at the tail');
INSERT INTO "auto_shape_types" VALUES(50,'notchedRightArrow','NOTCHED_RIGHT_ARROW','Notched Right Arrow','msoShapeNotchedRightArrow','Notched block arrow that points right');
INSERT INTO "auto_shape_types" VALUES(51,'homePlate','PENTAGON','Pentagon','msoShapePentagon','Pentagon');
INSERT INTO "auto_shape_types" VALUES(52,'chevron','CHEVRON','Chevron','msoShapeChevron','Chevron');
INSERT INTO "auto_shape_types" VALUES(53,'rightArrowCallout','RIGHT_ARROW_CALLOUT','Right Arrow Callout','msoShapeRightArrowCallout','Callout with arrow that points right');
INSERT INTO "auto_shape_types" VALUES(54,'leftArrowCallout','LEFT_ARROW_CALLOUT','Left Arrow Callout','msoShapeLeftArrowCallout','Callout with arrow that points left');
INSERT INTO "auto_shape_types" VALUES(55,'upArrowCallout','UP_ARROW_CALLOUT','Up Arrow Callout','msoShapeUpArrowCallout','Callout with arrow that points up');
INSERT INTO "auto_shape_types" VALUES(56,'downArrowCallout','DOWN_ARROW_CALLOUT','Down Arrow Callout','msoShapeDownArrowCallout','Callout with arrow that points down');
INSERT INTO "auto_shape_types" VALUES(57,'leftRightArrowCallout','LEFT_RIGHT_ARROW_CALLOUT','Left-Right Arrow Callout','msoShapeLeftRightArrowCallout','Callout with arrowheads that point both left and right');
INSERT INTO "auto_shape_types" VALUES(58,'upDownArrowCallout','UP_DOWN_ARROW_CALLOUT','Up-Down Arrow Callout','msoShapeUpDownArrowCallout','Callout with arrows that point up and down');
INSERT INTO "auto_shape_types" VALUES(59,'quadArrowCallout','QUAD_ARROW_CALLOUT','Quad Arrow Callout','msoShapeQuadArrowCallout','Callout with arrows that point up, down, left, and right');
INSERT INTO "auto_shape_types" VALUES(60,'circularArrow','CIRCULAR_ARROW','Circular Arrow','msoShapeCircularArrow','Block arrow that follows a curved 180-degree angle');
INSERT INTO "auto_shape_types" VALUES(61,'flowChartProcess','FLOWCHART_PROCESS','Process','msoShapeFlowchartProcess','Process flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(62,'flowChartAlternateProcess','FLOWCHART_ALTERNATE_PROCESS','Alternate process','msoShapeFlowchartAlternateProcess','Alternate process flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(63,'flowChartDecision','FLOWCHART_DECISION','Decision','msoShapeFlowchartDecision','Decision flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(64,'flowChartInputOutput','FLOWCHART_DATA','Data','msoShapeFlowchartData','Data flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(65,'flowChartPredefinedProcess','FLOWCHART_PREDEFINED_PROCESS','Predefined Process','msoShapeFlowchartPredefinedProcess','Predefined process flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(66,'flowChartInternalStorage','FLOWCHART_INTERNAL_STORAGE','Internal Storage','msoShapeFlowchartInternalStorage','Internal storage flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(67,'flowChartDocument','FLOWCHART_DOCUMENT','Document','msoShapeFlowchartDocument','Document flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(68,'flowChartMultidocument','FLOWCHART_MULTIDOCUMENT','Multidocument','msoShapeFlowchartMultidocument','Multi-document flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(69,'flowChartTerminator','FLOWCHART_TERMINATOR','Terminator','msoShapeFlowchartTerminator','Terminator flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(70,'flowChartPreparation','FLOWCHART_PREPARATION','Preparation','msoShapeFlowchartPreparation','Preparation flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(71,'flowChartManualInput','FLOWCHART_MANUAL_INPUT','Manual Input','msoShapeFlowchartManualInput','Manual input flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(72,'flowChartManualOperation','FLOWCHART_MANUAL_OPERATION','Manual Operation','msoShapeFlowchartManualOperation','Manual operation flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(73,'flowChartConnector','FLOWCHART_CONNECTOR','Connector','msoShapeFlowchartConnector','Connector flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(74,'flowChartOffpageConnector','FLOWCHART_OFFPAGE_CONNECTOR','Off-page Connector','msoShapeFlowchartOffpageConnector','Off-page connector flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(75,'flowChartPunchedCard','FLOWCHART_CARD','Card','msoShapeFlowchartCard','Card flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(76,'flowChartPunchedTape','FLOWCHART_PUNCHED_TAPE','Punched Tape','msoShapeFlowchartPunchedTape','Punched tape flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(77,'flowChartSummingJunction','FLOWCHART_SUMMING_JUNCTION','Summing Junction','msoShapeFlowchartSummingJunction','Summing junction flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(78,'flowChartOr','FLOWCHART_OR','Or','msoShapeFlowchartOr','"Or" flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(79,'flowChartCollate','FLOWCHART_COLLATE','Collate','msoShapeFlowchartCollate','Collate flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(80,'flowChartSort','FLOWCHART_SORT','Sort','msoShapeFlowchartSort','Sort flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(81,'flowChartExtract','FLOWCHART_EXTRACT','Extract','msoShapeFlowchartExtract','Extract flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(82,'flowChartMerge','FLOWCHART_MERGE','Merge','msoShapeFlowchartMerge','Merge flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(83,'flowChartOnlineStorage','FLOWCHART_STORED_DATA','Stored Data','msoShapeFlowchartStoredData','Stored data flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(84,'flowChartDelay','FLOWCHART_DELAY','Delay','msoShapeFlowchartDelay','Delay flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(85,'flowChartMagneticTape','FLOWCHART_SEQUENTIAL_ACCESS_STORAGE','Sequential Access Storage','msoShapeFlowchartSequentialAccessStorage','Sequential access storage flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(86,'flowChartMagneticDisk','FLOWCHART_MAGNETIC_DISK','Magnetic Disk','msoShapeFlowchartMagneticDisk','Magnetic disk flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(87,'flowChartMagneticDrum','FLOWCHART_DIRECT_ACCESS_STORAGE','Direct Access Storage','msoShapeFlowchartDirectAccessStorage','Direct access storage flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(88,'flowChartDisplay','FLOWCHART_DISPLAY','Display','msoShapeFlowchartDisplay','Display flowchart symbol');
INSERT INTO "auto_shape_types" VALUES(89,'irregularSeal1','EXPLOSION1','Explosion','msoShapeExplosion1','Explosion');
INSERT INTO "auto_shape_types" VALUES(90,'irregularSeal2','EXPLOSION2','Explosion','msoShapeExplosion2','Explosion');
INSERT INTO "auto_shape_types" VALUES(91,'star4','STAR_4_POINT','4-Point Star','msoShape4pointStar','4-point star');
INSERT INTO "auto_shape_types" VALUES(92,'star5','STAR_5_POINT','5-Point Star','msoShape5pointStar','5-point star');
INSERT INTO "auto_shape_types" VALUES(93,'star8','STAR_8_POINT','8-Point Star','msoShape8pointStar','8-point star');
INSERT INTO "auto_shape_types" VALUES(94,'star16','STAR_16_POINT','16-Point Star','msoShape16pointStar','16-point star');
INSERT INTO "auto_shape_types" VALUES(95,'star24','STAR_24_POINT','24-Point Star','msoShape24pointStar','24-point star');
INSERT INTO "auto_shape_types" VALUES(96,'star32','STAR_32_POINT','32-Point Star','msoShape32pointStar','32-point star');
INSERT INTO "auto_shape_types" VALUES(97,'ribbon2','UP_RIBBON','Up Ribbon','msoShapeUpRibbon','Ribbon banner with center area above ribbon ends');
INSERT INTO "auto_shape_types" VALUES(98,'ribbon','DOWN_RIBBON','Down Ribbon','msoShapeDownRibbon','Ribbon banner with center area below ribbon ends');
INSERT INTO "auto_shape_types" VALUES(99,'ellipseRibbon2','CURVED_UP_RIBBON','Curved Up Ribbon','msoShapeCurvedUpRibbon','Ribbon banner that curves up');
INSERT INTO "auto_shape_types" VALUES(100,'ellipseRibbon','CURVED_DOWN_RIBBON','Curved Down Ribbon','msoShapeCurvedDownRibbon','Ribbon banner that curves down');
INSERT INTO "auto_shape_types" VALUES(101,'verticalScroll','VERTICAL_SCROLL','Vertical Scroll','msoShapeVerticalScroll','Vertical scroll');
INSERT INTO "auto_shape_types" VALUES(102,'horizontalScroll','HORIZONTAL_SCROLL','Horizontal Scroll','msoShapeHorizontalScroll','Horizontal scroll');
INSERT INTO "auto_shape_types" VALUES(103,'wave','WAVE','Wave','msoShapeWave','Wave');
INSERT INTO "auto_shape_types" VALUES(104,'doubleWave','DOUBLE_WAVE','Double Wave','msoShapeDoubleWave','Double wave');
INSERT INTO "auto_shape_types" VALUES(105,'wedgeRectCallout','RECTANGULAR_CALLOUT','Rectangular Callout','msoShapeRectangularCallout','Rectangular callout');
INSERT INTO "auto_shape_types" VALUES(106,'wedgeRoundRectCallout','ROUNDED_RECTANGULAR_CALLOUT','Rounded Rectangular Callout','msoShapeRoundedRectangularCallout','Rounded rectangle-shaped callout');
INSERT INTO "auto_shape_types" VALUES(107,'wedgeEllipseCallout','OVAL_CALLOUT','Oval Callout','msoShapeOvalCallout','Oval-shaped callout');
INSERT INTO "auto_shape_types" VALUES(108,'cloudCallout','CLOUD_CALLOUT','Cloud Callout','msoShapeCloudCallout','Cloud callout');
INSERT INTO "auto_shape_types" VALUES(109,'borderCallout1','LINE_CALLOUT_1','Line Callout 1','msoShapeLineCallout1','Callout with border and horizontal callout line');
INSERT INTO "auto_shape_types" VALUES(110,'borderCallout2','LINE_CALLOUT_2','Line Callout 2','msoShapeLineCallout2','Callout with diagonal straight line');
INSERT INTO "auto_shape_types" VALUES(111,'borderCallout3','LINE_CALLOUT_3','Line Callout 3','msoShapeLineCallout3','Callout with angled line');
INSERT INTO "auto_shape_types" VALUES(112,'borderCallout3','LINE_CALLOUT_4','Line Callout 3','msoShapeLineCallout4','Callout with callout line segments forming a U-shape.');
INSERT INTO "auto_shape_types" VALUES(113,'accentCallout1','LINE_CALLOUT_1_ACCENT_BAR','Line Callout 1 (Accent Bar)','msoShapeLineCallout1AccentBar','Callout with vertical accent bar');
INSERT INTO "auto_shape_types" VALUES(114,'accentCallout2','LINE_CALLOUT_2_ACCENT_BAR','Line Callout 2 (Accent Bar)','msoShapeLineCallout2AccentBar','Callout with diagonal callout line and accent bar');
INSERT INTO "auto_shape_types" VALUES(115,'accentCallout3','LINE_CALLOUT_3_ACCENT_BAR','Line Callout 3 (Accent Bar)','msoShapeLineCallout3AccentBar','Callout with angled callout line and accent bar');
INSERT INTO "auto_shape_types" VALUES(116,'accentCallout3','LINE_CALLOUT_4_ACCENT_BAR','Line Callout 3 (Accent Bar)','msoShapeLineCallout4AccentBar','Callout with accent bar and callout line segments forming a U-shape.');
INSERT INTO "auto_shape_types" VALUES(117,'callout1','LINE_CALLOUT_1_NO_BORDER','Line Callout 1 (No Border)','msoShapeLineCallout1NoBorder','Callout with horizontal line');
INSERT INTO "auto_shape_types" VALUES(118,'callout2','LINE_CALLOUT_2_NO_BORDER','Line Callout 2 (No Border)','msoShapeLineCallout2NoBorder','Callout with no border and diagonal callout line');
INSERT INTO "auto_shape_types" VALUES(119,'callout3','LINE_CALLOUT_3_NO_BORDER','Line Callout 3 (No Border)','msoShapeLineCallout3NoBorder','Callout with no border and angled callout line');
INSERT INTO "auto_shape_types" VALUES(120,'callout3','LINE_CALLOUT_4_NO_BORDER','Line Callout 3 (No Border)','msoShapeLineCallout4NoBorder','Callout with no border and callout line segments forming a U-shape.');
INSERT INTO "auto_shape_types" VALUES(121,'accentBorderCallout1','LINE_CALLOUT_1_BORDER_AND_ACCENT_BAR','Line Callout 1 (Border and Accent Bar)','msoShapeLineCallout1BorderandAccentBar','Callout with border and vertical accent bar');
INSERT INTO "auto_shape_types" VALUES(122,'accentBorderCallout2','LINE_CALLOUT_2_BORDER_AND_ACCENT_BAR','Line Callout 2 (Border and Accent Bar)','msoShapeLineCallout2BorderandAccentBar','Callout with border, diagonal straight line, and accent bar');
INSERT INTO "auto_shape_types" VALUES(123,'accentBorderCallout3','LINE_CALLOUT_3_BORDER_AND_ACCENT_BAR','Line Callout 3 (Border and Accent Bar)','msoShapeLineCallout3BorderandAccentBar','Callout with border, angled callout line, and accent bar');
INSERT INTO "auto_shape_types" VALUES(124,'accentBorderCallout3','LINE_CALLOUT_4_BORDER_AND_ACCENT_BAR','Line Callout 3 (Border and Accent Bar)','msoShapeLineCallout4BorderandAccentBar','Callout with border, accent bar, and callout line segments forming a U-shape.');
INSERT INTO "auto_shape_types" VALUES(125,'actionButtonBlank','ACTION_BUTTON_CUSTOM','Action Button: Custom','msoShapeActionButtonCustom','Button with no default picture or text. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(126,'actionButtonHome','ACTION_BUTTON_HOME','Action Button: Home','msoShapeActionButtonHome','Home button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(127,'actionButtonHelp','ACTION_BUTTON_HELP','Action Button: Help','msoShapeActionButtonHelp','Help button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(128,'actionButtonInformation','ACTION_BUTTON_INFORMATION','Action Button: Information','msoShapeActionButtonInformation','Information button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(129,'actionButtonBackPrevious','ACTION_BUTTON_BACK_OR_PREVIOUS','Action Button: Back or Previous','msoShapeActionButtonBackorPrevious','Back or Previous button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(130,'actionButtonForwardNext','ACTION_BUTTON_FORWARD_OR_NEXT','Action Button: Forward or Next','msoShapeActionButtonForwardorNext','Forward or Next button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(131,'actionButtonBeginning','ACTION_BUTTON_BEGINNING','Action Button: Beginning','msoShapeActionButtonBeginning','Beginning button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(132,'actionButtonEnd','ACTION_BUTTON_END','Action Button: End','msoShapeActionButtonEnd','End button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(133,'actionButtonReturn','ACTION_BUTTON_RETURN','Action Button: Return','msoShapeActionButtonReturn','Return button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(134,'actionButtonDocument','ACTION_BUTTON_DOCUMENT','Action Button: Document','msoShapeActionButtonDocument','Document button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(135,'actionButtonSound','ACTION_BUTTON_SOUND','Action Button: Sound','msoShapeActionButtonSound','Sound button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(136,'actionButtonMovie','ACTION_BUTTON_MOVIE','Action Button: Movie','msoShapeActionButtonMovie','Movie button. Supports mouse-click and mouse-over actions');
INSERT INTO "auto_shape_types" VALUES(137,'wedgeRoundRectCallout','BALLOON','Rounded Rectangular Callout','msoShapeBalloon','Rounded Rectangular Callout');
INSERT INTO "auto_shape_types" VALUES(139,'flowChartOfflineStorage','FLOWCHART_OFFLINE_STORAGE','Offline Storage','msoShapeFlowchartOfflineStorage','Offline Storage');
INSERT INTO "auto_shape_types" VALUES(140,'leftRightRibbon','LEFT_RIGHT_RIBBON','Left Right Ribbon','msoShapeLeftRightRibbon','Left Right Ribbon');
INSERT INTO "auto_shape_types" VALUES(141,'diagStripe','DIAGONAL_STRIPE','Diagonal Stripe','msoShapeDiagonalStripe','Diagonal Stripe');
INSERT INTO "auto_shape_types" VALUES(142,'pie','PIE','Pie','msoShapePie','Pie');
INSERT INTO "auto_shape_types" VALUES(143,'nonIsoscelesTrapezoid','NON_ISOSCELES_TRAPEZOID','Non-isosceles Trapezoid','msoShapeNonIsoscelesTrapezoid','Non-isosceles Trapezoid');
INSERT INTO "auto_shape_types" VALUES(144,'decagon','DECAGON','Decagon','msoShapeDecagon','Decagon');
INSERT INTO "auto_shape_types" VALUES(145,'heptagon','HEPTAGON','Heptagon','msoShapeHeptagon','Heptagon');
INSERT INTO "auto_shape_types" VALUES(146,'dodecagon','DODECAGON','Dodecagon','msoShapeDodecagon','Dodecagon');
INSERT INTO "auto_shape_types" VALUES(147,'star6','STAR_6_POINT','6-Point Star','msoShape6PointStar','6-Point Star');
INSERT INTO "auto_shape_types" VALUES(148,'star7','STAR_7_POINT','7-Point Star','msoShape7PointStar','7-Point Star');
INSERT INTO "auto_shape_types" VALUES(149,'star10','STAR_10_POINT','10-Point Star','msoShape10PointStar','10-Point Star');
INSERT INTO "auto_shape_types" VALUES(150,'star12','STAR_12_POINT','12-Point Star','msoShape12PointStar','12-Point Star');
INSERT INTO "auto_shape_types" VALUES(151,'round1Rect','ROUND_1_RECTANGLE','Round Single Corner Rectangle','msoShapeRound1Rectangle','Round Single Corner Rectangle');
INSERT INTO "auto_shape_types" VALUES(152,'round2SameRect','ROUND_2_SAME_RECTANGLE','Round Same Side Corner Rectangle','msoShapeRound2SameRectangle','Round Same Side Corner Rectangle');
INSERT INTO "auto_shape_types" VALUES(153,'round2DiagRect','ROUND_2_DIAG_RECTANGLE','Round Diagonal Corner Rectangle','msoShapeRound2DiagRectangle','Round Diagonal Corner Rectangle');
INSERT INTO "auto_shape_types" VALUES(154,'snipRoundRect','SNIP_ROUND_RECTANGLE','Snip and Round Single Corner Rectangle','msoShapeSnipRoundRectangle','Snip and Round Single Corner Rectangle');
INSERT INTO "auto_shape_types" VALUES(155,'snip1Rect','SNIP_1_RECTANGLE','Snip Single Corner Rectangle','msoShapeSnip1Rectangle','Snip Single Corner Rectangle');
INSERT INTO "auto_shape_types" VALUES(156,'snip2SameRect','SNIP_2_SAME_RECTANGLE','Snip Same Side Corner Rectangle','msoShapeSnip2SameRectangle','Snip Same Side Corner Rectangle');
INSERT INTO "auto_shape_types" VALUES(157,'snip2DiagRect','SNIP_2_DIAG_RECTANGLE','Snip Diagonal Corner Rectangle','msoShapeSnip2DiagRectangle','Snip Diagonal Corner Rectangle');
INSERT INTO "auto_shape_types" VALUES(158,'frame','FRAME','Frame','msoShapeFrame','Frame');
INSERT INTO "auto_shape_types" VALUES(159,'halfFrame','HALF_FRAME','Half Frame','msoShapeHalfFrame','Half Frame');
INSERT INTO "auto_shape_types" VALUES(160,'teardrop','TEAR','Teardrop','msoShapeTear','Teardrop');
INSERT INTO "auto_shape_types" VALUES(161,'chord','CHORD','Chord','msoShapeChord','Geometric chord shape');
INSERT INTO "auto_shape_types" VALUES(162,'corner','CORNER','Corner','msoShapeCorner','Corner');
INSERT INTO "auto_shape_types" VALUES(163,'mathPlus','MATH_PLUS','Plus','msoShapeMathPlus','Plus');
INSERT INTO "auto_shape_types" VALUES(164,'mathMinus','MATH_MINUS','Minus','msoShapeMathMinus','Minus');
INSERT INTO "auto_shape_types" VALUES(165,'mathMultiply','MATH_MULTIPLY','Multiply','msoShapeMathMultiply','Multiply');
INSERT INTO "auto_shape_types" VALUES(166,'mathDivide','MATH_DIVIDE','Division','msoShapeMathDivide','Division');
INSERT INTO "auto_shape_types" VALUES(167,'mathEqual','MATH_EQUAL','Equal','msoShapeMathEqual','Equal');
INSERT INTO "auto_shape_types" VALUES(168,'mathNotEqual','MATH_NOT_EQUAL','Not Equal','msoShapeMathNotEqual','Not Equal');
INSERT INTO "auto_shape_types" VALUES(169,'cornerTabs','CORNER_TABS','Corner Tabs','msoShapeCornerTabs','Corner Tabs');
INSERT INTO "auto_shape_types" VALUES(170,'squareTabs','SQUARE_TABS','Square Tabs','msoShapeSquareTabs','Square Tabs');
INSERT INTO "auto_shape_types" VALUES(171,'plaqueTabs','PLAQUE_TABS','Plaque Tabs','msoShapePlaqueTabs','Plaque Tabs');
INSERT INTO "auto_shape_types" VALUES(172,'gear6','GEAR_6','Gear 6','msoShapeGear6','Gear 6');
INSERT INTO "auto_shape_types" VALUES(173,'gear9','GEAR_9','Gear 9','msoShapeGear9','Gear 9');
INSERT INTO "auto_shape_types" VALUES(174,'funnel','FUNNEL','Funnel','msoShapeFunnel','Funnel');
INSERT INTO "auto_shape_types" VALUES(175,'pieWedge','PIE_WEDGE','Pie','msoShapePieWedge','Pie');
INSERT INTO "auto_shape_types" VALUES(176,'leftCircularArrow','LEFT_CIRCULAR_ARROW','Left Circular Arrow','msoShapeLeftCircularArrow','Left Circular Arrow');
INSERT INTO "auto_shape_types" VALUES(177,'leftRightCircularArrow','LEFT_RIGHT_CIRCULAR_ARROW','Left Right Circular Arrow','msoShapeLeftRightCircularArrow','Left Right Circular Arrow');
INSERT INTO "auto_shape_types" VALUES(178,'swooshArrow','SWOOSH_ARROW','Swoosh Arrow','msoShapeSwooshArrow','Swoosh Arrow');
INSERT INTO "auto_shape_types" VALUES(179,'cloud','CLOUD','Cloud','msoShapeCloud','Cloud');
INSERT INTO "auto_shape_types" VALUES(180,'chartX','CHART_X','Chart X','msoShapeChartX','Chart X');
INSERT INTO "auto_shape_types" VALUES(181,'chartStar','CHART_STAR','Chart Star','msoShapeChartStar','Chart Star');
INSERT INTO "auto_shape_types" VALUES(182,'chartPlus','CHART_PLUS','Chart Plus','msoShapeChartPlus','Chart Plus');
INSERT INTO "auto_shape_types" VALUES(183,'lineInv','LINE_INVERSE','Straight Connector','msoShapeLineInverse','Straight Connector');
CREATE TABLE adjustment_values (
    prst     text,
    seq_nmbr integer,
    name     text,
    val      integer
);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout1',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout1',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout1',3,'adj3',112500);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout1',4,'adj4',-38333);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout2',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout2',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout2',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout2',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout2',5,'adj5',112500);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout2',6,'adj6',-46667);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',5,'adj5',100000);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',6,'adj6',-16667);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',7,'adj7',112963);
INSERT INTO "adjustment_values" VALUES('accentBorderCallout3',8,'adj8',-8333);
INSERT INTO "adjustment_values" VALUES('accentCallout1',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('accentCallout1',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('accentCallout1',3,'adj3',112500);
INSERT INTO "adjustment_values" VALUES('accentCallout1',4,'adj4',-38333);
INSERT INTO "adjustment_values" VALUES('accentCallout2',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('accentCallout2',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('accentCallout2',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('accentCallout2',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('accentCallout2',5,'adj5',112500);
INSERT INTO "adjustment_values" VALUES('accentCallout2',6,'adj6',-46667);
INSERT INTO "adjustment_values" VALUES('accentCallout3',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('accentCallout3',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('accentCallout3',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('accentCallout3',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('accentCallout3',5,'adj5',100000);
INSERT INTO "adjustment_values" VALUES('accentCallout3',6,'adj6',-16667);
INSERT INTO "adjustment_values" VALUES('accentCallout3',7,'adj7',112963);
INSERT INTO "adjustment_values" VALUES('accentCallout3',8,'adj8',-8333);
INSERT INTO "adjustment_values" VALUES('arc',1,'adj1',16200000);
INSERT INTO "adjustment_values" VALUES('arc',2,'adj2',0);
INSERT INTO "adjustment_values" VALUES('bentArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('bentArrow',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('bentArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('bentArrow',4,'adj4',43750);
INSERT INTO "adjustment_values" VALUES('bentConnector3',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('bentConnector4',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('bentConnector4',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('bentConnector5',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('bentConnector5',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('bentConnector5',3,'adj3',50000);
INSERT INTO "adjustment_values" VALUES('bentUpArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('bentUpArrow',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('bentUpArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('bevel',1,'adj',12500);
INSERT INTO "adjustment_values" VALUES('blockArc',1,'adj1',10800000);
INSERT INTO "adjustment_values" VALUES('blockArc',2,'adj2',0);
INSERT INTO "adjustment_values" VALUES('blockArc',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('borderCallout1',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('borderCallout1',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('borderCallout1',3,'adj3',112500);
INSERT INTO "adjustment_values" VALUES('borderCallout1',4,'adj4',-38333);
INSERT INTO "adjustment_values" VALUES('borderCallout2',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('borderCallout2',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('borderCallout2',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('borderCallout2',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('borderCallout2',5,'adj5',112500);
INSERT INTO "adjustment_values" VALUES('borderCallout2',6,'adj6',-46667);
INSERT INTO "adjustment_values" VALUES('borderCallout3',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('borderCallout3',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('borderCallout3',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('borderCallout3',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('borderCallout3',5,'adj5',100000);
INSERT INTO "adjustment_values" VALUES('borderCallout3',6,'adj6',-16667);
INSERT INTO "adjustment_values" VALUES('borderCallout3',7,'adj7',112963);
INSERT INTO "adjustment_values" VALUES('borderCallout3',8,'adj8',-8333);
INSERT INTO "adjustment_values" VALUES('bracePair',1,'adj',8333);
INSERT INTO "adjustment_values" VALUES('bracketPair',1,'adj',16667);
INSERT INTO "adjustment_values" VALUES('callout1',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('callout1',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('callout1',3,'adj3',112500);
INSERT INTO "adjustment_values" VALUES('callout1',4,'adj4',-38333);
INSERT INTO "adjustment_values" VALUES('callout2',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('callout2',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('callout2',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('callout2',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('callout2',5,'adj5',112500);
INSERT INTO "adjustment_values" VALUES('callout2',6,'adj6',-46667);
INSERT INTO "adjustment_values" VALUES('callout3',1,'adj1',18750);
INSERT INTO "adjustment_values" VALUES('callout3',2,'adj2',-8333);
INSERT INTO "adjustment_values" VALUES('callout3',3,'adj3',18750);
INSERT INTO "adjustment_values" VALUES('callout3',4,'adj4',-16667);
INSERT INTO "adjustment_values" VALUES('callout3',5,'adj5',100000);
INSERT INTO "adjustment_values" VALUES('callout3',6,'adj6',-16667);
INSERT INTO "adjustment_values" VALUES('callout3',7,'adj7',112963);
INSERT INTO "adjustment_values" VALUES('callout3',8,'adj8',-8333);
INSERT INTO "adjustment_values" VALUES('can',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('chevron',1,'adj',50000);
INSERT INTO "adjustment_values" VALUES('chord',1,'adj1',2700000);
INSERT INTO "adjustment_values" VALUES('chord',2,'adj2',16200000);
INSERT INTO "adjustment_values" VALUES('circularArrow',1,'adj1',12500);
INSERT INTO "adjustment_values" VALUES('circularArrow',2,'adj2',1142319);
INSERT INTO "adjustment_values" VALUES('circularArrow',3,'adj3',20457681);
INSERT INTO "adjustment_values" VALUES('circularArrow',4,'adj4',10800000);
INSERT INTO "adjustment_values" VALUES('circularArrow',5,'adj5',12500);
INSERT INTO "adjustment_values" VALUES('cloudCallout',1,'adj1',-20833);
INSERT INTO "adjustment_values" VALUES('cloudCallout',2,'adj2',62500);
INSERT INTO "adjustment_values" VALUES('corner',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('corner',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('cube',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('curvedConnector3',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('curvedConnector4',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('curvedConnector4',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('curvedConnector5',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('curvedConnector5',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('curvedConnector5',3,'adj3',50000);
INSERT INTO "adjustment_values" VALUES('curvedDownArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('curvedDownArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('curvedDownArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('curvedLeftArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('curvedLeftArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('curvedLeftArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('curvedRightArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('curvedRightArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('curvedRightArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('curvedUpArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('curvedUpArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('curvedUpArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('decagon',1,'vf',105146);
INSERT INTO "adjustment_values" VALUES('diagStripe',1,'adj',50000);
INSERT INTO "adjustment_values" VALUES('donut',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('doubleWave',1,'adj1',6250);
INSERT INTO "adjustment_values" VALUES('doubleWave',2,'adj2',0);
INSERT INTO "adjustment_values" VALUES('downArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('downArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('downArrowCallout',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('downArrowCallout',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('downArrowCallout',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('downArrowCallout',4,'adj4',64977);
INSERT INTO "adjustment_values" VALUES('ellipseRibbon',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('ellipseRibbon',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('ellipseRibbon',3,'adj3',12500);
INSERT INTO "adjustment_values" VALUES('ellipseRibbon2',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('ellipseRibbon2',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('ellipseRibbon2',3,'adj3',12500);
INSERT INTO "adjustment_values" VALUES('foldedCorner',1,'adj',16667);
INSERT INTO "adjustment_values" VALUES('frame',1,'adj1',12500);
INSERT INTO "adjustment_values" VALUES('gear6',1,'adj1',15000);
INSERT INTO "adjustment_values" VALUES('gear6',2,'adj2',3526);
INSERT INTO "adjustment_values" VALUES('gear9',1,'adj1',10000);
INSERT INTO "adjustment_values" VALUES('gear9',2,'adj2',1763);
INSERT INTO "adjustment_values" VALUES('halfFrame',1,'adj1',33333);
INSERT INTO "adjustment_values" VALUES('halfFrame',2,'adj2',33333);
INSERT INTO "adjustment_values" VALUES('heptagon',1,'hf',102572);
INSERT INTO "adjustment_values" VALUES('heptagon',2,'vf',105210);
INSERT INTO "adjustment_values" VALUES('hexagon',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('hexagon',2,'vf',115470);
INSERT INTO "adjustment_values" VALUES('homePlate',1,'adj',50000);
INSERT INTO "adjustment_values" VALUES('horizontalScroll',1,'adj',12500);
INSERT INTO "adjustment_values" VALUES('leftArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('leftArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('leftArrowCallout',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('leftArrowCallout',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('leftArrowCallout',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('leftArrowCallout',4,'adj4',64977);
INSERT INTO "adjustment_values" VALUES('leftBrace',1,'adj1',8333);
INSERT INTO "adjustment_values" VALUES('leftBrace',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('leftBracket',1,'adj',8333);
INSERT INTO "adjustment_values" VALUES('leftCircularArrow',1,'adj1',12500);
INSERT INTO "adjustment_values" VALUES('leftCircularArrow',2,'adj2',-1142319);
INSERT INTO "adjustment_values" VALUES('leftCircularArrow',3,'adj3',1142319);
INSERT INTO "adjustment_values" VALUES('leftCircularArrow',4,'adj4',10800000);
INSERT INTO "adjustment_values" VALUES('leftCircularArrow',5,'adj5',12500);
INSERT INTO "adjustment_values" VALUES('leftRightArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('leftRightArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('leftRightArrowCallout',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('leftRightArrowCallout',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('leftRightArrowCallout',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('leftRightArrowCallout',4,'adj4',48123);
INSERT INTO "adjustment_values" VALUES('leftRightCircularArrow',1,'adj1',12500);
INSERT INTO "adjustment_values" VALUES('leftRightCircularArrow',2,'adj2',1142319);
INSERT INTO "adjustment_values" VALUES('leftRightCircularArrow',3,'adj3',20457681);
INSERT INTO "adjustment_values" VALUES('leftRightCircularArrow',4,'adj4',11942319);
INSERT INTO "adjustment_values" VALUES('leftRightCircularArrow',5,'adj5',12500);
INSERT INTO "adjustment_values" VALUES('leftRightRibbon',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('leftRightRibbon',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('leftRightRibbon',3,'adj3',16667);
INSERT INTO "adjustment_values" VALUES('leftRightUpArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('leftRightUpArrow',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('leftRightUpArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('leftUpArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('leftUpArrow',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('leftUpArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('mathDivide',1,'adj1',23520);
INSERT INTO "adjustment_values" VALUES('mathDivide',2,'adj2',5880);
INSERT INTO "adjustment_values" VALUES('mathDivide',3,'adj3',11760);
INSERT INTO "adjustment_values" VALUES('mathEqual',1,'adj1',23520);
INSERT INTO "adjustment_values" VALUES('mathEqual',2,'adj2',11760);
INSERT INTO "adjustment_values" VALUES('mathMinus',1,'adj1',23520);
INSERT INTO "adjustment_values" VALUES('mathMultiply',1,'adj1',23520);
INSERT INTO "adjustment_values" VALUES('mathNotEqual',1,'adj1',23520);
INSERT INTO "adjustment_values" VALUES('mathNotEqual',2,'adj2',6600000);
INSERT INTO "adjustment_values" VALUES('mathNotEqual',3,'adj3',11760);
INSERT INTO "adjustment_values" VALUES('mathPlus',1,'adj1',23520);
INSERT INTO "adjustment_values" VALUES('moon',1,'adj',50000);
INSERT INTO "adjustment_values" VALUES('nonIsoscelesTrapezoid',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('nonIsoscelesTrapezoid',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('noSmoking',1,'adj',18750);
INSERT INTO "adjustment_values" VALUES('notchedRightArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('notchedRightArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('octagon',1,'adj',29289);
INSERT INTO "adjustment_values" VALUES('parallelogram',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('pentagon',1,'hf',105146);
INSERT INTO "adjustment_values" VALUES('pentagon',2,'vf',110557);
INSERT INTO "adjustment_values" VALUES('pie',1,'adj1',0);
INSERT INTO "adjustment_values" VALUES('pie',2,'adj2',16200000);
INSERT INTO "adjustment_values" VALUES('plaque',1,'adj',16667);
INSERT INTO "adjustment_values" VALUES('plus',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('quadArrow',1,'adj1',22500);
INSERT INTO "adjustment_values" VALUES('quadArrow',2,'adj2',22500);
INSERT INTO "adjustment_values" VALUES('quadArrow',3,'adj3',22500);
INSERT INTO "adjustment_values" VALUES('quadArrowCallout',1,'adj1',18515);
INSERT INTO "adjustment_values" VALUES('quadArrowCallout',2,'adj2',18515);
INSERT INTO "adjustment_values" VALUES('quadArrowCallout',3,'adj3',18515);
INSERT INTO "adjustment_values" VALUES('quadArrowCallout',4,'adj4',48123);
INSERT INTO "adjustment_values" VALUES('ribbon',1,'adj1',16667);
INSERT INTO "adjustment_values" VALUES('ribbon',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('ribbon2',1,'adj1',16667);
INSERT INTO "adjustment_values" VALUES('ribbon2',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('rightArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('rightArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('rightArrowCallout',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('rightArrowCallout',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('rightArrowCallout',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('rightArrowCallout',4,'adj4',64977);
INSERT INTO "adjustment_values" VALUES('rightBrace',1,'adj1',8333);
INSERT INTO "adjustment_values" VALUES('rightBrace',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('rightBracket',1,'adj',8333);
INSERT INTO "adjustment_values" VALUES('round1Rect',1,'adj',16667);
INSERT INTO "adjustment_values" VALUES('round2DiagRect',1,'adj1',16667);
INSERT INTO "adjustment_values" VALUES('round2DiagRect',2,'adj2',0);
INSERT INTO "adjustment_values" VALUES('round2SameRect',1,'adj1',16667);
INSERT INTO "adjustment_values" VALUES('round2SameRect',2,'adj2',0);
INSERT INTO "adjustment_values" VALUES('roundRect',1,'adj',16667);
INSERT INTO "adjustment_values" VALUES('smileyFace',1,'adj',4653);
INSERT INTO "adjustment_values" VALUES('snip1Rect',1,'adj',16667);
INSERT INTO "adjustment_values" VALUES('snip2DiagRect',1,'adj1',0);
INSERT INTO "adjustment_values" VALUES('snip2DiagRect',2,'adj2',16667);
INSERT INTO "adjustment_values" VALUES('snip2SameRect',1,'adj1',16667);
INSERT INTO "adjustment_values" VALUES('snip2SameRect',2,'adj2',0);
INSERT INTO "adjustment_values" VALUES('snipRoundRect',1,'adj1',16667);
INSERT INTO "adjustment_values" VALUES('snipRoundRect',2,'adj2',16667);
INSERT INTO "adjustment_values" VALUES('star10',1,'adj',42533);
INSERT INTO "adjustment_values" VALUES('star10',2,'hf',105146);
INSERT INTO "adjustment_values" VALUES('star12',1,'adj',37500);
INSERT INTO "adjustment_values" VALUES('star16',1,'adj',37500);
INSERT INTO "adjustment_values" VALUES('star24',1,'adj',37500);
INSERT INTO "adjustment_values" VALUES('star32',1,'adj',37500);
INSERT INTO "adjustment_values" VALUES('star4',1,'adj',12500);
INSERT INTO "adjustment_values" VALUES('star5',1,'adj',19098);
INSERT INTO "adjustment_values" VALUES('star5',2,'hf',105146);
INSERT INTO "adjustment_values" VALUES('star5',3,'vf',110557);
INSERT INTO "adjustment_values" VALUES('star6',1,'adj',28868);
INSERT INTO "adjustment_values" VALUES('star6',2,'hf',115470);
INSERT INTO "adjustment_values" VALUES('star7',1,'adj',34601);
INSERT INTO "adjustment_values" VALUES('star7',2,'hf',102572);
INSERT INTO "adjustment_values" VALUES('star7',3,'vf',105210);
INSERT INTO "adjustment_values" VALUES('star8',1,'adj',37500);
INSERT INTO "adjustment_values" VALUES('stripedRightArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('stripedRightArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('sun',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('swooshArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('swooshArrow',2,'adj2',16667);
INSERT INTO "adjustment_values" VALUES('teardrop',1,'adj',100000);
INSERT INTO "adjustment_values" VALUES('trapezoid',1,'adj',25000);
INSERT INTO "adjustment_values" VALUES('triangle',1,'adj',50000);
INSERT INTO "adjustment_values" VALUES('upArrowCallout',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('upArrowCallout',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('upArrowCallout',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('upArrowCallout',4,'adj4',64977);
INSERT INTO "adjustment_values" VALUES('upDownArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('upDownArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('upDownArrow',1,'adj1',50000);
INSERT INTO "adjustment_values" VALUES('upDownArrow',2,'adj2',50000);
INSERT INTO "adjustment_values" VALUES('upDownArrowCallout',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('upDownArrowCallout',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('upDownArrowCallout',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('upDownArrowCallout',4,'adj4',48123);
INSERT INTO "adjustment_values" VALUES('uturnArrow',1,'adj1',25000);
INSERT INTO "adjustment_values" VALUES('uturnArrow',2,'adj2',25000);
INSERT INTO "adjustment_values" VALUES('uturnArrow',3,'adj3',25000);
INSERT INTO "adjustment_values" VALUES('uturnArrow',4,'adj4',43750);
INSERT INTO "adjustment_values" VALUES('uturnArrow',5,'adj5',75000);
INSERT INTO "adjustment_values" VALUES('verticalScroll',1,'adj',12500);
INSERT INTO "adjustment_values" VALUES('wave',1,'adj1',12500);
INSERT INTO "adjustment_values" VALUES('wave',2,'adj2',0);
INSERT INTO "adjustment_values" VALUES('wedgeEllipseCallout',1,'adj1',-20833);
INSERT INTO "adjustment_values" VALUES('wedgeEllipseCallout',2,'adj2',62500);
INSERT INTO "adjustment_values" VALUES('wedgeRectCallout',1,'adj1',-20833);
INSERT INTO "adjustment_values" VALUES('wedgeRectCallout',2,'adj2',62500);
INSERT INTO "adjustment_values" VALUES('wedgeRoundRectCallout',1,'adj1',-20833);
INSERT INTO "adjustment_values" VALUES('wedgeRoundRectCallout',2,'adj2',62500);
INSERT INTO "adjustment_values" VALUES('wedgeRoundRectCallout',3,'adj3',16667);
COMMIT;
