"""A database with no persistent backend
"""

import db_base

class nodb(db_base.db_base):
    """A database interface with no persistent backend

    This object conforms to the database interface defined in db_base, but
    does not have a persistent store. The purpose is mainly for testing.
    """

    def __init__(self):
        self.cache = {}
        self.new_oid = 0
        self.new_tid = 0

    def table_exists(self, cls):
        """Return True if the table for class cls exists"""
        return False

    def create_table(self, cls):
        """Create a table for class cls"""
        self.new_tid += 1
        self.cache[self.new_tid] = {}
        cls.tid = self.new_tid
        
    
    def commit(self, instance):
        """Add to the cache if instance.oid is None"""
        if instance.oid is None:
            self.new_oid += 1
            instance.oid = self.new_oid
            self.cache[instance.__class__.tid][instance.oid] = instance
        

    def query_generator(self, cls, relation):
        """Evaluate the relation for all objects in the cache.

        Yields instances in the cache that satisfy the relation
        """
        # write a list comprehension using the python representation of the
        # relation
        expr = '[_x for _x in self.cache[cls.tid].values() if %s]' % relation.py_repr()
        for i in eval(expr):
            yield i
            
    def clear_cache(self):
        """Don't do it"""
        pass

    def empty_table(self, table_name):
        """Don't do it"""
        pass
    
            
