Hacking intervaltree
====================

This is a developer's guide to modifying and maintaining `intervaltree`.

## Dependencies

* On a Mac, you will need [`brew`][brew].

* On Linux, you will need `apt-get`.

On all systems, Python 2.6, 2.7, 3.2, 3.3 and 3.4 are needed to run the complete test suite. 

### Single version of Python

If you don't have all the above versions of Python, these `make` features will be unavailable to you:

* `make` and `make test`
* `make pytest`
* `make upload` and `make release upload`
     

## Project structure

### `intervaltree`

The `intervaltree` directory has three main files:

* `intervaltree.py`
* `interval.py`
* `node.py`

`intervaltree.py` and `interval.py` contain the public API to `IntervalTree` and `Interval`. `node.py` contains the internal logic of the tree. For the theory of how this type of tree works, read the following:

* Wikipedia's [Interval tree][Wiki intervaltree] article
* Eternally Confuzzled's tutorial on [AVL balancing][Confuzzled AVL tree]
* Tyler Kahn's simpler, immutable [interval tree implementation][Kahn intervaltree] in Python
 
### `test`

All files ending with `_test.py` are detected and run whenever you run `make` or `make quicktest`. In those files, only functions beginning with `test_` are executed.

#### `test/data`
Some tests depend on having certain lists of `Interval`s. These are stored in the modules of `test/data`. Most of these modules only contain a `data` attribute, which is a list of tuples that is converted to a list of `Interval`s by `test/intervals.py`. You can access them by importing the dict of lists of `Interval`s `test.intervals.ivs`.

Other tests (like `test/issue25_test.py`) depend on having pre-constructed `IntervalTree`s. These are constructed by `test/intervaltrees.py` and can be accessed by importing `test.intervaltrees.trees`. This is a dict of callables that return `IntervalTree`s. 

### `scripts`

Contains `testall.sh`, which runs all tests on all supported versions of Python.

### Dependency folders

* `pyandoc` and `pandoc` give the ability to convert README.md into rst format for PyPI.
* `docutils` and `bin` are created if `pip` could not install them system-wide without permissions. These are used to check the syntax of the converted rst README.
* `*.egg` are created by `PyTest` to fulfill testing dependencies
* `intervaltree.egg-info` is package metadata generated by `setup.py`.

### Other documentation files

* `HACKING.md` is this file.
* `README.md` contains public API documentation and credits.
* `README.rst` is generated from `README.md`.
* `CHANGELOG.md`
* `LICENSE.txt`

### Other code files

* `Makefile` contains convenience routines for managing and testing the project. It installs certain dependencies that are too inconvenient to install on [travis-ci.org][], and gives an easy way to call `test/testall.sh`.
* `setup.py` runs the tests in a single version of Python. Also, packages the project for PyPI.
* `setup.cfg` configures `setup.py`. If you want to permanently skip a folder in testing, do it here.


## Testing

### Code

To run the tests in the `test` directory, run

    make test

or simply

    make

The two commands above run all the available tests on all versions of Python supported. You should run `make` first, because it will also detect missing dependencies and install them.

The first time you run `make`, you may be asked for your password. This is in order to install `pandoc`, a tool used for processing the README file.

Running all tests requires that you have all the supported versions of Python installed. These are 2.6, 2.7, 3.2, 3.3, and 3.4. Try to use your packaga manager to install them if possible. Otherwise, go to [python.org/downloads][] and install them manually.

#### Single version of Python

Run

    make quicktest

### README

To test changes to the README and make sure that they are compatible with PyPI's very restrictive rules, run

    make rst

`make rst` is also run by `make test`, but `make test` takes longer.


## Cleaning

To clean up the project directory, run 
    
    make distclean
    
That should remove all the locally-installed dependencies and clear out all the temporary files.

To keep the dependencies, but clean everything else, run

    make clean


## Maintainers: Working with PyPI

### README

To update the README on PyPI, run

    make register

This will test the README's syntax stricly and push it up to the PyPI test server.
 
If you are satisfied with the results, run

    make release register

to do it for real on the production PyPI server.

### Publishing

To publish a new version to PyPI, run

    make upload

This will run `make test`, zip up the source distribution and push it to the PyPI test server.

If this looks like it went well, run

    make release upload

to push the distribution to the production PyPI server.


[brew]: http://brew.sh/
[python.org/downloads]: http://www.python.org/downloads
[travis-ci.org]: https://travis-ci.org/
[Confuzzled AVL tree]: http://www.eternallyconfuzzled.com/tuts/datastructures/jsw_tut_avl.aspx
[Wiki intervaltree]: http://en.wikipedia.org/wiki/Interval_tree
[Kahn intervaltree]: http://zurb.com/forrst/posts/Interval_Tree_implementation_in_python-e0K
