<?php
/**
 * Copyright 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
# Generated by the protocol buffer compiler. DO NOT EDIT!
# source: google/appengine/api/source.proto

namespace dummy {
  require_once 'google/appengine/runtime/proto/ProtocolMessage.php';
}
namespace google\appengine {
  class SourceLocation extends \google\net\ProtocolMessage {
    public function getFile() {
      if (!isset($this->file)) {
        return '';
      }
      return $this->file;
    }
    public function setFile($val) {
      $this->file = $val;
      return $this;
    }
    public function clearFile() {
      unset($this->file);
      return $this;
    }
    public function hasFile() {
      return isset($this->file);
    }
    public function getLine() {
      if (!isset($this->line)) {
        return "0";
      }
      return $this->line;
    }
    public function setLine($val) {
      if (is_double($val)) {
        $this->line = sprintf('%0.0F', $val);
      } else {
        $this->line = $val;
      }
      return $this;
    }
    public function clearLine() {
      unset($this->line);
      return $this;
    }
    public function hasLine() {
      return isset($this->line);
    }
    public function getFunctionName() {
      if (!isset($this->function_name)) {
        return '';
      }
      return $this->function_name;
    }
    public function setFunctionName($val) {
      $this->function_name = $val;
      return $this;
    }
    public function clearFunctionName() {
      unset($this->function_name);
      return $this;
    }
    public function hasFunctionName() {
      return isset($this->function_name);
    }
    public function clear() {
      $this->clearFile();
      $this->clearLine();
      $this->clearFunctionName();
    }
    public function byteSizePartial() {
      $res = 0;
      if (isset($this->file)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->file));
      }
      if (isset($this->line)) {
        $res += 1;
        $res += $this->lengthVarInt64($this->line);
      }
      if (isset($this->function_name)) {
        $res += 1;
        $res += $this->lengthString(strlen($this->function_name));
      }
      return $res;
    }
    public function outputPartial($out) {
      if (isset($this->file)) {
        $out->putVarInt32(10);
        $out->putPrefixedString($this->file);
      }
      if (isset($this->line)) {
        $out->putVarInt32(16);
        $out->putVarInt64($this->line);
      }
      if (isset($this->function_name)) {
        $out->putVarInt32(26);
        $out->putPrefixedString($this->function_name);
      }
    }
    public function tryMerge($d) {
      while($d->avail() > 0) {
        $tt = $d->getVarInt32();
        switch ($tt) {
          case 10:
            $length = $d->getVarInt32();
            $this->setFile(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 16:
            $this->setLine($d->getVarInt64());
            break;
          case 26:
            $length = $d->getVarInt32();
            $this->setFunctionName(substr($d->buffer(), $d->pos(), $length));
            $d->skip($length);
            break;
          case 0:
            throw new \google\net\ProtocolBufferDecodeError();
            break;
          default:
            $d->skipData($tt);
        }
      };
    }
    public function checkInitialized() {
      return null;
    }
    public function mergeFrom($x) {
      if ($x === $this) { throw new \IllegalArgumentException('Cannot copy message to itself'); }
      if ($x->hasFile()) {
        $this->setFile($x->getFile());
      }
      if ($x->hasLine()) {
        $this->setLine($x->getLine());
      }
      if ($x->hasFunctionName()) {
        $this->setFunctionName($x->getFunctionName());
      }
    }
    public function equals($x) {
      if ($x === $this) { return true; }
      if (isset($this->file) !== isset($x->file)) return false;
      if (isset($this->file) && $this->file !== $x->file) return false;
      if (isset($this->line) !== isset($x->line)) return false;
      if (isset($this->line) && !$this->integerEquals($this->line, $x->line)) return false;
      if (isset($this->function_name) !== isset($x->function_name)) return false;
      if (isset($this->function_name) && $this->function_name !== $x->function_name) return false;
      return true;
    }
    public function shortDebugString($prefix = "") {
      $res = '';
      if (isset($this->file)) {
        $res .= $prefix . "file: " . $this->debugFormatString($this->file) . "\n";
      }
      if (isset($this->line)) {
        $res .= $prefix . "line: " . $this->debugFormatInt64($this->line) . "\n";
      }
      if (isset($this->function_name)) {
        $res .= $prefix . "function_name: " . $this->debugFormatString($this->function_name) . "\n";
      }
      return $res;
    }
  }
}
