/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"]);
})(this, function(Bokeh) {
  var define;
  return (function(modules, entry, aliases, externals) {
    if (Bokeh != null) {
      return Bokeh.register_plugin(modules, entry, aliases, externals);
    } else {
      throw new Error("Cannot find Bokeh. You have to load it prior to loading plugins.");
    }
  })
({
462: function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0}),e(463)},
463: function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var _=e(1);
/*
    Copyright notice: many of the awesome techniques and  GLSL code contained in
    this module are based on work by Nicolas Rougier as part of the Glumpy and
    Vispy projects. The algorithms are published in
    http://jcgt.org/published/0003/04/01/ and http://jcgt.org/published/0002/02/08/
    
    This module contains all gl-specific code to add gl support for the glyphs.
    By implementing it separetely, the GL functionality can be spun off in a
    separate library.
    Other locations where we work with GL, or prepare for GL-rendering:
    - canvas.ts
    - plot.ts
    - glyph.ts
    - glyph_renderer.ts
    */_.__exportStar(e(464),t),_.__exportStar(e(469),t)},
464: function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var i=t(1),a=t(465),r=t(466),n=t(467),o=t(468),_=t(126),h=function(){function t(t){this._atlas={},this._index=0,this._width=256,this._height=256,this.tex=new a.Texture2D(t),this.tex.set_wrapping(t.REPEAT,t.REPEAT),this.tex.set_interpolation(t.NEAREST,t.NEAREST),this.tex.set_size([this._height,this._width],t.RGBA),this.tex.set_data([0,0],[this._height,this._width],new Uint8Array(this._height*this._width*4)),this.get_atlas_data([1])}return t.prototype.get_atlas_data=function(t){var e=t.join("-");if(void 0===this._atlas[e]){var s=this.make_pattern(t),i=s[0],a=s[1];this.tex.set_data([this._index,0],[1,this._width],new Uint8Array(i.map((function(t){return t+10})))),this._atlas[e]=[this._index/this._height,a],this._index+=1}return this._atlas[e]},t.prototype.make_pattern=function(t){t.length>1&&t.length%2&&(t=t.concat(t));for(var e=0,s=0,i=t;s<i.length;s++){e+=i[s]}for(var a=[],r=0,n=0,o=t.length+2;n<o;n+=2){var _=Math.max(1e-4,t[n%t.length]),h=Math.max(1e-4,t[(n+1)%t.length]);a.push(r,r+_),r+=_+h}var l=this._width,g=new Float32Array(4*l);for(n=0,o=l;n<o;n++){for(var u=void 0,f=void 0,v=void 0,p=e*n/(l-1),d=0,c=1e16,b=0,y=a.length;b<y;b++){var x=Math.abs(a[b]-p);x<c&&(d=b,c=x)}d%2==0?(v=p<=a[d]?1:0,f=a[d],u=a[d+1]):(v=p>a[d]?-1:0,f=a[d-1],u=a[d]),g[4*n+0]=a[d],g[4*n+1]=v,g[4*n+2]=f,g[4*n+3]=u}return[g,e]},t}();h.__name__="DashAtlas";var l={miter:0,round:1,bevel:2},g={"":0,none:0,".":0,round:1,")":1,"(":1,o:1,"triangle in":2,"<":2,"triangle out":3,">":3,square:4,"[":4,"]":4,"=":4,butt:5,"|":5},u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.init=function(){var t=this.gl;this._scale_aspect=0;var e=n.vertex_shader,s=o.fragment_shader;this.prog=new a.Program(t),this.prog.set_shaders(e,s),this.index_buffer=new a.IndexBuffer(t),this.vbo_position=new a.VertexBuffer(t),this.vbo_tangents=new a.VertexBuffer(t),this.vbo_segment=new a.VertexBuffer(t),this.vbo_angles=new a.VertexBuffer(t),this.vbo_texcoord=new a.VertexBuffer(t),this.dash_atlas=new h(t)},e.prototype.draw=function(t,e,s){var i=e.glglyph;if(i.data_changed){if(!isFinite(s.dx)||!isFinite(s.dy))return;i._baked_offset=[s.dx,s.dy],i._set_data(),i.data_changed=!1}this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1);var a=s.sx,r=s.sy,n=Math.sqrt(a*a+r*r);a/=n,r/=n,Math.abs(this._scale_aspect-r/a)>Math.abs(.001*this._scale_aspect)&&(i._update_scale(a,r),this._scale_aspect=r/a),this.prog.set_attribute("a_position","vec2",i.vbo_position),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents),this.prog.set_attribute("a_segment","vec2",i.vbo_segment),this.prog.set_attribute("a_angles","vec2",i.vbo_angles),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord),this.prog.set_uniform("u_length","float",[i.cumsum]),this.prog.set_texture("u_dash_atlas",this.dash_atlas.tex);var o=i._baked_offset;if(this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_uniform("u_offset","vec2",[s.dx-o[0],s.dy-o[1]]),this.prog.set_uniform("u_scale_aspect","vec2",[a,r]),this.prog.set_uniform("u_scale_length","float",[n]),this.I_triangles=i.I_triangles,this.I_triangles.length<65535)this.index_buffer.set_size(2*this.I_triangles.length),this.index_buffer.set_data(0,new Uint16Array(this.I_triangles)),this.prog.draw(this.gl.TRIANGLES,this.index_buffer);else{t=Array.from(this.I_triangles);for(var _=this.I_triangles.length,h=[],l=0,g=Math.ceil(_/64008);l<g;l++)h.push([]);for(l=0,g=t.length;l<g;l++){var u=t[l]%64008;h[f=Math.floor(t[l]/64008)].push(u)}var f=0;for(g=h.length;f<g;f++){var v=new Uint16Array(h[f]),p=64008*f*4;0!==v.length&&(this.prog.set_attribute("a_position","vec2",i.vbo_position,0,2*p),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents,0,4*p),this.prog.set_attribute("a_segment","vec2",i.vbo_segment,0,2*p),this.prog.set_attribute("a_angles","vec2",i.vbo_angles,0,2*p),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord,0,2*p),this.index_buffer.set_size(2*v.length),this.index_buffer.set_data(0,v),this.prog.draw(this.gl.TRIANGLES,this.index_buffer))}}},e.prototype._set_data=function(){this._bake(),this.vbo_position.set_size(4*this.V_position.length),this.vbo_position.set_data(0,this.V_position),this.vbo_tangents.set_size(4*this.V_tangents.length),this.vbo_tangents.set_data(0,this.V_tangents),this.vbo_angles.set_size(4*this.V_angles.length),this.vbo_angles.set_data(0,this.V_angles),this.vbo_texcoord.set_size(4*this.V_texcoord.length),this.vbo_texcoord.set_data(0,this.V_texcoord)},e.prototype._set_visuals=function(){var t,e=_.color2rgba(this.glyph.visuals.line.line_color.value(),this.glyph.visuals.line.line_alpha.value()),s=g[this.glyph.visuals.line.line_cap.value()],i=l[this.glyph.visuals.line.line_join.value()];this.prog.set_uniform("u_color","vec4",e),this.prog.set_uniform("u_linewidth","float",[this.glyph.visuals.line.line_width.value()]),this.prog.set_uniform("u_antialias","float",[.9]),this.prog.set_uniform("u_linecaps","vec2",[s,s]),this.prog.set_uniform("u_linejoin","float",[i]),this.prog.set_uniform("u_miter_limit","float",[10]);var a=this.glyph.visuals.line.line_dash.value(),r=0,n=1;a.length&&(r=(t=this.dash_atlas.get_atlas_data(a))[0],n=t[1]),this.prog.set_uniform("u_dash_index","float",[r]),this.prog.set_uniform("u_dash_phase","float",[this.glyph.visuals.line.line_dash_offset.value()]),this.prog.set_uniform("u_dash_period","float",[n]),this.prog.set_uniform("u_dash_caps","vec2",[s,s]),this.prog.set_uniform("u_closed","float",[0])},e.prototype._bake=function(){for(var t,e,s,i,a,r,n,o,_=this.nvertices,h=new Float64Array(this.glyph._x),l=new Float64Array(this.glyph._y),g=n=new Float32Array(2*_),u=new Float32Array(2*_),f=o=new Float32Array(4*_),v=0,p=_;v<p;v++)g[2*v+0]=h[v]+this._baked_offset[0],g[2*v+1]=l[v]+this._baked_offset[1];this.tangents=e=new Float32Array(2*_-2);for(v=0,p=_-1;v<p;v++)e[2*v+0]=n[2*(v+1)+0]-n[2*v+0],e[2*v+1]=n[2*(v+1)+1]-n[2*v+1];for(v=0,p=_-1;v<p;v++)f[4*(v+1)+0]=e[2*v+0],f[4*(v+1)+1]=e[2*v+1],f[4*v+2]=e[2*v+0],f[4*v+3]=e[2*v+1];f[0]=e[0],f[1]=e[1],f[4*(_-1)+2]=e[2*(_-2)+0],f[4*(_-1)+3]=e[2*(_-2)+1];var d=new Float32Array(_);for(v=0,p=_;v<p;v++)d[v]=Math.atan2(o[4*v+0]*o[4*v+3]-o[4*v+1]*o[4*v+2],o[4*v+0]*o[4*v+2]+o[4*v+1]*o[4*v+3]);for(v=0,p=_-1;v<p;v++)u[2*v+0]=d[v],u[2*v+1]=d[v+1];var c=4*_-4;this.V_position=i=new Float32Array(2*c),this.V_angles=s=new Float32Array(2*c),this.V_tangents=a=new Float32Array(4*c),this.V_texcoord=r=new Float32Array(2*c);for(v=0,p=_;v<p;v++)for(var b=0;b<4;b++){for(var y=0;y<2;y++)i[2*(4*v+b-2)+y]=g[2*v+y],s[2*(4*v+b)+y]=u[2*v+y];for(y=0;y<4;y++)a[4*(4*v+b-2)+y]=f[4*v+y]}for(v=0,p=_;v<p;v++)r[2*(4*v+0)+0]=-1,r[2*(4*v+1)+0]=-1,r[2*(4*v+2)+0]=1,r[2*(4*v+3)+0]=1,r[2*(4*v+0)+1]=-1,r[2*(4*v+1)+1]=1,r[2*(4*v+2)+1]=-1,r[2*(4*v+3)+1]=1;var x=6*(_-1);this.I_triangles=t=new Uint32Array(x);for(v=0,p=_;v<p;v++)t[6*v+0]=0+4*v,t[6*v+1]=1+4*v,t[6*v+2]=3+4*v,t[6*v+3]=2+4*v,t[6*v+4]=0+4*v,t[6*v+5]=3+4*v},e.prototype._update_scale=function(t,e){var s,i=this.nvertices,a=4*i-4,r=this.tangents,n=new Float32Array(i-1),o=new Float32Array(2*i);this.V_segment=s=new Float32Array(2*a);for(var _=0,h=i-1;_<h;_++)n[_]=Math.sqrt(Math.pow(r[2*_+0]*t,2)+Math.pow(r[2*_+1]*e,2));var l=0;for(_=0,h=i-1;_<h;_++)l+=n[_],o[2*(_+1)+0]=l,o[2*_+1]=l;for(_=0,h=i;_<h;_++)for(var g=0;g<4;g++)for(var u=0;u<2;u++)s[2*(4*_+g)+u]=o[2*_+u];this.cumsum=l,this.vbo_segment.set_size(4*this.V_segment.length),this.vbo_segment.set_data(0,this.V_segment)},e}(r.BaseGLGlyph);s.LineGLGlyph=u,u.__name__="LineGLGlyph"},
465: function _(t,e,r){var n,o,i,a,s,l,h,u,c,_=function(t,e){return Array.isArray(t)&&Array.isArray(e)?t.concat(e):t+e},f=function(t,e){if(null==e);else{if(Array.isArray(e)){for(var r=0;r<e.length;r++)if(p(t,e[r]))return!0;return!1}if(e.constructor===Object){for(var n in e)if(t==n)return!0;return!1}if(e.constructor==String)return e.indexOf(t)>=0}var o=Error("Not a container: "+e);throw o.name="TypeError",o},p=function t(e,r){if(null==e||null==r);else{if(Array.isArray(e)&&Array.isArray(r)){for(var n=0,o=e.length==r.length;o&&n<e.length;)o=t(e[n],r[n]),n+=1;return o}if(e.constructor===Object&&r.constructor===Object){var i=Object.keys(e),a=Object.keys(r);i.sort(),a.sort();var s;for(n=0,o=t(i,a);o&&n<i.length;)o=t(e[s=i[n]],r[s]),n+=1;return o}}return e==r},d=function(t,e){if(void 0===t||"undefined"!=typeof window&&window===t||"undefined"!=typeof global&&global===t)throw"Class constructor is called as a function.";for(var r in t)void 0!==Object[r]||"function"!=typeof t[r]||t[r].nobind||(t[r]=t[r].bind(t));t.__init__&&t.__init__.apply(t,e)},y=function(t,e){if(("number"==typeof t)+("number"==typeof e)===1){if(t.constructor===String)return A.call(t,e);if(e.constructor===String)return A.call(e,t);if(Array.isArray(e)){var r=t;t=e,e=r}if(Array.isArray(t)){for(var n=[],o=0;o<e;o++)n=n.concat(t);return n}}return t*e},g=function(t){return null===t||"object"!=typeof t?t:void 0!==t.length?!!t.length&&t:void 0!==t.byteLength?!!t.byteLength&&t:t.constructor!==Object||!!Object.getOwnPropertyNames(t).length&&t},v=function(t){if(!Array.isArray(this))return this.append.apply(this,arguments);this.push(t)},m=function(t,e){return this.constructor!==Object?this.get.apply(this,arguments):void 0!==this[t]?this[t]:void 0!==e?e:null},x=function(){return"function"==typeof this.keys?this.keys.apply(this,arguments):Object.keys(this)},b=function(t){if(this.constructor!==String)return this.lstrip.apply(this,arguments);t=void 0===t?" \t\r\n":t;for(var e=0;e<this.length;e++)if(t.indexOf(this[e])<0)return this.slice(e);return""},E=function(t){if(!Array.isArray(this))return this.remove.apply(this,arguments);for(var e=0;e<this.length;e++)if(p(this[e],t))return void this.splice(e,1);var r=Error(t);throw r.name="ValueError",r},A=function(t){if(this.repeat)return this.repeat(t);if(t<1)return"";for(var e="",r=this.valueOf();t>1;)1&t&&(e+=r),t>>=1,r+=r;return e+r},w=function(t){return this.constructor!==String?this.startswith.apply(this,arguments):0==this.indexOf(t)};c=window.console,u=function(t,e){var r,n,o,i,a,s,l;for(e=void 0===e?"periodic check":e,i=[];n=t.getError(),!(p(n,t.NO_ERROR)||g(i)&&p(n,i[i.length-1]));)v.call(i,n);if(i.length){for(a="","object"!=typeof(s=i)||Array.isArray(s)||(s=Object.keys(s)),l=0;l<s.length;l+=1)r=s[l],a=_(a,r);throw(o=new Error("RuntimeError:OpenGL got errors ("+e+"): "+a)).name="RuntimeError",o}return null},(o=function(){d(this,arguments)}).prototype._base_class=Object,o.prototype._class_name="GlooObject",o.prototype.__init__=function(t){if(this._gl=t,this.handle=null,this._create(),null===this.handle)throw"AssertionError: this.handle !== null";return null},o.prototype._create=function(){var t;throw(t=new Error("NotImplementedError:")).name="NotImplementedError",t},((a=function(){d(this,arguments)}).prototype=Object.create(o.prototype))._base_class=o.prototype,a.prototype._class_name="Program",a.prototype.UTYPEMAP={float:"uniform1fv",vec2:"uniform2fv",vec3:"uniform3fv",vec4:"uniform4fv",int:"uniform1iv",ivec2:"uniform2iv",ivec3:"uniform3iv",ivec4:"uniform4iv",bool:"uniform1iv",bvec2:"uniform2iv",bvec3:"uniform3iv",bvec4:"uniform4iv",mat2:"uniformMatrix2fv",mat3:"uniformMatrix3fv",mat4:"uniformMatrix4fv",sampler1D:"uniform1i",sampler2D:"uniform1i",sampler3D:"uniform1i"},a.prototype.ATYPEMAP={float:"vertexAttrib1f",vec2:"vertexAttrib2f",vec3:"vertexAttrib3f",vec4:"vertexAttrib4f"},a.prototype.ATYPEINFO={float:[1,5126],vec2:[2,5126],vec3:[3,5126],vec4:[4,5126]},a.prototype._create=function(){return this.handle=this._gl.createProgram(),this.locations={},this._unset_variables=[],this._validated=!1,this._samplers={},this._attributes={},this._known_invalid=[],null},a.prototype.delete=function(){return this._gl.deleteProgram(this.handle),null},a.prototype.activate=function(){return this._gl.useProgram(this.handle),null},a.prototype.deactivate=function(){return this._gl.useProgram(0),null},a.prototype.set_shaders=function(t,e){var r,n,o,i,a,s,l,h,u,c,f,p,d;for(s=this._gl,this._linked=!1,f=[[t,d=s.createShader(s.VERTEX_SHADER),"vertex"],[e,a=s.createShader(s.FRAGMENT_SHADER),"fragment"]],h=0;h<2;h+=1)if(r=(c=f[h])[0],l=c[1],p=c[2],s.shaderSource(l,r),s.compileShader(l),u=s.getShaderParameter(l,s.COMPILE_STATUS),!g(u))throw i=s.getShaderInfoLog(l),(o=new Error("RuntimeError:"+_("errors in "+p+" shader:\n",i))).name="RuntimeError",o;if(s.attachShader(this.handle,d),s.attachShader(this.handle,a),s.linkProgram(this.handle),!g(s.getProgramParameter(this.handle,s.LINK_STATUS)))throw(n=new Error("RuntimeError:Program link error:\n"+s.getProgramInfoLog(this.handle))).name="RuntimeError",n;return this._unset_variables=this._get_active_attributes_and_uniforms(),s.detachShader(this.handle,d),s.detachShader(this.handle,a),s.deleteShader(d),s.deleteShader(a),this._known_invalid=[],this._linked=!0,null},a.prototype._get_active_attributes_and_uniforms=function(){var t,e,r,n,o,i,a,s,l,h,u,c,f,p,d,y,m,x;for(s=this._gl,this.locations={},p=new window.RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*"),o=s.getProgramParameter(this.handle,s.ACTIVE_UNIFORMS),e=s.getProgramParameter(this.handle,s.ACTIVE_ATTRIBUTES),x=[],"object"!=typeof(y=[[t=[],e,s.getActiveAttrib,s.getAttribLocation],[x,o,s.getActiveUniform,s.getUniformLocation]])||Array.isArray(y)||(y=Object.keys(y)),m=0;m<y.length;m+=1)for(r=(d=y[m])[0],n=d[1],i=d[2],a=d[3],l=0;l<n;l+=1){if(c=(f=(h=i.call(s,this.handle,l)).name).match(p),g(c))for(f=c[1],u=0;u<h.size;u+=1)v.call(r,[f+"["+u+"]",h.type]);else v.call(r,[f,h.type]);this.locations[f]=a.call(s,this.handle,f)}return _(function(){var e,r,n,o=[];for("object"!=typeof(r=t)||Array.isArray(r)||(r=Object.keys(r)),n=0;n<r.length;n++)e=r[n],o.push(e[0]);return o}.apply(this),function(){var t,e,r,n=[];for("object"!=typeof(e=x)||Array.isArray(e)||(e=Object.keys(e)),r=0;r<e.length;r++)t=e[r],n.push(t[0]);return n}.apply(this))},a.prototype.set_texture=function(t,e){var r,n,o;if(!g(this._linked))throw(r=new Error("RuntimeError:Cannot set uniform when program has no code")).name="RuntimeError",r;return n=m.call(this.locations,t,-1),g(n<0)?(f(t,this._known_invalid)||(v.call(this._known_invalid,t),c.log("Variable "+t+" is not an active texture")),null):(f(t,this._unset_variables)&&E.call(this._unset_variables,t),this.activate(),o=x.call(this._samplers).length,f(t,this._samplers)&&(o=this._samplers[t][this._samplers[t].length-1]),this._samplers[t]=[e._target,e.handle,o],this._gl.uniform1i(n,o),null)},a.prototype.set_uniform=function(t,e,r){var n,o,i,a,s,l,h;if(!g(this._linked))throw(i=new Error("RuntimeError:Cannot set uniform when program has no code")).name="RuntimeError",i;if(s=m.call(this.locations,t,-1),g(s<0))return f(t,this._known_invalid)||(v.call(this._known_invalid,t),c.log("Variable "+t+" is not an active uniform")),null;if(f(t,this._unset_variables)&&E.call(this._unset_variables,t),o=1,w.call(e,"mat")||(n=m.call({int:"float",bool:"float"},e,b.call(e,"ib")),o=Math.floor(r.length/this.ATYPEINFO[n][0])),g(o>1))for(l=0;l<o;l+=1)f(t+"["+l+"]",this._unset_variables)&&f(h=t+"["+l+"]",this._unset_variables)&&E.call(this._unset_variables,h);return a=this.UTYPEMAP[e],this.activate(),w.call(e,"mat")?this._gl[a](s,!1,r):this._gl[a](s,r),null},a.prototype.set_attribute=function(t,e,r,n,o){var i,a,s,l,u,_;if(n=void 0===n?0:n,o=void 0===o?0:o,!g(this._linked))throw(a=new Error("RuntimeError:Cannot set attribute when program has no code")).name="RuntimeError",a;return u=r instanceof h,l=m.call(this.locations,t,-1),g(l<0)?(f(t,this._known_invalid)||(v.call(this._known_invalid,t),g(u)&&g(o>0)||c.log("Variable "+t+" is not an active attribute")),null):(f(t,this._unset_variables)&&E.call(this._unset_variables,t),this.activate(),g(u)?(s="vertexAttribPointer",i=[(_=this.ATYPEINFO[e])[0],_[1],this._gl.FALSE,n,o],this._attributes[t]=[r.handle,l,s,i]):(s=this.ATYPEMAP[e],this._attributes[t]=[0,l,s,r]),null)},a.prototype._pre_draw=function(){var t,e,r,n,o,i,a,s,l,h,u,c;for(c in this.activate(),a=this._samplers)a.hasOwnProperty(c)&&(l=(i=c=a[c])[0],s=i[1],h=i[2],this._gl.activeTexture(_(this._gl.TEXTURE0,h)),this._gl.bindTexture(l,s));for(c in o=this._attributes)o.hasOwnProperty(c)&&(u=(n=c=o[c])[0],e=n[1],r=n[2],t=n[3],g(u)?(this._gl.bindBuffer(this._gl.ARRAY_BUFFER,u),this._gl.enableVertexAttribArray(e),this._gl[r].apply(this._gl,[].concat([e],t))):(this._gl.bindBuffer(this._gl.ARRAY_BUFFER,null),this._gl.disableVertexAttribArray(e),this._gl[r].apply(this._gl,[].concat([e],t))));return g(this._validated)||(this._validated=!0,this._validate()),null},a.prototype._validate=function(){var t;if(this._unset_variables.length&&c.log("Program has unset variables: "+this._unset_variables),this._gl.validateProgram(this.handle),!g(this._gl.getProgramParameter(this.handle,this._gl.VALIDATE_STATUS)))throw c.log(this._gl.getProgramInfoLog(this.handle)),(t=new Error("RuntimeError:Program validation error")).name="RuntimeError",t;return null},a.prototype.draw=function(t,e){var r,n,o,a,s;if(!g(this._linked))throw(n=new Error("RuntimeError:Cannot draw program if code has not been set")).name="RuntimeError",n;return u(this._gl,"before draw"),g(e instanceof i)?(this._pre_draw(),e.activate(),r=e._buffer_size/2,a=this._gl.UNSIGNED_SHORT,this._gl.drawElements(t,r,a,0),e.deactivate()):(o=(s=e)[0],r=s[1],g(r)&&(this._pre_draw(),this._gl.drawArrays(t,o,r))),u(this._gl,"after draw"),null},((n=function(){d(this,arguments)}).prototype=Object.create(o.prototype))._base_class=o.prototype,n.prototype._class_name="Buffer",n.prototype._target=null,n.prototype._usage=35048,n.prototype._create=function(){return this.handle=this._gl.createBuffer(),this._buffer_size=0,null},n.prototype.delete=function(){return this._gl.deleteBuffer(this.handle),null},n.prototype.activate=function(){return this._gl.bindBuffer(this._target,this.handle),null},n.prototype.deactivate=function(){return this._gl.bindBuffer(this._target,null),null},n.prototype.set_size=function(t){return p(t,this._buffer_size)||(this.activate(),this._gl.bufferData(this._target,t,this._usage),this._buffer_size=t),null},n.prototype.set_data=function(t,e){return this.activate(),this._gl.bufferSubData(this._target,t,e),null},(h=function(){d(this,arguments)}).prototype=Object.create(n.prototype),h.prototype._base_class=n.prototype,h.prototype._class_name="VertexBuffer",h.prototype._target=34962,(i=function(){d(this,arguments)}).prototype=Object.create(n.prototype),i.prototype._base_class=n.prototype,i.prototype._class_name="IndexBuffer",i.prototype._target=34963,((s=function(){d(this,arguments)}).prototype=Object.create(o.prototype))._base_class=o.prototype,s.prototype._class_name="Texture2D",s.prototype._target=3553,s.prototype._types={Int8Array:5120,Uint8Array:5121,Int16Array:5122,Uint16Array:5123,Int32Array:5124,Uint32Array:5125,Float32Array:5126},s.prototype._create=function(){return this.handle=this._gl.createTexture(),this._shape_format=null,null},s.prototype.delete=function(){return this._gl.deleteTexture(this.handle),null},s.prototype.activate=function(){return this._gl.bindTexture(this._target,this.handle),null},s.prototype.deactivate=function(){return this._gl.bindTexture(this._target,0),null},s.prototype._get_alignment=function(t){var e,r,n;for("object"!=typeof(r=[4,8,2,1])||Array.isArray(r)||(r=Object.keys(r)),n=0;n<r.length;n+=1)if(e=r[n],p(t%e,0))return e;return null},s.prototype.set_wrapping=function(t,e){return this.activate(),this._gl.texParameterf(this._target,this._gl.TEXTURE_WRAP_S,t),this._gl.texParameterf(this._target,this._gl.TEXTURE_WRAP_T,e),null},s.prototype.set_interpolation=function(t,e){return this.activate(),this._gl.texParameterf(this._target,this._gl.TEXTURE_MIN_FILTER,t),this._gl.texParameterf(this._target,this._gl.TEXTURE_MAG_FILTER,e),null},s.prototype.set_size=function(t,e){var r,n,o;return r=(n=t)[0],o=n[1],p([r,o,e],this._shape_format)||(this._shape_format=[r,o,e],this.activate(),this._gl.texImage2D(this._target,0,e,o,r,0,e,this._gl.UNSIGNED_BYTE,null)),this.u_shape=[r,o],null},s.prototype.set_data=function(t,e,r){var n,o,i,a,s,l,h,u,c,_;if(p(e.length,2)&&(e=[e[0],e[1],1]),this.activate(),i=this._shape_format[2],s=(l=e)[0],u=l[1],l[2],_=(h=t)[0],c=h[1],null===(a=m.call(this._types,r.constructor.name,null)))throw(o=new Error("ValueError:Type "+r.constructor.name+" not allowed for texture")).name="ValueError",o;return n=this._get_alignment(y(e[e.length-2],e[e.length-1])),p(n,4)||this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT,n),this._gl.texSubImage2D(this._target,0,c,_,u,s,i,a,r),p(n,4)||this._gl.pixelStorei(this._gl.UNPACK_ALIGNMENT,4),null},((l=function(){d(this,arguments)}).prototype=Object.create(s.prototype))._base_class=s.prototype,l.prototype._class_name="Texture3DLike",l.prototype.GLSL_SAMPLE_NEAREST="\n        vec4 sample3D(sampler2D tex, vec3 texcoord, vec3 shape, vec2 tiles) {\n            shape.xyz = shape.zyx;  // silly row-major convention\n            float nrows = tiles.y, ncols = tiles.x;\n            // Don't let adjacent frames be interpolated into this one\n            texcoord.x = min(texcoord.x * shape.x, shape.x - 0.5);\n            texcoord.x = max(0.5, texcoord.x) / shape.x;\n            texcoord.y = min(texcoord.y * shape.y, shape.y - 0.5);\n            texcoord.y = max(0.5, texcoord.y) / shape.y;\n\n            float zindex = floor(texcoord.z * shape.z);\n\n            // Do a lookup in the 2D texture\n            float u = (mod(zindex, ncols) + texcoord.x) / ncols;\n            float v = (floor(zindex / ncols) + texcoord.y) / nrows;\n\n            return texture2D(tex, vec2(u,v));\n        }\n    ",l.prototype.GLSL_SAMPLE_LINEAR="\n        vec4 sample3D(sampler2D tex, vec3 texcoord, vec3 shape, vec2 tiles) {\n            shape.xyz = shape.zyx;  // silly row-major convention\n            float nrows = tiles.y, ncols = tiles.x;\n            // Don't let adjacent frames be interpolated into this one\n            texcoord.x = min(texcoord.x * shape.x, shape.x - 0.5);\n            texcoord.x = max(0.5, texcoord.x) / shape.x;\n            texcoord.y = min(texcoord.y * shape.y, shape.y - 0.5);\n            texcoord.y = max(0.5, texcoord.y) / shape.y;\n\n            float z = texcoord.z * shape.z;\n            float zindex1 = floor(z);\n            float u1 = (mod(zindex1, ncols) + texcoord.x) / ncols;\n            float v1 = (floor(zindex1 / ncols) + texcoord.y) / nrows;\n\n            float zindex2 = zindex1 + 1.0;\n            float u2 = (mod(zindex2, ncols) + texcoord.x) / ncols;\n            float v2 = (floor(zindex2 / ncols) + texcoord.y) / nrows;\n\n            vec4 s1 = texture2D(tex, vec2(u1, v1));\n            vec4 s2 = texture2D(tex, vec2(u2, v2));\n\n            return s1 * (zindex2 - z) + s2 * (z - zindex1);\n        }\n    ",l.prototype._get_tile_info=function(t){var e,r,n,o;if(r=this._gl.getParameter(this._gl.MAX_TEXTURE_SIZE),o=Math.floor(r/t[1]),o=Math.min(o,t[0]),n=window.Math.ceil(t[0]/o),g(y(n,t[2])>r))throw(e=new Error("RuntimeError:Cannot fit 3D data with shape "+t+" onto simulated 2D texture.")).name="RuntimeError",e;return[o,n]},l.prototype.set_size=function(t,e){var r,n,o,i;return n=(i=this._get_tile_info(t))[0],r=i[1],o=[y(t[1],n),y(t[2],r)],l.prototype._base_class.set_size.call(this,o,e),this.u_shape=[t[0],t[1],t[2]],this.u_tiles=[r,n],null},l.prototype.set_data=function(t,e,r){var n,o,i,a,s,h,u,c,_,f,d,v;if(p(e.length,3)&&(e=[e[0],e[1],e[2],1]),!function(t){for(var e=0;e<t.length;e++)if(!g(t[e]))return!1;return!0}(function(){var e,r,n,o=[];for("object"!=typeof(r=t)||Array.isArray(r)||(r=Object.keys(r)),n=0;n<r.length;n++)e=r[n],o.push(p(e,0));return o}.apply(this)))throw(i=new Error("ValueError:Texture3DLike does not support nonzero offset (for now)")).name="ValueError",i;if(s=(c=this._get_tile_info(e))[0],a=c[1],u=[y(e[1],s),y(e[2],a),e[3]],p(a,1))l.prototype._base_class.set_data.call(this,[0,0],u,r);else for(v=new(0,r.constructor)(y(y(u[0],u[1]),u[2])),l.prototype._base_class.set_data.call(this,[0,0],u,v),d=0;d<e[0];d+=1)h=(_=[Math.floor(d/a),d%a])[0],n=_[1],o=Math.floor(r.length/e[0]),f=r.slice(y(d,o),y(d+1,o)),l.prototype._base_class.set_data.call(this,[y(h,e[1]),y(n,e[2])],e.slice(1),f);return null},e.exports={Buffer:n,GlooObject:o,IndexBuffer:i,Program:a,Texture2D:s,Texture3DLike:l,VertexBuffer:h,check_error:u,console:c}},
466: function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});var r=e(126),i=e(175),n=function(){function e(e,t){this.gl=e,this.glyph=t,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.init()}return e.prototype.set_data_changed=function(e){e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0},e.prototype.set_visuals_changed=function(){this.visuals_changed=!0},e.prototype.render=function(e,t,a){var r,n=[0,1,2],s=n[0],o=n[1],h=n[2],l=1,c=1,_=this.glyph.renderer.map_to_screen([s*l,o*l,h*l],[s*c,o*c,h*c]),u=_[0],d=_[1];if(isNaN(u[0]+u[1]+u[2]+d[0]+d[1]+d[2]))return i.logger.warn("WebGL backend ("+this.glyph.model.type+"): falling back to canvas rendering"),!1;if(l=100/Math.min(Math.max(Math.abs(u[1]-u[0]),1e-12),1e12),c=100/Math.min(Math.max(Math.abs(d[1]-d[0]),1e-12),1e12),u=(r=this.glyph.renderer.map_to_screen([s*l,o*l,h*l],[s*c,o*c,h*c]))[0],d=r[1],Math.abs(u[1]-u[0]-(u[2]-u[1]))>1e-6||Math.abs(d[1]-d[0]-(d[2]-d[1]))>1e-6)return i.logger.warn("WebGL backend ("+this.glyph.model.type+"): falling back to canvas rendering"),!1;var v=[(u[1]-u[0])/l,(d[1]-d[0])/c],f=v[0],g=v[1],p=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,y=p.width,b=p.height,w={pixel_ratio:this.glyph.renderer.plot_view.canvas.pixel_ratio,width:y,height:b,dx:u[0]/f,dy:d[0]/g,sx:f,sy:g};return this.draw(t,a,w),!0},e}();function s(e,t){for(var a=new Float32Array(e),r=0,i=e;r<i;r++)a[r]=t;return a}function o(e,t){return void 0!==e[t].spec.value}a.BaseGLGlyph=n,n.__name__="BaseGLGlyph",a.line_width=function(e){return e<2&&(e=Math.sqrt(2*e)),e},a.fill_array_with_float=s,a.fill_array_with_vec=function(e,t,a){for(var r=new Float32Array(e*t),i=0;i<e;i++)for(var n=0;n<t;n++)r[i*t+n]=a[n];return r},a.visual_prop_is_singular=o,a.attach_float=function(e,t,a,r,i,n){if(i.doit)if(o(i,n))t.used=!1,e.set_attribute(a,"float",i[n].value());else{t.used=!0;var s=new Float32Array(i.cache[n+"_array"]);t.set_size(4*r),t.set_data(0,s),e.set_attribute(a,"float",t)}else t.used=!1,e.set_attribute(a,"float",[0])},a.attach_color=function(e,t,a,i,n,h){var l,c=h+"_color",_=h+"_alpha";if(n.doit)if(o(n,c)&&o(n,_))t.used=!1,l=r.color2rgba(n[c].value(),n[_].value()),e.set_attribute(a,"vec4",l);else{var u=void 0,d=void 0;t.used=!0,d=o(n,c)?function(){for(var e=[],t=0,a=i;t<a;t++)e.push(n[c].value());return e}():n.cache[c+"_array"],u=o(n,_)?s(i,n[_].value()):n.cache[_+"_array"];for(var v=new Float32Array(4*i),f=0,g=i;f<g;f++){l=r.color2rgba(d[f],u[f]);for(var p=0;p<4;p++)v[4*f+p]=l[p]}t.set_size(4*i*4),t.set_data(0,v),e.set_attribute(a,"vec4",t)}else t.used=!1,e.set_attribute(a,"vec4",[0,0,0,0])}},
467: function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.vertex_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = (a_position + u_offset) * abs_scale;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n"},
468: function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0}),e.fragment_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}\n"},
469: function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});var i=t(1),r=t(465),a=t(466),o=t(470),_=t(471),h=t(317),l=t(117),n=t(175),f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(e,t),e.prototype.init=function(){var t=this.gl,e=o.vertex_shader,s=_.fragment_shader(this._marker_code);this.prog=new r.Program(t),this.prog.set_shaders(e,s),this.vbo_x=new r.VertexBuffer(t),this.prog.set_attribute("a_x","float",this.vbo_x),this.vbo_y=new r.VertexBuffer(t),this.prog.set_attribute("a_y","float",this.vbo_y),this.vbo_s=new r.VertexBuffer(t),this.prog.set_attribute("a_size","float",this.vbo_s),this.vbo_a=new r.VertexBuffer(t),this.prog.set_attribute("a_angle","float",this.vbo_a),this.vbo_linewidth=new r.VertexBuffer(t),this.vbo_fg_color=new r.VertexBuffer(t),this.vbo_bg_color=new r.VertexBuffer(t),this.index_buffer=new r.IndexBuffer(t)},e.prototype.draw=function(t,e,s){var i=e.glglyph,r=i.nvertices;if(i.data_changed){if(!isFinite(s.dx)||!isFinite(s.dy))return;i._baked_offset=[s.dx,s.dy],i._set_data(r),i.data_changed=!1}else this.glyph instanceof h.CircleView&&null!=this.glyph._radius&&(null==this.last_trans||s.sx!=this.last_trans.sx||s.sy!=this.last_trans.sy)&&(this.last_trans=s,this.vbo_s.set_data(0,new Float32Array(l.map(this.glyph.sradius,(function(t){return 2*t})))));this.visuals_changed&&(this._set_visuals(r),this.visuals_changed=!1);var a=i._baked_offset;if(this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_uniform("u_offset","vec2",[s.dx-a[0],s.dy-a[1]]),this.prog.set_uniform("u_scale","vec2",[s.sx,s.sy]),this.prog.set_attribute("a_x","float",i.vbo_x),this.prog.set_attribute("a_y","float",i.vbo_y),this.prog.set_attribute("a_size","float",i.vbo_s),this.prog.set_attribute("a_angle","float",i.vbo_a),0!=t.length)if(t.length===r)this.prog.draw(this.gl.POINTS,[0,r]);else if(r<65535){var o=window.navigator.userAgent;o.indexOf("MSIE ")+o.indexOf("Trident/")+o.indexOf("Edge/")>0&&n.logger.warn("WebGL warning: IE is known to produce 1px sprites whith selections."),this.index_buffer.set_size(2*t.length),this.index_buffer.set_data(0,new Uint16Array(t)),this.prog.draw(this.gl.POINTS,this.index_buffer)}else{for(var _=[],f=0,u=Math.ceil(r/64e3);f<u;f++)_.push([]);for(f=0,u=t.length;f<u;f++){var g=t[f]%64e3;_[p=Math.floor(t[f]/64e3)].push(g)}var p=0;for(u=_.length;p<u;p++){var d=new Uint16Array(_[p]),b=64e3*p*4;0!==d.length&&(this.prog.set_attribute("a_x","float",i.vbo_x,0,b),this.prog.set_attribute("a_y","float",i.vbo_y,0,b),this.prog.set_attribute("a_size","float",i.vbo_s,0,b),this.prog.set_attribute("a_angle","float",i.vbo_a,0,b),this.vbo_linewidth.used&&this.prog.set_attribute("a_linewidth","float",this.vbo_linewidth,0,b),this.vbo_fg_color.used&&this.prog.set_attribute("a_fg_color","vec4",this.vbo_fg_color,0,4*b),this.vbo_bg_color.used&&this.prog.set_attribute("a_bg_color","vec4",this.vbo_bg_color,0,4*b),this.index_buffer.set_size(2*d.length),this.index_buffer.set_data(0,d),this.prog.draw(this.gl.POINTS,this.index_buffer))}}},e.prototype._set_data=function(t){var e=4*t;this.vbo_x.set_size(e),this.vbo_y.set_size(e),this.vbo_a.set_size(e),this.vbo_s.set_size(e);for(var s=new Float64Array(this.glyph._x),i=new Float64Array(this.glyph._y),r=0,a=t;r<a;r++)s[r]+=this._baked_offset[0],i[r]+=this._baked_offset[1];this.vbo_x.set_data(0,new Float32Array(s)),this.vbo_y.set_data(0,new Float32Array(i)),null!=this.glyph._angle&&this.vbo_a.set_data(0,new Float32Array(this.glyph._angle)),this.glyph instanceof h.CircleView&&null!=this.glyph._radius?this.vbo_s.set_data(0,new Float32Array(l.map(this.glyph.sradius,(function(t){return 2*t})))):this.vbo_s.set_data(0,new Float32Array(this.glyph._size))},e.prototype._set_visuals=function(t){a.attach_float(this.prog,this.vbo_linewidth,"a_linewidth",t,this.glyph.visuals.line,"line_width"),a.attach_color(this.prog,this.vbo_fg_color,"a_fg_color",t,this.glyph.visuals.line,"line"),a.attach_color(this.prog,this.vbo_bg_color,"a_bg_color",t,this.glyph.visuals.fill,"fill"),this.prog.set_uniform("u_antialias","float",[.8])},e}(a.BaseGLGlyph);function u(t){return function(e){function s(){return null!==e&&e.apply(this,arguments)||this}return i.__extends(s,e),Object.defineProperty(s.prototype,"_marker_code",{get:function(){return t},enumerable:!0,configurable:!0}),s}(f)}s.MarkerGLGlyph=f,f.__name__="MarkerGLGlyph";var g=i.__importStar(t(471));s.CircleGLGlyph=u(g.circle),s.SquareGLGlyph=u(g.square),s.DiamondGLGlyph=u(g.diamond),s.TriangleGLGlyph=u(g.triangle),s.InvertedTriangleGLGlyph=u(g.invertedtriangle),s.HexGLGlyph=u(g.hex),s.CrossGLGlyph=u(g.cross),s.CircleCrossGLGlyph=u(g.circlecross),s.SquareCrossGLGlyph=u(g.squarecross),s.DiamondCrossGLGlyph=u(g.diamondcross),s.XGLGlyph=u(g.x),s.CircleXGLGlyph=u(g.circlex),s.SquareXGLGlyph=u(g.squarex),s.AsteriskGLGlyph=u(g.asterisk)},
470: function _(n,i,a){Object.defineProperty(a,"__esModule",{value:!0}),a.vertex_shader="\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\n//\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform vec2 u_offset;\nuniform vec2 u_scale;\nuniform float u_antialias;\n//\nattribute float a_x;\nattribute float a_y;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4  a_fg_color;\nattribute vec4  a_bg_color;\n//\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying vec2  v_rotation;\n\nvoid main (void)\n{\n    v_size = a_size * u_pixel_ratio;\n    v_linewidth = a_linewidth * u_pixel_ratio;\n    v_fg_color = a_fg_color;\n    v_bg_color = a_bg_color;\n    v_rotation = vec2(cos(-a_angle), sin(-a_angle));\n    // Calculate position - the -0.5 is to correct for canvas origin\n    vec2 pos = (vec2(a_x, a_y) + u_offset) * u_scale; // in pixels\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(pos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n    gl_PointSize = SQRT_2 * v_size + 2.0 * (v_linewidth + 1.5*u_antialias);\n}\n"},
471: function _(a,n,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fragment_shader=function(a){return"\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\nconst float PI = 3.14159265358979323846264;\n//\nuniform float u_antialias;\n//\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2  v_rotation;\n\n"+a+"\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 fg_color, vec4 bg_color)\n{\n    vec4 frag_color;\n    float t = linewidth/2.0 - antialias;\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If fg alpha is zero, it probably means no outline. To avoid a dark outline\n    // shining through due to aa, we set the fg color to the bg color. Avoid if (i.e. branching).\n    float select = float(bool(fg_color.a));\n    fg_color.rgb = select * fg_color.rgb + (1.0  - select) * bg_color.rgb;\n    // Similarly, if we want a transparent bg\n    select = float(bool(bg_color.a));\n    bg_color.rgb = select * bg_color.rgb + (1.0  - select) * fg_color.rgb;\n\n    if( border_distance < 0.0)\n        frag_color = fg_color;\n    else if( signed_distance < 0.0 ) {\n        frag_color = mix(bg_color, fg_color, sqrt(alpha));\n    } else {\n        if( abs(signed_distance) < (linewidth/2.0 + antialias) ) {\n            frag_color = vec4(fg_color.rgb, fg_color.a * alpha);\n        } else {\n            discard;\n        }\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    vec2 P = gl_PointCoord.xy - vec2(0.5, 0.5);\n    P = vec2(v_rotation.x*P.x - v_rotation.y*P.y,\n             v_rotation.y*P.x + v_rotation.x*P.y);\n    float point_size = SQRT_2*v_size  + 2.0 * (v_linewidth + 1.5*u_antialias);\n    float distance = marker(P*point_size, v_size);\n    gl_FragColor = outline(distance, v_linewidth, u_antialias, v_fg_color, v_bg_color);\n    //gl_FragColor.rgb *= gl_FragColor.a;  // pre-multiply alpha\n}\n"},s.circle="\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n",s.square="\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n",s.diamond="\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n",s.hex="\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n",s.triangle="\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.invertedtriangle="\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.cross='\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.5;   // 2.5 is a tweak\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(square, cross);\n}\n',s.circlecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.squarecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.diamondcross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.x='\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 1.6;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(circle, X);\n}\n',s.circlex='\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    float almost = min(min(min(c1, c2), c3), c4);\n    // In this case, the X is also outside of the main shape\n    float Xmask = length(P) - size / 1.6;  // a circle\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return min(max(X, Xmask), almost);\n}\n',s.squarex="\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.asterisk='\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / (2.0 * SQRT_2);\n    float square = max(abs(P.x), abs(P.y)) - size / (2.0 * SQRT_2);\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    // Result is union of masked shapes\n    return min(max(X, diamond), max(cross, square));\n}\n'},
}, 462, {"models/glyphs/webgl/main":462,"models/glyphs/webgl/index":463,"models/glyphs/webgl/line":464,"models/glyphs/webgl/base":466,"models/glyphs/webgl/line.vert":467,"models/glyphs/webgl/line.frag":468,"models/glyphs/webgl/markers":469,"models/glyphs/webgl/markers.vert":470,"models/glyphs/webgl/markers.frag":471}, {});
})

