/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.util.Arrays;
import net.sf.launch4j.config.Describable;
import net.sf.launch4j.config.Messages;

public enum CharsetID implements Describable
{
    ASCII(0, Messages.getString("Charset.ascii")),
    ARABIC(1256, Messages.getString("Language.arabic")),
    CYRILLIC(1251, Messages.getString("Charset.cyrillic")),
    GREEK(1253, Messages.getString("Language.greek")),
    HEBREW(1255, Messages.getString("Language.hebrew")),
    SHIFT_JIS(932, Messages.getString("Charset.shift.jis")),
    SHIFT_KSC(949, Messages.getString("Charset.shift.ksc")),
    LATIN2(1250, Messages.getString("Charset.latin2")),
    MULTILINGUAL(1252, Messages.getString("Charset.multilingual")),
    BIG5(950, Messages.getString("Charset.big5")),
    TURKISH(1254, Messages.getString("Language.turkish")),
    UNICODE(1200, Messages.getString("Charset.unicode"));

    private static final CharsetID[] VALUES;
    private final int id;
    private final String description;

    private CharsetID(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getIndex() {
        for (int i = 0; i < VALUES.length; ++i) {
            if (VALUES[i] != this) continue;
            return i;
        }
        return -1;
    }

    public static CharsetID[] sortedValues() {
        return VALUES;
    }

    static {
        VALUES = CharsetID.values();
        Arrays.sort(VALUES, new Describable.DescribableComparator());
    }
}

