/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.rules.strings.InefficientStringBuffering;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class ConsecutiveLiteralAppends
extends AbstractRule {
    private static final Set blockParents = new HashSet();
    private static final PropertyDescriptor thresholdDescriptor;
    private static final Map propertyDescriptorsByName;
    private int threshold = 1;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchLabel;

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        Node lastBlock;
        if (!ConsecutiveLiteralAppends.isStringBuffer(node)) {
            return data;
        }
        this.threshold = this.getIntProperty(thresholdDescriptor);
        int concurrentCount = this.checkConstructor(node, data);
        Node currentBlock = lastBlock = this.getFirstParentBlock(node);
        Map decls = node.getScope().getVariableDeclarations();
        SimpleNode rootNode = null;
        if (concurrentCount == 1) {
            rootNode = node;
        }
        Iterator iter = decls.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            List decl = (List)entry.getValue();
            for (int ix = 0; ix < decl.size(); ++ix) {
                NameOccurrence no = (NameOccurrence)decl.get(ix);
                SimpleNode n = no.getLocation();
                currentBlock = this.getFirstParentBlock(n);
                if (!InefficientStringBuffering.isInStringBufferOperation(n, 3, "append")) {
                    if (no.isPartOfQualifiedName()) continue;
                    this.checkForViolation(rootNode, data, concurrentCount);
                    concurrentCount = 0;
                    continue;
                }
                ASTPrimaryExpression s = (ASTPrimaryExpression)n.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTPrimaryExpression == null ? ConsecutiveLiteralAppends.class$("net.sourceforge.pmd.ast.ASTPrimaryExpression") : class$net$sourceforge$pmd$ast$ASTPrimaryExpression);
                int numChildren = s.jjtGetNumChildren();
                for (int jx = 0; jx < numChildren; ++jx) {
                    SimpleNode sn = (SimpleNode)s.jjtGetChild(jx);
                    if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                    if (currentBlock != null && lastBlock != null && !currentBlock.equals(lastBlock) || currentBlock == null ^ lastBlock == null) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    }
                    if (concurrentCount == 0) {
                        rootNode = sn;
                    }
                    if (this.isAdditive(sn)) {
                        if ((concurrentCount = this.processAdditive(data, concurrentCount, sn, rootNode)) != 0) {
                            rootNode = sn;
                        }
                    } else if (!this.isAppendingStringLiteral(sn)) {
                        this.checkForViolation(rootNode, data, concurrentCount);
                        concurrentCount = 0;
                    } else {
                        ++concurrentCount;
                    }
                    lastBlock = currentBlock;
                }
            }
        }
        this.checkForViolation(rootNode, data, concurrentCount);
        return data;
    }

    private int checkConstructor(ASTVariableDeclaratorId node, Object data) {
        ASTArgumentList list;
        Node parent = node.jjtGetParent();
        if (parent.jjtGetNumChildren() >= 2 && (list = (ASTArgumentList)((SimpleNode)parent.jjtGetChild(1)).getFirstChildOfType(ASTArgumentList.class)) != null) {
            ASTLiteral literal = (ASTLiteral)list.getFirstChildOfType(ASTLiteral.class);
            if (!this.isAdditive(list) && literal != null && literal.isStringLiteral()) {
                return 1;
            }
            return this.processAdditive(data, 0, list, node);
        }
        return 0;
    }

    private int processAdditive(Object data, int concurrentCount, SimpleNode sn, SimpleNode rootNode) {
        ASTAdditiveExpression additive = (ASTAdditiveExpression)sn.getFirstChildOfType(ASTAdditiveExpression.class);
        if (additive == null) {
            return 0;
        }
        int count = concurrentCount;
        boolean found = false;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            SimpleNode childNode = (SimpleNode)additive.jjtGetChild(ix);
            if (childNode.jjtGetNumChildren() != 1 || childNode.findChildrenOfType(class$net$sourceforge$pmd$ast$ASTName == null ? ConsecutiveLiteralAppends.class$("net.sourceforge.pmd.ast.ASTName") : class$net$sourceforge$pmd$ast$ASTName).size() != 0) {
                if (!found) {
                    this.checkForViolation(rootNode, data, count);
                    found = true;
                }
                count = 0;
                continue;
            }
            ++count;
        }
        if (!found) {
            count = 1;
        }
        return count;
    }

    private boolean isAdditive(SimpleNode n) {
        List lstAdditive = n.findChildrenOfType(ASTAdditiveExpression.class);
        if (lstAdditive.isEmpty()) {
            return false;
        }
        for (int ix = 0; ix < lstAdditive.size(); ++ix) {
            ASTAdditiveExpression expr = (ASTAdditiveExpression)lstAdditive.get(ix);
            if (expr.getParentsOfType(class$net$sourceforge$pmd$ast$ASTArgumentList == null ? ConsecutiveLiteralAppends.class$("net.sourceforge.pmd.ast.ASTArgumentList") : class$net$sourceforge$pmd$ast$ASTArgumentList).size() == 1) continue;
            return false;
        }
        return true;
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !blockParents.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode != null && parentNode.getClass().equals(ASTIfStatement.class)) {
            parentNode = lastNode;
        } else if (parentNode != null && parentNode.getClass().equals(ASTSwitchStatement.class)) {
            parentNode = this.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            if (n.getClass().equals(class$net$sourceforge$pmd$ast$ASTSwitchLabel == null ? ConsecutiveLiteralAppends.class$("net.sourceforge.pmd.ast.ASTSwitchLabel") : class$net$sourceforge$pmd$ast$ASTSwitchLabel)) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    private void checkForViolation(SimpleNode node, Object data, int concurrentCount) {
        if (concurrentCount > this.threshold) {
            Object[] param = new String[]{String.valueOf(concurrentCount)};
            this.addViolation(data, (Node)node, param);
        }
    }

    private boolean isAppendingStringLiteral(SimpleNode node) {
        SimpleNode n = node;
        while (n.jjtGetNumChildren() != 0 && !n.getClass().equals(class$net$sourceforge$pmd$ast$ASTLiteral == null ? ConsecutiveLiteralAppends.class$("net.sourceforge.pmd.ast.ASTLiteral") : class$net$sourceforge$pmd$ast$ASTLiteral)) {
            n = (SimpleNode)n.jjtGetChild(0);
        }
        return n.getClass().equals(ASTLiteral.class);
    }

    private static boolean isStringBuffer(ASTVariableDeclaratorId node) {
        SimpleNode nn = node.getTypeNameNode();
        if (nn.jjtGetNumChildren() == 0) {
            return false;
        }
        return "StringBuffer".equals(((SimpleNode)nn.jjtGetChild(0)).getImage());
    }

    protected Map propertiesByName() {
        return propertyDescriptorsByName;
    }

    static {
        blockParents.add(ASTForStatement.class);
        blockParents.add(ASTWhileStatement.class);
        blockParents.add(ASTDoStatement.class);
        blockParents.add(ASTIfStatement.class);
        blockParents.add(ASTSwitchStatement.class);
        blockParents.add(ASTMethodDeclaration.class);
        thresholdDescriptor = new IntegerProperty("threshold", "?", 1, 1.0f);
        propertyDescriptorsByName = ConsecutiveLiteralAppends.asFixedMap(thresholdDescriptor);
    }
}

