/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.properties.AbstractMultiValueProperty;
import net.sourceforge.pmd.properties.ValueParser;
import net.sourceforge.pmd.properties.constraints.PropertyConstraint;

final class GenericMultiValuePropertyDescriptor<V, C extends Collection<V>>
extends AbstractMultiValueProperty<V> {
    private final Set<PropertyConstraint<? super C>> listValidators;
    private final ValueParser<V> parser;
    private final Class<V> type;

    GenericMultiValuePropertyDescriptor(String name, String description, float uiOrder, Collection<V> defaultValue, Set<PropertyConstraint<? super C>> listValidators, ValueParser<V> parser, char delim, Class<V> type) {
        super(name, description, (List)defaultValue, uiOrder, delim, false);
        this.listValidators = listValidators;
        this.parser = parser;
        this.type = type;
        String dftValueError = this.errorFor((List<V>)new ArrayList<V>(defaultValue));
        if (dftValueError != null) {
            throw new IllegalArgumentException(dftValueError);
        }
    }

    @Override
    public String errorFor(List<V> values) {
        for (PropertyConstraint<C> lv : this.listValidators) {
            String error = lv.validate(values);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    @Override
    protected V createFrom(String toParse) {
        return this.parser.valueOf(toParse);
    }

    @Override
    public Class<V> type() {
        return this.type;
    }
}

