/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.semantic.ast.condition.Condition;
import apex.jorje.semantic.ast.condition.StandardCondition;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.statement.BlockStatement;
import apex.jorje.semantic.ast.statement.IfElseBlockStatement;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.StatementUtil;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import org.objectweb.asm.Label;

public class IfBlockStatement
extends Statement {
    private final IfElseBlockStatement ifElseBlock;
    private final Condition condition;
    private final Statement statement;

    IfBlockStatement(IfElseBlockStatement ifElseBlock, IfBlock ifBlock) {
        super(ifElseBlock);
        this.ifElseBlock = ifElseBlock;
        this.condition = new StandardCondition(this, ifBlock.expr);
        this.statement = BlockStatement.builder().setDefiningNode(this).setStmnt(ifBlock.stmnt).build();
        this.setReturnable(this.statement);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.condition.traverse(visitor, scope);
            this.statement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.condition.validate(symbols, scope);
        this.statement.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.condition, this.statement)) {
            scope.getErrors().markInvalid(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        Label falseLabel = this.condition.getFalseLabel(emitter);
        this.statement.emit(emitter);
        if (!StatementUtil.isLastStatementReturnable(this.statement)) {
            emitter.emitJump(this.ifElseBlock.getLoc(), 167, this.ifElseBlock.getExit());
        }
        emitter.emit(falseLabel);
    }

    @Override
    public Location getLoc() {
        return this.ifElseBlock.getLoc();
    }
}

