//===----------------------------------------------------------------------===//
// Copyright © 2024 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

/// The Pkl standard library.
///
/// The standard library is a set of Pkl modules versioned and distributed together with the language.
///
/// To import a standard library module, use `import "pkl:<identifier>"`.
/// For example, `import "pkl:json"` imports the `pkl.json` module.
///
/// The `pkl.base` module defines the most fundamental properties, methods, and classes for using Pkl.
/// Its members are automatically available in every module and hence it does not need to be imported.
///
/// The default module allowlist (`--allowed-modules`) grants access to all standard library modules.
amends "pkl:DocPackageInfo"

import "pkl:release"

local current = release.current

name = "pkl"
version = (current.version) { build = null }.toString()
importUri = "pkl:/"
authors {
  "pkl-oss@group.apple.com"
}
sourceCode =
  let (commitish = if (current.version.isNormal()) current.version else current.commitId)
    "https://github.com/apple/pkl/blob/\(commitish)/stdlib/"
issueTracker = "https://github.com/apple/pkl/issues"
