amends "../snippetTest.pkl"

examples {
  ["file:"] {
    // test globbing while going up levels
    read*("../../input-helper/globtest/**.pkl")
    // test globbing child directories
    read*("globtest/*.txt")
  }

  ["amended"] {
    (read*("../../input-helper/globtest/**.pkl")) {
      [[true]] {
        text = "hi"
      }
    }
  }

  ["env:"] {
    // doesn't match names that include slashes
    read*("env:*")
    // matches all names including slashes
    read*("env:**")
    read*("env:NAME1")
    read*("env:NAME[1-2]")
    read*("env:*2")
    read*("env:/foo/*")
    // glob pattern should use percent-encoding if pattern is an absolute URI (same rules as `read`)
    read*("env:foo%20bar")
    read*("env:foo%20*")
  }

  ["prop:"] {
    read*("prop:*")
    read*("prop:**")
  }

  ["package:"] {
    read*("package://localhost:0/birds@0.5.0#/**.pkl")
  }

  ["use read expression with non-constant glob pattern"] {
    local function doRead(pattern) = read*(pattern)
    doRead("globtest/file*.txt")
    doRead("globtest/file1.txt")
    doRead("globtest/file2.txt")
  }
  
  ["read different resources with same glob pattern"] {
    local module1 = import(".../input-helper/basic/read/module1.pkl")
    local module2 = import(".../input-helper/basic/read/child/module2.pkl")
    module1.globbedRead
    module2.globbedRead
  }
}
