/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.xobject;

import java.io.IOException;
import java.util.List;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDMetadata;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;

public abstract class PDXObject
implements COSObjectable {
    private PDStream xobject;

    public PDXObject(COSStream xobj) {
        this.xobject = new PDStream(xobj);
    }

    public PDXObject(PDStream xobj) {
        this.xobject = xobj;
    }

    public PDXObject(PDDocument doc) {
        this.xobject = new PDStream(doc);
        this.xobject.getStream().setName(COSName.TYPE, "XObject");
    }

    public COSBase getCOSObject() {
        return this.xobject.getCOSObject();
    }

    public COSStream getCOSStream() {
        return this.xobject.getStream();
    }

    public PDStream getPDStream() {
        return this.xobject;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PDXObject createXObject(COSBase xobject) throws IOException {
        void var1_6;
        Object var1_1 = null;
        if (xobject == null) {
            return var1_6;
        }
        if (!(xobject instanceof COSStream)) throw new IOException("Unknown xobject type:" + xobject.getClass().getName());
        COSStream xstream = (COSStream)xobject;
        String subtype = xstream.getNameAsString("Subtype");
        if (subtype.equals("Image")) {
            PDStream image = new PDStream(xstream);
            List filters = image.getFilters();
            if (filters != null && filters.contains(COSName.DCT_DECODE.getName())) {
                return new PDJpeg(image);
            }
            if (filters != null && filters.contains(COSName.JPX_DECODE.getName())) {
                throw new IOException("JPXDecode has not been implemented for images");
            }
            PDPixelMap pDPixelMap = new PDPixelMap(image);
            return var1_6;
        } else {
            if (!subtype.equals("Form")) throw new IOException("Unknown xobject subtype '" + subtype + "'");
            PDXObjectForm pDXObjectForm = new PDXObjectForm(xstream);
        }
        return var1_6;
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream mdStream = (COSStream)this.xobject.getStream().getDictionaryObject("Metadata");
        if (mdStream != null) {
            retval = new PDMetadata(mdStream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.xobject.getStream().setItem("Metadata", (COSObjectable)meta);
    }
}

