/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ClassSummaryHelper {
    private final Map<String, Long> sizeStat = new HashMap<String, Long>();
    private int numberOfClasses = 0;
    private final String[] preferredOrder;

    public ClassSummaryHelper(String[] preferredOrder) {
        this.preferredOrder = preferredOrder;
    }

    public void addRegionsForClass(LinearDumper.J9ClassRegionNode allRegionsNode) {
        ++this.numberOfClasses;
        ClassSummaryHelper.appendSizeStat(this.sizeStat, allRegionsNode, "");
    }

    public void printStatistics(PrintStream out) {
        TreeMap<String, Long> data = new TreeMap<String, Long>(new StringCompare(this.preferredOrder));
        data.putAll(this.sizeStat);
        long totalSize = 0L;
        for (Map.Entry entry : data.entrySet()) {
            if (ClassSummaryHelper.getLevel((String)entry.getKey()) != 1) continue;
            totalSize += ((Long)entry.getValue()).longValue();
        }
        out.println(String.format("%d classes, using: %d bytes or %d kB", this.numberOfClasses, totalSize, totalSize / 1024L));
        out.println(String.format("%-39s %-8s %-8s %-6s", "Section", "Byte", "kB", "%"));
        for (Map.Entry entry : data.entrySet()) {
            out.println(ClassSummaryHelper.printSize((String)entry.getKey(), (Long)entry.getValue(), totalSize));
        }
    }

    private static void appendSizeStat(Map<String, Long> sizeStat, LinearDumper.J9ClassRegionNode regionNode, String parentName) {
        Object section = parentName;
        LinearDumper.J9ClassRegion nodeValue = regionNode.getNodeValue();
        if (nodeValue != null && (nodeValue.getType() == IClassWalkCallbacks.SlotType.J9_SECTION_START || nodeValue.getType() == IClassWalkCallbacks.SlotType.J9_Padding)) {
            Long length = sizeStat.get(section = (String)section + "/" + nodeValue.getName());
            if (length != null) {
                sizeStat.put((String)section, length + nodeValue.getLength());
            } else {
                sizeStat.put((String)section, nodeValue.getLength());
            }
        }
        for (LinearDumper.J9ClassRegionNode classRegionNode : regionNode.getChildren()) {
            ClassSummaryHelper.appendSizeStat(sizeStat, classRegionNode, (String)section);
        }
    }

    private static String printSize(String key, Long size, long totalSize) {
        StringBuilder section = new StringBuilder();
        int level = ClassSummaryHelper.getLevel(key);
        for (int i = 0; i < level; ++i) {
            section.append("  ");
        }
        section.append(key.substring(key.lastIndexOf(47) + 1));
        long sizeByte = size;
        double sizekB = (double)sizeByte / 1024.0;
        double percent = (double)sizeByte * 100.0 / (double)totalSize;
        return String.format("%-39s %-8d %-8.2f %-6.2f", section, sizeByte, sizekB, percent);
    }

    private static int getLevel(String key) {
        int index = -1;
        int level = 0;
        while ((index = key.indexOf(47, index + 1)) >= 0) {
            ++level;
        }
        return level;
    }

    private static class StringCompare
    implements Comparator<String> {
        private final Map<String, Integer> preferredOrderMap = new HashMap<String, Integer>();

        public StringCompare(String[] preferredOrder) {
            for (int i = 0; i < preferredOrder.length; ++i) {
                this.preferredOrderMap.put(preferredOrder[i], i);
            }
        }

        private int find(String key) {
            Integer order = this.preferredOrderMap.get(key.trim());
            if (order != null) {
                return order;
            }
            return Integer.MAX_VALUE;
        }

        private static String firstSegment(String key) {
            int start = key.indexOf(47) + 1;
            if (start <= 0) {
                throw new IllegalArgumentException();
            }
            int end = key.indexOf(47, start);
            String segment = end < 0 ? key.substring(start) : key.substring(start, end);
            return segment;
        }

        @Override
        public int compare(String o1, String o2) {
            int ordero2;
            String segment1 = StringCompare.firstSegment(o1);
            String segment2 = StringCompare.firstSegment(o2);
            int ordero1 = this.find(segment1);
            if (ordero1 != (ordero2 = this.find(segment2))) {
                return Integer.compare(ordero1, ordero2);
            }
            return o1.compareTo(o2);
        }
    }
}

