/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackmap;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BCNames;
import com.ibm.j9ddr.vm29.j9.PCStack;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.MapHelpers;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackMap {
    private static Logger logger = Logger.getLogger("j9ddr.stackwalker.stackmap");
    private static IStackMap impl;

    public static int j9stackmap_StackBitsForPC(UDATA pc, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, int[] resultsArray, int resultArraySize) throws CorruptDataException {
        IStackMap map = StackMap.getImpl();
        return map.j9stackmap_StackBitsForPC(pc, romClass, romMethod, resultsArray, resultArraySize);
    }

    private static IStackMap getImpl() {
        if (impl == null) {
            impl = StackMap.getImpl("ALG_STACK_MAP_VERSION");
        }
        return impl;
    }

    private static IStackMap getImpl(String algorithmID) {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf(algorithmID);
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new StackMap_V1();
    }

    private static interface IStackMap {
        public int j9stackmap_StackBitsForPC(UDATA var1, J9ROMClassPointer var2, J9ROMMethodPointer var3, int[] var4, int var5) throws CorruptDataException;
    }

    private static class StackMap_V1
    implements IStackMap {
        public static final byte INT = 0;
        public static final byte OBJ = 1;
        public static final byte WALKED = 1;
        public static final byte STACK_REQUEST = 2;
        public static final int BCT_ERR_NO_ERROR = 0;
        public static final int BCT_ERR_STACK_MAP_FAILED = -5;
        private J9MappingStack resultStack;
        private J9MappingStack startStack;
        private J9MappingStack liveStack;
        private U8Pointer bcStart;
        private U8Pointer bcIndex;
        private U8Pointer bcEnd;
        private int exceptionsToWalk;
        private J9ExceptionInfoPointer exceptionData;
        private Stack<J9MappingStack> branchStack = new Stack();

        protected StackMap_V1() {
        }

        @Override
        public int j9stackmap_StackBitsForPC(UDATA pc, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod, int[] resultsArray, int resultArraySize) throws CorruptDataException {
            logger.logp(Level.FINE, "StackMap_V1", "j9stackmap_StackBitsForPC", "romClass={0}, romMethod={1}, pc={2}", new Object[]{Long.toHexString(romClass.getAddress()), Long.toHexString(romMethod.getAddress()), pc});
            UDATA length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
            U16 stackStructSize = romMethod.maxStack();
            byte[] map = new byte[length.intValue()];
            map[pc.intValue()] = 2;
            int rc = this.mapStack(stackStructSize, map, romClass, romMethod);
            if (rc == 0) {
                rc = this.outputStackMap(resultsArray, resultArraySize);
            }
            return rc;
        }

        private int mapStack(U16 totalStack, byte[] map, J9ROMClassPointer romClass, J9ROMMethodPointer romMethod) throws CorruptDataException {
            this.exceptionData = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
            J9ROMConstantPoolItemPointer pool = J9ROMConstantPoolItemPointer.cast(romClass.add(1L));
            if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo)) {
                this.exceptionsToWalk = this.exceptionData.catchCount().intValue();
            }
            this.liveStack = this.startStack = new J9MappingStack(totalStack.intValue());
            this.bcIndex = this.bcStart = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod);
            UDATA length = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
            this.bcEnd = this.bcStart.add(length);
            block7: while (this.bcIndex.lt(this.bcEnd)) {
                int size;
                block69: {
                    int index;
                    int i;
                    int bc;
                    block86: {
                        int i2;
                        char signature;
                        J9UTF8Pointer utf8Signature;
                        block83: {
                            block82: {
                                block81: {
                                    block79: {
                                        block80: {
                                            block77: {
                                                block78: {
                                                    block76: {
                                                        byte type2;
                                                        int temp1;
                                                        block75: {
                                                            int temp2;
                                                            block74: {
                                                                block73: {
                                                                    block72: {
                                                                        block71: {
                                                                            block70: {
                                                                                block68: {
                                                                                    int rc;
                                                                                    int pc = (int)this.bcIndex.sub(UDATA.cast(this.bcStart)).getAddress();
                                                                                    bc = this.bcIndex.at(0L).intValue();
                                                                                    if (map[pc] != 0) {
                                                                                        if ((map[pc] & 2) != 0) {
                                                                                            this.resultStack = this.liveStack;
                                                                                            return 0;
                                                                                        }
                                                                                        rc = this.nextRoot();
                                                                                        if (rc == 0) continue;
                                                                                        return rc;
                                                                                    }
                                                                                    map[pc] = 1;
                                                                                    size = 0xFF & PCStack.J9JavaInstructionSizeAndBranchActionTable[bc];
                                                                                    int action = 0xFF & PCStack.JavaStackActionTable[bc];
                                                                                    if (logger.isLoggable(Level.FINER)) {
                                                                                        logger.logp(Level.FINER, "StackMap_V1", "mapStack", "bcIndex=0x{0} pc={1}, bc={2}, size={3}, action=0x{4}", new Object[]{Long.toHexString(this.bcIndex.getAddress()), pc, bc, size, Long.toHexString(action)});
                                                                                    }
                                                                                    if (action != 128) {
                                                                                        for (i = 0; i != (action & 7); ++i) {
                                                                                            this.POP();
                                                                                        }
                                                                                        if (action >= 16) {
                                                                                            if (action >= 80) {
                                                                                                this.PUSH((byte)1);
                                                                                            } else {
                                                                                                this.PUSH((byte)0);
                                                                                                if (action >= 32) {
                                                                                                    this.PUSH((byte)0);
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (size >>> 4 == 0) {
                                                                                            this.bcIndex = this.bcIndex.add(size);
                                                                                            if (size != 0) continue;
                                                                                            return -5;
                                                                                        }
                                                                                        switch (size >> 4) {
                                                                                            case 1: {
                                                                                                int offset = new I16(MapHelpers.PARAM_16(this.bcIndex, 1)).intValue();
                                                                                                int target = pc + offset;
                                                                                                if ((map[target] & 1) == 0) {
                                                                                                    this.liveStack = this.pushStack(target);
                                                                                                }
                                                                                                this.bcIndex = this.bcIndex.add(size & 7);
                                                                                                continue block7;
                                                                                            }
                                                                                            case 2: {
                                                                                                int target;
                                                                                                int offset;
                                                                                                if (bc == 167) {
                                                                                                    offset = new I16(MapHelpers.PARAM_16(this.bcIndex, 1)).intValue();
                                                                                                    target = pc + offset;
                                                                                                } else {
                                                                                                    offset = new I32(MapHelpers.PARAM_32(this.bcIndex, 1)).intValue();
                                                                                                    target = pc + offset;
                                                                                                }
                                                                                                this.bcIndex = this.bcStart.add(target);
                                                                                                continue block7;
                                                                                            }
                                                                                            case 4: {
                                                                                                rc = this.nextRoot();
                                                                                                if (rc == 0) continue block7;
                                                                                                return rc;
                                                                                            }
                                                                                            case 5: {
                                                                                                int npairs;
                                                                                                int target;
                                                                                                this.bcIndex = this.bcIndex.add(4 - (pc & 3));
                                                                                                int offset = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                this.bcIndex = this.bcIndex.add(4L);
                                                                                                temp2 = pc + offset;
                                                                                                int low = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                this.bcIndex = this.bcIndex.add(4L);
                                                                                                if (bc == 170) {
                                                                                                    int high = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                    this.bcIndex = this.bcIndex.add(4L);
                                                                                                    npairs = high - low + 1;
                                                                                                    temp1 = 0;
                                                                                                } else {
                                                                                                    npairs = low;
                                                                                                    temp1 = 4;
                                                                                                }
                                                                                                while (npairs > 0) {
                                                                                                    this.bcIndex = this.bcIndex.add(temp1);
                                                                                                    offset = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                    this.bcIndex = this.bcIndex.add(4L);
                                                                                                    target = pc + offset;
                                                                                                    if ((map[target] & 1) == 0) {
                                                                                                        this.liveStack = this.pushStack(target);
                                                                                                    }
                                                                                                    --npairs;
                                                                                                }
                                                                                                this.bcIndex = this.bcStart.add(temp2);
                                                                                                continue block7;
                                                                                            }
                                                                                            case 7: {
                                                                                                return -5;
                                                                                            }
                                                                                        }
                                                                                        this.bcIndex.add(size & 7);
                                                                                        continue;
                                                                                    }
                                                                                    if (bc != 18 && bc != 19) break block68;
                                                                                    index = bc == 18 ? MapHelpers.PARAM_8(this.bcIndex, 1).intValue() : MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                                                                    if (pool.add(index).slot2().longValue() != 0L) {
                                                                                        this.PUSH((byte)1);
                                                                                    } else {
                                                                                        this.PUSH((byte)0);
                                                                                    }
                                                                                    break block69;
                                                                                }
                                                                                if (bc != 89) break block70;
                                                                                type2 = this.POP();
                                                                                this.PUSH(type2);
                                                                                this.PUSH(type2);
                                                                                break block69;
                                                                            }
                                                                            if (bc != 90) break block71;
                                                                            type2 = this.POP();
                                                                            temp1 = this.POP();
                                                                            this.PUSH(type2);
                                                                            this.PUSH(temp1);
                                                                            this.PUSH(type2);
                                                                            break block69;
                                                                        }
                                                                        if (bc != 91) break block72;
                                                                        type2 = this.POP();
                                                                        temp1 = this.POP();
                                                                        temp2 = this.POP();
                                                                        this.PUSH(type2);
                                                                        this.PUSH(temp2);
                                                                        this.PUSH(temp1);
                                                                        this.PUSH(type2);
                                                                        break block69;
                                                                    }
                                                                    if (bc != 92) break block73;
                                                                    temp1 = this.POP();
                                                                    temp2 = this.POP();
                                                                    this.PUSH(temp2);
                                                                    this.PUSH(temp1);
                                                                    this.PUSH(temp2);
                                                                    this.PUSH(temp1);
                                                                    break block69;
                                                                }
                                                                if (bc != 93) break block74;
                                                                type2 = this.POP();
                                                                temp1 = this.POP();
                                                                temp2 = this.POP();
                                                                this.PUSH(temp1);
                                                                this.PUSH(type2);
                                                                this.PUSH(temp2);
                                                                this.PUSH(temp1);
                                                                this.PUSH(type2);
                                                                break block69;
                                                            }
                                                            if (bc != 94) break block75;
                                                            type2 = this.POP();
                                                            temp1 = this.POP();
                                                            temp2 = this.POP();
                                                            byte temp3 = this.POP();
                                                            this.PUSH(temp1);
                                                            this.PUSH(type2);
                                                            this.PUSH((int)temp3);
                                                            this.PUSH(temp2);
                                                            this.PUSH(temp1);
                                                            this.PUSH(type2);
                                                            break block69;
                                                        }
                                                        if (bc != 95) break block76;
                                                        type2 = this.POP();
                                                        temp1 = this.POP();
                                                        this.PUSH(type2);
                                                        this.PUSH(temp1);
                                                        break block69;
                                                    }
                                                    if (bc != 180) break block77;
                                                    this.POP();
                                                    index = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                                    utf8Signature = J9ROMFieldRefPointer.cast(pool.add(index)).nameAndSignature().signature();
                                                    signature = J9UTF8Helper.stringValue(utf8Signature).charAt(0);
                                                    if (signature != 'L' && signature != '[') break block78;
                                                    this.PUSH((byte)1);
                                                    break block69;
                                                }
                                                this.PUSH((byte)0);
                                                if (signature != 'J' && signature != 'D') break block69;
                                                this.PUSH((byte)0);
                                                break block69;
                                            }
                                            if (bc != 178) break block79;
                                            index = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                            utf8Signature = J9ROMFieldRefPointer.cast(pool.add(index)).nameAndSignature().signature();
                                            signature = J9UTF8Helper.stringValue(utf8Signature).charAt(0);
                                            if (signature != 'L' && signature != '[') break block80;
                                            this.PUSH((byte)1);
                                            break block69;
                                        }
                                        this.PUSH((byte)0);
                                        if (signature != 'J' && signature != 'D') break block69;
                                        this.PUSH((byte)0);
                                        break block69;
                                    }
                                    if (bc != 181 && bc != BCNames.JBwithfield) break block81;
                                    this.POP();
                                    index = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                    utf8Signature = J9ROMFieldRefPointer.cast(pool.add(index)).nameAndSignature().signature();
                                    signature = J9UTF8Helper.stringValue(utf8Signature).charAt(0);
                                    this.POP();
                                    if (signature == 'D' || signature == 'J') {
                                        this.POP();
                                    }
                                    if (bc == BCNames.JBwithfield) {
                                        this.PUSH((byte)1);
                                    }
                                    break block69;
                                }
                                if (bc != 179) break block82;
                                index = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                utf8Signature = J9ROMFieldRefPointer.cast(pool.add(index)).nameAndSignature().signature();
                                signature = J9UTF8Helper.stringValue(utf8Signature).charAt(0);
                                this.POP();
                                if (signature == 'D' || signature == 'J') {
                                    this.POP();
                                }
                                break block69;
                            }
                            if (bc == BCNames.JBinvokeinterface2) {
                                this.bcIndex = this.bcIndex.add(2L);
                                continue;
                            }
                            if (bc != BCNames.JBinvokehandle && bc != BCNames.JBinvokehandlegeneric && bc != 182 && bc != 183 && bc != BCNames.JBinvokespecialsplit && bc != 185) break block83;
                            this.POP();
                            index = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                            if (bc == BCNames.JBinvokestaticsplit) {
                                index = romClass.staticSplitMethodRefIndexes().at(index).intValue();
                            } else if (bc == BCNames.JBinvokespecialsplit) {
                                index = romClass.specialSplitMethodRefIndexes().at(index).intValue();
                            }
                            utf8Signature = J9ROMMethodRefPointer.cast(pool.add(index)).nameAndSignature().signature();
                            char[] args = J9UTF8Helper.stringValue(utf8Signature).toCharArray();
                            i2 = 0;
                            i2 = 1;
                            while (args[i2] != ')') {
                                block85: {
                                    block84: {
                                        this.POP();
                                        if (args[i2] != '[') break block84;
                                        while (args[++i2] == '[') {
                                        }
                                        if (args[i2] != 'L') break block85;
                                    }
                                    if (args[i2] == 'L') {
                                        while (args[++i2] != ';') {
                                        }
                                    } else if (args[i2] == 'D' || args[i2] == 'J') {
                                        this.POP();
                                    }
                                }
                                ++i2;
                            }
                            signature = args[i2 + 1];
                            if (signature != 'V') {
                                if (signature == 'L' || signature == '[') {
                                    this.PUSH((byte)1);
                                } else {
                                    this.PUSH((byte)0);
                                    if (signature == 'J' || signature == 'D') {
                                        this.PUSH((byte)0);
                                    }
                                }
                            }
                            if (bc != BCNames.JBinvokeinterface2) break block69;
                            this.bcIndex = this.bcIndex.sub(2L);
                            break block69;
                        }
                        if (bc != 184 && bc != BCNames.JBinvokestaticsplit) break block86;
                        index = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                        if (bc == BCNames.JBinvokestaticsplit) {
                            index = romClass.staticSplitMethodRefIndexes().at(index).intValue();
                        } else if (bc == BCNames.JBinvokespecialsplit) {
                            index = romClass.specialSplitMethodRefIndexes().at(index).intValue();
                        }
                        utf8Signature = J9ROMMethodRefPointer.cast(pool.add(index)).nameAndSignature().signature();
                        char[] args = J9UTF8Helper.stringValue(utf8Signature).toCharArray();
                        i2 = 0;
                        i2 = 1;
                        while (args[i2] != ')') {
                            block88: {
                                block87: {
                                    this.POP();
                                    if (args[i2] != '[') break block87;
                                    while (args[++i2] == '[') {
                                    }
                                    if (args[i2] != 'L') break block88;
                                }
                                if (args[i2] == 'L') {
                                    while (args[++i2] != ';') {
                                    }
                                } else if (args[i2] == 'D' || args[i2] == 'J') {
                                    this.POP();
                                }
                            }
                            ++i2;
                        }
                        signature = args[i2 + 1];
                        if (signature != 'V') {
                            if (signature == 'L' || signature == '[') {
                                this.PUSH((byte)1);
                            } else {
                                this.PUSH((byte)0);
                                if (signature == 'J' || signature == 'D') {
                                    this.PUSH((byte)0);
                                }
                            }
                        }
                        if (bc != BCNames.JBinvokeinterface2) break block69;
                        this.bcIndex = this.bcIndex.sub(2L);
                        break block69;
                    }
                    if (bc == 197) {
                        index = MapHelpers.PARAM_8(this.bcIndex, 3).intValue();
                        for (i = 0; i < index; ++i) {
                            this.POP();
                        }
                        this.PUSH((byte)1);
                        break;
                    }
                }
                this.bcIndex = this.bcIndex.add(size & 7);
            }
            return -5;
        }

        private J9MappingStack pushStack(int targetPC) {
            logger.logp(Level.FINEST, "StackMap_V1", "pushStack", "pushStack");
            this.liveStack.pc = targetPC;
            this.branchStack.push(this.liveStack);
            this.liveStack = new J9MappingStack(this.liveStack);
            return this.liveStack;
        }

        private void popStack() {
            logger.logp(Level.FINEST, "StackMap_V1", "popStack", "popStack");
            this.liveStack = this.branchStack.pop();
            this.bcIndex = this.bcStart.add(this.liveStack.pc);
        }

        private int nextRoot() throws CorruptDataException {
            if (this.liveStack == this.startStack) {
                if (this.exceptionsToWalk != 0) {
                    J9ExceptionHandlerPointer handler = ROMHelp.J9EXCEPTIONINFO_HANDLERS(this.exceptionData);
                    this.liveStack.reset();
                    this.PUSH((byte)1);
                    while (this.exceptionsToWalk > 0) {
                        this.pushStack(handler.add(--this.exceptionsToWalk).handlerPC().intValue());
                    }
                } else {
                    return -5;
                }
            }
            this.popStack();
            return 0;
        }

        public byte POP() throws CorruptDataException {
            logger.logp(Level.FINEST, "StackMap_V1", "POP", "POP()");
            return this.liveStack.POP();
        }

        private void PUSH(int o) throws CorruptDataException {
            this.PUSH((byte)o);
        }

        public void PUSH(byte o) throws CorruptDataException {
            logger.logp(Level.FINEST, "StackMap_V1", "PUSH", "PUSH({0})", o);
            this.liveStack.PUSH(o);
        }

        private int outputStackMap(int[] resultsArray, int bits) throws CorruptDataException {
            int stackSize = this.resultStack.stackSize();
            if (stackSize > 0 && resultsArray != null) {
                for (int i = 0; i < stackSize - bits; ++i) {
                    this.resultStack.POP();
                }
                int writePointer = bits - 1 >> 5;
                resultsArray[writePointer] = 0;
                while (true) {
                    int n = writePointer;
                    resultsArray[n] = resultsArray[n] << 1;
                    if (this.resultStack.POP() == 1) {
                        int n2 = writePointer;
                        resultsArray[n2] = resultsArray[n2] | 1;
                    }
                    if (--bits == 0) break;
                    if ((bits & 0x1F) != 0) continue;
                    resultsArray[++writePointer] = 0;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("outputStackMap. bits = ");
                buffer.append(bits);
                buffer.append(" resultsArray size = " + resultsArray.length);
                buffer.append(" result: ");
                for (int i = 0; i < resultsArray.length; ++i) {
                    buffer.append(Integer.toHexString(resultsArray[i]));
                }
                logger.logp(Level.FINE, "StackMap_V1", "outputStackMap", buffer.toString());
            }
            return stackSize;
        }
    }

    private static class J9MappingStack {
        public int pc;
        private int topOfStack = 0;
        private byte[] stack;

        public J9MappingStack(int stackSize) {
            this.stack = new byte[stackSize];
        }

        public J9MappingStack(J9MappingStack toClone) {
            this.stack = new byte[toClone.stack.length];
            System.arraycopy(toClone.stack, 0, this.stack, 0, toClone.topOfStack);
            this.topOfStack = toClone.topOfStack;
        }

        public void PUSH(byte value) throws CorruptDataException {
            if (this.topOfStack >= this.stack.length) {
                throw new CorruptDataException("Operand stack overflow. Stack size = " + this.stack.length + ", top of stack " + this.topOfStack);
            }
            this.stack[this.topOfStack++] = value;
        }

        public byte POP() throws CorruptDataException {
            if (this.topOfStack == 0) {
                throw new CorruptDataException("Operand stack underflow in StackMap");
            }
            return this.stack[--this.topOfStack];
        }

        public void reset() {
            this.topOfStack = 0;
        }

        public int stackSize() {
            return this.topOfStack;
        }
    }
}

