/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ig extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Oge Etiti Afr\u1ecbka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Oge Izugbe Moscow",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Moscow",
               "",
               "Oge Moscow",
               "",
            };
        final String[] Japan = new String[] {
               "Oge Izugbe Japan",
               "",
               "Oge Ihe Japan",
               "",
               "Oge Japan",
               "",
            };
        final String[] Pakistan = new String[] {
               "Oge Izugbe Pakistan",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Pakistan",
               "",
               "Oge Pakistan",
               "",
            };
        final String[] Taipei = new String[] {
               "Oge Izugbe Taipei",
               "",
               "Oge Ihe Taipei",
               "",
               "Oge Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "Oge Izugbe Hovd",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Hovd",
               "",
               "Oge Hovd",
               "",
            };
        final String[] Magadan = new String[] {
               "Oge Izugbe Magadan",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Magadan",
               "",
               "Oge Magadan",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Etiti Australia",
               "",
               "Oge Ihe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Etiti Australia",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Etiti Australia",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Oge Izugbe Mpaghara Etiti Europe",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara Etiti Europe",
               "",
               "Oge Mpaghara Etiti Europe",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Oge Izugbe Sakhalin",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Sakhalin",
               "",
               "Oge Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Oge Izugbe Paraguay",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Paraguay",
               "",
               "Oge Paraguay",
               "",
            };
        final String[] Malaysia = new String[] {
               "Oge Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5",
               "",
               "Oge Ihe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5",
               "",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Oge Izugbe Lord Howe",
               "",
               "Oge Ihe Lord Howe",
               "",
               "Oge Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Oge Izugbe New Zealand",
               "",
               "Oge Ihe New Zealand",
               "",
               "Oge New Zealand",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Oge Osimiri India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Oge Izugbe Yakutsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Yakutsk",
               "",
               "Oge Yakutsk",
               "",
            };
        final String[] Mauritius = new String[] {
               "Oge Izugbe Mauritius",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mauritius",
               "",
               "Oge Mauritius",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Afr\u1ecbka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Timor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Oge Solomon Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Oge Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Oge Marshall Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe",
               "",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Europe",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Oge Izugbe Newfoundland",
               "",
               "Oge Ihe Newfoundland",
               "",
               "Oge Newfoundland",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Oge Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Oge Izugbe Hong Kong",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Hong Kong",
               "",
               "Oge Hong Kong",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Argentina",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Argentina",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Argentina",
               "",
            };
        final String[] Atlantic = new String[] {
               "Oge Izugbe Mpaghara Atlantic",
               "",
               "Oge Ihe Mpaghara Atlantic",
               "",
               "Oge Mpaghara Atlantic",
               "",
            };
        final String[] Ponape = new String[] {
               "Oge Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Oge Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Oge Izugbe St. Pierre & Miquelon",
               "",
               "Oge Ihe St. Pierre & Miquelon",
               "",
               "Oge St. Pierre & Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Oge Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Oge Izugbe Yekaterinburg",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Yekaterinburg",
               "",
               "Oge Yekaterinburg",
               "",
            };
        final String[] Maldives = new String[] {
               "Oge Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Oge Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Oge Izugbe Israel",
               "",
               "Oge Ihe Israel",
               "",
               "Oge Israel",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Oge Etiti Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Oge Wallis & Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Oge Izugbe Mpaghara Mgbada Ugwu Afr\u1ecbka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Oge Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Oge Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Oge Izugbe Uzbekist",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Uzbekist",
               "",
               "Oge Uzbekist",
               "",
            };
        final String[] Omsk = new String[] {
               "Oge Izugbe Omsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Omsk",
               "",
               "Oge Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Oge Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Oge Izugbe Uruguay",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Uruguay",
               "",
               "Oge Uruguay",
               "",
            };
        final String[] Nepal = new String[] {
               "Oge Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Oge Izugbe Ulaanbaatar",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Ulaanbaatar",
               "",
               "Oge Ulaanbaatar",
               "",
            };
        final String[] America_Central = new String[] {
               "Oge Izugbe Mpaghara Etiti",
               "",
               "Oge Ihe Mpaghara Etiti",
               "",
               "Oge Mpaghara Etiti",
               "",
            };
        final String[] Truk = new String[] {
               "Oge Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "Oge Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Oge Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Oge Izugbe Falkland Islands",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Falkland Islands",
               "",
               "Oge Falkland Islands",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Oge Izugbe Vanuatu",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Vanuatu",
               "",
               "Oge Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Oge Izugbe Novosibirsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Novosibirsk",
               "",
               "Oge Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Oge Izugbe Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Oge Izugbe Azores",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Azores",
               "",
               "Oge Azores",
               "",
            };
        final String[] Apia = new String[] {
               "Oge Izugbe Apia",
               "",
               "Oge Ihe Apia",
               "",
               "Oge Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "Oge Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Oge Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Oge Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Oge Izugbe Krasnoyarsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Krasnoyarsk",
               "",
               "Oge Krasnoyarsk",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "Oge Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Oge Ekeresimesi Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Oge Izugbe Amazon",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Amazon",
               "",
               "Oge Amazon",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Oge Izugbe Fiji",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Fiji",
               "",
               "Oge Fiji",
               "",
            };
        final String[] Reunion = new String[] {
               "Oge R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Oge Cocos Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Oge Izugbe Chatham",
               "",
               "Oge Ihe Chatham",
               "",
               "Oge Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "Oge Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Oge Izugbe Argentina",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Argentina",
               "",
               "Oge Argentina",
               "",
            };
        final String[] Gambier = new String[] {
               "Oge Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Oge Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Oge Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Oge Macquarie Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Oge Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Oge Izugbe Hawaii-Aleutian",
               "",
               "Oge Ihe Hawaii-Aleutian",
               "",
               "Oge Hawaii-Aleutian",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Oge Izugbe Etiti Australia",
               "",
               "Oge Ihe Etiti Australia",
               "",
               "Oge Etiti Australia",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Oge Izugbe Mpaghara Pacific",
               "",
               "Oge Ihe Mpaghara Pacific",
               "",
               "Oge Mpaghara Pacific",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Oge Phoenix Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Oge Izugbe Turkmenist",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Turkmenist",
               "",
               "Oge Turkmenist",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Europe",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Oge Izugbe Cape Verde",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Cape Verde",
               "",
               "Oge Cape Verde",
               "",
            };
        final String[] Norfolk = new String[] {
               "Oge Norfolk Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "Oge Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Oge Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Oge Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Oge Izugbe Samoa",
               "",
               "Oge Ihe Samoa",
               "",
               "Oge Samoa",
               "",
            };
        final String[] Palau = new String[] {
               "Oge Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Oge Izugbe Azerbaijan",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Azerbaijan",
               "",
               "Oge Azerbaijan",
               "",
            };
        final String[] Mawson = new String[] {
               "Oge Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Oge Izugbe Mexican Pacific",
               "",
               "Oge Ihe Mexican Pacific",
               "",
               "Oge Mexican Pacific",
               "",
            };
        final String[] Davis = new String[] {
               "Oge Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Oge Izugbe Cuba",
               "",
               "Oge Ihe Mpaghara Cuba",
               "",
               "Oge Cuba",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Afr\u1ecbka",
               "",
            };
        final String[] GMT = new String[] {
               "Oge Mpaghara Greemwich Mean",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Oge Izugbe Philippine",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Philippine",
               "",
               "Oge Philippine",
               "",
            };
        final String[] French_Southern = new String[] {
               "Oge French Southern & Antarctic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Oge South Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Oge Izugbe New Caledonia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 New Caledonia",
               "",
               "Oge New Caledonia",
               "",
            };
        final String[] Volgograd = new String[] {
               "Oge Izugbe Volgograd",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Volgograd",
               "",
               "Oge Volgograd",
               "",
            };
        final String[] Brunei = new String[] {
               "Oge Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Oge Izugbe Iran",
               "",
               "Oge Ihe Iran",
               "",
               "Oge Iran",
               "",
            };
        final String[] Easter = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Island",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Island",
               "",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Island",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Oge Izugbe Northwest Mexico",
               "",
               "Oge Ihe Northwest Mexico",
               "",
               "Oge Northwest Mexico",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Oge Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Oge Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Oge Izugbe Tonga",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Tonga",
               "",
               "Oge Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Oge Izugbe Bangladesh",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Bangladesh",
               "",
               "Oge Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "Oge Izugbe Peru",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Peru",
               "",
               "Oge Peru",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Greenland",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Greenland",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Greenland",
               "",
            };
        final String[] Ecuador = new String[] {
               "Oge Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Greenland",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Greenland",
               "",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Greenland",
               "",
            };
        final String[] Gulf = new String[] {
               "Oge Izugbe Gulf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Oge Izugbe Korea",
               "",
               "Oge Ihe Korea",
               "",
               "Oge Korea",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Oge Izugbe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Australia",
               "",
               "Oge Ihe Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Australia",
               "",
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Australia",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Oge Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Oge Mpaghara \u1eccd\u1ecbda Anyanw\u1ee5 Indonesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Oge Izugbe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Australia",
               "",
               "Oge Ihe Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Australia",
               "",
               "Oge Mpaghara \u1eccw\u1ee5wa Anyanw\u1ee5 Australia",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Oge French Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Oge Izugbe Columbia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Columbia",
               "",
               "Oge Columbia",
               "",
            };
        final String[] Chile = new String[] {
               "Oge Izugbe Chile",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Chile",
               "",
               "Oge Chile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Oge Gilbert Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Oge Izugbe Mpaghara Ugwu",
               "",
               "Oge Ihe Mpaghara Ugwu",
               "",
               "Oge Mpaghara Ugwu",
               "",
            };
        final String[] Marquesas = new String[] {
               "Oge Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Oge Izugbe Arab",
               "",
               "Oge Ihe Arab",
               "",
               "Oge Arab",
               "",
            };
        final String[] Alaska = new String[] {
               "Oge Izugbe Alaska",
               "",
               "Oge Ihe Alaska",
               "",
               "Oge Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Oge Izugbe Vladivostok",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Vladivostok",
               "",
               "Oge Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Oge Izugbe Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Oge Izugbe Irkutsk",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Irkutsk",
               "",
               "Oge Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Oge Izugbe Georgia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Georgia",
               "",
               "Oge Georgia",
               "",
            };
        final String[] Tokelau = new String[] {
               "Oge Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Oge Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Oge Izugbe Fernando de Noronha",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Fernando de Noronha",
               "",
               "Oge Fernando de Noronha",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Oge Izugbe Choibals",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Choibals",
               "",
               "Oge Choibals",
               "",
            };
        final String[] Brasilia = new String[] {
               "Oge Izugbe Brasilia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Brasilia",
               "",
               "Oge Brasilia",
               "",
            };
        final String[] China = new String[] {
               "Oge Izugbe China",
               "",
               "Oge Ihe China",
               "",
               "Oge China",
               "",
            };
        final String[] Armenia = new String[] {
               "Oge Izugbe Armenia",
               "",
               "Oge Okpom\u1ecdk\u1ee5 Armenia",
               "",
               "Oge Armenia",
               "",
            };
        final String[] India = new String[] {
               "Oge Izugbe India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Oge Izugbe Cook Islands",
               "",
               "Oge \u1ecckara Okpom\u1ecdk\u1ee5 Cook Islands",
               "",
               "Oge Cook Islands",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Oge Mpaghara Greemwich Mean",
                    "",
                    "Oge Okpom\u1ecdk\u1ee5 Britain",
                    "",
                    "",
                    "",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Korea },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "Obodo Amagh\u1ecb" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Oge Mpaghara Greemwich Mean",
                    "",
                    "Oge Okpom\u1ecdk\u1ee5 Ireland",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "SystemV/CST6", America_Central },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "Africa/El_Aaiun",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Oge Mpaghara Greemwich Mean",
                    "",
                    "Oge Okpom\u1ecdk\u1ee5 Britain",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Nhazi Oge \u1ee4wa Niile",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
