/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm29.j9.gc.CorruptHintException;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIteratorAddressOrderedList;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm29.j9.gc.GCModronAllocateHintIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCModronAllocateHintIteratorAOL;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModronAllocateHintPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapLinkedFreeHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolAddressOrderedListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class GCMemoryPoolAddressOrderedList
extends GCMemoryPool {
    protected MM_HeapLinkedFreeHeaderPointer _heapFreeList;
    protected MM_MemoryPoolAddressOrderedListPointer _memoryPool;
    protected J9ModronAllocateHintPointer _hintActive = null;

    protected GCMemoryPoolAddressOrderedList(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        super(region, memoryPool);
        this.init(region, memoryPool);
    }

    private void init(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        this._memoryPoolType = GCMemoryPool.MemoryPoolType.AOL;
        this._memoryPool = MM_MemoryPoolAddressOrderedListPointer.cast(memoryPool);
        this._heapFreeList = this._memoryPool._heapFreeList();
        this._hintActive = this._memoryPool._hintActive();
    }

    public J9ModronAllocateHintPointer getFirstHint() {
        return this._hintActive;
    }

    public GCHeapLinkedFreeHeader getFirstFreeEntry() throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromLinkedFreeHeaderPointer(this._memoryPool._heapFreeList());
    }

    private void freeEntryCheck(GCHeapLinkedFreeHeader freeListEntry, GCHeapLinkedFreeHeader previousFreeEntry) throws CorruptFreeEntryException, CorruptDataException {
        MM_HeapLinkedFreeHeaderPointer freeEntryPointer = freeListEntry.getHeader();
        MM_HeapLinkedFreeHeaderPointer previousFreeEntryPointer = MM_HeapLinkedFreeHeaderPointer.NULL;
        this.freeEntryCheckGeneric(freeListEntry);
        if (null != previousFreeEntry && (previousFreeEntryPointer = previousFreeEntry.getHeader()).gte(freeEntryPointer)) {
            throw new CorruptFreeEntryException("invalidOrdering", freeEntryPointer);
        }
        if (freeListEntry.getSize().lt(GCBase.getExtensions().tlhMinimumSize())) {
            throw new CorruptFreeEntryException("sizeFieldInvalid", freeListEntry.getHeader());
        }
    }

    public GCModronAllocateHintIterator hintIterator() throws CorruptDataException {
        return new GCModronAllocateHintIteratorAOL(this);
    }

    public GCFreeListHeapIterator freeListIterator() throws CorruptDataException {
        return new GCFreeListHeapIteratorAddressOrderedList(this);
    }

    @Override
    public void checkFreeListsImpl() {
        try {
            GCFreeListHeapIterator freeEntryIterator = this.freeListIterator();
            GCHeapLinkedFreeHeader previousFreeEntry = null;
            J9ModronAllocateHintPointer hint = null;
            MM_HeapLinkedFreeHeaderPointer freeEntryFromHint = null;
            List hints = IteratorHelpers.toList(this.hintIterator());
            Collections.sort(hints, new Comparator<J9ModronAllocateHintPointer>(){

                @Override
                public int compare(J9ModronAllocateHintPointer o1, J9ModronAllocateHintPointer o2) {
                    try {
                        if (o2.heapFreeHeader().gt(o1.heapFreeHeader())) {
                            return -1;
                        }
                        if (o2.heapFreeHeader().eq(o1.heapFreeHeader())) {
                            return 0;
                        }
                        return 1;
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Corruption detected in image", e, false);
                        throw new UnsupportedOperationException("Unreachable");
                    }
                }
            });
            Iterator allocHintIterator = hints.iterator();
            if (allocHintIterator.hasNext()) {
                hint = (J9ModronAllocateHintPointer)allocHintIterator.next();
                freeEntryFromHint = hint.heapFreeHeader();
            }
            while (freeEntryIterator.hasNext()) {
                GCHeapLinkedFreeHeader freeListEntry = freeEntryIterator.next();
                try {
                    this.freeEntryCheck(freeListEntry, previousFreeEntry);
                    previousFreeEntry = freeListEntry;
                }
                catch (CorruptFreeEntryException e) {
                    EventManager.raiseCorruptDataEvent("Free list corruption detected", e, false);
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("Corruption detected in image", e, false);
                }
                MM_HeapLinkedFreeHeaderPointer freeListEntryPointer = freeListEntry.getHeader();
                while (null != freeEntryFromHint && freeEntryFromHint.lte(freeListEntryPointer)) {
                    if (freeEntryFromHint.lt(freeListEntryPointer)) {
                        EventManager.raiseCorruptDataEvent("Hint corruption detected", new CorruptHintException("allocHintFreeEntryCorrupt", hint), false);
                        continue;
                    }
                    if (allocHintIterator.hasNext()) {
                        hint = (J9ModronAllocateHintPointer)allocHintIterator.next();
                        freeEntryFromHint = hint.heapFreeHeader();
                        continue;
                    }
                    freeEntryFromHint = null;
                }
            }
            if (null != freeEntryFromHint) {
                EventManager.raiseCorruptDataEvent("Hint corruption detected ", new CorruptHintException("allocHintFreeEntryCorrupt", hint), false);
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Data corruption detected while validating freelists", e, false);
        }
    }
}

