/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.AVLTree;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.IAVLSearchComparator;
import com.ibm.j9ddr.vm29.j9.Pool;
import com.ibm.j9ddr.vm29.j9.SlotIterator;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9AVLTreeNodePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9AVLTreePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm29.structure.J9HashtableConstants;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

public class HashTable_V1<StructType extends AbstractPointer>
extends HashTable<StructType> {
    private static final long AVL_TREE_TAG_BIT = J9HashtableConstants.J9HASH_TABLE_AVL_TREE_TAG_BIT;
    private boolean _isInline = false;
    private AVLTreeComparatorFunction _avlTreeComparatorFunction;
    private EqualFunctionWrapper _equalFunctionWrapper;
    private boolean _isSpaceOpt;

    protected HashTable_V1(J9HashTablePointer hashTablePointer, boolean isInline, Class<StructType> structType, HashTable.HashEqualFunction<StructType> equalFn, HashTable.HashFunction<StructType> hashFn) throws CorruptDataException {
        super(hashTablePointer, structType, equalFn, hashFn, null);
        this._equalFunctionWrapper = new EqualFunctionWrapper();
        this._isInline = isInline;
        this._isSpaceOpt = this._table.listNodePool().isNull();
    }

    protected HashTable_V1(J9HashTablePointer hashTablePointer, boolean isInline, Class<StructType> structType, HashTable.HashFunction<StructType> hashFn, HashTable.HashComparatorFunction<StructType> comparatorFn) throws CorruptDataException {
        super(hashTablePointer, structType, null, hashFn, comparatorFn);
        this._avlTreeComparatorFunction = new AVLTreeComparatorFunction();
        this._equalFunctionWrapper = new EqualFunctionFromComparator();
        this._isInline = isInline;
        this._isSpaceOpt = this._table.listNodePool().isNull();
    }

    private VoidPointer avlNodeToData(J9AVLTreeNodePointer p) {
        return VoidPointer.cast(p.add(1L));
    }

    private J9AVLTreePointer avlTreeUntag(VoidPointer p) {
        return J9AVLTreePointer.cast(p.untag(AVL_TREE_TAG_BIT));
    }

    private PointerPointer nextEA(VoidPointer p) throws CorruptDataException {
        return PointerPointer.cast(p.addOffset(this._table.listNodeSize()).subOffset(UDATA.SIZEOF));
    }

    private boolean isAVLTreeTagged(VoidPointer p) {
        return p.allBitsIn(AVL_TREE_TAG_BIT);
    }

    public boolean isSpaceOpt() {
        return this._isSpaceOpt;
    }

    @Override
    public String getTableName() {
        try {
            return this._table.tableName().getCStringAtOffset(0L);
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting name", e, true);
            return null;
        }
    }

    @Override
    public long getCount() {
        try {
            return this._table.numberOfNodes().longValue();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting table count", e, true);
            return 0L;
        }
    }

    @Override
    public StructType find(StructType entry) throws CorruptDataException {
        AbstractPointer node;
        UDATA hash = this._hashFn.hash(entry).mod(this._table.tableSize());
        PointerPointer head = this._table.nodes().add(hash);
        VoidPointer findNode = VoidPointer.NULL;
        findNode = this._table.listNodePool().isNull() ? ((node = this.hashTableFindNodeSpaceOpt(this._table, entry, head)).at(0L).notNull() ? VoidPointer.cast(node) : VoidPointer.NULL) : (head.at(0L).isNull() ? VoidPointer.NULL : (this.isAVLTreeTagged(head.at(0L)) ? this.hashTableFindNodeInTree(this._table, entry, head) : this.hashTableFindNodeInList(this._table, entry, head)));
        if (!this._isInline && findNode.notNull()) {
            findNode = PointerPointer.cast(findNode).at(0L);
        }
        node = (AbstractPointer)DataType.getStructure(this._structType, findNode.getAddress());
        return (StructType)node;
    }

    private PointerPointer hashTableFindNodeSpaceOpt(J9HashTablePointer table, StructType entry, PointerPointer head) throws CorruptDataException {
        PointerPointer node = head;
        AbstractPointer nodeStruct = (AbstractPointer)DataType.getStructure(this._structType, node.getAddress());
        while (node.at(0L).notNull() && !this._equalFunctionWrapper.equal(nodeStruct, entry)) {
            if ((node = node.add(1L)) == table.nodes().add(table.tableSize())) {
                node = table.nodes();
            }
            nodeStruct = (AbstractPointer)DataType.getStructure(this._structType, node.getAddress());
        }
        return node;
    }

    private VoidPointer hashTableFindNodeInTree(J9HashTablePointer table, StructType entry, PointerPointer head) throws CorruptDataException {
        J9AVLTreePointer tree = this.avlTreeUntag(head.at(0L));
        AVLTree avlTree = AVLTree.fromJ9AVLTreePointer(tree, this._avlTreeComparatorFunction);
        J9AVLTreeNodePointer searchResult = avlTree.search(UDATA.cast(entry));
        if (searchResult.notNull()) {
            return this.avlNodeToData(searchResult);
        }
        return VoidPointer.NULL;
    }

    private VoidPointer hashTableFindNodeInList(J9HashTablePointer table, StructType entry, PointerPointer head) throws CorruptDataException {
        VoidPointer node = head.at(0L);
        AbstractPointer currentStruct = (AbstractPointer)DataType.getStructure(this._structType, node.getAddress());
        while (!node.isNull() && !this._equalFunctionWrapper.equal(currentStruct, entry)) {
            node = this.nextEA(node).at(0L);
            currentStruct = (AbstractPointer)DataType.getStructure(this._structType, node.getAddress());
        }
        return VoidPointer.cast(currentStruct);
    }

    @Override
    public SlotIterator<StructType> iterator() {
        return new HashTableSlotIterator();
    }

    private class EqualFunctionWrapper {
        private EqualFunctionWrapper() {
        }

        public boolean equal(StructType entry1, StructType entry2) throws CorruptDataException {
            if (!HashTable_V1.this._isInline) {
                entry1 = (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, PointerPointer.cast(entry1).at(0L).longValue());
            }
            return HashTable_V1.this._equalFn.equal(entry1, entry2);
        }
    }

    private class AVLTreeComparatorFunction
    implements IAVLSearchComparator {
        private AVLTreeComparatorFunction() {
        }

        @Override
        public int searchComparator(J9AVLTreePointer tree, UDATA searchValue, J9AVLTreeNodePointer node) throws CorruptDataException {
            VoidPointer data = HashTable_V1.this.avlNodeToData(node);
            AbstractPointer node1 = (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, searchValue.longValue());
            AbstractPointer node2 = null;
            node2 = HashTable_V1.this._isInline ? (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, data.longValue()) : (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, PointerPointer.cast(data).at(0L).longValue());
            return HashTable_V1.this._comparatorFn.compare(node1, node2);
        }
    }

    private class EqualFunctionFromComparator
    extends EqualFunctionWrapper {
        private EqualFunctionFromComparator() {
        }

        @Override
        public boolean equal(StructType entry1, StructType entry2) throws CorruptDataException {
            if (!HashTable_V1.this._isInline) {
                entry1 = (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType, PointerPointer.cast(entry1).at(0L).longValue());
            }
            return 0 == HashTable_V1.this._comparatorFn.compare(entry1, entry2);
        }
    }

    private final class HashTableSlotIterator
    implements SlotIterator<StructType> {
        private SlotIterator<PointerPointer> listPoolIterator;
        private SlotIterator<J9AVLTreeNodePointer> treePoolIterator;
        private PointerPointer _spaceOptNode;
        private PointerPointer _tableTop;

        public HashTableSlotIterator() {
            block10: {
                this.listPoolIterator = null;
                this.treePoolIterator = null;
                this._spaceOptNode = null;
                if (!HashTable_V1.this.isSpaceOpt()) {
                    try {
                        this.listPoolIterator = Pool.fromJ9Pool(HashTable_V1.this._table.listNodePool(), PointerPointer.class).iterator();
                    }
                    catch (CorruptDataException cde) {
                        EventManager.raiseCorruptDataEvent("Error getting ListNodePool iterator", cde, false);
                    }
                    try {
                        J9PoolPointer treeNodePool = HashTable_V1.this._table.treeNodePool();
                        if (treeNodePool.notNull()) {
                            this.treePoolIterator = Pool.fromJ9Pool(treeNodePool, J9AVLTreeNodePointer.class).iterator();
                            break block10;
                        }
                        this.treePoolIterator = null;
                    }
                    catch (CorruptDataException cde) {
                        EventManager.raiseCorruptDataEvent("Error getting TreeNodePool iterator", cde, false);
                    }
                } else {
                    try {
                        this._spaceOptNode = HashTable_V1.this._table.nodes();
                        this._tableTop = HashTable_V1.this._table.nodes().add(HashTable_V1.this._table.tableSize());
                        if (this._spaceOptNode.isNull()) {
                            throw new CorruptDataException("Hashtable nodes pointer is null");
                        }
                        this.nextSpaceOpt();
                    }
                    catch (CorruptDataException cde) {
                        EventManager.raiseCorruptDataEvent("Error initializing space optimized hashtable", cde, true);
                    }
                }
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = false;
            if (null != this.listPoolIterator && this.listPoolIterator.hasNext()) {
                hasNext = true;
            } else if (null != this.treePoolIterator && this.treePoolIterator.hasNext()) {
                hasNext = true;
            } else if (HashTable_V1.this.isSpaceOpt() && this._spaceOptNode.lt(this._tableTop)) {
                hasNext = true;
            }
            return hasNext;
        }

        @Override
        public StructType next() {
            PointerPointer data = null;
            AbstractPointer result = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more available elements");
            }
            if (HashTable_V1.this.isSpaceOpt()) {
                data = this._spaceOptNode;
                this._spaceOptNode = this._spaceOptNode.add(1L);
                try {
                    this.nextSpaceOpt();
                }
                catch (CorruptDataException cde) {
                    EventManager.raiseCorruptDataEvent("Hashtable nodes corrupted", cde, true);
                }
            } else if (this.listPoolIterator.hasNext()) {
                data = (PointerPointer)this.listPoolIterator.next();
            } else if (this.treePoolIterator.hasNext()) {
                J9AVLTreeNodePointer node = (J9AVLTreeNodePointer)this.treePoolIterator.next();
                data = PointerPointer.cast(HashTable_V1.this.avlNodeToData(node));
            }
            try {
                result = HashTable_V1.this._isInline ? (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType.getSimpleName(), data.getAddress()) : (AbstractPointer)DataType.getStructure(HashTable_V1.this._structType.getSimpleName(), PointerPointer.cast(data).at(0L).getAddress());
            }
            catch (CorruptDataException cde) {
                EventManager.raiseCorruptDataEvent("Pool element corrupted", cde, true);
            }
            return result;
        }

        @Override
        public VoidPointer nextAddress() {
            if (HashTable_V1.this._isInline) {
                throw new UnsupportedOperationException("Not supported.");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more available elements");
            }
            VoidPointer next = null;
            if (HashTable_V1.this.isSpaceOpt()) {
                next = VoidPointer.cast(this._spaceOptNode);
                this._spaceOptNode = this._spaceOptNode.add(1L);
                try {
                    this.nextSpaceOpt();
                }
                catch (CorruptDataException cde) {
                    EventManager.raiseCorruptDataEvent("Hashtable nodes corrupted", cde, true);
                }
            } else if (this.listPoolIterator.hasNext()) {
                next = this.listPoolIterator.nextAddress();
            } else if (this.treePoolIterator.hasNext()) {
                next = HashTable_V1.this.avlNodeToData((J9AVLTreeNodePointer)this.treePoolIterator.next());
            } else {
                throw new NoSuchElementException("There are no more available elements");
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The J9HashTable is read only and cannot be modified.");
        }

        private void nextSpaceOpt() throws CorruptDataException {
            while (this._spaceOptNode.lt(this._tableTop) && this._spaceOptNode.at(0L).isNull()) {
                this._spaceOptNode = this._spaceOptNode.add(1L);
            }
        }
    }
}

