/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;

public abstract class BaseMemoryRange
implements IMemoryRange {
    private final boolean fastPathContains;
    private int alignment;
    private long baseAddressTestValue;
    protected final long baseAddress;
    protected final long size;

    protected BaseMemoryRange(long baseAddress, long size) {
        this.baseAddress = baseAddress;
        this.size = size;
        this.alignment = 0;
        long workingAddress = baseAddress;
        for (int i = 0; i < 64 && (workingAddress & 1L) == 0L; ++i) {
            ++this.alignment;
            workingAddress >>>= 1;
        }
        this.baseAddressTestValue = baseAddress >>> this.alignment;
        long topAddress = this.getTopAddress();
        this.fastPathContains = this.baseAddressTestValue == topAddress >>> this.alignment && this.baseAddressTestValue != topAddress + 1L >>> this.alignment;
    }

    @Override
    public boolean contains(long address) {
        if (this.fastPathContains) {
            return this.baseAddressTestValue == address >>> this.alignment;
        }
        return Addresses.greaterThanOrEqual(address, this.getBaseAddress()) && Addresses.lessThanOrEqual(address, this.getTopAddress());
    }

    @Override
    public int compareTo(IMemoryRange o) {
        if (o.getAddressSpaceId() != this.getAddressSpaceId()) {
            return this.getAddressSpaceId() - o.getAddressSpaceId();
        }
        if (Addresses.greaterThan(this.getBaseAddress(), o.getBaseAddress())) {
            return 1;
        }
        if (Addresses.lessThan(this.getBaseAddress(), o.getBaseAddress())) {
            return -1;
        }
        if (Addresses.greaterThan(this.getTopAddress(), o.getTopAddress())) {
            return 1;
        }
        if (Addresses.lessThan(this.getTopAddress(), o.getTopAddress())) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MemoryRange ");
        buffer.append(this.getClass().getName());
        buffer.append(" from ");
        buffer.append(Long.toHexString(this.getBaseAddress()));
        buffer.append(" to ");
        buffer.append(Long.toHexString(this.getTopAddress()));
        return buffer.toString();
    }

    @Override
    public boolean isSubRange(IMemoryRange other) {
        boolean baseAddressInRange = Addresses.greaterThanOrEqual(other.getBaseAddress(), this.getBaseAddress());
        boolean topAddressInRange = Addresses.greaterThanOrEqual(this.getTopAddress(), other.getTopAddress());
        return baseAddressInRange && topAddressInRange;
    }

    @Override
    public boolean overlaps(IMemoryRange other) {
        return this.contains(other.getBaseAddress()) || this.contains(other.getTopAddress()) || other.contains(this.getBaseAddress()) || other.contains(this.getTopAddress());
    }

    @Override
    public final long getBaseAddress() {
        return this.baseAddress;
    }

    @Override
    public final long getSize() {
        return this.size;
    }

    @Override
    public final long getTopAddress() {
        if (this.size == 0L) {
            return this.baseAddress;
        }
        return this.baseAddress + this.size - 1L;
    }

    @Override
    public boolean isBacked() {
        return true;
    }
}

