/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.J9Heap;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=J9Heap.class)
public class J9HeapPointer
extends StructurePointer {
    public static final J9HeapPointer NULL = new J9HeapPointer(0L);

    protected J9HeapPointer(long address) {
        super(address);
    }

    public static J9HeapPointer cast(AbstractPointer structure) {
        return J9HeapPointer.cast(structure.getAddress());
    }

    public static J9HeapPointer cast(UDATA udata) {
        return J9HeapPointer.cast(udata.longValue());
    }

    public static J9HeapPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9HeapPointer(address);
    }

    @Override
    public J9HeapPointer add(long count) {
        return J9HeapPointer.cast(this.address + J9Heap.SIZEOF * count);
    }

    @Override
    public J9HeapPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9HeapPointer addOffset(long offset) {
        return J9HeapPointer.cast(this.address + offset);
    }

    @Override
    public J9HeapPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9HeapPointer sub(long count) {
        return J9HeapPointer.cast(this.address - J9Heap.SIZEOF * count);
    }

    @Override
    public J9HeapPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9HeapPointer subOffset(long offset) {
        return J9HeapPointer.cast(this.address - offset);
    }

    @Override
    public J9HeapPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9HeapPointer untag(long mask) {
        return J9HeapPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9HeapPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9Heap.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_firstFreeBlockOffset_", declaredType="U64")
    public UDATA firstFreeBlock() throws CorruptDataException {
        return new U64(this.getLongAtOffset(J9Heap._firstFreeBlockOffset_));
    }

    public UDATAPointer firstFreeBlockEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Heap._firstFreeBlockOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_heapSizeOffset_", declaredType="U64")
    public UDATA heapSize() throws CorruptDataException {
        return new U64(this.getLongAtOffset(J9Heap._heapSizeOffset_));
    }

    public UDATAPointer heapSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Heap._heapSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_largestAllocSizeVisitedOffset_", declaredType="U64")
    public UDATA largestAllocSizeVisited() throws CorruptDataException {
        return new U64(this.getLongAtOffset(J9Heap._largestAllocSizeVisitedOffset_));
    }

    public UDATAPointer largestAllocSizeVisitedEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Heap._largestAllocSizeVisitedOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_lastAllocSlotOffset_", declaredType="U64")
    public UDATA lastAllocSlot() throws CorruptDataException {
        return new U64(this.getLongAtOffset(J9Heap._lastAllocSlotOffset_));
    }

    public UDATAPointer lastAllocSlotEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Heap._lastAllocSlotOffset_);
    }
}

