/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.structure.J9JavaClassFlags;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.Iterator;

public class GCClassStaticsIterator
extends GCIterator {
    Iterator<J9ObjectPointer> slotsIterator;
    Iterator<VoidPointer> addressIterator;

    protected GCClassStaticsIterator(J9ClassPointer clazz) throws CorruptDataException {
        UDATAPointer staticPtr;
        long objectStaticCount;
        ArrayList<VoidPointer> addresses;
        ArrayList<J9ObjectPointer> statics;
        block6: {
            Object romFieldIterator = null;
            statics = new ArrayList<J9ObjectPointer>();
            addresses = new ArrayList<VoidPointer>();
            objectStaticCount = clazz.romClass().objectStaticCount().longValue();
            staticPtr = clazz.ramStatics();
            if (staticPtr.isNull()) {
                objectStaticCount = 0L;
            }
            try {
                if (J9ClassHelper.extendedClassFlags(clazz).allBitsIn(J9JavaClassFlags.J9ClassReusedStatics)) {
                    objectStaticCount = 0L;
                }
            }
            catch (NoSuchFieldError e) {
                if (!J9ClassHelper.isSwappedOut(clazz) || J9ClassHelper.areExtensionsEnabled()) break block6;
                objectStaticCount = 0L;
            }
        }
        while (objectStaticCount > 0L) {
            UDATA slot = staticPtr.at(0L);
            if (!slot.eq(0L)) {
                statics.add(J9ObjectPointer.cast(slot));
                addresses.add(VoidPointer.cast(staticPtr));
            }
            staticPtr = staticPtr.add(1L);
            --objectStaticCount;
        }
        this.slotsIterator = statics.iterator();
        this.addressIterator = addresses.iterator();
    }

    public static GCClassStaticsIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassStaticsIterator(clazz);
    }

    @Override
    public boolean hasNext() {
        return this.slotsIterator.hasNext();
    }

    @Override
    public J9ObjectPointer next() {
        this.addressIterator.next();
        return this.slotsIterator.next();
    }

    @Override
    public VoidPointer nextAddress() {
        this.slotsIterator.next();
        return this.addressIterator.next();
    }
}

