/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.J9FileImageInputStream;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.j9ddr.corereaders.CoreReader;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.util.WeakValueMap;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class J9DDRImageFactory
implements ImageFactory {
    public static final int DTFJ_MAJOR_VERSION = 1;
    public static final int DTFJ_MINOR_VERSION = 11;
    public static final int DTFJ_MODIFICATION_LEVEL = 28001;
    private static WeakValueMap<File, J9DDRImage> imageMap = new WeakValueMap();

    public int getDTFJMajorVersion() {
        return 1;
    }

    public int getDTFJMinorVersion() {
        return 11;
    }

    public int getDTFJModificationLevel() {
        return 28001;
    }

    public Image[] getImagesFromArchive(File archive, boolean extract) throws IOException {
        return new Image[0];
    }

    public Image getImage(ImageInputStream in, ImageInputStream meta, URI sourceID) throws IOException {
        ICore reader;
        Logger coreLogger = Logger.getLogger("j9ddr.core_readers");
        Logger ddrLogger = Logger.getLogger("j9ddr.view.dtfj");
        coreLogger.setParent(ddrLogger);
        if (ddrLogger.getLevel() == null && coreLogger.getLevel() == null) {
            coreLogger.setLevel(Level.SEVERE);
        }
        if ((reader = CoreReader.readCoreFile(in)) == null) {
            return null;
        }
        return new J9DDRImage(sourceID, reader, meta);
    }

    public Image getImage(File core) throws IOException {
        ICore reader;
        J9DDRImage cachedImage = imageMap.get(core.getAbsoluteFile());
        if (cachedImage != null && !cachedImage.isClosed()) {
            return cachedImage;
        }
        Logger coreLogger = Logger.getLogger("j9ddr.core_readers");
        Logger ddrLogger = Logger.getLogger("j9ddr.view.dtfj");
        coreLogger.setParent(ddrLogger);
        if (ddrLogger.getLevel() == null && coreLogger.getLevel() == null) {
            coreLogger.setLevel(Level.SEVERE);
        }
        if ((reader = CoreReader.readCoreFile(core.getPath())) == null) {
            return null;
        }
        cachedImage = new J9DDRImage(core.toURI(), reader, null);
        imageMap.put(core.getAbsoluteFile(), cachedImage);
        return cachedImage;
    }

    public Image getImage(ImageInputStream in, URI sourceID) throws IOException {
        return this.getImage(in, null, sourceID);
    }

    public Image getImage(File core, File metadata) throws IOException {
        if (FileManager.isArchive((File)metadata)) {
            ManagedImageSource source = new ManagedImageSource(core.getName(), ImageSourceType.CORE);
            source.setArchive(metadata);
            source.setExtractedTo(core);
            source.setPath(core.getAbsolutePath());
            J9FileImageInputStream in = new J9FileImageInputStream(core, source);
            return this.getImage((ImageInputStream)in, null, source.getURIOfExtractedFile());
        }
        return this.getImage(core);
    }
}

