/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.plugins;

import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PluginCommand
extends Command {
    private static final String COMMAND_NAME = "!plugins";
    private static final String COMMAND_LIST = "list";
    private static final String COMMAND_RELOAD = "reload";
    private static final String COMMAND_SHOWPATH = "showpath";
    private static final String COMMAND_SETPATH = "setpath";
    private static final String COMMAND_HELP = "help";
    private static final String COMMAND_HELP_QMARK = "?";
    private final Map<String, Method> commands = new HashMap<String, Method>();
    private Command.CommandDescription cd = null;

    public PluginCommand() {
        try {
            this.commands.put(COMMAND_LIST, this.getClass().getDeclaredMethod("commandListPlugins", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_RELOAD, this.getClass().getDeclaredMethod("commandReload", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_SHOWPATH, this.getClass().getDeclaredMethod("commandShowPath", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_SETPATH, this.getClass().getDeclaredMethod("commandSetPath", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_HELP, this.getClass().getDeclaredMethod("commandHelp", String[].class, Context.class, PrintStream.class));
            this.commands.put(COMMAND_HELP_QMARK, this.getClass().getDeclaredMethod("commandHelp", String[].class, Context.class, PrintStream.class));
        }
        catch (Exception e) {
            System.err.println("Error creating command list : " + e.getMessage());
        }
        this.cd = this.addCommand("plugins", "<subcmd>", "DDR Plugin management commands");
        this.cd.addSubCommand(COMMAND_LIST, "", "Show the list of loaded plugins for the current context");
        this.cd.addSubCommand(COMMAND_RELOAD, "", "Reload plugins for the current context");
        this.cd.addSubCommand(COMMAND_SHOWPATH, "", "Displays the current plugin search path");
        this.cd.addSubCommand(COMMAND_SETPATH, "<search path>", "Sets the current plugin search path");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length == 0) {
            out.println("\n");
            out.println("Error, all plugin commands require one or more parameters, see !plugins help for more information");
            return;
        }
        if (this.commands.containsKey(args[0])) {
            try {
                this.commands.get(args[0]).invoke((Object)this, args, context, out);
            }
            catch (InvocationTargetException e) {
                throw new DDRInteractiveCommandException(e.getCause().getMessage());
            }
            catch (Exception e) {
                throw new DDRInteractiveCommandException(e.getMessage());
            }
        } else {
            out.println("!plugins " + command + " was not recognised, run !plugins help to see all available options");
        }
    }

    private void commandListPlugins(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        DDRInteractiveClassLoader loader;
        boolean csv = false;
        if (args.length >= 2) {
            csv = args[1].equalsIgnoreCase("csv");
            out.println("id,vmversion,enabled,path,modified,exception");
        }
        if ((loader = context.getPluginClassloader()) == null) {
            out.println("No plugins are currently loaded");
            return;
        }
        ArrayList<PluginConfig> plugins = loader.getPlugins();
        ArrayList<PluginConfig> pluginFailures = loader.getPluginFailures();
        if (plugins.size() == 0 && pluginFailures.size() == 0 && !csv) {
            out.println("No plugins are currently loaded");
            return;
        }
        this.printPlugins(plugins, out, csv);
        this.printPlugins(pluginFailures, out, csv);
    }

    private void printPlugins(ArrayList<PluginConfig> plugins, PrintStream out, boolean csv) {
        for (PluginConfig plugin : plugins) {
            if (csv) {
                out.println(plugin.toCSV());
                continue;
            }
            out.println("\t" + plugin.getId());
        }
    }

    private void commandShowPath(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        Object path = System.getProperty("plugins");
        path = null == path ? (null == (path = System.getenv("com.ibm.java.diagnostics.plugins")) ? "<<warning : no plugin path has been defined>>" : (String)path + String.format(" (set from environment variable %s)", "com.ibm.java.diagnostics.plugins")) : (String)path + String.format(" (set from system property %s)", "plugins");
        out.println("DDR Plugin search path : " + (String)path);
    }

    private void commandSetPath(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 2) {
            out.println("The setpath option only takes a single parameter of the search path");
            return;
        }
        System.getProperties().setProperty("plugins", args[1]);
        out.println("Plugin search path set to : " + args[1]);
        out.println("Execute !plugins reload to scan this path for plugins");
    }

    private void commandReload(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        context.refreshCommandList();
        out.println("Plugins reloaded");
    }

    private void commandHelp(String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        this.printDetailedHelp(out);
    }
}

