/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;

public class FindInMemoryCommand
extends Command {
    private byte[] currentPattern;
    private int currentAlignment;
    private long currentAddress = -1L;
    private static final int TYPE_NONE = 0;
    private static final int TYPE_U8 = 1;
    private static final int TYPE_U16 = 2;
    private static final int TYPE_U32 = 3;
    private static final int TYPE_U64 = 4;
    private static final int TYPE_ASCII = 5;

    public FindInMemoryCommand() {
        this.addCommand("find", "<width|ascii pattern startaddr>", "Find first number or a search string in memory starting at an address");
        this.addCommand("findall", "<width|ascii pattern startaddr>", "Find all occurances of number or a search string in memory starting at an address");
        this.addCommand("findnext", "", "Find next match in the search initiated by find");
    }

    private void printHelp(PrintStream out) {
        out.append("Usage: \n");
        out.append("  !find u8|u16|u32|u64|udata|pointer 0xHEX|HEX [0xHexStartAddr|LongStartAddr]\n");
        out.append("  !find ascii <string> [0xHexStartAddr|LongStartAddr]\n");
        out.append("  !findall u8|u16|u32|u64|udata|pointer 0xHEX|HEX [0xHexStartAddr|LongStartAddr]\n");
        out.append("  !findall ascii <string> [0xHexStartAddr|LongStartAddr]\n");
        out.append("  !findnext\n");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        byte[] searchPattern;
        int alignment;
        String arg;
        IProcess process = context.process;
        boolean isLittleEndian = process.getByteOrder().equals(ByteOrder.LITTLE_ENDIAN);
        int udataSize = process.bytesPerPointer();
        int udataSearch = udataSize == 4 ? 3 : 4;
        int searchType = 0;
        boolean findAll = false;
        int argIndex = 0;
        if (command.endsWith("findnext")) {
            this.findNext(out, process);
            return;
        }
        if (command.endsWith("findall")) {
            findAll = true;
        }
        if (args.length == 0) {
            this.printHelp(out);
            return;
        }
        String searchTypeName = arg = args[argIndex++];
        if (arg.equalsIgnoreCase("u8")) {
            searchType = 1;
            alignment = 1;
        } else if (arg.equalsIgnoreCase("u16")) {
            searchType = 2;
            alignment = 2;
        } else if (arg.equalsIgnoreCase("u32")) {
            searchType = 3;
            alignment = 4;
        } else if (arg.equalsIgnoreCase("u64")) {
            searchType = 4;
            alignment = 8;
        } else if (arg.equalsIgnoreCase("udata")) {
            searchType = udataSearch;
            alignment = udataSize;
        } else if (arg.equalsIgnoreCase("pointer")) {
            searchType = udataSearch;
            alignment = udataSize;
        } else if (arg.equalsIgnoreCase("ascii")) {
            searchType = 5;
            alignment = 1;
        } else {
            this.printHelp(out);
            out.println("Unknown search type '" + searchTypeName + "'\n");
            return;
        }
        if (args.length <= argIndex) {
            this.printHelp(out);
            out.println("Expected pattern as argument " + (argIndex + 1) + "\n");
            return;
        }
        arg = args[argIndex++];
        if (searchType == 5) {
            if (arg.startsWith("\"")) {
                arg = arg.substring(1, arg.lastIndexOf(34));
            }
            try {
                searchPattern = arg.getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                searchPattern = arg.getBytes();
            }
        } else {
            int hexBytes;
            searchPattern = new byte[alignment];
            if (arg.startsWith("0x")) {
                arg = arg.substring(2);
            }
            if ((hexBytes = (arg.length() + 1) / 2) > alignment) {
                out.println("Search pattern too long for type '" + searchTypeName + "'");
                return;
            }
            arg = "0000000000000000".concat(arg);
            arg = arg.substring(arg.length() - alignment * 2);
            for (int i = 0; i < alignment; ++i) {
                int b = Integer.parseInt(arg.substring(i * 2, i * 2 + 2), 16);
                if (isLittleEndian) {
                    searchPattern[alignment - i - 1] = (byte)(b & 0xFF);
                    continue;
                }
                searchPattern[i] = (byte)(b & 0xFF);
            }
        }
        long startAddress = args.length <= argIndex ? 0L : ((arg = args[argIndex++]).startsWith("0x") ? Long.decode(arg) : Long.parseLong(arg, 16));
        this.currentAddress = startAddress;
        this.currentAlignment = alignment;
        this.currentPattern = searchPattern;
        boolean result = this.findFirst(out, process);
        if (findAll) {
            while (result) {
                result = this.findNext(out, process);
            }
        }
    }

    private boolean findNext(PrintStream out, IProcess process) {
        if (this.currentAddress == -1L) {
            out.println("No current search");
            return false;
        }
        long addr = this.currentAddress + (long)this.currentAlignment;
        long result = process.findPattern(this.currentPattern, this.currentAlignment, addr);
        if (result == -1L) {
            out.println("No more matches");
            this.currentPattern = null;
            this.currentAlignment = 1;
            this.currentAddress = -1L;
            return false;
        }
        String address = "0x" + Long.toHexString(result);
        out.println("Match found at " + address);
        this.currentAddress = result;
        return true;
    }

    private boolean findFirst(PrintStream out, IProcess process) {
        out.print("Scanning memory for ");
        for (int i = 0; i < this.currentPattern.length; ++i) {
            out.print(String.format("%02x ", this.currentPattern[i] & 0xFF));
        }
        out.println("aligned to " + this.currentAlignment + " starting from 0x" + Long.toHexString(this.currentAddress));
        long result = process.findPattern(this.currentPattern, this.currentAlignment, this.currentAddress);
        if (result == -1L) {
            out.println("Search term not found");
            this.currentPattern = null;
            this.currentAlignment = 1;
            this.currentAddress = -1L;
            return false;
        }
        String address = "0x" + Long.toHexString(result);
        out.println("Match found at " + address);
        this.currentAddress = result;
        return true;
    }
}

