/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public class StructureHeader {
    private static final String DEFAULT_J9_PACKAGE_PREFIX = "vm";
    private int coreVersion;
    private byte sizeofBool;
    private byte sizeofUDATA;
    private byte bitfieldFormat;
    private int structDataSize;
    private int stringTableDataSize;
    private int structureCount;
    private byte configVersion;
    private BlobID blobID = BlobID.J9;
    private int blobVersion;
    private String packageID = "vm";
    private final long headerSize;

    public StructureHeader(ImageInputStream ddrStream) throws IOException {
        long start = ddrStream.getStreamPosition();
        this.readCommonData(ddrStream);
        switch (this.coreVersion) {
            case 2: {
                this.readBlobVersion(ddrStream);
            }
        }
        this.headerSize = ddrStream.getStreamPosition() - start;
    }

    public StructureHeader(byte configVersion) {
        this.configVersion = configVersion;
        this.headerSize = -1L;
    }

    public StructureHeader(BlobID id, int blobVersion, String packageID) {
        this.blobID = id;
        this.blobVersion = blobVersion;
        this.packageID = packageID;
        this.headerSize = -1L;
    }

    public StructureHeader(InputStream in) {
        this.headerSize = -1L;
    }

    private void readCommonData(ImageInputStream ddrStream) throws IOException {
        ddrStream.mark();
        this.coreVersion = ddrStream.readInt();
        if (this.coreVersion > 65535) {
            if (ddrStream.getByteOrder() == ByteOrder.BIG_ENDIAN) {
                ddrStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            } else {
                ddrStream.setByteOrder(ByteOrder.BIG_ENDIAN);
            }
            ddrStream.reset();
            this.coreVersion = ddrStream.readInt();
        }
        this.sizeofBool = ddrStream.readByte();
        this.sizeofUDATA = ddrStream.readByte();
        this.bitfieldFormat = ddrStream.readByte();
        this.configVersion = ddrStream.readByte();
        this.structDataSize = ddrStream.readInt();
        this.stringTableDataSize = ddrStream.readInt();
        this.structureCount = ddrStream.readInt();
    }

    public void readBlobVersion(ImageInputStream ddrStream) throws IOException {
        switch (this.configVersion) {
            case 1: {
                int id = ddrStream.readInt();
                this.blobID = id >= BlobID.unknown.ordinal() ? BlobID.unknown : BlobID.values()[id];
                this.blobVersion = ddrStream.readInt();
                StringBuilder builder = new StringBuilder();
                boolean terminated = false;
                for (int i = 0; i < 32; ++i) {
                    char c = (char)ddrStream.readByte();
                    if (c == '\u0000') {
                        terminated |= terminated;
                        continue;
                    }
                    if (terminated) continue;
                    builder.append(c);
                }
                this.packageID = builder.toString();
                break;
            }
            default: {
                throw new IOException("Blob config version " + this.configVersion + " is not supported");
            }
        }
    }

    public int getCoreVersion() {
        return this.coreVersion;
    }

    public byte getSizeofBool() {
        return this.sizeofBool;
    }

    public byte getSizeofUDATA() {
        return this.sizeofUDATA;
    }

    public byte getBitfieldFormat() {
        return this.bitfieldFormat;
    }

    public int getStructDataSize() {
        return this.structDataSize;
    }

    public int getStringTableDataSize() {
        return this.stringTableDataSize;
    }

    public int getStructureCount() {
        return this.structureCount;
    }

    public byte getConfigVersion() {
        return this.configVersion;
    }

    public BlobID getBlobID() {
        return this.blobID;
    }

    public int getBlobVersion() {
        return this.blobVersion;
    }

    public int[] getBlobVersionArray() {
        int[] data = new int[]{this.blobVersion & 0xFF, this.blobVersion >> 8 & 0xFF, this.blobVersion >> 16 & 0xFF, this.blobVersion >> 24 & 0xFF};
        return data;
    }

    public String getPackageID() {
        return this.packageID;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }

    public static enum BlobID {
        J9("IBM J9 VM"),
        node("node.js"),
        unknown("unknown");

        private final String name;

        private BlobID(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

