/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import java.io.DataOutput;
import java.io.IOException;

public class LongPrimitiveArrayRecord
extends PortableHeapDumpRecord {
    private final int _type;
    private final int _numberOfElements;
    private final int _hashCode;
    private final boolean _is64Bit;
    private final long _instanceSize;
    private final boolean _is32BitHash;

    public LongPrimitiveArrayRecord(long l, long l2, int n, int n2, int n3, boolean bl, long l3, boolean bl2) {
        super(l, l2, null);
        this._type = n;
        this._numberOfElements = n2;
        this._hashCode = n3;
        this._is64Bit = bl;
        this._instanceSize = l3;
        this._is32BitHash = bl2;
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Unrecognised type code: " + n);
        }
    }

    @Override
    protected void writeHeapDump(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(7);
        int n = 0;
        n = (byte)(n | this._type << 5);
        byte by = PortableHeapDumpRecord.sizeofReference(this._numberOfElements);
        if (by < this._gapSize) {
            by = this._gapSize;
        }
        if (by != 0) {
            n = (byte)(n | 0x10);
        }
        n = (byte)(n | 2);
        dataOutput.writeByte(n);
        if (by > 0) {
            if (this._is64Bit) {
                dataOutput.writeLong(this._gapPreceding);
                dataOutput.writeLong(this._numberOfElements);
            } else {
                dataOutput.writeInt((int)this._gapPreceding);
                dataOutput.writeInt(this._numberOfElements);
            }
        } else {
            dataOutput.writeByte((byte)this._gapPreceding);
            dataOutput.writeByte(this._numberOfElements);
        }
        if (this._is32BitHash) {
            dataOutput.writeInt(this._hashCode);
        } else {
            dataOutput.writeShort(this._hashCode);
        }
        dataOutput.writeInt((int)(this._instanceSize / 4L));
    }
}

