/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.DTFJClass;
import com.ibm.jvm.dtfjview.commands.DTFJMethod;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionHandler {
    static final int UNKNOWN = 0;
    private static final int WORKS = 1;
    private static final int CAN_FAIL = 2;
    private static final int FAILS = 3;
    private static HashMap<String, DTFJClass> methodTable = new HashMap();
    private static IDTFJContext ctx;
    private static final Logger logger;

    public static String handleException(BaseJdmpviewCommand baseJdmpviewCommand, Throwable throwable) {
        ctx = baseJdmpviewCommand.ctx;
        StringBuffer stringBuffer = new StringBuffer();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        BaseJdmpviewCommand.ArtifactType artifactType = baseJdmpviewCommand.getArtifactType();
        String string = null;
        switch (artifactType) {
            case core: {
                string = "core";
                break;
            }
            case javacore: {
                string = "javacore";
                break;
            }
            case phd: {
                string = "phd";
                break;
            }
            default: {
                string = "Unknown artifact type";
            }
        }
        DTFJMethod dTFJMethod = ExceptionHandler.getDTFJMethod(stackTraceElementArray, baseJdmpviewCommand);
        if (throwable instanceof DataUnavailable) {
            if (dTFJMethod == null) {
                stringBuffer.append("Could not determine DTFJ class/method that caused this exception: ");
                stringBuffer.append(throwable.getLocalizedMessage());
            } else if (dTFJMethod.isSupported(artifactType) == 1) {
                stringBuffer.append(dTFJMethod.getClassName());
                stringBuffer.append(".");
                stringBuffer.append(dTFJMethod.getMethodname());
                stringBuffer.append(" should have worked for a ");
                stringBuffer.append(string);
                stringBuffer.append(" but returned: ");
                stringBuffer.append(throwable.getLocalizedMessage());
            } else if (dTFJMethod.isSupported(artifactType) == 2) {
                stringBuffer.append(dTFJMethod.getClassName());
                stringBuffer.append(".");
                stringBuffer.append(dTFJMethod.getMethodname());
                stringBuffer.append(" can fail for a ");
                stringBuffer.append(string);
                stringBuffer.append(" which is why it returned: ");
                stringBuffer.append(throwable.getLocalizedMessage());
            } else if (dTFJMethod.isSupported(artifactType) == 3) {
                stringBuffer.append(dTFJMethod.getClassName());
                stringBuffer.append(".");
                stringBuffer.append(dTFJMethod.getMethodname());
                stringBuffer.append(" is not supported for a ");
                stringBuffer.append(string);
                String string2 = throwable.getLocalizedMessage();
                if (string2 != null) {
                    stringBuffer.append(" causing: ");
                    stringBuffer.append(string2);
                }
            }
        } else if (throwable instanceof CorruptDataException) {
            CorruptData corruptData = ((CorruptDataException)throwable).getCorruptData();
            ImagePointer imagePointer = corruptData.getAddress();
            if (imagePointer == null) {
                stringBuffer.append("CorruptData found in dump at unknown address executing ");
                if (dTFJMethod == null) {
                    stringBuffer.append("an unknown class/method that caused this exception: ");
                    stringBuffer.append(throwable.getLocalizedMessage());
                } else {
                    stringBuffer.append(dTFJMethod.getClassName());
                    stringBuffer.append(".");
                    stringBuffer.append(dTFJMethod.getMethodname());
                }
            } else {
                String string3 = baseJdmpviewCommand.toHexStringAddr(imagePointer.getAddress());
                stringBuffer.append("CorruptData found in dump at address: ");
                stringBuffer.append(string3);
                stringBuffer.append(" causing: ");
                stringBuffer.append(throwable.getLocalizedMessage());
                if (dTFJMethod != null) {
                    stringBuffer.append(" executing ");
                    stringBuffer.append(dTFJMethod.getClassName());
                    stringBuffer.append(".");
                    stringBuffer.append(dTFJMethod.getMethodname());
                }
            }
        } else if (throwable instanceof MemoryAccessException) {
            stringBuffer.append(throwable.getLocalizedMessage());
        } else if (throwable instanceof IllegalArgumentException) {
            stringBuffer.append(throwable.getLocalizedMessage());
        } else {
            stringBuffer.append("==========> Unexpected exception " + throwable.getClass().getName() + " thrown: " + throwable.getLocalizedMessage());
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(stringWriter.toString());
        }
        return stringBuffer.toString();
    }

    private static DTFJMethod getDTFJMethod(StackTraceElement[] stackTraceElementArray, BaseJdmpviewCommand baseJdmpviewCommand) {
        for (int i = 0; i < 3; ++i) {
            String string = stackTraceElementArray[i].getClassName();
            String string2 = stackTraceElementArray[i].getMethodName();
            try {
                Class<?> clazz = Class.forName(string, true, ((Object)((Object)baseJdmpviewCommand)).getClass().getClassLoader());
                do {
                    DTFJMethod dTFJMethod;
                    if ((dTFJMethod = ExceptionHandler.checkInterfaces(clazz, string2)) == null) continue;
                    return dTFJMethod;
                } while ((clazz = clazz.getSuperclass()) != null);
                continue;
            }
            catch (Exception exception) {
                logger.log(Level.FINE, "Error examining stack trace to determine failing method.", exception);
            }
        }
        return null;
    }

    private static DTFJMethod checkInterfaces(Class<?> clazz, String string) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Object object;
            DTFJMethod dTFJMethod;
            String string2;
            DTFJClass dTFJClass;
            String string3 = classArray[i].getName();
            int n = string3.lastIndexOf(46);
            if ((dTFJClass = methodTable.get(string2 = string3.substring(++n))) != null && (dTFJMethod = ((DTFJClass)(object = dTFJClass)).getMethod(string)) != null) {
                return dTFJMethod;
            }
            try {
                object = Class.forName(string3, true, ctx.getAddressSpace().getClass().getClassLoader());
                dTFJMethod = ExceptionHandler.checkInterfaces(object, string);
                if (dTFJMethod == null) continue;
                return dTFJMethod;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(Level.FINE, "Error checking interfaces.", classNotFoundException);
            }
        }
        return null;
    }

    private static void init() {
        DTFJClass dTFJClass = new DTFJClass("JavaClass");
        dTFJClass.addMethod("getClassLoader", 1, 1, 1);
        dTFJClass.addMethod("getComponentType", 1, 3, 1);
        dTFJClass.addMethod("getConstantPoolReference", 1, 3, 1);
        dTFJClass.addMethod("getDeclaredFields", 1, 3, 1);
        dTFJClass.addMethod("getDeclaredMethods", 1, 3, 1);
        dTFJClass.addMethod("getInterfaces", 1, 3, 1);
        dTFJClass.addMethod("getModifiers", 1, 3, 1);
        dTFJClass.addMethod("getName", 1, 1, 1);
        dTFJClass.addMethod("getObject", 1, 1, 1);
        dTFJClass.addMethod("getReferences", 1, 3, 1);
        dTFJClass.addMethod("getSuperclass", 1, 3, 1);
        methodTable.put("JavaClass", dTFJClass);
        DTFJClass dTFJClass2 = new DTFJClass("JavaClassLoader");
        dTFJClass2.addMethod("findClass", 1, 1, 1);
        dTFJClass2.addMethod("getCachedClasses", 1, 1, 1);
        dTFJClass2.addMethod("getDefinedClasses", 1, 1, 1);
        dTFJClass2.addMethod("getObject", 1, 1, 1);
        methodTable.put("JavaClassLoader", dTFJClass2);
        DTFJClass dTFJClass3 = new DTFJClass("JavaField");
        dTFJClass3.addMethod("get", 1, 3, 3);
        dTFJClass3.addMethod("getBoolean", 1, 3, 3);
        dTFJClass3.addMethod("getByte", 1, 3, 3);
        dTFJClass3.addMethod("getChar", 1, 3, 3);
        dTFJClass3.addMethod("getDouble", 1, 3, 3);
        dTFJClass3.addMethod("getFloat", 1, 3, 3);
        dTFJClass3.addMethod("getInt", 1, 3, 3);
        dTFJClass3.addMethod("getLong", 1, 3, 3);
        dTFJClass3.addMethod("getShort", 1, 3, 3);
        dTFJClass3.addMethod("getString", 1, 3, 3);
        methodTable.put("JavaField", dTFJClass3);
        DTFJClass dTFJClass4 = new DTFJClass("JavaHeap");
        dTFJClass3.addMethod("getName", 1, 3, 1);
        dTFJClass3.addMethod("getObject", 1, 3, 1);
        dTFJClass3.addMethod("getSections", 1, 1, 1);
        methodTable.put("JavaHeap", dTFJClass4);
        DTFJClass dTFJClass5 = new DTFJClass("JavaLocation");
        dTFJClass5.addMethod("getAddress", 1, 3, 3);
        dTFJClass5.addMethod("getCompilationLevel", 1, 3, 3);
        dTFJClass5.addMethod("getFilename", 1, 3, 3);
        dTFJClass5.addMethod("getLineNumber", 2, 3, 3);
        dTFJClass5.addMethod("getMethod", 1, 3, 3);
        methodTable.put("JavaLocation", dTFJClass5);
        DTFJClass dTFJClass6 = new DTFJClass("JavaMember");
        dTFJClass6.addMethod("getDeclaringClass", 1, 3, 3);
        dTFJClass6.addMethod("getModifiers", 1, 3, 3);
        dTFJClass6.addMethod("getName", 1, 3, 3);
        dTFJClass6.addMethod("getSignature", 1, 3, 3);
        methodTable.put("JavaMember", dTFJClass6);
        DTFJClass dTFJClass7 = new DTFJClass("JavaMethod");
        dTFJClass7.addMethod("getBytecodeSections", 1, 3, 3);
        dTFJClass7.addMethod("getCompiledSections", 1, 3, 3);
        methodTable.put("JavaMethod", dTFJClass7);
        DTFJClass dTFJClass8 = new DTFJClass("JavaMonitor");
        dTFJClass8.addMethod("getEnterWaiters", 1, 1, 3);
        dTFJClass8.addMethod("getName", 1, 1, 3);
        dTFJClass8.addMethod("getNotifyWaiters", 1, 1, 3);
        dTFJClass8.addMethod("getOwner", 1, 1, 3);
        methodTable.put("JavaMonitor", dTFJClass8);
        DTFJClass dTFJClass9 = new DTFJClass("JavaObject");
        dTFJClass9.addMethod("arrayCopy", 1, 3, 1);
        dTFJClass9.addMethod("getArraySize", 1, 3, 1);
        dTFJClass9.addMethod("getHashcode", 1, 3, 1);
        dTFJClass9.addMethod("getHeap", 1, 3, 1);
        dTFJClass9.addMethod("getJavaClass", 1, 3, 1);
        dTFJClass9.addMethod("getPersistentHashcode", 1, 3, 1);
        dTFJClass9.addMethod("getReferences", 1, 3, 1);
        dTFJClass9.addMethod("getSections", 1, 3, 1);
        dTFJClass9.addMethod("getSize", 1, 3, 1);
        dTFJClass9.addMethod("isArray", 1, 3, 1);
        methodTable.put("JavaObject", dTFJClass9);
        DTFJClass dTFJClass10 = new DTFJClass("JavaReference");
        dTFJClass10.addMethod("getReachability", 1, 3, 1);
        dTFJClass10.addMethod("getReferenceType", 1, 3, 1);
        dTFJClass10.addMethod("getRootType", 1, 3, 1);
        dTFJClass10.addMethod("getSource", 1, 3, 1);
        dTFJClass10.addMethod("getTarget", 1, 3, 1);
        dTFJClass10.addMethod("isClassReference", 1, 3, 1);
        dTFJClass10.addMethod("isObjectReference", 1, 3, 1);
        methodTable.put("JavaReference", dTFJClass10);
        DTFJClass dTFJClass11 = new DTFJClass("JavaRuntime");
        dTFJClass11.addMethod("getJavaVM", 1, 3, 1);
        dTFJClass11.addMethod("getJavaVMInitArgs", 1, 1, 3);
        dTFJClass11.addMethod("getObjectAtAddress", 1, 3, 1);
        dTFJClass11.addMethod("getTraceBuffer", 3, 3, 3);
        methodTable.put("JavaRuntime", dTFJClass11);
        DTFJClass dTFJClass12 = new DTFJClass("JavaStackFrame");
        dTFJClass12.addMethod("getBasePointer", 1, 1, 3);
        dTFJClass12.addMethod("getLocation", 1, 1, 3);
        methodTable.put("JavaStackFrame", dTFJClass12);
        DTFJClass dTFJClass13 = new DTFJClass("JavaThread");
        dTFJClass13.addMethod("getImageThread", 1, 1, 3);
        dTFJClass13.addMethod("getJNIEnv", 1, 1, 3);
        dTFJClass13.addMethod("getName", 1, 1, 3);
        dTFJClass13.addMethod("getObject", 1, 1, 3);
        dTFJClass13.addMethod("getPriority", 1, 1, 3);
        dTFJClass13.addMethod("getState", 1, 1, 3);
        methodTable.put("JavaThread", dTFJClass13);
        DTFJClass dTFJClass14 = new DTFJClass("JavaVMInitArgs");
        dTFJClass14.addMethod("getIgnoreUnrecognized", 1, 1, 3);
        dTFJClass14.addMethod("getOptions", 1, 1, 3);
        dTFJClass14.addMethod("getVersion", 1, 3, 3);
        methodTable.put("JavaVMInitArgs", dTFJClass14);
        DTFJClass dTFJClass15 = new DTFJClass("JavaVMOptions");
        dTFJClass15.addMethod("getExtraInfo", 1, 1, 3);
        dTFJClass15.addMethod("getOptionString", 1, 1, 3);
        methodTable.put("JavaVMOptions", dTFJClass15);
        DTFJClass dTFJClass16 = new DTFJClass("Image");
        dTFJClass16.addMethod("getCreationTime", 2, 1, 1);
        dTFJClass16.addMethod("getHostName", 1, 3, 3);
        dTFJClass16.addMethod("getInstalledMemory", 1, 3, 3);
        dTFJClass16.addMethod("getIPAddresses", 1, 1, 3);
        dTFJClass16.addMethod("getProcessorCount", 1, 1, 3);
        dTFJClass16.addMethod("getProcessorSubType", 1, 3, 3);
        dTFJClass16.addMethod("getProcessorType", 1, 3, 3);
        dTFJClass16.addMethod("getSystemSubType", 1, 1, 3);
        dTFJClass16.addMethod("getSystemType", 1, 1, 3);
        methodTable.put("Image", dTFJClass16);
        DTFJClass dTFJClass17 = new DTFJClass("ImageModule");
        dTFJClass17.addMethod("getName", 1, 1, 3);
        dTFJClass17.addMethod("getProperties", 1, 1, 3);
        dTFJClass17.addMethod("getLoadAddress", 1, 3, 3);
        dTFJClass17.addMethod("getExecutable", 1, 3, 3);
        methodTable.put("ImageModule", dTFJClass17);
        DTFJClass dTFJClass18 = new DTFJClass("ImagePointer");
        dTFJClass18.addMethod("getByteAt", 1, 3, 3);
        dTFJClass18.addMethod("getDoubleAt", 1, 3, 3);
        dTFJClass18.addMethod("getFloatAt", 1, 3, 3);
        dTFJClass18.addMethod("getIntAt", 1, 3, 3);
        dTFJClass18.addMethod("getLongAt", 1, 3, 3);
        dTFJClass18.addMethod("getPointerAt", 1, 3, 3);
        dTFJClass18.addMethod("getShortAt", 1, 3, 3);
        dTFJClass18.addMethod("isExecutable", 1, 3, 3);
        dTFJClass18.addMethod("isReadOnly", 1, 3, 3);
        dTFJClass18.addMethod("isShared", 1, 3, 3);
        methodTable.put("ImagePointer", dTFJClass18);
        DTFJClass dTFJClass19 = new DTFJClass("ImageProcess");
        dTFJClass19.addMethod("getCommandLine", 1, 1, 3);
        dTFJClass19.addMethod("getCurrentThread", 1, 3, 3);
        dTFJClass19.addMethod("getEnvironment", 1, 1, 3);
        dTFJClass19.addMethod("getExecutable", 1, 3, 3);
        dTFJClass19.addMethod("getID", 1, 3, 3);
        dTFJClass19.addMethod("getLibraries", 1, 3, 3);
        dTFJClass19.addMethod("getSignalName", 1, 1, 3);
        dTFJClass19.addMethod("getSignalNumber", 1, 1, 3);
        methodTable.put("ImageProcess", dTFJClass19);
        DTFJClass dTFJClass20 = new DTFJClass("ImageRegister");
        dTFJClass20.addMethod("getValue", 1, 3, 3);
        methodTable.put("ImageRegister", dTFJClass20);
        DTFJClass dTFJClass21 = new DTFJClass("ImageSection");
        dTFJClass21.addMethod("isExecutable", 1, 3, 3);
        dTFJClass21.addMethod("isReadOnly", 1, 3, 3);
        dTFJClass21.addMethod("isShared", 1, 3, 3);
        methodTable.put("ImageSection", dTFJClass21);
        DTFJClass dTFJClass22 = new DTFJClass("ImageStackFrame");
        dTFJClass22.addMethod("getBasePointer", 1, 1, 3);
        dTFJClass22.addMethod("getProcedureAddress", 1, 1, 3);
        dTFJClass22.addMethod("getProcedureName", 1, 1, 3);
        methodTable.put("ImageStackFrame", dTFJClass22);
        DTFJClass dTFJClass23 = new DTFJClass("ImageThread");
        dTFJClass23.addMethod("getID", 1, 1, 3);
        dTFJClass23.addMethod("getStackFrames", 1, 1, 3);
        methodTable.put("ImageThread", dTFJClass23);
    }

    static {
        logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger.command");
        ExceptionHandler.init();
    }
}

