/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.JUCMonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.NodeList;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

@DTFJPlugin(version="1.*", runtime=false)
public class DeadlockCommand
extends BaseJdmpviewCommand {
    public DeadlockCommand() {
        this.addCommand("deadlock", "", "displays information about deadlocks if there are any");
    }

    public void run(String string, String[] stringArray, IContext iContext, PrintStream printStream) throws CommandException {
        if (this.initCommand(string, stringArray, iContext, printStream)) {
            return;
        }
        if (stringArray.length != 0) {
            printStream.println("The deadlock command does not take any parameters");
            return;
        }
        this.doCommand();
    }

    public void doCommand() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object72;
        Iterator iterator;
        Iterator iterator2;
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
        JavaRuntime javaRuntime = this.ctx.getRuntime();
        Iterator iterator3 = javaRuntime.getMonitors();
        int n = 0;
        this.out.print("\n  deadlocks for runtime \n");
        while (iterator3.hasNext()) {
            iterator2 = (JavaMonitor)iterator3.next();
            iterator = new MonitorNode((JavaMonitor)iterator2);
            object72 = null;
            object6 = null;
            try {
                object72 = iterator2.getOwner();
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("exception encountered while getting monitor owner: " + Exceptions.getCorruptDataExceptionString());
                return;
            }
            if (null == object72) continue;
            try {
                object5 = object72.getObject();
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("exception encountered while getting owner's JavaObject: " + Exceptions.getCorruptDataExceptionString());
                return;
            }
            object6 = object5.getID().getAddress();
            treeMap.put(object6, iterator);
        }
        iterator2 = javaRuntime.getThreads();
        while (iterator2.hasNext()) {
            try {
                iterator = iterator2.next();
                if (!(iterator instanceof JavaThread)) continue;
                object72 = (JavaThread)iterator;
                object6 = null;
                object5 = null;
                if ((object72.getState() & 0x200) == 0) continue;
                object4 = object72.getBlockingObject();
                object3 = new JUCMonitorNode((JavaObject)object4, javaRuntime);
                try {
                    object6 = Utils.getParkBlockerOwner((JavaObject)object4, javaRuntime);
                    if (object6 == null) {
                        continue;
                    }
                }
                catch (MemoryAccessException memoryAccessException) {
                    this.out.println("exception encountered while getting monitor owner: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                try {
                    object2 = object6.getObject();
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.println("exception encountered while getting owner's JavaObject: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                object5 = object2.getID().getAddress();
                treeMap.put(object5, object3);
            }
            catch (CorruptDataException corruptDataException) {
                this.out.println("\nwarning, corrupt data encountered during scan for java.util.concurrent locks...");
            }
            catch (DataUnavailable dataUnavailable) {
                this.out.println("\nwarning, data unavailable encountered during scan for java.util.concurrent locks...");
            }
        }
        for (Object object72 : treeMap.values()) {
            object6 = ((MonitorNode)object72).getEnterWaiters();
            while (object6.hasNext()) {
                object5 = object6.next();
                if (!(object5 instanceof JavaThread)) continue;
                object4 = (JavaThread)object5;
                object2 = null;
                try {
                    object3 = object4.getObject();
                }
                catch (CorruptDataException corruptDataException) {
                    this.out.println("exception encountered while getting waiter's ImageThread: " + Exceptions.getCorruptDataExceptionString());
                    return;
                }
                object2 = object3.getID().getAddress();
                object = (MonitorNode)treeMap.get(object2);
                if (null == object) continue;
                ((MonitorNode)object).waitingOn = object72;
            }
        }
        iterator = treeMap.values().iterator();
        int n2 = 1;
        object6 = new Vector();
        while (iterator.hasNext()) {
            object5 = (MonitorNode)iterator.next();
            object4 = object5;
            if (0 != object5.visit) continue;
            while (true) {
                ((MonitorNode)object4).visit = n2;
                if (null == ((MonitorNode)object4).waitingOn) {
                    ((MonitorNode)object4).deadlock = 1;
                    break;
                }
                if (this.isDeadlocked(((MonitorNode)object4).waitingOn)) {
                    NodeList nodeList;
                    object3 = ((MonitorNode)object4).waitingOn;
                    object4 = object5;
                    object2 = null;
                    while (object4 != object3) {
                        if (null == object2) {
                            object2 = new NodeList((MonitorNode)object4, n++);
                        }
                        ((MonitorNode)object4).deadlock = 3;
                        object4 = ((MonitorNode)object4).waitingOn;
                        ((NodeList)object2).add((MonitorNode)object4);
                        if (object4 == object3) continue;
                        ((MonitorNode)object4).inList = object2;
                    }
                    if (((MonitorNode)object3).inList.isLoop()) {
                        ((Vector)object6).insertElementAt(object2, ((Vector)object6).indexOf(((MonitorNode)object3).inList));
                        break;
                    }
                    object = ((MonitorNode)object3).inList;
                    if (null == (nodeList = ((MonitorNode)object3).inList.attachOrSplit((NodeList)object2, n++))) break;
                    ((Vector)object6).insertElementAt(nodeList, ((Vector)object6).indexOf(object));
                    ((Vector)object6).insertElementAt(object2, ((Vector)object6).indexOf(object));
                    break;
                }
                if (((MonitorNode)object4).waitingOn.visit == n2) {
                    object4 = object3 = ((MonitorNode)object4).waitingOn;
                    object2 = new NodeList((MonitorNode)object4, n++);
                    ((Vector)object6).insertElementAt(object2, 0);
                    do {
                        ((MonitorNode)object4).deadlock = 2;
                        object4 = ((MonitorNode)object4).waitingOn;
                        ((NodeList)object2).add((MonitorNode)object4);
                        ((MonitorNode)object4).inList = object2;
                    } while (object4 != object3);
                    object4 = object5;
                    object = null;
                    while (object4 != object3) {
                        if (null == object) {
                            object = new NodeList((MonitorNode)object4, n++);
                            ((Vector)object6).insertElementAt(object, 0);
                        }
                        ((MonitorNode)object4).deadlock = 3;
                        object4 = ((MonitorNode)object4).waitingOn;
                        ((NodeList)object).add((MonitorNode)object4);
                        if (object4 == object3) continue;
                        ((MonitorNode)object4).inList = object;
                    }
                    break;
                }
                object4 = ((MonitorNode)object4).waitingOn;
            }
            ++n2;
        }
        if (((Vector)object6).isEmpty()) {
            this.out.print("\n");
            this.out.print("\t no deadlocks detected");
            this.out.print("\n");
            return;
        }
        boolean bl = true;
        object4 = ((Vector)object6).iterator();
        while (object4.hasNext()) {
            object3 = (NodeList)object4.next();
            if (((NodeList)object3).isLoop()) {
                this.out.print("\n    deadlock loop:\n");
                bl = true;
            } else if (bl) {
                this.out.print("\n\n    deadlock branch(es):\n");
                bl = false;
            }
            this.out.print("\t  " + ((NodeList)object3).toString());
            this.out.print("\n");
        }
        this.out.print("\n");
    }

    private boolean isDeadlocked(MonitorNode monitorNode) {
        return 2 == monitorNode.deadlock || 3 == monitorNode.deadlock;
    }

    @Override
    public void printDetailedHelp(PrintStream printStream) {
        printStream.println("displays information about deadlocks if there are any\n\nparameters: none\n\nThe \"deadlock\" command shows detailed information about deadlocks or \"no deadlocks detected\" if there are no deadlocks.  A deadlock situation consists of one or more deadlock loops and zero or more branches attached to those loops.  This command prints out each branch attached to a loop and then the loop itself.  If there is a split in a deadlock branch, separate branches will be created for each side of the split in the branch.  Deadlock branches start with a monitor that has no threads waiting on it and the continues until it reaches a monitor that exists in another deadlock branch or loop.  Deadlock loops start and end with the same monitor.\n\nMonitors are represented by their owner and the object associated with the given monitor.  For example, \"3435 (0x45ae67)\" represents the monitor that is owned by the thread with id 3435 and is associated the object at address 0x45ae67.  Objects can be viewed by using a command like \"x/j 0x45ae67\" and threads can be viewed using a command like \"info thread 3435\".\n");
    }
}

