/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.I8;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.IScalar;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;

public class I16
extends IScalar {
    public static final int SIZEOF = 2;
    public static final long MASK = 65535L;
    public static final I16 MIN = new I16(32768L);
    public static final I16 MAX = new I16(32767L);

    public I16(long l) {
        super(l & 0xFFFFL);
    }

    public I16(Scalar scalar) {
        super(scalar);
    }

    public I16 add(int n) {
        return new I16(this.data + (long)n);
    }

    public I32 add(U8 u8) {
        return new I32(this).add(u8);
    }

    public boolean eq(U8 u8) {
        return new I32(this).eq(u8);
    }

    public I32 add(U16 u16) {
        return new I32(this).add(u16);
    }

    public boolean eq(U16 u16) {
        return new I32(this).eq(u16);
    }

    public U32 add(U32 u32) {
        return new U32(this).add(u32);
    }

    public boolean eq(U32 u32) {
        return new U32(this).eq(u32);
    }

    public U64 add(U64 u64) {
        return new U64(this).add(u64);
    }

    public boolean eq(U64 u64) {
        return new U64(this).eq(u64);
    }

    public UDATA add(UDATA uDATA) {
        return new UDATA(this).add(uDATA);
    }

    public boolean eq(UDATA uDATA) {
        return new UDATA(this).eq(uDATA);
    }

    public I32 add(I8 i8) {
        return new I32(this).add(i8);
    }

    public I16 add(I16 i16) {
        return new I16(this.data + i16.data);
    }

    public I32 add(I32 i32) {
        return new I32(this).add(i32);
    }

    public boolean eq(I32 i32) {
        return new I32(this).eq(i32);
    }

    public I64 add(I64 i64) {
        return new I64(this).add(i64);
    }

    public boolean eq(I64 i64) {
        return new I64(this).eq(i64);
    }

    public IDATA add(IDATA iDATA) {
        return new IDATA(this).add(iDATA);
    }

    public boolean eq(IDATA iDATA) {
        return new IDATA(this).eq(iDATA);
    }

    public I16 sub(int n) {
        return new I16(this.data - (long)n);
    }

    public I32 sub(U8 u8) {
        return new I32(this).sub(u8);
    }

    public I32 sub(U16 u16) {
        return new I32(this).sub(u16);
    }

    public U32 sub(U32 u32) {
        return new U32(this).sub(u32);
    }

    public U64 sub(U64 u64) {
        return new U64(this).sub(u64);
    }

    public UDATA sub(UDATA uDATA) {
        return new UDATA(this).sub(uDATA);
    }

    public I32 sub(I8 i8) {
        return new I32(this).sub(i8);
    }

    public I16 sub(I16 i16) {
        return new I16(this.data - i16.data);
    }

    public I32 sub(I32 i32) {
        return new I32(this).sub(i32);
    }

    public I64 sub(I64 i64) {
        return new I64(this).sub(i64);
    }

    public IDATA sub(IDATA iDATA) {
        return new IDATA(this).sub(iDATA);
    }

    @Override
    public long longValue() {
        return (short)this.data;
    }

    @Override
    public int intValue() {
        return (short)this.data;
    }

    public I16 bitOr(int n) {
        return new I16(this.data | (long)n);
    }

    public I16 bitOr(long l) {
        return new I16(this.data | l);
    }

    public I32 bitOr(U8 u8) {
        return new I32(this).bitOr(u8);
    }

    public I32 bitOr(U16 u16) {
        return new I32(this).bitOr(u16);
    }

    public U32 bitOr(U32 u32) {
        return new U32(this).bitOr(u32);
    }

    public U64 bitOr(U64 u64) {
        return new U64(this).bitOr(u64);
    }

    public UDATA bitOr(UDATA uDATA) {
        return new UDATA(this).bitOr(uDATA);
    }

    public I32 bitOr(I8 i8) {
        return new I32(this).bitOr(i8);
    }

    public I16 bitOr(I16 i16) {
        return new I16(this.data | i16.data);
    }

    public I32 bitOr(I32 i32) {
        return new I32(this).bitOr(i32);
    }

    public I64 bitOr(I64 i64) {
        return new I64(this).bitOr(i64);
    }

    public IDATA bitOr(IDATA iDATA) {
        return new IDATA(this).bitOr(iDATA);
    }

    public I16 bitAnd(int n) {
        return new I16(this.data & (long)n);
    }

    public I16 bitAnd(long l) {
        return new I16(this.data & l);
    }

    public I32 bitAnd(U8 u8) {
        return new I32(this).bitAnd(u8);
    }

    public I32 bitAnd(U16 u16) {
        return new I32(this).bitAnd(u16);
    }

    public U32 bitAnd(U32 u32) {
        return new U32(this).bitAnd(u32);
    }

    public U64 bitAnd(U64 u64) {
        return new U64(this).bitAnd(u64);
    }

    public UDATA bitAnd(UDATA uDATA) {
        return new UDATA(this).bitAnd(uDATA);
    }

    public I32 bitAnd(I8 i8) {
        return new I32(this).bitAnd(i8);
    }

    public I16 bitAnd(I16 i16) {
        return new I16(this.data & i16.data);
    }

    public I32 bitAnd(I32 i32) {
        return new I32(this).bitAnd(i32);
    }

    public I64 bitAnd(I64 i64) {
        return new I64(this).bitAnd(i64);
    }

    public IDATA bitAnd(IDATA iDATA) {
        return new IDATA(this).bitAnd(iDATA);
    }

    public I16 leftShift(int n) {
        return new I16(this.data << n);
    }

    public I16 rightShift(int n) {
        long l = this.data >>> n;
        if ((this.data & 0x8000L) != 0L) {
            l |= (long)(65535 << Math.max(0, 16 - n));
        }
        return new I16(l);
    }

    public I16 bitNot() {
        return new I16(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public I16 mult(int n) {
        return new I16(this.data * (long)n);
    }

    @Override
    public int sizeof() {
        return 2;
    }
}

