/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryRomClassCommand
extends Command {
    public QueryRomClassCommand() {
        this.addCommand("queryromclass", "<addr>,q1[,q2,...]", "query the specified J9ROMClass (equivalent to -drq in cfdump)\n" + String.format("%-25s %-20s \n", "    Query examples:", "<addr>,/romHeader,/romHeader/className,/methods,") + String.format("%-25s %-20s \n", "", "<addr>,/methods/method[0],/methods/method[3]/name,") + String.format("%-25s %-20s", "", "<addr>,/methods/method[3]/methodBytecodes"));
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        if (stringArray.length == 0) {
            this.printUsage(printStream);
            return;
        }
        try {
            String[] stringArray2 = stringArray[0].split(",");
            long l = CommandUtils.parsePointer(stringArray2[0], J9BuildFlags.env_data64);
            J9ROMClassPointer j9ROMClassPointer = J9ROMClassPointer.cast(l);
            stringArray2[0] = "";
            RomClassWalker romClassWalker = new RomClassWalker(j9ROMClassPointer, context);
            LinearDumper linearDumper = new LinearDumper();
            LinearDumper.J9ClassRegionNode j9ClassRegionNode = linearDumper.getAllRegions(romClassWalker);
            for (String string2 : stringArray2) {
                if (string2.length() == 0) continue;
                this.queryROMClass(printStream, j9ROMClassPointer, string2, j9ClassRegionNode);
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void printUsage(PrintStream printStream) {
        CommandUtils.dbgPrint(printStream, "Usage:" + nl);
        printStream.println("!queryromclass <addr>,q1[,q2,...] - query the specified J9ROMClass (equivalent to -drq in cfdump)");
        printStream.println("Query examples: <addr>,/romHeader,/romHeader/className,/methods,");
        printStream.println("\t<addr>,/methods/method[0],/methods/method[3]/name,");
        printStream.println("\t<addr>,/methods/method[3]/methodBytecodes");
    }

    private void queryROMClass(PrintStream printStream, J9ROMClassPointer j9ROMClassPointer, String string, LinearDumper.J9ClassRegionNode j9ClassRegionNode) throws CorruptDataException {
        String[] stringArray;
        for (String string2 : stringArray = string.split("/")) {
            int n;
            String string3;
            Object object;
            Object object2;
            if (string2.length() == 0) continue;
            if (string2.endsWith("]")) {
                object2 = Pattern.compile("^(.*)\\[(\\d*)\\]");
                object = ((Pattern)object2).matcher(string2);
                ((Matcher)object).find();
                string3 = ((Matcher)object).group(1).trim();
                n = Integer.parseInt(((Matcher)object).group(2).trim());
            } else {
                string3 = string2;
                n = 0;
            }
            object2 = j9ClassRegionNode.getChildren();
            if (object2.size() <= n) {
                printStream.println("Error: section not found or bad formatting");
                this.printUsage(printStream);
                return;
            }
            object = object2.iterator();
            while (object.hasNext()) {
                LinearDumper.J9ClassRegionNode j9ClassRegionNode2 = (LinearDumper.J9ClassRegionNode)object.next();
                if (j9ClassRegionNode2.getNodeValue() == null || !j9ClassRegionNode2.getNodeValue().getName().equals(string3) || n-- != 0) continue;
                j9ClassRegionNode = j9ClassRegionNode2;
            }
        }
        CommandUtils.dbgPrint(printStream, String.format("ROM Class '%s' at %s:\n\n", J9UTF8Helper.stringValue(j9ROMClassPointer.className()), j9ROMClassPointer.getHexAddress()));
        LinearDumper.printAllRegions(printStream, j9ROMClassPointer, 9L, j9ClassRegionNode, 0);
    }
}

