/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.SegmentsUtil;
import java.io.PrintStream;

public class DumpAllSegmentsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public DumpAllSegmentsCommand() {
        this.addCommand("dumpallsegments", "", "dump all segments in the VM");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            printStream.append(String.format("memorySegments - !j9memorysegmentlist 0x%s\n", Long.toHexString(j9JavaVMPointer.memorySegments().getAddress())));
            SegmentsUtil.dbgDumpSegmentList(printStream, j9JavaVMPointer.memorySegments());
            printStream.append(String.format("classMemorySegments - !j9memorysegmentlist 0x%s\n", Long.toHexString(j9JavaVMPointer.classMemorySegments().getAddress())));
            SegmentsUtil.dbgDumpSegmentList(printStream, j9JavaVMPointer.classMemorySegments());
            if (J9BuildFlags.interp_nativeSupport) {
                if (!j9JavaVMPointer.jitConfig().isNull()) {
                    printStream.append(String.format("jit code segments - !j9memorysegmentlist 0x%s\n", Long.toHexString(j9JavaVMPointer.jitConfig().codeCacheList().getAddress())));
                    SegmentsUtil.dbgDumpJITCodeSegmentList(printStream, j9JavaVMPointer.jitConfig().codeCacheList());
                    printStream.append(String.format("jit data segments - !j9memorysegmentlist 0x%s\n", Long.toHexString(j9JavaVMPointer.jitConfig().dataCacheList().getAddress())));
                    SegmentsUtil.dbgDumpSegmentList(printStream, j9JavaVMPointer.jitConfig().dataCacheList());
                } else {
                    printStream.append("JIT not enabled\n");
                }
            }
            printStream.append(nl);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }
}

